#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Action descriptor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Action {
    #[doc = "Specifies the action. Supported values - AlertingAction, LogToMetricAction"]
    #[serde(rename = "odata.type")]
    pub odata_type: String,
}
impl Action {
    pub fn new(odata_type: String) -> Self {
        Self { odata_type }
    }
}
#[doc = "Severity Level of Alert"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertSeverity {
    #[serde(rename = "0")]
    N0,
    #[serde(rename = "1")]
    N1,
    #[serde(rename = "2")]
    N2,
    #[serde(rename = "3")]
    N3,
    #[serde(rename = "4")]
    N4,
}
#[doc = "Specify action need to be taken when rule type is Alert"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertingAction {
    #[serde(flatten)]
    pub action: Action,
    #[doc = "Severity Level of Alert"]
    pub severity: AlertSeverity,
    #[doc = "Azure action group"]
    #[serde(rename = "aznsAction", default, skip_serializing_if = "Option::is_none")]
    pub azns_action: Option<AzNsActionGroup>,
    #[doc = "time (in minutes) for which Alerts should be throttled or suppressed."]
    #[serde(rename = "throttlingInMin", default, skip_serializing_if = "Option::is_none")]
    pub throttling_in_min: Option<i32>,
    #[doc = "The condition that results in the Log Search rule."]
    pub trigger: TriggerCondition,
}
impl AlertingAction {
    pub fn new(action: Action, severity: AlertSeverity, trigger: TriggerCondition) -> Self {
        Self {
            action,
            severity,
            azns_action: None,
            throttling_in_min: None,
            trigger,
        }
    }
}
#[doc = "Azure action group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzNsActionGroup {
    #[doc = "Azure Action Group reference."]
    #[serde(rename = "actionGroup", default, skip_serializing_if = "Vec::is_empty")]
    pub action_group: Vec<String>,
    #[doc = "Custom subject override for all email ids in Azure action group"]
    #[serde(rename = "emailSubject", default, skip_serializing_if = "Option::is_none")]
    pub email_subject: Option<String>,
    #[doc = "Custom payload to be sent for all webhook URI in Azure action group"]
    #[serde(rename = "customWebhookPayload", default, skip_serializing_if = "Option::is_none")]
    pub custom_webhook_payload: Option<String>,
}
impl AzNsActionGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result Condition Evaluation criteria."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConditionalOperator {
    GreaterThanOrEqual,
    LessThanOrEqual,
    GreaterThan,
    LessThan,
    Equal,
}
impl Default for ConditionalOperator {
    fn default() -> Self {
        Self::GreaterThanOrEqual
    }
}
#[doc = "Specifies the criteria for converting log to metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Criteria {
    #[doc = "Name of the metric"]
    #[serde(rename = "metricName")]
    pub metric_name: String,
    #[doc = "List of Dimensions for creating metric"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Dimension>,
}
impl Criteria {
    pub fn new(metric_name: String) -> Self {
        Self {
            metric_name,
            dimensions: Vec::new(),
        }
    }
}
#[doc = "Specifies the criteria for converting log to metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dimension {
    #[doc = "Name of the dimension"]
    pub name: String,
    #[doc = "Operator for dimension values"]
    pub operator: dimension::Operator,
    #[doc = "List of dimension values"]
    pub values: Vec<String>,
}
impl Dimension {
    pub fn new(name: String, operator: dimension::Operator, values: Vec<String>) -> Self {
        Self { name, operator, values }
    }
}
pub mod dimension {
    use super::*;
    #[doc = "Operator for dimension values"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Include,
    }
}
#[doc = "Describes the format of Error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorContract {
    #[doc = "Describes the format of Error response."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl ErrorContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the format of Error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "Error code"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message indicating why the operation failed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A log metrics trigger descriptor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogMetricTrigger {
    #[doc = "Result Condition Evaluation criteria."]
    #[serde(rename = "thresholdOperator", default, skip_serializing_if = "Option::is_none")]
    pub threshold_operator: Option<ConditionalOperator>,
    #[doc = "The threshold of the metric trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub threshold: Option<f64>,
    #[doc = "Metric Trigger Evaluation Type"]
    #[serde(rename = "metricTriggerType", default, skip_serializing_if = "Option::is_none")]
    pub metric_trigger_type: Option<MetricTriggerType>,
    #[doc = "Evaluation of metric on a particular column"]
    #[serde(rename = "metricColumn", default, skip_serializing_if = "Option::is_none")]
    pub metric_column: Option<String>,
}
impl LogMetricTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Log Search Rule Definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogSearchRule {
    #[doc = "The api-version used when creating this alert rule"]
    #[serde(rename = "createdWithApiVersion", default, skip_serializing_if = "Option::is_none")]
    pub created_with_api_version: Option<String>,
    #[doc = "True if alert rule is legacy Log Analytic rule"]
    #[serde(rename = "isLegacyLogAnalyticsRule", default, skip_serializing_if = "Option::is_none")]
    pub is_legacy_log_analytics_rule: Option<bool>,
    #[doc = "The description of the Log Search rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The display name of the alert rule"]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The flag that indicates whether the alert should be automatically resolved or not. The default is false."]
    #[serde(rename = "autoMitigate", default, skip_serializing_if = "Option::is_none")]
    pub auto_mitigate: Option<bool>,
    #[doc = "The flag which indicates whether the Log Search rule is enabled. Value should be true or false"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<log_search_rule::Enabled>,
    #[doc = "Last time the rule was updated in IS08601 format."]
    #[serde(rename = "lastUpdatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_time: Option<String>,
    #[doc = "Provisioning state of the scheduled query rule"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<log_search_rule::ProvisioningState>,
    #[doc = "Specifies the log search query."]
    pub source: Source,
    #[doc = "Defines how often to run the search and the time interval."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<Schedule>,
    #[doc = "Action descriptor."]
    pub action: Action,
}
impl LogSearchRule {
    pub fn new(source: Source, action: Action) -> Self {
        Self {
            created_with_api_version: None,
            is_legacy_log_analytics_rule: None,
            description: None,
            display_name: None,
            auto_mitigate: None,
            enabled: None,
            last_updated_time: None,
            provisioning_state: None,
            source,
            schedule: None,
            action,
        }
    }
}
pub mod log_search_rule {
    use super::*;
    #[doc = "The flag which indicates whether the Log Search rule is enabled. Value should be true or false"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Enabled {
        #[serde(rename = "true")]
        True,
        #[serde(rename = "false")]
        False,
    }
    #[doc = "Provisioning state of the scheduled query rule"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Deploying,
        Canceled,
        Failed,
    }
}
#[doc = "Log Search Rule Definition for Patching"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogSearchRulePatch {
    #[doc = "The flag which indicates whether the Log Search rule is enabled. Value should be true or false"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<log_search_rule_patch::Enabled>,
}
impl LogSearchRulePatch {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod log_search_rule_patch {
    use super::*;
    #[doc = "The flag which indicates whether the Log Search rule is enabled. Value should be true or false"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Enabled {
        #[serde(rename = "true")]
        True,
        #[serde(rename = "false")]
        False,
    }
}
#[doc = "The Log Search Rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogSearchRuleResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Log Search Rule Definition"]
    pub properties: LogSearchRule,
}
impl LogSearchRuleResource {
    pub fn new(resource: Resource, properties: LogSearchRule) -> Self {
        Self { resource, properties }
    }
}
#[doc = "Represents a collection of Log Search rule resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogSearchRuleResourceCollection {
    #[doc = "The values for the Log Search Rule resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LogSearchRuleResource>,
}
impl LogSearchRuleResourceCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The log search rule resource for patch operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogSearchRuleResourcePatch {
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Log Search Rule Definition for Patching"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LogSearchRulePatch>,
}
impl LogSearchRuleResourcePatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specify action need to be taken when rule type is converting log to metric"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogToMetricAction {
    #[serde(flatten)]
    pub action: Action,
    #[doc = "Criteria of Metric"]
    pub criteria: Vec<Criteria>,
}
impl LogToMetricAction {
    pub fn new(action: Action, criteria: Vec<Criteria>) -> Self {
        Self { action, criteria }
    }
}
#[doc = "Metric Trigger Evaluation Type"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum MetricTriggerType {
    Consecutive,
    Total,
}
impl Default for MetricTriggerType {
    fn default() -> Self {
        Self::Consecutive
    }
}
#[doc = "Set value to 'ResultAccount'"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum QueryType {
    ResultCount,
}
#[doc = "An azure resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "Azure resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Azure resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Azure resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields. "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
            kind: None,
            etag: None,
        }
    }
}
#[doc = "Defines how often to run the search and the time interval."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Schedule {
    #[doc = "frequency (in minutes) at which rule condition should be evaluated."]
    #[serde(rename = "frequencyInMinutes")]
    pub frequency_in_minutes: i32,
    #[doc = "Time window for which data needs to be fetched for query (should be greater than or equal to frequencyInMinutes)."]
    #[serde(rename = "timeWindowInMinutes")]
    pub time_window_in_minutes: i32,
}
impl Schedule {
    pub fn new(frequency_in_minutes: i32, time_window_in_minutes: i32) -> Self {
        Self {
            frequency_in_minutes,
            time_window_in_minutes,
        }
    }
}
#[doc = "Specifies the log search query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Source {
    #[doc = "Log search query. Required for action type - AlertingAction"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[doc = "List of  Resource referred into query"]
    #[serde(rename = "authorizedResources", default, skip_serializing_if = "Vec::is_empty")]
    pub authorized_resources: Vec<String>,
    #[doc = "The resource uri over which log search query is to be run."]
    #[serde(rename = "dataSourceId")]
    pub data_source_id: String,
    #[doc = "Set value to 'ResultAccount'"]
    #[serde(rename = "queryType", default, skip_serializing_if = "Option::is_none")]
    pub query_type: Option<QueryType>,
}
impl Source {
    pub fn new(data_source_id: String) -> Self {
        Self {
            query: None,
            authorized_resources: Vec::new(),
            data_source_id,
            query_type: None,
        }
    }
}
#[doc = "The condition that results in the Log Search rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerCondition {
    #[doc = "Result Condition Evaluation criteria."]
    #[serde(rename = "thresholdOperator")]
    pub threshold_operator: ConditionalOperator,
    #[doc = "Result or count threshold based on which rule should be triggered."]
    pub threshold: f64,
    #[doc = "A log metrics trigger descriptor."]
    #[serde(rename = "metricTrigger", default, skip_serializing_if = "Option::is_none")]
    pub metric_trigger: Option<LogMetricTrigger>,
}
impl TriggerCondition {
    pub fn new(threshold_operator: ConditionalOperator, threshold: f64) -> Self {
        Self {
            threshold_operator,
            threshold,
            metric_trigger: None,
        }
    }
}
