#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataSource {
    pub kind: data_source::Kind,
    pub configuration: DataSourceConfiguration,
    pub sinks: Vec<SinkConfiguration>,
}
impl DataSource {
    pub fn new(kind: data_source::Kind, configuration: DataSourceConfiguration, sinks: Vec<SinkConfiguration>) -> Self {
        Self {
            kind,
            configuration,
            sinks,
        }
    }
}
pub mod data_source {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        PerformanceCounter,
        #[serde(rename = "ETWProviders")]
        EtwProviders,
        WindowsEventLogs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataSourceConfiguration {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<EtwProviderConfiguration>,
    #[serde(rename = "perfCounters", default, skip_serializing_if = "Vec::is_empty")]
    pub perf_counters: Vec<PerformanceCounterConfiguration>,
    #[serde(rename = "eventLogs", default, skip_serializing_if = "Vec::is_empty")]
    pub event_logs: Vec<EventLogConfiguration>,
}
impl DataSourceConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EtwEventConfiguration {
    pub name: String,
    pub id: i64,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<String>,
}
impl EtwEventConfiguration {
    pub fn new(name: String, id: i64) -> Self {
        Self { name, id, filter: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EtwProviderConfiguration {
    pub id: String,
    pub events: Vec<EtwEventConfiguration>,
}
impl EtwProviderConfiguration {
    pub fn new(id: String, events: Vec<EtwEventConfiguration>) -> Self {
        Self { id, events }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventLogConfiguration {
    #[serde(rename = "logName")]
    pub log_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<String>,
}
impl EventLogConfiguration {
    pub fn new(log_name: String) -> Self {
        Self { log_name, filter: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettings {
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<guest_diagnostic_settings::OsType>,
    #[serde(rename = "dataSources", default, skip_serializing_if = "Vec::is_empty")]
    pub data_sources: Vec<DataSource>,
    #[serde(rename = "proxySetting", default, skip_serializing_if = "Option::is_none")]
    pub proxy_setting: Option<String>,
}
impl GuestDiagnosticSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod guest_diagnostic_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GuestDiagnosticSettingsAssociation {
    #[serde(rename = "guestDiagnosticSettingsName")]
    pub guest_diagnostic_settings_name: String,
}
impl GuestDiagnosticSettingsAssociation {
    pub fn new(guest_diagnostic_settings_name: String) -> Self {
        Self {
            guest_diagnostic_settings_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettingsAssociationList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GuestDiagnosticSettingsAssociationResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GuestDiagnosticSettingsAssociationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GuestDiagnosticSettingsAssociationResource {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: GuestDiagnosticSettingsAssociation,
}
impl GuestDiagnosticSettingsAssociationResource {
    pub fn new(resource: Resource, properties: GuestDiagnosticSettingsAssociation) -> Self {
        Self { resource, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettingsAssociationResourcePatch {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GuestDiagnosticSettingsAssociation>,
}
impl GuestDiagnosticSettingsAssociationResourcePatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettingsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GuestDiagnosticSettingsResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GuestDiagnosticSettingsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettingsPatchResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GuestDiagnosticSettings>,
}
impl GuestDiagnosticSettingsPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GuestDiagnosticSettingsResource {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: GuestDiagnosticSettings,
}
impl GuestDiagnosticSettingsResource {
    pub fn new(resource: Resource, properties: GuestDiagnosticSettings) -> Self {
        Self { resource, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PerformanceCounterConfiguration {
    pub name: String,
    #[serde(rename = "samplingPeriod")]
    pub sampling_period: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub instance: Option<String>,
}
impl PerformanceCounterConfiguration {
    pub fn new(name: String, sampling_period: String) -> Self {
        Self {
            name,
            sampling_period,
            instance: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SinkConfiguration {
    pub kind: sink_configuration::Kind,
}
impl SinkConfiguration {
    pub fn new(kind: sink_configuration::Kind) -> Self {
        Self { kind }
    }
}
pub mod sink_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        EventHub,
        ApplicationInsights,
        LogAnalytics,
    }
}
