#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "A disk assessed for an assessment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessedDisk {
    #[doc = "Name of the assessed disk."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "User friendly name of the assessed disk."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Gigabytes of storage provisioned for this disk."]
    #[serde(rename = "gigabytesProvisioned", default, skip_serializing_if = "Option::is_none")]
    pub gigabytes_provisioned: Option<f64>,
    #[doc = "Disk throughput in MegaBytes per second."]
    #[serde(rename = "megabytesPerSecondOfRead", default, skip_serializing_if = "Option::is_none")]
    pub megabytes_per_second_of_read: Option<f64>,
    #[doc = "Disk throughput in MegaBytes per second."]
    #[serde(rename = "megabytesPerSecondOfWrite", default, skip_serializing_if = "Option::is_none")]
    pub megabytes_per_second_of_write: Option<f64>,
    #[doc = "Number of read operations per second for the disk."]
    #[serde(rename = "numberOfReadOperationsPerSecond", default, skip_serializing_if = "Option::is_none")]
    pub number_of_read_operations_per_second: Option<f64>,
    #[doc = "Number of read and write operations per second for the disk."]
    #[serde(rename = "numberOfWriteOperationsPerSecond", default, skip_serializing_if = "Option::is_none")]
    pub number_of_write_operations_per_second: Option<f64>,
    #[doc = "Estimated aggregate storage cost for a 31-day month for this disk."]
    #[serde(rename = "monthlyStorageCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_storage_cost: Option<f64>,
    #[doc = "Storage type selected for this disk."]
    #[serde(rename = "recommendedDiskType", default, skip_serializing_if = "Option::is_none")]
    pub recommended_disk_type: Option<assessed_disk::RecommendedDiskType>,
    #[doc = "Recommended Azure size for the disk, given utilization data and preferences set on Assessment."]
    #[serde(rename = "recommendedDiskSize", default, skip_serializing_if = "Option::is_none")]
    pub recommended_disk_size: Option<assessed_disk::RecommendedDiskSize>,
    #[doc = "Gigabytes of storage provided by the recommended Azure disk size."]
    #[serde(rename = "gigabytesForRecommendedDiskSize", default, skip_serializing_if = "Option::is_none")]
    pub gigabytes_for_recommended_disk_size: Option<i32>,
    #[doc = "Whether this disk is suitable for Azure."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub suitability: Option<assessed_disk::Suitability>,
    #[doc = "If disk is not suitable to be migrated, this explains the reasons and mitigation steps."]
    #[serde(rename = "suitabilityExplanation", default, skip_serializing_if = "Option::is_none")]
    pub suitability_explanation: Option<assessed_disk::SuitabilityExplanation>,
    #[doc = "If disk is suitable to be migrate but some conditions/checks were not considered while calculating suitability, this explains the details."]
    #[serde(rename = "suitabilityDetail", default, skip_serializing_if = "Option::is_none")]
    pub suitability_detail: Option<assessed_disk::SuitabilityDetail>,
}
impl AssessedDisk {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod assessed_disk {
    use super::*;
    #[doc = "Storage type selected for this disk."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecommendedDiskType {
        Unknown,
        Standard,
        Premium,
        #[serde(rename = "StandardSSD")]
        StandardSsd,
        StandardOrPremium,
    }
    #[doc = "Recommended Azure size for the disk, given utilization data and preferences set on Assessment."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecommendedDiskSize {
        Unknown,
        #[serde(rename = "Standard_S4")]
        StandardS4,
        #[serde(rename = "Standard_S6")]
        StandardS6,
        #[serde(rename = "Standard_S10")]
        StandardS10,
        #[serde(rename = "Standard_S15")]
        StandardS15,
        #[serde(rename = "Standard_S20")]
        StandardS20,
        #[serde(rename = "Standard_S30")]
        StandardS30,
        #[serde(rename = "Standard_S40")]
        StandardS40,
        #[serde(rename = "Standard_S50")]
        StandardS50,
        #[serde(rename = "Premium_P4")]
        PremiumP4,
        #[serde(rename = "Premium_P6")]
        PremiumP6,
        #[serde(rename = "Premium_P10")]
        PremiumP10,
        #[serde(rename = "Premium_P15")]
        PremiumP15,
        #[serde(rename = "Premium_P20")]
        PremiumP20,
        #[serde(rename = "Premium_P30")]
        PremiumP30,
        #[serde(rename = "Premium_P40")]
        PremiumP40,
        #[serde(rename = "Premium_P50")]
        PremiumP50,
        #[serde(rename = "Standard_S60")]
        StandardS60,
        #[serde(rename = "Standard_S70")]
        StandardS70,
        #[serde(rename = "Standard_S80")]
        StandardS80,
        #[serde(rename = "Premium_P60")]
        PremiumP60,
        #[serde(rename = "Premium_P70")]
        PremiumP70,
        #[serde(rename = "Premium_P80")]
        PremiumP80,
        #[serde(rename = "StandardSSD_E10")]
        StandardSsdE10,
        #[serde(rename = "StandardSSD_E15")]
        StandardSsdE15,
        #[serde(rename = "StandardSSD_E20")]
        StandardSsdE20,
        #[serde(rename = "StandardSSD_E30")]
        StandardSsdE30,
        #[serde(rename = "StandardSSD_E40")]
        StandardSsdE40,
        #[serde(rename = "StandardSSD_E50")]
        StandardSsdE50,
        #[serde(rename = "StandardSSD_E60")]
        StandardSsdE60,
        #[serde(rename = "StandardSSD_E70")]
        StandardSsdE70,
        #[serde(rename = "StandardSSD_E80")]
        StandardSsdE80,
        #[serde(rename = "StandardSSD_E4")]
        StandardSsdE4,
        #[serde(rename = "StandardSSD_E6")]
        StandardSsdE6,
    }
    #[doc = "Whether this disk is suitable for Azure."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Suitability {
        Unknown,
        NotSuitable,
        Suitable,
        ConditionallySuitable,
        ReadinessUnknown,
    }
    #[doc = "If disk is not suitable to be migrated, this explains the reasons and mitigation steps."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SuitabilityExplanation {
        Unknown,
        NotApplicable,
        DiskSizeGreaterThanSupported,
        NoSuitableDiskSizeForIops,
        NoSuitableDiskSizeForThroughput,
        NoDiskSizeFoundInSelectedLocation,
        NoDiskSizeFoundForSelectedRedundancy,
        InternalErrorOccurredForDiskEvaluation,
        NoEaPriceFoundForDiskSize,
    }
    #[doc = "If disk is suitable to be migrate but some conditions/checks were not considered while calculating suitability, this explains the details."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SuitabilityDetail {
        None,
        NumberOfReadOperationsPerSecondMissing,
        NumberOfWriteOperationsPerSecondMissing,
        MegabytesPerSecondOfReadMissing,
        MegabytesPerSecondOfWriteMissing,
        DiskGigabytesConsumedMissing,
        DiskGigabytesProvisionedMissing,
        NumberOfReadOperationsPerSecondOutOfRange,
        NumberOfWriteOperationsPerSecondOutOfRange,
        MegabytesPerSecondOfReadOutOfRange,
        MegabytesPerSecondOfWriteOutOfRange,
        DiskGigabytesConsumedOutOfRange,
        DiskGigabytesProvisionedOutOfRange,
    }
}
#[doc = "A machine evaluated as part of an assessment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessedMachine {
    #[doc = "Path reference to this assessed machine. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessments/{assessmentName}/assessedMachines/{assessedMachineName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Name of the machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "For optimistic concurrency control."]
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[doc = "Type of the object = [Microsoft.Migrate/assessmentProjects/groups/assessments/assessedMachines]."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Properties of an assessed machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AssessedMachineProperties>,
}
impl AssessedMachine {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an assessed machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessedMachineProperties {
    #[doc = "Boot type of the machine."]
    #[serde(rename = "bootType", default, skip_serializing_if = "Option::is_none")]
    pub boot_type: Option<assessed_machine_properties::BootType>,
    #[doc = "ARM ID of the discovered machine."]
    #[serde(rename = "datacenterMachineArmId", default, skip_serializing_if = "Option::is_none")]
    pub datacenter_machine_arm_id: Option<String>,
    #[doc = "ARM ID of the discovered datacenter."]
    #[serde(rename = "datacenterManagementServerArmId", default, skip_serializing_if = "Option::is_none")]
    pub datacenter_management_server_arm_id: Option<String>,
    #[doc = "Name of the server hosting the datacenter management solution."]
    #[serde(rename = "datacenterManagementServerName", default, skip_serializing_if = "Option::is_none")]
    pub datacenter_management_server_name: Option<String>,
    #[doc = "Description of the machine"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "User readable name of the machine as defined by the user in their private datacenter."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Memory in Megabytes."]
    #[serde(rename = "megabytesOfMemory", default, skip_serializing_if = "Option::is_none")]
    pub megabytes_of_memory: Option<f64>,
    #[doc = "Processor count."]
    #[serde(rename = "numberOfCores", default, skip_serializing_if = "Option::is_none")]
    pub number_of_cores: Option<i32>,
    #[doc = "Operating System type of the machine."]
    #[serde(rename = "operatingSystemType", default, skip_serializing_if = "Option::is_none")]
    pub operating_system_type: Option<String>,
    #[doc = "Operating System name of the machine."]
    #[serde(rename = "operatingSystemName", default, skip_serializing_if = "Option::is_none")]
    pub operating_system_name: Option<String>,
    #[doc = "Operating System version of the machine."]
    #[serde(rename = "operatingSystemVersion", default, skip_serializing_if = "Option::is_none")]
    pub operating_system_version: Option<String>,
    #[doc = "Monthly network cost estimate for the network adapters that are attached to this machine as a group, for a 31-day month."]
    #[serde(rename = "monthlyBandwidthCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_bandwidth_cost: Option<f64>,
    #[doc = "Monthly storage cost estimate for the disks that are attached to this machine as a group, for a 31-day month."]
    #[serde(rename = "monthlyStorageCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_storage_cost: Option<f64>,
    #[doc = "Monthly premium storage cost estimate for the disks that are attached to this machine as a group, for a 31-day month."]
    #[serde(rename = "monthlyPremiumStorageCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_premium_storage_cost: Option<f64>,
    #[doc = "Monthly standard SSD storage cost estimate for the disks that are attached to this machine as a group, for a 31-day month."]
    #[serde(rename = "monthlyStandardSSDStorageCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_standard_ssd_storage_cost: Option<f64>,
    #[doc = "Confidence rating of assessed machine."]
    #[serde(rename = "confidenceRatingInPercentage", default, skip_serializing_if = "Option::is_none")]
    pub confidence_rating_in_percentage: Option<f64>,
    #[doc = "Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disks: Option<serde_json::Value>,
    #[doc = "Dictionary of network adapters attached to the machine. Key is name of the adapter. Value is a network adapter object."]
    #[serde(rename = "networkAdapters", default, skip_serializing_if = "Option::is_none")]
    pub network_adapters: Option<serde_json::Value>,
    #[doc = "Recommended Azure size for this machine."]
    #[serde(rename = "recommendedSize", default, skip_serializing_if = "Option::is_none")]
    pub recommended_size: Option<assessed_machine_properties::RecommendedSize>,
    #[doc = "Number of CPU cores in the Recommended Azure VM Size."]
    #[serde(rename = "numberOfCoresForRecommendedSize", default, skip_serializing_if = "Option::is_none")]
    pub number_of_cores_for_recommended_size: Option<i32>,
    #[doc = "Megabytes of memory in the Recommended Azure VM Size."]
    #[serde(rename = "megabytesOfMemoryForRecommendedSize", default, skip_serializing_if = "Option::is_none")]
    pub megabytes_of_memory_for_recommended_size: Option<f64>,
    #[doc = "Compute Cost for a 31-day month, if the machine is migrated to Azure with the Recommended Size."]
    #[serde(rename = "monthlyComputeCostForRecommendedSize", default, skip_serializing_if = "Option::is_none")]
    pub monthly_compute_cost_for_recommended_size: Option<f64>,
    #[doc = "Utilization percentage of the processor core as observed in the private data center, in the Time Range selected on Assessment, reported as the Percentile value based on the percentile number selected in assessment."]
    #[serde(rename = "percentageCoresUtilization", default, skip_serializing_if = "Option::is_none")]
    pub percentage_cores_utilization: Option<f64>,
    #[doc = "Utilization percentage of the memory as observed in the private data center, in the Time Range selected on Assessment, reported as the Percentile value based on the percentile number selected in assessment."]
    #[serde(rename = "percentageMemoryUtilization", default, skip_serializing_if = "Option::is_none")]
    pub percentage_memory_utilization: Option<f64>,
    #[doc = "Whether machine is suitable for migration to Azure."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub suitability: Option<assessed_machine_properties::Suitability>,
    #[doc = "If machine is not ready to be migrated, this explains the reasons and mitigation steps."]
    #[serde(rename = "suitabilityExplanation", default, skip_serializing_if = "Option::is_none")]
    pub suitability_explanation: Option<assessed_machine_properties::SuitabilityExplanation>,
    #[doc = "If machine is not suitable for cloud, this explains the reasons."]
    #[serde(rename = "suitabilityDetail", default, skip_serializing_if = "Option::is_none")]
    pub suitability_detail: Option<assessed_machine_properties::SuitabilityDetail>,
    #[doc = "Time when this machine was created. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "createdTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<String>,
    #[doc = "Time when this machine was last updated. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "updatedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<String>,
}
impl AssessedMachineProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod assessed_machine_properties {
    use super::*;
    #[doc = "Boot type of the machine."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BootType {
        Unknown,
        #[serde(rename = "EFI")]
        Efi,
        #[serde(rename = "BIOS")]
        Bios,
    }
    #[doc = "Recommended Azure size for this machine."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecommendedSize {
        Unknown,
        #[serde(rename = "Basic_A0")]
        BasicA0,
        #[serde(rename = "Basic_A1")]
        BasicA1,
        #[serde(rename = "Basic_A2")]
        BasicA2,
        #[serde(rename = "Basic_A3")]
        BasicA3,
        #[serde(rename = "Basic_A4")]
        BasicA4,
        #[serde(rename = "Standard_A0")]
        StandardA0,
        #[serde(rename = "Standard_A1")]
        StandardA1,
        #[serde(rename = "Standard_A2")]
        StandardA2,
        #[serde(rename = "Standard_A3")]
        StandardA3,
        #[serde(rename = "Standard_A4")]
        StandardA4,
        #[serde(rename = "Standard_A5")]
        StandardA5,
        #[serde(rename = "Standard_A6")]
        StandardA6,
        #[serde(rename = "Standard_A7")]
        StandardA7,
        #[serde(rename = "Standard_A8")]
        StandardA8,
        #[serde(rename = "Standard_A9")]
        StandardA9,
        #[serde(rename = "Standard_A10")]
        StandardA10,
        #[serde(rename = "Standard_A11")]
        StandardA11,
        #[serde(rename = "Standard_A1_v2")]
        StandardA1V2,
        #[serde(rename = "Standard_A2_v2")]
        StandardA2V2,
        #[serde(rename = "Standard_A4_v2")]
        StandardA4V2,
        #[serde(rename = "Standard_A8_v2")]
        StandardA8V2,
        #[serde(rename = "Standard_A2m_v2")]
        StandardA2mV2,
        #[serde(rename = "Standard_A4m_v2")]
        StandardA4mV2,
        #[serde(rename = "Standard_A8m_v2")]
        StandardA8mV2,
        #[serde(rename = "Standard_D1")]
        StandardD1,
        #[serde(rename = "Standard_D2")]
        StandardD2,
        #[serde(rename = "Standard_D3")]
        StandardD3,
        #[serde(rename = "Standard_D4")]
        StandardD4,
        #[serde(rename = "Standard_D11")]
        StandardD11,
        #[serde(rename = "Standard_D12")]
        StandardD12,
        #[serde(rename = "Standard_D13")]
        StandardD13,
        #[serde(rename = "Standard_D14")]
        StandardD14,
        #[serde(rename = "Standard_D1_v2")]
        StandardD1V2,
        #[serde(rename = "Standard_D2_v2")]
        StandardD2V2,
        #[serde(rename = "Standard_D3_v2")]
        StandardD3V2,
        #[serde(rename = "Standard_D4_v2")]
        StandardD4V2,
        #[serde(rename = "Standard_D5_v2")]
        StandardD5V2,
        #[serde(rename = "Standard_D11_v2")]
        StandardD11V2,
        #[serde(rename = "Standard_D12_v2")]
        StandardD12V2,
        #[serde(rename = "Standard_D13_v2")]
        StandardD13V2,
        #[serde(rename = "Standard_D14_v2")]
        StandardD14V2,
        #[serde(rename = "Standard_D15_v2")]
        StandardD15V2,
        #[serde(rename = "Standard_DS1")]
        StandardDs1,
        #[serde(rename = "Standard_DS2")]
        StandardDs2,
        #[serde(rename = "Standard_DS3")]
        StandardDs3,
        #[serde(rename = "Standard_DS4")]
        StandardDs4,
        #[serde(rename = "Standard_DS11")]
        StandardDs11,
        #[serde(rename = "Standard_DS12")]
        StandardDs12,
        #[serde(rename = "Standard_DS13")]
        StandardDs13,
        #[serde(rename = "Standard_DS14")]
        StandardDs14,
        #[serde(rename = "Standard_DS1_v2")]
        StandardDs1V2,
        #[serde(rename = "Standard_DS2_v2")]
        StandardDs2V2,
        #[serde(rename = "Standard_DS3_v2")]
        StandardDs3V2,
        #[serde(rename = "Standard_DS4_v2")]
        StandardDs4V2,
        #[serde(rename = "Standard_DS5_v2")]
        StandardDs5V2,
        #[serde(rename = "Standard_DS11_v2")]
        StandardDs11V2,
        #[serde(rename = "Standard_DS12_v2")]
        StandardDs12V2,
        #[serde(rename = "Standard_DS13_v2")]
        StandardDs13V2,
        #[serde(rename = "Standard_DS14_v2")]
        StandardDs14V2,
        #[serde(rename = "Standard_DS15_v2")]
        StandardDs15V2,
        #[serde(rename = "Standard_F1")]
        StandardF1,
        #[serde(rename = "Standard_F2")]
        StandardF2,
        #[serde(rename = "Standard_F4")]
        StandardF4,
        #[serde(rename = "Standard_F8")]
        StandardF8,
        #[serde(rename = "Standard_F16")]
        StandardF16,
        #[serde(rename = "Standard_F1s")]
        StandardF1s,
        #[serde(rename = "Standard_F2s")]
        StandardF2s,
        #[serde(rename = "Standard_F4s")]
        StandardF4s,
        #[serde(rename = "Standard_F8s")]
        StandardF8s,
        #[serde(rename = "Standard_F16s")]
        StandardF16s,
        #[serde(rename = "Standard_G1")]
        StandardG1,
        #[serde(rename = "Standard_G2")]
        StandardG2,
        #[serde(rename = "Standard_G3")]
        StandardG3,
        #[serde(rename = "Standard_G4")]
        StandardG4,
        #[serde(rename = "Standard_G5")]
        StandardG5,
        #[serde(rename = "Standard_GS1")]
        StandardGs1,
        #[serde(rename = "Standard_GS2")]
        StandardGs2,
        #[serde(rename = "Standard_GS3")]
        StandardGs3,
        #[serde(rename = "Standard_GS4")]
        StandardGs4,
        #[serde(rename = "Standard_GS5")]
        StandardGs5,
        #[serde(rename = "Standard_H8")]
        StandardH8,
        #[serde(rename = "Standard_H16")]
        StandardH16,
        #[serde(rename = "Standard_H8m")]
        StandardH8m,
        #[serde(rename = "Standard_H16m")]
        StandardH16m,
        #[serde(rename = "Standard_H16r")]
        StandardH16r,
        #[serde(rename = "Standard_H16mr")]
        StandardH16mr,
        #[serde(rename = "Standard_L4s")]
        StandardL4s,
        #[serde(rename = "Standard_L8s")]
        StandardL8s,
        #[serde(rename = "Standard_L16s")]
        StandardL16s,
        #[serde(rename = "Standard_L32s")]
        StandardL32s,
        #[serde(rename = "Standard_D2s_v3")]
        StandardD2sV3,
        #[serde(rename = "Standard_D4s_v3")]
        StandardD4sV3,
        #[serde(rename = "Standard_D8s_v3")]
        StandardD8sV3,
        #[serde(rename = "Standard_D16s_v3")]
        StandardD16sV3,
        #[serde(rename = "Standard_D32s_v3")]
        StandardD32sV3,
        #[serde(rename = "Standard_D64s_v3")]
        StandardD64sV3,
        #[serde(rename = "Standard_D2_v3")]
        StandardD2V3,
        #[serde(rename = "Standard_D4_v3")]
        StandardD4V3,
        #[serde(rename = "Standard_D8_v3")]
        StandardD8V3,
        #[serde(rename = "Standard_D16_v3")]
        StandardD16V3,
        #[serde(rename = "Standard_D32_v3")]
        StandardD32V3,
        #[serde(rename = "Standard_D64_v3")]
        StandardD64V3,
        #[serde(rename = "Standard_F2s_v2")]
        StandardF2sV2,
        #[serde(rename = "Standard_F4s_v2")]
        StandardF4sV2,
        #[serde(rename = "Standard_F8s_v2")]
        StandardF8sV2,
        #[serde(rename = "Standard_F16s_v2")]
        StandardF16sV2,
        #[serde(rename = "Standard_F32s_v2")]
        StandardF32sV2,
        #[serde(rename = "Standard_F64s_v2")]
        StandardF64sV2,
        #[serde(rename = "Standard_F72s_v2")]
        StandardF72sV2,
        #[serde(rename = "Standard_E2_v3")]
        StandardE2V3,
        #[serde(rename = "Standard_E4_v3")]
        StandardE4V3,
        #[serde(rename = "Standard_E8_v3")]
        StandardE8V3,
        #[serde(rename = "Standard_E16_v3")]
        StandardE16V3,
        #[serde(rename = "Standard_E32_v3")]
        StandardE32V3,
        #[serde(rename = "Standard_E64_v3")]
        StandardE64V3,
        #[serde(rename = "Standard_E2s_v3")]
        StandardE2sV3,
        #[serde(rename = "Standard_E4s_v3")]
        StandardE4sV3,
        #[serde(rename = "Standard_E8s_v3")]
        StandardE8sV3,
        #[serde(rename = "Standard_E16s_v3")]
        StandardE16sV3,
        #[serde(rename = "Standard_E32s_v3")]
        StandardE32sV3,
        #[serde(rename = "Standard_E64s_v3")]
        StandardE64sV3,
        #[serde(rename = "Standard_M64s")]
        StandardM64s,
        #[serde(rename = "Standard_M64ms")]
        StandardM64ms,
        #[serde(rename = "Standard_M128s")]
        StandardM128s,
        #[serde(rename = "Standard_M128ms")]
        StandardM128ms,
    }
    #[doc = "Whether machine is suitable for migration to Azure."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Suitability {
        Unknown,
        NotSuitable,
        Suitable,
        ConditionallySuitable,
        ReadinessUnknown,
    }
    #[doc = "If machine is not ready to be migrated, this explains the reasons and mitigation steps."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SuitabilityExplanation {
        Unknown,
        NotApplicable,
        GuestOperatingSystemArchitectureNotSupported,
        GuestOperatingSystemNotSupported,
        BootTypeNotSupported,
        MoreDisksThanSupported,
        NoSuitableVmSizeFound,
        OneOrMoreDisksNotSuitable,
        OneOrMoreAdaptersNotSuitable,
        InternalErrorOccurredDuringComputeEvaluation,
        InternalErrorOccurredDuringStorageEvaluation,
        InternalErrorOccurredDuringNetworkEvaluation,
        NoVmSizeSupportsStoragePerformance,
        NoVmSizeSupportsNetworkPerformance,
        NoVmSizeForSelectedPricingTier,
        NoVmSizeForSelectedAzureLocation,
        CheckRedHatLinuxVersion,
        CheckOpenSuseLinuxVersion,
        CheckWindowsServer2008R2Version,
        CheckCentOsVersion,
        CheckDebianLinuxVersion,
        CheckSuseLinuxVersion,
        CheckOracleLinuxVersion,
        CheckUbuntuLinuxVersion,
        CheckCoreOsLinuxVersion,
        WindowsServerVersionConditionallySupported,
        NoGuestOperatingSystemConditionallySupported,
        WindowsClientVersionsConditionallySupported,
        BootTypeUnknown,
        GuestOperatingSystemUnknown,
        WindowsServerVersionsSupportedWithCaveat,
        #[serde(rename = "WindowsOSNoLongerUnderMSSupport")]
        WindowsOsNoLongerUnderMsSupport,
        EndorsedWithConditionsLinuxDistributions,
        UnendorsedLinuxDistributions,
        NoVmSizeForStandardPricingTier,
        NoVmSizeForBasicPricingTier,
    }
    #[doc = "If machine is not suitable for cloud, this explains the reasons."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SuitabilityDetail {
        None,
        RecommendedSizeHasLessNetworkAdapters,
        CannotReportComputeCost,
        CannotReportStorageCost,
        CannotReportBandwidthCosts,
        PercentageOfCoresUtilizedMissing,
        PercentageOfMemoryUtilizedMissing,
        PercentageOfCoresUtilizedOutOfRange,
        PercentageOfMemoryUtilizedOutOfRange,
    }
}
#[doc = "List of assessed machines."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessedMachineResultList {
    #[doc = "List of assessed machines."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AssessedMachine>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AssessedMachineResultList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A network adapter assessed for an assessment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessedNetworkAdapter {
    #[doc = "MAC Address of the network adapter."]
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[doc = "List of IP Addresses on the network adapter."]
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
    #[doc = "User friendly name of the assessed network adapter."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Monthly cost estimate for network bandwidth used by this network adapter."]
    #[serde(rename = "monthlyBandwidthCosts", default, skip_serializing_if = "Option::is_none")]
    pub monthly_bandwidth_costs: Option<f64>,
    #[doc = "Adapter throughput for incoming traffic in MegaBytes per second."]
    #[serde(rename = "megabytesPerSecondReceived", default, skip_serializing_if = "Option::is_none")]
    pub megabytes_per_second_received: Option<f64>,
    #[doc = "Adapter throughput for outgoing traffic in MegaBytes per second."]
    #[serde(rename = "megabytesPerSecondTransmitted", default, skip_serializing_if = "Option::is_none")]
    pub megabytes_per_second_transmitted: Option<f64>,
    #[doc = "Gigabytes transmitted through this adapter each month."]
    #[serde(rename = "netGigabytesTransmittedPerMonth", default, skip_serializing_if = "Option::is_none")]
    pub net_gigabytes_transmitted_per_month: Option<f64>,
    #[doc = "Whether this adapter is suitable for Azure."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub suitability: Option<assessed_network_adapter::Suitability>,
    #[doc = "If network adapter is suitable, this explains the reasons and mitigation steps."]
    #[serde(rename = "suitabilityExplanation", default, skip_serializing_if = "Option::is_none")]
    pub suitability_explanation: Option<assessed_network_adapter::SuitabilityExplanation>,
    #[doc = "If network adapter is not suitable for cloud, this explains the reasons."]
    #[serde(rename = "suitabilityDetail", default, skip_serializing_if = "Option::is_none")]
    pub suitability_detail: Option<assessed_network_adapter::SuitabilityDetail>,
}
impl AssessedNetworkAdapter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod assessed_network_adapter {
    use super::*;
    #[doc = "Whether this adapter is suitable for Azure."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Suitability {
        Unknown,
        NotSuitable,
        Suitable,
        ConditionallySuitable,
        ReadinessUnknown,
    }
    #[doc = "If network adapter is suitable, this explains the reasons and mitigation steps."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SuitabilityExplanation {
        Unknown,
        NotApplicable,
        InternalErrorOccurred,
    }
    #[doc = "If network adapter is not suitable for cloud, this explains the reasons."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SuitabilityDetail {
        None,
        MegabytesOfDataTransmittedMissing,
        MegabytesOfDataTransmittedOutOfRange,
    }
}
#[doc = "An assessment created for a group in the Migration project."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Assessment {
    #[doc = "Path reference to this assessment. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessment/{assessmentName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Unique name of an assessment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "For optimistic concurrency control."]
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[doc = "Type of the object = [Microsoft.Migrate/assessmentProjects/groups/assessments]."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Properties of an assessment."]
    pub properties: AssessmentProperties,
}
impl Assessment {
    pub fn new(properties: AssessmentProperties) -> Self {
        Self {
            id: None,
            name: None,
            e_tag: None,
            type_: None,
            properties,
        }
    }
}
#[doc = "Assessment options."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssessmentOptions {
    #[doc = "Unique name of an assessment options."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Unique identifier of an assessment options."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Assessment options properties."]
    pub properties: AssessmentOptionsProperties,
}
impl AssessmentOptions {
    pub fn new(properties: AssessmentOptionsProperties) -> Self {
        Self {
            name: None,
            id: None,
            properties,
        }
    }
}
#[doc = "Assessment options properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessmentOptionsProperties {
    #[doc = "Dictionary of VM families grouped by vm family name describing the targeted azure locations of VM family and the category of the family."]
    #[serde(rename = "vmFamilies", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_families: Vec<VmFamily>,
    #[doc = "List of supported VM Families."]
    #[serde(rename = "reservedInstanceVmFamilies", default, skip_serializing_if = "Vec::is_empty")]
    pub reserved_instance_vm_families: Vec<String>,
    #[doc = "List of supported Azure regions for reserved instances."]
    #[serde(rename = "reservedInstanceSupportedLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub reserved_instance_supported_locations: Vec<String>,
    #[doc = "List of supported currencies for reserved instances."]
    #[serde(rename = "reservedInstanceSupportedCurrencies", default, skip_serializing_if = "Vec::is_empty")]
    pub reserved_instance_supported_currencies: Vec<String>,
    #[doc = "List of supported Azure offer codes for reserved instances."]
    #[serde(rename = "reservedInstanceSupportedOffers", default, skip_serializing_if = "Vec::is_empty")]
    pub reserved_instance_supported_offers: Vec<String>,
}
impl AssessmentOptionsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of API operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessmentOptionsResultList {
    #[doc = "List of operations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AssessmentOptions>,
}
impl AssessmentOptionsResultList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an assessment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssessmentProperties {
    #[doc = "Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API."]
    #[serde(rename = "azureLocation")]
    pub azure_location: assessment_properties::AzureLocation,
    #[doc = "Offer code according to which cost estimation is done."]
    #[serde(rename = "azureOfferCode")]
    pub azure_offer_code: assessment_properties::AzureOfferCode,
    #[doc = "Enterprise agreement subscription arm id."]
    #[serde(rename = "eaSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub ea_subscription_id: Option<String>,
    #[doc = "Pricing tier for Size evaluation."]
    #[serde(rename = "azurePricingTier")]
    pub azure_pricing_tier: assessment_properties::AzurePricingTier,
    #[doc = "Storage Redundancy type offered by Azure."]
    #[serde(rename = "azureStorageRedundancy")]
    pub azure_storage_redundancy: assessment_properties::AzureStorageRedundancy,
    #[doc = "Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3."]
    #[serde(rename = "scalingFactor")]
    pub scaling_factor: f64,
    #[doc = "Percentile of performance data used to recommend Azure size."]
    pub percentile: assessment_properties::Percentile,
    #[doc = "Time range of performance data used to recommend a size."]
    #[serde(rename = "timeRange")]
    pub time_range: assessment_properties::TimeRange,
    #[doc = "Start time to consider performance data for assessment"]
    #[serde(rename = "perfDataStartTime", default, skip_serializing_if = "Option::is_none")]
    pub perf_data_start_time: Option<String>,
    #[doc = "End time to consider performance data for assessment"]
    #[serde(rename = "perfDataEndTime", default, skip_serializing_if = "Option::is_none")]
    pub perf_data_end_time: Option<String>,
    #[doc = "User configurable setting that describes the status of the assessment."]
    pub stage: assessment_properties::Stage,
    #[doc = "Currency to report prices in."]
    pub currency: assessment_properties::Currency,
    #[doc = "AHUB discount on windows virtual machines."]
    #[serde(rename = "azureHybridUseBenefit")]
    pub azure_hybrid_use_benefit: assessment_properties::AzureHybridUseBenefit,
    #[doc = "Custom discount percentage to be applied on final costs. Can be in the range [0, 100]."]
    #[serde(rename = "discountPercentage")]
    pub discount_percentage: f64,
    #[doc = "Confidence rating percentage for assessment. Can be in the range [0, 100]."]
    #[serde(rename = "confidenceRatingInPercentage", default, skip_serializing_if = "Option::is_none")]
    pub confidence_rating_in_percentage: Option<f64>,
    #[doc = "Assessment sizing criterion."]
    #[serde(rename = "sizingCriterion")]
    pub sizing_criterion: assessment_properties::SizingCriterion,
    #[doc = "Azure reserved instance."]
    #[serde(rename = "reservedInstance")]
    pub reserved_instance: assessment_properties::ReservedInstance,
    #[doc = "List of azure VM families."]
    #[serde(rename = "azureVmFamilies")]
    pub azure_vm_families: Vec<String>,
    #[doc = "Storage type selected for this disk."]
    #[serde(rename = "azureDiskType")]
    pub azure_disk_type: assessment_properties::AzureDiskType,
    #[serde(rename = "vmUptime")]
    pub vm_uptime: VmUptime,
    #[doc = "Time when the Azure Prices were queried. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "pricesTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub prices_timestamp: Option<String>,
    #[doc = "Time when this project was created. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "createdTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<String>,
    #[doc = "Time when this project was last updated. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "updatedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<String>,
    #[doc = "Monthly compute cost estimate for the machines that are part of this assessment as a group, for a 31-day month."]
    #[serde(rename = "monthlyComputeCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_compute_cost: Option<f64>,
    #[doc = "Monthly network cost estimate for the machines that are part of this assessment as a group, for a 31-day month."]
    #[serde(rename = "monthlyBandwidthCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_bandwidth_cost: Option<f64>,
    #[doc = "Monthly storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month."]
    #[serde(rename = "monthlyStorageCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_storage_cost: Option<f64>,
    #[doc = "Monthly premium storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month."]
    #[serde(rename = "monthlyPremiumStorageCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_premium_storage_cost: Option<f64>,
    #[doc = "Monthly standard SSD storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month."]
    #[serde(rename = "monthlyStandardSSDStorageCost", default, skip_serializing_if = "Option::is_none")]
    pub monthly_standard_ssd_storage_cost: Option<f64>,
    #[doc = "Whether the assessment has been created and is valid."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<assessment_properties::Status>,
    #[doc = "Number of assessed machines part of this assessment."]
    #[serde(rename = "numberOfMachines", default, skip_serializing_if = "Option::is_none")]
    pub number_of_machines: Option<i32>,
}
impl AssessmentProperties {
    pub fn new(
        azure_location: assessment_properties::AzureLocation,
        azure_offer_code: assessment_properties::AzureOfferCode,
        azure_pricing_tier: assessment_properties::AzurePricingTier,
        azure_storage_redundancy: assessment_properties::AzureStorageRedundancy,
        scaling_factor: f64,
        percentile: assessment_properties::Percentile,
        time_range: assessment_properties::TimeRange,
        stage: assessment_properties::Stage,
        currency: assessment_properties::Currency,
        azure_hybrid_use_benefit: assessment_properties::AzureHybridUseBenefit,
        discount_percentage: f64,
        sizing_criterion: assessment_properties::SizingCriterion,
        reserved_instance: assessment_properties::ReservedInstance,
        azure_vm_families: Vec<String>,
        azure_disk_type: assessment_properties::AzureDiskType,
        vm_uptime: VmUptime,
    ) -> Self {
        Self {
            azure_location,
            azure_offer_code,
            ea_subscription_id: None,
            azure_pricing_tier,
            azure_storage_redundancy,
            scaling_factor,
            percentile,
            time_range,
            perf_data_start_time: None,
            perf_data_end_time: None,
            stage,
            currency,
            azure_hybrid_use_benefit,
            discount_percentage,
            confidence_rating_in_percentage: None,
            sizing_criterion,
            reserved_instance,
            azure_vm_families,
            azure_disk_type,
            vm_uptime,
            prices_timestamp: None,
            created_timestamp: None,
            updated_timestamp: None,
            monthly_compute_cost: None,
            monthly_bandwidth_cost: None,
            monthly_storage_cost: None,
            monthly_premium_storage_cost: None,
            monthly_standard_ssd_storage_cost: None,
            status: None,
            number_of_machines: None,
        }
    }
}
pub mod assessment_properties {
    use super::*;
    #[doc = "Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureLocation {
        Unknown,
        EastAsia,
        SoutheastAsia,
        AustraliaEast,
        AustraliaSoutheast,
        BrazilSouth,
        CanadaCentral,
        CanadaEast,
        WestEurope,
        NorthEurope,
        CentralIndia,
        SouthIndia,
        WestIndia,
        JapanEast,
        JapanWest,
        KoreaCentral,
        KoreaSouth,
        UkWest,
        UkSouth,
        NorthCentralUs,
        EastUs,
        WestUs2,
        SouthCentralUs,
        CentralUs,
        EastUs2,
        WestUs,
        WestCentralUs,
        GermanyCentral,
        GermanyNortheast,
        ChinaNorth,
        ChinaEast,
        #[serde(rename = "USGovArizona")]
        UsGovArizona,
        #[serde(rename = "USGovTexas")]
        UsGovTexas,
        #[serde(rename = "USGovIowa")]
        UsGovIowa,
        #[serde(rename = "USGovVirginia")]
        UsGovVirginia,
        #[serde(rename = "USDoDCentral")]
        UsDoDCentral,
        #[serde(rename = "USDoDEast")]
        UsDoDEast,
    }
    #[doc = "Offer code according to which cost estimation is done."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureOfferCode {
        Unknown,
        #[serde(rename = "MSAZR0003P")]
        Msazr0003p,
        #[serde(rename = "MSAZR0044P")]
        Msazr0044p,
        #[serde(rename = "MSAZR0059P")]
        Msazr0059p,
        #[serde(rename = "MSAZR0060P")]
        Msazr0060p,
        #[serde(rename = "MSAZR0062P")]
        Msazr0062p,
        #[serde(rename = "MSAZR0063P")]
        Msazr0063p,
        #[serde(rename = "MSAZR0064P")]
        Msazr0064p,
        #[serde(rename = "MSAZR0029P")]
        Msazr0029p,
        #[serde(rename = "MSAZR0022P")]
        Msazr0022p,
        #[serde(rename = "MSAZR0023P")]
        Msazr0023p,
        #[serde(rename = "MSAZR0148P")]
        Msazr0148p,
        #[serde(rename = "MSAZR0025P")]
        Msazr0025p,
        #[serde(rename = "MSAZR0036P")]
        Msazr0036p,
        #[serde(rename = "MSAZR0120P")]
        Msazr0120p,
        #[serde(rename = "MSAZR0121P")]
        Msazr0121p,
        #[serde(rename = "MSAZR0122P")]
        Msazr0122p,
        #[serde(rename = "MSAZR0123P")]
        Msazr0123p,
        #[serde(rename = "MSAZR0124P")]
        Msazr0124p,
        #[serde(rename = "MSAZR0125P")]
        Msazr0125p,
        #[serde(rename = "MSAZR0126P")]
        Msazr0126p,
        #[serde(rename = "MSAZR0127P")]
        Msazr0127p,
        #[serde(rename = "MSAZR0128P")]
        Msazr0128p,
        #[serde(rename = "MSAZR0129P")]
        Msazr0129p,
        #[serde(rename = "MSAZR0130P")]
        Msazr0130p,
        #[serde(rename = "MSAZR0111P")]
        Msazr0111p,
        #[serde(rename = "MSAZR0144P")]
        Msazr0144p,
        #[serde(rename = "MSAZR0149P")]
        Msazr0149p,
        #[serde(rename = "MSMCAZR0044P")]
        Msmcazr0044p,
        #[serde(rename = "MSMCAZR0059P")]
        Msmcazr0059p,
        #[serde(rename = "MSMCAZR0060P")]
        Msmcazr0060p,
        #[serde(rename = "MSMCAZR0063P")]
        Msmcazr0063p,
        #[serde(rename = "MSMCAZR0120P")]
        Msmcazr0120p,
        #[serde(rename = "MSMCAZR0121P")]
        Msmcazr0121p,
        #[serde(rename = "MSMCAZR0125P")]
        Msmcazr0125p,
        #[serde(rename = "MSMCAZR0128P")]
        Msmcazr0128p,
        #[serde(rename = "MSAZRDE0003P")]
        Msazrde0003p,
        #[serde(rename = "MSAZRDE0044P")]
        Msazrde0044p,
        #[serde(rename = "MSAZRUSGOV0003P")]
        Msazrusgov0003p,
        #[serde(rename = "EA")]
        Ea,
    }
    #[doc = "Pricing tier for Size evaluation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzurePricingTier {
        Standard,
        Basic,
    }
    #[doc = "Storage Redundancy type offered by Azure."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureStorageRedundancy {
        Unknown,
        LocallyRedundant,
        ZoneRedundant,
        GeoRedundant,
        ReadAccessGeoRedundant,
    }
    #[doc = "Percentile of performance data used to recommend Azure size."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Percentile {
        Percentile50,
        Percentile90,
        Percentile95,
        Percentile99,
    }
    #[doc = "Time range of performance data used to recommend a size."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TimeRange {
        Day,
        Week,
        Month,
        Custom,
    }
    #[doc = "User configurable setting that describes the status of the assessment."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Stage {
        InProgress,
        UnderReview,
        Approved,
    }
    #[doc = "Currency to report prices in."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Currency {
        Unknown,
        #[serde(rename = "USD")]
        Usd,
        #[serde(rename = "DKK")]
        Dkk,
        #[serde(rename = "CAD")]
        Cad,
        #[serde(rename = "IDR")]
        Idr,
        #[serde(rename = "JPY")]
        Jpy,
        #[serde(rename = "KRW")]
        Krw,
        #[serde(rename = "NZD")]
        Nzd,
        #[serde(rename = "NOK")]
        Nok,
        #[serde(rename = "RUB")]
        Rub,
        #[serde(rename = "SAR")]
        Sar,
        #[serde(rename = "ZAR")]
        Zar,
        #[serde(rename = "SEK")]
        Sek,
        #[serde(rename = "TRY")]
        Try,
        #[serde(rename = "GBP")]
        Gbp,
        #[serde(rename = "MXN")]
        Mxn,
        #[serde(rename = "MYR")]
        Myr,
        #[serde(rename = "INR")]
        Inr,
        #[serde(rename = "HKD")]
        Hkd,
        #[serde(rename = "BRL")]
        Brl,
        #[serde(rename = "TWD")]
        Twd,
        #[serde(rename = "EUR")]
        Eur,
        #[serde(rename = "CHF")]
        Chf,
        #[serde(rename = "ARS")]
        Ars,
        #[serde(rename = "AUD")]
        Aud,
        #[serde(rename = "CNY")]
        Cny,
    }
    #[doc = "AHUB discount on windows virtual machines."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureHybridUseBenefit {
        Unknown,
        Yes,
        No,
    }
    #[doc = "Assessment sizing criterion."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SizingCriterion {
        PerformanceBased,
        AsOnPremises,
    }
    #[doc = "Azure reserved instance."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReservedInstance {
        None,
        #[serde(rename = "RI1Year")]
        Ri1Year,
        #[serde(rename = "RI3Year")]
        Ri3Year,
    }
    #[doc = "Storage type selected for this disk."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureDiskType {
        Unknown,
        Standard,
        Premium,
        #[serde(rename = "StandardSSD")]
        StandardSsd,
        StandardOrPremium,
    }
    #[doc = "Whether the assessment has been created and is valid."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Created,
        Updated,
        Running,
        Completed,
        Invalid,
        OutOfSync,
        OutDated,
    }
}
#[doc = "List of assessments."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessmentResultList {
    #[doc = "List of assessments."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Assessment>,
}
impl AssessmentResultList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response from the Azure Migrate service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "An error response from the Azure Migrate service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response from the Azure Migrate service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "An identifier for the error. Codes are invariant and are intended to be consumed programmatically."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "A message describing the error, intended to be suitable for display in a user interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The target of the particular error. For example, the name of the property in error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "A list of additional details about the error."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CollectorAgentProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(rename = "spnDetails", default, skip_serializing_if = "Option::is_none")]
    pub spn_details: Option<CollectorBodyAgentSpnProperties>,
}
impl CollectorAgentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CollectorBodyAgentSpnProperties {
    #[doc = "AAD Authority URL which was used to request the token for the service principal."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authority: Option<String>,
    #[doc = "Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(rename = "applicationId", default, skip_serializing_if = "Option::is_none")]
    pub application_id: Option<String>,
    #[doc = "Intended audience for the service principal."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub audience: Option<String>,
    #[doc = "Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[doc = "Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl CollectorBodyAgentSpnProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CollectorProperties {
    #[doc = "The ARM id of the discovery service site."]
    #[serde(rename = "discoverySiteId", default, skip_serializing_if = "Option::is_none")]
    pub discovery_site_id: Option<String>,
    #[doc = "Time when this collector was created. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "createdTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<String>,
    #[doc = "Time when this collector was updated. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "updatedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<String>,
    #[serde(rename = "agentProperties", default, skip_serializing_if = "Option::is_none")]
    pub agent_properties: Option<CollectorAgentProperties>,
}
impl CollectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A disk discovered on a machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Disk {
    #[doc = "Gigabytes of storage provisioned for this disk."]
    #[serde(rename = "gigabytesAllocated", default, skip_serializing_if = "Option::is_none")]
    pub gigabytes_allocated: Option<f64>,
    #[doc = "User friendly name of the disk."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl Disk {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Download URL for assessment report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DownloadUrl {
    #[doc = "Hyperlink to download report."]
    #[serde(rename = "assessmentReportUrl", default, skip_serializing_if = "Option::is_none")]
    pub assessment_report_url: Option<String>,
    #[doc = "Expiry date of download url."]
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
}
impl DownloadUrl {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A group created in a Migration project."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Group {
    #[doc = "Path reference to this group. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Name of the group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "For optimistic concurrency control."]
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[doc = "Type of the object = [Microsoft.Migrate/assessmentProjects/groups]."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Properties of group resource."]
    pub properties: GroupProperties,
}
impl Group {
    pub fn new(properties: GroupProperties) -> Self {
        Self {
            id: None,
            name: None,
            e_tag: None,
            type_: None,
            properties,
        }
    }
}
#[doc = "Body properties of group update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupBodyProperties {
    #[doc = "Whether to add or remove the machines."]
    #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
    pub operation_type: Option<group_body_properties::OperationType>,
    #[doc = "List of machine names that are part of this group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub machines: Vec<String>,
}
impl GroupBodyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod group_body_properties {
    use super::*;
    #[doc = "Whether to add or remove the machines."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationType {
        Add,
        Remove,
    }
}
#[doc = "Properties of group resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupProperties {
    #[doc = "Whether the group has been created and is valid."]
    #[serde(rename = "groupStatus", default, skip_serializing_if = "Option::is_none")]
    pub group_status: Option<group_properties::GroupStatus>,
    #[doc = "Number of machines part of this group."]
    #[serde(rename = "machineCount", default, skip_serializing_if = "Option::is_none")]
    pub machine_count: Option<i32>,
    #[doc = "List of References to Assessments created on this group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub assessments: Vec<String>,
    #[doc = "If the assessments are in running state."]
    #[serde(rename = "areAssessmentsRunning", default, skip_serializing_if = "Option::is_none")]
    pub are_assessments_running: Option<bool>,
    #[doc = "Time when this group was created. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "createdTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<String>,
    #[doc = "Time when this group was last updated. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "updatedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<String>,
    #[doc = "The type of group."]
    #[serde(rename = "groupType", default, skip_serializing_if = "Option::is_none")]
    pub group_type: Option<String>,
}
impl GroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod group_properties {
    use super::*;
    #[doc = "Whether the group has been created and is valid."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GroupStatus {
        Created,
        Updated,
        Running,
        Completed,
        Invalid,
    }
}
#[doc = "List of groups."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupResultList {
    #[doc = "List of groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Group>,
}
impl GroupResultList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVCollector {
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CollectorProperties>,
}
impl HyperVCollector {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of Hyper-V collectors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVCollectorList {
    #[doc = "List of Hyper-V collectors."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HyperVCollector>,
}
impl HyperVCollectorList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportCollector {
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ImportCollectorProperties>,
}
impl ImportCollector {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of Import collectors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportCollectorList {
    #[doc = "List of Import collectors."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ImportCollector>,
}
impl ImportCollectorList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportCollectorProperties {
    #[serde(rename = "discoverySiteId", default, skip_serializing_if = "Option::is_none")]
    pub discovery_site_id: Option<String>,
    #[serde(rename = "createdTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<String>,
    #[serde(rename = "updatedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<String>,
}
impl ImportCollectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A machine in a migration project."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Machine {
    #[doc = "Path reference to this machine. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/machines/{machineName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Name of the machine. It is a GUID which is unique identifier of machine in private data center. For user-readable name, we have a displayName property on this machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "For optimistic concurrency control."]
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[doc = "Type of the object = [Microsoft.Migrate/assessmentProjects/machines]."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Properties of a machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MachineProperties>,
}
impl Machine {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MachineProperties {
    #[doc = "Boot type of the machine."]
    #[serde(rename = "bootType", default, skip_serializing_if = "Option::is_none")]
    pub boot_type: Option<machine_properties::BootType>,
    #[doc = "ARM ID of the data center as tracked by the Microsoft.OffAzure."]
    #[serde(rename = "datacenterManagementServerArmId", default, skip_serializing_if = "Option::is_none")]
    pub datacenter_management_server_arm_id: Option<String>,
    #[doc = "ARM ID of the machine as tracked by the Microsoft.OffAzure."]
    #[serde(rename = "discoveryMachineArmId", default, skip_serializing_if = "Option::is_none")]
    pub discovery_machine_arm_id: Option<String>,
    #[doc = "Name of the server hosting the datacenter management solution."]
    #[serde(rename = "datacenterManagementServerName", default, skip_serializing_if = "Option::is_none")]
    pub datacenter_management_server_name: Option<String>,
    #[doc = "User readable name of the machine as defined by the user in their private datacenter."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Memory in Megabytes."]
    #[serde(rename = "megabytesOfMemory", default, skip_serializing_if = "Option::is_none")]
    pub megabytes_of_memory: Option<f64>,
    #[doc = "Processor count."]
    #[serde(rename = "numberOfCores", default, skip_serializing_if = "Option::is_none")]
    pub number_of_cores: Option<i64>,
    #[doc = "Operating System type of the machine."]
    #[serde(rename = "operatingSystemType", default, skip_serializing_if = "Option::is_none")]
    pub operating_system_type: Option<String>,
    #[doc = "Operating System name of the machine."]
    #[serde(rename = "operatingSystemName", default, skip_serializing_if = "Option::is_none")]
    pub operating_system_name: Option<String>,
    #[doc = "Operating System version of the machine."]
    #[serde(rename = "operatingSystemVersion", default, skip_serializing_if = "Option::is_none")]
    pub operating_system_version: Option<String>,
    #[doc = "Description of the machine"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "List of references to the groups that the machine is member of."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groups: Vec<String>,
    #[doc = "Time when this machine was created. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "createdTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<String>,
    #[doc = "Time when this machine was last updated. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "updatedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<String>,
    #[doc = "Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disks: Option<serde_json::Value>,
    #[doc = "Dictionary of network adapters attached to the machine. Key is ID of network adapter. Value is a network adapter object"]
    #[serde(rename = "networkAdapters", default, skip_serializing_if = "Option::is_none")]
    pub network_adapters: Option<serde_json::Value>,
}
impl MachineProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod machine_properties {
    use super::*;
    #[doc = "Boot type of the machine."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BootType {
        Unknown,
        #[serde(rename = "EFI")]
        Efi,
        #[serde(rename = "BIOS")]
        Bios,
    }
}
#[doc = "List of machines."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MachineResultList {
    #[doc = "List of machines."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Machine>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MachineResultList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A network adapter discovered on a machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkAdapter {
    #[doc = "MAC Address of the network adapter."]
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[doc = "List of IP Addresses on the network adapter."]
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
    #[doc = "User friendly name of the network adapter."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl NetworkAdapter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A REST API operation supported by the provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Name of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Displayable properties of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationDisplay>,
    #[doc = "Origin of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Displayable properties of the operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDisplay {
    #[doc = "Provider of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "Resource operated on by the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[doc = "Operation Type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "Description of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of API operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResultList {
    #[doc = "List of operations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
}
impl OperationResultList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A private endpoint connection for a project."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateEndpointConnection {
    #[doc = "Name of the private endpoint endpoint connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Type of the object = [Microsoft.Migrate/assessmentProjects/privateEndpointConnections]."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "For optimistic concurrency control."]
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[doc = "Path reference to this private endpoint endpoint connection. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateEndpointConnections/{privateEndpointConnectionName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Private endpoint connection properties."]
    pub properties: PrivateEndpointConnectionProperties,
}
impl PrivateEndpointConnection {
    pub fn new(properties: PrivateEndpointConnectionProperties) -> Self {
        Self {
            name: None,
            type_: None,
            e_tag: None,
            id: None,
            properties,
        }
    }
}
#[doc = "A collection of private endpoint connections for a project."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionCollection {
    #[doc = "A list of private endpoint connections for a project."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpointConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateEndpointConnectionCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Private endpoint connection properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionProperties {
    #[doc = "Indicates whether there is an ongoing operation on the private endpoint."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<private_endpoint_connection_properties::ProvisioningState>,
    #[doc = "ARM id for a resource."]
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<ResourceId>,
    #[doc = "State of a private endpoint connection."]
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
}
impl PrivateEndpointConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod private_endpoint_connection_properties {
    use super::*;
    #[doc = "Indicates whether there is an ongoing operation on the private endpoint."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Accepted,
        InProgress,
        Succeeded,
        Failed,
    }
}
#[doc = "A private link resource for a project for which a private endpoint can be created."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResource {
    #[doc = "Name of the private link resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Type of the object = [Microsoft.Migrate/assessmentProjects/privateLinkResources]."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Path reference to this private link resource. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateLinkResources/{privateLinkResourceName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Properties of a private link resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkResourceProperties>,
}
impl PrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of private link resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceCollection {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateLinkResource>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateLinkResourceCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a private link resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceProperties {
    #[doc = "The private link resource required member names."]
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[doc = "Required DNS zone names of the the private link resource."]
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
    #[doc = "The private link resource group id."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
}
impl PrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "State of a private endpoint connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionState {
    #[doc = "Connection status of the private endpoint connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<private_link_service_connection_state::Status>,
    #[doc = "Description of the private endpoint connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Actions required on the private endpoint connection."]
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod private_link_service_connection_state {
    use super::*;
    #[doc = "Connection status of the private endpoint connection."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Approved,
        Pending,
        Rejected,
        Disconnected,
    }
}
#[doc = "Azure Migrate Project."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Project {
    #[doc = "Path reference to this project /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Name of the project."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Type of the object = [Microsoft.Migrate/assessmentProjects]."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "For optimistic concurrency control."]
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[doc = "Azure location in which project is created."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Tags provided by Azure Tagging service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Properties of a project."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProjectProperties>,
}
impl Project {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a project."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProjectProperties {
    #[doc = "Time when this project was created. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "createdTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<String>,
    #[doc = "Time when this project was last updated. Date-Time represented in ISO-8601 format."]
    #[serde(rename = "updatedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<String>,
    #[doc = "Endpoint at which the collector agent can call agent REST API."]
    #[serde(rename = "serviceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub service_endpoint: Option<String>,
    #[doc = "Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects."]
    #[serde(rename = "assessmentSolutionId", default, skip_serializing_if = "Option::is_none")]
    pub assessment_solution_id: Option<String>,
    #[doc = "Assessment project status."]
    #[serde(rename = "projectStatus", default, skip_serializing_if = "Option::is_none")]
    pub project_status: Option<project_properties::ProjectStatus>,
    #[doc = "The ARM id of service map workspace created by customer."]
    #[serde(rename = "customerWorkspaceId", default, skip_serializing_if = "Option::is_none")]
    pub customer_workspace_id: Option<String>,
    #[doc = "Location of service map workspace created by customer."]
    #[serde(rename = "customerWorkspaceLocation", default, skip_serializing_if = "Option::is_none")]
    pub customer_workspace_location: Option<String>,
    #[doc = "Number of groups created in the project."]
    #[serde(rename = "numberOfGroups", default, skip_serializing_if = "Option::is_none")]
    pub number_of_groups: Option<i32>,
    #[doc = "Number of machines in the project."]
    #[serde(rename = "numberOfMachines", default, skip_serializing_if = "Option::is_none")]
    pub number_of_machines: Option<i32>,
    #[doc = "Number of assessments created in the project."]
    #[serde(rename = "numberOfAssessments", default, skip_serializing_if = "Option::is_none")]
    pub number_of_assessments: Option<i32>,
    #[doc = "Time when last assessment was created. Date-Time represented in ISO-8601 format. This value will be null until assessment is created."]
    #[serde(rename = "lastAssessmentTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub last_assessment_timestamp: Option<String>,
    #[doc = "This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method."]
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<String>,
    #[doc = "The list of private endpoint connections to the project."]
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[doc = "The ARM id of the storage account used for interactions when public access is disabled."]
    #[serde(rename = "customerStorageAccountArmId", default, skip_serializing_if = "Option::is_none")]
    pub customer_storage_account_arm_id: Option<String>,
    #[doc = "Provisioning state of the project."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<project_properties::ProvisioningState>,
}
impl ProjectProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod project_properties {
    use super::*;
    #[doc = "Assessment project status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProjectStatus {
        Active,
        Inactive,
    }
    #[doc = "Provisioning state of the project."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Accepted,
        Creating,
        Deleting,
        Failed,
        Moving,
        Succeeded,
    }
}
#[doc = "List of projects."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProjectResultList {
    #[doc = "List of projects."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Project>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProjectResultList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ARM id for a resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceId {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ResourceId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerCollector {
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CollectorProperties>,
}
impl ServerCollector {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of Server collectors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerCollectorList {
    #[doc = "List of Server collectors."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServerCollector>,
}
impl ServerCollectorList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of group update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateGroupBody {
    #[doc = "For optimistic concurrency control."]
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[doc = "Body properties of group update."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GroupBodyProperties>,
}
impl UpdateGroupBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCollector {
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CollectorProperties>,
}
impl VMwareCollector {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of VMware collectors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCollectorList {
    #[doc = "List of VMware collectors."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VMwareCollector>,
}
impl VMwareCollectorList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VM family name, the list of targeted azure locations and the category of the family."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmFamily {
    #[doc = "Name of the VM family."]
    #[serde(rename = "familyName", default, skip_serializing_if = "Option::is_none")]
    pub family_name: Option<String>,
    #[doc = "List of Azure regions."]
    #[serde(rename = "targetLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub target_locations: Vec<String>,
    #[doc = "Category of the VM family."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub category: Vec<String>,
}
impl VmFamily {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmUptime {
    #[doc = "Number of days in a month for VM uptime."]
    #[serde(rename = "daysPerMonth", default, skip_serializing_if = "Option::is_none")]
    pub days_per_month: Option<f64>,
    #[doc = "Number of hours per day for VM uptime."]
    #[serde(rename = "hoursPerDay", default, skip_serializing_if = "Option::is_none")]
    pub hours_per_day: Option<f64>,
}
impl VmUptime {
    pub fn new() -> Self {
        Self::default()
    }
}
