#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The details of the error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[doc = "One of a server-defined set of error codes."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "A human-readable representation of the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "(Optional) The target of the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The error object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "The details of the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetails>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The management group details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroup {
    #[doc = "The ID of the management group. E.g. /providers/Microsoft.Management/managementGroups/20000000-0000-0000-0000-000000000000"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The type of the resource. E.g. /providers/Microsoft.Management/managementGroups"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The name of the management group. E.g. 20000000-0000-0000-0000-000000000000"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The generic properties of a management group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagementGroupProperties>,
}
impl ManagementGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The unique identifier (ID) of a management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupChildInfo {
    #[doc = "(Optional) The type of the management group."]
    #[serde(rename = "childType", default, skip_serializing_if = "Option::is_none")]
    pub child_type: Option<ManagementGroupType>,
    #[doc = "The ID of the child resource (management group or subscription). E.g. /providers/Microsoft.Management/managementGroups/40000000-0000-0000-0000-000000000000"]
    #[serde(rename = "childId", default, skip_serializing_if = "Option::is_none")]
    pub child_id: Option<String>,
    #[doc = "The friendly name of the child resource."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "(Optional) The AAD Tenant ID associated with the child resource."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl ManagementGroupChildInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The details properties of a management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupDetailsProperties {
    #[doc = "The version number of the object."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<f64>,
    #[doc = "The date and time when this object was last updated."]
    #[serde(rename = "updatedTime", default, skip_serializing_if = "Option::is_none")]
    pub updated_time: Option<String>,
    #[doc = "The identity of the principal or process that updated the object."]
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<String>,
    #[doc = "(Optional) The ID of the parent management group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parent: Option<ParentGroupInfo>,
    #[doc = "(Optional) The type of the management group."]
    #[serde(rename = "managementGroupType", default, skip_serializing_if = "Option::is_none")]
    pub management_group_type: Option<ManagementGroupType>,
}
impl ManagementGroupDetailsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupInfo {
    #[doc = "The ID of the management group. E.g. /providers/Microsoft.Management/managementGroups/20000000-0000-0000-0000-000000000000"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The type of the resource. E.g. /providers/Microsoft.Management/managementGroups"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The name of the management group. E.g. 20000000-0000-0000-0000-000000000000"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The generic properties of a management group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagementGroupInfoProperties>,
}
impl ManagementGroupInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The generic properties of a management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupInfoProperties {
    #[doc = "The AAD Tenant ID associated with the management group. E.g. 10000000-0000-0000-0000-000000000000"]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The friendly name of the management group."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl ManagementGroupInfoProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of listing management groups."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupListResult {
    #[doc = "The list of management groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ManagementGroupInfo>,
    #[doc = "The URL to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagementGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The generic properties of a management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupProperties {
    #[doc = "The AAD Tenant ID associated with the management group. E.g. 10000000-0000-0000-0000-000000000000"]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The friendly name of the management group."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The details properties of a management group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<ManagementGroupDetailsProperties>,
}
impl ManagementGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The generic properties of a management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupPropertiesWithChildren {
    #[doc = "The AAD Tenant ID associated with the management group. E.g. 10000000-0000-0000-0000-000000000000"]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The friendly name of the management group."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The details properties of a management group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<ManagementGroupDetailsProperties>,
    #[doc = "The list of children."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub children: Vec<ManagementGroupChildInfo>,
}
impl ManagementGroupPropertiesWithChildren {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The generic properties of a management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupPropertiesWithHierarchy {
    #[doc = "The AAD Tenant ID associated with the management group. E.g. 10000000-0000-0000-0000-000000000000"]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The friendly name of the management group."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The details properties of a management group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<ManagementGroupDetailsProperties>,
    #[doc = "The list of children."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub children: Vec<ManagementGroupRecursiveChildInfo>,
}
impl ManagementGroupPropertiesWithHierarchy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The unique identifier (ID) of a management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupRecursiveChildInfo {
    #[doc = "(Optional) The type of the management group."]
    #[serde(rename = "childType", default, skip_serializing_if = "Option::is_none")]
    pub child_type: Option<ManagementGroupType>,
    #[doc = "The ID of the child resource (management group or subscription). E.g. /providers/Microsoft.Management/managementGroups/40000000-0000-0000-0000-000000000000"]
    #[serde(rename = "childId", default, skip_serializing_if = "Option::is_none")]
    pub child_id: Option<String>,
    #[doc = "The friendly name of the child resource."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "(Optional) The AAD Tenant ID associated with the child resource."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The list of children."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub children: Vec<ManagementGroupRecursiveChildInfo>,
}
impl ManagementGroupRecursiveChildInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "(Optional) The type of the management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ManagementGroupType {
    Enrollment,
    Department,
    Account,
    Subscription,
}
#[doc = "The management group details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupWithChildren {
    #[doc = "The ID of the management group. E.g. /providers/Microsoft.Management/managementGroups/20000000-0000-0000-0000-000000000000"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The type of the resource. E.g. /providers/Microsoft.Management/managementGroups"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The name of the management group. E.g. 20000000-0000-0000-0000-000000000000"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The generic properties of a management group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagementGroupPropertiesWithChildren>,
}
impl ManagementGroupWithChildren {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The management group details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupWithHierarchy {
    #[doc = "The ID of the management group. E.g. /providers/Microsoft.Management/managementGroups/20000000-0000-0000-0000-000000000000"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The type of the resource. E.g. /providers/Microsoft.Management/managementGroups"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The name of the management group. E.g. 20000000-0000-0000-0000-000000000000"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The generic properties of a management group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagementGroupPropertiesWithHierarchy>,
}
impl ManagementGroupWithHierarchy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Management REST API operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The object that represents the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "The object that represents the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Service provider: Microsoft.Management."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource on which the operation is performed: Invoice, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Operation type: Read, write, delete, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result listing  operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of management operations supported by the Microsoft.Management resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "(Optional) The ID of the parent management group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ParentGroupInfo {
    #[doc = "The ID of the parent management group. E.g. /providers/Microsoft.Management/managementGroups/30000000-0000-0000-0000-000000000000"]
    #[serde(rename = "parentId", default, skip_serializing_if = "Option::is_none")]
    pub parent_id: Option<String>,
    #[doc = "The friendly name of the management group."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl ParentGroupInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
