#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "A Machine Learning compute based on AKS."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Aks {
    #[serde(flatten)]
    pub compute: Compute,
    #[doc = "AKS properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<aks::Properties>,
}
impl Aks {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod aks {
    use super::*;
    #[doc = "AKS properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Cluster full qualified domain name"]
        #[serde(rename = "clusterFqdn", default, skip_serializing_if = "Option::is_none")]
        pub cluster_fqdn: Option<String>,
        #[doc = "System services"]
        #[serde(rename = "systemServices", default, skip_serializing_if = "Vec::is_empty")]
        pub system_services: Vec<SystemService>,
        #[doc = "Number of agents"]
        #[serde(rename = "agentCount", default, skip_serializing_if = "Option::is_none")]
        pub agent_count: Option<i32>,
        #[doc = "Agent virtual machine size"]
        #[serde(rename = "agentVmSize", default, skip_serializing_if = "Option::is_none")]
        pub agent_vm_size: Option<String>,
        #[doc = "Intended usage of the cluster"]
        #[serde(rename = "clusterPurpose", default, skip_serializing_if = "Option::is_none")]
        pub cluster_purpose: Option<properties::ClusterPurpose>,
        #[doc = "The ssl configuration for scoring"]
        #[serde(rename = "sslConfiguration", default, skip_serializing_if = "Option::is_none")]
        pub ssl_configuration: Option<SslConfiguration>,
        #[doc = "Advance configuration for AKS networking"]
        #[serde(rename = "aksNetworkingConfiguration", default, skip_serializing_if = "Option::is_none")]
        pub aks_networking_configuration: Option<AksNetworkingConfiguration>,
        #[doc = "Load Balancer Type"]
        #[serde(rename = "loadBalancerType", default, skip_serializing_if = "Option::is_none")]
        pub load_balancer_type: Option<properties::LoadBalancerType>,
        #[doc = "Load Balancer Subnet"]
        #[serde(rename = "loadBalancerSubnet", default, skip_serializing_if = "Option::is_none")]
        pub load_balancer_subnet: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Intended usage of the cluster"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ClusterPurpose {
            FastProd,
            DenseProd,
            DevTest,
        }
        impl Default for ClusterPurpose {
            fn default() -> Self {
                Self::FastProd
            }
        }
        #[doc = "Load Balancer Type"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum LoadBalancerType {
            PublicIp,
            InternalLoadBalancer,
        }
        impl Default for LoadBalancerType {
            fn default() -> Self {
                Self::PublicIp
            }
        }
    }
}
#[doc = "Account key datastore credentials configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccountKeyDatastoreCredentials {
    #[serde(flatten)]
    pub datastore_credentials: DatastoreCredentials,
    #[doc = "Datastore account key secrets."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secrets: Option<AccountKeyDatastoreSecrets>,
}
impl AccountKeyDatastoreCredentials {
    pub fn new(datastore_credentials: DatastoreCredentials) -> Self {
        Self {
            datastore_credentials,
            secrets: None,
        }
    }
}
#[doc = "Datastore account key secrets."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccountKeyDatastoreSecrets {
    #[serde(flatten)]
    pub datastore_secrets: DatastoreSecrets,
    #[doc = "Storage account key."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
}
impl AccountKeyDatastoreSecrets {
    pub fn new(datastore_secrets: DatastoreSecrets) -> Self {
        Self {
            datastore_secrets,
            key: None,
        }
    }
}
#[doc = "Secrets related to a Machine Learning compute based on AKS."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AksComputeSecrets {
    #[serde(flatten)]
    pub compute_secrets: ComputeSecrets,
    #[doc = "Content of kubeconfig file that can be used to connect to the Kubernetes cluster."]
    #[serde(rename = "userKubeConfig", default, skip_serializing_if = "Option::is_none")]
    pub user_kube_config: Option<String>,
    #[doc = "Content of kubeconfig file that can be used to connect to the Kubernetes cluster."]
    #[serde(rename = "adminKubeConfig", default, skip_serializing_if = "Option::is_none")]
    pub admin_kube_config: Option<String>,
    #[doc = "Image registry pull secret."]
    #[serde(rename = "imagePullSecretName", default, skip_serializing_if = "Option::is_none")]
    pub image_pull_secret_name: Option<String>,
}
impl AksComputeSecrets {
    pub fn new(compute_secrets: ComputeSecrets) -> Self {
        Self {
            compute_secrets,
            user_kube_config: None,
            admin_kube_config: None,
            image_pull_secret_name: None,
        }
    }
}
#[doc = "Advance configuration for AKS networking"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AksNetworkingConfiguration {
    #[doc = "Virtual network subnet resource ID the compute nodes belong to"]
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[doc = "A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges."]
    #[serde(rename = "serviceCidr", default, skip_serializing_if = "Option::is_none")]
    pub service_cidr: Option<String>,
    #[doc = "An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr."]
    #[serde(rename = "dnsServiceIP", default, skip_serializing_if = "Option::is_none")]
    pub dns_service_ip: Option<String>,
    #[doc = "A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range."]
    #[serde(rename = "dockerBridgeCidr", default, skip_serializing_if = "Option::is_none")]
    pub docker_bridge_cidr: Option<String>,
}
impl AksNetworkingConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Machine Learning compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmlCompute {
    #[serde(flatten)]
    pub compute: Compute,
    #[doc = "AML Compute properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<aml_compute::Properties>,
}
impl AmlCompute {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod aml_compute {
    use super::*;
    #[doc = "AML Compute properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Compute OS Type"]
        #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
        pub os_type: Option<properties::OsType>,
        #[doc = "Virtual Machine Size"]
        #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
        pub vm_size: Option<String>,
        #[doc = "Virtual Machine priority"]
        #[serde(rename = "vmPriority", default, skip_serializing_if = "Option::is_none")]
        pub vm_priority: Option<properties::VmPriority>,
        #[doc = "Virtual Machine image for Windows AML Compute"]
        #[serde(rename = "virtualMachineImage", default, skip_serializing_if = "Option::is_none")]
        pub virtual_machine_image: Option<VirtualMachineImage>,
        #[doc = "Network is isolated or not"]
        #[serde(rename = "isolatedNetwork", default, skip_serializing_if = "Option::is_none")]
        pub isolated_network: Option<bool>,
        #[doc = "scale settings for AML Compute"]
        #[serde(rename = "scaleSettings", default, skip_serializing_if = "Option::is_none")]
        pub scale_settings: Option<ScaleSettings>,
        #[doc = "Settings for user account that gets created on each on the nodes of a compute."]
        #[serde(rename = "userAccountCredentials", default, skip_serializing_if = "Option::is_none")]
        pub user_account_credentials: Option<UserAccountCredentials>,
        #[doc = "Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subnet: Option<ResourceId>,
        #[doc = "State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled."]
        #[serde(rename = "remoteLoginPortPublicAccess", default, skip_serializing_if = "Option::is_none")]
        pub remote_login_port_public_access: Option<properties::RemoteLoginPortPublicAccess>,
        #[doc = "Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute."]
        #[serde(rename = "allocationState", default, skip_serializing_if = "Option::is_none")]
        pub allocation_state: Option<properties::AllocationState>,
        #[doc = "The time at which the compute entered its current allocation state."]
        #[serde(rename = "allocationStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
        pub allocation_state_transition_time: Option<String>,
        #[doc = "Collection of errors encountered by various compute nodes during node setup."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub errors: Vec<ErrorResponse>,
        #[doc = "The number of compute nodes currently assigned to the compute."]
        #[serde(rename = "currentNodeCount", default, skip_serializing_if = "Option::is_none")]
        pub current_node_count: Option<i32>,
        #[doc = "The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation."]
        #[serde(rename = "targetNodeCount", default, skip_serializing_if = "Option::is_none")]
        pub target_node_count: Option<i32>,
        #[doc = "Counts of various compute node states on the amlCompute."]
        #[serde(rename = "nodeStateCounts", default, skip_serializing_if = "Option::is_none")]
        pub node_state_counts: Option<NodeStateCounts>,
        #[doc = "Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs."]
        #[serde(rename = "enableNodePublicIp", default, skip_serializing_if = "Option::is_none")]
        pub enable_node_public_ip: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Compute OS Type"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum OsType {
            Linux,
            Windows,
        }
        impl Default for OsType {
            fn default() -> Self {
                Self::Linux
            }
        }
        #[doc = "Virtual Machine priority"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum VmPriority {
            Dedicated,
            LowPriority,
        }
        #[doc = "State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RemoteLoginPortPublicAccess {
            Enabled,
            Disabled,
            NotSpecified,
        }
        impl Default for RemoteLoginPortPublicAccess {
            fn default() -> Self {
                Self::NotSpecified
            }
        }
        #[doc = "Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AllocationState {
            Steady,
            Resizing,
        }
    }
}
#[doc = "Compute node information related to a AmlCompute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmlComputeNodeInformation {
    #[doc = "ID of the compute node."]
    #[serde(rename = "nodeId", default, skip_serializing_if = "Option::is_none")]
    pub node_id: Option<String>,
    #[doc = "Private IP address of the compute node."]
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "Public IP address of the compute node."]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[doc = "SSH port number of the node."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<f64>,
    #[doc = "State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted."]
    #[serde(rename = "nodeState", default, skip_serializing_if = "Option::is_none")]
    pub node_state: Option<aml_compute_node_information::NodeState>,
    #[doc = "ID of the Experiment running on the node, if any else null."]
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
}
impl AmlComputeNodeInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod aml_compute_node_information {
    use super::*;
    #[doc = "State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeState {
        #[serde(rename = "idle")]
        Idle,
        #[serde(rename = "running")]
        Running,
        #[serde(rename = "preparing")]
        Preparing,
        #[serde(rename = "unusable")]
        Unusable,
        #[serde(rename = "leaving")]
        Leaving,
        #[serde(rename = "preempted")]
        Preempted,
    }
}
#[doc = "Compute node information related to a AmlCompute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmlComputeNodesInformation {
    #[serde(flatten)]
    pub compute_nodes_information: ComputeNodesInformation,
    #[doc = "The collection of returned AmlCompute nodes details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub nodes: Vec<AmlComputeNodeInformation>,
    #[doc = "The continuation token."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AmlComputeNodesInformation {
    pub fn new(compute_nodes_information: ComputeNodesInformation) -> Self {
        Self {
            compute_nodes_information,
            nodes: Vec::new(),
            next_link: None,
        }
    }
}
#[doc = "AML Token identity configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmlToken {
    #[serde(flatten)]
    pub identity_configuration: IdentityConfiguration,
}
impl AmlToken {
    pub fn new(identity_configuration: IdentityConfiguration) -> Self {
        Self { identity_configuration }
    }
}
#[doc = "Features enabled for a workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmlUserFeature {
    #[doc = "Specifies the feature ID"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Specifies the feature name "]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Describes the feature for user experience"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl AmlUserFeature {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base definition for asset references."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssetReferenceBase {
    #[doc = "Enum to determine which reference method to use for an asset."]
    #[serde(rename = "referenceType")]
    pub reference_type: ReferenceType,
}
impl AssetReferenceBase {
    pub fn new(reference_type: ReferenceType) -> Self {
        Self { reference_type }
    }
}
#[doc = "A user that can be assigned to a compute instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssignedUser {
    #[doc = "User’s AAD Object Id."]
    #[serde(rename = "objectId")]
    pub object_id: String,
    #[doc = "User’s AAD Tenant Id."]
    #[serde(rename = "tenantId")]
    pub tenant_id: String,
}
impl AssignedUser {
    pub fn new(object_id: String, tenant_id: String) -> Self {
        Self { object_id, tenant_id }
    }
}
#[doc = "Auto pause properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoPauseProperties {
    #[serde(rename = "delayInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub delay_in_minutes: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl AutoPauseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Auto scale properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoScaleProperties {
    #[serde(rename = "minNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub min_node_count: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "maxNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub max_node_count: Option<i32>,
}
impl AutoScaleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoScaleSettings {
    #[serde(flatten)]
    pub online_scale_settings: OnlineScaleSettings,
    #[doc = "The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds."]
    #[serde(rename = "pollingInterval", default, skip_serializing_if = "Option::is_none")]
    pub polling_interval: Option<String>,
    #[doc = "Target CPU usage for the autoscaler."]
    #[serde(rename = "targetUtilizationPercentage", default, skip_serializing_if = "Option::is_none")]
    pub target_utilization_percentage: Option<i32>,
}
impl AutoScaleSettings {
    pub fn new(online_scale_settings: OnlineScaleSettings) -> Self {
        Self {
            online_scale_settings,
            polling_interval: None,
            target_utilization_percentage: None,
        }
    }
}
#[doc = "Azure Blob datastore configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobContents {
    #[serde(flatten)]
    pub datastore_contents: DatastoreContents,
    #[doc = "Storage account name."]
    #[serde(rename = "accountName")]
    pub account_name: String,
    #[doc = "Storage account container name."]
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[doc = "Base definition for datastore credentials."]
    pub credentials: DatastoreCredentials,
    #[doc = "Azure cloud endpoint for the storage account."]
    pub endpoint: String,
    #[doc = "Protocol used to communicate with the storage account."]
    pub protocol: String,
}
impl AzureBlobContents {
    pub fn new(
        datastore_contents: DatastoreContents,
        account_name: String,
        container_name: String,
        credentials: DatastoreCredentials,
        endpoint: String,
        protocol: String,
    ) -> Self {
        Self {
            datastore_contents,
            account_name,
            container_name,
            credentials,
            endpoint,
            protocol,
        }
    }
}
#[doc = "Azure Data Lake Gen1 datastore configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeGen1Contents {
    #[serde(flatten)]
    pub datastore_contents: DatastoreContents,
    #[doc = "Base definition for datastore credentials."]
    pub credentials: DatastoreCredentials,
    #[doc = "Azure Data Lake store name."]
    #[serde(rename = "storeName")]
    pub store_name: String,
}
impl AzureDataLakeGen1Contents {
    pub fn new(datastore_contents: DatastoreContents, credentials: DatastoreCredentials, store_name: String) -> Self {
        Self {
            datastore_contents,
            credentials,
            store_name,
        }
    }
}
#[doc = "Azure Data Lake Gen2 datastore configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeGen2Contents {
    #[serde(flatten)]
    pub datastore_contents: DatastoreContents,
    #[doc = "Storage account name."]
    #[serde(rename = "accountName")]
    pub account_name: String,
    #[doc = "Storage account container name."]
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[doc = "Base definition for datastore credentials."]
    pub credentials: DatastoreCredentials,
    #[doc = "Azure cloud endpoint for the storage account."]
    pub endpoint: String,
    #[doc = "Protocol used to communicate with the storage account."]
    pub protocol: String,
}
impl AzureDataLakeGen2Contents {
    pub fn new(
        datastore_contents: DatastoreContents,
        account_name: String,
        container_name: String,
        credentials: DatastoreCredentials,
        endpoint: String,
        protocol: String,
    ) -> Self {
        Self {
            datastore_contents,
            account_name,
            container_name,
            credentials,
            endpoint,
            protocol,
        }
    }
}
#[doc = "Azure File datastore configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileContents {
    #[serde(flatten)]
    pub datastore_contents: DatastoreContents,
    #[doc = "Storage account name."]
    #[serde(rename = "accountName")]
    pub account_name: String,
    #[doc = "Storage account container name."]
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[doc = "Base definition for datastore credentials."]
    pub credentials: DatastoreCredentials,
    #[doc = "Azure cloud endpoint for the storage account."]
    pub endpoint: String,
    #[doc = "Protocol used to communicate with the storage account."]
    pub protocol: String,
}
impl AzureFileContents {
    pub fn new(
        datastore_contents: DatastoreContents,
        account_name: String,
        container_name: String,
        credentials: DatastoreCredentials,
        endpoint: String,
        protocol: String,
    ) -> Self {
        Self {
            datastore_contents,
            account_name,
            container_name,
            credentials,
            endpoint,
            protocol,
        }
    }
}
#[doc = "Azure Postgre SQL datastore configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlContents {
    #[serde(flatten)]
    pub datastore_contents: DatastoreContents,
    #[doc = "Base definition for datastore credentials."]
    pub credentials: DatastoreCredentials,
    #[doc = "Azure SQL database name."]
    #[serde(rename = "databaseName")]
    pub database_name: String,
    #[doc = "Whether the Azure PostgreSQL server requires SSL."]
    #[serde(rename = "enableSSL", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<bool>,
    #[doc = "Azure cloud endpoint for the database."]
    pub endpoint: String,
    #[doc = "Azure SQL server port."]
    #[serde(rename = "portNumber")]
    pub port_number: i32,
    #[doc = "Azure SQL server name."]
    #[serde(rename = "serverName")]
    pub server_name: String,
}
impl AzurePostgreSqlContents {
    pub fn new(
        datastore_contents: DatastoreContents,
        credentials: DatastoreCredentials,
        database_name: String,
        endpoint: String,
        port_number: i32,
        server_name: String,
    ) -> Self {
        Self {
            datastore_contents,
            credentials,
            database_name,
            enable_ssl: None,
            endpoint,
            port_number,
            server_name,
        }
    }
}
#[doc = "Azure SQL Database datastore configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseContents {
    #[serde(flatten)]
    pub datastore_contents: DatastoreContents,
    #[doc = "Base definition for datastore credentials."]
    pub credentials: DatastoreCredentials,
    #[doc = "Azure SQL database name."]
    #[serde(rename = "databaseName")]
    pub database_name: String,
    #[doc = "Azure cloud endpoint for the database."]
    pub endpoint: String,
    #[doc = "Azure SQL server port."]
    #[serde(rename = "portNumber")]
    pub port_number: i32,
    #[doc = "Azure SQL server name."]
    #[serde(rename = "serverName")]
    pub server_name: String,
}
impl AzureSqlDatabaseContents {
    pub fn new(
        datastore_contents: DatastoreContents,
        credentials: DatastoreCredentials,
        database_name: String,
        endpoint: String,
        port_number: i32,
        server_name: String,
    ) -> Self {
        Self {
            datastore_contents,
            credentials,
            database_name,
            endpoint,
            port_number,
            server_name,
        }
    }
}
#[doc = "Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BanditPolicy {
    #[serde(flatten)]
    pub early_termination_policy: EarlyTerminationPolicy,
    #[doc = "Absolute distance allowed from the best performing run."]
    #[serde(rename = "slackAmount", default, skip_serializing_if = "Option::is_none")]
    pub slack_amount: Option<f32>,
    #[doc = "Ratio of the allowed distance from the best performing run."]
    #[serde(rename = "slackFactor", default, skip_serializing_if = "Option::is_none")]
    pub slack_factor: Option<f32>,
}
impl BanditPolicy {
    pub fn new(early_termination_policy: EarlyTerminationPolicy) -> Self {
        Self {
            early_termination_policy,
            slack_amount: None,
            slack_factor: None,
        }
    }
}
#[doc = "Batch inference settings per deployment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchDeployment {
    #[doc = "Configuration for a scoring code asset."]
    #[serde(rename = "codeConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub code_configuration: Option<CodeConfiguration>,
    #[doc = "Configuration for compute binding."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compute: Option<ComputeConfiguration>,
    #[doc = "Description of the endpoint deployment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "ARM resource ID of the environment specification for the endpoint deployment."]
    #[serde(rename = "environmentId", default, skip_serializing_if = "Option::is_none")]
    pub environment_id: Option<String>,
    #[doc = "Environment variables configuration for the deployment."]
    #[serde(rename = "environmentVariables", default, skip_serializing_if = "Option::is_none")]
    pub environment_variables: Option<serde_json::Value>,
    #[doc = "Error threshold, if the error count for the entire input goes above this value,\r\nthe batch inference will be aborted. Range is [-1, int.MaxValue].\r\nFor FileDataset, this value is the count of file failures.\r\nFor TabularDataset, this value is the count of record failures.\r\nIf set to -1 (the lower bound), all failures during batch inference will be ignored."]
    #[serde(rename = "errorThreshold", default, skip_serializing_if = "Option::is_none")]
    pub error_threshold: Option<i32>,
    #[doc = "Log verbosity for batch inferencing.\r\nIncreasing verbosity order for logging is : Warning, Info and Debug.\r\nThe default value is Info."]
    #[serde(rename = "loggingLevel", default, skip_serializing_if = "Option::is_none")]
    pub logging_level: Option<BatchLoggingLevel>,
    #[doc = "Size of the mini-batch passed to each batch invocation.\r\nFor FileDataset, this is the number of files per mini-batch.\r\nFor TabularDataset, this is the size of the records in bytes, per mini-batch."]
    #[serde(rename = "miniBatchSize", default, skip_serializing_if = "Option::is_none")]
    pub mini_batch_size: Option<i64>,
    #[doc = "Base definition for asset references."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub model: Option<AssetReferenceBase>,
    #[doc = "Batch inference output configuration."]
    #[serde(rename = "outputConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub output_configuration: Option<BatchOutputConfiguration>,
    #[doc = "Partition keys list used for Named partitioning."]
    #[serde(rename = "partitionKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_keys: Vec<String>,
    #[doc = "Property dictionary. Properties can be added, but not removed or altered."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Retry settings for a batch inference operation."]
    #[serde(rename = "retrySettings", default, skip_serializing_if = "Option::is_none")]
    pub retry_settings: Option<BatchRetrySettings>,
}
impl BatchDeployment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BatchDeploymentTrackedResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Service identity associated with a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Batch inference settings per deployment."]
    pub properties: BatchDeployment,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl BatchDeploymentTrackedResource {
    pub fn new(tracked_resource: TrackedResource, properties: BatchDeployment) -> Self {
        Self {
            tracked_resource,
            identity: None,
            kind: None,
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of BatchDeployment entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchDeploymentTrackedResourceArmPaginatedResult {
    #[doc = "The link to the next page of BatchDeployment objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type BatchDeployment."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BatchDeploymentTrackedResource>,
}
impl BatchDeploymentTrackedResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Batch endpoint configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchEndpoint {
    #[doc = "Enum to determine endpoint authentication mode."]
    #[serde(rename = "authMode", default, skip_serializing_if = "Option::is_none")]
    pub auth_mode: Option<EndpointAuthMode>,
    #[doc = "Description of the inference endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Keys for endpoint authentication."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keys: Option<EndpointAuthKeys>,
    #[doc = "Property dictionary. Properties can be added, but not removed or altered."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Endpoint URI."]
    #[serde(rename = "scoringUri", default, skip_serializing_if = "Option::is_none")]
    pub scoring_uri: Option<String>,
    #[doc = "Endpoint Swagger URI."]
    #[serde(rename = "swaggerUri", default, skip_serializing_if = "Option::is_none")]
    pub swagger_uri: Option<String>,
    #[doc = "Traffic rules on how the traffic will be routed across deployments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub traffic: Option<serde_json::Value>,
}
impl BatchEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BatchEndpointTrackedResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Service identity associated with a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Batch endpoint configuration."]
    pub properties: BatchEndpoint,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl BatchEndpointTrackedResource {
    pub fn new(tracked_resource: TrackedResource, properties: BatchEndpoint) -> Self {
        Self {
            tracked_resource,
            identity: None,
            kind: None,
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of BatchEndpoint entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchEndpointTrackedResourceArmPaginatedResult {
    #[doc = "The link to the next page of BatchEndpoint objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type BatchEndpoint."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BatchEndpointTrackedResource>,
}
impl BatchEndpointTrackedResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Log verbosity for batch inferencing.\r\nIncreasing verbosity order for logging is : Warning, Info and Debug.\r\nThe default value is Info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum BatchLoggingLevel {
    Info,
    Warning,
    Debug,
}
#[doc = "Enum to determine how batch inferencing will handle output"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum BatchOutputAction {
    SummaryOnly,
    AppendRow,
}
#[doc = "Batch inference output configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchOutputConfiguration {
    #[doc = "Customized output file name for append_row output action."]
    #[serde(rename = "appendRowFileName", default, skip_serializing_if = "Option::is_none")]
    pub append_row_file_name: Option<String>,
    #[doc = "Enum to determine how batch inferencing will handle output"]
    #[serde(rename = "outputAction", default, skip_serializing_if = "Option::is_none")]
    pub output_action: Option<BatchOutputAction>,
}
impl BatchOutputConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Retry settings for a batch inference operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchRetrySettings {
    #[doc = "Maximum retry count for a mini-batch"]
    #[serde(rename = "maxRetries", default, skip_serializing_if = "Option::is_none")]
    pub max_retries: Option<i32>,
    #[doc = "Invocation timeout for a mini-batch, in ISO 8601 format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
}
impl BatchRetrySettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Certificate datastore credentials configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateDatastoreCredentials {
    #[serde(flatten)]
    pub datastore_credentials: DatastoreCredentials,
    #[doc = "Authority URL used for authentication."]
    #[serde(rename = "authorityUrl", default, skip_serializing_if = "Option::is_none")]
    pub authority_url: Option<String>,
    #[doc = "Service principal client ID."]
    #[serde(rename = "clientId")]
    pub client_id: String,
    #[doc = "Resource the service principal has access to."]
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[doc = "Datastore certificate secrets."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secrets: Option<CertificateDatastoreSecrets>,
    #[doc = "ID of the tenant to which the service principal belongs."]
    #[serde(rename = "tenantId")]
    pub tenant_id: String,
    #[doc = "Thumbprint of the certificate used for authentication."]
    pub thumbprint: String,
}
impl CertificateDatastoreCredentials {
    pub fn new(datastore_credentials: DatastoreCredentials, client_id: String, tenant_id: String, thumbprint: String) -> Self {
        Self {
            datastore_credentials,
            authority_url: None,
            client_id,
            resource_uri: None,
            secrets: None,
            tenant_id,
            thumbprint,
        }
    }
}
#[doc = "Datastore certificate secrets."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateDatastoreSecrets {
    #[serde(flatten)]
    pub datastore_secrets: DatastoreSecrets,
    #[doc = "Service principal certificate."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<String>,
}
impl CertificateDatastoreSecrets {
    pub fn new(datastore_secrets: DatastoreSecrets) -> Self {
        Self {
            datastore_secrets,
            certificate: None,
        }
    }
}
#[doc = "AmlCompute update parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClusterUpdateParameters {
    #[doc = "The properties of a amlCompute that need to be updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ClusterUpdateProperties>,
}
impl ClusterUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a amlCompute that need to be updated."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClusterUpdateProperties {
    #[doc = "scale settings for AML Compute"]
    #[serde(rename = "scaleSettings", default, skip_serializing_if = "Option::is_none")]
    pub scale_settings: Option<ScaleSettings>,
}
impl ClusterUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CocoExportSummary {
    #[serde(flatten)]
    pub export_summary: ExportSummary,
    #[doc = "The container name to which the labels will be exported."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The output path where the labels will be exported."]
    #[serde(rename = "snapshotPath", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_path: Option<String>,
}
impl CocoExportSummary {
    pub fn new(export_summary: ExportSummary) -> Self {
        Self {
            export_summary,
            container_name: None,
            snapshot_path: None,
        }
    }
}
#[doc = "Configuration for a scoring code asset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodeConfiguration {
    #[doc = "ARM resource ID of the code asset."]
    #[serde(rename = "codeId", default, skip_serializing_if = "Option::is_none")]
    pub code_id: Option<String>,
    #[doc = "The script to execute on startup. eg. \"score.py\""]
    #[serde(rename = "scoringScript")]
    pub scoring_script: String,
}
impl CodeConfiguration {
    pub fn new(scoring_script: String) -> Self {
        Self {
            code_id: None,
            scoring_script,
        }
    }
}
#[doc = "Container for code asset versions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CodeContainer {
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl CodeContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodeContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Container for code asset versions."]
    pub properties: CodeContainer,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl CodeContainerResource {
    pub fn new(properties: CodeContainer) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of CodeContainer entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CodeContainerResourceArmPaginatedResult {
    #[doc = "The link to the next page of CodeContainer objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type CodeContainer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CodeContainerResource>,
}
impl CodeContainerResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Code asset version details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodeVersion {
    #[doc = "ARM resource ID of the datastore where the asset is located."]
    #[serde(rename = "datastoreId", default, skip_serializing_if = "Option::is_none")]
    pub datastore_id: Option<String>,
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "If the name version are system generated (anonymous registration)."]
    #[serde(rename = "isAnonymous", default, skip_serializing_if = "Option::is_none")]
    pub is_anonymous: Option<bool>,
    #[doc = "The path of the file/directory in the datastore."]
    pub path: String,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl CodeVersion {
    pub fn new(path: String) -> Self {
        Self {
            datastore_id: None,
            description: None,
            is_anonymous: None,
            path,
            properties: None,
            tags: None,
        }
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodeVersionResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Code asset version details."]
    pub properties: CodeVersion,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl CodeVersionResource {
    pub fn new(properties: CodeVersion) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of CodeVersion entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CodeVersionResourceArmPaginatedResult {
    #[doc = "The link to the next page of CodeVersion objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type CodeVersion."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CodeVersionResource>,
}
impl CodeVersionResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Command job definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommandJob {
    #[serde(flatten)]
    pub job_base: JobBase,
    #[doc = "ARM resource ID of the code asset."]
    #[serde(rename = "codeId", default, skip_serializing_if = "Option::is_none")]
    pub code_id: Option<String>,
    #[doc = "The command to execute on startup of the job. eg. \"python train.py\""]
    pub command: String,
    #[doc = "Configuration for compute binding."]
    pub compute: ComputeConfiguration,
    #[doc = "Base definition for job distribution configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub distribution: Option<DistributionConfiguration>,
    #[doc = "The ARM resource ID of the Environment specification for the job."]
    #[serde(rename = "environmentId", default, skip_serializing_if = "Option::is_none")]
    pub environment_id: Option<String>,
    #[doc = "Environment variables included in the job."]
    #[serde(rename = "environmentVariables", default, skip_serializing_if = "Option::is_none")]
    pub environment_variables: Option<serde_json::Value>,
    #[doc = "The name of the experiment the job belongs to. If not set, the job is placed in the \"Default\" experiment."]
    #[serde(rename = "experimentName", default, skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    #[doc = "Base definition for identity configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityConfiguration>,
    #[doc = "Mapping of input data bindings used in the job."]
    #[serde(rename = "inputDataBindings", default, skip_serializing_if = "Option::is_none")]
    pub input_data_bindings: Option<serde_json::Value>,
    #[doc = "Job output definition container information on where to find job output/logs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<JobOutput>,
    #[doc = "Mapping of output data bindings used in the job."]
    #[serde(rename = "outputDataBindings", default, skip_serializing_if = "Option::is_none")]
    pub output_data_bindings: Option<serde_json::Value>,
    #[doc = "Input parameters."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[doc = "Job priority for scheduling policy. Only applies to AMLCompute.\r\nPrivate preview feature and only available to users on the allow list."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "The status of a job."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<JobStatus>,
    #[doc = "The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
}
impl CommandJob {
    pub fn new(job_base: JobBase, command: String, compute: ComputeConfiguration) -> Self {
        Self {
            job_base,
            code_id: None,
            command,
            compute,
            distribution: None,
            environment_id: None,
            environment_variables: None,
            experiment_name: None,
            identity: None,
            input_data_bindings: None,
            output: None,
            output_data_bindings: None,
            parameters: None,
            priority: None,
            status: None,
            timeout: None,
        }
    }
}
#[doc = "Machine Learning compute object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Compute {
    #[doc = "The type of compute"]
    #[serde(rename = "computeType")]
    pub compute_type: ComputeType,
    #[doc = "Location for the underlying compute"]
    #[serde(rename = "computeLocation", default, skip_serializing_if = "Option::is_none")]
    pub compute_location: Option<String>,
    #[doc = "The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<compute::ProvisioningState>,
    #[doc = "The description of the Machine Learning compute."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The time at which the compute was created."]
    #[serde(rename = "createdOn", default, skip_serializing_if = "Option::is_none")]
    pub created_on: Option<String>,
    #[doc = "The time at which the compute was last modified."]
    #[serde(rename = "modifiedOn", default, skip_serializing_if = "Option::is_none")]
    pub modified_on: Option<String>,
    #[doc = "ARM resource id of the underlying compute"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "Errors during provisioning"]
    #[serde(rename = "provisioningErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub provisioning_errors: Vec<ErrorResponse>,
    #[doc = "Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false."]
    #[serde(rename = "isAttachedCompute", default, skip_serializing_if = "Option::is_none")]
    pub is_attached_compute: Option<bool>,
    #[doc = "Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication."]
    #[serde(rename = "disableLocalAuth", default, skip_serializing_if = "Option::is_none")]
    pub disable_local_auth: Option<bool>,
}
impl Compute {
    pub fn new(compute_type: ComputeType) -> Self {
        Self {
            compute_type,
            compute_location: None,
            provisioning_state: None,
            description: None,
            created_on: None,
            modified_on: None,
            resource_id: None,
            provisioning_errors: Vec::new(),
            is_attached_compute: None,
            disable_local_auth: None,
        }
    }
}
pub mod compute {
    use super::*;
    #[doc = "The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Unknown,
        Updating,
        Creating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "Configuration for compute binding."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeConfiguration {
    #[doc = "Number of instances or nodes."]
    #[serde(rename = "instanceCount", default, skip_serializing_if = "Option::is_none")]
    pub instance_count: Option<i32>,
    #[doc = "SKU type to run on."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    #[doc = "Set to true for jobs running on local compute."]
    #[serde(rename = "isLocal", default, skip_serializing_if = "Option::is_none")]
    pub is_local: Option<bool>,
    #[doc = "Location for virtual cluster run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Additional properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "ARM resource ID of the compute resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl ComputeConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Machine Learning compute instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ComputeInstance {
    #[serde(flatten)]
    pub compute: Compute,
    #[doc = "Compute Instance properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<compute_instance::Properties>,
}
impl ComputeInstance {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod compute_instance {
    use super::*;
    #[doc = "Compute Instance properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Virtual Machine Size"]
        #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
        pub vm_size: Option<String>,
        #[doc = "Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subnet: Option<ResourceId>,
        #[doc = "Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role."]
        #[serde(rename = "applicationSharingPolicy", default, skip_serializing_if = "Option::is_none")]
        pub application_sharing_policy: Option<properties::ApplicationSharingPolicy>,
        #[doc = "Specifies policy and settings for SSH access."]
        #[serde(rename = "sshSettings", default, skip_serializing_if = "Option::is_none")]
        pub ssh_settings: Option<ComputeInstanceSshSettings>,
        #[doc = "Defines all connectivity endpoints and properties for an ComputeInstance."]
        #[serde(rename = "connectivityEndpoints", default, skip_serializing_if = "Option::is_none")]
        pub connectivity_endpoints: Option<ComputeInstanceConnectivityEndpoints>,
        #[doc = "Describes available applications and their endpoints on this ComputeInstance."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub applications: Vec<ComputeInstanceApplication>,
        #[doc = "Describes information on user who created this ComputeInstance."]
        #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
        pub created_by: Option<ComputeInstanceCreatedBy>,
        #[doc = "Collection of errors encountered on this ComputeInstance."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub errors: Vec<ErrorResponse>,
        #[doc = "Current state of an ComputeInstance."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<ComputeInstanceState>,
        #[doc = "The Compute Instance Authorization type. Available values are personal (default)."]
        #[serde(rename = "computeInstanceAuthorizationType", default, skip_serializing_if = "Option::is_none")]
        pub compute_instance_authorization_type: Option<properties::ComputeInstanceAuthorizationType>,
        #[doc = "Settings for a personal compute instance."]
        #[serde(rename = "personalComputeInstanceSettings", default, skip_serializing_if = "Option::is_none")]
        pub personal_compute_instance_settings: Option<PersonalComputeInstanceSettings>,
        #[doc = "Details of customized scripts to execute for setting up the cluster."]
        #[serde(rename = "setupScripts", default, skip_serializing_if = "Option::is_none")]
        pub setup_scripts: Option<SetupScripts>,
        #[doc = "The last operation on ComputeInstance."]
        #[serde(rename = "lastOperation", default, skip_serializing_if = "Option::is_none")]
        pub last_operation: Option<ComputeInstanceLastOperation>,
        #[doc = "The list of schedules to be applied on the computes"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub schedules: Option<ComputeSchedules>,
        #[doc = "Enable or disable node public IP address provisioning. Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs."]
        #[serde(rename = "enableNodePublicIp", default, skip_serializing_if = "Option::is_none")]
        pub enable_node_public_ip: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ApplicationSharingPolicy {
            Personal,
            Shared,
        }
        impl Default for ApplicationSharingPolicy {
            fn default() -> Self {
                Self::Shared
            }
        }
        #[doc = "The Compute Instance Authorization type. Available values are personal (default)."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ComputeInstanceAuthorizationType {
            #[serde(rename = "personal")]
            Personal,
        }
        impl Default for ComputeInstanceAuthorizationType {
            fn default() -> Self {
                Self::Personal
            }
        }
    }
}
#[doc = "Defines an Aml Instance application and its connectivity endpoint URI."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeInstanceApplication {
    #[doc = "Name of the ComputeInstance application."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Application' endpoint URI."]
    #[serde(rename = "endpointUri", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_uri: Option<String>,
}
impl ComputeInstanceApplication {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines all connectivity endpoints and properties for an ComputeInstance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeInstanceConnectivityEndpoints {
    #[doc = "Public IP Address of this ComputeInstance."]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[doc = "Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed)."]
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
}
impl ComputeInstanceConnectivityEndpoints {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes information on user who created this ComputeInstance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeInstanceCreatedBy {
    #[doc = "Name of the user."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[doc = "Uniquely identifies user' Azure Active Directory organization."]
    #[serde(rename = "userOrgId", default, skip_serializing_if = "Option::is_none")]
    pub user_org_id: Option<String>,
    #[doc = "Uniquely identifies the user within his/her organization."]
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
}
impl ComputeInstanceCreatedBy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The last operation on ComputeInstance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeInstanceLastOperation {
    #[doc = "Name of the last operation."]
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<compute_instance_last_operation::OperationName>,
    #[doc = "Time of the last operation."]
    #[serde(rename = "operationTime", default, skip_serializing_if = "Option::is_none")]
    pub operation_time: Option<String>,
    #[doc = "Operation status."]
    #[serde(rename = "operationStatus", default, skip_serializing_if = "Option::is_none")]
    pub operation_status: Option<compute_instance_last_operation::OperationStatus>,
}
impl ComputeInstanceLastOperation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod compute_instance_last_operation {
    use super::*;
    #[doc = "Name of the last operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationName {
        Create,
        Start,
        Stop,
        Restart,
        Reimage,
        Delete,
    }
    #[doc = "Operation status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationStatus {
        InProgress,
        Succeeded,
        CreateFailed,
        StartFailed,
        StopFailed,
        RestartFailed,
        ReimageFailed,
        DeleteFailed,
    }
}
#[doc = "Specifies policy and settings for SSH access."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeInstanceSshSettings {
    #[doc = "State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable."]
    #[serde(rename = "sshPublicAccess", default, skip_serializing_if = "Option::is_none")]
    pub ssh_public_access: Option<compute_instance_ssh_settings::SshPublicAccess>,
    #[doc = "Describes the admin user name."]
    #[serde(rename = "adminUserName", default, skip_serializing_if = "Option::is_none")]
    pub admin_user_name: Option<String>,
    #[doc = "Describes the port for connecting through SSH."]
    #[serde(rename = "sshPort", default, skip_serializing_if = "Option::is_none")]
    pub ssh_port: Option<i32>,
    #[doc = "Specifies the SSH rsa public key file as a string. Use \"ssh-keygen -t rsa -b 2048\" to generate your SSH key pairs."]
    #[serde(rename = "adminPublicKey", default, skip_serializing_if = "Option::is_none")]
    pub admin_public_key: Option<String>,
}
impl ComputeInstanceSshSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod compute_instance_ssh_settings {
    use super::*;
    #[doc = "State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SshPublicAccess {
        Enabled,
        Disabled,
    }
    impl Default for SshPublicAccess {
        fn default() -> Self {
            Self::Disabled
        }
    }
}
#[doc = "Current state of an ComputeInstance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ComputeInstanceState {
    Creating,
    CreateFailed,
    Deleting,
    Running,
    Restarting,
    JobRunning,
    SettingUp,
    SetupFailed,
    Starting,
    Stopped,
    Stopping,
    UserSettingUp,
    UserSetupFailed,
    Unknown,
    Unusable,
}
#[doc = "Compute nodes information related to a Machine Learning compute. Might differ for every type of compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ComputeNodesInformation {
    #[doc = "The type of compute"]
    #[serde(rename = "computeType")]
    pub compute_type: ComputeType,
    #[doc = "The continuation token."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ComputeNodesInformation {
    pub fn new(compute_type: ComputeType) -> Self {
        Self {
            compute_type,
            next_link: None,
        }
    }
}
#[doc = "The compute power action."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ComputePowerAction {
    Start,
    Stop,
}
#[doc = "Machine Learning compute object wrapped into ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Machine Learning compute object."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Compute>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<Identity>,
    #[doc = "Specifies the location of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Contains resource tags defined as key/value pairs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Sku of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ComputeResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The list of schedules to be applied on the computes"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeSchedules {
    #[doc = "The list of compute start stop schedules to be applied."]
    #[serde(rename = "computeStartStop", default, skip_serializing_if = "Vec::is_empty")]
    pub compute_start_stop: Vec<ComputeStartStopSchedule>,
}
impl ComputeSchedules {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Secrets related to a Machine Learning compute. Might differ for every type of compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ComputeSecrets {
    #[doc = "The type of compute"]
    #[serde(rename = "computeType")]
    pub compute_type: ComputeType,
}
impl ComputeSecrets {
    pub fn new(compute_type: ComputeType) -> Self {
        Self { compute_type }
    }
}
#[doc = "Compute start stop schedule properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeStartStopSchedule {
    #[doc = "Schedule id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The current deployment state of schedule."]
    #[serde(rename = "provisioningStatus", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_status: Option<compute_start_stop_schedule::ProvisioningStatus>,
    #[doc = "The schedule status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<ScheduleStatus>,
    #[doc = "The schedule trigger type."]
    #[serde(rename = "triggerType", default, skip_serializing_if = "Option::is_none")]
    pub trigger_type: Option<TriggerType>,
    #[doc = "The compute power action."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<ComputePowerAction>,
    #[doc = "The workflow trigger recurrence for ComputeStartStop schedule type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recurrence: Option<Recurrence>,
    #[doc = "The workflow trigger cron for ComputeStartStop schedule type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cron: Option<Cron>,
}
impl ComputeStartStopSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod compute_start_stop_schedule {
    use super::*;
    #[doc = "The current deployment state of schedule."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningStatus {
        Completed,
        Provisioning,
        Failed,
    }
}
#[doc = "The type of compute"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ComputeType {
    #[serde(rename = "AKS")]
    Aks,
    AmlCompute,
    ComputeInstance,
    DataFactory,
    VirtualMachine,
    #[serde(rename = "HDInsight")]
    HdInsight,
    Databricks,
    DataLakeAnalytics,
    SynapseSpark,
}
#[doc = "The resource requirements for the container (cpu and memory)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerResourceRequirements {
    #[doc = "The minimum amount of CPU cores to be used by the container. More info:\nhttps://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cpu: Option<f64>,
    #[doc = "The maximum amount of CPU cores allowed to be used by the container. More info:\nhttps://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/"]
    #[serde(rename = "cpuLimit", default, skip_serializing_if = "Option::is_none")]
    pub cpu_limit: Option<f64>,
    #[doc = "The minimum amount of memory (in GB) to be used by the container. More info:\nhttps://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/"]
    #[serde(rename = "memoryInGB", default, skip_serializing_if = "Option::is_none")]
    pub memory_in_gb: Option<f64>,
    #[doc = "The maximum amount of memory (in GB) allowed to be used by the container. More info:\nhttps://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/"]
    #[serde(rename = "memoryInGBLimit", default, skip_serializing_if = "Option::is_none")]
    pub memory_in_gb_limit: Option<f64>,
    #[doc = "The number of GPU cores in the container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub gpu: Option<i32>,
    #[doc = "The number of FPGA PCIE devices exposed to the container. Must be multiple of 2."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fpga: Option<i32>,
}
impl ContainerResourceRequirements {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ContainerType {
    StorageInitializer,
    InferenceServer,
}
#[doc = "Enum to determine the datastore contents type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ContentsType {
    AzureBlob,
    AzureDataLakeGen1,
    AzureDataLakeGen2,
    AzureFile,
    AzureMySql,
    AzurePostgreSql,
    AzureSqlDatabase,
    GlusterFs,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CosmosDbSettings {
    #[doc = "The throughput of the collections in cosmosdb database"]
    #[serde(rename = "collectionsThroughput", default, skip_serializing_if = "Option::is_none")]
    pub collections_throughput: Option<i32>,
}
impl CosmosDbSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Enum to determine the datastore credentials type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CredentialsType {
    AccountKey,
    Certificate,
    None,
    Sas,
    ServicePrincipal,
    SqlAdmin,
}
#[doc = "The workflow trigger cron for ComputeStartStop schedule type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Cron {
    #[doc = "The start time."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The time zone."]
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[doc = "The cron expression."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expression: Option<String>,
}
impl Cron {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CsvExportSummary {
    #[serde(flatten)]
    pub export_summary: ExportSummary,
    #[doc = "The container name to which the labels will be exported."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The output path where the labels will be exported."]
    #[serde(rename = "snapshotPath", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_path: Option<String>,
}
impl CsvExportSummary {
    pub fn new(export_summary: ExportSummary) -> Self {
        Self {
            export_summary,
            container_name: None,
            snapshot_path: None,
        }
    }
}
#[doc = "Describes how the data should be attached to the container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DataBindingMode {
    Mount,
    Download,
    Upload,
}
#[doc = "Container for data asset versions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataContainer {
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl DataContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Container for data asset versions."]
    pub properties: DataContainer,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl DataContainerResource {
    pub fn new(properties: DataContainer) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of DataContainer entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataContainerResourceArmPaginatedResult {
    #[doc = "The link to the next page of DataContainer objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type DataContainer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DataContainerResource>,
}
impl DataContainerResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A DataFactory compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFactory {
    #[serde(flatten)]
    pub compute: Compute,
}
impl DataFactory {
    pub fn new(compute: Compute) -> Self {
        Self { compute }
    }
}
#[doc = "A DataLakeAnalytics compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataLakeAnalytics {
    #[serde(flatten)]
    pub compute: Compute,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<data_lake_analytics::Properties>,
}
impl DataLakeAnalytics {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod data_lake_analytics {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "DataLake Store Account Name"]
        #[serde(rename = "dataLakeStoreAccountName", default, skip_serializing_if = "Option::is_none")]
        pub data_lake_store_account_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Reference to an asset via its path in a datastore."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataPathAssetReference {
    #[serde(flatten)]
    pub asset_reference_base: AssetReferenceBase,
    #[doc = "ARM resource ID of the datastore where the asset is located."]
    #[serde(rename = "datastoreId", default, skip_serializing_if = "Option::is_none")]
    pub datastore_id: Option<String>,
    #[doc = "The path of the file/directory in the datastore."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl DataPathAssetReference {
    pub fn new(asset_reference_base: AssetReferenceBase) -> Self {
        Self {
            asset_reference_base,
            datastore_id: None,
            path: None,
        }
    }
}
#[doc = "Data asset version details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataVersion {
    #[serde(rename = "datasetType", default, skip_serializing_if = "Option::is_none")]
    pub dataset_type: Option<DatasetType>,
    #[doc = "ARM resource ID of the datastore where the asset is located."]
    #[serde(rename = "datastoreId", default, skip_serializing_if = "Option::is_none")]
    pub datastore_id: Option<String>,
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "If the name version are system generated (anonymous registration)."]
    #[serde(rename = "isAnonymous", default, skip_serializing_if = "Option::is_none")]
    pub is_anonymous: Option<bool>,
    #[doc = "The path of the file/directory in the datastore."]
    pub path: String,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl DataVersion {
    pub fn new(path: String) -> Self {
        Self {
            dataset_type: None,
            datastore_id: None,
            description: None,
            is_anonymous: None,
            path,
            properties: None,
            tags: None,
        }
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataVersionResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Data asset version details."]
    pub properties: DataVersion,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl DataVersionResource {
    pub fn new(properties: DataVersion) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of DataVersion entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataVersionResourceArmPaginatedResult {
    #[doc = "The link to the next page of DataVersion objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type DataVersion."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DataVersionResource>,
}
impl DataVersionResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A DataFactory compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Databricks {
    #[serde(flatten)]
    pub compute: Compute,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<databricks::Properties>,
}
impl Databricks {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod databricks {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Databricks access token"]
        #[serde(rename = "databricksAccessToken", default, skip_serializing_if = "Option::is_none")]
        pub databricks_access_token: Option<String>,
        #[doc = "Workspace Url"]
        #[serde(rename = "workspaceUrl", default, skip_serializing_if = "Option::is_none")]
        pub workspace_url: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Secrets related to a Machine Learning compute based on Databricks."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksComputeSecrets {
    #[serde(flatten)]
    pub compute_secrets: ComputeSecrets,
    #[doc = "access token for databricks account."]
    #[serde(rename = "databricksAccessToken", default, skip_serializing_if = "Option::is_none")]
    pub databricks_access_token: Option<String>,
}
impl DatabricksComputeSecrets {
    pub fn new(compute_secrets: ComputeSecrets) -> Self {
        Self {
            compute_secrets,
            databricks_access_token: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetExportSummary {
    #[serde(flatten)]
    pub export_summary: ExportSummary,
    #[doc = "The unique name of the labeled data asset."]
    #[serde(rename = "labeledAssetName", default, skip_serializing_if = "Option::is_none")]
    pub labeled_asset_name: Option<String>,
}
impl DatasetExportSummary {
    pub fn new(export_summary: ExportSummary) -> Self {
        Self {
            export_summary,
            labeled_asset_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DatasetType {
    Simple,
    Dataflow,
}
#[doc = "Base definition for datastore contents configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatastoreContents {
    #[doc = "Enum to determine the datastore contents type."]
    #[serde(rename = "contentsType")]
    pub contents_type: ContentsType,
}
impl DatastoreContents {
    pub fn new(contents_type: ContentsType) -> Self {
        Self { contents_type }
    }
}
#[doc = "Base definition for datastore credentials."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatastoreCredentials {
    #[doc = "Enum to determine the datastore credentials type."]
    #[serde(rename = "credentialsType")]
    pub credentials_type: CredentialsType,
}
impl DatastoreCredentials {
    pub fn new(credentials_type: CredentialsType) -> Self {
        Self { credentials_type }
    }
}
#[doc = "Datastore definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatastoreProperties {
    #[doc = "Base definition for datastore contents configuration."]
    pub contents: DatastoreContents,
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Whether the service has validated access to the datastore with the provided credentials."]
    #[serde(rename = "hasBeenValidated", default, skip_serializing_if = "Option::is_none")]
    pub has_been_validated: Option<bool>,
    #[doc = "Whether this datastore is the default for the workspace."]
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[doc = "Information about a datastore origin, if linked."]
    #[serde(rename = "linkedInfo", default, skip_serializing_if = "Option::is_none")]
    pub linked_info: Option<LinkedInfo>,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl DatastoreProperties {
    pub fn new(contents: DatastoreContents) -> Self {
        Self {
            contents,
            description: None,
            has_been_validated: None,
            is_default: None,
            linked_info: None,
            properties: None,
            tags: None,
        }
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatastorePropertiesResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Datastore definition."]
    pub properties: DatastoreProperties,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl DatastorePropertiesResource {
    pub fn new(properties: DatastoreProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of DatastoreProperties entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatastorePropertiesResourceArmPaginatedResult {
    #[doc = "The link to the next page of DatastoreProperties objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type DatastoreProperties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DatastorePropertiesResource>,
}
impl DatastorePropertiesResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base definition for datastore secrets."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatastoreSecrets {
    #[doc = "Enum to determine the datastore secrets type."]
    #[serde(rename = "secretsType")]
    pub secrets_type: SecretsType,
}
impl DatastoreSecrets {
    pub fn new(secrets_type: SecretsType) -> Self {
        Self { secrets_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentLogs {
    #[doc = "The retrieved online deployment logs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
}
impl DeploymentLogs {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentLogsRequest {
    #[serde(rename = "containerType", default, skip_serializing_if = "Option::is_none")]
    pub container_type: Option<ContainerType>,
    #[doc = "The maximum number of lines to tail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tail: Option<i32>,
}
impl DeploymentLogsRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DeploymentProvisioningState {
    Creating,
    Deleting,
    Scaling,
    Updating,
    Succeeded,
    Failed,
    Canceled,
}
#[doc = "Base definition for job distribution configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DistributionConfiguration {
    #[doc = "Enum to determine the job distribution type."]
    #[serde(rename = "distributionType")]
    pub distribution_type: DistributionType,
}
impl DistributionConfiguration {
    pub fn new(distribution_type: DistributionType) -> Self {
        Self { distribution_type }
    }
}
#[doc = "Enum to determine the job distribution type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DistributionType {
    PyTorch,
    TensorFlow,
    Mpi,
}
#[doc = "Class to represent configuration settings for Docker Build"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DockerBuild {
    #[serde(flatten)]
    pub docker_specification: DockerSpecification,
    #[doc = "Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.\r\nThe path is relative to the asset path which must contain a single Blob URI value.\r\n<seealso href=\"https://docs.docker.com/engine/context/working-with-contexts/\" />"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub context: Option<String>,
    #[doc = "Docker command line instructions to assemble an image.\r\n<seealso href=\"https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments\" />"]
    pub dockerfile: String,
}
impl DockerBuild {
    pub fn new(docker_specification: DockerSpecification, dockerfile: String) -> Self {
        Self {
            docker_specification,
            context: None,
            dockerfile,
        }
    }
}
#[doc = "Class to represent configuration settings for Docker Build"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DockerImage {
    #[serde(flatten)]
    pub docker_specification: DockerSpecification,
    #[doc = "Image name of a custom base image.\r\n<seealso href=\"https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image\" />"]
    #[serde(rename = "dockerImageUri")]
    pub docker_image_uri: String,
}
impl DockerImage {
    pub fn new(docker_specification: DockerSpecification, docker_image_uri: String) -> Self {
        Self {
            docker_specification,
            docker_image_uri,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DockerImagePlatform {
    #[doc = "The type of operating system."]
    #[serde(rename = "operatingSystemType", default, skip_serializing_if = "Option::is_none")]
    pub operating_system_type: Option<OperatingSystemType>,
}
impl DockerImagePlatform {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configuration settings for Docker"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DockerSpecification {
    #[doc = "Enum to determine docker specification type. Must be either Build or Image."]
    #[serde(rename = "dockerSpecificationType")]
    pub docker_specification_type: DockerSpecificationType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub platform: Option<DockerImagePlatform>,
}
impl DockerSpecification {
    pub fn new(docker_specification_type: DockerSpecificationType) -> Self {
        Self {
            docker_specification_type,
            platform: None,
        }
    }
}
#[doc = "Enum to determine docker specification type. Must be either Build or Image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DockerSpecificationType {
    Build,
    Image,
}
#[doc = "Early termination policies enable canceling poor-performing runs before they complete."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EarlyTerminationPolicy {
    #[doc = "Number of intervals by which to delay the first evaluation."]
    #[serde(rename = "delayEvaluation", default, skip_serializing_if = "Option::is_none")]
    pub delay_evaluation: Option<i32>,
    #[doc = "Interval (number of runs) between policy evaluations."]
    #[serde(rename = "evaluationInterval", default, skip_serializing_if = "Option::is_none")]
    pub evaluation_interval: Option<i32>,
    #[serde(rename = "policyType")]
    pub policy_type: EarlyTerminationPolicyType,
}
impl EarlyTerminationPolicy {
    pub fn new(policy_type: EarlyTerminationPolicyType) -> Self {
        Self {
            delay_evaluation: None,
            evaluation_interval: None,
            policy_type,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EarlyTerminationPolicyType {
    Bandit,
    MedianStopping,
    TruncationSelection,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptionProperty {
    #[doc = "Indicates whether or not the encryption is enabled for the workspace."]
    pub status: encryption_property::Status,
    #[doc = "Identity that will be used to access key vault for encryption at rest"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityForCmk>,
    #[serde(rename = "keyVaultProperties")]
    pub key_vault_properties: KeyVaultProperties,
}
impl EncryptionProperty {
    pub fn new(status: encryption_property::Status, key_vault_properties: KeyVaultProperties) -> Self {
        Self {
            status,
            identity: None,
            key_vault_properties,
        }
    }
}
pub mod encryption_property {
    use super::*;
    #[doc = "Indicates whether or not the encryption is enabled for the workspace."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
}
#[doc = "Keys for endpoint authentication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointAuthKeys {
    #[doc = "The primary key."]
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[doc = "The secondary key."]
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
}
impl EndpointAuthKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Enum to determine endpoint authentication mode."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EndpointAuthMode {
    #[serde(rename = "AMLToken")]
    AmlToken,
    Key,
    #[serde(rename = "AADToken")]
    AadToken,
}
#[doc = "Service Token"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointAuthToken {
    #[doc = "Access token."]
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<String>,
    #[doc = "Access token expiry time (UTC)."]
    #[serde(rename = "expiryTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub expiry_time_utc: Option<i64>,
    #[doc = "Refresh access token after time (UTC)."]
    #[serde(rename = "refreshAfterTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub refresh_after_time_utc: Option<i64>,
    #[doc = "Access token type."]
    #[serde(rename = "tokenType", default, skip_serializing_if = "Option::is_none")]
    pub token_type: Option<String>,
}
impl EndpointAuthToken {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Enum to determine endpoint compute type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EndpointComputeType {
    Managed,
    #[serde(rename = "K8S")]
    K8s,
    #[serde(rename = "AzureMLCompute")]
    AzureMlCompute,
}
#[doc = "State of endpoint provisioning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EndpointProvisioningState {
    Creating,
    Deleting,
    Succeeded,
    Failed,
    Updating,
    Canceled,
}
#[doc = "Container for environment specification versions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentContainer {
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl EnvironmentContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Container for environment specification versions."]
    pub properties: EnvironmentContainer,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl EnvironmentContainerResource {
    pub fn new(properties: EnvironmentContainer) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of EnvironmentContainer entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentContainerResourceArmPaginatedResult {
    #[doc = "The link to the next page of EnvironmentContainer objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type EnvironmentContainer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EnvironmentContainerResource>,
}
impl EnvironmentContainerResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Environment specification is either user created or curated by Azure ML service"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EnvironmentSpecificationType {
    Curated,
    UserCreated,
}
#[doc = "Environment specification version details.\r\n<see href=\"https://repo2docker.readthedocs.io/en/latest/specification.html\" />"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentSpecificationVersion {
    #[doc = "Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.\r\n<see href=\"https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment\" />"]
    #[serde(rename = "condaFile", default, skip_serializing_if = "Option::is_none")]
    pub conda_file: Option<String>,
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Configuration settings for Docker"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub docker: Option<DockerSpecification>,
    #[doc = "Environment specification is either user created or curated by Azure ML service"]
    #[serde(rename = "environmentSpecificationType", default, skip_serializing_if = "Option::is_none")]
    pub environment_specification_type: Option<EnvironmentSpecificationType>,
    #[serde(rename = "inferenceContainerProperties", default, skip_serializing_if = "Option::is_none")]
    pub inference_container_properties: Option<InferenceContainerProperties>,
    #[doc = "If the name version are system generated (anonymous registration)."]
    #[serde(rename = "isAnonymous", default, skip_serializing_if = "Option::is_none")]
    pub is_anonymous: Option<bool>,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl EnvironmentSpecificationVersion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentSpecificationVersionResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Environment specification version details.\r\n<see href=\"https://repo2docker.readthedocs.io/en/latest/specification.html\" />"]
    pub properties: EnvironmentSpecificationVersion,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl EnvironmentSpecificationVersionResource {
    pub fn new(properties: EnvironmentSpecificationVersion) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of EnvironmentSpecificationVersion entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentSpecificationVersionResourceArmPaginatedResult {
    #[doc = "The link to the next page of EnvironmentSpecificationVersion objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type EnvironmentSpecificationVersion."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EnvironmentSpecificationVersionResource>,
}
impl EnvironmentSpecificationVersionResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The error detail."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetail {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetail>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "The error detail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetail>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The estimated price info for using a VM of a particular OS type, tier, etc."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EstimatedVmPrice {
    #[doc = "The price charged for using the VM."]
    #[serde(rename = "retailPrice")]
    pub retail_price: f64,
    #[doc = "Operating system type used by the VM."]
    #[serde(rename = "osType")]
    pub os_type: estimated_vm_price::OsType,
    #[doc = "The type of the VM."]
    #[serde(rename = "vmTier")]
    pub vm_tier: estimated_vm_price::VmTier,
}
impl EstimatedVmPrice {
    pub fn new(retail_price: f64, os_type: estimated_vm_price::OsType, vm_tier: estimated_vm_price::VmTier) -> Self {
        Self {
            retail_price,
            os_type,
            vm_tier,
        }
    }
}
pub mod estimated_vm_price {
    use super::*;
    #[doc = "Operating system type used by the VM."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Linux,
        Windows,
    }
    #[doc = "The type of the VM."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VmTier {
        Standard,
        LowPriority,
        Spot,
    }
}
#[doc = "The estimated price info for using a VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EstimatedVmPrices {
    #[doc = "Three lettered code specifying the currency of the VM price. Example: USD"]
    #[serde(rename = "billingCurrency")]
    pub billing_currency: estimated_vm_prices::BillingCurrency,
    #[doc = "The unit of time measurement for the specified VM price. Example: OneHour"]
    #[serde(rename = "unitOfMeasure")]
    pub unit_of_measure: estimated_vm_prices::UnitOfMeasure,
    #[doc = "The list of estimated prices for using a VM of a particular OS type, tier, etc."]
    pub values: Vec<EstimatedVmPrice>,
}
impl EstimatedVmPrices {
    pub fn new(
        billing_currency: estimated_vm_prices::BillingCurrency,
        unit_of_measure: estimated_vm_prices::UnitOfMeasure,
        values: Vec<EstimatedVmPrice>,
    ) -> Self {
        Self {
            billing_currency,
            unit_of_measure,
            values,
        }
    }
}
pub mod estimated_vm_prices {
    use super::*;
    #[doc = "Three lettered code specifying the currency of the VM price. Example: USD"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BillingCurrency {
        #[serde(rename = "USD")]
        Usd,
    }
    #[doc = "The unit of time measurement for the specified VM price. Example: OneHour"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UnitOfMeasure {
        OneHour,
    }
}
#[doc = "The format of exported labels."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ExportFormatType {
    Dataset,
    Coco,
    #[serde(rename = "CSV")]
    Csv,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportSummary {
    #[doc = "The time when the export was completed."]
    #[serde(rename = "endTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub end_time_utc: Option<String>,
    #[doc = "The total number of labeled datapoints exported."]
    #[serde(rename = "exportedRowCount", default, skip_serializing_if = "Option::is_none")]
    pub exported_row_count: Option<i64>,
    #[doc = "The format of exported labels."]
    pub format: ExportFormatType,
    #[doc = "Name and identifier of the job containing exported labels."]
    #[serde(rename = "labelingJobId", default, skip_serializing_if = "Option::is_none")]
    pub labeling_job_id: Option<String>,
    #[doc = "The time when the export was requested."]
    #[serde(rename = "startTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub start_time_utc: Option<String>,
}
impl ExportSummary {
    pub fn new(format: ExportFormatType) -> Self {
        Self {
            end_time_utc: None,
            exported_row_count: None,
            format,
            labeling_job_id: None,
            start_time_utc: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FlavorData {
    #[doc = "Model flavor-specific data."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<serde_json::Value>,
}
impl FlavorData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "GlusterFs datastore configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GlusterFsContents {
    #[serde(flatten)]
    pub datastore_contents: DatastoreContents,
    #[doc = "GlusterFS server address (can be the IP address or server name)."]
    #[serde(rename = "serverAddress")]
    pub server_address: String,
    #[doc = "GlusterFS volume name."]
    #[serde(rename = "volumeName")]
    pub volume_name: String,
}
impl GlusterFsContents {
    pub fn new(datastore_contents: DatastoreContents, server_address: String, volume_name: String) -> Self {
        Self {
            datastore_contents,
            server_address,
            volume_name,
        }
    }
}
#[doc = "Defines supported metric goals for hyperparameter tuning"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Goal {
    Minimize,
    Maximize,
}
#[doc = "A HDInsight compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsight {
    #[serde(flatten)]
    pub compute: Compute,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hd_insight::Properties>,
}
impl HdInsight {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod hd_insight {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Port open for ssh connections on the master node of the cluster."]
        #[serde(rename = "sshPort", default, skip_serializing_if = "Option::is_none")]
        pub ssh_port: Option<i32>,
        #[doc = "Public IP address of the master node of the cluster."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub address: Option<String>,
        #[doc = "Admin credentials for virtual machine"]
        #[serde(rename = "administratorAccount", default, skip_serializing_if = "Option::is_none")]
        pub administrator_account: Option<VirtualMachineSshCredentials>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Reference to an asset via its ARM resource ID."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IdAssetReference {
    #[serde(flatten)]
    pub asset_reference_base: AssetReferenceBase,
    #[doc = "ARM resource ID of the asset."]
    #[serde(rename = "assetId")]
    pub asset_id: String,
}
impl IdAssetReference {
    pub fn new(asset_reference_base: AssetReferenceBase, asset_id: String) -> Self {
        Self {
            asset_reference_base,
            asset_id,
        }
    }
}
#[doc = "Identity for the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Identity {
    #[doc = "The principal ID of resource identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The tenant ID of resource."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The identity type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity::Type>,
    #[doc = "dictionary containing all the user assigned identities, with resourceId of the UAI as key."]
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<UserAssignedIdentities>,
}
impl Identity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity {
    use super::*;
    #[doc = "The identity type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        #[serde(rename = "SystemAssigned,UserAssigned")]
        SystemAssignedUserAssigned,
        UserAssigned,
        None,
    }
}
#[doc = "Base definition for identity configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IdentityConfiguration {
    #[doc = "Enum to determine identity framework."]
    #[serde(rename = "identityType")]
    pub identity_type: IdentityConfigurationType,
}
impl IdentityConfiguration {
    pub fn new(identity_type: IdentityConfigurationType) -> Self {
        Self { identity_type }
    }
}
#[doc = "Enum to determine identity framework."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IdentityConfigurationType {
    Managed,
    #[serde(rename = "AMLToken")]
    AmlToken,
}
#[doc = "Identity that will be used to access key vault for encryption at rest"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityForCmk {
    #[doc = "The ArmId of the user assigned identity that will be used to access the customer managed key vault"]
    #[serde(rename = "userAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identity: Option<String>,
}
impl IdentityForCmk {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Annotation type of image data."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ImageAnnotationType {
    Classification,
    BoundingBox,
    InstanceSegmentation,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InferenceContainerProperties {
    #[serde(rename = "livenessRoute", default, skip_serializing_if = "Option::is_none")]
    pub liveness_route: Option<Route>,
    #[serde(rename = "readinessRoute", default, skip_serializing_if = "Option::is_none")]
    pub readiness_route: Option<Route>,
    #[serde(rename = "scoringRoute", default, skip_serializing_if = "Option::is_none")]
    pub scoring_route: Option<Route>,
}
impl InferenceContainerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InputDataBinding {
    #[doc = "ARM resource ID of the registered dataVersion."]
    #[serde(rename = "dataId", default, skip_serializing_if = "Option::is_none")]
    pub data_id: Option<String>,
    #[doc = "Describes how the data should be attached to the container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<DataBindingMode>,
    #[doc = "Location of data inside the container process."]
    #[serde(rename = "pathOnCompute", default, skip_serializing_if = "Option::is_none")]
    pub path_on_compute: Option<String>,
}
impl InputDataBinding {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base definition for a job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobBase {
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "List of JobEndpoints.\r\nFor local jobs, a job endpoint will have an endpoint value of FileStreamObject."]
    #[serde(rename = "interactionEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub interaction_endpoints: Option<serde_json::Value>,
    #[doc = "Enum to determine the type of job."]
    #[serde(rename = "jobType")]
    pub job_type: JobType,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<JobProvisioningState>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl JobBase {
    pub fn new(job_type: JobType) -> Self {
        Self {
            description: None,
            interaction_endpoints: None,
            job_type,
            properties: None,
            provisioning_state: None,
            tags: None,
        }
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobBaseResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Base definition for a job."]
    pub properties: JobBase,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl JobBaseResource {
    pub fn new(properties: JobBase) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of JobBase entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobBaseResourceArmPaginatedResult {
    #[doc = "The link to the next page of JobBase objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type JobBase."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobBaseResource>,
}
impl JobBaseResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Job endpoint definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobEndpoint {
    #[doc = "Url for endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
    #[doc = "Endpoint type."]
    #[serde(rename = "jobEndpointType", default, skip_serializing_if = "Option::is_none")]
    pub job_endpoint_type: Option<String>,
    #[doc = "Port for endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "Additional properties to set on the endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl JobEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Job output definition container information on where to find job output/logs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobOutput {
    #[doc = "ARM ID of the datastore where the job logs and artifacts are stored, or null for the default container (\"azureml\") in the workspace's storage account."]
    #[serde(rename = "datastoreId", default, skip_serializing_if = "Option::is_none")]
    pub datastore_id: Option<String>,
    #[doc = "Path within the datastore to the job logs and artifacts."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl JobOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JobProvisioningState {
    Succeeded,
    Failed,
    Canceled,
    InProgress,
}
#[doc = "The status of a job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JobStatus {
    NotStarted,
    Starting,
    Provisioning,
    Preparing,
    Queued,
    Running,
    Finalizing,
    CancelRequested,
    Completed,
    Failed,
    Canceled,
    NotResponding,
    Paused,
    Unknown,
}
#[doc = "Enum to determine the type of job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JobType {
    Command,
    Sweep,
    Labeling,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct K8sOnlineDeployment {
    #[serde(flatten)]
    pub online_deployment: OnlineDeployment,
    #[doc = "The resource requirements for the container (cpu and memory)."]
    #[serde(rename = "containerResourceRequirements", default, skip_serializing_if = "Option::is_none")]
    pub container_resource_requirements: Option<ContainerResourceRequirements>,
}
impl K8sOnlineDeployment {
    pub fn new(online_deployment: OnlineDeployment) -> Self {
        Self {
            online_deployment,
            container_resource_requirements: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum KeyType {
    Primary,
    Secondary,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultProperties {
    #[doc = "The ArmId of the keyVault where the customer owned encryption key is present."]
    #[serde(rename = "keyVaultArmId")]
    pub key_vault_arm_id: String,
    #[doc = "Key vault uri to access the encryption key."]
    #[serde(rename = "keyIdentifier")]
    pub key_identifier: String,
    #[doc = "For future use - The client id of the identity which will be used to access key vault."]
    #[serde(rename = "identityClientId", default, skip_serializing_if = "Option::is_none")]
    pub identity_client_id: Option<String>,
}
impl KeyVaultProperties {
    pub fn new(key_vault_arm_id: String, key_identifier: String) -> Self {
        Self {
            key_vault_arm_id,
            key_identifier,
            identity_client_id: None,
        }
    }
}
#[doc = "Label category definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabelCategory {
    #[doc = "Indicates whether it is allowed to select multiple classes in this category."]
    #[serde(rename = "allowMultiSelect", default, skip_serializing_if = "Option::is_none")]
    pub allow_multi_select: Option<bool>,
    #[doc = "Dictionary of label classes in this category."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub classes: Option<serde_json::Value>,
    #[doc = "Display name of the label category."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl LabelCategory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Label class definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabelClass {
    #[doc = "Display name of the label class."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Dictionary of subclasses of the label class."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subclasses: Option<serde_json::Value>,
}
impl LabelClass {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Labeling dataset configuration definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabelingDatasetConfiguration {
    #[doc = "Name of the data asset to perform labeling."]
    #[serde(rename = "assetName", default, skip_serializing_if = "Option::is_none")]
    pub asset_name: Option<String>,
    #[doc = "AML dataset version."]
    #[serde(rename = "datasetVersion", default, skip_serializing_if = "Option::is_none")]
    pub dataset_version: Option<String>,
    #[doc = "Indicates whether to enable incremental dataset refresh."]
    #[serde(rename = "incrementalDatasetRefreshEnabled", default, skip_serializing_if = "Option::is_none")]
    pub incremental_dataset_refresh_enabled: Option<bool>,
}
impl LabelingDatasetConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Labeling job definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LabelingJob {
    #[doc = "Created time of the job in UTC timezone."]
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[doc = "Labeling dataset configuration definition"]
    #[serde(rename = "datasetConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub dataset_configuration: Option<LabelingDatasetConfiguration>,
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "List of JobEndpoints.\r\nFor local jobs, a job endpoint will have an endpoint value of FileStreamObject."]
    #[serde(rename = "interactionEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub interaction_endpoints: Option<serde_json::Value>,
    #[doc = "Instructions for labeling job"]
    #[serde(rename = "jobInstructions", default, skip_serializing_if = "Option::is_none")]
    pub job_instructions: Option<LabelingJobInstructions>,
    #[doc = "Enum to determine the type of job."]
    #[serde(rename = "jobType")]
    pub job_type: JobType,
    #[doc = "Label categories of the job."]
    #[serde(rename = "labelCategories", default, skip_serializing_if = "Option::is_none")]
    pub label_categories: Option<serde_json::Value>,
    #[doc = "Properties of a labeling job"]
    #[serde(rename = "labelingJobMediaProperties", default, skip_serializing_if = "Option::is_none")]
    pub labeling_job_media_properties: Option<LabelingJobMediaProperties>,
    #[doc = "Labeling MLAssist configuration definition"]
    #[serde(rename = "mlAssistConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ml_assist_configuration: Option<MlAssistConfiguration>,
    #[doc = "Progress metrics definition"]
    #[serde(rename = "progressMetrics", default, skip_serializing_if = "Option::is_none")]
    pub progress_metrics: Option<ProgressMetrics>,
    #[doc = "Internal id of the job(Previously called project)."]
    #[serde(rename = "projectId", default, skip_serializing_if = "Option::is_none")]
    pub project_id: Option<String>,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<JobProvisioningState>,
    #[doc = "The status of a job."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<JobStatus>,
    #[doc = "Status messages of the job."]
    #[serde(rename = "statusMessages", default, skip_serializing_if = "Vec::is_empty")]
    pub status_messages: Vec<StatusMessage>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl LabelingJob {
    pub fn new(job_type: JobType) -> Self {
        Self {
            created_time_utc: None,
            dataset_configuration: None,
            description: None,
            interaction_endpoints: None,
            job_instructions: None,
            job_type,
            label_categories: None,
            labeling_job_media_properties: None,
            ml_assist_configuration: None,
            progress_metrics: None,
            project_id: None,
            properties: None,
            provisioning_state: None,
            status: None,
            status_messages: Vec::new(),
            tags: None,
        }
    }
}
#[doc = "Properties of a labeling job for image data"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LabelingJobImageProperties {
    #[serde(flatten)]
    pub labeling_job_media_properties: LabelingJobMediaProperties,
    #[doc = "Annotation type of image data."]
    #[serde(rename = "annotationType", default, skip_serializing_if = "Option::is_none")]
    pub annotation_type: Option<ImageAnnotationType>,
}
impl LabelingJobImageProperties {
    pub fn new(labeling_job_media_properties: LabelingJobMediaProperties) -> Self {
        Self {
            labeling_job_media_properties,
            annotation_type: None,
        }
    }
}
#[doc = "Instructions for labeling job"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabelingJobInstructions {
    #[doc = "The link to a page with detailed labeling instructions for labelers."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
}
impl LabelingJobInstructions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a labeling job"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LabelingJobMediaProperties {
    #[doc = "Media type of data asset."]
    #[serde(rename = "mediaType")]
    pub media_type: MediaType,
}
impl LabelingJobMediaProperties {
    pub fn new(media_type: MediaType) -> Self {
        Self { media_type }
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LabelingJobResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Labeling job definition"]
    pub properties: LabelingJob,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl LabelingJobResource {
    pub fn new(properties: LabelingJob) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of LabelingJob entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabelingJobResourceArmPaginatedResult {
    #[doc = "The link to the next page of LabelingJob objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type LabelingJob."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LabelingJobResource>,
}
impl LabelingJobResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a labeling job for text data"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LabelingJobTextProperties {
    #[serde(flatten)]
    pub labeling_job_media_properties: LabelingJobMediaProperties,
    #[doc = "Annotation type of text data."]
    #[serde(rename = "annotationType", default, skip_serializing_if = "Option::is_none")]
    pub annotation_type: Option<TextAnnotationType>,
}
impl LabelingJobTextProperties {
    pub fn new(labeling_job_media_properties: LabelingJobMediaProperties) -> Self {
        Self {
            labeling_job_media_properties,
            annotation_type: None,
        }
    }
}
#[doc = "Information about a datastore origin, if linked."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkedInfo {
    #[doc = "Linked service ID."]
    #[serde(rename = "linkedId", default, skip_serializing_if = "Option::is_none")]
    pub linked_id: Option<String>,
    #[doc = "Linked service resource name."]
    #[serde(rename = "linkedResourceName", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_name: Option<String>,
    #[doc = "Enum to determine the type of linked service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<OriginType>,
}
impl LinkedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Aml user feature operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListAmlUserFeatureResult {
    #[doc = "The list of AML user facing features."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AmlUserFeature>,
    #[doc = "The URI to fetch the next page of AML user features information. Call ListNext() with this to fetch the next page of AML user features information."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListAmlUserFeatureResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListNotebookKeysResult {
    #[serde(rename = "primaryAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_access_key: Option<String>,
    #[serde(rename = "secondaryAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_access_key: Option<String>,
}
impl ListNotebookKeysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListStorageAccountKeysResult {
    #[serde(rename = "userStorageKey", default, skip_serializing_if = "Option::is_none")]
    pub user_storage_key: Option<String>,
}
impl ListStorageAccountKeysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Usages operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListUsagesResult {
    #[doc = "The list of AML resource usages."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
    #[doc = "The URI to fetch the next page of AML resource usage information. Call ListNext() with this to fetch the next page of AML resource usage information."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListUsagesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListWorkspaceKeysResult {
    #[serde(rename = "userStorageKey", default, skip_serializing_if = "Option::is_none")]
    pub user_storage_key: Option<String>,
    #[serde(rename = "userStorageResourceId", default, skip_serializing_if = "Option::is_none")]
    pub user_storage_resource_id: Option<String>,
    #[serde(rename = "appInsightsInstrumentationKey", default, skip_serializing_if = "Option::is_none")]
    pub app_insights_instrumentation_key: Option<String>,
    #[serde(rename = "containerRegistryCredentials", default, skip_serializing_if = "Option::is_none")]
    pub container_registry_credentials: Option<RegistryListCredentialsResult>,
    #[serde(rename = "notebookAccessKeys", default, skip_serializing_if = "Option::is_none")]
    pub notebook_access_keys: Option<ListNotebookKeysResult>,
}
impl ListWorkspaceKeysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List WorkspaceQuotasByVMFamily operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListWorkspaceQuotas {
    #[doc = "The list of Workspace Quotas by VM Family"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceQuota>,
    #[doc = "The URI to fetch the next page of workspace quota information by VM Family. Call ListNext() with this to fetch the next page of Workspace Quota information."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListWorkspaceQuotas {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Labeling MLAssist configuration definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MlAssistConfiguration {
    #[doc = "Configuration for compute binding."]
    #[serde(rename = "inferencingComputeBinding", default, skip_serializing_if = "Option::is_none")]
    pub inferencing_compute_binding: Option<ComputeConfiguration>,
    #[doc = "Indicates whether MLAssist feature is enabled."]
    #[serde(rename = "mlAssistEnabled", default, skip_serializing_if = "Option::is_none")]
    pub ml_assist_enabled: Option<bool>,
    #[doc = "Configuration for compute binding."]
    #[serde(rename = "trainingComputeBinding", default, skip_serializing_if = "Option::is_none")]
    pub training_compute_binding: Option<ComputeConfiguration>,
}
impl MlAssistConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Managed identity configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedIdentity {
    #[serde(flatten)]
    pub identity_configuration: IdentityConfiguration,
    #[doc = "Specifies a user-assigned identity by client ID. For system-assigned, do not set this field."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[doc = "Specifies a user-assigned identity by object ID. For system-assigned, do not set this field."]
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[doc = "Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl ManagedIdentity {
    pub fn new(identity_configuration: IdentityConfiguration) -> Self {
        Self {
            identity_configuration,
            client_id: None,
            object_id: None,
            resource_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedOnlineDeployment {
    #[serde(flatten)]
    pub online_deployment: OnlineDeployment,
    #[doc = "Compute instance type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    #[doc = "Deployment container liveness/readiness probe configuration."]
    #[serde(rename = "readinessProbe", default, skip_serializing_if = "Option::is_none")]
    pub readiness_probe: Option<ProbeSettings>,
}
impl ManagedOnlineDeployment {
    pub fn new(online_deployment: OnlineDeployment) -> Self {
        Self {
            online_deployment,
            instance_type: None,
            readiness_probe: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManualScaleSettings {
    #[serde(flatten)]
    pub online_scale_settings: OnlineScaleSettings,
    #[doc = "Fixed number of instances for this deployment."]
    #[serde(rename = "instanceCount", default, skip_serializing_if = "Option::is_none")]
    pub instance_count: Option<i32>,
}
impl ManualScaleSettings {
    pub fn new(online_scale_settings: OnlineScaleSettings) -> Self {
        Self {
            online_scale_settings,
            instance_count: None,
        }
    }
}
#[doc = "Media type of data asset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum MediaType {
    Image,
    Text,
}
#[doc = "Defines an early termination policy based on running averages of the primary metric of all runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MedianStoppingPolicy {
    #[serde(flatten)]
    pub early_termination_policy: EarlyTerminationPolicy,
}
impl MedianStoppingPolicy {
    pub fn new(early_termination_policy: EarlyTerminationPolicy) -> Self {
        Self { early_termination_policy }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelContainer {
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ModelContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ModelContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: ModelContainer,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ModelContainerResource {
    pub fn new(properties: ModelContainer) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of ModelContainer entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelContainerResourceArmPaginatedResult {
    #[doc = "The link to the next page of ModelContainer objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type ModelContainer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ModelContainerResource>,
}
impl ModelContainerResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Model asset version details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ModelVersion {
    #[doc = "ARM resource ID of the datastore where the asset is located."]
    #[serde(rename = "datastoreId", default, skip_serializing_if = "Option::is_none")]
    pub datastore_id: Option<String>,
    #[doc = "The asset description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Mapping of model flavors to their properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flavors: Option<serde_json::Value>,
    #[doc = "If the name version are system generated (anonymous registration)."]
    #[serde(rename = "isAnonymous", default, skip_serializing_if = "Option::is_none")]
    pub is_anonymous: Option<bool>,
    #[doc = "The path of the file/directory in the datastore."]
    pub path: String,
    #[doc = "The asset property dictionary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Tag dictionary. Tags can be added, removed, and updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ModelVersion {
    pub fn new(path: String) -> Self {
        Self {
            datastore_id: None,
            description: None,
            flavors: None,
            is_anonymous: None,
            path,
            properties: None,
            tags: None,
        }
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ModelVersionResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Model asset version details."]
    pub properties: ModelVersion,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ModelVersionResource {
    pub fn new(properties: ModelVersion) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of ModelVersion entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelVersionResourceArmPaginatedResult {
    #[doc = "The link to the next page of ModelVersion objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type ModelVersion."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ModelVersionResource>,
}
impl ModelVersionResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "MPI distribution configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Mpi {
    #[serde(flatten)]
    pub distribution_configuration: DistributionConfiguration,
    #[doc = "Number of processes per MPI node."]
    #[serde(rename = "processCountPerInstance", default, skip_serializing_if = "Option::is_none")]
    pub process_count_per_instance: Option<i32>,
}
impl Mpi {
    pub fn new(distribution_configuration: DistributionConfiguration) -> Self {
        Self {
            distribution_configuration,
            process_count_per_instance: None,
        }
    }
}
#[doc = "Counts of various compute node states on the amlCompute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NodeStateCounts {
    #[doc = "Number of compute nodes in idle state."]
    #[serde(rename = "idleNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub idle_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are running jobs."]
    #[serde(rename = "runningNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub running_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are being prepared."]
    #[serde(rename = "preparingNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub preparing_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are in unusable state."]
    #[serde(rename = "unusableNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub unusable_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are leaving the amlCompute."]
    #[serde(rename = "leavingNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub leaving_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are in preempted state."]
    #[serde(rename = "preemptedNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub preempted_node_count: Option<i32>,
}
impl NodeStateCounts {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Empty/none datastore credentials."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NoneDatastoreCredentials {
    #[serde(flatten)]
    pub datastore_credentials: DatastoreCredentials,
    #[doc = "Empty/none datastore secret."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secrets: Option<NoneDatastoreSecrets>,
}
impl NoneDatastoreCredentials {
    pub fn new(datastore_credentials: DatastoreCredentials) -> Self {
        Self {
            datastore_credentials,
            secrets: None,
        }
    }
}
#[doc = "Empty/none datastore secret."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NoneDatastoreSecrets {
    #[serde(flatten)]
    pub datastore_secrets: DatastoreSecrets,
}
impl NoneDatastoreSecrets {
    pub fn new(datastore_secrets: DatastoreSecrets) -> Self {
        Self { datastore_secrets }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookAccessTokenResult {
    #[serde(rename = "notebookResourceId", default, skip_serializing_if = "Option::is_none")]
    pub notebook_resource_id: Option<String>,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "publicDns", default, skip_serializing_if = "Option::is_none")]
    pub public_dns: Option<String>,
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<String>,
    #[serde(rename = "tokenType", default, skip_serializing_if = "Option::is_none")]
    pub token_type: Option<String>,
    #[serde(rename = "expiresIn", default, skip_serializing_if = "Option::is_none")]
    pub expires_in: Option<i32>,
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
}
impl NotebookAccessTokenResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookPreparationError {
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "statusCode", default, skip_serializing_if = "Option::is_none")]
    pub status_code: Option<i32>,
}
impl NotebookPreparationError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookResourceInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "the data plane resourceId that used to initialize notebook component"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "notebookPreparationError", default, skip_serializing_if = "Option::is_none")]
    pub notebook_preparation_error: Option<NotebookPreparationError>,
}
impl NotebookResourceInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Optimization objective."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Objective {
    #[doc = "Defines supported metric goals for hyperparameter tuning"]
    pub goal: Goal,
    #[doc = "Name of the metric to optimize."]
    #[serde(rename = "primaryMetric")]
    pub primary_metric: String,
}
impl Objective {
    pub fn new(goal: Goal, primary_metric: String) -> Self {
        Self { goal, primary_metric }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OnlineDeployment {
    #[doc = "If true, enables Application Insights logging."]
    #[serde(rename = "appInsightsEnabled", default, skip_serializing_if = "Option::is_none")]
    pub app_insights_enabled: Option<bool>,
    #[doc = "Configuration for a scoring code asset."]
    #[serde(rename = "codeConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub code_configuration: Option<CodeConfiguration>,
    #[doc = "Description of the endpoint deployment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Enum to determine endpoint compute type."]
    #[serde(rename = "endpointComputeType")]
    pub endpoint_compute_type: EndpointComputeType,
    #[doc = "ARM resource ID of the environment specification for the endpoint deployment."]
    #[serde(rename = "environmentId", default, skip_serializing_if = "Option::is_none")]
    pub environment_id: Option<String>,
    #[doc = "Environment variables configuration for the deployment."]
    #[serde(rename = "environmentVariables", default, skip_serializing_if = "Option::is_none")]
    pub environment_variables: Option<serde_json::Value>,
    #[doc = "Deployment container liveness/readiness probe configuration."]
    #[serde(rename = "livenessProbe", default, skip_serializing_if = "Option::is_none")]
    pub liveness_probe: Option<ProbeSettings>,
    #[doc = "Base definition for asset references."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub model: Option<AssetReferenceBase>,
    #[doc = "Property dictionary. Properties can be added, but not removed or altered."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<DeploymentProvisioningState>,
    #[doc = "Online deployment scoring requests configuration."]
    #[serde(rename = "requestSettings", default, skip_serializing_if = "Option::is_none")]
    pub request_settings: Option<OnlineRequestSettings>,
    #[doc = "Online deployment scaling configuration."]
    #[serde(rename = "scaleSettings", default, skip_serializing_if = "Option::is_none")]
    pub scale_settings: Option<OnlineScaleSettings>,
}
impl OnlineDeployment {
    pub fn new(endpoint_compute_type: EndpointComputeType) -> Self {
        Self {
            app_insights_enabled: None,
            code_configuration: None,
            description: None,
            endpoint_compute_type,
            environment_id: None,
            environment_variables: None,
            liveness_probe: None,
            model: None,
            properties: None,
            provisioning_state: None,
            request_settings: None,
            scale_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OnlineDeploymentTrackedResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Service identity associated with a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    pub properties: OnlineDeployment,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl OnlineDeploymentTrackedResource {
    pub fn new(tracked_resource: TrackedResource, properties: OnlineDeployment) -> Self {
        Self {
            tracked_resource,
            identity: None,
            kind: None,
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of OnlineDeployment entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OnlineDeploymentTrackedResourceArmPaginatedResult {
    #[doc = "The link to the next page of OnlineDeployment objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type OnlineDeployment."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OnlineDeploymentTrackedResource>,
}
impl OnlineDeploymentTrackedResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Online endpoint configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OnlineEndpoint {
    #[doc = "Enum to determine endpoint authentication mode."]
    #[serde(rename = "authMode")]
    pub auth_mode: EndpointAuthMode,
    #[doc = "Description of the inference endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Keys for endpoint authentication."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keys: Option<EndpointAuthKeys>,
    #[doc = "Property dictionary. Properties can be added, but not removed or altered."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "State of endpoint provisioning."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<EndpointProvisioningState>,
    #[doc = "Endpoint URI."]
    #[serde(rename = "scoringUri", default, skip_serializing_if = "Option::is_none")]
    pub scoring_uri: Option<String>,
    #[doc = "Endpoint Swagger URI."]
    #[serde(rename = "swaggerUri", default, skip_serializing_if = "Option::is_none")]
    pub swagger_uri: Option<String>,
    #[doc = "ARM resource ID of the compute if it exists.\r\noptional"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "Traffic rules on how the traffic will be routed across deployments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub traffic: Option<serde_json::Value>,
}
impl OnlineEndpoint {
    pub fn new(auth_mode: EndpointAuthMode) -> Self {
        Self {
            auth_mode,
            description: None,
            keys: None,
            properties: None,
            provisioning_state: None,
            scoring_uri: None,
            swagger_uri: None,
            target: None,
            traffic: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OnlineEndpointTrackedResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Service identity associated with a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Online endpoint configuration"]
    pub properties: OnlineEndpoint,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl OnlineEndpointTrackedResource {
    pub fn new(tracked_resource: TrackedResource, properties: OnlineEndpoint) -> Self {
        Self {
            tracked_resource,
            identity: None,
            kind: None,
            properties,
            system_data: None,
        }
    }
}
#[doc = "A paginated list of OnlineEndpoint entities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OnlineEndpointTrackedResourceArmPaginatedResult {
    #[doc = "The link to the next page of OnlineEndpoint objects. If null, there are no additional pages."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "An array of objects of type OnlineEndpoint."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OnlineEndpointTrackedResource>,
}
impl OnlineEndpointTrackedResourceArmPaginatedResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Online deployment scoring requests configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OnlineRequestSettings {
    #[doc = "The number of requests allowed to queue at once for this deployment."]
    #[serde(rename = "maxConcurrentRequestsPerInstance", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_requests_per_instance: Option<i32>,
    #[doc = "The maximum queue wait time in ISO 8601 format. Supports millisecond precision."]
    #[serde(rename = "maxQueueWait", default, skip_serializing_if = "Option::is_none")]
    pub max_queue_wait: Option<String>,
    #[doc = "The request timeout in ISO 8601 format. Supports millisecond precision."]
    #[serde(rename = "requestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub request_timeout: Option<String>,
}
impl OnlineRequestSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Online deployment scaling configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OnlineScaleSettings {
    #[doc = "Maximum number of instances for this deployment."]
    #[serde(rename = "maxInstances", default, skip_serializing_if = "Option::is_none")]
    pub max_instances: Option<i32>,
    #[doc = "Minimum number of instances for this deployment."]
    #[serde(rename = "minInstances", default, skip_serializing_if = "Option::is_none")]
    pub min_instances: Option<i32>,
    #[serde(rename = "scaleType")]
    pub scale_type: ScaleType,
}
impl OnlineScaleSettings {
    pub fn new(scale_type: ScaleType) -> Self {
        Self {
            max_instances: None,
            min_instances: None,
            scale_type,
        }
    }
}
#[doc = "The type of operating system."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OperatingSystemType {
    Linux,
    Windows,
}
#[doc = "Azure Machine Learning workspace REST API operation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Display name of operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "Display name of operation"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "The resource provider name: Microsoft.MachineLearningExperimentation"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "The resource on which the operation is performed."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "The operation that users can perform."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "The description for the operation."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "An array of operations supported by the resource provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of AML workspace operations supported by the AML workspace resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OrderString {
    CreatedAtDesc,
    CreatedAtAsc,
    UpdatedAtDesc,
    UpdatedAtAsc,
}
#[doc = "Enum to determine the type of linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OriginType {
    Synapse,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OutputDataBinding {
    #[doc = "ARM resource ID of the datastore where the data output will be stored."]
    #[serde(rename = "datastoreId", default, skip_serializing_if = "Option::is_none")]
    pub datastore_id: Option<String>,
    #[doc = "Describes how the data should be attached to the container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<DataBindingMode>,
    #[doc = "Location of data inside the container process."]
    #[serde(rename = "pathOnCompute", default, skip_serializing_if = "Option::is_none")]
    pub path_on_compute: Option<String>,
    #[doc = "Path within the datastore to the data."]
    #[serde(rename = "pathOnDatastore", default, skip_serializing_if = "Option::is_none")]
    pub path_on_datastore: Option<String>,
}
impl OutputDataBinding {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Reference to an asset via its path in a job output."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutputPathAssetReference {
    #[serde(flatten)]
    pub asset_reference_base: AssetReferenceBase,
    #[doc = "ARM resource ID of the job."]
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[doc = "The path of the file/directory in the job output."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl OutputPathAssetReference {
    pub fn new(asset_reference_base: AssetReferenceBase) -> Self {
        Self {
            asset_reference_base,
            job_id: None,
            path: None,
        }
    }
}
#[doc = "Paginated list of Machine Learning compute objects wrapped in ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaginatedComputeResourcesList {
    #[doc = "An array of Machine Learning compute objects wrapped in ARM resource envelope."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ComputeResource>,
    #[doc = "A continuation link (absolute URI) to the next page of results in the list."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PaginatedComputeResourcesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Paginated list of Workspace connection objects."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaginatedWorkspaceConnectionsList {
    #[doc = "An array of Workspace connection objects."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkspaceConnection>,
    #[doc = "A continuation link (absolute URI) to the next page of results in the list."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PaginatedWorkspaceConnectionsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PartialAksOnlineDeployment {
    #[serde(flatten)]
    pub partial_online_deployment: PartialOnlineDeployment,
    #[doc = "The resource requirements for the container (cpu and memory)."]
    #[serde(rename = "containerResourceRequirements", default, skip_serializing_if = "Option::is_none")]
    pub container_resource_requirements: Option<ContainerResourceRequirements>,
}
impl PartialAksOnlineDeployment {
    pub fn new(partial_online_deployment: PartialOnlineDeployment) -> Self {
        Self {
            partial_online_deployment,
            container_resource_requirements: None,
        }
    }
}
#[doc = "Mutable batch inference settings per deployment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartialBatchDeployment {
    #[doc = "Description of the endpoint deployment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl PartialBatchDeployment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Strictly used in update requests."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartialBatchDeploymentPartialTrackedResource {
    #[doc = "Service identity associated with a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "The geo-location where the resource lives."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Mutable batch inference settings per deployment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PartialBatchDeployment>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl PartialBatchDeploymentPartialTrackedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Mutable Batch endpoint configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartialBatchEndpoint {
    #[doc = "Traffic rules on how the traffic will be routed across deployments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub traffic: Option<serde_json::Value>,
}
impl PartialBatchEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Strictly used in update requests."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartialBatchEndpointPartialTrackedResource {
    #[doc = "Service identity associated with a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "The geo-location where the resource lives."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Mutable Batch endpoint configuration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PartialBatchEndpoint>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl PartialBatchEndpointPartialTrackedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PartialManagedOnlineDeployment {
    #[serde(flatten)]
    pub partial_online_deployment: PartialOnlineDeployment,
    #[doc = "Deployment container liveness/readiness probe configuration."]
    #[serde(rename = "readinessProbe", default, skip_serializing_if = "Option::is_none")]
    pub readiness_probe: Option<ProbeSettings>,
}
impl PartialManagedOnlineDeployment {
    pub fn new(partial_online_deployment: PartialOnlineDeployment) -> Self {
        Self {
            partial_online_deployment,
            readiness_probe: None,
        }
    }
}
#[doc = "Mutable online deployment configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PartialOnlineDeployment {
    #[doc = "Whether AppInsights telemetry is enabled for this online deployment."]
    #[serde(rename = "appInsightsEnabled", default, skip_serializing_if = "Option::is_none")]
    pub app_insights_enabled: Option<bool>,
    #[doc = "Enum to determine endpoint compute type."]
    #[serde(rename = "endpointComputeType")]
    pub endpoint_compute_type: EndpointComputeType,
    #[doc = "Deployment container liveness/readiness probe configuration."]
    #[serde(rename = "livenessProbe", default, skip_serializing_if = "Option::is_none")]
    pub liveness_probe: Option<ProbeSettings>,
    #[doc = "Online deployment scoring requests configuration."]
    #[serde(rename = "requestSettings", default, skip_serializing_if = "Option::is_none")]
    pub request_settings: Option<OnlineRequestSettings>,
    #[doc = "Online deployment scaling configuration."]
    #[serde(rename = "scaleSettings", default, skip_serializing_if = "Option::is_none")]
    pub scale_settings: Option<OnlineScaleSettings>,
}
impl PartialOnlineDeployment {
    pub fn new(endpoint_compute_type: EndpointComputeType) -> Self {
        Self {
            app_insights_enabled: None,
            endpoint_compute_type,
            liveness_probe: None,
            request_settings: None,
            scale_settings: None,
        }
    }
}
#[doc = "Strictly used in update requests."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartialOnlineDeploymentPartialTrackedResource {
    #[doc = "Service identity associated with a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "The geo-location where the resource lives."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Mutable online deployment configuration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PartialOnlineDeployment>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl PartialOnlineDeploymentPartialTrackedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Mutable online endpoint configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartialOnlineEndpoint {
    #[doc = "Traffic rules on how the traffic will be routed across deployments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub traffic: Option<serde_json::Value>,
}
impl PartialOnlineEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Strictly used in update requests."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartialOnlineEndpointPartialTrackedResource {
    #[doc = "Service identity associated with a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "The geo-location where the resource lives."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Mutable online endpoint configuration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PartialOnlineEndpoint>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl PartialOnlineEndpointPartialTrackedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Password {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl Password {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Settings for a personal compute instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PersonalComputeInstanceSettings {
    #[doc = "A user that can be assigned to a compute instance."]
    #[serde(rename = "assignedUser", default, skip_serializing_if = "Option::is_none")]
    pub assigned_user: Option<AssignedUser>,
}
impl PersonalComputeInstanceSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Private Endpoint resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[doc = "The ARM identifier for Private Endpoint"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The ARM identifier for Subnet resource that private endpoint links to"]
    #[serde(rename = "subnetArmId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_arm_id: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Private Endpoint Connection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the PrivateEndpointConnectProperties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnectionProperties>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<Identity>,
    #[doc = "Specifies the location of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Contains resource tags defined as key/value pairs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Sku of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of private endpoint connection associated with the specified workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionListResult {
    #[doc = "Array of private endpoint connections"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpointConnection>,
}
impl PrivateEndpointConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the PrivateEndpointConnectProperties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateEndpointConnectionProperties {
    #[doc = "The Private Endpoint resource."]
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[doc = "A collection of information about the state of the connection between service consumer and provider."]
    #[serde(rename = "privateLinkServiceConnectionState")]
    pub private_link_service_connection_state: PrivateLinkServiceConnectionState,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<PrivateEndpointConnectionProvisioningState>,
}
impl PrivateEndpointConnectionProperties {
    pub fn new(private_link_service_connection_state: PrivateLinkServiceConnectionState) -> Self {
        Self {
            private_endpoint: None,
            private_link_service_connection_state,
            provisioning_state: None,
        }
    }
}
#[doc = "The current provisioning state."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PrivateEndpointConnectionProvisioningState {
    Succeeded,
    Creating,
    Deleting,
    Failed,
}
#[doc = "The private endpoint connection status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PrivateEndpointServiceConnectionStatus {
    Pending,
    Approved,
    Rejected,
    Disconnected,
    Timeout,
}
#[doc = "A private link resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of a private link resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkResourceProperties>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<Identity>,
    #[doc = "Specifies the location of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Contains resource tags defined as key/value pairs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Sku of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl PrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of private link resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceListResult {
    #[doc = "Array of private link resources"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateLinkResource>,
}
impl PrivateLinkResourceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a private link resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceProperties {
    #[doc = "The private link resource group id."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[doc = "The private link resource required member names."]
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[doc = "The private link resource Private link DNS zone name."]
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl PrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A collection of information about the state of the connection between service consumer and provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionState {
    #[doc = "The private endpoint connection status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<PrivateEndpointServiceConnectionStatus>,
    #[doc = "The reason for approval/rejection of the connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "A message indicating if changes on the service provider require any updates on the consumer."]
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Deployment container liveness/readiness probe configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProbeSettings {
    #[doc = "The number of failures to allow before returning an unhealthy status."]
    #[serde(rename = "failureThreshold", default, skip_serializing_if = "Option::is_none")]
    pub failure_threshold: Option<i32>,
    #[doc = "The delay before the first probe in ISO 8601 format."]
    #[serde(rename = "initialDelay", default, skip_serializing_if = "Option::is_none")]
    pub initial_delay: Option<String>,
    #[doc = "The length of time between probes in ISO 8601 format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub period: Option<String>,
    #[doc = "The number of successful probes before returning a healthy status."]
    #[serde(rename = "successThreshold", default, skip_serializing_if = "Option::is_none")]
    pub success_threshold: Option<i32>,
    #[doc = "The probe timeout in ISO 8601 format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
}
impl ProbeSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Progress metrics definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProgressMetrics {
    #[doc = "The completed datapoint count."]
    #[serde(rename = "completedDatapointCount", default, skip_serializing_if = "Option::is_none")]
    pub completed_datapoint_count: Option<i64>,
    #[doc = "The time of last successful incremental dataset refresh in UTC."]
    #[serde(rename = "incrementalDatasetLastRefreshTime", default, skip_serializing_if = "Option::is_none")]
    pub incremental_dataset_last_refresh_time: Option<String>,
    #[doc = "The skipped datapoint count."]
    #[serde(rename = "skippedDatapointCount", default, skip_serializing_if = "Option::is_none")]
    pub skipped_datapoint_count: Option<i64>,
    #[doc = "The total datapoint count."]
    #[serde(rename = "totalDatapointCount", default, skip_serializing_if = "Option::is_none")]
    pub total_datapoint_count: Option<i64>,
}
impl ProgressMetrics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "PyTorch distribution configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PyTorch {
    #[serde(flatten)]
    pub distribution_configuration: DistributionConfiguration,
    #[doc = "Total process count for the distributed job."]
    #[serde(rename = "processCount", default, skip_serializing_if = "Option::is_none")]
    pub process_count: Option<i32>,
}
impl PyTorch {
    pub fn new(distribution_configuration: DistributionConfiguration) -> Self {
        Self {
            distribution_configuration,
            process_count: None,
        }
    }
}
#[doc = "The properties for Quota update or retrieval."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaBaseProperties {
    #[doc = "Specifies the resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Specifies the resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The maximum permitted quota of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "An enum describing the unit of quota measurement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<quota_base_properties::Unit>,
}
impl QuotaBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod quota_base_properties {
    use super::*;
    #[doc = "An enum describing the unit of quota measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[doc = "Quota update parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaUpdateParameters {
    #[doc = "The list for update quota."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<QuotaBaseProperties>,
    #[doc = "Region of workspace quota to be updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl QuotaUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The workflow trigger recurrence for ComputeStartStop schedule type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Recurrence {
    #[doc = "The recurrence frequency."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<RecurrenceFrequency>,
    #[doc = "The interval."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[doc = "The start time."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The time zone."]
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[doc = "The recurrence schedule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<RecurrenceSchedule>,
}
impl Recurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The recurrence frequency."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecurrenceFrequency {
    NotSpecified,
    Second,
    Minute,
    Hour,
    Day,
    Week,
    Month,
    Year,
}
#[doc = "The recurrence schedule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecurrenceSchedule {
    #[doc = "The minutes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub minutes: Vec<i32>,
    #[doc = "The hours."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hours: Vec<i32>,
    #[doc = "The days of the week."]
    #[serde(rename = "weekDays", default, skip_serializing_if = "Vec::is_empty")]
    pub week_days: Vec<String>,
}
impl RecurrenceSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Enum to determine which reference method to use for an asset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ReferenceType {
    Id,
    DataPath,
    OutputPath,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegenerateEndpointKeysRequest {
    #[serde(rename = "keyType")]
    pub key_type: KeyType,
    #[doc = "The value the key is set to."]
    #[serde(rename = "keyValue", default, skip_serializing_if = "Option::is_none")]
    pub key_value: Option<String>,
}
impl RegenerateEndpointKeysRequest {
    pub fn new(key_type: KeyType) -> Self {
        Self { key_type, key_value: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryListCredentialsResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub passwords: Vec<Password>,
}
impl RegistryListCredentialsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common fields that are returned in the response for all Azure Resource Manager resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or \"Microsoft.Storage/storageAccounts\""]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceId {
    #[doc = "The ID of the resource"]
    pub id: String,
}
impl ResourceId {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "Service identity associated with a resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceIdentity {
    #[doc = "Client ID that is used when authenticating."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "AAD Tenant where this identity lives."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "Defines values for a ResourceIdentity's type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<ResourceIdentityAssignment>,
    #[doc = "Dictionary of the user assigned identities, key is ARM resource ID of the UAI."]
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl ResourceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines values for a ResourceIdentity's type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ResourceIdentityAssignment {
    SystemAssigned,
    UserAssigned,
    #[serde(rename = "SystemAssigned,UserAssigned")]
    SystemAssignedUserAssigned,
    None,
}
#[doc = "The Resource Name."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceName {
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "The localized name of the resource."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl ResourceName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The quota assigned to a resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceQuota {
    #[doc = "Specifies the resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Region of the AML workspace in the id."]
    #[serde(rename = "amlWorkspaceLocation", default, skip_serializing_if = "Option::is_none")]
    pub aml_workspace_location: Option<String>,
    #[doc = "Specifies the resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The Resource Name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<ResourceName>,
    #[doc = "The maximum permitted quota of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "An enum describing the unit of quota measurement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<resource_quota::Unit>,
}
impl ResourceQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_quota {
    use super::*;
    #[doc = "An enum describing the unit of quota measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSkuLocationInfo {
    #[doc = "Location of the SKU"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "List of availability zones where the SKU is supported."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[doc = "Details of capabilities available to a SKU in specific zones."]
    #[serde(rename = "zoneDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub zone_details: Vec<ResourceSkuZoneDetails>,
}
impl ResourceSkuLocationInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes The zonal capabilities of a SKU."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSkuZoneDetails {
    #[doc = "The set of zones that the SKU is available in with the specified capabilities."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub name: Vec<String>,
    #[doc = "A list of capabilities that are available for the SKU in the specified list of zones."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<SkuCapability>,
}
impl ResourceSkuZoneDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The restriction because of which SKU cannot be used."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Restriction {
    #[doc = "The type of restrictions. As of now only possible value for this is location."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
    #[doc = "The reason for the restriction."]
    #[serde(rename = "reasonCode", default, skip_serializing_if = "Option::is_none")]
    pub reason_code: Option<restriction::ReasonCode>,
}
impl Restriction {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod restriction {
    use super::*;
    #[doc = "The reason for the restriction."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReasonCode {
        NotSpecified,
        NotAvailableForRegion,
        NotAvailableForSubscription,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Route {
    #[doc = "The path for the route."]
    pub path: String,
    #[doc = "The port for the route."]
    pub port: i32,
}
impl Route {
    pub fn new(path: String, port: i32) -> Self {
        Self { path, port }
    }
}
#[doc = "Features/user capabilities associated with the sku"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuCapability {
    #[doc = "Capability/Feature ID"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Details about the feature/capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl SkuCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SamplingAlgorithm {
    Grid,
    Random,
    Bayesian,
}
#[doc = "SAS datastore credentials configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SasDatastoreCredentials {
    #[serde(flatten)]
    pub datastore_credentials: DatastoreCredentials,
    #[doc = "Datastore SAS secrets."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secrets: Option<SasDatastoreSecrets>,
}
impl SasDatastoreCredentials {
    pub fn new(datastore_credentials: DatastoreCredentials) -> Self {
        Self {
            datastore_credentials,
            secrets: None,
        }
    }
}
#[doc = "Datastore SAS secrets."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SasDatastoreSecrets {
    #[serde(flatten)]
    pub datastore_secrets: DatastoreSecrets,
    #[doc = "Storage container SAS token."]
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<String>,
}
impl SasDatastoreSecrets {
    pub fn new(datastore_secrets: DatastoreSecrets) -> Self {
        Self {
            datastore_secrets,
            sas_token: None,
        }
    }
}
#[doc = "scale settings for AML Compute"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScaleSettings {
    #[doc = "Max number of nodes to use"]
    #[serde(rename = "maxNodeCount")]
    pub max_node_count: i32,
    #[doc = "Min number of nodes to use"]
    #[serde(rename = "minNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub min_node_count: Option<i32>,
    #[doc = "Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format."]
    #[serde(rename = "nodeIdleTimeBeforeScaleDown", default, skip_serializing_if = "Option::is_none")]
    pub node_idle_time_before_scale_down: Option<String>,
}
impl ScaleSettings {
    pub fn new(max_node_count: i32) -> Self {
        Self {
            max_node_count,
            min_node_count: None,
            node_idle_time_before_scale_down: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ScaleType {
    Auto,
    Manual,
}
#[doc = "The schedule status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ScheduleStatus {
    Enabled,
    Disabled,
}
#[doc = "The schedule type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ScheduleType {
    ComputeStartStop,
}
#[doc = "Script reference"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScriptReference {
    #[doc = "The storage source of the script: inline, workspace."]
    #[serde(rename = "scriptSource", default, skip_serializing_if = "Option::is_none")]
    pub script_source: Option<String>,
    #[doc = "The location of scripts in the mounted volume."]
    #[serde(rename = "scriptData", default, skip_serializing_if = "Option::is_none")]
    pub script_data: Option<String>,
    #[doc = "Optional command line arguments passed to the script to run."]
    #[serde(rename = "scriptArguments", default, skip_serializing_if = "Option::is_none")]
    pub script_arguments: Option<String>,
    #[doc = "Optional time period passed to timeout command."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
}
impl ScriptReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Customized setup scripts"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScriptsToExecute {
    #[doc = "Script reference"]
    #[serde(rename = "startupScript", default, skip_serializing_if = "Option::is_none")]
    pub startup_script: Option<ScriptReference>,
    #[doc = "Script reference"]
    #[serde(rename = "creationScript", default, skip_serializing_if = "Option::is_none")]
    pub creation_script: Option<ScriptReference>,
}
impl ScriptsToExecute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Enum to determine the datastore secrets type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecretsType {
    AccountKey,
    Certificate,
    None,
    Sas,
    ServicePrincipal,
    SqlAdmin,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceManagedResourcesSettings {
    #[serde(rename = "cosmosDb", default, skip_serializing_if = "Option::is_none")]
    pub cosmos_db: Option<CosmosDbSettings>,
}
impl ServiceManagedResourcesSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Service principal credentials."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServicePrincipalCredentials {
    #[doc = "Client Id"]
    #[serde(rename = "clientId")]
    pub client_id: String,
    #[doc = "Client secret"]
    #[serde(rename = "clientSecret")]
    pub client_secret: String,
}
impl ServicePrincipalCredentials {
    pub fn new(client_id: String, client_secret: String) -> Self {
        Self { client_id, client_secret }
    }
}
#[doc = "Service Principal datastore credentials configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServicePrincipalDatastoreCredentials {
    #[serde(flatten)]
    pub datastore_credentials: DatastoreCredentials,
    #[doc = "Authority URL used for authentication."]
    #[serde(rename = "authorityUrl", default, skip_serializing_if = "Option::is_none")]
    pub authority_url: Option<String>,
    #[doc = "Service principal client ID."]
    #[serde(rename = "clientId")]
    pub client_id: String,
    #[doc = "Resource the service principal has access to."]
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[doc = "Datastore Service Principal secrets."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secrets: Option<ServicePrincipalDatastoreSecrets>,
    #[doc = "ID of the tenant to which the service principal belongs."]
    #[serde(rename = "tenantId")]
    pub tenant_id: String,
}
impl ServicePrincipalDatastoreCredentials {
    pub fn new(datastore_credentials: DatastoreCredentials, client_id: String, tenant_id: String) -> Self {
        Self {
            datastore_credentials,
            authority_url: None,
            client_id,
            resource_uri: None,
            secrets: None,
            tenant_id,
        }
    }
}
#[doc = "Datastore Service Principal secrets."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServicePrincipalDatastoreSecrets {
    #[serde(flatten)]
    pub datastore_secrets: DatastoreSecrets,
    #[doc = "Service principal secret."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
}
impl ServicePrincipalDatastoreSecrets {
    pub fn new(datastore_secrets: DatastoreSecrets) -> Self {
        Self {
            datastore_secrets,
            client_secret: None,
        }
    }
}
#[doc = "Details of customized scripts to execute for setting up the cluster."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SetupScripts {
    #[doc = "Customized setup scripts"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scripts: Option<ScriptsToExecute>,
}
impl SetupScripts {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharedPrivateLinkResource {
    #[doc = "Unique name of the private link."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Properties of a shared private link resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SharedPrivateLinkResourceProperty>,
}
impl SharedPrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a shared private link resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharedPrivateLinkResourceProperty {
    #[doc = "The resource id that private link links to."]
    #[serde(rename = "privateLinkResourceId", default, skip_serializing_if = "Option::is_none")]
    pub private_link_resource_id: Option<String>,
    #[doc = "The private link resource group id."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[doc = "Request message."]
    #[serde(rename = "requestMessage", default, skip_serializing_if = "Option::is_none")]
    pub request_message: Option<String>,
    #[doc = "The private endpoint connection status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<PrivateEndpointServiceConnectionStatus>,
}
impl SharedPrivateLinkResourceProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Sku of the resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[doc = "Name of the sku"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Tier of the sku like Basic or Enterprise"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of skus with features"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkspaceSku>,
    #[doc = "The URI to fetch the next page of Workspace Skus. Call ListNext() with this URI to fetch the next page of Workspace Skus"]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SkuListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SQL Admin datastore credentials configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlAdminDatastoreCredentials {
    #[serde(flatten)]
    pub datastore_credentials: DatastoreCredentials,
    #[doc = "Datastore SQL Admin secrets."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secrets: Option<SqlAdminDatastoreSecrets>,
    #[doc = "SQL database user name."]
    #[serde(rename = "userId")]
    pub user_id: String,
}
impl SqlAdminDatastoreCredentials {
    pub fn new(datastore_credentials: DatastoreCredentials, user_id: String) -> Self {
        Self {
            datastore_credentials,
            secrets: None,
            user_id,
        }
    }
}
#[doc = "Datastore SQL Admin secrets."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlAdminDatastoreSecrets {
    #[serde(flatten)]
    pub datastore_secrets: DatastoreSecrets,
    #[doc = "SQL database password."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl SqlAdminDatastoreSecrets {
    pub fn new(datastore_secrets: DatastoreSecrets) -> Self {
        Self {
            datastore_secrets,
            password: None,
        }
    }
}
#[doc = "The ssl configuration for scoring"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SslConfiguration {
    #[doc = "Enable or disable ssl for scoring"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<ssl_configuration::Status>,
    #[doc = "Cert data"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cert: Option<String>,
    #[doc = "Key data"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[doc = "CNAME of the cert"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cname: Option<String>,
    #[doc = "Leaf domain label of public endpoint"]
    #[serde(rename = "leafDomainLabel", default, skip_serializing_if = "Option::is_none")]
    pub leaf_domain_label: Option<String>,
    #[doc = "Indicates whether to overwrite existing domain label."]
    #[serde(rename = "overwriteExistingDomain", default, skip_serializing_if = "Option::is_none")]
    pub overwrite_existing_domain: Option<bool>,
}
impl SslConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ssl_configuration {
    use super::*;
    #[doc = "Enable or disable ssl for scoring"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
        Auto,
    }
}
#[doc = "Active message associated with project"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StatusMessage {
    #[doc = "Service-defined message code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Time in UTC at which the message was created."]
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<StatusMessageLevel>,
    #[doc = "A human-readable representation of the message code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl StatusMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum StatusMessageLevel {
    Error,
    Information,
    Warning,
}
#[doc = "Sweep job definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SweepJob {
    #[serde(flatten)]
    pub job_base: JobBase,
    pub algorithm: SamplingAlgorithm,
    #[doc = "Configuration for compute binding."]
    pub compute: ComputeConfiguration,
    #[doc = "Early termination policies enable canceling poor-performing runs before they complete."]
    #[serde(rename = "earlyTermination", default, skip_serializing_if = "Option::is_none")]
    pub early_termination: Option<EarlyTerminationPolicy>,
    #[doc = "The name of the experiment the job belongs to. If not set, the job is placed in the \"Default\" experiment."]
    #[serde(rename = "experimentName", default, skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    #[doc = "Base definition for identity configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityConfiguration>,
    #[doc = "An upper bound on the number of trials performed in parallel."]
    #[serde(rename = "maxConcurrentTrials", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_trials: Option<i32>,
    #[doc = "An upper bound on the number of trials to perform."]
    #[serde(rename = "maxTotalTrials", default, skip_serializing_if = "Option::is_none")]
    pub max_total_trials: Option<i32>,
    #[doc = "Optimization objective."]
    pub objective: Objective,
    #[doc = "Job output definition container information on where to find job output/logs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<JobOutput>,
    #[doc = "Job priority for scheduling policy. Only applies to AMLCompute.\r\nPrivate preview feature and only available to users on the allow list."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter"]
    #[serde(rename = "searchSpace")]
    pub search_space: serde_json::Value,
    #[doc = "The status of a job."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<JobStatus>,
    #[doc = "The total timeout in ISO 8601 format. Only supports duration with precision as low as Minutes."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
    #[doc = "Trial component definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub trial: Option<TrialComponent>,
}
impl SweepJob {
    pub fn new(
        job_base: JobBase,
        algorithm: SamplingAlgorithm,
        compute: ComputeConfiguration,
        objective: Objective,
        search_space: serde_json::Value,
    ) -> Self {
        Self {
            job_base,
            algorithm,
            compute,
            early_termination: None,
            experiment_name: None,
            identity: None,
            max_concurrent_trials: None,
            max_total_trials: None,
            objective,
            output: None,
            priority: None,
            search_space,
            status: None,
            timeout: None,
            trial: None,
        }
    }
}
#[doc = "A SynapseSpark compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseSpark {
    #[serde(flatten)]
    pub compute: Compute,
    #[serde(flatten)]
    pub synapse_spark_pool_properties: SynapseSparkPoolProperties,
}
impl SynapseSpark {
    pub fn new(compute: Compute) -> Self {
        Self {
            compute,
            synapse_spark_pool_properties: SynapseSparkPoolProperties::default(),
        }
    }
}
#[doc = "Properties specific to Synapse Spark pools."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SynapseSparkPoolProperties {
    #[doc = "AKS properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<synapse_spark_pool_properties::Properties>,
}
impl SynapseSparkPoolProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod synapse_spark_pool_properties {
    use super::*;
    #[doc = "AKS properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Auto scale properties"]
        #[serde(rename = "autoScaleProperties", default, skip_serializing_if = "Option::is_none")]
        pub auto_scale_properties: Option<AutoScaleProperties>,
        #[doc = "Auto pause properties"]
        #[serde(rename = "autoPauseProperties", default, skip_serializing_if = "Option::is_none")]
        pub auto_pause_properties: Option<AutoPauseProperties>,
        #[doc = "Spark version."]
        #[serde(rename = "sparkVersion", default, skip_serializing_if = "Option::is_none")]
        pub spark_version: Option<String>,
        #[doc = "The number of compute nodes currently assigned to the compute."]
        #[serde(rename = "nodeCount", default, skip_serializing_if = "Option::is_none")]
        pub node_count: Option<i32>,
        #[doc = "Node size."]
        #[serde(rename = "nodeSize", default, skip_serializing_if = "Option::is_none")]
        pub node_size: Option<String>,
        #[doc = "Node size family."]
        #[serde(rename = "nodeSizeFamily", default, skip_serializing_if = "Option::is_none")]
        pub node_size_family: Option<String>,
        #[doc = "Azure subscription identifier."]
        #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
        pub subscription_id: Option<String>,
        #[doc = "Name of the resource group in which workspace is located."]
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[doc = "Name of Azure Machine Learning workspace."]
        #[serde(rename = "workspaceName", default, skip_serializing_if = "Option::is_none")]
        pub workspace_name: Option<String>,
        #[doc = "Pool name."]
        #[serde(rename = "poolName", default, skip_serializing_if = "Option::is_none")]
        pub pool_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "A system service running on a compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemService {
    #[doc = "The type of this system service."]
    #[serde(rename = "systemServiceType", default, skip_serializing_if = "Option::is_none")]
    pub system_service_type: Option<String>,
    #[doc = "Public IP address"]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[doc = "The version for this type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl SystemService {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "TensorFlow distribution configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TensorFlow {
    #[serde(flatten)]
    pub distribution_configuration: DistributionConfiguration,
    #[doc = "Number of parameter server tasks."]
    #[serde(rename = "parameterServerCount", default, skip_serializing_if = "Option::is_none")]
    pub parameter_server_count: Option<i32>,
    #[doc = "Number of workers. Overwrites the node count in compute binding."]
    #[serde(rename = "workerCount", default, skip_serializing_if = "Option::is_none")]
    pub worker_count: Option<i32>,
}
impl TensorFlow {
    pub fn new(distribution_configuration: DistributionConfiguration) -> Self {
        Self {
            distribution_configuration,
            parameter_server_count: None,
            worker_count: None,
        }
    }
}
#[doc = "Annotation type of text data."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TextAnnotationType {
    Classification,
}
#[doc = "The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The geo-location where the resource lives"]
    pub location: String,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            tags: None,
            location,
        }
    }
}
#[doc = "Trial component definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrialComponent {
    #[doc = "ARM resource ID of the code asset."]
    #[serde(rename = "codeId", default, skip_serializing_if = "Option::is_none")]
    pub code_id: Option<String>,
    #[doc = "The command to execute on startup of the job. eg. \"python train.py\""]
    pub command: String,
    #[doc = "Base definition for job distribution configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub distribution: Option<DistributionConfiguration>,
    #[doc = "The ARM resource ID of the Environment specification for the job."]
    #[serde(rename = "environmentId", default, skip_serializing_if = "Option::is_none")]
    pub environment_id: Option<String>,
    #[doc = "Environment variables included in the job."]
    #[serde(rename = "environmentVariables", default, skip_serializing_if = "Option::is_none")]
    pub environment_variables: Option<serde_json::Value>,
    #[doc = "Mapping of input data bindings used in the job."]
    #[serde(rename = "inputDataBindings", default, skip_serializing_if = "Option::is_none")]
    pub input_data_bindings: Option<serde_json::Value>,
    #[doc = "Mapping of output data bindings used in the job."]
    #[serde(rename = "outputDataBindings", default, skip_serializing_if = "Option::is_none")]
    pub output_data_bindings: Option<serde_json::Value>,
    #[doc = "The max run duration in ISO 8601 format, after which the trial component will be cancelled.\r\nOnly supports duration with precision as low as Seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
}
impl TrialComponent {
    pub fn new(command: String) -> Self {
        Self {
            code_id: None,
            command,
            distribution: None,
            environment_id: None,
            environment_variables: None,
            input_data_bindings: None,
            output_data_bindings: None,
            timeout: None,
        }
    }
}
#[doc = "The schedule trigger type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TriggerType {
    Recurrence,
    Cron,
}
#[doc = "Defines an early termination policy that cancels a given percentage of runs at each evaluation interval."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TruncationSelectionPolicy {
    #[serde(flatten)]
    pub early_termination_policy: EarlyTerminationPolicy,
    #[doc = "The percentage of runs to cancel at each evaluation interval."]
    #[serde(rename = "truncationPercentage", default, skip_serializing_if = "Option::is_none")]
    pub truncation_percentage: Option<i32>,
}
impl TruncationSelectionPolicy {
    pub fn new(early_termination_policy: EarlyTerminationPolicy) -> Self {
        Self {
            early_termination_policy,
            truncation_percentage: None,
        }
    }
}
#[doc = "The properties for update Quota response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateWorkspaceQuotas {
    #[doc = "Specifies the resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Specifies the resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The maximum permitted quota of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "An enum describing the unit of quota measurement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<update_workspace_quotas::Unit>,
    #[doc = "Status of update workspace quota."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<update_workspace_quotas::Status>,
}
impl UpdateWorkspaceQuotas {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod update_workspace_quotas {
    use super::*;
    #[doc = "An enum describing the unit of quota measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
    #[doc = "Status of update workspace quota."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Undefined,
        Success,
        Failure,
        InvalidQuotaBelowClusterMinimum,
        InvalidQuotaExceedsSubscriptionLimit,
        #[serde(rename = "InvalidVMFamilyName")]
        InvalidVmFamilyName,
        OperationNotSupportedForSku,
        OperationNotEnabledForRegion,
    }
}
#[doc = "The result of update workspace quota."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateWorkspaceQuotasResult {
    #[doc = "The list of workspace quota update result."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<UpdateWorkspaceQuotas>,
    #[doc = "The URI to fetch the next page of workspace quota update result. Call ListNext() with this to fetch the next page of Workspace Quota update result."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UpdateWorkspaceQuotasResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes AML Resource Usage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Usage {
    #[doc = "Specifies the resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Region of the AML workspace in the id."]
    #[serde(rename = "amlWorkspaceLocation", default, skip_serializing_if = "Option::is_none")]
    pub aml_workspace_location: Option<String>,
    #[doc = "Specifies the resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "An enum describing the unit of usage measurement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<usage::Unit>,
    #[doc = "The current usage of the resource."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[doc = "The maximum permitted usage of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "The Usage Names."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<UsageName>,
}
impl Usage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod usage {
    use super::*;
    #[doc = "An enum describing the unit of usage measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[doc = "The Usage Names."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "The localized name of the resource."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Settings for user account that gets created on each on the nodes of a compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserAccountCredentials {
    #[doc = "Name of the administrator user account which can be used to SSH to nodes."]
    #[serde(rename = "adminUserName")]
    pub admin_user_name: String,
    #[doc = "SSH public key of the administrator user account."]
    #[serde(rename = "adminUserSshPublicKey", default, skip_serializing_if = "Option::is_none")]
    pub admin_user_ssh_public_key: Option<String>,
    #[doc = "Password of the administrator user account."]
    #[serde(rename = "adminUserPassword", default, skip_serializing_if = "Option::is_none")]
    pub admin_user_password: Option<String>,
}
impl UserAccountCredentials {
    pub fn new(admin_user_name: String) -> Self {
        Self {
            admin_user_name,
            admin_user_ssh_public_key: None,
            admin_user_password: None,
        }
    }
}
#[doc = "dictionary containing all the user assigned identities, with resourceId of the UAI as key."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserAssignedIdentities {}
impl UserAssignedIdentities {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "User Assigned Identity"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserAssignedIdentity {
    #[doc = "The principal ID of the user assigned identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The tenant ID of the user assigned identity."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The clientId(aka appId) of the user assigned identity."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
}
impl UserAssignedIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "User assigned identities associated with a resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserAssignedIdentityMeta {
    #[doc = "Aka application ID, a unique identifier generated by Azure AD that is tied to an application and service principal during its initial provisioning."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[doc = "The object ID of the service principal object for your managed identity that is used to grant role-based access to an Azure resource."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
}
impl UserAssignedIdentityMeta {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Machine Learning compute based on Azure Virtual Machines."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachine {
    #[serde(flatten)]
    pub compute: Compute,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<virtual_machine::Properties>,
}
impl VirtualMachine {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod virtual_machine {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Virtual Machine size"]
        #[serde(rename = "virtualMachineSize", default, skip_serializing_if = "Option::is_none")]
        pub virtual_machine_size: Option<String>,
        #[doc = "Port open for ssh connections."]
        #[serde(rename = "sshPort", default, skip_serializing_if = "Option::is_none")]
        pub ssh_port: Option<i32>,
        #[doc = "Public IP address of the virtual machine."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub address: Option<String>,
        #[doc = "Admin credentials for virtual machine"]
        #[serde(rename = "administratorAccount", default, skip_serializing_if = "Option::is_none")]
        pub administrator_account: Option<VirtualMachineSshCredentials>,
        #[doc = "Indicates whether this compute will be used for running notebooks."]
        #[serde(rename = "isNotebookInstanceCompute", default, skip_serializing_if = "Option::is_none")]
        pub is_notebook_instance_compute: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Virtual Machine image for Windows AML Compute"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineImage {
    #[doc = "Virtual Machine image path"]
    pub id: String,
}
impl VirtualMachineImage {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "Secrets related to a Machine Learning compute based on AKS."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineSecrets {
    #[serde(flatten)]
    pub compute_secrets: ComputeSecrets,
    #[doc = "Admin credentials for virtual machine"]
    #[serde(rename = "administratorAccount", default, skip_serializing_if = "Option::is_none")]
    pub administrator_account: Option<VirtualMachineSshCredentials>,
}
impl VirtualMachineSecrets {
    pub fn new(compute_secrets: ComputeSecrets) -> Self {
        Self {
            compute_secrets,
            administrator_account: None,
        }
    }
}
#[doc = "Describes the properties of a VM size."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSize {
    #[doc = "The name of the virtual machine size."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The family name of the virtual machine size."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[doc = "The number of vCPUs supported by the virtual machine size."]
    #[serde(rename = "vCPUs", default, skip_serializing_if = "Option::is_none")]
    pub v_cp_us: Option<i32>,
    #[doc = "The number of gPUs supported by the virtual machine size."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub gpus: Option<i32>,
    #[doc = "The OS VHD disk size, in MB, allowed by the virtual machine size."]
    #[serde(rename = "osVhdSizeMB", default, skip_serializing_if = "Option::is_none")]
    pub os_vhd_size_mb: Option<i32>,
    #[doc = "The resource volume size, in MB, allowed by the virtual machine size."]
    #[serde(rename = "maxResourceVolumeMB", default, skip_serializing_if = "Option::is_none")]
    pub max_resource_volume_mb: Option<i32>,
    #[doc = "The amount of memory, in GB, supported by the virtual machine size."]
    #[serde(rename = "memoryGB", default, skip_serializing_if = "Option::is_none")]
    pub memory_gb: Option<f64>,
    #[doc = "Specifies if the virtual machine size supports low priority VMs."]
    #[serde(rename = "lowPriorityCapable", default, skip_serializing_if = "Option::is_none")]
    pub low_priority_capable: Option<bool>,
    #[doc = "Specifies if the virtual machine size supports premium IO."]
    #[serde(rename = "premiumIO", default, skip_serializing_if = "Option::is_none")]
    pub premium_io: Option<bool>,
    #[doc = "The estimated price info for using a VM."]
    #[serde(rename = "estimatedVMPrices", default, skip_serializing_if = "Option::is_none")]
    pub estimated_vm_prices: Option<EstimatedVmPrices>,
}
impl VirtualMachineSize {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Virtual Machine size operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSizeListResult {
    #[doc = "The list of virtual machine sizes supported by AmlCompute."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualMachineSize>,
}
impl VirtualMachineSizeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Admin credentials for virtual machine"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSshCredentials {
    #[doc = "Username of admin account"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "Password of admin account"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[doc = "Public key data"]
    #[serde(rename = "publicKeyData", default, skip_serializing_if = "Option::is_none")]
    pub public_key_data: Option<String>,
    #[doc = "Private key data"]
    #[serde(rename = "privateKeyData", default, skip_serializing_if = "Option::is_none")]
    pub private_key_data: Option<String>,
}
impl VirtualMachineSshCredentials {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An object that represents a machine learning workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Workspace {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of a machine learning workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkspaceProperties>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<Identity>,
    #[doc = "Specifies the location of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Contains resource tags defined as key/value pairs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Sku of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl Workspace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Workspace connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceConnection {
    #[doc = "ResourceId of the workspace connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Friendly name of the workspace connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type of workspace connection."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Workspace Connection specific properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkspaceConnectionProps>,
}
impl WorkspaceConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Workspace Connection specific properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceConnectionProps {
    #[doc = "Category of the workspace connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[doc = "Target of the workspace connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "Authorization type of the workspace connection."]
    #[serde(rename = "authType", default, skip_serializing_if = "Option::is_none")]
    pub auth_type: Option<String>,
    #[doc = "Value details of the workspace connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "format for the workspace connection value"]
    #[serde(rename = "valueFormat", default, skip_serializing_if = "Option::is_none")]
    pub value_format: Option<workspace_connection_props::ValueFormat>,
}
impl WorkspaceConnectionProps {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod workspace_connection_props {
    use super::*;
    #[doc = "format for the workspace connection value"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ValueFormat {
        #[serde(rename = "JSON")]
        Json,
    }
}
#[doc = "The result of a request to list machine learning workspaces."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceListResult {
    #[doc = "The list of machine learning workspaces. Since this list may be incomplete, the nextLink field should be used to request the next list of machine learning workspaces."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Workspace>,
    #[doc = "The URI that can be used to request the next list of machine learning workspaces."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkspaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a machine learning workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceProperties {
    #[doc = "The immutable id associated with this workspace."]
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[doc = "The description of this workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The friendly name for this workspace. This name in mutable"]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created"]
    #[serde(rename = "keyVault", default, skip_serializing_if = "Option::is_none")]
    pub key_vault: Option<String>,
    #[doc = "ARM id of the application insights associated with this workspace. This cannot be changed once the workspace has been created"]
    #[serde(rename = "applicationInsights", default, skip_serializing_if = "Option::is_none")]
    pub application_insights: Option<String>,
    #[doc = "ARM id of the container registry associated with this workspace. This cannot be changed once the workspace has been created"]
    #[serde(rename = "containerRegistry", default, skip_serializing_if = "Option::is_none")]
    pub container_registry: Option<String>,
    #[doc = "ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created"]
    #[serde(rename = "storageAccount", default, skip_serializing_if = "Option::is_none")]
    pub storage_account: Option<String>,
    #[doc = "Url for the discovery service to identify regional endpoints for machine learning experimentation services"]
    #[serde(rename = "discoveryUrl", default, skip_serializing_if = "Option::is_none")]
    pub discovery_url: Option<String>,
    #[doc = "The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<workspace_properties::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionProperty>,
    #[doc = "The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service"]
    #[serde(rename = "hbiWorkspace", default, skip_serializing_if = "Option::is_none")]
    pub hbi_workspace: Option<bool>,
    #[doc = "The name of the managed resource group created by workspace RP in customer subscription if the workspace is CMK workspace"]
    #[serde(rename = "serviceProvisionedResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub service_provisioned_resource_group: Option<String>,
    #[doc = "Count of private connections in the workspace"]
    #[serde(rename = "privateLinkCount", default, skip_serializing_if = "Option::is_none")]
    pub private_link_count: Option<i32>,
    #[doc = "The compute name for image build"]
    #[serde(rename = "imageBuildCompute", default, skip_serializing_if = "Option::is_none")]
    pub image_build_compute: Option<String>,
    #[doc = "The flag to indicate whether to allow public access when behind VNet."]
    #[serde(rename = "allowPublicAccessWhenBehindVnet", default, skip_serializing_if = "Option::is_none")]
    pub allow_public_access_when_behind_vnet: Option<bool>,
    #[doc = "The list of private endpoint connections in the workspace."]
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[doc = "The list of shared private link resources in this workspace."]
    #[serde(rename = "sharedPrivateLinkResources", default, skip_serializing_if = "Vec::is_empty")]
    pub shared_private_link_resources: Vec<SharedPrivateLinkResource>,
    #[serde(rename = "notebookInfo", default, skip_serializing_if = "Option::is_none")]
    pub notebook_info: Option<NotebookResourceInfo>,
    #[serde(rename = "serviceManagedResourcesSettings", default, skip_serializing_if = "Option::is_none")]
    pub service_managed_resources_settings: Option<ServiceManagedResourcesSettings>,
    #[doc = "The user assigned identity resource id that represents the workspace identity."]
    #[serde(rename = "primaryUserAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub primary_user_assigned_identity: Option<String>,
    #[doc = "The tenant id associated with this workspace."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl WorkspaceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod workspace_properties {
    use super::*;
    #[doc = "The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Unknown,
        Updating,
        Creating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The parameters for updating the properties of a machine learning workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspacePropertiesUpdateParameters {
    #[doc = "The description of this workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The friendly name for this workspace."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The compute name for image build"]
    #[serde(rename = "imageBuildCompute", default, skip_serializing_if = "Option::is_none")]
    pub image_build_compute: Option<String>,
    #[serde(rename = "serviceManagedResourcesSettings", default, skip_serializing_if = "Option::is_none")]
    pub service_managed_resources_settings: Option<ServiceManagedResourcesSettings>,
    #[doc = "The user assigned identity resource id that represents the workspace identity."]
    #[serde(rename = "primaryUserAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub primary_user_assigned_identity: Option<String>,
}
impl WorkspacePropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes Workspace Sku details and features"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceSku {
    #[doc = "The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.)."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[doc = "A list of locations and availability zones in those locations where the SKU is available."]
    #[serde(rename = "locationInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub location_info: Vec<ResourceSkuLocationInfo>,
    #[doc = "Sku Tier like Basic or Enterprise"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "List of features/user capabilities associated with the sku"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<SkuCapability>,
    #[doc = "The restrictions because of which SKU cannot be used. This is empty if there are no restrictions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub restrictions: Vec<Restriction>,
}
impl WorkspaceSku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for updating a machine learning workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceUpdateParameters {
    #[doc = "The resource tags for the machine learning workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Sku of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<Identity>,
    #[doc = "The parameters for updating the properties of a machine learning workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkspacePropertiesUpdateParameters>,
}
impl WorkspaceUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metadata pertaining to creation and last modification of the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[doc = "The identity that created the resource."]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[doc = "The type of identity that created the resource."]
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[doc = "The timestamp of resource creation (UTC)."]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "The identity that last modified the resource."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[doc = "The timestamp of resource last modification (UTC)"]
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[doc = "The type of identity that created the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[doc = "The type of identity that last modified the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
