#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AciServiceCreateRequest {
    #[serde(flatten)]
    pub create_service_request: CreateServiceRequest,
    #[doc = "The resource requirements for the container (cpu and memory)."]
    #[serde(rename = "containerResourceRequirements", default, skip_serializing_if = "Option::is_none")]
    pub container_resource_requirements: Option<ContainerResourceRequirements>,
    #[doc = "Whether or not authentication is enabled on the service."]
    #[serde(rename = "authEnabled", default, skip_serializing_if = "Option::is_none")]
    pub auth_enabled: Option<bool>,
    #[doc = "Whether or not SSL is enabled."]
    #[serde(rename = "sslEnabled", default, skip_serializing_if = "Option::is_none")]
    pub ssl_enabled: Option<bool>,
    #[doc = "Whether or not Application Insights is enabled."]
    #[serde(rename = "appInsightsEnabled", default, skip_serializing_if = "Option::is_none")]
    pub app_insights_enabled: Option<bool>,
    #[doc = "Details of the data collection options specified."]
    #[serde(rename = "dataCollection", default, skip_serializing_if = "Option::is_none")]
    pub data_collection: Option<serde_json::Value>,
    #[doc = "The public SSL certificate in PEM format to use if SSL is enabled."]
    #[serde(rename = "sslCertificate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_certificate: Option<String>,
    #[doc = "The public SSL key in PEM format for the certificate."]
    #[serde(rename = "sslKey", default, skip_serializing_if = "Option::is_none")]
    pub ssl_key: Option<String>,
    #[doc = "The CName for the service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cname: Option<String>,
    #[doc = "The Dns label for the service."]
    #[serde(rename = "dnsNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub dns_name_label: Option<String>,
    #[doc = "The virtual network configuration."]
    #[serde(rename = "vnetConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub vnet_configuration: Option<serde_json::Value>,
    #[doc = "The encryption properties."]
    #[serde(rename = "encryptionProperties", default, skip_serializing_if = "Option::is_none")]
    pub encryption_properties: Option<serde_json::Value>,
}
impl AciServiceCreateRequest {
    pub fn new(create_service_request: CreateServiceRequest) -> Self {
        Self {
            create_service_request,
            container_resource_requirements: None,
            auth_enabled: None,
            ssl_enabled: None,
            app_insights_enabled: None,
            data_collection: None,
            ssl_certificate: None,
            ssl_key: None,
            cname: None,
            dns_name_label: None,
            vnet_configuration: None,
            encryption_properties: None,
        }
    }
}
#[doc = "The response for an ACI service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AciServiceResponse {
    #[serde(flatten)]
    pub service_response_base: ServiceResponseBase,
    #[doc = "The resource requirements for the container (cpu and memory)."]
    #[serde(rename = "containerResourceRequirements", default, skip_serializing_if = "Option::is_none")]
    pub container_resource_requirements: Option<ContainerResourceRequirements>,
    #[doc = "The Uri for sending scoring requests."]
    #[serde(rename = "scoringUri", default, skip_serializing_if = "Option::is_none")]
    pub scoring_uri: Option<String>,
    #[doc = "The name of the Azure location/region."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Whether or not authentication is enabled on the service."]
    #[serde(rename = "authEnabled", default, skip_serializing_if = "Option::is_none")]
    pub auth_enabled: Option<bool>,
    #[doc = "Whether or not SSL is enabled."]
    #[serde(rename = "sslEnabled", default, skip_serializing_if = "Option::is_none")]
    pub ssl_enabled: Option<bool>,
    #[doc = "Whether or not Application Insights is enabled."]
    #[serde(rename = "appInsightsEnabled", default, skip_serializing_if = "Option::is_none")]
    pub app_insights_enabled: Option<bool>,
    #[doc = "Details of the data collection options specified."]
    #[serde(rename = "dataCollection", default, skip_serializing_if = "Option::is_none")]
    pub data_collection: Option<serde_json::Value>,
    #[doc = "The public SSL certificate in PEM format to use if SSL is enabled."]
    #[serde(rename = "sslCertificate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_certificate: Option<String>,
    #[doc = "The public SSL key in PEM format for the certificate."]
    #[serde(rename = "sslKey", default, skip_serializing_if = "Option::is_none")]
    pub ssl_key: Option<String>,
    #[doc = "The CName for the service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cname: Option<String>,
    #[doc = "The public IP address for the service."]
    #[serde(rename = "publicIp", default, skip_serializing_if = "Option::is_none")]
    pub public_ip: Option<String>,
    #[doc = "The public Fqdn for the service."]
    #[serde(rename = "publicFqdn", default, skip_serializing_if = "Option::is_none")]
    pub public_fqdn: Option<String>,
    #[doc = "The Uri for sending swagger requests."]
    #[serde(rename = "swaggerUri", default, skip_serializing_if = "Option::is_none")]
    pub swagger_uri: Option<String>,
    #[doc = "Details on the models and configurations."]
    #[serde(rename = "modelConfigMap", default, skip_serializing_if = "Option::is_none")]
    pub model_config_map: Option<serde_json::Value>,
    #[doc = "The list of models."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub models: Vec<Model>,
    #[doc = "The Environment, models and assets used for inferencing."]
    #[serde(rename = "environmentImageRequest", default, skip_serializing_if = "Option::is_none")]
    pub environment_image_request: Option<serde_json::Value>,
    #[doc = "The virtual network configuration."]
    #[serde(rename = "vnetConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub vnet_configuration: Option<serde_json::Value>,
    #[doc = "The encryption properties."]
    #[serde(rename = "encryptionProperties", default, skip_serializing_if = "Option::is_none")]
    pub encryption_properties: Option<serde_json::Value>,
}
impl AciServiceResponse {
    pub fn new(service_response_base: ServiceResponseBase) -> Self {
        Self {
            service_response_base,
            container_resource_requirements: None,
            scoring_uri: None,
            location: None,
            auth_enabled: None,
            ssl_enabled: None,
            app_insights_enabled: None,
            data_collection: None,
            ssl_certificate: None,
            ssl_key: None,
            cname: None,
            public_ip: None,
            public_fqdn: None,
            swagger_uri: None,
            model_config_map: None,
            models: Vec::new(),
            environment_image_request: None,
            vnet_configuration: None,
            encryption_properties: None,
        }
    }
}
#[doc = "A Machine Learning compute based on AKS."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Aks {
    #[serde(flatten)]
    pub compute: Compute,
    #[doc = "AKS properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<aks::Properties>,
}
impl Aks {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod aks {
    use super::*;
    #[doc = "AKS properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Cluster full qualified domain name"]
        #[serde(rename = "clusterFqdn", default, skip_serializing_if = "Option::is_none")]
        pub cluster_fqdn: Option<String>,
        #[doc = "System services"]
        #[serde(rename = "systemServices", default, skip_serializing_if = "Vec::is_empty")]
        pub system_services: Vec<SystemService>,
        #[doc = "Number of agents"]
        #[serde(rename = "agentCount", default, skip_serializing_if = "Option::is_none")]
        pub agent_count: Option<i32>,
        #[doc = "Agent virtual machine size"]
        #[serde(rename = "agentVMSize", default, skip_serializing_if = "Option::is_none")]
        pub agent_vm_size: Option<String>,
        #[doc = "The ssl configuration for scoring"]
        #[serde(rename = "sslConfiguration", default, skip_serializing_if = "Option::is_none")]
        pub ssl_configuration: Option<SslConfiguration>,
        #[doc = "Advance configuration for AKS networking"]
        #[serde(rename = "aksNetworkingConfiguration", default, skip_serializing_if = "Option::is_none")]
        pub aks_networking_configuration: Option<AksNetworkingConfiguration>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AksReplicaStatus {
    #[doc = "The desired number of replicas."]
    #[serde(rename = "desiredReplicas", default, skip_serializing_if = "Option::is_none")]
    pub desired_replicas: Option<i32>,
    #[doc = "The number of updated replicas."]
    #[serde(rename = "updatedReplicas", default, skip_serializing_if = "Option::is_none")]
    pub updated_replicas: Option<i32>,
    #[doc = "The number of available replicas."]
    #[serde(rename = "availableReplicas", default, skip_serializing_if = "Option::is_none")]
    pub available_replicas: Option<i32>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
}
impl AksReplicaStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The request to create an AKS service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AksServiceCreateRequest {
    #[serde(flatten)]
    pub create_endpoint_variant_request: CreateEndpointVariantRequest,
    #[doc = "The number of replicas on the cluster."]
    #[serde(rename = "numReplicas", default, skip_serializing_if = "Option::is_none")]
    pub num_replicas: Option<i32>,
    #[doc = "Details of the data collection options specified."]
    #[serde(rename = "dataCollection", default, skip_serializing_if = "Option::is_none")]
    pub data_collection: Option<serde_json::Value>,
    #[doc = "The name of the compute resource."]
    #[serde(rename = "computeName", default, skip_serializing_if = "Option::is_none")]
    pub compute_name: Option<String>,
    #[doc = "Whether or not Application Insights is enabled."]
    #[serde(rename = "appInsightsEnabled", default, skip_serializing_if = "Option::is_none")]
    pub app_insights_enabled: Option<bool>,
    #[doc = "The auto scaler properties."]
    #[serde(rename = "autoScaler", default, skip_serializing_if = "Option::is_none")]
    pub auto_scaler: Option<serde_json::Value>,
    #[doc = "The resource requirements for the container (cpu and memory)."]
    #[serde(rename = "containerResourceRequirements", default, skip_serializing_if = "Option::is_none")]
    pub container_resource_requirements: Option<ContainerResourceRequirements>,
    #[doc = "The maximum number of concurrent requests per container."]
    #[serde(rename = "maxConcurrentRequestsPerContainer", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_requests_per_container: Option<i32>,
    #[doc = "Maximum time a request will wait in the queue (in milliseconds). After this time, the service will return 503 (Service Unavailable)"]
    #[serde(rename = "maxQueueWaitMs", default, skip_serializing_if = "Option::is_none")]
    pub max_queue_wait_ms: Option<i32>,
    #[doc = "Kubernetes namespace for the service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespace: Option<String>,
    #[doc = "The scoring timeout in milliseconds."]
    #[serde(rename = "scoringTimeoutMs", default, skip_serializing_if = "Option::is_none")]
    pub scoring_timeout_ms: Option<i32>,
    #[doc = "Whether or not authentication is enabled."]
    #[serde(rename = "authEnabled", default, skip_serializing_if = "Option::is_none")]
    pub auth_enabled: Option<bool>,
    #[doc = "The liveness probe requirements."]
    #[serde(rename = "livenessProbeRequirements", default, skip_serializing_if = "Option::is_none")]
    pub liveness_probe_requirements: Option<serde_json::Value>,
    #[doc = "Whether or not AAD authentication is enabled."]
    #[serde(rename = "aadAuthEnabled", default, skip_serializing_if = "Option::is_none")]
    pub aad_auth_enabled: Option<bool>,
}
impl AksServiceCreateRequest {
    pub fn new(create_endpoint_variant_request: CreateEndpointVariantRequest) -> Self {
        Self {
            create_endpoint_variant_request,
            num_replicas: None,
            data_collection: None,
            compute_name: None,
            app_insights_enabled: None,
            auto_scaler: None,
            container_resource_requirements: None,
            max_concurrent_requests_per_container: None,
            max_queue_wait_ms: None,
            namespace: None,
            scoring_timeout_ms: None,
            auth_enabled: None,
            liveness_probe_requirements: None,
            aad_auth_enabled: None,
        }
    }
}
#[doc = "The response for an AKS service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AksServiceResponse {
    #[serde(flatten)]
    pub aks_variant_response: AksVariantResponse,
    #[doc = "The list of models."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub models: Vec<Model>,
    #[doc = "The resource requirements for the container (cpu and memory)."]
    #[serde(rename = "containerResourceRequirements", default, skip_serializing_if = "Option::is_none")]
    pub container_resource_requirements: Option<ContainerResourceRequirements>,
    #[doc = "The maximum number of concurrent requests per container."]
    #[serde(rename = "maxConcurrentRequestsPerContainer", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_requests_per_container: Option<i32>,
    #[doc = "Maximum time a request will wait in the queue (in milliseconds). After this time, the service will return 503 (Service Unavailable)"]
    #[serde(rename = "maxQueueWaitMs", default, skip_serializing_if = "Option::is_none")]
    pub max_queue_wait_ms: Option<i32>,
    #[doc = "The name of the compute resource."]
    #[serde(rename = "computeName", default, skip_serializing_if = "Option::is_none")]
    pub compute_name: Option<String>,
    #[doc = "The Kubernetes namespace of the deployment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespace: Option<String>,
    #[doc = "The number of replicas on the cluster."]
    #[serde(rename = "numReplicas", default, skip_serializing_if = "Option::is_none")]
    pub num_replicas: Option<i32>,
    #[doc = "Details of the data collection options specified."]
    #[serde(rename = "dataCollection", default, skip_serializing_if = "Option::is_none")]
    pub data_collection: Option<serde_json::Value>,
    #[doc = "Whether or not Application Insights is enabled."]
    #[serde(rename = "appInsightsEnabled", default, skip_serializing_if = "Option::is_none")]
    pub app_insights_enabled: Option<bool>,
    #[doc = "The auto scaler properties."]
    #[serde(rename = "autoScaler", default, skip_serializing_if = "Option::is_none")]
    pub auto_scaler: Option<serde_json::Value>,
    #[doc = "The Uri for sending scoring requests."]
    #[serde(rename = "scoringUri", default, skip_serializing_if = "Option::is_none")]
    pub scoring_uri: Option<String>,
    #[doc = "The deployment status."]
    #[serde(rename = "deploymentStatus", default, skip_serializing_if = "Option::is_none")]
    pub deployment_status: Option<serde_json::Value>,
    #[doc = "The scoring timeout in milliseconds."]
    #[serde(rename = "scoringTimeoutMs", default, skip_serializing_if = "Option::is_none")]
    pub scoring_timeout_ms: Option<i32>,
    #[doc = "The liveness probe requirements."]
    #[serde(rename = "livenessProbeRequirements", default, skip_serializing_if = "Option::is_none")]
    pub liveness_probe_requirements: Option<serde_json::Value>,
    #[doc = "Whether or not authentication is enabled."]
    #[serde(rename = "authEnabled", default, skip_serializing_if = "Option::is_none")]
    pub auth_enabled: Option<bool>,
    #[doc = "Whether or not AAD authentication is enabled."]
    #[serde(rename = "aadAuthEnabled", default, skip_serializing_if = "Option::is_none")]
    pub aad_auth_enabled: Option<bool>,
    #[doc = "The Uri for sending swagger requests."]
    #[serde(rename = "swaggerUri", default, skip_serializing_if = "Option::is_none")]
    pub swagger_uri: Option<String>,
    #[doc = "Details on the models and configurations."]
    #[serde(rename = "modelConfigMap", default, skip_serializing_if = "Option::is_none")]
    pub model_config_map: Option<serde_json::Value>,
    #[doc = "The Environment, models and assets used for inferencing."]
    #[serde(rename = "environmentImageRequest", default, skip_serializing_if = "Option::is_none")]
    pub environment_image_request: Option<serde_json::Value>,
}
impl AksServiceResponse {
    pub fn new(aks_variant_response: AksVariantResponse) -> Self {
        Self {
            aks_variant_response,
            models: Vec::new(),
            container_resource_requirements: None,
            max_concurrent_requests_per_container: None,
            max_queue_wait_ms: None,
            compute_name: None,
            namespace: None,
            num_replicas: None,
            data_collection: None,
            app_insights_enabled: None,
            auto_scaler: None,
            scoring_uri: None,
            deployment_status: None,
            scoring_timeout_ms: None,
            liveness_probe_requirements: None,
            auth_enabled: None,
            aad_auth_enabled: None,
            swagger_uri: None,
            model_config_map: None,
            environment_image_request: None,
        }
    }
}
#[doc = "The response for an AKS variant."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AksVariantResponse {
    #[serde(flatten)]
    pub service_response_base: ServiceResponseBase,
    #[doc = "Is this the default variant."]
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[doc = "The amount of traffic variant receives."]
    #[serde(rename = "trafficPercentile", default, skip_serializing_if = "Option::is_none")]
    pub traffic_percentile: Option<f32>,
    #[doc = "The type of the variant."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<aks_variant_response::Type>,
}
impl AksVariantResponse {
    pub fn new(service_response_base: ServiceResponseBase) -> Self {
        Self {
            service_response_base,
            is_default: None,
            traffic_percentile: None,
            type_: None,
        }
    }
}
pub mod aks_variant_response {
    use super::*;
    #[doc = "The type of the variant."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Control,
        Treatment,
    }
}
#[doc = "Secrets related to a Machine Learning compute based on AKS."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AksComputeSecrets {
    #[serde(flatten)]
    pub compute_secrets: ComputeSecrets,
    #[doc = "Content of kubeconfig file that can be used to connect to the Kubernetes cluster."]
    #[serde(rename = "userKubeConfig", default, skip_serializing_if = "Option::is_none")]
    pub user_kube_config: Option<String>,
    #[doc = "Content of kubeconfig file that can be used to connect to the Kubernetes cluster."]
    #[serde(rename = "adminKubeConfig", default, skip_serializing_if = "Option::is_none")]
    pub admin_kube_config: Option<String>,
    #[doc = "Image registry pull secret."]
    #[serde(rename = "imagePullSecretName", default, skip_serializing_if = "Option::is_none")]
    pub image_pull_secret_name: Option<String>,
}
impl AksComputeSecrets {
    pub fn new(compute_secrets: ComputeSecrets) -> Self {
        Self {
            compute_secrets,
            user_kube_config: None,
            admin_kube_config: None,
            image_pull_secret_name: None,
        }
    }
}
#[doc = "Advance configuration for AKS networking"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AksNetworkingConfiguration {
    #[doc = "Virtual network subnet resource ID the compute nodes belong to"]
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[doc = "A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges."]
    #[serde(rename = "serviceCidr", default, skip_serializing_if = "Option::is_none")]
    pub service_cidr: Option<String>,
    #[doc = "An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr."]
    #[serde(rename = "dnsServiceIP", default, skip_serializing_if = "Option::is_none")]
    pub dns_service_ip: Option<String>,
    #[doc = "A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range."]
    #[serde(rename = "dockerBridgeCidr", default, skip_serializing_if = "Option::is_none")]
    pub docker_bridge_cidr: Option<String>,
}
impl AksNetworkingConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Machine Learning compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmlCompute {
    #[serde(flatten)]
    pub compute: Compute,
    #[doc = "AML Compute properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<aml_compute::Properties>,
}
impl AmlCompute {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod aml_compute {
    use super::*;
    #[doc = "AML Compute properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Virtual Machine Size"]
        #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
        pub vm_size: Option<String>,
        #[doc = "Virtual Machine priority"]
        #[serde(rename = "vmPriority", default, skip_serializing_if = "Option::is_none")]
        pub vm_priority: Option<properties::VmPriority>,
        #[doc = "scale settings for AML Compute"]
        #[serde(rename = "scaleSettings", default, skip_serializing_if = "Option::is_none")]
        pub scale_settings: Option<ScaleSettings>,
        #[doc = "Settings for user account that gets created on each on the nodes of a compute."]
        #[serde(rename = "userAccountCredentials", default, skip_serializing_if = "Option::is_none")]
        pub user_account_credentials: Option<UserAccountCredentials>,
        #[doc = "Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subnet: Option<ResourceId>,
        #[doc = "State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled."]
        #[serde(rename = "remoteLoginPortPublicAccess", default, skip_serializing_if = "Option::is_none")]
        pub remote_login_port_public_access: Option<properties::RemoteLoginPortPublicAccess>,
        #[doc = "Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute."]
        #[serde(rename = "allocationState", default, skip_serializing_if = "Option::is_none")]
        pub allocation_state: Option<properties::AllocationState>,
        #[doc = "The time at which the compute entered its current allocation state."]
        #[serde(rename = "allocationStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
        pub allocation_state_transition_time: Option<String>,
        #[doc = "Collection of errors encountered by various compute nodes during node setup."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub errors: Vec<MachineLearningServiceError>,
        #[doc = "The number of compute nodes currently assigned to the compute."]
        #[serde(rename = "currentNodeCount", default, skip_serializing_if = "Option::is_none")]
        pub current_node_count: Option<i32>,
        #[doc = "The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation."]
        #[serde(rename = "targetNodeCount", default, skip_serializing_if = "Option::is_none")]
        pub target_node_count: Option<i32>,
        #[doc = "Counts of various compute node states on the amlCompute."]
        #[serde(rename = "nodeStateCounts", default, skip_serializing_if = "Option::is_none")]
        pub node_state_counts: Option<NodeStateCounts>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Virtual Machine priority"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum VmPriority {
            Dedicated,
            LowPriority,
        }
        #[doc = "State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RemoteLoginPortPublicAccess {
            Enabled,
            Disabled,
            NotSpecified,
        }
        impl Default for RemoteLoginPortPublicAccess {
            fn default() -> Self {
                Self::NotSpecified
            }
        }
        #[doc = "Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AllocationState {
            Steady,
            Resizing,
        }
    }
}
#[doc = "Compute node information related to a AmlCompute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmlComputeNodeInformation {
    #[doc = "ID of the compute node."]
    #[serde(rename = "nodeId", default, skip_serializing_if = "Option::is_none")]
    pub node_id: Option<String>,
    #[doc = "Private IP address of the compute node."]
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "Public IP address of the compute node."]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[doc = "SSH port number of the node."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<f64>,
    #[doc = "State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted."]
    #[serde(rename = "nodeState", default, skip_serializing_if = "Option::is_none")]
    pub node_state: Option<aml_compute_node_information::NodeState>,
    #[doc = "ID of the Experiment running on the node, if any else null."]
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
}
impl AmlComputeNodeInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod aml_compute_node_information {
    use super::*;
    #[doc = "State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeState {
        #[serde(rename = "idle")]
        Idle,
        #[serde(rename = "running")]
        Running,
        #[serde(rename = "preparing")]
        Preparing,
        #[serde(rename = "unusable")]
        Unusable,
        #[serde(rename = "leaving")]
        Leaving,
        #[serde(rename = "preempted")]
        Preempted,
    }
}
#[doc = "Compute node information related to a AmlCompute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmlComputeNodesInformation {
    #[serde(flatten)]
    pub compute_nodes_information: ComputeNodesInformation,
    #[doc = "The collection of returned AmlCompute nodes details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub nodes: Vec<AmlComputeNodeInformation>,
}
impl AmlComputeNodesInformation {
    pub fn new(compute_nodes_information: ComputeNodesInformation) -> Self {
        Self {
            compute_nodes_information,
            nodes: Vec::new(),
        }
    }
}
#[doc = "Features enabled for a workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmlUserFeature {
    #[doc = "Specifies the feature ID"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Specifies the feature name "]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Describes the feature for user experience"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl AmlUserFeature {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthKeys {
    #[doc = "The primary key."]
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[doc = "The secondary key."]
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
}
impl AuthKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Auto Scaler properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoScaler {
    #[doc = "Option to enable/disable auto scaling."]
    #[serde(rename = "autoscaleEnabled", default, skip_serializing_if = "Option::is_none")]
    pub autoscale_enabled: Option<bool>,
    #[doc = "The minimum number of replicas to scale down to."]
    #[serde(rename = "minReplicas", default, skip_serializing_if = "Option::is_none")]
    pub min_replicas: Option<i32>,
    #[doc = "The maximum number of replicas in the cluster."]
    #[serde(rename = "maxReplicas", default, skip_serializing_if = "Option::is_none")]
    pub max_replicas: Option<i32>,
    #[doc = "The target utilization percentage to use for determining whether to scale the cluster."]
    #[serde(rename = "targetUtilization", default, skip_serializing_if = "Option::is_none")]
    pub target_utilization: Option<i32>,
    #[doc = "The amount of seconds to wait between auto scale updates."]
    #[serde(rename = "refreshPeriodInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub refresh_period_in_seconds: Option<i32>,
}
impl AutoScaler {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Azure Data Lake credential type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureDataLakeCredentialTypes {
    None,
    ServicePrincipal,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataLakeSection {
    #[serde(flatten)]
    pub client_credentials: ClientCredentials,
    #[doc = "The Azure Data Lake store name."]
    #[serde(rename = "storeName", default, skip_serializing_if = "Option::is_none")]
    pub store_name: Option<String>,
    #[doc = "The Azure Data Lake credential type."]
    #[serde(rename = "credentialType", default, skip_serializing_if = "Option::is_none")]
    pub credential_type: Option<AzureDataLakeCredentialTypes>,
}
impl AzureDataLakeSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMySqlSection {
    #[serde(flatten)]
    pub azure_sql_section: AzureSqlSection,
}
impl AzureMySqlSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzurePostgreSqlSection {
    #[serde(flatten)]
    pub azure_sql_section: AzureSqlSection,
    #[doc = "Indicates SSL requirement of Azure Postgresql server."]
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<bool>,
}
impl AzurePostgreSqlSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure resource for datastore."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResourceDatastore {
    #[doc = "Subscription ID."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "Resource Group."]
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[doc = "Indicates which identity to use to authenticate service data access to customer's storage."]
    #[serde(rename = "serviceDataAccessAuthIdentity", default, skip_serializing_if = "Option::is_none")]
    pub service_data_access_auth_identity: Option<azure_resource_datastore::ServiceDataAccessAuthIdentity>,
}
impl AzureResourceDatastore {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_resource_datastore {
    use super::*;
    #[doc = "Indicates which identity to use to authenticate service data access to customer's storage."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceDataAccessAuthIdentity {
        None,
        WorkspaceSystemAssignedIdentity,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDatabaseSection {
    #[serde(flatten)]
    pub azure_sql_section: AzureSqlSection,
}
impl AzureSqlDatabaseSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlSection {
    #[serde(flatten)]
    pub client_credentials: ClientCredentials,
    #[doc = "The Azure SQL server name."]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "The Azure SQL database name."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "The server host endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
    #[doc = "The Azure SQL user id."]
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
    #[doc = "The Azure SQL user password."]
    #[serde(rename = "userPassword", default, skip_serializing_if = "Option::is_none")]
    pub user_password: Option<String>,
    #[doc = "/ The Azure SQL port number."]
    #[serde(rename = "portNumber", default, skip_serializing_if = "Option::is_none")]
    pub port_number: Option<String>,
    #[doc = "Sql Authentication type."]
    #[serde(rename = "credentialType", default, skip_serializing_if = "Option::is_none")]
    pub credential_type: Option<SqlCredentialTypes>,
}
impl AzureSqlSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = " The credential type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureStorageCredentialTypes {
    None,
    Sas,
    AccountKey,
    ClientCredentials,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageSection {
    #[serde(flatten)]
    pub azure_resource_datastore: AzureResourceDatastore,
    #[doc = "Storage Account Name."]
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[doc = "The storage container name."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The host of the container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
    #[doc = "The protocol to use. Defaults to https."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<String>,
    #[doc = " The credential type."]
    #[serde(rename = "credentialType", default, skip_serializing_if = "Option::is_none")]
    pub credential_type: Option<AzureStorageCredentialTypes>,
    #[doc = "The credential."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<String>,
    #[serde(rename = "clientCredentials", default, skip_serializing_if = "Option::is_none")]
    pub client_credentials: Option<ClientCredentials>,
    #[doc = " If this is an \"DataStoreType.AzureBlob\", the length of time (in seconds) to cache files locally after they are accessed (downloaded)."]
    #[serde(rename = "blobCacheTimeout", default, skip_serializing_if = "Option::is_none")]
    pub blob_cache_timeout: Option<i32>,
    #[doc = "Indicate if we are using SAS token or Account Key (Deprecated)."]
    #[serde(rename = "isSas", default, skip_serializing_if = "Option::is_none")]
    pub is_sas: Option<bool>,
    #[doc = " Storage Account Key (Deprecated)."]
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<String>,
    #[doc = " SAS Token for the container (Deprecated)."]
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<String>,
    #[doc = "Indicate if we are using Workspace ManagedIdentities/MSI token (Deprecated)."]
    #[serde(rename = "areWorkspaceManagedIdentitiesAllowed", default, skip_serializing_if = "Option::is_none")]
    pub are_workspace_managed_identities_allowed: Option<bool>,
}
impl AzureStorageSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientCredentials {
    #[serde(flatten)]
    pub azure_resource_datastore: AzureResourceDatastore,
    #[doc = "The Client ID/Application ID"]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[doc = "The ID of the tenant the service principal/app belongs to."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = " Is it using certificate to authenticate. If false then use client secret."]
    #[serde(rename = "isCertAuth", default, skip_serializing_if = "Option::is_none")]
    pub is_cert_auth: Option<bool>,
    #[doc = "The content of the certificate used for authentication."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<String>,
    #[doc = "The thumbprint of the certificate above."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "The client secret."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
    #[doc = "The authority URL used for authentication."]
    #[serde(rename = "authorityUrl", default, skip_serializing_if = "Option::is_none")]
    pub authority_url: Option<String>,
    #[doc = "The resource the service principal/app has access to."]
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ClientCredentials {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "AmlCompute update parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClusterUpdateParameters {
    #[doc = "The properties of a amlCompute that need to be updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ClusterUpdateProperties>,
}
impl ClusterUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a amlCompute that need to be updated."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClusterUpdateProperties {
    #[doc = "scale settings for AML Compute"]
    #[serde(rename = "scaleSettings", default, skip_serializing_if = "Option::is_none")]
    pub scale_settings: Option<ScaleSettings>,
}
impl ClusterUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Machine Learning compute object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Compute {
    #[doc = "The type of compute"]
    #[serde(rename = "computeType")]
    pub compute_type: ComputeType,
    #[doc = "Location for the underlying compute"]
    #[serde(rename = "computeLocation", default, skip_serializing_if = "Option::is_none")]
    pub compute_location: Option<String>,
    #[doc = "The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<compute::ProvisioningState>,
    #[doc = "The description of the Machine Learning compute."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The date and time when the compute was created."]
    #[serde(rename = "createdOn", default, skip_serializing_if = "Option::is_none")]
    pub created_on: Option<String>,
    #[doc = "The date and time when the compute was last modified."]
    #[serde(rename = "modifiedOn", default, skip_serializing_if = "Option::is_none")]
    pub modified_on: Option<String>,
    #[doc = "ARM resource id of the underlying compute"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "Errors during provisioning"]
    #[serde(rename = "provisioningErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub provisioning_errors: Vec<MachineLearningServiceError>,
    #[doc = "Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false."]
    #[serde(rename = "isAttachedCompute", default, skip_serializing_if = "Option::is_none")]
    pub is_attached_compute: Option<bool>,
}
impl Compute {
    pub fn new(compute_type: ComputeType) -> Self {
        Self {
            compute_type,
            compute_location: None,
            provisioning_state: None,
            description: None,
            created_on: None,
            modified_on: None,
            resource_id: None,
            provisioning_errors: Vec::new(),
            is_attached_compute: None,
        }
    }
}
pub mod compute {
    use super::*;
    #[doc = "The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Unknown,
        Updating,
        Creating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "Compute nodes information related to a Machine Learning compute. Might differ for every type of compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ComputeNodesInformation {
    #[doc = "The type of compute"]
    #[serde(rename = "computeType")]
    pub compute_type: ComputeType,
    #[doc = "The continuation token."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ComputeNodesInformation {
    pub fn new(compute_type: ComputeType) -> Self {
        Self {
            compute_type,
            next_link: None,
        }
    }
}
#[doc = "Machine Learning compute object wrapped into ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Machine Learning compute object."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Compute>,
}
impl ComputeResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Secrets related to a Machine Learning compute. Might differ for every type of compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ComputeSecrets {
    #[doc = "The type of compute"]
    #[serde(rename = "computeType")]
    pub compute_type: ComputeType,
}
impl ComputeSecrets {
    pub fn new(compute_type: ComputeType) -> Self {
        Self { compute_type }
    }
}
#[doc = "The type of compute"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ComputeType {
    #[serde(rename = "AKS")]
    Aks,
    AmlCompute,
    DataFactory,
    VirtualMachine,
    #[serde(rename = "HDInsight")]
    HdInsight,
    Databricks,
    DataLakeAnalytics,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistry {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl ContainerRegistry {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
}
impl ContainerRegistryResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource requirements for the container (cpu and memory)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerResourceRequirements {
    #[doc = "The number of CPU cores on the container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cpu: Option<f64>,
    #[doc = "The amount of memory on the container in GB."]
    #[serde(rename = "memoryInGB", default, skip_serializing_if = "Option::is_none")]
    pub memory_in_gb: Option<f64>,
    #[doc = "The number of GPU cores in the container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub gpu: Option<i32>,
    #[doc = "The number of FPGA PCIE devices exposed to the container. Must be multiple of 2."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fpga: Option<i32>,
}
impl ContainerResourceRequirements {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Variant properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateEndpointVariantRequest {
    #[serde(flatten)]
    pub create_service_request: CreateServiceRequest,
    #[doc = "Is this the default variant."]
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[doc = "The amount of traffic variant receives."]
    #[serde(rename = "trafficPercentile", default, skip_serializing_if = "Option::is_none")]
    pub traffic_percentile: Option<f32>,
    #[doc = "The type of the variant."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<create_endpoint_variant_request::Type>,
}
impl CreateEndpointVariantRequest {
    pub fn new(create_service_request: CreateServiceRequest) -> Self {
        Self {
            create_service_request,
            is_default: None,
            traffic_percentile: None,
            type_: None,
        }
    }
}
pub mod create_endpoint_variant_request {
    use super::*;
    #[doc = "The type of the variant."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Control,
        Treatment,
    }
}
#[doc = "The base class for creating a service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateServiceRequest {
    #[doc = "The description of the service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The service tag dictionary. Tags are mutable."]
    #[serde(rename = "kvTags", default, skip_serializing_if = "Option::is_none")]
    pub kv_tags: Option<serde_json::Value>,
    #[doc = "The service properties dictionary. Properties are immutable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "The authentication keys."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keys: Option<serde_json::Value>,
    #[doc = "The compute environment type for the service."]
    #[serde(rename = "computeType")]
    pub compute_type: create_service_request::ComputeType,
    #[doc = "The Environment, models and assets needed for inferencing."]
    #[serde(rename = "environmentImageRequest", default, skip_serializing_if = "Option::is_none")]
    pub environment_image_request: Option<serde_json::Value>,
    #[doc = "The name of the Azure location/region."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl CreateServiceRequest {
    pub fn new(compute_type: create_service_request::ComputeType) -> Self {
        Self {
            description: None,
            kv_tags: None,
            properties: None,
            keys: None,
            compute_type,
            environment_image_request: None,
            location: None,
        }
    }
}
pub mod create_service_request {
    use super::*;
    #[doc = "The compute environment type for the service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComputeType {
        #[serde(rename = "ACI")]
        Aci,
        #[serde(rename = "AKS")]
        Aks,
    }
}
#[doc = "A DataFactory compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFactory {
    #[serde(flatten)]
    pub compute: Compute,
}
impl DataFactory {
    pub fn new(compute: Compute) -> Self {
        Self { compute }
    }
}
#[doc = "A DataLakeAnalytics compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataLakeAnalytics {
    #[serde(flatten)]
    pub compute: Compute,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<data_lake_analytics::Properties>,
}
impl DataLakeAnalytics {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod data_lake_analytics {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "DataLake Store Account Name"]
        #[serde(rename = "dataLakeStoreAccountName", default, skip_serializing_if = "Option::is_none")]
        pub data_lake_store_account_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "A DataFactory compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Databricks {
    #[serde(flatten)]
    pub compute: Compute,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<databricks::Properties>,
}
impl Databricks {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod databricks {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Databricks access token"]
        #[serde(rename = "databricksAccessToken", default, skip_serializing_if = "Option::is_none")]
        pub databricks_access_token: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Secrets related to a Machine Learning compute based on Databricks."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksComputeSecrets {
    #[serde(flatten)]
    pub compute_secrets: ComputeSecrets,
    #[doc = "access token for databricks account."]
    #[serde(rename = "databricksAccessToken", default, skip_serializing_if = "Option::is_none")]
    pub databricks_access_token: Option<String>,
}
impl DatabricksComputeSecrets {
    pub fn new(compute_secrets: ComputeSecrets) -> Self {
        Self {
            compute_secrets,
            databricks_access_token: None,
        }
    }
}
#[doc = "Machine Learning dataset object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dataset {
    #[doc = "Unique Dataset identifier."]
    #[serde(rename = "datasetId", default, skip_serializing_if = "Option::is_none")]
    pub dataset_id: Option<String>,
    #[doc = "Dataset state"]
    #[serde(rename = "datasetState", default, skip_serializing_if = "Option::is_none")]
    pub dataset_state: Option<DatasetState>,
    #[doc = "Last created Dataset definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub latest: Option<dataset::Latest>,
    #[doc = "The dataset creation time (UTC)."]
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[doc = "The dataset last modified time (UTC)."]
    #[serde(rename = "modifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub modified_time: Option<String>,
    #[doc = "eTag description"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Unique dataset name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Description about this dataset version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Tags for this dataset version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Flag to hide Dataset in UI"]
    #[serde(rename = "isVisible", default, skip_serializing_if = "Option::is_none")]
    pub is_visible: Option<bool>,
    #[doc = "Name of the default compute to be used for any Dataset actions (such as Profile, Write)."]
    #[serde(rename = "defaultCompute", default, skip_serializing_if = "Option::is_none")]
    pub default_compute: Option<String>,
    #[doc = "Dataset Type."]
    #[serde(rename = "datasetType", default, skip_serializing_if = "Option::is_none")]
    pub dataset_type: Option<String>,
}
impl Dataset {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod dataset {
    use super::*;
    #[doc = "Last created Dataset definition."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Latest {
        #[doc = "Unique Dataset identifier."]
        #[serde(rename = "datasetId", default, skip_serializing_if = "Option::is_none")]
        pub dataset_id: Option<String>,
        #[doc = "An identifier uniquely identifies a definition change."]
        #[serde(rename = "versionId", default, skip_serializing_if = "Option::is_none")]
        pub version_id: Option<String>,
        #[doc = "Dataset state"]
        #[serde(rename = "datasetDefinitionState", default, skip_serializing_if = "Option::is_none")]
        pub dataset_definition_state: Option<DatasetState>,
        #[doc = "Dataflow Json"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub dataflow: Option<String>,
        #[doc = " Datastore and reference to location of data such as relativePath, Sql Query and etc."]
        #[serde(rename = "dataPath", default, skip_serializing_if = "Option::is_none")]
        pub data_path: Option<latest::DataPath>,
        #[doc = "Indicates how the source data is partitioned. This is defined to filter on a range of partitioned data before performing actions or materialization."]
        #[serde(rename = "partitionFormatInPath", default, skip_serializing_if = "Option::is_none")]
        pub partition_format_in_path: Option<bool>,
        #[doc = "Summary of Definition changes."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub notes: Option<String>,
        #[doc = "eTag description"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub etag: Option<String>,
        #[doc = "The dataset creation time (UTC)."]
        #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
        pub created_time: Option<String>,
        #[doc = "The dataset last modified time (UTC)."]
        #[serde(rename = "modifiedTime", default, skip_serializing_if = "Option::is_none")]
        pub modified_time: Option<String>,
        #[doc = "User who created."]
        #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
        pub created_by: Option<UserInfo>,
        #[doc = "Dataset FileType, specified by user."]
        #[serde(rename = "fileType", default, skip_serializing_if = "Option::is_none")]
        pub file_type: Option<String>,
        #[doc = "Properties stores information like name of time series column for time series dataset."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub properties: Option<serde_json::Value>,
        #[doc = "Indicates the saved dataset this definition is mapping to, populated on Get."]
        #[serde(rename = "savedDatasetId", default, skip_serializing_if = "Option::is_none")]
        pub saved_dataset_id: Option<String>,
        #[doc = " Telemetry information about the dataset including information like which service the dataset was created from."]
        #[serde(rename = "telemetryInfo", default, skip_serializing_if = "Option::is_none")]
        pub telemetry_info: Option<serde_json::Value>,
        #[doc = " Whether to use description and tags from the definition level as opposed to dataset level (old behavior)."]
        #[serde(rename = "useDescriptionTagsFromDefinition", default, skip_serializing_if = "Option::is_none")]
        pub use_description_tags_from_definition: Option<bool>,
        #[doc = "Description about the dataset."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[doc = "Tags associated with the dataset."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub tags: Option<serde_json::Value>,
    }
    impl Latest {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod latest {
        use super::*;
        #[doc = " Datastore and reference to location of data such as relativePath, Sql Query and etc."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
        pub struct DataPath {
            #[doc = "Data store Name"]
            #[serde(rename = "datastoreName", default, skip_serializing_if = "Option::is_none")]
            pub datastore_name: Option<String>,
            #[doc = "Relative path in the data store"]
            #[serde(rename = "relativePath", default, skip_serializing_if = "Option::is_none")]
            pub relative_path: Option<String>,
            #[doc = "Azure path for Azure Blob or File"]
            #[serde(rename = "azureFilePath", default, skip_serializing_if = "Option::is_none")]
            pub azure_file_path: Option<String>,
            #[doc = "List of files expanded from a file GLOB specified"]
            #[serde(default, skip_serializing_if = "Vec::is_empty")]
            pub paths: Vec<String>,
            #[doc = "Sql Query/Table/Stored Procedure details."]
            #[serde(rename = "sqlDataPath", default, skip_serializing_if = "Option::is_none")]
            pub sql_data_path: Option<data_path::SqlDataPath>,
            #[doc = "HTTP URL."]
            #[serde(rename = "httpUrl", default, skip_serializing_if = "Option::is_none")]
            pub http_url: Option<String>,
            #[doc = "Additional Properties."]
            #[serde(rename = "additionalProperties", default, skip_serializing_if = "Option::is_none")]
            pub additional_properties: Option<serde_json::Value>,
            #[doc = "Specify the partition format of path. Defaults to None."]
            #[serde(rename = "partitionFormat", default, skip_serializing_if = "Option::is_none")]
            pub partition_format: Option<String>,
            #[doc = "Whether or not to ignore unmatched path."]
            #[serde(rename = "partitionFormatIgnoreError", default, skip_serializing_if = "Option::is_none")]
            pub partition_format_ignore_error: Option<bool>,
        }
        impl DataPath {
            pub fn new() -> Self {
                Self::default()
            }
        }
        pub mod data_path {
            use super::*;
            #[doc = "Sql Query/Table/Stored Procedure details."]
            #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
            pub struct SqlDataPath {
                #[doc = "SQL table name"]
                #[serde(rename = "sqlTableName", default, skip_serializing_if = "Option::is_none")]
                pub sql_table_name: Option<String>,
                #[doc = "SQL query"]
                #[serde(rename = "sqlQuery", default, skip_serializing_if = "Option::is_none")]
                pub sql_query: Option<String>,
                #[doc = "SQL storedProcedure name"]
                #[serde(rename = "sqlStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
                pub sql_stored_procedure_name: Option<String>,
                #[doc = "SQL query timeout. Unit in seconds."]
                #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
                pub query_timeout: Option<i64>,
            }
            impl SqlDataPath {
                pub fn new() -> Self {
                    Self::default()
                }
            }
        }
    }
}
#[doc = "The request for creating dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetCreateRequest {
    #[doc = "Skip validation that ensures data can be loaded from the dataset before registration."]
    #[serde(rename = "skipValidation", default, skip_serializing_if = "Option::is_none")]
    pub skip_validation: Option<bool>,
    #[doc = "Specifies dataset type."]
    #[serde(rename = "datasetType")]
    pub dataset_type: dataset_create_request::DatasetType,
    pub parameters: dataset_create_request::Parameters,
    pub registration: dataset_create_request::Registration,
    #[serde(rename = "timeSeries", default, skip_serializing_if = "Option::is_none")]
    pub time_series: Option<dataset_create_request::TimeSeries>,
}
impl DatasetCreateRequest {
    pub fn new(
        dataset_type: dataset_create_request::DatasetType,
        parameters: dataset_create_request::Parameters,
        registration: dataset_create_request::Registration,
    ) -> Self {
        Self {
            skip_validation: None,
            dataset_type,
            parameters,
            registration,
            time_series: None,
        }
    }
}
pub mod dataset_create_request {
    use super::*;
    #[doc = "Specifies dataset type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DatasetType {
        #[serde(rename = "tabular")]
        Tabular,
        #[serde(rename = "file")]
        File,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Parameters {
        #[doc = "Header type."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub header: Option<parameters::Header>,
        #[doc = "Boolean to keep path information as column in the dataset. Defaults to False. This is useful when reading multiple files, and want to know which file a particular record originated from, or to keep useful information in file path."]
        #[serde(rename = "includePath", default, skip_serializing_if = "Option::is_none")]
        pub include_path: Option<bool>,
        #[doc = "The partition information of each path will be extracted into columns based on the specified format. Format part '{column_name}' creates string column, and '{column_name:yyyy/MM/dd/HH/mm/ss}' creates datetime column, where 'yyyy', 'MM', 'dd', 'HH', 'mm' and 'ss' are used to extract year, month, day, hour, minute and second for the datetime type. The format should start from the position of first partition key until the end of file path. For example, given the path '../USA/2019/01/01/data.parquet' where the partition is by country/region and time, partition_format='/{CountryOrRegion}/{PartitionDate:yyyy/MM/dd}/data.csv' creates a string column 'CountryOrRegion' with the value 'USA' and a datetime column 'PartitionDate' with the value '2019-01-01"]
        #[serde(rename = "partitionFormat", default, skip_serializing_if = "Option::is_none")]
        pub partition_format: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub path: Option<parameters::Path>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub query: Option<parameters::Query>,
        #[doc = "Data source type."]
        #[serde(rename = "sourceType", default, skip_serializing_if = "Option::is_none")]
        pub source_type: Option<parameters::SourceType>,
        #[doc = "The separator used to split columns for 'delimited_files' sourceType."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub separator: Option<String>,
    }
    impl Parameters {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod parameters {
        use super::*;
        #[doc = "Header type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Header {
            #[serde(rename = "all_files_have_same_headers")]
            AllFilesHaveSameHeaders,
            #[serde(rename = "only_first_file_has_headers")]
            OnlyFirstFileHasHeaders,
            #[serde(rename = "no_headers")]
            NoHeaders,
            #[serde(rename = "combine_all_files_headers")]
            CombineAllFilesHeaders,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
        pub struct Path {
            #[doc = "The Http URL."]
            #[serde(rename = "httpUrl", default, skip_serializing_if = "Option::is_none")]
            pub http_url: Option<String>,
            #[serde(rename = "dataPath", default, skip_serializing_if = "Option::is_none")]
            pub data_path: Option<path::DataPath>,
        }
        impl Path {
            pub fn new() -> Self {
                Self::default()
            }
        }
        pub mod path {
            use super::*;
            #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
            pub struct DataPath {
                #[doc = "The datastore name."]
                #[serde(rename = "datastoreName", default, skip_serializing_if = "Option::is_none")]
                pub datastore_name: Option<String>,
                #[doc = "Path within the datastore."]
                #[serde(rename = "relativePath", default, skip_serializing_if = "Option::is_none")]
                pub relative_path: Option<String>,
            }
            impl DataPath {
                pub fn new() -> Self {
                    Self::default()
                }
            }
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
        pub struct Query {
            #[doc = "The SQL/PostgreSQL/MySQL datastore name."]
            #[serde(rename = "datastoreName", default, skip_serializing_if = "Option::is_none")]
            pub datastore_name: Option<String>,
            #[doc = "SQL Quey."]
            #[serde(default, skip_serializing_if = "Option::is_none")]
            pub query: Option<String>,
        }
        impl Query {
            pub fn new() -> Self {
                Self::default()
            }
        }
        #[doc = "Data source type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum SourceType {
            #[serde(rename = "delimited_files")]
            DelimitedFiles,
            #[serde(rename = "json_lines_files")]
            JsonLinesFiles,
            #[serde(rename = "parquet_files")]
            ParquetFiles,
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Registration {
        #[doc = "The description for the dataset."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[doc = "The name of the dataset."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "Tags associated with the dataset."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub tags: Option<serde_json::Value>,
    }
    impl Registration {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct TimeSeries {
        #[doc = " Column name to be used as FineGrainTimestamp"]
        #[serde(rename = "fineGrainTimestamp", default, skip_serializing_if = "Option::is_none")]
        pub fine_grain_timestamp: Option<String>,
        #[doc = "Column name to be used as CoarseGrainTimestamp. Can only be used if 'fineGrainTimestamp' is specified and cannot be same as 'fineGrainTimestamp'."]
        #[serde(rename = "coarseGrainTimestamp", default, skip_serializing_if = "Option::is_none")]
        pub coarse_grain_timestamp: Option<String>,
    }
    impl TimeSeries {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "The dataset reference object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatasetReference {
    #[doc = "The name of the dataset reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The id of the dataset reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl DatasetReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Machine Learning dataset object wrapped into ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatasetResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Machine Learning dataset object."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Dataset>,
}
impl DatasetResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Dataset state"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatasetState {
    #[doc = "Dataset state"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "Reference to better Dataset or a Definition"]
    #[serde(rename = "deprecatedBy", default, skip_serializing_if = "Option::is_none")]
    pub deprecated_by: Option<dataset_state::DeprecatedBy>,
    #[doc = "eTag description"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl DatasetState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod dataset_state {
    use super::*;
    #[doc = "Reference to better Dataset or a Definition"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct DeprecatedBy {
        #[doc = "Unique Dataset identifier."]
        #[serde(rename = "datasetId", default, skip_serializing_if = "Option::is_none")]
        pub dataset_id: Option<String>,
        #[doc = "Definition Version"]
        #[serde(rename = "definitionVersion", default, skip_serializing_if = "Option::is_none")]
        pub definition_version: Option<String>,
    }
    impl DeprecatedBy {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Machine Learning datastore object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Datastore {
    #[doc = "Name of the datastore."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Description of the datastore."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The datastore type."]
    #[serde(rename = "dataStoreType", default, skip_serializing_if = "Option::is_none")]
    pub data_store_type: Option<datastore::DataStoreType>,
    #[doc = "A read only property that denotes whether the service datastore has been validated with credentials."]
    #[serde(rename = "hasBeenValidated", default, skip_serializing_if = "Option::is_none")]
    pub has_been_validated: Option<bool>,
    #[doc = "Tags for this datastore."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(rename = "azureStorageSection", default, skip_serializing_if = "Option::is_none")]
    pub azure_storage_section: Option<AzureStorageSection>,
    #[serde(rename = "azureDataLakeSection", default, skip_serializing_if = "Option::is_none")]
    pub azure_data_lake_section: Option<AzureDataLakeSection>,
    #[serde(rename = "azureSqlDatabaseSection", default, skip_serializing_if = "Option::is_none")]
    pub azure_sql_database_section: Option<AzureSqlDatabaseSection>,
    #[serde(rename = "azurePostgreSqlSection", default, skip_serializing_if = "Option::is_none")]
    pub azure_postgre_sql_section: Option<AzurePostgreSqlSection>,
    #[serde(rename = "azureMySqlSection", default, skip_serializing_if = "Option::is_none")]
    pub azure_my_sql_section: Option<AzureMySqlSection>,
    #[doc = "Data specific to GlusterFS."]
    #[serde(rename = "glusterFsSection", default, skip_serializing_if = "Option::is_none")]
    pub gluster_fs_section: Option<GlusterFsSection>,
    #[doc = "User who created."]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[doc = "User who created."]
    #[serde(rename = "modifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub modified_by: Option<UserInfo>,
    #[doc = "The date and time when the datastore was created."]
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[doc = "The date and time when the datastore was last modified."]
    #[serde(rename = "modifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub modified_time: Option<String>,
    #[doc = "Info about origin if it is linked."]
    #[serde(rename = "linkedInfo", default, skip_serializing_if = "Option::is_none")]
    pub linked_info: Option<LinkedInfo>,
}
impl Datastore {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod datastore {
    use super::*;
    #[doc = "The datastore type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataStoreType {
        AzureBlob,
        AzureFile,
        AzureDataLake,
        AzureSqlDatabase,
        AzurePostgreSql,
        #[serde(rename = "DBFS")]
        Dbfs,
        AzureDataLakeGen2,
        AzureMySql,
    }
}
#[doc = "The request for creating datastore."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatastoreCreateRequest {
    #[doc = "The name of the datastore."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The description of the datastore."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Skip validation that ensures data can be loaded from the dataset before registration."]
    #[serde(rename = "skipValidation", default, skip_serializing_if = "Option::is_none")]
    pub skip_validation: Option<bool>,
    #[doc = "Include datastore secret in response."]
    #[serde(rename = "includeSecret", default, skip_serializing_if = "Option::is_none")]
    pub include_secret: Option<bool>,
    #[doc = "Specifies datastore type."]
    #[serde(rename = "dataStoreType")]
    pub data_store_type: datastore_create_request::DataStoreType,
    #[doc = "The name of the storage account."]
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[doc = "The name of the file share."]
    #[serde(rename = "shareName", default, skip_serializing_if = "Option::is_none")]
    pub share_name: Option<String>,
    #[doc = "The name of the azure blob container."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "Account Key of storage account."]
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<String>,
    #[doc = "The endpoint of the server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
    #[doc = "The protocol to be used"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<String>,
    #[doc = "Sas Token of storage account."]
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<String>,
    #[doc = "The service principal's client/application ID."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[doc = "The service principal's secret."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
    #[doc = "The ADLS store name."]
    #[serde(rename = "storeName", default, skip_serializing_if = "Option::is_none")]
    pub store_name: Option<String>,
    #[doc = "The service principal Tenant ID."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "Authority url used to authenticate the user."]
    #[serde(rename = "authorityUrl", default, skip_serializing_if = "Option::is_none")]
    pub authority_url: Option<String>,
    #[doc = "Determines what operations will be performed."]
    #[serde(rename = "resourceUrl", default, skip_serializing_if = "Option::is_none")]
    pub resource_url: Option<String>,
    #[doc = "The subscription ID of the storage account. Defaults to selected subscription"]
    #[serde(rename = "storageAccountSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_subscription_id: Option<String>,
    #[doc = "The resource group of the storage account. Defaults to selected resource group"]
    #[serde(rename = "storageAccountResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_resource_group: Option<String>,
    #[doc = "The ID of the subscription the ADLS store belongs to. Defaults to selected subscription."]
    #[serde(rename = "adlsSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub adls_subscription_id: Option<String>,
    #[doc = "The resource group the ADLS store belongs to. Defaults to selected resource group."]
    #[serde(rename = "adlsResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub adls_resource_group: Option<String>,
    #[doc = "The file system name of the ADLS Gen2."]
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<String>,
    #[doc = "The database name."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "The password."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[doc = "The SQL/MySQL/PostgreSQL server name"]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "The user ID."]
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
    #[doc = "The port number."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<String>,
    #[doc = "This sets the ssl value of the server. Defaults to true if not set."]
    #[serde(rename = "enforceSSL", default, skip_serializing_if = "Option::is_none")]
    pub enforce_ssl: Option<bool>,
    #[doc = "The username of the database user."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[doc = "If set to true, datastore support data access authenticated with Workspace MSI."]
    #[serde(rename = "workspaceSystemAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub workspace_system_assigned_identity: Option<bool>,
}
impl DatastoreCreateRequest {
    pub fn new(data_store_type: datastore_create_request::DataStoreType) -> Self {
        Self {
            name: None,
            description: None,
            skip_validation: None,
            include_secret: None,
            data_store_type,
            account_name: None,
            share_name: None,
            container_name: None,
            account_key: None,
            endpoint: None,
            protocol: None,
            sas_token: None,
            client_id: None,
            client_secret: None,
            store_name: None,
            tenant_id: None,
            authority_url: None,
            resource_url: None,
            storage_account_subscription_id: None,
            storage_account_resource_group: None,
            adls_subscription_id: None,
            adls_resource_group: None,
            file_system: None,
            database_name: None,
            password: None,
            server_name: None,
            user_id: None,
            port: None,
            enforce_ssl: None,
            user_name: None,
            workspace_system_assigned_identity: None,
        }
    }
}
pub mod datastore_create_request {
    use super::*;
    #[doc = "Specifies datastore type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataStoreType {
        #[serde(rename = "blob")]
        Blob,
        #[serde(rename = "adls")]
        Adls,
        #[serde(rename = "adls-gen2")]
        AdlsGen2,
        #[serde(rename = "dbfs")]
        Dbfs,
        #[serde(rename = "file")]
        File,
        #[serde(rename = "mysqldb")]
        Mysqldb,
        #[serde(rename = "sqldb")]
        Sqldb,
        #[serde(rename = "psqldb")]
        Psqldb,
    }
}
#[doc = "Machine Learning datastore object wrapped into ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatastoreResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Machine Learning datastore object."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Datastore>,
}
impl DatastoreResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptionProperties {
    #[doc = "vault base Url"]
    #[serde(rename = "vaultBaseUrl")]
    pub vault_base_url: String,
    #[doc = "Encryption Key name"]
    #[serde(rename = "keyName")]
    pub key_name: String,
    #[doc = "Encryption Key Version"]
    #[serde(rename = "keyVersion")]
    pub key_version: String,
}
impl EncryptionProperties {
    pub fn new(vault_base_url: String, key_name: String, key_version: String) -> Self {
        Self {
            vault_base_url,
            key_name,
            key_version,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptionProperty {
    #[doc = "Indicates whether or not the encryption is enabled for the workspace."]
    pub status: encryption_property::Status,
    #[serde(rename = "keyVaultProperties")]
    pub key_vault_properties: KeyVaultProperties,
}
impl EncryptionProperty {
    pub fn new(status: encryption_property::Status, key_vault_properties: KeyVaultProperties) -> Self {
        Self {
            status,
            key_vault_properties,
        }
    }
}
pub mod encryption_property {
    use super::*;
    #[doc = "Indicates whether or not the encryption is enabled for the workspace."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
}
#[doc = "Request to create a Docker image based on Environment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentImageRequest {
    #[doc = "The name of the driver file."]
    #[serde(rename = "driverProgram", default, skip_serializing_if = "Option::is_none")]
    pub driver_program: Option<String>,
    #[doc = "The list of assets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub assets: Vec<ImageAsset>,
    #[doc = "The list of model Ids."]
    #[serde(rename = "modelIds", default, skip_serializing_if = "Vec::is_empty")]
    pub model_ids: Vec<String>,
    #[doc = "The list of models."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub models: Vec<Model>,
    #[doc = "The details of the AZURE ML environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub environment: Option<serde_json::Value>,
    #[doc = "The unique identifying details of the AZURE ML environment."]
    #[serde(rename = "environmentReference", default, skip_serializing_if = "Option::is_none")]
    pub environment_reference: Option<serde_json::Value>,
}
impl EnvironmentImageRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request to create a Docker image based on Environment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentImageResponse {
    #[doc = "The name of the driver file."]
    #[serde(rename = "driverProgram", default, skip_serializing_if = "Option::is_none")]
    pub driver_program: Option<String>,
    #[doc = "The list of assets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub assets: Vec<ImageAsset>,
    #[doc = "The list of model Ids."]
    #[serde(rename = "modelIds", default, skip_serializing_if = "Vec::is_empty")]
    pub model_ids: Vec<String>,
    #[doc = "The list of models."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub models: Vec<Model>,
    #[doc = "The details of the AZURE ML environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub environment: Option<serde_json::Value>,
    #[doc = "The unique identifying details of the AZURE ML environment."]
    #[serde(rename = "environmentReference", default, skip_serializing_if = "Option::is_none")]
    pub environment_reference: Option<serde_json::Value>,
}
impl EnvironmentImageResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentReference {
    #[doc = "Name of the environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Version of the environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl EnvironmentReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Error detail information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorDetail {
    #[doc = "Error code."]
    pub code: String,
    #[doc = "Error message."]
    pub message: String,
}
impl ErrorDetail {
    pub fn new(code: String, message: String) -> Self {
        Self { code, message }
    }
}
#[doc = "Error response information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "Error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "An array of error detail objects."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetail>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Data specific to GlusterFS."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GlusterFsSection {
    #[doc = "The server address of one of the servers that hosts the GlusterFS. Can be either the IP address or server name."]
    #[serde(rename = "serverAddress", default, skip_serializing_if = "Option::is_none")]
    pub server_address: Option<String>,
    #[doc = "The name of the created GlusterFS volume."]
    #[serde(rename = "volumeName", default, skip_serializing_if = "Option::is_none")]
    pub volume_name: Option<String>,
}
impl GlusterFsSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A HDInsight compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsight {
    #[serde(flatten)]
    pub compute: Compute,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hd_insight::Properties>,
}
impl HdInsight {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod hd_insight {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Port open for ssh connections on the master node of the cluster."]
        #[serde(rename = "sshPort", default, skip_serializing_if = "Option::is_none")]
        pub ssh_port: Option<i32>,
        #[doc = "Public IP address of the master node of the cluster."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub address: Option<String>,
        #[doc = "Admin credentials for virtual machine"]
        #[serde(rename = "administratorAccount", default, skip_serializing_if = "Option::is_none")]
        pub administrator_account: Option<VirtualMachineSshCredentials>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Identity for the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Identity {
    #[doc = "The principal ID of resource identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The tenant ID of resource."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The identity type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity::Type>,
    #[doc = "dictionary containing all the user assigned identities, with resourceId of the UAI as key."]
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<UserAssignedIdentities>,
}
impl Identity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity {
    use super::*;
    #[doc = "The identity type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        #[serde(rename = "SystemAssigned,UserAssigned")]
        SystemAssignedUserAssigned,
        UserAssigned,
        None,
    }
}
#[doc = "An Image asset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageAsset {
    #[doc = "The Asset Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The mime type."]
    #[serde(rename = "mimeType", default, skip_serializing_if = "Option::is_none")]
    pub mime_type: Option<String>,
    #[doc = "The Url of the Asset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[doc = "Whether the Asset is unpacked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unpack: Option<bool>,
}
impl ImageAsset {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultProperties {
    #[doc = "The ArmId of the keyVault where the customer owned encryption key is present."]
    #[serde(rename = "keyVaultArmId")]
    pub key_vault_arm_id: String,
    #[doc = "Key vault uri to access the encryption key."]
    #[serde(rename = "keyIdentifier")]
    pub key_identifier: String,
    #[doc = "For future use - The client id of the identity which will be used to access key vault."]
    #[serde(rename = "identityClientId", default, skip_serializing_if = "Option::is_none")]
    pub identity_client_id: Option<String>,
}
impl KeyVaultProperties {
    pub fn new(key_vault_arm_id: String, key_identifier: String) -> Self {
        Self {
            key_vault_arm_id,
            key_identifier,
            identity_client_id: None,
        }
    }
}
#[doc = "Info about origin if it is linked."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkedInfo {
    #[doc = "LinkedId id."]
    #[serde(rename = "linkedId", default, skip_serializing_if = "Option::is_none")]
    pub linked_id: Option<String>,
    #[doc = "Linked resource name."]
    #[serde(rename = "linkedResourceName", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_name: Option<String>,
    #[doc = "Datastore origin"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<Origin>,
}
impl LinkedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Linked workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkedWorkspace {
    #[doc = "ResourceId of the link of the linked workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Friendly name of the linked workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type of linked workspace."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "LinkedWorkspace specific properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LinkedWorkspaceProps>,
}
impl LinkedWorkspace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "object used for creating linked workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkedWorkspaceDto {
    #[doc = "Friendly name of the linked workspace"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "LinkedWorkspace specific properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LinkedWorkspaceProps>,
}
impl LinkedWorkspaceDto {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "LinkedWorkspace specific properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkedWorkspaceProps {
    #[doc = "ResourceId of the link target of the linked workspace."]
    #[serde(rename = "linkedWorkspaceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub linked_workspace_resource_id: Option<String>,
    #[doc = "ResourceId of the user assigned identity for the linked workspace."]
    #[serde(rename = "userAssignedIdentityResourceId", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identity_resource_id: Option<String>,
}
impl LinkedWorkspaceProps {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Aml user feature operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListAmlUserFeatureResult {
    #[doc = "The list of AML user facing features."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AmlUserFeature>,
    #[doc = "The URI to fetch the next page of AML user features information. Call ListNext() with this to fetch the next page of AML user features information."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListAmlUserFeatureResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Usages operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListUsagesResult {
    #[doc = "The list of AML resource usages."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
    #[doc = "The URI to fetch the next page of AML resource usage information. Call ListNext() with this to fetch the next page of AML resource usage information."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListUsagesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListWorkspaceKeysResult {
    #[serde(rename = "userStorageKey", default, skip_serializing_if = "Option::is_none")]
    pub user_storage_key: Option<String>,
    #[serde(rename = "userStorageResourceId", default, skip_serializing_if = "Option::is_none")]
    pub user_storage_resource_id: Option<String>,
    #[serde(rename = "appInsightsInstrumentationKey", default, skip_serializing_if = "Option::is_none")]
    pub app_insights_instrumentation_key: Option<String>,
    #[serde(rename = "containerRegistryCredentials", default, skip_serializing_if = "Option::is_none")]
    pub container_registry_credentials: Option<RegistryListCredentialsResult>,
}
impl ListWorkspaceKeysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List WorkspaceQuotasByVMFamily operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListWorkspaceQuotas {
    #[doc = "The list of Workspace Quotas by VM Family"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceQuota>,
    #[doc = "The URI to fetch the next page of workspace quota information by VM Family. Call ListNext() with this to fetch the next page of Workspace Quota information."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListWorkspaceQuotas {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The liveness probe requirements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LivenessProbeRequirements {
    #[doc = "The number of failures to allow before returning an unhealthy status."]
    #[serde(rename = "failureThreshold", default, skip_serializing_if = "Option::is_none")]
    pub failure_threshold: Option<i32>,
    #[doc = "The number of successful probes before returning a healthy status."]
    #[serde(rename = "successThreshold", default, skip_serializing_if = "Option::is_none")]
    pub success_threshold: Option<i32>,
    #[doc = "The probe timeout in seconds."]
    #[serde(rename = "timeoutSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_seconds: Option<i32>,
    #[doc = "The length of time between probes in seconds."]
    #[serde(rename = "periodSeconds", default, skip_serializing_if = "Option::is_none")]
    pub period_seconds: Option<i32>,
    #[doc = "The delay before the first probe in seconds."]
    #[serde(rename = "initialDelaySeconds", default, skip_serializing_if = "Option::is_none")]
    pub initial_delay_seconds: Option<i32>,
}
impl LivenessProbeRequirements {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Wrapper for error response to follow ARM guidelines."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MachineLearningServiceError {
    #[doc = "Error response information."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl MachineLearningServiceError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Machine Learning Model."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Model {
    #[doc = "The Model Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The Model name."]
    pub name: String,
    #[doc = "The Model framework."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub framework: Option<String>,
    #[doc = "The Model framework version."]
    #[serde(rename = "frameworkVersion", default, skip_serializing_if = "Option::is_none")]
    pub framework_version: Option<String>,
    #[doc = "The Model version assigned by Model Management Service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
    #[doc = "The list of datasets associated with the model."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datasets: Vec<DatasetReference>,
    #[doc = "The URL of the Model. Usually a SAS URL."]
    pub url: String,
    #[doc = "The MIME type of Model content. For more details about MIME type, please open https://www.iana.org/assignments/media-types/media-types.xhtml"]
    #[serde(rename = "mimeType")]
    pub mime_type: String,
    #[doc = "The Model description text."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The Model creation time (UTC)."]
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[doc = "The Model last modified time (UTC)."]
    #[serde(rename = "modifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub modified_time: Option<String>,
    #[doc = "Indicates whether we need to unpack the Model during docker Image creation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unpack: Option<bool>,
    #[doc = "The Parent Model Id."]
    #[serde(rename = "parentModelId", default, skip_serializing_if = "Option::is_none")]
    pub parent_model_id: Option<String>,
    #[doc = "The RunId that created this model."]
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[doc = "The name of the experiment where this model was created."]
    #[serde(rename = "experimentName", default, skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    #[doc = "The Model tag dictionary. Items are mutable."]
    #[serde(rename = "kvTags", default, skip_serializing_if = "Option::is_none")]
    pub kv_tags: Option<serde_json::Value>,
    #[doc = "The Model property dictionary. Properties are immutable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "Models derived from this model"]
    #[serde(rename = "derivedModelIds", default, skip_serializing_if = "Vec::is_empty")]
    pub derived_model_ids: Vec<String>,
    #[doc = "Sample Input Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}"]
    #[serde(rename = "sampleInputData", default, skip_serializing_if = "Option::is_none")]
    pub sample_input_data: Option<String>,
    #[doc = "Sample Output Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}"]
    #[serde(rename = "sampleOutputData", default, skip_serializing_if = "Option::is_none")]
    pub sample_output_data: Option<String>,
    #[doc = "The resource requirements for the container (cpu and memory)."]
    #[serde(rename = "resourceRequirements", default, skip_serializing_if = "Option::is_none")]
    pub resource_requirements: Option<ContainerResourceRequirements>,
}
impl Model {
    pub fn new(name: String, url: String, mime_type: String) -> Self {
        Self {
            id: None,
            name,
            framework: None,
            framework_version: None,
            version: None,
            datasets: Vec::new(),
            url,
            mime_type,
            description: None,
            created_time: None,
            modified_time: None,
            unpack: None,
            parent_model_id: None,
            run_id: None,
            experiment_name: None,
            kv_tags: None,
            properties: None,
            derived_model_ids: Vec::new(),
            sample_input_data: None,
            sample_output_data: None,
            resource_requirements: None,
        }
    }
}
#[doc = "The Model data collection properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelDataCollection {
    #[doc = "Option for enabling/disabling Event Hub."]
    #[serde(rename = "eventHubEnabled", default, skip_serializing_if = "Option::is_none")]
    pub event_hub_enabled: Option<bool>,
    #[doc = "Option for enabling/disabling storage."]
    #[serde(rename = "storageEnabled", default, skip_serializing_if = "Option::is_none")]
    pub storage_enabled: Option<bool>,
}
impl ModelDataCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelDockerSection {
    #[doc = "Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile."]
    #[serde(rename = "baseImage", default, skip_serializing_if = "Option::is_none")]
    pub base_image: Option<String>,
    #[doc = "Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage."]
    #[serde(rename = "baseDockerfile", default, skip_serializing_if = "Option::is_none")]
    pub base_dockerfile: Option<String>,
    #[doc = "Image registry that contains the base image."]
    #[serde(rename = "baseImageRegistry", default, skip_serializing_if = "Option::is_none")]
    pub base_image_registry: Option<serde_json::Value>,
}
impl ModelDockerSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelDockerSectionResponse {
    #[doc = "Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile."]
    #[serde(rename = "baseImage", default, skip_serializing_if = "Option::is_none")]
    pub base_image: Option<String>,
    #[doc = "Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage."]
    #[serde(rename = "baseDockerfile", default, skip_serializing_if = "Option::is_none")]
    pub base_dockerfile: Option<String>,
    #[doc = "Image registry that contains the base image."]
    #[serde(rename = "baseImageRegistry", default, skip_serializing_if = "Option::is_none")]
    pub base_image_registry: Option<serde_json::Value>,
}
impl ModelDockerSectionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelEnvironmentDefinition {
    #[doc = "The name of the environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The environment version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[doc = "Settings for a Python environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub python: Option<serde_json::Value>,
    #[doc = "Definition of environment variables to be defined in the environment."]
    #[serde(rename = "environmentVariables", default, skip_serializing_if = "Option::is_none")]
    pub environment_variables: Option<serde_json::Value>,
    #[doc = "The definition of a Docker container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub docker: Option<serde_json::Value>,
    #[doc = "The configuration for a Spark environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub spark: Option<serde_json::Value>,
    #[doc = "Settings for a R environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub r: Option<serde_json::Value>,
    #[doc = "The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: \"latest\"."]
    #[serde(rename = "inferencingStackVersion", default, skip_serializing_if = "Option::is_none")]
    pub inferencing_stack_version: Option<String>,
}
impl ModelEnvironmentDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelEnvironmentDefinitionResponse {
    #[doc = "The name of the environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The environment version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[doc = "Settings for a Python environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub python: Option<serde_json::Value>,
    #[doc = "Definition of environment variables to be defined in the environment."]
    #[serde(rename = "environmentVariables", default, skip_serializing_if = "Option::is_none")]
    pub environment_variables: Option<serde_json::Value>,
    #[doc = "The definition of a Docker container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub docker: Option<serde_json::Value>,
    #[doc = "The configuration for a Spark environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub spark: Option<serde_json::Value>,
    #[doc = "Settings for a R environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub r: Option<serde_json::Value>,
    #[doc = "The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: \"latest\"."]
    #[serde(rename = "inferencingStackVersion", default, skip_serializing_if = "Option::is_none")]
    pub inferencing_stack_version: Option<String>,
}
impl ModelEnvironmentDefinitionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelPythonSection {
    #[doc = "The python interpreter path to use if an environment build is not required. The path specified gets used to call the user script."]
    #[serde(rename = "interpreterPath", default, skip_serializing_if = "Option::is_none")]
    pub interpreter_path: Option<String>,
    #[doc = "True means that AzureML reuses an existing python environment; False means that AzureML will create a python environment based on the Conda dependencies specification."]
    #[serde(rename = "userManagedDependencies", default, skip_serializing_if = "Option::is_none")]
    pub user_managed_dependencies: Option<bool>,
    #[doc = "A JObject containing Conda dependencies."]
    #[serde(rename = "condaDependencies", default, skip_serializing_if = "Option::is_none")]
    pub conda_dependencies: Option<serde_json::Value>,
    #[serde(rename = "baseCondaEnvironment", default, skip_serializing_if = "Option::is_none")]
    pub base_conda_environment: Option<String>,
}
impl ModelPythonSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelSparkSection {
    #[doc = "The list of spark repositories."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub repositories: Vec<String>,
    #[doc = "The Spark packages to use."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub packages: Vec<SparkMavenPackage>,
    #[doc = "Whether to precache the packages."]
    #[serde(rename = "precachePackages", default, skip_serializing_if = "Option::is_none")]
    pub precache_packages: Option<bool>,
}
impl ModelSparkSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Counts of various compute node states on the amlCompute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NodeStateCounts {
    #[doc = "Number of compute nodes in idle state."]
    #[serde(rename = "idleNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub idle_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are running jobs."]
    #[serde(rename = "runningNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub running_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are being prepared."]
    #[serde(rename = "preparingNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub preparing_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are in unusable state."]
    #[serde(rename = "unusableNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub unusable_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are leaving the amlCompute."]
    #[serde(rename = "leavingNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub leaving_node_count: Option<i32>,
    #[doc = "Number of compute nodes which are in preempted state."]
    #[serde(rename = "preemptedNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub preempted_node_count: Option<i32>,
}
impl NodeStateCounts {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Machine Learning workspace REST API operation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Display name of operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "Display name of operation"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "The resource provider name: Microsoft.MachineLearningExperimentation"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "The resource on which the operation is performed."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "The operation that users can perform."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "The description for the operation."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "An array of operations supported by the resource provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of AML workspace operations supported by the AML workspace resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Datastore origin"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Origin {
    Synapse,
}
#[doc = "Paginated list of Machine Learning compute objects wrapped in ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaginatedComputeResourcesList {
    #[doc = "An array of Machine Learning compute objects wrapped in ARM resource envelope."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ComputeResource>,
    #[doc = "A continuation link (absolute URI) to the next page of results in the list."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PaginatedComputeResourcesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Paginated list of Machine Learning dataset objects wrapped in ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaginatedDatasetResourcesList {
    #[doc = "An array of Machine Learning dataset objects wrapped in ARM resource envelope."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DatasetResource>,
    #[doc = "A continuation link (absolute URI) to the next page of results in the list."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PaginatedDatasetResourcesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Paginated list of Machine Learning datastore objects wrapped in ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaginatedDatastoreResourcesList {
    #[doc = "An array of Machine Learning datastore objects wrapped in ARM resource envelope."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DatastoreResource>,
    #[doc = "A continuation link (absolute URI) to the next page of results in the list."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PaginatedDatastoreResourcesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Paginated list of Machine Learning service objects wrapped in ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaginatedServiceList {
    #[doc = "An array of Machine Learning compute objects wrapped in ARM resource envelope."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceResource>,
    #[doc = "A continuation link (absolute URI) to the next page of results in the list."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PaginatedServiceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Password {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl Password {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Private Endpoint resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[doc = "The ARM identifier for Private Endpoint"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Private Endpoint Connection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the PrivateEndpointConnectProperties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnectionProperties>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the PrivateEndpointConnectProperties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateEndpointConnectionProperties {
    #[doc = "The Private Endpoint resource."]
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[doc = "A collection of information about the state of the connection between service consumer and provider."]
    #[serde(rename = "privateLinkServiceConnectionState")]
    pub private_link_service_connection_state: PrivateLinkServiceConnectionState,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<PrivateEndpointConnectionProvisioningState>,
}
impl PrivateEndpointConnectionProperties {
    pub fn new(private_link_service_connection_state: PrivateLinkServiceConnectionState) -> Self {
        Self {
            private_endpoint: None,
            private_link_service_connection_state,
            provisioning_state: None,
        }
    }
}
#[doc = "The current provisioning state."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PrivateEndpointConnectionProvisioningState {
    Succeeded,
    Creating,
    Deleting,
    Failed,
}
#[doc = "The private endpoint connection status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PrivateEndpointServiceConnectionStatus {
    Pending,
    Approved,
    Rejected,
    Disconnected,
    Timeout,
}
#[doc = "A private link resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of a private link resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkResourceProperties>,
}
impl PrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of private link resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceListResult {
    #[doc = "Array of private link resources"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateLinkResource>,
}
impl PrivateLinkResourceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a private link resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceProperties {
    #[doc = "The private link resource group id."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[doc = "The private link resource required member names."]
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[doc = "The private link resource Private link DNS zone name."]
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl PrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A collection of information about the state of the connection between service consumer and provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionState {
    #[doc = "The private endpoint connection status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<PrivateEndpointServiceConnectionStatus>,
    #[doc = "The reason for approval/rejection of the connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "A message indicating if changes on the service provider require any updates on the consumer."]
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for Quota update or retrieval."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaBaseProperties {
    #[doc = "Specifies the resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Specifies the resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The maximum permitted quota of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "An enum describing the unit of quota measurement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<quota_base_properties::Unit>,
}
impl QuotaBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod quota_base_properties {
    use super::*;
    #[doc = "An enum describing the unit of quota measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[doc = "Quota update parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaUpdateParameters {
    #[doc = "The list for update quota."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<QuotaBaseProperties>,
}
impl QuotaUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RCranPackage {
    #[doc = "The package name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The repository name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
}
impl RCranPackage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RGitHubPackage {
    #[doc = "Repository address in the format username/repo[/subdir][@ref|#pull]."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[doc = "Personal access token to install from a private repo"]
    #[serde(rename = "authToken", default, skip_serializing_if = "Option::is_none")]
    pub auth_token: Option<String>,
}
impl RGitHubPackage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RGitHubPackageResponse {
    #[doc = "Repository address in the format username/repo[/subdir][@ref|#pull]."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
}
impl RGitHubPackageResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RSection {
    #[doc = "The version of R to be installed"]
    #[serde(rename = "rVersion", default, skip_serializing_if = "Option::is_none")]
    pub r_version: Option<String>,
    #[doc = "Indicates whether the environment is managed by user or by AzureML."]
    #[serde(rename = "userManaged", default, skip_serializing_if = "Option::is_none")]
    pub user_managed: Option<bool>,
    #[doc = "The Rscript path to use if an environment build is not required.\r\nThe path specified gets used to call the user script."]
    #[serde(rename = "rscriptPath", default, skip_serializing_if = "Option::is_none")]
    pub rscript_path: Option<String>,
    #[doc = "Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. \"2019-04-17\""]
    #[serde(rename = "snapshotDate", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_date: Option<String>,
    #[doc = "The CRAN packages to use."]
    #[serde(rename = "cranPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub cran_packages: Vec<RCranPackage>,
    #[doc = "The packages directly from GitHub."]
    #[serde(rename = "gitHubPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub git_hub_packages: Vec<RGitHubPackage>,
    #[doc = "The packages from custom urls."]
    #[serde(rename = "customUrlPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_url_packages: Vec<String>,
    #[doc = "The packages from Bioconductor."]
    #[serde(rename = "bioConductorPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub bio_conductor_packages: Vec<String>,
}
impl RSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RSectionResponse {
    #[doc = "The version of R to be installed"]
    #[serde(rename = "rVersion", default, skip_serializing_if = "Option::is_none")]
    pub r_version: Option<String>,
    #[doc = "Indicates whether the environment is managed by user or by AzureML."]
    #[serde(rename = "userManaged", default, skip_serializing_if = "Option::is_none")]
    pub user_managed: Option<bool>,
    #[doc = "The Rscript path to use if an environment build is not required.\r\nThe path specified gets used to call the user script."]
    #[serde(rename = "rscriptPath", default, skip_serializing_if = "Option::is_none")]
    pub rscript_path: Option<String>,
    #[doc = "Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. \"2019-04-17\""]
    #[serde(rename = "snapshotDate", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_date: Option<String>,
    #[doc = "The CRAN packages to use."]
    #[serde(rename = "cranPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub cran_packages: Vec<RCranPackage>,
    #[doc = "The packages directly from GitHub."]
    #[serde(rename = "gitHubPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub git_hub_packages: Vec<RGitHubPackageResponse>,
    #[doc = "The packages from custom urls."]
    #[serde(rename = "customUrlPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_url_packages: Vec<String>,
    #[doc = "The packages from Bioconductor."]
    #[serde(rename = "bioConductorPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub bio_conductor_packages: Vec<String>,
}
impl RSectionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryListCredentialsResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub passwords: Vec<Password>,
}
impl RegistryListCredentialsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Resource Manager resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Specifies the resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Specifies the name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<Identity>,
    #[doc = "Specifies the location of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Specifies the type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Contains resource tags defined as key/value pairs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Sku of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceId {
    #[doc = "The ID of the resource"]
    pub id: String,
}
impl ResourceId {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "The Resource Name."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceName {
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "The localized name of the resource."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl ResourceName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The quota assigned to a resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceQuota {
    #[doc = "Specifies the resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Specifies the resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The Resource Name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<ResourceName>,
    #[doc = "The maximum permitted quota of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "An enum describing the unit of quota measurement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<resource_quota::Unit>,
}
impl ResourceQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_quota {
    use super::*;
    #[doc = "An enum describing the unit of quota measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSkuLocationInfo {
    #[doc = "Location of the SKU"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "List of availability zones where the SKU is supported."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[doc = "Details of capabilities available to a SKU in specific zones."]
    #[serde(rename = "zoneDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub zone_details: Vec<ResourceSkuZoneDetails>,
}
impl ResourceSkuLocationInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes The zonal capabilities of a SKU."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSkuZoneDetails {
    #[doc = "The set of zones that the SKU is available in with the specified capabilities."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub name: Vec<String>,
    #[doc = "A list of capabilities that are available for the SKU in the specified list of zones."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<SkuCapability>,
}
impl ResourceSkuZoneDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The restriction because of which SKU cannot be used."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Restriction {
    #[doc = "The type of restrictions. As of now only possible value for this is location."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
    #[doc = "The reason for the restriction."]
    #[serde(rename = "reasonCode", default, skip_serializing_if = "Option::is_none")]
    pub reason_code: Option<restriction::ReasonCode>,
}
impl Restriction {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod restriction {
    use super::*;
    #[doc = "The reason for the restriction."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReasonCode {
        NotSpecified,
        NotAvailableForRegion,
        NotAvailableForSubscription,
    }
}
#[doc = "Features/user capabilities associated with the sku"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuCapability {
    #[doc = "Capability/Feature ID"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Details about the feature/capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl SkuCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "scale settings for AML Compute"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScaleSettings {
    #[doc = "Max number of nodes to use"]
    #[serde(rename = "maxNodeCount")]
    pub max_node_count: i32,
    #[doc = "Min number of nodes to use"]
    #[serde(rename = "minNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub min_node_count: Option<i32>,
    #[doc = "Node Idle Time before scaling down amlCompute"]
    #[serde(rename = "nodeIdleTimeBeforeScaleDown", default, skip_serializing_if = "Option::is_none")]
    pub node_idle_time_before_scale_down: Option<String>,
}
impl ScaleSettings {
    pub fn new(max_node_count: i32) -> Self {
        Self {
            max_node_count,
            min_node_count: None,
            node_idle_time_before_scale_down: None,
        }
    }
}
#[doc = "Service principal credentials."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServicePrincipalCredentials {
    #[doc = "Client Id"]
    #[serde(rename = "clientId")]
    pub client_id: String,
    #[doc = "Client secret"]
    #[serde(rename = "clientSecret")]
    pub client_secret: String,
}
impl ServicePrincipalCredentials {
    pub fn new(client_id: String, client_secret: String) -> Self {
        Self { client_id, client_secret }
    }
}
#[doc = "Machine Learning service object wrapped into ARM resource envelope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The base service response. The correct inherited response based on computeType will be returned (ex. ACIServiceResponse)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceResponseBase>,
}
impl ServiceResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The base service response. The correct inherited response based on computeType will be returned (ex. ACIServiceResponse)"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceResponseBase {
    #[doc = "The service description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The service tag dictionary. Tags are mutable."]
    #[serde(rename = "kvTags", default, skip_serializing_if = "Option::is_none")]
    pub kv_tags: Option<serde_json::Value>,
    #[doc = "The service property dictionary. Properties are immutable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "The current state of the service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<service_response_base::State>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
    #[doc = "The compute environment type for the service."]
    #[serde(rename = "computeType")]
    pub compute_type: service_response_base::ComputeType,
    #[doc = "The deployment type for the service."]
    #[serde(rename = "deploymentType", default, skip_serializing_if = "Option::is_none")]
    pub deployment_type: Option<service_response_base::DeploymentType>,
}
impl ServiceResponseBase {
    pub fn new(compute_type: service_response_base::ComputeType) -> Self {
        Self {
            description: None,
            kv_tags: None,
            properties: None,
            state: None,
            error: None,
            compute_type,
            deployment_type: None,
        }
    }
}
pub mod service_response_base {
    use super::*;
    #[doc = "The current state of the service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Transitioning,
        Healthy,
        Unhealthy,
        Failed,
        Unschedulable,
    }
    #[doc = "The compute environment type for the service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComputeType {
        #[serde(rename = "ACI")]
        Aci,
        #[serde(rename = "AKS")]
        Aks,
    }
    #[doc = "The deployment type for the service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeploymentType {
        #[serde(rename = "GRPCRealtimeEndpoint")]
        GrpcRealtimeEndpoint,
        HttpRealtimeEndpoint,
        Batch,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharedPrivateLinkResource {
    #[doc = "Unique name of the private link."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Properties of a shared private link resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SharedPrivateLinkResourceProperty>,
}
impl SharedPrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a shared private link resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharedPrivateLinkResourceProperty {
    #[doc = "The resource id that private link links to."]
    #[serde(rename = "privateLinkResourceId", default, skip_serializing_if = "Option::is_none")]
    pub private_link_resource_id: Option<String>,
    #[doc = "The private link resource group id."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[doc = "Request message."]
    #[serde(rename = "requestMessage", default, skip_serializing_if = "Option::is_none")]
    pub request_message: Option<String>,
    #[doc = "The private endpoint connection status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<PrivateEndpointServiceConnectionStatus>,
}
impl SharedPrivateLinkResourceProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Sku of the resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[doc = "Name of the sku"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Tier of the sku like Basic or Enterprise"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of skus with features"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkspaceSku>,
    #[doc = "The URI to fetch the next page of Workspace Skus. Call ListNext() with this URI to fetch the next page of Workspace Skus"]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SkuListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SparkMavenPackage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub group: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub artifact: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl SparkMavenPackage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Sql Authentication type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SqlCredentialTypes {
    SqlAuthentication,
    ServicePrincipal,
    None,
}
#[doc = "The ssl configuration for scoring"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SslConfiguration {
    #[doc = "Enable or disable ssl for scoring"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<ssl_configuration::Status>,
    #[doc = "Cert data"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cert: Option<String>,
    #[doc = "Key data"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[doc = "CNAME of the cert"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cname: Option<String>,
}
impl SslConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ssl_configuration {
    use super::*;
    #[doc = "Enable or disable ssl for scoring"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
}
#[doc = "A system service running on a compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemService {
    #[doc = "The type of this system service."]
    #[serde(rename = "systemServiceType", default, skip_serializing_if = "Option::is_none")]
    pub system_service_type: Option<String>,
    #[doc = "Public IP address"]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[doc = "The version for this type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl SystemService {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for update Quota response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateWorkspaceQuotas {
    #[doc = "Specifies the resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Specifies the resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The maximum permitted quota of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "An enum describing the unit of quota measurement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<update_workspace_quotas::Unit>,
    #[doc = "Status of update workspace quota."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<update_workspace_quotas::Status>,
}
impl UpdateWorkspaceQuotas {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod update_workspace_quotas {
    use super::*;
    #[doc = "An enum describing the unit of quota measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
    #[doc = "Status of update workspace quota."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Undefined,
        Success,
        Failure,
        InvalidQuotaBelowClusterMinimum,
        InvalidQuotaExceedsSubscriptionLimit,
        #[serde(rename = "InvalidVMFamilyName")]
        InvalidVmFamilyName,
        OperationNotSupportedForSku,
        OperationNotEnabledForRegion,
    }
}
#[doc = "The result of update workspace quota."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateWorkspaceQuotasResult {
    #[doc = "The list of workspace quota update result."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<UpdateWorkspaceQuotas>,
    #[doc = "The URI to fetch the next page of workspace quota update result. Call ListNext() with this to fetch the next page of Workspace Quota update result."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UpdateWorkspaceQuotasResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes AML Resource Usage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Usage {
    #[doc = "Specifies the resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Specifies the resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "An enum describing the unit of usage measurement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<usage::Unit>,
    #[doc = "The current usage of the resource."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[doc = "The maximum permitted usage of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "The Usage Names."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<UsageName>,
}
impl Usage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod usage {
    use super::*;
    #[doc = "An enum describing the unit of usage measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[doc = "The Usage Names."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "The localized name of the resource."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Settings for user account that gets created on each on the nodes of a compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserAccountCredentials {
    #[doc = "Name of the administrator user account which can be used to SSH to nodes."]
    #[serde(rename = "adminUserName")]
    pub admin_user_name: String,
    #[doc = "SSH public key of the administrator user account."]
    #[serde(rename = "adminUserSshPublicKey", default, skip_serializing_if = "Option::is_none")]
    pub admin_user_ssh_public_key: Option<String>,
    #[doc = "Password of the administrator user account."]
    #[serde(rename = "adminUserPassword", default, skip_serializing_if = "Option::is_none")]
    pub admin_user_password: Option<String>,
}
impl UserAccountCredentials {
    pub fn new(admin_user_name: String) -> Self {
        Self {
            admin_user_name,
            admin_user_ssh_public_key: None,
            admin_user_password: None,
        }
    }
}
#[doc = "dictionary containing all the user assigned identities, with resourceId of the UAI as key."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserAssignedIdentities {}
impl UserAssignedIdentities {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "User Assigned Identity"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserAssignedIdentity {
    #[doc = "The principal ID of the user assigned identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The tenant ID of the user assigned identity."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The clientId(aka appId) of the user assigned identity."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
}
impl UserAssignedIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "User who created."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserInfo {
    #[doc = "A user or service principal's object ID.."]
    #[serde(rename = "userObjectId", default, skip_serializing_if = "Option::is_none")]
    pub user_object_id: Option<String>,
    #[doc = "A user or service principal's PuID."]
    #[serde(rename = "userPuId", default, skip_serializing_if = "Option::is_none")]
    pub user_pu_id: Option<String>,
    #[doc = "A user identity provider. Eg live.com"]
    #[serde(rename = "userIdp", default, skip_serializing_if = "Option::is_none")]
    pub user_idp: Option<String>,
    #[doc = "A user alternate sec id. This represents the user in a different identity provider system Eg.1:live.com:puid"]
    #[serde(rename = "userAltSecId", default, skip_serializing_if = "Option::is_none")]
    pub user_alt_sec_id: Option<String>,
    #[doc = "The issuer which issued the token for this user."]
    #[serde(rename = "userIss", default, skip_serializing_if = "Option::is_none")]
    pub user_iss: Option<String>,
    #[doc = "A user or service principal's tenant ID."]
    #[serde(rename = "userTenantId", default, skip_serializing_if = "Option::is_none")]
    pub user_tenant_id: Option<String>,
    #[doc = " A user's full name or a service principal's app ID."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl UserInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Machine Learning compute based on Azure Virtual Machines."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachine {
    #[serde(flatten)]
    pub compute: Compute,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<virtual_machine::Properties>,
}
impl VirtualMachine {
    pub fn new(compute: Compute) -> Self {
        Self { compute, properties: None }
    }
}
pub mod virtual_machine {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Virtual Machine size"]
        #[serde(rename = "virtualMachineSize", default, skip_serializing_if = "Option::is_none")]
        pub virtual_machine_size: Option<String>,
        #[doc = "Port open for ssh connections."]
        #[serde(rename = "sshPort", default, skip_serializing_if = "Option::is_none")]
        pub ssh_port: Option<i32>,
        #[doc = "Public IP address of the virtual machine."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub address: Option<String>,
        #[doc = "Admin credentials for virtual machine"]
        #[serde(rename = "administratorAccount", default, skip_serializing_if = "Option::is_none")]
        pub administrator_account: Option<VirtualMachineSshCredentials>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Secrets related to a Machine Learning compute based on AKS."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineSecrets {
    #[serde(flatten)]
    pub compute_secrets: ComputeSecrets,
    #[doc = "Admin credentials for virtual machine"]
    #[serde(rename = "administratorAccount", default, skip_serializing_if = "Option::is_none")]
    pub administrator_account: Option<VirtualMachineSshCredentials>,
}
impl VirtualMachineSecrets {
    pub fn new(compute_secrets: ComputeSecrets) -> Self {
        Self {
            compute_secrets,
            administrator_account: None,
        }
    }
}
#[doc = "Describes the properties of a VM size."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSize {
    #[doc = "The name of the virtual machine size."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The family name of the virtual machine size."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[doc = "The number of vCPUs supported by the virtual machine size."]
    #[serde(rename = "vCPUs", default, skip_serializing_if = "Option::is_none")]
    pub v_cp_us: Option<i32>,
    #[doc = "The number of gPUs supported by the virtual machine size."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub gpus: Option<i32>,
    #[doc = "The OS VHD disk size, in MB, allowed by the virtual machine size."]
    #[serde(rename = "osVhdSizeMB", default, skip_serializing_if = "Option::is_none")]
    pub os_vhd_size_mb: Option<i32>,
    #[doc = "The resource volume size, in MB, allowed by the virtual machine size."]
    #[serde(rename = "maxResourceVolumeMB", default, skip_serializing_if = "Option::is_none")]
    pub max_resource_volume_mb: Option<i32>,
    #[doc = "The amount of memory, in GB, supported by the virtual machine size."]
    #[serde(rename = "memoryGB", default, skip_serializing_if = "Option::is_none")]
    pub memory_gb: Option<f64>,
    #[doc = "Specifies if the virtual machine size supports low priority VMs."]
    #[serde(rename = "lowPriorityCapable", default, skip_serializing_if = "Option::is_none")]
    pub low_priority_capable: Option<bool>,
    #[doc = "Specifies if the virtual machine size supports premium IO."]
    #[serde(rename = "premiumIO", default, skip_serializing_if = "Option::is_none")]
    pub premium_io: Option<bool>,
}
impl VirtualMachineSize {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Virtual Machine size operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSizeListResult {
    #[doc = "The list of virtual machine sizes supported by AmlCompute."]
    #[serde(rename = "amlCompute", default, skip_serializing_if = "Vec::is_empty")]
    pub aml_compute: Vec<VirtualMachineSize>,
}
impl VirtualMachineSizeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Admin credentials for virtual machine"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSshCredentials {
    #[doc = "Username of admin account"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "Password of admin account"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[doc = "Public key data"]
    #[serde(rename = "publicKeyData", default, skip_serializing_if = "Option::is_none")]
    pub public_key_data: Option<String>,
    #[doc = "Private key data"]
    #[serde(rename = "privateKeyData", default, skip_serializing_if = "Option::is_none")]
    pub private_key_data: Option<String>,
}
impl VirtualMachineSshCredentials {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetConfiguration {
    #[doc = "The name of the virtual network."]
    #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_name: Option<String>,
    #[doc = "The name of the virtual network subnet."]
    #[serde(rename = "subnetName", default, skip_serializing_if = "Option::is_none")]
    pub subnet_name: Option<String>,
}
impl VnetConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An object that represents a machine learning workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Workspace {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of a machine learning workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkspaceProperties>,
}
impl Workspace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of a request to list machine learning workspaces."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceListResult {
    #[doc = "The list of machine learning workspaces. Since this list may be incomplete, the nextLink field should be used to request the next list of machine learning workspaces."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Workspace>,
    #[doc = "The URI that can be used to request the next list of machine learning workspaces."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkspaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a machine learning workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceProperties {
    #[doc = "The immutable id associated with this workspace."]
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[doc = "The description of this workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The friendly name for this workspace. This name in mutable"]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The creation time of the machine learning workspace in ISO8601 format."]
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[doc = "ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created"]
    #[serde(rename = "keyVault", default, skip_serializing_if = "Option::is_none")]
    pub key_vault: Option<String>,
    #[doc = "ARM id of the application insights associated with this workspace. This cannot be changed once the workspace has been created"]
    #[serde(rename = "applicationInsights", default, skip_serializing_if = "Option::is_none")]
    pub application_insights: Option<String>,
    #[doc = "ARM id of the container registry associated with this workspace. This cannot be changed once the workspace has been created"]
    #[serde(rename = "containerRegistry", default, skip_serializing_if = "Option::is_none")]
    pub container_registry: Option<String>,
    #[doc = "ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created"]
    #[serde(rename = "storageAccount", default, skip_serializing_if = "Option::is_none")]
    pub storage_account: Option<String>,
    #[doc = "Url for the discovery service to identify regional endpoints for machine learning experimentation services"]
    #[serde(rename = "discoveryUrl", default, skip_serializing_if = "Option::is_none")]
    pub discovery_url: Option<String>,
    #[doc = "The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<workspace_properties::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionProperty>,
    #[doc = "The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service"]
    #[serde(rename = "hbiWorkspace", default, skip_serializing_if = "Option::is_none")]
    pub hbi_workspace: Option<bool>,
    #[doc = "The name of the managed resource group created by workspace RP in customer subscription if the workspace is CMK workspace"]
    #[serde(rename = "serviceProvisionedResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub service_provisioned_resource_group: Option<String>,
    #[doc = "Count of private connections in the workspace"]
    #[serde(rename = "privateLinkCount", default, skip_serializing_if = "Option::is_none")]
    pub private_link_count: Option<i32>,
    #[doc = "The compute name for image build"]
    #[serde(rename = "imageBuildCompute", default, skip_serializing_if = "Option::is_none")]
    pub image_build_compute: Option<String>,
    #[doc = "The flag to indicate whether to allow public access when behind VNet."]
    #[serde(rename = "allowPublicAccessWhenBehindVnet", default, skip_serializing_if = "Option::is_none")]
    pub allow_public_access_when_behind_vnet: Option<bool>,
    #[doc = "The list of private endpoint connections in the workspace."]
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[doc = "The list of shared private link resources in this workspace."]
    #[serde(rename = "sharedPrivateLinkResources", default, skip_serializing_if = "Vec::is_empty")]
    pub shared_private_link_resources: Vec<SharedPrivateLinkResource>,
}
impl WorkspaceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod workspace_properties {
    use super::*;
    #[doc = "The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Unknown,
        Updating,
        Creating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The parameters for updating the properties of a machine learning workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspacePropertiesUpdateParameters {
    #[doc = "The description of this workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The friendly name for this workspace."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl WorkspacePropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes Workspace Sku details and features"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceSku {
    #[doc = "The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.)."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[doc = "A list of locations and availability zones in those locations where the SKU is available."]
    #[serde(rename = "locationInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub location_info: Vec<ResourceSkuLocationInfo>,
    #[doc = "Sku Tier like Basic or Enterprise"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "List of features/user capabilities associated with the sku"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<SkuCapability>,
    #[doc = "The restrictions because of which SKU cannot be used. This is empty if there are no restrictions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub restrictions: Vec<Restriction>,
}
impl WorkspaceSku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for updating a machine learning workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceUpdateParameters {
    #[doc = "The resource tags for the machine learning workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Sku of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "The parameters for updating the properties of a machine learning workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkspacePropertiesUpdateParameters>,
}
impl WorkspaceUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
