#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2AcknowledgementConnectionSettings {
    #[serde(rename = "ignoreCertificateNameMismatch")]
    pub ignore_certificate_name_mismatch: bool,
    #[serde(rename = "supportHttpStatusCodeContinue")]
    pub support_http_status_code_continue: bool,
    #[serde(rename = "keepHttpConnectionAlive")]
    pub keep_http_connection_alive: bool,
    #[serde(rename = "unfoldHttpHeaders")]
    pub unfold_http_headers: bool,
}
impl As2AcknowledgementConnectionSettings {
    pub fn new(
        ignore_certificate_name_mismatch: bool,
        support_http_status_code_continue: bool,
        keep_http_connection_alive: bool,
        unfold_http_headers: bool,
    ) -> Self {
        Self {
            ignore_certificate_name_mismatch,
            support_http_status_code_continue,
            keep_http_connection_alive,
            unfold_http_headers,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2AgreementContent {
    #[serde(rename = "receiveAgreement")]
    pub receive_agreement: As2OneWayAgreement,
    #[serde(rename = "sendAgreement")]
    pub send_agreement: As2OneWayAgreement,
}
impl As2AgreementContent {
    pub fn new(receive_agreement: As2OneWayAgreement, send_agreement: As2OneWayAgreement) -> Self {
        Self {
            receive_agreement,
            send_agreement,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2EnvelopeSettings {
    #[serde(rename = "messageContentType")]
    pub message_content_type: String,
    #[serde(rename = "transmitFileNameInMimeHeader")]
    pub transmit_file_name_in_mime_header: bool,
    #[serde(rename = "fileNameTemplate")]
    pub file_name_template: String,
    #[serde(rename = "suspendMessageOnFileNameGenerationError")]
    pub suspend_message_on_file_name_generation_error: bool,
    #[serde(rename = "autogenerateFileName")]
    pub autogenerate_file_name: bool,
}
impl As2EnvelopeSettings {
    pub fn new(
        message_content_type: String,
        transmit_file_name_in_mime_header: bool,
        file_name_template: String,
        suspend_message_on_file_name_generation_error: bool,
        autogenerate_file_name: bool,
    ) -> Self {
        Self {
            message_content_type,
            transmit_file_name_in_mime_header,
            file_name_template,
            suspend_message_on_file_name_generation_error,
            autogenerate_file_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2ErrorSettings {
    #[serde(rename = "suspendDuplicateMessage")]
    pub suspend_duplicate_message: bool,
    #[serde(rename = "resendIfMDNNotReceived")]
    pub resend_if_mdn_not_received: bool,
}
impl As2ErrorSettings {
    pub fn new(suspend_duplicate_message: bool, resend_if_mdn_not_received: bool) -> Self {
        Self {
            suspend_duplicate_message,
            resend_if_mdn_not_received,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2MdnSettings {
    #[serde(rename = "needMDN")]
    pub need_mdn: bool,
    #[serde(rename = "signMDN")]
    pub sign_mdn: bool,
    #[serde(rename = "sendMDNAsynchronously")]
    pub send_mdn_asynchronously: bool,
    #[serde(rename = "receiptDeliveryUrl", default, skip_serializing_if = "Option::is_none")]
    pub receipt_delivery_url: Option<String>,
    #[serde(rename = "dispositionNotificationTo", default, skip_serializing_if = "Option::is_none")]
    pub disposition_notification_to: Option<String>,
    #[serde(rename = "signOutboundMDNIfOptional")]
    pub sign_outbound_mdn_if_optional: bool,
    #[serde(rename = "mdnText", default, skip_serializing_if = "Option::is_none")]
    pub mdn_text: Option<String>,
    #[serde(rename = "sendInboundMDNToMessageBox")]
    pub send_inbound_mdn_to_message_box: bool,
    #[serde(rename = "micHashingAlgorithm")]
    pub mic_hashing_algorithm: HashingAlgorithm,
}
impl As2MdnSettings {
    pub fn new(
        need_mdn: bool,
        sign_mdn: bool,
        send_mdn_asynchronously: bool,
        sign_outbound_mdn_if_optional: bool,
        send_inbound_mdn_to_message_box: bool,
        mic_hashing_algorithm: HashingAlgorithm,
    ) -> Self {
        Self {
            need_mdn,
            sign_mdn,
            send_mdn_asynchronously,
            receipt_delivery_url: None,
            disposition_notification_to: None,
            sign_outbound_mdn_if_optional,
            mdn_text: None,
            send_inbound_mdn_to_message_box,
            mic_hashing_algorithm,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2MessageConnectionSettings {
    #[serde(rename = "ignoreCertificateNameMismatch")]
    pub ignore_certificate_name_mismatch: bool,
    #[serde(rename = "supportHttpStatusCodeContinue")]
    pub support_http_status_code_continue: bool,
    #[serde(rename = "keepHttpConnectionAlive")]
    pub keep_http_connection_alive: bool,
    #[serde(rename = "unfoldHttpHeaders")]
    pub unfold_http_headers: bool,
}
impl As2MessageConnectionSettings {
    pub fn new(
        ignore_certificate_name_mismatch: bool,
        support_http_status_code_continue: bool,
        keep_http_connection_alive: bool,
        unfold_http_headers: bool,
    ) -> Self {
        Self {
            ignore_certificate_name_mismatch,
            support_http_status_code_continue,
            keep_http_connection_alive,
            unfold_http_headers,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2OneWayAgreement {
    #[serde(rename = "senderBusinessIdentity")]
    pub sender_business_identity: BusinessIdentity,
    #[serde(rename = "receiverBusinessIdentity")]
    pub receiver_business_identity: BusinessIdentity,
    #[serde(rename = "protocolSettings")]
    pub protocol_settings: As2ProtocolSettings,
}
impl As2OneWayAgreement {
    pub fn new(
        sender_business_identity: BusinessIdentity,
        receiver_business_identity: BusinessIdentity,
        protocol_settings: As2ProtocolSettings,
    ) -> Self {
        Self {
            sender_business_identity,
            receiver_business_identity,
            protocol_settings,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2ProtocolSettings {
    #[serde(rename = "messageConnectionSettings")]
    pub message_connection_settings: As2MessageConnectionSettings,
    #[serde(rename = "acknowledgementConnectionSettings")]
    pub acknowledgement_connection_settings: As2AcknowledgementConnectionSettings,
    #[serde(rename = "mdnSettings")]
    pub mdn_settings: As2MdnSettings,
    #[serde(rename = "securitySettings")]
    pub security_settings: As2SecuritySettings,
    #[serde(rename = "validationSettings")]
    pub validation_settings: As2ValidationSettings,
    #[serde(rename = "envelopeSettings")]
    pub envelope_settings: As2EnvelopeSettings,
    #[serde(rename = "errorSettings")]
    pub error_settings: As2ErrorSettings,
}
impl As2ProtocolSettings {
    pub fn new(
        message_connection_settings: As2MessageConnectionSettings,
        acknowledgement_connection_settings: As2AcknowledgementConnectionSettings,
        mdn_settings: As2MdnSettings,
        security_settings: As2SecuritySettings,
        validation_settings: As2ValidationSettings,
        envelope_settings: As2EnvelopeSettings,
        error_settings: As2ErrorSettings,
    ) -> Self {
        Self {
            message_connection_settings,
            acknowledgement_connection_settings,
            mdn_settings,
            security_settings,
            validation_settings,
            envelope_settings,
            error_settings,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2SecuritySettings {
    #[serde(rename = "overrideGroupSigningCertificate")]
    pub override_group_signing_certificate: bool,
    #[serde(rename = "signingCertificateName", default, skip_serializing_if = "Option::is_none")]
    pub signing_certificate_name: Option<String>,
    #[serde(rename = "encryptionCertificateName", default, skip_serializing_if = "Option::is_none")]
    pub encryption_certificate_name: Option<String>,
    #[serde(rename = "enableNRRForInboundEncodedMessages")]
    pub enable_nrr_for_inbound_encoded_messages: bool,
    #[serde(rename = "enableNRRForInboundDecodedMessages")]
    pub enable_nrr_for_inbound_decoded_messages: bool,
    #[serde(rename = "enableNRRForOutboundMDN")]
    pub enable_nrr_for_outbound_mdn: bool,
    #[serde(rename = "enableNRRForOutboundEncodedMessages")]
    pub enable_nrr_for_outbound_encoded_messages: bool,
    #[serde(rename = "enableNRRForOutboundDecodedMessages")]
    pub enable_nrr_for_outbound_decoded_messages: bool,
    #[serde(rename = "enableNRRForInboundMDN")]
    pub enable_nrr_for_inbound_mdn: bool,
    #[serde(rename = "sha2AlgorithmFormat", default, skip_serializing_if = "Option::is_none")]
    pub sha2_algorithm_format: Option<String>,
}
impl As2SecuritySettings {
    pub fn new(
        override_group_signing_certificate: bool,
        enable_nrr_for_inbound_encoded_messages: bool,
        enable_nrr_for_inbound_decoded_messages: bool,
        enable_nrr_for_outbound_mdn: bool,
        enable_nrr_for_outbound_encoded_messages: bool,
        enable_nrr_for_outbound_decoded_messages: bool,
        enable_nrr_for_inbound_mdn: bool,
    ) -> Self {
        Self {
            override_group_signing_certificate,
            signing_certificate_name: None,
            encryption_certificate_name: None,
            enable_nrr_for_inbound_encoded_messages,
            enable_nrr_for_inbound_decoded_messages,
            enable_nrr_for_outbound_mdn,
            enable_nrr_for_outbound_encoded_messages,
            enable_nrr_for_outbound_decoded_messages,
            enable_nrr_for_inbound_mdn,
            sha2_algorithm_format: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct As2ValidationSettings {
    #[serde(rename = "overrideMessageProperties")]
    pub override_message_properties: bool,
    #[serde(rename = "encryptMessage")]
    pub encrypt_message: bool,
    #[serde(rename = "signMessage")]
    pub sign_message: bool,
    #[serde(rename = "compressMessage")]
    pub compress_message: bool,
    #[serde(rename = "checkDuplicateMessage")]
    pub check_duplicate_message: bool,
    #[serde(rename = "interchangeDuplicatesValidityDays")]
    pub interchange_duplicates_validity_days: i32,
    #[serde(rename = "checkCertificateRevocationListOnSend")]
    pub check_certificate_revocation_list_on_send: bool,
    #[serde(rename = "checkCertificateRevocationListOnReceive")]
    pub check_certificate_revocation_list_on_receive: bool,
    #[serde(rename = "encryptionAlgorithm")]
    pub encryption_algorithm: EncryptionAlgorithm,
    #[serde(rename = "signingAlgorithm", default, skip_serializing_if = "Option::is_none")]
    pub signing_algorithm: Option<SigningAlgorithm>,
}
impl As2ValidationSettings {
    pub fn new(
        override_message_properties: bool,
        encrypt_message: bool,
        sign_message: bool,
        compress_message: bool,
        check_duplicate_message: bool,
        interchange_duplicates_validity_days: i32,
        check_certificate_revocation_list_on_send: bool,
        check_certificate_revocation_list_on_receive: bool,
        encryption_algorithm: EncryptionAlgorithm,
    ) -> Self {
        Self {
            override_message_properties,
            encrypt_message,
            sign_message,
            compress_message,
            check_duplicate_message,
            interchange_duplicates_validity_days,
            check_certificate_revocation_list_on_send,
            check_certificate_revocation_list_on_receive,
            encryption_algorithm,
            signing_algorithm: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgreementContent {
    #[serde(rename = "aS2", default, skip_serializing_if = "Option::is_none")]
    pub a_s2: Option<As2AgreementContent>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub x12: Option<X12AgreementContent>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub edifact: Option<EdifactAgreementContent>,
}
impl AgreementContent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AgreementType {
    NotSpecified,
    #[serde(rename = "AS2")]
    As2,
    X12,
    Edifact,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactContentPropertiesDefinition {
    #[serde(flatten)]
    pub artifact_properties: ArtifactProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<serde_json::Value>,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "contentLink", default, skip_serializing_if = "Option::is_none")]
    pub content_link: Option<ContentLink>,
}
impl ArtifactContentPropertiesDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactProperties {
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
}
impl ArtifactProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssemblyCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AssemblyDefinition>,
}
impl AssemblyCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssemblyDefinition {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: AssemblyProperties,
}
impl AssemblyDefinition {
    pub fn new(properties: AssemblyProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssemblyProperties {
    #[serde(flatten)]
    pub artifact_content_properties_definition: ArtifactContentPropertiesDefinition,
    #[serde(rename = "assemblyName")]
    pub assembly_name: String,
    #[serde(rename = "assemblyVersion", default, skip_serializing_if = "Option::is_none")]
    pub assembly_version: Option<String>,
    #[serde(rename = "assemblyCulture", default, skip_serializing_if = "Option::is_none")]
    pub assembly_culture: Option<String>,
    #[serde(rename = "assemblyPublicKeyToken", default, skip_serializing_if = "Option::is_none")]
    pub assembly_public_key_token: Option<String>,
}
impl AssemblyProperties {
    pub fn new(assembly_name: String) -> Self {
        Self {
            artifact_content_properties_definition: ArtifactContentPropertiesDefinition::default(),
            assembly_name,
            assembly_version: None,
            assembly_culture: None,
            assembly_public_key_token: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceErrorInfo {
    #[serde(flatten)]
    pub error_info: ErrorInfo,
    pub message: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<AzureResourceErrorInfo>,
}
impl AzureResourceErrorInfo {
    pub fn new(error_info: ErrorInfo, message: String) -> Self {
        Self {
            error_info,
            message,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct B2bPartnerContent {
    #[serde(rename = "businessIdentities", default, skip_serializing_if = "Vec::is_empty")]
    pub business_identities: Vec<BusinessIdentity>,
}
impl B2bPartnerContent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BatchConfiguration {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: BatchConfigurationProperties,
}
impl BatchConfiguration {
    pub fn new(properties: BatchConfigurationProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchConfigurationCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BatchConfiguration>,
}
impl BatchConfigurationCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BatchConfigurationProperties {
    #[serde(flatten)]
    pub artifact_properties: ArtifactProperties,
    #[serde(rename = "batchGroupName")]
    pub batch_group_name: String,
    #[serde(rename = "releaseCriteria")]
    pub release_criteria: BatchReleaseCriteria,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
}
impl BatchConfigurationProperties {
    pub fn new(batch_group_name: String, release_criteria: BatchReleaseCriteria) -> Self {
        Self {
            artifact_properties: ArtifactProperties::default(),
            batch_group_name,
            release_criteria,
            created_time: None,
            changed_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchReleaseCriteria {
    #[serde(rename = "messageCount", default, skip_serializing_if = "Option::is_none")]
    pub message_count: Option<i32>,
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recurrence: Option<WorkflowTriggerRecurrence>,
}
impl BatchReleaseCriteria {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BusinessIdentity {
    pub qualifier: String,
    pub value: String,
}
impl BusinessIdentity {
    pub fn new(qualifier: String, value: String) -> Self {
        Self { qualifier, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CallbackUrl {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl CallbackUrl {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentHash {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub algorithm: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ContentHash {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentLink {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
    #[serde(rename = "contentVersion", default, skip_serializing_if = "Option::is_none")]
    pub content_version: Option<String>,
    #[serde(rename = "contentSize", default, skip_serializing_if = "Option::is_none")]
    pub content_size: Option<i64>,
    #[serde(rename = "contentHash", default, skip_serializing_if = "Option::is_none")]
    pub content_hash: Option<ContentHash>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<Object>,
}
impl ContentLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Correlation {
    #[serde(rename = "clientTrackingId", default, skip_serializing_if = "Option::is_none")]
    pub client_tracking_id: Option<String>,
}
impl Correlation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DayOfWeek {
    Sunday,
    Monday,
    Tuesday,
    Wednesday,
    Thursday,
    Friday,
    Saturday,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactAcknowledgementSettings {
    #[serde(rename = "needTechnicalAcknowledgement")]
    pub need_technical_acknowledgement: bool,
    #[serde(rename = "batchTechnicalAcknowledgements")]
    pub batch_technical_acknowledgements: bool,
    #[serde(rename = "needFunctionalAcknowledgement")]
    pub need_functional_acknowledgement: bool,
    #[serde(rename = "batchFunctionalAcknowledgements")]
    pub batch_functional_acknowledgements: bool,
    #[serde(rename = "needLoopForValidMessages")]
    pub need_loop_for_valid_messages: bool,
    #[serde(rename = "sendSynchronousAcknowledgement")]
    pub send_synchronous_acknowledgement: bool,
    #[serde(rename = "acknowledgementControlNumberPrefix", default, skip_serializing_if = "Option::is_none")]
    pub acknowledgement_control_number_prefix: Option<String>,
    #[serde(rename = "acknowledgementControlNumberSuffix", default, skip_serializing_if = "Option::is_none")]
    pub acknowledgement_control_number_suffix: Option<String>,
    #[serde(rename = "acknowledgementControlNumberLowerBound")]
    pub acknowledgement_control_number_lower_bound: i32,
    #[serde(rename = "acknowledgementControlNumberUpperBound")]
    pub acknowledgement_control_number_upper_bound: i32,
    #[serde(rename = "rolloverAcknowledgementControlNumber")]
    pub rollover_acknowledgement_control_number: bool,
}
impl EdifactAcknowledgementSettings {
    pub fn new(
        need_technical_acknowledgement: bool,
        batch_technical_acknowledgements: bool,
        need_functional_acknowledgement: bool,
        batch_functional_acknowledgements: bool,
        need_loop_for_valid_messages: bool,
        send_synchronous_acknowledgement: bool,
        acknowledgement_control_number_lower_bound: i32,
        acknowledgement_control_number_upper_bound: i32,
        rollover_acknowledgement_control_number: bool,
    ) -> Self {
        Self {
            need_technical_acknowledgement,
            batch_technical_acknowledgements,
            need_functional_acknowledgement,
            batch_functional_acknowledgements,
            need_loop_for_valid_messages,
            send_synchronous_acknowledgement,
            acknowledgement_control_number_prefix: None,
            acknowledgement_control_number_suffix: None,
            acknowledgement_control_number_lower_bound,
            acknowledgement_control_number_upper_bound,
            rollover_acknowledgement_control_number,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactAgreementContent {
    #[serde(rename = "receiveAgreement")]
    pub receive_agreement: EdifactOneWayAgreement,
    #[serde(rename = "sendAgreement")]
    pub send_agreement: EdifactOneWayAgreement,
}
impl EdifactAgreementContent {
    pub fn new(receive_agreement: EdifactOneWayAgreement, send_agreement: EdifactOneWayAgreement) -> Self {
        Self {
            receive_agreement,
            send_agreement,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EdifactCharacterSet {
    NotSpecified,
    #[serde(rename = "UNOB")]
    Unob,
    #[serde(rename = "UNOA")]
    Unoa,
    #[serde(rename = "UNOC")]
    Unoc,
    #[serde(rename = "UNOD")]
    Unod,
    #[serde(rename = "UNOE")]
    Unoe,
    #[serde(rename = "UNOF")]
    Unof,
    #[serde(rename = "UNOG")]
    Unog,
    #[serde(rename = "UNOH")]
    Unoh,
    #[serde(rename = "UNOI")]
    Unoi,
    #[serde(rename = "UNOJ")]
    Unoj,
    #[serde(rename = "UNOK")]
    Unok,
    #[serde(rename = "UNOX")]
    Unox,
    #[serde(rename = "UNOY")]
    Unoy,
    #[serde(rename = "KECA")]
    Keca,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EdifactDecimalIndicator {
    NotSpecified,
    Comma,
    Decimal,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactDelimiterOverride {
    #[serde(rename = "messageId", default, skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    #[serde(rename = "messageVersion", default, skip_serializing_if = "Option::is_none")]
    pub message_version: Option<String>,
    #[serde(rename = "messageRelease", default, skip_serializing_if = "Option::is_none")]
    pub message_release: Option<String>,
    #[serde(rename = "dataElementSeparator")]
    pub data_element_separator: i32,
    #[serde(rename = "componentSeparator")]
    pub component_separator: i32,
    #[serde(rename = "segmentTerminator")]
    pub segment_terminator: i32,
    #[serde(rename = "repetitionSeparator")]
    pub repetition_separator: i32,
    #[serde(rename = "segmentTerminatorSuffix")]
    pub segment_terminator_suffix: SegmentTerminatorSuffix,
    #[serde(rename = "decimalPointIndicator")]
    pub decimal_point_indicator: EdifactDecimalIndicator,
    #[serde(rename = "releaseIndicator")]
    pub release_indicator: i32,
    #[serde(rename = "messageAssociationAssignedCode", default, skip_serializing_if = "Option::is_none")]
    pub message_association_assigned_code: Option<String>,
    #[serde(rename = "targetNamespace", default, skip_serializing_if = "Option::is_none")]
    pub target_namespace: Option<String>,
}
impl EdifactDelimiterOverride {
    pub fn new(
        data_element_separator: i32,
        component_separator: i32,
        segment_terminator: i32,
        repetition_separator: i32,
        segment_terminator_suffix: SegmentTerminatorSuffix,
        decimal_point_indicator: EdifactDecimalIndicator,
        release_indicator: i32,
    ) -> Self {
        Self {
            message_id: None,
            message_version: None,
            message_release: None,
            data_element_separator,
            component_separator,
            segment_terminator,
            repetition_separator,
            segment_terminator_suffix,
            decimal_point_indicator,
            release_indicator,
            message_association_assigned_code: None,
            target_namespace: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EdifactEnvelopeOverride {
    #[serde(rename = "messageId", default, skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    #[serde(rename = "messageVersion", default, skip_serializing_if = "Option::is_none")]
    pub message_version: Option<String>,
    #[serde(rename = "messageRelease", default, skip_serializing_if = "Option::is_none")]
    pub message_release: Option<String>,
    #[serde(rename = "messageAssociationAssignedCode", default, skip_serializing_if = "Option::is_none")]
    pub message_association_assigned_code: Option<String>,
    #[serde(rename = "targetNamespace", default, skip_serializing_if = "Option::is_none")]
    pub target_namespace: Option<String>,
    #[serde(rename = "functionalGroupId", default, skip_serializing_if = "Option::is_none")]
    pub functional_group_id: Option<String>,
    #[serde(rename = "senderApplicationQualifier", default, skip_serializing_if = "Option::is_none")]
    pub sender_application_qualifier: Option<String>,
    #[serde(rename = "senderApplicationId", default, skip_serializing_if = "Option::is_none")]
    pub sender_application_id: Option<String>,
    #[serde(rename = "receiverApplicationQualifier", default, skip_serializing_if = "Option::is_none")]
    pub receiver_application_qualifier: Option<String>,
    #[serde(rename = "receiverApplicationId", default, skip_serializing_if = "Option::is_none")]
    pub receiver_application_id: Option<String>,
    #[serde(rename = "controllingAgencyCode", default, skip_serializing_if = "Option::is_none")]
    pub controlling_agency_code: Option<String>,
    #[serde(rename = "groupHeaderMessageVersion", default, skip_serializing_if = "Option::is_none")]
    pub group_header_message_version: Option<String>,
    #[serde(rename = "groupHeaderMessageRelease", default, skip_serializing_if = "Option::is_none")]
    pub group_header_message_release: Option<String>,
    #[serde(rename = "associationAssignedCode", default, skip_serializing_if = "Option::is_none")]
    pub association_assigned_code: Option<String>,
    #[serde(rename = "applicationPassword", default, skip_serializing_if = "Option::is_none")]
    pub application_password: Option<String>,
}
impl EdifactEnvelopeOverride {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactEnvelopeSettings {
    #[serde(rename = "groupAssociationAssignedCode", default, skip_serializing_if = "Option::is_none")]
    pub group_association_assigned_code: Option<String>,
    #[serde(rename = "communicationAgreementId", default, skip_serializing_if = "Option::is_none")]
    pub communication_agreement_id: Option<String>,
    #[serde(rename = "applyDelimiterStringAdvice")]
    pub apply_delimiter_string_advice: bool,
    #[serde(rename = "createGroupingSegments")]
    pub create_grouping_segments: bool,
    #[serde(rename = "enableDefaultGroupHeaders")]
    pub enable_default_group_headers: bool,
    #[serde(rename = "recipientReferencePasswordValue", default, skip_serializing_if = "Option::is_none")]
    pub recipient_reference_password_value: Option<String>,
    #[serde(rename = "recipientReferencePasswordQualifier", default, skip_serializing_if = "Option::is_none")]
    pub recipient_reference_password_qualifier: Option<String>,
    #[serde(rename = "applicationReferenceId", default, skip_serializing_if = "Option::is_none")]
    pub application_reference_id: Option<String>,
    #[serde(rename = "processingPriorityCode", default, skip_serializing_if = "Option::is_none")]
    pub processing_priority_code: Option<String>,
    #[serde(rename = "interchangeControlNumberLowerBound")]
    pub interchange_control_number_lower_bound: i64,
    #[serde(rename = "interchangeControlNumberUpperBound")]
    pub interchange_control_number_upper_bound: i64,
    #[serde(rename = "rolloverInterchangeControlNumber")]
    pub rollover_interchange_control_number: bool,
    #[serde(rename = "interchangeControlNumberPrefix", default, skip_serializing_if = "Option::is_none")]
    pub interchange_control_number_prefix: Option<String>,
    #[serde(rename = "interchangeControlNumberSuffix", default, skip_serializing_if = "Option::is_none")]
    pub interchange_control_number_suffix: Option<String>,
    #[serde(rename = "senderReverseRoutingAddress", default, skip_serializing_if = "Option::is_none")]
    pub sender_reverse_routing_address: Option<String>,
    #[serde(rename = "receiverReverseRoutingAddress", default, skip_serializing_if = "Option::is_none")]
    pub receiver_reverse_routing_address: Option<String>,
    #[serde(rename = "functionalGroupId", default, skip_serializing_if = "Option::is_none")]
    pub functional_group_id: Option<String>,
    #[serde(rename = "groupControllingAgencyCode", default, skip_serializing_if = "Option::is_none")]
    pub group_controlling_agency_code: Option<String>,
    #[serde(rename = "groupMessageVersion", default, skip_serializing_if = "Option::is_none")]
    pub group_message_version: Option<String>,
    #[serde(rename = "groupMessageRelease", default, skip_serializing_if = "Option::is_none")]
    pub group_message_release: Option<String>,
    #[serde(rename = "groupControlNumberLowerBound")]
    pub group_control_number_lower_bound: i64,
    #[serde(rename = "groupControlNumberUpperBound")]
    pub group_control_number_upper_bound: i64,
    #[serde(rename = "rolloverGroupControlNumber")]
    pub rollover_group_control_number: bool,
    #[serde(rename = "groupControlNumberPrefix", default, skip_serializing_if = "Option::is_none")]
    pub group_control_number_prefix: Option<String>,
    #[serde(rename = "groupControlNumberSuffix", default, skip_serializing_if = "Option::is_none")]
    pub group_control_number_suffix: Option<String>,
    #[serde(rename = "groupApplicationReceiverQualifier", default, skip_serializing_if = "Option::is_none")]
    pub group_application_receiver_qualifier: Option<String>,
    #[serde(rename = "groupApplicationReceiverId", default, skip_serializing_if = "Option::is_none")]
    pub group_application_receiver_id: Option<String>,
    #[serde(rename = "groupApplicationSenderQualifier", default, skip_serializing_if = "Option::is_none")]
    pub group_application_sender_qualifier: Option<String>,
    #[serde(rename = "groupApplicationSenderId", default, skip_serializing_if = "Option::is_none")]
    pub group_application_sender_id: Option<String>,
    #[serde(rename = "groupApplicationPassword", default, skip_serializing_if = "Option::is_none")]
    pub group_application_password: Option<String>,
    #[serde(rename = "overwriteExistingTransactionSetControlNumber")]
    pub overwrite_existing_transaction_set_control_number: bool,
    #[serde(rename = "transactionSetControlNumberPrefix", default, skip_serializing_if = "Option::is_none")]
    pub transaction_set_control_number_prefix: Option<String>,
    #[serde(rename = "transactionSetControlNumberSuffix", default, skip_serializing_if = "Option::is_none")]
    pub transaction_set_control_number_suffix: Option<String>,
    #[serde(rename = "transactionSetControlNumberLowerBound")]
    pub transaction_set_control_number_lower_bound: i64,
    #[serde(rename = "transactionSetControlNumberUpperBound")]
    pub transaction_set_control_number_upper_bound: i64,
    #[serde(rename = "rolloverTransactionSetControlNumber")]
    pub rollover_transaction_set_control_number: bool,
    #[serde(rename = "isTestInterchange")]
    pub is_test_interchange: bool,
    #[serde(rename = "senderInternalIdentification", default, skip_serializing_if = "Option::is_none")]
    pub sender_internal_identification: Option<String>,
    #[serde(rename = "senderInternalSubIdentification", default, skip_serializing_if = "Option::is_none")]
    pub sender_internal_sub_identification: Option<String>,
    #[serde(rename = "receiverInternalIdentification", default, skip_serializing_if = "Option::is_none")]
    pub receiver_internal_identification: Option<String>,
    #[serde(rename = "receiverInternalSubIdentification", default, skip_serializing_if = "Option::is_none")]
    pub receiver_internal_sub_identification: Option<String>,
}
impl EdifactEnvelopeSettings {
    pub fn new(
        apply_delimiter_string_advice: bool,
        create_grouping_segments: bool,
        enable_default_group_headers: bool,
        interchange_control_number_lower_bound: i64,
        interchange_control_number_upper_bound: i64,
        rollover_interchange_control_number: bool,
        group_control_number_lower_bound: i64,
        group_control_number_upper_bound: i64,
        rollover_group_control_number: bool,
        overwrite_existing_transaction_set_control_number: bool,
        transaction_set_control_number_lower_bound: i64,
        transaction_set_control_number_upper_bound: i64,
        rollover_transaction_set_control_number: bool,
        is_test_interchange: bool,
    ) -> Self {
        Self {
            group_association_assigned_code: None,
            communication_agreement_id: None,
            apply_delimiter_string_advice,
            create_grouping_segments,
            enable_default_group_headers,
            recipient_reference_password_value: None,
            recipient_reference_password_qualifier: None,
            application_reference_id: None,
            processing_priority_code: None,
            interchange_control_number_lower_bound,
            interchange_control_number_upper_bound,
            rollover_interchange_control_number,
            interchange_control_number_prefix: None,
            interchange_control_number_suffix: None,
            sender_reverse_routing_address: None,
            receiver_reverse_routing_address: None,
            functional_group_id: None,
            group_controlling_agency_code: None,
            group_message_version: None,
            group_message_release: None,
            group_control_number_lower_bound,
            group_control_number_upper_bound,
            rollover_group_control_number,
            group_control_number_prefix: None,
            group_control_number_suffix: None,
            group_application_receiver_qualifier: None,
            group_application_receiver_id: None,
            group_application_sender_qualifier: None,
            group_application_sender_id: None,
            group_application_password: None,
            overwrite_existing_transaction_set_control_number,
            transaction_set_control_number_prefix: None,
            transaction_set_control_number_suffix: None,
            transaction_set_control_number_lower_bound,
            transaction_set_control_number_upper_bound,
            rollover_transaction_set_control_number,
            is_test_interchange,
            sender_internal_identification: None,
            sender_internal_sub_identification: None,
            receiver_internal_identification: None,
            receiver_internal_sub_identification: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactFramingSettings {
    #[serde(rename = "serviceCodeListDirectoryVersion", default, skip_serializing_if = "Option::is_none")]
    pub service_code_list_directory_version: Option<String>,
    #[serde(rename = "characterEncoding", default, skip_serializing_if = "Option::is_none")]
    pub character_encoding: Option<String>,
    #[serde(rename = "protocolVersion")]
    pub protocol_version: i32,
    #[serde(rename = "dataElementSeparator")]
    pub data_element_separator: i32,
    #[serde(rename = "componentSeparator")]
    pub component_separator: i32,
    #[serde(rename = "segmentTerminator")]
    pub segment_terminator: i32,
    #[serde(rename = "releaseIndicator")]
    pub release_indicator: i32,
    #[serde(rename = "repetitionSeparator")]
    pub repetition_separator: i32,
    #[serde(rename = "characterSet")]
    pub character_set: EdifactCharacterSet,
    #[serde(rename = "decimalPointIndicator")]
    pub decimal_point_indicator: EdifactDecimalIndicator,
    #[serde(rename = "segmentTerminatorSuffix")]
    pub segment_terminator_suffix: SegmentTerminatorSuffix,
}
impl EdifactFramingSettings {
    pub fn new(
        protocol_version: i32,
        data_element_separator: i32,
        component_separator: i32,
        segment_terminator: i32,
        release_indicator: i32,
        repetition_separator: i32,
        character_set: EdifactCharacterSet,
        decimal_point_indicator: EdifactDecimalIndicator,
        segment_terminator_suffix: SegmentTerminatorSuffix,
    ) -> Self {
        Self {
            service_code_list_directory_version: None,
            character_encoding: None,
            protocol_version,
            data_element_separator,
            component_separator,
            segment_terminator,
            release_indicator,
            repetition_separator,
            character_set,
            decimal_point_indicator,
            segment_terminator_suffix,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactMessageFilter {
    #[serde(rename = "messageFilterType")]
    pub message_filter_type: MessageFilterType,
}
impl EdifactMessageFilter {
    pub fn new(message_filter_type: MessageFilterType) -> Self {
        Self { message_filter_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactMessageIdentifier {
    #[serde(rename = "messageId")]
    pub message_id: String,
}
impl EdifactMessageIdentifier {
    pub fn new(message_id: String) -> Self {
        Self { message_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactOneWayAgreement {
    #[serde(rename = "senderBusinessIdentity")]
    pub sender_business_identity: BusinessIdentity,
    #[serde(rename = "receiverBusinessIdentity")]
    pub receiver_business_identity: BusinessIdentity,
    #[serde(rename = "protocolSettings")]
    pub protocol_settings: EdifactProtocolSettings,
}
impl EdifactOneWayAgreement {
    pub fn new(
        sender_business_identity: BusinessIdentity,
        receiver_business_identity: BusinessIdentity,
        protocol_settings: EdifactProtocolSettings,
    ) -> Self {
        Self {
            sender_business_identity,
            receiver_business_identity,
            protocol_settings,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactProcessingSettings {
    #[serde(rename = "maskSecurityInfo")]
    pub mask_security_info: bool,
    #[serde(rename = "preserveInterchange")]
    pub preserve_interchange: bool,
    #[serde(rename = "suspendInterchangeOnError")]
    pub suspend_interchange_on_error: bool,
    #[serde(rename = "createEmptyXmlTagsForTrailingSeparators")]
    pub create_empty_xml_tags_for_trailing_separators: bool,
    #[serde(rename = "useDotAsDecimalSeparator")]
    pub use_dot_as_decimal_separator: bool,
}
impl EdifactProcessingSettings {
    pub fn new(
        mask_security_info: bool,
        preserve_interchange: bool,
        suspend_interchange_on_error: bool,
        create_empty_xml_tags_for_trailing_separators: bool,
        use_dot_as_decimal_separator: bool,
    ) -> Self {
        Self {
            mask_security_info,
            preserve_interchange,
            suspend_interchange_on_error,
            create_empty_xml_tags_for_trailing_separators,
            use_dot_as_decimal_separator,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactProtocolSettings {
    #[serde(rename = "validationSettings")]
    pub validation_settings: EdifactValidationSettings,
    #[serde(rename = "framingSettings")]
    pub framing_settings: EdifactFramingSettings,
    #[serde(rename = "envelopeSettings")]
    pub envelope_settings: EdifactEnvelopeSettings,
    #[serde(rename = "acknowledgementSettings")]
    pub acknowledgement_settings: EdifactAcknowledgementSettings,
    #[serde(rename = "messageFilter")]
    pub message_filter: EdifactMessageFilter,
    #[serde(rename = "processingSettings")]
    pub processing_settings: EdifactProcessingSettings,
    #[serde(rename = "envelopeOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub envelope_overrides: Vec<EdifactEnvelopeOverride>,
    #[serde(rename = "messageFilterList", default, skip_serializing_if = "Vec::is_empty")]
    pub message_filter_list: Vec<EdifactMessageIdentifier>,
    #[serde(rename = "schemaReferences")]
    pub schema_references: Vec<EdifactSchemaReference>,
    #[serde(rename = "validationOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_overrides: Vec<EdifactValidationOverride>,
    #[serde(rename = "edifactDelimiterOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub edifact_delimiter_overrides: Vec<EdifactDelimiterOverride>,
}
impl EdifactProtocolSettings {
    pub fn new(
        validation_settings: EdifactValidationSettings,
        framing_settings: EdifactFramingSettings,
        envelope_settings: EdifactEnvelopeSettings,
        acknowledgement_settings: EdifactAcknowledgementSettings,
        message_filter: EdifactMessageFilter,
        processing_settings: EdifactProcessingSettings,
        schema_references: Vec<EdifactSchemaReference>,
    ) -> Self {
        Self {
            validation_settings,
            framing_settings,
            envelope_settings,
            acknowledgement_settings,
            message_filter,
            processing_settings,
            envelope_overrides: Vec::new(),
            message_filter_list: Vec::new(),
            schema_references,
            validation_overrides: Vec::new(),
            edifact_delimiter_overrides: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactSchemaReference {
    #[serde(rename = "messageId")]
    pub message_id: String,
    #[serde(rename = "messageVersion")]
    pub message_version: String,
    #[serde(rename = "messageRelease")]
    pub message_release: String,
    #[serde(rename = "senderApplicationId", default, skip_serializing_if = "Option::is_none")]
    pub sender_application_id: Option<String>,
    #[serde(rename = "senderApplicationQualifier", default, skip_serializing_if = "Option::is_none")]
    pub sender_application_qualifier: Option<String>,
    #[serde(rename = "associationAssignedCode", default, skip_serializing_if = "Option::is_none")]
    pub association_assigned_code: Option<String>,
    #[serde(rename = "schemaName")]
    pub schema_name: String,
}
impl EdifactSchemaReference {
    pub fn new(message_id: String, message_version: String, message_release: String, schema_name: String) -> Self {
        Self {
            message_id,
            message_version,
            message_release,
            sender_application_id: None,
            sender_application_qualifier: None,
            association_assigned_code: None,
            schema_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactValidationOverride {
    #[serde(rename = "messageId")]
    pub message_id: String,
    #[serde(rename = "enforceCharacterSet")]
    pub enforce_character_set: bool,
    #[serde(rename = "validateEDITypes")]
    pub validate_edi_types: bool,
    #[serde(rename = "validateXSDTypes")]
    pub validate_xsd_types: bool,
    #[serde(rename = "allowLeadingAndTrailingSpacesAndZeroes")]
    pub allow_leading_and_trailing_spaces_and_zeroes: bool,
    #[serde(rename = "trailingSeparatorPolicy")]
    pub trailing_separator_policy: TrailingSeparatorPolicy,
    #[serde(rename = "trimLeadingAndTrailingSpacesAndZeroes")]
    pub trim_leading_and_trailing_spaces_and_zeroes: bool,
}
impl EdifactValidationOverride {
    pub fn new(
        message_id: String,
        enforce_character_set: bool,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: TrailingSeparatorPolicy,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
    ) -> Self {
        Self {
            message_id,
            enforce_character_set,
            validate_edi_types,
            validate_xsd_types,
            allow_leading_and_trailing_spaces_and_zeroes,
            trailing_separator_policy,
            trim_leading_and_trailing_spaces_and_zeroes,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdifactValidationSettings {
    #[serde(rename = "validateCharacterSet")]
    pub validate_character_set: bool,
    #[serde(rename = "checkDuplicateInterchangeControlNumber")]
    pub check_duplicate_interchange_control_number: bool,
    #[serde(rename = "interchangeControlNumberValidityDays")]
    pub interchange_control_number_validity_days: i32,
    #[serde(rename = "checkDuplicateGroupControlNumber")]
    pub check_duplicate_group_control_number: bool,
    #[serde(rename = "checkDuplicateTransactionSetControlNumber")]
    pub check_duplicate_transaction_set_control_number: bool,
    #[serde(rename = "validateEDITypes")]
    pub validate_edi_types: bool,
    #[serde(rename = "validateXSDTypes")]
    pub validate_xsd_types: bool,
    #[serde(rename = "allowLeadingAndTrailingSpacesAndZeroes")]
    pub allow_leading_and_trailing_spaces_and_zeroes: bool,
    #[serde(rename = "trimLeadingAndTrailingSpacesAndZeroes")]
    pub trim_leading_and_trailing_spaces_and_zeroes: bool,
    #[serde(rename = "trailingSeparatorPolicy")]
    pub trailing_separator_policy: TrailingSeparatorPolicy,
}
impl EdifactValidationSettings {
    pub fn new(
        validate_character_set: bool,
        check_duplicate_interchange_control_number: bool,
        interchange_control_number_validity_days: i32,
        check_duplicate_group_control_number: bool,
        check_duplicate_transaction_set_control_number: bool,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: TrailingSeparatorPolicy,
    ) -> Self {
        Self {
            validate_character_set,
            check_duplicate_interchange_control_number,
            interchange_control_number_validity_days,
            check_duplicate_group_control_number,
            check_duplicate_transaction_set_control_number,
            validate_edi_types,
            validate_xsd_types,
            allow_leading_and_trailing_spaces_and_zeroes,
            trim_leading_and_trailing_spaces_and_zeroes,
            trailing_separator_policy,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EncryptionAlgorithm {
    NotSpecified,
    None,
    #[serde(rename = "DES3")]
    Des3,
    #[serde(rename = "RC2")]
    Rc2,
    #[serde(rename = "AES128")]
    Aes128,
    #[serde(rename = "AES192")]
    Aes192,
    #[serde(rename = "AES256")]
    Aes256,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorInfo {
    pub code: String,
}
impl ErrorInfo {
    pub fn new(code: String) -> Self {
        Self { code }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorProperties>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EventLevel {
    LogAlways,
    Critical,
    Error,
    Warning,
    Informational,
    Verbose,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Expression {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub text: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subexpressions: Vec<Expression>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<AzureResourceErrorInfo>,
}
impl Expression {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressionRoot {
    #[serde(flatten)]
    pub expression: Expression,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl ExpressionRoot {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressionTraces {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub inputs: Vec<ExpressionRoot>,
}
impl ExpressionTraces {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenerateUpgradedDefinitionParameters {
    #[serde(rename = "targetSchemaVersion", default, skip_serializing_if = "Option::is_none")]
    pub target_schema_version: Option<String>,
}
impl GenerateUpgradedDefinitionParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetCallbackUrlParameters {
    #[serde(rename = "notAfter", default, skip_serializing_if = "Option::is_none")]
    pub not_after: Option<String>,
    #[serde(rename = "keyType", default, skip_serializing_if = "Option::is_none")]
    pub key_type: Option<KeyType>,
}
impl GetCallbackUrlParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum HashingAlgorithm {
    NotSpecified,
    None,
    #[serde(rename = "MD5")]
    Md5,
    #[serde(rename = "SHA1")]
    Sha1,
    #[serde(rename = "SHA2256")]
    Sha2256,
    #[serde(rename = "SHA2384")]
    Sha2384,
    #[serde(rename = "SHA2512")]
    Sha2512,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccount {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IntegrationAccountProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<IntegrationAccountSku>,
}
impl IntegrationAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountAgreement {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: IntegrationAccountAgreementProperties,
}
impl IntegrationAccountAgreement {
    pub fn new(properties: IntegrationAccountAgreementProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountAgreementFilter {
    #[serde(rename = "agreementType")]
    pub agreement_type: AgreementType,
}
impl IntegrationAccountAgreementFilter {
    pub fn new(agreement_type: AgreementType) -> Self {
        Self { agreement_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountAgreementListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IntegrationAccountAgreement>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationAccountAgreementListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountAgreementProperties {
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(rename = "agreementType")]
    pub agreement_type: AgreementType,
    #[serde(rename = "hostPartner")]
    pub host_partner: String,
    #[serde(rename = "guestPartner")]
    pub guest_partner: String,
    #[serde(rename = "hostIdentity")]
    pub host_identity: BusinessIdentity,
    #[serde(rename = "guestIdentity")]
    pub guest_identity: BusinessIdentity,
    pub content: AgreementContent,
}
impl IntegrationAccountAgreementProperties {
    pub fn new(
        agreement_type: AgreementType,
        host_partner: String,
        guest_partner: String,
        host_identity: BusinessIdentity,
        guest_identity: BusinessIdentity,
        content: AgreementContent,
    ) -> Self {
        Self {
            created_time: None,
            changed_time: None,
            metadata: None,
            agreement_type,
            host_partner,
            guest_partner,
            host_identity,
            guest_identity,
            content,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountCertificate {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: IntegrationAccountCertificateProperties,
}
impl IntegrationAccountCertificate {
    pub fn new(properties: IntegrationAccountCertificateProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountCertificateListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IntegrationAccountCertificate>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationAccountCertificateListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountCertificateProperties {
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<KeyVaultKeyReference>,
    #[serde(rename = "publicCertificate", default, skip_serializing_if = "Option::is_none")]
    pub public_certificate: Option<String>,
}
impl IntegrationAccountCertificateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IntegrationAccount>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationAccountListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountMap {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: IntegrationAccountMapProperties,
}
impl IntegrationAccountMap {
    pub fn new(properties: IntegrationAccountMapProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountMapFilter {
    #[serde(rename = "mapType")]
    pub map_type: MapType,
}
impl IntegrationAccountMapFilter {
    pub fn new(map_type: MapType) -> Self {
        Self { map_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountMapListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IntegrationAccountMap>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationAccountMapListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountMapProperties {
    #[serde(rename = "mapType")]
    pub map_type: MapType,
    #[serde(rename = "parametersSchema", default, skip_serializing_if = "Option::is_none")]
    pub parameters_schema: Option<integration_account_map_properties::ParametersSchema>,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "contentLink", default, skip_serializing_if = "Option::is_none")]
    pub content_link: Option<ContentLink>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
}
impl IntegrationAccountMapProperties {
    pub fn new(map_type: MapType) -> Self {
        Self {
            map_type,
            parameters_schema: None,
            created_time: None,
            changed_time: None,
            content: None,
            content_type: None,
            content_link: None,
            metadata: None,
        }
    }
}
pub mod integration_account_map_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ParametersSchema {
        #[serde(rename = "ref", default, skip_serializing_if = "Option::is_none")]
        pub ref_: Option<String>,
    }
    impl ParametersSchema {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountPartner {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: IntegrationAccountPartnerProperties,
}
impl IntegrationAccountPartner {
    pub fn new(properties: IntegrationAccountPartnerProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountPartnerFilter {
    #[serde(rename = "partnerType")]
    pub partner_type: PartnerType,
}
impl IntegrationAccountPartnerFilter {
    pub fn new(partner_type: PartnerType) -> Self {
        Self { partner_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountPartnerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IntegrationAccountPartner>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationAccountPartnerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountPartnerProperties {
    #[serde(rename = "partnerType")]
    pub partner_type: PartnerType,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    pub content: PartnerContent,
}
impl IntegrationAccountPartnerProperties {
    pub fn new(partner_type: PartnerType, content: PartnerContent) -> Self {
        Self {
            partner_type,
            created_time: None,
            changed_time: None,
            metadata: None,
            content,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountProperties {}
impl IntegrationAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountSchema {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: IntegrationAccountSchemaProperties,
}
impl IntegrationAccountSchema {
    pub fn new(properties: IntegrationAccountSchemaProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountSchemaFilter {
    #[serde(rename = "schemaType")]
    pub schema_type: SchemaType,
}
impl IntegrationAccountSchemaFilter {
    pub fn new(schema_type: SchemaType) -> Self {
        Self { schema_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountSchemaListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IntegrationAccountSchema>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationAccountSchemaListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountSchemaProperties {
    #[serde(rename = "schemaType")]
    pub schema_type: SchemaType,
    #[serde(rename = "targetNamespace", default, skip_serializing_if = "Option::is_none")]
    pub target_namespace: Option<String>,
    #[serde(rename = "documentName", default, skip_serializing_if = "Option::is_none")]
    pub document_name: Option<String>,
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<String>,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "contentLink", default, skip_serializing_if = "Option::is_none")]
    pub content_link: Option<ContentLink>,
}
impl IntegrationAccountSchemaProperties {
    pub fn new(schema_type: SchemaType) -> Self {
        Self {
            schema_type,
            target_namespace: None,
            document_name: None,
            file_name: None,
            created_time: None,
            changed_time: None,
            metadata: None,
            content: None,
            content_type: None,
            content_link: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountSession {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: IntegrationAccountSessionProperties,
}
impl IntegrationAccountSession {
    pub fn new(properties: IntegrationAccountSessionProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountSessionFilter {
    #[serde(rename = "changedTime")]
    pub changed_time: String,
}
impl IntegrationAccountSessionFilter {
    pub fn new(changed_time: String) -> Self {
        Self { changed_time }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountSessionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IntegrationAccountSession>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationAccountSessionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationAccountSessionProperties {
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<Object>,
}
impl IntegrationAccountSessionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationAccountSku {
    pub name: IntegrationAccountSkuName,
}
impl IntegrationAccountSku {
    pub fn new(name: IntegrationAccountSkuName) -> Self {
        Self { name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IntegrationAccountSkuName {
    NotSpecified,
    Free,
    Basic,
    Standard,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JsonSchema {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
}
impl JsonSchema {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum KeyType {
    NotSpecified,
    Primary,
    Secondary,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultKey {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kid: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub attributes: Option<key_vault_key::Attributes>,
}
impl KeyVaultKey {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod key_vault_key {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Attributes {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub created: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub updated: Option<i64>,
    }
    impl Attributes {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultKeyCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<KeyVaultKey>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl KeyVaultKeyCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultKeyReference {
    #[serde(rename = "keyVault")]
    pub key_vault: key_vault_key_reference::KeyVault,
    #[serde(rename = "keyName")]
    pub key_name: String,
    #[serde(rename = "keyVersion", default, skip_serializing_if = "Option::is_none")]
    pub key_version: Option<String>,
}
impl KeyVaultKeyReference {
    pub fn new(key_vault: key_vault_key_reference::KeyVault, key_name: String) -> Self {
        Self {
            key_vault,
            key_name,
            key_version: None,
        }
    }
}
pub mod key_vault_key_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct KeyVault {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
        pub type_: Option<String>,
    }
    impl KeyVault {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultReference {
    #[serde(flatten)]
    pub resource_reference: ResourceReference,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl KeyVaultReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListKeyVaultKeysDefinition {
    #[serde(rename = "keyVault")]
    pub key_vault: KeyVaultReference,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ListKeyVaultKeysDefinition {
    pub fn new(key_vault: KeyVaultReference) -> Self {
        Self {
            key_vault,
            skip_token: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum MapType {
    NotSpecified,
    Xslt,
    Xslt20,
    Xslt30,
    Liquid,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum MessageFilterType {
    NotSpecified,
    Include,
    Exclude,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Object {}
impl Object {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResult {
    #[serde(flatten)]
    pub operation_result_properties: OperationResultProperties,
    #[serde(rename = "trackingId", default, skip_serializing_if = "Option::is_none")]
    pub tracking_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub inputs: Option<Object>,
    #[serde(rename = "inputsLink", default, skip_serializing_if = "Option::is_none")]
    pub inputs_link: Option<ContentLink>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub outputs: Option<Object>,
    #[serde(rename = "outputsLink", default, skip_serializing_if = "Option::is_none")]
    pub outputs_link: Option<ContentLink>,
    #[serde(rename = "trackedProperties", default, skip_serializing_if = "Option::is_none")]
    pub tracked_properties: Option<Object>,
    #[serde(rename = "retryHistory", default, skip_serializing_if = "Vec::is_empty")]
    pub retry_history: Vec<RetryHistory>,
    #[serde(rename = "iterationCount", default, skip_serializing_if = "Option::is_none")]
    pub iteration_count: Option<i32>,
}
impl OperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResultProperties {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub correlation: Option<RunActionCorrelation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<WorkflowStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
}
impl OperationResultProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ParameterType {
    NotSpecified,
    String,
    SecureString,
    Int,
    Float,
    Bool,
    Array,
    Object,
    SecureObject,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartnerContent {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub b2b: Option<B2bPartnerContent>,
}
impl PartnerContent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PartnerType {
    NotSpecified,
    #[serde(rename = "B2B")]
    B2b,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecurrenceFrequency {
    NotSpecified,
    Second,
    Minute,
    Hour,
    Day,
    Week,
    Month,
    Year,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecurrenceSchedule {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub minutes: Vec<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hours: Vec<i32>,
    #[serde(rename = "weekDays", default, skip_serializing_if = "Vec::is_empty")]
    pub week_days: Vec<String>,
    #[serde(rename = "monthDays", default, skip_serializing_if = "Vec::is_empty")]
    pub month_days: Vec<i32>,
    #[serde(rename = "monthlyOccurrences", default, skip_serializing_if = "Vec::is_empty")]
    pub monthly_occurrences: Vec<RecurrenceScheduleOccurrence>,
}
impl RecurrenceSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecurrenceScheduleOccurrence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub day: Option<DayOfWeek>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub occurrence: Option<i32>,
}
impl RecurrenceScheduleOccurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegenerateActionParameter {
    #[serde(rename = "keyType", default, skip_serializing_if = "Option::is_none")]
    pub key_type: Option<KeyType>,
}
impl RegenerateActionParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RepetitionIndex {
    #[serde(rename = "scopeName", default, skip_serializing_if = "Option::is_none")]
    pub scope_name: Option<String>,
    #[serde(rename = "itemIndex")]
    pub item_index: i32,
}
impl RepetitionIndex {
    pub fn new(item_index: i32) -> Self {
        Self {
            scope_name: None,
            item_index,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Request {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<Object>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
}
impl Request {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestHistory {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RequestHistoryProperties>,
}
impl RequestHistory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestHistoryListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RequestHistory>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RequestHistoryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestHistoryProperties {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub request: Option<Request>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub response: Option<Response>,
}
impl RequestHistoryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ResourceReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Response {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<Object>,
    #[serde(rename = "statusCode", default, skip_serializing_if = "Option::is_none")]
    pub status_code: Option<i32>,
    #[serde(rename = "bodyLink", default, skip_serializing_if = "Option::is_none")]
    pub body_link: Option<ContentLink>,
}
impl Response {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetryHistory {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "serviceRequestId", default, skip_serializing_if = "Option::is_none")]
    pub service_request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl RetryHistory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunActionCorrelation {
    #[serde(flatten)]
    pub run_correlation: RunCorrelation,
    #[serde(rename = "actionTrackingId", default, skip_serializing_if = "Option::is_none")]
    pub action_tracking_id: Option<String>,
}
impl RunActionCorrelation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunCorrelation {
    #[serde(rename = "clientTrackingId", default, skip_serializing_if = "Option::is_none")]
    pub client_tracking_id: Option<String>,
    #[serde(rename = "clientKeywords", default, skip_serializing_if = "Vec::is_empty")]
    pub client_keywords: Vec<String>,
}
impl RunCorrelation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SchemaType {
    NotSpecified,
    Xml,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SegmentTerminatorSuffix {
    NotSpecified,
    None,
    #[serde(rename = "CR")]
    Cr,
    #[serde(rename = "LF")]
    Lf,
    #[serde(rename = "CRLF")]
    Crlf,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SetTriggerStateActionDefinition {
    pub source: WorkflowTrigger,
}
impl SetTriggerStateActionDefinition {
    pub fn new(source: WorkflowTrigger) -> Self {
        Self { source }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SigningAlgorithm {
    NotSpecified,
    Default,
    #[serde(rename = "SHA1")]
    Sha1,
    #[serde(rename = "SHA2256")]
    Sha2256,
    #[serde(rename = "SHA2384")]
    Sha2384,
    #[serde(rename = "SHA2512")]
    Sha2512,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Sku {
    pub name: SkuName,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<ResourceReference>,
}
impl Sku {
    pub fn new(name: SkuName) -> Self {
        Self { name, plan: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SkuName {
    NotSpecified,
    Free,
    Shared,
    Basic,
    Standard,
    Premium,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TrackEventsOperationOptions {
    None,
    DisableSourceInfoEnrich,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackingEvent {
    #[serde(rename = "eventLevel")]
    pub event_level: EventLevel,
    #[serde(rename = "eventTime")]
    pub event_time: String,
    #[serde(rename = "recordType")]
    pub record_type: TrackingRecordType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<TrackingEventErrorInfo>,
}
impl TrackingEvent {
    pub fn new(event_level: EventLevel, event_time: String, record_type: TrackingRecordType) -> Self {
        Self {
            event_level,
            event_time,
            record_type,
            error: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrackingEventErrorInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
}
impl TrackingEventErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackingEventsDefinition {
    #[serde(rename = "sourceType")]
    pub source_type: String,
    #[serde(rename = "trackEventsOptions", default, skip_serializing_if = "Option::is_none")]
    pub track_events_options: Option<TrackEventsOperationOptions>,
    pub events: Vec<TrackingEvent>,
}
impl TrackingEventsDefinition {
    pub fn new(source_type: String, events: Vec<TrackingEvent>) -> Self {
        Self {
            source_type,
            track_events_options: None,
            events,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TrackingRecordType {
    NotSpecified,
    Custom,
    #[serde(rename = "AS2Message")]
    As2Message,
    #[serde(rename = "AS2MDN")]
    As2mdn,
    X12Interchange,
    X12FunctionalGroup,
    X12TransactionSet,
    X12InterchangeAcknowledgment,
    X12FunctionalGroupAcknowledgment,
    X12TransactionSetAcknowledgment,
    EdifactInterchange,
    EdifactFunctionalGroup,
    EdifactTransactionSet,
    EdifactInterchangeAcknowledgment,
    EdifactFunctionalGroupAcknowledgment,
    EdifactTransactionSetAcknowledgment,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TrailingSeparatorPolicy {
    NotSpecified,
    NotAllowed,
    Optional,
    Mandatory,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum UsageIndicator {
    NotSpecified,
    Test,
    Information,
    Production,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Workflow {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkflowProperties>,
}
impl Workflow {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<WorkflowState>,
}
impl WorkflowFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Workflow>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkflowListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowOutputParameter {
    #[serde(flatten)]
    pub workflow_parameter: WorkflowParameter,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Object>,
}
impl WorkflowOutputParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowParameter {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<ParameterType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<Object>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<Object>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl WorkflowParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<WorkflowProvisioningState>,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<WorkflowState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "accessEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub access_endpoint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(rename = "integrationAccount", default, skip_serializing_if = "Option::is_none")]
    pub integration_account: Option<ResourceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definition: Option<Object>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
}
impl WorkflowProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum WorkflowProvisioningState {
    NotSpecified,
    Accepted,
    Running,
    Ready,
    Creating,
    Created,
    Deleting,
    Deleted,
    Canceled,
    Failed,
    Succeeded,
    Moving,
    Updating,
    Registering,
    Registered,
    Unregistering,
    Unregistered,
    Completed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRun {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkflowRunProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl WorkflowRun {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunAction {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkflowRunActionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl WorkflowRunAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunActionFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<WorkflowStatus>,
}
impl WorkflowRunActionFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunActionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkflowRunAction>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkflowRunActionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunActionProperties {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<WorkflowStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Object>,
    #[serde(rename = "trackingId", default, skip_serializing_if = "Option::is_none")]
    pub tracking_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub correlation: Option<Correlation>,
    #[serde(rename = "inputsLink", default, skip_serializing_if = "Option::is_none")]
    pub inputs_link: Option<ContentLink>,
    #[serde(rename = "outputsLink", default, skip_serializing_if = "Option::is_none")]
    pub outputs_link: Option<ContentLink>,
    #[serde(rename = "trackedProperties", default, skip_serializing_if = "Option::is_none")]
    pub tracked_properties: Option<Object>,
    #[serde(rename = "retryHistory", default, skip_serializing_if = "Vec::is_empty")]
    pub retry_history: Vec<RetryHistory>,
}
impl WorkflowRunActionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkflowRunActionRepetitionDefinition {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: WorkflowRunActionRepetitionProperties,
}
impl WorkflowRunActionRepetitionDefinition {
    pub fn new(properties: WorkflowRunActionRepetitionProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunActionRepetitionDefinitionCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkflowRunActionRepetitionDefinition>,
}
impl WorkflowRunActionRepetitionDefinitionCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunActionRepetitionProperties {
    #[serde(flatten)]
    pub operation_result: OperationResult,
    #[serde(rename = "repetitionIndexes", default, skip_serializing_if = "Vec::is_empty")]
    pub repetition_indexes: Vec<RepetitionIndex>,
}
impl WorkflowRunActionRepetitionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<WorkflowStatus>,
}
impl WorkflowRunFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkflowRun>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkflowRunListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunProperties {
    #[serde(rename = "waitEndTime", default, skip_serializing_if = "Option::is_none")]
    pub wait_end_time: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<WorkflowStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Object>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub correlation: Option<Correlation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub workflow: Option<ResourceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub trigger: Option<WorkflowRunTrigger>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub outputs: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub response: Option<WorkflowRunTrigger>,
}
impl WorkflowRunProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowRunTrigger {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub inputs: Option<Object>,
    #[serde(rename = "inputsLink", default, skip_serializing_if = "Option::is_none")]
    pub inputs_link: Option<ContentLink>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub outputs: Option<Object>,
    #[serde(rename = "outputsLink", default, skip_serializing_if = "Option::is_none")]
    pub outputs_link: Option<ContentLink>,
    #[serde(rename = "scheduledTime", default, skip_serializing_if = "Option::is_none")]
    pub scheduled_time: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "trackingId", default, skip_serializing_if = "Option::is_none")]
    pub tracking_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub correlation: Option<Correlation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<WorkflowStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Object>,
    #[serde(rename = "trackedProperties", default, skip_serializing_if = "Option::is_none")]
    pub tracked_properties: Option<Object>,
}
impl WorkflowRunTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum WorkflowState {
    NotSpecified,
    Completed,
    Enabled,
    Disabled,
    Deleted,
    Suspended,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum WorkflowStatus {
    NotSpecified,
    Paused,
    Running,
    Waiting,
    Succeeded,
    Skipped,
    Suspended,
    Cancelled,
    Failed,
    Faulted,
    TimedOut,
    Aborted,
    Ignored,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTrigger {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkflowTriggerProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl WorkflowTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerCallbackUrl {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[serde(rename = "basePath", default, skip_serializing_if = "Option::is_none")]
    pub base_path: Option<String>,
    #[serde(rename = "relativePath", default, skip_serializing_if = "Option::is_none")]
    pub relative_path: Option<String>,
    #[serde(rename = "relativePathParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub relative_path_parameters: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub queries: Option<WorkflowTriggerListCallbackUrlQueries>,
}
impl WorkflowTriggerCallbackUrl {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<WorkflowState>,
}
impl WorkflowTriggerFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerHistory {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkflowTriggerHistoryProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl WorkflowTriggerHistory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerHistoryFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<WorkflowStatus>,
}
impl WorkflowTriggerHistoryFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerHistoryListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkflowTriggerHistory>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkflowTriggerHistoryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerHistoryProperties {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<WorkflowStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Object>,
    #[serde(rename = "trackingId", default, skip_serializing_if = "Option::is_none")]
    pub tracking_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub correlation: Option<Correlation>,
    #[serde(rename = "inputsLink", default, skip_serializing_if = "Option::is_none")]
    pub inputs_link: Option<ContentLink>,
    #[serde(rename = "outputsLink", default, skip_serializing_if = "Option::is_none")]
    pub outputs_link: Option<ContentLink>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fired: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub run: Option<ResourceReference>,
}
impl WorkflowTriggerHistoryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerListCallbackUrlQueries {
    #[serde(rename = "api-version", default, skip_serializing_if = "Option::is_none")]
    pub api_version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sv: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sig: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub se: Option<String>,
}
impl WorkflowTriggerListCallbackUrlQueries {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkflowTrigger>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkflowTriggerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<WorkflowTriggerProvisioningState>,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<WorkflowState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<WorkflowStatus>,
    #[serde(rename = "lastExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub last_execution_time: Option<String>,
    #[serde(rename = "nextExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub next_execution_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recurrence: Option<WorkflowTriggerRecurrence>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub workflow: Option<ResourceReference>,
}
impl WorkflowTriggerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum WorkflowTriggerProvisioningState {
    NotSpecified,
    Accepted,
    Running,
    Ready,
    Creating,
    Created,
    Deleting,
    Deleted,
    Canceled,
    Failed,
    Succeeded,
    Moving,
    Updating,
    Registering,
    Registered,
    Unregistering,
    Unregistered,
    Completed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowTriggerRecurrence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<RecurrenceFrequency>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<RecurrenceSchedule>,
}
impl WorkflowTriggerRecurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowVersion {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkflowVersionProperties>,
}
impl WorkflowVersion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowVersionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkflowVersion>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkflowVersionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkflowVersionProperties {
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
    pub changed_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<WorkflowState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "accessEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub access_endpoint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(rename = "integrationAccount", default, skip_serializing_if = "Option::is_none")]
    pub integration_account: Option<ResourceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definition: Option<Object>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
}
impl WorkflowVersionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12AcknowledgementSettings {
    #[serde(rename = "needTechnicalAcknowledgement")]
    pub need_technical_acknowledgement: bool,
    #[serde(rename = "batchTechnicalAcknowledgements")]
    pub batch_technical_acknowledgements: bool,
    #[serde(rename = "needFunctionalAcknowledgement")]
    pub need_functional_acknowledgement: bool,
    #[serde(rename = "functionalAcknowledgementVersion", default, skip_serializing_if = "Option::is_none")]
    pub functional_acknowledgement_version: Option<String>,
    #[serde(rename = "batchFunctionalAcknowledgements")]
    pub batch_functional_acknowledgements: bool,
    #[serde(rename = "needImplementationAcknowledgement")]
    pub need_implementation_acknowledgement: bool,
    #[serde(rename = "implementationAcknowledgementVersion", default, skip_serializing_if = "Option::is_none")]
    pub implementation_acknowledgement_version: Option<String>,
    #[serde(rename = "batchImplementationAcknowledgements")]
    pub batch_implementation_acknowledgements: bool,
    #[serde(rename = "needLoopForValidMessages")]
    pub need_loop_for_valid_messages: bool,
    #[serde(rename = "sendSynchronousAcknowledgement")]
    pub send_synchronous_acknowledgement: bool,
    #[serde(rename = "acknowledgementControlNumberPrefix", default, skip_serializing_if = "Option::is_none")]
    pub acknowledgement_control_number_prefix: Option<String>,
    #[serde(rename = "acknowledgementControlNumberSuffix", default, skip_serializing_if = "Option::is_none")]
    pub acknowledgement_control_number_suffix: Option<String>,
    #[serde(rename = "acknowledgementControlNumberLowerBound")]
    pub acknowledgement_control_number_lower_bound: i32,
    #[serde(rename = "acknowledgementControlNumberUpperBound")]
    pub acknowledgement_control_number_upper_bound: i32,
    #[serde(rename = "rolloverAcknowledgementControlNumber")]
    pub rollover_acknowledgement_control_number: bool,
}
impl X12AcknowledgementSettings {
    pub fn new(
        need_technical_acknowledgement: bool,
        batch_technical_acknowledgements: bool,
        need_functional_acknowledgement: bool,
        batch_functional_acknowledgements: bool,
        need_implementation_acknowledgement: bool,
        batch_implementation_acknowledgements: bool,
        need_loop_for_valid_messages: bool,
        send_synchronous_acknowledgement: bool,
        acknowledgement_control_number_lower_bound: i32,
        acknowledgement_control_number_upper_bound: i32,
        rollover_acknowledgement_control_number: bool,
    ) -> Self {
        Self {
            need_technical_acknowledgement,
            batch_technical_acknowledgements,
            need_functional_acknowledgement,
            functional_acknowledgement_version: None,
            batch_functional_acknowledgements,
            need_implementation_acknowledgement,
            implementation_acknowledgement_version: None,
            batch_implementation_acknowledgements,
            need_loop_for_valid_messages,
            send_synchronous_acknowledgement,
            acknowledgement_control_number_prefix: None,
            acknowledgement_control_number_suffix: None,
            acknowledgement_control_number_lower_bound,
            acknowledgement_control_number_upper_bound,
            rollover_acknowledgement_control_number,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12AgreementContent {
    #[serde(rename = "receiveAgreement")]
    pub receive_agreement: X12OneWayAgreement,
    #[serde(rename = "sendAgreement")]
    pub send_agreement: X12OneWayAgreement,
}
impl X12AgreementContent {
    pub fn new(receive_agreement: X12OneWayAgreement, send_agreement: X12OneWayAgreement) -> Self {
        Self {
            receive_agreement,
            send_agreement,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum X12CharacterSet {
    NotSpecified,
    Basic,
    Extended,
    #[serde(rename = "UTF8")]
    Utf8,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum X12DateFormat {
    NotSpecified,
    #[serde(rename = "CCYYMMDD")]
    Ccyymmdd,
    #[serde(rename = "YYMMDD")]
    Yymmdd,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12DelimiterOverrides {
    #[serde(rename = "protocolVersion", default, skip_serializing_if = "Option::is_none")]
    pub protocol_version: Option<String>,
    #[serde(rename = "messageId", default, skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    #[serde(rename = "dataElementSeparator")]
    pub data_element_separator: i32,
    #[serde(rename = "componentSeparator")]
    pub component_separator: i32,
    #[serde(rename = "segmentTerminator")]
    pub segment_terminator: i32,
    #[serde(rename = "segmentTerminatorSuffix")]
    pub segment_terminator_suffix: SegmentTerminatorSuffix,
    #[serde(rename = "replaceCharacter")]
    pub replace_character: i32,
    #[serde(rename = "replaceSeparatorsInPayload")]
    pub replace_separators_in_payload: bool,
    #[serde(rename = "targetNamespace", default, skip_serializing_if = "Option::is_none")]
    pub target_namespace: Option<String>,
}
impl X12DelimiterOverrides {
    pub fn new(
        data_element_separator: i32,
        component_separator: i32,
        segment_terminator: i32,
        segment_terminator_suffix: SegmentTerminatorSuffix,
        replace_character: i32,
        replace_separators_in_payload: bool,
    ) -> Self {
        Self {
            protocol_version: None,
            message_id: None,
            data_element_separator,
            component_separator,
            segment_terminator,
            segment_terminator_suffix,
            replace_character,
            replace_separators_in_payload,
            target_namespace: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12EnvelopeOverride {
    #[serde(rename = "targetNamespace")]
    pub target_namespace: String,
    #[serde(rename = "protocolVersion")]
    pub protocol_version: String,
    #[serde(rename = "messageId")]
    pub message_id: String,
    #[serde(rename = "responsibleAgencyCode")]
    pub responsible_agency_code: String,
    #[serde(rename = "headerVersion")]
    pub header_version: String,
    #[serde(rename = "senderApplicationId")]
    pub sender_application_id: String,
    #[serde(rename = "receiverApplicationId")]
    pub receiver_application_id: String,
    #[serde(rename = "functionalIdentifierCode", default, skip_serializing_if = "Option::is_none")]
    pub functional_identifier_code: Option<String>,
    #[serde(rename = "dateFormat")]
    pub date_format: X12DateFormat,
    #[serde(rename = "timeFormat")]
    pub time_format: X12TimeFormat,
}
impl X12EnvelopeOverride {
    pub fn new(
        target_namespace: String,
        protocol_version: String,
        message_id: String,
        responsible_agency_code: String,
        header_version: String,
        sender_application_id: String,
        receiver_application_id: String,
        date_format: X12DateFormat,
        time_format: X12TimeFormat,
    ) -> Self {
        Self {
            target_namespace,
            protocol_version,
            message_id,
            responsible_agency_code,
            header_version,
            sender_application_id,
            receiver_application_id,
            functional_identifier_code: None,
            date_format,
            time_format,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12EnvelopeSettings {
    #[serde(rename = "controlStandardsId")]
    pub control_standards_id: i32,
    #[serde(rename = "useControlStandardsIdAsRepetitionCharacter")]
    pub use_control_standards_id_as_repetition_character: bool,
    #[serde(rename = "senderApplicationId")]
    pub sender_application_id: String,
    #[serde(rename = "receiverApplicationId")]
    pub receiver_application_id: String,
    #[serde(rename = "controlVersionNumber")]
    pub control_version_number: String,
    #[serde(rename = "interchangeControlNumberLowerBound")]
    pub interchange_control_number_lower_bound: i32,
    #[serde(rename = "interchangeControlNumberUpperBound")]
    pub interchange_control_number_upper_bound: i32,
    #[serde(rename = "rolloverInterchangeControlNumber")]
    pub rollover_interchange_control_number: bool,
    #[serde(rename = "enableDefaultGroupHeaders")]
    pub enable_default_group_headers: bool,
    #[serde(rename = "functionalGroupId", default, skip_serializing_if = "Option::is_none")]
    pub functional_group_id: Option<String>,
    #[serde(rename = "groupControlNumberLowerBound")]
    pub group_control_number_lower_bound: i32,
    #[serde(rename = "groupControlNumberUpperBound")]
    pub group_control_number_upper_bound: i32,
    #[serde(rename = "rolloverGroupControlNumber")]
    pub rollover_group_control_number: bool,
    #[serde(rename = "groupHeaderAgencyCode")]
    pub group_header_agency_code: String,
    #[serde(rename = "groupHeaderVersion")]
    pub group_header_version: String,
    #[serde(rename = "transactionSetControlNumberLowerBound")]
    pub transaction_set_control_number_lower_bound: i32,
    #[serde(rename = "transactionSetControlNumberUpperBound")]
    pub transaction_set_control_number_upper_bound: i32,
    #[serde(rename = "rolloverTransactionSetControlNumber")]
    pub rollover_transaction_set_control_number: bool,
    #[serde(rename = "transactionSetControlNumberPrefix", default, skip_serializing_if = "Option::is_none")]
    pub transaction_set_control_number_prefix: Option<String>,
    #[serde(rename = "transactionSetControlNumberSuffix", default, skip_serializing_if = "Option::is_none")]
    pub transaction_set_control_number_suffix: Option<String>,
    #[serde(rename = "overwriteExistingTransactionSetControlNumber")]
    pub overwrite_existing_transaction_set_control_number: bool,
    #[serde(rename = "groupHeaderDateFormat")]
    pub group_header_date_format: X12DateFormat,
    #[serde(rename = "groupHeaderTimeFormat")]
    pub group_header_time_format: X12TimeFormat,
    #[serde(rename = "usageIndicator")]
    pub usage_indicator: UsageIndicator,
}
impl X12EnvelopeSettings {
    pub fn new(
        control_standards_id: i32,
        use_control_standards_id_as_repetition_character: bool,
        sender_application_id: String,
        receiver_application_id: String,
        control_version_number: String,
        interchange_control_number_lower_bound: i32,
        interchange_control_number_upper_bound: i32,
        rollover_interchange_control_number: bool,
        enable_default_group_headers: bool,
        group_control_number_lower_bound: i32,
        group_control_number_upper_bound: i32,
        rollover_group_control_number: bool,
        group_header_agency_code: String,
        group_header_version: String,
        transaction_set_control_number_lower_bound: i32,
        transaction_set_control_number_upper_bound: i32,
        rollover_transaction_set_control_number: bool,
        overwrite_existing_transaction_set_control_number: bool,
        group_header_date_format: X12DateFormat,
        group_header_time_format: X12TimeFormat,
        usage_indicator: UsageIndicator,
    ) -> Self {
        Self {
            control_standards_id,
            use_control_standards_id_as_repetition_character,
            sender_application_id,
            receiver_application_id,
            control_version_number,
            interchange_control_number_lower_bound,
            interchange_control_number_upper_bound,
            rollover_interchange_control_number,
            enable_default_group_headers,
            functional_group_id: None,
            group_control_number_lower_bound,
            group_control_number_upper_bound,
            rollover_group_control_number,
            group_header_agency_code,
            group_header_version,
            transaction_set_control_number_lower_bound,
            transaction_set_control_number_upper_bound,
            rollover_transaction_set_control_number,
            transaction_set_control_number_prefix: None,
            transaction_set_control_number_suffix: None,
            overwrite_existing_transaction_set_control_number,
            group_header_date_format,
            group_header_time_format,
            usage_indicator,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12FramingSettings {
    #[serde(rename = "dataElementSeparator")]
    pub data_element_separator: i32,
    #[serde(rename = "componentSeparator")]
    pub component_separator: i32,
    #[serde(rename = "replaceSeparatorsInPayload")]
    pub replace_separators_in_payload: bool,
    #[serde(rename = "replaceCharacter")]
    pub replace_character: i32,
    #[serde(rename = "segmentTerminator")]
    pub segment_terminator: i32,
    #[serde(rename = "characterSet")]
    pub character_set: X12CharacterSet,
    #[serde(rename = "segmentTerminatorSuffix")]
    pub segment_terminator_suffix: SegmentTerminatorSuffix,
}
impl X12FramingSettings {
    pub fn new(
        data_element_separator: i32,
        component_separator: i32,
        replace_separators_in_payload: bool,
        replace_character: i32,
        segment_terminator: i32,
        character_set: X12CharacterSet,
        segment_terminator_suffix: SegmentTerminatorSuffix,
    ) -> Self {
        Self {
            data_element_separator,
            component_separator,
            replace_separators_in_payload,
            replace_character,
            segment_terminator,
            character_set,
            segment_terminator_suffix,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12MessageFilter {
    #[serde(rename = "messageFilterType")]
    pub message_filter_type: MessageFilterType,
}
impl X12MessageFilter {
    pub fn new(message_filter_type: MessageFilterType) -> Self {
        Self { message_filter_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12MessageIdentifier {
    #[serde(rename = "messageId")]
    pub message_id: String,
}
impl X12MessageIdentifier {
    pub fn new(message_id: String) -> Self {
        Self { message_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12OneWayAgreement {
    #[serde(rename = "senderBusinessIdentity")]
    pub sender_business_identity: BusinessIdentity,
    #[serde(rename = "receiverBusinessIdentity")]
    pub receiver_business_identity: BusinessIdentity,
    #[serde(rename = "protocolSettings")]
    pub protocol_settings: X12ProtocolSettings,
}
impl X12OneWayAgreement {
    pub fn new(
        sender_business_identity: BusinessIdentity,
        receiver_business_identity: BusinessIdentity,
        protocol_settings: X12ProtocolSettings,
    ) -> Self {
        Self {
            sender_business_identity,
            receiver_business_identity,
            protocol_settings,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12ProcessingSettings {
    #[serde(rename = "maskSecurityInfo")]
    pub mask_security_info: bool,
    #[serde(rename = "convertImpliedDecimal")]
    pub convert_implied_decimal: bool,
    #[serde(rename = "preserveInterchange")]
    pub preserve_interchange: bool,
    #[serde(rename = "suspendInterchangeOnError")]
    pub suspend_interchange_on_error: bool,
    #[serde(rename = "createEmptyXmlTagsForTrailingSeparators")]
    pub create_empty_xml_tags_for_trailing_separators: bool,
    #[serde(rename = "useDotAsDecimalSeparator")]
    pub use_dot_as_decimal_separator: bool,
}
impl X12ProcessingSettings {
    pub fn new(
        mask_security_info: bool,
        convert_implied_decimal: bool,
        preserve_interchange: bool,
        suspend_interchange_on_error: bool,
        create_empty_xml_tags_for_trailing_separators: bool,
        use_dot_as_decimal_separator: bool,
    ) -> Self {
        Self {
            mask_security_info,
            convert_implied_decimal,
            preserve_interchange,
            suspend_interchange_on_error,
            create_empty_xml_tags_for_trailing_separators,
            use_dot_as_decimal_separator,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12ProtocolSettings {
    #[serde(rename = "validationSettings")]
    pub validation_settings: X12ValidationSettings,
    #[serde(rename = "framingSettings")]
    pub framing_settings: X12FramingSettings,
    #[serde(rename = "envelopeSettings")]
    pub envelope_settings: X12EnvelopeSettings,
    #[serde(rename = "acknowledgementSettings")]
    pub acknowledgement_settings: X12AcknowledgementSettings,
    #[serde(rename = "messageFilter")]
    pub message_filter: X12MessageFilter,
    #[serde(rename = "securitySettings")]
    pub security_settings: X12SecuritySettings,
    #[serde(rename = "processingSettings")]
    pub processing_settings: X12ProcessingSettings,
    #[serde(rename = "envelopeOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub envelope_overrides: Vec<X12EnvelopeOverride>,
    #[serde(rename = "validationOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_overrides: Vec<X12ValidationOverride>,
    #[serde(rename = "messageFilterList", default, skip_serializing_if = "Vec::is_empty")]
    pub message_filter_list: Vec<X12MessageIdentifier>,
    #[serde(rename = "schemaReferences")]
    pub schema_references: Vec<X12SchemaReference>,
    #[serde(rename = "x12DelimiterOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub x12_delimiter_overrides: Vec<X12DelimiterOverrides>,
}
impl X12ProtocolSettings {
    pub fn new(
        validation_settings: X12ValidationSettings,
        framing_settings: X12FramingSettings,
        envelope_settings: X12EnvelopeSettings,
        acknowledgement_settings: X12AcknowledgementSettings,
        message_filter: X12MessageFilter,
        security_settings: X12SecuritySettings,
        processing_settings: X12ProcessingSettings,
        schema_references: Vec<X12SchemaReference>,
    ) -> Self {
        Self {
            validation_settings,
            framing_settings,
            envelope_settings,
            acknowledgement_settings,
            message_filter,
            security_settings,
            processing_settings,
            envelope_overrides: Vec::new(),
            validation_overrides: Vec::new(),
            message_filter_list: Vec::new(),
            schema_references,
            x12_delimiter_overrides: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12SchemaReference {
    #[serde(rename = "messageId")]
    pub message_id: String,
    #[serde(rename = "senderApplicationId", default, skip_serializing_if = "Option::is_none")]
    pub sender_application_id: Option<String>,
    #[serde(rename = "schemaVersion")]
    pub schema_version: String,
    #[serde(rename = "schemaName")]
    pub schema_name: String,
}
impl X12SchemaReference {
    pub fn new(message_id: String, schema_version: String, schema_name: String) -> Self {
        Self {
            message_id,
            sender_application_id: None,
            schema_version,
            schema_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12SecuritySettings {
    #[serde(rename = "authorizationQualifier")]
    pub authorization_qualifier: String,
    #[serde(rename = "authorizationValue", default, skip_serializing_if = "Option::is_none")]
    pub authorization_value: Option<String>,
    #[serde(rename = "securityQualifier")]
    pub security_qualifier: String,
    #[serde(rename = "passwordValue", default, skip_serializing_if = "Option::is_none")]
    pub password_value: Option<String>,
}
impl X12SecuritySettings {
    pub fn new(authorization_qualifier: String, security_qualifier: String) -> Self {
        Self {
            authorization_qualifier,
            authorization_value: None,
            security_qualifier,
            password_value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum X12TimeFormat {
    NotSpecified,
    #[serde(rename = "HHMM")]
    Hhmm,
    #[serde(rename = "HHMMSS")]
    Hhmmss,
    #[serde(rename = "HHMMSSdd")]
    HhmmsSdd,
    #[serde(rename = "HHMMSSd")]
    HhmmsSd,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12ValidationOverride {
    #[serde(rename = "messageId")]
    pub message_id: String,
    #[serde(rename = "validateEDITypes")]
    pub validate_edi_types: bool,
    #[serde(rename = "validateXSDTypes")]
    pub validate_xsd_types: bool,
    #[serde(rename = "allowLeadingAndTrailingSpacesAndZeroes")]
    pub allow_leading_and_trailing_spaces_and_zeroes: bool,
    #[serde(rename = "validateCharacterSet")]
    pub validate_character_set: bool,
    #[serde(rename = "trimLeadingAndTrailingSpacesAndZeroes")]
    pub trim_leading_and_trailing_spaces_and_zeroes: bool,
    #[serde(rename = "trailingSeparatorPolicy")]
    pub trailing_separator_policy: TrailingSeparatorPolicy,
}
impl X12ValidationOverride {
    pub fn new(
        message_id: String,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        validate_character_set: bool,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: TrailingSeparatorPolicy,
    ) -> Self {
        Self {
            message_id,
            validate_edi_types,
            validate_xsd_types,
            allow_leading_and_trailing_spaces_and_zeroes,
            validate_character_set,
            trim_leading_and_trailing_spaces_and_zeroes,
            trailing_separator_policy,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X12ValidationSettings {
    #[serde(rename = "validateCharacterSet")]
    pub validate_character_set: bool,
    #[serde(rename = "checkDuplicateInterchangeControlNumber")]
    pub check_duplicate_interchange_control_number: bool,
    #[serde(rename = "interchangeControlNumberValidityDays")]
    pub interchange_control_number_validity_days: i32,
    #[serde(rename = "checkDuplicateGroupControlNumber")]
    pub check_duplicate_group_control_number: bool,
    #[serde(rename = "checkDuplicateTransactionSetControlNumber")]
    pub check_duplicate_transaction_set_control_number: bool,
    #[serde(rename = "validateEDITypes")]
    pub validate_edi_types: bool,
    #[serde(rename = "validateXSDTypes")]
    pub validate_xsd_types: bool,
    #[serde(rename = "allowLeadingAndTrailingSpacesAndZeroes")]
    pub allow_leading_and_trailing_spaces_and_zeroes: bool,
    #[serde(rename = "trimLeadingAndTrailingSpacesAndZeroes")]
    pub trim_leading_and_trailing_spaces_and_zeroes: bool,
    #[serde(rename = "trailingSeparatorPolicy")]
    pub trailing_separator_policy: TrailingSeparatorPolicy,
}
impl X12ValidationSettings {
    pub fn new(
        validate_character_set: bool,
        check_duplicate_interchange_control_number: bool,
        interchange_control_number_validity_days: i32,
        check_duplicate_group_control_number: bool,
        check_duplicate_transaction_set_control_number: bool,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: TrailingSeparatorPolicy,
    ) -> Self {
        Self {
            validate_character_set,
            check_duplicate_interchange_control_number,
            interchange_control_number_validity_days,
            check_duplicate_group_control_number,
            check_duplicate_transaction_set_control_number,
            validate_edi_types,
            validate_xsd_types,
            allow_leading_and_trailing_spaces_and_zeroes,
            trim_leading_and_trailing_spaces_and_zeroes,
            trailing_separator_policy,
        }
    }
}
