#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AddUsersPayload {
    #[serde(rename = "emailAddresses")]
    pub email_addresses: Vec<String>,
}
impl AddUsersPayload {
    pub fn new(email_addresses: Vec<String>) -> Self {
        Self { email_addresses }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateLabProperties {
    #[serde(rename = "environmentSettingCreationParameters", default, skip_serializing_if = "Option::is_none")]
    pub environment_setting_creation_parameters: Option<EnvironmentSettingCreationParameters>,
    #[serde(rename = "labCreationParameters")]
    pub lab_creation_parameters: LabCreationParameters,
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl CreateLabProperties {
    pub fn new(lab_creation_parameters: LabCreationParameters, name: String) -> Self {
        Self {
            environment_setting_creation_parameters: None,
            lab_creation_parameters,
            name,
            location: None,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Environment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EnvironmentProperties>,
}
impl Environment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "virtualMachineDetails", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_details: Option<VirtualMachineDetails>,
    #[serde(rename = "latestOperationResult", default, skip_serializing_if = "Option::is_none")]
    pub latest_operation_result: Option<LatestOperationResult>,
    #[serde(rename = "environmentState", default, skip_serializing_if = "Option::is_none")]
    pub environment_state: Option<String>,
    #[serde(rename = "totalUsage", default, skip_serializing_if = "Option::is_none")]
    pub total_usage: Option<String>,
    #[serde(rename = "passwordLastReset", default, skip_serializing_if = "Option::is_none")]
    pub password_last_reset: Option<String>,
}
impl EnvironmentDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentFragment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EnvironmentPropertiesFragment>,
}
impl EnvironmentFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentOperationsPayload {
    #[serde(rename = "environmentId")]
    pub environment_id: String,
}
impl EnvironmentOperationsPayload {
    pub fn new(environment_id: String) -> Self {
        Self { environment_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentProperties {
    #[serde(rename = "resourceSets", default, skip_serializing_if = "Option::is_none")]
    pub resource_sets: Option<ResourceSet>,
    #[serde(rename = "claimedByUserObjectId", default, skip_serializing_if = "Option::is_none")]
    pub claimed_by_user_object_id: Option<String>,
    #[serde(rename = "claimedByUserPrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub claimed_by_user_principal_id: Option<String>,
    #[serde(rename = "claimedByUserName", default, skip_serializing_if = "Option::is_none")]
    pub claimed_by_user_name: Option<String>,
    #[serde(rename = "isClaimed", default, skip_serializing_if = "Option::is_none")]
    pub is_claimed: Option<bool>,
    #[serde(rename = "lastKnownPowerState", default, skip_serializing_if = "Option::is_none")]
    pub last_known_power_state: Option<String>,
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<NetworkInterface>,
    #[serde(rename = "totalUsage", default, skip_serializing_if = "Option::is_none")]
    pub total_usage: Option<String>,
    #[serde(rename = "passwordLastReset", default, skip_serializing_if = "Option::is_none")]
    pub password_last_reset: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
    #[serde(rename = "latestOperationResult", default, skip_serializing_if = "Option::is_none")]
    pub latest_operation_result: Option<LatestOperationResult>,
}
impl EnvironmentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentPropertiesFragment {
    #[serde(rename = "resourceSets", default, skip_serializing_if = "Option::is_none")]
    pub resource_sets: Option<ResourceSetFragment>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl EnvironmentPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentSetting {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EnvironmentSettingProperties>,
}
impl EnvironmentSetting {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentSettingCreationParameters {
    #[serde(rename = "resourceSettingCreationParameters")]
    pub resource_setting_creation_parameters: ResourceSettingCreationParameters,
}
impl EnvironmentSettingCreationParameters {
    pub fn new(resource_setting_creation_parameters: ResourceSettingCreationParameters) -> Self {
        Self {
            resource_setting_creation_parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentSettingFragment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EnvironmentSettingPropertiesFragment>,
}
impl EnvironmentSettingFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentSettingProperties {
    #[serde(rename = "publishingState", default, skip_serializing_if = "Option::is_none")]
    pub publishing_state: Option<environment_setting_properties::PublishingState>,
    #[serde(rename = "configurationState", default, skip_serializing_if = "Option::is_none")]
    pub configuration_state: Option<environment_setting_properties::ConfigurationState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(rename = "resourceSettings")]
    pub resource_settings: ResourceSettings,
    #[serde(rename = "lastChanged", default, skip_serializing_if = "Option::is_none")]
    pub last_changed: Option<String>,
    #[serde(rename = "lastPublished", default, skip_serializing_if = "Option::is_none")]
    pub last_published: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
    #[serde(rename = "latestOperationResult", default, skip_serializing_if = "Option::is_none")]
    pub latest_operation_result: Option<LatestOperationResult>,
}
impl EnvironmentSettingProperties {
    pub fn new(resource_settings: ResourceSettings) -> Self {
        Self {
            publishing_state: None,
            configuration_state: None,
            description: None,
            title: None,
            resource_settings,
            last_changed: None,
            last_published: None,
            provisioning_state: None,
            unique_identifier: None,
            latest_operation_result: None,
        }
    }
}
pub mod environment_setting_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublishingState {
        Draft,
        Publishing,
        Published,
        PublishFailed,
        Scaling,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConfigurationState {
        NotApplicable,
        Completed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentSettingPropertiesFragment {
    #[serde(rename = "configurationState", default, skip_serializing_if = "Option::is_none")]
    pub configuration_state: Option<environment_setting_properties_fragment::ConfigurationState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(rename = "resourceSettings", default, skip_serializing_if = "Option::is_none")]
    pub resource_settings: Option<ResourceSettingsFragment>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl EnvironmentSettingPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod environment_setting_properties_fragment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConfigurationState {
        NotApplicable,
        Completed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentSize {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<environment_size::Name>,
    #[serde(rename = "vmSizes", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_sizes: Vec<SizeInfo>,
    #[serde(rename = "maxPrice", default, skip_serializing_if = "Option::is_none")]
    pub max_price: Option<f64>,
    #[serde(rename = "minNumberOfCores", default, skip_serializing_if = "Option::is_none")]
    pub min_number_of_cores: Option<i32>,
    #[serde(rename = "minMemory", default, skip_serializing_if = "Option::is_none")]
    pub min_memory: Option<f64>,
}
impl EnvironmentSize {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod environment_size {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
        Performance,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentSizeFragment {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<environment_size_fragment::Name>,
    #[serde(rename = "vmSizes", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_sizes: Vec<SizeInfoFragment>,
}
impl EnvironmentSizeFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod environment_size_fragment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
        Performance,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImage {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryImageProperties>,
}
impl GalleryImage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageFragment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryImagePropertiesFragment>,
}
impl GalleryImageFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<GalleryImageReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub icon: Option<String>,
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
    #[serde(rename = "isOverride", default, skip_serializing_if = "Option::is_none")]
    pub is_override: Option<bool>,
    #[serde(rename = "planId", default, skip_serializing_if = "Option::is_none")]
    pub plan_id: Option<String>,
    #[serde(rename = "isPlanAuthorized", default, skip_serializing_if = "Option::is_none")]
    pub is_plan_authorized: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
    #[serde(rename = "latestOperationResult", default, skip_serializing_if = "Option::is_none")]
    pub latest_operation_result: Option<LatestOperationResult>,
}
impl GalleryImageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImagePropertiesFragment {
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
    #[serde(rename = "isOverride", default, skip_serializing_if = "Option::is_none")]
    pub is_override: Option<bool>,
    #[serde(rename = "isPlanAuthorized", default, skip_serializing_if = "Option::is_none")]
    pub is_plan_authorized: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl GalleryImagePropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl GalleryImageReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageReferenceFragment {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl GalleryImageReferenceFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetEnvironmentResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub environment: Option<EnvironmentDetails>,
}
impl GetEnvironmentResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetPersonalPreferencesResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "favoriteLabResourceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub favorite_lab_resource_ids: Vec<String>,
}
impl GetPersonalPreferencesResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetRegionalAvailabilityResponse {
    #[serde(rename = "regionalAvailability", default, skip_serializing_if = "Vec::is_empty")]
    pub regional_availability: Vec<RegionalAvailability>,
}
impl GetRegionalAvailabilityResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Lab {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LabProperties>,
}
impl Lab {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabAccount {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LabAccountProperties>,
}
impl LabAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabAccountFragment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LabAccountPropertiesFragment>,
}
impl LabAccountFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabAccountProperties {
    #[serde(rename = "sizeConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub size_configuration: Option<SizeConfigurationProperties>,
    #[serde(rename = "enabledRegionSelection", default, skip_serializing_if = "Option::is_none")]
    pub enabled_region_selection: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
    #[serde(rename = "latestOperationResult", default, skip_serializing_if = "Option::is_none")]
    pub latest_operation_result: Option<LatestOperationResult>,
}
impl LabAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabAccountPropertiesFragment {
    #[serde(rename = "enabledRegionSelection", default, skip_serializing_if = "Option::is_none")]
    pub enabled_region_selection: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl LabAccountPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabCreationParameters {
    #[serde(rename = "maxUsersInLab", default, skip_serializing_if = "Option::is_none")]
    pub max_users_in_lab: Option<i32>,
}
impl LabCreationParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "usageQuota", default, skip_serializing_if = "Option::is_none")]
    pub usage_quota: Option<String>,
}
impl LabDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabFragment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LabPropertiesFragment>,
}
impl LabFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabProperties {
    #[serde(rename = "maxUsersInLab", default, skip_serializing_if = "Option::is_none")]
    pub max_users_in_lab: Option<i32>,
    #[serde(rename = "userQuota", default, skip_serializing_if = "Option::is_none")]
    pub user_quota: Option<i32>,
    #[serde(rename = "invitationCode", default, skip_serializing_if = "Option::is_none")]
    pub invitation_code: Option<String>,
    #[serde(rename = "createdByObjectId", default, skip_serializing_if = "Option::is_none")]
    pub created_by_object_id: Option<String>,
    #[serde(rename = "usageQuota", default, skip_serializing_if = "Option::is_none")]
    pub usage_quota: Option<String>,
    #[serde(rename = "userAccessMode", default, skip_serializing_if = "Option::is_none")]
    pub user_access_mode: Option<lab_properties::UserAccessMode>,
    #[serde(rename = "createdByUserPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub created_by_user_principal_name: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
    #[serde(rename = "latestOperationResult", default, skip_serializing_if = "Option::is_none")]
    pub latest_operation_result: Option<LatestOperationResult>,
}
impl LabProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod lab_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UserAccessMode {
        Restricted,
        Open,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabPropertiesFragment {
    #[serde(rename = "maxUsersInLab", default, skip_serializing_if = "Option::is_none")]
    pub max_users_in_lab: Option<i32>,
    #[serde(rename = "usageQuota", default, skip_serializing_if = "Option::is_none")]
    pub usage_quota: Option<String>,
    #[serde(rename = "userAccessMode", default, skip_serializing_if = "Option::is_none")]
    pub user_access_mode: Option<lab_properties_fragment::UserAccessMode>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl LabPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod lab_properties_fragment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UserAccessMode {
        Restricted,
        Open,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LatestOperationResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "requestUri", default, skip_serializing_if = "Option::is_none")]
    pub request_uri: Option<String>,
    #[serde(rename = "httpMethod", default, skip_serializing_if = "Option::is_none")]
    pub http_method: Option<String>,
    #[serde(rename = "operationUrl", default, skip_serializing_if = "Option::is_none")]
    pub operation_url: Option<String>,
}
impl LatestOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LatestOperationResultFragment {}
impl LatestOperationResultFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListEnvironmentsPayload {
    #[serde(rename = "labId", default, skip_serializing_if = "Option::is_none")]
    pub lab_id: Option<String>,
}
impl ListEnvironmentsPayload {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListEnvironmentsResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub environments: Vec<EnvironmentDetails>,
}
impl ListEnvironmentsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListLabsResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labs: Vec<LabDetails>,
}
impl ListLabsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterface {
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "sshAuthority", default, skip_serializing_if = "Option::is_none")]
    pub ssh_authority: Option<String>,
    #[serde(rename = "rdpAuthority", default, skip_serializing_if = "Option::is_none")]
    pub rdp_authority: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
}
impl NetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceFragment {}
impl NetworkInterfaceFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationBatchStatusPayload {
    pub urls: Vec<String>,
}
impl OperationBatchStatusPayload {
    pub fn new(urls: Vec<String>) -> Self {
        Self { urls }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationBatchStatusResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub items: Vec<OperationBatchStatusResponseItem>,
}
impl OperationBatchStatusResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationBatchStatusResponseItem {
    #[serde(rename = "operationUrl", default, skip_serializing_if = "Option::is_none")]
    pub operation_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl OperationBatchStatusResponseItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl OperationError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetadata {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationMetadataDisplay>,
}
impl OperationMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetadataDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationMetadataDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<OperationError>,
}
impl OperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusPayload {
    #[serde(rename = "operationUrl")]
    pub operation_url: String,
}
impl OperationStatusPayload {
    pub fn new(operation_url: String) -> Self {
        Self { operation_url }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatusResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl OperationStatusResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PersonalPreferencesOperationsPayload {
    #[serde(rename = "labAccountResourceId", default, skip_serializing_if = "Option::is_none")]
    pub lab_account_resource_id: Option<String>,
    #[serde(rename = "addRemove", default, skip_serializing_if = "Option::is_none")]
    pub add_remove: Option<personal_preferences_operations_payload::AddRemove>,
    #[serde(rename = "labResourceId", default, skip_serializing_if = "Option::is_none")]
    pub lab_resource_id: Option<String>,
}
impl PersonalPreferencesOperationsPayload {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod personal_preferences_operations_payload {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AddRemove {
        Add,
        Remove,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderOperationResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OperationMetadata>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProviderOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublishPayload {
    #[serde(rename = "useExistingImage", default, skip_serializing_if = "Option::is_none")]
    pub use_existing_image: Option<bool>,
}
impl PublishPayload {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReferenceVm {
    #[serde(rename = "userName")]
    pub user_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "vmStateDetails", default, skip_serializing_if = "Option::is_none")]
    pub vm_state_details: Option<VmStateDetails>,
    #[serde(rename = "vmResourceId", default, skip_serializing_if = "Option::is_none")]
    pub vm_resource_id: Option<String>,
}
impl ReferenceVm {
    pub fn new(user_name: String) -> Self {
        Self {
            user_name,
            password: None,
            vm_state_details: None,
            vm_resource_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReferenceVmCreationParameters {
    #[serde(rename = "userName")]
    pub user_name: String,
    pub password: String,
}
impl ReferenceVmCreationParameters {
    pub fn new(user_name: String, password: String) -> Self {
        Self { user_name, password }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReferenceVmFragment {
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl ReferenceVmFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegionalAvailability {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "sizeAvailabilities", default, skip_serializing_if = "Vec::is_empty")]
    pub size_availabilities: Vec<SizeAvailability>,
}
impl RegionalAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegisterPayload {
    #[serde(rename = "registrationCode", default, skip_serializing_if = "Option::is_none")]
    pub registration_code: Option<String>,
}
impl RegisterPayload {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResetPasswordPayload {
    #[serde(rename = "environmentId")]
    pub environment_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl ResetPasswordPayload {
    pub fn new(environment_id: String) -> Self {
        Self {
            environment_id,
            username: None,
            password: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSet {
    #[serde(rename = "vmResourceId", default, skip_serializing_if = "Option::is_none")]
    pub vm_resource_id: Option<String>,
    #[serde(rename = "resourceSettingId", default, skip_serializing_if = "Option::is_none")]
    pub resource_setting_id: Option<String>,
}
impl ResourceSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSetFragment {
    #[serde(rename = "vmResourceId", default, skip_serializing_if = "Option::is_none")]
    pub vm_resource_id: Option<String>,
    #[serde(rename = "resourceSettingId", default, skip_serializing_if = "Option::is_none")]
    pub resource_setting_id: Option<String>,
}
impl ResourceSetFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceSettingCreationParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "galleryImageResourceId")]
    pub gallery_image_resource_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<resource_setting_creation_parameters::Size>,
    #[serde(rename = "referenceVmCreationParameters")]
    pub reference_vm_creation_parameters: ReferenceVmCreationParameters,
}
impl ResourceSettingCreationParameters {
    pub fn new(gallery_image_resource_id: String, reference_vm_creation_parameters: ReferenceVmCreationParameters) -> Self {
        Self {
            location: None,
            name: None,
            gallery_image_resource_id,
            size: None,
            reference_vm_creation_parameters,
        }
    }
}
pub mod resource_setting_creation_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Size {
        Basic,
        Standard,
        Performance,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "galleryImageResourceId", default, skip_serializing_if = "Option::is_none")]
    pub gallery_image_resource_id: Option<String>,
    #[serde(rename = "imageName", default, skip_serializing_if = "Option::is_none")]
    pub image_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<resource_settings::Size>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cores: Option<i32>,
    #[serde(rename = "referenceVm")]
    pub reference_vm: ReferenceVm,
}
impl ResourceSettings {
    pub fn new(reference_vm: ReferenceVm) -> Self {
        Self {
            id: None,
            gallery_image_resource_id: None,
            image_name: None,
            size: None,
            cores: None,
            reference_vm,
        }
    }
}
pub mod resource_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Size {
        Basic,
        Standard,
        Performance,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSettingsFragment {
    #[serde(rename = "galleryImageResourceId", default, skip_serializing_if = "Option::is_none")]
    pub gallery_image_resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<resource_settings_fragment::Size>,
    #[serde(rename = "referenceVm", default, skip_serializing_if = "Option::is_none")]
    pub reference_vm: Option<ReferenceVmFragment>,
}
impl ResourceSettingsFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_settings_fragment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Size {
        Basic,
        Standard,
        Performance,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseWithContinuationEnvironmentSetting {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EnvironmentSetting>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResponseWithContinuationEnvironmentSetting {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseWithContinuationEnvironment {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Environment>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResponseWithContinuationEnvironment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseWithContinuationGalleryImage {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GalleryImage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResponseWithContinuationGalleryImage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseWithContinuationLabAccount {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LabAccount>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResponseWithContinuationLabAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseWithContinuationLab {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Lab>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResponseWithContinuationLab {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseWithContinuationUser {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<User>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResponseWithContinuationUser {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SizeAvailability {
    #[serde(rename = "sizeCategory", default, skip_serializing_if = "Option::is_none")]
    pub size_category: Option<size_availability::SizeCategory>,
    #[serde(rename = "isAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_available: Option<bool>,
}
impl SizeAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod size_availability {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SizeCategory {
        Basic,
        Standard,
        Performance,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SizeConfigurationProperties {
    #[serde(rename = "environmentSizes", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_sizes: Vec<EnvironmentSize>,
}
impl SizeConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SizeConfigurationPropertiesFragment {
    #[serde(rename = "environmentSizes", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_sizes: Vec<EnvironmentSizeFragment>,
}
impl SizeConfigurationPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SizeInfo {
    #[serde(rename = "computeSize", default, skip_serializing_if = "Option::is_none")]
    pub compute_size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub price: Option<f64>,
    #[serde(rename = "numberOfCores", default, skip_serializing_if = "Option::is_none")]
    pub number_of_cores: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub memory: Option<f64>,
}
impl SizeInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SizeInfoFragment {
    #[serde(rename = "computeSize", default, skip_serializing_if = "Option::is_none")]
    pub compute_size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub price: Option<f64>,
    #[serde(rename = "numberOfCores", default, skip_serializing_if = "Option::is_none")]
    pub number_of_cores: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub memory: Option<f64>,
}
impl SizeInfoFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct User {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserProperties>,
}
impl User {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserFragment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserPropertiesFragment>,
}
impl UserFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(rename = "familyName", default, skip_serializing_if = "Option::is_none")]
    pub family_name: Option<String>,
    #[serde(rename = "givenName", default, skip_serializing_if = "Option::is_none")]
    pub given_name: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "totalUsage", default, skip_serializing_if = "Option::is_none")]
    pub total_usage: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
    #[serde(rename = "latestOperationResult", default, skip_serializing_if = "Option::is_none")]
    pub latest_operation_result: Option<LatestOperationResult>,
}
impl UserProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserPropertiesFragment {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl UserPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineDetails {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "rdpAuthority", default, skip_serializing_if = "Option::is_none")]
    pub rdp_authority: Option<String>,
    #[serde(rename = "sshAuthority", default, skip_serializing_if = "Option::is_none")]
    pub ssh_authority: Option<String>,
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(rename = "lastKnownPowerState", default, skip_serializing_if = "Option::is_none")]
    pub last_known_power_state: Option<String>,
}
impl VirtualMachineDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmStateDetails {
    #[serde(rename = "rdpAuthority", default, skip_serializing_if = "Option::is_none")]
    pub rdp_authority: Option<String>,
    #[serde(rename = "sshAuthority", default, skip_serializing_if = "Option::is_none")]
    pub ssh_authority: Option<String>,
    #[serde(rename = "powerState", default, skip_serializing_if = "Option::is_none")]
    pub power_state: Option<String>,
    #[serde(rename = "lastKnownPowerState", default, skip_serializing_if = "Option::is_none")]
    pub last_known_power_state: Option<String>,
}
impl VmStateDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmStateDetailsFragment {}
impl VmStateDetailsFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
