#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BucketDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "bucketName", default, skip_serializing_if = "Option::is_none")]
    pub bucket_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub insecure: Option<bool>,
    #[serde(rename = "timeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_in_seconds: Option<i64>,
    #[serde(rename = "syncIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub sync_interval_in_seconds: Option<i64>,
    #[serde(rename = "accessKey", default, skip_serializing_if = "Option::is_none")]
    pub access_key: Option<String>,
    #[serde(rename = "localAuthRef", default, skip_serializing_if = "Option::is_none")]
    pub local_auth_ref: Option<String>,
}
impl BucketDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BucketPatchDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "bucketName", default, skip_serializing_if = "Option::is_none")]
    pub bucket_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub insecure: Option<bool>,
    #[serde(rename = "timeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_in_seconds: Option<i64>,
    #[serde(rename = "syncIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub sync_interval_in_seconds: Option<i64>,
    #[serde(rename = "accessKey", default, skip_serializing_if = "Option::is_none")]
    pub access_key: Option<String>,
    #[serde(rename = "localAuthRef", default, skip_serializing_if = "Option::is_none")]
    pub local_auth_ref: Option<String>,
}
impl BucketPatchDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type ChartValues = String;
pub type ChartVersion = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClusterScopeSettings {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<cluster_scope_settings::Properties>,
}
impl ClusterScopeSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod cluster_scope_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "allowMultipleInstances", default, skip_serializing_if = "Option::is_none")]
        pub allow_multiple_instances: Option<bool>,
        #[serde(rename = "defaultReleaseNamespace", default, skip_serializing_if = "Option::is_none")]
        pub default_release_namespace: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComplianceStatus {
    #[serde(rename = "complianceState", default, skip_serializing_if = "Option::is_none")]
    pub compliance_state: Option<compliance_status::ComplianceState>,
    #[serde(rename = "lastConfigApplied", default, skip_serializing_if = "Option::is_none")]
    pub last_config_applied: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "messageLevel", default, skip_serializing_if = "Option::is_none")]
    pub message_level: Option<compliance_status::MessageLevel>,
}
impl ComplianceStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod compliance_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComplianceState {
        Pending,
        Compliant,
        Noncompliant,
        Installed,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MessageLevel {
        Error,
        Warning,
        Information,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConfigurationProtectedSettings {}
impl ConfigurationProtectedSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DependsOnDefinition {
    #[serde(rename = "kustomizationName", default, skip_serializing_if = "Option::is_none")]
    pub kustomization_name: Option<String>,
}
impl DependsOnDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetail>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetail>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Extension {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<extension::Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<Identity>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl Extension {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod extension {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "extensionType", default, skip_serializing_if = "Option::is_none")]
        pub extension_type: Option<String>,
        #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
        pub auto_upgrade_minor_version: Option<bool>,
        #[serde(rename = "releaseTrain", default, skip_serializing_if = "Option::is_none")]
        pub release_train: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub version: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub scope: Option<Scope>,
        #[serde(rename = "configurationSettings", default, skip_serializing_if = "Option::is_none")]
        pub configuration_settings: Option<serde_json::Value>,
        #[serde(rename = "configurationProtectedSettings", default, skip_serializing_if = "Option::is_none")]
        pub configuration_protected_settings: Option<serde_json::Value>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<ProvisioningStateDefinition>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub statuses: Vec<ExtensionStatus>,
        #[serde(rename = "errorInfo", default, skip_serializing_if = "Option::is_none")]
        pub error_info: Option<ErrorDetail>,
        #[serde(rename = "customLocationSettings", default, skip_serializing_if = "Option::is_none")]
        pub custom_location_settings: Option<serde_json::Value>,
        #[serde(rename = "packageUri", default, skip_serializing_if = "Option::is_none")]
        pub package_uri: Option<String>,
        #[serde(rename = "aksAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
        pub aks_assigned_identity: Option<properties::AksAssignedIdentity>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
        pub struct AksAssignedIdentity {
            #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
            pub principal_id: Option<String>,
            #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
            pub tenant_id: Option<String>,
            #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
            pub type_: Option<aks_assigned_identity::Type>,
        }
        impl AksAssignedIdentity {
            pub fn new() -> Self {
                Self::default()
            }
        }
        pub mod aks_assigned_identity {
            use super::*;
            #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
            pub enum Type {
                SystemAssigned,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtensionStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(rename = "displayStatus", default, skip_serializing_if = "Option::is_none")]
    pub display_status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<extension_status::Level>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
}
impl ExtensionStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod extension_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Error,
        Warning,
        Information,
    }
    impl Default for Level {
        fn default() -> Self {
            Self::Information
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExtensionType {
    pub properties: ExtensionTypeProperties,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ExtensionType {
    pub fn new(properties: ExtensionTypeProperties) -> Self {
        Self {
            properties,
            system_data: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtensionTypeList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExtensionType>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExtensionTypeList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtensionTypeProperties {
    #[serde(rename = "releaseTrains", default, skip_serializing_if = "Vec::is_empty")]
    pub release_trains: Vec<String>,
    #[serde(rename = "clusterTypes", default, skip_serializing_if = "Option::is_none")]
    pub cluster_types: Option<extension_type_properties::ClusterTypes>,
    #[serde(rename = "supportedScopes", default, skip_serializing_if = "Option::is_none")]
    pub supported_scopes: Option<SupportedScopes>,
}
impl ExtensionTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod extension_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ClusterTypes {
        #[serde(rename = "connectedClusters")]
        ConnectedClusters,
        #[serde(rename = "managedClusters")]
        ManagedClusters,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtensionVersionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub versions: Vec<serde_json::Value>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ExtensionVersionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtensionsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Extension>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExtensionsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FluxComplianceStateDefinition {
    Compliant,
    #[serde(rename = "Non-Compliant")]
    NonCompliant,
    Pending,
    Suspended,
    Unknown,
}
impl Default for FluxComplianceStateDefinition {
    fn default() -> Self {
        Self::Unknown
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FluxConfiguration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<flux_configuration::Properties>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl FluxConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod flux_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub scope: Option<ScopeDefinition>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub namespace: Option<String>,
        #[serde(rename = "sourceKind", default, skip_serializing_if = "Option::is_none")]
        pub source_kind: Option<SourceKindDefinition>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub suspend: Option<bool>,
        #[serde(rename = "gitRepository", default, skip_serializing_if = "Option::is_none")]
        pub git_repository: Option<GitRepositoryDefinition>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub bucket: Option<BucketDefinition>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub kustomizations: Option<serde_json::Value>,
        #[serde(rename = "configurationProtectedSettings", default, skip_serializing_if = "Option::is_none")]
        pub configuration_protected_settings: Option<serde_json::Value>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub statuses: Vec<ObjectStatusDefinition>,
        #[serde(rename = "repositoryPublicKey", default, skip_serializing_if = "Option::is_none")]
        pub repository_public_key: Option<String>,
        #[serde(rename = "lastSourceUpdatedCommitId", default, skip_serializing_if = "Option::is_none")]
        pub last_source_updated_commit_id: Option<String>,
        #[serde(rename = "lastSourceUpdatedAt", default, skip_serializing_if = "Option::is_none")]
        pub last_source_updated_at: Option<String>,
        #[serde(rename = "complianceState", default, skip_serializing_if = "Option::is_none")]
        pub compliance_state: Option<FluxComplianceStateDefinition>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<ProvisioningStateDefinition>,
        #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
        pub error_message: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FluxConfigurationPatch {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<flux_configuration_patch::Properties>,
}
impl FluxConfigurationPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod flux_configuration_patch {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "sourceKind", default, skip_serializing_if = "Option::is_none")]
        pub source_kind: Option<SourceKindDefinition>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub suspend: Option<bool>,
        #[serde(rename = "gitRepository", default, skip_serializing_if = "Option::is_none")]
        pub git_repository: Option<GitRepositoryPatchDefinition>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub bucket: Option<BucketDefinition>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub kustomizations: Option<serde_json::Value>,
        #[serde(rename = "configurationProtectedSettings", default, skip_serializing_if = "Option::is_none")]
        pub configuration_protected_settings: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FluxConfigurationsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FluxConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FluxConfigurationsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GitRepositoryDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "timeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_in_seconds: Option<i64>,
    #[serde(rename = "syncIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub sync_interval_in_seconds: Option<i64>,
    #[serde(rename = "repositoryRef", default, skip_serializing_if = "Option::is_none")]
    pub repository_ref: Option<RepositoryRefDefinition>,
    #[serde(rename = "sshKnownHosts", default, skip_serializing_if = "Option::is_none")]
    pub ssh_known_hosts: Option<String>,
    #[serde(rename = "httpsUser", default, skip_serializing_if = "Option::is_none")]
    pub https_user: Option<String>,
    #[serde(rename = "httpsCACert", default, skip_serializing_if = "Option::is_none")]
    pub https_ca_cert: Option<String>,
    #[serde(rename = "localAuthRef", default, skip_serializing_if = "Option::is_none")]
    pub local_auth_ref: Option<String>,
}
impl GitRepositoryDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GitRepositoryPatchDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "timeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_in_seconds: Option<i64>,
    #[serde(rename = "syncIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub sync_interval_in_seconds: Option<i64>,
    #[serde(rename = "repositoryRef", default, skip_serializing_if = "Option::is_none")]
    pub repository_ref: Option<RepositoryRefDefinition>,
    #[serde(rename = "sshKnownHosts", default, skip_serializing_if = "Option::is_none")]
    pub ssh_known_hosts: Option<String>,
    #[serde(rename = "httpsUser", default, skip_serializing_if = "Option::is_none")]
    pub https_user: Option<String>,
    #[serde(rename = "httpsCACert", default, skip_serializing_if = "Option::is_none")]
    pub https_ca_cert: Option<String>,
    #[serde(rename = "localAuthRef", default, skip_serializing_if = "Option::is_none")]
    pub local_auth_ref: Option<String>,
}
impl GitRepositoryPatchDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HelmOperatorProperties {
    #[serde(rename = "chartVersion", default, skip_serializing_if = "Option::is_none")]
    pub chart_version: Option<ChartVersion>,
    #[serde(rename = "chartValues", default, skip_serializing_if = "Option::is_none")]
    pub chart_values: Option<ChartValues>,
}
impl HelmOperatorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HelmReleasePropertiesDefinition {
    #[serde(rename = "lastRevisionApplied", default, skip_serializing_if = "Option::is_none")]
    pub last_revision_applied: Option<i64>,
    #[serde(rename = "helmChartRef", default, skip_serializing_if = "Option::is_none")]
    pub helm_chart_ref: Option<ObjectReferenceDefinition>,
    #[serde(rename = "failureCount", default, skip_serializing_if = "Option::is_none")]
    pub failure_count: Option<i64>,
    #[serde(rename = "installFailureCount", default, skip_serializing_if = "Option::is_none")]
    pub install_failure_count: Option<i64>,
    #[serde(rename = "upgradeFailureCount", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_failure_count: Option<i64>,
}
impl HelmReleasePropertiesDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Identity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity::Type>,
}
impl Identity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KustomizationDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "dependsOn", default, skip_serializing_if = "Vec::is_empty")]
    pub depends_on: Vec<DependsOnDefinition>,
    #[serde(rename = "timeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_in_seconds: Option<i64>,
    #[serde(rename = "syncIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub sync_interval_in_seconds: Option<i64>,
    #[serde(rename = "retryIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub retry_interval_in_seconds: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prune: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub force: Option<bool>,
}
impl KustomizationDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KustomizationPatchDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "dependsOn", default, skip_serializing_if = "Vec::is_empty")]
    pub depends_on: Vec<DependsOnDefinition>,
    #[serde(rename = "timeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_in_seconds: Option<i64>,
    #[serde(rename = "syncIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub sync_interval_in_seconds: Option<i64>,
    #[serde(rename = "retryIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub retry_interval_in_seconds: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prune: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub force: Option<bool>,
}
impl KustomizationPatchDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum KustomizationValidationDefinition {
    #[serde(rename = "none")]
    None,
    #[serde(rename = "client")]
    Client,
    #[serde(rename = "server")]
    Server,
}
impl Default for KustomizationValidationDefinition {
    fn default() -> Self {
        Self::None
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ObjectReferenceDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespace: Option<String>,
}
impl ObjectReferenceDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ObjectStatusConditionDefinition {
    #[serde(rename = "lastTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub last_transition_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ObjectStatusConditionDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ObjectStatusDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespace: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[serde(rename = "complianceState", default, skip_serializing_if = "Option::is_none")]
    pub compliance_state: Option<FluxComplianceStateDefinition>,
    #[serde(rename = "appliedBy", default, skip_serializing_if = "Option::is_none")]
    pub applied_by: Option<ObjectReferenceDefinition>,
    #[serde(rename = "statusConditions", default, skip_serializing_if = "Vec::is_empty")]
    pub status_conditions: Vec<ObjectStatusConditionDefinition>,
    #[serde(rename = "helmReleaseProperties", default, skip_serializing_if = "Option::is_none")]
    pub helm_release_properties: Option<HelmReleasePropertiesDefinition>,
}
impl ObjectStatusDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatusList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OperationStatusResult>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationStatusList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    pub status: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetail>,
}
impl OperationStatusResult {
    pub fn new(status: String) -> Self {
        Self {
            id: None,
            name: None,
            status,
            properties: None,
            error: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OperatorScopeDefinition {
    #[serde(rename = "cluster")]
    Cluster,
    #[serde(rename = "namespace")]
    Namespace,
}
impl Default for OperatorScopeDefinition {
    fn default() -> Self {
        Self::Cluster
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OperatorTypeDefinition {
    Flux,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProvisioningStateDefinition {
    Succeeded,
    Failed,
    Canceled,
    Creating,
    Updating,
    Deleting,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RepositoryRefDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub semver: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub commit: Option<String>,
}
impl RepositoryRefDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderOperation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<resource_provider_operation::Display>,
    #[serde(rename = "isDataAction", default, skip_serializing_if = "Option::is_none")]
    pub is_data_action: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
}
impl ResourceProviderOperation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_provider_operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderOperationList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceProviderOperation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceProviderOperationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Scope {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cluster: Option<ScopeCluster>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespace: Option<ScopeNamespace>,
}
impl Scope {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeCluster {
    #[serde(rename = "releaseNamespace", default, skip_serializing_if = "Option::is_none")]
    pub release_namespace: Option<String>,
}
impl ScopeCluster {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ScopeDefinition {
    #[serde(rename = "cluster")]
    Cluster,
    #[serde(rename = "namespace")]
    Namespace,
}
impl Default for ScopeDefinition {
    fn default() -> Self {
        Self::Cluster
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeNamespace {
    #[serde(rename = "targetNamespace", default, skip_serializing_if = "Option::is_none")]
    pub target_namespace: Option<String>,
}
impl ScopeNamespace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceControlConfiguration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<source_control_configuration::Properties>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl SourceControlConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod source_control_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "repositoryUrl", default, skip_serializing_if = "Option::is_none")]
        pub repository_url: Option<String>,
        #[serde(rename = "operatorNamespace", default, skip_serializing_if = "Option::is_none")]
        pub operator_namespace: Option<String>,
        #[serde(rename = "operatorInstanceName", default, skip_serializing_if = "Option::is_none")]
        pub operator_instance_name: Option<String>,
        #[serde(rename = "operatorType", default, skip_serializing_if = "Option::is_none")]
        pub operator_type: Option<OperatorTypeDefinition>,
        #[serde(rename = "operatorParams", default, skip_serializing_if = "Option::is_none")]
        pub operator_params: Option<String>,
        #[serde(rename = "configurationProtectedSettings", default, skip_serializing_if = "Option::is_none")]
        pub configuration_protected_settings: Option<ConfigurationProtectedSettings>,
        #[serde(rename = "operatorScope", default, skip_serializing_if = "Option::is_none")]
        pub operator_scope: Option<OperatorScopeDefinition>,
        #[serde(rename = "repositoryPublicKey", default, skip_serializing_if = "Option::is_none")]
        pub repository_public_key: Option<String>,
        #[serde(rename = "sshKnownHostsContents", default, skip_serializing_if = "Option::is_none")]
        pub ssh_known_hosts_contents: Option<String>,
        #[serde(rename = "enableHelmOperator", default, skip_serializing_if = "Option::is_none")]
        pub enable_helm_operator: Option<bool>,
        #[serde(rename = "helmOperatorProperties", default, skip_serializing_if = "Option::is_none")]
        pub helm_operator_properties: Option<HelmOperatorProperties>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[serde(rename = "complianceStatus", default, skip_serializing_if = "Option::is_none")]
        pub compliance_status: Option<ComplianceStatus>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Accepted,
            Deleting,
            Running,
            Succeeded,
            Failed,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceControlConfigurationList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SourceControlConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SourceControlConfigurationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SourceKindDefinition {
    GitRepository,
    Bucket,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SupportedScopes {
    #[serde(rename = "defaultScope", default, skip_serializing_if = "Option::is_none")]
    pub default_scope: Option<String>,
    #[serde(rename = "clusterScopeSettings", default, skip_serializing_if = "Option::is_none")]
    pub cluster_scope_settings: Option<ClusterScopeSettings>,
}
impl SupportedScopes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PatchExtension {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<patch_extension::Properties>,
}
impl PatchExtension {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod patch_extension {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
        pub auto_upgrade_minor_version: Option<bool>,
        #[serde(rename = "releaseTrain", default, skip_serializing_if = "Option::is_none")]
        pub release_train: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub version: Option<String>,
        #[serde(rename = "configurationSettings", default, skip_serializing_if = "Option::is_none")]
        pub configuration_settings: Option<serde_json::Value>,
        #[serde(rename = "configurationProtectedSettings", default, skip_serializing_if = "Option::is_none")]
        pub configuration_protected_settings: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
