#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The JSON-serialized X509 Certificate."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateBodyDescription {
    #[doc = "base-64 representation of the X509 leaf certificate .cer file or just .pem file content."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<String>,
}
impl CertificateBodyDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The X509 Certificate."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateDescription {
    #[doc = "The description of an X509 CA Certificate."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificateProperties>,
    #[doc = "The resource identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the certificate."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The entity tag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl CertificateDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The JSON-serialized array of Certificate objects."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateListDescription {
    #[doc = "The array of Certificate objects."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CertificateDescription>,
}
impl CertificateListDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The description of an X509 CA Certificate."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateProperties {
    #[doc = "The certificate's subject name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[doc = "The certificate's expiration date and time."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiry: Option<String>,
    #[doc = "The certificate's thumbprint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "Determines whether certificate has been verified."]
    #[serde(rename = "isVerified", default, skip_serializing_if = "Option::is_none")]
    pub is_verified: Option<bool>,
    #[doc = "The certificate's create date and time."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[doc = "The certificate's last update date and time."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
}
impl CertificateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The description of an X509 CA Certificate including the challenge nonce issued for the Proof-Of-Possession flow."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificatePropertiesWithNonce {
    #[doc = "The certificate's subject name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[doc = "The certificate's expiration date and time."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiry: Option<String>,
    #[doc = "The certificate's thumbprint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "Determines whether certificate has been verified."]
    #[serde(rename = "isVerified", default, skip_serializing_if = "Option::is_none")]
    pub is_verified: Option<bool>,
    #[doc = "The certificate's create date and time."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[doc = "The certificate's last update date and time."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[doc = "The certificate's verification code that will be used for proof of possession."]
    #[serde(rename = "verificationCode", default, skip_serializing_if = "Option::is_none")]
    pub verification_code: Option<String>,
}
impl CertificatePropertiesWithNonce {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The JSON-serialized leaf certificate"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateVerificationDescription {
    #[doc = "base-64 representation of X509 certificate .cer file or just .pem file content."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<String>,
}
impl CertificateVerificationDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The X509 Certificate."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateWithNonceDescription {
    #[doc = "The description of an X509 CA Certificate including the challenge nonce issued for the Proof-Of-Possession flow."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificatePropertiesWithNonce>,
    #[doc = "The resource identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the certificate."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The entity tag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl CertificateWithNonceDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The IoT hub cloud-to-device messaging properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudToDeviceProperties {
    #[doc = "The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages."]
    #[serde(rename = "maxDeliveryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_delivery_count: Option<i32>,
    #[doc = "The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages."]
    #[serde(rename = "defaultTtlAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub default_ttl_as_iso8601: Option<String>,
    #[doc = "The properties of the feedback queue for cloud-to-device messages."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub feedback: Option<FeedbackProperties>,
}
impl CloudToDeviceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Error details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The HTTP status code."]
    #[serde(rename = "httpStatusCode", default, skip_serializing_if = "Option::is_none")]
    pub http_status_code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of the EventHubConsumerGroupInfo object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubConsumerGroupInfo {
    #[doc = "The tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "The Event Hub-compatible consumer group identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The Event Hub-compatible consumer group name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "the resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The etag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl EventHubConsumerGroupInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The JSON-serialized array of Event Hub-compatible consumer group names with a next link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubConsumerGroupsListResult {
    #[doc = "List of consumer groups objects"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EventHubConsumerGroupInfo>,
    #[doc = "The next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EventHubConsumerGroupsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubProperties {
    #[doc = "The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages"]
    #[serde(rename = "retentionTimeInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_time_in_days: Option<i64>,
    #[doc = "The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages."]
    #[serde(rename = "partitionCount", default, skip_serializing_if = "Option::is_none")]
    pub partition_count: Option<i32>,
    #[doc = "The partition ids in the Event Hub-compatible endpoint."]
    #[serde(rename = "partitionIds", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_ids: Vec<String>,
    #[doc = "The Event Hub-compatible name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "The Event Hub-compatible endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
}
impl EventHubProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Use to provide parameters when requesting an export of all devices in the IoT hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportDevicesRequest {
    #[doc = "The export blob container URI."]
    #[serde(rename = "exportBlobContainerUri")]
    pub export_blob_container_uri: String,
    #[doc = "The value indicating whether keys should be excluded during export."]
    #[serde(rename = "excludeKeys")]
    pub exclude_keys: bool,
}
impl ExportDevicesRequest {
    pub fn new(export_blob_container_uri: String, exclude_keys: bool) -> Self {
        Self {
            export_blob_container_uri,
            exclude_keys,
        }
    }
}
#[doc = "The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FallbackRouteProperties {
    #[doc = "The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The source to which the routing rule is to be applied to. For example, DeviceMessages"]
    pub source: fallback_route_properties::Source,
    #[doc = "The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub condition: Option<String>,
    #[doc = "The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed."]
    #[serde(rename = "endpointNames")]
    pub endpoint_names: Vec<String>,
    #[doc = "Used to specify whether the fallback route is enabled."]
    #[serde(rename = "isEnabled")]
    pub is_enabled: bool,
}
impl FallbackRouteProperties {
    pub fn new(source: fallback_route_properties::Source, endpoint_names: Vec<String>, is_enabled: bool) -> Self {
        Self {
            name: None,
            source,
            condition: None,
            endpoint_names,
            is_enabled,
        }
    }
}
pub mod fallback_route_properties {
    use super::*;
    #[doc = "The source to which the routing rule is to be applied to. For example, DeviceMessages"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        DeviceMessages,
    }
}
#[doc = "The properties of the feedback queue for cloud-to-device messages."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FeedbackProperties {
    #[doc = "The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages."]
    #[serde(rename = "lockDurationAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub lock_duration_as_iso8601: Option<String>,
    #[doc = "The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages."]
    #[serde(rename = "ttlAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub ttl_as_iso8601: Option<String>,
    #[doc = "The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages."]
    #[serde(rename = "maxDeliveryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_delivery_count: Option<i32>,
}
impl FeedbackProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Use to provide parameters when requesting an import of all devices in the hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportDevicesRequest {
    #[doc = "The input blob container URI."]
    #[serde(rename = "inputBlobContainerUri")]
    pub input_blob_container_uri: String,
    #[doc = "The output blob container URI."]
    #[serde(rename = "outputBlobContainerUri")]
    pub output_blob_container_uri: String,
}
impl ImportDevicesRequest {
    pub fn new(input_blob_container_uri: String, output_blob_container_uri: String) -> Self {
        Self {
            input_blob_container_uri,
            output_blob_container_uri,
        }
    }
}
#[doc = "IoT Hub capacity information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubCapacity {
    #[doc = "The minimum number of units."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<i64>,
    #[doc = "The maximum number of units."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i64>,
    #[doc = "The default number of units."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<i64>,
    #[doc = "The type of the scaling enabled."]
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<iot_hub_capacity::ScaleType>,
}
impl IotHubCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod iot_hub_capacity {
    use super::*;
    #[doc = "The type of the scaling enabled."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScaleType {
        Automatic,
        Manual,
        None,
    }
}
#[doc = "The description of the IoT hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IotHubDescription {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The properties of an IoT hub."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IotHubProperties>,
    #[doc = "Information about the SKU of the IoT hub."]
    pub sku: IotHubSkuInfo,
}
impl IotHubDescription {
    pub fn new(resource: Resource, sku: IotHubSkuInfo) -> Self {
        Self {
            resource,
            etag: None,
            properties: None,
            sku,
        }
    }
}
#[doc = "The JSON-serialized array of IotHubDescription objects with a next link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubDescriptionListResult {
    #[doc = "The array of IotHubDescription objects."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IotHubDescription>,
    #[doc = "The next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IotHubDescriptionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties indicating whether a given IoT hub name is available."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubNameAvailabilityInfo {
    #[doc = "The value which indicates whether the provided name is available."]
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[doc = "The reason for unavailability."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<iot_hub_name_availability_info::Reason>,
    #[doc = "The detailed reason message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl IotHubNameAvailabilityInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod iot_hub_name_availability_info {
    use super::*;
    #[doc = "The reason for unavailability."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[doc = "The properties of an IoT hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubProperties {
    #[doc = "The shared access policies you can use to secure a connection to the IoT hub."]
    #[serde(rename = "authorizationPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub authorization_policies: Vec<SharedAccessSignatureAuthorizationRule>,
    #[doc = "The IP filter rules."]
    #[serde(rename = "ipFilterRules", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_filter_rules: Vec<IpFilterRule>,
    #[doc = "The provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "The hub state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The name of the host."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[doc = "The Event Hub-compatible endpoint properties. The possible keys to this dictionary are events and operationsMonitoringEvents. Both of these keys have to be present in the dictionary while making create or update calls for the IoT hub."]
    #[serde(rename = "eventHubEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub event_hub_endpoints: Option<serde_json::Value>,
    #[doc = "The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub routing: Option<RoutingProperties>,
    #[doc = "The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown."]
    #[serde(rename = "storageEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub storage_endpoints: Option<serde_json::Value>,
    #[doc = "The messaging endpoint properties for the file upload notification queue."]
    #[serde(rename = "messagingEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub messaging_endpoints: Option<serde_json::Value>,
    #[doc = "If True, file upload notifications are enabled."]
    #[serde(rename = "enableFileUploadNotifications", default, skip_serializing_if = "Option::is_none")]
    pub enable_file_upload_notifications: Option<bool>,
    #[doc = "The IoT hub cloud-to-device messaging properties."]
    #[serde(rename = "cloudToDevice", default, skip_serializing_if = "Option::is_none")]
    pub cloud_to_device: Option<CloudToDeviceProperties>,
    #[doc = "IoT hub comments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
    #[doc = "The operations monitoring properties for the IoT hub. The possible keys to the dictionary are Connections, DeviceTelemetry, C2DCommands, DeviceIdentityOperations, FileUploadOperations, Routes, D2CTwinOperations, C2DTwinOperations, TwinQueries, JobsOperations, DirectMethods."]
    #[serde(rename = "operationsMonitoringProperties", default, skip_serializing_if = "Option::is_none")]
    pub operations_monitoring_properties: Option<OperationsMonitoringProperties>,
    #[doc = "The capabilities and features enabled for the IoT hub."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub features: Option<iot_hub_properties::Features>,
}
impl IotHubProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod iot_hub_properties {
    use super::*;
    #[doc = "The capabilities and features enabled for the IoT hub."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Features {
        None,
        DeviceManagement,
    }
}
#[doc = "Quota metrics properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubQuotaMetricInfo {
    #[doc = "The name of the quota metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The current value for the quota metric."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[doc = "The maximum value of the quota metric."]
    #[serde(rename = "maxValue", default, skip_serializing_if = "Option::is_none")]
    pub max_value: Option<i64>,
}
impl IotHubQuotaMetricInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The JSON-serialized array of IotHubQuotaMetricInfo objects with a next link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubQuotaMetricInfoListResult {
    #[doc = "The array of quota metrics objects."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IotHubQuotaMetricInfo>,
    #[doc = "The next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IotHubQuotaMetricInfoListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SKU properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IotHubSkuDescription {
    #[doc = "The type of the resource."]
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[doc = "Information about the SKU of the IoT hub."]
    pub sku: IotHubSkuInfo,
    #[doc = "IoT Hub capacity information."]
    pub capacity: IotHubCapacity,
}
impl IotHubSkuDescription {
    pub fn new(sku: IotHubSkuInfo, capacity: IotHubCapacity) -> Self {
        Self {
            resource_type: None,
            sku,
            capacity,
        }
    }
}
#[doc = "The JSON-serialized array of IotHubSkuDescription objects with a next link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubSkuDescriptionListResult {
    #[doc = "The array of IotHubSkuDescription."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IotHubSkuDescription>,
    #[doc = "The next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IotHubSkuDescriptionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information about the SKU of the IoT hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IotHubSkuInfo {
    #[doc = "The name of the SKU."]
    pub name: iot_hub_sku_info::Name,
    #[doc = "The billing tier for the IoT hub."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<iot_hub_sku_info::Tier>,
    #[doc = "The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i64>,
}
impl IotHubSkuInfo {
    pub fn new(name: iot_hub_sku_info::Name) -> Self {
        Self {
            name,
            tier: None,
            capacity: None,
        }
    }
}
pub mod iot_hub_sku_info {
    use super::*;
    #[doc = "The name of the SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        F1,
        S1,
        S2,
        S3,
    }
    #[doc = "The billing tier for the IoT hub."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Free,
        Standard,
    }
}
#[doc = "The IP filter rules for the IoT hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpFilterRule {
    #[doc = "The name of the IP filter rule."]
    #[serde(rename = "filterName")]
    pub filter_name: String,
    #[doc = "The desired action for requests captured by this rule."]
    pub action: ip_filter_rule::Action,
    #[doc = "A string that contains the IP address range in CIDR notation for the rule."]
    #[serde(rename = "ipMask")]
    pub ip_mask: String,
}
impl IpFilterRule {
    pub fn new(filter_name: String, action: ip_filter_rule::Action, ip_mask: String) -> Self {
        Self {
            filter_name,
            action,
            ip_mask,
        }
    }
}
pub mod ip_filter_rule {
    use super::*;
    #[doc = "The desired action for requests captured by this rule."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Accept,
        Reject,
    }
}
#[doc = "The properties of the Job Response object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobResponse {
    #[doc = "The job identifier."]
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[doc = "The start time of the job."]
    #[serde(rename = "startTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub start_time_utc: Option<String>,
    #[doc = "The time the job stopped processing."]
    #[serde(rename = "endTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub end_time_utc: Option<String>,
    #[doc = "The type of the job."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<job_response::Type>,
    #[doc = "The status of the job."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<job_response::Status>,
    #[doc = "If status == failed, this string containing the reason for the failure."]
    #[serde(rename = "failureReason", default, skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    #[doc = "The status message for the job."]
    #[serde(rename = "statusMessage", default, skip_serializing_if = "Option::is_none")]
    pub status_message: Option<String>,
    #[doc = "The job identifier of the parent job, if any."]
    #[serde(rename = "parentJobId", default, skip_serializing_if = "Option::is_none")]
    pub parent_job_id: Option<String>,
}
impl JobResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_response {
    use super::*;
    #[doc = "The type of the job."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "unknown")]
        Unknown,
        #[serde(rename = "export")]
        Export,
        #[serde(rename = "import")]
        Import,
        #[serde(rename = "backup")]
        Backup,
        #[serde(rename = "readDeviceProperties")]
        ReadDeviceProperties,
        #[serde(rename = "writeDeviceProperties")]
        WriteDeviceProperties,
        #[serde(rename = "updateDeviceConfiguration")]
        UpdateDeviceConfiguration,
        #[serde(rename = "rebootDevice")]
        RebootDevice,
        #[serde(rename = "factoryResetDevice")]
        FactoryResetDevice,
        #[serde(rename = "firmwareUpdate")]
        FirmwareUpdate,
    }
    #[doc = "The status of the job."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "unknown")]
        Unknown,
        #[serde(rename = "enqueued")]
        Enqueued,
        #[serde(rename = "running")]
        Running,
        #[serde(rename = "completed")]
        Completed,
        #[serde(rename = "failed")]
        Failed,
        #[serde(rename = "cancelled")]
        Cancelled,
    }
}
#[doc = "The JSON-serialized array of JobResponse objects with a next link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobResponseListResult {
    #[doc = "The array of JobResponse objects."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobResponse>,
    #[doc = "The next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobResponseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of the messaging endpoints used by this IoT hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MessagingEndpointProperties {
    #[doc = "The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload."]
    #[serde(rename = "lockDurationAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub lock_duration_as_iso8601: Option<String>,
    #[doc = "The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload."]
    #[serde(rename = "ttlAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub ttl_as_iso8601: Option<String>,
    #[doc = "The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload."]
    #[serde(rename = "maxDeliveryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_delivery_count: Option<i32>,
}
impl MessagingEndpointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IoT Hub REST API operation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{read | write | action | delete}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The object that represents the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "The object that represents the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Service provider: Microsoft Devices"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource Type: IotHubs"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Name of the operation"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Input values."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationInputs {
    #[doc = "The name of the IoT hub to check."]
    pub name: String,
}
impl OperationInputs {
    pub fn new(name: String) -> Self {
        Self { name }
    }
}
#[doc = "Result of the request to list IoT Hub operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of IoT Hub operations supported by the Microsoft.Devices resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The operations monitoring properties for the IoT hub. The possible keys to the dictionary are Connections, DeviceTelemetry, C2DCommands, DeviceIdentityOperations, FileUploadOperations, Routes, D2CTwinOperations, C2DTwinOperations, TwinQueries, JobsOperations, DirectMethods."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsMonitoringProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub events: Option<serde_json::Value>,
}
impl OperationsMonitoringProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Identity registry statistics."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryStatistics {
    #[doc = "The total count of devices in the identity registry."]
    #[serde(rename = "totalDeviceCount", default, skip_serializing_if = "Option::is_none")]
    pub total_device_count: Option<i64>,
    #[doc = "The count of enabled devices in the identity registry."]
    #[serde(rename = "enabledDeviceCount", default, skip_serializing_if = "Option::is_none")]
    pub enabled_device_count: Option<i64>,
    #[doc = "The count of disabled devices in the identity registry."]
    #[serde(rename = "disabledDeviceCount", default, skip_serializing_if = "Option::is_none")]
    pub disabled_device_count: Option<i64>,
}
impl RegistryStatistics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The common properties of an Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "The resource identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The resource location."]
    pub location: String,
    #[doc = "The resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[doc = "The properties of a routing rule that your IoT hub uses to route messages to endpoints."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RouteProperties {
    #[doc = "The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique."]
    pub name: String,
    #[doc = "The source that the routing rule is to be applied to, such as DeviceMessages."]
    pub source: route_properties::Source,
    #[doc = "The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub condition: Option<String>,
    #[doc = "The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed."]
    #[serde(rename = "endpointNames")]
    pub endpoint_names: Vec<String>,
    #[doc = "Used to specify whether a route is enabled."]
    #[serde(rename = "isEnabled")]
    pub is_enabled: bool,
}
impl RouteProperties {
    pub fn new(name: String, source: route_properties::Source, endpoint_names: Vec<String>, is_enabled: bool) -> Self {
        Self {
            name,
            source,
            condition: None,
            endpoint_names,
            is_enabled,
        }
    }
}
pub mod route_properties {
    use super::*;
    #[doc = "The source that the routing rule is to be applied to, such as DeviceMessages."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        DeviceMessages,
        TwinChangeEvents,
        DeviceLifecycleEvents,
        DeviceJobLifecycleEvents,
    }
}
#[doc = "The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingEndpoints {
    #[doc = "The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules."]
    #[serde(rename = "serviceBusQueues", default, skip_serializing_if = "Vec::is_empty")]
    pub service_bus_queues: Vec<RoutingServiceBusQueueEndpointProperties>,
    #[doc = "The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules."]
    #[serde(rename = "serviceBusTopics", default, skip_serializing_if = "Vec::is_empty")]
    pub service_bus_topics: Vec<RoutingServiceBusTopicEndpointProperties>,
    #[doc = "The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint."]
    #[serde(rename = "eventHubs", default, skip_serializing_if = "Vec::is_empty")]
    pub event_hubs: Vec<RoutingEventHubProperties>,
    #[doc = "The list of storage container endpoints that IoT hub routes messages to, based on the routing rules."]
    #[serde(rename = "storageContainers", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_containers: Vec<RoutingStorageContainerProperties>,
}
impl RoutingEndpoints {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties related to an event hub endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutingEventHubProperties {
    #[doc = "The connection string of the event hub endpoint. "]
    #[serde(rename = "connectionString")]
    pub connection_string: String,
    #[doc = "The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, operationsMonitoringEvents, fileNotifications, $default. Endpoint names must be unique across endpoint types."]
    pub name: String,
    #[doc = "The subscription identifier of the event hub endpoint."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "The name of the resource group of the event hub endpoint."]
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl RoutingEventHubProperties {
    pub fn new(connection_string: String, name: String) -> Self {
        Self {
            connection_string,
            name,
            subscription_id: None,
            resource_group: None,
        }
    }
}
#[doc = "The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingProperties {
    #[doc = "The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoints: Option<RoutingEndpoints>,
    #[doc = "The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<RouteProperties>,
    #[doc = "The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint."]
    #[serde(rename = "fallbackRoute", default, skip_serializing_if = "Option::is_none")]
    pub fallback_route: Option<FallbackRouteProperties>,
}
impl RoutingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties related to service bus queue endpoint types."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutingServiceBusQueueEndpointProperties {
    #[doc = "The connection string of the service bus queue endpoint."]
    #[serde(rename = "connectionString")]
    pub connection_string: String,
    #[doc = "The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, operationsMonitoringEvents, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name."]
    pub name: String,
    #[doc = "The subscription identifier of the service bus queue endpoint."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "The name of the resource group of the service bus queue endpoint."]
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl RoutingServiceBusQueueEndpointProperties {
    pub fn new(connection_string: String, name: String) -> Self {
        Self {
            connection_string,
            name,
            subscription_id: None,
            resource_group: None,
        }
    }
}
#[doc = "The properties related to service bus topic endpoint types."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutingServiceBusTopicEndpointProperties {
    #[doc = "The connection string of the service bus topic endpoint."]
    #[serde(rename = "connectionString")]
    pub connection_string: String,
    #[doc = "The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, operationsMonitoringEvents, fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name need not be the same as the actual topic name."]
    pub name: String,
    #[doc = "The subscription identifier of the service bus topic endpoint."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "The name of the resource group of the service bus topic endpoint."]
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl RoutingServiceBusTopicEndpointProperties {
    pub fn new(connection_string: String, name: String) -> Self {
        Self {
            connection_string,
            name,
            subscription_id: None,
            resource_group: None,
        }
    }
}
#[doc = "The properties related to a storage container endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutingStorageContainerProperties {
    #[doc = "The connection string of the storage account."]
    #[serde(rename = "connectionString")]
    pub connection_string: String,
    #[doc = "The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, operationsMonitoringEvents, fileNotifications, $default. Endpoint names must be unique across endpoint types."]
    pub name: String,
    #[doc = "The subscription identifier of the storage account."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "The name of the resource group of the storage account."]
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[doc = "The name of storage container in the storage account."]
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[doc = "File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered."]
    #[serde(rename = "fileNameFormat", default, skip_serializing_if = "Option::is_none")]
    pub file_name_format: Option<String>,
    #[doc = "Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds."]
    #[serde(rename = "batchFrequencyInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub batch_frequency_in_seconds: Option<i32>,
    #[doc = "Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB)."]
    #[serde(rename = "maxChunkSizeInBytes", default, skip_serializing_if = "Option::is_none")]
    pub max_chunk_size_in_bytes: Option<i32>,
    #[doc = "Encoding that is used to serialize messages to blobs. Supported values are 'avro' and 'avroDeflate'. Default value is 'avro'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encoding: Option<String>,
}
impl RoutingStorageContainerProperties {
    pub fn new(connection_string: String, name: String, container_name: String) -> Self {
        Self {
            connection_string,
            name,
            subscription_id: None,
            resource_group: None,
            container_name,
            file_name_format: None,
            batch_frequency_in_seconds: None,
            max_chunk_size_in_bytes: None,
            encoding: None,
        }
    }
}
#[doc = "The properties of an IoT hub shared access policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharedAccessSignatureAuthorizationRule {
    #[doc = "The name of the shared access policy."]
    #[serde(rename = "keyName")]
    pub key_name: String,
    #[doc = "The primary key."]
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[doc = "The secondary key."]
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
    #[doc = "The permissions assigned to the shared access policy."]
    pub rights: shared_access_signature_authorization_rule::Rights,
}
impl SharedAccessSignatureAuthorizationRule {
    pub fn new(key_name: String, rights: shared_access_signature_authorization_rule::Rights) -> Self {
        Self {
            key_name,
            primary_key: None,
            secondary_key: None,
            rights,
        }
    }
}
pub mod shared_access_signature_authorization_rule {
    use super::*;
    #[doc = "The permissions assigned to the shared access policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Rights {
        RegistryRead,
        RegistryWrite,
        ServiceConnect,
        DeviceConnect,
        #[serde(rename = "RegistryRead, RegistryWrite")]
        RegistryReadRegistryWrite,
        #[serde(rename = "RegistryRead, ServiceConnect")]
        RegistryReadServiceConnect,
        #[serde(rename = "RegistryRead, DeviceConnect")]
        RegistryReadDeviceConnect,
        #[serde(rename = "RegistryWrite, ServiceConnect")]
        RegistryWriteServiceConnect,
        #[serde(rename = "RegistryWrite, DeviceConnect")]
        RegistryWriteDeviceConnect,
        #[serde(rename = "ServiceConnect, DeviceConnect")]
        ServiceConnectDeviceConnect,
        #[serde(rename = "RegistryRead, RegistryWrite, ServiceConnect")]
        RegistryReadRegistryWriteServiceConnect,
        #[serde(rename = "RegistryRead, RegistryWrite, DeviceConnect")]
        RegistryReadRegistryWriteDeviceConnect,
        #[serde(rename = "RegistryRead, ServiceConnect, DeviceConnect")]
        RegistryReadServiceConnectDeviceConnect,
        #[serde(rename = "RegistryWrite, ServiceConnect, DeviceConnect")]
        RegistryWriteServiceConnectDeviceConnect,
        #[serde(rename = "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect")]
        RegistryReadRegistryWriteServiceConnectDeviceConnect,
    }
}
#[doc = "The list of shared access policies with a next link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharedAccessSignatureAuthorizationRuleListResult {
    #[doc = "The list of shared access policies."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SharedAccessSignatureAuthorizationRule>,
    #[doc = "The next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SharedAccessSignatureAuthorizationRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of the Azure Storage endpoint for file upload."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageEndpointProperties {
    #[doc = "The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options."]
    #[serde(rename = "sasTtlAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub sas_ttl_as_iso8601: Option<String>,
    #[doc = "The connection string for the Azure Storage account to which files are uploaded."]
    #[serde(rename = "connectionString")]
    pub connection_string: String,
    #[doc = "The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified."]
    #[serde(rename = "containerName")]
    pub container_name: String,
}
impl StorageEndpointProperties {
    pub fn new(connection_string: String, container_name: String) -> Self {
        Self {
            sas_ttl_as_iso8601: None,
            connection_string,
            container_name,
        }
    }
}
#[doc = "A container holding only the Tags for a resource, allowing the user to update the tags on an IoT Hub instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsResource {
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TagsResource {
    pub fn new() -> Self {
        Self::default()
    }
}
