#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<arm_identity::Type>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl ArmIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod arm_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmUserIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
}
impl ArmUserIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateBodyDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<String>,
}
impl CertificateBodyDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificateProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl CertificateDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateListDescription {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CertificateDescription>,
}
impl CertificateListDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiry: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(rename = "isVerified", default, skip_serializing_if = "Option::is_none")]
    pub is_verified: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<String>,
}
impl CertificateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificatePropertiesWithNonce {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiry: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(rename = "isVerified", default, skip_serializing_if = "Option::is_none")]
    pub is_verified: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "verificationCode", default, skip_serializing_if = "Option::is_none")]
    pub verification_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<String>,
}
impl CertificatePropertiesWithNonce {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateVerificationDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<String>,
}
impl CertificateVerificationDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateWithNonceDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificatePropertiesWithNonce>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl CertificateWithNonceDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudToDeviceProperties {
    #[serde(rename = "maxDeliveryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_delivery_count: Option<i32>,
    #[serde(rename = "defaultTtlAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub default_ttl_as_iso8601: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub feedback: Option<FeedbackProperties>,
}
impl CloudToDeviceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionPropertiesDescription {
    #[serde(rename = "keySource", default, skip_serializing_if = "Option::is_none")]
    pub key_source: Option<String>,
    #[serde(rename = "keyVaultProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub key_vault_properties: Vec<KeyVaultKeyProperties>,
}
impl EncryptionPropertiesDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointHealthData {
    #[serde(rename = "endpointId", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_id: Option<String>,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<endpoint_health_data::HealthStatus>,
    #[serde(rename = "lastKnownError", default, skip_serializing_if = "Option::is_none")]
    pub last_known_error: Option<String>,
    #[serde(rename = "lastKnownErrorTime", default, skip_serializing_if = "Option::is_none")]
    pub last_known_error_time: Option<String>,
    #[serde(rename = "lastSuccessfulSendAttemptTime", default, skip_serializing_if = "Option::is_none")]
    pub last_successful_send_attempt_time: Option<String>,
    #[serde(rename = "lastSendAttemptTime", default, skip_serializing_if = "Option::is_none")]
    pub last_send_attempt_time: Option<String>,
}
impl EndpointHealthData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod endpoint_health_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthStatus {
        #[serde(rename = "unknown")]
        Unknown,
        #[serde(rename = "healthy")]
        Healthy,
        #[serde(rename = "degraded")]
        Degraded,
        #[serde(rename = "unhealthy")]
        Unhealthy,
        #[serde(rename = "dead")]
        Dead,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointHealthDataListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EndpointHealthData>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EndpointHealthDataListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnrichmentProperties {
    pub key: String,
    pub value: String,
    #[serde(rename = "endpointNames")]
    pub endpoint_names: Vec<String>,
}
impl EnrichmentProperties {
    pub fn new(key: String, value: String, endpoint_names: Vec<String>) -> Self {
        Self {
            key,
            value,
            endpoint_names,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(rename = "httpStatusCode", default, skip_serializing_if = "Option::is_none")]
    pub http_status_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubConsumerGroupBodyDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EventHubConsumerGroupName>,
}
impl EventHubConsumerGroupBodyDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubConsumerGroupInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl EventHubConsumerGroupInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubConsumerGroupName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl EventHubConsumerGroupName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubConsumerGroupsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EventHubConsumerGroupInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EventHubConsumerGroupsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubProperties {
    #[serde(rename = "retentionTimeInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_time_in_days: Option<i64>,
    #[serde(rename = "partitionCount", default, skip_serializing_if = "Option::is_none")]
    pub partition_count: Option<i32>,
    #[serde(rename = "partitionIds", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_ids: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
}
impl EventHubProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportDevicesRequest {
    #[serde(rename = "exportBlobContainerUri")]
    pub export_blob_container_uri: String,
    #[serde(rename = "excludeKeys")]
    pub exclude_keys: bool,
    #[serde(rename = "exportBlobName", default, skip_serializing_if = "Option::is_none")]
    pub export_blob_name: Option<String>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<export_devices_request::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedIdentity>,
}
impl ExportDevicesRequest {
    pub fn new(export_blob_container_uri: String, exclude_keys: bool) -> Self {
        Self {
            export_blob_container_uri,
            exclude_keys,
            export_blob_name: None,
            authentication_type: None,
            identity: None,
        }
    }
}
pub mod export_devices_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        #[serde(rename = "keyBased")]
        KeyBased,
        #[serde(rename = "identityBased")]
        IdentityBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FailoverInput {
    #[serde(rename = "failoverRegion")]
    pub failover_region: String,
}
impl FailoverInput {
    pub fn new(failover_region: String) -> Self {
        Self { failover_region }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FallbackRouteProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    pub source: fallback_route_properties::Source,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub condition: Option<String>,
    #[serde(rename = "endpointNames")]
    pub endpoint_names: Vec<String>,
    #[serde(rename = "isEnabled")]
    pub is_enabled: bool,
}
impl FallbackRouteProperties {
    pub fn new(source: fallback_route_properties::Source, endpoint_names: Vec<String>, is_enabled: bool) -> Self {
        Self {
            name: None,
            source,
            condition: None,
            endpoint_names,
            is_enabled,
        }
    }
}
pub mod fallback_route_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        DeviceMessages,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FeedbackProperties {
    #[serde(rename = "lockDurationAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub lock_duration_as_iso8601: Option<String>,
    #[serde(rename = "ttlAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub ttl_as_iso8601: Option<String>,
    #[serde(rename = "maxDeliveryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_delivery_count: Option<i32>,
}
impl FeedbackProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GroupIdInformation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub properties: GroupIdInformationProperties,
}
impl GroupIdInformation {
    pub fn new(properties: GroupIdInformationProperties) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupIdInformationProperties {
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl GroupIdInformationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportDevicesRequest {
    #[serde(rename = "inputBlobContainerUri")]
    pub input_blob_container_uri: String,
    #[serde(rename = "outputBlobContainerUri")]
    pub output_blob_container_uri: String,
    #[serde(rename = "inputBlobName", default, skip_serializing_if = "Option::is_none")]
    pub input_blob_name: Option<String>,
    #[serde(rename = "outputBlobName", default, skip_serializing_if = "Option::is_none")]
    pub output_blob_name: Option<String>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<import_devices_request::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedIdentity>,
}
impl ImportDevicesRequest {
    pub fn new(input_blob_container_uri: String, output_blob_container_uri: String) -> Self {
        Self {
            input_blob_container_uri,
            output_blob_container_uri,
            input_blob_name: None,
            output_blob_name: None,
            authentication_type: None,
            identity: None,
        }
    }
}
pub mod import_devices_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        #[serde(rename = "keyBased")]
        KeyBased,
        #[serde(rename = "identityBased")]
        IdentityBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<i64>,
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<iot_hub_capacity::ScaleType>,
}
impl IotHubCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod iot_hub_capacity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScaleType {
        Automatic,
        Manual,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IotHubDescription {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IotHubProperties>,
    pub sku: IotHubSkuInfo,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ArmIdentity>,
}
impl IotHubDescription {
    pub fn new(resource: Resource, sku: IotHubSkuInfo) -> Self {
        Self {
            resource,
            etag: None,
            properties: None,
            sku,
            identity: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubDescriptionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IotHubDescription>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IotHubDescriptionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubLocationDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub role: Option<iot_hub_location_description::Role>,
}
impl IotHubLocationDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod iot_hub_location_description {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Role {
        #[serde(rename = "primary")]
        Primary,
        #[serde(rename = "secondary")]
        Secondary,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubNameAvailabilityInfo {
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<iot_hub_name_availability_info::Reason>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl IotHubNameAvailabilityInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod iot_hub_name_availability_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubProperties {
    #[serde(rename = "authorizationPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub authorization_policies: Vec<SharedAccessSignatureAuthorizationRule>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<iot_hub_properties::PublicNetworkAccess>,
    #[serde(rename = "ipFilterRules", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_filter_rules: Vec<IpFilterRule>,
    #[serde(rename = "networkRuleSets", default, skip_serializing_if = "Option::is_none")]
    pub network_rule_sets: Option<NetworkRuleSetProperties>,
    #[serde(rename = "minTlsVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_tls_version: Option<String>,
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "eventHubEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub event_hub_endpoints: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub routing: Option<RoutingProperties>,
    #[serde(rename = "storageEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub storage_endpoints: Option<serde_json::Value>,
    #[serde(rename = "messagingEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub messaging_endpoints: Option<serde_json::Value>,
    #[serde(rename = "enableFileUploadNotifications", default, skip_serializing_if = "Option::is_none")]
    pub enable_file_upload_notifications: Option<bool>,
    #[serde(rename = "cloudToDevice", default, skip_serializing_if = "Option::is_none")]
    pub cloud_to_device: Option<CloudToDeviceProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
    #[serde(rename = "deviceStreams", default, skip_serializing_if = "Option::is_none")]
    pub device_streams: Option<iot_hub_properties::DeviceStreams>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub features: Option<iot_hub_properties::Features>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionPropertiesDescription>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<IotHubLocationDescription>,
}
impl IotHubProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod iot_hub_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicNetworkAccess {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct DeviceStreams {
        #[serde(rename = "streamingEndpoints", default, skip_serializing_if = "Vec::is_empty")]
        pub streaming_endpoints: Vec<String>,
    }
    impl DeviceStreams {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Features {
        None,
        DeviceManagement,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubQuotaMetricInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[serde(rename = "maxValue", default, skip_serializing_if = "Option::is_none")]
    pub max_value: Option<i64>,
}
impl IotHubQuotaMetricInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubQuotaMetricInfoListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IotHubQuotaMetricInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IotHubQuotaMetricInfoListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IotHubSkuDescription {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    pub sku: IotHubSkuInfo,
    pub capacity: IotHubCapacity,
}
impl IotHubSkuDescription {
    pub fn new(sku: IotHubSkuInfo, capacity: IotHubCapacity) -> Self {
        Self {
            resource_type: None,
            sku,
            capacity,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubSkuDescriptionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IotHubSkuDescription>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IotHubSkuDescriptionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IotHubSkuInfo {
    pub name: iot_hub_sku_info::Name,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<iot_hub_sku_info::Tier>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i64>,
}
impl IotHubSkuInfo {
    pub fn new(name: iot_hub_sku_info::Name) -> Self {
        Self {
            name,
            tier: None,
            capacity: None,
        }
    }
}
pub mod iot_hub_sku_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        F1,
        S1,
        S2,
        S3,
        B1,
        B2,
        B3,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Free,
        Standard,
        Basic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpFilterRule {
    #[serde(rename = "filterName")]
    pub filter_name: String,
    pub action: ip_filter_rule::Action,
    #[serde(rename = "ipMask")]
    pub ip_mask: String,
}
impl IpFilterRule {
    pub fn new(filter_name: String, action: ip_filter_rule::Action, ip_mask: String) -> Self {
        Self {
            filter_name,
            action,
            ip_mask,
        }
    }
}
pub mod ip_filter_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Accept,
        Reject,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobResponse {
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "startTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub start_time_utc: Option<String>,
    #[serde(rename = "endTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub end_time_utc: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<job_response::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<job_response::Status>,
    #[serde(rename = "failureReason", default, skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    #[serde(rename = "statusMessage", default, skip_serializing_if = "Option::is_none")]
    pub status_message: Option<String>,
    #[serde(rename = "parentJobId", default, skip_serializing_if = "Option::is_none")]
    pub parent_job_id: Option<String>,
}
impl JobResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "unknown")]
        Unknown,
        #[serde(rename = "export")]
        Export,
        #[serde(rename = "import")]
        Import,
        #[serde(rename = "backup")]
        Backup,
        #[serde(rename = "readDeviceProperties")]
        ReadDeviceProperties,
        #[serde(rename = "writeDeviceProperties")]
        WriteDeviceProperties,
        #[serde(rename = "updateDeviceConfiguration")]
        UpdateDeviceConfiguration,
        #[serde(rename = "rebootDevice")]
        RebootDevice,
        #[serde(rename = "factoryResetDevice")]
        FactoryResetDevice,
        #[serde(rename = "firmwareUpdate")]
        FirmwareUpdate,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "unknown")]
        Unknown,
        #[serde(rename = "enqueued")]
        Enqueued,
        #[serde(rename = "running")]
        Running,
        #[serde(rename = "completed")]
        Completed,
        #[serde(rename = "failed")]
        Failed,
        #[serde(rename = "cancelled")]
        Cancelled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobResponseListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobResponse>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobResponseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultKeyProperties {
    #[serde(rename = "keyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub key_identifier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedIdentity>,
}
impl KeyVaultKeyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedIdentity {
    #[serde(rename = "userAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identity: Option<String>,
}
impl ManagedIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MatchedRoute {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteProperties>,
}
impl MatchedRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MessagingEndpointProperties {
    #[serde(rename = "lockDurationAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub lock_duration_as_iso8601: Option<String>,
    #[serde(rename = "ttlAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub ttl_as_iso8601: Option<String>,
    #[serde(rename = "maxDeliveryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_delivery_count: Option<i32>,
}
impl MessagingEndpointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Name {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl Name {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkRuleSetIpRule {
    #[serde(rename = "filterName")]
    pub filter_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<network_rule_set_ip_rule::Action>,
    #[serde(rename = "ipMask")]
    pub ip_mask: String,
}
impl NetworkRuleSetIpRule {
    pub fn new(filter_name: String, ip_mask: String) -> Self {
        Self {
            filter_name,
            action: None,
            ip_mask,
        }
    }
}
pub mod network_rule_set_ip_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Allow,
    }
    impl Default for Action {
        fn default() -> Self {
            Self::Allow
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkRuleSetProperties {
    #[serde(rename = "defaultAction", default, skip_serializing_if = "Option::is_none")]
    pub default_action: Option<network_rule_set_properties::DefaultAction>,
    #[serde(rename = "applyToBuiltInEventHubEndpoint")]
    pub apply_to_built_in_event_hub_endpoint: bool,
    #[serde(rename = "ipRules")]
    pub ip_rules: Vec<NetworkRuleSetIpRule>,
}
impl NetworkRuleSetProperties {
    pub fn new(apply_to_built_in_event_hub_endpoint: bool, ip_rules: Vec<NetworkRuleSetIpRule>) -> Self {
        Self {
            default_action: None,
            apply_to_built_in_event_hub_endpoint,
            ip_rules,
        }
    }
}
pub mod network_rule_set_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DefaultAction {
        Deny,
        Allow,
    }
    impl Default for DefaultAction {
        fn default() -> Self {
            Self::Deny
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationInputs {
    pub name: String,
}
impl OperationInputs {
    pub fn new(name: String) -> Self {
        Self { name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateEndpointConnection {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub properties: PrivateEndpointConnectionProperties,
}
impl PrivateEndpointConnection {
    pub fn new(properties: PrivateEndpointConnectionProperties) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateEndpointConnectionProperties {
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[serde(rename = "privateLinkServiceConnectionState")]
    pub private_link_service_connection_state: PrivateLinkServiceConnectionState,
}
impl PrivateEndpointConnectionProperties {
    pub fn new(private_link_service_connection_state: PrivateLinkServiceConnectionState) -> Self {
        Self {
            private_endpoint: None,
            private_link_service_connection_state,
        }
    }
}
pub type PrivateEndpointConnectionsList = Vec<PrivateEndpointConnection>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResources {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GroupIdInformation>,
}
impl PrivateLinkResources {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateLinkServiceConnectionState {
    pub status: private_link_service_connection_state::Status,
    pub description: String,
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new(status: private_link_service_connection_state::Status, description: String) -> Self {
        Self {
            status,
            description,
            actions_required: None,
        }
    }
}
pub mod private_link_service_connection_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Pending,
        Approved,
        Rejected,
        Disconnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryStatistics {
    #[serde(rename = "totalDeviceCount", default, skip_serializing_if = "Option::is_none")]
    pub total_device_count: Option<i64>,
    #[serde(rename = "enabledDeviceCount", default, skip_serializing_if = "Option::is_none")]
    pub enabled_device_count: Option<i64>,
    #[serde(rename = "disabledDeviceCount", default, skip_serializing_if = "Option::is_none")]
    pub disabled_device_count: Option<i64>,
}
impl RegistryStatistics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteCompilationError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<route_compilation_error::Severity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<RouteErrorRange>,
}
impl RouteCompilationError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod route_compilation_error {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        #[serde(rename = "error")]
        Error,
        #[serde(rename = "warning")]
        Warning,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteErrorPosition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub line: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub column: Option<i32>,
}
impl RouteErrorPosition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteErrorRange {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub start: Option<RouteErrorPosition>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub end: Option<RouteErrorPosition>,
}
impl RouteErrorRange {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RouteProperties {
    pub name: String,
    pub source: route_properties::Source,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub condition: Option<String>,
    #[serde(rename = "endpointNames")]
    pub endpoint_names: Vec<String>,
    #[serde(rename = "isEnabled")]
    pub is_enabled: bool,
}
impl RouteProperties {
    pub fn new(name: String, source: route_properties::Source, endpoint_names: Vec<String>, is_enabled: bool) -> Self {
        Self {
            name,
            source,
            condition: None,
            endpoint_names,
            is_enabled,
        }
    }
}
pub mod route_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        Invalid,
        DeviceMessages,
        TwinChangeEvents,
        DeviceLifecycleEvents,
        DeviceJobLifecycleEvents,
        DigitalTwinChangeEvents,
        DeviceConnectionStateEvents,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingEndpoints {
    #[serde(rename = "serviceBusQueues", default, skip_serializing_if = "Vec::is_empty")]
    pub service_bus_queues: Vec<RoutingServiceBusQueueEndpointProperties>,
    #[serde(rename = "serviceBusTopics", default, skip_serializing_if = "Vec::is_empty")]
    pub service_bus_topics: Vec<RoutingServiceBusTopicEndpointProperties>,
    #[serde(rename = "eventHubs", default, skip_serializing_if = "Vec::is_empty")]
    pub event_hubs: Vec<RoutingEventHubProperties>,
    #[serde(rename = "storageContainers", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_containers: Vec<RoutingStorageContainerProperties>,
}
impl RoutingEndpoints {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutingEventHubProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(rename = "endpointUri", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_uri: Option<String>,
    #[serde(rename = "entityPath", default, skip_serializing_if = "Option::is_none")]
    pub entity_path: Option<String>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<routing_event_hub_properties::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedIdentity>,
    pub name: String,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl RoutingEventHubProperties {
    pub fn new(name: String) -> Self {
        Self {
            id: None,
            connection_string: None,
            endpoint_uri: None,
            entity_path: None,
            authentication_type: None,
            identity: None,
            name,
            subscription_id: None,
            resource_group: None,
        }
    }
}
pub mod routing_event_hub_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        #[serde(rename = "keyBased")]
        KeyBased,
        #[serde(rename = "identityBased")]
        IdentityBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingMessage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    #[serde(rename = "appProperties", default, skip_serializing_if = "Option::is_none")]
    pub app_properties: Option<serde_json::Value>,
    #[serde(rename = "systemProperties", default, skip_serializing_if = "Option::is_none")]
    pub system_properties: Option<serde_json::Value>,
}
impl RoutingMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoints: Option<RoutingEndpoints>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<RouteProperties>,
    #[serde(rename = "fallbackRoute", default, skip_serializing_if = "Option::is_none")]
    pub fallback_route: Option<FallbackRouteProperties>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub enrichments: Vec<EnrichmentProperties>,
}
impl RoutingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutingServiceBusQueueEndpointProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(rename = "endpointUri", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_uri: Option<String>,
    #[serde(rename = "entityPath", default, skip_serializing_if = "Option::is_none")]
    pub entity_path: Option<String>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<routing_service_bus_queue_endpoint_properties::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedIdentity>,
    pub name: String,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl RoutingServiceBusQueueEndpointProperties {
    pub fn new(name: String) -> Self {
        Self {
            id: None,
            connection_string: None,
            endpoint_uri: None,
            entity_path: None,
            authentication_type: None,
            identity: None,
            name,
            subscription_id: None,
            resource_group: None,
        }
    }
}
pub mod routing_service_bus_queue_endpoint_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        #[serde(rename = "keyBased")]
        KeyBased,
        #[serde(rename = "identityBased")]
        IdentityBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutingServiceBusTopicEndpointProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(rename = "endpointUri", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_uri: Option<String>,
    #[serde(rename = "entityPath", default, skip_serializing_if = "Option::is_none")]
    pub entity_path: Option<String>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<routing_service_bus_topic_endpoint_properties::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedIdentity>,
    pub name: String,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl RoutingServiceBusTopicEndpointProperties {
    pub fn new(name: String) -> Self {
        Self {
            id: None,
            connection_string: None,
            endpoint_uri: None,
            entity_path: None,
            authentication_type: None,
            identity: None,
            name,
            subscription_id: None,
            resource_group: None,
        }
    }
}
pub mod routing_service_bus_topic_endpoint_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        #[serde(rename = "keyBased")]
        KeyBased,
        #[serde(rename = "identityBased")]
        IdentityBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutingStorageContainerProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(rename = "endpointUri", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_uri: Option<String>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<routing_storage_container_properties::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedIdentity>,
    pub name: String,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "fileNameFormat", default, skip_serializing_if = "Option::is_none")]
    pub file_name_format: Option<String>,
    #[serde(rename = "batchFrequencyInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub batch_frequency_in_seconds: Option<i32>,
    #[serde(rename = "maxChunkSizeInBytes", default, skip_serializing_if = "Option::is_none")]
    pub max_chunk_size_in_bytes: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encoding: Option<routing_storage_container_properties::Encoding>,
}
impl RoutingStorageContainerProperties {
    pub fn new(name: String, container_name: String) -> Self {
        Self {
            id: None,
            connection_string: None,
            endpoint_uri: None,
            authentication_type: None,
            identity: None,
            name,
            subscription_id: None,
            resource_group: None,
            container_name,
            file_name_format: None,
            batch_frequency_in_seconds: None,
            max_chunk_size_in_bytes: None,
            encoding: None,
        }
    }
}
pub mod routing_storage_container_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        #[serde(rename = "keyBased")]
        KeyBased,
        #[serde(rename = "identityBased")]
        IdentityBased,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Encoding {
        Avro,
        AvroDeflate,
        #[serde(rename = "JSON")]
        Json,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingTwin {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<routing_twin::Properties>,
}
impl RoutingTwin {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod routing_twin {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub desired: Option<serde_json::Value>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reported: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharedAccessSignatureAuthorizationRule {
    #[serde(rename = "keyName")]
    pub key_name: String,
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
    pub rights: shared_access_signature_authorization_rule::Rights,
}
impl SharedAccessSignatureAuthorizationRule {
    pub fn new(key_name: String, rights: shared_access_signature_authorization_rule::Rights) -> Self {
        Self {
            key_name,
            primary_key: None,
            secondary_key: None,
            rights,
        }
    }
}
pub mod shared_access_signature_authorization_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Rights {
        RegistryRead,
        RegistryWrite,
        ServiceConnect,
        DeviceConnect,
        #[serde(rename = "RegistryRead, RegistryWrite")]
        RegistryReadRegistryWrite,
        #[serde(rename = "RegistryRead, ServiceConnect")]
        RegistryReadServiceConnect,
        #[serde(rename = "RegistryRead, DeviceConnect")]
        RegistryReadDeviceConnect,
        #[serde(rename = "RegistryWrite, ServiceConnect")]
        RegistryWriteServiceConnect,
        #[serde(rename = "RegistryWrite, DeviceConnect")]
        RegistryWriteDeviceConnect,
        #[serde(rename = "ServiceConnect, DeviceConnect")]
        ServiceConnectDeviceConnect,
        #[serde(rename = "RegistryRead, RegistryWrite, ServiceConnect")]
        RegistryReadRegistryWriteServiceConnect,
        #[serde(rename = "RegistryRead, RegistryWrite, DeviceConnect")]
        RegistryReadRegistryWriteDeviceConnect,
        #[serde(rename = "RegistryRead, ServiceConnect, DeviceConnect")]
        RegistryReadServiceConnectDeviceConnect,
        #[serde(rename = "RegistryWrite, ServiceConnect, DeviceConnect")]
        RegistryWriteServiceConnectDeviceConnect,
        #[serde(rename = "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect")]
        RegistryReadRegistryWriteServiceConnectDeviceConnect,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharedAccessSignatureAuthorizationRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SharedAccessSignatureAuthorizationRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SharedAccessSignatureAuthorizationRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageEndpointProperties {
    #[serde(rename = "sasTtlAsIso8601", default, skip_serializing_if = "Option::is_none")]
    pub sas_ttl_as_iso8601: Option<String>,
    #[serde(rename = "connectionString")]
    pub connection_string: String,
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<storage_endpoint_properties::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedIdentity>,
}
impl StorageEndpointProperties {
    pub fn new(connection_string: String, container_name: String) -> Self {
        Self {
            sas_ttl_as_iso8601: None,
            connection_string,
            container_name,
            authentication_type: None,
            identity: None,
        }
    }
}
pub mod storage_endpoint_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        #[serde(rename = "keyBased")]
        KeyBased,
        #[serde(rename = "identityBased")]
        IdentityBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TagsResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestAllRoutesInput {
    #[serde(rename = "routingSource", default, skip_serializing_if = "Option::is_none")]
    pub routing_source: Option<test_all_routes_input::RoutingSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<RoutingMessage>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub twin: Option<RoutingTwin>,
}
impl TestAllRoutesInput {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod test_all_routes_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RoutingSource {
        Invalid,
        DeviceMessages,
        TwinChangeEvents,
        DeviceLifecycleEvents,
        DeviceJobLifecycleEvents,
        DigitalTwinChangeEvents,
        DeviceConnectionStateEvents,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestAllRoutesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<MatchedRoute>,
}
impl TestAllRoutesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestRouteInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<RoutingMessage>,
    pub route: RouteProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub twin: Option<RoutingTwin>,
}
impl TestRouteInput {
    pub fn new(route: RouteProperties) -> Self {
        Self {
            message: None,
            route,
            twin: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestRouteResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub result: Option<test_route_result::Result>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<TestRouteResultDetails>,
}
impl TestRouteResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod test_route_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Result {
        #[serde(rename = "undefined")]
        Undefined,
        #[serde(rename = "false")]
        False,
        #[serde(rename = "true")]
        True,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestRouteResultDetails {
    #[serde(rename = "compilationErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub compilation_errors: Vec<RouteCompilationError>,
}
impl TestRouteResultDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserSubscriptionQuota {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<Name>,
}
impl UserSubscriptionQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserSubscriptionQuotaListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<UserSubscriptionQuota>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UserSubscriptionQuotaListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
