#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdvancedFilter {
    #[serde(rename = "operatorType")]
    pub operator_type: advanced_filter::OperatorType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
}
impl AdvancedFilter {
    pub fn new(operator_type: advanced_filter::OperatorType) -> Self {
        Self { operator_type, key: None }
    }
}
pub mod advanced_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperatorType {
        NumberIn,
        NumberNotIn,
        NumberLessThan,
        NumberGreaterThan,
        NumberLessThanOrEquals,
        NumberGreaterThanOrEquals,
        BoolEquals,
        StringIn,
        StringNotIn,
        StringBeginsWith,
        StringEndsWith,
        StringContains,
        NumberInRange,
        NumberNotInRange,
        StringNotBeginsWith,
        StringNotEndsWith,
        StringNotContains,
        IsNullOrUndefined,
        IsNotNull,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFunctionEventSubscriptionDestination {
    #[serde(flatten)]
    pub event_subscription_destination: EventSubscriptionDestination,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFunctionEventSubscriptionDestinationProperties>,
}
impl AzureFunctionEventSubscriptionDestination {
    pub fn new(event_subscription_destination: EventSubscriptionDestination) -> Self {
        Self {
            event_subscription_destination,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFunctionEventSubscriptionDestinationProperties {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "maxEventsPerBatch", default, skip_serializing_if = "Option::is_none")]
    pub max_events_per_batch: Option<i32>,
    #[serde(rename = "preferredBatchSizeInKilobytes", default, skip_serializing_if = "Option::is_none")]
    pub preferred_batch_size_in_kilobytes: Option<i32>,
    #[serde(rename = "deliveryAttributeMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub delivery_attribute_mappings: Vec<DeliveryAttributeMapping>,
}
impl AzureFunctionEventSubscriptionDestinationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BoolEqualsAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<bool>,
}
impl BoolEqualsAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionState {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<connection_state::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl ConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Pending,
        Approved,
        Rejected,
        Disconnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeadLetterDestination {
    #[serde(rename = "endpointType")]
    pub endpoint_type: dead_letter_destination::EndpointType,
}
impl DeadLetterDestination {
    pub fn new(endpoint_type: dead_letter_destination::EndpointType) -> Self {
        Self { endpoint_type }
    }
}
pub mod dead_letter_destination {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EndpointType {
        StorageBlob,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeadLetterWithResourceIdentity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<EventSubscriptionIdentity>,
    #[serde(rename = "deadLetterDestination", default, skip_serializing_if = "Option::is_none")]
    pub dead_letter_destination: Option<DeadLetterDestination>,
}
impl DeadLetterWithResourceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeliveryAttributeListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DeliveryAttributeMapping>,
}
impl DeliveryAttributeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryAttributeMapping {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type")]
    pub type_: delivery_attribute_mapping::Type,
}
impl DeliveryAttributeMapping {
    pub fn new(type_: delivery_attribute_mapping::Type) -> Self {
        Self { name: None, type_ }
    }
}
pub mod delivery_attribute_mapping {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Static,
        Dynamic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeliveryWithResourceIdentity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<EventSubscriptionIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub destination: Option<EventSubscriptionDestination>,
}
impl DeliveryWithResourceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Domain {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DomainProperties>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityInfo>,
}
impl Domain {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
            system_data: None,
            identity: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainProperties {
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<domain_properties::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
    #[serde(rename = "inputSchema", default, skip_serializing_if = "Option::is_none")]
    pub input_schema: Option<domain_properties::InputSchema>,
    #[serde(rename = "inputSchemaMapping", default, skip_serializing_if = "Option::is_none")]
    pub input_schema_mapping: Option<InputSchemaMapping>,
    #[serde(rename = "metricResourceId", default, skip_serializing_if = "Option::is_none")]
    pub metric_resource_id: Option<String>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<domain_properties::PublicNetworkAccess>,
    #[serde(rename = "inboundIpRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_ip_rules: Vec<InboundIpRule>,
    #[serde(rename = "disableLocalAuth", default, skip_serializing_if = "Option::is_none")]
    pub disable_local_auth: Option<bool>,
    #[serde(rename = "autoCreateTopicWithFirstSubscription", default, skip_serializing_if = "Option::is_none")]
    pub auto_create_topic_with_first_subscription: Option<bool>,
    #[serde(rename = "autoDeleteTopicWithLastSubscription", default, skip_serializing_if = "Option::is_none")]
    pub auto_delete_topic_with_last_subscription: Option<bool>,
}
impl DomainProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod domain_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Canceled,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InputSchema {
        EventGridSchema,
        CustomEventSchema,
        #[serde(rename = "CloudEventSchemaV1_0")]
        CloudEventSchemaV10,
    }
    impl Default for InputSchema {
        fn default() -> Self {
            Self::EventGridSchema
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicNetworkAccess {
        Enabled,
        Disabled,
    }
    impl Default for PublicNetworkAccess {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DomainRegenerateKeyRequest {
    #[serde(rename = "keyName")]
    pub key_name: String,
}
impl DomainRegenerateKeyRequest {
    pub fn new(key_name: String) -> Self {
        Self { key_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainSharedAccessKeys {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key1: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key2: Option<String>,
}
impl DomainSharedAccessKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainTopic {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DomainTopicProperties>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl DomainTopic {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainTopicProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<domain_topic_properties::ProvisioningState>,
}
impl DomainTopicProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod domain_topic_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Canceled,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainTopicsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DomainTopic>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DomainTopicsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainUpdateParameterProperties {
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<domain_update_parameter_properties::PublicNetworkAccess>,
    #[serde(rename = "inboundIpRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_ip_rules: Vec<InboundIpRule>,
    #[serde(rename = "disableLocalAuth", default, skip_serializing_if = "Option::is_none")]
    pub disable_local_auth: Option<bool>,
    #[serde(rename = "autoCreateTopicWithFirstSubscription", default, skip_serializing_if = "Option::is_none")]
    pub auto_create_topic_with_first_subscription: Option<bool>,
    #[serde(rename = "autoDeleteTopicWithLastSubscription", default, skip_serializing_if = "Option::is_none")]
    pub auto_delete_topic_with_last_subscription: Option<bool>,
}
impl DomainUpdateParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod domain_update_parameter_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicNetworkAccess {
        Enabled,
        Disabled,
    }
    impl Default for PublicNetworkAccess {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DomainUpdateParameterProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityInfo>,
}
impl DomainUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Domain>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DomainsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicDeliveryAttributeMapping {
    #[serde(flatten)]
    pub delivery_attribute_mapping: DeliveryAttributeMapping,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DynamicDeliveryAttributeMappingProperties>,
}
impl DynamicDeliveryAttributeMapping {
    pub fn new(delivery_attribute_mapping: DeliveryAttributeMapping) -> Self {
        Self {
            delivery_attribute_mapping,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DynamicDeliveryAttributeMappingProperties {
    #[serde(rename = "sourceField", default, skip_serializing_if = "Option::is_none")]
    pub source_field: Option<String>,
}
impl DynamicDeliveryAttributeMappingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventHubEventSubscriptionDestination {
    #[serde(flatten)]
    pub event_subscription_destination: EventSubscriptionDestination,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EventHubEventSubscriptionDestinationProperties>,
}
impl EventHubEventSubscriptionDestination {
    pub fn new(event_subscription_destination: EventSubscriptionDestination) -> Self {
        Self {
            event_subscription_destination,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubEventSubscriptionDestinationProperties {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "deliveryAttributeMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub delivery_attribute_mappings: Vec<DeliveryAttributeMapping>,
}
impl EventHubEventSubscriptionDestinationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSubscription {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EventSubscriptionProperties>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl EventSubscription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventSubscriptionDestination {
    #[serde(rename = "endpointType")]
    pub endpoint_type: event_subscription_destination::EndpointType,
}
impl EventSubscriptionDestination {
    pub fn new(endpoint_type: event_subscription_destination::EndpointType) -> Self {
        Self { endpoint_type }
    }
}
pub mod event_subscription_destination {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EndpointType {
        WebHook,
        EventHub,
        StorageQueue,
        HybridConnection,
        ServiceBusQueue,
        ServiceBusTopic,
        AzureFunction,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSubscriptionFilter {
    #[serde(rename = "subjectBeginsWith", default, skip_serializing_if = "Option::is_none")]
    pub subject_begins_with: Option<String>,
    #[serde(rename = "subjectEndsWith", default, skip_serializing_if = "Option::is_none")]
    pub subject_ends_with: Option<String>,
    #[serde(rename = "includedEventTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub included_event_types: Vec<String>,
    #[serde(rename = "isSubjectCaseSensitive", default, skip_serializing_if = "Option::is_none")]
    pub is_subject_case_sensitive: Option<bool>,
    #[serde(rename = "enableAdvancedFilteringOnArrays", default, skip_serializing_if = "Option::is_none")]
    pub enable_advanced_filtering_on_arrays: Option<bool>,
    #[serde(rename = "advancedFilters", default, skip_serializing_if = "Vec::is_empty")]
    pub advanced_filters: Vec<AdvancedFilter>,
}
impl EventSubscriptionFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSubscriptionFullUrl {
    #[serde(rename = "endpointUrl", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_url: Option<String>,
}
impl EventSubscriptionFullUrl {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSubscriptionIdentity {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<event_subscription_identity::Type>,
    #[serde(rename = "userAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identity: Option<String>,
}
impl EventSubscriptionIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod event_subscription_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSubscriptionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub topic: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<event_subscription_properties::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub destination: Option<EventSubscriptionDestination>,
    #[serde(rename = "deliveryWithResourceIdentity", default, skip_serializing_if = "Option::is_none")]
    pub delivery_with_resource_identity: Option<DeliveryWithResourceIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<EventSubscriptionFilter>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<String>,
    #[serde(rename = "expirationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time_utc: Option<String>,
    #[serde(rename = "eventDeliverySchema", default, skip_serializing_if = "Option::is_none")]
    pub event_delivery_schema: Option<event_subscription_properties::EventDeliverySchema>,
    #[serde(rename = "retryPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retry_policy: Option<RetryPolicy>,
    #[serde(rename = "deadLetterDestination", default, skip_serializing_if = "Option::is_none")]
    pub dead_letter_destination: Option<DeadLetterDestination>,
    #[serde(rename = "deadLetterWithResourceIdentity", default, skip_serializing_if = "Option::is_none")]
    pub dead_letter_with_resource_identity: Option<DeadLetterWithResourceIdentity>,
}
impl EventSubscriptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod event_subscription_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Canceled,
        Failed,
        AwaitingManualAction,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EventDeliverySchema {
        EventGridSchema,
        CustomInputSchema,
        #[serde(rename = "CloudEventSchemaV1_0")]
        CloudEventSchemaV10,
    }
    impl Default for EventDeliverySchema {
        fn default() -> Self {
            Self::EventGridSchema
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSubscriptionUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub destination: Option<EventSubscriptionDestination>,
    #[serde(rename = "deliveryWithResourceIdentity", default, skip_serializing_if = "Option::is_none")]
    pub delivery_with_resource_identity: Option<DeliveryWithResourceIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<EventSubscriptionFilter>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<String>,
    #[serde(rename = "expirationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time_utc: Option<String>,
    #[serde(rename = "eventDeliverySchema", default, skip_serializing_if = "Option::is_none")]
    pub event_delivery_schema: Option<event_subscription_update_parameters::EventDeliverySchema>,
    #[serde(rename = "retryPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retry_policy: Option<RetryPolicy>,
    #[serde(rename = "deadLetterDestination", default, skip_serializing_if = "Option::is_none")]
    pub dead_letter_destination: Option<DeadLetterDestination>,
    #[serde(rename = "deadLetterWithResourceIdentity", default, skip_serializing_if = "Option::is_none")]
    pub dead_letter_with_resource_identity: Option<DeadLetterWithResourceIdentity>,
}
impl EventSubscriptionUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod event_subscription_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EventDeliverySchema {
        EventGridSchema,
        CustomInputSchema,
        #[serde(rename = "CloudEventSchemaV1_0")]
        CloudEventSchemaV10,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSubscriptionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EventSubscription>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EventSubscriptionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventType {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EventTypeProperties>,
}
impl EventType {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventTypeProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "schemaUrl", default, skip_serializing_if = "Option::is_none")]
    pub schema_url: Option<String>,
    #[serde(rename = "isInDefaultSet", default, skip_serializing_if = "Option::is_none")]
    pub is_in_default_set: Option<bool>,
}
impl EventTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventTypesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EventType>,
}
impl EventTypesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtensionTopic {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExtensionTopicProperties>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ExtensionTopic {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtensionTopicProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "systemTopic", default, skip_serializing_if = "Option::is_none")]
    pub system_topic: Option<String>,
}
impl ExtensionTopicProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HybridConnectionEventSubscriptionDestination {
    #[serde(flatten)]
    pub event_subscription_destination: EventSubscriptionDestination,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HybridConnectionEventSubscriptionDestinationProperties>,
}
impl HybridConnectionEventSubscriptionDestination {
    pub fn new(event_subscription_destination: EventSubscriptionDestination) -> Self {
        Self {
            event_subscription_destination,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HybridConnectionEventSubscriptionDestinationProperties {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "deliveryAttributeMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub delivery_attribute_mappings: Vec<DeliveryAttributeMapping>,
}
impl HybridConnectionEventSubscriptionDestinationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity_info::Type>,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl IdentityInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        None,
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundIpRule {
    #[serde(rename = "ipMask", default, skip_serializing_if = "Option::is_none")]
    pub ip_mask: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<inbound_ip_rule::Action>,
}
impl InboundIpRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod inbound_ip_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Allow,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InputSchemaMapping {
    #[serde(rename = "inputSchemaMappingType")]
    pub input_schema_mapping_type: input_schema_mapping::InputSchemaMappingType,
}
impl InputSchemaMapping {
    pub fn new(input_schema_mapping_type: input_schema_mapping::InputSchemaMappingType) -> Self {
        Self { input_schema_mapping_type }
    }
}
pub mod input_schema_mapping {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InputSchemaMappingType {
        Json,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IsNotNullAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
}
impl IsNotNullAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self { advanced_filter }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IsNullOrUndefinedAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
}
impl IsNullOrUndefinedAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self { advanced_filter }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JsonField {
    #[serde(rename = "sourceField", default, skip_serializing_if = "Option::is_none")]
    pub source_field: Option<String>,
}
impl JsonField {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JsonFieldWithDefault {
    #[serde(rename = "sourceField", default, skip_serializing_if = "Option::is_none")]
    pub source_field: Option<String>,
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<String>,
}
impl JsonFieldWithDefault {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonInputSchemaMapping {
    #[serde(flatten)]
    pub input_schema_mapping: InputSchemaMapping,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JsonInputSchemaMappingProperties>,
}
impl JsonInputSchemaMapping {
    pub fn new(input_schema_mapping: InputSchemaMapping) -> Self {
        Self {
            input_schema_mapping,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JsonInputSchemaMappingProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<JsonField>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub topic: Option<JsonField>,
    #[serde(rename = "eventTime", default, skip_serializing_if = "Option::is_none")]
    pub event_time: Option<JsonField>,
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<JsonFieldWithDefault>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<JsonFieldWithDefault>,
    #[serde(rename = "dataVersion", default, skip_serializing_if = "Option::is_none")]
    pub data_version: Option<JsonFieldWithDefault>,
}
impl JsonInputSchemaMappingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NumberGreaterThanAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
}
impl NumberGreaterThanAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NumberGreaterThanOrEqualsAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
}
impl NumberGreaterThanOrEqualsAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NumberInAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<f64>,
}
impl NumberInAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NumberInRangeAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<Vec<f64>>,
}
impl NumberInRangeAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NumberLessThanAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
}
impl NumberLessThanAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NumberLessThanOrEqualsAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
}
impl NumberLessThanOrEqualsAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NumberNotInAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<f64>,
}
impl NumberNotInAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NumberNotInRangeAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<Vec<f64>>,
}
impl NumberNotInRangeAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
}
impl OperationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnectionProperties>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpointConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateEndpointConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionProperties {
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[serde(rename = "groupIds", default, skip_serializing_if = "Vec::is_empty")]
    pub group_ids: Vec<String>,
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<ConnectionState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<private_endpoint_connection_properties::ProvisioningState>,
}
impl PrivateEndpointConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod private_endpoint_connection_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Canceled,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkResourceProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl PrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceProperties {
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl PrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourcesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateLinkResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateLinkResourcesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetryPolicy {
    #[serde(rename = "maxDeliveryAttempts", default, skip_serializing_if = "Option::is_none")]
    pub max_delivery_attempts: Option<i32>,
    #[serde(rename = "eventTimeToLiveInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub event_time_to_live_in_minutes: Option<i32>,
}
impl RetryPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceBusQueueEventSubscriptionDestination {
    #[serde(flatten)]
    pub event_subscription_destination: EventSubscriptionDestination,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceBusQueueEventSubscriptionDestinationProperties>,
}
impl ServiceBusQueueEventSubscriptionDestination {
    pub fn new(event_subscription_destination: EventSubscriptionDestination) -> Self {
        Self {
            event_subscription_destination,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusQueueEventSubscriptionDestinationProperties {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "deliveryAttributeMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub delivery_attribute_mappings: Vec<DeliveryAttributeMapping>,
}
impl ServiceBusQueueEventSubscriptionDestinationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceBusTopicEventSubscriptionDestination {
    #[serde(flatten)]
    pub event_subscription_destination: EventSubscriptionDestination,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceBusTopicEventSubscriptionDestinationProperties>,
}
impl ServiceBusTopicEventSubscriptionDestination {
    pub fn new(event_subscription_destination: EventSubscriptionDestination) -> Self {
        Self {
            event_subscription_destination,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusTopicEventSubscriptionDestinationProperties {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "deliveryAttributeMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub delivery_attribute_mappings: Vec<DeliveryAttributeMapping>,
}
impl ServiceBusTopicEventSubscriptionDestinationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StaticDeliveryAttributeMapping {
    #[serde(flatten)]
    pub delivery_attribute_mapping: DeliveryAttributeMapping,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StaticDeliveryAttributeMappingProperties>,
}
impl StaticDeliveryAttributeMapping {
    pub fn new(delivery_attribute_mapping: DeliveryAttributeMapping) -> Self {
        Self {
            delivery_attribute_mapping,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StaticDeliveryAttributeMappingProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "isSecret", default, skip_serializing_if = "Option::is_none")]
    pub is_secret: Option<bool>,
}
impl StaticDeliveryAttributeMappingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageBlobDeadLetterDestination {
    #[serde(flatten)]
    pub dead_letter_destination: DeadLetterDestination,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StorageBlobDeadLetterDestinationProperties>,
}
impl StorageBlobDeadLetterDestination {
    pub fn new(dead_letter_destination: DeadLetterDestination) -> Self {
        Self {
            dead_letter_destination,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageBlobDeadLetterDestinationProperties {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "blobContainerName", default, skip_serializing_if = "Option::is_none")]
    pub blob_container_name: Option<String>,
}
impl StorageBlobDeadLetterDestinationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageQueueEventSubscriptionDestination {
    #[serde(flatten)]
    pub event_subscription_destination: EventSubscriptionDestination,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StorageQueueEventSubscriptionDestinationProperties>,
}
impl StorageQueueEventSubscriptionDestination {
    pub fn new(event_subscription_destination: EventSubscriptionDestination) -> Self {
        Self {
            event_subscription_destination,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageQueueEventSubscriptionDestinationProperties {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "queueName", default, skip_serializing_if = "Option::is_none")]
    pub queue_name: Option<String>,
    #[serde(rename = "queueMessageTimeToLiveInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub queue_message_time_to_live_in_seconds: Option<i64>,
}
impl StorageQueueEventSubscriptionDestinationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StringBeginsWithAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl StringBeginsWithAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StringContainsAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl StringContainsAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StringEndsWithAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl StringEndsWithAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StringInAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl StringInAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StringNotBeginsWithAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl StringNotBeginsWithAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StringNotContainsAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl StringNotContainsAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StringNotEndsWithAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl StringNotEndsWithAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StringNotInAdvancedFilter {
    #[serde(flatten)]
    pub advanced_filter: AdvancedFilter,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl StringNotInAdvancedFilter {
    pub fn new(advanced_filter: AdvancedFilter) -> Self {
        Self {
            advanced_filter,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SystemTopic {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SystemTopicProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityInfo>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl SystemTopic {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
            identity: None,
            system_data: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemTopicProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<system_topic_properties::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[serde(rename = "topicType", default, skip_serializing_if = "Option::is_none")]
    pub topic_type: Option<String>,
    #[serde(rename = "metricResourceId", default, skip_serializing_if = "Option::is_none")]
    pub metric_resource_id: Option<String>,
}
impl SystemTopicProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_topic_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Canceled,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemTopicUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityInfo>,
}
impl SystemTopicUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemTopicsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SystemTopic>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SystemTopicsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Topic {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TopicProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityInfo>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl Topic {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
            identity: None,
            system_data: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopicProperties {
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<topic_properties::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
    #[serde(rename = "inputSchema", default, skip_serializing_if = "Option::is_none")]
    pub input_schema: Option<topic_properties::InputSchema>,
    #[serde(rename = "inputSchemaMapping", default, skip_serializing_if = "Option::is_none")]
    pub input_schema_mapping: Option<InputSchemaMapping>,
    #[serde(rename = "metricResourceId", default, skip_serializing_if = "Option::is_none")]
    pub metric_resource_id: Option<String>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<topic_properties::PublicNetworkAccess>,
    #[serde(rename = "inboundIpRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_ip_rules: Vec<InboundIpRule>,
    #[serde(rename = "disableLocalAuth", default, skip_serializing_if = "Option::is_none")]
    pub disable_local_auth: Option<bool>,
}
impl TopicProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod topic_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Canceled,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InputSchema {
        EventGridSchema,
        CustomEventSchema,
        #[serde(rename = "CloudEventSchemaV1_0")]
        CloudEventSchemaV10,
    }
    impl Default for InputSchema {
        fn default() -> Self {
            Self::EventGridSchema
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicNetworkAccess {
        Enabled,
        Disabled,
    }
    impl Default for PublicNetworkAccess {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TopicRegenerateKeyRequest {
    #[serde(rename = "keyName")]
    pub key_name: String,
}
impl TopicRegenerateKeyRequest {
    pub fn new(key_name: String) -> Self {
        Self { key_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopicSharedAccessKeys {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key1: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key2: Option<String>,
}
impl TopicSharedAccessKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopicTypeInfo {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TopicTypeProperties>,
}
impl TopicTypeInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopicTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "resourceRegionType", default, skip_serializing_if = "Option::is_none")]
    pub resource_region_type: Option<topic_type_properties::ResourceRegionType>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<topic_type_properties::ProvisioningState>,
    #[serde(rename = "supportedLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_locations: Vec<String>,
    #[serde(rename = "sourceResourceFormat", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_format: Option<String>,
    #[serde(rename = "supportedScopesForSource", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_scopes_for_source: Vec<String>,
}
impl TopicTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod topic_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceRegionType {
        RegionalResource,
        GlobalResource,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Canceled,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopicTypesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TopicTypeInfo>,
}
impl TopicTypesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopicUpdateParameterProperties {
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<topic_update_parameter_properties::PublicNetworkAccess>,
    #[serde(rename = "inboundIpRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_ip_rules: Vec<InboundIpRule>,
    #[serde(rename = "disableLocalAuth", default, skip_serializing_if = "Option::is_none")]
    pub disable_local_auth: Option<bool>,
}
impl TopicUpdateParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod topic_update_parameter_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicNetworkAccess {
        Enabled,
        Disabled,
    }
    impl Default for PublicNetworkAccess {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopicUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TopicUpdateParameterProperties>,
}
impl TopicUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopicsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Topic>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TopicsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentityProperties {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
}
impl UserIdentityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebHookEventSubscriptionDestination {
    #[serde(flatten)]
    pub event_subscription_destination: EventSubscriptionDestination,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WebHookEventSubscriptionDestinationProperties>,
}
impl WebHookEventSubscriptionDestination {
    pub fn new(event_subscription_destination: EventSubscriptionDestination) -> Self {
        Self {
            event_subscription_destination,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebHookEventSubscriptionDestinationProperties {
    #[serde(rename = "endpointUrl", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_url: Option<String>,
    #[serde(rename = "endpointBaseUrl", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_base_url: Option<String>,
    #[serde(rename = "maxEventsPerBatch", default, skip_serializing_if = "Option::is_none")]
    pub max_events_per_batch: Option<i32>,
    #[serde(rename = "preferredBatchSizeInKilobytes", default, skip_serializing_if = "Option::is_none")]
    pub preferred_batch_size_in_kilobytes: Option<i32>,
    #[serde(rename = "azureActiveDirectoryTenantId", default, skip_serializing_if = "Option::is_none")]
    pub azure_active_directory_tenant_id: Option<String>,
    #[serde(
        rename = "azureActiveDirectoryApplicationIdOrUri",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub azure_active_directory_application_id_or_uri: Option<String>,
    #[serde(rename = "deliveryAttributeMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub delivery_attribute_mappings: Vec<DeliveryAttributeMapping>,
}
impl WebHookEventSubscriptionDestinationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
