#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicableSchedule {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: ApplicableScheduleProperties,
}
impl ApplicableSchedule {
    pub fn new(properties: ApplicableScheduleProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicableScheduleFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl ApplicableScheduleFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicableScheduleProperties {
    #[serde(rename = "labVmsShutdown", default, skip_serializing_if = "Option::is_none")]
    pub lab_vms_shutdown: Option<Schedule>,
    #[serde(rename = "labVmsStartup", default, skip_serializing_if = "Option::is_none")]
    pub lab_vms_startup: Option<Schedule>,
}
impl ApplicableScheduleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicableSchedulePropertiesFragment {}
impl ApplicableSchedulePropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplyArtifactsRequest {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub artifacts: Vec<ArtifactInstallProperties>,
}
impl ApplyArtifactsRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ArmTemplate {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: ArmTemplateProperties,
}
impl ArmTemplate {
    pub fn new(properties: ArmTemplateProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmTemplateInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub template: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
}
impl ArmTemplateInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmTemplateList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ArmTemplate>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ArmTemplateList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmTemplateParameterProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ArmTemplateParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmTemplateParameterPropertiesFragment {}
impl ArmTemplateParameterPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmTemplateProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub icon: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub contents: Option<serde_json::Value>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "parametersValueFilesInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub parameters_value_files_info: Vec<ParametersValueFileInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl ArmTemplateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Artifact {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: ArtifactProperties,
}
impl Artifact {
    pub fn new(properties: ArtifactProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactDeploymentStatusProperties {
    #[serde(rename = "deploymentStatus", default, skip_serializing_if = "Option::is_none")]
    pub deployment_status: Option<String>,
    #[serde(rename = "artifactsApplied", default, skip_serializing_if = "Option::is_none")]
    pub artifacts_applied: Option<i32>,
    #[serde(rename = "totalArtifacts", default, skip_serializing_if = "Option::is_none")]
    pub total_artifacts: Option<i32>,
}
impl ArtifactDeploymentStatusProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactDeploymentStatusPropertiesFragment {}
impl ArtifactDeploymentStatusPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactInstallProperties {
    #[serde(rename = "artifactId", default, skip_serializing_if = "Option::is_none")]
    pub artifact_id: Option<String>,
    #[serde(rename = "artifactTitle", default, skip_serializing_if = "Option::is_none")]
    pub artifact_title: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<ArtifactParameterProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "deploymentStatusMessage", default, skip_serializing_if = "Option::is_none")]
    pub deployment_status_message: Option<String>,
    #[serde(rename = "vmExtensionStatusMessage", default, skip_serializing_if = "Option::is_none")]
    pub vm_extension_status_message: Option<String>,
    #[serde(rename = "installTime", default, skip_serializing_if = "Option::is_none")]
    pub install_time: Option<String>,
}
impl ArtifactInstallProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactInstallPropertiesFragment {}
impl ArtifactInstallPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Artifact>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ArtifactList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactParameterProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ArtifactParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactParameterPropertiesFragment {}
impl ArtifactParameterPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(rename = "filePath", default, skip_serializing_if = "Option::is_none")]
    pub file_path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub icon: Option<String>,
    #[serde(rename = "targetOsType", default, skip_serializing_if = "Option::is_none")]
    pub target_os_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
}
impl ArtifactProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ArtifactSource {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: ArtifactSourceProperties,
}
impl ArtifactSource {
    pub fn new(properties: ArtifactSourceProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactSourceFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl ArtifactSourceFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactSourceList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ArtifactSource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ArtifactSourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactSourceProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
    #[serde(rename = "sourceType", default, skip_serializing_if = "Option::is_none")]
    pub source_type: Option<artifact_source_properties::SourceType>,
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<String>,
    #[serde(rename = "armTemplateFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub arm_template_folder_path: Option<String>,
    #[serde(rename = "branchRef", default, skip_serializing_if = "Option::is_none")]
    pub branch_ref: Option<String>,
    #[serde(rename = "securityToken", default, skip_serializing_if = "Option::is_none")]
    pub security_token: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<artifact_source_properties::Status>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl ArtifactSourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod artifact_source_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceType {
        VsoGit,
        GitHub,
        StorageAccount,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactSourcePropertiesFragment {}
impl ArtifactSourcePropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AttachDiskProperties {
    #[serde(rename = "leasedByLabVmId", default, skip_serializing_if = "Option::is_none")]
    pub leased_by_lab_vm_id: Option<String>,
}
impl AttachDiskProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AttachNewDataDiskOptions {
    #[serde(rename = "diskSizeGiB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gi_b: Option<i32>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<attach_new_data_disk_options::DiskType>,
}
impl AttachNewDataDiskOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod attach_new_data_disk_options {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        Standard,
        Premium,
        #[serde(rename = "StandardSSD")]
        StandardSsd,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AttachNewDataDiskOptionsFragment {}
impl AttachNewDataDiskOptionsFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BulkCreationParameters {
    #[serde(rename = "instanceCount", default, skip_serializing_if = "Option::is_none")]
    pub instance_count: Option<i32>,
}
impl BulkCreationParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BulkCreationParametersFragment {}
impl BulkCreationParametersFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeDataDisk {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "diskUri", default, skip_serializing_if = "Option::is_none")]
    pub disk_uri: Option<String>,
    #[serde(rename = "managedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk_id: Option<String>,
    #[serde(rename = "diskSizeGiB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gi_b: Option<i32>,
}
impl ComputeDataDisk {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeDataDiskFragment {}
impl ComputeDataDiskFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeVmInstanceViewStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(rename = "displayStatus", default, skip_serializing_if = "Option::is_none")]
    pub display_status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ComputeVmInstanceViewStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeVmInstanceViewStatusFragment {}
impl ComputeVmInstanceViewStatusFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeVmProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<ComputeVmInstanceViewStatus>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<String>,
    #[serde(rename = "networkInterfaceId", default, skip_serializing_if = "Option::is_none")]
    pub network_interface_id: Option<String>,
    #[serde(rename = "osDiskId", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_id: Option<String>,
    #[serde(rename = "dataDiskIds", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disk_ids: Vec<String>,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<ComputeDataDisk>,
}
impl ComputeVmProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeVmPropertiesFragment {}
impl ComputeVmPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CostThresholdProperties {
    #[serde(rename = "thresholdId", default, skip_serializing_if = "Option::is_none")]
    pub threshold_id: Option<String>,
    #[serde(rename = "percentageThreshold", default, skip_serializing_if = "Option::is_none")]
    pub percentage_threshold: Option<PercentageCostThresholdProperties>,
    #[serde(rename = "displayOnChart", default, skip_serializing_if = "Option::is_none")]
    pub display_on_chart: Option<cost_threshold_properties::DisplayOnChart>,
    #[serde(rename = "sendNotificationWhenExceeded", default, skip_serializing_if = "Option::is_none")]
    pub send_notification_when_exceeded: Option<cost_threshold_properties::SendNotificationWhenExceeded>,
    #[serde(rename = "notificationSent", default, skip_serializing_if = "Option::is_none")]
    pub notification_sent: Option<String>,
}
impl CostThresholdProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod cost_threshold_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DisplayOnChart {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SendNotificationWhenExceeded {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomImage {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: CustomImageProperties,
}
impl CustomImage {
    pub fn new(properties: CustomImageProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomImageFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl CustomImageFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomImageList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CustomImage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CustomImageList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomImageProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vm: Option<CustomImagePropertiesFromVm>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vhd: Option<CustomImagePropertiesCustom>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<String>,
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[serde(rename = "managedImageId", default, skip_serializing_if = "Option::is_none")]
    pub managed_image_id: Option<String>,
    #[serde(rename = "managedSnapshotId", default, skip_serializing_if = "Option::is_none")]
    pub managed_snapshot_id: Option<String>,
    #[serde(rename = "dataDiskStorageInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disk_storage_info: Vec<DataDiskStorageTypeInfo>,
    #[serde(rename = "customImagePlan", default, skip_serializing_if = "Option::is_none")]
    pub custom_image_plan: Option<CustomImagePropertiesFromPlan>,
    #[serde(rename = "isPlanAuthorized", default, skip_serializing_if = "Option::is_none")]
    pub is_plan_authorized: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl CustomImageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomImagePropertiesCustom {
    #[serde(rename = "imageName", default, skip_serializing_if = "Option::is_none")]
    pub image_name: Option<String>,
    #[serde(rename = "sysPrep", default, skip_serializing_if = "Option::is_none")]
    pub sys_prep: Option<bool>,
    #[serde(rename = "osType")]
    pub os_type: custom_image_properties_custom::OsType,
}
impl CustomImagePropertiesCustom {
    pub fn new(os_type: custom_image_properties_custom::OsType) -> Self {
        Self {
            image_name: None,
            sys_prep: None,
            os_type,
        }
    }
}
pub mod custom_image_properties_custom {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomImagePropertiesCustomFragment {}
impl CustomImagePropertiesCustomFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomImagePropertiesFragment {}
impl CustomImagePropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomImagePropertiesFromPlan {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
}
impl CustomImagePropertiesFromPlan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomImagePropertiesFromPlanFragment {}
impl CustomImagePropertiesFromPlanFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomImagePropertiesFromVm {
    #[serde(rename = "sourceVmId", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_id: Option<String>,
    #[serde(rename = "windowsOsInfo", default, skip_serializing_if = "Option::is_none")]
    pub windows_os_info: Option<WindowsOsInfo>,
    #[serde(rename = "linuxOsInfo", default, skip_serializing_if = "Option::is_none")]
    pub linux_os_info: Option<LinuxOsInfo>,
}
impl CustomImagePropertiesFromVm {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomImagePropertiesFromVmFragment {}
impl CustomImagePropertiesFromVmFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataDiskProperties {
    #[serde(rename = "attachNewDataDiskOptions", default, skip_serializing_if = "Option::is_none")]
    pub attach_new_data_disk_options: Option<AttachNewDataDiskOptions>,
    #[serde(rename = "existingLabDiskId", default, skip_serializing_if = "Option::is_none")]
    pub existing_lab_disk_id: Option<String>,
    #[serde(rename = "hostCaching", default, skip_serializing_if = "Option::is_none")]
    pub host_caching: Option<data_disk_properties::HostCaching>,
}
impl DataDiskProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_disk_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HostCaching {
        None,
        ReadOnly,
        ReadWrite,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataDiskPropertiesFragment {}
impl DataDiskPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataDiskStorageTypeInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub lun: Option<String>,
    #[serde(rename = "storageType", default, skip_serializing_if = "Option::is_none")]
    pub storage_type: Option<data_disk_storage_type_info::StorageType>,
}
impl DataDiskStorageTypeInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_disk_storage_type_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageType {
        Standard,
        Premium,
        #[serde(rename = "StandardSSD")]
        StandardSsd,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataDiskStorageTypeInfoFragment {}
impl DataDiskStorageTypeInfoFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DayDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
}
impl DayDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DayDetailsFragment {}
impl DayDetailsFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetachDataDiskProperties {
    #[serde(rename = "existingLabDiskId", default, skip_serializing_if = "Option::is_none")]
    pub existing_lab_disk_id: Option<String>,
}
impl DetachDataDiskProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetachDiskProperties {
    #[serde(rename = "leasedByLabVmId", default, skip_serializing_if = "Option::is_none")]
    pub leased_by_lab_vm_id: Option<String>,
}
impl DetachDiskProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Disk {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: DiskProperties,
}
impl Disk {
    pub fn new(properties: DiskProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl DiskFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Disk>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiskList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskProperties {
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<disk_properties::DiskType>,
    #[serde(rename = "diskSizeGiB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gi_b: Option<i32>,
    #[serde(rename = "leasedByLabVmId", default, skip_serializing_if = "Option::is_none")]
    pub leased_by_lab_vm_id: Option<String>,
    #[serde(rename = "diskBlobName", default, skip_serializing_if = "Option::is_none")]
    pub disk_blob_name: Option<String>,
    #[serde(rename = "diskUri", default, skip_serializing_if = "Option::is_none")]
    pub disk_uri: Option<String>,
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "hostCaching", default, skip_serializing_if = "Option::is_none")]
    pub host_caching: Option<String>,
    #[serde(rename = "managedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk_id: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl DiskProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod disk_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        Standard,
        Premium,
        #[serde(rename = "StandardSSD")]
        StandardSsd,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskPropertiesFragment {}
impl DiskPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DtlEnvironment {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: EnvironmentProperties,
}
impl DtlEnvironment {
    pub fn new(properties: EnvironmentProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DtlEnvironmentFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl DtlEnvironmentFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DtlEnvironmentList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DtlEnvironment>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DtlEnvironmentList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentDeploymentProperties {
    #[serde(rename = "armTemplateId", default, skip_serializing_if = "Option::is_none")]
    pub arm_template_id: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<ArmTemplateParameterProperties>,
}
impl EnvironmentDeploymentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentDeploymentPropertiesFragment {}
impl EnvironmentDeploymentPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentProperties {
    #[serde(rename = "deploymentProperties", default, skip_serializing_if = "Option::is_none")]
    pub deployment_properties: Option<EnvironmentDeploymentProperties>,
    #[serde(rename = "armTemplateDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub arm_template_display_name: Option<String>,
    #[serde(rename = "resourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub resource_group_id: Option<String>,
    #[serde(rename = "createdByUser", default, skip_serializing_if = "Option::is_none")]
    pub created_by_user: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl EnvironmentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentPropertiesFragment {}
impl EnvironmentPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EvaluatePoliciesProperties {
    #[serde(rename = "factName", default, skip_serializing_if = "Option::is_none")]
    pub fact_name: Option<String>,
    #[serde(rename = "factData", default, skip_serializing_if = "Option::is_none")]
    pub fact_data: Option<String>,
    #[serde(rename = "valueOffset", default, skip_serializing_if = "Option::is_none")]
    pub value_offset: Option<String>,
    #[serde(rename = "userObjectId", default, skip_serializing_if = "Option::is_none")]
    pub user_object_id: Option<String>,
}
impl EvaluatePoliciesProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EvaluatePoliciesRequest {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub policies: Vec<EvaluatePoliciesProperties>,
}
impl EvaluatePoliciesRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EvaluatePoliciesResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub results: Vec<PolicySetResult>,
}
impl EvaluatePoliciesResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Event {
    #[serde(rename = "eventName", default, skip_serializing_if = "Option::is_none")]
    pub event_name: Option<event::EventName>,
}
impl Event {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod event {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EventName {
        AutoShutdown,
        Cost,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventFragment {}
impl EventFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportResourceUsageParameters {
    #[serde(rename = "blobStorageAbsoluteSasUri", default, skip_serializing_if = "Option::is_none")]
    pub blob_storage_absolute_sas_uri: Option<String>,
    #[serde(rename = "usageStartDate", default, skip_serializing_if = "Option::is_none")]
    pub usage_start_date: Option<String>,
}
impl ExportResourceUsageParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSubnet {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl ExternalSubnet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSubnetFragment {}
impl ExternalSubnetFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Formula {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: FormulaProperties,
}
impl Formula {
    pub fn new(properties: FormulaProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FormulaFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl FormulaFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FormulaList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Formula>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FormulaList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FormulaProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[serde(rename = "formulaContent", default, skip_serializing_if = "Option::is_none")]
    pub formula_content: Option<LabVirtualMachineCreationParameter>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vm: Option<FormulaPropertiesFromVm>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl FormulaProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FormulaPropertiesFragment {}
impl FormulaPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FormulaPropertiesFromVm {
    #[serde(rename = "labVmId", default, skip_serializing_if = "Option::is_none")]
    pub lab_vm_id: Option<String>,
}
impl FormulaPropertiesFromVm {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FormulaPropertiesFromVmFragment {}
impl FormulaPropertiesFromVmFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryImage {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: GalleryImageProperties,
}
impl GalleryImage {
    pub fn new(properties: GalleryImageProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GalleryImage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GalleryImageList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<GalleryImageReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub icon: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "planId", default, skip_serializing_if = "Option::is_none")]
    pub plan_id: Option<String>,
    #[serde(rename = "isPlanAuthorized", default, skip_serializing_if = "Option::is_none")]
    pub is_plan_authorized: Option<bool>,
}
impl GalleryImageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl GalleryImageReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageReferenceFragment {}
impl GalleryImageReferenceFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenerateArmTemplateRequest {
    #[serde(rename = "virtualMachineName", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<ParameterInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "fileUploadOptions", default, skip_serializing_if = "Option::is_none")]
    pub file_upload_options: Option<generate_arm_template_request::FileUploadOptions>,
}
impl GenerateArmTemplateRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod generate_arm_template_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FileUploadOptions {
        UploadFilesAndGenerateSasTokens,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenerateUploadUriParameter {
    #[serde(rename = "blobName", default, skip_serializing_if = "Option::is_none")]
    pub blob_name: Option<String>,
}
impl GenerateUploadUriParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenerateUploadUriResponse {
    #[serde(rename = "uploadUri", default, skip_serializing_if = "Option::is_none")]
    pub upload_uri: Option<String>,
}
impl GenerateUploadUriResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HourDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minute: Option<i32>,
}
impl HourDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HourDetailsFragment {}
impl HourDetailsFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProperties {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity_properties::Type>,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "clientSecretUrl", default, skip_serializing_if = "Option::is_none")]
    pub client_secret_url: Option<String>,
}
impl IdentityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        None,
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned,UserAssigned")]
        SystemAssignedUserAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportLabVirtualMachineRequest {
    #[serde(rename = "sourceVirtualMachineResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_virtual_machine_resource_id: Option<String>,
    #[serde(rename = "destinationVirtualMachineName", default, skip_serializing_if = "Option::is_none")]
    pub destination_virtual_machine_name: Option<String>,
}
impl ImportLabVirtualMachineRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRule {
    #[serde(rename = "transportProtocol", default, skip_serializing_if = "Option::is_none")]
    pub transport_protocol: Option<inbound_nat_rule::TransportProtocol>,
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<i32>,
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
}
impl InboundNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod inbound_nat_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TransportProtocol {
        Tcp,
        Udp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRuleFragment {}
impl InboundNatRuleFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Lab {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LabProperties>,
}
impl Lab {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabAnnouncementProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub markdown: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<lab_announcement_properties::Enabled>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expired: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl LabAnnouncementProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod lab_announcement_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Enabled {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabAnnouncementPropertiesFragment {}
impl LabAnnouncementPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LabCost {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: LabCostProperties,
}
impl LabCost {
    pub fn new(properties: LabCostProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabCostDetailsProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cost: Option<f64>,
    #[serde(rename = "costType", default, skip_serializing_if = "Option::is_none")]
    pub cost_type: Option<lab_cost_details_properties::CostType>,
}
impl LabCostDetailsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod lab_cost_details_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CostType {
        Unavailable,
        Reported,
        Projected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabCostProperties {
    #[serde(rename = "targetCost", default, skip_serializing_if = "Option::is_none")]
    pub target_cost: Option<TargetCostProperties>,
    #[serde(rename = "labCostSummary", default, skip_serializing_if = "Option::is_none")]
    pub lab_cost_summary: Option<LabCostSummaryProperties>,
    #[serde(rename = "labCostDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub lab_cost_details: Vec<LabCostDetailsProperties>,
    #[serde(rename = "resourceCosts", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_costs: Vec<LabResourceCostProperties>,
    #[serde(rename = "currencyCode", default, skip_serializing_if = "Option::is_none")]
    pub currency_code: Option<String>,
    #[serde(rename = "startDateTime", default, skip_serializing_if = "Option::is_none")]
    pub start_date_time: Option<String>,
    #[serde(rename = "endDateTime", default, skip_serializing_if = "Option::is_none")]
    pub end_date_time: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl LabCostProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabCostSummaryProperties {
    #[serde(rename = "estimatedLabCost", default, skip_serializing_if = "Option::is_none")]
    pub estimated_lab_cost: Option<f64>,
}
impl LabCostSummaryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl LabFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Lab>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LabList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabProperties {
    #[serde(rename = "defaultStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub default_storage_account: Option<String>,
    #[serde(rename = "defaultPremiumStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub default_premium_storage_account: Option<String>,
    #[serde(rename = "artifactsStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub artifacts_storage_account: Option<String>,
    #[serde(rename = "premiumDataDiskStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub premium_data_disk_storage_account: Option<String>,
    #[serde(rename = "vaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "labStorageType", default, skip_serializing_if = "Option::is_none")]
    pub lab_storage_type: Option<lab_properties::LabStorageType>,
    #[serde(rename = "mandatoryArtifactsResourceIdsLinux", default, skip_serializing_if = "Vec::is_empty")]
    pub mandatory_artifacts_resource_ids_linux: Vec<String>,
    #[serde(rename = "mandatoryArtifactsResourceIdsWindows", default, skip_serializing_if = "Vec::is_empty")]
    pub mandatory_artifacts_resource_ids_windows: Vec<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "premiumDataDisks", default, skip_serializing_if = "Option::is_none")]
    pub premium_data_disks: Option<lab_properties::PremiumDataDisks>,
    #[serde(rename = "environmentPermission", default, skip_serializing_if = "Option::is_none")]
    pub environment_permission: Option<lab_properties::EnvironmentPermission>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub announcement: Option<LabAnnouncementProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub support: Option<LabSupportProperties>,
    #[serde(rename = "vmCreationResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub vm_creation_resource_group: Option<String>,
    #[serde(rename = "publicIpId", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_id: Option<String>,
    #[serde(rename = "loadBalancerId", default, skip_serializing_if = "Option::is_none")]
    pub load_balancer_id: Option<String>,
    #[serde(rename = "networkSecurityGroupId", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group_id: Option<String>,
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<serde_json::Value>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl LabProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod lab_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LabStorageType {
        Standard,
        Premium,
        #[serde(rename = "StandardSSD")]
        StandardSsd,
    }
    impl Default for LabStorageType {
        fn default() -> Self {
            Self::Premium
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PremiumDataDisks {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EnvironmentPermission {
        Reader,
        Contributor,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabPropertiesFragment {}
impl LabPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabResourceCostProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resourcename: Option<String>,
    #[serde(rename = "resourceUId", default, skip_serializing_if = "Option::is_none")]
    pub resource_u_id: Option<String>,
    #[serde(rename = "resourceCost", default, skip_serializing_if = "Option::is_none")]
    pub resource_cost: Option<f64>,
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(rename = "resourceOwner", default, skip_serializing_if = "Option::is_none")]
    pub resource_owner: Option<String>,
    #[serde(rename = "resourcePricingTier", default, skip_serializing_if = "Option::is_none")]
    pub resource_pricing_tier: Option<String>,
    #[serde(rename = "resourceStatus", default, skip_serializing_if = "Option::is_none")]
    pub resource_status: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "externalResourceId", default, skip_serializing_if = "Option::is_none")]
    pub external_resource_id: Option<String>,
}
impl LabResourceCostProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabSupportProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<lab_support_properties::Enabled>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub markdown: Option<String>,
}
impl LabSupportProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod lab_support_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Enabled {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabSupportPropertiesFragment {}
impl LabSupportPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVhd {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl LabVhd {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVhdList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LabVhd>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LabVhdList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LabVirtualMachine {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: LabVirtualMachineProperties,
}
impl LabVirtualMachine {
    pub fn new(properties: LabVirtualMachineProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVirtualMachineCreationParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LabVirtualMachineCreationParameterProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl LabVirtualMachineCreationParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVirtualMachineCreationParameterFragment {}
impl LabVirtualMachineCreationParameterFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVirtualMachineCreationParameterProperties {
    #[serde(rename = "bulkCreationParameters", default, skip_serializing_if = "Option::is_none")]
    pub bulk_creation_parameters: Option<BulkCreationParameters>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    #[serde(rename = "ownerObjectId", default, skip_serializing_if = "Option::is_none")]
    pub owner_object_id: Option<String>,
    #[serde(rename = "ownerUserPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub owner_user_principal_name: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "customImageId", default, skip_serializing_if = "Option::is_none")]
    pub custom_image_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "sshKey", default, skip_serializing_if = "Option::is_none")]
    pub ssh_key: Option<String>,
    #[serde(rename = "isAuthenticationWithSshKey", default, skip_serializing_if = "Option::is_none")]
    pub is_authentication_with_ssh_key: Option<bool>,
    #[serde(rename = "labSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub lab_subnet_name: Option<String>,
    #[serde(rename = "labVirtualNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub lab_virtual_network_id: Option<String>,
    #[serde(rename = "disallowPublicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub disallow_public_ip_address: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub artifacts: Vec<ArtifactInstallProperties>,
    #[serde(rename = "galleryImageReference", default, skip_serializing_if = "Option::is_none")]
    pub gallery_image_reference: Option<GalleryImageReference>,
    #[serde(rename = "planId", default, skip_serializing_if = "Option::is_none")]
    pub plan_id: Option<String>,
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<NetworkInterfaceProperties>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(rename = "allowClaim", default, skip_serializing_if = "Option::is_none")]
    pub allow_claim: Option<bool>,
    #[serde(rename = "storageType", default, skip_serializing_if = "Option::is_none")]
    pub storage_type: Option<String>,
    #[serde(rename = "environmentId", default, skip_serializing_if = "Option::is_none")]
    pub environment_id: Option<String>,
    #[serde(rename = "dataDiskParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disk_parameters: Vec<DataDiskProperties>,
    #[serde(rename = "scheduleParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub schedule_parameters: Vec<ScheduleCreationParameter>,
}
impl LabVirtualMachineCreationParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVirtualMachineCreationParameterPropertiesFragment {}
impl LabVirtualMachineCreationParameterPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVirtualMachineFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl LabVirtualMachineFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVirtualMachineList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LabVirtualMachine>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LabVirtualMachineList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVirtualMachineProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    #[serde(rename = "ownerObjectId", default, skip_serializing_if = "Option::is_none")]
    pub owner_object_id: Option<String>,
    #[serde(rename = "ownerUserPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub owner_user_principal_name: Option<String>,
    #[serde(rename = "createdByUserId", default, skip_serializing_if = "Option::is_none")]
    pub created_by_user_id: Option<String>,
    #[serde(rename = "createdByUser", default, skip_serializing_if = "Option::is_none")]
    pub created_by_user: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "computeId", default, skip_serializing_if = "Option::is_none")]
    pub compute_id: Option<String>,
    #[serde(rename = "customImageId", default, skip_serializing_if = "Option::is_none")]
    pub custom_image_id: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "sshKey", default, skip_serializing_if = "Option::is_none")]
    pub ssh_key: Option<String>,
    #[serde(rename = "isAuthenticationWithSshKey", default, skip_serializing_if = "Option::is_none")]
    pub is_authentication_with_ssh_key: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "labSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub lab_subnet_name: Option<String>,
    #[serde(rename = "labVirtualNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub lab_virtual_network_id: Option<String>,
    #[serde(rename = "disallowPublicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub disallow_public_ip_address: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub artifacts: Vec<ArtifactInstallProperties>,
    #[serde(rename = "artifactDeploymentStatus", default, skip_serializing_if = "Option::is_none")]
    pub artifact_deployment_status: Option<ArtifactDeploymentStatusProperties>,
    #[serde(rename = "galleryImageReference", default, skip_serializing_if = "Option::is_none")]
    pub gallery_image_reference: Option<GalleryImageReference>,
    #[serde(rename = "planId", default, skip_serializing_if = "Option::is_none")]
    pub plan_id: Option<String>,
    #[serde(rename = "computeVm", default, skip_serializing_if = "Option::is_none")]
    pub compute_vm: Option<ComputeVmProperties>,
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<NetworkInterfaceProperties>,
    #[serde(rename = "applicableSchedule", default, skip_serializing_if = "Option::is_none")]
    pub applicable_schedule: Option<ApplicableSchedule>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(rename = "allowClaim", default, skip_serializing_if = "Option::is_none")]
    pub allow_claim: Option<bool>,
    #[serde(rename = "storageType", default, skip_serializing_if = "Option::is_none")]
    pub storage_type: Option<String>,
    #[serde(rename = "virtualMachineCreationSource", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_creation_source: Option<lab_virtual_machine_properties::VirtualMachineCreationSource>,
    #[serde(rename = "environmentId", default, skip_serializing_if = "Option::is_none")]
    pub environment_id: Option<String>,
    #[serde(rename = "dataDiskParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disk_parameters: Vec<DataDiskProperties>,
    #[serde(rename = "scheduleParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub schedule_parameters: Vec<ScheduleCreationParameter>,
    #[serde(rename = "lastKnownPowerState", default, skip_serializing_if = "Option::is_none")]
    pub last_known_power_state: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl LabVirtualMachineProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod lab_virtual_machine_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VirtualMachineCreationSource {
        FromCustomImage,
        FromGalleryImage,
        FromSharedGalleryImage,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LabVirtualMachinePropertiesFragment {}
impl LabVirtualMachinePropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinuxOsInfo {
    #[serde(rename = "linuxOsState", default, skip_serializing_if = "Option::is_none")]
    pub linux_os_state: Option<linux_os_info::LinuxOsState>,
}
impl LinuxOsInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod linux_os_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LinuxOsState {
        NonDeprovisioned,
        DeprovisionRequested,
        DeprovisionApplied,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinuxOsInfoFragment {}
impl LinuxOsInfoFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceProperties {
    #[serde(rename = "virtualNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_id: Option<String>,
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[serde(rename = "publicIpAddressId", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_id: Option<String>,
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "dnsName", default, skip_serializing_if = "Option::is_none")]
    pub dns_name: Option<String>,
    #[serde(rename = "rdpAuthority", default, skip_serializing_if = "Option::is_none")]
    pub rdp_authority: Option<String>,
    #[serde(rename = "sshAuthority", default, skip_serializing_if = "Option::is_none")]
    pub ssh_authority: Option<String>,
    #[serde(rename = "sharedPublicIpAddressConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub shared_public_ip_address_configuration: Option<SharedPublicIpAddressConfiguration>,
}
impl NetworkInterfaceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfacePropertiesFragment {}
impl NetworkInterfacePropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotificationChannel {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: NotificationChannelProperties,
}
impl NotificationChannel {
    pub fn new(properties: NotificationChannelProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationChannelFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl NotificationChannelFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationChannelList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NotificationChannel>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NotificationChannelList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationChannelProperties {
    #[serde(rename = "webHookUrl", default, skip_serializing_if = "Option::is_none")]
    pub web_hook_url: Option<String>,
    #[serde(rename = "emailRecipient", default, skip_serializing_if = "Option::is_none")]
    pub email_recipient: Option<String>,
    #[serde(rename = "notificationLocale", default, skip_serializing_if = "Option::is_none")]
    pub notification_locale: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub events: Vec<Event>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl NotificationChannelProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationChannelPropertiesFragment {}
impl NotificationChannelPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<notification_settings::Status>,
    #[serde(rename = "timeInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub time_in_minutes: Option<i32>,
    #[serde(rename = "webhookUrl", default, skip_serializing_if = "Option::is_none")]
    pub webhook_url: Option<String>,
    #[serde(rename = "emailRecipient", default, skip_serializing_if = "Option::is_none")]
    pub email_recipient: Option<String>,
    #[serde(rename = "notificationLocale", default, skip_serializing_if = "Option::is_none")]
    pub notification_locale: Option<String>,
}
impl NotificationSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod notification_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Disabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationSettingsFragment {}
impl NotificationSettingsFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotifyParameters {
    #[serde(rename = "eventName", default, skip_serializing_if = "Option::is_none")]
    pub event_name: Option<notify_parameters::EventName>,
    #[serde(rename = "jsonPayload", default, skip_serializing_if = "Option::is_none")]
    pub json_payload: Option<String>,
}
impl NotifyParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod notify_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EventName {
        AutoShutdown,
        Cost,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl OperationError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetadata {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationMetadataDisplay>,
}
impl OperationMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetadataDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationMetadataDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "statusCode", default, skip_serializing_if = "Option::is_none")]
    pub status_code: Option<operation_result::StatusCode>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<OperationError>,
}
impl OperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StatusCode {
        Continue,
        SwitchingProtocols,
        #[serde(rename = "OK")]
        Ok,
        Created,
        Accepted,
        NonAuthoritativeInformation,
        NoContent,
        ResetContent,
        PartialContent,
        MultipleChoices,
        Ambiguous,
        MovedPermanently,
        Moved,
        Found,
        Redirect,
        SeeOther,
        RedirectMethod,
        NotModified,
        UseProxy,
        Unused,
        TemporaryRedirect,
        RedirectKeepVerb,
        BadRequest,
        Unauthorized,
        PaymentRequired,
        Forbidden,
        NotFound,
        MethodNotAllowed,
        NotAcceptable,
        ProxyAuthenticationRequired,
        RequestTimeout,
        Conflict,
        Gone,
        LengthRequired,
        PreconditionFailed,
        RequestEntityTooLarge,
        RequestUriTooLong,
        UnsupportedMediaType,
        RequestedRangeNotSatisfiable,
        ExpectationFailed,
        UpgradeRequired,
        InternalServerError,
        NotImplemented,
        BadGateway,
        ServiceUnavailable,
        GatewayTimeout,
        HttpVersionNotSupported,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ParameterInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ParameterInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ParametersValueFileInfo {
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<String>,
    #[serde(rename = "parametersValueInfo", default, skip_serializing_if = "Option::is_none")]
    pub parameters_value_info: Option<serde_json::Value>,
}
impl ParametersValueFileInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PercentageCostThresholdProperties {
    #[serde(rename = "thresholdValue", default, skip_serializing_if = "Option::is_none")]
    pub threshold_value: Option<f64>,
}
impl PercentageCostThresholdProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Policy {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: PolicyProperties,
}
impl Policy {
    pub fn new(properties: PolicyProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl PolicyFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Policy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PolicyList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<policy_properties::Status>,
    #[serde(rename = "factName", default, skip_serializing_if = "Option::is_none")]
    pub fact_name: Option<policy_properties::FactName>,
    #[serde(rename = "factData", default, skip_serializing_if = "Option::is_none")]
    pub fact_data: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub threshold: Option<String>,
    #[serde(rename = "evaluatorType", default, skip_serializing_if = "Option::is_none")]
    pub evaluator_type: Option<policy_properties::EvaluatorType>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl PolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod policy_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FactName {
        UserOwnedLabVmCount,
        UserOwnedLabPremiumVmCount,
        LabVmCount,
        LabPremiumVmCount,
        LabVmSize,
        GalleryImage,
        UserOwnedLabVmCountInSubnet,
        LabTargetCost,
        EnvironmentTemplate,
        ScheduleEditPermission,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EvaluatorType {
        AllowedValuesPolicy,
        MaxValuePolicy,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyPropertiesFragment {}
impl PolicyPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicySetResult {
    #[serde(rename = "hasError", default, skip_serializing_if = "Option::is_none")]
    pub has_error: Option<bool>,
    #[serde(rename = "policyViolations", default, skip_serializing_if = "Vec::is_empty")]
    pub policy_violations: Vec<PolicyViolation>,
}
impl PolicySetResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyViolation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl PolicyViolation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Port {
    #[serde(rename = "transportProtocol", default, skip_serializing_if = "Option::is_none")]
    pub transport_protocol: Option<port::TransportProtocol>,
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
}
impl Port {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod port {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TransportProtocol {
        Tcp,
        Udp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PortFragment {}
impl PortFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderOperationResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OperationMetadata>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProviderOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RdpConnection {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub contents: Option<String>,
}
impl RdpConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResizeLabVirtualMachineProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
}
impl ResizeLabVirtualMachineProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetargetScheduleProperties {
    #[serde(rename = "currentResourceId", default, skip_serializing_if = "Option::is_none")]
    pub current_resource_id: Option<String>,
    #[serde(rename = "targetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_id: Option<String>,
}
impl RetargetScheduleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Schedule {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: ScheduleProperties,
}
impl Schedule {
    pub fn new(properties: ScheduleProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduleCreationParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScheduleCreationParameterProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ScheduleCreationParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduleCreationParameterFragment {}
impl ScheduleCreationParameterFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduleCreationParameterProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<schedule_creation_parameter_properties::Status>,
    #[serde(rename = "taskType", default, skip_serializing_if = "Option::is_none")]
    pub task_type: Option<String>,
    #[serde(rename = "weeklyRecurrence", default, skip_serializing_if = "Option::is_none")]
    pub weekly_recurrence: Option<WeekDetails>,
    #[serde(rename = "dailyRecurrence", default, skip_serializing_if = "Option::is_none")]
    pub daily_recurrence: Option<DayDetails>,
    #[serde(rename = "hourlyRecurrence", default, skip_serializing_if = "Option::is_none")]
    pub hourly_recurrence: Option<HourDetails>,
    #[serde(rename = "timeZoneId", default, skip_serializing_if = "Option::is_none")]
    pub time_zone_id: Option<String>,
    #[serde(rename = "notificationSettings", default, skip_serializing_if = "Option::is_none")]
    pub notification_settings: Option<NotificationSettings>,
    #[serde(rename = "targetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_id: Option<String>,
}
impl ScheduleCreationParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod schedule_creation_parameter_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Disabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduleCreationParameterPropertiesFragment {}
impl ScheduleCreationParameterPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduleFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl ScheduleFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduleList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Schedule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ScheduleList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduleProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<schedule_properties::Status>,
    #[serde(rename = "taskType", default, skip_serializing_if = "Option::is_none")]
    pub task_type: Option<String>,
    #[serde(rename = "weeklyRecurrence", default, skip_serializing_if = "Option::is_none")]
    pub weekly_recurrence: Option<WeekDetails>,
    #[serde(rename = "dailyRecurrence", default, skip_serializing_if = "Option::is_none")]
    pub daily_recurrence: Option<DayDetails>,
    #[serde(rename = "hourlyRecurrence", default, skip_serializing_if = "Option::is_none")]
    pub hourly_recurrence: Option<HourDetails>,
    #[serde(rename = "timeZoneId", default, skip_serializing_if = "Option::is_none")]
    pub time_zone_id: Option<String>,
    #[serde(rename = "notificationSettings", default, skip_serializing_if = "Option::is_none")]
    pub notification_settings: Option<NotificationSettings>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "targetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_id: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl ScheduleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod schedule_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Disabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SchedulePropertiesFragment {}
impl SchedulePropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Secret {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: SecretProperties,
}
impl Secret {
    pub fn new(properties: SecretProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecretFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl SecretFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecretList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Secret>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecretList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecretProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl SecretProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecretPropertiesFragment {}
impl SecretPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceFabric {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: ServiceFabricProperties,
}
impl ServiceFabric {
    pub fn new(properties: ServiceFabricProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceFabricFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl ServiceFabricFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceFabricList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceFabric>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceFabricList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceFabricProperties {
    #[serde(rename = "externalServiceFabricId", default, skip_serializing_if = "Option::is_none")]
    pub external_service_fabric_id: Option<String>,
    #[serde(rename = "environmentId", default, skip_serializing_if = "Option::is_none")]
    pub environment_id: Option<String>,
    #[serde(rename = "applicableSchedule", default, skip_serializing_if = "Option::is_none")]
    pub applicable_schedule: Option<ApplicableSchedule>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl ServiceFabricProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceFabricPropertiesFragment {}
impl ServiceFabricPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceRunner {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityProperties>,
}
impl ServiceRunner {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceRunnerList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceRunner>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceRunnerList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharedPublicIpAddressConfiguration {
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<InboundNatRule>,
}
impl SharedPublicIpAddressConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharedPublicIpAddressConfigurationFragment {}
impl SharedPublicIpAddressConfigurationFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShutdownNotificationContent {
    #[serde(rename = "skipUrl", default, skip_serializing_if = "Option::is_none")]
    pub skip_url: Option<String>,
    #[serde(rename = "delayUrl60", default, skip_serializing_if = "Option::is_none")]
    pub delay_url60: Option<String>,
    #[serde(rename = "delayUrl120", default, skip_serializing_if = "Option::is_none")]
    pub delay_url120: Option<String>,
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub guid: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub owner: Option<String>,
    #[serde(rename = "vmUrl", default, skip_serializing_if = "Option::is_none")]
    pub vm_url: Option<String>,
    #[serde(rename = "minutesUntilShutdown", default, skip_serializing_if = "Option::is_none")]
    pub minutes_until_shutdown: Option<String>,
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub text: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub resource_group_name: Option<String>,
    #[serde(rename = "labName", default, skip_serializing_if = "Option::is_none")]
    pub lab_name: Option<String>,
}
impl ShutdownNotificationContent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Subnet {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "labSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub lab_subnet_name: Option<String>,
    #[serde(rename = "allowPublicIp", default, skip_serializing_if = "Option::is_none")]
    pub allow_public_ip: Option<subnet::AllowPublicIp>,
}
impl Subnet {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod subnet {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AllowPublicIp {
        Default,
        Deny,
        Allow,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetFragment {}
impl SubnetFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetOverride {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "labSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub lab_subnet_name: Option<String>,
    #[serde(rename = "useInVmCreationPermission", default, skip_serializing_if = "Option::is_none")]
    pub use_in_vm_creation_permission: Option<subnet_override::UseInVmCreationPermission>,
    #[serde(rename = "usePublicIpAddressPermission", default, skip_serializing_if = "Option::is_none")]
    pub use_public_ip_address_permission: Option<subnet_override::UsePublicIpAddressPermission>,
    #[serde(rename = "sharedPublicIpAddressConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub shared_public_ip_address_configuration: Option<SubnetSharedPublicIpAddressConfiguration>,
    #[serde(rename = "virtualNetworkPoolName", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_pool_name: Option<String>,
}
impl SubnetOverride {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod subnet_override {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UseInVmCreationPermission {
        Default,
        Deny,
        Allow,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UsePublicIpAddressPermission {
        Default,
        Deny,
        Allow,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetOverrideFragment {}
impl SubnetOverrideFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetSharedPublicIpAddressConfiguration {
    #[serde(rename = "allowedPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_ports: Vec<Port>,
}
impl SubnetSharedPublicIpAddressConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetSharedPublicIpAddressConfigurationFragment {}
impl SubnetSharedPublicIpAddressConfigurationFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetCostProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<target_cost_properties::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<i32>,
    #[serde(rename = "costThresholds", default, skip_serializing_if = "Vec::is_empty")]
    pub cost_thresholds: Vec<CostThresholdProperties>,
    #[serde(rename = "cycleStartDateTime", default, skip_serializing_if = "Option::is_none")]
    pub cycle_start_date_time: Option<String>,
    #[serde(rename = "cycleEndDateTime", default, skip_serializing_if = "Option::is_none")]
    pub cycle_end_date_time: Option<String>,
    #[serde(rename = "cycleType", default, skip_serializing_if = "Option::is_none")]
    pub cycle_type: Option<target_cost_properties::CycleType>,
}
impl TargetCostProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod target_cost_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CycleType {
        CalendarMonth,
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl UpdateResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct User {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserProperties>,
}
impl User {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl UserFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentity {
    #[serde(rename = "principalName", default, skip_serializing_if = "Option::is_none")]
    pub principal_name: Option<String>,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[serde(rename = "appId", default, skip_serializing_if = "Option::is_none")]
    pub app_id: Option<String>,
}
impl UserIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentityFragment {}
impl UserIdentityFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<User>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UserList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<UserIdentity>,
    #[serde(rename = "secretStore", default, skip_serializing_if = "Option::is_none")]
    pub secret_store: Option<UserSecretStore>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl UserProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserPropertiesFragment {}
impl UserPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserSecretStore {
    #[serde(rename = "keyVaultUri", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_uri: Option<String>,
    #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_id: Option<String>,
}
impl UserSecretStore {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserSecretStoreFragment {}
impl UserSecretStoreFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetwork {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkProperties>,
}
impl VirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkFragment {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl VirtualNetworkFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetwork>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkProperties {
    #[serde(rename = "allowedSubnets", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_subnets: Vec<Subnet>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "externalProviderResourceId", default, skip_serializing_if = "Option::is_none")]
    pub external_provider_resource_id: Option<String>,
    #[serde(rename = "externalSubnets", default, skip_serializing_if = "Vec::is_empty")]
    pub external_subnets: Vec<ExternalSubnet>,
    #[serde(rename = "subnetOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub subnet_overrides: Vec<SubnetOverride>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "uniqueIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub unique_identifier: Option<String>,
}
impl VirtualNetworkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPropertiesFragment {}
impl VirtualNetworkPropertiesFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WeekDetails {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub weekdays: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
}
impl WeekDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WeekDetailsFragment {}
impl WeekDetailsFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WindowsOsInfo {
    #[serde(rename = "windowsOsState", default, skip_serializing_if = "Option::is_none")]
    pub windows_os_state: Option<windows_os_info::WindowsOsState>,
}
impl WindowsOsInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod windows_os_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WindowsOsState {
        NonSysprepped,
        SysprepRequested,
        SysprepApplied,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WindowsOsInfoFragment {}
impl WindowsOsInfoFragment {
    pub fn new() -> Self {
        Self::default()
    }
}
