#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerHostMapping {
    #[serde(rename = "containerHostResourceId", default, skip_serializing_if = "Option::is_none")]
    pub container_host_resource_id: Option<String>,
    #[serde(rename = "mappedControllerResourceId", default, skip_serializing_if = "Option::is_none")]
    pub mapped_controller_resource_id: Option<String>,
}
impl ContainerHostMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Controller {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    pub properties: ControllerProperties,
    pub sku: Sku,
}
impl Controller {
    pub fn new(properties: ControllerProperties, sku: Sku) -> Self {
        Self {
            tracked_resource: TrackedResource::default(),
            properties,
            sku,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ControllerConnectionDetails {
    #[serde(rename = "orchestratorSpecificConnectionDetails", default, skip_serializing_if = "Option::is_none")]
    pub orchestrator_specific_connection_details: Option<OrchestratorSpecificConnectionDetails>,
}
impl ControllerConnectionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ControllerConnectionDetailsList {
    #[serde(rename = "connectionDetailsList", default, skip_serializing_if = "Vec::is_empty")]
    pub connection_details_list: Vec<ControllerConnectionDetails>,
}
impl ControllerConnectionDetailsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ControllerList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Controller>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ControllerList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ControllerProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<controller_properties::ProvisioningState>,
    #[serde(rename = "hostSuffix", default, skip_serializing_if = "Option::is_none")]
    pub host_suffix: Option<String>,
    #[serde(rename = "dataPlaneFqdn", default, skip_serializing_if = "Option::is_none")]
    pub data_plane_fqdn: Option<String>,
    #[serde(rename = "targetContainerHostApiServerFqdn", default, skip_serializing_if = "Option::is_none")]
    pub target_container_host_api_server_fqdn: Option<String>,
    #[serde(rename = "targetContainerHostResourceId")]
    pub target_container_host_resource_id: String,
    #[serde(rename = "targetContainerHostCredentialsBase64")]
    pub target_container_host_credentials_base64: String,
}
impl ControllerProperties {
    pub fn new(target_container_host_resource_id: String, target_container_host_credentials_base64: String) -> Self {
        Self {
            provisioning_state: None,
            host_suffix: None,
            data_plane_fqdn: None,
            target_container_host_api_server_fqdn: None,
            target_container_host_resource_id,
            target_container_host_credentials_base64,
        }
    }
}
pub mod controller_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Failed,
        Canceled,
        Updating,
        Creating,
        Deleting,
        Deleted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ControllerUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ControllerUpdateParametersProperties>,
}
impl ControllerUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ControllerUpdateParametersProperties {
    #[serde(rename = "targetContainerHostCredentialsBase64", default, skip_serializing_if = "Option::is_none")]
    pub target_container_host_credentials_base64: Option<String>,
}
impl ControllerUpdateParametersProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DevSpacesErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetails>,
}
impl DevSpacesErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KubernetesConnectionDetails {
    #[serde(flatten)]
    pub orchestrator_specific_connection_details: OrchestratorSpecificConnectionDetails,
    #[serde(rename = "kubeConfig", default, skip_serializing_if = "Option::is_none")]
    pub kube_config: Option<String>,
}
impl KubernetesConnectionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListConnectionDetailsParameters {
    #[serde(rename = "targetContainerHostResourceId")]
    pub target_container_host_resource_id: String,
}
impl ListConnectionDetailsParameters {
    pub fn new(target_container_host_resource_id: String) -> Self {
        Self {
            target_container_host_resource_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OrchestratorSpecificConnectionDetails {
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl OrchestratorSpecificConnectionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderOperationDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<ResourceProviderOperationDisplay>,
}
impl ResourceProviderOperationDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderOperationDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ResourceProviderOperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderOperationList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceProviderOperationDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceProviderOperationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Sku {
    pub name: sku::Name,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<sku::Tier>,
}
impl Sku {
    pub fn new(name: sku::Name) -> Self {
        Self { name, tier: None }
    }
}
pub mod sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        S1,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl TrackedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
