#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Schema for Application properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Application {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Schema for Application properties."]
    pub properties: ApplicationProperties,
}
impl Application {
    pub fn new(properties: ApplicationProperties) -> Self {
        Self {
            resource: Resource::default(),
            properties,
        }
    }
}
#[doc = "Represents a ApplicationGroup definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGroup {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Schema for ApplicationGroup properties."]
    pub properties: ApplicationGroupProperties,
}
impl ApplicationGroup {
    pub fn new(tracked_resource: TrackedResource, properties: ApplicationGroupProperties) -> Self {
        Self {
            tracked_resource,
            properties,
        }
    }
}
#[doc = "List of ApplicationGroup definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGroupList {
    #[doc = "List of ApplicationGroup definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGroup>,
    #[doc = "Link to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGroupList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ApplicationGroup properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGroupPatch {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "tags to be updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "ApplicationGroup properties that can be patched."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGroupPatchProperties>,
}
impl ApplicationGroupPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ApplicationGroup properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGroupPatchProperties {
    #[doc = "Description of ApplicationGroup."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Friendly name of ApplicationGroup."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl ApplicationGroupPatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Schema for ApplicationGroup properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGroupProperties {
    #[doc = "Description of ApplicationGroup."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Friendly name of ApplicationGroup."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "HostPool arm path of ApplicationGroup."]
    #[serde(rename = "hostPoolArmPath")]
    pub host_pool_arm_path: String,
    #[doc = "Workspace arm path of ApplicationGroup."]
    #[serde(rename = "workspaceArmPath", default, skip_serializing_if = "Option::is_none")]
    pub workspace_arm_path: Option<String>,
    #[doc = "Resource Type of ApplicationGroup."]
    #[serde(rename = "applicationGroupType")]
    pub application_group_type: application_group_properties::ApplicationGroupType,
}
impl ApplicationGroupProperties {
    pub fn new(host_pool_arm_path: String, application_group_type: application_group_properties::ApplicationGroupType) -> Self {
        Self {
            description: None,
            friendly_name: None,
            host_pool_arm_path,
            workspace_arm_path: None,
            application_group_type,
        }
    }
}
pub mod application_group_properties {
    use super::*;
    #[doc = "Resource Type of ApplicationGroup."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ApplicationGroupType {
        RemoteApp,
        Desktop,
    }
}
#[doc = "List of Application definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationList {
    #[doc = "List of Application definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Application>,
    #[doc = "Link to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationPatch {
    #[doc = "tags to be updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Application properties that can be patched."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationPatchProperties>,
}
impl ApplicationPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationPatchProperties {
    #[doc = "Description of Application."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Friendly name of Application."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Specifies a path for the executable file for the application."]
    #[serde(rename = "filePath", default, skip_serializing_if = "Option::is_none")]
    pub file_path: Option<String>,
    #[doc = "Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all."]
    #[serde(rename = "commandLineSetting", default, skip_serializing_if = "Option::is_none")]
    pub command_line_setting: Option<application_patch_properties::CommandLineSetting>,
    #[doc = "Command Line Arguments for Application."]
    #[serde(rename = "commandLineArguments", default, skip_serializing_if = "Option::is_none")]
    pub command_line_arguments: Option<String>,
    #[doc = "Specifies whether to show the RemoteApp program in the RD Web Access server."]
    #[serde(rename = "showInPortal", default, skip_serializing_if = "Option::is_none")]
    pub show_in_portal: Option<bool>,
    #[doc = "Path to icon."]
    #[serde(rename = "iconPath", default, skip_serializing_if = "Option::is_none")]
    pub icon_path: Option<String>,
    #[doc = "Index of the icon."]
    #[serde(rename = "iconIndex", default, skip_serializing_if = "Option::is_none")]
    pub icon_index: Option<i64>,
}
impl ApplicationPatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_patch_properties {
    use super::*;
    #[doc = "Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CommandLineSetting {
        DoNotAllow,
        Allow,
        Require,
    }
}
#[doc = "Schema for Application properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationProperties {
    #[doc = "Description of Application."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Friendly name of Application."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Specifies a path for the executable file for the application."]
    #[serde(rename = "filePath", default, skip_serializing_if = "Option::is_none")]
    pub file_path: Option<String>,
    #[doc = "Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all."]
    #[serde(rename = "commandLineSetting")]
    pub command_line_setting: application_properties::CommandLineSetting,
    #[doc = "Command Line Arguments for Application."]
    #[serde(rename = "commandLineArguments", default, skip_serializing_if = "Option::is_none")]
    pub command_line_arguments: Option<String>,
    #[doc = "Specifies whether to show the RemoteApp program in the RD Web Access server."]
    #[serde(rename = "showInPortal", default, skip_serializing_if = "Option::is_none")]
    pub show_in_portal: Option<bool>,
    #[doc = "Path to icon."]
    #[serde(rename = "iconPath", default, skip_serializing_if = "Option::is_none")]
    pub icon_path: Option<String>,
    #[doc = "Index of the icon."]
    #[serde(rename = "iconIndex", default, skip_serializing_if = "Option::is_none")]
    pub icon_index: Option<i64>,
    #[doc = "Hash of the icon."]
    #[serde(rename = "iconHash", default, skip_serializing_if = "Option::is_none")]
    pub icon_hash: Option<String>,
    #[doc = "the icon a 64 bit string as a byte array."]
    #[serde(rename = "iconContent", default, skip_serializing_if = "Option::is_none")]
    pub icon_content: Option<String>,
}
impl ApplicationProperties {
    pub fn new(command_line_setting: application_properties::CommandLineSetting) -> Self {
        Self {
            description: None,
            friendly_name: None,
            file_path: None,
            command_line_setting,
            command_line_arguments: None,
            show_in_portal: None,
            icon_path: None,
            icon_index: None,
            icon_hash: None,
            icon_content: None,
        }
    }
}
pub mod application_properties {
    use super::*;
    #[doc = "Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CommandLineSetting {
        DoNotAllow,
        Allow,
        Require,
    }
}
#[doc = "Error response of an operation failure"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "Error code"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message indicating why the operation failed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Schema for Desktop properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Desktop {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Schema for Desktop properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DesktopProperties>,
}
impl Desktop {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of Desktop definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DesktopList {
    #[doc = "List of Desktop definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Desktop>,
    #[doc = "Link to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DesktopList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Desktop properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DesktopPatch {
    #[doc = "tags to be updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Desktop properties that can be patched."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DesktopPatchProperties>,
}
impl DesktopPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Desktop properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DesktopPatchProperties {
    #[doc = "Description of Desktop."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Friendly name of Desktop."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl DesktopPatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Schema for Desktop properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DesktopProperties {
    #[doc = "Description of Desktop."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Friendly name of Desktop."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Hash of the icon."]
    #[serde(rename = "iconHash", default, skip_serializing_if = "Option::is_none")]
    pub icon_hash: Option<String>,
    #[doc = "The icon a 64 bit string as a byte array."]
    #[serde(rename = "iconContent", default, skip_serializing_if = "Option::is_none")]
    pub icon_content: Option<String>,
}
impl DesktopProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a HostPool definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HostPool {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Properties of HostPool."]
    pub properties: HostPoolProperties,
}
impl HostPool {
    pub fn new(tracked_resource: TrackedResource, properties: HostPoolProperties) -> Self {
        Self {
            tracked_resource,
            properties,
        }
    }
}
#[doc = "List of HostPool definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostPoolList {
    #[doc = "List of HostPool definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HostPool>,
    #[doc = "Link to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl HostPoolList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HostPool properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostPoolPatch {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "tags to be updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Properties of HostPool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HostPoolPatchProperties>,
}
impl HostPoolPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of HostPool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostPoolPatchProperties {
    #[doc = "Friendly name of HostPool."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Description of HostPool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Custom rdp property of HostPool."]
    #[serde(rename = "customRdpProperty", default, skip_serializing_if = "Option::is_none")]
    pub custom_rdp_property: Option<String>,
    #[doc = "The max session limit of HostPool."]
    #[serde(rename = "maxSessionLimit", default, skip_serializing_if = "Option::is_none")]
    pub max_session_limit: Option<i64>,
    #[doc = "PersonalDesktopAssignment type for HostPool."]
    #[serde(rename = "personalDesktopAssignmentType", default, skip_serializing_if = "Option::is_none")]
    pub personal_desktop_assignment_type: Option<host_pool_patch_properties::PersonalDesktopAssignmentType>,
    #[doc = "The type of the load balancer."]
    #[serde(rename = "loadBalancerType", default, skip_serializing_if = "Option::is_none")]
    pub load_balancer_type: Option<host_pool_patch_properties::LoadBalancerType>,
    #[doc = "The ring number of HostPool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub ring: Option<i64>,
    #[doc = "Is validation environment."]
    #[serde(rename = "validationEnvironment", default, skip_serializing_if = "Option::is_none")]
    pub validation_environment: Option<bool>,
    #[doc = "Represents a RegistrationInfo definition."]
    #[serde(rename = "registrationInfo", default, skip_serializing_if = "Option::is_none")]
    pub registration_info: Option<RegistrationInfoPatch>,
    #[doc = "Path to keyvault containing ssoContext secret."]
    #[serde(rename = "ssoContext", default, skip_serializing_if = "Option::is_none")]
    pub sso_context: Option<String>,
    #[doc = "The type of preferred application group type, default to Desktop Application Group"]
    #[serde(rename = "preferredAppGroupType", default, skip_serializing_if = "Option::is_none")]
    pub preferred_app_group_type: Option<host_pool_patch_properties::PreferredAppGroupType>,
}
impl HostPoolPatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod host_pool_patch_properties {
    use super::*;
    #[doc = "PersonalDesktopAssignment type for HostPool."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PersonalDesktopAssignmentType {
        Automatic,
        Direct,
    }
    #[doc = "The type of the load balancer."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadBalancerType {
        BreadthFirst,
        DepthFirst,
        Persistent,
    }
    #[doc = "The type of preferred application group type, default to Desktop Application Group"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreferredAppGroupType {
        None,
        Desktop,
        RailApplications,
    }
}
#[doc = "Properties of HostPool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HostPoolProperties {
    #[doc = "Friendly name of HostPool."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Description of HostPool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "HostPool type for desktop."]
    #[serde(rename = "hostPoolType")]
    pub host_pool_type: host_pool_properties::HostPoolType,
    #[doc = "PersonalDesktopAssignment type for HostPool."]
    #[serde(rename = "personalDesktopAssignmentType", default, skip_serializing_if = "Option::is_none")]
    pub personal_desktop_assignment_type: Option<host_pool_properties::PersonalDesktopAssignmentType>,
    #[doc = "Custom rdp property of HostPool."]
    #[serde(rename = "customRdpProperty", default, skip_serializing_if = "Option::is_none")]
    pub custom_rdp_property: Option<String>,
    #[doc = "The max session limit of HostPool."]
    #[serde(rename = "maxSessionLimit", default, skip_serializing_if = "Option::is_none")]
    pub max_session_limit: Option<i64>,
    #[doc = "The type of the load balancer."]
    #[serde(rename = "loadBalancerType")]
    pub load_balancer_type: host_pool_properties::LoadBalancerType,
    #[doc = "The ring number of HostPool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub ring: Option<i64>,
    #[doc = "Is validation environment."]
    #[serde(rename = "validationEnvironment", default, skip_serializing_if = "Option::is_none")]
    pub validation_environment: Option<bool>,
    #[doc = "Represents a RegistrationInfo definition."]
    #[serde(rename = "registrationInfo", default, skip_serializing_if = "Option::is_none")]
    pub registration_info: Option<RegistrationInfo>,
    #[doc = "VM template for sessionhosts configuration within hostpool."]
    #[serde(rename = "vmTemplate", default, skip_serializing_if = "Option::is_none")]
    pub vm_template: Option<String>,
    #[doc = "List of applicationGroup links."]
    #[serde(rename = "applicationGroupReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_group_references: Vec<String>,
    #[doc = "Path to keyvault containing ssoContext secret."]
    #[serde(rename = "ssoContext", default, skip_serializing_if = "Option::is_none")]
    pub sso_context: Option<String>,
    #[doc = "The type of preferred application group type, default to Desktop Application Group"]
    #[serde(rename = "preferredAppGroupType")]
    pub preferred_app_group_type: host_pool_properties::PreferredAppGroupType,
}
impl HostPoolProperties {
    pub fn new(
        host_pool_type: host_pool_properties::HostPoolType,
        load_balancer_type: host_pool_properties::LoadBalancerType,
        preferred_app_group_type: host_pool_properties::PreferredAppGroupType,
    ) -> Self {
        Self {
            friendly_name: None,
            description: None,
            host_pool_type,
            personal_desktop_assignment_type: None,
            custom_rdp_property: None,
            max_session_limit: None,
            load_balancer_type,
            ring: None,
            validation_environment: None,
            registration_info: None,
            vm_template: None,
            application_group_references: Vec::new(),
            sso_context: None,
            preferred_app_group_type,
        }
    }
}
pub mod host_pool_properties {
    use super::*;
    #[doc = "HostPool type for desktop."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HostPoolType {
        Personal,
        Shared,
    }
    #[doc = "PersonalDesktopAssignment type for HostPool."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PersonalDesktopAssignmentType {
        Automatic,
        Direct,
    }
    #[doc = "The type of the load balancer."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadBalancerType {
        BreadthFirst,
        DepthFirst,
        Persistent,
    }
    #[doc = "The type of preferred application group type, default to Desktop Application Group"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreferredAppGroupType {
        None,
        Desktop,
        RailApplications,
    }
}
#[doc = "Represents a RegistrationInfo definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistrationInfo {
    #[doc = "Expiration time of registration token."]
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[doc = "The registration token base64 encoded string."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub token: Option<String>,
    #[doc = "The type of resetting the token."]
    #[serde(rename = "registrationTokenOperation", default, skip_serializing_if = "Option::is_none")]
    pub registration_token_operation: Option<registration_info::RegistrationTokenOperation>,
}
impl RegistrationInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod registration_info {
    use super::*;
    #[doc = "The type of resetting the token."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RegistrationTokenOperation {
        Delete,
        None,
        Update,
    }
}
#[doc = "Represents a RegistrationInfo definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistrationInfoPatch {
    #[doc = "The type of resetting the token."]
    #[serde(rename = "registrationTokenOperation", default, skip_serializing_if = "Option::is_none")]
    pub registration_token_operation: Option<registration_info_patch::RegistrationTokenOperation>,
}
impl RegistrationInfoPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod registration_info_patch {
    use super::*;
    #[doc = "The type of resetting the token."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RegistrationTokenOperation {
        Delete,
        None,
        Update,
    }
}
#[doc = "Common fields that are returned in the response for all Azure Resource Manager resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or \"Microsoft.Storage/storageAccounts\""]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Supported operation of this resource provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderOperation {
    #[doc = "Operation name, in format of {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Display metadata associated with the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<resource_provider_operation::Display>,
}
impl ResourceProviderOperation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_provider_operation {
    use super::*;
    #[doc = "Display metadata associated with the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Resource provider: Microsoft Desktop Virtualization."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource on which the operation is performed."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Type of operation: get, read, delete, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "Description of this operation."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result of the request to list operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderOperationList {
    #[doc = "List of operations supported by this resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceProviderOperation>,
}
impl ResourceProviderOperationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents message sent to a UserSession."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SendMessage {
    #[doc = "Title of message."]
    #[serde(rename = "messageTitle", default, skip_serializing_if = "Option::is_none")]
    pub message_title: Option<String>,
    #[doc = "Body of message."]
    #[serde(rename = "messageBody", default, skip_serializing_if = "Option::is_none")]
    pub message_body: Option<String>,
}
impl SendMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a SessionHost definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SessionHost {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Schema for SessionHost properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SessionHostProperties>,
}
impl SessionHost {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of SessionHost definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SessionHostList {
    #[doc = "List of SessionHost definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SessionHost>,
    #[doc = "Link to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SessionHostList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SessionHost properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SessionHostPatch {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "SessionHost properties that can be patched."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SessionHostPatchProperties>,
}
impl SessionHostPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SessionHost properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SessionHostPatchProperties {
    #[doc = "Allow a new session."]
    #[serde(rename = "allowNewSession", default, skip_serializing_if = "Option::is_none")]
    pub allow_new_session: Option<bool>,
    #[doc = "User assigned to SessionHost."]
    #[serde(rename = "assignedUser", default, skip_serializing_if = "Option::is_none")]
    pub assigned_user: Option<String>,
}
impl SessionHostPatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Schema for SessionHost properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SessionHostProperties {
    #[doc = "Last heart beat from SessionHost."]
    #[serde(rename = "lastHeartBeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heart_beat: Option<String>,
    #[doc = "Number of sessions on SessionHost."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sessions: Option<i64>,
    #[doc = "Version of agent on SessionHost."]
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[doc = "Allow a new session."]
    #[serde(rename = "allowNewSession", default, skip_serializing_if = "Option::is_none")]
    pub allow_new_session: Option<bool>,
    #[doc = "Virtual Machine Id of SessionHost's underlying virtual machine."]
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
    #[doc = "Resource Id of SessionHost's underlying virtual machine."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "User assigned to SessionHost."]
    #[serde(rename = "assignedUser", default, skip_serializing_if = "Option::is_none")]
    pub assigned_user: Option<String>,
    #[doc = "Status for a SessionHost."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<session_host_properties::Status>,
    #[doc = "The timestamp of the status."]
    #[serde(rename = "statusTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub status_timestamp: Option<String>,
    #[doc = "The version of the OS on the session host."]
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[doc = "The version of the side by side stack on the session host."]
    #[serde(rename = "sxSStackVersion", default, skip_serializing_if = "Option::is_none")]
    pub sx_s_stack_version: Option<String>,
    #[doc = "Update state of a SessionHost."]
    #[serde(rename = "updateState", default, skip_serializing_if = "Option::is_none")]
    pub update_state: Option<session_host_properties::UpdateState>,
    #[doc = "The timestamp of the last update."]
    #[serde(rename = "lastUpdateTime", default, skip_serializing_if = "Option::is_none")]
    pub last_update_time: Option<String>,
    #[doc = "The error message."]
    #[serde(rename = "updateErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub update_error_message: Option<String>,
}
impl SessionHostProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod session_host_properties {
    use super::*;
    #[doc = "Status for a SessionHost."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Available,
        Unavailable,
        Shutdown,
        Disconnected,
        Upgrading,
        UpgradeFailed,
    }
    #[doc = "Update state of a SessionHost."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UpdateState {
        Initial,
        Pending,
        Started,
        Succeeded,
        Failed,
    }
}
#[doc = "Represents a StartMenuItem definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StartMenuItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Schema for StartMenuItem properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StartMenuItemProperties>,
}
impl StartMenuItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of StartMenuItem definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StartMenuItemList {
    #[doc = "List of StartMenuItem definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<StartMenuItem>,
    #[doc = "Link to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl StartMenuItemList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Schema for StartMenuItem properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StartMenuItemProperties {
    #[doc = "Alias of StartMenuItem."]
    #[serde(rename = "appAlias", default, skip_serializing_if = "Option::is_none")]
    pub app_alias: Option<String>,
    #[doc = "Friendly name of StartMenuItem."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Path to the file of StartMenuItem."]
    #[serde(rename = "filePath", default, skip_serializing_if = "Option::is_none")]
    pub file_path: Option<String>,
    #[doc = "Command line arguments for StartMenuItem."]
    #[serde(rename = "commandLineArguments", default, skip_serializing_if = "Option::is_none")]
    pub command_line_arguments: Option<String>,
    #[doc = "Path to the icon."]
    #[serde(rename = "iconPath", default, skip_serializing_if = "Option::is_none")]
    pub icon_path: Option<String>,
    #[doc = "Index of the icon."]
    #[serde(rename = "iconIndex", default, skip_serializing_if = "Option::is_none")]
    pub icon_index: Option<i64>,
}
impl StartMenuItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The geo-location where the resource lives"]
    pub location: String,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            tags: None,
            location,
        }
    }
}
#[doc = "Represents a UserSession definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserSession {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Schema for UserSession properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserSessionProperties>,
}
impl UserSession {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of UserSession definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserSessionList {
    #[doc = "List of UserSession definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<UserSession>,
    #[doc = "Link to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UserSessionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Schema for UserSession properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserSessionProperties {
    #[doc = "The user principal name."]
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
    #[doc = "Application type of application."]
    #[serde(rename = "applicationType", default, skip_serializing_if = "Option::is_none")]
    pub application_type: Option<user_session_properties::ApplicationType>,
    #[doc = "State of user session."]
    #[serde(rename = "sessionState", default, skip_serializing_if = "Option::is_none")]
    pub session_state: Option<user_session_properties::SessionState>,
    #[doc = "The active directory user name."]
    #[serde(rename = "activeDirectoryUserName", default, skip_serializing_if = "Option::is_none")]
    pub active_directory_user_name: Option<String>,
    #[doc = "The timestamp of the user session create."]
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
}
impl UserSessionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod user_session_properties {
    use super::*;
    #[doc = "Application type of application."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ApplicationType {
        RemoteApp,
        Desktop,
    }
    #[doc = "State of user session."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SessionState {
        Unknown,
        Active,
        Disconnected,
        Pending,
        LogOff,
        UserProfileDiskMounted,
    }
}
#[doc = "Represents a Workspace definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Workspace {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Schema for Workspace properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkspaceProperties>,
}
impl Workspace {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
        }
    }
}
#[doc = "List of Workspace definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceList {
    #[doc = "List of Workspace definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Workspace>,
    #[doc = "Link to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkspaceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Workspace properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspacePatch {
    #[doc = "tags to be updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Workspace properties that can be patched."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkspacePatchProperties>,
}
impl WorkspacePatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Workspace properties that can be patched."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspacePatchProperties {
    #[doc = "Description of Workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Friendly name of Workspace."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "List of applicationGroup links."]
    #[serde(rename = "applicationGroupReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_group_references: Vec<String>,
}
impl WorkspacePatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Schema for Workspace properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceProperties {
    #[doc = "Description of Workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Friendly name of Workspace."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "List of applicationGroup resource Ids."]
    #[serde(rename = "applicationGroupReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_group_references: Vec<String>,
}
impl WorkspaceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
