#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen1FileDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: AdlsGen1FileProperties,
}
impl AdlsGen1FileDataSet {
    pub fn new(data_set: DataSet, properties: AdlsGen1FileProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen1FileProperties {
    #[serde(rename = "accountName")]
    pub account_name: String,
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "fileName")]
    pub file_name: String,
    #[serde(rename = "folderPath")]
    pub folder_path: String,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl AdlsGen1FileProperties {
    pub fn new(account_name: String, file_name: String, folder_path: String, resource_group: String, subscription_id: String) -> Self {
        Self {
            account_name,
            data_set_id: None,
            file_name,
            folder_path,
            resource_group,
            subscription_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen1FolderDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: AdlsGen1FolderProperties,
}
impl AdlsGen1FolderDataSet {
    pub fn new(data_set: DataSet, properties: AdlsGen1FolderProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen1FolderProperties {
    #[serde(rename = "accountName")]
    pub account_name: String,
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "folderPath")]
    pub folder_path: String,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl AdlsGen1FolderProperties {
    pub fn new(account_name: String, folder_path: String, resource_group: String, subscription_id: String) -> Self {
        Self {
            account_name,
            data_set_id: None,
            folder_path,
            resource_group,
            subscription_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FileDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: AdlsGen2FileProperties,
}
impl AdlsGen2FileDataSet {
    pub fn new(data_set: DataSet, properties: AdlsGen2FileProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FileDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: AdlsGen2FileDataSetMappingProperties,
}
impl AdlsGen2FileDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: AdlsGen2FileDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FileDataSetMappingProperties {
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<adls_gen2_file_data_set_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "filePath")]
    pub file_path: String,
    #[serde(rename = "fileSystem")]
    pub file_system: String,
    #[serde(rename = "outputType", default, skip_serializing_if = "Option::is_none")]
    pub output_type: Option<adls_gen2_file_data_set_mapping_properties::OutputType>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<adls_gen2_file_data_set_mapping_properties::ProvisioningState>,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl AdlsGen2FileDataSetMappingProperties {
    pub fn new(
        data_set_id: String,
        file_path: String,
        file_system: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            data_set_id,
            data_set_mapping_status: None,
            file_path,
            file_system,
            output_type: None,
            provisioning_state: None,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
pub mod adls_gen2_file_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OutputType {
        Csv,
        Parquet,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FileProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "filePath")]
    pub file_path: String,
    #[serde(rename = "fileSystem")]
    pub file_system: String,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl AdlsGen2FileProperties {
    pub fn new(
        file_path: String,
        file_system: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            data_set_id: None,
            file_path,
            file_system,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FileSystemDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: AdlsGen2FileSystemProperties,
}
impl AdlsGen2FileSystemDataSet {
    pub fn new(data_set: DataSet, properties: AdlsGen2FileSystemProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FileSystemDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: AdlsGen2FileSystemDataSetMappingProperties,
}
impl AdlsGen2FileSystemDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: AdlsGen2FileSystemDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FileSystemDataSetMappingProperties {
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<adls_gen2_file_system_data_set_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "fileSystem")]
    pub file_system: String,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<adls_gen2_file_system_data_set_mapping_properties::ProvisioningState>,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl AdlsGen2FileSystemDataSetMappingProperties {
    pub fn new(
        data_set_id: String,
        file_system: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            data_set_id,
            data_set_mapping_status: None,
            file_system,
            provisioning_state: None,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
pub mod adls_gen2_file_system_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FileSystemProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "fileSystem")]
    pub file_system: String,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl AdlsGen2FileSystemProperties {
    pub fn new(file_system: String, resource_group: String, storage_account_name: String, subscription_id: String) -> Self {
        Self {
            data_set_id: None,
            file_system,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FolderDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: AdlsGen2FolderProperties,
}
impl AdlsGen2FolderDataSet {
    pub fn new(data_set: DataSet, properties: AdlsGen2FolderProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FolderDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: AdlsGen2FolderDataSetMappingProperties,
}
impl AdlsGen2FolderDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: AdlsGen2FolderDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FolderDataSetMappingProperties {
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<adls_gen2_folder_data_set_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "fileSystem")]
    pub file_system: String,
    #[serde(rename = "folderPath")]
    pub folder_path: String,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<adls_gen2_folder_data_set_mapping_properties::ProvisioningState>,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl AdlsGen2FolderDataSetMappingProperties {
    pub fn new(
        data_set_id: String,
        file_system: String,
        folder_path: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            data_set_id,
            data_set_mapping_status: None,
            file_system,
            folder_path,
            provisioning_state: None,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
pub mod adls_gen2_folder_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2FolderProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "fileSystem")]
    pub file_system: String,
    #[serde(rename = "folderPath")]
    pub folder_path: String,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl AdlsGen2FolderProperties {
    pub fn new(
        file_system: String,
        folder_path: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            data_set_id: None,
            file_system,
            folder_path,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2StorageAccountDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: AdlsGen2StorageAccountDataSetProperties,
}
impl AdlsGen2StorageAccountDataSet {
    pub fn new(data_set: DataSet, properties: AdlsGen2StorageAccountDataSetProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2StorageAccountDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: AdlsGen2StorageAccountDataSetMappingProperties,
}
impl AdlsGen2StorageAccountDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: AdlsGen2StorageAccountDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2StorageAccountDataSetMappingProperties {
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<adls_gen2_storage_account_data_set_mapping_properties::DataSetMappingStatus>,
    pub folder: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "mountPath", default, skip_serializing_if = "Option::is_none")]
    pub mount_path: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<adls_gen2_storage_account_data_set_mapping_properties::ProvisioningState>,
    #[serde(rename = "storageAccountResourceId")]
    pub storage_account_resource_id: String,
}
impl AdlsGen2StorageAccountDataSetMappingProperties {
    pub fn new(container_name: String, data_set_id: String, folder: String, storage_account_resource_id: String) -> Self {
        Self {
            container_name,
            data_set_id,
            data_set_mapping_status: None,
            folder,
            location: None,
            mount_path: None,
            provisioning_state: None,
            storage_account_resource_id,
        }
    }
}
pub mod adls_gen2_storage_account_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2StorageAccountDataSetProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    pub paths: Vec<AdlsGen2StorageAccountPath>,
    #[serde(rename = "storageAccountResourceId")]
    pub storage_account_resource_id: String,
}
impl AdlsGen2StorageAccountDataSetProperties {
    pub fn new(paths: Vec<AdlsGen2StorageAccountPath>, storage_account_resource_id: String) -> Self {
        Self {
            data_set_id: None,
            location: None,
            paths,
            storage_account_resource_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2StorageAccountPath {
    #[serde(rename = "consumerPath", default, skip_serializing_if = "Option::is_none")]
    pub consumer_path: Option<String>,
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "providerPath", default, skip_serializing_if = "Option::is_none")]
    pub provider_path: Option<String>,
}
impl AdlsGen2StorageAccountPath {
    pub fn new(container_name: String) -> Self {
        Self {
            consumer_path: None,
            container_name,
            provider_path: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Account {
    #[serde(flatten)]
    pub default_dto: DefaultDto,
    pub identity: Identity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AccountProperties>,
}
impl Account {
    pub fn new(identity: Identity) -> Self {
        Self {
            default_dto: DefaultDto::default(),
            identity,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccountList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Account>,
}
impl AccountList {
    pub fn new(value: Vec<Account>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccountProperties {
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<account_properties::ProvisioningState>,
    #[serde(rename = "userEmail", default, skip_serializing_if = "Option::is_none")]
    pub user_email: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl AccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod account_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccountUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl AccountUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobContainerDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: BlobContainerProperties,
}
impl BlobContainerDataSet {
    pub fn new(data_set: DataSet, properties: BlobContainerProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobContainerDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: BlobContainerMappingProperties,
}
impl BlobContainerDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: BlobContainerMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobContainerMappingProperties {
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<blob_container_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<blob_container_mapping_properties::ProvisioningState>,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl BlobContainerMappingProperties {
    pub fn new(
        container_name: String,
        data_set_id: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            container_name,
            data_set_id,
            data_set_mapping_status: None,
            provisioning_state: None,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
pub mod blob_container_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobContainerProperties {
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl BlobContainerProperties {
    pub fn new(container_name: String, resource_group: String, storage_account_name: String, subscription_id: String) -> Self {
        Self {
            container_name,
            data_set_id: None,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: BlobProperties,
}
impl BlobDataSet {
    pub fn new(data_set: DataSet, properties: BlobProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: BlobMappingProperties,
}
impl BlobDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: BlobMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobFolderDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: BlobFolderProperties,
}
impl BlobFolderDataSet {
    pub fn new(data_set: DataSet, properties: BlobFolderProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobFolderDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: BlobFolderMappingProperties,
}
impl BlobFolderDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: BlobFolderMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobFolderMappingProperties {
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<blob_folder_mapping_properties::DataSetMappingStatus>,
    pub prefix: String,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<blob_folder_mapping_properties::ProvisioningState>,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl BlobFolderMappingProperties {
    pub fn new(
        container_name: String,
        data_set_id: String,
        prefix: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            container_name,
            data_set_id,
            data_set_mapping_status: None,
            prefix,
            provisioning_state: None,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
pub mod blob_folder_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobFolderProperties {
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    pub prefix: String,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl BlobFolderProperties {
    pub fn new(
        container_name: String,
        prefix: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            container_name,
            data_set_id: None,
            prefix,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobMappingProperties {
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<blob_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "filePath")]
    pub file_path: String,
    #[serde(rename = "outputType", default, skip_serializing_if = "Option::is_none")]
    pub output_type: Option<blob_mapping_properties::OutputType>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<blob_mapping_properties::ProvisioningState>,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl BlobMappingProperties {
    pub fn new(
        container_name: String,
        data_set_id: String,
        file_path: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            container_name,
            data_set_id,
            data_set_mapping_status: None,
            file_path,
            output_type: None,
            provisioning_state: None,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
pub mod blob_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OutputType {
        Csv,
        Parquet,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobProperties {
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "filePath")]
    pub file_path: String,
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
    #[serde(rename = "storageAccountName")]
    pub storage_account_name: String,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
}
impl BlobProperties {
    pub fn new(
        container_name: String,
        file_path: String,
        resource_group: String,
        storage_account_name: String,
        subscription_id: String,
    ) -> Self {
        Self {
            container_name,
            data_set_id: None,
            file_path,
            resource_group,
            storage_account_name,
            subscription_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobStorageAccountDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: BlobStorageAccountDataSetProperties,
}
impl BlobStorageAccountDataSet {
    pub fn new(data_set: DataSet, properties: BlobStorageAccountDataSetProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobStorageAccountDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: BlobStorageAccountDataSetMappingProperties,
}
impl BlobStorageAccountDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: BlobStorageAccountDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobStorageAccountDataSetMappingProperties {
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<blob_storage_account_data_set_mapping_properties::DataSetMappingStatus>,
    pub folder: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "mountPath", default, skip_serializing_if = "Option::is_none")]
    pub mount_path: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<blob_storage_account_data_set_mapping_properties::ProvisioningState>,
    #[serde(rename = "storageAccountResourceId")]
    pub storage_account_resource_id: String,
}
impl BlobStorageAccountDataSetMappingProperties {
    pub fn new(container_name: String, data_set_id: String, folder: String, storage_account_resource_id: String) -> Self {
        Self {
            container_name,
            data_set_id,
            data_set_mapping_status: None,
            folder,
            location: None,
            mount_path: None,
            provisioning_state: None,
            storage_account_resource_id,
        }
    }
}
pub mod blob_storage_account_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobStorageAccountDataSetProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    pub paths: Vec<BlobStorageAccountPath>,
    #[serde(rename = "storageAccountResourceId")]
    pub storage_account_resource_id: String,
}
impl BlobStorageAccountDataSetProperties {
    pub fn new(paths: Vec<BlobStorageAccountPath>, storage_account_resource_id: String) -> Self {
        Self {
            data_set_id: None,
            location: None,
            paths,
            storage_account_resource_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobStorageAccountPath {
    #[serde(rename = "consumerPath", default, skip_serializing_if = "Option::is_none")]
    pub consumer_path: Option<String>,
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "providerPath", default, skip_serializing_if = "Option::is_none")]
    pub provider_path: Option<String>,
}
impl BlobStorageAccountPath {
    pub fn new(container_name: String) -> Self {
        Self {
            consumer_path: None,
            container_name,
            provider_path: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsumerInvitation {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    pub properties: ConsumerInvitationProperties,
}
impl ConsumerInvitation {
    pub fn new(properties: ConsumerInvitationProperties) -> Self {
        Self {
            proxy_dto: ProxyDto::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsumerInvitationList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ConsumerInvitation>,
}
impl ConsumerInvitationList {
    pub fn new(value: Vec<ConsumerInvitation>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsumerInvitationProperties {
    #[serde(rename = "dataSetCount", default, skip_serializing_if = "Option::is_none")]
    pub data_set_count: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(rename = "invitationId")]
    pub invitation_id: String,
    #[serde(rename = "invitationStatus", default, skip_serializing_if = "Option::is_none")]
    pub invitation_status: Option<consumer_invitation_properties::InvitationStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "providerEmail", default, skip_serializing_if = "Option::is_none")]
    pub provider_email: Option<String>,
    #[serde(rename = "providerName", default, skip_serializing_if = "Option::is_none")]
    pub provider_name: Option<String>,
    #[serde(rename = "providerTenantName", default, skip_serializing_if = "Option::is_none")]
    pub provider_tenant_name: Option<String>,
    #[serde(rename = "respondedAt", default, skip_serializing_if = "Option::is_none")]
    pub responded_at: Option<String>,
    #[serde(rename = "sentAt", default, skip_serializing_if = "Option::is_none")]
    pub sent_at: Option<String>,
    #[serde(rename = "shareName", default, skip_serializing_if = "Option::is_none")]
    pub share_name: Option<String>,
    #[serde(rename = "termsOfUse", default, skip_serializing_if = "Option::is_none")]
    pub terms_of_use: Option<String>,
    #[serde(rename = "userEmail", default, skip_serializing_if = "Option::is_none")]
    pub user_email: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl ConsumerInvitationProperties {
    pub fn new(invitation_id: String) -> Self {
        Self {
            data_set_count: None,
            description: None,
            expiration_date: None,
            invitation_id,
            invitation_status: None,
            location: None,
            provider_email: None,
            provider_name: None,
            provider_tenant_name: None,
            responded_at: None,
            sent_at: None,
            share_name: None,
            terms_of_use: None,
            user_email: None,
            user_name: None,
        }
    }
}
pub mod consumer_invitation_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InvitationStatus {
        Pending,
        Accepted,
        Rejected,
        Withdrawn,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConsumerSourceDataSet {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConsumerSourceDataSetProperties>,
}
impl ConsumerSourceDataSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsumerSourceDataSetList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ConsumerSourceDataSet>,
}
impl ConsumerSourceDataSetList {
    pub fn new(value: Vec<ConsumerSourceDataSet>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConsumerSourceDataSetProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "dataSetLocation", default, skip_serializing_if = "Option::is_none")]
    pub data_set_location: Option<String>,
    #[serde(rename = "dataSetName", default, skip_serializing_if = "Option::is_none")]
    pub data_set_name: Option<String>,
    #[serde(rename = "dataSetPath", default, skip_serializing_if = "Option::is_none")]
    pub data_set_path: Option<String>,
    #[serde(rename = "dataSetType", default, skip_serializing_if = "Option::is_none")]
    pub data_set_type: Option<consumer_source_data_set_properties::DataSetType>,
}
impl ConsumerSourceDataSetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod consumer_source_data_set_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetType {
        Blob,
        Container,
        BlobFolder,
        AdlsGen2FileSystem,
        AdlsGen2Folder,
        AdlsGen2File,
        AdlsGen1Folder,
        AdlsGen1File,
        AdlsGen2StorageAccount,
        KustoCluster,
        KustoDatabase,
        #[serde(rename = "SqlDBTable")]
        SqlDbTable,
        #[serde(rename = "SqlDWTable")]
        SqlDwTable,
        SynapseWorkspaceSqlPoolTable,
        BlobStorageAccount,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataSet {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    pub kind: data_set::Kind,
}
impl DataSet {
    pub fn new(kind: data_set::Kind) -> Self {
        Self {
            proxy_dto: ProxyDto::default(),
            kind,
        }
    }
}
pub mod data_set {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Blob,
        Container,
        BlobFolder,
        AdlsGen2FileSystem,
        AdlsGen2Folder,
        AdlsGen2File,
        AdlsGen1Folder,
        AdlsGen1File,
        AdlsGen2StorageAccount,
        KustoCluster,
        KustoDatabase,
        #[serde(rename = "SqlDBTable")]
        SqlDbTable,
        #[serde(rename = "SqlDWTable")]
        SqlDwTable,
        SynapseWorkspaceSqlPoolTable,
        BlobStorageAccount,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataSetList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<DataSet>,
}
impl DataSetList {
    pub fn new(value: Vec<DataSet>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataSetMapping {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    pub kind: data_set_mapping::Kind,
}
impl DataSetMapping {
    pub fn new(kind: data_set_mapping::Kind) -> Self {
        Self {
            proxy_dto: ProxyDto::default(),
            kind,
        }
    }
}
pub mod data_set_mapping {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Blob,
        Container,
        BlobFolder,
        AdlsGen2FileSystem,
        AdlsGen2Folder,
        AdlsGen2File,
        AdlsGen2StorageAccount,
        KustoCluster,
        KustoDatabase,
        #[serde(rename = "SqlDBTable")]
        SqlDbTable,
        #[serde(rename = "SqlDWTable")]
        SqlDwTable,
        SynapseWorkspaceSqlPoolTable,
        BlobStorageAccount,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataSetMappingList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<DataSetMapping>,
}
impl DataSetMappingList {
    pub fn new(value: Vec<DataSetMapping>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataShareError {
    pub error: DataShareErrorInfo,
}
impl DataShareError {
    pub fn new(error: DataShareErrorInfo) -> Self {
        Self { error }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataShareErrorInfo {
    pub code: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<DataShareErrorInfo>,
    pub message: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl DataShareErrorInfo {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            details: Vec::new(),
            message,
            target: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultDto {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl DefaultDto {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DimensionProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl DimensionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Identity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity::Type>,
}
impl Identity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Invitation {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InvitationProperties>,
}
impl Invitation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InvitationList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Invitation>,
}
impl InvitationList {
    pub fn new(value: Vec<Invitation>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InvitationProperties {
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(rename = "invitationId", default, skip_serializing_if = "Option::is_none")]
    pub invitation_id: Option<String>,
    #[serde(rename = "invitationStatus", default, skip_serializing_if = "Option::is_none")]
    pub invitation_status: Option<invitation_properties::InvitationStatus>,
    #[serde(rename = "respondedAt", default, skip_serializing_if = "Option::is_none")]
    pub responded_at: Option<String>,
    #[serde(rename = "sentAt", default, skip_serializing_if = "Option::is_none")]
    pub sent_at: Option<String>,
    #[serde(rename = "targetActiveDirectoryId", default, skip_serializing_if = "Option::is_none")]
    pub target_active_directory_id: Option<String>,
    #[serde(rename = "targetEmail", default, skip_serializing_if = "Option::is_none")]
    pub target_email: Option<String>,
    #[serde(rename = "targetObjectId", default, skip_serializing_if = "Option::is_none")]
    pub target_object_id: Option<String>,
    #[serde(rename = "userEmail", default, skip_serializing_if = "Option::is_none")]
    pub user_email: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl InvitationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod invitation_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InvitationStatus {
        Pending,
        Accepted,
        Rejected,
        Withdrawn,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KustoClusterDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: KustoClusterDataSetProperties,
}
impl KustoClusterDataSet {
    pub fn new(data_set: DataSet, properties: KustoClusterDataSetProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KustoClusterDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: KustoClusterDataSetMappingProperties,
}
impl KustoClusterDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: KustoClusterDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KustoClusterDataSetMappingProperties {
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<kusto_cluster_data_set_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "kustoClusterResourceId")]
    pub kusto_cluster_resource_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<kusto_cluster_data_set_mapping_properties::ProvisioningState>,
}
impl KustoClusterDataSetMappingProperties {
    pub fn new(data_set_id: String, kusto_cluster_resource_id: String) -> Self {
        Self {
            data_set_id,
            data_set_mapping_status: None,
            kusto_cluster_resource_id,
            location: None,
            provisioning_state: None,
        }
    }
}
pub mod kusto_cluster_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KustoClusterDataSetProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "kustoClusterResourceId")]
    pub kusto_cluster_resource_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<kusto_cluster_data_set_properties::ProvisioningState>,
}
impl KustoClusterDataSetProperties {
    pub fn new(kusto_cluster_resource_id: String) -> Self {
        Self {
            data_set_id: None,
            kusto_cluster_resource_id,
            location: None,
            provisioning_state: None,
        }
    }
}
pub mod kusto_cluster_data_set_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KustoDatabaseDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: KustoDatabaseDataSetProperties,
}
impl KustoDatabaseDataSet {
    pub fn new(data_set: DataSet, properties: KustoDatabaseDataSetProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KustoDatabaseDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: KustoDatabaseDataSetMappingProperties,
}
impl KustoDatabaseDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: KustoDatabaseDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KustoDatabaseDataSetMappingProperties {
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<kusto_database_data_set_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "kustoClusterResourceId")]
    pub kusto_cluster_resource_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<kusto_database_data_set_mapping_properties::ProvisioningState>,
}
impl KustoDatabaseDataSetMappingProperties {
    pub fn new(data_set_id: String, kusto_cluster_resource_id: String) -> Self {
        Self {
            data_set_id,
            data_set_mapping_status: None,
            kusto_cluster_resource_id,
            location: None,
            provisioning_state: None,
        }
    }
}
pub mod kusto_database_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KustoDatabaseDataSetProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "kustoDatabaseResourceId")]
    pub kusto_database_resource_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<kusto_database_data_set_properties::ProvisioningState>,
}
impl KustoDatabaseDataSetProperties {
    pub fn new(kusto_database_resource_id: String) -> Self {
        Self {
            data_set_id: None,
            kusto_database_resource_id,
            location: None,
            provisioning_state: None,
        }
    }
}
pub mod kusto_database_data_set_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<OperationModel>,
}
impl OperationList {
    pub fn new(value: Vec<OperationModel>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetaLogSpecification {
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl OperationMetaLogSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetaMetricSpecification {
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<DimensionProperties>,
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "enableRegionalMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub enable_regional_mdm_account: Option<String>,
    #[serde(rename = "fillGapWithZero", default, skip_serializing_if = "Option::is_none")]
    pub fill_gap_with_zero: Option<bool>,
    #[serde(rename = "internalMetricName", default, skip_serializing_if = "Option::is_none")]
    pub internal_metric_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "resourceIdDimensionNameOverride", default, skip_serializing_if = "Option::is_none")]
    pub resource_id_dimension_name_override: Option<String>,
    #[serde(rename = "supportedAggregationTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_aggregation_types: Vec<String>,
    #[serde(rename = "supportedTimeGrainTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_time_grain_types: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
}
impl OperationMetaMetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetaPropertyInfo {
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<OperationMetaServiceSpecification>,
}
impl OperationMetaPropertyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetaServiceSpecification {
    #[serde(rename = "logSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub log_specifications: Vec<OperationMetaLogSpecification>,
    #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_specifications: Vec<OperationMetaMetricSpecification>,
}
impl OperationMetaServiceSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationModel {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationModelProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationMetaPropertyInfo>,
}
impl OperationModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationModelProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
}
impl OperationModelProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationResponse {
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<DataShareErrorInfo>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    pub status: operation_response::Status,
}
impl OperationResponse {
    pub fn new(status: operation_response::Status) -> Self {
        Self {
            end_time: None,
            error: None,
            start_time: None,
            status,
        }
    }
}
pub mod operation_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Accepted,
        InProgress,
        TransientFailure,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderShareSubscription {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProviderShareSubscriptionProperties>,
}
impl ProviderShareSubscription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProviderShareSubscriptionList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ProviderShareSubscription>,
}
impl ProviderShareSubscriptionList {
    pub fn new(value: Vec<ProviderShareSubscription>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderShareSubscriptionProperties {
    #[serde(rename = "consumerEmail", default, skip_serializing_if = "Option::is_none")]
    pub consumer_email: Option<String>,
    #[serde(rename = "consumerName", default, skip_serializing_if = "Option::is_none")]
    pub consumer_name: Option<String>,
    #[serde(rename = "consumerTenantName", default, skip_serializing_if = "Option::is_none")]
    pub consumer_tenant_name: Option<String>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(rename = "providerEmail", default, skip_serializing_if = "Option::is_none")]
    pub provider_email: Option<String>,
    #[serde(rename = "providerName", default, skip_serializing_if = "Option::is_none")]
    pub provider_name: Option<String>,
    #[serde(rename = "sharedAt", default, skip_serializing_if = "Option::is_none")]
    pub shared_at: Option<String>,
    #[serde(rename = "shareSubscriptionObjectId", default, skip_serializing_if = "Option::is_none")]
    pub share_subscription_object_id: Option<String>,
    #[serde(rename = "shareSubscriptionStatus", default, skip_serializing_if = "Option::is_none")]
    pub share_subscription_status: Option<provider_share_subscription_properties::ShareSubscriptionStatus>,
}
impl ProviderShareSubscriptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod provider_share_subscription_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ShareSubscriptionStatus {
        Active,
        Revoked,
        SourceDeleted,
        Revoking,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyDto {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ProxyDto {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduledSourceShareSynchronizationSettingProperties {
    #[serde(rename = "recurrenceInterval", default, skip_serializing_if = "Option::is_none")]
    pub recurrence_interval: Option<scheduled_source_share_synchronization_setting_properties::RecurrenceInterval>,
    #[serde(rename = "synchronizationTime", default, skip_serializing_if = "Option::is_none")]
    pub synchronization_time: Option<String>,
}
impl ScheduledSourceShareSynchronizationSettingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod scheduled_source_share_synchronization_setting_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecurrenceInterval {
        Hour,
        Day,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledSourceSynchronizationSetting {
    #[serde(flatten)]
    pub source_share_synchronization_setting: SourceShareSynchronizationSetting,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScheduledSourceShareSynchronizationSettingProperties>,
}
impl ScheduledSourceSynchronizationSetting {
    pub fn new(source_share_synchronization_setting: SourceShareSynchronizationSetting) -> Self {
        Self {
            source_share_synchronization_setting,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledSynchronizationSetting {
    #[serde(flatten)]
    pub synchronization_setting: SynchronizationSetting,
    pub properties: ScheduledSynchronizationSettingProperties,
}
impl ScheduledSynchronizationSetting {
    pub fn new(synchronization_setting: SynchronizationSetting, properties: ScheduledSynchronizationSettingProperties) -> Self {
        Self {
            synchronization_setting,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledSynchronizationSettingProperties {
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<scheduled_synchronization_setting_properties::ProvisioningState>,
    #[serde(rename = "recurrenceInterval")]
    pub recurrence_interval: scheduled_synchronization_setting_properties::RecurrenceInterval,
    #[serde(rename = "synchronizationTime")]
    pub synchronization_time: String,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl ScheduledSynchronizationSettingProperties {
    pub fn new(
        recurrence_interval: scheduled_synchronization_setting_properties::RecurrenceInterval,
        synchronization_time: String,
    ) -> Self {
        Self {
            created_at: None,
            provisioning_state: None,
            recurrence_interval,
            synchronization_time,
            user_name: None,
        }
    }
}
pub mod scheduled_synchronization_setting_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecurrenceInterval {
        Hour,
        Day,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledTrigger {
    #[serde(flatten)]
    pub trigger: Trigger,
    pub properties: ScheduledTriggerProperties,
}
impl ScheduledTrigger {
    pub fn new(trigger: Trigger, properties: ScheduledTriggerProperties) -> Self {
        Self { trigger, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledTriggerProperties {
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<scheduled_trigger_properties::ProvisioningState>,
    #[serde(rename = "recurrenceInterval")]
    pub recurrence_interval: scheduled_trigger_properties::RecurrenceInterval,
    #[serde(rename = "synchronizationMode", default, skip_serializing_if = "Option::is_none")]
    pub synchronization_mode: Option<scheduled_trigger_properties::SynchronizationMode>,
    #[serde(rename = "synchronizationTime")]
    pub synchronization_time: String,
    #[serde(rename = "triggerStatus", default, skip_serializing_if = "Option::is_none")]
    pub trigger_status: Option<scheduled_trigger_properties::TriggerStatus>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl ScheduledTriggerProperties {
    pub fn new(recurrence_interval: scheduled_trigger_properties::RecurrenceInterval, synchronization_time: String) -> Self {
        Self {
            created_at: None,
            provisioning_state: None,
            recurrence_interval,
            synchronization_mode: None,
            synchronization_time,
            trigger_status: None,
            user_name: None,
        }
    }
}
pub mod scheduled_trigger_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecurrenceInterval {
        Hour,
        Day,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SynchronizationMode {
        Incremental,
        FullSync,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TriggerStatus {
        Active,
        Inactive,
        SourceSynchronizationSettingDeleted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Share {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ShareProperties>,
}
impl Share {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShareList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Share>,
}
impl ShareList {
    pub fn new(value: Vec<Share>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShareProperties {
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<share_properties::ProvisioningState>,
    #[serde(rename = "shareKind", default, skip_serializing_if = "Option::is_none")]
    pub share_kind: Option<share_properties::ShareKind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub terms: Option<String>,
    #[serde(rename = "userEmail", default, skip_serializing_if = "Option::is_none")]
    pub user_email: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl ShareProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod share_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ShareKind {
        CopyBased,
        InPlace,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShareSubscription {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    pub properties: ShareSubscriptionProperties,
}
impl ShareSubscription {
    pub fn new(properties: ShareSubscriptionProperties) -> Self {
        Self {
            proxy_dto: ProxyDto::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShareSubscriptionList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ShareSubscription>,
}
impl ShareSubscriptionList {
    pub fn new(value: Vec<ShareSubscription>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShareSubscriptionProperties {
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(rename = "invitationId")]
    pub invitation_id: String,
    #[serde(rename = "providerEmail", default, skip_serializing_if = "Option::is_none")]
    pub provider_email: Option<String>,
    #[serde(rename = "providerName", default, skip_serializing_if = "Option::is_none")]
    pub provider_name: Option<String>,
    #[serde(rename = "providerTenantName", default, skip_serializing_if = "Option::is_none")]
    pub provider_tenant_name: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<share_subscription_properties::ProvisioningState>,
    #[serde(rename = "shareDescription", default, skip_serializing_if = "Option::is_none")]
    pub share_description: Option<String>,
    #[serde(rename = "shareKind", default, skip_serializing_if = "Option::is_none")]
    pub share_kind: Option<share_subscription_properties::ShareKind>,
    #[serde(rename = "shareName", default, skip_serializing_if = "Option::is_none")]
    pub share_name: Option<String>,
    #[serde(rename = "shareSubscriptionStatus", default, skip_serializing_if = "Option::is_none")]
    pub share_subscription_status: Option<share_subscription_properties::ShareSubscriptionStatus>,
    #[serde(rename = "shareTerms", default, skip_serializing_if = "Option::is_none")]
    pub share_terms: Option<String>,
    #[serde(rename = "sourceShareLocation")]
    pub source_share_location: String,
    #[serde(rename = "userEmail", default, skip_serializing_if = "Option::is_none")]
    pub user_email: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl ShareSubscriptionProperties {
    pub fn new(invitation_id: String, source_share_location: String) -> Self {
        Self {
            created_at: None,
            expiration_date: None,
            invitation_id,
            provider_email: None,
            provider_name: None,
            provider_tenant_name: None,
            provisioning_state: None,
            share_description: None,
            share_kind: None,
            share_name: None,
            share_subscription_status: None,
            share_terms: None,
            source_share_location,
            user_email: None,
            user_name: None,
        }
    }
}
pub mod share_subscription_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ShareKind {
        CopyBased,
        InPlace,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ShareSubscriptionStatus {
        Active,
        Revoked,
        SourceDeleted,
        Revoking,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShareSubscriptionSynchronization {
    #[serde(rename = "durationMs", default, skip_serializing_if = "Option::is_none")]
    pub duration_ms: Option<i32>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "synchronizationId")]
    pub synchronization_id: String,
    #[serde(rename = "synchronizationMode", default, skip_serializing_if = "Option::is_none")]
    pub synchronization_mode: Option<share_subscription_synchronization::SynchronizationMode>,
}
impl ShareSubscriptionSynchronization {
    pub fn new(synchronization_id: String) -> Self {
        Self {
            duration_ms: None,
            end_time: None,
            message: None,
            start_time: None,
            status: None,
            synchronization_id,
            synchronization_mode: None,
        }
    }
}
pub mod share_subscription_synchronization {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SynchronizationMode {
        Incremental,
        FullSync,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShareSubscriptionSynchronizationList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ShareSubscriptionSynchronization>,
}
impl ShareSubscriptionSynchronizationList {
    pub fn new(value: Vec<ShareSubscriptionSynchronization>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShareSynchronization {
    #[serde(rename = "consumerEmail", default, skip_serializing_if = "Option::is_none")]
    pub consumer_email: Option<String>,
    #[serde(rename = "consumerName", default, skip_serializing_if = "Option::is_none")]
    pub consumer_name: Option<String>,
    #[serde(rename = "consumerTenantName", default, skip_serializing_if = "Option::is_none")]
    pub consumer_tenant_name: Option<String>,
    #[serde(rename = "durationMs", default, skip_serializing_if = "Option::is_none")]
    pub duration_ms: Option<i32>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "synchronizationId", default, skip_serializing_if = "Option::is_none")]
    pub synchronization_id: Option<String>,
    #[serde(rename = "synchronizationMode", default, skip_serializing_if = "Option::is_none")]
    pub synchronization_mode: Option<share_synchronization::SynchronizationMode>,
}
impl ShareSynchronization {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod share_synchronization {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SynchronizationMode {
        Incremental,
        FullSync,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShareSynchronizationList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ShareSynchronization>,
}
impl ShareSynchronizationList {
    pub fn new(value: Vec<ShareSynchronization>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceShareSynchronizationSetting {
    pub kind: source_share_synchronization_setting::Kind,
}
impl SourceShareSynchronizationSetting {
    pub fn new(kind: source_share_synchronization_setting::Kind) -> Self {
        Self { kind }
    }
}
pub mod source_share_synchronization_setting {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        ScheduleBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceShareSynchronizationSettingList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<SourceShareSynchronizationSetting>,
}
impl SourceShareSynchronizationSettingList {
    pub fn new(value: Vec<SourceShareSynchronizationSetting>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDbTableDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlDbTableProperties>,
}
impl SqlDbTableDataSet {
    pub fn new(data_set: DataSet) -> Self {
        Self {
            data_set,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDbTableDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: SqlDbTableDataSetMappingProperties,
}
impl SqlDbTableDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: SqlDbTableDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDbTableDataSetMappingProperties {
    #[serde(rename = "databaseName")]
    pub database_name: String,
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<sql_db_table_data_set_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<sql_db_table_data_set_mapping_properties::ProvisioningState>,
    #[serde(rename = "schemaName")]
    pub schema_name: String,
    #[serde(rename = "sqlServerResourceId")]
    pub sql_server_resource_id: String,
    #[serde(rename = "tableName")]
    pub table_name: String,
}
impl SqlDbTableDataSetMappingProperties {
    pub fn new(
        database_name: String,
        data_set_id: String,
        schema_name: String,
        sql_server_resource_id: String,
        table_name: String,
    ) -> Self {
        Self {
            database_name,
            data_set_id,
            data_set_mapping_status: None,
            provisioning_state: None,
            schema_name,
            sql_server_resource_id,
            table_name,
        }
    }
}
pub mod sql_db_table_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDbTableProperties {
    #[serde(rename = "databaseName")]
    pub database_name: String,
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "schemaName")]
    pub schema_name: String,
    #[serde(rename = "sqlServerResourceId")]
    pub sql_server_resource_id: String,
    #[serde(rename = "tableName")]
    pub table_name: String,
}
impl SqlDbTableProperties {
    pub fn new(database_name: String, schema_name: String, sql_server_resource_id: String, table_name: String) -> Self {
        Self {
            database_name,
            data_set_id: None,
            schema_name,
            sql_server_resource_id,
            table_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDwTableDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlDwTableProperties>,
}
impl SqlDwTableDataSet {
    pub fn new(data_set: DataSet) -> Self {
        Self {
            data_set,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDwTableDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: SqlDwTableDataSetMappingProperties,
}
impl SqlDwTableDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: SqlDwTableDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDwTableDataSetMappingProperties {
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<sql_dw_table_data_set_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "dataWarehouseName")]
    pub data_warehouse_name: String,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<sql_dw_table_data_set_mapping_properties::ProvisioningState>,
    #[serde(rename = "schemaName")]
    pub schema_name: String,
    #[serde(rename = "sqlServerResourceId")]
    pub sql_server_resource_id: String,
    #[serde(rename = "tableName")]
    pub table_name: String,
}
impl SqlDwTableDataSetMappingProperties {
    pub fn new(
        data_set_id: String,
        data_warehouse_name: String,
        schema_name: String,
        sql_server_resource_id: String,
        table_name: String,
    ) -> Self {
        Self {
            data_set_id,
            data_set_mapping_status: None,
            data_warehouse_name,
            provisioning_state: None,
            schema_name,
            sql_server_resource_id,
            table_name,
        }
    }
}
pub mod sql_dw_table_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDwTableProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "dataWarehouseName")]
    pub data_warehouse_name: String,
    #[serde(rename = "schemaName")]
    pub schema_name: String,
    #[serde(rename = "sqlServerResourceId")]
    pub sql_server_resource_id: String,
    #[serde(rename = "tableName")]
    pub table_name: String,
}
impl SqlDwTableProperties {
    pub fn new(data_warehouse_name: String, schema_name: String, sql_server_resource_id: String, table_name: String) -> Self {
        Self {
            data_set_id: None,
            data_warehouse_name,
            schema_name,
            sql_server_resource_id,
            table_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseWorkspaceSqlPoolTableDataSet {
    #[serde(flatten)]
    pub data_set: DataSet,
    pub properties: SynapseWorkspaceSqlPoolTableDataSetProperties,
}
impl SynapseWorkspaceSqlPoolTableDataSet {
    pub fn new(data_set: DataSet, properties: SynapseWorkspaceSqlPoolTableDataSetProperties) -> Self {
        Self { data_set, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseWorkspaceSqlPoolTableDataSetMapping {
    #[serde(flatten)]
    pub data_set_mapping: DataSetMapping,
    pub properties: SynapseWorkspaceSqlPoolTableDataSetMappingProperties,
}
impl SynapseWorkspaceSqlPoolTableDataSetMapping {
    pub fn new(data_set_mapping: DataSetMapping, properties: SynapseWorkspaceSqlPoolTableDataSetMappingProperties) -> Self {
        Self {
            data_set_mapping,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseWorkspaceSqlPoolTableDataSetMappingProperties {
    #[serde(rename = "dataSetId")]
    pub data_set_id: String,
    #[serde(rename = "dataSetMappingStatus", default, skip_serializing_if = "Option::is_none")]
    pub data_set_mapping_status: Option<synapse_workspace_sql_pool_table_data_set_mapping_properties::DataSetMappingStatus>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<synapse_workspace_sql_pool_table_data_set_mapping_properties::ProvisioningState>,
    #[serde(rename = "synapseWorkspaceSqlPoolTableResourceId")]
    pub synapse_workspace_sql_pool_table_resource_id: String,
}
impl SynapseWorkspaceSqlPoolTableDataSetMappingProperties {
    pub fn new(data_set_id: String, synapse_workspace_sql_pool_table_resource_id: String) -> Self {
        Self {
            data_set_id,
            data_set_mapping_status: None,
            provisioning_state: None,
            synapse_workspace_sql_pool_table_resource_id,
        }
    }
}
pub mod synapse_workspace_sql_pool_table_data_set_mapping_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetMappingStatus {
        Ok,
        Broken,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Creating,
        Deleting,
        Moving,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseWorkspaceSqlPoolTableDataSetProperties {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "synapseWorkspaceSqlPoolTableResourceId")]
    pub synapse_workspace_sql_pool_table_resource_id: String,
}
impl SynapseWorkspaceSqlPoolTableDataSetProperties {
    pub fn new(synapse_workspace_sql_pool_table_resource_id: String) -> Self {
        Self {
            data_set_id: None,
            synapse_workspace_sql_pool_table_resource_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SynchronizationDetails {
    #[serde(rename = "dataSetId", default, skip_serializing_if = "Option::is_none")]
    pub data_set_id: Option<String>,
    #[serde(rename = "dataSetType", default, skip_serializing_if = "Option::is_none")]
    pub data_set_type: Option<synchronization_details::DataSetType>,
    #[serde(rename = "durationMs", default, skip_serializing_if = "Option::is_none")]
    pub duration_ms: Option<i32>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "filesRead", default, skip_serializing_if = "Option::is_none")]
    pub files_read: Option<i64>,
    #[serde(rename = "filesWritten", default, skip_serializing_if = "Option::is_none")]
    pub files_written: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "rowsCopied", default, skip_serializing_if = "Option::is_none")]
    pub rows_copied: Option<i64>,
    #[serde(rename = "rowsRead", default, skip_serializing_if = "Option::is_none")]
    pub rows_read: Option<i64>,
    #[serde(rename = "sizeRead", default, skip_serializing_if = "Option::is_none")]
    pub size_read: Option<i64>,
    #[serde(rename = "sizeWritten", default, skip_serializing_if = "Option::is_none")]
    pub size_written: Option<i64>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "vCore", default, skip_serializing_if = "Option::is_none")]
    pub v_core: Option<i64>,
}
impl SynchronizationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod synchronization_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSetType {
        Blob,
        Container,
        BlobFolder,
        AdlsGen2FileSystem,
        AdlsGen2Folder,
        AdlsGen2File,
        AdlsGen1Folder,
        AdlsGen1File,
        AdlsGen2StorageAccount,
        KustoCluster,
        KustoDatabase,
        #[serde(rename = "SqlDBTable")]
        SqlDbTable,
        #[serde(rename = "SqlDWTable")]
        SqlDwTable,
        SynapseWorkspaceSqlPoolTable,
        BlobStorageAccount,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynchronizationDetailsList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<SynchronizationDetails>,
}
impl SynchronizationDetailsList {
    pub fn new(value: Vec<SynchronizationDetails>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynchronizationSetting {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    pub kind: synchronization_setting::Kind,
}
impl SynchronizationSetting {
    pub fn new(kind: synchronization_setting::Kind) -> Self {
        Self {
            proxy_dto: ProxyDto::default(),
            kind,
        }
    }
}
pub mod synchronization_setting {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        ScheduleBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynchronizationSettingList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<SynchronizationSetting>,
}
impl SynchronizationSettingList {
    pub fn new(value: Vec<SynchronizationSetting>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Synchronize {
    #[serde(rename = "synchronizationMode", default, skip_serializing_if = "Option::is_none")]
    pub synchronization_mode: Option<synchronize::SynchronizationMode>,
}
impl Synchronize {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod synchronize {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SynchronizationMode {
        Incremental,
        FullSync,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Trigger {
    #[serde(flatten)]
    pub proxy_dto: ProxyDto,
    pub kind: trigger::Kind,
}
impl Trigger {
    pub fn new(kind: trigger::Kind) -> Self {
        Self {
            proxy_dto: ProxyDto::default(),
            kind,
        }
    }
}
pub mod trigger {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        ScheduleBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Trigger>,
}
impl TriggerList {
    pub fn new(value: Vec<Trigger>) -> Self {
        Self { next_link: None, value }
    }
}
