#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CapabilityInformation {
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<capability_information::State>,
    #[serde(rename = "maxAccountCount", default, skip_serializing_if = "Option::is_none")]
    pub max_account_count: Option<i32>,
    #[serde(rename = "accountCount", default, skip_serializing_if = "Option::is_none")]
    pub account_count: Option<i32>,
    #[serde(rename = "migrationState", default, skip_serializing_if = "Option::is_none")]
    pub migration_state: Option<bool>,
}
impl CapabilityInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod capability_information {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Registered,
        Suspended,
        Deleted,
        Unregistered,
        Warned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckNameAvailabilityParameters {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: check_name_availability_parameters::Type,
}
impl CheckNameAvailabilityParameters {
    pub fn new(name: String, type_: check_name_availability_parameters::Type) -> Self {
        Self { name, type_ }
    }
}
pub mod check_name_availability_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.DataLakeStore/accounts")]
        MicrosoftDataLakeStoreAccounts,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateDataLakeStoreAccountParameters {
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<EncryptionIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreateDataLakeStoreAccountProperties>,
}
impl CreateDataLakeStoreAccountParameters {
    pub fn new(location: String) -> Self {
        Self {
            location,
            tags: None,
            identity: None,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateDataLakeStoreAccountProperties {
    #[serde(rename = "defaultGroup", default, skip_serializing_if = "Option::is_none")]
    pub default_group: Option<String>,
    #[serde(rename = "encryptionConfig", default, skip_serializing_if = "Option::is_none")]
    pub encryption_config: Option<EncryptionConfig>,
    #[serde(rename = "encryptionState", default, skip_serializing_if = "Option::is_none")]
    pub encryption_state: Option<create_data_lake_store_account_properties::EncryptionState>,
    #[serde(rename = "firewallRules", default, skip_serializing_if = "Vec::is_empty")]
    pub firewall_rules: Vec<CreateFirewallRuleWithAccountParameters>,
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<CreateVirtualNetworkRuleWithAccountParameters>,
    #[serde(rename = "firewallState", default, skip_serializing_if = "Option::is_none")]
    pub firewall_state: Option<create_data_lake_store_account_properties::FirewallState>,
    #[serde(rename = "firewallAllowAzureIps", default, skip_serializing_if = "Option::is_none")]
    pub firewall_allow_azure_ips: Option<create_data_lake_store_account_properties::FirewallAllowAzureIps>,
    #[serde(rename = "trustedIdProviders", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_id_providers: Vec<CreateTrustedIdProviderWithAccountParameters>,
    #[serde(rename = "trustedIdProviderState", default, skip_serializing_if = "Option::is_none")]
    pub trusted_id_provider_state: Option<create_data_lake_store_account_properties::TrustedIdProviderState>,
    #[serde(rename = "newTier", default, skip_serializing_if = "Option::is_none")]
    pub new_tier: Option<create_data_lake_store_account_properties::NewTier>,
}
impl CreateDataLakeStoreAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod create_data_lake_store_account_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EncryptionState {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirewallState {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirewallAllowAzureIps {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TrustedIdProviderState {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NewTier {
        Consumption,
        #[serde(rename = "Commitment_1TB")]
        Commitment1tb,
        #[serde(rename = "Commitment_10TB")]
        Commitment10tb,
        #[serde(rename = "Commitment_100TB")]
        Commitment100tb,
        #[serde(rename = "Commitment_500TB")]
        Commitment500tb,
        #[serde(rename = "Commitment_1PB")]
        Commitment1pb,
        #[serde(rename = "Commitment_5PB")]
        Commitment5pb,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateFirewallRuleWithAccountParameters {
    pub name: String,
    pub properties: CreateOrUpdateFirewallRuleProperties,
}
impl CreateFirewallRuleWithAccountParameters {
    pub fn new(name: String, properties: CreateOrUpdateFirewallRuleProperties) -> Self {
        Self { name, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateOrUpdateFirewallRuleParameters {
    pub properties: CreateOrUpdateFirewallRuleProperties,
}
impl CreateOrUpdateFirewallRuleParameters {
    pub fn new(properties: CreateOrUpdateFirewallRuleProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateOrUpdateFirewallRuleProperties {
    #[serde(rename = "startIpAddress")]
    pub start_ip_address: String,
    #[serde(rename = "endIpAddress")]
    pub end_ip_address: String,
}
impl CreateOrUpdateFirewallRuleProperties {
    pub fn new(start_ip_address: String, end_ip_address: String) -> Self {
        Self {
            start_ip_address,
            end_ip_address,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateOrUpdateTrustedIdProviderParameters {
    pub properties: CreateOrUpdateTrustedIdProviderProperties,
}
impl CreateOrUpdateTrustedIdProviderParameters {
    pub fn new(properties: CreateOrUpdateTrustedIdProviderProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateOrUpdateTrustedIdProviderProperties {
    #[serde(rename = "idProvider")]
    pub id_provider: String,
}
impl CreateOrUpdateTrustedIdProviderProperties {
    pub fn new(id_provider: String) -> Self {
        Self { id_provider }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateOrUpdateVirtualNetworkRuleParameters {
    pub properties: CreateOrUpdateVirtualNetworkRuleProperties,
}
impl CreateOrUpdateVirtualNetworkRuleParameters {
    pub fn new(properties: CreateOrUpdateVirtualNetworkRuleProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateOrUpdateVirtualNetworkRuleProperties {
    #[serde(rename = "subnetId")]
    pub subnet_id: String,
}
impl CreateOrUpdateVirtualNetworkRuleProperties {
    pub fn new(subnet_id: String) -> Self {
        Self { subnet_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateTrustedIdProviderWithAccountParameters {
    pub name: String,
    pub properties: CreateOrUpdateTrustedIdProviderProperties,
}
impl CreateTrustedIdProviderWithAccountParameters {
    pub fn new(name: String, properties: CreateOrUpdateTrustedIdProviderProperties) -> Self {
        Self { name, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateVirtualNetworkRuleWithAccountParameters {
    pub name: String,
    pub properties: CreateOrUpdateVirtualNetworkRuleProperties,
}
impl CreateVirtualNetworkRuleWithAccountParameters {
    pub fn new(name: String, properties: CreateOrUpdateVirtualNetworkRuleProperties) -> Self {
        Self { name, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataLakeStoreAccount {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<EncryptionIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DataLakeStoreAccountProperties>,
}
impl DataLakeStoreAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataLakeStoreAccountBasic {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DataLakeStoreAccountPropertiesBasic>,
}
impl DataLakeStoreAccountBasic {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataLakeStoreAccountListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DataLakeStoreAccountBasic>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DataLakeStoreAccountListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataLakeStoreAccountProperties {
    #[serde(flatten)]
    pub data_lake_store_account_properties_basic: DataLakeStoreAccountPropertiesBasic,
    #[serde(rename = "defaultGroup", default, skip_serializing_if = "Option::is_none")]
    pub default_group: Option<String>,
    #[serde(rename = "encryptionConfig", default, skip_serializing_if = "Option::is_none")]
    pub encryption_config: Option<EncryptionConfig>,
    #[serde(rename = "encryptionState", default, skip_serializing_if = "Option::is_none")]
    pub encryption_state: Option<data_lake_store_account_properties::EncryptionState>,
    #[serde(rename = "encryptionProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub encryption_provisioning_state: Option<data_lake_store_account_properties::EncryptionProvisioningState>,
    #[serde(rename = "firewallRules", default, skip_serializing_if = "Vec::is_empty")]
    pub firewall_rules: Vec<FirewallRule>,
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<VirtualNetworkRule>,
    #[serde(rename = "firewallState", default, skip_serializing_if = "Option::is_none")]
    pub firewall_state: Option<data_lake_store_account_properties::FirewallState>,
    #[serde(rename = "firewallAllowAzureIps", default, skip_serializing_if = "Option::is_none")]
    pub firewall_allow_azure_ips: Option<data_lake_store_account_properties::FirewallAllowAzureIps>,
    #[serde(rename = "trustedIdProviders", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_id_providers: Vec<TrustedIdProvider>,
    #[serde(rename = "trustedIdProviderState", default, skip_serializing_if = "Option::is_none")]
    pub trusted_id_provider_state: Option<data_lake_store_account_properties::TrustedIdProviderState>,
    #[serde(rename = "newTier", default, skip_serializing_if = "Option::is_none")]
    pub new_tier: Option<data_lake_store_account_properties::NewTier>,
    #[serde(rename = "currentTier", default, skip_serializing_if = "Option::is_none")]
    pub current_tier: Option<data_lake_store_account_properties::CurrentTier>,
}
impl DataLakeStoreAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_lake_store_account_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EncryptionState {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EncryptionProvisioningState {
        Creating,
        Succeeded,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirewallState {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirewallAllowAzureIps {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TrustedIdProviderState {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NewTier {
        Consumption,
        #[serde(rename = "Commitment_1TB")]
        Commitment1tb,
        #[serde(rename = "Commitment_10TB")]
        Commitment10tb,
        #[serde(rename = "Commitment_100TB")]
        Commitment100tb,
        #[serde(rename = "Commitment_500TB")]
        Commitment500tb,
        #[serde(rename = "Commitment_1PB")]
        Commitment1pb,
        #[serde(rename = "Commitment_5PB")]
        Commitment5pb,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CurrentTier {
        Consumption,
        #[serde(rename = "Commitment_1TB")]
        Commitment1tb,
        #[serde(rename = "Commitment_10TB")]
        Commitment10tb,
        #[serde(rename = "Commitment_100TB")]
        Commitment100tb,
        #[serde(rename = "Commitment_500TB")]
        Commitment500tb,
        #[serde(rename = "Commitment_1PB")]
        Commitment1pb,
        #[serde(rename = "Commitment_5PB")]
        Commitment5pb,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataLakeStoreAccountPropertiesBasic {
    #[serde(rename = "accountId", default, skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<data_lake_store_account_properties_basic::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<data_lake_store_account_properties_basic::State>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "lastModifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
}
impl DataLakeStoreAccountPropertiesBasic {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_lake_store_account_properties_basic {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Failed,
        Creating,
        Running,
        Succeeded,
        Patching,
        Suspending,
        Resuming,
        Deleting,
        Deleted,
        Undeleting,
        Canceled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Active,
        Suspended,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptionConfig {
    #[serde(rename = "type")]
    pub type_: encryption_config::Type,
    #[serde(rename = "keyVaultMetaInfo", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_meta_info: Option<KeyVaultMetaInfo>,
}
impl EncryptionConfig {
    pub fn new(type_: encryption_config::Type) -> Self {
        Self {
            type_,
            key_vault_meta_info: None,
        }
    }
}
pub mod encryption_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        UserManaged,
        ServiceManaged,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptionIdentity {
    #[serde(rename = "type")]
    pub type_: encryption_identity::Type,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl EncryptionIdentity {
    pub fn new(type_: encryption_identity::Type) -> Self {
        Self {
            type_,
            principal_id: None,
            tenant_id: None,
        }
    }
}
pub mod encryption_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FirewallRuleProperties>,
}
impl FirewallRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FirewallRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FirewallRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallRuleProperties {
    #[serde(rename = "startIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub start_ip_address: Option<String>,
    #[serde(rename = "endIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub end_ip_address: Option<String>,
}
impl FirewallRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultMetaInfo {
    #[serde(rename = "keyVaultResourceId")]
    pub key_vault_resource_id: String,
    #[serde(rename = "encryptionKeyName")]
    pub encryption_key_name: String,
    #[serde(rename = "encryptionKeyVersion")]
    pub encryption_key_version: String,
}
impl KeyVaultMetaInfo {
    pub fn new(key_vault_resource_id: String, encryption_key_name: String, encryption_key_version: String) -> Self {
        Self {
            key_vault_resource_id,
            encryption_key_name,
            encryption_key_version,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameAvailabilityInformation {
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl NameAvailabilityInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationDisplay>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<operation::Origin>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Origin {
        #[serde(rename = "user")]
        User,
        #[serde(rename = "system")]
        System,
        #[serde(rename = "user,system")]
        UserSystem,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrustedIdProvider {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TrustedIdProviderProperties>,
}
impl TrustedIdProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrustedIdProviderListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TrustedIdProvider>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TrustedIdProviderListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrustedIdProviderProperties {
    #[serde(rename = "idProvider", default, skip_serializing_if = "Option::is_none")]
    pub id_provider: Option<String>,
}
impl TrustedIdProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateDataLakeStoreAccountParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateDataLakeStoreAccountProperties>,
}
impl UpdateDataLakeStoreAccountParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateDataLakeStoreAccountProperties {
    #[serde(rename = "defaultGroup", default, skip_serializing_if = "Option::is_none")]
    pub default_group: Option<String>,
    #[serde(rename = "encryptionConfig", default, skip_serializing_if = "Option::is_none")]
    pub encryption_config: Option<UpdateEncryptionConfig>,
    #[serde(rename = "firewallRules", default, skip_serializing_if = "Vec::is_empty")]
    pub firewall_rules: Vec<UpdateFirewallRuleWithAccountParameters>,
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<UpdateVirtualNetworkRuleWithAccountParameters>,
    #[serde(rename = "firewallState", default, skip_serializing_if = "Option::is_none")]
    pub firewall_state: Option<update_data_lake_store_account_properties::FirewallState>,
    #[serde(rename = "firewallAllowAzureIps", default, skip_serializing_if = "Option::is_none")]
    pub firewall_allow_azure_ips: Option<update_data_lake_store_account_properties::FirewallAllowAzureIps>,
    #[serde(rename = "trustedIdProviders", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_id_providers: Vec<UpdateTrustedIdProviderWithAccountParameters>,
    #[serde(rename = "trustedIdProviderState", default, skip_serializing_if = "Option::is_none")]
    pub trusted_id_provider_state: Option<update_data_lake_store_account_properties::TrustedIdProviderState>,
    #[serde(rename = "newTier", default, skip_serializing_if = "Option::is_none")]
    pub new_tier: Option<update_data_lake_store_account_properties::NewTier>,
}
impl UpdateDataLakeStoreAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod update_data_lake_store_account_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirewallState {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirewallAllowAzureIps {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TrustedIdProviderState {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NewTier {
        Consumption,
        #[serde(rename = "Commitment_1TB")]
        Commitment1tb,
        #[serde(rename = "Commitment_10TB")]
        Commitment10tb,
        #[serde(rename = "Commitment_100TB")]
        Commitment100tb,
        #[serde(rename = "Commitment_500TB")]
        Commitment500tb,
        #[serde(rename = "Commitment_1PB")]
        Commitment1pb,
        #[serde(rename = "Commitment_5PB")]
        Commitment5pb,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateEncryptionConfig {
    #[serde(rename = "keyVaultMetaInfo", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_meta_info: Option<UpdateKeyVaultMetaInfo>,
}
impl UpdateEncryptionConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateFirewallRuleParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateFirewallRuleProperties>,
}
impl UpdateFirewallRuleParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateFirewallRuleProperties {
    #[serde(rename = "startIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub start_ip_address: Option<String>,
    #[serde(rename = "endIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub end_ip_address: Option<String>,
}
impl UpdateFirewallRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateFirewallRuleWithAccountParameters {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateFirewallRuleProperties>,
}
impl UpdateFirewallRuleWithAccountParameters {
    pub fn new(name: String) -> Self {
        Self { name, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateKeyVaultMetaInfo {
    #[serde(rename = "encryptionKeyVersion", default, skip_serializing_if = "Option::is_none")]
    pub encryption_key_version: Option<String>,
}
impl UpdateKeyVaultMetaInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateTrustedIdProviderParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateTrustedIdProviderProperties>,
}
impl UpdateTrustedIdProviderParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateTrustedIdProviderProperties {
    #[serde(rename = "idProvider", default, skip_serializing_if = "Option::is_none")]
    pub id_provider: Option<String>,
}
impl UpdateTrustedIdProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateTrustedIdProviderWithAccountParameters {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateTrustedIdProviderProperties>,
}
impl UpdateTrustedIdProviderWithAccountParameters {
    pub fn new(name: String) -> Self {
        Self { name, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateVirtualNetworkRuleParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateVirtualNetworkRuleProperties>,
}
impl UpdateVirtualNetworkRuleParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateVirtualNetworkRuleProperties {
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
}
impl UpdateVirtualNetworkRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateVirtualNetworkRuleWithAccountParameters {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateVirtualNetworkRuleProperties>,
}
impl UpdateVirtualNetworkRuleWithAccountParameters {
    pub fn new(name: String) -> Self {
        Self { name, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Usage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<usage::Unit>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<UsageName>,
}
impl Usage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
        Bytes,
        Seconds,
        Percent,
        CountsPerSecond,
        BytesPerSecond,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
}
impl UsageListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkRuleProperties>,
}
impl VirtualNetworkRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkRuleProperties {
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
}
impl VirtualNetworkRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
