#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessPolicyResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub policy: Option<UserAccessPolicy>,
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<String>,
    #[serde(rename = "dataPlaneUrl", default, skip_serializing_if = "Option::is_none")]
    pub data_plane_url: Option<String>,
}
impl AccessPolicyResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Activity {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "dependsOn", default, skip_serializing_if = "Vec::is_empty")]
    pub depends_on: Vec<ActivityDependency>,
    #[serde(rename = "userProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub user_properties: Vec<UserProperty>,
}
impl Activity {
    pub fn new(name: String, type_: String) -> Self {
        Self {
            name,
            type_,
            description: None,
            depends_on: Vec::new(),
            user_properties: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityDependency {
    pub activity: String,
    #[serde(rename = "dependencyConditions")]
    pub dependency_conditions: Vec<String>,
}
impl ActivityDependency {
    pub fn new(activity: String, dependency_conditions: Vec<String>) -> Self {
        Self {
            activity,
            dependency_conditions,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActivityPolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retry: Option<serde_json::Value>,
    #[serde(rename = "retryIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub retry_interval_in_seconds: Option<i64>,
    #[serde(rename = "secureInput", default, skip_serializing_if = "Option::is_none")]
    pub secure_input: Option<bool>,
    #[serde(rename = "secureOutput", default, skip_serializing_if = "Option::is_none")]
    pub secure_output: Option<bool>,
}
impl ActivityPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActivityRun {
    #[serde(rename = "pipelineName", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_name: Option<String>,
    #[serde(rename = "pipelineRunId", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_run_id: Option<String>,
    #[serde(rename = "activityName", default, skip_serializing_if = "Option::is_none")]
    pub activity_name: Option<String>,
    #[serde(rename = "activityType", default, skip_serializing_if = "Option::is_none")]
    pub activity_type: Option<String>,
    #[serde(rename = "activityRunId", default, skip_serializing_if = "Option::is_none")]
    pub activity_run_id: Option<String>,
    #[serde(rename = "linkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub linked_service_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "activityRunStart", default, skip_serializing_if = "Option::is_none")]
    pub activity_run_start: Option<String>,
    #[serde(rename = "activityRunEnd", default, skip_serializing_if = "Option::is_none")]
    pub activity_run_end: Option<String>,
    #[serde(rename = "durationInMs", default, skip_serializing_if = "Option::is_none")]
    pub duration_in_ms: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub input: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
}
impl ActivityRun {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityRunsQueryResponse {
    pub value: Vec<ActivityRun>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl ActivityRunsQueryResponse {
    pub fn new(value: Vec<ActivityRun>) -> Self {
        Self {
            value,
            continuation_token: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddDataFlowToDebugSessionResponse {
    #[serde(rename = "jobVersion", default, skip_serializing_if = "Option::is_none")]
    pub job_version: Option<String>,
}
impl AddDataFlowToDebugSessionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdditionalColumns {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
}
impl AdditionalColumns {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonMwsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonMwsLinkedServiceTypeProperties,
}
impl AmazonMwsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AmazonMwsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonMwsLinkedServiceTypeProperties {
    pub endpoint: serde_json::Value,
    #[serde(rename = "marketplaceID")]
    pub marketplace_id: serde_json::Value,
    #[serde(rename = "sellerID")]
    pub seller_id: serde_json::Value,
    #[serde(rename = "mwsAuthToken", default, skip_serializing_if = "Option::is_none")]
    pub mws_auth_token: Option<SecretBase>,
    #[serde(rename = "accessKeyId")]
    pub access_key_id: serde_json::Value,
    #[serde(rename = "secretKey", default, skip_serializing_if = "Option::is_none")]
    pub secret_key: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AmazonMwsLinkedServiceTypeProperties {
    pub fn new(
        endpoint: serde_json::Value,
        marketplace_id: serde_json::Value,
        seller_id: serde_json::Value,
        access_key_id: serde_json::Value,
    ) -> Self {
        Self {
            endpoint,
            marketplace_id,
            seller_id,
            mws_auth_token: None,
            access_key_id,
            secret_key: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonMwsObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl AmazonMwsObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonMwsSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl AmazonMwsSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRdsForLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AmazonRdsForLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRdsForOracleLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonRdsForLinkedServiceTypeProperties,
}
impl AmazonRdsForOracleLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AmazonRdsForLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AmazonRdsForOraclePartitionOption {
    None,
    PhysicalPartitionsOfTable,
    DynamicRange,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonRdsForOraclePartitionSettings {
    #[serde(rename = "partitionNames", default, skip_serializing_if = "Option::is_none")]
    pub partition_names: Option<serde_json::Value>,
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
}
impl AmazonRdsForOraclePartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRdsForOracleSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "oracleReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub oracle_reader_query: Option<serde_json::Value>,
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<AmazonRdsForOraclePartitionSettings>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl AmazonRdsForOracleSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            oracle_reader_query: None,
            query_timeout: None,
            partition_option: None,
            partition_settings: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRdsForOracleTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AmazonRdsForOracleTableDatasetTypeProperties>,
}
impl AmazonRdsForOracleTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonRdsForOracleTableDatasetTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AmazonRdsForOracleTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRdsForSqlServerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonRdsForSqlServerLinkedServiceTypeProperties,
}
impl AmazonRdsForSqlServerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AmazonRdsForSqlServerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRdsForSqlServerLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "alwaysEncryptedSettings", default, skip_serializing_if = "Option::is_none")]
    pub always_encrypted_settings: Option<SqlAlwaysEncryptedProperties>,
}
impl AmazonRdsForSqlServerLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            user_name: None,
            password: None,
            encrypted_credential: None,
            always_encrypted_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRdsForSqlServerSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "produceAdditionalTypes", default, skip_serializing_if = "Option::is_none")]
    pub produce_additional_types: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl AmazonRdsForSqlServerSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            produce_additional_types: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRdsForSqlServerTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AmazonRdsForSqlServerTableDatasetTypeProperties>,
}
impl AmazonRdsForSqlServerTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonRdsForSqlServerTableDatasetTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AmazonRdsForSqlServerTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRedshiftLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonRedshiftLinkedServiceTypeProperties,
}
impl AmazonRedshiftLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AmazonRedshiftLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRedshiftLinkedServiceTypeProperties {
    pub server: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    pub database: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AmazonRedshiftLinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            server,
            username: None,
            password: None,
            database,
            port: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRedshiftSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "redshiftUnloadSettings", default, skip_serializing_if = "Option::is_none")]
    pub redshift_unload_settings: Option<RedshiftUnloadSettings>,
}
impl AmazonRedshiftSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            redshift_unload_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRedshiftTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AmazonRedshiftTableDatasetTypeProperties>,
}
impl AmazonRedshiftTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonRedshiftTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl AmazonRedshiftTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3CompatibleLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonS3CompatibleLinkedServiceTypeProperties,
}
impl AmazonS3CompatibleLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AmazonS3CompatibleLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonS3CompatibleLinkedServiceTypeProperties {
    #[serde(rename = "accessKeyId", default, skip_serializing_if = "Option::is_none")]
    pub access_key_id: Option<serde_json::Value>,
    #[serde(rename = "secretAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub secret_access_key: Option<SecretBase>,
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<serde_json::Value>,
    #[serde(rename = "forcePathStyle", default, skip_serializing_if = "Option::is_none")]
    pub force_path_style: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AmazonS3CompatibleLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3CompatibleLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[serde(rename = "bucketName", default, skip_serializing_if = "Option::is_none")]
    pub bucket_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<serde_json::Value>,
}
impl AmazonS3CompatibleLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            bucket_name: None,
            version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3CompatibleReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AmazonS3CompatibleReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3Dataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonS3DatasetTypeProperties,
}
impl AmazonS3Dataset {
    pub fn new(dataset: Dataset, type_properties: AmazonS3DatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3DatasetTypeProperties {
    #[serde(rename = "bucketName")]
    pub bucket_name: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl AmazonS3DatasetTypeProperties {
    pub fn new(bucket_name: serde_json::Value) -> Self {
        Self {
            bucket_name,
            key: None,
            prefix: None,
            version: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
            format: None,
            compression: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3LinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonS3LinkedServiceTypeProperties,
}
impl AmazonS3LinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AmazonS3LinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonS3LinkedServiceTypeProperties {
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[serde(rename = "accessKeyId", default, skip_serializing_if = "Option::is_none")]
    pub access_key_id: Option<serde_json::Value>,
    #[serde(rename = "secretAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub secret_access_key: Option<SecretBase>,
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<serde_json::Value>,
    #[serde(rename = "sessionToken", default, skip_serializing_if = "Option::is_none")]
    pub session_token: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AmazonS3LinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3Location {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[serde(rename = "bucketName", default, skip_serializing_if = "Option::is_none")]
    pub bucket_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<serde_json::Value>,
}
impl AmazonS3Location {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            bucket_name: None,
            version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3ReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AmazonS3ReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppendVariableActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: AppendVariableActivityTypeProperties,
}
impl AppendVariableActivity {
    pub fn new(control_activity: ControlActivity, type_properties: AppendVariableActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppendVariableActivityTypeProperties {
    #[serde(rename = "variableName", default, skip_serializing_if = "Option::is_none")]
    pub variable_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
}
impl AppendVariableActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmIdWrapper {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ArmIdWrapper {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AvroCompressionCodec {
    #[serde(rename = "none")]
    None,
    #[serde(rename = "deflate")]
    Deflate,
    #[serde(rename = "snappy")]
    Snappy,
    #[serde(rename = "xz")]
    Xz,
    #[serde(rename = "bzip2")]
    Bzip2,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AvroDatasetTypeProperties>,
}
impl AvroDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroDatasetTypeProperties {
    pub location: DatasetLocation,
    #[serde(rename = "avroCompressionCodec", default, skip_serializing_if = "Option::is_none")]
    pub avro_compression_codec: Option<serde_json::Value>,
    #[serde(rename = "avroCompressionLevel", default, skip_serializing_if = "Option::is_none")]
    pub avro_compression_level: Option<i64>,
}
impl AvroDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            avro_compression_codec: None,
            avro_compression_level: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
}
impl AvroFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self { dataset_storage_format }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<AvroWriteSettings>,
}
impl AvroSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl AvroSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[serde(rename = "recordName", default, skip_serializing_if = "Option::is_none")]
    pub record_name: Option<String>,
    #[serde(rename = "recordNamespace", default, skip_serializing_if = "Option::is_none")]
    pub record_namespace: Option<String>,
    #[serde(rename = "maxRowsPerFile", default, skip_serializing_if = "Option::is_none")]
    pub max_rows_per_file: Option<serde_json::Value>,
    #[serde(rename = "fileNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub file_name_prefix: Option<serde_json::Value>,
}
impl AvroWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings) -> Self {
        Self {
            format_write_settings,
            record_name: None,
            record_namespace: None,
            max_rows_per_file: None,
            file_name_prefix: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzPowerShellSetup {
    #[serde(flatten)]
    pub custom_setup_base: CustomSetupBase,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzPowerShellSetupTypeProperties,
}
impl AzPowerShellSetup {
    pub fn new(custom_setup_base: CustomSetupBase, type_properties: AzPowerShellSetupTypeProperties) -> Self {
        Self {
            custom_setup_base,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzPowerShellSetupTypeProperties {
    pub version: String,
}
impl AzPowerShellSetupTypeProperties {
    pub fn new(version: String) -> Self {
        Self { version }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBatchLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureBatchLinkedServiceTypeProperties,
}
impl AzureBatchLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureBatchLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBatchLinkedServiceTypeProperties {
    #[serde(rename = "accountName")]
    pub account_name: serde_json::Value,
    #[serde(rename = "accessKey", default, skip_serializing_if = "Option::is_none")]
    pub access_key: Option<SecretBase>,
    #[serde(rename = "batchUri")]
    pub batch_uri: serde_json::Value,
    #[serde(rename = "poolName")]
    pub pool_name: serde_json::Value,
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl AzureBatchLinkedServiceTypeProperties {
    pub fn new(
        account_name: serde_json::Value,
        batch_uri: serde_json::Value,
        pool_name: serde_json::Value,
        linked_service_name: LinkedServiceReference,
    ) -> Self {
        Self {
            account_name,
            access_key: None,
            batch_uri,
            pool_name,
            linked_service_name,
            encrypted_credential: None,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureBlobDatasetTypeProperties>,
}
impl AzureBlobDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobDatasetTypeProperties {
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[serde(rename = "tableRootLocation", default, skip_serializing_if = "Option::is_none")]
    pub table_root_location: Option<serde_json::Value>,
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl AzureBlobDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureBlobFsDatasetTypeProperties>,
}
impl AzureBlobFsDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobFsDatasetTypeProperties {
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl AzureBlobFsDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureBlobFsLinkedServiceTypeProperties,
}
impl AzureBlobFsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureBlobFsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsLinkedServiceTypeProperties {
    pub url: serde_json::Value,
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
    #[serde(rename = "servicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential_type: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalCredential", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential: Option<SecretBase>,
}
impl AzureBlobFsLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            account_key: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            encrypted_credential: None,
            credential: None,
            service_principal_credential_type: None,
            service_principal_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<serde_json::Value>,
}
impl AzureBlobFsLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            file_system: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AzureBlobFsReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl AzureBlobFsSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            copy_behavior: None,
            metadata: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "treatEmptyAsNull", default, skip_serializing_if = "Option::is_none")]
    pub treat_empty_as_null: Option<serde_json::Value>,
    #[serde(rename = "skipHeaderLineCount", default, skip_serializing_if = "Option::is_none")]
    pub skip_header_line_count: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
}
impl AzureBlobFsSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            treat_empty_as_null: None,
            skip_header_line_count: None,
            recursive: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
    #[serde(rename = "blockSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub block_size_in_mb: Option<serde_json::Value>,
}
impl AzureBlobFsWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self {
            store_write_settings,
            block_size_in_mb: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureBlobStorageLinkedServiceTypeProperties,
}
impl AzureBlobStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureBlobStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobStorageLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "sasUri", default, skip_serializing_if = "Option::is_none")]
    pub sas_uri: Option<serde_json::Value>,
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "serviceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub service_endpoint: Option<String>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[serde(rename = "accountKind", default, skip_serializing_if = "Option::is_none")]
    pub account_kind: Option<String>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl AzureBlobStorageLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobStorageLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub container: Option<serde_json::Value>,
}
impl AzureBlobStorageLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            container: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobStorageReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AzureBlobStorageReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobStorageWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
    #[serde(rename = "blockSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub block_size_in_mb: Option<serde_json::Value>,
}
impl AzureBlobStorageWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self {
            store_write_settings,
            block_size_in_mb: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerCommandActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataExplorerCommandActivityTypeProperties,
}
impl AzureDataExplorerCommandActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureDataExplorerCommandActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerCommandActivityTypeProperties {
    pub command: serde_json::Value,
    #[serde(rename = "commandTimeout", default, skip_serializing_if = "Option::is_none")]
    pub command_timeout: Option<serde_json::Value>,
}
impl AzureDataExplorerCommandActivityTypeProperties {
    pub fn new(command: serde_json::Value) -> Self {
        Self {
            command,
            command_timeout: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataExplorerDatasetTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureDataExplorerDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataExplorerLinkedServiceTypeProperties,
}
impl AzureDataExplorerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDataExplorerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerLinkedServiceTypeProperties {
    pub endpoint: serde_json::Value,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    pub database: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl AzureDataExplorerLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            endpoint,
            service_principal_id: None,
            service_principal_key: None,
            database,
            tenant: None,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "ingestionMappingName", default, skip_serializing_if = "Option::is_none")]
    pub ingestion_mapping_name: Option<serde_json::Value>,
    #[serde(rename = "ingestionMappingAsJson", default, skip_serializing_if = "Option::is_none")]
    pub ingestion_mapping_as_json: Option<serde_json::Value>,
    #[serde(rename = "flushImmediately", default, skip_serializing_if = "Option::is_none")]
    pub flush_immediately: Option<serde_json::Value>,
}
impl AzureDataExplorerSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            ingestion_mapping_name: None,
            ingestion_mapping_as_json: None,
            flush_immediately: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    pub query: serde_json::Value,
    #[serde(rename = "noTruncation", default, skip_serializing_if = "Option::is_none")]
    pub no_truncation: Option<serde_json::Value>,
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl AzureDataExplorerSource {
    pub fn new(copy_source: CopySource, query: serde_json::Value) -> Self {
        Self {
            copy_source,
            query,
            no_truncation: None,
            query_timeout: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataExplorerDatasetTypeProperties,
}
impl AzureDataExplorerTableDataset {
    pub fn new(dataset: Dataset, type_properties: AzureDataExplorerDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeAnalyticsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataLakeAnalyticsLinkedServiceTypeProperties,
}
impl AzureDataLakeAnalyticsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDataLakeAnalyticsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeAnalyticsLinkedServiceTypeProperties {
    #[serde(rename = "accountName")]
    pub account_name: serde_json::Value,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    pub tenant: serde_json::Value,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<serde_json::Value>,
    #[serde(rename = "resourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub resource_group_name: Option<serde_json::Value>,
    #[serde(rename = "dataLakeAnalyticsUri", default, skip_serializing_if = "Option::is_none")]
    pub data_lake_analytics_uri: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureDataLakeAnalyticsLinkedServiceTypeProperties {
    pub fn new(account_name: serde_json::Value, tenant: serde_json::Value) -> Self {
        Self {
            account_name,
            service_principal_id: None,
            service_principal_key: None,
            tenant,
            subscription_id: None,
            resource_group_name: None,
            data_lake_analytics_uri: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureDataLakeStoreDatasetTypeProperties>,
}
impl AzureDataLakeStoreDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataLakeStoreDatasetTypeProperties {
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl AzureDataLakeStoreDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataLakeStoreLinkedServiceTypeProperties,
}
impl AzureDataLakeStoreLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDataLakeStoreLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreLinkedServiceTypeProperties {
    #[serde(rename = "dataLakeStoreUri")]
    pub data_lake_store_uri: serde_json::Value,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<serde_json::Value>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<serde_json::Value>,
    #[serde(rename = "resourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub resource_group_name: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl AzureDataLakeStoreLinkedServiceTypeProperties {
    pub fn new(data_lake_store_uri: serde_json::Value) -> Self {
        Self {
            data_lake_store_uri,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            account_name: None,
            subscription_id: None,
            resource_group_name: None,
            encrypted_credential: None,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl AzureDataLakeStoreLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "listAfter", default, skip_serializing_if = "Option::is_none")]
    pub list_after: Option<serde_json::Value>,
    #[serde(rename = "listBefore", default, skip_serializing_if = "Option::is_none")]
    pub list_before: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AzureDataLakeStoreReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            file_list_path: None,
            list_after: None,
            list_before: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
    #[serde(rename = "enableAdlsSingleFileParallel", default, skip_serializing_if = "Option::is_none")]
    pub enable_adls_single_file_parallel: Option<serde_json::Value>,
}
impl AzureDataLakeStoreSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            copy_behavior: None,
            enable_adls_single_file_parallel: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
}
impl AzureDataLakeStoreSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            recursive: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
    #[serde(rename = "expiryDateTime", default, skip_serializing_if = "Option::is_none")]
    pub expiry_date_time: Option<serde_json::Value>,
}
impl AzureDataLakeStoreWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self {
            store_write_settings,
            expiry_date_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataPathAssignments {}
impl AzureDataPathAssignments {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureDatabricksDeltaLakeDatasetTypeProperties>,
}
impl AzureDatabricksDeltaLakeDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDatabricksDeltaLakeDatasetTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub database: Option<serde_json::Value>,
}
impl AzureDatabricksDeltaLakeDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeExportCommand {
    #[serde(flatten)]
    pub export_settings: ExportSettings,
    #[serde(rename = "dateFormat", default, skip_serializing_if = "Option::is_none")]
    pub date_format: Option<serde_json::Value>,
    #[serde(rename = "timestampFormat", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_format: Option<serde_json::Value>,
}
impl AzureDatabricksDeltaLakeExportCommand {
    pub fn new(export_settings: ExportSettings) -> Self {
        Self {
            export_settings,
            date_format: None,
            timestamp_format: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeImportCommand {
    #[serde(flatten)]
    pub import_settings: ImportSettings,
    #[serde(rename = "dateFormat", default, skip_serializing_if = "Option::is_none")]
    pub date_format: Option<serde_json::Value>,
    #[serde(rename = "timestampFormat", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_format: Option<serde_json::Value>,
}
impl AzureDatabricksDeltaLakeImportCommand {
    pub fn new(import_settings: ImportSettings) -> Self {
        Self {
            import_settings,
            date_format: None,
            timestamp_format: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDatabricksDetltaLakeLinkedServiceTypeProperties,
}
impl AzureDatabricksDeltaLakeLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDatabricksDetltaLakeLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[serde(rename = "importSettings", default, skip_serializing_if = "Option::is_none")]
    pub import_settings: Option<AzureDatabricksDeltaLakeImportCommand>,
}
impl AzureDatabricksDeltaLakeSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
            import_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "exportSettings", default, skip_serializing_if = "Option::is_none")]
    pub export_settings: Option<AzureDatabricksDeltaLakeExportCommand>,
}
impl AzureDatabricksDeltaLakeSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            export_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDetltaLakeLinkedServiceTypeProperties {
    pub domain: serde_json::Value,
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[serde(rename = "clusterId", default, skip_serializing_if = "Option::is_none")]
    pub cluster_id: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
    #[serde(rename = "workspaceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_resource_id: Option<serde_json::Value>,
}
impl AzureDatabricksDetltaLakeLinkedServiceTypeProperties {
    pub fn new(domain: serde_json::Value) -> Self {
        Self {
            domain,
            access_token: None,
            cluster_id: None,
            encrypted_credential: None,
            credential: None,
            workspace_resource_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDatabricksLinkedServiceTypeProperties,
}
impl AzureDatabricksLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDatabricksLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksLinkedServiceTypeProperties {
    pub domain: serde_json::Value,
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<serde_json::Value>,
    #[serde(rename = "workspaceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_resource_id: Option<serde_json::Value>,
    #[serde(rename = "existingClusterId", default, skip_serializing_if = "Option::is_none")]
    pub existing_cluster_id: Option<serde_json::Value>,
    #[serde(rename = "instancePoolId", default, skip_serializing_if = "Option::is_none")]
    pub instance_pool_id: Option<serde_json::Value>,
    #[serde(rename = "newClusterVersion", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_version: Option<serde_json::Value>,
    #[serde(rename = "newClusterNumOfWorker", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_num_of_worker: Option<serde_json::Value>,
    #[serde(rename = "newClusterNodeType", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_node_type: Option<serde_json::Value>,
    #[serde(rename = "newClusterSparkConf", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_spark_conf: Option<serde_json::Value>,
    #[serde(rename = "newClusterSparkEnvVars", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_spark_env_vars: Option<serde_json::Value>,
    #[serde(rename = "newClusterCustomTags", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_custom_tags: Option<serde_json::Value>,
    #[serde(rename = "newClusterLogDestination", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_log_destination: Option<serde_json::Value>,
    #[serde(rename = "newClusterDriverNodeType", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_driver_node_type: Option<serde_json::Value>,
    #[serde(rename = "newClusterInitScripts", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_init_scripts: Option<serde_json::Value>,
    #[serde(rename = "newClusterEnableElasticDisk", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_enable_elastic_disk: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl AzureDatabricksLinkedServiceTypeProperties {
    pub fn new(domain: serde_json::Value) -> Self {
        Self {
            domain,
            access_token: None,
            authentication: None,
            workspace_resource_id: None,
            existing_cluster_id: None,
            instance_pool_id: None,
            new_cluster_version: None,
            new_cluster_num_of_worker: None,
            new_cluster_node_type: None,
            new_cluster_spark_conf: None,
            new_cluster_spark_env_vars: None,
            new_cluster_custom_tags: None,
            new_cluster_log_destination: None,
            new_cluster_driver_node_type: None,
            new_cluster_init_scripts: None,
            new_cluster_enable_elastic_disk: None,
            encrypted_credential: None,
            policy_id: None,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureFileStorageLinkedServiceTypeProperties,
}
impl AzureFileStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureFileStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFileStorageLinkedServiceTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<serde_json::Value>,
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "sasUri", default, skip_serializing_if = "Option::is_none")]
    pub sas_uri: Option<serde_json::Value>,
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "fileShare", default, skip_serializing_if = "Option::is_none")]
    pub file_share: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub snapshot: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureFileStorageLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileStorageLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl AzureFileStorageLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileStorageReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AzureFileStorageReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileStorageWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
}
impl AzureFileStorageWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self { store_write_settings }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFunctionActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureFunctionActivityTypeProperties,
}
impl AzureFunctionActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureFunctionActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFunctionActivityMethod {
    #[serde(rename = "GET")]
    Get,
    #[serde(rename = "POST")]
    Post,
    #[serde(rename = "PUT")]
    Put,
    #[serde(rename = "DELETE")]
    Delete,
    #[serde(rename = "OPTIONS")]
    Options,
    #[serde(rename = "HEAD")]
    Head,
    #[serde(rename = "TRACE")]
    Trace,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFunctionActivityTypeProperties {
    pub method: AzureFunctionActivityMethod,
    #[serde(rename = "functionName")]
    pub function_name: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<serde_json::Value>,
}
impl AzureFunctionActivityTypeProperties {
    pub fn new(method: AzureFunctionActivityMethod, function_name: serde_json::Value) -> Self {
        Self {
            method,
            function_name,
            headers: None,
            body: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFunctionLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureFunctionLinkedServiceTypeProperties,
}
impl AzureFunctionLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureFunctionLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFunctionLinkedServiceTypeProperties {
    #[serde(rename = "functionAppUrl")]
    pub function_app_url: serde_json::Value,
    #[serde(rename = "functionKey", default, skip_serializing_if = "Option::is_none")]
    pub function_key: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<serde_json::Value>,
}
impl AzureFunctionLinkedServiceTypeProperties {
    pub fn new(function_app_url: serde_json::Value) -> Self {
        Self {
            function_app_url,
            function_key: None,
            encrypted_credential: None,
            credential: None,
            resource_id: None,
            authentication: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureKeyVaultLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureKeyVaultLinkedServiceTypeProperties,
}
impl AzureKeyVaultLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureKeyVaultLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureKeyVaultLinkedServiceTypeProperties {
    #[serde(rename = "baseUrl")]
    pub base_url: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl AzureKeyVaultLinkedServiceTypeProperties {
    pub fn new(base_url: serde_json::Value) -> Self {
        Self {
            base_url,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureKeyVaultSecretReference {
    #[serde(flatten)]
    pub secret_base: SecretBase,
    pub store: LinkedServiceReference,
    #[serde(rename = "secretName")]
    pub secret_name: serde_json::Value,
    #[serde(rename = "secretVersion", default, skip_serializing_if = "Option::is_none")]
    pub secret_version: Option<serde_json::Value>,
}
impl AzureKeyVaultSecretReference {
    pub fn new(secret_base: SecretBase, store: LinkedServiceReference, secret_name: serde_json::Value) -> Self {
        Self {
            secret_base,
            store,
            secret_name,
            secret_version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlBatchExecutionActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlBatchExecutionActivityTypeProperties,
}
impl AzureMlBatchExecutionActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureMlBatchExecutionActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMlBatchExecutionActivityTypeProperties {
    #[serde(rename = "globalParameters", default, skip_serializing_if = "Option::is_none")]
    pub global_parameters: Option<serde_json::Value>,
    #[serde(rename = "webServiceOutputs", default, skip_serializing_if = "Option::is_none")]
    pub web_service_outputs: Option<serde_json::Value>,
    #[serde(rename = "webServiceInputs", default, skip_serializing_if = "Option::is_none")]
    pub web_service_inputs: Option<serde_json::Value>,
}
impl AzureMlBatchExecutionActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlExecutePipelineActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlExecutePipelineActivityTypeProperties,
}
impl AzureMlExecutePipelineActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureMlExecutePipelineActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMlExecutePipelineActivityTypeProperties {
    #[serde(rename = "mlPipelineId", default, skip_serializing_if = "Option::is_none")]
    pub ml_pipeline_id: Option<serde_json::Value>,
    #[serde(rename = "mlPipelineEndpointId", default, skip_serializing_if = "Option::is_none")]
    pub ml_pipeline_endpoint_id: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<serde_json::Value>,
    #[serde(rename = "experimentName", default, skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<serde_json::Value>,
    #[serde(rename = "mlPipelineParameters", default, skip_serializing_if = "Option::is_none")]
    pub ml_pipeline_parameters: Option<serde_json::Value>,
    #[serde(rename = "dataPathAssignments", default, skip_serializing_if = "Option::is_none")]
    pub data_path_assignments: Option<serde_json::Value>,
    #[serde(rename = "mlParentRunId", default, skip_serializing_if = "Option::is_none")]
    pub ml_parent_run_id: Option<serde_json::Value>,
    #[serde(rename = "continueOnStepFailure", default, skip_serializing_if = "Option::is_none")]
    pub continue_on_step_failure: Option<serde_json::Value>,
}
impl AzureMlExecutePipelineActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlLinkedServiceTypeProperties,
}
impl AzureMlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureMlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlLinkedServiceTypeProperties {
    #[serde(rename = "mlEndpoint")]
    pub ml_endpoint: serde_json::Value,
    #[serde(rename = "apiKey")]
    pub api_key: SecretBase,
    #[serde(rename = "updateResourceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub update_resource_endpoint: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<serde_json::Value>,
}
impl AzureMlLinkedServiceTypeProperties {
    pub fn new(ml_endpoint: serde_json::Value, api_key: SecretBase) -> Self {
        Self {
            ml_endpoint,
            api_key,
            update_resource_endpoint: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            encrypted_credential: None,
            authentication: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMlPipelineParameters {}
impl AzureMlPipelineParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlServiceLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlServiceLinkedServiceTypeProperties,
}
impl AzureMlServiceLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureMlServiceLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlServiceLinkedServiceTypeProperties {
    #[serde(rename = "subscriptionId")]
    pub subscription_id: serde_json::Value,
    #[serde(rename = "resourceGroupName")]
    pub resource_group_name: serde_json::Value,
    #[serde(rename = "mlWorkspaceName")]
    pub ml_workspace_name: serde_json::Value,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureMlServiceLinkedServiceTypeProperties {
    pub fn new(subscription_id: serde_json::Value, resource_group_name: serde_json::Value, ml_workspace_name: serde_json::Value) -> Self {
        Self {
            subscription_id,
            resource_group_name,
            ml_workspace_name,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlUpdateResourceActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlUpdateResourceActivityTypeProperties,
}
impl AzureMlUpdateResourceActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureMlUpdateResourceActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlUpdateResourceActivityTypeProperties {
    #[serde(rename = "trainedModelName")]
    pub trained_model_name: serde_json::Value,
    #[serde(rename = "trainedModelLinkedServiceName")]
    pub trained_model_linked_service_name: LinkedServiceReference,
    #[serde(rename = "trainedModelFilePath")]
    pub trained_model_file_path: serde_json::Value,
}
impl AzureMlUpdateResourceActivityTypeProperties {
    pub fn new(
        trained_model_name: serde_json::Value,
        trained_model_linked_service_name: LinkedServiceReference,
        trained_model_file_path: serde_json::Value,
    ) -> Self {
        Self {
            trained_model_name,
            trained_model_linked_service_name,
            trained_model_file_path,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlWebServiceFile {
    #[serde(rename = "filePath")]
    pub file_path: serde_json::Value,
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
}
impl AzureMlWebServiceFile {
    pub fn new(file_path: serde_json::Value, linked_service_name: LinkedServiceReference) -> Self {
        Self {
            file_path,
            linked_service_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMariaDbLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMariaDbLinkedServiceTypeProperties,
}
impl AzureMariaDbLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureMariaDbLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMariaDbLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureMariaDbLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMariaDbSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl AzureMariaDbSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMariaDbTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl AzureMariaDbTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMySqlLinkedServiceTypeProperties,
}
impl AzureMySqlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureMySqlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureMySqlLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl AzureMySqlSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl AzureMySqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMySqlTableDatasetTypeProperties,
}
impl AzureMySqlTableDataset {
    pub fn new(dataset: Dataset, type_properties: AzureMySqlTableDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMySqlTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureMySqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzurePostgreSqlLinkedServiceTypeProperties,
}
impl AzurePostgreSqlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzurePostgreSqlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzurePostgreSqlLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzurePostgreSqlLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl AzurePostgreSqlSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl AzurePostgreSqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzurePostgreSqlTableDatasetTypeProperties>,
}
impl AzurePostgreSqlTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzurePostgreSqlTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl AzurePostgreSqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureQueueSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
}
impl AzureQueueSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self { copy_sink }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchIndexDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSearchIndexDatasetTypeProperties,
}
impl AzureSearchIndexDataset {
    pub fn new(dataset: Dataset, type_properties: AzureSearchIndexDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchIndexDatasetTypeProperties {
    #[serde(rename = "indexName")]
    pub index_name: serde_json::Value,
}
impl AzureSearchIndexDatasetTypeProperties {
    pub fn new(index_name: serde_json::Value) -> Self {
        Self { index_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchIndexSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<azure_search_index_sink::WriteBehavior>,
}
impl AzureSearchIndexSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
        }
    }
}
pub mod azure_search_index_sink {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WriteBehavior {
        Merge,
        Upload,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSearchLinkedServiceTypeProperties,
}
impl AzureSearchLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureSearchLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchLinkedServiceTypeProperties {
    pub url: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureSearchLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            key: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDwLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSqlDwLinkedServiceTypeProperties,
}
impl AzureSqlDwLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureSqlDwLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDwLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl AzureSqlDwLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            encrypted_credential: None,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDwTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureSqlDwTableDatasetTypeProperties>,
}
impl AzureSqlDwTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDwTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureSqlDwTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSqlDatabaseLinkedServiceTypeProperties,
}
impl AzureSqlDatabaseLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureSqlDatabaseLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "alwaysEncryptedSettings", default, skip_serializing_if = "Option::is_none")]
    pub always_encrypted_settings: Option<SqlAlwaysEncryptedProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl AzureSqlDatabaseLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            encrypted_credential: None,
            always_encrypted_settings: None,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlMiLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSqlMiLinkedServiceTypeProperties,
}
impl AzureSqlMiLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureSqlMiLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlMiLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "alwaysEncryptedSettings", default, skip_serializing_if = "Option::is_none")]
    pub always_encrypted_settings: Option<SqlAlwaysEncryptedProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl AzureSqlMiLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            encrypted_credential: None,
            always_encrypted_settings: None,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlMiTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureSqlMiTableDatasetTypeProperties>,
}
impl AzureSqlMiTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlMiTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureSqlMiTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "sqlWriterStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "sqlWriterTableType", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_table_type: Option<serde_json::Value>,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureTableTypeParameterName", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_table_type_parameter_name: Option<serde_json::Value>,
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
    #[serde(rename = "sqlWriterUseTableLock", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_use_table_lock: Option<serde_json::Value>,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
    #[serde(rename = "upsertSettings", default, skip_serializing_if = "Option::is_none")]
    pub upsert_settings: Option<SqlUpsertSettings>,
}
impl AzureSqlSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            sql_writer_stored_procedure_name: None,
            sql_writer_table_type: None,
            pre_copy_script: None,
            stored_procedure_parameters: None,
            stored_procedure_table_type_parameter_name: None,
            table_option: None,
            sql_writer_use_table_lock: None,
            write_behavior: None,
            upsert_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "produceAdditionalTypes", default, skip_serializing_if = "Option::is_none")]
    pub produce_additional_types: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl AzureSqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            produce_additional_types: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureSqlTableDatasetTypeProperties>,
}
impl AzureSqlTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureSqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureStorageLinkedServiceTypeProperties,
}
impl AzureStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "sasUri", default, skip_serializing_if = "Option::is_none")]
    pub sas_uri: Option<serde_json::Value>,
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<String>,
}
impl AzureStorageLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureTableDatasetTypeProperties,
}
impl AzureTableDataset {
    pub fn new(dataset: Dataset, type_properties: AzureTableDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableDatasetTypeProperties {
    #[serde(rename = "tableName")]
    pub table_name: serde_json::Value,
}
impl AzureTableDatasetTypeProperties {
    pub fn new(table_name: serde_json::Value) -> Self {
        Self { table_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "azureTableDefaultPartitionKeyValue", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_default_partition_key_value: Option<serde_json::Value>,
    #[serde(rename = "azureTablePartitionKeyName", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_partition_key_name: Option<serde_json::Value>,
    #[serde(rename = "azureTableRowKeyName", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_row_key_name: Option<serde_json::Value>,
    #[serde(rename = "azureTableInsertType", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_insert_type: Option<serde_json::Value>,
}
impl AzureTableSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            azure_table_default_partition_key_value: None,
            azure_table_partition_key_name: None,
            azure_table_row_key_name: None,
            azure_table_insert_type: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(rename = "azureTableSourceQuery", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_source_query: Option<serde_json::Value>,
    #[serde(rename = "azureTableSourceIgnoreTableNotFound", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_source_ignore_table_not_found: Option<serde_json::Value>,
}
impl AzureTableSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            azure_table_source_query: None,
            azure_table_source_ignore_table_not_found: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureStorageLinkedServiceTypeProperties,
}
impl AzureTableStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinaryDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<BinaryDatasetTypeProperties>,
}
impl BinaryDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinaryDatasetTypeProperties {
    pub location: DatasetLocation,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl BinaryDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            compression: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinaryReadSettings {
    #[serde(flatten)]
    pub format_read_settings: FormatReadSettings,
    #[serde(rename = "compressionProperties", default, skip_serializing_if = "Option::is_none")]
    pub compression_properties: Option<CompressionReadSettings>,
}
impl BinaryReadSettings {
    pub fn new(format_read_settings: FormatReadSettings) -> Self {
        Self {
            format_read_settings,
            compression_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinarySink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
}
impl BinarySink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinarySource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<BinaryReadSettings>,
}
impl BinarySource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            format_settings: None,
        }
    }
}
pub type BlobEventTypeArray = Vec<String>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobEventsTrigger {
    #[serde(flatten)]
    pub multiple_pipeline_trigger: MultiplePipelineTrigger,
    #[serde(rename = "typeProperties")]
    pub type_properties: blob_events_trigger::TypeProperties,
}
impl BlobEventsTrigger {
    pub fn new(multiple_pipeline_trigger: MultiplePipelineTrigger, type_properties: blob_events_trigger::TypeProperties) -> Self {
        Self {
            multiple_pipeline_trigger,
            type_properties,
        }
    }
}
pub mod blob_events_trigger {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[serde(rename = "blobPathBeginsWith", default, skip_serializing_if = "Option::is_none")]
        pub blob_path_begins_with: Option<String>,
        #[serde(rename = "blobPathEndsWith", default, skip_serializing_if = "Option::is_none")]
        pub blob_path_ends_with: Option<String>,
        #[serde(rename = "ignoreEmptyBlobs", default, skip_serializing_if = "Option::is_none")]
        pub ignore_empty_blobs: Option<bool>,
        pub events: BlobEventTypeArray,
        pub scope: String,
    }
    impl TypeProperties {
        pub fn new(events: BlobEventTypeArray, scope: String) -> Self {
            Self {
                blob_path_begins_with: None,
                blob_path_ends_with: None,
                ignore_empty_blobs: None,
                events,
                scope,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "blobWriterOverwriteFiles", default, skip_serializing_if = "Option::is_none")]
    pub blob_writer_overwrite_files: Option<serde_json::Value>,
    #[serde(rename = "blobWriterDateTimeFormat", default, skip_serializing_if = "Option::is_none")]
    pub blob_writer_date_time_format: Option<serde_json::Value>,
    #[serde(rename = "blobWriterAddHeader", default, skip_serializing_if = "Option::is_none")]
    pub blob_writer_add_header: Option<serde_json::Value>,
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl BlobSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            blob_writer_overwrite_files: None,
            blob_writer_date_time_format: None,
            blob_writer_add_header: None,
            copy_behavior: None,
            metadata: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "treatEmptyAsNull", default, skip_serializing_if = "Option::is_none")]
    pub treat_empty_as_null: Option<serde_json::Value>,
    #[serde(rename = "skipHeaderLineCount", default, skip_serializing_if = "Option::is_none")]
    pub skip_header_line_count: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
}
impl BlobSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            treat_empty_as_null: None,
            skip_header_line_count: None,
            recursive: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobTrigger {
    #[serde(flatten)]
    pub multiple_pipeline_trigger: MultiplePipelineTrigger,
    #[serde(rename = "typeProperties")]
    pub type_properties: blob_trigger::TypeProperties,
}
impl BlobTrigger {
    pub fn new(multiple_pipeline_trigger: MultiplePipelineTrigger, type_properties: blob_trigger::TypeProperties) -> Self {
        Self {
            multiple_pipeline_trigger,
            type_properties,
        }
    }
}
pub mod blob_trigger {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[serde(rename = "folderPath")]
        pub folder_path: String,
        #[serde(rename = "maxConcurrency")]
        pub max_concurrency: i64,
        #[serde(rename = "linkedService")]
        pub linked_service: LinkedServiceReference,
    }
    impl TypeProperties {
        pub fn new(folder_path: String, max_concurrency: i64, linked_service: LinkedServiceReference) -> Self {
            Self {
                folder_path,
                max_concurrency,
                linked_service,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CmkIdentityDefinition {
    #[serde(rename = "userAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identity: Option<String>,
}
impl CmkIdentityDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: CassandraLinkedServiceTypeProperties,
}
impl CassandraLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CassandraLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl CassandraLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            authentication_type: None,
            port: None,
            username: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "consistencyLevel", default, skip_serializing_if = "Option::is_none")]
    pub consistency_level: Option<cassandra_source::ConsistencyLevel>,
}
impl CassandraSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            consistency_level: None,
        }
    }
}
pub mod cassandra_source {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConsistencyLevel {
        #[serde(rename = "ALL")]
        All,
        #[serde(rename = "EACH_QUORUM")]
        EachQuorum,
        #[serde(rename = "QUORUM")]
        Quorum,
        #[serde(rename = "LOCAL_QUORUM")]
        LocalQuorum,
        #[serde(rename = "ONE")]
        One,
        #[serde(rename = "TWO")]
        Two,
        #[serde(rename = "THREE")]
        Three,
        #[serde(rename = "LOCAL_ONE")]
        LocalOne,
        #[serde(rename = "SERIAL")]
        Serial,
        #[serde(rename = "LOCAL_SERIAL")]
        LocalSerial,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<CassandraTableDatasetTypeProperties>,
}
impl CassandraTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keyspace: Option<serde_json::Value>,
}
impl CassandraTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ChainingTrigger {
    #[serde(flatten)]
    pub trigger: Trigger,
    pub pipeline: TriggerPipelineReference,
    #[serde(rename = "typeProperties")]
    pub type_properties: chaining_trigger::TypeProperties,
}
impl ChainingTrigger {
    pub fn new(trigger: Trigger, pipeline: TriggerPipelineReference, type_properties: chaining_trigger::TypeProperties) -> Self {
        Self {
            trigger,
            pipeline,
            type_properties,
        }
    }
}
pub mod chaining_trigger {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[serde(rename = "dependsOn")]
        pub depends_on: Vec<PipelineReference>,
        #[serde(rename = "runDimension")]
        pub run_dimension: String,
    }
    impl TypeProperties {
        pub fn new(depends_on: Vec<PipelineReference>, run_dimension: String) -> Self {
            Self { depends_on, run_dimension }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudError {
    pub error: CloudErrorBody,
}
impl CloudError {
    pub fn new(error: CloudErrorBody) -> Self {
        Self { error }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudErrorBody {
    pub code: String,
    pub message: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudError>,
}
impl CloudErrorBody {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CmdkeySetup {
    #[serde(flatten)]
    pub custom_setup_base: CustomSetupBase,
    #[serde(rename = "typeProperties")]
    pub type_properties: CmdkeySetupTypeProperties,
}
impl CmdkeySetup {
    pub fn new(custom_setup_base: CustomSetupBase, type_properties: CmdkeySetupTypeProperties) -> Self {
        Self {
            custom_setup_base,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CmdkeySetupTypeProperties {
    #[serde(rename = "targetName")]
    pub target_name: serde_json::Value,
    #[serde(rename = "userName")]
    pub user_name: serde_json::Value,
    pub password: SecretBase,
}
impl CmdkeySetupTypeProperties {
    pub fn new(target_name: serde_json::Value, user_name: serde_json::Value, password: SecretBase) -> Self {
        Self {
            target_name,
            user_name,
            password,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsEntityDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<CommonDataServiceForAppsEntityDatasetTypeProperties>,
}
impl CommonDataServiceForAppsEntityDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CommonDataServiceForAppsEntityDatasetTypeProperties {
    #[serde(rename = "entityName", default, skip_serializing_if = "Option::is_none")]
    pub entity_name: Option<serde_json::Value>,
}
impl CommonDataServiceForAppsEntityDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: CommonDataServiceForAppsLinkedServiceTypeProperties,
}
impl CommonDataServiceForAppsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CommonDataServiceForAppsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsLinkedServiceTypeProperties {
    #[serde(rename = "deploymentType")]
    pub deployment_type: serde_json::Value,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "serviceUri", default, skip_serializing_if = "Option::is_none")]
    pub service_uri: Option<serde_json::Value>,
    #[serde(rename = "organizationName", default, skip_serializing_if = "Option::is_none")]
    pub organization_name: Option<serde_json::Value>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential_type: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalCredential", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl CommonDataServiceForAppsLinkedServiceTypeProperties {
    pub fn new(deployment_type: serde_json::Value, authentication_type: serde_json::Value) -> Self {
        Self {
            deployment_type,
            host_name: None,
            port: None,
            service_uri: None,
            organization_name: None,
            authentication_type,
            username: None,
            password: None,
            service_principal_id: None,
            service_principal_credential_type: None,
            service_principal_credential: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior")]
    pub write_behavior: DynamicsSinkWriteBehavior,
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
    #[serde(rename = "alternateKeyName", default, skip_serializing_if = "Option::is_none")]
    pub alternate_key_name: Option<serde_json::Value>,
}
impl CommonDataServiceForAppsSink {
    pub fn new(copy_sink: CopySink, write_behavior: DynamicsSinkWriteBehavior) -> Self {
        Self {
            copy_sink,
            write_behavior,
            ignore_null_values: None,
            alternate_key_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl CommonDataServiceForAppsSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ComponentSetup {
    #[serde(flatten)]
    pub custom_setup_base: CustomSetupBase,
    #[serde(rename = "typeProperties")]
    pub type_properties: LicensedComponentSetupTypeProperties,
}
impl ComponentSetup {
    pub fn new(custom_setup_base: CustomSetupBase, type_properties: LicensedComponentSetupTypeProperties) -> Self {
        Self {
            custom_setup_base,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CompressionCodec {
    #[serde(rename = "none")]
    None,
    #[serde(rename = "lzo")]
    Lzo,
    #[serde(rename = "bzip2")]
    Bzip2,
    #[serde(rename = "gzip")]
    Gzip,
    #[serde(rename = "deflate")]
    Deflate,
    #[serde(rename = "zipDeflate")]
    ZipDeflate,
    #[serde(rename = "snappy")]
    Snappy,
    #[serde(rename = "lz4")]
    Lz4,
    #[serde(rename = "tar")]
    Tar,
    #[serde(rename = "tarGZip")]
    TarGZip,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CompressionLevel {
    Optimal,
    Fastest,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CompressionReadSettings {
    #[serde(rename = "type")]
    pub type_: String,
}
impl CompressionReadSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConcurLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: ConcurLinkedServiceTypeProperties,
}
impl ConcurLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ConcurLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConcurLinkedServiceTypeProperties {
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    pub username: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ConcurLinkedServiceTypeProperties {
    pub fn new(client_id: serde_json::Value, username: serde_json::Value) -> Self {
        Self {
            connection_properties: None,
            client_id,
            username,
            password: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConcurObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ConcurObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConcurSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ConcurSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionStateProperties {
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl ConnectionStateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ControlActivity {
    #[serde(flatten)]
    pub activity: Activity,
}
impl ControlActivity {
    pub fn new(activity: Activity) -> Self {
        Self { activity }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopyActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: CopyActivityTypeProperties,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub inputs: Vec<DatasetReference>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub outputs: Vec<DatasetReference>,
}
impl CopyActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: CopyActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
            inputs: Vec::new(),
            outputs: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CopyActivityLogSettings {
    #[serde(rename = "logLevel", default, skip_serializing_if = "Option::is_none")]
    pub log_level: Option<serde_json::Value>,
    #[serde(rename = "enableReliableLogging", default, skip_serializing_if = "Option::is_none")]
    pub enable_reliable_logging: Option<serde_json::Value>,
}
impl CopyActivityLogSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopyActivityTypeProperties {
    pub source: CopySource,
    pub sink: CopySink,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub translator: Option<serde_json::Value>,
    #[serde(rename = "enableStaging", default, skip_serializing_if = "Option::is_none")]
    pub enable_staging: Option<serde_json::Value>,
    #[serde(rename = "stagingSettings", default, skip_serializing_if = "Option::is_none")]
    pub staging_settings: Option<StagingSettings>,
    #[serde(rename = "parallelCopies", default, skip_serializing_if = "Option::is_none")]
    pub parallel_copies: Option<serde_json::Value>,
    #[serde(rename = "dataIntegrationUnits", default, skip_serializing_if = "Option::is_none")]
    pub data_integration_units: Option<serde_json::Value>,
    #[serde(rename = "enableSkipIncompatibleRow", default, skip_serializing_if = "Option::is_none")]
    pub enable_skip_incompatible_row: Option<serde_json::Value>,
    #[serde(rename = "redirectIncompatibleRowSettings", default, skip_serializing_if = "Option::is_none")]
    pub redirect_incompatible_row_settings: Option<RedirectIncompatibleRowSettings>,
    #[serde(rename = "logStorageSettings", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_settings: Option<LogStorageSettings>,
    #[serde(rename = "logSettings", default, skip_serializing_if = "Option::is_none")]
    pub log_settings: Option<LogSettings>,
    #[serde(rename = "preserveRules", default, skip_serializing_if = "Vec::is_empty")]
    pub preserve_rules: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub preserve: Vec<serde_json::Value>,
    #[serde(rename = "validateDataConsistency", default, skip_serializing_if = "Option::is_none")]
    pub validate_data_consistency: Option<serde_json::Value>,
    #[serde(rename = "skipErrorFile", default, skip_serializing_if = "Option::is_none")]
    pub skip_error_file: Option<SkipErrorFile>,
}
impl CopyActivityTypeProperties {
    pub fn new(source: CopySource, sink: CopySink) -> Self {
        Self {
            source,
            sink,
            translator: None,
            enable_staging: None,
            staging_settings: None,
            parallel_copies: None,
            data_integration_units: None,
            enable_skip_incompatible_row: None,
            redirect_incompatible_row_settings: None,
            log_storage_settings: None,
            log_settings: None,
            preserve_rules: Vec::new(),
            preserve: Vec::new(),
            validate_data_consistency: None,
            skip_error_file: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CopyBehaviorType {
    PreserveHierarchy,
    FlattenHierarchy,
    MergeFiles,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopySink {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(rename = "writeBatchSize", default, skip_serializing_if = "Option::is_none")]
    pub write_batch_size: Option<serde_json::Value>,
    #[serde(rename = "writeBatchTimeout", default, skip_serializing_if = "Option::is_none")]
    pub write_batch_timeout: Option<serde_json::Value>,
    #[serde(rename = "sinkRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub sink_retry_count: Option<serde_json::Value>,
    #[serde(rename = "sinkRetryWait", default, skip_serializing_if = "Option::is_none")]
    pub sink_retry_wait: Option<serde_json::Value>,
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<serde_json::Value>,
    #[serde(rename = "disableMetricsCollection", default, skip_serializing_if = "Option::is_none")]
    pub disable_metrics_collection: Option<serde_json::Value>,
}
impl CopySink {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            write_batch_size: None,
            write_batch_timeout: None,
            sink_retry_count: None,
            sink_retry_wait: None,
            max_concurrent_connections: None,
            disable_metrics_collection: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopySource {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(rename = "sourceRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub source_retry_count: Option<serde_json::Value>,
    #[serde(rename = "sourceRetryWait", default, skip_serializing_if = "Option::is_none")]
    pub source_retry_wait: Option<serde_json::Value>,
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<serde_json::Value>,
    #[serde(rename = "disableMetricsCollection", default, skip_serializing_if = "Option::is_none")]
    pub disable_metrics_collection: Option<serde_json::Value>,
}
impl CopySource {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            source_retry_count: None,
            source_retry_wait: None,
            max_concurrent_connections: None,
            disable_metrics_collection: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopyTranslator {
    #[serde(rename = "type")]
    pub type_: String,
}
impl CopyTranslator {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: CosmosDbLinkedServiceTypeProperties,
}
impl CosmosDbLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CosmosDbLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CosmosDbLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(rename = "accountEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub account_endpoint: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub database: Option<serde_json::Value>,
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<SecretBase>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential_type: Option<cosmos_db_linked_service_type_properties::ServicePrincipalCredentialType>,
    #[serde(rename = "servicePrincipalCredential", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[serde(rename = "connectionMode", default, skip_serializing_if = "Option::is_none")]
    pub connection_mode: Option<cosmos_db_linked_service_type_properties::ConnectionMode>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl CosmosDbLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod cosmos_db_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServicePrincipalCredentialType {
        ServicePrincipalKey,
        ServicePrincipalCert,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionMode {
        Gateway,
        Direct,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: CosmosDbMongoDbApiCollectionDatasetTypeProperties,
}
impl CosmosDbMongoDbApiCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: CosmosDbMongoDbApiCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiCollectionDatasetTypeProperties {
    pub collection: serde_json::Value,
}
impl CosmosDbMongoDbApiCollectionDatasetTypeProperties {
    pub fn new(collection: serde_json::Value) -> Self {
        Self { collection }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: CosmosDbMongoDbApiLinkedServiceTypeProperties,
}
impl CosmosDbMongoDbApiLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CosmosDbMongoDbApiLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiLinkedServiceTypeProperties {
    #[serde(rename = "isServerVersionAbove32", default, skip_serializing_if = "Option::is_none")]
    pub is_server_version_above32: Option<serde_json::Value>,
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    pub database: serde_json::Value,
}
impl CosmosDbMongoDbApiLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            is_server_version_above32: None,
            connection_string,
            database,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
}
impl CosmosDbMongoDbApiSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<serde_json::Value>,
    #[serde(rename = "cursorMethods", default, skip_serializing_if = "Option::is_none")]
    pub cursor_methods: Option<MongoDbCursorMethodsProperties>,
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<serde_json::Value>,
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl CosmosDbMongoDbApiSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            filter: None,
            cursor_methods: None,
            batch_size: None,
            query_timeout: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbSqlApiCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: CosmosDbSqlApiCollectionDatasetTypeProperties,
}
impl CosmosDbSqlApiCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: CosmosDbSqlApiCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbSqlApiCollectionDatasetTypeProperties {
    #[serde(rename = "collectionName")]
    pub collection_name: serde_json::Value,
}
impl CosmosDbSqlApiCollectionDatasetTypeProperties {
    pub fn new(collection_name: serde_json::Value) -> Self {
        Self { collection_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbSqlApiSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
}
impl CosmosDbSqlApiSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbSqlApiSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "pageSize", default, skip_serializing_if = "Option::is_none")]
    pub page_size: Option<serde_json::Value>,
    #[serde(rename = "preferredRegions", default, skip_serializing_if = "Option::is_none")]
    pub preferred_regions: Option<serde_json::Value>,
    #[serde(rename = "detectDatetime", default, skip_serializing_if = "Option::is_none")]
    pub detect_datetime: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl CosmosDbSqlApiSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            page_size: None,
            preferred_regions: None,
            detect_datetime: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CouchbaseLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: CouchbaseLinkedServiceTypeProperties,
}
impl CouchbaseLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CouchbaseLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CouchbaseLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(rename = "credString", default, skip_serializing_if = "Option::is_none")]
    pub cred_string: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl CouchbaseLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CouchbaseSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl CouchbaseSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CouchbaseTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl CouchbaseTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateDataFlowDebugSessionRequest {
    #[serde(rename = "computeType", default, skip_serializing_if = "Option::is_none")]
    pub compute_type: Option<String>,
    #[serde(rename = "coreCount", default, skip_serializing_if = "Option::is_none")]
    pub core_count: Option<i64>,
    #[serde(rename = "timeToLive", default, skip_serializing_if = "Option::is_none")]
    pub time_to_live: Option<i64>,
    #[serde(rename = "integrationRuntime", default, skip_serializing_if = "Option::is_none")]
    pub integration_runtime: Option<IntegrationRuntimeDebugResource>,
}
impl CreateDataFlowDebugSessionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateDataFlowDebugSessionResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
}
impl CreateDataFlowDebugSessionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateLinkedIntegrationRuntimeRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "dataFactoryName", default, skip_serializing_if = "Option::is_none")]
    pub data_factory_name: Option<String>,
    #[serde(rename = "dataFactoryLocation", default, skip_serializing_if = "Option::is_none")]
    pub data_factory_location: Option<String>,
}
impl CreateLinkedIntegrationRuntimeRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateRunResponse {
    #[serde(rename = "runId")]
    pub run_id: String,
}
impl CreateRunResponse {
    pub fn new(run_id: String) -> Self {
        Self { run_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Credential {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
}
impl Credential {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            description: None,
            annotations: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CredentialReference {
    #[serde(rename = "type")]
    pub type_: credential_reference::Type,
    #[serde(rename = "referenceName")]
    pub reference_name: String,
}
impl CredentialReference {
    pub fn new(type_: credential_reference::Type, reference_name: String) -> Self {
        Self { type_, reference_name }
    }
}
pub mod credential_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        CredentialReference,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CredentialResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: Credential,
}
impl CredentialResource {
    pub fn new(properties: Credential) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: CustomActivityTypeProperties,
}
impl CustomActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: CustomActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomActivityReferenceObject {
    #[serde(rename = "linkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_services: Vec<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datasets: Vec<DatasetReference>,
}
impl CustomActivityReferenceObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomActivityTypeProperties {
    pub command: serde_json::Value,
    #[serde(rename = "resourceLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub resource_linked_service: Option<LinkedServiceReference>,
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[serde(rename = "referenceObjects", default, skip_serializing_if = "Option::is_none")]
    pub reference_objects: Option<CustomActivityReferenceObject>,
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<serde_json::Value>,
    #[serde(rename = "retentionTimeInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_time_in_days: Option<serde_json::Value>,
    #[serde(rename = "autoUserSpecification", default, skip_serializing_if = "Option::is_none")]
    pub auto_user_specification: Option<serde_json::Value>,
}
impl CustomActivityTypeProperties {
    pub fn new(command: serde_json::Value) -> Self {
        Self {
            command,
            resource_linked_service: None,
            folder_path: None,
            reference_objects: None,
            extended_properties: None,
            retention_time_in_days: None,
            auto_user_specification: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomDataSourceLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: serde_json::Value,
}
impl CustomDataSourceLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: serde_json::Value) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<serde_json::Value>,
}
impl CustomDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomEventsTrigger {
    #[serde(flatten)]
    pub multiple_pipeline_trigger: MultiplePipelineTrigger,
    #[serde(rename = "typeProperties")]
    pub type_properties: custom_events_trigger::TypeProperties,
}
impl CustomEventsTrigger {
    pub fn new(multiple_pipeline_trigger: MultiplePipelineTrigger, type_properties: custom_events_trigger::TypeProperties) -> Self {
        Self {
            multiple_pipeline_trigger,
            type_properties,
        }
    }
}
pub mod custom_events_trigger {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[serde(rename = "subjectBeginsWith", default, skip_serializing_if = "Option::is_none")]
        pub subject_begins_with: Option<String>,
        #[serde(rename = "subjectEndsWith", default, skip_serializing_if = "Option::is_none")]
        pub subject_ends_with: Option<String>,
        pub events: Vec<serde_json::Value>,
        pub scope: String,
    }
    impl TypeProperties {
        pub fn new(events: Vec<serde_json::Value>, scope: String) -> Self {
            Self {
                subject_begins_with: None,
                subject_ends_with: None,
                events,
                scope,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomSetupBase {
    #[serde(rename = "type")]
    pub type_: String,
}
impl CustomSetupBase {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DwCopyCommandDefaultValue {
    #[serde(rename = "columnName", default, skip_serializing_if = "Option::is_none")]
    pub column_name: Option<serde_json::Value>,
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<serde_json::Value>,
}
impl DwCopyCommandDefaultValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DwCopyCommandSettings {
    #[serde(rename = "defaultValues", default, skip_serializing_if = "Vec::is_empty")]
    pub default_values: Vec<DwCopyCommandDefaultValue>,
    #[serde(rename = "additionalOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_options: Option<serde_json::Value>,
}
impl DwCopyCommandSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlow {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub folder: Option<data_flow::Folder>,
}
impl DataFlow {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            description: None,
            annotations: Vec::new(),
            folder: None,
        }
    }
}
pub mod data_flow {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Folder {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Folder {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowDebugCommandPayload {
    #[serde(rename = "streamName")]
    pub stream_name: String,
    #[serde(rename = "rowLimits", default, skip_serializing_if = "Option::is_none")]
    pub row_limits: Option<i64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expression: Option<String>,
}
impl DataFlowDebugCommandPayload {
    pub fn new(stream_name: String) -> Self {
        Self {
            stream_name,
            row_limits: None,
            columns: Vec::new(),
            expression: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugCommandRequest {
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub command: Option<data_flow_debug_command_request::Command>,
    #[serde(rename = "commandPayload", default, skip_serializing_if = "Option::is_none")]
    pub command_payload: Option<DataFlowDebugCommandPayload>,
}
impl DataFlowDebugCommandRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_flow_debug_command_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Command {
        #[serde(rename = "executePreviewQuery")]
        ExecutePreviewQuery,
        #[serde(rename = "executeStatisticsQuery")]
        ExecuteStatisticsQuery,
        #[serde(rename = "executeExpressionQuery")]
        ExecuteExpressionQuery,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugCommandResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
}
impl DataFlowDebugCommandResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugPackage {
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[serde(rename = "dataFlow", default, skip_serializing_if = "Option::is_none")]
    pub data_flow: Option<DataFlowDebugResource>,
    #[serde(rename = "dataFlows", default, skip_serializing_if = "Vec::is_empty")]
    pub data_flows: Vec<DataFlowDebugResource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datasets: Vec<DatasetDebugResource>,
    #[serde(rename = "linkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_services: Vec<LinkedServiceDebugResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub staging: Option<DataFlowStagingInfo>,
    #[serde(rename = "debugSettings", default, skip_serializing_if = "Option::is_none")]
    pub debug_settings: Option<data_flow_debug_package::DebugSettings>,
}
impl DataFlowDebugPackage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_flow_debug_package {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct DebugSettings {
        #[serde(rename = "sourceSettings", default, skip_serializing_if = "Vec::is_empty")]
        pub source_settings: Vec<DataFlowSourceSetting>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub parameters: Option<ParameterValueSpecification>,
        #[serde(rename = "datasetParameters", default, skip_serializing_if = "Option::is_none")]
        pub dataset_parameters: Option<serde_json::Value>,
    }
    impl DebugSettings {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowDebugResource {
    #[serde(flatten)]
    pub sub_resource_debug_resource: SubResourceDebugResource,
    pub properties: DataFlow,
}
impl DataFlowDebugResource {
    pub fn new(properties: DataFlow) -> Self {
        Self {
            sub_resource_debug_resource: SubResourceDebugResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugSessionInfo {
    #[serde(rename = "dataFlowName", default, skip_serializing_if = "Option::is_none")]
    pub data_flow_name: Option<String>,
    #[serde(rename = "computeType", default, skip_serializing_if = "Option::is_none")]
    pub compute_type: Option<String>,
    #[serde(rename = "coreCount", default, skip_serializing_if = "Option::is_none")]
    pub core_count: Option<i64>,
    #[serde(rename = "nodeCount", default, skip_serializing_if = "Option::is_none")]
    pub node_count: Option<i64>,
    #[serde(rename = "integrationRuntimeName", default, skip_serializing_if = "Option::is_none")]
    pub integration_runtime_name: Option<String>,
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "timeToLiveInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub time_to_live_in_minutes: Option<i64>,
    #[serde(rename = "lastActivityTime", default, skip_serializing_if = "Option::is_none")]
    pub last_activity_time: Option<String>,
}
impl DataFlowDebugSessionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowListResponse {
    pub value: Vec<DataFlowResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DataFlowListResponse {
    pub fn new(value: Vec<DataFlowResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowReference {
    #[serde(rename = "type")]
    pub type_: data_flow_reference::Type,
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[serde(rename = "datasetParameters", default, skip_serializing_if = "Option::is_none")]
    pub dataset_parameters: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl DataFlowReference {
    pub fn new(type_: data_flow_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            dataset_parameters: None,
            parameters: None,
        }
    }
}
pub mod data_flow_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        DataFlowReference,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: DataFlow,
}
impl DataFlowResource {
    pub fn new(properties: DataFlow) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowSink {
    #[serde(flatten)]
    pub transformation: Transformation,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataset: Option<DatasetReference>,
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
    #[serde(rename = "schemaLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub schema_linked_service: Option<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flowlet: Option<DataFlowReference>,
}
impl DataFlowSink {
    pub fn new(transformation: Transformation) -> Self {
        Self {
            transformation,
            dataset: None,
            linked_service: None,
            schema_linked_service: None,
            flowlet: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowSource {
    #[serde(flatten)]
    pub transformation: Transformation,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataset: Option<DatasetReference>,
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
    #[serde(rename = "schemaLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub schema_linked_service: Option<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flowlet: Option<DataFlowReference>,
}
impl DataFlowSource {
    pub fn new(transformation: Transformation) -> Self {
        Self {
            transformation,
            dataset: None,
            linked_service: None,
            schema_linked_service: None,
            flowlet: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowSourceSetting {
    #[serde(rename = "sourceName", default, skip_serializing_if = "Option::is_none")]
    pub source_name: Option<String>,
    #[serde(rename = "rowLimit", default, skip_serializing_if = "Option::is_none")]
    pub row_limit: Option<i64>,
}
impl DataFlowSourceSetting {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowStagingInfo {
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
}
impl DataFlowStagingInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataLakeAnalyticsUsqlActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: DataLakeAnalyticsUsqlActivityTypeProperties,
}
impl DataLakeAnalyticsUsqlActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DataLakeAnalyticsUsqlActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataLakeAnalyticsUsqlActivityTypeProperties {
    #[serde(rename = "scriptPath")]
    pub script_path: serde_json::Value,
    #[serde(rename = "scriptLinkedService")]
    pub script_linked_service: LinkedServiceReference,
    #[serde(rename = "degreeOfParallelism", default, skip_serializing_if = "Option::is_none")]
    pub degree_of_parallelism: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[serde(rename = "runtimeVersion", default, skip_serializing_if = "Option::is_none")]
    pub runtime_version: Option<serde_json::Value>,
    #[serde(rename = "compilationMode", default, skip_serializing_if = "Option::is_none")]
    pub compilation_mode: Option<serde_json::Value>,
}
impl DataLakeAnalyticsUsqlActivityTypeProperties {
    pub fn new(script_path: serde_json::Value, script_linked_service: LinkedServiceReference) -> Self {
        Self {
            script_path,
            script_linked_service,
            degree_of_parallelism: None,
            priority: None,
            parameters: None,
            runtime_version: None,
            compilation_mode: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksNotebookActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: DatabricksNotebookActivityTypeProperties,
}
impl DatabricksNotebookActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DatabricksNotebookActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksNotebookActivityTypeProperties {
    #[serde(rename = "notebookPath")]
    pub notebook_path: serde_json::Value,
    #[serde(rename = "baseParameters", default, skip_serializing_if = "Option::is_none")]
    pub base_parameters: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub libraries: Vec<serde_json::Value>,
}
impl DatabricksNotebookActivityTypeProperties {
    pub fn new(notebook_path: serde_json::Value) -> Self {
        Self {
            notebook_path,
            base_parameters: None,
            libraries: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksSparkJarActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: DatabricksSparkJarActivityTypeProperties,
}
impl DatabricksSparkJarActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DatabricksSparkJarActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksSparkJarActivityTypeProperties {
    #[serde(rename = "mainClassName")]
    pub main_class_name: serde_json::Value,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub libraries: Vec<serde_json::Value>,
}
impl DatabricksSparkJarActivityTypeProperties {
    pub fn new(main_class_name: serde_json::Value) -> Self {
        Self {
            main_class_name,
            parameters: Vec::new(),
            libraries: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksSparkPythonActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: DatabricksSparkPythonActivityTypeProperties,
}
impl DatabricksSparkPythonActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DatabricksSparkPythonActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksSparkPythonActivityTypeProperties {
    #[serde(rename = "pythonFile")]
    pub python_file: serde_json::Value,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub libraries: Vec<serde_json::Value>,
}
impl DatabricksSparkPythonActivityTypeProperties {
    pub fn new(python_file: serde_json::Value) -> Self {
        Self {
            python_file,
            parameters: Vec::new(),
            libraries: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dataset {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub structure: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterDefinitionSpecification>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub folder: Option<dataset::Folder>,
}
impl Dataset {
    pub fn new(type_: String, linked_service_name: LinkedServiceReference) -> Self {
        Self {
            type_,
            description: None,
            structure: None,
            schema: None,
            linked_service_name,
            parameters: None,
            annotations: Vec::new(),
            folder: None,
        }
    }
}
pub mod dataset {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Folder {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Folder {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetCompression {
    #[serde(rename = "type")]
    pub type_: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<serde_json::Value>,
}
impl DatasetCompression {
    pub fn new(type_: serde_json::Value) -> Self {
        Self { type_, level: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatasetDataElement {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<serde_json::Value>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<serde_json::Value>,
}
impl DatasetDataElement {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetDebugResource {
    #[serde(flatten)]
    pub sub_resource_debug_resource: SubResourceDebugResource,
    pub properties: Dataset,
}
impl DatasetDebugResource {
    pub fn new(properties: Dataset) -> Self {
        Self {
            sub_resource_debug_resource: SubResourceDebugResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetListResponse {
    pub value: Vec<DatasetResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DatasetListResponse {
    pub fn new(value: Vec<DatasetResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetLocation {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
}
impl DatasetLocation {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            folder_path: None,
            file_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetReference {
    #[serde(rename = "type")]
    pub type_: dataset_reference::Type,
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl DatasetReference {
    pub fn new(type_: dataset_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            parameters: None,
        }
    }
}
pub mod dataset_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        DatasetReference,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: Dataset,
}
impl DatasetResource {
    pub fn new(properties: Dataset) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatasetSchemaDataElement {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<serde_json::Value>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<serde_json::Value>,
}
impl DatasetSchemaDataElement {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetStorageFormat {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub serializer: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub deserializer: Option<serde_json::Value>,
}
impl DatasetStorageFormat {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            serializer: None,
            deserializer: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DayOfWeek {
    Sunday,
    Monday,
    Tuesday,
    Wednesday,
    Thursday,
    Friday,
    Saturday,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Db2LinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: Db2LinkedServiceTypeProperties,
}
impl Db2LinkedService {
    pub fn new(linked_service: LinkedService, type_properties: Db2LinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Db2LinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub database: Option<serde_json::Value>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<db2_linked_service_type_properties::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "packageCollection", default, skip_serializing_if = "Option::is_none")]
    pub package_collection: Option<serde_json::Value>,
    #[serde(rename = "certificateCommonName", default, skip_serializing_if = "Option::is_none")]
    pub certificate_common_name: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl Db2LinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod db2_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Db2Source {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl Db2Source {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Db2TableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<Db2TableDatasetTypeProperties>,
}
impl Db2TableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Db2TableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl Db2TableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeleteActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: DeleteActivityTypeProperties,
}
impl DeleteActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DeleteActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeleteActivityTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<i64>,
    #[serde(rename = "enableLogging", default, skip_serializing_if = "Option::is_none")]
    pub enable_logging: Option<serde_json::Value>,
    #[serde(rename = "logStorageSettings", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_settings: Option<LogStorageSettings>,
    pub dataset: DatasetReference,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
}
impl DeleteActivityTypeProperties {
    pub fn new(dataset: DatasetReference) -> Self {
        Self {
            recursive: None,
            max_concurrent_connections: None,
            enable_logging: None,
            log_storage_settings: None,
            dataset,
            store_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeleteDataFlowDebugSessionRequest {
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
}
impl DeleteDataFlowDebugSessionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<DelimitedTextDatasetTypeProperties>,
}
impl DelimitedTextDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextDatasetTypeProperties {
    pub location: DatasetLocation,
    #[serde(rename = "columnDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub column_delimiter: Option<serde_json::Value>,
    #[serde(rename = "rowDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub row_delimiter: Option<serde_json::Value>,
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[serde(rename = "compressionCodec", default, skip_serializing_if = "Option::is_none")]
    pub compression_codec: Option<serde_json::Value>,
    #[serde(rename = "compressionLevel", default, skip_serializing_if = "Option::is_none")]
    pub compression_level: Option<serde_json::Value>,
    #[serde(rename = "quoteChar", default, skip_serializing_if = "Option::is_none")]
    pub quote_char: Option<serde_json::Value>,
    #[serde(rename = "escapeChar", default, skip_serializing_if = "Option::is_none")]
    pub escape_char: Option<serde_json::Value>,
    #[serde(rename = "firstRowAsHeader", default, skip_serializing_if = "Option::is_none")]
    pub first_row_as_header: Option<serde_json::Value>,
    #[serde(rename = "nullValue", default, skip_serializing_if = "Option::is_none")]
    pub null_value: Option<serde_json::Value>,
}
impl DelimitedTextDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            column_delimiter: None,
            row_delimiter: None,
            encoding_name: None,
            compression_codec: None,
            compression_level: None,
            quote_char: None,
            escape_char: None,
            first_row_as_header: None,
            null_value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextReadSettings {
    #[serde(flatten)]
    pub format_read_settings: FormatReadSettings,
    #[serde(rename = "skipLineCount", default, skip_serializing_if = "Option::is_none")]
    pub skip_line_count: Option<serde_json::Value>,
    #[serde(rename = "compressionProperties", default, skip_serializing_if = "Option::is_none")]
    pub compression_properties: Option<CompressionReadSettings>,
}
impl DelimitedTextReadSettings {
    pub fn new(format_read_settings: FormatReadSettings) -> Self {
        Self {
            format_read_settings,
            skip_line_count: None,
            compression_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<DelimitedTextWriteSettings>,
}
impl DelimitedTextSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<DelimitedTextReadSettings>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl DelimitedTextSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            format_settings: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[serde(rename = "quoteAllText", default, skip_serializing_if = "Option::is_none")]
    pub quote_all_text: Option<serde_json::Value>,
    #[serde(rename = "fileExtension")]
    pub file_extension: serde_json::Value,
    #[serde(rename = "maxRowsPerFile", default, skip_serializing_if = "Option::is_none")]
    pub max_rows_per_file: Option<serde_json::Value>,
    #[serde(rename = "fileNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub file_name_prefix: Option<serde_json::Value>,
}
impl DelimitedTextWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings, file_extension: serde_json::Value) -> Self {
        Self {
            format_write_settings,
            quote_all_text: None,
            file_extension,
            max_rows_per_file: None,
            file_name_prefix: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DependencyReference {
    #[serde(rename = "type")]
    pub type_: String,
}
impl DependencyReference {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DistcpSettings {
    #[serde(rename = "resourceManagerEndpoint")]
    pub resource_manager_endpoint: serde_json::Value,
    #[serde(rename = "tempScriptPath")]
    pub temp_script_path: serde_json::Value,
    #[serde(rename = "distcpOptions", default, skip_serializing_if = "Option::is_none")]
    pub distcp_options: Option<serde_json::Value>,
}
impl DistcpSettings {
    pub fn new(resource_manager_endpoint: serde_json::Value, temp_script_path: serde_json::Value) -> Self {
        Self {
            resource_manager_endpoint,
            temp_script_path,
            distcp_options: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DocumentDbCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: DocumentDbCollectionDatasetTypeProperties,
}
impl DocumentDbCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: DocumentDbCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DocumentDbCollectionDatasetTypeProperties {
    #[serde(rename = "collectionName")]
    pub collection_name: serde_json::Value,
}
impl DocumentDbCollectionDatasetTypeProperties {
    pub fn new(collection_name: serde_json::Value) -> Self {
        Self { collection_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DocumentDbCollectionSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "nestingSeparator", default, skip_serializing_if = "Option::is_none")]
    pub nesting_separator: Option<serde_json::Value>,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
}
impl DocumentDbCollectionSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            nesting_separator: None,
            write_behavior: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DocumentDbCollectionSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "nestingSeparator", default, skip_serializing_if = "Option::is_none")]
    pub nesting_separator: Option<serde_json::Value>,
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl DocumentDbCollectionSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            nesting_separator: None,
            query_timeout: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DrillDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl DrillDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DrillLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: DrillLinkedServiceTypeProperties,
}
impl DrillLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: DrillLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DrillLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl DrillLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DrillSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl DrillSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DrillTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<DrillDatasetTypeProperties>,
}
impl DrillTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: DynamicsAxLinkedServiceTypeProperties,
}
impl DynamicsAxLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: DynamicsAxLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxLinkedServiceTypeProperties {
    pub url: serde_json::Value,
    #[serde(rename = "servicePrincipalId")]
    pub service_principal_id: serde_json::Value,
    #[serde(rename = "servicePrincipalKey")]
    pub service_principal_key: SecretBase,
    pub tenant: serde_json::Value,
    #[serde(rename = "aadResourceId")]
    pub aad_resource_id: serde_json::Value,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl DynamicsAxLinkedServiceTypeProperties {
    pub fn new(
        url: serde_json::Value,
        service_principal_id: serde_json::Value,
        service_principal_key: SecretBase,
        tenant: serde_json::Value,
        aad_resource_id: serde_json::Value,
    ) -> Self {
        Self {
            url,
            service_principal_id,
            service_principal_key,
            tenant,
            aad_resource_id,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: DynamicsAxResourceDatasetTypeProperties,
}
impl DynamicsAxResourceDataset {
    pub fn new(dataset: Dataset, type_properties: DynamicsAxResourceDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxResourceDatasetTypeProperties {
    pub path: serde_json::Value,
}
impl DynamicsAxResourceDatasetTypeProperties {
    pub fn new(path: serde_json::Value) -> Self {
        Self { path }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl DynamicsAxSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            http_request_timeout: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DynamicsAuthenticationType {
    Office365,
    Ifd,
    #[serde(rename = "AADServicePrincipal")]
    AadServicePrincipal,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmEntityDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<DynamicsCrmEntityDatasetTypeProperties>,
}
impl DynamicsCrmEntityDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DynamicsCrmEntityDatasetTypeProperties {
    #[serde(rename = "entityName", default, skip_serializing_if = "Option::is_none")]
    pub entity_name: Option<serde_json::Value>,
}
impl DynamicsCrmEntityDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: DynamicsCrmLinkedServiceTypeProperties,
}
impl DynamicsCrmLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: DynamicsCrmLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmLinkedServiceTypeProperties {
    #[serde(rename = "deploymentType")]
    pub deployment_type: serde_json::Value,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "serviceUri", default, skip_serializing_if = "Option::is_none")]
    pub service_uri: Option<serde_json::Value>,
    #[serde(rename = "organizationName", default, skip_serializing_if = "Option::is_none")]
    pub organization_name: Option<serde_json::Value>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential_type: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalCredential", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl DynamicsCrmLinkedServiceTypeProperties {
    pub fn new(deployment_type: serde_json::Value, authentication_type: serde_json::Value) -> Self {
        Self {
            deployment_type,
            host_name: None,
            port: None,
            service_uri: None,
            organization_name: None,
            authentication_type,
            username: None,
            password: None,
            service_principal_id: None,
            service_principal_credential_type: None,
            service_principal_credential: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior")]
    pub write_behavior: DynamicsSinkWriteBehavior,
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
    #[serde(rename = "alternateKeyName", default, skip_serializing_if = "Option::is_none")]
    pub alternate_key_name: Option<serde_json::Value>,
}
impl DynamicsCrmSink {
    pub fn new(copy_sink: CopySink, write_behavior: DynamicsSinkWriteBehavior) -> Self {
        Self {
            copy_sink,
            write_behavior,
            ignore_null_values: None,
            alternate_key_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl DynamicsCrmSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DynamicsDeploymentType {
    Online,
    OnPremisesWithIfd,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsEntityDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<DynamicsEntityDatasetTypeProperties>,
}
impl DynamicsEntityDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DynamicsEntityDatasetTypeProperties {
    #[serde(rename = "entityName", default, skip_serializing_if = "Option::is_none")]
    pub entity_name: Option<serde_json::Value>,
}
impl DynamicsEntityDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: DynamicsLinkedServiceTypeProperties,
}
impl DynamicsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: DynamicsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsLinkedServiceTypeProperties {
    #[serde(rename = "deploymentType")]
    pub deployment_type: serde_json::Value,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "serviceUri", default, skip_serializing_if = "Option::is_none")]
    pub service_uri: Option<serde_json::Value>,
    #[serde(rename = "organizationName", default, skip_serializing_if = "Option::is_none")]
    pub organization_name: Option<serde_json::Value>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential_type: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalCredential", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl DynamicsLinkedServiceTypeProperties {
    pub fn new(deployment_type: serde_json::Value, authentication_type: serde_json::Value) -> Self {
        Self {
            deployment_type,
            host_name: None,
            port: None,
            service_uri: None,
            organization_name: None,
            authentication_type,
            username: None,
            password: None,
            service_principal_id: None,
            service_principal_credential_type: None,
            service_principal_credential: None,
            encrypted_credential: None,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior")]
    pub write_behavior: DynamicsSinkWriteBehavior,
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
    #[serde(rename = "alternateKeyName", default, skip_serializing_if = "Option::is_none")]
    pub alternate_key_name: Option<serde_json::Value>,
}
impl DynamicsSink {
    pub fn new(copy_sink: CopySink, write_behavior: DynamicsSinkWriteBehavior) -> Self {
        Self {
            copy_sink,
            write_behavior,
            ignore_null_values: None,
            alternate_key_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DynamicsSinkWriteBehavior {
    Upsert,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl DynamicsSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EloquaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: EloquaLinkedServiceTypeProperties,
}
impl EloquaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: EloquaLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EloquaLinkedServiceTypeProperties {
    pub endpoint: serde_json::Value,
    pub username: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl EloquaLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value, username: serde_json::Value) -> Self {
        Self {
            endpoint,
            username,
            password: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EloquaObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl EloquaObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EloquaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl EloquaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptionConfiguration {
    #[serde(rename = "keyName")]
    pub key_name: String,
    #[serde(rename = "vaultBaseUrl")]
    pub vault_base_url: String,
    #[serde(rename = "keyVersion", default, skip_serializing_if = "Option::is_none")]
    pub key_version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<CmkIdentityDefinition>,
}
impl EncryptionConfiguration {
    pub fn new(key_name: String, vault_base_url: String) -> Self {
        Self {
            key_name,
            vault_base_url,
            key_version: None,
            identity: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityReference {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<entity_reference::Type>,
    #[serde(rename = "referenceName", default, skip_serializing_if = "Option::is_none")]
    pub reference_name: Option<String>,
}
impl EntityReference {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod entity_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        IntegrationRuntimeReference,
        LinkedServiceReference,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentVariableSetup {
    #[serde(flatten)]
    pub custom_setup_base: CustomSetupBase,
    #[serde(rename = "typeProperties")]
    pub type_properties: EnvironmentVariableSetupTypeProperties,
}
impl EnvironmentVariableSetup {
    pub fn new(custom_setup_base: CustomSetupBase, type_properties: EnvironmentVariableSetupTypeProperties) -> Self {
        Self {
            custom_setup_base,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentVariableSetupTypeProperties {
    #[serde(rename = "variableName")]
    pub variable_name: String,
    #[serde(rename = "variableValue")]
    pub variable_value: String,
}
impl EnvironmentVariableSetupTypeProperties {
    pub fn new(variable_name: String, variable_value: String) -> Self {
        Self {
            variable_name,
            variable_value,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExcelDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<ExcelDatasetTypeProperties>,
}
impl ExcelDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExcelDatasetTypeProperties {
    pub location: DatasetLocation,
    #[serde(rename = "sheetName", default, skip_serializing_if = "Option::is_none")]
    pub sheet_name: Option<serde_json::Value>,
    #[serde(rename = "sheetIndex", default, skip_serializing_if = "Option::is_none")]
    pub sheet_index: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub range: Option<serde_json::Value>,
    #[serde(rename = "firstRowAsHeader", default, skip_serializing_if = "Option::is_none")]
    pub first_row_as_header: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
    #[serde(rename = "nullValue", default, skip_serializing_if = "Option::is_none")]
    pub null_value: Option<serde_json::Value>,
}
impl ExcelDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            sheet_name: None,
            sheet_index: None,
            range: None,
            first_row_as_header: None,
            compression: None,
            null_value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExcelSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl ExcelSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecuteDataFlowActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: ExecuteDataFlowActivityTypeProperties,
}
impl ExecuteDataFlowActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: ExecuteDataFlowActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecuteDataFlowActivityTypeProperties {
    #[serde(rename = "dataFlow")]
    pub data_flow: DataFlowReference,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub staging: Option<DataFlowStagingInfo>,
    #[serde(rename = "integrationRuntime", default, skip_serializing_if = "Option::is_none")]
    pub integration_runtime: Option<IntegrationRuntimeReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compute: Option<execute_data_flow_activity_type_properties::Compute>,
    #[serde(rename = "traceLevel", default, skip_serializing_if = "Option::is_none")]
    pub trace_level: Option<serde_json::Value>,
    #[serde(rename = "continueOnError", default, skip_serializing_if = "Option::is_none")]
    pub continue_on_error: Option<serde_json::Value>,
    #[serde(rename = "runConcurrently", default, skip_serializing_if = "Option::is_none")]
    pub run_concurrently: Option<serde_json::Value>,
}
impl ExecuteDataFlowActivityTypeProperties {
    pub fn new(data_flow: DataFlowReference) -> Self {
        Self {
            data_flow,
            staging: None,
            integration_runtime: None,
            compute: None,
            trace_level: None,
            continue_on_error: None,
            run_concurrently: None,
        }
    }
}
pub mod execute_data_flow_activity_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Compute {
        #[serde(rename = "computeType", default, skip_serializing_if = "Option::is_none")]
        pub compute_type: Option<serde_json::Value>,
        #[serde(rename = "coreCount", default, skip_serializing_if = "Option::is_none")]
        pub core_count: Option<serde_json::Value>,
    }
    impl Compute {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecutePipelineActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: ExecutePipelineActivityTypeProperties,
}
impl ExecutePipelineActivity {
    pub fn new(control_activity: ControlActivity, type_properties: ExecutePipelineActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecutePipelineActivityTypeProperties {
    pub pipeline: PipelineReference,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
    #[serde(rename = "waitOnCompletion", default, skip_serializing_if = "Option::is_none")]
    pub wait_on_completion: Option<bool>,
}
impl ExecutePipelineActivityTypeProperties {
    pub fn new(pipeline: PipelineReference) -> Self {
        Self {
            pipeline,
            parameters: None,
            wait_on_completion: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecutePowerQueryActivityTypeProperties {
    #[serde(flatten)]
    pub execute_data_flow_activity_type_properties: ExecuteDataFlowActivityTypeProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sinks: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub queries: Vec<PowerQuerySinkMapping>,
}
impl ExecutePowerQueryActivityTypeProperties {
    pub fn new(execute_data_flow_activity_type_properties: ExecuteDataFlowActivityTypeProperties) -> Self {
        Self {
            execute_data_flow_activity_type_properties,
            sinks: None,
            queries: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecuteSsisPackageActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: ExecuteSsisPackageActivityTypeProperties,
}
impl ExecuteSsisPackageActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: ExecuteSsisPackageActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecuteSsisPackageActivityTypeProperties {
    #[serde(rename = "packageLocation")]
    pub package_location: SsisPackageLocation,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub runtime: Option<serde_json::Value>,
    #[serde(rename = "loggingLevel", default, skip_serializing_if = "Option::is_none")]
    pub logging_level: Option<serde_json::Value>,
    #[serde(rename = "environmentPath", default, skip_serializing_if = "Option::is_none")]
    pub environment_path: Option<serde_json::Value>,
    #[serde(rename = "executionCredential", default, skip_serializing_if = "Option::is_none")]
    pub execution_credential: Option<SsisExecutionCredential>,
    #[serde(rename = "connectVia")]
    pub connect_via: IntegrationRuntimeReference,
    #[serde(rename = "projectParameters", default, skip_serializing_if = "Option::is_none")]
    pub project_parameters: Option<serde_json::Value>,
    #[serde(rename = "packageParameters", default, skip_serializing_if = "Option::is_none")]
    pub package_parameters: Option<serde_json::Value>,
    #[serde(rename = "projectConnectionManagers", default, skip_serializing_if = "Option::is_none")]
    pub project_connection_managers: Option<serde_json::Value>,
    #[serde(rename = "packageConnectionManagers", default, skip_serializing_if = "Option::is_none")]
    pub package_connection_managers: Option<serde_json::Value>,
    #[serde(rename = "propertyOverrides", default, skip_serializing_if = "Option::is_none")]
    pub property_overrides: Option<serde_json::Value>,
    #[serde(rename = "logLocation", default, skip_serializing_if = "Option::is_none")]
    pub log_location: Option<SsisLogLocation>,
}
impl ExecuteSsisPackageActivityTypeProperties {
    pub fn new(package_location: SsisPackageLocation, connect_via: IntegrationRuntimeReference) -> Self {
        Self {
            package_location,
            runtime: None,
            logging_level: None,
            environment_path: None,
            execution_credential: None,
            connect_via,
            project_parameters: None,
            package_parameters: None,
            project_connection_managers: None,
            package_connection_managers: None,
            property_overrides: None,
            log_location: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecuteWranglingDataflowActivity {
    #[serde(flatten)]
    pub activity: Activity,
    #[serde(rename = "typeProperties")]
    pub type_properties: ExecutePowerQueryActivityTypeProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub policy: Option<ActivityPolicy>,
}
impl ExecuteWranglingDataflowActivity {
    pub fn new(activity: Activity, type_properties: ExecutePowerQueryActivityTypeProperties) -> Self {
        Self {
            activity,
            type_properties,
            policy: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecutionActivity {
    #[serde(flatten)]
    pub activity: Activity,
    #[serde(rename = "linkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub linked_service_name: Option<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub policy: Option<ActivityPolicy>,
}
impl ExecutionActivity {
    pub fn new(activity: Activity) -> Self {
        Self {
            activity,
            linked_service_name: None,
            policy: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportSettings {
    #[serde(rename = "type")]
    pub type_: String,
}
impl ExportSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExposureControlBatchRequest {
    #[serde(rename = "exposureControlRequests")]
    pub exposure_control_requests: Vec<ExposureControlRequest>,
}
impl ExposureControlBatchRequest {
    pub fn new(exposure_control_requests: Vec<ExposureControlRequest>) -> Self {
        Self { exposure_control_requests }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExposureControlBatchResponse {
    #[serde(rename = "exposureControlResponses")]
    pub exposure_control_responses: Vec<ExposureControlResponse>,
}
impl ExposureControlBatchResponse {
    pub fn new(exposure_control_responses: Vec<ExposureControlResponse>) -> Self {
        Self {
            exposure_control_responses,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExposureControlRequest {
    #[serde(rename = "featureName", default, skip_serializing_if = "Option::is_none")]
    pub feature_name: Option<String>,
    #[serde(rename = "featureType", default, skip_serializing_if = "Option::is_none")]
    pub feature_type: Option<String>,
}
impl ExposureControlRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExposureControlResponse {
    #[serde(rename = "featureName", default, skip_serializing_if = "Option::is_none")]
    pub feature_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ExposureControlResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Expression {
    #[serde(rename = "type")]
    pub type_: expression::Type,
    pub value: String,
}
impl Expression {
    pub fn new(type_: expression::Type, value: String) -> Self {
        Self { type_, value }
    }
}
pub mod expression {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Expression,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Factory {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<FactoryIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FactoryProperties>,
}
impl Factory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FactoryGitHubConfiguration {
    #[serde(flatten)]
    pub factory_repo_configuration: FactoryRepoConfiguration,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<GitHubClientSecret>,
}
impl FactoryGitHubConfiguration {
    pub fn new(factory_repo_configuration: FactoryRepoConfiguration) -> Self {
        Self {
            factory_repo_configuration,
            host_name: None,
            client_id: None,
            client_secret: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FactoryIdentity {
    #[serde(rename = "type")]
    pub type_: factory_identity::Type,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<UserAssignedIdentitiesDefinitionSpecification>,
}
impl FactoryIdentity {
    pub fn new(type_: factory_identity::Type) -> Self {
        Self {
            type_,
            principal_id: None,
            tenant_id: None,
            user_assigned_identities: None,
        }
    }
}
pub mod factory_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned,UserAssigned")]
        SystemAssignedUserAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FactoryListResponse {
    pub value: Vec<Factory>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FactoryListResponse {
    pub fn new(value: Vec<Factory>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FactoryProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "repoConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub repo_configuration: Option<FactoryRepoConfiguration>,
    #[serde(rename = "globalParameters", default, skip_serializing_if = "Option::is_none")]
    pub global_parameters: Option<GlobalParameterDefinitionSpecification>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionConfiguration>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<factory_properties::PublicNetworkAccess>,
}
impl FactoryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod factory_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicNetworkAccess {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FactoryRepoConfiguration {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(rename = "accountName")]
    pub account_name: String,
    #[serde(rename = "repositoryName")]
    pub repository_name: String,
    #[serde(rename = "collaborationBranch")]
    pub collaboration_branch: String,
    #[serde(rename = "rootFolder")]
    pub root_folder: String,
    #[serde(rename = "lastCommitId", default, skip_serializing_if = "Option::is_none")]
    pub last_commit_id: Option<String>,
}
impl FactoryRepoConfiguration {
    pub fn new(type_: String, account_name: String, repository_name: String, collaboration_branch: String, root_folder: String) -> Self {
        Self {
            type_,
            account_name,
            repository_name,
            collaboration_branch,
            root_folder,
            last_commit_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FactoryRepoUpdate {
    #[serde(rename = "factoryResourceId", default, skip_serializing_if = "Option::is_none")]
    pub factory_resource_id: Option<String>,
    #[serde(rename = "repoConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub repo_configuration: Option<FactoryRepoConfiguration>,
}
impl FactoryRepoUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FactoryUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<FactoryIdentity>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<factory_update_parameters::PublicNetworkAccess>,
}
impl FactoryUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod factory_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicNetworkAccess {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FactoryVstsConfiguration {
    #[serde(flatten)]
    pub factory_repo_configuration: FactoryRepoConfiguration,
    #[serde(rename = "projectName")]
    pub project_name: String,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl FactoryVstsConfiguration {
    pub fn new(factory_repo_configuration: FactoryRepoConfiguration, project_name: String) -> Self {
        Self {
            factory_repo_configuration,
            project_name,
            tenant_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FailActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: FailActivityTypeProperties,
}
impl FailActivity {
    pub fn new(control_activity: ControlActivity, type_properties: FailActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FailActivityTypeProperties {
    pub message: serde_json::Value,
    #[serde(rename = "errorCode")]
    pub error_code: serde_json::Value,
}
impl FailActivityTypeProperties {
    pub fn new(message: serde_json::Value, error_code: serde_json::Value) -> Self {
        Self { message, error_code }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: FileServerLinkedServiceTypeProperties,
}
impl FileServerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: FileServerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl FileServerLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            user_id: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl FileServerLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[serde(rename = "fileFilter", default, skip_serializing_if = "Option::is_none")]
    pub file_filter: Option<serde_json::Value>,
}
impl FileServerReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
            file_filter: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
}
impl FileServerWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self { store_write_settings }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileShareDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<FileShareDatasetTypeProperties>,
}
impl FileShareDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileShareDatasetTypeProperties {
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[serde(rename = "fileFilter", default, skip_serializing_if = "Option::is_none")]
    pub file_filter: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl FileShareDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileSystemSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
}
impl FileSystemSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            copy_behavior: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileSystemSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl FileSystemSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            recursive: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FilterActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: FilterActivityTypeProperties,
}
impl FilterActivity {
    pub fn new(control_activity: ControlActivity, type_properties: FilterActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FilterActivityTypeProperties {
    pub items: Expression,
    pub condition: Expression,
}
impl FilterActivityTypeProperties {
    pub fn new(items: Expression, condition: Expression) -> Self {
        Self { items, condition }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Flowlet {
    #[serde(flatten)]
    pub data_flow: DataFlow,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<FlowletTypeProperties>,
}
impl Flowlet {
    pub fn new(data_flow: DataFlow) -> Self {
        Self {
            data_flow,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FlowletTypeProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<DataFlowSource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sinks: Vec<DataFlowSink>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transformations: Vec<Transformation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<String>,
    #[serde(rename = "scriptLines", default, skip_serializing_if = "Vec::is_empty")]
    pub script_lines: Vec<String>,
}
impl FlowletTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ForEachActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: ForEachActivityTypeProperties,
}
impl ForEachActivity {
    pub fn new(control_activity: ControlActivity, type_properties: ForEachActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ForEachActivityTypeProperties {
    #[serde(rename = "isSequential", default, skip_serializing_if = "Option::is_none")]
    pub is_sequential: Option<bool>,
    #[serde(rename = "batchCount", default, skip_serializing_if = "Option::is_none")]
    pub batch_count: Option<i64>,
    pub items: Expression,
    pub activities: Vec<Activity>,
}
impl ForEachActivityTypeProperties {
    pub fn new(items: Expression, activities: Vec<Activity>) -> Self {
        Self {
            is_sequential: None,
            batch_count: None,
            items,
            activities,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FormatReadSettings {
    #[serde(rename = "type")]
    pub type_: String,
}
impl FormatReadSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FormatWriteSettings {
    #[serde(rename = "type")]
    pub type_: String,
}
impl FormatWriteSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FtpReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "useBinaryTransfer", default, skip_serializing_if = "Option::is_none")]
    pub use_binary_transfer: Option<bool>,
    #[serde(rename = "disableChunking", default, skip_serializing_if = "Option::is_none")]
    pub disable_chunking: Option<serde_json::Value>,
}
impl FtpReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            file_list_path: None,
            use_binary_transfer: None,
            disable_chunking: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FtpServerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: FtpServerLinkedServiceTypeProperties,
}
impl FtpServerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: FtpServerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FtpServerLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<ftp_server_linked_service_type_properties::AuthenticationType>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[serde(rename = "enableServerCertificateValidation", default, skip_serializing_if = "Option::is_none")]
    pub enable_server_certificate_validation: Option<serde_json::Value>,
}
impl FtpServerLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            port: None,
            authentication_type: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
            enable_ssl: None,
            enable_server_certificate_validation: None,
        }
    }
}
pub mod ftp_server_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FtpServerLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl FtpServerLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenericDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl GenericDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetDataFactoryOperationStatusResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl GetDataFactoryOperationStatusResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetMetadataActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: GetMetadataActivityTypeProperties,
}
impl GetMetadataActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: GetMetadataActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetMetadataActivityTypeProperties {
    pub dataset: DatasetReference,
    #[serde(rename = "fieldList", default, skip_serializing_if = "Vec::is_empty")]
    pub field_list: Vec<serde_json::Value>,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<FormatReadSettings>,
}
impl GetMetadataActivityTypeProperties {
    pub fn new(dataset: DatasetReference) -> Self {
        Self {
            dataset,
            field_list: Vec::new(),
            store_settings: None,
            format_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetSsisObjectMetadataRequest {
    #[serde(rename = "metadataPath", default, skip_serializing_if = "Option::is_none")]
    pub metadata_path: Option<String>,
}
impl GetSsisObjectMetadataRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GitHubAccessTokenRequest {
    #[serde(rename = "gitHubAccessCode")]
    pub git_hub_access_code: String,
    #[serde(rename = "gitHubClientId", default, skip_serializing_if = "Option::is_none")]
    pub git_hub_client_id: Option<String>,
    #[serde(rename = "gitHubClientSecret", default, skip_serializing_if = "Option::is_none")]
    pub git_hub_client_secret: Option<GitHubClientSecret>,
    #[serde(rename = "gitHubAccessTokenBaseUrl")]
    pub git_hub_access_token_base_url: String,
}
impl GitHubAccessTokenRequest {
    pub fn new(git_hub_access_code: String, git_hub_access_token_base_url: String) -> Self {
        Self {
            git_hub_access_code,
            git_hub_client_id: None,
            git_hub_client_secret: None,
            git_hub_access_token_base_url,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GitHubAccessTokenResponse {
    #[serde(rename = "gitHubAccessToken", default, skip_serializing_if = "Option::is_none")]
    pub git_hub_access_token: Option<String>,
}
impl GitHubAccessTokenResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GitHubClientSecret {
    #[serde(rename = "byoaSecretAkvUrl", default, skip_serializing_if = "Option::is_none")]
    pub byoa_secret_akv_url: Option<String>,
    #[serde(rename = "byoaSecretName", default, skip_serializing_if = "Option::is_none")]
    pub byoa_secret_name: Option<String>,
}
impl GitHubClientSecret {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GlobalParameterDefinitionSpecification {}
impl GlobalParameterDefinitionSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GlobalParameterSpecification {
    #[serde(rename = "type")]
    pub type_: global_parameter_specification::Type,
    pub value: serde_json::Value,
}
impl GlobalParameterSpecification {
    pub fn new(type_: global_parameter_specification::Type, value: serde_json::Value) -> Self {
        Self { type_, value }
    }
}
pub mod global_parameter_specification {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Object,
        String,
        Int,
        Float,
        Bool,
        Array,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleAdWordsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: GoogleAdWordsLinkedServiceTypeProperties,
}
impl GoogleAdWordsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: GoogleAdWordsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GoogleAdWordsLinkedServiceTypeProperties {
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[serde(rename = "clientCustomerID", default, skip_serializing_if = "Option::is_none")]
    pub client_customer_id: Option<serde_json::Value>,
    #[serde(rename = "developerToken", default, skip_serializing_if = "Option::is_none")]
    pub developer_token: Option<SecretBase>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<google_ad_words_linked_service_type_properties::AuthenticationType>,
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<SecretBase>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<serde_json::Value>,
    #[serde(rename = "keyFilePath", default, skip_serializing_if = "Option::is_none")]
    pub key_file_path: Option<serde_json::Value>,
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl GoogleAdWordsLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod google_ad_words_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        ServiceAuthentication,
        UserAuthentication,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleAdWordsObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl GoogleAdWordsObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleAdWordsSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl GoogleAdWordsSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GoogleBigQueryDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataset: Option<serde_json::Value>,
}
impl GoogleBigQueryDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleBigQueryLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: GoogleBigQueryLinkedServiceTypeProperties,
}
impl GoogleBigQueryLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: GoogleBigQueryLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleBigQueryLinkedServiceTypeProperties {
    pub project: serde_json::Value,
    #[serde(rename = "additionalProjects", default, skip_serializing_if = "Option::is_none")]
    pub additional_projects: Option<serde_json::Value>,
    #[serde(rename = "requestGoogleDriveScope", default, skip_serializing_if = "Option::is_none")]
    pub request_google_drive_scope: Option<serde_json::Value>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: google_big_query_linked_service_type_properties::AuthenticationType,
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<SecretBase>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<serde_json::Value>,
    #[serde(rename = "keyFilePath", default, skip_serializing_if = "Option::is_none")]
    pub key_file_path: Option<serde_json::Value>,
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl GoogleBigQueryLinkedServiceTypeProperties {
    pub fn new(
        project: serde_json::Value,
        authentication_type: google_big_query_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            project,
            additional_projects: None,
            request_google_drive_scope: None,
            authentication_type,
            refresh_token: None,
            client_id: None,
            client_secret: None,
            email: None,
            key_file_path: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            encrypted_credential: None,
        }
    }
}
pub mod google_big_query_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        ServiceAuthentication,
        UserAuthentication,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleBigQueryObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GoogleBigQueryDatasetTypeProperties>,
}
impl GoogleBigQueryObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleBigQuerySource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl GoogleBigQuerySource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleCloudStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: GoogleCloudStorageLinkedServiceTypeProperties,
}
impl GoogleCloudStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: GoogleCloudStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GoogleCloudStorageLinkedServiceTypeProperties {
    #[serde(rename = "accessKeyId", default, skip_serializing_if = "Option::is_none")]
    pub access_key_id: Option<serde_json::Value>,
    #[serde(rename = "secretAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub secret_access_key: Option<SecretBase>,
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl GoogleCloudStorageLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleCloudStorageLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[serde(rename = "bucketName", default, skip_serializing_if = "Option::is_none")]
    pub bucket_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<serde_json::Value>,
}
impl GoogleCloudStorageLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            bucket_name: None,
            version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleCloudStorageReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl GoogleCloudStorageReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GreenplumDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl GreenplumDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GreenplumLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: GreenplumLinkedServiceTypeProperties,
}
impl GreenplumLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: GreenplumLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GreenplumLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl GreenplumLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GreenplumSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl GreenplumSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GreenplumTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GreenplumDatasetTypeProperties>,
}
impl GreenplumTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HBaseLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: HBaseLinkedServiceTypeProperties,
}
impl HBaseLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HBaseLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HBaseLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "httpPath", default, skip_serializing_if = "Option::is_none")]
    pub http_path: Option<serde_json::Value>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: h_base_linked_service_type_properties::AuthenticationType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl HBaseLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, authentication_type: h_base_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            host,
            port: None,
            http_path: None,
            authentication_type,
            username: None,
            password: None,
            enable_ssl: None,
            trusted_cert_path: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod h_base_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        Basic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HBaseObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl HBaseObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HBaseSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl HBaseSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum HdInsightActivityDebugInfoOption {
    None,
    Always,
    Failure,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightHiveActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightHiveActivityTypeProperties,
}
impl HdInsightHiveActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightHiveActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HdInsightHiveActivityTypeProperties {
    #[serde(rename = "storageLinkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_linked_services: Vec<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<serde_json::Value>,
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    #[serde(rename = "scriptPath", default, skip_serializing_if = "Option::is_none")]
    pub script_path: Option<serde_json::Value>,
    #[serde(rename = "scriptLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub script_linked_service: Option<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub defines: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub variables: Vec<serde_json::Value>,
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<i64>,
}
impl HdInsightHiveActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightLinkedServiceTypeProperties,
}
impl HdInsightLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HdInsightLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightLinkedServiceTypeProperties {
    #[serde(rename = "clusterUri")]
    pub cluster_uri: serde_json::Value,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "linkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub linked_service_name: Option<LinkedServiceReference>,
    #[serde(rename = "hcatalogLinkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub hcatalog_linked_service_name: Option<LinkedServiceReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "isEspEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_esp_enabled: Option<serde_json::Value>,
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<serde_json::Value>,
}
impl HdInsightLinkedServiceTypeProperties {
    pub fn new(cluster_uri: serde_json::Value) -> Self {
        Self {
            cluster_uri,
            user_name: None,
            password: None,
            linked_service_name: None,
            hcatalog_linked_service_name: None,
            encrypted_credential: None,
            is_esp_enabled: None,
            file_system: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightMapReduceActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightMapReduceActivityTypeProperties,
}
impl HdInsightMapReduceActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightMapReduceActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightMapReduceActivityTypeProperties {
    #[serde(rename = "storageLinkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_linked_services: Vec<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<serde_json::Value>,
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    #[serde(rename = "className")]
    pub class_name: serde_json::Value,
    #[serde(rename = "jarFilePath")]
    pub jar_file_path: serde_json::Value,
    #[serde(rename = "jarLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub jar_linked_service: Option<LinkedServiceReference>,
    #[serde(rename = "jarLibs", default, skip_serializing_if = "Vec::is_empty")]
    pub jar_libs: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub defines: Option<serde_json::Value>,
}
impl HdInsightMapReduceActivityTypeProperties {
    pub fn new(class_name: serde_json::Value, jar_file_path: serde_json::Value) -> Self {
        Self {
            storage_linked_services: Vec::new(),
            arguments: Vec::new(),
            get_debug_info: None,
            class_name,
            jar_file_path,
            jar_linked_service: None,
            jar_libs: Vec::new(),
            defines: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightOnDemandLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightOnDemandLinkedServiceTypeProperties,
}
impl HdInsightOnDemandLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HdInsightOnDemandLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightOnDemandLinkedServiceTypeProperties {
    #[serde(rename = "clusterSize")]
    pub cluster_size: serde_json::Value,
    #[serde(rename = "timeToLive")]
    pub time_to_live: serde_json::Value,
    pub version: serde_json::Value,
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[serde(rename = "hostSubscriptionId")]
    pub host_subscription_id: serde_json::Value,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    pub tenant: serde_json::Value,
    #[serde(rename = "clusterResourceGroup")]
    pub cluster_resource_group: serde_json::Value,
    #[serde(rename = "clusterNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub cluster_name_prefix: Option<serde_json::Value>,
    #[serde(rename = "clusterUserName", default, skip_serializing_if = "Option::is_none")]
    pub cluster_user_name: Option<serde_json::Value>,
    #[serde(rename = "clusterPassword", default, skip_serializing_if = "Option::is_none")]
    pub cluster_password: Option<SecretBase>,
    #[serde(rename = "clusterSshUserName", default, skip_serializing_if = "Option::is_none")]
    pub cluster_ssh_user_name: Option<serde_json::Value>,
    #[serde(rename = "clusterSshPassword", default, skip_serializing_if = "Option::is_none")]
    pub cluster_ssh_password: Option<SecretBase>,
    #[serde(rename = "additionalLinkedServiceNames", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_linked_service_names: Vec<LinkedServiceReference>,
    #[serde(rename = "hcatalogLinkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub hcatalog_linked_service_name: Option<LinkedServiceReference>,
    #[serde(rename = "clusterType", default, skip_serializing_if = "Option::is_none")]
    pub cluster_type: Option<serde_json::Value>,
    #[serde(rename = "sparkVersion", default, skip_serializing_if = "Option::is_none")]
    pub spark_version: Option<serde_json::Value>,
    #[serde(rename = "coreConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub core_configuration: Option<serde_json::Value>,
    #[serde(rename = "hBaseConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub h_base_configuration: Option<serde_json::Value>,
    #[serde(rename = "hdfsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub hdfs_configuration: Option<serde_json::Value>,
    #[serde(rename = "hiveConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub hive_configuration: Option<serde_json::Value>,
    #[serde(rename = "mapReduceConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub map_reduce_configuration: Option<serde_json::Value>,
    #[serde(rename = "oozieConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub oozie_configuration: Option<serde_json::Value>,
    #[serde(rename = "stormConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub storm_configuration: Option<serde_json::Value>,
    #[serde(rename = "yarnConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub yarn_configuration: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "headNodeSize", default, skip_serializing_if = "Option::is_none")]
    pub head_node_size: Option<serde_json::Value>,
    #[serde(rename = "dataNodeSize", default, skip_serializing_if = "Option::is_none")]
    pub data_node_size: Option<serde_json::Value>,
    #[serde(rename = "zookeeperNodeSize", default, skip_serializing_if = "Option::is_none")]
    pub zookeeper_node_size: Option<serde_json::Value>,
    #[serde(rename = "scriptActions", default, skip_serializing_if = "Vec::is_empty")]
    pub script_actions: Vec<ScriptAction>,
    #[serde(rename = "virtualNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_id: Option<serde_json::Value>,
    #[serde(rename = "subnetName", default, skip_serializing_if = "Option::is_none")]
    pub subnet_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl HdInsightOnDemandLinkedServiceTypeProperties {
    pub fn new(
        cluster_size: serde_json::Value,
        time_to_live: serde_json::Value,
        version: serde_json::Value,
        linked_service_name: LinkedServiceReference,
        host_subscription_id: serde_json::Value,
        tenant: serde_json::Value,
        cluster_resource_group: serde_json::Value,
    ) -> Self {
        Self {
            cluster_size,
            time_to_live,
            version,
            linked_service_name,
            host_subscription_id,
            service_principal_id: None,
            service_principal_key: None,
            tenant,
            cluster_resource_group,
            cluster_name_prefix: None,
            cluster_user_name: None,
            cluster_password: None,
            cluster_ssh_user_name: None,
            cluster_ssh_password: None,
            additional_linked_service_names: Vec::new(),
            hcatalog_linked_service_name: None,
            cluster_type: None,
            spark_version: None,
            core_configuration: None,
            h_base_configuration: None,
            hdfs_configuration: None,
            hive_configuration: None,
            map_reduce_configuration: None,
            oozie_configuration: None,
            storm_configuration: None,
            yarn_configuration: None,
            encrypted_credential: None,
            head_node_size: None,
            data_node_size: None,
            zookeeper_node_size: None,
            script_actions: Vec::new(),
            virtual_network_id: None,
            subnet_name: None,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightPigActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightPigActivityTypeProperties,
}
impl HdInsightPigActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightPigActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HdInsightPigActivityTypeProperties {
    #[serde(rename = "storageLinkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_linked_services: Vec<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub arguments: Option<serde_json::Value>,
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    #[serde(rename = "scriptPath", default, skip_serializing_if = "Option::is_none")]
    pub script_path: Option<serde_json::Value>,
    #[serde(rename = "scriptLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub script_linked_service: Option<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub defines: Option<serde_json::Value>,
}
impl HdInsightPigActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightSparkActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightSparkActivityTypeProperties,
}
impl HdInsightSparkActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightSparkActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightSparkActivityTypeProperties {
    #[serde(rename = "rootPath")]
    pub root_path: serde_json::Value,
    #[serde(rename = "entryFilePath")]
    pub entry_file_path: serde_json::Value,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<serde_json::Value>,
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    #[serde(rename = "sparkJobLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub spark_job_linked_service: Option<LinkedServiceReference>,
    #[serde(rename = "className", default, skip_serializing_if = "Option::is_none")]
    pub class_name: Option<String>,
    #[serde(rename = "proxyUser", default, skip_serializing_if = "Option::is_none")]
    pub proxy_user: Option<serde_json::Value>,
    #[serde(rename = "sparkConfig", default, skip_serializing_if = "Option::is_none")]
    pub spark_config: Option<serde_json::Value>,
}
impl HdInsightSparkActivityTypeProperties {
    pub fn new(root_path: serde_json::Value, entry_file_path: serde_json::Value) -> Self {
        Self {
            root_path,
            entry_file_path,
            arguments: Vec::new(),
            get_debug_info: None,
            spark_job_linked_service: None,
            class_name: None,
            proxy_user: None,
            spark_config: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightStreamingActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightStreamingActivityTypeProperties,
}
impl HdInsightStreamingActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightStreamingActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightStreamingActivityTypeProperties {
    #[serde(rename = "storageLinkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_linked_services: Vec<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<serde_json::Value>,
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    pub mapper: serde_json::Value,
    pub reducer: serde_json::Value,
    pub input: serde_json::Value,
    pub output: serde_json::Value,
    #[serde(rename = "filePaths")]
    pub file_paths: Vec<serde_json::Value>,
    #[serde(rename = "fileLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub file_linked_service: Option<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub combiner: Option<serde_json::Value>,
    #[serde(rename = "commandEnvironment", default, skip_serializing_if = "Vec::is_empty")]
    pub command_environment: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub defines: Option<serde_json::Value>,
}
impl HdInsightStreamingActivityTypeProperties {
    pub fn new(
        mapper: serde_json::Value,
        reducer: serde_json::Value,
        input: serde_json::Value,
        output: serde_json::Value,
        file_paths: Vec<serde_json::Value>,
    ) -> Self {
        Self {
            storage_linked_services: Vec::new(),
            arguments: Vec::new(),
            get_debug_info: None,
            mapper,
            reducer,
            input,
            output,
            file_paths,
            file_linked_service: None,
            combiner: None,
            command_environment: Vec::new(),
            defines: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: HdfsLinkedServiceTypeProperties,
}
impl HdfsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HdfsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsLinkedServiceTypeProperties {
    pub url: serde_json::Value,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
}
impl HdfsLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            authentication_type: None,
            encrypted_credential: None,
            user_name: None,
            password: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl HdfsLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[serde(rename = "distcpSettings", default, skip_serializing_if = "Option::is_none")]
    pub distcp_settings: Option<DistcpSettings>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
}
impl HdfsReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
            distcp_settings: None,
            delete_files_after_completion: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "distcpSettings", default, skip_serializing_if = "Option::is_none")]
    pub distcp_settings: Option<DistcpSettings>,
}
impl HdfsSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            recursive: None,
            distcp_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum HdiNodeTypes {
    Headnode,
    Workernode,
    Zookeeper,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HiveDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl HiveDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HiveLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: HiveLinkedServiceTypeProperties,
}
impl HiveLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HiveLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HiveLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "serverType", default, skip_serializing_if = "Option::is_none")]
    pub server_type: Option<hive_linked_service_type_properties::ServerType>,
    #[serde(rename = "thriftTransportProtocol", default, skip_serializing_if = "Option::is_none")]
    pub thrift_transport_protocol: Option<hive_linked_service_type_properties::ThriftTransportProtocol>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: hive_linked_service_type_properties::AuthenticationType,
    #[serde(rename = "serviceDiscoveryMode", default, skip_serializing_if = "Option::is_none")]
    pub service_discovery_mode: Option<serde_json::Value>,
    #[serde(rename = "zooKeeperNameSpace", default, skip_serializing_if = "Option::is_none")]
    pub zoo_keeper_name_space: Option<serde_json::Value>,
    #[serde(rename = "useNativeQuery", default, skip_serializing_if = "Option::is_none")]
    pub use_native_query: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "httpPath", default, skip_serializing_if = "Option::is_none")]
    pub http_path: Option<serde_json::Value>,
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl HiveLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, authentication_type: hive_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            host,
            port: None,
            server_type: None,
            thrift_transport_protocol: None,
            authentication_type,
            service_discovery_mode: None,
            zoo_keeper_name_space: None,
            use_native_query: None,
            username: None,
            password: None,
            http_path: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod hive_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServerType {
        HiveServer1,
        HiveServer2,
        HiveThriftServer,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ThriftTransportProtocol {
        Binary,
        #[serde(rename = "SASL")]
        Sasl,
        #[serde(rename = "HTTP ")]
        Http,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        Username,
        UsernameAndPassword,
        #[serde(rename = "WindowsAzureHDInsightService")]
        WindowsAzureHdInsightService,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HiveObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<HiveDatasetTypeProperties>,
}
impl HiveObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HiveSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl HiveSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<HttpDatasetTypeProperties>,
}
impl HttpDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpDatasetTypeProperties {
    #[serde(rename = "relativeUrl", default, skip_serializing_if = "Option::is_none")]
    pub relative_url: Option<serde_json::Value>,
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[serde(rename = "requestBody", default, skip_serializing_if = "Option::is_none")]
    pub request_body: Option<serde_json::Value>,
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl HttpDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: HttpLinkedServiceTypeProperties,
}
impl HttpLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HttpLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpLinkedServiceTypeProperties {
    pub url: serde_json::Value,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<http_linked_service_type_properties::AuthenticationType>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "authHeaders", default, skip_serializing_if = "Option::is_none")]
    pub auth_headers: Option<serde_json::Value>,
    #[serde(rename = "embeddedCertData", default, skip_serializing_if = "Option::is_none")]
    pub embedded_cert_data: Option<serde_json::Value>,
    #[serde(rename = "certThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub cert_thumbprint: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "enableServerCertificateValidation", default, skip_serializing_if = "Option::is_none")]
    pub enable_server_certificate_validation: Option<serde_json::Value>,
}
impl HttpLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            authentication_type: None,
            user_name: None,
            password: None,
            auth_headers: None,
            embedded_cert_data: None,
            cert_thumbprint: None,
            encrypted_credential: None,
            enable_server_certificate_validation: None,
        }
    }
}
pub mod http_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
        Digest,
        Windows,
        ClientCertificate,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[serde(rename = "requestBody", default, skip_serializing_if = "Option::is_none")]
    pub request_body: Option<serde_json::Value>,
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[serde(rename = "requestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub request_timeout: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
}
impl HttpReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            request_method: None,
            request_body: None,
            additional_headers: None,
            request_timeout: None,
            enable_partition_discovery: None,
            partition_root_path: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpServerLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[serde(rename = "relativeUrl", default, skip_serializing_if = "Option::is_none")]
    pub relative_url: Option<serde_json::Value>,
}
impl HttpServerLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            relative_url: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl HttpSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            http_request_timeout: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubspotLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: HubspotLinkedServiceTypeProperties,
}
impl HubspotLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HubspotLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubspotLinkedServiceTypeProperties {
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl HubspotLinkedServiceTypeProperties {
    pub fn new(client_id: serde_json::Value) -> Self {
        Self {
            client_id,
            client_secret: None,
            access_token: None,
            refresh_token: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubspotObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl HubspotObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubspotSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl HubspotSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IfConditionActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: IfConditionActivityTypeProperties,
}
impl IfConditionActivity {
    pub fn new(control_activity: ControlActivity, type_properties: IfConditionActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IfConditionActivityTypeProperties {
    pub expression: Expression,
    #[serde(rename = "ifTrueActivities", default, skip_serializing_if = "Vec::is_empty")]
    pub if_true_activities: Vec<Activity>,
    #[serde(rename = "ifFalseActivities", default, skip_serializing_if = "Vec::is_empty")]
    pub if_false_activities: Vec<Activity>,
}
impl IfConditionActivityTypeProperties {
    pub fn new(expression: Expression) -> Self {
        Self {
            expression,
            if_true_activities: Vec::new(),
            if_false_activities: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImpalaDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl ImpalaDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImpalaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: ImpalaLinkedServiceTypeProperties,
}
impl ImpalaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ImpalaLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImpalaLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: impala_linked_service_type_properties::AuthenticationType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ImpalaLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, authentication_type: impala_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            host,
            port: None,
            authentication_type,
            username: None,
            password: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod impala_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        #[serde(rename = "SASLUsername")]
        SaslUsername,
        UsernameAndPassword,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImpalaObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<ImpalaDatasetTypeProperties>,
}
impl ImpalaObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImpalaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ImpalaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportSettings {
    #[serde(rename = "type")]
    pub type_: String,
}
impl ImportSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: InformixLinkedServiceTypeProperties,
}
impl InformixLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: InformixLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<SecretBase>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl InformixLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            authentication_type: None,
            credential: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl InformixSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl InformixSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<InformixTableDatasetTypeProperties>,
}
impl InformixTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InformixTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl InformixTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntime {
    #[serde(rename = "type")]
    pub type_: IntegrationRuntimeType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl IntegrationRuntime {
    pub fn new(type_: IntegrationRuntimeType) -> Self {
        Self { type_, description: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeAuthKeys {
    #[serde(rename = "authKey1", default, skip_serializing_if = "Option::is_none")]
    pub auth_key1: Option<String>,
    #[serde(rename = "authKey2", default, skip_serializing_if = "Option::is_none")]
    pub auth_key2: Option<String>,
}
impl IntegrationRuntimeAuthKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IntegrationRuntimeAutoUpdate {
    On,
    Off,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeComputeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "nodeSize", default, skip_serializing_if = "Option::is_none")]
    pub node_size: Option<String>,
    #[serde(rename = "numberOfNodes", default, skip_serializing_if = "Option::is_none")]
    pub number_of_nodes: Option<i64>,
    #[serde(rename = "maxParallelExecutionsPerNode", default, skip_serializing_if = "Option::is_none")]
    pub max_parallel_executions_per_node: Option<i64>,
    #[serde(rename = "dataFlowProperties", default, skip_serializing_if = "Option::is_none")]
    pub data_flow_properties: Option<IntegrationRuntimeDataFlowProperties>,
    #[serde(rename = "vNetProperties", default, skip_serializing_if = "Option::is_none")]
    pub v_net_properties: Option<IntegrationRuntimeVNetProperties>,
}
impl IntegrationRuntimeComputeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeConnectionInfo {
    #[serde(rename = "serviceToken", default, skip_serializing_if = "Option::is_none")]
    pub service_token: Option<String>,
    #[serde(rename = "identityCertThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub identity_cert_thumbprint: Option<String>,
    #[serde(rename = "hostServiceUri", default, skip_serializing_if = "Option::is_none")]
    pub host_service_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "publicKey", default, skip_serializing_if = "Option::is_none")]
    pub public_key: Option<String>,
    #[serde(rename = "isIdentityCertExprired", default, skip_serializing_if = "Option::is_none")]
    pub is_identity_cert_exprired: Option<bool>,
}
impl IntegrationRuntimeConnectionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeCustomSetupScriptProperties {
    #[serde(rename = "blobContainerUri", default, skip_serializing_if = "Option::is_none")]
    pub blob_container_uri: Option<String>,
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<SecureString>,
}
impl IntegrationRuntimeCustomSetupScriptProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeCustomerVirtualNetwork {
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
}
impl IntegrationRuntimeCustomerVirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeDataFlowProperties {
    #[serde(rename = "computeType", default, skip_serializing_if = "Option::is_none")]
    pub compute_type: Option<integration_runtime_data_flow_properties::ComputeType>,
    #[serde(rename = "coreCount", default, skip_serializing_if = "Option::is_none")]
    pub core_count: Option<i64>,
    #[serde(rename = "timeToLive", default, skip_serializing_if = "Option::is_none")]
    pub time_to_live: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cleanup: Option<bool>,
}
impl IntegrationRuntimeDataFlowProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod integration_runtime_data_flow_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComputeType {
        General,
        MemoryOptimized,
        ComputeOptimized,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeDataProxyProperties {
    #[serde(rename = "connectVia", default, skip_serializing_if = "Option::is_none")]
    pub connect_via: Option<EntityReference>,
    #[serde(rename = "stagingLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub staging_linked_service: Option<EntityReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl IntegrationRuntimeDataProxyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeDebugResource {
    #[serde(flatten)]
    pub sub_resource_debug_resource: SubResourceDebugResource,
    pub properties: IntegrationRuntime,
}
impl IntegrationRuntimeDebugResource {
    pub fn new(properties: IntegrationRuntime) -> Self {
        Self {
            sub_resource_debug_resource: SubResourceDebugResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeListResponse {
    pub value: Vec<IntegrationRuntimeResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationRuntimeListResponse {
    pub fn new(value: Vec<IntegrationRuntimeResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeMonitoringData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub nodes: Vec<IntegrationRuntimeNodeMonitoringData>,
}
impl IntegrationRuntimeMonitoringData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeNodeIpAddress {
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
}
impl IntegrationRuntimeNodeIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeNodeMonitoringData {
    #[serde(rename = "nodeName", default, skip_serializing_if = "Option::is_none")]
    pub node_name: Option<String>,
    #[serde(rename = "availableMemoryInMB", default, skip_serializing_if = "Option::is_none")]
    pub available_memory_in_mb: Option<i64>,
    #[serde(rename = "cpuUtilization", default, skip_serializing_if = "Option::is_none")]
    pub cpu_utilization: Option<i64>,
    #[serde(rename = "concurrentJobsLimit", default, skip_serializing_if = "Option::is_none")]
    pub concurrent_jobs_limit: Option<i64>,
    #[serde(rename = "concurrentJobsRunning", default, skip_serializing_if = "Option::is_none")]
    pub concurrent_jobs_running: Option<i64>,
    #[serde(rename = "maxConcurrentJobs", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_jobs: Option<i64>,
    #[serde(rename = "sentBytes", default, skip_serializing_if = "Option::is_none")]
    pub sent_bytes: Option<f64>,
    #[serde(rename = "receivedBytes", default, skip_serializing_if = "Option::is_none")]
    pub received_bytes: Option<f64>,
}
impl IntegrationRuntimeNodeMonitoringData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<IntegrationRuntimeOutboundNetworkDependenciesEndpoint>,
}
impl IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeOutboundNetworkDependenciesEndpoint {
    #[serde(rename = "domainName", default, skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    #[serde(rename = "endpointDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub endpoint_details: Vec<IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails>,
}
impl IntegrationRuntimeOutboundNetworkDependenciesEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint>,
}
impl IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeReference {
    #[serde(rename = "type")]
    pub type_: integration_runtime_reference::Type,
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl IntegrationRuntimeReference {
    pub fn new(type_: integration_runtime_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            parameters: None,
        }
    }
}
pub mod integration_runtime_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        IntegrationRuntimeReference,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeRegenerateKeyParameters {
    #[serde(rename = "keyName", default, skip_serializing_if = "Option::is_none")]
    pub key_name: Option<integration_runtime_regenerate_key_parameters::KeyName>,
}
impl IntegrationRuntimeRegenerateKeyParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod integration_runtime_regenerate_key_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyName {
        #[serde(rename = "authKey1")]
        AuthKey1,
        #[serde(rename = "authKey2")]
        AuthKey2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: IntegrationRuntime,
}
impl IntegrationRuntimeResource {
    pub fn new(properties: IntegrationRuntime) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeSsisCatalogInfo {
    #[serde(rename = "catalogServerEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub catalog_server_endpoint: Option<String>,
    #[serde(rename = "catalogAdminUserName", default, skip_serializing_if = "Option::is_none")]
    pub catalog_admin_user_name: Option<String>,
    #[serde(rename = "catalogAdminPassword", default, skip_serializing_if = "Option::is_none")]
    pub catalog_admin_password: Option<SecureString>,
    #[serde(rename = "catalogPricingTier", default, skip_serializing_if = "Option::is_none")]
    pub catalog_pricing_tier: Option<integration_runtime_ssis_catalog_info::CatalogPricingTier>,
    #[serde(rename = "dualStandbyPairName", default, skip_serializing_if = "Option::is_none")]
    pub dual_standby_pair_name: Option<String>,
}
impl IntegrationRuntimeSsisCatalogInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod integration_runtime_ssis_catalog_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CatalogPricingTier {
        Basic,
        Standard,
        Premium,
        #[serde(rename = "PremiumRS")]
        PremiumRs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeSsisProperties {
    #[serde(rename = "catalogInfo", default, skip_serializing_if = "Option::is_none")]
    pub catalog_info: Option<IntegrationRuntimeSsisCatalogInfo>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<integration_runtime_ssis_properties::LicenseType>,
    #[serde(rename = "customSetupScriptProperties", default, skip_serializing_if = "Option::is_none")]
    pub custom_setup_script_properties: Option<IntegrationRuntimeCustomSetupScriptProperties>,
    #[serde(rename = "dataProxyProperties", default, skip_serializing_if = "Option::is_none")]
    pub data_proxy_properties: Option<IntegrationRuntimeDataProxyProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub edition: Option<integration_runtime_ssis_properties::Edition>,
    #[serde(rename = "expressCustomSetupProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub express_custom_setup_properties: Vec<CustomSetupBase>,
    #[serde(rename = "packageStores", default, skip_serializing_if = "Vec::is_empty")]
    pub package_stores: Vec<PackageStore>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl IntegrationRuntimeSsisProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod integration_runtime_ssis_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        BasePrice,
        LicenseIncluded,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Edition {
        Standard,
        Enterprise,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IntegrationRuntimeState {
    Initial,
    Stopped,
    Started,
    Starting,
    Stopping,
    NeedRegistration,
    Online,
    Limited,
    Offline,
    AccessDenied,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeStatus {
    #[serde(rename = "type")]
    pub type_: IntegrationRuntimeType,
    #[serde(rename = "dataFactoryName", default, skip_serializing_if = "Option::is_none")]
    pub data_factory_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<IntegrationRuntimeState>,
}
impl IntegrationRuntimeStatus {
    pub fn new(type_: IntegrationRuntimeType) -> Self {
        Self {
            type_,
            data_factory_name: None,
            state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeStatusListResponse {
    pub value: Vec<IntegrationRuntimeStatusResponse>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationRuntimeStatusListResponse {
    pub fn new(value: Vec<IntegrationRuntimeStatusResponse>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeStatusResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    pub properties: IntegrationRuntimeStatus,
}
impl IntegrationRuntimeStatusResponse {
    pub fn new(properties: IntegrationRuntimeStatus) -> Self {
        Self { name: None, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IntegrationRuntimeType {
    Managed,
    SelfHosted,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IntegrationRuntimeVNetProperties {
    #[serde(rename = "vNetId", default, skip_serializing_if = "Option::is_none")]
    pub v_net_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<String>,
    #[serde(rename = "publicIPs", default, skip_serializing_if = "Vec::is_empty")]
    pub public_i_ps: Vec<String>,
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
}
impl IntegrationRuntimeVNetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JiraLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: JiraLinkedServiceTypeProperties,
}
impl JiraLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: JiraLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JiraLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    pub username: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl JiraLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, username: serde_json::Value) -> Self {
        Self {
            host,
            port: None,
            username,
            password: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JiraObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl JiraObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JiraSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl JiraSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<JsonDatasetTypeProperties>,
}
impl JsonDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonDatasetTypeProperties {
    pub location: DatasetLocation,
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl JsonDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            encoding_name: None,
            compression: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
    #[serde(rename = "filePattern", default, skip_serializing_if = "Option::is_none")]
    pub file_pattern: Option<serde_json::Value>,
    #[serde(rename = "nestingSeparator", default, skip_serializing_if = "Option::is_none")]
    pub nesting_separator: Option<serde_json::Value>,
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[serde(rename = "jsonNodeReference", default, skip_serializing_if = "Option::is_none")]
    pub json_node_reference: Option<serde_json::Value>,
    #[serde(rename = "jsonPathDefinition", default, skip_serializing_if = "Option::is_none")]
    pub json_path_definition: Option<serde_json::Value>,
}
impl JsonFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self {
            dataset_storage_format,
            file_pattern: None,
            nesting_separator: None,
            encoding_name: None,
            json_node_reference: None,
            json_path_definition: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JsonFormatFilePattern {
    #[serde(rename = "setOfObjects")]
    SetOfObjects,
    #[serde(rename = "arrayOfObjects")]
    ArrayOfObjects,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonReadSettings {
    #[serde(flatten)]
    pub format_read_settings: FormatReadSettings,
    #[serde(rename = "compressionProperties", default, skip_serializing_if = "Option::is_none")]
    pub compression_properties: Option<CompressionReadSettings>,
}
impl JsonReadSettings {
    pub fn new(format_read_settings: FormatReadSettings) -> Self {
        Self {
            format_read_settings,
            compression_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<JsonWriteSettings>,
}
impl JsonSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<JsonReadSettings>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl JsonSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            format_settings: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JsonWriteFilePattern {
    #[serde(rename = "setOfObjects")]
    SetOfObjects,
    #[serde(rename = "arrayOfObjects")]
    ArrayOfObjects,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[serde(rename = "filePattern", default, skip_serializing_if = "Option::is_none")]
    pub file_pattern: Option<serde_json::Value>,
}
impl JsonWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings) -> Self {
        Self {
            format_write_settings,
            file_pattern: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LicensedComponentSetupTypeProperties {
    #[serde(rename = "componentName")]
    pub component_name: String,
    #[serde(rename = "licenseKey", default, skip_serializing_if = "Option::is_none")]
    pub license_key: Option<SecretBase>,
}
impl LicensedComponentSetupTypeProperties {
    pub fn new(component_name: String) -> Self {
        Self {
            component_name,
            license_key: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkedIntegrationRuntime {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "dataFactoryName", default, skip_serializing_if = "Option::is_none")]
    pub data_factory_name: Option<String>,
    #[serde(rename = "dataFactoryLocation", default, skip_serializing_if = "Option::is_none")]
    pub data_factory_location: Option<String>,
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
}
impl LinkedIntegrationRuntime {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedIntegrationRuntimeKeyAuthorization {
    #[serde(flatten)]
    pub linked_integration_runtime_type: LinkedIntegrationRuntimeType,
    pub key: SecureString,
}
impl LinkedIntegrationRuntimeKeyAuthorization {
    pub fn new(linked_integration_runtime_type: LinkedIntegrationRuntimeType, key: SecureString) -> Self {
        Self {
            linked_integration_runtime_type,
            key,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedIntegrationRuntimeRbacAuthorization {
    #[serde(flatten)]
    pub linked_integration_runtime_type: LinkedIntegrationRuntimeType,
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl LinkedIntegrationRuntimeRbacAuthorization {
    pub fn new(linked_integration_runtime_type: LinkedIntegrationRuntimeType, resource_id: String) -> Self {
        Self {
            linked_integration_runtime_type,
            resource_id,
            credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedIntegrationRuntimeRequest {
    #[serde(rename = "factoryName")]
    pub factory_name: String,
}
impl LinkedIntegrationRuntimeRequest {
    pub fn new(factory_name: String) -> Self {
        Self { factory_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedIntegrationRuntimeType {
    #[serde(rename = "authorizationType")]
    pub authorization_type: String,
}
impl LinkedIntegrationRuntimeType {
    pub fn new(authorization_type: String) -> Self {
        Self { authorization_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedService {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(rename = "connectVia", default, skip_serializing_if = "Option::is_none")]
    pub connect_via: Option<IntegrationRuntimeReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterDefinitionSpecification>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
}
impl LinkedService {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            connect_via: None,
            description: None,
            parameters: None,
            annotations: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedServiceDebugResource {
    #[serde(flatten)]
    pub sub_resource_debug_resource: SubResourceDebugResource,
    pub properties: LinkedService,
}
impl LinkedServiceDebugResource {
    pub fn new(properties: LinkedService) -> Self {
        Self {
            sub_resource_debug_resource: SubResourceDebugResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedServiceListResponse {
    pub value: Vec<LinkedServiceResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LinkedServiceListResponse {
    pub fn new(value: Vec<LinkedServiceResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedServiceReference {
    #[serde(rename = "type")]
    pub type_: linked_service_reference::Type,
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl LinkedServiceReference {
    pub fn new(type_: linked_service_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            parameters: None,
        }
    }
}
pub mod linked_service_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        LinkedServiceReference,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedServiceResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: LinkedService,
}
impl LinkedServiceResource {
    pub fn new(properties: LinkedService) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogLocationSettings {
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
}
impl LogLocationSettings {
    pub fn new(linked_service_name: LinkedServiceReference) -> Self {
        Self {
            linked_service_name,
            path: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogSettings {
    #[serde(rename = "enableCopyActivityLog", default, skip_serializing_if = "Option::is_none")]
    pub enable_copy_activity_log: Option<serde_json::Value>,
    #[serde(rename = "copyActivityLogSettings", default, skip_serializing_if = "Option::is_none")]
    pub copy_activity_log_settings: Option<CopyActivityLogSettings>,
    #[serde(rename = "logLocationSettings")]
    pub log_location_settings: LogLocationSettings,
}
impl LogSettings {
    pub fn new(log_location_settings: LogLocationSettings) -> Self {
        Self {
            enable_copy_activity_log: None,
            copy_activity_log_settings: None,
            log_location_settings,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogStorageSettings {
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
    #[serde(rename = "logLevel", default, skip_serializing_if = "Option::is_none")]
    pub log_level: Option<serde_json::Value>,
    #[serde(rename = "enableReliableLogging", default, skip_serializing_if = "Option::is_none")]
    pub enable_reliable_logging: Option<serde_json::Value>,
}
impl LogStorageSettings {
    pub fn new(linked_service_name: LinkedServiceReference) -> Self {
        Self {
            linked_service_name,
            path: None,
            log_level: None,
            enable_reliable_logging: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LookupActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: LookupActivityTypeProperties,
}
impl LookupActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: LookupActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LookupActivityTypeProperties {
    pub source: CopySource,
    pub dataset: DatasetReference,
    #[serde(rename = "firstRowOnly", default, skip_serializing_if = "Option::is_none")]
    pub first_row_only: Option<serde_json::Value>,
}
impl LookupActivityTypeProperties {
    pub fn new(source: CopySource, dataset: DatasetReference) -> Self {
        Self {
            source,
            dataset,
            first_row_only: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MagentoLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: MagentoLinkedServiceTypeProperties,
}
impl MagentoLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MagentoLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MagentoLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MagentoLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            access_token: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MagentoObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl MagentoObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MagentoSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl MagentoSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedIntegrationRuntime {
    #[serde(flatten)]
    pub integration_runtime: IntegrationRuntime,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<IntegrationRuntimeState>,
    #[serde(rename = "typeProperties")]
    pub type_properties: ManagedIntegrationRuntimeTypeProperties,
    #[serde(rename = "managedVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub managed_virtual_network: Option<ManagedVirtualNetworkReference>,
}
impl ManagedIntegrationRuntime {
    pub fn new(integration_runtime: IntegrationRuntime, type_properties: ManagedIntegrationRuntimeTypeProperties) -> Self {
        Self {
            integration_runtime,
            state: None,
            type_properties,
            managed_virtual_network: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedIntegrationRuntimeError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ManagedIntegrationRuntimeError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedIntegrationRuntimeNode {
    #[serde(rename = "nodeId", default, skip_serializing_if = "Option::is_none")]
    pub node_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<managed_integration_runtime_node::Status>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ManagedIntegrationRuntimeError>,
}
impl ManagedIntegrationRuntimeNode {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_integration_runtime_node {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Starting,
        Available,
        Recycling,
        Unavailable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedIntegrationRuntimeOperationResult {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub result: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<String>,
    #[serde(rename = "activityId", default, skip_serializing_if = "Option::is_none")]
    pub activity_id: Option<String>,
}
impl ManagedIntegrationRuntimeOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedIntegrationRuntimeStatus {
    #[serde(flatten)]
    pub integration_runtime_status: IntegrationRuntimeStatus,
    #[serde(rename = "typeProperties")]
    pub type_properties: ManagedIntegrationRuntimeStatusTypeProperties,
}
impl ManagedIntegrationRuntimeStatus {
    pub fn new(
        integration_runtime_status: IntegrationRuntimeStatus,
        type_properties: ManagedIntegrationRuntimeStatusTypeProperties,
    ) -> Self {
        Self {
            integration_runtime_status,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedIntegrationRuntimeStatusTypeProperties {
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub nodes: Vec<ManagedIntegrationRuntimeNode>,
    #[serde(rename = "otherErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub other_errors: Vec<ManagedIntegrationRuntimeError>,
    #[serde(rename = "lastOperation", default, skip_serializing_if = "Option::is_none")]
    pub last_operation: Option<ManagedIntegrationRuntimeOperationResult>,
}
impl ManagedIntegrationRuntimeStatusTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedIntegrationRuntimeTypeProperties {
    #[serde(rename = "computeProperties", default, skip_serializing_if = "Option::is_none")]
    pub compute_properties: Option<IntegrationRuntimeComputeProperties>,
    #[serde(rename = "ssisProperties", default, skip_serializing_if = "Option::is_none")]
    pub ssis_properties: Option<IntegrationRuntimeSsisProperties>,
    #[serde(rename = "customerVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub customer_virtual_network: Option<IntegrationRuntimeCustomerVirtualNetwork>,
}
impl ManagedIntegrationRuntimeTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedPrivateEndpoint {
    #[serde(rename = "connectionState", default, skip_serializing_if = "Option::is_none")]
    pub connection_state: Option<ConnectionStateProperties>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub fqdns: Vec<String>,
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "isReserved", default, skip_serializing_if = "Option::is_none")]
    pub is_reserved: Option<bool>,
    #[serde(rename = "privateLinkResourceId", default, skip_serializing_if = "Option::is_none")]
    pub private_link_resource_id: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ManagedPrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedPrivateEndpointResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: ManagedPrivateEndpoint,
}
impl ManagedPrivateEndpointResource {
    pub fn new(properties: ManagedPrivateEndpoint) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedVirtualNetwork {
    #[serde(rename = "vNetId", default, skip_serializing_if = "Option::is_none")]
    pub v_net_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub alias: Option<String>,
}
impl ManagedVirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedVirtualNetworkListResponse {
    pub value: Vec<ManagedVirtualNetworkResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagedVirtualNetworkListResponse {
    pub fn new(value: Vec<ManagedVirtualNetworkResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedVirtualNetworkReference {
    #[serde(rename = "type")]
    pub type_: managed_virtual_network_reference::Type,
    #[serde(rename = "referenceName")]
    pub reference_name: String,
}
impl ManagedVirtualNetworkReference {
    pub fn new(type_: managed_virtual_network_reference::Type, reference_name: String) -> Self {
        Self { type_, reference_name }
    }
}
pub mod managed_virtual_network_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        ManagedVirtualNetworkReference,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedVirtualNetworkResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: ManagedVirtualNetwork,
}
impl ManagedVirtualNetworkResource {
    pub fn new(properties: ManagedVirtualNetwork) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MappingDataFlow {
    #[serde(flatten)]
    pub data_flow: DataFlow,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<MappingDataFlowTypeProperties>,
}
impl MappingDataFlow {
    pub fn new(data_flow: DataFlow) -> Self {
        Self {
            data_flow,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MappingDataFlowTypeProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<DataFlowSource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sinks: Vec<DataFlowSink>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transformations: Vec<Transformation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<String>,
    #[serde(rename = "scriptLines", default, skip_serializing_if = "Vec::is_empty")]
    pub script_lines: Vec<String>,
}
impl MappingDataFlowTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MariaDbLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: MariaDbLinkedServiceTypeProperties,
}
impl MariaDbLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MariaDbLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MariaDbLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MariaDbLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MariaDbSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl MariaDbSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MariaDbTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl MariaDbTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MarketoLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: MarketoLinkedServiceTypeProperties,
}
impl MarketoLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MarketoLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MarketoLinkedServiceTypeProperties {
    pub endpoint: serde_json::Value,
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MarketoLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value, client_id: serde_json::Value) -> Self {
        Self {
            endpoint,
            client_id,
            client_secret: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MarketoObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl MarketoObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MarketoSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl MarketoSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataItem {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
}
impl MetadataItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: MicrosoftAccessLinkedServiceTypeProperties,
}
impl MicrosoftAccessLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MicrosoftAccessLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<SecretBase>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MicrosoftAccessLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            authentication_type: None,
            credential: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl MicrosoftAccessSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl MicrosoftAccessSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<MicrosoftAccessTableDatasetTypeProperties>,
}
impl MicrosoftAccessTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MicrosoftAccessTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl MicrosoftAccessTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbAtlasCollectionDatasetTypeProperties,
}
impl MongoDbAtlasCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: MongoDbAtlasCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasCollectionDatasetTypeProperties {
    pub collection: serde_json::Value,
}
impl MongoDbAtlasCollectionDatasetTypeProperties {
    pub fn new(collection: serde_json::Value) -> Self {
        Self { collection }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbAtlasLinkedServiceTypeProperties,
}
impl MongoDbAtlasLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MongoDbAtlasLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    pub database: serde_json::Value,
}
impl MongoDbAtlasLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            connection_string,
            database,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
}
impl MongoDbAtlasSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<serde_json::Value>,
    #[serde(rename = "cursorMethods", default, skip_serializing_if = "Option::is_none")]
    pub cursor_methods: Option<MongoDbCursorMethodsProperties>,
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<serde_json::Value>,
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl MongoDbAtlasSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            filter: None,
            cursor_methods: None,
            batch_size: None,
            query_timeout: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbCollectionDatasetTypeProperties,
}
impl MongoDbCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: MongoDbCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionDatasetTypeProperties {
    #[serde(rename = "collectionName")]
    pub collection_name: serde_json::Value,
}
impl MongoDbCollectionDatasetTypeProperties {
    pub fn new(collection_name: serde_json::Value) -> Self {
        Self { collection_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbCursorMethodsProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub project: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sort: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub skip: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<serde_json::Value>,
}
impl MongoDbCursorMethodsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbLinkedServiceTypeProperties,
}
impl MongoDbLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MongoDbLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbLinkedServiceTypeProperties {
    pub server: serde_json::Value,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<mongo_db_linked_service_type_properties::AuthenticationType>,
    #[serde(rename = "databaseName")]
    pub database_name: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "authSource", default, skip_serializing_if = "Option::is_none")]
    pub auth_source: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MongoDbLinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, database_name: serde_json::Value) -> Self {
        Self {
            server,
            authentication_type: None,
            database_name,
            username: None,
            password: None,
            auth_source: None,
            port: None,
            enable_ssl: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod mongo_db_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl MongoDbSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2CollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbV2CollectionDatasetTypeProperties,
}
impl MongoDbV2CollectionDataset {
    pub fn new(dataset: Dataset, type_properties: MongoDbV2CollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2CollectionDatasetTypeProperties {
    pub collection: serde_json::Value,
}
impl MongoDbV2CollectionDatasetTypeProperties {
    pub fn new(collection: serde_json::Value) -> Self {
        Self { collection }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2LinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbV2LinkedServiceTypeProperties,
}
impl MongoDbV2LinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MongoDbV2LinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2LinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    pub database: serde_json::Value,
}
impl MongoDbV2LinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            connection_string,
            database,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2Sink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
}
impl MongoDbV2Sink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2Source {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<serde_json::Value>,
    #[serde(rename = "cursorMethods", default, skip_serializing_if = "Option::is_none")]
    pub cursor_methods: Option<MongoDbCursorMethodsProperties>,
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<serde_json::Value>,
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl MongoDbV2Source {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            filter: None,
            cursor_methods: None,
            batch_size: None,
            query_timeout: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MultiplePipelineTrigger {
    #[serde(flatten)]
    pub trigger: Trigger,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub pipelines: Vec<TriggerPipelineReference>,
}
impl MultiplePipelineTrigger {
    pub fn new(trigger: Trigger) -> Self {
        Self {
            trigger,
            pipelines: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MySqlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: MySqlLinkedServiceTypeProperties,
}
impl MySqlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MySqlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MySqlLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MySqlLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MySqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl MySqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MySqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<MySqlTableDatasetTypeProperties>,
}
impl MySqlTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MySqlTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl MySqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetezzaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: NetezzaLinkedServiceTypeProperties,
}
impl NetezzaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: NetezzaLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetezzaLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl NetezzaLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum NetezzaPartitionOption {
    None,
    DataSlice,
    DynamicRange,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetezzaPartitionSettings {
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
}
impl NetezzaPartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetezzaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<NetezzaPartitionSettings>,
}
impl NetezzaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetezzaTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<NetezzaTableDatasetTypeProperties>,
}
impl NetezzaTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetezzaTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl NetezzaTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ODataLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: ODataLinkedServiceTypeProperties,
}
impl ODataLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ODataLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ODataLinkedServiceTypeProperties {
    pub url: serde_json::Value,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<o_data_linked_service_type_properties::AuthenticationType>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "authHeaders", default, skip_serializing_if = "Option::is_none")]
    pub auth_headers: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[serde(rename = "aadResourceId", default, skip_serializing_if = "Option::is_none")]
    pub aad_resource_id: Option<serde_json::Value>,
    #[serde(rename = "aadServicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub aad_service_principal_credential_type: Option<o_data_linked_service_type_properties::AadServicePrincipalCredentialType>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(rename = "servicePrincipalEmbeddedCert", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_embedded_cert: Option<SecretBase>,
    #[serde(rename = "servicePrincipalEmbeddedCertPassword", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_embedded_cert_password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ODataLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            authentication_type: None,
            user_name: None,
            password: None,
            auth_headers: None,
            tenant: None,
            service_principal_id: None,
            azure_cloud_type: None,
            aad_resource_id: None,
            aad_service_principal_credential_type: None,
            service_principal_key: None,
            service_principal_embedded_cert: None,
            service_principal_embedded_cert_password: None,
            encrypted_credential: None,
        }
    }
}
pub mod o_data_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
        Windows,
        AadServicePrincipal,
        ManagedServiceIdentity,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AadServicePrincipalCredentialType {
        ServicePrincipalKey,
        ServicePrincipalCert,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ODataResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<ODataResourceDatasetTypeProperties>,
}
impl ODataResourceDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ODataResourceDatasetTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
}
impl ODataResourceDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ODataSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl ODataSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            http_request_timeout: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: OdbcLinkedServiceTypeProperties,
}
impl OdbcLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: OdbcLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<SecretBase>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl OdbcLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            authentication_type: None,
            credential: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl OdbcSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl OdbcSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<OdbcTableDatasetTypeProperties>,
}
impl OdbcTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OdbcTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl OdbcTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365Dataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: Office365DatasetTypeProperties,
}
impl Office365Dataset {
    pub fn new(dataset: Dataset, type_properties: Office365DatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365DatasetTypeProperties {
    #[serde(rename = "tableName")]
    pub table_name: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub predicate: Option<serde_json::Value>,
}
impl Office365DatasetTypeProperties {
    pub fn new(table_name: serde_json::Value) -> Self {
        Self {
            table_name,
            predicate: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365LinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: Office365LinkedServiceTypeProperties,
}
impl Office365LinkedService {
    pub fn new(linked_service: LinkedService, type_properties: Office365LinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365LinkedServiceTypeProperties {
    #[serde(rename = "office365TenantId")]
    pub office365_tenant_id: serde_json::Value,
    #[serde(rename = "servicePrincipalTenantId")]
    pub service_principal_tenant_id: serde_json::Value,
    #[serde(rename = "servicePrincipalId")]
    pub service_principal_id: serde_json::Value,
    #[serde(rename = "servicePrincipalKey")]
    pub service_principal_key: SecretBase,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl Office365LinkedServiceTypeProperties {
    pub fn new(
        office365_tenant_id: serde_json::Value,
        service_principal_tenant_id: serde_json::Value,
        service_principal_id: serde_json::Value,
        service_principal_key: SecretBase,
    ) -> Self {
        Self {
            office365_tenant_id,
            service_principal_tenant_id,
            service_principal_id,
            service_principal_key,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365Source {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "allowedGroups", default, skip_serializing_if = "Option::is_none")]
    pub allowed_groups: Option<serde_json::Value>,
    #[serde(rename = "userScopeFilterUri", default, skip_serializing_if = "Option::is_none")]
    pub user_scope_filter_uri: Option<serde_json::Value>,
    #[serde(rename = "dateFilterColumn", default, skip_serializing_if = "Option::is_none")]
    pub date_filter_column: Option<serde_json::Value>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<serde_json::Value>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<serde_json::Value>,
    #[serde(rename = "outputColumns", default, skip_serializing_if = "Option::is_none")]
    pub output_columns: Option<serde_json::Value>,
}
impl Office365Source {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            allowed_groups: None,
            user_scope_filter_uri: None,
            date_filter_column: None,
            start_time: None,
            end_time: None,
            output_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationProperties>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationLogSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl OperationLogSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetricAvailability {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl OperationMetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetricDimension {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "toBeExportedForShoebox", default, skip_serializing_if = "Option::is_none")]
    pub to_be_exported_for_shoebox: Option<bool>,
}
impl OperationMetricDimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetricSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[serde(rename = "enableRegionalMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub enable_regional_mdm_account: Option<String>,
    #[serde(rename = "sourceMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_account: Option<String>,
    #[serde(rename = "sourceMdmNamespace", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_namespace: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub availabilities: Vec<OperationMetricAvailability>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<OperationMetricDimension>,
}
impl OperationMetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationProperties {
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<OperationServiceSpecification>,
}
impl OperationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationServiceSpecification {
    #[serde(rename = "logSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub log_specifications: Vec<OperationLogSpecification>,
    #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_specifications: Vec<OperationMetricSpecification>,
}
impl OperationServiceSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleCloudStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: OracleCloudStorageLinkedServiceTypeProperties,
}
impl OracleCloudStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: OracleCloudStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OracleCloudStorageLinkedServiceTypeProperties {
    #[serde(rename = "accessKeyId", default, skip_serializing_if = "Option::is_none")]
    pub access_key_id: Option<serde_json::Value>,
    #[serde(rename = "secretAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub secret_access_key: Option<SecretBase>,
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl OracleCloudStorageLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleCloudStorageLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[serde(rename = "bucketName", default, skip_serializing_if = "Option::is_none")]
    pub bucket_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<serde_json::Value>,
}
impl OracleCloudStorageLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            bucket_name: None,
            version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleCloudStorageReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl OracleCloudStorageReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: OracleLinkedServiceTypeProperties,
}
impl OracleLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: OracleLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl OracleLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OraclePartitionOption {
    None,
    PhysicalPartitionsOfTable,
    DynamicRange,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OraclePartitionSettings {
    #[serde(rename = "partitionNames", default, skip_serializing_if = "Option::is_none")]
    pub partition_names: Option<serde_json::Value>,
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
}
impl OraclePartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleServiceCloudLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: OracleServiceCloudLinkedServiceTypeProperties,
}
impl OracleServiceCloudLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: OracleServiceCloudLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleServiceCloudLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    pub username: serde_json::Value,
    pub password: SecretBase,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl OracleServiceCloudLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, username: serde_json::Value, password: SecretBase) -> Self {
        Self {
            host,
            username,
            password,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleServiceCloudObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl OracleServiceCloudObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleServiceCloudSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl OracleServiceCloudSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl OracleSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "oracleReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub oracle_reader_query: Option<serde_json::Value>,
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<OraclePartitionSettings>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl OracleSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            oracle_reader_query: None,
            query_timeout: None,
            partition_option: None,
            partition_settings: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<OracleTableDatasetTypeProperties>,
}
impl OracleTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OracleTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl OracleTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OrcCompressionCodec {
    #[serde(rename = "none")]
    None,
    #[serde(rename = "zlib")]
    Zlib,
    #[serde(rename = "snappy")]
    Snappy,
    #[serde(rename = "lzo")]
    Lzo,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<OrcDatasetTypeProperties>,
}
impl OrcDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcDatasetTypeProperties {
    pub location: DatasetLocation,
    #[serde(rename = "orcCompressionCodec", default, skip_serializing_if = "Option::is_none")]
    pub orc_compression_codec: Option<serde_json::Value>,
}
impl OrcDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            orc_compression_codec: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
}
impl OrcFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self { dataset_storage_format }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<OrcWriteSettings>,
}
impl OrcSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl OrcSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[serde(rename = "maxRowsPerFile", default, skip_serializing_if = "Option::is_none")]
    pub max_rows_per_file: Option<serde_json::Value>,
    #[serde(rename = "fileNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub file_name_prefix: Option<serde_json::Value>,
}
impl OrcWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings) -> Self {
        Self {
            format_write_settings,
            max_rows_per_file: None,
            file_name_prefix: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PackageStore {
    pub name: String,
    #[serde(rename = "packageStoreLinkedService")]
    pub package_store_linked_service: EntityReference,
}
impl PackageStore {
    pub fn new(name: String, package_store_linked_service: EntityReference) -> Self {
        Self {
            name,
            package_store_linked_service,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ParameterDefinitionSpecification {}
impl ParameterDefinitionSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParameterSpecification {
    #[serde(rename = "type")]
    pub type_: parameter_specification::Type,
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<serde_json::Value>,
}
impl ParameterSpecification {
    pub fn new(type_: parameter_specification::Type) -> Self {
        Self {
            type_,
            default_value: None,
        }
    }
}
pub mod parameter_specification {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Object,
        String,
        Int,
        Float,
        Bool,
        Array,
        SecureString,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ParameterValueSpecification {}
impl ParameterValueSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<ParquetDatasetTypeProperties>,
}
impl ParquetDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetDatasetTypeProperties {
    pub location: DatasetLocation,
    #[serde(rename = "compressionCodec", default, skip_serializing_if = "Option::is_none")]
    pub compression_codec: Option<serde_json::Value>,
}
impl ParquetDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            compression_codec: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
}
impl ParquetFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self { dataset_storage_format }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<ParquetWriteSettings>,
}
impl ParquetSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl ParquetSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[serde(rename = "maxRowsPerFile", default, skip_serializing_if = "Option::is_none")]
    pub max_rows_per_file: Option<serde_json::Value>,
    #[serde(rename = "fileNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub file_name_prefix: Option<serde_json::Value>,
}
impl ParquetWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings) -> Self {
        Self {
            format_write_settings,
            max_rows_per_file: None,
            file_name_prefix: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PaypalLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: PaypalLinkedServiceTypeProperties,
}
impl PaypalLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: PaypalLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PaypalLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl PaypalLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, client_id: serde_json::Value) -> Self {
        Self {
            host,
            client_id,
            client_secret: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PaypalObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl PaypalObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PaypalSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl PaypalSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PhoenixDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl PhoenixDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PhoenixLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: PhoenixLinkedServiceTypeProperties,
}
impl PhoenixLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: PhoenixLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PhoenixLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "httpPath", default, skip_serializing_if = "Option::is_none")]
    pub http_path: Option<serde_json::Value>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: phoenix_linked_service_type_properties::AuthenticationType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl PhoenixLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, authentication_type: phoenix_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            host,
            port: None,
            http_path: None,
            authentication_type,
            username: None,
            password: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod phoenix_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        UsernameAndPassword,
        #[serde(rename = "WindowsAzureHDInsightService")]
        WindowsAzureHdInsightService,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PhoenixObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<PhoenixDatasetTypeProperties>,
}
impl PhoenixObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PhoenixSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl PhoenixSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Pipeline {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub activities: Vec<Activity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterDefinitionSpecification>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub variables: Option<VariableDefinitionSpecification>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub concurrency: Option<i64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
    #[serde(rename = "runDimensions", default, skip_serializing_if = "Option::is_none")]
    pub run_dimensions: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub folder: Option<pipeline::Folder>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub policy: Option<PipelinePolicy>,
}
impl Pipeline {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pipeline {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Folder {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Folder {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PipelineElapsedTimeMetricPolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<serde_json::Value>,
}
impl PipelineElapsedTimeMetricPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PipelineListResponse {
    pub value: Vec<PipelineResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PipelineListResponse {
    pub fn new(value: Vec<PipelineResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PipelinePolicy {
    #[serde(rename = "elapsedTimeMetric", default, skip_serializing_if = "Option::is_none")]
    pub elapsed_time_metric: Option<PipelineElapsedTimeMetricPolicy>,
}
impl PipelinePolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PipelineReference {
    #[serde(rename = "type")]
    pub type_: pipeline_reference::Type,
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl PipelineReference {
    pub fn new(type_: pipeline_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            name: None,
        }
    }
}
pub mod pipeline_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        PipelineReference,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PipelineResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: Pipeline,
}
impl PipelineResource {
    pub fn new(properties: Pipeline) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PipelineRun {
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[serde(rename = "runGroupId", default, skip_serializing_if = "Option::is_none")]
    pub run_group_id: Option<String>,
    #[serde(rename = "isLatest", default, skip_serializing_if = "Option::is_none")]
    pub is_latest: Option<bool>,
    #[serde(rename = "pipelineName", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[serde(rename = "runDimensions", default, skip_serializing_if = "Option::is_none")]
    pub run_dimensions: Option<serde_json::Value>,
    #[serde(rename = "invokedBy", default, skip_serializing_if = "Option::is_none")]
    pub invoked_by: Option<PipelineRunInvokedBy>,
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[serde(rename = "runStart", default, skip_serializing_if = "Option::is_none")]
    pub run_start: Option<String>,
    #[serde(rename = "runEnd", default, skip_serializing_if = "Option::is_none")]
    pub run_end: Option<String>,
    #[serde(rename = "durationInMs", default, skip_serializing_if = "Option::is_none")]
    pub duration_in_ms: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl PipelineRun {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PipelineRunInvokedBy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "invokedByType", default, skip_serializing_if = "Option::is_none")]
    pub invoked_by_type: Option<String>,
    #[serde(rename = "pipelineName", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_name: Option<String>,
    #[serde(rename = "pipelineRunId", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_run_id: Option<String>,
}
impl PipelineRunInvokedBy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PipelineRunsQueryResponse {
    pub value: Vec<PipelineRun>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl PipelineRunsQueryResponse {
    pub fn new(value: Vec<PipelineRun>) -> Self {
        Self {
            value,
            continuation_token: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolybaseSettings {
    #[serde(rename = "rejectType", default, skip_serializing_if = "Option::is_none")]
    pub reject_type: Option<PolybaseSettingsRejectType>,
    #[serde(rename = "rejectValue", default, skip_serializing_if = "Option::is_none")]
    pub reject_value: Option<serde_json::Value>,
    #[serde(rename = "rejectSampleValue", default, skip_serializing_if = "Option::is_none")]
    pub reject_sample_value: Option<serde_json::Value>,
    #[serde(rename = "useTypeDefault", default, skip_serializing_if = "Option::is_none")]
    pub use_type_default: Option<serde_json::Value>,
}
impl PolybaseSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PolybaseSettingsRejectType {
    #[serde(rename = "value")]
    Value,
    #[serde(rename = "percentage")]
    Percentage,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PostgreSqlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: PostgreSqlLinkedServiceTypeProperties,
}
impl PostgreSqlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: PostgreSqlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PostgreSqlLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl PostgreSqlLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PostgreSqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl PostgreSqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PostgreSqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<PostgreSqlTableDatasetTypeProperties>,
}
impl PostgreSqlTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PostgreSqlTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl PostgreSqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PowerQuerySink {
    #[serde(flatten)]
    pub data_flow_sink: DataFlowSink,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<String>,
}
impl PowerQuerySink {
    pub fn new(data_flow_sink: DataFlowSink) -> Self {
        Self {
            data_flow_sink,
            script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PowerQuerySinkMapping {
    #[serde(rename = "queryName", default, skip_serializing_if = "Option::is_none")]
    pub query_name: Option<String>,
    #[serde(rename = "dataflowSinks", default, skip_serializing_if = "Vec::is_empty")]
    pub dataflow_sinks: Vec<PowerQuerySink>,
}
impl PowerQuerySinkMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PowerQuerySource {
    #[serde(flatten)]
    pub data_flow_source: DataFlowSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<String>,
}
impl PowerQuerySource {
    pub fn new(data_flow_source: DataFlowSource) -> Self {
        Self {
            data_flow_source,
            script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PowerQueryTypeProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<PowerQuerySource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<String>,
    #[serde(rename = "documentLocale", default, skip_serializing_if = "Option::is_none")]
    pub document_locale: Option<String>,
}
impl PowerQueryTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrestoDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl PrestoDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrestoLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: PrestoLinkedServiceTypeProperties,
}
impl PrestoLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: PrestoLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrestoLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(rename = "serverVersion")]
    pub server_version: serde_json::Value,
    pub catalog: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: presto_linked_service_type_properties::AuthenticationType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[serde(rename = "timeZoneID", default, skip_serializing_if = "Option::is_none")]
    pub time_zone_id: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl PrestoLinkedServiceTypeProperties {
    pub fn new(
        host: serde_json::Value,
        server_version: serde_json::Value,
        catalog: serde_json::Value,
        authentication_type: presto_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            host,
            server_version,
            catalog,
            port: None,
            authentication_type,
            username: None,
            password: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            time_zone_id: None,
            encrypted_credential: None,
        }
    }
}
pub mod presto_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        #[serde(rename = "LDAP")]
        Ldap,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrestoObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<PrestoDatasetTypeProperties>,
}
impl PrestoObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrestoSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl PrestoSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateEndpointConnectionListResponse {
    pub value: Vec<PrivateEndpointConnectionResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateEndpointConnectionListResponse {
    pub fn new(value: Vec<PrivateEndpointConnectionResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RemotePrivateEndpointConnection>,
}
impl PrivateEndpointConnectionResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkConnectionApprovalRequest {
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkConnectionState>,
}
impl PrivateLinkConnectionApprovalRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkConnectionApprovalRequestResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkConnectionApprovalRequest>,
}
impl PrivateLinkConnectionApprovalRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkConnectionState {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkResourceProperties>,
}
impl PrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceProperties {
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl PrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateLinkResourcesWrapper {
    pub value: Vec<PrivateLinkResource>,
}
impl PrivateLinkResourcesWrapper {
    pub fn new(value: Vec<PrivateLinkResource>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryDataFlowDebugSessionsResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DataFlowDebugSessionInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl QueryDataFlowDebugSessionsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuickBooksLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: QuickBooksLinkedServiceTypeProperties,
}
impl QuickBooksLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: QuickBooksLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuickBooksLinkedServiceTypeProperties {
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<serde_json::Value>,
    #[serde(rename = "companyId", default, skip_serializing_if = "Option::is_none")]
    pub company_id: Option<serde_json::Value>,
    #[serde(rename = "consumerKey", default, skip_serializing_if = "Option::is_none")]
    pub consumer_key: Option<serde_json::Value>,
    #[serde(rename = "consumerSecret", default, skip_serializing_if = "Option::is_none")]
    pub consumer_secret: Option<SecretBase>,
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[serde(rename = "accessTokenSecret", default, skip_serializing_if = "Option::is_none")]
    pub access_token_secret: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl QuickBooksLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuickBooksObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl QuickBooksObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuickBooksSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl QuickBooksSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecurrenceFrequency {
    NotSpecified,
    Minute,
    Hour,
    Day,
    Week,
    Month,
    Year,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecurrenceSchedule {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub minutes: Vec<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hours: Vec<i32>,
    #[serde(rename = "weekDays", default, skip_serializing_if = "Vec::is_empty")]
    pub week_days: Vec<String>,
    #[serde(rename = "monthDays", default, skip_serializing_if = "Vec::is_empty")]
    pub month_days: Vec<i32>,
    #[serde(rename = "monthlyOccurrences", default, skip_serializing_if = "Vec::is_empty")]
    pub monthly_occurrences: Vec<RecurrenceScheduleOccurrence>,
}
impl RecurrenceSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecurrenceScheduleOccurrence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub day: Option<DayOfWeek>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub occurrence: Option<i32>,
}
impl RecurrenceScheduleOccurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedirectIncompatibleRowSettings {
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
}
impl RedirectIncompatibleRowSettings {
    pub fn new(linked_service_name: serde_json::Value) -> Self {
        Self {
            linked_service_name,
            path: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedshiftUnloadSettings {
    #[serde(rename = "s3LinkedServiceName")]
    pub s3_linked_service_name: LinkedServiceReference,
    #[serde(rename = "bucketName")]
    pub bucket_name: serde_json::Value,
}
impl RedshiftUnloadSettings {
    pub fn new(s3_linked_service_name: LinkedServiceReference, bucket_name: serde_json::Value) -> Self {
        Self {
            s3_linked_service_name,
            bucket_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RelationalSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl RelationalSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RelationalTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<RelationalTableDatasetTypeProperties>,
}
impl RelationalTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RelationalTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl RelationalTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RemotePrivateEndpointConnection {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<ArmIdWrapper>,
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkConnectionState>,
}
impl RemotePrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RerunTumblingWindowTrigger {
    #[serde(flatten)]
    pub trigger: Trigger,
    #[serde(rename = "typeProperties")]
    pub type_properties: rerun_tumbling_window_trigger::TypeProperties,
}
impl RerunTumblingWindowTrigger {
    pub fn new(trigger: Trigger, type_properties: rerun_tumbling_window_trigger::TypeProperties) -> Self {
        Self { trigger, type_properties }
    }
}
pub mod rerun_tumbling_window_trigger {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[serde(rename = "parentTrigger")]
        pub parent_trigger: serde_json::Value,
        #[serde(rename = "requestedStartTime")]
        pub requested_start_time: String,
        #[serde(rename = "requestedEndTime")]
        pub requested_end_time: String,
        #[serde(rename = "rerunConcurrency")]
        pub rerun_concurrency: i64,
    }
    impl TypeProperties {
        pub fn new(
            parent_trigger: serde_json::Value,
            requested_start_time: String,
            requested_end_time: String,
            rerun_concurrency: i64,
        ) -> Self {
            Self {
                parent_trigger,
                requested_start_time,
                requested_end_time,
                rerun_concurrency,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponsysLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: ResponsysLinkedServiceTypeProperties,
}
impl ResponsysLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ResponsysLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponsysLinkedServiceTypeProperties {
    pub endpoint: serde_json::Value,
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ResponsysLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value, client_id: serde_json::Value) -> Self {
        Self {
            endpoint,
            client_id,
            client_secret: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponsysObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ResponsysObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponsysSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ResponsysSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<RestResourceDatasetTypeProperties>,
}
impl RestResourceDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestResourceDatasetTypeProperties {
    #[serde(rename = "relativeUrl", default, skip_serializing_if = "Option::is_none")]
    pub relative_url: Option<serde_json::Value>,
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[serde(rename = "requestBody", default, skip_serializing_if = "Option::is_none")]
    pub request_body: Option<serde_json::Value>,
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[serde(rename = "paginationRules", default, skip_serializing_if = "Option::is_none")]
    pub pagination_rules: Option<serde_json::Value>,
}
impl RestResourceDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestServiceLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: RestServiceLinkedServiceTypeProperties,
}
impl RestServiceLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: RestServiceLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestServiceLinkedServiceTypeProperties {
    pub url: serde_json::Value,
    #[serde(rename = "enableServerCertificateValidation", default, skip_serializing_if = "Option::is_none")]
    pub enable_server_certificate_validation: Option<serde_json::Value>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: rest_service_linked_service_type_properties::AuthenticationType,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "authHeaders", default, skip_serializing_if = "Option::is_none")]
    pub auth_headers: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[serde(rename = "aadResourceId", default, skip_serializing_if = "Option::is_none")]
    pub aad_resource_id: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl RestServiceLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value, authentication_type: rest_service_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            url,
            enable_server_certificate_validation: None,
            authentication_type,
            user_name: None,
            password: None,
            auth_headers: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            aad_resource_id: None,
            encrypted_credential: None,
            credential: None,
        }
    }
}
pub mod rest_service_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        Basic,
        AadServicePrincipal,
        ManagedServiceIdentity,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
    #[serde(rename = "requestInterval", default, skip_serializing_if = "Option::is_none")]
    pub request_interval: Option<serde_json::Value>,
    #[serde(rename = "httpCompressionType", default, skip_serializing_if = "Option::is_none")]
    pub http_compression_type: Option<serde_json::Value>,
}
impl RestSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            request_method: None,
            additional_headers: None,
            http_request_timeout: None,
            request_interval: None,
            http_compression_type: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[serde(rename = "requestBody", default, skip_serializing_if = "Option::is_none")]
    pub request_body: Option<serde_json::Value>,
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[serde(rename = "paginationRules", default, skip_serializing_if = "Option::is_none")]
    pub pagination_rules: Option<serde_json::Value>,
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
    #[serde(rename = "requestInterval", default, skip_serializing_if = "Option::is_none")]
    pub request_interval: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl RestSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            request_method: None,
            request_body: None,
            additional_headers: None,
            pagination_rules: None,
            http_request_timeout: None,
            request_interval: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetryPolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<serde_json::Value>,
    #[serde(rename = "intervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub interval_in_seconds: Option<i64>,
}
impl RetryPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunFilterParameters {
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
    #[serde(rename = "lastUpdatedAfter")]
    pub last_updated_after: String,
    #[serde(rename = "lastUpdatedBefore")]
    pub last_updated_before: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub filters: Vec<RunQueryFilter>,
    #[serde(rename = "orderBy", default, skip_serializing_if = "Vec::is_empty")]
    pub order_by: Vec<RunQueryOrderBy>,
}
impl RunFilterParameters {
    pub fn new(last_updated_after: String, last_updated_before: String) -> Self {
        Self {
            continuation_token: None,
            last_updated_after,
            last_updated_before,
            filters: Vec::new(),
            order_by: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunQueryFilter {
    pub operand: run_query_filter::Operand,
    pub operator: run_query_filter::Operator,
    pub values: Vec<String>,
}
impl RunQueryFilter {
    pub fn new(operand: run_query_filter::Operand, operator: run_query_filter::Operator, values: Vec<String>) -> Self {
        Self { operand, operator, values }
    }
}
pub mod run_query_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operand {
        PipelineName,
        Status,
        RunStart,
        RunEnd,
        ActivityName,
        ActivityRunStart,
        ActivityRunEnd,
        ActivityType,
        TriggerName,
        TriggerRunTimestamp,
        RunGroupId,
        LatestOnly,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Equals,
        NotEquals,
        In,
        NotIn,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunQueryOrderBy {
    #[serde(rename = "orderBy")]
    pub order_by: run_query_order_by::OrderBy,
    pub order: run_query_order_by::Order,
}
impl RunQueryOrderBy {
    pub fn new(order_by: run_query_order_by::OrderBy, order: run_query_order_by::Order) -> Self {
        Self { order_by, order }
    }
}
pub mod run_query_order_by {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OrderBy {
        RunStart,
        RunEnd,
        PipelineName,
        Status,
        ActivityName,
        ActivityRunStart,
        ActivityRunEnd,
        TriggerName,
        TriggerRunTimestamp,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Order {
        #[serde(rename = "ASC")]
        Asc,
        #[serde(rename = "DESC")]
        Desc,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisAccessCredential {
    pub domain: serde_json::Value,
    #[serde(rename = "userName")]
    pub user_name: serde_json::Value,
    pub password: SecretBase,
}
impl SsisAccessCredential {
    pub fn new(domain: serde_json::Value, user_name: serde_json::Value, password: SecretBase) -> Self {
        Self {
            domain,
            user_name,
            password,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisChildPackage {
    #[serde(rename = "packagePath")]
    pub package_path: serde_json::Value,
    #[serde(rename = "packageName", default, skip_serializing_if = "Option::is_none")]
    pub package_name: Option<String>,
    #[serde(rename = "packageContent")]
    pub package_content: serde_json::Value,
    #[serde(rename = "packageLastModifiedDate", default, skip_serializing_if = "Option::is_none")]
    pub package_last_modified_date: Option<String>,
}
impl SsisChildPackage {
    pub fn new(package_path: serde_json::Value, package_content: serde_json::Value) -> Self {
        Self {
            package_path,
            package_name: None,
            package_content,
            package_last_modified_date: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisConnectionManager {}
impl SsisConnectionManager {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisExecutionCredential {
    pub domain: serde_json::Value,
    #[serde(rename = "userName")]
    pub user_name: serde_json::Value,
    pub password: SecureString,
}
impl SsisExecutionCredential {
    pub fn new(domain: serde_json::Value, user_name: serde_json::Value, password: SecureString) -> Self {
        Self {
            domain,
            user_name,
            password,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisExecutionParameter {
    pub value: serde_json::Value,
}
impl SsisExecutionParameter {
    pub fn new(value: serde_json::Value) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisLogLocation {
    #[serde(rename = "logPath")]
    pub log_path: serde_json::Value,
    #[serde(rename = "type")]
    pub type_: ssis_log_location::Type,
    #[serde(rename = "typeProperties")]
    pub type_properties: SsisLogLocationTypeProperties,
}
impl SsisLogLocation {
    pub fn new(log_path: serde_json::Value, type_: ssis_log_location::Type, type_properties: SsisLogLocationTypeProperties) -> Self {
        Self {
            log_path,
            type_,
            type_properties,
        }
    }
}
pub mod ssis_log_location {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        File,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisLogLocationTypeProperties {
    #[serde(rename = "accessCredential", default, skip_serializing_if = "Option::is_none")]
    pub access_credential: Option<SsisAccessCredential>,
    #[serde(rename = "logRefreshInterval", default, skip_serializing_if = "Option::is_none")]
    pub log_refresh_interval: Option<serde_json::Value>,
}
impl SsisLogLocationTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisPackageLocation {
    #[serde(rename = "packagePath", default, skip_serializing_if = "Option::is_none")]
    pub package_path: Option<serde_json::Value>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<ssis_package_location::Type>,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SsisPackageLocationTypeProperties>,
}
impl SsisPackageLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ssis_package_location {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "SSISDB")]
        Ssisdb,
        File,
        InlinePackage,
        PackageStore,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisPackageLocationTypeProperties {
    #[serde(rename = "packagePassword", default, skip_serializing_if = "Option::is_none")]
    pub package_password: Option<SecretBase>,
    #[serde(rename = "accessCredential", default, skip_serializing_if = "Option::is_none")]
    pub access_credential: Option<SsisAccessCredential>,
    #[serde(rename = "configurationPath", default, skip_serializing_if = "Option::is_none")]
    pub configuration_path: Option<serde_json::Value>,
    #[serde(rename = "configurationAccessCredential", default, skip_serializing_if = "Option::is_none")]
    pub configuration_access_credential: Option<SsisAccessCredential>,
    #[serde(rename = "packageName", default, skip_serializing_if = "Option::is_none")]
    pub package_name: Option<String>,
    #[serde(rename = "packageContent", default, skip_serializing_if = "Option::is_none")]
    pub package_content: Option<serde_json::Value>,
    #[serde(rename = "packageLastModifiedDate", default, skip_serializing_if = "Option::is_none")]
    pub package_last_modified_date: Option<String>,
    #[serde(rename = "childPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub child_packages: Vec<SsisChildPackage>,
}
impl SsisPackageLocationTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisPropertyOverride {
    pub value: serde_json::Value,
    #[serde(rename = "isSensitive", default, skip_serializing_if = "Option::is_none")]
    pub is_sensitive: Option<bool>,
}
impl SsisPropertyOverride {
    pub fn new(value: serde_json::Value) -> Self {
        Self { value, is_sensitive: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SalesforceLinkedServiceTypeProperties,
}
impl SalesforceLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SalesforceLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SalesforceLinkedServiceTypeProperties {
    #[serde(rename = "environmentUrl", default, skip_serializing_if = "Option::is_none")]
    pub environment_url: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "securityToken", default, skip_serializing_if = "Option::is_none")]
    pub security_token: Option<SecretBase>,
    #[serde(rename = "apiVersion", default, skip_serializing_if = "Option::is_none")]
    pub api_version: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SalesforceLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceMarketingCloudLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SalesforceMarketingCloudLinkedServiceTypeProperties,
}
impl SalesforceMarketingCloudLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SalesforceMarketingCloudLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SalesforceMarketingCloudLinkedServiceTypeProperties {
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SalesforceMarketingCloudLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceMarketingCloudObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl SalesforceMarketingCloudObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceMarketingCloudSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SalesforceMarketingCloudSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SalesforceObjectDatasetTypeProperties>,
}
impl SalesforceObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SalesforceObjectDatasetTypeProperties {
    #[serde(rename = "objectApiName", default, skip_serializing_if = "Option::is_none")]
    pub object_api_name: Option<serde_json::Value>,
}
impl SalesforceObjectDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceServiceCloudLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SalesforceServiceCloudLinkedServiceTypeProperties,
}
impl SalesforceServiceCloudLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SalesforceServiceCloudLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SalesforceServiceCloudLinkedServiceTypeProperties {
    #[serde(rename = "environmentUrl", default, skip_serializing_if = "Option::is_none")]
    pub environment_url: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "securityToken", default, skip_serializing_if = "Option::is_none")]
    pub security_token: Option<SecretBase>,
    #[serde(rename = "apiVersion", default, skip_serializing_if = "Option::is_none")]
    pub api_version: Option<serde_json::Value>,
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SalesforceServiceCloudLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceServiceCloudObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SalesforceServiceCloudObjectDatasetTypeProperties>,
}
impl SalesforceServiceCloudObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SalesforceServiceCloudObjectDatasetTypeProperties {
    #[serde(rename = "objectApiName", default, skip_serializing_if = "Option::is_none")]
    pub object_api_name: Option<serde_json::Value>,
}
impl SalesforceServiceCloudObjectDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceServiceCloudSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<salesforce_service_cloud_sink::WriteBehavior>,
    #[serde(rename = "externalIdFieldName", default, skip_serializing_if = "Option::is_none")]
    pub external_id_field_name: Option<serde_json::Value>,
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
}
impl SalesforceServiceCloudSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
            external_id_field_name: None,
            ignore_null_values: None,
        }
    }
}
pub mod salesforce_service_cloud_sink {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WriteBehavior {
        Insert,
        Upsert,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceServiceCloudSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "readBehavior", default, skip_serializing_if = "Option::is_none")]
    pub read_behavior: Option<salesforce_service_cloud_source::ReadBehavior>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl SalesforceServiceCloudSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            read_behavior: None,
            additional_columns: None,
        }
    }
}
pub mod salesforce_service_cloud_source {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReadBehavior {
        Query,
        QueryAll,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<salesforce_sink::WriteBehavior>,
    #[serde(rename = "externalIdFieldName", default, skip_serializing_if = "Option::is_none")]
    pub external_id_field_name: Option<serde_json::Value>,
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
}
impl SalesforceSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
            external_id_field_name: None,
            ignore_null_values: None,
        }
    }
}
pub mod salesforce_sink {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WriteBehavior {
        Insert,
        Upsert,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "readBehavior", default, skip_serializing_if = "Option::is_none")]
    pub read_behavior: Option<salesforce_source::ReadBehavior>,
}
impl SalesforceSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            read_behavior: None,
        }
    }
}
pub mod salesforce_source {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReadBehavior {
        Query,
        QueryAll,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapBwLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapBwLinkedServiceTypeProperties,
}
impl SapBwLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapBwLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapBwLinkedServiceTypeProperties {
    pub server: serde_json::Value,
    #[serde(rename = "systemNumber")]
    pub system_number: serde_json::Value,
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapBwLinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, system_number: serde_json::Value, client_id: serde_json::Value) -> Self {
        Self {
            server,
            system_number,
            client_id,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapBwCubeDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
}
impl SapBwCubeDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self { dataset }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapBwSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SapBwSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapCloudForCustomerLinkedServiceTypeProperties,
}
impl SapCloudForCustomerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapCloudForCustomerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerLinkedServiceTypeProperties {
    pub url: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapCloudForCustomerLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            username: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapCloudForCustomerResourceDatasetTypeProperties,
}
impl SapCloudForCustomerResourceDataset {
    pub fn new(dataset: Dataset, type_properties: SapCloudForCustomerResourceDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerResourceDatasetTypeProperties {
    pub path: serde_json::Value,
}
impl SapCloudForCustomerResourceDatasetTypeProperties {
    pub fn new(path: serde_json::Value) -> Self {
        Self { path }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<sap_cloud_for_customer_sink::WriteBehavior>,
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl SapCloudForCustomerSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
            http_request_timeout: None,
        }
    }
}
pub mod sap_cloud_for_customer_sink {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WriteBehavior {
        Insert,
        Update,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl SapCloudForCustomerSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            http_request_timeout: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapEccLinkedServiceTypeProperties,
}
impl SapEccLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapEccLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccLinkedServiceTypeProperties {
    pub url: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<String>,
}
impl SapEccLinkedServiceTypeProperties {
    pub fn new(url: String) -> Self {
        Self {
            url,
            username: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapEccResourceDatasetTypeProperties,
}
impl SapEccResourceDataset {
    pub fn new(dataset: Dataset, type_properties: SapEccResourceDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccResourceDatasetTypeProperties {
    pub path: serde_json::Value,
}
impl SapEccResourceDatasetTypeProperties {
    pub fn new(path: serde_json::Value) -> Self {
        Self { path }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl SapEccSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            http_request_timeout: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapHanaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapHanaLinkedServiceProperties,
}
impl SapHanaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapHanaLinkedServiceProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapHanaLinkedServiceProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<serde_json::Value>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<sap_hana_linked_service_properties::AuthenticationType>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapHanaLinkedServiceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sap_hana_linked_service_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Windows,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SapHanaPartitionOption {
    None,
    PhysicalPartitionsOfTable,
    SapHanaDynamicRange,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapHanaPartitionSettings {
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
}
impl SapHanaPartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapHanaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "packetSize", default, skip_serializing_if = "Option::is_none")]
    pub packet_size: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SapHanaPartitionSettings>,
}
impl SapHanaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            packet_size: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapHanaTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SapHanaTableDatasetTypeProperties>,
}
impl SapHanaTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapHanaTableDatasetTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl SapHanaTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapOpenHubLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapOpenHubLinkedServiceTypeProperties,
}
impl SapOpenHubLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapOpenHubLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapOpenHubLinkedServiceTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<serde_json::Value>,
    #[serde(rename = "systemNumber", default, skip_serializing_if = "Option::is_none")]
    pub system_number: Option<serde_json::Value>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<serde_json::Value>,
    #[serde(rename = "systemId", default, skip_serializing_if = "Option::is_none")]
    pub system_id: Option<serde_json::Value>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "messageServer", default, skip_serializing_if = "Option::is_none")]
    pub message_server: Option<serde_json::Value>,
    #[serde(rename = "messageServerService", default, skip_serializing_if = "Option::is_none")]
    pub message_server_service: Option<serde_json::Value>,
    #[serde(rename = "logonGroup", default, skip_serializing_if = "Option::is_none")]
    pub logon_group: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapOpenHubLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapOpenHubSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(rename = "excludeLastRequest", default, skip_serializing_if = "Option::is_none")]
    pub exclude_last_request: Option<serde_json::Value>,
    #[serde(rename = "baseRequestId", default, skip_serializing_if = "Option::is_none")]
    pub base_request_id: Option<serde_json::Value>,
    #[serde(rename = "customRfcReadTableFunctionModule", default, skip_serializing_if = "Option::is_none")]
    pub custom_rfc_read_table_function_module: Option<serde_json::Value>,
    #[serde(rename = "sapDataColumnDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub sap_data_column_delimiter: Option<serde_json::Value>,
}
impl SapOpenHubSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            exclude_last_request: None,
            base_request_id: None,
            custom_rfc_read_table_function_module: None,
            sap_data_column_delimiter: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapOpenHubTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapOpenHubTableDatasetTypeProperties,
}
impl SapOpenHubTableDataset {
    pub fn new(dataset: Dataset, type_properties: SapOpenHubTableDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapOpenHubTableDatasetTypeProperties {
    #[serde(rename = "openHubDestinationName")]
    pub open_hub_destination_name: serde_json::Value,
    #[serde(rename = "excludeLastRequest", default, skip_serializing_if = "Option::is_none")]
    pub exclude_last_request: Option<serde_json::Value>,
    #[serde(rename = "baseRequestId", default, skip_serializing_if = "Option::is_none")]
    pub base_request_id: Option<serde_json::Value>,
}
impl SapOpenHubTableDatasetTypeProperties {
    pub fn new(open_hub_destination_name: serde_json::Value) -> Self {
        Self {
            open_hub_destination_name,
            exclude_last_request: None,
            base_request_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapTableLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapTableLinkedServiceTypeProperties,
}
impl SapTableLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapTableLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapTableLinkedServiceTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<serde_json::Value>,
    #[serde(rename = "systemNumber", default, skip_serializing_if = "Option::is_none")]
    pub system_number: Option<serde_json::Value>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<serde_json::Value>,
    #[serde(rename = "systemId", default, skip_serializing_if = "Option::is_none")]
    pub system_id: Option<serde_json::Value>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "messageServer", default, skip_serializing_if = "Option::is_none")]
    pub message_server: Option<serde_json::Value>,
    #[serde(rename = "messageServerService", default, skip_serializing_if = "Option::is_none")]
    pub message_server_service: Option<serde_json::Value>,
    #[serde(rename = "sncMode", default, skip_serializing_if = "Option::is_none")]
    pub snc_mode: Option<serde_json::Value>,
    #[serde(rename = "sncMyName", default, skip_serializing_if = "Option::is_none")]
    pub snc_my_name: Option<serde_json::Value>,
    #[serde(rename = "sncPartnerName", default, skip_serializing_if = "Option::is_none")]
    pub snc_partner_name: Option<serde_json::Value>,
    #[serde(rename = "sncLibraryPath", default, skip_serializing_if = "Option::is_none")]
    pub snc_library_path: Option<serde_json::Value>,
    #[serde(rename = "sncQop", default, skip_serializing_if = "Option::is_none")]
    pub snc_qop: Option<serde_json::Value>,
    #[serde(rename = "logonGroup", default, skip_serializing_if = "Option::is_none")]
    pub logon_group: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapTableLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SapTablePartitionOption {
    None,
    PartitionOnInt,
    PartitionOnCalendarYear,
    PartitionOnCalendarMonth,
    PartitionOnCalendarDate,
    PartitionOnTime,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapTablePartitionSettings {
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
    #[serde(rename = "maxPartitionsNumber", default, skip_serializing_if = "Option::is_none")]
    pub max_partitions_number: Option<serde_json::Value>,
}
impl SapTablePartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapTableResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: SapTableResourceDatasetTypeProperties,
}
impl SapTableResourceDataset {
    pub fn new(dataset: Dataset, type_properties: SapTableResourceDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapTableResourceDatasetTypeProperties {
    #[serde(rename = "tableName")]
    pub table_name: serde_json::Value,
}
impl SapTableResourceDatasetTypeProperties {
    pub fn new(table_name: serde_json::Value) -> Self {
        Self { table_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapTableSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(rename = "rowCount", default, skip_serializing_if = "Option::is_none")]
    pub row_count: Option<serde_json::Value>,
    #[serde(rename = "rowSkips", default, skip_serializing_if = "Option::is_none")]
    pub row_skips: Option<serde_json::Value>,
    #[serde(rename = "rfcTableFields", default, skip_serializing_if = "Option::is_none")]
    pub rfc_table_fields: Option<serde_json::Value>,
    #[serde(rename = "rfcTableOptions", default, skip_serializing_if = "Option::is_none")]
    pub rfc_table_options: Option<serde_json::Value>,
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<serde_json::Value>,
    #[serde(rename = "customRfcReadTableFunctionModule", default, skip_serializing_if = "Option::is_none")]
    pub custom_rfc_read_table_function_module: Option<serde_json::Value>,
    #[serde(rename = "sapDataColumnDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub sap_data_column_delimiter: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SapTablePartitionSettings>,
}
impl SapTableSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            row_count: None,
            row_skips: None,
            rfc_table_fields: None,
            rfc_table_options: None,
            batch_size: None,
            custom_rfc_read_table_function_module: None,
            sap_data_column_delimiter: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduleTrigger {
    #[serde(flatten)]
    pub multiple_pipeline_trigger: MultiplePipelineTrigger,
    #[serde(rename = "typeProperties")]
    pub type_properties: schedule_trigger::TypeProperties,
}
impl ScheduleTrigger {
    pub fn new(multiple_pipeline_trigger: MultiplePipelineTrigger, type_properties: schedule_trigger::TypeProperties) -> Self {
        Self {
            multiple_pipeline_trigger,
            type_properties,
        }
    }
}
pub mod schedule_trigger {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        pub recurrence: ScheduleTriggerRecurrence,
    }
    impl TypeProperties {
        pub fn new(recurrence: ScheduleTriggerRecurrence) -> Self {
            Self { recurrence }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduleTriggerRecurrence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<RecurrenceFrequency>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<RecurrenceSchedule>,
}
impl ScheduleTriggerRecurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScriptAction {
    pub name: String,
    pub uri: String,
    pub roles: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<String>,
}
impl ScriptAction {
    pub fn new(name: String, uri: String, roles: serde_json::Value) -> Self {
        Self {
            name,
            uri,
            roles,
            parameters: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecretBase {
    #[serde(rename = "type")]
    pub type_: String,
}
impl SecretBase {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecureString {
    #[serde(flatten)]
    pub secret_base: SecretBase,
    pub value: String,
}
impl SecureString {
    pub fn new(secret_base: SecretBase, value: String) -> Self {
        Self { secret_base, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SelfDependencyTumblingWindowTriggerReference {
    #[serde(flatten)]
    pub dependency_reference: DependencyReference,
    pub offset: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
}
impl SelfDependencyTumblingWindowTriggerReference {
    pub fn new(dependency_reference: DependencyReference, offset: String) -> Self {
        Self {
            dependency_reference,
            offset,
            size: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SelfHostedIntegrationRuntime {
    #[serde(flatten)]
    pub integration_runtime: IntegrationRuntime,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SelfHostedIntegrationRuntimeTypeProperties>,
}
impl SelfHostedIntegrationRuntime {
    pub fn new(integration_runtime: IntegrationRuntime) -> Self {
        Self {
            integration_runtime,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SelfHostedIntegrationRuntimeNode {
    #[serde(rename = "nodeName", default, skip_serializing_if = "Option::is_none")]
    pub node_name: Option<String>,
    #[serde(rename = "machineName", default, skip_serializing_if = "Option::is_none")]
    pub machine_name: Option<String>,
    #[serde(rename = "hostServiceUri", default, skip_serializing_if = "Option::is_none")]
    pub host_service_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<self_hosted_integration_runtime_node::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capabilities: Option<serde_json::Value>,
    #[serde(rename = "versionStatus", default, skip_serializing_if = "Option::is_none")]
    pub version_status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "registerTime", default, skip_serializing_if = "Option::is_none")]
    pub register_time: Option<String>,
    #[serde(rename = "lastConnectTime", default, skip_serializing_if = "Option::is_none")]
    pub last_connect_time: Option<String>,
    #[serde(rename = "expiryTime", default, skip_serializing_if = "Option::is_none")]
    pub expiry_time: Option<String>,
    #[serde(rename = "lastStartTime", default, skip_serializing_if = "Option::is_none")]
    pub last_start_time: Option<String>,
    #[serde(rename = "lastStopTime", default, skip_serializing_if = "Option::is_none")]
    pub last_stop_time: Option<String>,
    #[serde(rename = "lastUpdateResult", default, skip_serializing_if = "Option::is_none")]
    pub last_update_result: Option<self_hosted_integration_runtime_node::LastUpdateResult>,
    #[serde(rename = "lastStartUpdateTime", default, skip_serializing_if = "Option::is_none")]
    pub last_start_update_time: Option<String>,
    #[serde(rename = "lastEndUpdateTime", default, skip_serializing_if = "Option::is_none")]
    pub last_end_update_time: Option<String>,
    #[serde(rename = "isActiveDispatcher", default, skip_serializing_if = "Option::is_none")]
    pub is_active_dispatcher: Option<bool>,
    #[serde(rename = "concurrentJobsLimit", default, skip_serializing_if = "Option::is_none")]
    pub concurrent_jobs_limit: Option<i64>,
    #[serde(rename = "maxConcurrentJobs", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_jobs: Option<i64>,
}
impl SelfHostedIntegrationRuntimeNode {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod self_hosted_integration_runtime_node {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        NeedRegistration,
        Online,
        Limited,
        Offline,
        Upgrading,
        Initializing,
        InitializeFailed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastUpdateResult {
        None,
        Succeed,
        Fail,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SelfHostedIntegrationRuntimeStatus {
    #[serde(flatten)]
    pub integration_runtime_status: IntegrationRuntimeStatus,
    #[serde(rename = "typeProperties")]
    pub type_properties: SelfHostedIntegrationRuntimeStatusTypeProperties,
}
impl SelfHostedIntegrationRuntimeStatus {
    pub fn new(
        integration_runtime_status: IntegrationRuntimeStatus,
        type_properties: SelfHostedIntegrationRuntimeStatusTypeProperties,
    ) -> Self {
        Self {
            integration_runtime_status,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SelfHostedIntegrationRuntimeStatusTypeProperties {
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[serde(rename = "taskQueueId", default, skip_serializing_if = "Option::is_none")]
    pub task_queue_id: Option<String>,
    #[serde(rename = "internalChannelEncryption", default, skip_serializing_if = "Option::is_none")]
    pub internal_channel_encryption: Option<self_hosted_integration_runtime_status_type_properties::InternalChannelEncryption>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub nodes: Vec<SelfHostedIntegrationRuntimeNode>,
    #[serde(rename = "scheduledUpdateDate", default, skip_serializing_if = "Option::is_none")]
    pub scheduled_update_date: Option<String>,
    #[serde(rename = "updateDelayOffset", default, skip_serializing_if = "Option::is_none")]
    pub update_delay_offset: Option<String>,
    #[serde(rename = "localTimeZoneOffset", default, skip_serializing_if = "Option::is_none")]
    pub local_time_zone_offset: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capabilities: Option<serde_json::Value>,
    #[serde(rename = "serviceUrls", default, skip_serializing_if = "Vec::is_empty")]
    pub service_urls: Vec<String>,
    #[serde(rename = "autoUpdate", default, skip_serializing_if = "Option::is_none")]
    pub auto_update: Option<IntegrationRuntimeAutoUpdate>,
    #[serde(rename = "versionStatus", default, skip_serializing_if = "Option::is_none")]
    pub version_status: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub links: Vec<LinkedIntegrationRuntime>,
    #[serde(rename = "pushedVersion", default, skip_serializing_if = "Option::is_none")]
    pub pushed_version: Option<String>,
    #[serde(rename = "latestVersion", default, skip_serializing_if = "Option::is_none")]
    pub latest_version: Option<String>,
    #[serde(rename = "autoUpdateETA", default, skip_serializing_if = "Option::is_none")]
    pub auto_update_eta: Option<String>,
}
impl SelfHostedIntegrationRuntimeStatusTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod self_hosted_integration_runtime_status_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InternalChannelEncryption {
        NotSet,
        SslEncrypted,
        NotEncrypted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SelfHostedIntegrationRuntimeTypeProperties {
    #[serde(rename = "linkedInfo", default, skip_serializing_if = "Option::is_none")]
    pub linked_info: Option<LinkedIntegrationRuntimeType>,
}
impl SelfHostedIntegrationRuntimeTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceNowLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: ServiceNowLinkedServiceTypeProperties,
}
impl ServiceNowLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ServiceNowLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceNowLinkedServiceTypeProperties {
    pub endpoint: serde_json::Value,
    #[serde(rename = "authenticationType")]
    pub authentication_type: service_now_linked_service_type_properties::AuthenticationType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ServiceNowLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value, authentication_type: service_now_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            endpoint,
            authentication_type,
            username: None,
            password: None,
            client_id: None,
            client_secret: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
pub mod service_now_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        OAuth2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceNowObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ServiceNowObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceNowSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ServiceNowSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ServicePrincipalCredentialType {
    ServicePrincipalKey,
    ServicePrincipalCert,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SetVariableActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: SetVariableActivityTypeProperties,
}
impl SetVariableActivity {
    pub fn new(control_activity: ControlActivity, type_properties: SetVariableActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SetVariableActivityTypeProperties {
    #[serde(rename = "variableName", default, skip_serializing_if = "Option::is_none")]
    pub variable_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
}
impl SetVariableActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl SftpLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[serde(rename = "disableChunking", default, skip_serializing_if = "Option::is_none")]
    pub disable_chunking: Option<serde_json::Value>,
}
impl SftpReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            file_list_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
            disable_chunking: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpServerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SftpServerLinkedServiceTypeProperties,
}
impl SftpServerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SftpServerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpServerLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<sftp_server_linked_service_type_properties::AuthenticationType>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "privateKeyPath", default, skip_serializing_if = "Option::is_none")]
    pub private_key_path: Option<serde_json::Value>,
    #[serde(rename = "privateKeyContent", default, skip_serializing_if = "Option::is_none")]
    pub private_key_content: Option<SecretBase>,
    #[serde(rename = "passPhrase", default, skip_serializing_if = "Option::is_none")]
    pub pass_phrase: Option<SecretBase>,
    #[serde(rename = "skipHostKeyValidation", default, skip_serializing_if = "Option::is_none")]
    pub skip_host_key_validation: Option<serde_json::Value>,
    #[serde(rename = "hostKeyFingerprint", default, skip_serializing_if = "Option::is_none")]
    pub host_key_fingerprint: Option<serde_json::Value>,
}
impl SftpServerLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            port: None,
            authentication_type: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
            private_key_path: None,
            private_key_content: None,
            pass_phrase: None,
            skip_host_key_validation: None,
            host_key_fingerprint: None,
        }
    }
}
pub mod sftp_server_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        SshPublicKey,
        MultiFactor,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
    #[serde(rename = "operationTimeout", default, skip_serializing_if = "Option::is_none")]
    pub operation_timeout: Option<serde_json::Value>,
    #[serde(rename = "useTempFileRename", default, skip_serializing_if = "Option::is_none")]
    pub use_temp_file_rename: Option<serde_json::Value>,
}
impl SftpWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self {
            store_write_settings,
            operation_timeout: None,
            use_temp_file_rename: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharePointOnlineListDatasetTypeProperties {
    #[serde(rename = "listName", default, skip_serializing_if = "Option::is_none")]
    pub list_name: Option<serde_json::Value>,
}
impl SharePointOnlineListDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePointOnlineListLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SharePointOnlineListLinkedServiceTypeProperties,
}
impl SharePointOnlineListLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SharePointOnlineListLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePointOnlineListLinkedServiceTypeProperties {
    #[serde(rename = "siteUrl")]
    pub site_url: serde_json::Value,
    #[serde(rename = "tenantId")]
    pub tenant_id: serde_json::Value,
    #[serde(rename = "servicePrincipalId")]
    pub service_principal_id: serde_json::Value,
    #[serde(rename = "servicePrincipalKey")]
    pub service_principal_key: SecretBase,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SharePointOnlineListLinkedServiceTypeProperties {
    pub fn new(
        site_url: serde_json::Value,
        tenant_id: serde_json::Value,
        service_principal_id: serde_json::Value,
        service_principal_key: SecretBase,
    ) -> Self {
        Self {
            site_url,
            tenant_id,
            service_principal_id,
            service_principal_key,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePointOnlineListResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SharePointOnlineListDatasetTypeProperties>,
}
impl SharePointOnlineListResourceDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePointOnlineListSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl SharePointOnlineListSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            http_request_timeout: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShopifyLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: ShopifyLinkedServiceTypeProperties,
}
impl ShopifyLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ShopifyLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShopifyLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ShopifyLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            access_token: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShopifyObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ShopifyObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShopifySource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ShopifySource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkipErrorFile {
    #[serde(rename = "fileMissing", default, skip_serializing_if = "Option::is_none")]
    pub file_missing: Option<serde_json::Value>,
    #[serde(rename = "dataInconsistency", default, skip_serializing_if = "Option::is_none")]
    pub data_inconsistency: Option<serde_json::Value>,
}
impl SkipErrorFile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: SnowflakeDatasetTypeProperties,
}
impl SnowflakeDataset {
    pub fn new(dataset: Dataset, type_properties: SnowflakeDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnowflakeDatasetTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl SnowflakeDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeExportCopyCommand {
    #[serde(flatten)]
    pub export_settings: ExportSettings,
    #[serde(rename = "additionalCopyOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_copy_options: Option<serde_json::Value>,
    #[serde(rename = "additionalFormatOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_format_options: Option<serde_json::Value>,
}
impl SnowflakeExportCopyCommand {
    pub fn new(export_settings: ExportSettings) -> Self {
        Self {
            export_settings,
            additional_copy_options: None,
            additional_format_options: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeImportCopyCommand {
    #[serde(flatten)]
    pub import_settings: ImportSettings,
    #[serde(rename = "additionalCopyOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_copy_options: Option<serde_json::Value>,
    #[serde(rename = "additionalFormatOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_format_options: Option<serde_json::Value>,
}
impl SnowflakeImportCopyCommand {
    pub fn new(import_settings: ImportSettings) -> Self {
        Self {
            import_settings,
            additional_copy_options: None,
            additional_format_options: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SnowflakeLinkedServiceTypeProperties,
}
impl SnowflakeLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SnowflakeLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SnowflakeLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[serde(rename = "importSettings", default, skip_serializing_if = "Option::is_none")]
    pub import_settings: Option<SnowflakeImportCopyCommand>,
}
impl SnowflakeSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
            import_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "exportSettings", default, skip_serializing_if = "Option::is_none")]
    pub export_settings: Option<SnowflakeExportCopyCommand>,
}
impl SnowflakeSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            export_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SparkDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl SparkDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SparkLinkedServiceTypeProperties,
}
impl SparkLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SparkLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkLinkedServiceTypeProperties {
    pub host: serde_json::Value,
    pub port: serde_json::Value,
    #[serde(rename = "serverType", default, skip_serializing_if = "Option::is_none")]
    pub server_type: Option<spark_linked_service_type_properties::ServerType>,
    #[serde(rename = "thriftTransportProtocol", default, skip_serializing_if = "Option::is_none")]
    pub thrift_transport_protocol: Option<spark_linked_service_type_properties::ThriftTransportProtocol>,
    #[serde(rename = "authenticationType")]
    pub authentication_type: spark_linked_service_type_properties::AuthenticationType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "httpPath", default, skip_serializing_if = "Option::is_none")]
    pub http_path: Option<serde_json::Value>,
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SparkLinkedServiceTypeProperties {
    pub fn new(
        host: serde_json::Value,
        port: serde_json::Value,
        authentication_type: spark_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            host,
            port,
            server_type: None,
            thrift_transport_protocol: None,
            authentication_type,
            username: None,
            password: None,
            http_path: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod spark_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServerType {
        SharkServer,
        SharkServer2,
        SparkThriftServer,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ThriftTransportProtocol {
        Binary,
        #[serde(rename = "SASL")]
        Sasl,
        #[serde(rename = "HTTP ")]
        Http,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        Username,
        UsernameAndPassword,
        #[serde(rename = "WindowsAzureHDInsightService")]
        WindowsAzureHdInsightService,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SparkDatasetTypeProperties>,
}
impl SparkObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SparkSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlAlwaysEncryptedProperties {
    #[serde(rename = "alwaysEncryptedAkvAuthType")]
    pub always_encrypted_akv_auth_type: sql_always_encrypted_properties::AlwaysEncryptedAkvAuthType,
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl SqlAlwaysEncryptedProperties {
    pub fn new(always_encrypted_akv_auth_type: sql_always_encrypted_properties::AlwaysEncryptedAkvAuthType) -> Self {
        Self {
            always_encrypted_akv_auth_type,
            service_principal_id: None,
            service_principal_key: None,
            credential: None,
        }
    }
}
pub mod sql_always_encrypted_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AlwaysEncryptedAkvAuthType {
        ServicePrincipal,
        ManagedIdentity,
        UserAssignedManagedIdentity,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDwSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[serde(rename = "allowPolyBase", default, skip_serializing_if = "Option::is_none")]
    pub allow_poly_base: Option<serde_json::Value>,
    #[serde(rename = "polyBaseSettings", default, skip_serializing_if = "Option::is_none")]
    pub poly_base_settings: Option<PolybaseSettings>,
    #[serde(rename = "allowCopyCommand", default, skip_serializing_if = "Option::is_none")]
    pub allow_copy_command: Option<serde_json::Value>,
    #[serde(rename = "copyCommandSettings", default, skip_serializing_if = "Option::is_none")]
    pub copy_command_settings: Option<DwCopyCommandSettings>,
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
    #[serde(rename = "sqlWriterUseTableLock", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_use_table_lock: Option<serde_json::Value>,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
    #[serde(rename = "upsertSettings", default, skip_serializing_if = "Option::is_none")]
    pub upsert_settings: Option<SqlDwUpsertSettings>,
}
impl SqlDwSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
            allow_poly_base: None,
            poly_base_settings: None,
            allow_copy_command: None,
            copy_command_settings: None,
            table_option: None,
            sql_writer_use_table_lock: None,
            write_behavior: None,
            upsert_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDwSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl SqlDwSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDwUpsertSettings {
    #[serde(rename = "interimSchemaName", default, skip_serializing_if = "Option::is_none")]
    pub interim_schema_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keys: Option<serde_json::Value>,
}
impl SqlDwUpsertSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SqlDwWriteBehaviorEnum {
    Insert,
    Upsert,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlMiSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "sqlWriterStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "sqlWriterTableType", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_table_type: Option<serde_json::Value>,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureTableTypeParameterName", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_table_type_parameter_name: Option<serde_json::Value>,
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
    #[serde(rename = "sqlWriterUseTableLock", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_use_table_lock: Option<serde_json::Value>,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
    #[serde(rename = "upsertSettings", default, skip_serializing_if = "Option::is_none")]
    pub upsert_settings: Option<SqlUpsertSettings>,
}
impl SqlMiSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            sql_writer_stored_procedure_name: None,
            sql_writer_table_type: None,
            pre_copy_script: None,
            stored_procedure_parameters: None,
            stored_procedure_table_type_parameter_name: None,
            table_option: None,
            sql_writer_use_table_lock: None,
            write_behavior: None,
            upsert_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlMiSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "produceAdditionalTypes", default, skip_serializing_if = "Option::is_none")]
    pub produce_additional_types: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl SqlMiSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            produce_additional_types: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SqlPartitionOption {
    None,
    PhysicalPartitionsOfTable,
    DynamicRange,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlPartitionSettings {
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
}
impl SqlPartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SqlServerLinkedServiceTypeProperties,
}
impl SqlServerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SqlServerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerLinkedServiceTypeProperties {
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[serde(rename = "alwaysEncryptedSettings", default, skip_serializing_if = "Option::is_none")]
    pub always_encrypted_settings: Option<SqlAlwaysEncryptedProperties>,
}
impl SqlServerLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            user_name: None,
            password: None,
            encrypted_credential: None,
            always_encrypted_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "sqlWriterStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "sqlWriterTableType", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_table_type: Option<serde_json::Value>,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureTableTypeParameterName", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_table_type_parameter_name: Option<serde_json::Value>,
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
    #[serde(rename = "sqlWriterUseTableLock", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_use_table_lock: Option<serde_json::Value>,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
    #[serde(rename = "upsertSettings", default, skip_serializing_if = "Option::is_none")]
    pub upsert_settings: Option<SqlUpsertSettings>,
}
impl SqlServerSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            sql_writer_stored_procedure_name: None,
            sql_writer_table_type: None,
            pre_copy_script: None,
            stored_procedure_parameters: None,
            stored_procedure_table_type_parameter_name: None,
            table_option: None,
            sql_writer_use_table_lock: None,
            write_behavior: None,
            upsert_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "produceAdditionalTypes", default, skip_serializing_if = "Option::is_none")]
    pub produce_additional_types: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl SqlServerSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            produce_additional_types: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerStoredProcedureActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: SqlServerStoredProcedureActivityTypeProperties,
}
impl SqlServerStoredProcedureActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: SqlServerStoredProcedureActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerStoredProcedureActivityTypeProperties {
    #[serde(rename = "storedProcedureName")]
    pub stored_procedure_name: serde_json::Value,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
}
impl SqlServerStoredProcedureActivityTypeProperties {
    pub fn new(stored_procedure_name: serde_json::Value) -> Self {
        Self {
            stored_procedure_name,
            stored_procedure_parameters: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SqlServerTableDatasetTypeProperties>,
}
impl SqlServerTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlServerTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl SqlServerTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[serde(rename = "sqlWriterStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "sqlWriterTableType", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_table_type: Option<serde_json::Value>,
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureTableTypeParameterName", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_table_type_parameter_name: Option<serde_json::Value>,
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
    #[serde(rename = "sqlWriterUseTableLock", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_use_table_lock: Option<serde_json::Value>,
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
    #[serde(rename = "upsertSettings", default, skip_serializing_if = "Option::is_none")]
    pub upsert_settings: Option<SqlUpsertSettings>,
}
impl SqlSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            sql_writer_stored_procedure_name: None,
            sql_writer_table_type: None,
            pre_copy_script: None,
            stored_procedure_parameters: None,
            stored_procedure_table_type_parameter_name: None,
            table_option: None,
            sql_writer_use_table_lock: None,
            write_behavior: None,
            upsert_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[serde(rename = "isolationLevel", default, skip_serializing_if = "Option::is_none")]
    pub isolation_level: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl SqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            isolation_level: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlUpsertSettings {
    #[serde(rename = "useTempDB", default, skip_serializing_if = "Option::is_none")]
    pub use_temp_db: Option<serde_json::Value>,
    #[serde(rename = "interimSchemaName", default, skip_serializing_if = "Option::is_none")]
    pub interim_schema_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keys: Option<serde_json::Value>,
}
impl SqlUpsertSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SqlWriteBehaviorEnum {
    Insert,
    Upsert,
    StoredProcedure,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SquareLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SquareLinkedServiceTypeProperties,
}
impl SquareLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SquareLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SquareLinkedServiceTypeProperties {
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<serde_json::Value>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[serde(rename = "redirectUri", default, skip_serializing_if = "Option::is_none")]
    pub redirect_uri: Option<serde_json::Value>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SquareLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SquareObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl SquareObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SquareSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SquareSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisEnvironment {
    #[serde(flatten)]
    pub ssis_object_metadata: SsisObjectMetadata,
    #[serde(rename = "folderId", default, skip_serializing_if = "Option::is_none")]
    pub folder_id: Option<i64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub variables: Vec<SsisVariable>,
}
impl SsisEnvironment {
    pub fn new(ssis_object_metadata: SsisObjectMetadata) -> Self {
        Self {
            ssis_object_metadata,
            folder_id: None,
            variables: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisEnvironmentReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    #[serde(rename = "environmentFolderName", default, skip_serializing_if = "Option::is_none")]
    pub environment_folder_name: Option<String>,
    #[serde(rename = "environmentName", default, skip_serializing_if = "Option::is_none")]
    pub environment_name: Option<String>,
    #[serde(rename = "referenceType", default, skip_serializing_if = "Option::is_none")]
    pub reference_type: Option<String>,
}
impl SsisEnvironmentReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisFolder {
    #[serde(flatten)]
    pub ssis_object_metadata: SsisObjectMetadata,
}
impl SsisFolder {
    pub fn new(ssis_object_metadata: SsisObjectMetadata) -> Self {
        Self { ssis_object_metadata }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisObjectMetadata {
    #[serde(rename = "type")]
    pub type_: SsisObjectMetadataType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl SsisObjectMetadata {
    pub fn new(type_: SsisObjectMetadataType) -> Self {
        Self {
            type_,
            id: None,
            name: None,
            description: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisObjectMetadataListResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SsisObjectMetadata>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SsisObjectMetadataListResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisObjectMetadataStatusResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
}
impl SsisObjectMetadataStatusResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SsisObjectMetadataType {
    Folder,
    Project,
    Package,
    Environment,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisPackage {
    #[serde(flatten)]
    pub ssis_object_metadata: SsisObjectMetadata,
    #[serde(rename = "folderId", default, skip_serializing_if = "Option::is_none")]
    pub folder_id: Option<i64>,
    #[serde(rename = "projectVersion", default, skip_serializing_if = "Option::is_none")]
    pub project_version: Option<i64>,
    #[serde(rename = "projectId", default, skip_serializing_if = "Option::is_none")]
    pub project_id: Option<i64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<SsisParameter>,
}
impl SsisPackage {
    pub fn new(ssis_object_metadata: SsisObjectMetadata) -> Self {
        Self {
            ssis_object_metadata,
            folder_id: None,
            project_version: None,
            project_id: None,
            parameters: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub required: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sensitive: Option<bool>,
    #[serde(rename = "designDefaultValue", default, skip_serializing_if = "Option::is_none")]
    pub design_default_value: Option<String>,
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<String>,
    #[serde(rename = "sensitiveDefaultValue", default, skip_serializing_if = "Option::is_none")]
    pub sensitive_default_value: Option<String>,
    #[serde(rename = "valueType", default, skip_serializing_if = "Option::is_none")]
    pub value_type: Option<String>,
    #[serde(rename = "valueSet", default, skip_serializing_if = "Option::is_none")]
    pub value_set: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub variable: Option<String>,
}
impl SsisParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisProject {
    #[serde(flatten)]
    pub ssis_object_metadata: SsisObjectMetadata,
    #[serde(rename = "folderId", default, skip_serializing_if = "Option::is_none")]
    pub folder_id: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
    #[serde(rename = "environmentRefs", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_refs: Vec<SsisEnvironmentReference>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<SsisParameter>,
}
impl SsisProject {
    pub fn new(ssis_object_metadata: SsisObjectMetadata) -> Self {
        Self {
            ssis_object_metadata,
            folder_id: None,
            version: None,
            environment_refs: Vec::new(),
            parameters: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisVariable {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sensitive: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "sensitiveValue", default, skip_serializing_if = "Option::is_none")]
    pub sensitive_value: Option<String>,
}
impl SsisVariable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StagingSettings {
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
    #[serde(rename = "enableCompression", default, skip_serializing_if = "Option::is_none")]
    pub enable_compression: Option<serde_json::Value>,
}
impl StagingSettings {
    pub fn new(linked_service_name: LinkedServiceReference) -> Self {
        Self {
            linked_service_name,
            path: None,
            enable_compression: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StoreReadSettings {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<serde_json::Value>,
    #[serde(rename = "disableMetricsCollection", default, skip_serializing_if = "Option::is_none")]
    pub disable_metrics_collection: Option<serde_json::Value>,
}
impl StoreReadSettings {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            max_concurrent_connections: None,
            disable_metrics_collection: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StoreWriteSettings {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<serde_json::Value>,
    #[serde(rename = "disableMetricsCollection", default, skip_serializing_if = "Option::is_none")]
    pub disable_metrics_collection: Option<serde_json::Value>,
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
}
impl StoreWriteSettings {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            max_concurrent_connections: None,
            disable_metrics_collection: None,
            copy_behavior: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StoredProcedureParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<StoredProcedureParameterType>,
}
impl StoredProcedureParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum StoredProcedureParameterType {
    String,
    Int,
    Int64,
    Decimal,
    Guid,
    Boolean,
    Date,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResourceDebugResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl SubResourceDebugResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SwitchActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: SwitchActivityTypeProperties,
}
impl SwitchActivity {
    pub fn new(control_activity: ControlActivity, type_properties: SwitchActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SwitchActivityTypeProperties {
    pub on: Expression,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub cases: Vec<SwitchCase>,
    #[serde(rename = "defaultActivities", default, skip_serializing_if = "Vec::is_empty")]
    pub default_activities: Vec<Activity>,
}
impl SwitchActivityTypeProperties {
    pub fn new(on: Expression) -> Self {
        Self {
            on,
            cases: Vec::new(),
            default_activities: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwitchCase {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub activities: Vec<Activity>,
}
impl SwitchCase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SybaseLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: SybaseLinkedServiceTypeProperties,
}
impl SybaseLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SybaseLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SybaseLinkedServiceTypeProperties {
    pub server: serde_json::Value,
    pub database: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<sybase_linked_service_type_properties::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SybaseLinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            server,
            database,
            schema: None,
            authentication_type: None,
            username: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
pub mod sybase_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Windows,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SybaseSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SybaseSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SybaseTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SybaseTableDatasetTypeProperties>,
}
impl SybaseTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SybaseTableDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl SybaseTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TabularSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl TabularSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query_timeout: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TabularTranslator {
    #[serde(flatten)]
    pub copy_translator: CopyTranslator,
    #[serde(rename = "columnMappings", default, skip_serializing_if = "Option::is_none")]
    pub column_mappings: Option<serde_json::Value>,
    #[serde(rename = "schemaMapping", default, skip_serializing_if = "Option::is_none")]
    pub schema_mapping: Option<serde_json::Value>,
    #[serde(rename = "collectionReference", default, skip_serializing_if = "Option::is_none")]
    pub collection_reference: Option<serde_json::Value>,
    #[serde(rename = "mapComplexValuesToString", default, skip_serializing_if = "Option::is_none")]
    pub map_complex_values_to_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mappings: Option<serde_json::Value>,
    #[serde(rename = "typeConversion", default, skip_serializing_if = "Option::is_none")]
    pub type_conversion: Option<serde_json::Value>,
    #[serde(rename = "typeConversionSettings", default, skip_serializing_if = "Option::is_none")]
    pub type_conversion_settings: Option<TypeConversionSettings>,
}
impl TabularTranslator {
    pub fn new(copy_translator: CopyTranslator) -> Self {
        Self {
            copy_translator,
            column_mappings: None,
            schema_mapping: None,
            collection_reference: None,
            map_complex_values_to_string: None,
            mappings: None,
            type_conversion: None,
            type_conversion_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TarGZipReadSettings {
    #[serde(flatten)]
    pub compression_read_settings: CompressionReadSettings,
    #[serde(rename = "preserveCompressionFileNameAsFolder", default, skip_serializing_if = "Option::is_none")]
    pub preserve_compression_file_name_as_folder: Option<serde_json::Value>,
}
impl TarGZipReadSettings {
    pub fn new(compression_read_settings: CompressionReadSettings) -> Self {
        Self {
            compression_read_settings,
            preserve_compression_file_name_as_folder: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TarReadSettings {
    #[serde(flatten)]
    pub compression_read_settings: CompressionReadSettings,
    #[serde(rename = "preserveCompressionFileNameAsFolder", default, skip_serializing_if = "Option::is_none")]
    pub preserve_compression_file_name_as_folder: Option<serde_json::Value>,
}
impl TarReadSettings {
    pub fn new(compression_read_settings: CompressionReadSettings) -> Self {
        Self {
            compression_read_settings,
            preserve_compression_file_name_as_folder: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: TeradataLinkedServiceTypeProperties,
}
impl TeradataLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: TeradataLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<serde_json::Value>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<teradata_linked_service_type_properties::AuthenticationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl TeradataLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod teradata_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Windows,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TeradataPartitionOption {
    None,
    Hash,
    DynamicRange,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataPartitionSettings {
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
}
impl TeradataPartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<TeradataPartitionSettings>,
}
impl TeradataSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<TeradataTableDatasetTypeProperties>,
}
impl TeradataTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataTableDatasetTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub database: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl TeradataTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TextFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
    #[serde(rename = "columnDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub column_delimiter: Option<serde_json::Value>,
    #[serde(rename = "rowDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub row_delimiter: Option<serde_json::Value>,
    #[serde(rename = "escapeChar", default, skip_serializing_if = "Option::is_none")]
    pub escape_char: Option<serde_json::Value>,
    #[serde(rename = "quoteChar", default, skip_serializing_if = "Option::is_none")]
    pub quote_char: Option<serde_json::Value>,
    #[serde(rename = "nullValue", default, skip_serializing_if = "Option::is_none")]
    pub null_value: Option<serde_json::Value>,
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[serde(rename = "treatEmptyAsNull", default, skip_serializing_if = "Option::is_none")]
    pub treat_empty_as_null: Option<serde_json::Value>,
    #[serde(rename = "skipLineCount", default, skip_serializing_if = "Option::is_none")]
    pub skip_line_count: Option<serde_json::Value>,
    #[serde(rename = "firstRowAsHeader", default, skip_serializing_if = "Option::is_none")]
    pub first_row_as_header: Option<serde_json::Value>,
}
impl TextFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self {
            dataset_storage_format,
            column_delimiter: None,
            row_delimiter: None,
            escape_char: None,
            quote_char: None,
            null_value: None,
            encoding_name: None,
            treat_empty_as_null: None,
            skip_line_count: None,
            first_row_as_header: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Transformation {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataset: Option<DatasetReference>,
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flowlet: Option<DataFlowReference>,
}
impl Transformation {
    pub fn new(name: String) -> Self {
        Self {
            name,
            description: None,
            dataset: None,
            linked_service: None,
            flowlet: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Trigger {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "runtimeState", default, skip_serializing_if = "Option::is_none")]
    pub runtime_state: Option<TriggerRuntimeState>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
}
impl Trigger {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            description: None,
            runtime_state: None,
            annotations: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerDependencyReference {
    #[serde(flatten)]
    pub dependency_reference: DependencyReference,
    #[serde(rename = "referenceTrigger")]
    pub reference_trigger: TriggerReference,
}
impl TriggerDependencyReference {
    pub fn new(dependency_reference: DependencyReference, reference_trigger: TriggerReference) -> Self {
        Self {
            dependency_reference,
            reference_trigger,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerFilterParameters {
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
    #[serde(rename = "parentTriggerName", default, skip_serializing_if = "Option::is_none")]
    pub parent_trigger_name: Option<String>,
}
impl TriggerFilterParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerListResponse {
    pub value: Vec<TriggerResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TriggerListResponse {
    pub fn new(value: Vec<TriggerResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerPipelineReference {
    #[serde(rename = "pipelineReference", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_reference: Option<PipelineReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl TriggerPipelineReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerQueryResponse {
    pub value: Vec<TriggerResource>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl TriggerQueryResponse {
    pub fn new(value: Vec<TriggerResource>) -> Self {
        Self {
            value,
            continuation_token: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerReference {
    #[serde(rename = "type")]
    pub type_: trigger_reference::Type,
    #[serde(rename = "referenceName")]
    pub reference_name: String,
}
impl TriggerReference {
    pub fn new(type_: trigger_reference::Type, reference_name: String) -> Self {
        Self { type_, reference_name }
    }
}
pub mod trigger_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        TriggerReference,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: Trigger,
}
impl TriggerResource {
    pub fn new(properties: Trigger) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerRun {
    #[serde(rename = "triggerRunId", default, skip_serializing_if = "Option::is_none")]
    pub trigger_run_id: Option<String>,
    #[serde(rename = "triggerName", default, skip_serializing_if = "Option::is_none")]
    pub trigger_name: Option<String>,
    #[serde(rename = "triggerType", default, skip_serializing_if = "Option::is_none")]
    pub trigger_type: Option<String>,
    #[serde(rename = "triggerRunTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub trigger_run_timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<trigger_run::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(rename = "triggeredPipelines", default, skip_serializing_if = "Option::is_none")]
    pub triggered_pipelines: Option<serde_json::Value>,
    #[serde(rename = "runDimension", default, skip_serializing_if = "Option::is_none")]
    pub run_dimension: Option<serde_json::Value>,
    #[serde(rename = "dependencyStatus", default, skip_serializing_if = "Option::is_none")]
    pub dependency_status: Option<serde_json::Value>,
}
impl TriggerRun {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod trigger_run {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Succeeded,
        Failed,
        Inprogress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerRunsQueryResponse {
    pub value: Vec<TriggerRun>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl TriggerRunsQueryResponse {
    pub fn new(value: Vec<TriggerRun>) -> Self {
        Self {
            value,
            continuation_token: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TriggerRuntimeState {
    Started,
    Stopped,
    Disabled,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerSubscriptionOperationStatus {
    #[serde(rename = "triggerName", default, skip_serializing_if = "Option::is_none")]
    pub trigger_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<trigger_subscription_operation_status::Status>,
}
impl TriggerSubscriptionOperationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod trigger_subscription_operation_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Provisioning,
        Deprovisioning,
        Disabled,
        Unknown,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TumblingWindowFrequency {
    Minute,
    Hour,
    Month,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TumblingWindowTrigger {
    #[serde(flatten)]
    pub trigger: Trigger,
    pub pipeline: TriggerPipelineReference,
    #[serde(rename = "typeProperties")]
    pub type_properties: tumbling_window_trigger::TypeProperties,
}
impl TumblingWindowTrigger {
    pub fn new(trigger: Trigger, pipeline: TriggerPipelineReference, type_properties: tumbling_window_trigger::TypeProperties) -> Self {
        Self {
            trigger,
            pipeline,
            type_properties,
        }
    }
}
pub mod tumbling_window_trigger {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        pub frequency: TumblingWindowFrequency,
        pub interval: i32,
        #[serde(rename = "startTime")]
        pub start_time: String,
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub delay: Option<serde_json::Value>,
        #[serde(rename = "maxConcurrency")]
        pub max_concurrency: i64,
        #[serde(rename = "retryPolicy", default, skip_serializing_if = "Option::is_none")]
        pub retry_policy: Option<RetryPolicy>,
        #[serde(rename = "dependsOn", default, skip_serializing_if = "Vec::is_empty")]
        pub depends_on: Vec<DependencyReference>,
    }
    impl TypeProperties {
        pub fn new(frequency: TumblingWindowFrequency, interval: i32, start_time: String, max_concurrency: i64) -> Self {
            Self {
                frequency,
                interval,
                start_time,
                end_time: None,
                delay: None,
                max_concurrency,
                retry_policy: None,
                depends_on: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TumblingWindowTriggerDependencyReference {
    #[serde(flatten)]
    pub trigger_dependency_reference: TriggerDependencyReference,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offset: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
}
impl TumblingWindowTriggerDependencyReference {
    pub fn new(trigger_dependency_reference: TriggerDependencyReference) -> Self {
        Self {
            trigger_dependency_reference,
            offset: None,
            size: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TypeConversionSettings {
    #[serde(rename = "allowDataTruncation", default, skip_serializing_if = "Option::is_none")]
    pub allow_data_truncation: Option<serde_json::Value>,
    #[serde(rename = "treatBooleanAsNumber", default, skip_serializing_if = "Option::is_none")]
    pub treat_boolean_as_number: Option<serde_json::Value>,
    #[serde(rename = "dateTimeFormat", default, skip_serializing_if = "Option::is_none")]
    pub date_time_format: Option<serde_json::Value>,
    #[serde(rename = "dateTimeOffsetFormat", default, skip_serializing_if = "Option::is_none")]
    pub date_time_offset_format: Option<serde_json::Value>,
    #[serde(rename = "timeSpanFormat", default, skip_serializing_if = "Option::is_none")]
    pub time_span_format: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub culture: Option<serde_json::Value>,
}
impl TypeConversionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UntilActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: UntilActivityTypeProperties,
}
impl UntilActivity {
    pub fn new(control_activity: ControlActivity, type_properties: UntilActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UntilActivityTypeProperties {
    pub expression: Expression,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<serde_json::Value>,
    pub activities: Vec<Activity>,
}
impl UntilActivityTypeProperties {
    pub fn new(expression: Expression, activities: Vec<Activity>) -> Self {
        Self {
            expression,
            timeout: None,
            activities,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateIntegrationRuntimeNodeRequest {
    #[serde(rename = "concurrentJobsLimit", default, skip_serializing_if = "Option::is_none")]
    pub concurrent_jobs_limit: Option<i64>,
}
impl UpdateIntegrationRuntimeNodeRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateIntegrationRuntimeRequest {
    #[serde(rename = "autoUpdate", default, skip_serializing_if = "Option::is_none")]
    pub auto_update: Option<IntegrationRuntimeAutoUpdate>,
    #[serde(rename = "updateDelayOffset", default, skip_serializing_if = "Option::is_none")]
    pub update_delay_offset: Option<String>,
}
impl UpdateIntegrationRuntimeRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserAccessPolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub permissions: Option<String>,
    #[serde(rename = "accessResourcePath", default, skip_serializing_if = "Option::is_none")]
    pub access_resource_path: Option<String>,
    #[serde(rename = "profileName", default, skip_serializing_if = "Option::is_none")]
    pub profile_name: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "expireTime", default, skip_serializing_if = "Option::is_none")]
    pub expire_time: Option<String>,
}
impl UserAccessPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserAssignedIdentitiesDefinitionSpecification {}
impl UserAssignedIdentitiesDefinitionSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserAssignedIdentitySpecification {}
impl UserAssignedIdentitySpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserProperty {
    pub name: String,
    pub value: serde_json::Value,
}
impl UserProperty {
    pub fn new(name: String, value: serde_json::Value) -> Self {
        Self { name, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidationActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: ValidationActivityTypeProperties,
}
impl ValidationActivity {
    pub fn new(control_activity: ControlActivity, type_properties: ValidationActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidationActivityTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sleep: Option<serde_json::Value>,
    #[serde(rename = "minimumSize", default, skip_serializing_if = "Option::is_none")]
    pub minimum_size: Option<serde_json::Value>,
    #[serde(rename = "childItems", default, skip_serializing_if = "Option::is_none")]
    pub child_items: Option<serde_json::Value>,
    pub dataset: DatasetReference,
}
impl ValidationActivityTypeProperties {
    pub fn new(dataset: DatasetReference) -> Self {
        Self {
            timeout: None,
            sleep: None,
            minimum_size: None,
            child_items: None,
            dataset,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VariableDefinitionSpecification {}
impl VariableDefinitionSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VariableSpecification {
    #[serde(rename = "type")]
    pub type_: variable_specification::Type,
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<serde_json::Value>,
}
impl VariableSpecification {
    pub fn new(type_: variable_specification::Type) -> Self {
        Self {
            type_,
            default_value: None,
        }
    }
}
pub mod variable_specification {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        String,
        Bool,
        Array,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VerticaDatasetTypeProperties {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl VerticaDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerticaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: VerticaLinkedServiceTypeProperties,
}
impl VerticaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: VerticaLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VerticaLinkedServiceTypeProperties {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl VerticaLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerticaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl VerticaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerticaTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<VerticaDatasetTypeProperties>,
}
impl VerticaTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WaitActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: WaitActivityTypeProperties,
}
impl WaitActivity {
    pub fn new(control_activity: ControlActivity, type_properties: WaitActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WaitActivityTypeProperties {
    #[serde(rename = "waitTimeInSeconds")]
    pub wait_time_in_seconds: serde_json::Value,
}
impl WaitActivityTypeProperties {
    pub fn new(wait_time_in_seconds: serde_json::Value) -> Self {
        Self { wait_time_in_seconds }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: WebActivityTypeProperties,
}
impl WebActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: WebActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebActivityAuthentication {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pfx: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
    #[serde(rename = "userTenant", default, skip_serializing_if = "Option::is_none")]
    pub user_tenant: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<CredentialReference>,
}
impl WebActivityAuthentication {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum WebActivityMethod {
    #[serde(rename = "GET")]
    Get,
    #[serde(rename = "POST")]
    Post,
    #[serde(rename = "PUT")]
    Put,
    #[serde(rename = "DELETE")]
    Delete,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebActivityTypeProperties {
    pub method: WebActivityMethod,
    pub url: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<WebActivityAuthentication>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datasets: Vec<DatasetReference>,
    #[serde(rename = "linkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_services: Vec<LinkedServiceReference>,
    #[serde(rename = "connectVia", default, skip_serializing_if = "Option::is_none")]
    pub connect_via: Option<IntegrationRuntimeReference>,
}
impl WebActivityTypeProperties {
    pub fn new(method: WebActivityMethod, url: serde_json::Value) -> Self {
        Self {
            method,
            url,
            headers: None,
            body: None,
            authentication: None,
            datasets: Vec::new(),
            linked_services: Vec::new(),
            connect_via: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebAnonymousAuthentication {
    #[serde(flatten)]
    pub web_linked_service_type_properties: WebLinkedServiceTypeProperties,
}
impl WebAnonymousAuthentication {
    pub fn new(web_linked_service_type_properties: WebLinkedServiceTypeProperties) -> Self {
        Self {
            web_linked_service_type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebBasicAuthentication {
    #[serde(flatten)]
    pub web_linked_service_type_properties: WebLinkedServiceTypeProperties,
    pub username: serde_json::Value,
    pub password: SecretBase,
}
impl WebBasicAuthentication {
    pub fn new(
        web_linked_service_type_properties: WebLinkedServiceTypeProperties,
        username: serde_json::Value,
        password: SecretBase,
    ) -> Self {
        Self {
            web_linked_service_type_properties,
            username,
            password,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebClientCertificateAuthentication {
    #[serde(flatten)]
    pub web_linked_service_type_properties: WebLinkedServiceTypeProperties,
    pub pfx: SecretBase,
    pub password: SecretBase,
}
impl WebClientCertificateAuthentication {
    pub fn new(web_linked_service_type_properties: WebLinkedServiceTypeProperties, pfx: SecretBase, password: SecretBase) -> Self {
        Self {
            web_linked_service_type_properties,
            pfx,
            password,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebHookActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[serde(rename = "typeProperties")]
    pub type_properties: WebHookActivityTypeProperties,
}
impl WebHookActivity {
    pub fn new(control_activity: ControlActivity, type_properties: WebHookActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum WebHookActivityMethod {
    #[serde(rename = "POST")]
    Post,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebHookActivityTypeProperties {
    pub method: WebHookActivityMethod,
    pub url: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<WebActivityAuthentication>,
    #[serde(rename = "reportStatusOnCallBack", default, skip_serializing_if = "Option::is_none")]
    pub report_status_on_call_back: Option<serde_json::Value>,
}
impl WebHookActivityTypeProperties {
    pub fn new(method: WebHookActivityMethod, url: serde_json::Value) -> Self {
        Self {
            method,
            url,
            timeout: None,
            headers: None,
            body: None,
            authentication: None,
            report_status_on_call_back: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: WebLinkedServiceTypeProperties,
}
impl WebLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: WebLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebLinkedServiceTypeProperties {
    pub url: serde_json::Value,
    #[serde(rename = "authenticationType")]
    pub authentication_type: web_linked_service_type_properties::AuthenticationType,
}
impl WebLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value, authentication_type: web_linked_service_type_properties::AuthenticationType) -> Self {
        Self { url, authentication_type }
    }
}
pub mod web_linked_service_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
        ClientCertificate,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl WebSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties")]
    pub type_properties: WebTableDatasetTypeProperties,
}
impl WebTableDataset {
    pub fn new(dataset: Dataset, type_properties: WebTableDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebTableDatasetTypeProperties {
    pub index: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
}
impl WebTableDatasetTypeProperties {
    pub fn new(index: serde_json::Value) -> Self {
        Self { index, path: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WranglingDataFlow {
    #[serde(flatten)]
    pub data_flow: DataFlow,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<PowerQueryTypeProperties>,
}
impl WranglingDataFlow {
    pub fn new(data_flow: DataFlow) -> Self {
        Self {
            data_flow,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XeroLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: XeroLinkedServiceTypeProperties,
}
impl XeroLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: XeroLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct XeroLinkedServiceTypeProperties {
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<serde_json::Value>,
    #[serde(rename = "consumerKey", default, skip_serializing_if = "Option::is_none")]
    pub consumer_key: Option<SecretBase>,
    #[serde(rename = "privateKey", default, skip_serializing_if = "Option::is_none")]
    pub private_key: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl XeroLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XeroObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl XeroObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XeroSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl XeroSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XmlDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<XmlDatasetTypeProperties>,
}
impl XmlDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XmlDatasetTypeProperties {
    pub location: DatasetLocation,
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[serde(rename = "nullValue", default, skip_serializing_if = "Option::is_none")]
    pub null_value: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl XmlDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            encoding_name: None,
            null_value: None,
            compression: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XmlReadSettings {
    #[serde(flatten)]
    pub format_read_settings: FormatReadSettings,
    #[serde(rename = "compressionProperties", default, skip_serializing_if = "Option::is_none")]
    pub compression_properties: Option<CompressionReadSettings>,
    #[serde(rename = "validationMode", default, skip_serializing_if = "Option::is_none")]
    pub validation_mode: Option<serde_json::Value>,
    #[serde(rename = "detectDataType", default, skip_serializing_if = "Option::is_none")]
    pub detect_data_type: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespaces: Option<serde_json::Value>,
    #[serde(rename = "namespacePrefixes", default, skip_serializing_if = "Option::is_none")]
    pub namespace_prefixes: Option<serde_json::Value>,
}
impl XmlReadSettings {
    pub fn new(format_read_settings: FormatReadSettings) -> Self {
        Self {
            format_read_settings,
            compression_properties: None,
            validation_mode: None,
            detect_data_type: None,
            namespaces: None,
            namespace_prefixes: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XmlSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<XmlReadSettings>,
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Option::is_none")]
    pub additional_columns: Option<serde_json::Value>,
}
impl XmlSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            format_settings: None,
            additional_columns: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ZipDeflateReadSettings {
    #[serde(flatten)]
    pub compression_read_settings: CompressionReadSettings,
    #[serde(rename = "preserveZipFileNameAsFolder", default, skip_serializing_if = "Option::is_none")]
    pub preserve_zip_file_name_as_folder: Option<serde_json::Value>,
}
impl ZipDeflateReadSettings {
    pub fn new(compression_read_settings: CompressionReadSettings) -> Self {
        Self {
            compression_read_settings,
            preserve_zip_file_name_as_folder: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ZohoLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[serde(rename = "typeProperties")]
    pub type_properties: ZohoLinkedServiceTypeProperties,
}
impl ZohoLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ZohoLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ZohoLinkedServiceTypeProperties {
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<serde_json::Value>,
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ZohoLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ZohoObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ZohoObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ZohoSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ZohoSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedPrivateEndpointListResponse {
    pub value: Vec<ManagedPrivateEndpointResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagedPrivateEndpointListResponse {
    pub fn new(value: Vec<ManagedPrivateEndpointResource>) -> Self {
        Self { value, next_link: None }
    }
}
