#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressSpace {
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
}
impl AddressSpace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreatedBy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub oid: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub puid: Option<String>,
    #[serde(rename = "applicationId", default, skip_serializing_if = "Option::is_none")]
    pub application_id: Option<String>,
}
impl CreatedBy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type CreatedDateTime = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Encryption {
    #[serde(rename = "keySource", default, skip_serializing_if = "Option::is_none")]
    pub key_source: Option<encryption::KeySource>,
    #[serde(rename = "KeyName", default, skip_serializing_if = "Option::is_none")]
    pub key_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keyversion: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keyvaulturi: Option<String>,
}
impl Encryption {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod encryption {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeySource {
        Default,
        #[serde(rename = "Microsoft.Keyvault")]
        MicrosoftKeyvault,
    }
    impl Default for KeySource {
        fn default() -> Self {
            Self::Default
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorDetail {
    pub code: String,
    pub message: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl ErrorDetail {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorInfo {
    pub code: String,
    pub message: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub innererror: Option<String>,
}
impl ErrorInfo {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            details: Vec::new(),
            innererror: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorResponse {
    pub error: ErrorInfo,
}
impl ErrorResponse {
    pub fn new(error: ErrorInfo) -> Self {
        Self { error }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedIdentityConfiguration {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ManagedIdentityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PeeringProvisioningState {
    Succeeded,
    Updating,
    Deleting,
    Failed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProvisioningState {
    Accepted,
    Running,
    Ready,
    Creating,
    Created,
    Deleting,
    Deleted,
    Canceled,
    Failed,
    Succeeded,
    Updating,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Sku {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
}
impl Sku {
    pub fn new(name: String) -> Self {
        Self { name, tier: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    pub location: String,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            tags: None,
            location,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkPeering {
    pub properties: VirtualNetworkPeeringPropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VirtualNetworkPeering {
    pub fn new(properties: VirtualNetworkPeeringPropertiesFormat) -> Self {
        Self {
            properties,
            name: None,
            id: None,
            type_: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkPeering>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkPeeringList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkPeeringPropertiesFormat {
    #[serde(rename = "allowVirtualNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub allow_virtual_network_access: Option<bool>,
    #[serde(rename = "allowForwardedTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_forwarded_traffic: Option<bool>,
    #[serde(rename = "allowGatewayTransit", default, skip_serializing_if = "Option::is_none")]
    pub allow_gateway_transit: Option<bool>,
    #[serde(rename = "useRemoteGateways", default, skip_serializing_if = "Option::is_none")]
    pub use_remote_gateways: Option<bool>,
    #[serde(rename = "databricksVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub databricks_virtual_network: Option<virtual_network_peering_properties_format::DatabricksVirtualNetwork>,
    #[serde(rename = "databricksAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub databricks_address_space: Option<AddressSpace>,
    #[serde(rename = "remoteVirtualNetwork")]
    pub remote_virtual_network: virtual_network_peering_properties_format::RemoteVirtualNetwork,
    #[serde(rename = "remoteAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub remote_address_space: Option<AddressSpace>,
    #[serde(rename = "peeringState", default, skip_serializing_if = "Option::is_none")]
    pub peering_state: Option<virtual_network_peering_properties_format::PeeringState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<PeeringProvisioningState>,
}
impl VirtualNetworkPeeringPropertiesFormat {
    pub fn new(remote_virtual_network: virtual_network_peering_properties_format::RemoteVirtualNetwork) -> Self {
        Self {
            allow_virtual_network_access: None,
            allow_forwarded_traffic: None,
            allow_gateway_transit: None,
            use_remote_gateways: None,
            databricks_virtual_network: None,
            databricks_address_space: None,
            remote_virtual_network,
            remote_address_space: None,
            peering_state: None,
            provisioning_state: None,
        }
    }
}
pub mod virtual_network_peering_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct DatabricksVirtualNetwork {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
    }
    impl DatabricksVirtualNetwork {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct RemoteVirtualNetwork {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
    }
    impl RemoteVirtualNetwork {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PeeringState {
        Initiated,
        Connected,
        Disconnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Workspace {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    pub properties: WorkspaceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
}
impl Workspace {
    pub fn new(tracked_resource: TrackedResource, properties: WorkspaceProperties) -> Self {
        Self {
            tracked_resource,
            properties,
            sku: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkspaceCustomBooleanParameter {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<WorkspaceCustomParameterType>,
    pub value: bool,
}
impl WorkspaceCustomBooleanParameter {
    pub fn new(value: bool) -> Self {
        Self { type_: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkspaceCustomObjectParameter {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<WorkspaceCustomParameterType>,
    pub value: serde_json::Value,
}
impl WorkspaceCustomObjectParameter {
    pub fn new(value: serde_json::Value) -> Self {
        Self { type_: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum WorkspaceCustomParameterType {
    Bool,
    Object,
    String,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceCustomParameters {
    #[serde(rename = "amlWorkspaceId", default, skip_serializing_if = "Option::is_none")]
    pub aml_workspace_id: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "customVirtualNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub custom_virtual_network_id: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "customPublicSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub custom_public_subnet_name: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "customPrivateSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub custom_private_subnet_name: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "enableNoPublicIp", default, skip_serializing_if = "Option::is_none")]
    pub enable_no_public_ip: Option<WorkspaceCustomBooleanParameter>,
    #[serde(rename = "loadBalancerBackendPoolName", default, skip_serializing_if = "Option::is_none")]
    pub load_balancer_backend_pool_name: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "loadBalancerId", default, skip_serializing_if = "Option::is_none")]
    pub load_balancer_id: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "natGatewayName", default, skip_serializing_if = "Option::is_none")]
    pub nat_gateway_name: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "publicIpName", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_name: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "prepareEncryption", default, skip_serializing_if = "Option::is_none")]
    pub prepare_encryption: Option<WorkspaceCustomBooleanParameter>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<WorkspaceEncryptionParameter>,
    #[serde(rename = "requireInfrastructureEncryption", default, skip_serializing_if = "Option::is_none")]
    pub require_infrastructure_encryption: Option<WorkspaceCustomBooleanParameter>,
    #[serde(rename = "storageAccountName", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_name: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "storageAccountSkuName", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_sku_name: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "vnetAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub vnet_address_prefix: Option<WorkspaceCustomStringParameter>,
    #[serde(rename = "resourceTags", default, skip_serializing_if = "Option::is_none")]
    pub resource_tags: Option<WorkspaceCustomObjectParameter>,
}
impl WorkspaceCustomParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkspaceCustomStringParameter {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<WorkspaceCustomParameterType>,
    pub value: String,
}
impl WorkspaceCustomStringParameter {
    pub fn new(value: String) -> Self {
        Self { type_: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceEncryptionParameter {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<WorkspaceCustomParameterType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<Encryption>,
}
impl WorkspaceEncryptionParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Workspace>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkspaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkspaceProperties {
    #[serde(rename = "managedResourceGroupId")]
    pub managed_resource_group_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<WorkspaceCustomParameters>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "uiDefinitionUri", default, skip_serializing_if = "Option::is_none")]
    pub ui_definition_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub authorizations: Vec<WorkspaceProviderAuthorization>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<CreatedBy>,
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<CreatedBy>,
    #[serde(rename = "createdDateTime", default, skip_serializing_if = "Option::is_none")]
    pub created_date_time: Option<CreatedDateTime>,
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[serde(rename = "workspaceUrl", default, skip_serializing_if = "Option::is_none")]
    pub workspace_url: Option<String>,
    #[serde(rename = "storageAccountIdentity", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_identity: Option<ManagedIdentityConfiguration>,
}
impl WorkspaceProperties {
    pub fn new(managed_resource_group_id: String) -> Self {
        Self {
            managed_resource_group_id,
            parameters: None,
            provisioning_state: None,
            ui_definition_uri: None,
            authorizations: Vec::new(),
            created_by: None,
            updated_by: None,
            created_date_time: None,
            workspace_id: None,
            workspace_url: None,
            storage_account_identity: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkspaceProviderAuthorization {
    #[serde(rename = "principalId")]
    pub principal_id: String,
    #[serde(rename = "roleDefinitionId")]
    pub role_definition_id: String,
}
impl WorkspaceProviderAuthorization {
    pub fn new(principal_id: String, role_definition_id: String) -> Self {
        Self {
            principal_id,
            role_definition_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceUpdate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl WorkspaceUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
