#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Available operations of the service"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableOperations {
    #[doc = "Collection of available operation details"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OperationDetail>,
    #[doc = "URL client should use to fetch the next page (per server side paging).\r\nIt's null for now, added for future use."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailableOperations {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka.ms/b2cBilling](https://aka.ms/b2cBilling)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct B2cResourceSku {
    #[doc = "The name of the SKU for the tenant."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<b2c_resource_sku::Name>,
    #[doc = "The tier of the tenant."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<b2c_resource_sku::Tier>,
}
impl B2cResourceSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod b2c_resource_sku {
    use super::*;
    #[doc = "The name of the SKU for the tenant."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Standard,
        PremiumP1,
        PremiumP2,
    }
    #[doc = "The tier of the tenant."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        A0,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct B2cTenantResource {
    #[doc = "The type of the B2C tenant resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<b2c_tenant_resource::Type>,
    #[doc = "SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka.ms/b2cBilling](https://aka.ms/b2cBilling)."]
    pub sku: B2cResourceSku,
    #[doc = "Properties of the Azure AD B2C tenant Azure resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<B2cTenantResourceProperties>,
    #[doc = "An identifier that represents the Azure AD B2C tenant resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the Azure AD B2C tenant resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/B2CDataResidency) for more information."]
    pub location: String,
    #[doc = "Resource Tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl B2cTenantResource {
    pub fn new(sku: B2cResourceSku, location: String) -> Self {
        Self {
            type_: None,
            sku,
            properties: None,
            id: None,
            name: None,
            location,
            tags: None,
            system_data: None,
        }
    }
}
pub mod b2c_tenant_resource {
    use super::*;
    #[doc = "The type of the B2C tenant resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.AzureActiveDirectory/b2cDirectories")]
        MicrosoftAzureActiveDirectoryB2cDirectories,
    }
}
#[doc = "The collection of Azure AD B2C tenant resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct B2cTenantResourceList {
    #[doc = "List of Azure AD B2C tenant resources"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<B2cTenantResource>,
}
impl B2cTenantResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the Azure AD B2C tenant Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct B2cTenantResourceProperties {
    #[doc = "The billing configuration for the tenant."]
    #[serde(rename = "billingConfig", default, skip_serializing_if = "Option::is_none")]
    pub billing_config: Option<b2c_tenant_resource_properties::BillingConfig>,
    #[doc = "An identifier of the Azure AD B2C tenant."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl B2cTenantResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod b2c_tenant_resource_properties {
    use super::*;
    #[doc = "The billing configuration for the tenant."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct BillingConfig {
        #[doc = "The type of billing. Will be MAU for all new customers. If 'Auths', it can be updated to 'MAU'. Cannot be changed if value is 'MAU'. Learn more about Azure AD B2C billing at [aka.ms/b2cBilling](https://aka.ms/b2cbilling)."]
        #[serde(rename = "billingType", default, skip_serializing_if = "Option::is_none")]
        pub billing_type: Option<billing_config::BillingType>,
        #[doc = "The data from which the billing type took effect"]
        #[serde(rename = "effectiveStartDateUtc", default, skip_serializing_if = "Option::is_none")]
        pub effective_start_date_utc: Option<String>,
    }
    impl BillingConfig {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod billing_config {
        use super::*;
        #[doc = "The type of billing. Will be MAU for all new customers. If 'Auths', it can be updated to 'MAU'. Cannot be changed if value is 'MAU'. Learn more about Azure AD B2C billing at [aka.ms/b2cBilling](https://aka.ms/b2cbilling)."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum BillingType {
            #[serde(rename = "MAU")]
            Mau,
            Auths,
        }
    }
}
#[doc = "The request body to update the Azure AD B2C tenant resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct B2cTenantUpdateRequest {
    #[doc = "SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka.ms/b2cBilling](https://aka.ms/b2cBilling)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<B2cResourceSku>,
    #[doc = "Properties of the Azure AD B2C tenant Azure resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<B2cTenantResourceProperties>,
    #[doc = "Resource Tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl B2cTenantUpdateRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The information required to check the availability of the name for the tenant."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckNameAvailabilityRequestBody {
    #[doc = "The domain name to check for availability."]
    pub name: String,
    #[doc = "Country code of Azure tenant (e.g. 'US'). Refer to [aka.ms/B2CDataResidency](https://aka.ms/B2CDataResidency) to see valid country codes and corresponding data residency locations. If you do not see a country code in an valid data residency location, choose one from the list."]
    #[serde(rename = "countryCode")]
    pub country_code: CountryCode,
}
impl CheckNameAvailabilityRequestBody {
    pub fn new(name: String, country_code: CountryCode) -> Self {
        Self { name, country_code }
    }
}
#[doc = "An error response for a resource management request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type CountryCode = String;
#[doc = "These properties are used to create the Azure AD B2C tenant. These properties are not part of the Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateTenantProperties {
    #[doc = "The display name of the Azure AD B2C tenant."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Country code of Azure tenant (e.g. 'US'). Refer to [aka.ms/B2CDataResidency](https://aka.ms/B2CDataResidency) to see valid country codes and corresponding data residency locations. If you do not see a country code in an valid data residency location, choose one from the list."]
    #[serde(rename = "countryCode", default, skip_serializing_if = "Option::is_none")]
    pub country_code: Option<CountryCode>,
}
impl CreateTenantProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The information needed to create the Azure AD B2C tenant and corresponding Azure resource, which is used for billing purposes."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateTenantRequestBody {
    #[doc = "The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/B2CDataResidency) for more information."]
    pub location: String,
    pub properties: create_tenant_request_body::Properties,
    #[doc = "SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka.ms/b2cBilling](https://aka.ms/b2cBilling)."]
    pub sku: B2cResourceSku,
    #[doc = "Resource Tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl CreateTenantRequestBody {
    pub fn new(location: String, properties: create_tenant_request_body::Properties, sku: B2cResourceSku) -> Self {
        Self {
            location,
            properties,
            sku,
            tags: None,
        }
    }
}
pub mod create_tenant_request_body {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "These properties are used to create the Azure AD B2C tenant. These properties are not part of the Azure resource."]
        #[serde(rename = "createTenantProperties", default, skip_serializing_if = "Option::is_none")]
        pub create_tenant_properties: Option<CreateTenantProperties>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorResponse>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Guest Usages Resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestUsagesResource {
    #[doc = "An identifier that represents the Guest Usages resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the Guest Usages resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the Guest Usages resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Location of the Guest Usages resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Key-value pairs of additional resource provisioning properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Guest Usages Resource Properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GuestUsagesResourceProperties>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl GuestUsagesResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The collection of guest usages resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestUsagesResourceList {
    #[doc = "List of guest usages resources"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GuestUsagesResource>,
}
impl GuestUsagesResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Guest Usages Resource for Patch"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestUsagesResourcePatch {
    #[doc = "Key-value pairs of additional resource provisioning properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl GuestUsagesResourcePatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Guest Usages Resource Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestUsagesResourceProperties {
    #[doc = "An identifier for the tenant for which the resource is being created"]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl GuestUsagesResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the reason for the 'nameAvailable' value."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum NameAvailabilityReason {
    AlreadyExists,
    Invalid,
}
#[doc = "Response of the CheckNameAvailability operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameAvailabilityResponse {
    #[doc = "Description of the reason if name is not available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "True if the name is available and can be used to create a new tenant. Otherwise false."]
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[doc = "Describes the reason for the 'nameAvailable' value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<NameAvailabilityReason>,
}
impl NameAvailabilityResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Operation detail payload"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDetail {
    #[doc = "Name of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Indicates whether the operation is a data action"]
    #[serde(rename = "isDataAction", default, skip_serializing_if = "Option::is_none")]
    pub is_data_action: Option<bool>,
    #[doc = "Operation display payload"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationDisplay>,
    #[doc = "Origin of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
}
impl OperationDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Operation display payload"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDisplay {
    #[doc = "Resource provider of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "Resource of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[doc = "Localized friendly name for the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "Localized friendly description for the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metadata pertaining to creation and last modification of the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[doc = "The identity that created the resource."]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[doc = "The type of identity that created the resource."]
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[doc = "The timestamp of resource creation (UTC)."]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "The identity that last modified the resource."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[doc = "The timestamp of resource last modification (UTC)"]
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[doc = "The type of identity that created the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[doc = "The type of identity that last modified the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
