#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The check eligibility Connector credentials definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckEligibilityDefinition {
    #[doc = "Connector kind (eg aws)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Credentials authentication key (eg AWS ARN)"]
    #[serde(rename = "credentialsKey", default, skip_serializing_if = "Option::is_none")]
    pub credentials_key: Option<String>,
    #[doc = "Credentials secret (eg AWS ExternalId)"]
    #[serde(rename = "credentialsSecret", default, skip_serializing_if = "Option::is_none")]
    pub credentials_secret: Option<String>,
    #[doc = "Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)"]
    #[serde(rename = "reportId", default, skip_serializing_if = "Option::is_none")]
    pub report_id: Option<String>,
}
impl CheckEligibilityDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details of any error encountered on last collection attempt"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorCollectionErrorInfo {
    #[doc = "Detailed error message"]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[doc = "External Provider error message"]
    #[serde(rename = "errorInnerMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_inner_message: Option<String>,
    #[doc = "Short error code"]
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[doc = "Time the error started occurring (Last time error occurred in lastChecked)"]
    #[serde(rename = "errorStartTime", default, skip_serializing_if = "Option::is_none")]
    pub error_start_time: Option<String>,
}
impl ConnectorCollectionErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection and ingestion information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorCollectionInfo {
    #[doc = "Last time the data acquisition process initiated connecting to the external provider"]
    #[serde(rename = "lastChecked", default, skip_serializing_if = "Option::is_none")]
    pub last_checked: Option<String>,
    #[doc = "Source timestamp of external data currently available in Azure (eg AWS last processed CUR file timestamp)"]
    #[serde(rename = "sourceLastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub source_last_updated: Option<String>,
    #[doc = "Last time the external data was updated into Azure"]
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[doc = "Details of any error encountered on last collection attempt"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ConnectorCollectionErrorInfo>,
}
impl ConnectorCollectionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Connector model definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorDefinition {
    #[doc = "Connector kind (eg aws)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Connector id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Connector name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Connector type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The properties of a Connector"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectorProperties>,
}
impl ConnectorDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of listing connector definitions. It contains a list of available connector definitions in the scope provided."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorDefinitionListResult {
    #[doc = "The list of connector definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConnectorDefinition>,
}
impl ConnectorDefinitionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a Connector"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorProperties {
    #[doc = "Connector DisplayName"]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Connector providerBillingAccountId, determined from credentials (eg AWS Consolidated account number)"]
    #[serde(rename = "providerBillingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub provider_billing_account_id: Option<String>,
    #[doc = "The display name of the providerBillingAccountId as defined on the external provider"]
    #[serde(rename = "providerBillingAccountDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub provider_billing_account_display_name: Option<String>,
    #[doc = "Credentials authentication key (eg AWS ARN)"]
    #[serde(rename = "credentialsKey", default, skip_serializing_if = "Option::is_none")]
    pub credentials_key: Option<String>,
    #[doc = "Credentials secret (eg AWS ExternalId)"]
    #[serde(rename = "credentialsSecret", default, skip_serializing_if = "Option::is_none")]
    pub credentials_secret: Option<String>,
    #[doc = "Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)"]
    #[serde(rename = "reportId", default, skip_serializing_if = "Option::is_none")]
    pub report_id: Option<String>,
    #[doc = "Connector definition creation datetime"]
    #[serde(rename = "createdOn", default, skip_serializing_if = "Option::is_none")]
    pub created_on: Option<String>,
    #[doc = "Connector last modified datetime"]
    #[serde(rename = "modifiedOn", default, skip_serializing_if = "Option::is_none")]
    pub modified_on: Option<String>,
    #[doc = "Connector status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<connector_properties::Status>,
    #[doc = "Associated ExternalBillingAccountId"]
    #[serde(rename = "externalBillingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub external_billing_account_id: Option<String>,
    #[doc = "Default ManagementGroupId"]
    #[serde(rename = "defaultManagementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub default_management_group_id: Option<String>,
    #[doc = "Billing SubscriptionId"]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "Connector billing model"]
    #[serde(rename = "billingModel", default, skip_serializing_if = "Option::is_none")]
    pub billing_model: Option<connector_properties::BillingModel>,
    #[doc = "Number of days remaining of trial"]
    #[serde(rename = "daysTrialRemaining", default, skip_serializing_if = "Option::is_none")]
    pub days_trial_remaining: Option<i64>,
    #[doc = "Collection and ingestion information"]
    #[serde(rename = "collectionInfo", default, skip_serializing_if = "Option::is_none")]
    pub collection_info: Option<ConnectorCollectionInfo>,
}
impl ConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connector_properties {
    use super::*;
    #[doc = "Connector status"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "active")]
        Active,
        #[serde(rename = "error")]
        Error,
        #[serde(rename = "expired")]
        Expired,
        #[serde(rename = "warning")]
        Warning,
    }
    #[doc = "Connector billing model"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BillingModel {
        #[serde(rename = "trial")]
        Trial,
        #[serde(rename = "autoUpgrade")]
        AutoUpgrade,
        #[serde(rename = "premium")]
        Premium,
        #[serde(rename = "expired")]
        Expired,
    }
}
#[doc = "Represents CostAllocation showback rule model"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CostAllocationDetails {
    #[doc = "Cost allocation policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub policy: Option<cost_allocation_details::Policy>,
}
impl CostAllocationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod cost_allocation_details {
    use super::*;
    #[doc = "Cost allocation policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Policy {
        Proportional,
        Evenly,
        Fixed,
    }
}
#[doc = "Represents CostAllocation showback rule model"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CostAllocationDetailsKind {
    #[serde(flatten)]
    pub showback_rule_properties: ShowbackRuleProperties,
    #[doc = "Represents CostAllocation showback rule model"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<CostAllocationDetails>,
}
impl CostAllocationDetailsKind {
    pub fn new(showback_rule_properties: ShowbackRuleProperties) -> Self {
        Self {
            showback_rule_properties,
            details: None,
        }
    }
}
#[doc = "Represents Custom price showback rule model"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomPriceDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pricesheet: Option<String>,
    #[doc = "Array of benefits."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub benefits: Vec<String>,
    #[doc = "List of markups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub markups: Vec<Markup>,
}
impl CustomPriceDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents Custom price showback rule model"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomPriceDetailsKind {
    #[serde(flatten)]
    pub showback_rule_properties: ShowbackRuleProperties,
    #[doc = "Represents Custom price showback rule model"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<CustomPriceDetails>,
}
impl CustomPriceDetailsKind {
    pub fn new(showback_rule_properties: ShowbackRuleProperties) -> Self {
        Self {
            showback_rule_properties,
            details: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DimensionProperties>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DimensionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "filterEnabled", default, skip_serializing_if = "Option::is_none")]
    pub filter_enabled: Option<bool>,
    #[serde(rename = "groupingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub grouping_enabled: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub data: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(rename = "usageStart", default, skip_serializing_if = "Option::is_none")]
    pub usage_start: Option<String>,
    #[serde(rename = "usageEnd", default, skip_serializing_if = "Option::is_none")]
    pub usage_end: Option<String>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DimensionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of listing dimensions. It contains a list of available dimensions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DimensionsListResult {
    #[doc = "The list of dimensions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Dimension>,
}
impl DimensionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The details of the error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorBase {
    #[doc = "A machine readable error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "A human readable error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "Indicates which property in the request is responsible for the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl ErrorBase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The details of the error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[doc = "A machine readable error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "A human readable error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "Indicates which property in the request is responsible for the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorBase>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Error response indicates that the service is not able to process the incoming request. The reason is provided in the error message."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "The details of the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetails>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The ExternalBillingAccount model definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalBillingAccountDefinition {
    #[doc = "ExternalBillingAccount id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "ExternalBillingAccount name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "ExternalBillingAccount type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "ExternalBillingAccount kind (eg aws)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "The properties of a ExternalBillingAccount"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExternalBillingAccountProperties>,
}
impl ExternalBillingAccountDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of listing ExternalBillingAccount definitions. It contains a list of available ExternalBillingAccount definitions in the scope provided."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalBillingAccountDefinitionListResult {
    #[doc = "The list of ExternalBillingAccount definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExternalBillingAccountDefinition>,
}
impl ExternalBillingAccountDefinitionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a ExternalBillingAccount"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalBillingAccountProperties {
    #[doc = "ExternalBillingAccount DisplayName"]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Provider BillingAccountId (eg AWS Consolidated Account number)"]
    #[serde(rename = "providerBillingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub provider_billing_account_id: Option<String>,
    #[doc = "Underlying ConnectorId"]
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[doc = "Collection and ingestion information"]
    #[serde(rename = "collectionInfo", default, skip_serializing_if = "Option::is_none")]
    pub collection_info: Option<ConnectorCollectionInfo>,
}
impl ExternalBillingAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The ExternalSubscription model definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSubscriptionDefinition {
    #[doc = "ExternalSubscription id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "ExternalSubscription name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "ExternalSubscription type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "ExternalSubscription kind (eg aws)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "The properties of a ExternalSubscription"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExternalSubscriptionProperties>,
}
impl ExternalSubscriptionDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of listing ExternalSubscription definitions. It contains a list of available ExternalSubscription definitions in the scope provided."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSubscriptionDefinitionListResult {
    #[doc = "The list of ExternalSubscription definitions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExternalSubscriptionDefinition>,
}
impl ExternalSubscriptionDefinitionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The list of ExternalSubscriptionIds operation request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSubscriptionIdListRequest {
    #[doc = "The list of ExternalSubscriptionIds."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<String>,
}
impl ExternalSubscriptionIdListRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a ExternalSubscription"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSubscriptionProperties {
    #[doc = "ExternalSubscription DisplayName"]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Assigned ManagementGroupId"]
    #[serde(rename = "managementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub management_group_id: Option<String>,
    #[doc = "Provider BillingAccountId (eg AWS Consolidated Account number)"]
    #[serde(rename = "providerBillingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub provider_billing_account_id: Option<String>,
    #[doc = "Provider AccountId (eg AWS Linked Account number)"]
    #[serde(rename = "providerAccountId", default, skip_serializing_if = "Option::is_none")]
    pub provider_account_id: Option<String>,
    #[doc = "Parent ExternalBillingAccountId"]
    #[serde(rename = "externalBillingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub external_billing_account_id: Option<String>,
    #[doc = "Collection and ingestion information"]
    #[serde(rename = "collectionInfo", default, skip_serializing_if = "Option::is_none")]
    pub collection_info: Option<ConnectorCollectionInfo>,
}
impl ExternalSubscriptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Markup model definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Markup {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub percentage: Option<String>,
}
impl Markup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Cost management REST API operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The object that represents the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "The object that represents the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Service provider: Microsoft.CostManagement."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource on which the operation is performed: Dimensions, Query."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Operation type: Read, write, delete, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result of listing cost management operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of cost management operations supported by the Microsoft.CostManagement resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Query {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<QueryProperties>,
}
impl Query {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryColumn {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl QueryColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryProperties {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of columns"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<QueryColumn>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rows: Vec<Vec<serde_json::Value>>,
}
impl QueryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of query. It contains all columns listed under groupings and aggregation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryResult {
    #[doc = "The list of usage data."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Query>,
}
impl QueryResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The aggregation expression to be used in the report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReportConfigAggregation {
    #[doc = "The name of the column to aggregate."]
    pub name: String,
    #[doc = "The name of the aggregation function to use."]
    pub function: report_config_aggregation::Function,
}
impl ReportConfigAggregation {
    pub fn new(name: String, function: report_config_aggregation::Function) -> Self {
        Self { name, function }
    }
}
pub mod report_config_aggregation {
    use super::*;
    #[doc = "The name of the aggregation function to use."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Function {
        Sum,
    }
}
#[doc = "The type of the column in the report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ReportConfigColumnType {
    Tag,
    Dimension,
}
#[doc = "The comparison expression to be used in the report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReportConfigComparisonExpression {
    #[doc = "The name of the column to use in comparison."]
    pub name: String,
    #[doc = "The operator to use for comparison."]
    pub operator: report_config_comparison_expression::Operator,
    #[doc = "Array of values to use for comparison"]
    pub values: Vec<String>,
}
impl ReportConfigComparisonExpression {
    pub fn new(name: String, operator: report_config_comparison_expression::Operator, values: Vec<String>) -> Self {
        Self { name, operator, values }
    }
}
pub mod report_config_comparison_expression {
    use super::*;
    #[doc = "The operator to use for comparison."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        In,
        Contains,
    }
}
#[doc = "The definition of data present in the report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReportConfigDataset {
    #[doc = "The granularity of rows in the report."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub granularity: Option<report_config_dataset::Granularity>,
    #[doc = "The configuration of dataset in the report."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub configuration: Option<ReportConfigDatasetConfiguration>,
    #[doc = "Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub aggregation: Option<serde_json::Value>,
    #[doc = "Array of group by expression to use in the report. Report can have up to 2 group by clauses."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub grouping: Vec<ReportConfigGrouping>,
    #[doc = "Array of order by expression to use in the report."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sorting: Vec<ReportConfigSorting>,
    #[doc = "The filter expression to be used in the report."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<ReportConfigFilter>,
}
impl ReportConfigDataset {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod report_config_dataset {
    use super::*;
    #[doc = "The granularity of rows in the report."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Granularity {
        Daily,
        Monthly,
    }
}
#[doc = "The configuration of dataset in the report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReportConfigDatasetConfiguration {
    #[doc = "Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<String>,
}
impl ReportConfigDatasetConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The definition of a report config."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReportConfigDefinition {
    #[doc = "The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates."]
    #[serde(rename = "type")]
    pub type_: report_config_definition::Type,
    #[doc = "The time frame for pulling data for the report. If custom, then a specific time period must be provided."]
    pub timeframe: report_config_definition::Timeframe,
    #[doc = "The start and end date for pulling data for the report."]
    #[serde(rename = "timePeriod", default, skip_serializing_if = "Option::is_none")]
    pub time_period: Option<ReportConfigTimePeriod>,
    #[doc = "The definition of data present in the report."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataset: Option<ReportConfigDataset>,
}
impl ReportConfigDefinition {
    pub fn new(type_: report_config_definition::Type, timeframe: report_config_definition::Timeframe) -> Self {
        Self {
            type_,
            timeframe,
            time_period: None,
            dataset: None,
        }
    }
}
pub mod report_config_definition {
    use super::*;
    #[doc = "The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Usage,
    }
    #[doc = "The time frame for pulling data for the report. If custom, then a specific time period must be provided."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Timeframe {
        WeekToDate,
        MonthToDate,
        YearToDate,
        Custom,
    }
}
#[doc = "The filter expression to be used in the report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReportConfigFilter {
    #[doc = "The logical \"AND\" expression. Must have at least 2 items."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub and: Vec<ReportConfigFilter>,
    #[doc = "The logical \"OR\" expression. Must have at least 2 items."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub or: Vec<ReportConfigFilter>,
    #[doc = "The filter expression to be used in the report."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub not: Box<Option<ReportConfigFilter>>,
    #[doc = "The comparison expression to be used in the report."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dimension: Option<ReportConfigComparisonExpression>,
    #[doc = "The comparison expression to be used in the report."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<ReportConfigComparisonExpression>,
}
impl ReportConfigFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The group by expression to be used in the report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReportConfigGrouping {
    #[doc = "The type of the column in the report."]
    #[serde(rename = "type")]
    pub type_: ReportConfigColumnType,
    #[doc = "The name of the column to group. This version supports subscription lowest possible grain."]
    pub name: String,
}
impl ReportConfigGrouping {
    pub fn new(type_: ReportConfigColumnType, name: String) -> Self {
        Self { type_, name }
    }
}
#[doc = "The order by expression to be used in the report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReportConfigSorting {
    #[doc = "Direction of sort."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<report_config_sorting::Direction>,
    #[doc = "The name of the column to sort."]
    pub name: String,
}
impl ReportConfigSorting {
    pub fn new(name: String) -> Self {
        Self { direction: None, name }
    }
}
pub mod report_config_sorting {
    use super::*;
    #[doc = "Direction of sort."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Ascending,
        Descending,
    }
}
#[doc = "The start and end date for pulling data for the report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReportConfigTimePeriod {
    #[doc = "The start date to pull data from."]
    pub from: String,
    #[doc = "The end date to pull data to."]
    pub to: String,
}
impl ReportConfigTimePeriod {
    pub fn new(from: String, to: String) -> Self {
        Self { from, to }
    }
}
#[doc = "The Resource model definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Scope model definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Scope {
    #[doc = "Scope id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Scope name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Scope type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The Scope model definition"]
    #[serde(rename = "childScope", default, skip_serializing_if = "Option::is_none")]
    pub child_scope: Box<Option<Scope>>,
}
impl Scope {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The showback rule model definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShowbackRule {
    #[doc = "Rule id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Rule name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Rule type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The properties of a showback rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ShowbackRuleProperties>,
}
impl ShowbackRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of listing showback rules. It contains a list of available rules in the scope provided."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShowbackRuleListResult {
    #[doc = "The list of showback rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ShowbackRule>,
}
impl ShowbackRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a showback rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShowbackRuleProperties {
    #[doc = "Description of a showback rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The current status of the showback rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<showback_rule_properties::Status>,
    #[doc = "The current version of showback rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
    #[doc = "List of authorized assigned scopes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub scopes: Vec<Scope>,
    #[doc = "The time when the showback rule was created."]
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[doc = "The current time when showback rule was deprecate."]
    #[serde(rename = "deprecationTime", default, skip_serializing_if = "Option::is_none")]
    pub deprecation_time: Option<String>,
    #[doc = "The current status when showback rule was modified."]
    #[serde(rename = "modificationTime", default, skip_serializing_if = "Option::is_none")]
    pub modification_time: Option<String>,
    #[doc = "The rule type of the showback rule solution."]
    #[serde(rename = "ruleType")]
    pub rule_type: showback_rule_properties::RuleType,
}
impl ShowbackRuleProperties {
    pub fn new(rule_type: showback_rule_properties::RuleType) -> Self {
        Self {
            description: None,
            status: None,
            version: None,
            scopes: Vec::new(),
            creation_time: None,
            deprecation_time: None,
            modification_time: None,
            rule_type,
        }
    }
}
pub mod showback_rule_properties {
    use super::*;
    #[doc = "The current status of the showback rule."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        NotActive,
        Active,
    }
    #[doc = "The rule type of the showback rule solution."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleType {
        CustomPrice,
        CostAllocation,
    }
}
