#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The common properties of the export."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonExportProperties {
    #[doc = "The format of the export being delivered."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<common_export_properties::Format>,
    #[doc = "The delivery information associated with a export."]
    #[serde(rename = "deliveryInfo")]
    pub delivery_info: ExportDeliveryInfo,
    #[doc = "The definition of a query."]
    pub definition: QueryDefinition,
}
impl CommonExportProperties {
    pub fn new(delivery_info: ExportDeliveryInfo, definition: QueryDefinition) -> Self {
        Self {
            format: None,
            delivery_info,
            definition,
        }
    }
}
pub mod common_export_properties {
    use super::*;
    #[doc = "The format of the export being delivered."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Format {
        Csv,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DimensionProperties>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DimensionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "filterEnabled", default, skip_serializing_if = "Option::is_none")]
    pub filter_enabled: Option<bool>,
    #[serde(rename = "groupingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub grouping_enabled: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub data: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(rename = "usageStart", default, skip_serializing_if = "Option::is_none")]
    pub usage_start: Option<String>,
    #[serde(rename = "usageEnd", default, skip_serializing_if = "Option::is_none")]
    pub usage_end: Option<String>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DimensionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of listing dimensions. It contains a list of available dimensions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DimensionsListResult {
    #[doc = "The list of dimensions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Dimension>,
}
impl DimensionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The details of the error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[doc = "Error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message indicating why the operation failed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Error response indicates that the service is not able to process the incoming request. The reason is provided in the error message."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "The details of the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetails>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A export resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Export {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of the export."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExportProperties>,
}
impl Export {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The destination information for the delivery of the export."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportDeliveryDestination {
    #[doc = "The resource id of the storage account where exports will be delivered."]
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[doc = "The name of the container where exports will be uploaded."]
    pub container: String,
    #[doc = "The name of the directory where exports will be uploaded."]
    #[serde(rename = "rootFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub root_folder_path: Option<String>,
}
impl ExportDeliveryDestination {
    pub fn new(resource_id: String, container: String) -> Self {
        Self {
            resource_id,
            container,
            root_folder_path: None,
        }
    }
}
#[doc = "The delivery information associated with a export."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportDeliveryInfo {
    #[doc = "The destination information for the delivery of the export."]
    pub destination: ExportDeliveryDestination,
}
impl ExportDeliveryInfo {
    pub fn new(destination: ExportDeliveryDestination) -> Self {
        Self { destination }
    }
}
#[doc = "A export execution."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportExecution {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of the export execution."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExportExecutionProperties>,
}
impl ExportExecution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of listing exports execution history of a export by name"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportExecutionListResult {
    #[doc = "The list of export executions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExportExecution>,
}
impl ExportExecutionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of the export execution."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportExecutionProperties {
    #[doc = "The type of the export execution."]
    #[serde(rename = "executionType", default, skip_serializing_if = "Option::is_none")]
    pub execution_type: Option<export_execution_properties::ExecutionType>,
    #[doc = "The status of the export execution."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<export_execution_properties::Status>,
    #[doc = "The identifier for the entity that executed the export. For OnDemand executions, it is the email id. For Scheduled executions, it is the constant value - System."]
    #[serde(rename = "submittedBy", default, skip_serializing_if = "Option::is_none")]
    pub submitted_by: Option<String>,
    #[doc = "The time when export was queued to be executed."]
    #[serde(rename = "submittedTime", default, skip_serializing_if = "Option::is_none")]
    pub submitted_time: Option<String>,
    #[doc = "The time when export was picked up to be executed."]
    #[serde(rename = "processingStartTime", default, skip_serializing_if = "Option::is_none")]
    pub processing_start_time: Option<String>,
    #[doc = "The time when export execution finished."]
    #[serde(rename = "processingEndTime", default, skip_serializing_if = "Option::is_none")]
    pub processing_end_time: Option<String>,
    #[doc = "The name of the file export got written to."]
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<String>,
    #[doc = "The common properties of the export."]
    #[serde(rename = "runSettings", default, skip_serializing_if = "Option::is_none")]
    pub run_settings: Option<CommonExportProperties>,
}
impl ExportExecutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod export_execution_properties {
    use super::*;
    #[doc = "The type of the export execution."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ExecutionType {
        OnDemand,
        Scheduled,
    }
    #[doc = "The status of the export execution."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Queued,
        InProgress,
        Completed,
        Failed,
        Timeout,
        NewDataNotAvailable,
        DataNotAvailable,
    }
}
#[doc = "Result of listing exports. It contains a list of available exports in the scope provided."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportListResult {
    #[doc = "The list of exports."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Export>,
}
impl ExportListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of the export."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportProperties {
    #[serde(flatten)]
    pub common_export_properties: CommonExportProperties,
    #[doc = "The schedule associated with a export."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<ExportSchedule>,
}
impl ExportProperties {
    pub fn new(common_export_properties: CommonExportProperties) -> Self {
        Self {
            common_export_properties,
            schedule: None,
        }
    }
}
#[doc = "The start and end date for recurrence schedule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportRecurrencePeriod {
    #[doc = "The start date of recurrence."]
    pub from: String,
    #[doc = "The end date of recurrence."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub to: Option<String>,
}
impl ExportRecurrencePeriod {
    pub fn new(from: String) -> Self {
        Self { from, to: None }
    }
}
#[doc = "The schedule associated with a export."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportSchedule {
    #[doc = "The status of the schedule. Whether active or not. If inactive, the export's scheduled execution is paused."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<export_schedule::Status>,
    #[doc = "The schedule recurrence."]
    pub recurrence: export_schedule::Recurrence,
    #[doc = "The start and end date for recurrence schedule."]
    #[serde(rename = "recurrencePeriod", default, skip_serializing_if = "Option::is_none")]
    pub recurrence_period: Option<ExportRecurrencePeriod>,
}
impl ExportSchedule {
    pub fn new(recurrence: export_schedule::Recurrence) -> Self {
        Self {
            status: None,
            recurrence,
            recurrence_period: None,
        }
    }
}
pub mod export_schedule {
    use super::*;
    #[doc = "The status of the schedule. Whether active or not. If inactive, the export's scheduled execution is paused."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Active,
        Inactive,
    }
    #[doc = "The schedule recurrence."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Recurrence {
        Daily,
        Weekly,
        Monthly,
        Annually,
    }
}
#[doc = "A Cost management REST API operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The object that represents the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "The object that represents the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Service provider: Microsoft.CostManagement."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource on which the operation is performed: Dimensions, Query."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Operation type: Read, write, delete, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result of listing cost management operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of cost management operations supported by the Microsoft.CostManagement resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Query {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<QueryProperties>,
}
impl Query {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The aggregation expression to be used in the query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryAggregation {
    #[doc = "The name of the column to aggregate."]
    pub name: String,
    #[doc = "The name of the aggregation function to use."]
    pub function: query_aggregation::Function,
}
impl QueryAggregation {
    pub fn new(name: String, function: query_aggregation::Function) -> Self {
        Self { name, function }
    }
}
pub mod query_aggregation {
    use super::*;
    #[doc = "The name of the aggregation function to use."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Function {
        Sum,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryColumn {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl QueryColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The type of the column in the export."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum QueryColumnType {
    Tag,
    Dimension,
}
#[doc = "The comparison expression to be used in the query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryComparisonExpression {
    #[doc = "The name of the column to use in comparison."]
    pub name: String,
    #[doc = "The operator to use for comparison."]
    pub operator: query_comparison_expression::Operator,
    #[doc = "Array of values to use for comparison"]
    pub values: Vec<String>,
}
impl QueryComparisonExpression {
    pub fn new(name: String, operator: query_comparison_expression::Operator, values: Vec<String>) -> Self {
        Self { name, operator, values }
    }
}
pub mod query_comparison_expression {
    use super::*;
    #[doc = "The operator to use for comparison."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        In,
    }
}
#[doc = "The definition of data present in the query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryDataset {
    #[doc = "The granularity of rows in the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub granularity: Option<query_dataset::Granularity>,
    #[doc = "The configuration of dataset in the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub configuration: Option<QueryDatasetConfiguration>,
    #[doc = "Dictionary of aggregation expression to use in the query. The key of each item in the dictionary is the alias for the aggregated column. Query can have up to 2 aggregation clauses."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub aggregation: Option<serde_json::Value>,
    #[doc = "Array of group by expression to use in the query. Query can have up to 2 group by clauses."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub grouping: Vec<QueryGrouping>,
    #[doc = "Array of sorting by columns in query."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sorting: Vec<QuerySortingConfiguration>,
    #[doc = "The filter expression to be used in the export."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<QueryFilter>,
}
impl QueryDataset {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod query_dataset {
    use super::*;
    #[doc = "The granularity of rows in the query."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Granularity {
        Daily,
        Hourly,
    }
}
#[doc = "The configuration of dataset in the query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryDatasetConfiguration {
    #[doc = "Array of column names to be included in the query. Any valid query column name is allowed. If not provided, then query includes all columns."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<String>,
}
impl QueryDatasetConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The definition of a query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryDefinition {
    #[doc = "The type of the query."]
    #[serde(rename = "type")]
    pub type_: query_definition::Type,
    #[doc = "The time frame for pulling data for the query. If custom, then a specific time period must be provided."]
    pub timeframe: query_definition::Timeframe,
    #[doc = "The start and end date for pulling data for the query."]
    #[serde(rename = "timePeriod", default, skip_serializing_if = "Option::is_none")]
    pub time_period: Option<QueryTimePeriod>,
    #[doc = "The definition of data present in the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataset: Option<QueryDataset>,
}
impl QueryDefinition {
    pub fn new(type_: query_definition::Type, timeframe: query_definition::Timeframe) -> Self {
        Self {
            type_,
            timeframe,
            time_period: None,
            dataset: None,
        }
    }
}
pub mod query_definition {
    use super::*;
    #[doc = "The type of the query."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Usage,
    }
    #[doc = "The time frame for pulling data for the query. If custom, then a specific time period must be provided."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Timeframe {
        WeekToDate,
        MonthToDate,
        YearToDate,
        TheLastWeek,
        TheLastMonth,
        TheLastYear,
        Custom,
    }
}
#[doc = "The filter expression to be used in the export."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryFilter {
    #[doc = "The logical \"AND\" expression. Must have at least 2 items."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub and: Vec<QueryFilter>,
    #[doc = "The logical \"OR\" expression. Must have at least 2 items."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub or: Vec<QueryFilter>,
    #[doc = "The filter expression to be used in the export."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub not: Box<Option<QueryFilter>>,
    #[doc = "The comparison expression to be used in the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dimension: Option<QueryComparisonExpression>,
    #[doc = "The comparison expression to be used in the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<QueryComparisonExpression>,
}
impl QueryFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The group by expression to be used in the query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryGrouping {
    #[doc = "The type of the column in the export."]
    #[serde(rename = "type")]
    pub type_: QueryColumnType,
    #[doc = "The name of the column to group."]
    pub name: String,
}
impl QueryGrouping {
    pub fn new(type_: QueryColumnType, name: String) -> Self {
        Self { type_, name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryProperties {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of columns"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<QueryColumn>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rows: Vec<Vec<serde_json::Value>>,
}
impl QueryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of query. It contains all columns listed under groupings and aggregation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryResult {
    #[doc = "The list of usage data."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Query>,
}
impl QueryResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The configuration for sorting in the query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuerySortingConfiguration {
    #[doc = "The sorting direction"]
    #[serde(rename = "querySortingDirection", default, skip_serializing_if = "Option::is_none")]
    pub query_sorting_direction: Option<query_sorting_configuration::QuerySortingDirection>,
    #[doc = "The name of the column to use in sorting."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl QuerySortingConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod query_sorting_configuration {
    use super::*;
    #[doc = "The sorting direction"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum QuerySortingDirection {
        Ascending,
        Descending,
    }
}
#[doc = "The start and end date for pulling data for the query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryTimePeriod {
    #[doc = "The start date to pull data from."]
    pub from: String,
    #[doc = "The end date to pull data to."]
    pub to: String,
}
impl QueryTimePeriod {
    pub fn new(from: String, to: String) -> Self {
        Self { from, to }
    }
}
#[doc = "The Resource model definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
