#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The resource model definition for a ARM proxy resource. It will have everything other than required location and tags"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmProxyResource {
    #[doc = "The unique resource identifier of the database account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the database account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of Azure resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ArmProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The core properties of ARM resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmResourceProperties {
    #[doc = "The unique resource identifier of the ARM resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the ARM resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of Azure resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The location of the resource group to which the resource belongs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with \"defaultExperience\": \"Cassandra\". Current \"defaultExperience\" values also include \"Table\", \"Graph\", \"DocumentDB\", and \"MongoDB\"."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<Tags>,
}
impl ArmResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB capability object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Capability {
    #[doc = "Name of the Cosmos DB capability. For example, \"name\": \"EnableCassandra\". Current values also include \"EnableTable\" and \"EnableGremlin\"."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl Capability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters to create and update Cosmos DB Cassandra keyspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraKeyspaceCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB Cassandra keyspace."]
    pub properties: CassandraKeyspaceCreateUpdateProperties,
}
impl CassandraKeyspaceCreateUpdateParameters {
    pub fn new(properties: CassandraKeyspaceCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB Cassandra keyspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraKeyspaceCreateUpdateProperties {
    #[doc = "Cosmos DB Cassandra keyspace resource object"]
    pub resource: CassandraKeyspaceResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl CassandraKeyspaceCreateUpdateProperties {
    pub fn new(resource: CassandraKeyspaceResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB Cassandra keyspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraKeyspaceGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl CassandraKeyspaceGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB Cassandra keyspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraKeyspaceGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB Cassandra keyspace"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CassandraKeyspaceGetProperties>,
}
impl CassandraKeyspaceGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the Cassandra keyspaces and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraKeyspaceListResult {
    #[doc = "List of Cassandra keyspaces and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CassandraKeyspaceGetResults>,
}
impl CassandraKeyspaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB Cassandra keyspace resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraKeyspaceResource {
    #[doc = "Name of the Cosmos DB Cassandra keyspace"]
    pub id: String,
}
impl CassandraKeyspaceResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "Cosmos DB Cassandra table partition key"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraPartitionKey {
    #[doc = "Name of the Cosmos DB Cassandra table partition key"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl CassandraPartitionKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB Cassandra table schema"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraSchema {
    #[doc = "List of Cassandra table columns."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<Column>,
    #[doc = "List of partition key."]
    #[serde(rename = "partitionKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_keys: Vec<CassandraPartitionKey>,
    #[doc = "List of cluster key."]
    #[serde(rename = "clusterKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub cluster_keys: Vec<ClusterKey>,
}
impl CassandraSchema {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters to create and update Cosmos DB Cassandra table."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraTableCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB Cassandra table."]
    pub properties: CassandraTableCreateUpdateProperties,
}
impl CassandraTableCreateUpdateParameters {
    pub fn new(properties: CassandraTableCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB Cassandra table."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraTableCreateUpdateProperties {
    #[doc = "Cosmos DB Cassandra table resource object"]
    pub resource: CassandraTableResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl CassandraTableCreateUpdateProperties {
    pub fn new(resource: CassandraTableResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB Cassandra table"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraTableGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl CassandraTableGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB Cassandra table."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraTableGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB Cassandra table"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CassandraTableGetProperties>,
}
impl CassandraTableGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the Cassandra tables and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraTableListResult {
    #[doc = "List of Cassandra tables and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CassandraTableGetResults>,
}
impl CassandraTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB Cassandra table resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraTableResource {
    #[doc = "Name of the Cosmos DB Cassandra table"]
    pub id: String,
    #[doc = "Time to live of the Cosmos DB Cassandra table"]
    #[serde(rename = "defaultTtl", default, skip_serializing_if = "Option::is_none")]
    pub default_ttl: Option<i64>,
    #[doc = "Cosmos DB Cassandra table schema"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<CassandraSchema>,
}
impl CassandraTableResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            default_ttl: None,
            schema: None,
        }
    }
}
#[doc = "Cosmos DB Cassandra table cluster key"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClusterKey {
    #[doc = "Name of the Cosmos DB Cassandra table cluster key"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Order of the Cosmos DB Cassandra table cluster key, only support \"Asc\" and \"Desc\""]
    #[serde(rename = "orderBy", default, skip_serializing_if = "Option::is_none")]
    pub order_by: Option<String>,
}
impl ClusterKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB Cassandra table column"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Column {
    #[doc = "Name of the Cosmos DB Cassandra table column"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Type of the Cosmos DB Cassandra table column"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Column {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CompositePath {
    #[doc = "The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "Sort order for composite paths."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub order: Option<composite_path::Order>,
}
impl CompositePath {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod composite_path {
    use super::*;
    #[doc = "Sort order for composite paths."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Order {
        Ascending,
        Descending,
    }
}
pub type CompositePathList = Vec<CompositePath>;
#[doc = "The conflict resolution policy for the container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConflictResolutionPolicy {
    #[doc = "Indicates the conflict resolution mode."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<conflict_resolution_policy::Mode>,
    #[doc = "The conflict resolution path in the case of LastWriterWins mode."]
    #[serde(rename = "conflictResolutionPath", default, skip_serializing_if = "Option::is_none")]
    pub conflict_resolution_path: Option<String>,
    #[doc = "The procedure to resolve conflicts in the case of custom mode."]
    #[serde(rename = "conflictResolutionProcedure", default, skip_serializing_if = "Option::is_none")]
    pub conflict_resolution_procedure: Option<String>,
}
impl ConflictResolutionPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod conflict_resolution_policy {
    use super::*;
    #[doc = "Indicates the conflict resolution mode."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        LastWriterWins,
        Custom,
    }
    impl Default for Mode {
        fn default() -> Self {
            Self::LastWriterWins
        }
    }
}
#[doc = "The cassandra connector offer type for the Cosmos DB C* database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConnectorOffer {
    Small,
}
#[doc = "The consistency policy for the Cosmos DB database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsistencyPolicy {
    #[doc = "The default consistency level and configuration settings of the Cosmos DB account."]
    #[serde(rename = "defaultConsistencyLevel")]
    pub default_consistency_level: consistency_policy::DefaultConsistencyLevel,
    #[doc = "When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'."]
    #[serde(rename = "maxStalenessPrefix", default, skip_serializing_if = "Option::is_none")]
    pub max_staleness_prefix: Option<i64>,
    #[doc = "When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'."]
    #[serde(rename = "maxIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub max_interval_in_seconds: Option<i32>,
}
impl ConsistencyPolicy {
    pub fn new(default_consistency_level: consistency_policy::DefaultConsistencyLevel) -> Self {
        Self {
            default_consistency_level,
            max_staleness_prefix: None,
            max_interval_in_seconds: None,
        }
    }
}
pub mod consistency_policy {
    use super::*;
    #[doc = "The default consistency level and configuration settings of the Cosmos DB account."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DefaultConsistencyLevel {
        Eventual,
        Session,
        BoundedStaleness,
        Strong,
        ConsistentPrefix,
    }
}
#[doc = "The configuration of the partition key to be used for partitioning data into multiple partitions"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerPartitionKey {
    #[doc = "List of paths using which data within the container can be partitioned"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub paths: Vec<Path>,
    #[doc = "Indicates the kind of algorithm used for partitioning"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<container_partition_key::Kind>,
    #[doc = "Indicates the version of the partition key definition"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i32>,
}
impl ContainerPartitionKey {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod container_partition_key {
    use super::*;
    #[doc = "Indicates the kind of algorithm used for partitioning"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Hash,
        Range,
    }
    impl Default for Kind {
        fn default() -> Self {
            Self::Hash
        }
    }
}
#[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateUpdateOptions {}
impl CreateUpdateOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Connection string for the Cosmos DB account"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountConnectionString {
    #[doc = "Value of the connection string"]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[doc = "Description of the connection string"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl DatabaseAccountConnectionString {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters to create and update Cosmos DB database accounts."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseAccountCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Indicates the type of database account. This can only be set at database account creation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<database_account_create_update_parameters::Kind>,
    #[doc = "Properties to create and update Azure Cosmos DB database accounts."]
    pub properties: DatabaseAccountCreateUpdateProperties,
}
impl DatabaseAccountCreateUpdateParameters {
    pub fn new(properties: DatabaseAccountCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            kind: None,
            properties,
        }
    }
}
pub mod database_account_create_update_parameters {
    use super::*;
    #[doc = "Indicates the type of database account. This can only be set at database account creation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "GlobalDocumentDB")]
        GlobalDocumentDb,
        #[serde(rename = "MongoDB")]
        MongoDb,
        Parse,
    }
    impl Default for Kind {
        fn default() -> Self {
            Self::GlobalDocumentDb
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB database accounts."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseAccountCreateUpdateProperties {
    #[doc = "The consistency policy for the Cosmos DB database account."]
    #[serde(rename = "consistencyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub consistency_policy: Option<ConsistencyPolicy>,
    #[doc = "An array that contains the georeplication locations enabled for the Cosmos DB account."]
    pub locations: Vec<Location>,
    #[doc = "The offer type for the Cosmos DB database account."]
    #[serde(rename = "databaseAccountOfferType")]
    pub database_account_offer_type: DatabaseAccountOfferType,
    #[doc = "Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces."]
    #[serde(rename = "ipRangeFilter", default, skip_serializing_if = "Option::is_none")]
    pub ip_range_filter: Option<IpRangeFilter>,
    #[doc = "Flag to indicate whether to enable/disable Virtual Network ACL rules."]
    #[serde(rename = "isVirtualNetworkFilterEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_virtual_network_filter_enabled: Option<bool>,
    #[doc = "Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account."]
    #[serde(rename = "enableAutomaticFailover", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_failover: Option<bool>,
    #[doc = "List of Cosmos DB capabilities for the account"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
    #[doc = "List of Virtual Network ACL rules configured for the Cosmos DB account."]
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<VirtualNetworkRule>,
    #[doc = "Enables the account to write in multiple locations"]
    #[serde(rename = "enableMultipleWriteLocations", default, skip_serializing_if = "Option::is_none")]
    pub enable_multiple_write_locations: Option<bool>,
    #[doc = "Enables the cassandra connector on the Cosmos DB C* account"]
    #[serde(rename = "enableCassandraConnector", default, skip_serializing_if = "Option::is_none")]
    pub enable_cassandra_connector: Option<bool>,
    #[doc = "The cassandra connector offer type for the Cosmos DB C* database account."]
    #[serde(rename = "connectorOffer", default, skip_serializing_if = "Option::is_none")]
    pub connector_offer: Option<ConnectorOffer>,
    #[doc = "Disable write operations on metadata resources (databases, containers, throughput) via account keys"]
    #[serde(rename = "disableKeyBasedMetadataWriteAccess", default, skip_serializing_if = "Option::is_none")]
    pub disable_key_based_metadata_write_access: Option<bool>,
}
impl DatabaseAccountCreateUpdateProperties {
    pub fn new(locations: Vec<Location>, database_account_offer_type: DatabaseAccountOfferType) -> Self {
        Self {
            consistency_policy: None,
            locations,
            database_account_offer_type,
            ip_range_filter: None,
            is_virtual_network_filter_enabled: None,
            enable_automatic_failover: None,
            capabilities: Vec::new(),
            virtual_network_rules: Vec::new(),
            enable_multiple_write_locations: None,
            enable_cassandra_connector: None,
            connector_offer: None,
            disable_key_based_metadata_write_access: None,
        }
    }
}
#[doc = "Properties for the database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountGetProperties {
    #[doc = "The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'Offline' - the Cosmos DB account is not active. 'DeletionFailed' – the Cosmos DB account deletion failed."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The connection endpoint for the Cosmos DB database account."]
    #[serde(rename = "documentEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub document_endpoint: Option<String>,
    #[doc = "The offer type for the Cosmos DB database account."]
    #[serde(rename = "databaseAccountOfferType", default, skip_serializing_if = "Option::is_none")]
    pub database_account_offer_type: Option<DatabaseAccountOfferType>,
    #[doc = "Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces."]
    #[serde(rename = "ipRangeFilter", default, skip_serializing_if = "Option::is_none")]
    pub ip_range_filter: Option<IpRangeFilter>,
    #[doc = "Flag to indicate whether to enable/disable Virtual Network ACL rules."]
    #[serde(rename = "isVirtualNetworkFilterEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_virtual_network_filter_enabled: Option<bool>,
    #[doc = "Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account."]
    #[serde(rename = "enableAutomaticFailover", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_failover: Option<bool>,
    #[doc = "The consistency policy for the Cosmos DB database account."]
    #[serde(rename = "consistencyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub consistency_policy: Option<ConsistencyPolicy>,
    #[doc = "List of Cosmos DB capabilities for the account"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
    #[doc = "An array that contains the write location for the Cosmos DB account."]
    #[serde(rename = "writeLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub write_locations: Vec<Location>,
    #[doc = "An array that contains of the read locations enabled for the Cosmos DB account."]
    #[serde(rename = "readLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub read_locations: Vec<Location>,
    #[doc = "An array that contains all of the locations enabled for the Cosmos DB account."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<Location>,
    #[doc = "An array that contains the regions ordered by their failover priorities."]
    #[serde(rename = "failoverPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub failover_policies: Vec<FailoverPolicy>,
    #[doc = "List of Virtual Network ACL rules configured for the Cosmos DB account."]
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<VirtualNetworkRule>,
    #[doc = "Enables the account to write in multiple locations"]
    #[serde(rename = "enableMultipleWriteLocations", default, skip_serializing_if = "Option::is_none")]
    pub enable_multiple_write_locations: Option<bool>,
    #[doc = "Enables the cassandra connector on the Cosmos DB C* account"]
    #[serde(rename = "enableCassandraConnector", default, skip_serializing_if = "Option::is_none")]
    pub enable_cassandra_connector: Option<bool>,
    #[doc = "The cassandra connector offer type for the Cosmos DB C* database account."]
    #[serde(rename = "connectorOffer", default, skip_serializing_if = "Option::is_none")]
    pub connector_offer: Option<ConnectorOffer>,
    #[doc = "Disable write operations on metadata resources (databases, containers, throughput) via account keys"]
    #[serde(rename = "disableKeyBasedMetadataWriteAccess", default, skip_serializing_if = "Option::is_none")]
    pub disable_key_based_metadata_write_access: Option<bool>,
}
impl DatabaseAccountGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Indicates the type of database account. This can only be set at database account creation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<database_account_get_results::Kind>,
    #[doc = "Properties for the database account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseAccountGetProperties>,
}
impl DatabaseAccountGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod database_account_get_results {
    use super::*;
    #[doc = "Indicates the type of database account. This can only be set at database account creation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "GlobalDocumentDB")]
        GlobalDocumentDb,
        #[serde(rename = "MongoDB")]
        MongoDb,
        Parse,
    }
    impl Default for Kind {
        fn default() -> Self {
            Self::GlobalDocumentDb
        }
    }
}
#[doc = "The connection strings for the given database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountListConnectionStringsResult {
    #[doc = "An array that contains the connection strings for the Cosmos DB account."]
    #[serde(rename = "connectionStrings", default, skip_serializing_if = "Vec::is_empty")]
    pub connection_strings: Vec<DatabaseAccountConnectionString>,
}
impl DatabaseAccountListConnectionStringsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The access keys for the given database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountListKeysResult {
    #[serde(flatten)]
    pub database_account_list_read_only_keys_result: DatabaseAccountListReadOnlyKeysResult,
    #[doc = "Base 64 encoded value of the primary read-write key."]
    #[serde(rename = "primaryMasterKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_master_key: Option<String>,
    #[doc = "Base 64 encoded value of the secondary read-write key."]
    #[serde(rename = "secondaryMasterKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_master_key: Option<String>,
}
impl DatabaseAccountListKeysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The read-only access keys for the given database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountListReadOnlyKeysResult {
    #[doc = "Base 64 encoded value of the primary read-only key."]
    #[serde(rename = "primaryReadonlyMasterKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_readonly_master_key: Option<String>,
    #[doc = "Base 64 encoded value of the secondary read-only key."]
    #[serde(rename = "secondaryReadonlyMasterKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_readonly_master_key: Option<String>,
}
impl DatabaseAccountListReadOnlyKeysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The offer type for the Cosmos DB database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DatabaseAccountOfferType {
    Standard,
}
#[doc = "Parameters to regenerate the keys within the database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseAccountRegenerateKeyParameters {
    #[doc = "The access key to regenerate."]
    #[serde(rename = "keyKind")]
    pub key_kind: database_account_regenerate_key_parameters::KeyKind,
}
impl DatabaseAccountRegenerateKeyParameters {
    pub fn new(key_kind: database_account_regenerate_key_parameters::KeyKind) -> Self {
        Self { key_kind }
    }
}
pub mod database_account_regenerate_key_parameters {
    use super::*;
    #[doc = "The access key to regenerate."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyKind {
        #[serde(rename = "primary")]
        Primary,
        #[serde(rename = "secondary")]
        Secondary,
        #[serde(rename = "primaryReadonly")]
        PrimaryReadonly,
        #[serde(rename = "secondaryReadonly")]
        SecondaryReadonly,
    }
}
#[doc = "Parameters for patching Azure Cosmos DB database account properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountUpdateParameters {
    #[doc = "Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with \"defaultExperience\": \"Cassandra\". Current \"defaultExperience\" values also include \"Table\", \"Graph\", \"DocumentDB\", and \"MongoDB\"."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<Tags>,
    #[doc = "The location of the resource group to which the resource belongs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Properties to update Azure Cosmos DB database accounts."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseAccountUpdateProperties>,
}
impl DatabaseAccountUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties to update Azure Cosmos DB database accounts."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountUpdateProperties {
    #[doc = "The consistency policy for the Cosmos DB database account."]
    #[serde(rename = "consistencyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub consistency_policy: Option<ConsistencyPolicy>,
    #[doc = "An array that contains the georeplication locations enabled for the Cosmos DB account."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<Location>,
    #[doc = "Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces."]
    #[serde(rename = "ipRangeFilter", default, skip_serializing_if = "Option::is_none")]
    pub ip_range_filter: Option<IpRangeFilter>,
    #[doc = "Flag to indicate whether to enable/disable Virtual Network ACL rules."]
    #[serde(rename = "isVirtualNetworkFilterEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_virtual_network_filter_enabled: Option<bool>,
    #[doc = "Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account."]
    #[serde(rename = "enableAutomaticFailover", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_failover: Option<bool>,
    #[doc = "List of Cosmos DB capabilities for the account"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
    #[doc = "List of Virtual Network ACL rules configured for the Cosmos DB account."]
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<VirtualNetworkRule>,
    #[doc = "Enables the account to write in multiple locations"]
    #[serde(rename = "enableMultipleWriteLocations", default, skip_serializing_if = "Option::is_none")]
    pub enable_multiple_write_locations: Option<bool>,
    #[doc = "Enables the cassandra connector on the Cosmos DB C* account"]
    #[serde(rename = "enableCassandraConnector", default, skip_serializing_if = "Option::is_none")]
    pub enable_cassandra_connector: Option<bool>,
    #[doc = "The cassandra connector offer type for the Cosmos DB C* database account."]
    #[serde(rename = "connectorOffer", default, skip_serializing_if = "Option::is_none")]
    pub connector_offer: Option<ConnectorOffer>,
    #[doc = "Disable write operations on metadata resources (databases, containers, throughput) via account keys"]
    #[serde(rename = "disableKeyBasedMetadataWriteAccess", default, skip_serializing_if = "Option::is_none")]
    pub disable_key_based_metadata_write_access: Option<bool>,
}
impl DatabaseAccountUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the database accounts and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountsListResult {
    #[doc = "List of database account and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DatabaseAccountGetResults>,
}
impl DatabaseAccountsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Error Response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "Error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message indicating why the operation failed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExcludedPath {
    #[doc = "The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl ExcludedPath {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The system generated resource properties associated with SQL databases, SQL containers, Gremlin databases and Gremlin graphs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedResourceProperties {
    #[doc = "A system generated property. A unique identifier."]
    #[serde(rename = "_rid", default, skip_serializing_if = "Option::is_none")]
    pub rid: Option<String>,
    #[doc = "A system generated property that denotes the last updated timestamp of the resource."]
    #[serde(rename = "_ts", default, skip_serializing_if = "Option::is_none")]
    pub ts: Option<serde_json::Value>,
    #[doc = "A system generated property representing the resource etag required for optimistic concurrency control."]
    #[serde(rename = "_etag", default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExtendedResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The list of new failover policies for the failover priority change."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FailoverPolicies {
    #[doc = "List of failover policies."]
    #[serde(rename = "failoverPolicies")]
    pub failover_policies: Vec<FailoverPolicy>,
}
impl FailoverPolicies {
    pub fn new(failover_policies: Vec<FailoverPolicy>) -> Self {
        Self { failover_policies }
    }
}
#[doc = "The failover policy for a given region of a database account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverPolicy {
    #[doc = "The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the region in which the database account exists."]
    #[serde(rename = "locationName", default, skip_serializing_if = "Option::is_none")]
    pub location_name: Option<String>,
    #[doc = "The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists."]
    #[serde(rename = "failoverPriority", default, skip_serializing_if = "Option::is_none")]
    pub failover_priority: Option<i32>,
}
impl FailoverPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters to create and update Cosmos DB Gremlin database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinDatabaseCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB Gremlin database."]
    pub properties: GremlinDatabaseCreateUpdateProperties,
}
impl GremlinDatabaseCreateUpdateParameters {
    pub fn new(properties: GremlinDatabaseCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB Gremlin database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinDatabaseCreateUpdateProperties {
    #[doc = "Cosmos DB Gremlin database resource object"]
    pub resource: GremlinDatabaseResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl GremlinDatabaseCreateUpdateProperties {
    pub fn new(resource: GremlinDatabaseResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB SQL database"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinDatabaseGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl GremlinDatabaseGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB Gremlin database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinDatabaseGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB SQL database"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GremlinDatabaseGetProperties>,
}
impl GremlinDatabaseGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the Gremlin databases and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinDatabaseListResult {
    #[doc = "List of Gremlin databases and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GremlinDatabaseGetResults>,
}
impl GremlinDatabaseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB Gremlin database resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinDatabaseResource {
    #[doc = "Name of the Cosmos DB Gremlin database"]
    pub id: String,
}
impl GremlinDatabaseResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "Parameters to create and update Cosmos DB Gremlin graph."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinGraphCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB Gremlin graph."]
    pub properties: GremlinGraphCreateUpdateProperties,
}
impl GremlinGraphCreateUpdateParameters {
    pub fn new(properties: GremlinGraphCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB Gremlin graph."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinGraphCreateUpdateProperties {
    #[doc = "Cosmos DB Gremlin graph resource object"]
    pub resource: GremlinGraphResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl GremlinGraphCreateUpdateProperties {
    pub fn new(resource: GremlinGraphResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB Gremlin graph"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinGraphGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl GremlinGraphGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB Gremlin graph."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinGraphGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB Gremlin graph"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GremlinGraphGetProperties>,
}
impl GremlinGraphGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the graphs and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinGraphListResult {
    #[doc = "List of graphs and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GremlinGraphGetResults>,
}
impl GremlinGraphListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB Gremlin graph resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinGraphResource {
    #[doc = "Name of the Cosmos DB Gremlin graph"]
    pub id: String,
    #[doc = "Cosmos DB indexing policy"]
    #[serde(rename = "indexingPolicy", default, skip_serializing_if = "Option::is_none")]
    pub indexing_policy: Option<IndexingPolicy>,
    #[doc = "The configuration of the partition key to be used for partitioning data into multiple partitions"]
    #[serde(rename = "partitionKey", default, skip_serializing_if = "Option::is_none")]
    pub partition_key: Option<ContainerPartitionKey>,
    #[doc = "Default time to live"]
    #[serde(rename = "defaultTtl", default, skip_serializing_if = "Option::is_none")]
    pub default_ttl: Option<i64>,
    #[doc = "The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service."]
    #[serde(rename = "uniqueKeyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub unique_key_policy: Option<UniqueKeyPolicy>,
    #[doc = "The conflict resolution policy for the container."]
    #[serde(rename = "conflictResolutionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub conflict_resolution_policy: Option<ConflictResolutionPolicy>,
}
impl GremlinGraphResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            indexing_policy: None,
            partition_key: None,
            default_ttl: None,
            unique_key_policy: None,
            conflict_resolution_policy: None,
        }
    }
}
pub type IpRangeFilter = String;
#[doc = "The paths that are included in indexing"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncludedPath {
    #[doc = "The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "List of indexes for this path"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub indexes: Vec<Indexes>,
}
impl IncludedPath {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The indexes for the path."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Indexes {
    #[doc = "The datatype for which the indexing behavior is applied to."]
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<indexes::DataType>,
    #[doc = "The precision of the index. -1 is maximum precision."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub precision: Option<i64>,
    #[doc = "Indicates the type of index."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<indexes::Kind>,
}
impl Indexes {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod indexes {
    use super::*;
    #[doc = "The datatype for which the indexing behavior is applied to."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataType {
        String,
        Number,
        Point,
        Polygon,
        LineString,
        MultiPolygon,
    }
    impl Default for DataType {
        fn default() -> Self {
            Self::String
        }
    }
    #[doc = "Indicates the type of index."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Hash,
        Range,
        Spatial,
    }
    impl Default for Kind {
        fn default() -> Self {
            Self::Hash
        }
    }
}
#[doc = "Cosmos DB indexing policy"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IndexingPolicy {
    #[doc = "Indicates if the indexing policy is automatic"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub automatic: Option<bool>,
    #[doc = "Indicates the indexing mode."]
    #[serde(rename = "indexingMode", default, skip_serializing_if = "Option::is_none")]
    pub indexing_mode: Option<indexing_policy::IndexingMode>,
    #[doc = "List of paths to include in the indexing"]
    #[serde(rename = "includedPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub included_paths: Vec<IncludedPath>,
    #[doc = "List of paths to exclude from indexing"]
    #[serde(rename = "excludedPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub excluded_paths: Vec<ExcludedPath>,
    #[doc = "List of composite path list"]
    #[serde(rename = "compositeIndexes", default, skip_serializing_if = "Vec::is_empty")]
    pub composite_indexes: Vec<CompositePathList>,
    #[doc = "List of spatial specifics"]
    #[serde(rename = "spatialIndexes", default, skip_serializing_if = "Vec::is_empty")]
    pub spatial_indexes: Vec<SpatialSpec>,
}
impl IndexingPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod indexing_policy {
    use super::*;
    #[doc = "Indicates the indexing mode."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IndexingMode {
        Consistent,
        Lazy,
        None,
    }
    impl Default for IndexingMode {
        fn default() -> Self {
            Self::Consistent
        }
    }
}
pub type Key = String;
#[doc = "A region in which the Azure Cosmos DB database account is deployed."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Location {
    #[doc = "The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the region."]
    #[serde(rename = "locationName", default, skip_serializing_if = "Option::is_none")]
    pub location_name: Option<String>,
    #[doc = "The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/"]
    #[serde(rename = "documentEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub document_endpoint: Option<String>,
    #[doc = "The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'Offline' - the Cosmos DB account is not active. 'DeletionFailed' – the Cosmos DB account deletion failed."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists."]
    #[serde(rename = "failoverPriority", default, skip_serializing_if = "Option::is_none")]
    pub failover_priority: Option<i32>,
    #[doc = "Flag to indicate whether or not this region is an AvailabilityZone region"]
    #[serde(rename = "isZoneRedundant", default, skip_serializing_if = "Option::is_none")]
    pub is_zone_redundant: Option<bool>,
}
impl Location {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metric data"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Metric {
    #[doc = "The start time for the metric (ISO-8601 format)."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time for the metric (ISO-8601 format)."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The time grain to be used to summarize the metric values."]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[doc = "The unit of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<UnitType>,
    #[doc = "A metric name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
    #[doc = "The metric values for the specified time window and timestep."]
    #[serde(rename = "metricValues", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_values: Vec<MetricValue>,
}
impl Metric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The availability of the metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricAvailability {
    #[doc = "The time grain to be used to summarize the metric values."]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[doc = "The retention for the metric values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
}
impl MetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The definition of a metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricDefinition {
    #[doc = "The list of metric availabilities for the account."]
    #[serde(rename = "metricAvailabilities", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_availabilities: Vec<MetricAvailability>,
    #[doc = "The primary aggregation type of the metric."]
    #[serde(rename = "primaryAggregationType", default, skip_serializing_if = "Option::is_none")]
    pub primary_aggregation_type: Option<metric_definition::PrimaryAggregationType>,
    #[doc = "The unit of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<UnitType>,
    #[doc = "The resource uri of the database."]
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[doc = "A metric name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
}
impl MetricDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod metric_definition {
    use super::*;
    #[doc = "The primary aggregation type of the metric."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrimaryAggregationType {
        None,
        Average,
        Total,
        Minimum,
        Maximum,
        Last,
    }
}
#[doc = "The response to a list metric definitions request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricDefinitionsListResult {
    #[doc = "The list of metric definitions for the account."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MetricDefinition>,
}
impl MetricDefinitionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list metrics request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricListResult {
    #[doc = "The list of metrics for the account."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Metric>,
}
impl MetricListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A metric name."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricName {
    #[doc = "The name of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "The friendly name of the metric."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl MetricName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents metrics values."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricValue {
    #[doc = "The number of values for the metric."]
    #[serde(rename = "_count", default, skip_serializing_if = "Option::is_none")]
    pub count: Option<f64>,
    #[doc = "The average value of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub average: Option<f64>,
    #[doc = "The max value of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f64>,
    #[doc = "The min value of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f64>,
    #[doc = "The metric timestamp (ISO-8601 format)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[doc = "The total value of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<f64>,
}
impl MetricValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters to create and update Cosmos DB MongoDB collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB MongoDB collection."]
    pub properties: MongoDbCollectionCreateUpdateProperties,
}
impl MongoDbCollectionCreateUpdateParameters {
    pub fn new(properties: MongoDbCollectionCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB MongoDB collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionCreateUpdateProperties {
    #[doc = "Cosmos DB MongoDB collection resource object"]
    pub resource: MongoDbCollectionResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl MongoDbCollectionCreateUpdateProperties {
    pub fn new(resource: MongoDbCollectionResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB MongoDB collection"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbCollectionGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl MongoDbCollectionGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB MongoDB collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbCollectionGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB MongoDB collection"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MongoDbCollectionGetProperties>,
}
impl MongoDbCollectionGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the MongoDB collections and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbCollectionListResult {
    #[doc = "List of MongoDB collections and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MongoDbCollectionGetResults>,
}
impl MongoDbCollectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB MongoDB collection resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionResource {
    #[doc = "Name of the Cosmos DB MongoDB collection"]
    pub id: String,
    #[doc = "The shard key and partition kind pair, only support \"Hash\" partition kind"]
    #[serde(rename = "shardKey", default, skip_serializing_if = "Option::is_none")]
    pub shard_key: Option<ShardKeys>,
    #[doc = "List of index keys"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub indexes: Vec<MongoIndex>,
}
impl MongoDbCollectionResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            shard_key: None,
            indexes: Vec::new(),
        }
    }
}
#[doc = "Parameters to create and update Cosmos DB MongoDB database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbDatabaseCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB MongoDB database."]
    pub properties: MongoDbDatabaseCreateUpdateProperties,
}
impl MongoDbDatabaseCreateUpdateParameters {
    pub fn new(properties: MongoDbDatabaseCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB MongoDB database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbDatabaseCreateUpdateProperties {
    #[doc = "Cosmos DB MongoDB database resource object"]
    pub resource: MongoDbDatabaseResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl MongoDbDatabaseCreateUpdateProperties {
    pub fn new(resource: MongoDbDatabaseResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB MongoDB database"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbDatabaseGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl MongoDbDatabaseGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB MongoDB database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbDatabaseGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB MongoDB database"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MongoDbDatabaseGetProperties>,
}
impl MongoDbDatabaseGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the MongoDB databases and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbDatabaseListResult {
    #[doc = "List of MongoDB databases and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MongoDbDatabaseGetResults>,
}
impl MongoDbDatabaseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB MongoDB database resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbDatabaseResource {
    #[doc = "Name of the Cosmos DB MongoDB database"]
    pub id: String,
}
impl MongoDbDatabaseResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "Cosmos DB MongoDB collection index key"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoIndex {
    #[doc = "Cosmos DB MongoDB collection resource object"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<MongoIndexKeys>,
    #[doc = "Cosmos DB MongoDB collection index options"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<MongoIndexOptions>,
}
impl MongoIndex {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB MongoDB collection resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoIndexKeys {
    #[doc = "List of keys for each MongoDB collection in the Azure Cosmos DB service"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub keys: Vec<Key>,
}
impl MongoIndexKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB MongoDB collection index options"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoIndexOptions {
    #[doc = "Expire after seconds"]
    #[serde(rename = "expireAfterSeconds", default, skip_serializing_if = "Option::is_none")]
    pub expire_after_seconds: Option<i64>,
    #[doc = "Is unique or not"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unique: Option<bool>,
}
impl MongoIndexOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A notebook workspace resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspace {
    #[serde(flatten)]
    pub arm_proxy_resource: ArmProxyResource,
    #[doc = "Properties of a notebook workspace resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NotebookWorkspaceProperties>,
}
impl NotebookWorkspace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The connection info for the given notebook workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspaceConnectionInfoResult {
    #[doc = "Specifies auth token used for connecting to Notebook server (uses token-based auth)."]
    #[serde(rename = "authToken", default, skip_serializing_if = "Option::is_none")]
    pub auth_token: Option<String>,
    #[doc = "Specifies the endpoint of Notebook server."]
    #[serde(rename = "notebookServerEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub notebook_server_endpoint: Option<String>,
}
impl NotebookWorkspaceConnectionInfoResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters to create a notebook workspace resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspaceCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_proxy_resource: ArmProxyResource,
}
impl NotebookWorkspaceCreateUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of notebook workspace resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspaceListResult {
    #[doc = "Array of notebook workspace resources"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NotebookWorkspace>,
}
impl NotebookWorkspaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a notebook workspace resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspaceProperties {
    #[doc = "Specifies the endpoint of Notebook server."]
    #[serde(rename = "notebookServerEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub notebook_server_endpoint: Option<String>,
    #[doc = "Status of the notebook workspace. Possible values are: Creating, Online, Deleting, Failed, Updating."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl NotebookWorkspaceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "REST API operation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The object that represents the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "The object that represents the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Service provider: Microsoft.ResourceProvider"]
        #[serde(rename = "Provider", default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource on which the operation is performed: Profile, endpoint, etc."]
        #[serde(rename = "Resource", default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Operation type: Read, write, delete, etc."]
        #[serde(rename = "Operation", default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "Description of operation"]
        #[serde(rename = "Description", default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result of the request to list Resource Provider operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of operations supported by the Resource Provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The metric values for a single partition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartitionMetric {
    #[serde(flatten)]
    pub metric: Metric,
    #[doc = "The partition id (GUID identifier) of the metric values."]
    #[serde(rename = "partitionId", default, skip_serializing_if = "Option::is_none")]
    pub partition_id: Option<String>,
    #[doc = "The partition key range id (integer identifier) of the metric values."]
    #[serde(rename = "partitionKeyRangeId", default, skip_serializing_if = "Option::is_none")]
    pub partition_key_range_id: Option<String>,
}
impl PartitionMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list partition metrics request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartitionMetricListResult {
    #[doc = "The list of partition-level metrics for the account."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PartitionMetric>,
}
impl PartitionMetricListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The partition level usage data for a usage request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartitionUsage {
    #[serde(flatten)]
    pub usage: Usage,
    #[doc = "The partition id (GUID identifier) of the usages."]
    #[serde(rename = "partitionId", default, skip_serializing_if = "Option::is_none")]
    pub partition_id: Option<String>,
    #[doc = "The partition key range id (integer identifier) of the usages."]
    #[serde(rename = "partitionKeyRangeId", default, skip_serializing_if = "Option::is_none")]
    pub partition_key_range_id: Option<String>,
}
impl PartitionUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list partition level usage request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartitionUsagesResult {
    #[doc = "The list of partition-level usages for the database. A usage is a point in time metric"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PartitionUsage>,
}
impl PartitionUsagesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type Path = String;
#[doc = "Percentile Metric data"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PercentileMetric {
    #[doc = "The start time for the metric (ISO-8601 format)."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time for the metric (ISO-8601 format)."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The time grain to be used to summarize the metric values."]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[doc = "The unit of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<UnitType>,
    #[doc = "A metric name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
    #[doc = "The percentile metric values for the specified time window and timestep."]
    #[serde(rename = "metricValues", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_values: Vec<PercentileMetricValue>,
}
impl PercentileMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list percentile metrics request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PercentileMetricListResult {
    #[doc = "The list of percentile metrics for the account."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PercentileMetric>,
}
impl PercentileMetricListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents percentile metrics values."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PercentileMetricValue {
    #[serde(flatten)]
    pub metric_value: MetricValue,
    #[doc = "The 10th percentile value for the metric."]
    #[serde(rename = "P10", default, skip_serializing_if = "Option::is_none")]
    pub p10: Option<f64>,
    #[doc = "The 25th percentile value for the metric."]
    #[serde(rename = "P25", default, skip_serializing_if = "Option::is_none")]
    pub p25: Option<f64>,
    #[doc = "The 50th percentile value for the metric."]
    #[serde(rename = "P50", default, skip_serializing_if = "Option::is_none")]
    pub p50: Option<f64>,
    #[doc = "The 75th percentile value for the metric."]
    #[serde(rename = "P75", default, skip_serializing_if = "Option::is_none")]
    pub p75: Option<f64>,
    #[doc = "The 90th percentile value for the metric."]
    #[serde(rename = "P90", default, skip_serializing_if = "Option::is_none")]
    pub p90: Option<f64>,
    #[doc = "The 95th percentile value for the metric."]
    #[serde(rename = "P95", default, skip_serializing_if = "Option::is_none")]
    pub p95: Option<f64>,
    #[doc = "The 99th percentile value for the metric."]
    #[serde(rename = "P99", default, skip_serializing_if = "Option::is_none")]
    pub p99: Option<f64>,
}
impl PercentileMetricValue {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type ProvisioningState = String;
#[doc = "Cosmos DB region to online or offline."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegionForOnlineOffline {
    #[doc = "Cosmos DB region, with spaces between words and each word capitalized."]
    pub region: String,
}
impl RegionForOnlineOffline {
    pub fn new(region: String) -> Self {
        Self { region }
    }
}
#[doc = "The shard key and partition kind pair, only support \"Hash\" partition kind"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShardKeys {}
impl ShardKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SpatialSpec {
    #[doc = "The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "List of path's spatial type"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub types: Vec<SpatialType>,
}
impl SpatialSpec {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Indicates the spatial type of index."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SpatialType {
    Point,
    LineString,
    Polygon,
    MultiPolygon,
}
#[doc = "Parameters to create and update Cosmos DB container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlContainerCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB container."]
    pub properties: SqlContainerCreateUpdateProperties,
}
impl SqlContainerCreateUpdateParameters {
    pub fn new(properties: SqlContainerCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlContainerCreateUpdateProperties {
    #[doc = "Cosmos DB SQL container resource object"]
    pub resource: SqlContainerResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl SqlContainerCreateUpdateProperties {
    pub fn new(resource: SqlContainerResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB container"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlContainerGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl SqlContainerGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlContainerGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB container"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlContainerGetProperties>,
}
impl SqlContainerGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the containers and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlContainerListResult {
    #[doc = "List of containers and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlContainerGetResults>,
}
impl SqlContainerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB SQL container resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlContainerResource {
    #[doc = "Name of the Cosmos DB SQL container"]
    pub id: String,
    #[doc = "Cosmos DB indexing policy"]
    #[serde(rename = "indexingPolicy", default, skip_serializing_if = "Option::is_none")]
    pub indexing_policy: Option<IndexingPolicy>,
    #[doc = "The configuration of the partition key to be used for partitioning data into multiple partitions"]
    #[serde(rename = "partitionKey", default, skip_serializing_if = "Option::is_none")]
    pub partition_key: Option<ContainerPartitionKey>,
    #[doc = "Default time to live"]
    #[serde(rename = "defaultTtl", default, skip_serializing_if = "Option::is_none")]
    pub default_ttl: Option<i64>,
    #[doc = "The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service."]
    #[serde(rename = "uniqueKeyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub unique_key_policy: Option<UniqueKeyPolicy>,
    #[doc = "The conflict resolution policy for the container."]
    #[serde(rename = "conflictResolutionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub conflict_resolution_policy: Option<ConflictResolutionPolicy>,
}
impl SqlContainerResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            indexing_policy: None,
            partition_key: None,
            default_ttl: None,
            unique_key_policy: None,
            conflict_resolution_policy: None,
        }
    }
}
#[doc = "Parameters to create and update Cosmos DB SQL database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDatabaseCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB SQL database."]
    pub properties: SqlDatabaseCreateUpdateProperties,
}
impl SqlDatabaseCreateUpdateParameters {
    pub fn new(properties: SqlDatabaseCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB SQL database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDatabaseCreateUpdateProperties {
    #[doc = "Cosmos DB SQL database resource object"]
    pub resource: SqlDatabaseResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl SqlDatabaseCreateUpdateProperties {
    pub fn new(resource: SqlDatabaseResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB SQL database"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDatabaseGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<sql_database_get_properties::Resource>,
}
impl SqlDatabaseGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_database_get_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Resource {
        #[serde(flatten)]
        pub sql_database_resource: SqlDatabaseResource,
        #[serde(flatten)]
        pub extended_resource_properties: ExtendedResourceProperties,
        #[doc = "A system generated property that specified the addressable path of the collections resource."]
        #[serde(rename = "_colls", default, skip_serializing_if = "Option::is_none")]
        pub colls: Option<String>,
        #[doc = "A system generated property that specifies the addressable path of the users resource."]
        #[serde(rename = "_users", default, skip_serializing_if = "Option::is_none")]
        pub users: Option<String>,
    }
    impl Resource {
        pub fn new(sql_database_resource: SqlDatabaseResource) -> Self {
            Self {
                sql_database_resource,
                extended_resource_properties: ExtendedResourceProperties::default(),
                colls: None,
                users: None,
            }
        }
    }
}
#[doc = "An Azure Cosmos DB SQL database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDatabaseGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB SQL database"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlDatabaseGetProperties>,
}
impl SqlDatabaseGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the SQL databases and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDatabaseListResult {
    #[doc = "List of SQL databases and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlDatabaseGetResults>,
}
impl SqlDatabaseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB SQL database resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDatabaseResource {
    #[doc = "Name of the Cosmos DB SQL database"]
    pub id: String,
}
impl SqlDatabaseResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "Parameters to create and update Cosmos DB storedProcedure."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlStoredProcedureCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB storedProcedure."]
    pub properties: SqlStoredProcedureCreateUpdateProperties,
}
impl SqlStoredProcedureCreateUpdateParameters {
    pub fn new(properties: SqlStoredProcedureCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB storedProcedure."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlStoredProcedureCreateUpdateProperties {
    #[doc = "Cosmos DB SQL storedProcedure resource object"]
    pub resource: SqlStoredProcedureResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl SqlStoredProcedureCreateUpdateProperties {
    pub fn new(resource: SqlStoredProcedureResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB StoredProcedure"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlStoredProcedureGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl SqlStoredProcedureGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB storedProcedure."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlStoredProcedureGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB StoredProcedure"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlStoredProcedureGetProperties>,
}
impl SqlStoredProcedureGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the storedProcedures and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlStoredProcedureListResult {
    #[doc = "List of storedProcedures and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlStoredProcedureGetResults>,
}
impl SqlStoredProcedureListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB SQL storedProcedure resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlStoredProcedureResource {
    #[doc = "Name of the Cosmos DB SQL storedProcedure"]
    pub id: String,
    #[doc = "Body of the Stored Procedure"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
}
impl SqlStoredProcedureResource {
    pub fn new(id: String) -> Self {
        Self { id, body: None }
    }
}
#[doc = "Parameters to create and update Cosmos DB trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlTriggerCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB trigger."]
    pub properties: SqlTriggerCreateUpdateProperties,
}
impl SqlTriggerCreateUpdateParameters {
    pub fn new(properties: SqlTriggerCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlTriggerCreateUpdateProperties {
    #[doc = "Cosmos DB SQL trigger resource object"]
    pub resource: SqlTriggerResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl SqlTriggerCreateUpdateProperties {
    pub fn new(resource: SqlTriggerResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB trigger"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlTriggerGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl SqlTriggerGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlTriggerGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB trigger"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlTriggerGetProperties>,
}
impl SqlTriggerGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the triggers and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlTriggerListResult {
    #[doc = "List of triggers and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlTriggerGetResults>,
}
impl SqlTriggerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB SQL trigger resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlTriggerResource {
    #[doc = "Name of the Cosmos DB SQL trigger"]
    pub id: String,
    #[doc = "Body of the Trigger"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    #[doc = "Type of the Trigger"]
    #[serde(rename = "triggerType", default, skip_serializing_if = "Option::is_none")]
    pub trigger_type: Option<sql_trigger_resource::TriggerType>,
    #[doc = "The operation the trigger is associated with"]
    #[serde(rename = "triggerOperation", default, skip_serializing_if = "Option::is_none")]
    pub trigger_operation: Option<sql_trigger_resource::TriggerOperation>,
}
impl SqlTriggerResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            body: None,
            trigger_type: None,
            trigger_operation: None,
        }
    }
}
pub mod sql_trigger_resource {
    use super::*;
    #[doc = "Type of the Trigger"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TriggerType {
        Pre,
        Post,
    }
    #[doc = "The operation the trigger is associated with"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TriggerOperation {
        All,
        Create,
        Update,
        Delete,
        Replace,
    }
}
#[doc = "Parameters to create and update Cosmos DB userDefinedFunction."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlUserDefinedFunctionCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB userDefinedFunction."]
    pub properties: SqlUserDefinedFunctionCreateUpdateProperties,
}
impl SqlUserDefinedFunctionCreateUpdateParameters {
    pub fn new(properties: SqlUserDefinedFunctionCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB userDefinedFunction."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlUserDefinedFunctionCreateUpdateProperties {
    #[doc = "Cosmos DB SQL userDefinedFunction resource object"]
    pub resource: SqlUserDefinedFunctionResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl SqlUserDefinedFunctionCreateUpdateProperties {
    pub fn new(resource: SqlUserDefinedFunctionResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos DB userDefinedFunction"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlUserDefinedFunctionGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl SqlUserDefinedFunctionGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB userDefinedFunction."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlUserDefinedFunctionGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB userDefinedFunction"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlUserDefinedFunctionGetProperties>,
}
impl SqlUserDefinedFunctionGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the userDefinedFunctions and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlUserDefinedFunctionListResult {
    #[doc = "List of userDefinedFunctions and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlUserDefinedFunctionGetResults>,
}
impl SqlUserDefinedFunctionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB SQL userDefinedFunction resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlUserDefinedFunctionResource {
    #[doc = "Name of the Cosmos DB SQL userDefinedFunction"]
    pub id: String,
    #[doc = "Body of the User Defined Function"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
}
impl SqlUserDefinedFunctionResource {
    pub fn new(id: String) -> Self {
        Self { id, body: None }
    }
}
#[doc = "Parameters to create and update Cosmos DB Table."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TableCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to create and update Azure Cosmos DB Table."]
    pub properties: TableCreateUpdateProperties,
}
impl TableCreateUpdateParameters {
    pub fn new(properties: TableCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to create and update Azure Cosmos DB Table."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TableCreateUpdateProperties {
    #[doc = "Cosmos DB table resource object"]
    pub resource: TableResource,
    #[doc = "CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are \"If-Match\", \"If-None-Match\", \"Session-Token\" and \"Throughput\""]
    pub options: CreateUpdateOptions,
}
impl TableCreateUpdateProperties {
    pub fn new(resource: TableResource, options: CreateUpdateOptions) -> Self {
        Self { resource, options }
    }
}
#[doc = "The properties of an Azure Cosmos Table"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TableGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl TableGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB Table."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TableGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos Table"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TableGetProperties>,
}
impl TableGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List operation response, that contains the Table and their properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TableListResult {
    #[doc = "List of Table and their properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TableGetResults>,
}
impl TableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB table resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TableResource {
    #[doc = "Name of the Cosmos DB table"]
    pub id: String,
}
impl TableResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with \"defaultExperience\": \"Cassandra\". Current \"defaultExperience\" values also include \"Table\", \"Graph\", \"DocumentDB\", and \"MongoDB\"."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Tags {}
impl Tags {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of an Azure Cosmos DB resource throughput"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThroughputSettingsGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl ThroughputSettingsGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure Cosmos DB resource throughput."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThroughputSettingsGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "The properties of an Azure Cosmos DB resource throughput"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ThroughputSettingsGetProperties>,
}
impl ThroughputSettingsGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cosmos DB resource throughput object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThroughputSettingsResource {
    #[doc = "Value of the Cosmos DB resource throughput"]
    pub throughput: i64,
    #[doc = "The minimum throughput of the resource"]
    #[serde(rename = "minimumThroughput", default, skip_serializing_if = "Option::is_none")]
    pub minimum_throughput: Option<String>,
    #[doc = "The throughput replace is pending"]
    #[serde(rename = "offerReplacePending", default, skip_serializing_if = "Option::is_none")]
    pub offer_replace_pending: Option<String>,
}
impl ThroughputSettingsResource {
    pub fn new(throughput: i64) -> Self {
        Self {
            throughput,
            minimum_throughput: None,
            offer_replace_pending: None,
        }
    }
}
#[doc = "Parameters to update Cosmos DB resource throughput."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThroughputSettingsUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[doc = "Properties to update Azure Cosmos DB resource throughput."]
    pub properties: ThroughputSettingsUpdateProperties,
}
impl ThroughputSettingsUpdateParameters {
    pub fn new(properties: ThroughputSettingsUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[doc = "Properties to update Azure Cosmos DB resource throughput."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThroughputSettingsUpdateProperties {
    #[doc = "Cosmos DB resource throughput object"]
    pub resource: ThroughputSettingsResource,
}
impl ThroughputSettingsUpdateProperties {
    pub fn new(resource: ThroughputSettingsResource) -> Self {
        Self { resource }
    }
}
#[doc = "The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UniqueKey {
    #[doc = "List of paths must be unique for each document in the Azure Cosmos DB service"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub paths: Vec<Path>,
}
impl UniqueKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UniqueKeyPolicy {
    #[doc = "List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service."]
    #[serde(rename = "uniqueKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub unique_keys: Vec<UniqueKey>,
}
impl UniqueKeyPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The unit of the metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum UnitType {
    Count,
    Bytes,
    Seconds,
    Percent,
    CountPerSecond,
    BytesPerSecond,
    Milliseconds,
}
#[doc = "The usage data for a usage request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Usage {
    #[doc = "The unit of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<UnitType>,
    #[doc = "A metric name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
    #[doc = "The quota period used to summarize the usage values."]
    #[serde(rename = "quotaPeriod", default, skip_serializing_if = "Option::is_none")]
    pub quota_period: Option<String>,
    #[doc = "Maximum value for this metric"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "Current value for this metric"]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
}
impl Usage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list usage request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsagesResult {
    #[doc = "The list of usages for the database. A usage is a point in time metric"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
}
impl UsagesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Network ACL Rule object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkRule {
    #[doc = "Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Create firewall rule before the virtual network has vnet service endpoint enabled."]
    #[serde(rename = "ignoreMissingVNetServiceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub ignore_missing_v_net_service_endpoint: Option<bool>,
}
impl VirtualNetworkRule {
    pub fn new() -> Self {
        Self::default()
    }
}
