#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmProxyResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ArmProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmResourceProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<Tags>,
}
impl ArmResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AnalyticalStorageConfiguration {
    #[serde(rename = "schemaType", default, skip_serializing_if = "Option::is_none")]
    pub schema_type: Option<AnalyticalStorageSchemaType>,
}
impl AnalyticalStorageConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AnalyticalStorageSchemaType {
    WellDefined,
    FullFidelity,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiProperties {
    #[serde(rename = "serverVersion", default, skip_serializing_if = "Option::is_none")]
    pub server_version: Option<api_properties::ServerVersion>,
}
impl ApiProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod api_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServerVersion {
        #[serde(rename = "3.2")]
        N3_2,
        #[serde(rename = "3.6")]
        N3_6,
        #[serde(rename = "4.0")]
        N4_0,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoUpgradePolicyResource {
    #[serde(rename = "throughputPolicy", default, skip_serializing_if = "Option::is_none")]
    pub throughput_policy: Option<ThroughputPolicyResource>,
}
impl AutoUpgradePolicyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoscaleSettings {
    #[serde(rename = "maxThroughput", default, skip_serializing_if = "Option::is_none")]
    pub max_throughput: Option<i64>,
}
impl AutoscaleSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoscaleSettingsResource {
    #[serde(rename = "maxThroughput")]
    pub max_throughput: i64,
    #[serde(rename = "autoUpgradePolicy", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_policy: Option<AutoUpgradePolicyResource>,
    #[serde(rename = "targetMaxThroughput", default, skip_serializing_if = "Option::is_none")]
    pub target_max_throughput: Option<i64>,
}
impl AutoscaleSettingsResource {
    pub fn new(max_throughput: i64) -> Self {
        Self {
            max_throughput,
            auto_upgrade_policy: None,
            target_max_throughput: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupPolicy {
    #[serde(rename = "type")]
    pub type_: BackupPolicyType,
}
impl BackupPolicy {
    pub fn new(type_: BackupPolicyType) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum BackupPolicyType {
    Periodic,
    Continuous,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Capability {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl Capability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraKeyspaceCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: CassandraKeyspaceCreateUpdateProperties,
}
impl CassandraKeyspaceCreateUpdateParameters {
    pub fn new(properties: CassandraKeyspaceCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraKeyspaceCreateUpdateProperties {
    pub resource: CassandraKeyspaceResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl CassandraKeyspaceCreateUpdateProperties {
    pub fn new(resource: CassandraKeyspaceResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraKeyspaceGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl CassandraKeyspaceGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraKeyspaceGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CassandraKeyspaceGetProperties>,
}
impl CassandraKeyspaceGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraKeyspaceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CassandraKeyspaceGetResults>,
}
impl CassandraKeyspaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraKeyspaceResource {
    pub id: String,
}
impl CassandraKeyspaceResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraPartitionKey {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl CassandraPartitionKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraSchema {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<Column>,
    #[serde(rename = "partitionKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_keys: Vec<CassandraPartitionKey>,
    #[serde(rename = "clusterKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub cluster_keys: Vec<ClusterKey>,
}
impl CassandraSchema {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraTableCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: CassandraTableCreateUpdateProperties,
}
impl CassandraTableCreateUpdateParameters {
    pub fn new(properties: CassandraTableCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraTableCreateUpdateProperties {
    pub resource: CassandraTableResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl CassandraTableCreateUpdateProperties {
    pub fn new(resource: CassandraTableResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraTableGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl CassandraTableGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraTableGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CassandraTableGetProperties>,
}
impl CassandraTableGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraTableListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CassandraTableGetResults>,
}
impl CassandraTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraTableResource {
    pub id: String,
    #[serde(rename = "defaultTtl", default, skip_serializing_if = "Option::is_none")]
    pub default_ttl: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<CassandraSchema>,
    #[serde(rename = "analyticalStorageTtl", default, skip_serializing_if = "Option::is_none")]
    pub analytical_storage_ttl: Option<i64>,
}
impl CassandraTableResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            default_ttl: None,
            schema: None,
            analytical_storage_ttl: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClusterKey {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "orderBy", default, skip_serializing_if = "Option::is_none")]
    pub order_by: Option<String>,
}
impl ClusterKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Column {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Column {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CompositePath {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub order: Option<composite_path::Order>,
}
impl CompositePath {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod composite_path {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Order {
        #[serde(rename = "ascending")]
        Ascending,
        #[serde(rename = "descending")]
        Descending,
    }
}
pub type CompositePathList = Vec<CompositePath>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConflictResolutionPolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<conflict_resolution_policy::Mode>,
    #[serde(rename = "conflictResolutionPath", default, skip_serializing_if = "Option::is_none")]
    pub conflict_resolution_path: Option<String>,
    #[serde(rename = "conflictResolutionProcedure", default, skip_serializing_if = "Option::is_none")]
    pub conflict_resolution_procedure: Option<String>,
}
impl ConflictResolutionPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod conflict_resolution_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        LastWriterWins,
        Custom,
    }
    impl Default for Mode {
        fn default() -> Self {
            Self::LastWriterWins
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConnectorOffer {
    Small,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsistencyPolicy {
    #[serde(rename = "defaultConsistencyLevel")]
    pub default_consistency_level: consistency_policy::DefaultConsistencyLevel,
    #[serde(rename = "maxStalenessPrefix", default, skip_serializing_if = "Option::is_none")]
    pub max_staleness_prefix: Option<i64>,
    #[serde(rename = "maxIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub max_interval_in_seconds: Option<i32>,
}
impl ConsistencyPolicy {
    pub fn new(default_consistency_level: consistency_policy::DefaultConsistencyLevel) -> Self {
        Self {
            default_consistency_level,
            max_staleness_prefix: None,
            max_interval_in_seconds: None,
        }
    }
}
pub mod consistency_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DefaultConsistencyLevel {
        Eventual,
        Session,
        BoundedStaleness,
        Strong,
        ConsistentPrefix,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerPartitionKey {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub paths: Vec<Path>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<container_partition_key::Kind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i32>,
    #[serde(rename = "systemKey", default, skip_serializing_if = "Option::is_none")]
    pub system_key: Option<bool>,
}
impl ContainerPartitionKey {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod container_partition_key {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Hash,
        Range,
        MultiHash,
    }
    impl Default for Kind {
        fn default() -> Self {
            Self::Hash
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContinuousModeBackupPolicy {
    #[serde(flatten)]
    pub backup_policy: BackupPolicy,
}
impl ContinuousModeBackupPolicy {
    pub fn new(backup_policy: BackupPolicy) -> Self {
        Self { backup_policy }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CorsPolicy {
    #[serde(rename = "allowedOrigins")]
    pub allowed_origins: String,
    #[serde(rename = "allowedMethods", default, skip_serializing_if = "Option::is_none")]
    pub allowed_methods: Option<String>,
    #[serde(rename = "allowedHeaders", default, skip_serializing_if = "Option::is_none")]
    pub allowed_headers: Option<String>,
    #[serde(rename = "exposedHeaders", default, skip_serializing_if = "Option::is_none")]
    pub exposed_headers: Option<String>,
    #[serde(rename = "maxAgeInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub max_age_in_seconds: Option<i64>,
}
impl CorsPolicy {
    pub fn new(allowed_origins: String) -> Self {
        Self {
            allowed_origins,
            allowed_methods: None,
            allowed_headers: None,
            exposed_headers: None,
            max_age_in_seconds: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateUpdateOptions {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub throughput: Option<i64>,
    #[serde(rename = "autoscaleSettings", default, skip_serializing_if = "Option::is_none")]
    pub autoscale_settings: Option<AutoscaleSettings>,
}
impl CreateUpdateOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountConnectionString {
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl DatabaseAccountConnectionString {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseAccountCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<database_account_create_update_parameters::Kind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
    pub properties: DatabaseAccountCreateUpdateProperties,
}
impl DatabaseAccountCreateUpdateParameters {
    pub fn new(properties: DatabaseAccountCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            kind: None,
            identity: None,
            properties,
        }
    }
}
pub mod database_account_create_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "GlobalDocumentDB")]
        GlobalDocumentDb,
        #[serde(rename = "MongoDB")]
        MongoDb,
        Parse,
    }
    impl Default for Kind {
        fn default() -> Self {
            Self::GlobalDocumentDb
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseAccountCreateUpdateProperties {
    #[serde(rename = "consistencyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub consistency_policy: Option<ConsistencyPolicy>,
    pub locations: Vec<Location>,
    #[serde(rename = "databaseAccountOfferType")]
    pub database_account_offer_type: DatabaseAccountOfferType,
    #[serde(rename = "ipRules", default, skip_serializing_if = "Option::is_none")]
    pub ip_rules: Option<IpRules>,
    #[serde(rename = "isVirtualNetworkFilterEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_virtual_network_filter_enabled: Option<bool>,
    #[serde(rename = "enableAutomaticFailover", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_failover: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<VirtualNetworkRule>,
    #[serde(rename = "enableMultipleWriteLocations", default, skip_serializing_if = "Option::is_none")]
    pub enable_multiple_write_locations: Option<bool>,
    #[serde(rename = "enableCassandraConnector", default, skip_serializing_if = "Option::is_none")]
    pub enable_cassandra_connector: Option<bool>,
    #[serde(rename = "connectorOffer", default, skip_serializing_if = "Option::is_none")]
    pub connector_offer: Option<ConnectorOffer>,
    #[serde(rename = "disableKeyBasedMetadataWriteAccess", default, skip_serializing_if = "Option::is_none")]
    pub disable_key_based_metadata_write_access: Option<bool>,
    #[serde(rename = "keyVaultKeyUri", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_key_uri: Option<String>,
    #[serde(rename = "defaultIdentity", default, skip_serializing_if = "Option::is_none")]
    pub default_identity: Option<String>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<PublicNetworkAccess>,
    #[serde(rename = "enableFreeTier", default, skip_serializing_if = "Option::is_none")]
    pub enable_free_tier: Option<bool>,
    #[serde(rename = "apiProperties", default, skip_serializing_if = "Option::is_none")]
    pub api_properties: Option<ApiProperties>,
    #[serde(rename = "enableAnalyticalStorage", default, skip_serializing_if = "Option::is_none")]
    pub enable_analytical_storage: Option<bool>,
    #[serde(rename = "analyticalStorageConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub analytical_storage_configuration: Option<AnalyticalStorageConfiguration>,
    #[serde(rename = "backupPolicy", default, skip_serializing_if = "Option::is_none")]
    pub backup_policy: Option<BackupPolicy>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub cors: Vec<CorsPolicy>,
    #[serde(rename = "networkAclBypass", default, skip_serializing_if = "Option::is_none")]
    pub network_acl_bypass: Option<NetworkAclBypass>,
    #[serde(rename = "networkAclBypassResourceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub network_acl_bypass_resource_ids: Vec<String>,
}
impl DatabaseAccountCreateUpdateProperties {
    pub fn new(locations: Vec<Location>, database_account_offer_type: DatabaseAccountOfferType) -> Self {
        Self {
            consistency_policy: None,
            locations,
            database_account_offer_type,
            ip_rules: None,
            is_virtual_network_filter_enabled: None,
            enable_automatic_failover: None,
            capabilities: Vec::new(),
            virtual_network_rules: Vec::new(),
            enable_multiple_write_locations: None,
            enable_cassandra_connector: None,
            connector_offer: None,
            disable_key_based_metadata_write_access: None,
            key_vault_key_uri: None,
            default_identity: None,
            public_network_access: None,
            enable_free_tier: None,
            api_properties: None,
            enable_analytical_storage: None,
            analytical_storage_configuration: None,
            backup_policy: None,
            cors: Vec::new(),
            network_acl_bypass: None,
            network_acl_bypass_resource_ids: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountGetProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "documentEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub document_endpoint: Option<String>,
    #[serde(rename = "databaseAccountOfferType", default, skip_serializing_if = "Option::is_none")]
    pub database_account_offer_type: Option<DatabaseAccountOfferType>,
    #[serde(rename = "ipRules", default, skip_serializing_if = "Option::is_none")]
    pub ip_rules: Option<IpRules>,
    #[serde(rename = "isVirtualNetworkFilterEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_virtual_network_filter_enabled: Option<bool>,
    #[serde(rename = "enableAutomaticFailover", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_failover: Option<bool>,
    #[serde(rename = "consistencyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub consistency_policy: Option<ConsistencyPolicy>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
    #[serde(rename = "writeLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub write_locations: Vec<Location>,
    #[serde(rename = "readLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub read_locations: Vec<Location>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<Location>,
    #[serde(rename = "failoverPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub failover_policies: Vec<FailoverPolicy>,
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<VirtualNetworkRule>,
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[serde(rename = "enableMultipleWriteLocations", default, skip_serializing_if = "Option::is_none")]
    pub enable_multiple_write_locations: Option<bool>,
    #[serde(rename = "enableCassandraConnector", default, skip_serializing_if = "Option::is_none")]
    pub enable_cassandra_connector: Option<bool>,
    #[serde(rename = "connectorOffer", default, skip_serializing_if = "Option::is_none")]
    pub connector_offer: Option<ConnectorOffer>,
    #[serde(rename = "disableKeyBasedMetadataWriteAccess", default, skip_serializing_if = "Option::is_none")]
    pub disable_key_based_metadata_write_access: Option<bool>,
    #[serde(rename = "keyVaultKeyUri", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_key_uri: Option<String>,
    #[serde(rename = "defaultIdentity", default, skip_serializing_if = "Option::is_none")]
    pub default_identity: Option<String>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<PublicNetworkAccess>,
    #[serde(rename = "enableFreeTier", default, skip_serializing_if = "Option::is_none")]
    pub enable_free_tier: Option<bool>,
    #[serde(rename = "apiProperties", default, skip_serializing_if = "Option::is_none")]
    pub api_properties: Option<ApiProperties>,
    #[serde(rename = "enableAnalyticalStorage", default, skip_serializing_if = "Option::is_none")]
    pub enable_analytical_storage: Option<bool>,
    #[serde(rename = "analyticalStorageConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub analytical_storage_configuration: Option<AnalyticalStorageConfiguration>,
    #[serde(rename = "backupPolicy", default, skip_serializing_if = "Option::is_none")]
    pub backup_policy: Option<BackupPolicy>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub cors: Vec<CorsPolicy>,
    #[serde(rename = "networkAclBypass", default, skip_serializing_if = "Option::is_none")]
    pub network_acl_bypass: Option<NetworkAclBypass>,
    #[serde(rename = "networkAclBypassResourceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub network_acl_bypass_resource_ids: Vec<String>,
}
impl DatabaseAccountGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<database_account_get_results::Kind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseAccountGetProperties>,
}
impl DatabaseAccountGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod database_account_get_results {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "GlobalDocumentDB")]
        GlobalDocumentDb,
        #[serde(rename = "MongoDB")]
        MongoDb,
        Parse,
    }
    impl Default for Kind {
        fn default() -> Self {
            Self::GlobalDocumentDb
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountListConnectionStringsResult {
    #[serde(rename = "connectionStrings", default, skip_serializing_if = "Vec::is_empty")]
    pub connection_strings: Vec<DatabaseAccountConnectionString>,
}
impl DatabaseAccountListConnectionStringsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountListKeysResult {
    #[serde(flatten)]
    pub database_account_list_read_only_keys_result: DatabaseAccountListReadOnlyKeysResult,
    #[serde(rename = "primaryMasterKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_master_key: Option<String>,
    #[serde(rename = "secondaryMasterKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_master_key: Option<String>,
}
impl DatabaseAccountListKeysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountListReadOnlyKeysResult {
    #[serde(rename = "primaryReadonlyMasterKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_readonly_master_key: Option<String>,
    #[serde(rename = "secondaryReadonlyMasterKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_readonly_master_key: Option<String>,
}
impl DatabaseAccountListReadOnlyKeysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DatabaseAccountOfferType {
    Standard,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseAccountRegenerateKeyParameters {
    #[serde(rename = "keyKind")]
    pub key_kind: database_account_regenerate_key_parameters::KeyKind,
}
impl DatabaseAccountRegenerateKeyParameters {
    pub fn new(key_kind: database_account_regenerate_key_parameters::KeyKind) -> Self {
        Self { key_kind }
    }
}
pub mod database_account_regenerate_key_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyKind {
        #[serde(rename = "primary")]
        Primary,
        #[serde(rename = "secondary")]
        Secondary,
        #[serde(rename = "primaryReadonly")]
        PrimaryReadonly,
        #[serde(rename = "secondaryReadonly")]
        SecondaryReadonly,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<Tags>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseAccountUpdateProperties>,
}
impl DatabaseAccountUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountUpdateProperties {
    #[serde(rename = "consistencyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub consistency_policy: Option<ConsistencyPolicy>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<Location>,
    #[serde(rename = "ipRules", default, skip_serializing_if = "Option::is_none")]
    pub ip_rules: Option<IpRules>,
    #[serde(rename = "isVirtualNetworkFilterEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_virtual_network_filter_enabled: Option<bool>,
    #[serde(rename = "enableAutomaticFailover", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_failover: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<VirtualNetworkRule>,
    #[serde(rename = "enableMultipleWriteLocations", default, skip_serializing_if = "Option::is_none")]
    pub enable_multiple_write_locations: Option<bool>,
    #[serde(rename = "enableCassandraConnector", default, skip_serializing_if = "Option::is_none")]
    pub enable_cassandra_connector: Option<bool>,
    #[serde(rename = "connectorOffer", default, skip_serializing_if = "Option::is_none")]
    pub connector_offer: Option<ConnectorOffer>,
    #[serde(rename = "disableKeyBasedMetadataWriteAccess", default, skip_serializing_if = "Option::is_none")]
    pub disable_key_based_metadata_write_access: Option<bool>,
    #[serde(rename = "keyVaultKeyUri", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_key_uri: Option<String>,
    #[serde(rename = "defaultIdentity", default, skip_serializing_if = "Option::is_none")]
    pub default_identity: Option<String>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<PublicNetworkAccess>,
    #[serde(rename = "enableFreeTier", default, skip_serializing_if = "Option::is_none")]
    pub enable_free_tier: Option<bool>,
    #[serde(rename = "apiProperties", default, skip_serializing_if = "Option::is_none")]
    pub api_properties: Option<ApiProperties>,
    #[serde(rename = "enableAnalyticalStorage", default, skip_serializing_if = "Option::is_none")]
    pub enable_analytical_storage: Option<bool>,
    #[serde(rename = "analyticalStorageConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub analytical_storage_configuration: Option<AnalyticalStorageConfiguration>,
    #[serde(rename = "backupPolicy", default, skip_serializing_if = "Option::is_none")]
    pub backup_policy: Option<BackupPolicy>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub cors: Vec<CorsPolicy>,
    #[serde(rename = "networkAclBypass", default, skip_serializing_if = "Option::is_none")]
    pub network_acl_bypass: Option<NetworkAclBypass>,
    #[serde(rename = "networkAclBypassResourceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub network_acl_bypass_resource_ids: Vec<String>,
}
impl DatabaseAccountUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAccountsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DatabaseAccountGetResults>,
}
impl DatabaseAccountsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExcludedPath {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl ExcludedPath {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedResourceProperties {
    #[serde(rename = "_rid", default, skip_serializing_if = "Option::is_none")]
    pub rid: Option<String>,
    #[serde(rename = "_ts", default, skip_serializing_if = "Option::is_none")]
    pub ts: Option<f64>,
    #[serde(rename = "_etag", default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExtendedResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FailoverPolicies {
    #[serde(rename = "failoverPolicies")]
    pub failover_policies: Vec<FailoverPolicy>,
}
impl FailoverPolicies {
    pub fn new(failover_policies: Vec<FailoverPolicy>) -> Self {
        Self { failover_policies }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverPolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "locationName", default, skip_serializing_if = "Option::is_none")]
    pub location_name: Option<String>,
    #[serde(rename = "failoverPriority", default, skip_serializing_if = "Option::is_none")]
    pub failover_priority: Option<i32>,
}
impl FailoverPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinDatabaseCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: GremlinDatabaseCreateUpdateProperties,
}
impl GremlinDatabaseCreateUpdateParameters {
    pub fn new(properties: GremlinDatabaseCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinDatabaseCreateUpdateProperties {
    pub resource: GremlinDatabaseResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl GremlinDatabaseCreateUpdateProperties {
    pub fn new(resource: GremlinDatabaseResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinDatabaseGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl GremlinDatabaseGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinDatabaseGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GremlinDatabaseGetProperties>,
}
impl GremlinDatabaseGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinDatabaseListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GremlinDatabaseGetResults>,
}
impl GremlinDatabaseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinDatabaseResource {
    pub id: String,
}
impl GremlinDatabaseResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinGraphCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: GremlinGraphCreateUpdateProperties,
}
impl GremlinGraphCreateUpdateParameters {
    pub fn new(properties: GremlinGraphCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinGraphCreateUpdateProperties {
    pub resource: GremlinGraphResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl GremlinGraphCreateUpdateProperties {
    pub fn new(resource: GremlinGraphResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinGraphGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl GremlinGraphGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinGraphGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GremlinGraphGetProperties>,
}
impl GremlinGraphGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GremlinGraphListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GremlinGraphGetResults>,
}
impl GremlinGraphListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GremlinGraphResource {
    pub id: String,
    #[serde(rename = "indexingPolicy", default, skip_serializing_if = "Option::is_none")]
    pub indexing_policy: Option<IndexingPolicy>,
    #[serde(rename = "partitionKey", default, skip_serializing_if = "Option::is_none")]
    pub partition_key: Option<ContainerPartitionKey>,
    #[serde(rename = "defaultTtl", default, skip_serializing_if = "Option::is_none")]
    pub default_ttl: Option<i64>,
    #[serde(rename = "uniqueKeyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub unique_key_policy: Option<UniqueKeyPolicy>,
    #[serde(rename = "conflictResolutionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub conflict_resolution_policy: Option<ConflictResolutionPolicy>,
}
impl GremlinGraphResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            indexing_policy: None,
            partition_key: None,
            default_ttl: None,
            unique_key_policy: None,
            conflict_resolution_policy: None,
        }
    }
}
pub type IpRules = Vec<IpAddressOrRange>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncludedPath {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub indexes: Vec<Indexes>,
}
impl IncludedPath {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Indexes {
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<indexes::DataType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub precision: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<indexes::Kind>,
}
impl Indexes {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod indexes {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataType {
        String,
        Number,
        Point,
        Polygon,
        LineString,
        MultiPolygon,
    }
    impl Default for DataType {
        fn default() -> Self {
            Self::String
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Hash,
        Range,
        Spatial,
    }
    impl Default for Kind {
        fn default() -> Self {
            Self::Hash
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IndexingPolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub automatic: Option<bool>,
    #[serde(rename = "indexingMode", default, skip_serializing_if = "Option::is_none")]
    pub indexing_mode: Option<indexing_policy::IndexingMode>,
    #[serde(rename = "includedPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub included_paths: Vec<IncludedPath>,
    #[serde(rename = "excludedPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub excluded_paths: Vec<ExcludedPath>,
    #[serde(rename = "compositeIndexes", default, skip_serializing_if = "Vec::is_empty")]
    pub composite_indexes: Vec<CompositePathList>,
    #[serde(rename = "spatialIndexes", default, skip_serializing_if = "Vec::is_empty")]
    pub spatial_indexes: Vec<SpatialSpec>,
}
impl IndexingPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod indexing_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IndexingMode {
        #[serde(rename = "consistent")]
        Consistent,
        #[serde(rename = "lazy")]
        Lazy,
        #[serde(rename = "none")]
        None,
    }
    impl Default for IndexingMode {
        fn default() -> Self {
            Self::Consistent
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressOrRange {
    #[serde(rename = "ipAddressOrRange", default, skip_serializing_if = "Option::is_none")]
    pub ip_address_or_range: Option<String>,
}
impl IpAddressOrRange {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type Key = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Location {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "locationName", default, skip_serializing_if = "Option::is_none")]
    pub location_name: Option<String>,
    #[serde(rename = "documentEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub document_endpoint: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "failoverPriority", default, skip_serializing_if = "Option::is_none")]
    pub failover_priority: Option<i32>,
    #[serde(rename = "isZoneRedundant", default, skip_serializing_if = "Option::is_none")]
    pub is_zone_redundant: Option<bool>,
}
impl Location {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedServiceIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<managed_service_identity::Type>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl ManagedServiceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_service_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned,UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Metric {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<UnitType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
    #[serde(rename = "metricValues", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_values: Vec<MetricValue>,
}
impl Metric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricAvailability {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
}
impl MetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricDefinition {
    #[serde(rename = "metricAvailabilities", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_availabilities: Vec<MetricAvailability>,
    #[serde(rename = "primaryAggregationType", default, skip_serializing_if = "Option::is_none")]
    pub primary_aggregation_type: Option<metric_definition::PrimaryAggregationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<UnitType>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
}
impl MetricDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod metric_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrimaryAggregationType {
        None,
        Average,
        Total,
        Minimum,
        Maximum,
        Last,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricDefinitionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MetricDefinition>,
}
impl MetricDefinitionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Metric>,
}
impl MetricListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl MetricName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricValue {
    #[serde(rename = "_count", default, skip_serializing_if = "Option::is_none")]
    pub count: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub average: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<f64>,
}
impl MetricValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: MongoDbCollectionCreateUpdateProperties,
}
impl MongoDbCollectionCreateUpdateParameters {
    pub fn new(properties: MongoDbCollectionCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionCreateUpdateProperties {
    pub resource: MongoDbCollectionResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl MongoDbCollectionCreateUpdateProperties {
    pub fn new(resource: MongoDbCollectionResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbCollectionGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl MongoDbCollectionGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbCollectionGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MongoDbCollectionGetProperties>,
}
impl MongoDbCollectionGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbCollectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MongoDbCollectionGetResults>,
}
impl MongoDbCollectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionResource {
    pub id: String,
    #[serde(rename = "shardKey", default, skip_serializing_if = "Option::is_none")]
    pub shard_key: Option<ShardKeys>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub indexes: Vec<MongoIndex>,
    #[serde(rename = "analyticalStorageTtl", default, skip_serializing_if = "Option::is_none")]
    pub analytical_storage_ttl: Option<i64>,
}
impl MongoDbCollectionResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            shard_key: None,
            indexes: Vec::new(),
            analytical_storage_ttl: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbDatabaseCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: MongoDbDatabaseCreateUpdateProperties,
}
impl MongoDbDatabaseCreateUpdateParameters {
    pub fn new(properties: MongoDbDatabaseCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbDatabaseCreateUpdateProperties {
    pub resource: MongoDbDatabaseResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl MongoDbDatabaseCreateUpdateProperties {
    pub fn new(resource: MongoDbDatabaseResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbDatabaseGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl MongoDbDatabaseGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbDatabaseGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MongoDbDatabaseGetProperties>,
}
impl MongoDbDatabaseGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbDatabaseListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MongoDbDatabaseGetResults>,
}
impl MongoDbDatabaseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbDatabaseResource {
    pub id: String,
}
impl MongoDbDatabaseResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoIndex {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<MongoIndexKeys>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<MongoIndexOptions>,
}
impl MongoIndex {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoIndexKeys {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub keys: Vec<Key>,
}
impl MongoIndexKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoIndexOptions {
    #[serde(rename = "expireAfterSeconds", default, skip_serializing_if = "Option::is_none")]
    pub expire_after_seconds: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unique: Option<bool>,
}
impl MongoIndexOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum NetworkAclBypass {
    None,
    AzureServices,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspace {
    #[serde(flatten)]
    pub arm_proxy_resource: ArmProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NotebookWorkspaceProperties>,
}
impl NotebookWorkspace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspaceConnectionInfoResult {
    #[serde(rename = "authToken", default, skip_serializing_if = "Option::is_none")]
    pub auth_token: Option<String>,
    #[serde(rename = "notebookServerEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub notebook_server_endpoint: Option<String>,
}
impl NotebookWorkspaceConnectionInfoResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspaceCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_proxy_resource: ArmProxyResource,
}
impl NotebookWorkspaceCreateUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspaceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NotebookWorkspace>,
}
impl NotebookWorkspaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookWorkspaceProperties {
    #[serde(rename = "notebookServerEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub notebook_server_endpoint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl NotebookWorkspaceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(rename = "Provider", default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(rename = "Resource", default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(rename = "Operation", default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(rename = "Description", default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OptionsResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub throughput: Option<i64>,
    #[serde(rename = "autoscaleSettings", default, skip_serializing_if = "Option::is_none")]
    pub autoscale_settings: Option<AutoscaleSettings>,
}
impl OptionsResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartitionMetric {
    #[serde(flatten)]
    pub metric: Metric,
    #[serde(rename = "partitionId", default, skip_serializing_if = "Option::is_none")]
    pub partition_id: Option<String>,
    #[serde(rename = "partitionKeyRangeId", default, skip_serializing_if = "Option::is_none")]
    pub partition_key_range_id: Option<String>,
}
impl PartitionMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartitionMetricListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PartitionMetric>,
}
impl PartitionMetricListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartitionUsage {
    #[serde(flatten)]
    pub usage: Usage,
    #[serde(rename = "partitionId", default, skip_serializing_if = "Option::is_none")]
    pub partition_id: Option<String>,
    #[serde(rename = "partitionKeyRangeId", default, skip_serializing_if = "Option::is_none")]
    pub partition_key_range_id: Option<String>,
}
impl PartitionUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartitionUsagesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PartitionUsage>,
}
impl PartitionUsagesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type Path = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PercentileMetric {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<UnitType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
    #[serde(rename = "metricValues", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_values: Vec<PercentileMetricValue>,
}
impl PercentileMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PercentileMetricListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PercentileMetric>,
}
impl PercentileMetricListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PercentileMetricValue {
    #[serde(flatten)]
    pub metric_value: MetricValue,
    #[serde(rename = "P10", default, skip_serializing_if = "Option::is_none")]
    pub p10: Option<f64>,
    #[serde(rename = "P25", default, skip_serializing_if = "Option::is_none")]
    pub p25: Option<f64>,
    #[serde(rename = "P50", default, skip_serializing_if = "Option::is_none")]
    pub p50: Option<f64>,
    #[serde(rename = "P75", default, skip_serializing_if = "Option::is_none")]
    pub p75: Option<f64>,
    #[serde(rename = "P90", default, skip_serializing_if = "Option::is_none")]
    pub p90: Option<f64>,
    #[serde(rename = "P95", default, skip_serializing_if = "Option::is_none")]
    pub p95: Option<f64>,
    #[serde(rename = "P99", default, skip_serializing_if = "Option::is_none")]
    pub p99: Option<f64>,
}
impl PercentileMetricValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PeriodicModeBackupPolicy {
    #[serde(flatten)]
    pub backup_policy: BackupPolicy,
    #[serde(rename = "periodicModeProperties", default, skip_serializing_if = "Option::is_none")]
    pub periodic_mode_properties: Option<PeriodicModeProperties>,
}
impl PeriodicModeBackupPolicy {
    pub fn new(backup_policy: BackupPolicy) -> Self {
        Self {
            backup_policy,
            periodic_mode_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeriodicModeProperties {
    #[serde(rename = "backupIntervalInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub backup_interval_in_minutes: Option<i32>,
    #[serde(rename = "backupRetentionIntervalInHours", default, skip_serializing_if = "Option::is_none")]
    pub backup_retention_interval_in_hours: Option<i32>,
}
impl PeriodicModeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Permission {
    #[serde(rename = "dataActions", default, skip_serializing_if = "Vec::is_empty")]
    pub data_actions: Vec<String>,
    #[serde(rename = "notDataActions", default, skip_serializing_if = "Vec::is_empty")]
    pub not_data_actions: Vec<String>,
}
impl Permission {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnectionProperties>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpointConnection>,
}
impl PrivateEndpointConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionProperties {
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpointProperty>,
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionStateProperty>,
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl PrivateEndpointConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointProperty {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl PrivateEndpointProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResource {
    #[serde(flatten)]
    pub arm_proxy_resource: ArmProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkResourceProperties>,
}
impl PrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateLinkResource>,
}
impl PrivateLinkResourceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceProperties {
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl PrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionStateProperty {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkServiceConnectionStateProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type ProvisioningState = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PublicNetworkAccess {
    Enabled,
    Disabled,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegionForOnlineOffline {
    pub region: String,
}
impl RegionForOnlineOffline {
    pub fn new(region: String) -> Self {
        Self { region }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShardKeys {}
impl ShardKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SpatialSpec {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub types: Vec<SpatialType>,
}
impl SpatialSpec {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SpatialType {
    Point,
    LineString,
    Polygon,
    MultiPolygon,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlContainerCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: SqlContainerCreateUpdateProperties,
}
impl SqlContainerCreateUpdateParameters {
    pub fn new(properties: SqlContainerCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlContainerCreateUpdateProperties {
    pub resource: SqlContainerResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl SqlContainerCreateUpdateProperties {
    pub fn new(resource: SqlContainerResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlContainerGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl SqlContainerGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlContainerGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlContainerGetProperties>,
}
impl SqlContainerGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlContainerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlContainerGetResults>,
}
impl SqlContainerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlContainerResource {
    pub id: String,
    #[serde(rename = "indexingPolicy", default, skip_serializing_if = "Option::is_none")]
    pub indexing_policy: Option<IndexingPolicy>,
    #[serde(rename = "partitionKey", default, skip_serializing_if = "Option::is_none")]
    pub partition_key: Option<ContainerPartitionKey>,
    #[serde(rename = "defaultTtl", default, skip_serializing_if = "Option::is_none")]
    pub default_ttl: Option<i64>,
    #[serde(rename = "uniqueKeyPolicy", default, skip_serializing_if = "Option::is_none")]
    pub unique_key_policy: Option<UniqueKeyPolicy>,
    #[serde(rename = "conflictResolutionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub conflict_resolution_policy: Option<ConflictResolutionPolicy>,
    #[serde(rename = "analyticalStorageTtl", default, skip_serializing_if = "Option::is_none")]
    pub analytical_storage_ttl: Option<i64>,
}
impl SqlContainerResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            indexing_policy: None,
            partition_key: None,
            default_ttl: None,
            unique_key_policy: None,
            conflict_resolution_policy: None,
            analytical_storage_ttl: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDatabaseCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: SqlDatabaseCreateUpdateProperties,
}
impl SqlDatabaseCreateUpdateParameters {
    pub fn new(properties: SqlDatabaseCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDatabaseCreateUpdateProperties {
    pub resource: SqlDatabaseResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl SqlDatabaseCreateUpdateProperties {
    pub fn new(resource: SqlDatabaseResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDatabaseGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<sql_database_get_properties::Resource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl SqlDatabaseGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_database_get_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Resource {
        #[serde(flatten)]
        pub sql_database_resource: SqlDatabaseResource,
        #[serde(flatten)]
        pub extended_resource_properties: ExtendedResourceProperties,
        #[serde(rename = "_colls", default, skip_serializing_if = "Option::is_none")]
        pub colls: Option<String>,
        #[serde(rename = "_users", default, skip_serializing_if = "Option::is_none")]
        pub users: Option<String>,
    }
    impl Resource {
        pub fn new(sql_database_resource: SqlDatabaseResource) -> Self {
            Self {
                sql_database_resource,
                extended_resource_properties: ExtendedResourceProperties::default(),
                colls: None,
                users: None,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDatabaseGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlDatabaseGetProperties>,
}
impl SqlDatabaseGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDatabaseListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlDatabaseGetResults>,
}
impl SqlDatabaseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDatabaseResource {
    pub id: String,
}
impl SqlDatabaseResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlRoleAssignmentCreateUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlRoleAssignmentResource>,
}
impl SqlRoleAssignmentCreateUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlRoleAssignmentGetResults {
    #[serde(flatten)]
    pub arm_proxy_resource: ArmProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlRoleAssignmentResource>,
}
impl SqlRoleAssignmentGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlRoleAssignmentListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlRoleAssignmentGetResults>,
}
impl SqlRoleAssignmentListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlRoleAssignmentResource {
    #[serde(rename = "roleDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub role_definition_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
}
impl SqlRoleAssignmentResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlRoleDefinitionCreateUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlRoleDefinitionResource>,
}
impl SqlRoleDefinitionCreateUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlRoleDefinitionGetResults {
    #[serde(flatten)]
    pub arm_proxy_resource: ArmProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlRoleDefinitionResource>,
}
impl SqlRoleDefinitionGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlRoleDefinitionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlRoleDefinitionGetResults>,
}
impl SqlRoleDefinitionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlRoleDefinitionResource {
    #[serde(rename = "roleName", default, skip_serializing_if = "Option::is_none")]
    pub role_name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<sql_role_definition_resource::Type>,
    #[serde(rename = "assignableScopes", default, skip_serializing_if = "Vec::is_empty")]
    pub assignable_scopes: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub permissions: Vec<Permission>,
}
impl SqlRoleDefinitionResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_role_definition_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        BuiltInRole,
        CustomRole,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlStoredProcedureCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: SqlStoredProcedureCreateUpdateProperties,
}
impl SqlStoredProcedureCreateUpdateParameters {
    pub fn new(properties: SqlStoredProcedureCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlStoredProcedureCreateUpdateProperties {
    pub resource: SqlStoredProcedureResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl SqlStoredProcedureCreateUpdateProperties {
    pub fn new(resource: SqlStoredProcedureResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlStoredProcedureGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl SqlStoredProcedureGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlStoredProcedureGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlStoredProcedureGetProperties>,
}
impl SqlStoredProcedureGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlStoredProcedureListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlStoredProcedureGetResults>,
}
impl SqlStoredProcedureListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlStoredProcedureResource {
    pub id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
}
impl SqlStoredProcedureResource {
    pub fn new(id: String) -> Self {
        Self { id, body: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlTriggerCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: SqlTriggerCreateUpdateProperties,
}
impl SqlTriggerCreateUpdateParameters {
    pub fn new(properties: SqlTriggerCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlTriggerCreateUpdateProperties {
    pub resource: SqlTriggerResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl SqlTriggerCreateUpdateProperties {
    pub fn new(resource: SqlTriggerResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlTriggerGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl SqlTriggerGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlTriggerGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlTriggerGetProperties>,
}
impl SqlTriggerGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlTriggerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlTriggerGetResults>,
}
impl SqlTriggerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlTriggerResource {
    pub id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    #[serde(rename = "triggerType", default, skip_serializing_if = "Option::is_none")]
    pub trigger_type: Option<sql_trigger_resource::TriggerType>,
    #[serde(rename = "triggerOperation", default, skip_serializing_if = "Option::is_none")]
    pub trigger_operation: Option<sql_trigger_resource::TriggerOperation>,
}
impl SqlTriggerResource {
    pub fn new(id: String) -> Self {
        Self {
            id,
            body: None,
            trigger_type: None,
            trigger_operation: None,
        }
    }
}
pub mod sql_trigger_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TriggerType {
        Pre,
        Post,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TriggerOperation {
        All,
        Create,
        Update,
        Delete,
        Replace,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlUserDefinedFunctionCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: SqlUserDefinedFunctionCreateUpdateProperties,
}
impl SqlUserDefinedFunctionCreateUpdateParameters {
    pub fn new(properties: SqlUserDefinedFunctionCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlUserDefinedFunctionCreateUpdateProperties {
    pub resource: SqlUserDefinedFunctionResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl SqlUserDefinedFunctionCreateUpdateProperties {
    pub fn new(resource: SqlUserDefinedFunctionResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlUserDefinedFunctionGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl SqlUserDefinedFunctionGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlUserDefinedFunctionGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlUserDefinedFunctionGetProperties>,
}
impl SqlUserDefinedFunctionGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlUserDefinedFunctionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlUserDefinedFunctionGetResults>,
}
impl SqlUserDefinedFunctionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlUserDefinedFunctionResource {
    pub id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
}
impl SqlUserDefinedFunctionResource {
    pub fn new(id: String) -> Self {
        Self { id, body: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TableCreateUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: TableCreateUpdateProperties,
}
impl TableCreateUpdateParameters {
    pub fn new(properties: TableCreateUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TableCreateUpdateProperties {
    pub resource: TableResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<CreateUpdateOptions>,
}
impl TableCreateUpdateProperties {
    pub fn new(resource: TableResource) -> Self {
        Self { resource, options: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TableGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl TableGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TableGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TableGetProperties>,
}
impl TableGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TableListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TableGetResults>,
}
impl TableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TableResource {
    pub id: String,
}
impl TableResource {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Tags {}
impl Tags {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThroughputPolicyResource {
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
    #[serde(rename = "incrementPercent", default, skip_serializing_if = "Option::is_none")]
    pub increment_percent: Option<i64>,
}
impl ThroughputPolicyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThroughputSettingsGetProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<serde_json::Value>,
}
impl ThroughputSettingsGetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThroughputSettingsGetResults {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ThroughputSettingsGetProperties>,
}
impl ThroughputSettingsGetResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThroughputSettingsResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub throughput: Option<i64>,
    #[serde(rename = "autoscaleSettings", default, skip_serializing_if = "Option::is_none")]
    pub autoscale_settings: Option<AutoscaleSettingsResource>,
    #[serde(rename = "minimumThroughput", default, skip_serializing_if = "Option::is_none")]
    pub minimum_throughput: Option<String>,
    #[serde(rename = "offerReplacePending", default, skip_serializing_if = "Option::is_none")]
    pub offer_replace_pending: Option<String>,
}
impl ThroughputSettingsResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThroughputSettingsUpdateParameters {
    #[serde(flatten)]
    pub arm_resource_properties: ArmResourceProperties,
    pub properties: ThroughputSettingsUpdateProperties,
}
impl ThroughputSettingsUpdateParameters {
    pub fn new(properties: ThroughputSettingsUpdateProperties) -> Self {
        Self {
            arm_resource_properties: ArmResourceProperties::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThroughputSettingsUpdateProperties {
    pub resource: ThroughputSettingsResource,
}
impl ThroughputSettingsUpdateProperties {
    pub fn new(resource: ThroughputSettingsResource) -> Self {
        Self { resource }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UniqueKey {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub paths: Vec<Path>,
}
impl UniqueKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UniqueKeyPolicy {
    #[serde(rename = "uniqueKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub unique_keys: Vec<UniqueKey>,
}
impl UniqueKeyPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum UnitType {
    Count,
    Bytes,
    Seconds,
    Percent,
    CountPerSecond,
    BytesPerSecond,
    Milliseconds,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Usage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<UnitType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
    #[serde(rename = "quotaPeriod", default, skip_serializing_if = "Option::is_none")]
    pub quota_period: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
}
impl Usage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsagesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
}
impl UsagesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "ignoreMissingVNetServiceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub ignore_missing_v_net_service_endpoint: Option<bool>,
}
impl VirtualNetworkRule {
    pub fn new() -> Self {
        Self::default()
    }
}
