#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The agentpool that has the ARM resource and properties. \r\nThe agentpool will have all information to create an agent pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AgentPool {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of agent pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AgentPoolProperties>,
}
impl AgentPool {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The collection of agent pools."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgentPoolListResult {
    #[doc = "The collection value."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AgentPool>,
    #[doc = "The URI that can be used to request the next set of paged results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AgentPoolListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of agent pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgentPoolProperties {
    #[doc = "The count of agent machine"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[doc = "The Tier of agent machine"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[doc = "The OS of agent machine"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub os: Option<agent_pool_properties::Os>,
    #[doc = "The Virtual Network Subnet Resource Id of the agent machine"]
    #[serde(rename = "virtualNetworkSubnetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_subnet_resource_id: Option<String>,
    #[doc = "The provisioning state of this agent pool"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<agent_pool_properties::ProvisioningState>,
}
impl AgentPoolProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod agent_pool_properties {
    use super::*;
    #[doc = "The OS of agent machine"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Os {
        Windows,
        Linux,
    }
    #[doc = "The provisioning state of this agent pool"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgentPoolPropertiesUpdateParameters {
    #[doc = "The count of agent machine"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
}
impl AgentPoolPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The QueueStatus of Agent Pool"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgentPoolQueueStatus {
    #[doc = "The number of pending runs in the queue"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
}
impl AgentPoolQueueStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for updating an agent pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgentPoolUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AgentPoolPropertiesUpdateParameters>,
    #[doc = "The ARM resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl AgentPoolUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties that determine the run agent configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgentProperties {
    #[doc = "The CPU configuration in terms of number of cores required for the run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cpu: Option<i32>,
}
impl AgentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a run argument."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Argument {
    #[doc = "The name of the argument."]
    pub name: String,
    #[doc = "The value of the argument."]
    pub value: String,
    #[doc = "Flag to indicate whether the argument represents a secret and want to be removed from build logs."]
    #[serde(rename = "isSecret", default, skip_serializing_if = "Option::is_none")]
    pub is_secret: Option<bool>,
}
impl Argument {
    pub fn new(name: String, value: String) -> Self {
        Self {
            name,
            value,
            is_secret: None,
        }
    }
}
#[doc = "The authorization properties for accessing the source code repository."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AuthInfo {
    #[doc = "The type of Auth token."]
    #[serde(rename = "tokenType")]
    pub token_type: auth_info::TokenType,
    #[doc = "The access token used to access the source control provider."]
    pub token: String,
    #[doc = "The refresh token used to refresh the access token."]
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<String>,
    #[doc = "The scope of the access token."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[doc = "Time in seconds that the token remains valid"]
    #[serde(rename = "expiresIn", default, skip_serializing_if = "Option::is_none")]
    pub expires_in: Option<i32>,
}
impl AuthInfo {
    pub fn new(token_type: auth_info::TokenType, token: String) -> Self {
        Self {
            token_type,
            token,
            refresh_token: None,
            scope: None,
            expires_in: None,
        }
    }
}
pub mod auth_info {
    use super::*;
    #[doc = "The type of Auth token."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TokenType {
        #[serde(rename = "PAT")]
        Pat,
        OAuth,
    }
}
#[doc = "The authorization properties for accessing the source code repository."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthInfoUpdateParameters {
    #[doc = "The type of Auth token."]
    #[serde(rename = "tokenType", default, skip_serializing_if = "Option::is_none")]
    pub token_type: Option<auth_info_update_parameters::TokenType>,
    #[doc = "The access token used to access the source control provider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub token: Option<String>,
    #[doc = "The refresh token used to refresh the access token."]
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<String>,
    #[doc = "The scope of the access token."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[doc = "Time in seconds that the token remains valid"]
    #[serde(rename = "expiresIn", default, skip_serializing_if = "Option::is_none")]
    pub expires_in: Option<i32>,
}
impl AuthInfoUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod auth_info_update_parameters {
    use super::*;
    #[doc = "The type of Auth token."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TokenType {
        #[serde(rename = "PAT")]
        Pat,
        OAuth,
    }
}
#[doc = "Properties that describe a base image dependency."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BaseImageDependency {
    #[doc = "The type of the base image dependency."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<base_image_dependency::Type>,
    #[doc = "The registry login server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registry: Option<String>,
    #[doc = "The repository name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[doc = "The tag name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[doc = "The sha256-based digest of the image manifest."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub digest: Option<String>,
}
impl BaseImageDependency {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod base_image_dependency {
    use super::*;
    #[doc = "The type of the base image dependency."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        BuildTime,
        RunTime,
    }
}
#[doc = "The trigger based on base image dependency."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseImageTrigger {
    #[doc = "The type of the auto trigger for base image dependency updates."]
    #[serde(rename = "baseImageTriggerType")]
    pub base_image_trigger_type: base_image_trigger::BaseImageTriggerType,
    #[doc = "The endpoint URL for receiving update triggers."]
    #[serde(rename = "updateTriggerEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub update_trigger_endpoint: Option<String>,
    #[doc = "Type of Payload body for Base image update triggers."]
    #[serde(rename = "updateTriggerPayloadType", default, skip_serializing_if = "Option::is_none")]
    pub update_trigger_payload_type: Option<base_image_trigger::UpdateTriggerPayloadType>,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<base_image_trigger::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl BaseImageTrigger {
    pub fn new(base_image_trigger_type: base_image_trigger::BaseImageTriggerType, name: String) -> Self {
        Self {
            base_image_trigger_type,
            update_trigger_endpoint: None,
            update_trigger_payload_type: None,
            status: None,
            name,
        }
    }
}
pub mod base_image_trigger {
    use super::*;
    #[doc = "The type of the auto trigger for base image dependency updates."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BaseImageTriggerType {
        All,
        Runtime,
    }
    #[doc = "Type of Payload body for Base image update triggers."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UpdateTriggerPayloadType {
        Default,
        Token,
    }
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "The properties for updating base image dependency trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseImageTriggerUpdateParameters {
    #[doc = "The type of the auto trigger for base image dependency updates."]
    #[serde(rename = "baseImageTriggerType", default, skip_serializing_if = "Option::is_none")]
    pub base_image_trigger_type: Option<base_image_trigger_update_parameters::BaseImageTriggerType>,
    #[doc = "The endpoint URL for receiving update triggers."]
    #[serde(rename = "updateTriggerEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub update_trigger_endpoint: Option<String>,
    #[doc = "Type of Payload body for Base image update triggers."]
    #[serde(rename = "updateTriggerPayloadType", default, skip_serializing_if = "Option::is_none")]
    pub update_trigger_payload_type: Option<base_image_trigger_update_parameters::UpdateTriggerPayloadType>,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<base_image_trigger_update_parameters::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl BaseImageTriggerUpdateParameters {
    pub fn new(name: String) -> Self {
        Self {
            base_image_trigger_type: None,
            update_trigger_endpoint: None,
            update_trigger_payload_type: None,
            status: None,
            name,
        }
    }
}
pub mod base_image_trigger_update_parameters {
    use super::*;
    #[doc = "The type of the auto trigger for base image dependency updates."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BaseImageTriggerType {
        All,
        Runtime,
    }
    #[doc = "Type of Payload body for Base image update triggers."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UpdateTriggerPayloadType {
        Default,
        Token,
    }
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Credentials {
    #[doc = "Describes the credential parameters for accessing the source registry."]
    #[serde(rename = "sourceRegistry", default, skip_serializing_if = "Option::is_none")]
    pub source_registry: Option<SourceRegistryCredentials>,
    #[doc = "Describes the credential parameters for accessing other custom registries. The key\r\nfor the dictionary item will be the registry login server (myregistry.azurecr.io) and\r\nthe value of the item will be the registry credentials for accessing the registry."]
    #[serde(rename = "customRegistries", default, skip_serializing_if = "Option::is_none")]
    pub custom_registries: Option<serde_json::Value>,
}
impl Credentials {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the credentials that will be used to access a custom registry during a run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomRegistryCredentials {
    #[doc = "Describes the properties of a secret object value."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<SecretObject>,
    #[doc = "Describes the properties of a secret object value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretObject>,
    #[doc = "Indicates the managed identity assigned to the custom credential. If a user-assigned identity\r\nthis value is the Client ID. If a system-assigned identity, the value will be `system`. In\r\nthe case of a system-assigned identity, the Client ID will be determined by the runner. This\r\nidentity may be used to authenticate to key vault to retrieve credentials or it may be the only \r\nsource of authentication used for accessing the registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
}
impl CustomRegistryCredentials {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for a docker quick build."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DockerBuildRequest {
    #[serde(flatten)]
    pub run_request: RunRequest,
    #[doc = "The fully qualified image names including the repository and tag."]
    #[serde(rename = "imageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub image_names: Vec<String>,
    #[doc = "The value of this property indicates whether the image built should be pushed to the registry or not."]
    #[serde(rename = "isPushEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_push_enabled: Option<bool>,
    #[doc = "The value of this property indicates whether the image cache is enabled or not."]
    #[serde(rename = "noCache", default, skip_serializing_if = "Option::is_none")]
    pub no_cache: Option<bool>,
    #[doc = "The Docker file path relative to the source location."]
    #[serde(rename = "dockerFilePath")]
    pub docker_file_path: String,
    #[doc = "The name of the target build stage for the docker build."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The collection of override arguments to be used when executing the run."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<Argument>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "The platform properties against which the run has to happen."]
    pub platform: PlatformProperties,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.\r\nIf it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API."]
    #[serde(rename = "sourceLocation", default, skip_serializing_if = "Option::is_none")]
    pub source_location: Option<String>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
}
impl DockerBuildRequest {
    pub fn new(run_request: RunRequest, docker_file_path: String, platform: PlatformProperties) -> Self {
        Self {
            run_request,
            image_names: Vec::new(),
            is_push_enabled: None,
            no_cache: None,
            docker_file_path,
            target: None,
            arguments: Vec::new(),
            timeout: None,
            platform,
            agent_configuration: None,
            source_location: None,
            credentials: None,
        }
    }
}
#[doc = "The Docker build step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DockerBuildStep {
    #[serde(flatten)]
    pub task_step_properties: TaskStepProperties,
    #[doc = "The fully qualified image names including the repository and tag."]
    #[serde(rename = "imageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub image_names: Vec<String>,
    #[doc = "The value of this property indicates whether the image built should be pushed to the registry or not."]
    #[serde(rename = "isPushEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_push_enabled: Option<bool>,
    #[doc = "The value of this property indicates whether the image cache is enabled or not."]
    #[serde(rename = "noCache", default, skip_serializing_if = "Option::is_none")]
    pub no_cache: Option<bool>,
    #[doc = "The Docker file path relative to the source context."]
    #[serde(rename = "dockerFilePath")]
    pub docker_file_path: String,
    #[doc = "The name of the target build stage for the docker build."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The collection of override arguments to be used when executing this build step."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<Argument>,
}
impl DockerBuildStep {
    pub fn new(task_step_properties: TaskStepProperties, docker_file_path: String) -> Self {
        Self {
            task_step_properties,
            image_names: Vec::new(),
            is_push_enabled: None,
            no_cache: None,
            docker_file_path,
            target: None,
            arguments: Vec::new(),
        }
    }
}
#[doc = "The properties for updating a docker build step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DockerBuildStepUpdateParameters {
    #[serde(flatten)]
    pub task_step_update_parameters: TaskStepUpdateParameters,
    #[doc = "The fully qualified image names including the repository and tag."]
    #[serde(rename = "imageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub image_names: Vec<String>,
    #[doc = "The value of this property indicates whether the image built should be pushed to the registry or not."]
    #[serde(rename = "isPushEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_push_enabled: Option<bool>,
    #[doc = "The value of this property indicates whether the image cache is enabled or not."]
    #[serde(rename = "noCache", default, skip_serializing_if = "Option::is_none")]
    pub no_cache: Option<bool>,
    #[doc = "The Docker file path relative to the source context."]
    #[serde(rename = "dockerFilePath", default, skip_serializing_if = "Option::is_none")]
    pub docker_file_path: Option<String>,
    #[doc = "The collection of override arguments to be used when executing this build step."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<Argument>,
    #[doc = "The name of the target build stage for the docker build."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl DockerBuildStepUpdateParameters {
    pub fn new(task_step_update_parameters: TaskStepUpdateParameters) -> Self {
        Self {
            task_step_update_parameters,
            image_names: Vec::new(),
            is_push_enabled: None,
            no_cache: None,
            docker_file_path: None,
            arguments: Vec::new(),
            target: None,
        }
    }
}
#[doc = "The parameters for a quick task run request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncodedTaskRunRequest {
    #[serde(flatten)]
    pub run_request: RunRequest,
    #[doc = "Base64 encoded value of the template/definition file content."]
    #[serde(rename = "encodedTaskContent")]
    pub encoded_task_content: String,
    #[doc = "Base64 encoded value of the parameters/values file content."]
    #[serde(rename = "encodedValuesContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_values_content: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "The platform properties against which the run has to happen."]
    pub platform: PlatformProperties,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.\r\nIf it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API."]
    #[serde(rename = "sourceLocation", default, skip_serializing_if = "Option::is_none")]
    pub source_location: Option<String>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
}
impl EncodedTaskRunRequest {
    pub fn new(run_request: RunRequest, encoded_task_content: String, platform: PlatformProperties) -> Self {
        Self {
            run_request,
            encoded_task_content,
            encoded_values_content: None,
            values: Vec::new(),
            timeout: None,
            platform,
            agent_configuration: None,
            source_location: None,
            credentials: None,
        }
    }
}
#[doc = "The properties of a encoded task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncodedTaskStep {
    #[serde(flatten)]
    pub task_step_properties: TaskStepProperties,
    #[doc = "Base64 encoded value of the template/definition file content."]
    #[serde(rename = "encodedTaskContent")]
    pub encoded_task_content: String,
    #[doc = "Base64 encoded value of the parameters/values file content."]
    #[serde(rename = "encodedValuesContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_values_content: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
}
impl EncodedTaskStep {
    pub fn new(task_step_properties: TaskStepProperties, encoded_task_content: String) -> Self {
        Self {
            task_step_properties,
            encoded_task_content,
            encoded_values_content: None,
            values: Vec::new(),
        }
    }
}
#[doc = "The properties for updating encoded task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncodedTaskStepUpdateParameters {
    #[serde(flatten)]
    pub task_step_update_parameters: TaskStepUpdateParameters,
    #[doc = "Base64 encoded value of the template/definition file content."]
    #[serde(rename = "encodedTaskContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_task_content: Option<String>,
    #[doc = "Base64 encoded value of the parameters/values file content."]
    #[serde(rename = "encodedValuesContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_values_content: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
}
impl EncodedTaskStepUpdateParameters {
    pub fn new(task_step_update_parameters: TaskStepUpdateParameters) -> Self {
        Self {
            task_step_update_parameters,
            encoded_task_content: None,
            encoded_values_content: None,
            values: Vec::new(),
        }
    }
}
#[doc = "An error response from the Azure Container Registry service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "An error response from the Azure Container Registry service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponseBody>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response from the Azure Container Registry service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorResponseBody {
    #[doc = "error code."]
    pub code: String,
    #[doc = "error message."]
    pub message: String,
    #[doc = "target of the particular error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "an array of additional nested error response info objects, as described by this contract."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<InnerErrorDescription>,
}
impl ErrorResponseBody {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
            details: Vec::new(),
        }
    }
}
#[doc = "The request parameters for a scheduling run against a task file."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileTaskRunRequest {
    #[serde(flatten)]
    pub run_request: RunRequest,
    #[doc = "The template/definition file path relative to the source."]
    #[serde(rename = "taskFilePath")]
    pub task_file_path: String,
    #[doc = "The values/parameters file path relative to the source."]
    #[serde(rename = "valuesFilePath", default, skip_serializing_if = "Option::is_none")]
    pub values_file_path: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "The platform properties against which the run has to happen."]
    pub platform: PlatformProperties,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.\r\nIf it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API."]
    #[serde(rename = "sourceLocation", default, skip_serializing_if = "Option::is_none")]
    pub source_location: Option<String>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
}
impl FileTaskRunRequest {
    pub fn new(run_request: RunRequest, task_file_path: String, platform: PlatformProperties) -> Self {
        Self {
            run_request,
            task_file_path,
            values_file_path: None,
            values: Vec::new(),
            timeout: None,
            platform,
            agent_configuration: None,
            source_location: None,
            credentials: None,
        }
    }
}
#[doc = "The properties of a task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileTaskStep {
    #[serde(flatten)]
    pub task_step_properties: TaskStepProperties,
    #[doc = "The task template/definition file path relative to the source context."]
    #[serde(rename = "taskFilePath")]
    pub task_file_path: String,
    #[doc = "The task values/parameters file path relative to the source context."]
    #[serde(rename = "valuesFilePath", default, skip_serializing_if = "Option::is_none")]
    pub values_file_path: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
}
impl FileTaskStep {
    pub fn new(task_step_properties: TaskStepProperties, task_file_path: String) -> Self {
        Self {
            task_step_properties,
            task_file_path,
            values_file_path: None,
            values: Vec::new(),
        }
    }
}
#[doc = "The properties of updating a task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileTaskStepUpdateParameters {
    #[serde(flatten)]
    pub task_step_update_parameters: TaskStepUpdateParameters,
    #[doc = "The task template/definition file path relative to the source context."]
    #[serde(rename = "taskFilePath", default, skip_serializing_if = "Option::is_none")]
    pub task_file_path: Option<String>,
    #[doc = "The values/parameters file path relative to the source context."]
    #[serde(rename = "valuesFilePath", default, skip_serializing_if = "Option::is_none")]
    pub values_file_path: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
}
impl FileTaskStepUpdateParameters {
    pub fn new(task_step_update_parameters: TaskStepUpdateParameters) -> Self {
        Self {
            task_step_update_parameters,
            task_file_path: None,
            values_file_path: None,
            values: Vec::new(),
        }
    }
}
#[doc = "Managed identity for the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProperties {
    #[doc = "The principal ID of resource identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The tenant ID of resource."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The identity type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity_properties::Type>,
    #[doc = "The list of user identities associated with the resource. The user identity \r\ndictionary key references will be ARM resource ids in the form: \r\n'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/\r\n    providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."]
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl IdentityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity_properties {
    use super::*;
    #[doc = "The identity type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[doc = "Properties for a registry image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageDescriptor {
    #[doc = "The registry login server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registry: Option<String>,
    #[doc = "The repository name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[doc = "The tag name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[doc = "The sha256-based digest of the image manifest."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub digest: Option<String>,
}
impl ImageDescriptor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The image update trigger that caused a build."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageUpdateTrigger {
    #[doc = "The unique ID of the trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The timestamp when the image update happened."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[doc = "The list of image updates that caused the build."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub images: Vec<ImageDescriptor>,
}
impl ImageUpdateTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "inner error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InnerErrorDescription {
    #[doc = "error code."]
    pub code: String,
    #[doc = "error message."]
    pub message: String,
    #[doc = "target of the particular error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl InnerErrorDescription {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OverrideTaskStepProperties {
    #[doc = "The source context against which run has to be queued."]
    #[serde(rename = "contextPath", default, skip_serializing_if = "Option::is_none")]
    pub context_path: Option<String>,
    #[doc = "The file against which run has to be queued."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub file: Option<String>,
    #[doc = "Gets or sets the collection of override arguments to be used when\r\nexecuting a build step."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<Argument>,
    #[doc = "The name of the target build stage for the docker build."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a Task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
    #[doc = "Base64 encoded update trigger token that will be attached with the base image trigger webhook."]
    #[serde(rename = "updateTriggerToken", default, skip_serializing_if = "Option::is_none")]
    pub update_trigger_token: Option<String>,
}
impl OverrideTaskStepProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The platform properties against which the run has to happen."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PlatformProperties {
    #[doc = "The operating system type required for the run."]
    pub os: platform_properties::Os,
    #[doc = "The OS architecture."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub architecture: Option<platform_properties::Architecture>,
    #[doc = "Variant of the CPU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub variant: Option<platform_properties::Variant>,
}
impl PlatformProperties {
    pub fn new(os: platform_properties::Os) -> Self {
        Self {
            os,
            architecture: None,
            variant: None,
        }
    }
}
pub mod platform_properties {
    use super::*;
    #[doc = "The operating system type required for the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Os {
        Windows,
        Linux,
    }
    #[doc = "The OS architecture."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Architecture {
        #[serde(rename = "amd64")]
        Amd64,
        #[serde(rename = "x86")]
        X86,
        #[serde(rename = "386")]
        N386,
        #[serde(rename = "arm")]
        Arm,
        #[serde(rename = "arm64")]
        Arm64,
    }
    #[doc = "Variant of the CPU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Variant {
        #[serde(rename = "v6")]
        V6,
        #[serde(rename = "v7")]
        V7,
        #[serde(rename = "v8")]
        V8,
    }
}
#[doc = "The properties for updating the platform configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PlatformUpdateParameters {
    #[doc = "The operating system type required for the run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub os: Option<platform_update_parameters::Os>,
    #[doc = "The OS architecture."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub architecture: Option<platform_update_parameters::Architecture>,
    #[doc = "Variant of the CPU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub variant: Option<platform_update_parameters::Variant>,
}
impl PlatformUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod platform_update_parameters {
    use super::*;
    #[doc = "The operating system type required for the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Os {
        Windows,
        Linux,
    }
    #[doc = "The OS architecture."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Architecture {
        #[serde(rename = "amd64")]
        Amd64,
        #[serde(rename = "x86")]
        X86,
        #[serde(rename = "386")]
        N386,
        #[serde(rename = "arm")]
        Arm,
        #[serde(rename = "arm64")]
        Arm64,
    }
    #[doc = "Variant of the CPU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Variant {
        #[serde(rename = "v6")]
        V6,
        #[serde(rename = "v7")]
        V7,
        #[serde(rename = "v8")]
        V8,
    }
}
#[doc = "The resource model definition for a ARM proxy resource. It will have everything other than required location and tags."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The location of the resource. This cannot be changed after the resource is created."]
    pub location: String,
    #[doc = "The tags of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
            system_data: None,
        }
    }
}
#[doc = "Run resource properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Run {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties for a run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RunProperties>,
}
impl Run {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties that are enabled for Odata querying on runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunFilter {
    #[doc = "The unique identifier for the run."]
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[doc = "The type of run."]
    #[serde(rename = "runType", default, skip_serializing_if = "Option::is_none")]
    pub run_type: Option<run_filter::RunType>,
    #[doc = "The current status of the run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<run_filter::Status>,
    #[doc = "The create time for a run."]
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[doc = "The time the run finished."]
    #[serde(rename = "finishTime", default, skip_serializing_if = "Option::is_none")]
    pub finish_time: Option<String>,
    #[doc = "The list of comma-separated image manifests that were generated from the run. This is applicable if the run is of\r\nbuild type."]
    #[serde(rename = "outputImageManifests", default, skip_serializing_if = "Option::is_none")]
    pub output_image_manifests: Option<String>,
    #[doc = "The value that indicates whether archiving is enabled or not."]
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
    #[doc = "The name of the task that the run corresponds to."]
    #[serde(rename = "taskName", default, skip_serializing_if = "Option::is_none")]
    pub task_name: Option<String>,
    #[doc = "The name of the agent pool that the run corresponds to."]
    #[serde(rename = "agentPoolName", default, skip_serializing_if = "Option::is_none")]
    pub agent_pool_name: Option<String>,
}
impl RunFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod run_filter {
    use super::*;
    #[doc = "The type of run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RunType {
        QuickBuild,
        QuickRun,
        AutoBuild,
        AutoRun,
    }
    #[doc = "The current status of the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Queued,
        Started,
        Running,
        Succeeded,
        Failed,
        Canceled,
        Error,
        Timeout,
    }
}
#[doc = "The result of get log link operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunGetLogResult {
    #[doc = "The link to logs for a run on a azure container registry."]
    #[serde(rename = "logLink", default, skip_serializing_if = "Option::is_none")]
    pub log_link: Option<String>,
    #[doc = "The link to logs in registry for a run on a azure container registry."]
    #[serde(rename = "logArtifactLink", default, skip_serializing_if = "Option::is_none")]
    pub log_artifact_link: Option<String>,
}
impl RunGetLogResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunListResult {
    #[doc = "The collection value."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Run>,
    #[doc = "The URI that can be used to request the next set of paged results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RunListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for a run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunProperties {
    #[doc = "The unique identifier for the run."]
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[doc = "The current status of the run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<run_properties::Status>,
    #[doc = "The last updated time for the run."]
    #[serde(rename = "lastUpdatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_time: Option<String>,
    #[doc = "The type of run."]
    #[serde(rename = "runType", default, skip_serializing_if = "Option::is_none")]
    pub run_type: Option<run_properties::RunType>,
    #[doc = "The dedicated agent pool for the run."]
    #[serde(rename = "agentPoolName", default, skip_serializing_if = "Option::is_none")]
    pub agent_pool_name: Option<String>,
    #[doc = "The time the run was scheduled."]
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[doc = "The time the run started."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The time the run finished."]
    #[serde(rename = "finishTime", default, skip_serializing_if = "Option::is_none")]
    pub finish_time: Option<String>,
    #[doc = "The list of all images that were generated from the run. This is applicable if the run generates base image dependencies."]
    #[serde(rename = "outputImages", default, skip_serializing_if = "Vec::is_empty")]
    pub output_images: Vec<ImageDescriptor>,
    #[doc = "The task against which run was scheduled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub task: Option<String>,
    #[doc = "The image update trigger that caused a build."]
    #[serde(rename = "imageUpdateTrigger", default, skip_serializing_if = "Option::is_none")]
    pub image_update_trigger: Option<ImageUpdateTrigger>,
    #[doc = "The source trigger that caused a run."]
    #[serde(rename = "sourceTrigger", default, skip_serializing_if = "Option::is_none")]
    pub source_trigger: Option<SourceTriggerDescriptor>,
    #[serde(rename = "timerTrigger", default, skip_serializing_if = "Option::is_none")]
    pub timer_trigger: Option<TimerTriggerDescriptor>,
    #[doc = "The platform properties against which the run has to happen."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub platform: Option<PlatformProperties>,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The scope of the credentials that were used to login to the source registry during this run."]
    #[serde(rename = "sourceRegistryAuth", default, skip_serializing_if = "Option::is_none")]
    pub source_registry_auth: Option<String>,
    #[doc = "The list of custom registries that were logged in during this run."]
    #[serde(rename = "customRegistries", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_registries: Vec<String>,
    #[doc = "The error message received from backend systems after the run is scheduled."]
    #[serde(rename = "runErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub run_error_message: Option<String>,
    #[doc = "The update trigger token passed for the Run."]
    #[serde(rename = "updateTriggerToken", default, skip_serializing_if = "Option::is_none")]
    pub update_trigger_token: Option<String>,
    #[doc = "Properties for a registry image."]
    #[serde(rename = "logArtifact", default, skip_serializing_if = "Option::is_none")]
    pub log_artifact: Option<ImageDescriptor>,
    #[doc = "The provisioning state of a run."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<run_properties::ProvisioningState>,
    #[doc = "The value that indicates whether archiving is enabled or not."]
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
}
impl RunProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod run_properties {
    use super::*;
    #[doc = "The current status of the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Queued,
        Started,
        Running,
        Succeeded,
        Failed,
        Canceled,
        Error,
        Timeout,
    }
    #[doc = "The type of run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RunType {
        QuickBuild,
        QuickRun,
        AutoBuild,
        AutoRun,
    }
    #[doc = "The provisioning state of a run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The request parameters for scheduling a run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunRequest {
    #[doc = "The type of the run request."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "The value that indicates whether archiving is enabled for the run or not."]
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
    #[doc = "The dedicated agent pool for the run."]
    #[serde(rename = "agentPoolName", default, skip_serializing_if = "Option::is_none")]
    pub agent_pool_name: Option<String>,
    #[doc = "The template that describes the repository and tag information for run log artifact."]
    #[serde(rename = "logTemplate", default, skip_serializing_if = "Option::is_none")]
    pub log_template: Option<String>,
}
impl RunRequest {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            is_archive_enabled: None,
            agent_pool_name: None,
            log_template: None,
        }
    }
}
#[doc = "The set of run properties that can be updated."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunUpdateParameters {
    #[doc = "The value that indicates whether archiving is enabled or not."]
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
}
impl RunUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a secret object value."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecretObject {
    #[doc = "The value of the secret. The format of this value will be determined\r\nbased on the type of the secret object. If the type is Opaque, the value will be\r\nused as is without any modification."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "The type of the secret object which determines how the value of the secret object has to be\r\ninterpreted."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<secret_object::Type>,
}
impl SecretObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod secret_object {
    use super::*;
    #[doc = "The type of the secret object which determines how the value of the secret object has to be\r\ninterpreted."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Opaque,
        Vaultsecret,
    }
}
#[doc = "The properties of a overridable value that can be passed to a task template."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SetValue {
    #[doc = "The name of the overridable value."]
    pub name: String,
    #[doc = "The overridable value."]
    pub value: String,
    #[doc = "Flag to indicate whether the value represents a secret or not."]
    #[serde(rename = "isSecret", default, skip_serializing_if = "Option::is_none")]
    pub is_secret: Option<bool>,
}
impl SetValue {
    pub fn new(name: String, value: String) -> Self {
        Self {
            name,
            value,
            is_secret: None,
        }
    }
}
#[doc = "The properties of the source code repository."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceProperties {
    #[doc = "The type of source control service."]
    #[serde(rename = "sourceControlType")]
    pub source_control_type: source_properties::SourceControlType,
    #[doc = "The full URL to the source code repository"]
    #[serde(rename = "repositoryUrl")]
    pub repository_url: String,
    #[doc = "The branch name of the source code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[doc = "The authorization properties for accessing the source code repository."]
    #[serde(rename = "sourceControlAuthProperties", default, skip_serializing_if = "Option::is_none")]
    pub source_control_auth_properties: Option<AuthInfo>,
}
impl SourceProperties {
    pub fn new(source_control_type: source_properties::SourceControlType, repository_url: String) -> Self {
        Self {
            source_control_type,
            repository_url,
            branch: None,
            source_control_auth_properties: None,
        }
    }
}
pub mod source_properties {
    use super::*;
    #[doc = "The type of source control service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceControlType {
        Github,
        VisualStudioTeamService,
    }
}
#[doc = "Describes the credential parameters for accessing the source registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceRegistryCredentials {
    #[doc = "The authentication mode which determines the source registry login scope. The credentials for the source registry\r\nwill be generated using the given scope. These credentials will be used to login to\r\nthe source registry during the run."]
    #[serde(rename = "loginMode", default, skip_serializing_if = "Option::is_none")]
    pub login_mode: Option<source_registry_credentials::LoginMode>,
}
impl SourceRegistryCredentials {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod source_registry_credentials {
    use super::*;
    #[doc = "The authentication mode which determines the source registry login scope. The credentials for the source registry\r\nwill be generated using the given scope. These credentials will be used to login to\r\nthe source registry during the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoginMode {
        None,
        Default,
    }
}
#[doc = "The properties of a source based trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceTrigger {
    #[doc = "The properties of the source code repository."]
    #[serde(rename = "sourceRepository")]
    pub source_repository: SourceProperties,
    #[doc = "The source event corresponding to the trigger."]
    #[serde(rename = "sourceTriggerEvents")]
    pub source_trigger_events: Vec<String>,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<source_trigger::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl SourceTrigger {
    pub fn new(source_repository: SourceProperties, source_trigger_events: Vec<String>, name: String) -> Self {
        Self {
            source_repository,
            source_trigger_events,
            status: None,
            name,
        }
    }
}
pub mod source_trigger {
    use super::*;
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "The source trigger that caused a run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceTriggerDescriptor {
    #[doc = "The unique ID of the trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The event type of the trigger."]
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[doc = "The unique ID that identifies a commit."]
    #[serde(rename = "commitId", default, skip_serializing_if = "Option::is_none")]
    pub commit_id: Option<String>,
    #[doc = "The unique ID that identifies pull request."]
    #[serde(rename = "pullRequestId", default, skip_serializing_if = "Option::is_none")]
    pub pull_request_id: Option<String>,
    #[doc = "The repository URL."]
    #[serde(rename = "repositoryUrl", default, skip_serializing_if = "Option::is_none")]
    pub repository_url: Option<String>,
    #[doc = "The branch name in the repository."]
    #[serde(rename = "branchName", default, skip_serializing_if = "Option::is_none")]
    pub branch_name: Option<String>,
    #[doc = "The source control provider type."]
    #[serde(rename = "providerType", default, skip_serializing_if = "Option::is_none")]
    pub provider_type: Option<String>,
}
impl SourceTriggerDescriptor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for updating a source based trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceTriggerUpdateParameters {
    #[doc = "The properties for updating the source code repository."]
    #[serde(rename = "sourceRepository", default, skip_serializing_if = "Option::is_none")]
    pub source_repository: Option<SourceUpdateParameters>,
    #[doc = "The source event corresponding to the trigger."]
    #[serde(rename = "sourceTriggerEvents", default, skip_serializing_if = "Vec::is_empty")]
    pub source_trigger_events: Vec<String>,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<source_trigger_update_parameters::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl SourceTriggerUpdateParameters {
    pub fn new(name: String) -> Self {
        Self {
            source_repository: None,
            source_trigger_events: Vec::new(),
            status: None,
            name,
        }
    }
}
pub mod source_trigger_update_parameters {
    use super::*;
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "The properties for updating the source code repository."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceUpdateParameters {
    #[doc = "The type of source control service."]
    #[serde(rename = "sourceControlType", default, skip_serializing_if = "Option::is_none")]
    pub source_control_type: Option<source_update_parameters::SourceControlType>,
    #[doc = "The full URL to the source code repository"]
    #[serde(rename = "repositoryUrl", default, skip_serializing_if = "Option::is_none")]
    pub repository_url: Option<String>,
    #[doc = "The branch name of the source code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[doc = "The authorization properties for accessing the source code repository."]
    #[serde(rename = "sourceControlAuthProperties", default, skip_serializing_if = "Option::is_none")]
    pub source_control_auth_properties: Option<AuthInfoUpdateParameters>,
}
impl SourceUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod source_update_parameters {
    use super::*;
    #[doc = "The type of source control service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceControlType {
        Github,
        VisualStudioTeamService,
    }
}
#[doc = "The properties of a response to source upload request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceUploadDefinition {
    #[doc = "The URL where the client can upload the source."]
    #[serde(rename = "uploadUrl", default, skip_serializing_if = "Option::is_none")]
    pub upload_url: Option<String>,
    #[doc = "The relative path to the source. This is used to submit the subsequent queue build request."]
    #[serde(rename = "relativePath", default, skip_serializing_if = "Option::is_none")]
    pub relative_path: Option<String>,
}
impl SourceUploadDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metadata pertaining to creation and last modification of the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[doc = "The identity that created the resource."]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[doc = "The type of identity that created the resource."]
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[doc = "The timestamp of resource creation (UTC)."]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "The identity that last modified the resource."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[doc = "The timestamp of resource modification (UTC)."]
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[doc = "The type of identity that created the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[doc = "The type of identity that last modified the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
#[doc = "The task that has the ARM resource and task properties. \r\nThe task will have all information to schedule a run against it."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Task {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Managed identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityProperties>,
    #[doc = "The properties of a task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TaskProperties>,
}
impl Task {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            identity: None,
            properties: None,
        }
    }
}
#[doc = "The collection of tasks."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskListResult {
    #[doc = "The collection value."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Task>,
    #[doc = "The URI that can be used to request the next set of paged results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TaskListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a task."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskProperties {
    #[doc = "The provisioning state of the task."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<task_properties::ProvisioningState>,
    #[doc = "The creation date of task."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "The current status of task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<task_properties::Status>,
    #[doc = "The platform properties against which the run has to happen."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub platform: Option<PlatformProperties>,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The dedicated agent pool for the task."]
    #[serde(rename = "agentPoolName", default, skip_serializing_if = "Option::is_none")]
    pub agent_pool_name: Option<String>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "Base properties for any task step."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub step: Option<TaskStepProperties>,
    #[doc = "The properties of a trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub trigger: Option<TriggerProperties>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
    #[doc = "The template that describes the repository and tag information for run log artifact."]
    #[serde(rename = "logTemplate", default, skip_serializing_if = "Option::is_none")]
    pub log_template: Option<String>,
    #[doc = "The value of this property indicates whether the task resource is system task or not."]
    #[serde(rename = "isSystemTask", default, skip_serializing_if = "Option::is_none")]
    pub is_system_task: Option<bool>,
}
impl TaskProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod task_properties {
    use super::*;
    #[doc = "The provisioning state of the task."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
    #[doc = "The current status of task."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
}
#[doc = "The properties for updating a task."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskPropertiesUpdateParameters {
    #[doc = "The current status of task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<task_properties_update_parameters::Status>,
    #[doc = "The properties for updating the platform configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub platform: Option<PlatformUpdateParameters>,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The dedicated agent pool for the task."]
    #[serde(rename = "agentPoolName", default, skip_serializing_if = "Option::is_none")]
    pub agent_pool_name: Option<String>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "Base properties for updating any task step."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub step: Option<TaskStepUpdateParameters>,
    #[doc = "The properties for updating triggers."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub trigger: Option<TriggerUpdateParameters>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
    #[doc = "The template that describes the repository and tag information for run log artifact."]
    #[serde(rename = "logTemplate", default, skip_serializing_if = "Option::is_none")]
    pub log_template: Option<String>,
}
impl TaskPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod task_properties_update_parameters {
    use super::*;
    #[doc = "The current status of task."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
}
#[doc = "The task run that has the ARM resource and properties. \r\nThe task run will have the information of request and result of a run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskRun {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Managed identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityProperties>,
    #[doc = "The properties of task run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TaskRunProperties>,
    #[doc = "The location of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl TaskRun {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The collection of task runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskRunListResult {
    #[doc = "The collection value."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TaskRun>,
    #[doc = "The URI that can be used to request the next set of paged results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TaskRunListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of task run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskRunProperties {
    #[doc = "The provisioning state of this task run"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<task_run_properties::ProvisioningState>,
    #[doc = "The request parameters for scheduling a run."]
    #[serde(rename = "runRequest", default, skip_serializing_if = "Option::is_none")]
    pub run_request: Option<RunRequest>,
    #[doc = "Run resource properties"]
    #[serde(rename = "runResult", default, skip_serializing_if = "Option::is_none")]
    pub run_result: Option<Run>,
    #[doc = "How the run should be forced to rerun even if the run request configuration has not changed"]
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
}
impl TaskRunProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod task_run_properties {
    use super::*;
    #[doc = "The provisioning state of this task run"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The properties of a task run update parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskRunPropertiesUpdateParameters {
    #[doc = "The request parameters for scheduling a run."]
    #[serde(rename = "runRequest", default, skip_serializing_if = "Option::is_none")]
    pub run_request: Option<RunRequest>,
    #[doc = "How the run should be forced to rerun even if the run request configuration has not changed"]
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
}
impl TaskRunPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for a task run request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskRunRequest {
    #[serde(flatten)]
    pub run_request: RunRequest,
    #[doc = "The resource ID of task against which run has to be queued."]
    #[serde(rename = "taskId")]
    pub task_id: String,
    #[serde(rename = "overrideTaskStepProperties", default, skip_serializing_if = "Option::is_none")]
    pub override_task_step_properties: Option<OverrideTaskStepProperties>,
}
impl TaskRunRequest {
    pub fn new(run_request: RunRequest, task_id: String) -> Self {
        Self {
            run_request,
            task_id,
            override_task_step_properties: None,
        }
    }
}
#[doc = "The parameters for updating a task run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskRunUpdateParameters {
    #[doc = "Managed identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityProperties>,
    #[doc = "The properties of a task run update parameters."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TaskRunPropertiesUpdateParameters>,
    #[doc = "The location of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "The ARM resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TaskRunUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base properties for any task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskStepProperties {
    #[doc = "The type of the step."]
    #[serde(rename = "type")]
    pub type_: task_step_properties::Type,
    #[doc = "List of base image dependencies for a step."]
    #[serde(rename = "baseImageDependencies", default, skip_serializing_if = "Vec::is_empty")]
    pub base_image_dependencies: Vec<BaseImageDependency>,
    #[doc = "The URL(absolute or relative) of the source context for the task step."]
    #[serde(rename = "contextPath", default, skip_serializing_if = "Option::is_none")]
    pub context_path: Option<String>,
    #[doc = "The token (git PAT or SAS token of storage account blob) associated with the context for a step."]
    #[serde(rename = "contextAccessToken", default, skip_serializing_if = "Option::is_none")]
    pub context_access_token: Option<String>,
}
impl TaskStepProperties {
    pub fn new(type_: task_step_properties::Type) -> Self {
        Self {
            type_,
            base_image_dependencies: Vec::new(),
            context_path: None,
            context_access_token: None,
        }
    }
}
pub mod task_step_properties {
    use super::*;
    #[doc = "The type of the step."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Docker,
        FileTask,
        EncodedTask,
    }
}
#[doc = "Base properties for updating any task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskStepUpdateParameters {
    #[doc = "The type of the step."]
    #[serde(rename = "type")]
    pub type_: task_step_update_parameters::Type,
    #[doc = "The URL(absolute or relative) of the source context for the task step."]
    #[serde(rename = "contextPath", default, skip_serializing_if = "Option::is_none")]
    pub context_path: Option<String>,
    #[doc = "The token (git PAT or SAS token of storage account blob) associated with the context for a step."]
    #[serde(rename = "contextAccessToken", default, skip_serializing_if = "Option::is_none")]
    pub context_access_token: Option<String>,
}
impl TaskStepUpdateParameters {
    pub fn new(type_: task_step_update_parameters::Type) -> Self {
        Self {
            type_,
            context_path: None,
            context_access_token: None,
        }
    }
}
pub mod task_step_update_parameters {
    use super::*;
    #[doc = "The type of the step."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Docker,
        FileTask,
        EncodedTask,
    }
}
#[doc = "The parameters for updating a task."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskUpdateParameters {
    #[doc = "Managed identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<IdentityProperties>,
    #[doc = "The properties for updating a task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TaskPropertiesUpdateParameters>,
    #[doc = "The ARM resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TaskUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a timer trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimerTrigger {
    #[doc = "The CRON expression for the task schedule"]
    pub schedule: String,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<timer_trigger::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl TimerTrigger {
    pub fn new(schedule: String, name: String) -> Self {
        Self {
            schedule,
            status: None,
            name,
        }
    }
}
pub mod timer_trigger {
    use super::*;
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TimerTriggerDescriptor {
    #[doc = "The timer trigger name that caused the run."]
    #[serde(rename = "timerTriggerName", default, skip_serializing_if = "Option::is_none")]
    pub timer_trigger_name: Option<String>,
    #[doc = "The occurrence that triggered the run."]
    #[serde(rename = "scheduleOccurrence", default, skip_serializing_if = "Option::is_none")]
    pub schedule_occurrence: Option<String>,
}
impl TimerTriggerDescriptor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for updating a timer trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimerTriggerUpdateParameters {
    #[doc = "The CRON expression for the task schedule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<String>,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<timer_trigger_update_parameters::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl TimerTriggerUpdateParameters {
    pub fn new(name: String) -> Self {
        Self {
            schedule: None,
            status: None,
            name,
        }
    }
}
pub mod timer_trigger_update_parameters {
    use super::*;
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "The properties of a trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerProperties {
    #[doc = "The collection of timer triggers."]
    #[serde(rename = "timerTriggers", default, skip_serializing_if = "Vec::is_empty")]
    pub timer_triggers: Vec<TimerTrigger>,
    #[doc = "The collection of triggers based on source code repository."]
    #[serde(rename = "sourceTriggers", default, skip_serializing_if = "Vec::is_empty")]
    pub source_triggers: Vec<SourceTrigger>,
    #[doc = "The trigger based on base image dependency."]
    #[serde(rename = "baseImageTrigger", default, skip_serializing_if = "Option::is_none")]
    pub base_image_trigger: Option<BaseImageTrigger>,
}
impl TriggerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for updating triggers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerUpdateParameters {
    #[doc = "The collection of timer triggers."]
    #[serde(rename = "timerTriggers", default, skip_serializing_if = "Vec::is_empty")]
    pub timer_triggers: Vec<TimerTriggerUpdateParameters>,
    #[doc = "The collection of triggers based on source code repository."]
    #[serde(rename = "sourceTriggers", default, skip_serializing_if = "Vec::is_empty")]
    pub source_triggers: Vec<SourceTriggerUpdateParameters>,
    #[doc = "The properties for updating base image dependency trigger."]
    #[serde(rename = "baseImageTrigger", default, skip_serializing_if = "Option::is_none")]
    pub base_image_trigger: Option<BaseImageTriggerUpdateParameters>,
}
impl TriggerUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentityProperties {
    #[doc = "The principal id of user assigned identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The client id of user assigned identity."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
}
impl UserIdentityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
