#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The Active Directory Object that will be used for authenticating the token of a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveDirectoryObject {
    #[doc = "The user/group/application object ID for Active Directory Object that will be used for authenticating the token of a container registry."]
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[doc = "The tenant ID of user/group/application object Active Directory Object that will be used for authenticating the token of a container registry."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl ActiveDirectoryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters used to generate credentials for a specified token or user of a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenerateCredentialsParameters {
    #[doc = "The resource ID of the token for which credentials have to be generated."]
    #[serde(rename = "tokenId", default, skip_serializing_if = "Option::is_none")]
    pub token_id: Option<String>,
    #[doc = "The expiry date of the generated credentials after which the credentials become invalid."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiry: Option<String>,
    #[doc = "Specifies name of the password which should be regenerated if any -- password1 or password2."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<generate_credentials_parameters::Name>,
}
impl GenerateCredentialsParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod generate_credentials_parameters {
    use super::*;
    #[doc = "Specifies name of the password which should be regenerated if any -- password1 or password2."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "password1")]
        Password1,
        #[serde(rename = "password2")]
        Password2,
    }
}
#[doc = "The response from the GenerateCredentials operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenerateCredentialsResult {
    #[doc = "The username for a container registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "The list of passwords for a container registry."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub passwords: Vec<TokenPassword>,
}
impl GenerateCredentialsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource model definition for a ARM proxy resource. It will have everything other than required location and tags."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An object that represents a scope map for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeMap {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of a scope map."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScopeMapProperties>,
}
impl ScopeMap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of a request to list scope maps for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeMapListResult {
    #[doc = "The list of scope maps. Since this list may be incomplete, the nextLink field should be used to request the next list of scope maps."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ScopeMap>,
    #[doc = "The URI that can be used to request the next list of scope maps."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ScopeMapListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a scope map."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScopeMapProperties {
    #[doc = "The user friendly description of the scope map."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The type of the scope map. E.g. BuildIn scope map."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The creation date of scope map."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "Provisioning state of the resource."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<scope_map_properties::ProvisioningState>,
    #[doc = "The list of scoped permissions for registry artifacts.\r\nE.g. repositories/repository-name/content/read,\r\nrepositories/repository-name/metadata/write"]
    pub actions: Vec<String>,
}
impl ScopeMapProperties {
    pub fn new(actions: Vec<String>) -> Self {
        Self {
            description: None,
            type_: None,
            creation_date: None,
            provisioning_state: None,
            actions,
        }
    }
}
pub mod scope_map_properties {
    use super::*;
    #[doc = "Provisioning state of the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The update parameters for scope map properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeMapPropertiesUpdateParameters {
    #[doc = "The user friendly description of the scope map."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The list of scope permissions for registry artifacts.\r\nE.g. repositories/repository-name/pull, \r\nrepositories/repository-name/delete"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub actions: Vec<String>,
}
impl ScopeMapPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for updating the scope map."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeMapUpdateParameters {
    #[doc = "The update parameters for scope map properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScopeMapPropertiesUpdateParameters>,
}
impl ScopeMapUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metadata pertaining to creation and last modification of the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[doc = "The identity that created the resource."]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[doc = "The type of identity that created the resource."]
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[doc = "The timestamp of resource creation (UTC)."]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "The identity that last modified the resource."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[doc = "The timestamp of resource modification (UTC)."]
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[doc = "The type of identity that created the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[doc = "The type of identity that last modified the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
#[doc = "An object that represents a token for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Token {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of a token."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TokenProperties>,
}
impl Token {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a certificate used for authenticating a token."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenCertificate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<token_certificate::Name>,
    #[doc = "The expiry datetime of the certificate."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiry: Option<String>,
    #[doc = "The thumbprint of the certificate."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token."]
    #[serde(rename = "encodedPemCertificate", default, skip_serializing_if = "Option::is_none")]
    pub encoded_pem_certificate: Option<String>,
}
impl TokenCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod token_certificate {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "certificate1")]
        Certificate1,
        #[serde(rename = "certificate2")]
        Certificate2,
    }
}
#[doc = "The properties of the credentials that can be used for authenticating the token."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenCredentialsProperties {
    #[doc = "The Active Directory Object that will be used for authenticating the token of a container registry."]
    #[serde(rename = "activeDirectoryObject", default, skip_serializing_if = "Option::is_none")]
    pub active_directory_object: Option<ActiveDirectoryObject>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub certificates: Vec<TokenCertificate>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub passwords: Vec<TokenPassword>,
}
impl TokenCredentialsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of a request to list tokens for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenListResult {
    #[doc = "The list of tokens. Since this list may be incomplete, the nextLink field should be used to request the next list of tokens."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Token>,
    #[doc = "The URI that can be used to request the next list of tokens."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TokenListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The password that will be used for authenticating the token of a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenPassword {
    #[doc = "The creation datetime of the password."]
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[doc = "The expiry datetime of the password."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiry: Option<String>,
    #[doc = "The password name \"password1\" or \"password2\""]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<token_password::Name>,
    #[doc = "The password value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl TokenPassword {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod token_password {
    use super::*;
    #[doc = "The password name \"password1\" or \"password2\""]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "password1")]
        Password1,
        #[serde(rename = "password2")]
        Password2,
    }
}
#[doc = "The properties of a token."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenProperties {
    #[doc = "The creation date of scope map."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "Provisioning state of the resource."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<token_properties::ProvisioningState>,
    #[doc = "The resource ID of the scope map to which the token will be associated with."]
    #[serde(rename = "scopeMapId", default, skip_serializing_if = "Option::is_none")]
    pub scope_map_id: Option<String>,
    #[doc = "The properties of the credentials that can be used for authenticating the token."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<TokenCredentialsProperties>,
    #[doc = "The status of the token example enabled or disabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<token_properties::Status>,
}
impl TokenProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod token_properties {
    use super::*;
    #[doc = "Provisioning state of the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
    #[doc = "The status of the token example enabled or disabled."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
}
#[doc = "The parameters for updating a token."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenUpdateParameters {
    #[doc = "The parameters for updating token properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TokenUpdateProperties>,
}
impl TokenUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for updating token properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenUpdateProperties {
    #[doc = "The resource ID of the scope map to which the token will be associated with."]
    #[serde(rename = "scopeMapId", default, skip_serializing_if = "Option::is_none")]
    pub scope_map_id: Option<String>,
    #[doc = "The status of the token example enabled or disabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<token_update_properties::Status>,
    #[doc = "The properties of the credentials that can be used for authenticating the token."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<TokenCredentialsProperties>,
}
impl TokenUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod token_update_properties {
    use super::*;
    #[doc = "The status of the token example enabled or disabled."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
}
