#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The agent that initiated the event. For most situations, this could be from the authorization context of the request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Actor {
    #[doc = "The subject or username associated with the request context that generated the event."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl Actor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties that determine the run agent configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgentProperties {
    #[doc = "The CPU configuration in terms of number of cores required for the run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cpu: Option<i32>,
}
impl AgentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a run argument."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Argument {
    #[doc = "The name of the argument."]
    pub name: String,
    #[doc = "The value of the argument."]
    pub value: String,
    #[doc = "Flag to indicate whether the argument represents a secret and want to be removed from build logs."]
    #[serde(rename = "isSecret", default, skip_serializing_if = "Option::is_none")]
    pub is_secret: Option<bool>,
}
impl Argument {
    pub fn new(name: String, value: String) -> Self {
        Self {
            name,
            value,
            is_secret: None,
        }
    }
}
#[doc = "The authorization properties for accessing the source code repository."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AuthInfo {
    #[doc = "The type of Auth token."]
    #[serde(rename = "tokenType")]
    pub token_type: auth_info::TokenType,
    #[doc = "The access token used to access the source control provider."]
    pub token: String,
    #[doc = "The refresh token used to refresh the access token."]
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<String>,
    #[doc = "The scope of the access token."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[doc = "Time in seconds that the token remains valid"]
    #[serde(rename = "expiresIn", default, skip_serializing_if = "Option::is_none")]
    pub expires_in: Option<i32>,
}
impl AuthInfo {
    pub fn new(token_type: auth_info::TokenType, token: String) -> Self {
        Self {
            token_type,
            token,
            refresh_token: None,
            scope: None,
            expires_in: None,
        }
    }
}
pub mod auth_info {
    use super::*;
    #[doc = "The type of Auth token."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TokenType {
        #[serde(rename = "PAT")]
        Pat,
        OAuth,
    }
}
#[doc = "The authorization properties for accessing the source code repository."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthInfoUpdateParameters {
    #[doc = "The type of Auth token."]
    #[serde(rename = "tokenType", default, skip_serializing_if = "Option::is_none")]
    pub token_type: Option<auth_info_update_parameters::TokenType>,
    #[doc = "The access token used to access the source control provider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub token: Option<String>,
    #[doc = "The refresh token used to refresh the access token."]
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<String>,
    #[doc = "The scope of the access token."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[doc = "Time in seconds that the token remains valid"]
    #[serde(rename = "expiresIn", default, skip_serializing_if = "Option::is_none")]
    pub expires_in: Option<i32>,
}
impl AuthInfoUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod auth_info_update_parameters {
    use super::*;
    #[doc = "The type of Auth token."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TokenType {
        #[serde(rename = "PAT")]
        Pat,
        OAuth,
    }
}
#[doc = "Properties that describe a base image dependency."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BaseImageDependency {
    #[doc = "The type of the base image dependency."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<base_image_dependency::Type>,
    #[doc = "The registry login server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registry: Option<String>,
    #[doc = "The repository name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[doc = "The tag name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[doc = "The sha256-based digest of the image manifest."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub digest: Option<String>,
}
impl BaseImageDependency {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod base_image_dependency {
    use super::*;
    #[doc = "The type of the base image dependency."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        BuildTime,
        RunTime,
    }
}
#[doc = "The trigger based on base image dependency."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseImageTrigger {
    #[doc = "The type of the auto trigger for base image dependency updates."]
    #[serde(rename = "baseImageTriggerType")]
    pub base_image_trigger_type: base_image_trigger::BaseImageTriggerType,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<base_image_trigger::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl BaseImageTrigger {
    pub fn new(base_image_trigger_type: base_image_trigger::BaseImageTriggerType, name: String) -> Self {
        Self {
            base_image_trigger_type,
            status: None,
            name,
        }
    }
}
pub mod base_image_trigger {
    use super::*;
    #[doc = "The type of the auto trigger for base image dependency updates."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BaseImageTriggerType {
        All,
        Runtime,
    }
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "The properties for updating base image dependency trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseImageTriggerUpdateParameters {
    #[doc = "The type of the auto trigger for base image dependency updates."]
    #[serde(rename = "baseImageTriggerType", default, skip_serializing_if = "Option::is_none")]
    pub base_image_trigger_type: Option<base_image_trigger_update_parameters::BaseImageTriggerType>,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<base_image_trigger_update_parameters::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl BaseImageTriggerUpdateParameters {
    pub fn new(name: String) -> Self {
        Self {
            base_image_trigger_type: None,
            status: None,
            name,
        }
    }
}
pub mod base_image_trigger_update_parameters {
    use super::*;
    #[doc = "The type of the auto trigger for base image dependency updates."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BaseImageTriggerType {
        All,
        Runtime,
    }
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "The configuration of service URI and custom headers for the webhook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CallbackConfig {
    #[doc = "The service URI for the webhook to post notifications."]
    #[serde(rename = "serviceUri")]
    pub service_uri: String,
    #[doc = "Custom headers that will be added to the webhook notifications."]
    #[serde(rename = "customHeaders", default, skip_serializing_if = "Option::is_none")]
    pub custom_headers: Option<serde_json::Value>,
}
impl CallbackConfig {
    pub fn new(service_uri: String) -> Self {
        Self {
            service_uri,
            custom_headers: None,
        }
    }
}
#[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Credentials {
    #[doc = "Describes the credential parameters for accessing the source registry."]
    #[serde(rename = "sourceRegistry", default, skip_serializing_if = "Option::is_none")]
    pub source_registry: Option<SourceRegistryCredentials>,
    #[doc = "Describes the credential parameters for accessing other custom registries. The key\r\nfor the dictionary item will be the registry login server (myregistry.azurecr.io) and\r\nthe value of the item will be the registry credentials for accessing the registry."]
    #[serde(rename = "customRegistries", default, skip_serializing_if = "Option::is_none")]
    pub custom_registries: Option<serde_json::Value>,
}
impl Credentials {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the credentials that will be used to access a custom registry during a run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomRegistryCredentials {
    #[doc = "Describes the properties of a secret object value."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<SecretObject>,
    #[doc = "Describes the properties of a secret object value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretObject>,
}
impl CustomRegistryCredentials {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for a docker quick build."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DockerBuildRequest {
    #[serde(flatten)]
    pub run_request: RunRequest,
    #[doc = "The fully qualified image names including the repository and tag."]
    #[serde(rename = "imageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub image_names: Vec<String>,
    #[doc = "The value of this property indicates whether the image built should be pushed to the registry or not."]
    #[serde(rename = "isPushEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_push_enabled: Option<bool>,
    #[doc = "The value of this property indicates whether the image cache is enabled or not."]
    #[serde(rename = "noCache", default, skip_serializing_if = "Option::is_none")]
    pub no_cache: Option<bool>,
    #[doc = "The Docker file path relative to the source location."]
    #[serde(rename = "dockerFilePath")]
    pub docker_file_path: String,
    #[doc = "The name of the target build stage for the docker build."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The collection of override arguments to be used when executing the run."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<Argument>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "The platform properties against which the run has to happen."]
    pub platform: PlatformProperties,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.\r\nIf it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API."]
    #[serde(rename = "sourceLocation", default, skip_serializing_if = "Option::is_none")]
    pub source_location: Option<String>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
}
impl DockerBuildRequest {
    pub fn new(docker_file_path: String, platform: PlatformProperties) -> Self {
        Self {
            run_request: RunRequest::default(),
            image_names: Vec::new(),
            is_push_enabled: None,
            no_cache: None,
            docker_file_path,
            target: None,
            arguments: Vec::new(),
            timeout: None,
            platform,
            agent_configuration: None,
            source_location: None,
            credentials: None,
        }
    }
}
#[doc = "The Docker build step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DockerBuildStep {
    #[serde(flatten)]
    pub task_step_properties: TaskStepProperties,
    #[doc = "The fully qualified image names including the repository and tag."]
    #[serde(rename = "imageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub image_names: Vec<String>,
    #[doc = "The value of this property indicates whether the image built should be pushed to the registry or not."]
    #[serde(rename = "isPushEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_push_enabled: Option<bool>,
    #[doc = "The value of this property indicates whether the image cache is enabled or not."]
    #[serde(rename = "noCache", default, skip_serializing_if = "Option::is_none")]
    pub no_cache: Option<bool>,
    #[doc = "The Docker file path relative to the source context."]
    #[serde(rename = "dockerFilePath")]
    pub docker_file_path: String,
    #[doc = "The name of the target build stage for the docker build."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The collection of override arguments to be used when executing this build step."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<Argument>,
}
impl DockerBuildStep {
    pub fn new(docker_file_path: String) -> Self {
        Self {
            task_step_properties: TaskStepProperties::default(),
            image_names: Vec::new(),
            is_push_enabled: None,
            no_cache: None,
            docker_file_path,
            target: None,
            arguments: Vec::new(),
        }
    }
}
#[doc = "The properties for updating a docker build step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DockerBuildStepUpdateParameters {
    #[serde(flatten)]
    pub task_step_update_parameters: TaskStepUpdateParameters,
    #[doc = "The fully qualified image names including the repository and tag."]
    #[serde(rename = "imageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub image_names: Vec<String>,
    #[doc = "The value of this property indicates whether the image built should be pushed to the registry or not."]
    #[serde(rename = "isPushEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_push_enabled: Option<bool>,
    #[doc = "The value of this property indicates whether the image cache is enabled or not."]
    #[serde(rename = "noCache", default, skip_serializing_if = "Option::is_none")]
    pub no_cache: Option<bool>,
    #[doc = "The Docker file path relative to the source context."]
    #[serde(rename = "dockerFilePath", default, skip_serializing_if = "Option::is_none")]
    pub docker_file_path: Option<String>,
    #[doc = "The collection of override arguments to be used when executing this build step."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<Argument>,
    #[doc = "The name of the target build stage for the docker build."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl DockerBuildStepUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for a quick task run request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncodedTaskRunRequest {
    #[serde(flatten)]
    pub run_request: RunRequest,
    #[doc = "Base64 encoded value of the template/definition file content."]
    #[serde(rename = "encodedTaskContent")]
    pub encoded_task_content: String,
    #[doc = "Base64 encoded value of the parameters/values file content."]
    #[serde(rename = "encodedValuesContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_values_content: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "The platform properties against which the run has to happen."]
    pub platform: PlatformProperties,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.\r\nIf it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API."]
    #[serde(rename = "sourceLocation", default, skip_serializing_if = "Option::is_none")]
    pub source_location: Option<String>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
}
impl EncodedTaskRunRequest {
    pub fn new(encoded_task_content: String, platform: PlatformProperties) -> Self {
        Self {
            run_request: RunRequest::default(),
            encoded_task_content,
            encoded_values_content: None,
            values: Vec::new(),
            timeout: None,
            platform,
            agent_configuration: None,
            source_location: None,
            credentials: None,
        }
    }
}
#[doc = "The properties of a encoded task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncodedTaskStep {
    #[serde(flatten)]
    pub task_step_properties: TaskStepProperties,
    #[doc = "Base64 encoded value of the template/definition file content."]
    #[serde(rename = "encodedTaskContent")]
    pub encoded_task_content: String,
    #[doc = "Base64 encoded value of the parameters/values file content."]
    #[serde(rename = "encodedValuesContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_values_content: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
}
impl EncodedTaskStep {
    pub fn new(encoded_task_content: String) -> Self {
        Self {
            task_step_properties: TaskStepProperties::default(),
            encoded_task_content,
            encoded_values_content: None,
            values: Vec::new(),
        }
    }
}
#[doc = "The properties for updating encoded task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncodedTaskStepUpdateParameters {
    #[serde(flatten)]
    pub task_step_update_parameters: TaskStepUpdateParameters,
    #[doc = "Base64 encoded value of the template/definition file content."]
    #[serde(rename = "encodedTaskContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_task_content: Option<String>,
    #[doc = "Base64 encoded value of the parameters/values file content."]
    #[serde(rename = "encodedValuesContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_values_content: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
}
impl EncodedTaskStepUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The event for a webhook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Event {
    #[serde(flatten)]
    pub event_info: EventInfo,
    #[doc = "The event request message sent to the service URI."]
    #[serde(rename = "eventRequestMessage", default, skip_serializing_if = "Option::is_none")]
    pub event_request_message: Option<EventRequestMessage>,
    #[doc = "The event response message received from the service URI."]
    #[serde(rename = "eventResponseMessage", default, skip_serializing_if = "Option::is_none")]
    pub event_response_message: Option<EventResponseMessage>,
}
impl Event {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The content of the event request message."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventContent {
    #[doc = "The event ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The time at which the event occurred."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[doc = "The action that encompasses the provided event."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
    #[doc = "The target of the event."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<Target>,
    #[doc = "The request that generated the event."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub request: Option<Request>,
    #[doc = "The agent that initiated the event. For most situations, this could be from the authorization context of the request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub actor: Option<Actor>,
    #[doc = "The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<Source>,
}
impl EventContent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The basic information of an event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventInfo {
    #[doc = "The event ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl EventInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of a request to list events for a webhook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventListResult {
    #[doc = "The list of events. Since this list may be incomplete, the nextLink field should be used to request the next list of events."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Event>,
    #[doc = "The URI that can be used to request the next list of events."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EventListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The event request message sent to the service URI."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventRequestMessage {
    #[doc = "The content of the event request message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<EventContent>,
    #[doc = "The headers of the event request message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
    #[doc = "The HTTP method used to send the event request message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[doc = "The URI used to send the event request message."]
    #[serde(rename = "requestUri", default, skip_serializing_if = "Option::is_none")]
    pub request_uri: Option<String>,
    #[doc = "The HTTP message version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl EventRequestMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The event response message received from the service URI."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventResponseMessage {
    #[doc = "The content of the event response message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[doc = "The headers of the event response message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
    #[doc = "The reason phrase of the event response message."]
    #[serde(rename = "reasonPhrase", default, skip_serializing_if = "Option::is_none")]
    pub reason_phrase: Option<String>,
    #[doc = "The status code of the event response message."]
    #[serde(rename = "statusCode", default, skip_serializing_if = "Option::is_none")]
    pub status_code: Option<String>,
    #[doc = "The HTTP message version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl EventResponseMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The request parameters for a scheduling run against a task file."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileTaskRunRequest {
    #[serde(flatten)]
    pub run_request: RunRequest,
    #[doc = "The template/definition file path relative to the source."]
    #[serde(rename = "taskFilePath")]
    pub task_file_path: String,
    #[doc = "The values/parameters file path relative to the source."]
    #[serde(rename = "valuesFilePath", default, skip_serializing_if = "Option::is_none")]
    pub values_file_path: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "The platform properties against which the run has to happen."]
    pub platform: PlatformProperties,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.\r\nIf it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API."]
    #[serde(rename = "sourceLocation", default, skip_serializing_if = "Option::is_none")]
    pub source_location: Option<String>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
}
impl FileTaskRunRequest {
    pub fn new(task_file_path: String, platform: PlatformProperties) -> Self {
        Self {
            run_request: RunRequest::default(),
            task_file_path,
            values_file_path: None,
            values: Vec::new(),
            timeout: None,
            platform,
            agent_configuration: None,
            source_location: None,
            credentials: None,
        }
    }
}
#[doc = "The properties of a task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileTaskStep {
    #[serde(flatten)]
    pub task_step_properties: TaskStepProperties,
    #[doc = "The task template/definition file path relative to the source context."]
    #[serde(rename = "taskFilePath")]
    pub task_file_path: String,
    #[doc = "The task values/parameters file path relative to the source context."]
    #[serde(rename = "valuesFilePath", default, skip_serializing_if = "Option::is_none")]
    pub values_file_path: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
}
impl FileTaskStep {
    pub fn new(task_file_path: String) -> Self {
        Self {
            task_step_properties: TaskStepProperties::default(),
            task_file_path,
            values_file_path: None,
            values: Vec::new(),
        }
    }
}
#[doc = "The properties of updating a task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileTaskStepUpdateParameters {
    #[serde(flatten)]
    pub task_step_update_parameters: TaskStepUpdateParameters,
    #[doc = "The task template/definition file path relative to the source context."]
    #[serde(rename = "taskFilePath", default, skip_serializing_if = "Option::is_none")]
    pub task_file_path: Option<String>,
    #[doc = "The values/parameters file path relative to the source context."]
    #[serde(rename = "valuesFilePath", default, skip_serializing_if = "Option::is_none")]
    pub values_file_path: Option<String>,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
}
impl FileTaskStepUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP rule with specific IP or IP range in CIDR format."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpRule {
    #[doc = "The action of IP ACL rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<ip_rule::Action>,
    #[doc = "Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed."]
    pub value: String,
}
impl IpRule {
    pub fn new(value: String) -> Self {
        Self { action: None, value }
    }
}
pub mod ip_rule {
    use super::*;
    #[doc = "The action of IP ACL rule."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Allow,
    }
    impl Default for Action {
        fn default() -> Self {
            Self::Allow
        }
    }
}
#[doc = "Properties for a registry image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageDescriptor {
    #[doc = "The registry login server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registry: Option<String>,
    #[doc = "The repository name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[doc = "The tag name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[doc = "The sha256-based digest of the image manifest."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub digest: Option<String>,
}
impl ImageDescriptor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The image update trigger that caused a build."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageUpdateTrigger {
    #[doc = "The unique ID of the trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The timestamp when the image update happened."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[doc = "The list of image updates that caused the build."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub images: Vec<ImageDescriptor>,
}
impl ImageUpdateTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportImageParameters {
    pub source: ImportSource,
    #[doc = "List of strings of the form repo[:tag]. When tag is omitted the source will be used (or 'latest' if source tag is also omitted)."]
    #[serde(rename = "targetTags", default, skip_serializing_if = "Vec::is_empty")]
    pub target_tags: Vec<String>,
    #[doc = "List of strings of repository names to do a manifest only copy. No tag will be created."]
    #[serde(rename = "untaggedTargetRepositories", default, skip_serializing_if = "Vec::is_empty")]
    pub untagged_target_repositories: Vec<String>,
    #[doc = "When Force, any existing target tags will be overwritten. When NoForce, any existing target tags will fail the operation before any copying begins."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<import_image_parameters::Mode>,
}
impl ImportImageParameters {
    pub fn new(source: ImportSource) -> Self {
        Self {
            source,
            target_tags: Vec::new(),
            untagged_target_repositories: Vec::new(),
            mode: None,
        }
    }
}
pub mod import_image_parameters {
    use super::*;
    #[doc = "When Force, any existing target tags will be overwritten. When NoForce, any existing target tags will fail the operation before any copying begins."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        NoForce,
        Force,
    }
    impl Default for Mode {
        fn default() -> Self {
            Self::NoForce
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportSource {
    #[doc = "The resource identifier of the source Azure Container Registry."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "The address of the source registry (e.g. 'mcr.microsoft.com')."]
    #[serde(rename = "registryUri", default, skip_serializing_if = "Option::is_none")]
    pub registry_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<ImportSourceCredentials>,
    #[doc = "Repository name of the source image.\r\nSpecify an image by repository ('hello-world'). This will use the 'latest' tag.\r\nSpecify an image by tag ('hello-world:latest').\r\nSpecify an image by sha256-based manifest digest ('hello-world@sha256:abc123')."]
    #[serde(rename = "sourceImage")]
    pub source_image: String,
}
impl ImportSource {
    pub fn new(source_image: String) -> Self {
        Self {
            resource_id: None,
            registry_uri: None,
            credentials: None,
            source_image,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportSourceCredentials {
    #[doc = "The username to authenticate with the source registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "The password used to authenticate with the source registry."]
    pub password: String,
}
impl ImportSourceCredentials {
    pub fn new(password: String) -> Self {
        Self { username: None, password }
    }
}
#[doc = "The network rule set for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkRuleSet {
    #[doc = "The default action of allow or deny when no other rules match."]
    #[serde(rename = "defaultAction")]
    pub default_action: network_rule_set::DefaultAction,
    #[doc = "The virtual network rules."]
    #[serde(rename = "virtualNetworkRules", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_rules: Vec<VirtualNetworkRule>,
    #[doc = "The IP ACL rules."]
    #[serde(rename = "ipRules", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_rules: Vec<IpRule>,
}
impl NetworkRuleSet {
    pub fn new(default_action: network_rule_set::DefaultAction) -> Self {
        Self {
            default_action,
            virtual_network_rules: Vec::new(),
            ip_rules: Vec::new(),
        }
    }
}
pub mod network_rule_set {
    use super::*;
    #[doc = "The default action of allow or deny when no other rules match."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DefaultAction {
        Allow,
        Deny,
    }
    impl Default for DefaultAction {
        fn default() -> Self {
            Self::Allow
        }
    }
}
#[doc = "The definition of a container registry operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDefinition {
    #[doc = "The origin information of the container registry operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[doc = "Operation name: {provider}/{resource}/{operation}."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The display information for a container registry operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationDisplayDefinition>,
    #[doc = "The definition of Azure Monitoring properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationPropertiesDefinition>,
}
impl OperationDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The display information for a container registry operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDisplayDefinition {
    #[doc = "The resource provider name: Microsoft.ContainerRegistry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "The resource on which the operation is performed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[doc = "The operation that users can perform."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "The description for the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationDisplayDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of a request to list container registry operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "The list of container registry operations. Since this list may be incomplete, the nextLink field should be used to request the next list of operations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OperationDefinition>,
    #[doc = "The URI that can be used to request the next list of container registry operations."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The definition of Azure Monitoring metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationMetricSpecificationDefinition {
    #[doc = "Metric name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Metric display name."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Metric description."]
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[doc = "Metric unit."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[doc = "Metric aggregation type."]
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[doc = "Internal metric name."]
    #[serde(rename = "internalMetricName", default, skip_serializing_if = "Option::is_none")]
    pub internal_metric_name: Option<String>,
}
impl OperationMetricSpecificationDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The definition of Azure Monitoring properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationPropertiesDefinition {
    #[doc = "The definition of Azure Monitoring metrics list."]
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<OperationServiceSpecificationDefinition>,
}
impl OperationPropertiesDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The definition of Azure Monitoring metrics list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationServiceSpecificationDefinition {
    #[doc = "A list of Azure Monitoring metrics definition."]
    #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_specifications: Vec<OperationMetricSpecificationDefinition>,
}
impl OperationServiceSpecificationDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The platform properties against which the run has to happen."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PlatformProperties {
    #[doc = "The operating system type required for the run."]
    pub os: platform_properties::Os,
    #[doc = "The OS architecture."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub architecture: Option<platform_properties::Architecture>,
    #[doc = "Variant of the CPU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub variant: Option<platform_properties::Variant>,
}
impl PlatformProperties {
    pub fn new(os: platform_properties::Os) -> Self {
        Self {
            os,
            architecture: None,
            variant: None,
        }
    }
}
pub mod platform_properties {
    use super::*;
    #[doc = "The operating system type required for the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Os {
        Windows,
        Linux,
    }
    #[doc = "The OS architecture."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Architecture {
        #[serde(rename = "amd64")]
        Amd64,
        #[serde(rename = "x86")]
        X86,
        #[serde(rename = "arm")]
        Arm,
    }
    #[doc = "Variant of the CPU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Variant {
        #[serde(rename = "v6")]
        V6,
        #[serde(rename = "v7")]
        V7,
        #[serde(rename = "v8")]
        V8,
    }
}
#[doc = "The properties for updating the platform configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PlatformUpdateParameters {
    #[doc = "The operating system type required for the run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub os: Option<platform_update_parameters::Os>,
    #[doc = "The OS architecture."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub architecture: Option<platform_update_parameters::Architecture>,
    #[doc = "Variant of the CPU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub variant: Option<platform_update_parameters::Variant>,
}
impl PlatformUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod platform_update_parameters {
    use super::*;
    #[doc = "The operating system type required for the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Os {
        Windows,
        Linux,
    }
    #[doc = "The OS architecture."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Architecture {
        #[serde(rename = "amd64")]
        Amd64,
        #[serde(rename = "x86")]
        X86,
        #[serde(rename = "arm")]
        Arm,
    }
    #[doc = "Variant of the CPU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Variant {
        #[serde(rename = "v6")]
        V6,
        #[serde(rename = "v7")]
        V7,
        #[serde(rename = "v8")]
        V8,
    }
}
#[doc = "The resource model definition for a ARM proxy resource. It will have everything other than required location and tags."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An object that represents quarantine policy for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuarantinePolicy {
    #[doc = "The value that indicates whether the policy is enabled or not."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<quarantine_policy::Status>,
}
impl QuarantinePolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod quarantine_policy {
    use super::*;
    #[doc = "The value that indicates whether the policy is enabled or not."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
}
#[doc = "The parameters used to regenerate the login credential."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegenerateCredentialParameters {
    #[doc = "Specifies name of the password which should be regenerated -- password or password2."]
    pub name: regenerate_credential_parameters::Name,
}
impl RegenerateCredentialParameters {
    pub fn new(name: regenerate_credential_parameters::Name) -> Self {
        Self { name }
    }
}
pub mod regenerate_credential_parameters {
    use super::*;
    #[doc = "Specifies name of the password which should be regenerated -- password or password2."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "password")]
        Password,
        #[serde(rename = "password2")]
        Password2,
    }
}
#[doc = "An object that represents a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Registry {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The SKU of a container registry."]
    pub sku: Sku,
    #[doc = "The properties of a container registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RegistryProperties>,
}
impl Registry {
    pub fn new(resource: Resource, sku: Sku) -> Self {
        Self {
            resource,
            sku,
            properties: None,
        }
    }
}
#[doc = "The response from the ListCredentials operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryListCredentialsResult {
    #[doc = "The username for a container registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "The list of passwords for a container registry."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub passwords: Vec<RegistryPassword>,
}
impl RegistryListCredentialsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of a request to list container registries."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryListResult {
    #[doc = "The list of container registries. Since this list may be incomplete, the nextLink field should be used to request the next list of container registries."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Registry>,
    #[doc = "The URI that can be used to request the next list of container registries."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RegistryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A request to check whether a container registry name is available."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegistryNameCheckRequest {
    #[doc = "The name of the container registry."]
    pub name: String,
    #[doc = "The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'."]
    #[serde(rename = "type")]
    pub type_: registry_name_check_request::Type,
}
impl RegistryNameCheckRequest {
    pub fn new(name: String, type_: registry_name_check_request::Type) -> Self {
        Self { name, type_ }
    }
}
pub mod registry_name_check_request {
    use super::*;
    #[doc = "The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.ContainerRegistry/registries")]
        MicrosoftContainerRegistryRegistries,
    }
}
#[doc = "The result of a request to check the availability of a container registry name."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryNameStatus {
    #[doc = "The value that indicates whether the name is available."]
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[doc = "If any, the reason that the name is not available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[doc = "If any, the error message that provides more detail for the reason that the name is not available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl RegistryNameStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The login password for the container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryPassword {
    #[doc = "The password name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<registry_password::Name>,
    #[doc = "The password value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl RegistryPassword {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod registry_password {
    use super::*;
    #[doc = "The password name."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "password")]
        Password,
        #[serde(rename = "password2")]
        Password2,
    }
}
#[doc = "An object that represents policies for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryPolicies {
    #[doc = "An object that represents quarantine policy for a container registry."]
    #[serde(rename = "quarantinePolicy", default, skip_serializing_if = "Option::is_none")]
    pub quarantine_policy: Option<QuarantinePolicy>,
    #[doc = "An object that represents content trust policy for a container registry."]
    #[serde(rename = "trustPolicy", default, skip_serializing_if = "Option::is_none")]
    pub trust_policy: Option<TrustPolicy>,
}
impl RegistryPolicies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryProperties {
    #[doc = "The URL that can be used to log into the container registry."]
    #[serde(rename = "loginServer", default, skip_serializing_if = "Option::is_none")]
    pub login_server: Option<String>,
    #[doc = "The creation date of the container registry in ISO8601 format."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "The provisioning state of the container registry at the time the operation was called."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<registry_properties::ProvisioningState>,
    #[doc = "The status of an Azure resource at the time the operation was called."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<Status>,
    #[doc = "The value that indicates whether the admin user is enabled."]
    #[serde(rename = "adminUserEnabled", default, skip_serializing_if = "Option::is_none")]
    pub admin_user_enabled: Option<bool>,
    #[doc = "The properties of a storage account for a container registry. Only applicable to Classic SKU."]
    #[serde(rename = "storageAccount", default, skip_serializing_if = "Option::is_none")]
    pub storage_account: Option<StorageAccountProperties>,
    #[doc = "The network rule set for a container registry."]
    #[serde(rename = "networkRuleSet", default, skip_serializing_if = "Option::is_none")]
    pub network_rule_set: Option<NetworkRuleSet>,
}
impl RegistryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod registry_properties {
    use super::*;
    #[doc = "The provisioning state of the container registry at the time the operation was called."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The parameters for updating the properties of a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryPropertiesUpdateParameters {
    #[doc = "The value that indicates whether the admin user is enabled."]
    #[serde(rename = "adminUserEnabled", default, skip_serializing_if = "Option::is_none")]
    pub admin_user_enabled: Option<bool>,
    #[doc = "The properties of a storage account for a container registry. Only applicable to Classic SKU."]
    #[serde(rename = "storageAccount", default, skip_serializing_if = "Option::is_none")]
    pub storage_account: Option<StorageAccountProperties>,
    #[doc = "The network rule set for a container registry."]
    #[serde(rename = "networkRuleSet", default, skip_serializing_if = "Option::is_none")]
    pub network_rule_set: Option<NetworkRuleSet>,
}
impl RegistryPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for updating a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryUpdateParameters {
    #[doc = "The tags for the container registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The SKU of a container registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "The parameters for updating the properties of a container registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RegistryPropertiesUpdateParameters>,
}
impl RegistryUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The quota usage for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryUsage {
    #[doc = "The name of the usage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The limit of the usage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "The current value of the usage."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[doc = "The unit of measurement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<registry_usage::Unit>,
}
impl RegistryUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod registry_usage {
    use super::*;
    #[doc = "The unit of measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
        Bytes,
    }
}
#[doc = "The result of a request to get container registry quota usages."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryUsageListResult {
    #[doc = "The list of container registry quota usages."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RegistryUsage>,
}
impl RegistryUsageListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An object that represents a replication for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Replication {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of a replication."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReplicationProperties>,
}
impl Replication {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The result of a request to list replications for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationListResult {
    #[doc = "The list of replications. Since this list may be incomplete, the nextLink field should be used to request the next list of replications."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Replication>,
    #[doc = "The URI that can be used to request the next list of replications."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ReplicationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a replication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProperties {
    #[doc = "The provisioning state of the replication at the time the operation was called."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<replication_properties::ProvisioningState>,
    #[doc = "The status of an Azure resource at the time the operation was called."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<Status>,
}
impl ReplicationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod replication_properties {
    use super::*;
    #[doc = "The provisioning state of the replication at the time the operation was called."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The parameters for updating a replication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationUpdateParameters {
    #[doc = "The tags for the replication."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ReplicationUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The request that generated the event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Request {
    #[doc = "The ID of the request that initiated the event."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the standard http request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub addr: Option<String>,
    #[doc = "The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[doc = "The request method that generated the event."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[doc = "The user agent header of the request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub useragent: Option<String>,
}
impl Request {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The location of the resource. This cannot be changed after the resource is created."]
    pub location: String,
    #[doc = "The tags of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[doc = "Run resource properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Run {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties for a run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RunProperties>,
}
impl Run {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties that are enabled for Odata querying on runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunFilter {
    #[doc = "The unique identifier for the run."]
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[doc = "The type of run."]
    #[serde(rename = "runType", default, skip_serializing_if = "Option::is_none")]
    pub run_type: Option<run_filter::RunType>,
    #[doc = "The current status of the run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<run_filter::Status>,
    #[doc = "The create time for a run."]
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[doc = "The time the run finished."]
    #[serde(rename = "finishTime", default, skip_serializing_if = "Option::is_none")]
    pub finish_time: Option<String>,
    #[doc = "The list of comma-separated image manifests that were generated from the run. This is applicable if the run is of\r\nbuild type."]
    #[serde(rename = "outputImageManifests", default, skip_serializing_if = "Option::is_none")]
    pub output_image_manifests: Option<String>,
    #[doc = "The value that indicates whether archiving is enabled or not."]
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
    #[doc = "The name of the task that the run corresponds to."]
    #[serde(rename = "taskName", default, skip_serializing_if = "Option::is_none")]
    pub task_name: Option<String>,
}
impl RunFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod run_filter {
    use super::*;
    #[doc = "The type of run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RunType {
        QuickBuild,
        QuickRun,
        AutoBuild,
        AutoRun,
    }
    #[doc = "The current status of the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Queued,
        Started,
        Running,
        Succeeded,
        Failed,
        Canceled,
        Error,
        Timeout,
    }
}
#[doc = "The result of get log link operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunGetLogResult {
    #[doc = "The link to logs for a run on a azure container registry."]
    #[serde(rename = "logLink", default, skip_serializing_if = "Option::is_none")]
    pub log_link: Option<String>,
}
impl RunGetLogResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunListResult {
    #[doc = "The collection value."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Run>,
    #[doc = "The URI that can be used to request the next set of paged results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RunListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for a run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunProperties {
    #[doc = "The unique identifier for the run."]
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[doc = "The current status of the run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<run_properties::Status>,
    #[doc = "The last updated time for the run."]
    #[serde(rename = "lastUpdatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_time: Option<String>,
    #[doc = "The type of run."]
    #[serde(rename = "runType", default, skip_serializing_if = "Option::is_none")]
    pub run_type: Option<run_properties::RunType>,
    #[doc = "The time the run was scheduled."]
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[doc = "The time the run started."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The time the run finished."]
    #[serde(rename = "finishTime", default, skip_serializing_if = "Option::is_none")]
    pub finish_time: Option<String>,
    #[doc = "The list of all images that were generated from the run. This is applicable if the run generates base image dependencies."]
    #[serde(rename = "outputImages", default, skip_serializing_if = "Vec::is_empty")]
    pub output_images: Vec<ImageDescriptor>,
    #[doc = "The task against which run was scheduled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub task: Option<String>,
    #[doc = "The image update trigger that caused a build."]
    #[serde(rename = "imageUpdateTrigger", default, skip_serializing_if = "Option::is_none")]
    pub image_update_trigger: Option<ImageUpdateTrigger>,
    #[doc = "The source trigger that caused a run."]
    #[serde(rename = "sourceTrigger", default, skip_serializing_if = "Option::is_none")]
    pub source_trigger: Option<SourceTriggerDescriptor>,
    #[doc = "The platform properties against which the run has to happen."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub platform: Option<PlatformProperties>,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "The scope of the credentials that were used to login to the source registry during this run."]
    #[serde(rename = "sourceRegistryAuth", default, skip_serializing_if = "Option::is_none")]
    pub source_registry_auth: Option<String>,
    #[doc = "The list of custom registries that were logged in during this run."]
    #[serde(rename = "customRegistries", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_registries: Vec<String>,
    #[doc = "The error message received from backend systems after the run is scheduled."]
    #[serde(rename = "runErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub run_error_message: Option<String>,
    #[doc = "The provisioning state of a run."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<run_properties::ProvisioningState>,
    #[doc = "The value that indicates whether archiving is enabled or not."]
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
}
impl RunProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod run_properties {
    use super::*;
    #[doc = "The current status of the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Queued,
        Started,
        Running,
        Succeeded,
        Failed,
        Canceled,
        Error,
        Timeout,
    }
    #[doc = "The type of run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RunType {
        QuickBuild,
        QuickRun,
        AutoBuild,
        AutoRun,
    }
    #[doc = "The provisioning state of a run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The request parameters for scheduling a run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunRequest {
    #[doc = "The type of the run request."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The value that indicates whether archiving is enabled for the run or not."]
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
}
impl RunRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The set of run properties that can be updated."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunUpdateParameters {
    #[doc = "The value that indicates whether archiving is enabled or not."]
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
}
impl RunUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a secret object value."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecretObject {
    #[doc = "The value of the secret. The format of this value will be determined\r\nbased on the type of the secret object. If the type is Opaque, the value will be\r\nused as is without any modification."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "The type of the secret object which determines how the value of the secret object has to be\r\ninterpreted."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<secret_object::Type>,
}
impl SecretObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod secret_object {
    use super::*;
    #[doc = "The type of the secret object which determines how the value of the secret object has to be\r\ninterpreted."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Opaque,
    }
}
#[doc = "The properties of a overridable value that can be passed to a task template."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SetValue {
    #[doc = "The name of the overridable value."]
    pub name: String,
    #[doc = "The overridable value."]
    pub value: String,
    #[doc = "Flag to indicate whether the value represents a secret or not."]
    #[serde(rename = "isSecret", default, skip_serializing_if = "Option::is_none")]
    pub is_secret: Option<bool>,
}
impl SetValue {
    pub fn new(name: String, value: String) -> Self {
        Self {
            name,
            value,
            is_secret: None,
        }
    }
}
#[doc = "The SKU of a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Sku {
    #[doc = "The SKU name of the container registry. Required for registry creation."]
    pub name: sku::Name,
    #[doc = "The SKU tier based on the SKU name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<sku::Tier>,
}
impl Sku {
    pub fn new(name: sku::Name) -> Self {
        Self { name, tier: None }
    }
}
pub mod sku {
    use super::*;
    #[doc = "The SKU name of the container registry. Required for registry creation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Classic,
        Basic,
        Standard,
        Premium,
    }
    #[doc = "The SKU tier based on the SKU name."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Classic,
        Basic,
        Standard,
        Premium,
    }
}
#[doc = "The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Source {
    #[doc = "The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname() along with the running port."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub addr: Option<String>,
    #[doc = "The running instance of an application. Changes after each restart."]
    #[serde(rename = "instanceID", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
}
impl Source {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of the source code repository."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceProperties {
    #[doc = "The type of source control service."]
    #[serde(rename = "sourceControlType")]
    pub source_control_type: source_properties::SourceControlType,
    #[doc = "The full URL to the source code repository"]
    #[serde(rename = "repositoryUrl")]
    pub repository_url: String,
    #[doc = "The branch name of the source code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[doc = "The authorization properties for accessing the source code repository."]
    #[serde(rename = "sourceControlAuthProperties", default, skip_serializing_if = "Option::is_none")]
    pub source_control_auth_properties: Option<AuthInfo>,
}
impl SourceProperties {
    pub fn new(source_control_type: source_properties::SourceControlType, repository_url: String) -> Self {
        Self {
            source_control_type,
            repository_url,
            branch: None,
            source_control_auth_properties: None,
        }
    }
}
pub mod source_properties {
    use super::*;
    #[doc = "The type of source control service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceControlType {
        Github,
        VisualStudioTeamService,
    }
}
#[doc = "Describes the credential parameters for accessing the source registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceRegistryCredentials {
    #[doc = "The authentication mode which determines the source registry login scope. The credentials for the source registry\r\nwill be generated using the given scope. These credentials will be used to login to\r\nthe source registry during the run."]
    #[serde(rename = "loginMode", default, skip_serializing_if = "Option::is_none")]
    pub login_mode: Option<source_registry_credentials::LoginMode>,
}
impl SourceRegistryCredentials {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod source_registry_credentials {
    use super::*;
    #[doc = "The authentication mode which determines the source registry login scope. The credentials for the source registry\r\nwill be generated using the given scope. These credentials will be used to login to\r\nthe source registry during the run."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoginMode {
        None,
        Default,
    }
}
#[doc = "The properties of a source based trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceTrigger {
    #[doc = "The properties of the source code repository."]
    #[serde(rename = "sourceRepository")]
    pub source_repository: SourceProperties,
    #[doc = "The source event corresponding to the trigger."]
    #[serde(rename = "sourceTriggerEvents")]
    pub source_trigger_events: Vec<String>,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<source_trigger::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl SourceTrigger {
    pub fn new(source_repository: SourceProperties, source_trigger_events: Vec<String>, name: String) -> Self {
        Self {
            source_repository,
            source_trigger_events,
            status: None,
            name,
        }
    }
}
pub mod source_trigger {
    use super::*;
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "The source trigger that caused a run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceTriggerDescriptor {
    #[doc = "The unique ID of the trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The event type of the trigger."]
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[doc = "The unique ID that identifies a commit."]
    #[serde(rename = "commitId", default, skip_serializing_if = "Option::is_none")]
    pub commit_id: Option<String>,
    #[doc = "The unique ID that identifies pull request."]
    #[serde(rename = "pullRequestId", default, skip_serializing_if = "Option::is_none")]
    pub pull_request_id: Option<String>,
    #[doc = "The repository URL."]
    #[serde(rename = "repositoryUrl", default, skip_serializing_if = "Option::is_none")]
    pub repository_url: Option<String>,
    #[doc = "The branch name in the repository."]
    #[serde(rename = "branchName", default, skip_serializing_if = "Option::is_none")]
    pub branch_name: Option<String>,
    #[doc = "The source control provider type."]
    #[serde(rename = "providerType", default, skip_serializing_if = "Option::is_none")]
    pub provider_type: Option<String>,
}
impl SourceTriggerDescriptor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for updating a source based trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceTriggerUpdateParameters {
    #[doc = "The properties for updating the source code repository."]
    #[serde(rename = "sourceRepository", default, skip_serializing_if = "Option::is_none")]
    pub source_repository: Option<SourceUpdateParameters>,
    #[doc = "The source event corresponding to the trigger."]
    #[serde(rename = "sourceTriggerEvents", default, skip_serializing_if = "Vec::is_empty")]
    pub source_trigger_events: Vec<String>,
    #[doc = "The current status of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<source_trigger_update_parameters::Status>,
    #[doc = "The name of the trigger."]
    pub name: String,
}
impl SourceTriggerUpdateParameters {
    pub fn new(name: String) -> Self {
        Self {
            source_repository: None,
            source_trigger_events: Vec::new(),
            status: None,
            name,
        }
    }
}
pub mod source_trigger_update_parameters {
    use super::*;
    #[doc = "The current status of trigger."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
    impl Default for Status {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "The properties for updating the source code repository."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceUpdateParameters {
    #[doc = "The type of source control service."]
    #[serde(rename = "sourceControlType", default, skip_serializing_if = "Option::is_none")]
    pub source_control_type: Option<source_update_parameters::SourceControlType>,
    #[doc = "The full URL to the source code repository"]
    #[serde(rename = "repositoryUrl", default, skip_serializing_if = "Option::is_none")]
    pub repository_url: Option<String>,
    #[doc = "The branch name of the source code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[doc = "The authorization properties for accessing the source code repository."]
    #[serde(rename = "sourceControlAuthProperties", default, skip_serializing_if = "Option::is_none")]
    pub source_control_auth_properties: Option<AuthInfoUpdateParameters>,
}
impl SourceUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod source_update_parameters {
    use super::*;
    #[doc = "The type of source control service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceControlType {
        Github,
        VisualStudioTeamService,
    }
}
#[doc = "The properties of a response to source upload request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceUploadDefinition {
    #[doc = "The URL where the client can upload the source."]
    #[serde(rename = "uploadUrl", default, skip_serializing_if = "Option::is_none")]
    pub upload_url: Option<String>,
    #[doc = "The relative path to the source. This is used to submit the subsequent queue build request."]
    #[serde(rename = "relativePath", default, skip_serializing_if = "Option::is_none")]
    pub relative_path: Option<String>,
}
impl SourceUploadDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The status of an Azure resource at the time the operation was called."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Status {
    #[doc = "The short label for the status."]
    #[serde(rename = "displayStatus", default, skip_serializing_if = "Option::is_none")]
    pub display_status: Option<String>,
    #[doc = "The detailed message for the status, including alerts and error messages."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The timestamp when the status was changed to the current value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
}
impl Status {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a storage account for a container registry. Only applicable to Classic SKU."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageAccountProperties {
    #[doc = "The resource ID of the storage account."]
    pub id: String,
}
impl StorageAccountProperties {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "The target of the event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Target {
    #[doc = "The MIME type of the referenced object."]
    #[serde(rename = "mediaType", default, skip_serializing_if = "Option::is_none")]
    pub media_type: Option<String>,
    #[doc = "The number of bytes of the content. Same as Length field."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<i64>,
    #[doc = "The digest of the content, as defined by the Registry V2 HTTP API Specification."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub digest: Option<String>,
    #[doc = "The number of bytes of the content. Same as Size field."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub length: Option<i64>,
    #[doc = "The repository name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[doc = "The direct URL to the content."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[doc = "The tag name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[doc = "The name of the artifact."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The version of the artifact."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl Target {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The task that has the ARM resource and task properties. \r\nThe task will have all information to schedule a run against it."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Task {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of a task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TaskProperties>,
}
impl Task {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The collection of tasks."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskListResult {
    #[doc = "The collection value."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Task>,
    #[doc = "The URI that can be used to request the next set of paged results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TaskListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a task."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskProperties {
    #[doc = "The provisioning state of the task."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<task_properties::ProvisioningState>,
    #[doc = "The creation date of task."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "The current status of task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<task_properties::Status>,
    #[doc = "The platform properties against which the run has to happen."]
    pub platform: PlatformProperties,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "Base properties for any task step."]
    pub step: TaskStepProperties,
    #[doc = "The properties of a trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub trigger: Option<TriggerProperties>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
}
impl TaskProperties {
    pub fn new(platform: PlatformProperties, step: TaskStepProperties) -> Self {
        Self {
            provisioning_state: None,
            creation_date: None,
            status: None,
            platform,
            agent_configuration: None,
            timeout: None,
            step,
            trigger: None,
            credentials: None,
        }
    }
}
pub mod task_properties {
    use super::*;
    #[doc = "The provisioning state of the task."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
    #[doc = "The current status of task."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
}
#[doc = "The properties for updating a task."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskPropertiesUpdateParameters {
    #[doc = "The current status of task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<task_properties_update_parameters::Status>,
    #[doc = "The properties for updating the platform configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub platform: Option<PlatformUpdateParameters>,
    #[doc = "The properties that determine the run agent configuration."]
    #[serde(rename = "agentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub agent_configuration: Option<AgentProperties>,
    #[doc = "Run timeout in seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "Base properties for updating any task step."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub step: Option<TaskStepUpdateParameters>,
    #[doc = "The properties for updating triggers."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub trigger: Option<TriggerUpdateParameters>,
    #[doc = "The parameters that describes a set of credentials that will be used when a run is invoked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<Credentials>,
}
impl TaskPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod task_properties_update_parameters {
    use super::*;
    #[doc = "The current status of task."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
}
#[doc = "The parameters for a task run request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskRunRequest {
    #[serde(flatten)]
    pub run_request: RunRequest,
    #[doc = "The name of task against which run has to be queued."]
    #[serde(rename = "taskName")]
    pub task_name: String,
    #[doc = "The collection of overridable values that can be passed when running a task."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<SetValue>,
}
impl TaskRunRequest {
    pub fn new(task_name: String) -> Self {
        Self {
            run_request: RunRequest::default(),
            task_name,
            values: Vec::new(),
        }
    }
}
#[doc = "Base properties for any task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskStepProperties {
    #[doc = "The type of the step."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<task_step_properties::Type>,
    #[doc = "List of base image dependencies for a step."]
    #[serde(rename = "baseImageDependencies", default, skip_serializing_if = "Vec::is_empty")]
    pub base_image_dependencies: Vec<BaseImageDependency>,
    #[doc = "The URL(absolute or relative) of the source context for the task step."]
    #[serde(rename = "contextPath", default, skip_serializing_if = "Option::is_none")]
    pub context_path: Option<String>,
    #[doc = "The token (git PAT or SAS token of storage account blob) associated with the context for a step."]
    #[serde(rename = "contextAccessToken", default, skip_serializing_if = "Option::is_none")]
    pub context_access_token: Option<String>,
}
impl TaskStepProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod task_step_properties {
    use super::*;
    #[doc = "The type of the step."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Docker,
        FileTask,
        EncodedTask,
    }
}
#[doc = "Base properties for updating any task step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskStepUpdateParameters {
    #[doc = "The type of the step."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<task_step_update_parameters::Type>,
    #[doc = "The URL(absolute or relative) of the source context for the task step."]
    #[serde(rename = "contextPath", default, skip_serializing_if = "Option::is_none")]
    pub context_path: Option<String>,
    #[doc = "The token (git PAT or SAS token of storage account blob) associated with the context for a step."]
    #[serde(rename = "contextAccessToken", default, skip_serializing_if = "Option::is_none")]
    pub context_access_token: Option<String>,
}
impl TaskStepUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod task_step_update_parameters {
    use super::*;
    #[doc = "The type of the step."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Docker,
        FileTask,
        EncodedTask,
    }
}
#[doc = "The parameters for updating a task."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskUpdateParameters {
    #[doc = "The properties for updating a task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TaskPropertiesUpdateParameters>,
    #[doc = "The ARM resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TaskUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerProperties {
    #[doc = "The collection of triggers based on source code repository."]
    #[serde(rename = "sourceTriggers", default, skip_serializing_if = "Vec::is_empty")]
    pub source_triggers: Vec<SourceTrigger>,
    #[doc = "The trigger based on base image dependency."]
    #[serde(rename = "baseImageTrigger", default, skip_serializing_if = "Option::is_none")]
    pub base_image_trigger: Option<BaseImageTrigger>,
}
impl TriggerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties for updating triggers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerUpdateParameters {
    #[doc = "The collection of triggers based on source code repository."]
    #[serde(rename = "sourceTriggers", default, skip_serializing_if = "Vec::is_empty")]
    pub source_triggers: Vec<SourceTriggerUpdateParameters>,
    #[doc = "The properties for updating base image dependency trigger."]
    #[serde(rename = "baseImageTrigger", default, skip_serializing_if = "Option::is_none")]
    pub base_image_trigger: Option<BaseImageTriggerUpdateParameters>,
}
impl TriggerUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An object that represents content trust policy for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrustPolicy {
    #[doc = "The type of trust policy."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<trust_policy::Type>,
    #[doc = "The value that indicates whether the policy is enabled or not."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<trust_policy::Status>,
}
impl TrustPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod trust_policy {
    use super::*;
    #[doc = "The type of trust policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Notary,
    }
    #[doc = "The value that indicates whether the policy is enabled or not."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
}
#[doc = "Virtual network rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkRule {
    #[doc = "The action of virtual network rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<virtual_network_rule::Action>,
    #[doc = "Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}."]
    pub id: String,
}
impl VirtualNetworkRule {
    pub fn new(id: String) -> Self {
        Self { action: None, id }
    }
}
pub mod virtual_network_rule {
    use super::*;
    #[doc = "The action of virtual network rule."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Allow,
    }
    impl Default for Action {
        fn default() -> Self {
            Self::Allow
        }
    }
}
#[doc = "An object that represents a webhook for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Webhook {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of a webhook."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WebhookProperties>,
}
impl Webhook {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The parameters for creating a webhook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebhookCreateParameters {
    #[doc = "The tags for the webhook."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The location of the webhook. This cannot be changed after the resource is created."]
    pub location: String,
    #[doc = "The parameters for creating the properties of a webhook."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WebhookPropertiesCreateParameters>,
}
impl WebhookCreateParameters {
    pub fn new(location: String) -> Self {
        Self {
            tags: None,
            location,
            properties: None,
        }
    }
}
#[doc = "The result of a request to list webhooks for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebhookListResult {
    #[doc = "The list of webhooks. Since this list may be incomplete, the nextLink field should be used to request the next list of webhooks."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Webhook>,
    #[doc = "The URI that can be used to request the next list of webhooks."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebhookListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a webhook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebhookProperties {
    #[doc = "The status of the webhook at the time the operation was called."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<webhook_properties::Status>,
    #[doc = "The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[doc = "The list of actions that trigger the webhook to post notifications."]
    pub actions: Vec<String>,
    #[doc = "The provisioning state of the webhook at the time the operation was called."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<webhook_properties::ProvisioningState>,
}
impl WebhookProperties {
    pub fn new(actions: Vec<String>) -> Self {
        Self {
            status: None,
            scope: None,
            actions,
            provisioning_state: None,
        }
    }
}
pub mod webhook_properties {
    use super::*;
    #[doc = "The status of the webhook at the time the operation was called."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
    #[doc = "The provisioning state of the webhook at the time the operation was called."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The parameters for creating the properties of a webhook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebhookPropertiesCreateParameters {
    #[doc = "The service URI for the webhook to post notifications."]
    #[serde(rename = "serviceUri")]
    pub service_uri: String,
    #[doc = "Custom headers that will be added to the webhook notifications."]
    #[serde(rename = "customHeaders", default, skip_serializing_if = "Option::is_none")]
    pub custom_headers: Option<serde_json::Value>,
    #[doc = "The status of the webhook at the time the operation was called."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<webhook_properties_create_parameters::Status>,
    #[doc = "The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[doc = "The list of actions that trigger the webhook to post notifications."]
    pub actions: Vec<String>,
}
impl WebhookPropertiesCreateParameters {
    pub fn new(service_uri: String, actions: Vec<String>) -> Self {
        Self {
            service_uri,
            custom_headers: None,
            status: None,
            scope: None,
            actions,
        }
    }
}
pub mod webhook_properties_create_parameters {
    use super::*;
    #[doc = "The status of the webhook at the time the operation was called."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
}
#[doc = "The parameters for updating the properties of a webhook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebhookPropertiesUpdateParameters {
    #[doc = "The service URI for the webhook to post notifications."]
    #[serde(rename = "serviceUri", default, skip_serializing_if = "Option::is_none")]
    pub service_uri: Option<String>,
    #[doc = "Custom headers that will be added to the webhook notifications."]
    #[serde(rename = "customHeaders", default, skip_serializing_if = "Option::is_none")]
    pub custom_headers: Option<serde_json::Value>,
    #[doc = "The status of the webhook at the time the operation was called."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<webhook_properties_update_parameters::Status>,
    #[doc = "The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[doc = "The list of actions that trigger the webhook to post notifications."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub actions: Vec<String>,
}
impl WebhookPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod webhook_properties_update_parameters {
    use super::*;
    #[doc = "The status of the webhook at the time the operation was called."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
}
#[doc = "The parameters for updating a webhook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebhookUpdateParameters {
    #[doc = "The tags for the webhook."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The parameters for updating the properties of a webhook."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WebhookPropertiesUpdateParameters>,
}
impl WebhookUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
