#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "An object that represents a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Registry {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of a container registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RegistryProperties>,
}
impl Registry {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The result of a request to get the administrator login credentials for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryCredentials {
    #[doc = "The administrator username."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "The administrator password."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl RegistryCredentials {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of a request to list container registries."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryListResult {
    #[doc = "The list of container registries. Since this list may be incomplete, the nextLink field should be used to request the next list of container registries."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Registry>,
    #[doc = "The URI that can be used to request the next list of container registries."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RegistryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A request to check whether the container registry name is available."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegistryNameCheckRequest {
    #[doc = "The name of the container registry."]
    pub name: String,
    #[doc = "The resource type of the container registry. This field must be set to \"Microsoft.ContainerRegistry/registries\"."]
    #[serde(rename = "type")]
    pub type_: registry_name_check_request::Type,
}
impl RegistryNameCheckRequest {
    pub fn new(name: String, type_: registry_name_check_request::Type) -> Self {
        Self { name, type_ }
    }
}
pub mod registry_name_check_request {
    use super::*;
    #[doc = "The resource type of the container registry. This field must be set to \"Microsoft.ContainerRegistry/registries\"."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.ContainerRegistry/registries")]
        MicrosoftContainerRegistryRegistries,
    }
}
#[doc = "The result of a request to check the availability of a container registry name."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryNameStatus {
    #[doc = "The value that indicates whether the name is available."]
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[doc = "If any, the reason that the name is not available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[doc = "If any, the error message that provides more detail for the reason that the name is not available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl RegistryNameStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegistryProperties {
    #[doc = "The URL that can be used to log into the container registry."]
    #[serde(rename = "loginServer", default, skip_serializing_if = "Option::is_none")]
    pub login_server: Option<String>,
    #[doc = "The creation date of the container registry in ISO8601 format."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "The value that indicates whether the admin user is enabled. This value is false by default."]
    #[serde(rename = "adminUserEnabled", default, skip_serializing_if = "Option::is_none")]
    pub admin_user_enabled: Option<bool>,
    #[doc = "The properties of a storage account for a container registry."]
    #[serde(rename = "storageAccount")]
    pub storage_account: StorageAccountProperties,
}
impl RegistryProperties {
    pub fn new(storage_account: StorageAccountProperties) -> Self {
        Self {
            login_server: None,
            creation_date: None,
            admin_user_enabled: None,
            storage_account,
        }
    }
}
#[doc = "The parameters for updating the properties of a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryPropertiesUpdateParameters {
    #[doc = "The value that indicates whether the admin user is enabled. This value is false by default."]
    #[serde(rename = "adminUserEnabled", default, skip_serializing_if = "Option::is_none")]
    pub admin_user_enabled: Option<bool>,
    #[doc = "The properties of a storage account for a container registry."]
    #[serde(rename = "storageAccount", default, skip_serializing_if = "Option::is_none")]
    pub storage_account: Option<StorageAccountProperties>,
}
impl RegistryPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters for updating a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryUpdateParameters {
    #[doc = "The resource tags for the container registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The parameters for updating the properties of a container registry."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RegistryPropertiesUpdateParameters>,
}
impl RegistryUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The location of the resource. This cannot be changed after the resource is created."]
    pub location: String,
    #[doc = "The tags of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[doc = "The properties of a storage account for a container registry."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageAccountProperties {
    #[doc = "The name of the storage account."]
    pub name: String,
    #[doc = "The access key to the storage account."]
    #[serde(rename = "accessKey")]
    pub access_key: String,
}
impl StorageAccountProperties {
    pub fn new(name: String, access_key: String) -> Self {
        Self { name, access_key }
    }
}
