#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BaseImageDependency {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<base_image_dependency::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registry: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub digest: Option<String>,
}
impl BaseImageDependency {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod base_image_dependency {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        BuildTime,
        RunTime,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Build {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BuildProperties>,
}
impl Build {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BuildArgument {
    #[serde(rename = "type")]
    pub type_: build_argument::Type,
    pub name: String,
    pub value: String,
    #[serde(rename = "isSecret", default, skip_serializing_if = "Option::is_none")]
    pub is_secret: Option<bool>,
}
impl BuildArgument {
    pub fn new(type_: build_argument::Type, name: String, value: String) -> Self {
        Self {
            type_,
            name,
            value,
            is_secret: None,
        }
    }
}
pub mod build_argument {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        DockerBuildArgument,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildArgumentList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BuildArgument>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BuildArgumentList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildFilter {
    #[serde(rename = "buildId", default, skip_serializing_if = "Option::is_none")]
    pub build_id: Option<String>,
    #[serde(rename = "buildType", default, skip_serializing_if = "Option::is_none")]
    pub build_type: Option<build_filter::BuildType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<build_filter::Status>,
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[serde(rename = "finishTime", default, skip_serializing_if = "Option::is_none")]
    pub finish_time: Option<String>,
    #[serde(rename = "outputImageManifests", default, skip_serializing_if = "Option::is_none")]
    pub output_image_manifests: Option<String>,
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
    #[serde(rename = "buildTaskName", default, skip_serializing_if = "Option::is_none")]
    pub build_task_name: Option<String>,
}
impl BuildFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod build_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BuildType {
        AutoBuild,
        QuickBuild,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Queued,
        Started,
        Running,
        Succeeded,
        Failed,
        Canceled,
        Error,
        Timeout,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildGetLogResult {
    #[serde(rename = "logLink", default, skip_serializing_if = "Option::is_none")]
    pub log_link: Option<String>,
}
impl BuildGetLogResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Build>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BuildListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildProperties {
    #[serde(rename = "buildId", default, skip_serializing_if = "Option::is_none")]
    pub build_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<build_properties::Status>,
    #[serde(rename = "lastUpdatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_time: Option<String>,
    #[serde(rename = "buildType", default, skip_serializing_if = "Option::is_none")]
    pub build_type: Option<build_properties::BuildType>,
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "finishTime", default, skip_serializing_if = "Option::is_none")]
    pub finish_time: Option<String>,
    #[serde(rename = "outputImages", default, skip_serializing_if = "Vec::is_empty")]
    pub output_images: Vec<ImageDescriptor>,
    #[serde(rename = "buildTask", default, skip_serializing_if = "Option::is_none")]
    pub build_task: Option<String>,
    #[serde(rename = "imageUpdateTrigger", default, skip_serializing_if = "Option::is_none")]
    pub image_update_trigger: Option<ImageUpdateTrigger>,
    #[serde(rename = "gitCommitTrigger", default, skip_serializing_if = "Option::is_none")]
    pub git_commit_trigger: Option<GitCommitTrigger>,
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub platform: Option<PlatformProperties>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<build_properties::ProvisioningState>,
}
impl BuildProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod build_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Queued,
        Started,
        Running,
        Succeeded,
        Failed,
        Canceled,
        Error,
        Timeout,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BuildType {
        AutoBuild,
        QuickBuild,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildStep {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BuildStepProperties>,
}
impl BuildStep {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildStepList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BuildStep>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BuildStepList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildStepProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<build_step_properties::ProvisioningState>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<build_step_properties::Type>,
}
impl BuildStepProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod build_step_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Docker,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildStepPropertiesUpdateParameters {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<build_step_properties_update_parameters::Type>,
}
impl BuildStepPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod build_step_properties_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Docker,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildStepUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BuildStepPropertiesUpdateParameters>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl BuildStepUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BuildTask {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BuildTaskProperties>,
}
impl BuildTask {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BuildTaskBuildRequest {
    #[serde(flatten)]
    pub queue_build_request: QueueBuildRequest,
    #[serde(rename = "buildTaskName")]
    pub build_task_name: String,
}
impl BuildTaskBuildRequest {
    pub fn new(build_task_name: String) -> Self {
        Self {
            queue_build_request: QueueBuildRequest::default(),
            build_task_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildTaskFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub alias: Option<String>,
}
impl BuildTaskFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildTaskListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BuildTask>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BuildTaskListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BuildTaskProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<build_task_properties::ProvisioningState>,
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    pub alias: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<build_task_properties::Status>,
    #[serde(rename = "sourceRepository")]
    pub source_repository: SourceRepositoryProperties,
    pub platform: PlatformProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
}
impl BuildTaskProperties {
    pub fn new(alias: String, source_repository: SourceRepositoryProperties, platform: PlatformProperties) -> Self {
        Self {
            provisioning_state: None,
            creation_date: None,
            alias,
            status: None,
            source_repository,
            platform,
            timeout: None,
        }
    }
}
pub mod build_task_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Deleting,
        Succeeded,
        Failed,
        Canceled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildTaskPropertiesUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub alias: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<build_task_properties_update_parameters::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub platform: Option<PlatformProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[serde(rename = "sourceRepository", default, skip_serializing_if = "Option::is_none")]
    pub source_repository: Option<SourceRepositoryUpdateParameters>,
}
impl BuildTaskPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod build_task_properties_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Disabled,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildTaskUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BuildTaskPropertiesUpdateParameters>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl BuildTaskUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BuildUpdateParameters {
    #[serde(rename = "isArchiveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_archive_enabled: Option<bool>,
}
impl BuildUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DockerBuildStep {
    #[serde(flatten)]
    pub build_step_properties: BuildStepProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[serde(rename = "imageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub image_names: Vec<String>,
    #[serde(rename = "isPushEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_push_enabled: Option<bool>,
    #[serde(rename = "noCache", default, skip_serializing_if = "Option::is_none")]
    pub no_cache: Option<bool>,
    #[serde(rename = "dockerFilePath", default, skip_serializing_if = "Option::is_none")]
    pub docker_file_path: Option<String>,
    #[serde(rename = "contextPath", default, skip_serializing_if = "Option::is_none")]
    pub context_path: Option<String>,
    #[serde(rename = "buildArguments", default, skip_serializing_if = "Vec::is_empty")]
    pub build_arguments: Vec<BuildArgument>,
    #[serde(rename = "baseImageDependencies", default, skip_serializing_if = "Vec::is_empty")]
    pub base_image_dependencies: Vec<BaseImageDependency>,
    #[serde(rename = "baseImageTrigger", default, skip_serializing_if = "Option::is_none")]
    pub base_image_trigger: Option<docker_build_step::BaseImageTrigger>,
}
impl DockerBuildStep {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod docker_build_step {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BaseImageTrigger {
        All,
        Runtime,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DockerBuildStepUpdateParameters {
    #[serde(flatten)]
    pub build_step_properties_update_parameters: BuildStepPropertiesUpdateParameters,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[serde(rename = "imageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub image_names: Vec<String>,
    #[serde(rename = "isPushEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_push_enabled: Option<bool>,
    #[serde(rename = "noCache", default, skip_serializing_if = "Option::is_none")]
    pub no_cache: Option<bool>,
    #[serde(rename = "dockerFilePath", default, skip_serializing_if = "Option::is_none")]
    pub docker_file_path: Option<String>,
    #[serde(rename = "contextPath", default, skip_serializing_if = "Option::is_none")]
    pub context_path: Option<String>,
    #[serde(rename = "buildArguments", default, skip_serializing_if = "Vec::is_empty")]
    pub build_arguments: Vec<BuildArgument>,
    #[serde(rename = "baseImageTrigger", default, skip_serializing_if = "Option::is_none")]
    pub base_image_trigger: Option<docker_build_step_update_parameters::BaseImageTrigger>,
}
impl DockerBuildStepUpdateParameters {
    pub fn new() -> Self {
        Self {
            build_step_properties_update_parameters: BuildStepPropertiesUpdateParameters::default(),
            branch: None,
            image_names: Vec::new(),
            is_push_enabled: None,
            no_cache: None,
            docker_file_path: None,
            context_path: None,
            build_arguments: Vec::new(),
            base_image_trigger: None,
        }
    }
}
pub mod docker_build_step_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BaseImageTrigger {
        All,
        Runtime,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GitCommitTrigger {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "commitId", default, skip_serializing_if = "Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(rename = "repositoryUrl", default, skip_serializing_if = "Option::is_none")]
    pub repository_url: Option<String>,
    #[serde(rename = "branchName", default, skip_serializing_if = "Option::is_none")]
    pub branch_name: Option<String>,
    #[serde(rename = "providerType", default, skip_serializing_if = "Option::is_none")]
    pub provider_type: Option<String>,
}
impl GitCommitTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageDescriptor {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registry: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub digest: Option<String>,
}
impl ImageDescriptor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageUpdateTrigger {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub images: Vec<ImageDescriptor>,
}
impl ImageUpdateTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PlatformProperties {
    #[serde(rename = "osType")]
    pub os_type: platform_properties::OsType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cpu: Option<i32>,
}
impl PlatformProperties {
    pub fn new(os_type: platform_properties::OsType) -> Self {
        Self { os_type, cpu: None }
    }
}
pub mod platform_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueueBuildRequest {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl QueueBuildRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuickBuildRequest {
    #[serde(flatten)]
    pub queue_build_request: QueueBuildRequest,
    #[serde(rename = "imageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub image_names: Vec<String>,
    #[serde(rename = "sourceLocation")]
    pub source_location: String,
    #[serde(rename = "buildArguments", default, skip_serializing_if = "Vec::is_empty")]
    pub build_arguments: Vec<BuildArgument>,
    #[serde(rename = "isPushEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_push_enabled: Option<bool>,
    #[serde(rename = "noCache", default, skip_serializing_if = "Option::is_none")]
    pub no_cache: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    pub platform: PlatformProperties,
    #[serde(rename = "dockerFilePath")]
    pub docker_file_path: String,
}
impl QuickBuildRequest {
    pub fn new(source_location: String, platform: PlatformProperties, docker_file_path: String) -> Self {
        Self {
            queue_build_request: QueueBuildRequest::default(),
            image_names: Vec::new(),
            source_location,
            build_arguments: Vec::new(),
            is_push_enabled: None,
            no_cache: None,
            timeout: None,
            platform,
            docker_file_path,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceControlAuthInfo {
    #[serde(rename = "tokenType", default, skip_serializing_if = "Option::is_none")]
    pub token_type: Option<source_control_auth_info::TokenType>,
    pub token: String,
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[serde(rename = "expiresIn", default, skip_serializing_if = "Option::is_none")]
    pub expires_in: Option<i32>,
}
impl SourceControlAuthInfo {
    pub fn new(token: String) -> Self {
        Self {
            token_type: None,
            token,
            refresh_token: None,
            scope: None,
            expires_in: None,
        }
    }
}
pub mod source_control_auth_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TokenType {
        #[serde(rename = "PAT")]
        Pat,
        OAuth,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceRepositoryProperties {
    #[serde(rename = "sourceControlType")]
    pub source_control_type: source_repository_properties::SourceControlType,
    #[serde(rename = "repositoryUrl")]
    pub repository_url: String,
    #[serde(rename = "isCommitTriggerEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_commit_trigger_enabled: Option<bool>,
    #[serde(rename = "sourceControlAuthProperties", default, skip_serializing_if = "Option::is_none")]
    pub source_control_auth_properties: Option<SourceControlAuthInfo>,
}
impl SourceRepositoryProperties {
    pub fn new(source_control_type: source_repository_properties::SourceControlType, repository_url: String) -> Self {
        Self {
            source_control_type,
            repository_url,
            is_commit_trigger_enabled: None,
            source_control_auth_properties: None,
        }
    }
}
pub mod source_repository_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceControlType {
        Github,
        VisualStudioTeamService,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceRepositoryUpdateParameters {
    #[serde(rename = "sourceControlAuthProperties", default, skip_serializing_if = "Option::is_none")]
    pub source_control_auth_properties: Option<SourceControlAuthInfo>,
    #[serde(rename = "isCommitTriggerEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_commit_trigger_enabled: Option<bool>,
}
impl SourceRepositoryUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceUploadDefinition {
    #[serde(rename = "uploadUrl", default, skip_serializing_if = "Option::is_none")]
    pub upload_url: Option<String>,
    #[serde(rename = "relativePath", default, skip_serializing_if = "Option::is_none")]
    pub relative_path: Option<String>,
}
impl SourceUploadDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
