#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmountWithExchangeRate {
    #[serde(flatten)]
    pub amount: Amount,
    #[serde(rename = "exchangeRate", default, skip_serializing_if = "Option::is_none")]
    pub exchange_rate: Option<f64>,
    #[serde(rename = "exchangeRateMonth", default, skip_serializing_if = "Option::is_none")]
    pub exchange_rate_month: Option<i32>,
}
impl AmountWithExchangeRate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Balance {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BalanceProperties>,
}
impl Balance {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BalanceProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(rename = "beginningBalance", default, skip_serializing_if = "Option::is_none")]
    pub beginning_balance: Option<f64>,
    #[serde(rename = "endingBalance", default, skip_serializing_if = "Option::is_none")]
    pub ending_balance: Option<f64>,
    #[serde(rename = "newPurchases", default, skip_serializing_if = "Option::is_none")]
    pub new_purchases: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub adjustments: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub utilized: Option<f64>,
    #[serde(rename = "serviceOverage", default, skip_serializing_if = "Option::is_none")]
    pub service_overage: Option<f64>,
    #[serde(rename = "chargesBilledSeparately", default, skip_serializing_if = "Option::is_none")]
    pub charges_billed_separately: Option<f64>,
    #[serde(rename = "totalOverage", default, skip_serializing_if = "Option::is_none")]
    pub total_overage: Option<f64>,
    #[serde(rename = "totalUsage", default, skip_serializing_if = "Option::is_none")]
    pub total_usage: Option<f64>,
    #[serde(rename = "azureMarketplaceServiceCharges", default, skip_serializing_if = "Option::is_none")]
    pub azure_marketplace_service_charges: Option<f64>,
    #[serde(rename = "billingFrequency", default, skip_serializing_if = "Option::is_none")]
    pub billing_frequency: Option<balance_properties::BillingFrequency>,
    #[serde(rename = "priceHidden", default, skip_serializing_if = "Option::is_none")]
    pub price_hidden: Option<bool>,
    #[serde(rename = "newPurchasesDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub new_purchases_details: Vec<serde_json::Value>,
    #[serde(rename = "adjustmentDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub adjustment_details: Vec<serde_json::Value>,
}
impl BalanceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod balance_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BillingFrequency {
        Month,
        Quarter,
        Year,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Budget {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BudgetProperties>,
}
impl Budget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BudgetComparisonExpression {
    pub name: String,
    pub operator: budget_comparison_expression::Operator,
    pub values: Vec<String>,
}
impl BudgetComparisonExpression {
    pub fn new(name: String, operator: budget_comparison_expression::Operator, values: Vec<String>) -> Self {
        Self { name, operator, values }
    }
}
pub mod budget_comparison_expression {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        In,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BudgetFilter {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub and: Vec<BudgetFilterProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub not: Option<BudgetFilterProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dimensions: Option<BudgetComparisonExpression>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<BudgetComparisonExpression>,
}
impl BudgetFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BudgetFilterProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dimensions: Option<BudgetComparisonExpression>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<BudgetComparisonExpression>,
}
impl BudgetFilterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BudgetProperties {
    pub category: budget_properties::Category,
    pub amount: f64,
    #[serde(rename = "timeGrain")]
    pub time_grain: budget_properties::TimeGrain,
    #[serde(rename = "timePeriod")]
    pub time_period: BudgetTimePeriod,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<BudgetFilter>,
    #[serde(rename = "currentSpend", default, skip_serializing_if = "Option::is_none")]
    pub current_spend: Option<CurrentSpend>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notifications: Option<serde_json::Value>,
    #[serde(rename = "forecastSpend", default, skip_serializing_if = "Option::is_none")]
    pub forecast_spend: Option<ForecastSpend>,
}
impl BudgetProperties {
    pub fn new(
        category: budget_properties::Category,
        amount: f64,
        time_grain: budget_properties::TimeGrain,
        time_period: BudgetTimePeriod,
    ) -> Self {
        Self {
            category,
            amount,
            time_grain,
            time_period,
            filter: None,
            current_spend: None,
            notifications: None,
            forecast_spend: None,
        }
    }
}
pub mod budget_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Category {
        Cost,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TimeGrain {
        Monthly,
        Quarterly,
        Annually,
        BillingMonth,
        BillingQuarter,
        BillingAnnual,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BudgetTimePeriod {
    #[serde(rename = "startDate")]
    pub start_date: String,
    #[serde(rename = "endDate", default, skip_serializing_if = "Option::is_none")]
    pub end_date: Option<String>,
}
impl BudgetTimePeriod {
    pub fn new(start_date: String) -> Self {
        Self {
            start_date,
            end_date: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BudgetsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Budget>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BudgetsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ChargeSummary {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub kind: charge_summary::Kind,
}
impl ChargeSummary {
    pub fn new(kind: charge_summary::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
        }
    }
}
pub mod charge_summary {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "legacy")]
        Legacy,
        #[serde(rename = "modern")]
        Modern,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ChargesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ChargeSummary>,
}
impl ChargesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreditBalanceSummary {
    #[serde(rename = "estimatedBalance", default, skip_serializing_if = "Option::is_none")]
    pub estimated_balance: Option<Amount>,
    #[serde(rename = "currentBalance", default, skip_serializing_if = "Option::is_none")]
    pub current_balance: Option<Amount>,
    #[serde(rename = "estimatedBalanceInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub estimated_balance_in_billing_currency: Option<AmountWithExchangeRate>,
}
impl CreditBalanceSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreditSummary {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreditSummaryProperties>,
}
impl CreditSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreditSummaryProperties {
    #[serde(rename = "balanceSummary", default, skip_serializing_if = "Option::is_none")]
    pub balance_summary: Option<CreditBalanceSummary>,
    #[serde(rename = "pendingCreditAdjustments", default, skip_serializing_if = "Option::is_none")]
    pub pending_credit_adjustments: Option<Amount>,
    #[serde(rename = "expiredCredit", default, skip_serializing_if = "Option::is_none")]
    pub expired_credit: Option<Amount>,
    #[serde(rename = "pendingEligibleCharges", default, skip_serializing_if = "Option::is_none")]
    pub pending_eligible_charges: Option<Amount>,
    #[serde(rename = "creditCurrency", default, skip_serializing_if = "Option::is_none")]
    pub credit_currency: Option<String>,
    #[serde(rename = "billingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub billing_currency: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reseller: Option<Reseller>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
}
impl CreditSummaryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CurrentSpend {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub amount: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
}
impl CurrentSpend {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DownloadProperties {
    #[serde(rename = "downloadUrl", default, skip_serializing_if = "Option::is_none")]
    pub download_url: Option<String>,
    #[serde(rename = "validTill", default, skip_serializing_if = "Option::is_none")]
    pub valid_till: Option<String>,
}
impl DownloadProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetails>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventProperties {
    #[serde(rename = "transactionDate", default, skip_serializing_if = "Option::is_none")]
    pub transaction_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "newCredit", default, skip_serializing_if = "Option::is_none")]
    pub new_credit: Option<Amount>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub adjustments: Option<Amount>,
    #[serde(rename = "creditExpired", default, skip_serializing_if = "Option::is_none")]
    pub credit_expired: Option<Amount>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub charges: Option<Amount>,
    #[serde(rename = "closedBalance", default, skip_serializing_if = "Option::is_none")]
    pub closed_balance: Option<Amount>,
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<event_properties::EventType>,
    #[serde(rename = "invoiceNumber", default, skip_serializing_if = "Option::is_none")]
    pub invoice_number: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingProfileDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_display_name: Option<String>,
    #[serde(rename = "lotId", default, skip_serializing_if = "Option::is_none")]
    pub lot_id: Option<String>,
    #[serde(rename = "lotSource", default, skip_serializing_if = "Option::is_none")]
    pub lot_source: Option<String>,
    #[serde(rename = "canceledCredit", default, skip_serializing_if = "Option::is_none")]
    pub canceled_credit: Option<Amount>,
    #[serde(rename = "creditCurrency", default, skip_serializing_if = "Option::is_none")]
    pub credit_currency: Option<String>,
    #[serde(rename = "billingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub billing_currency: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reseller: Option<Reseller>,
    #[serde(rename = "creditExpiredInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub credit_expired_in_billing_currency: Option<AmountWithExchangeRate>,
    #[serde(rename = "newCreditInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub new_credit_in_billing_currency: Option<AmountWithExchangeRate>,
    #[serde(rename = "adjustmentsInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub adjustments_in_billing_currency: Option<AmountWithExchangeRate>,
    #[serde(rename = "chargesInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub charges_in_billing_currency: Option<AmountWithExchangeRate>,
    #[serde(rename = "closedBalanceInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub closed_balance_in_billing_currency: Option<AmountWithExchangeRate>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
}
impl EventProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod event_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EventType {
        SettledCharges,
        PendingCharges,
        PendingAdjustments,
        PendingNewCredit,
        PendingExpiredCredit,
        UnKnown,
        NewCredit,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSummary {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EventProperties>,
}
impl EventSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Events {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EventSummary>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl Events {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ForecastSpend {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub amount: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
}
impl ForecastSpend {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HighCasedErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl HighCasedErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HighCasedErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<HighCasedErrorDetails>,
}
impl HighCasedErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LegacyChargeSummary {
    #[serde(flatten)]
    pub charge_summary: ChargeSummary,
    pub properties: LegacyChargeSummaryProperties,
}
impl LegacyChargeSummary {
    pub fn new(charge_summary: ChargeSummary, properties: LegacyChargeSummaryProperties) -> Self {
        Self {
            charge_summary,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LegacyChargeSummaryProperties {
    #[serde(rename = "billingPeriodId", default, skip_serializing_if = "Option::is_none")]
    pub billing_period_id: Option<String>,
    #[serde(rename = "usageStart", default, skip_serializing_if = "Option::is_none")]
    pub usage_start: Option<String>,
    #[serde(rename = "usageEnd", default, skip_serializing_if = "Option::is_none")]
    pub usage_end: Option<String>,
    #[serde(rename = "azureCharges", default, skip_serializing_if = "Option::is_none")]
    pub azure_charges: Option<f64>,
    #[serde(rename = "chargesBilledSeparately", default, skip_serializing_if = "Option::is_none")]
    pub charges_billed_separately: Option<f64>,
    #[serde(rename = "marketplaceCharges", default, skip_serializing_if = "Option::is_none")]
    pub marketplace_charges: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
}
impl LegacyChargeSummaryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LegacyReservationRecommendation {
    #[serde(flatten)]
    pub reservation_recommendation: ReservationRecommendation,
    pub properties: LegacyReservationRecommendationProperties,
}
impl LegacyReservationRecommendation {
    pub fn new(reservation_recommendation: ReservationRecommendation, properties: LegacyReservationRecommendationProperties) -> Self {
        Self {
            reservation_recommendation,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LegacyReservationRecommendationProperties {
    #[serde(rename = "lookBackPeriod", default, skip_serializing_if = "Option::is_none")]
    pub look_back_period: Option<String>,
    #[serde(rename = "instanceFlexibilityRatio", default, skip_serializing_if = "Option::is_none")]
    pub instance_flexibility_ratio: Option<f64>,
    #[serde(rename = "instanceFlexibilityGroup", default, skip_serializing_if = "Option::is_none")]
    pub instance_flexibility_group: Option<String>,
    #[serde(rename = "normalizedSize", default, skip_serializing_if = "Option::is_none")]
    pub normalized_size: Option<String>,
    #[serde(rename = "recommendedQuantityNormalized", default, skip_serializing_if = "Option::is_none")]
    pub recommended_quantity_normalized: Option<f64>,
    #[serde(rename = "meterId", default, skip_serializing_if = "Option::is_none")]
    pub meter_id: Option<String>,
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub term: Option<String>,
    #[serde(rename = "costWithNoReservedInstances", default, skip_serializing_if = "Option::is_none")]
    pub cost_with_no_reserved_instances: Option<f64>,
    #[serde(rename = "recommendedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub recommended_quantity: Option<f64>,
    #[serde(rename = "totalCostWithReservedInstances", default, skip_serializing_if = "Option::is_none")]
    pub total_cost_with_reserved_instances: Option<f64>,
    #[serde(rename = "netSavings", default, skip_serializing_if = "Option::is_none")]
    pub net_savings: Option<f64>,
    #[serde(rename = "firstUsageDate", default, skip_serializing_if = "Option::is_none")]
    pub first_usage_date: Option<String>,
    pub scope: String,
    #[serde(rename = "skuProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub sku_properties: Vec<SkuProperty>,
}
impl LegacyReservationRecommendationProperties {
    pub fn new(scope: String) -> Self {
        Self {
            look_back_period: None,
            instance_flexibility_ratio: None,
            instance_flexibility_group: None,
            normalized_size: None,
            recommended_quantity_normalized: None,
            meter_id: None,
            resource_type: None,
            term: None,
            cost_with_no_reserved_instances: None,
            recommended_quantity: None,
            total_cost_with_reserved_instances: None,
            net_savings: None,
            first_usage_date: None,
            scope,
            sku_properties: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LegacyReservationTransaction {
    #[serde(flatten)]
    pub reservation_transaction: ReservationTransaction,
    pub properties: LegacyReservationTransactionProperties,
}
impl LegacyReservationTransaction {
    pub fn new(properties: LegacyReservationTransactionProperties) -> Self {
        Self {
            reservation_transaction: ReservationTransaction::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LegacyReservationTransactionProperties {
    #[serde(rename = "eventDate", default, skip_serializing_if = "Option::is_none")]
    pub event_date: Option<String>,
    #[serde(rename = "reservationOrderId", default, skip_serializing_if = "Option::is_none")]
    pub reservation_order_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub amount: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(rename = "reservationOrderName", default, skip_serializing_if = "Option::is_none")]
    pub reservation_order_name: Option<String>,
    #[serde(rename = "purchasingEnrollment", default, skip_serializing_if = "Option::is_none")]
    pub purchasing_enrollment: Option<String>,
    #[serde(rename = "purchasingSubscriptionGuid", default, skip_serializing_if = "Option::is_none")]
    pub purchasing_subscription_guid: Option<String>,
    #[serde(rename = "purchasingSubscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub purchasing_subscription_name: Option<String>,
    #[serde(rename = "armSkuName", default, skip_serializing_if = "Option::is_none")]
    pub arm_sku_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub term: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[serde(rename = "accountOwnerEmail", default, skip_serializing_if = "Option::is_none")]
    pub account_owner_email: Option<String>,
    #[serde(rename = "departmentName", default, skip_serializing_if = "Option::is_none")]
    pub department_name: Option<String>,
    #[serde(rename = "costCenter", default, skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    #[serde(rename = "currentEnrollment", default, skip_serializing_if = "Option::is_none")]
    pub current_enrollment: Option<String>,
    #[serde(rename = "billingFrequency", default, skip_serializing_if = "Option::is_none")]
    pub billing_frequency: Option<String>,
    #[serde(rename = "billingMonth", default, skip_serializing_if = "Option::is_none")]
    pub billing_month: Option<i32>,
    #[serde(rename = "monetaryCommitment", default, skip_serializing_if = "Option::is_none")]
    pub monetary_commitment: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub overage: Option<f64>,
}
impl LegacyReservationTransactionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LegacySharedScopeReservationRecommendationProperties {
    #[serde(flatten)]
    pub legacy_reservation_recommendation_properties: LegacyReservationRecommendationProperties,
}
impl LegacySharedScopeReservationRecommendationProperties {
    pub fn new(legacy_reservation_recommendation_properties: LegacyReservationRecommendationProperties) -> Self {
        Self {
            legacy_reservation_recommendation_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LegacySingleScopeReservationRecommendationProperties {
    #[serde(flatten)]
    pub legacy_reservation_recommendation_properties: LegacyReservationRecommendationProperties,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
}
impl LegacySingleScopeReservationRecommendationProperties {
    pub fn new(legacy_reservation_recommendation_properties: LegacyReservationRecommendationProperties) -> Self {
        Self {
            legacy_reservation_recommendation_properties,
            subscription_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LegacyUsageDetail {
    #[serde(flatten)]
    pub usage_detail: UsageDetail,
    pub properties: LegacyUsageDetailProperties,
}
impl LegacyUsageDetail {
    pub fn new(usage_detail: UsageDetail, properties: LegacyUsageDetailProperties) -> Self {
        Self { usage_detail, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LegacyUsageDetailProperties {
    #[serde(rename = "billingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub billing_account_id: Option<String>,
    #[serde(rename = "billingAccountName", default, skip_serializing_if = "Option::is_none")]
    pub billing_account_name: Option<String>,
    #[serde(rename = "billingPeriodStartDate", default, skip_serializing_if = "Option::is_none")]
    pub billing_period_start_date: Option<String>,
    #[serde(rename = "billingPeriodEndDate", default, skip_serializing_if = "Option::is_none")]
    pub billing_period_end_date: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingProfileName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_name: Option<String>,
    #[serde(rename = "accountOwnerId", default, skip_serializing_if = "Option::is_none")]
    pub account_owner_id: Option<String>,
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "subscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub subscription_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub product: Option<String>,
    #[serde(rename = "partNumber", default, skip_serializing_if = "Option::is_none")]
    pub part_number: Option<String>,
    #[serde(rename = "meterId", default, skip_serializing_if = "Option::is_none")]
    pub meter_id: Option<String>,
    #[serde(rename = "meterDetails", default, skip_serializing_if = "Option::is_none")]
    pub meter_details: Option<MeterDetailsResponse>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<f64>,
    #[serde(rename = "effectivePrice", default, skip_serializing_if = "Option::is_none")]
    pub effective_price: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cost: Option<f64>,
    #[serde(rename = "unitPrice", default, skip_serializing_if = "Option::is_none")]
    pub unit_price: Option<f64>,
    #[serde(rename = "billingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub billing_currency: Option<String>,
    #[serde(rename = "resourceLocation", default, skip_serializing_if = "Option::is_none")]
    pub resource_location: Option<String>,
    #[serde(rename = "consumedService", default, skip_serializing_if = "Option::is_none")]
    pub consumed_service: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
    pub resource_name: Option<String>,
    #[serde(rename = "serviceInfo1", default, skip_serializing_if = "Option::is_none")]
    pub service_info1: Option<String>,
    #[serde(rename = "serviceInfo2", default, skip_serializing_if = "Option::is_none")]
    pub service_info2: Option<String>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub additional_info: Option<String>,
    #[serde(rename = "invoiceSection", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section: Option<String>,
    #[serde(rename = "costCenter", default, skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "reservationId", default, skip_serializing_if = "Option::is_none")]
    pub reservation_id: Option<String>,
    #[serde(rename = "reservationName", default, skip_serializing_if = "Option::is_none")]
    pub reservation_name: Option<String>,
    #[serde(rename = "productOrderId", default, skip_serializing_if = "Option::is_none")]
    pub product_order_id: Option<String>,
    #[serde(rename = "productOrderName", default, skip_serializing_if = "Option::is_none")]
    pub product_order_name: Option<String>,
    #[serde(rename = "offerId", default, skip_serializing_if = "Option::is_none")]
    pub offer_id: Option<String>,
    #[serde(rename = "isAzureCreditEligible", default, skip_serializing_if = "Option::is_none")]
    pub is_azure_credit_eligible: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub term: Option<String>,
    #[serde(rename = "publisherName", default, skip_serializing_if = "Option::is_none")]
    pub publisher_name: Option<String>,
    #[serde(rename = "publisherType", default, skip_serializing_if = "Option::is_none")]
    pub publisher_type: Option<String>,
    #[serde(rename = "planName", default, skip_serializing_if = "Option::is_none")]
    pub plan_name: Option<String>,
    #[serde(rename = "chargeType", default, skip_serializing_if = "Option::is_none")]
    pub charge_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<String>,
    #[serde(rename = "payGPrice", default, skip_serializing_if = "Option::is_none")]
    pub pay_g_price: Option<f64>,
    #[serde(rename = "benefitId", default, skip_serializing_if = "Option::is_none")]
    pub benefit_id: Option<String>,
    #[serde(rename = "benefitName", default, skip_serializing_if = "Option::is_none")]
    pub benefit_name: Option<String>,
    #[serde(rename = "pricingModel", default, skip_serializing_if = "Option::is_none")]
    pub pricing_model: Option<legacy_usage_detail_properties::PricingModel>,
}
impl LegacyUsageDetailProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod legacy_usage_detail_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PricingModel {
        #[serde(rename = "On Demand")]
        OnDemand,
        Reservation,
        Spot,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LotProperties {
    #[serde(rename = "originalAmount", default, skip_serializing_if = "Option::is_none")]
    pub original_amount: Option<Amount>,
    #[serde(rename = "closedBalance", default, skip_serializing_if = "Option::is_none")]
    pub closed_balance: Option<Amount>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<lot_properties::Source>,
    #[serde(rename = "startDate", default, skip_serializing_if = "Option::is_none")]
    pub start_date: Option<String>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(rename = "poNumber", default, skip_serializing_if = "Option::is_none")]
    pub po_number: Option<String>,
    #[serde(rename = "purchasedDate", default, skip_serializing_if = "Option::is_none")]
    pub purchased_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<lot_properties::Status>,
    #[serde(rename = "creditCurrency", default, skip_serializing_if = "Option::is_none")]
    pub credit_currency: Option<String>,
    #[serde(rename = "billingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub billing_currency: Option<String>,
    #[serde(rename = "originalAmountInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub original_amount_in_billing_currency: Option<AmountWithExchangeRate>,
    #[serde(rename = "closedBalanceInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub closed_balance_in_billing_currency: Option<AmountWithExchangeRate>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reseller: Option<Reseller>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
}
impl LotProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod lot_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        PurchasedCredit,
        PromotionalCredit,
        ConsumptionCommitment,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        None,
        Active,
        Inactive,
        Expired,
        Complete,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LotSummary {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LotProperties>,
}
impl LotSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Lots {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LotSummary>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl Lots {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupAggregatedCostProperties {
    #[serde(rename = "billingPeriodId", default, skip_serializing_if = "Option::is_none")]
    pub billing_period_id: Option<String>,
    #[serde(rename = "usageStart", default, skip_serializing_if = "Option::is_none")]
    pub usage_start: Option<String>,
    #[serde(rename = "usageEnd", default, skip_serializing_if = "Option::is_none")]
    pub usage_end: Option<String>,
    #[serde(rename = "azureCharges", default, skip_serializing_if = "Option::is_none")]
    pub azure_charges: Option<f64>,
    #[serde(rename = "marketplaceCharges", default, skip_serializing_if = "Option::is_none")]
    pub marketplace_charges: Option<f64>,
    #[serde(rename = "chargesBilledSeparately", default, skip_serializing_if = "Option::is_none")]
    pub charges_billed_separately: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub children: Vec<ManagementGroupAggregatedCostResult>,
    #[serde(rename = "includedSubscriptions", default, skip_serializing_if = "Vec::is_empty")]
    pub included_subscriptions: Vec<String>,
    #[serde(rename = "excludedSubscriptions", default, skip_serializing_if = "Vec::is_empty")]
    pub excluded_subscriptions: Vec<String>,
}
impl ManagementGroupAggregatedCostProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementGroupAggregatedCostResult {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagementGroupAggregatedCostProperties>,
}
impl ManagementGroupAggregatedCostResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Marketplace {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MarketplaceProperties>,
}
impl Marketplace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MarketplaceProperties {
    #[serde(rename = "billingPeriodId", default, skip_serializing_if = "Option::is_none")]
    pub billing_period_id: Option<String>,
    #[serde(rename = "usageStart", default, skip_serializing_if = "Option::is_none")]
    pub usage_start: Option<String>,
    #[serde(rename = "usageEnd", default, skip_serializing_if = "Option::is_none")]
    pub usage_end: Option<String>,
    #[serde(rename = "resourceRate", default, skip_serializing_if = "Option::is_none")]
    pub resource_rate: Option<f64>,
    #[serde(rename = "offerName", default, skip_serializing_if = "Option::is_none")]
    pub offer_name: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub additional_info: Option<String>,
    #[serde(rename = "orderNumber", default, skip_serializing_if = "Option::is_none")]
    pub order_number: Option<String>,
    #[serde(rename = "instanceName", default, skip_serializing_if = "Option::is_none")]
    pub instance_name: Option<String>,
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(rename = "consumedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub consumed_quantity: Option<f64>,
    #[serde(rename = "unitOfMeasure", default, skip_serializing_if = "Option::is_none")]
    pub unit_of_measure: Option<String>,
    #[serde(rename = "pretaxCost", default, skip_serializing_if = "Option::is_none")]
    pub pretax_cost: Option<f64>,
    #[serde(rename = "isEstimated", default, skip_serializing_if = "Option::is_none")]
    pub is_estimated: Option<bool>,
    #[serde(rename = "meterId", default, skip_serializing_if = "Option::is_none")]
    pub meter_id: Option<String>,
    #[serde(rename = "subscriptionGuid", default, skip_serializing_if = "Option::is_none")]
    pub subscription_guid: Option<String>,
    #[serde(rename = "subscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub subscription_name: Option<String>,
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[serde(rename = "departmentName", default, skip_serializing_if = "Option::is_none")]
    pub department_name: Option<String>,
    #[serde(rename = "consumedService", default, skip_serializing_if = "Option::is_none")]
    pub consumed_service: Option<String>,
    #[serde(rename = "costCenter", default, skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    #[serde(rename = "additionalProperties", default, skip_serializing_if = "Option::is_none")]
    pub additional_properties: Option<String>,
    #[serde(rename = "publisherName", default, skip_serializing_if = "Option::is_none")]
    pub publisher_name: Option<String>,
    #[serde(rename = "planName", default, skip_serializing_if = "Option::is_none")]
    pub plan_name: Option<String>,
    #[serde(rename = "isRecurringCharge", default, skip_serializing_if = "Option::is_none")]
    pub is_recurring_charge: Option<bool>,
}
impl MarketplaceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MarketplacesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Marketplace>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MarketplacesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MeterDetails {
    #[serde(rename = "meterName", default, skip_serializing_if = "Option::is_none")]
    pub meter_name: Option<String>,
    #[serde(rename = "meterCategory", default, skip_serializing_if = "Option::is_none")]
    pub meter_category: Option<String>,
    #[serde(rename = "meterSubCategory", default, skip_serializing_if = "Option::is_none")]
    pub meter_sub_category: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "meterLocation", default, skip_serializing_if = "Option::is_none")]
    pub meter_location: Option<String>,
    #[serde(rename = "totalIncludedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub total_included_quantity: Option<f64>,
    #[serde(rename = "pretaxStandardRate", default, skip_serializing_if = "Option::is_none")]
    pub pretax_standard_rate: Option<f64>,
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[serde(rename = "serviceTier", default, skip_serializing_if = "Option::is_none")]
    pub service_tier: Option<String>,
}
impl MeterDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MeterDetailsResponse {
    #[serde(rename = "meterName", default, skip_serializing_if = "Option::is_none")]
    pub meter_name: Option<String>,
    #[serde(rename = "meterCategory", default, skip_serializing_if = "Option::is_none")]
    pub meter_category: Option<String>,
    #[serde(rename = "meterSubCategory", default, skip_serializing_if = "Option::is_none")]
    pub meter_sub_category: Option<String>,
    #[serde(rename = "unitOfMeasure", default, skip_serializing_if = "Option::is_none")]
    pub unit_of_measure: Option<String>,
    #[serde(rename = "serviceFamily", default, skip_serializing_if = "Option::is_none")]
    pub service_family: Option<String>,
}
impl MeterDetailsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ModernChargeSummary {
    #[serde(flatten)]
    pub charge_summary: ChargeSummary,
    pub properties: ModernChargeSummaryProperties,
}
impl ModernChargeSummary {
    pub fn new(charge_summary: ChargeSummary, properties: ModernChargeSummaryProperties) -> Self {
        Self {
            charge_summary,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModernChargeSummaryProperties {
    #[serde(rename = "billingPeriodId", default, skip_serializing_if = "Option::is_none")]
    pub billing_period_id: Option<String>,
    #[serde(rename = "usageStart", default, skip_serializing_if = "Option::is_none")]
    pub usage_start: Option<String>,
    #[serde(rename = "usageEnd", default, skip_serializing_if = "Option::is_none")]
    pub usage_end: Option<String>,
    #[serde(rename = "azureCharges", default, skip_serializing_if = "Option::is_none")]
    pub azure_charges: Option<Amount>,
    #[serde(rename = "chargesBilledSeparately", default, skip_serializing_if = "Option::is_none")]
    pub charges_billed_separately: Option<Amount>,
    #[serde(rename = "marketplaceCharges", default, skip_serializing_if = "Option::is_none")]
    pub marketplace_charges: Option<Amount>,
    #[serde(rename = "billingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub billing_account_id: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "invoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_id: Option<String>,
    #[serde(rename = "customerId", default, skip_serializing_if = "Option::is_none")]
    pub customer_id: Option<String>,
    #[serde(rename = "isInvoiced", default, skip_serializing_if = "Option::is_none")]
    pub is_invoiced: Option<bool>,
}
impl ModernChargeSummaryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ModernReservationRecommendation {
    #[serde(flatten)]
    pub reservation_recommendation: ReservationRecommendation,
    pub properties: ModernReservationRecommendationProperties,
}
impl ModernReservationRecommendation {
    pub fn new(reservation_recommendation: ReservationRecommendation, properties: ModernReservationRecommendationProperties) -> Self {
        Self {
            reservation_recommendation,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModernReservationRecommendationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "lookBackPeriod", default, skip_serializing_if = "Option::is_none")]
    pub look_back_period: Option<i32>,
    #[serde(rename = "instanceFlexibilityRatio", default, skip_serializing_if = "Option::is_none")]
    pub instance_flexibility_ratio: Option<f64>,
    #[serde(rename = "instanceFlexibilityGroup", default, skip_serializing_if = "Option::is_none")]
    pub instance_flexibility_group: Option<String>,
    #[serde(rename = "normalizedSize", default, skip_serializing_if = "Option::is_none")]
    pub normalized_size: Option<String>,
    #[serde(rename = "recommendedQuantityNormalized", default, skip_serializing_if = "Option::is_none")]
    pub recommended_quantity_normalized: Option<f64>,
    #[serde(rename = "meterId", default, skip_serializing_if = "Option::is_none")]
    pub meter_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub term: Option<String>,
    #[serde(rename = "costWithNoReservedInstances", default, skip_serializing_if = "Option::is_none")]
    pub cost_with_no_reserved_instances: Option<Amount>,
    #[serde(rename = "recommendedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub recommended_quantity: Option<f64>,
    #[serde(rename = "totalCostWithReservedInstances", default, skip_serializing_if = "Option::is_none")]
    pub total_cost_with_reserved_instances: Option<Amount>,
    #[serde(rename = "netSavings", default, skip_serializing_if = "Option::is_none")]
    pub net_savings: Option<Amount>,
    #[serde(rename = "firstUsageDate", default, skip_serializing_if = "Option::is_none")]
    pub first_usage_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[serde(rename = "skuProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub sku_properties: Vec<SkuProperty>,
    #[serde(rename = "skuName", default, skip_serializing_if = "Option::is_none")]
    pub sku_name: Option<String>,
}
impl ModernReservationRecommendationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ModernReservationTransaction {
    #[serde(flatten)]
    pub reservation_transaction_resource: ReservationTransactionResource,
    pub properties: ModernReservationTransactionProperties,
}
impl ModernReservationTransaction {
    pub fn new(properties: ModernReservationTransactionProperties) -> Self {
        Self {
            reservation_transaction_resource: ReservationTransactionResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModernReservationTransactionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub amount: Option<f64>,
    #[serde(rename = "armSkuName", default, skip_serializing_if = "Option::is_none")]
    pub arm_sku_name: Option<String>,
    #[serde(rename = "billingFrequency", default, skip_serializing_if = "Option::is_none")]
    pub billing_frequency: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingProfileName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "eventDate", default, skip_serializing_if = "Option::is_none")]
    pub event_date: Option<String>,
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub invoice: Option<String>,
    #[serde(rename = "invoiceId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_id: Option<String>,
    #[serde(rename = "invoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_id: Option<String>,
    #[serde(rename = "invoiceSectionName", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_name: Option<String>,
    #[serde(rename = "purchasingSubscriptionGuid", default, skip_serializing_if = "Option::is_none")]
    pub purchasing_subscription_guid: Option<String>,
    #[serde(rename = "purchasingSubscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub purchasing_subscription_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "reservationOrderId", default, skip_serializing_if = "Option::is_none")]
    pub reservation_order_id: Option<String>,
    #[serde(rename = "reservationOrderName", default, skip_serializing_if = "Option::is_none")]
    pub reservation_order_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub term: Option<String>,
}
impl ModernReservationTransactionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModernReservationTransactionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ModernReservationTransaction>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ModernReservationTransactionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ModernUsageDetail {
    #[serde(flatten)]
    pub usage_detail: UsageDetail,
    pub properties: ModernUsageDetailProperties,
}
impl ModernUsageDetail {
    pub fn new(usage_detail: UsageDetail, properties: ModernUsageDetailProperties) -> Self {
        Self { usage_detail, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModernUsageDetailProperties {
    #[serde(rename = "billingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub billing_account_id: Option<String>,
    #[serde(rename = "effectivePrice", default, skip_serializing_if = "Option::is_none")]
    pub effective_price: Option<f64>,
    #[serde(rename = "pricingModel", default, skip_serializing_if = "Option::is_none")]
    pub pricing_model: Option<modern_usage_detail_properties::PricingModel>,
    #[serde(rename = "billingAccountName", default, skip_serializing_if = "Option::is_none")]
    pub billing_account_name: Option<String>,
    #[serde(rename = "billingPeriodStartDate", default, skip_serializing_if = "Option::is_none")]
    pub billing_period_start_date: Option<String>,
    #[serde(rename = "billingPeriodEndDate", default, skip_serializing_if = "Option::is_none")]
    pub billing_period_end_date: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingProfileName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_name: Option<String>,
    #[serde(rename = "subscriptionGuid", default, skip_serializing_if = "Option::is_none")]
    pub subscription_guid: Option<String>,
    #[serde(rename = "subscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub subscription_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub product: Option<String>,
    #[serde(rename = "meterId", default, skip_serializing_if = "Option::is_none")]
    pub meter_id: Option<String>,
    #[serde(rename = "meterName", default, skip_serializing_if = "Option::is_none")]
    pub meter_name: Option<String>,
    #[serde(rename = "meterRegion", default, skip_serializing_if = "Option::is_none")]
    pub meter_region: Option<String>,
    #[serde(rename = "meterCategory", default, skip_serializing_if = "Option::is_none")]
    pub meter_category: Option<String>,
    #[serde(rename = "meterSubCategory", default, skip_serializing_if = "Option::is_none")]
    pub meter_sub_category: Option<String>,
    #[serde(rename = "serviceFamily", default, skip_serializing_if = "Option::is_none")]
    pub service_family: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<f64>,
    #[serde(rename = "unitOfMeasure", default, skip_serializing_if = "Option::is_none")]
    pub unit_of_measure: Option<String>,
    #[serde(rename = "instanceName", default, skip_serializing_if = "Option::is_none")]
    pub instance_name: Option<String>,
    #[serde(rename = "costInUSD", default, skip_serializing_if = "Option::is_none")]
    pub cost_in_usd: Option<f64>,
    #[serde(rename = "unitPrice", default, skip_serializing_if = "Option::is_none")]
    pub unit_price: Option<f64>,
    #[serde(rename = "billingCurrencyCode", default, skip_serializing_if = "Option::is_none")]
    pub billing_currency_code: Option<String>,
    #[serde(rename = "resourceLocation", default, skip_serializing_if = "Option::is_none")]
    pub resource_location: Option<String>,
    #[serde(rename = "consumedService", default, skip_serializing_if = "Option::is_none")]
    pub consumed_service: Option<String>,
    #[serde(rename = "serviceInfo1", default, skip_serializing_if = "Option::is_none")]
    pub service_info1: Option<String>,
    #[serde(rename = "serviceInfo2", default, skip_serializing_if = "Option::is_none")]
    pub service_info2: Option<String>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub additional_info: Option<String>,
    #[serde(rename = "invoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_id: Option<String>,
    #[serde(rename = "invoiceSectionName", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_name: Option<String>,
    #[serde(rename = "costCenter", default, skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "reservationId", default, skip_serializing_if = "Option::is_none")]
    pub reservation_id: Option<String>,
    #[serde(rename = "reservationName", default, skip_serializing_if = "Option::is_none")]
    pub reservation_name: Option<String>,
    #[serde(rename = "productOrderId", default, skip_serializing_if = "Option::is_none")]
    pub product_order_id: Option<String>,
    #[serde(rename = "productOrderName", default, skip_serializing_if = "Option::is_none")]
    pub product_order_name: Option<String>,
    #[serde(rename = "isAzureCreditEligible", default, skip_serializing_if = "Option::is_none")]
    pub is_azure_credit_eligible: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub term: Option<String>,
    #[serde(rename = "publisherName", default, skip_serializing_if = "Option::is_none")]
    pub publisher_name: Option<String>,
    #[serde(rename = "publisherType", default, skip_serializing_if = "Option::is_none")]
    pub publisher_type: Option<String>,
    #[serde(rename = "chargeType", default, skip_serializing_if = "Option::is_none")]
    pub charge_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<String>,
    #[serde(rename = "costInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub cost_in_billing_currency: Option<f64>,
    #[serde(rename = "costInPricingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub cost_in_pricing_currency: Option<f64>,
    #[serde(rename = "exchangeRate", default, skip_serializing_if = "Option::is_none")]
    pub exchange_rate: Option<String>,
    #[serde(rename = "exchangeRateDate", default, skip_serializing_if = "Option::is_none")]
    pub exchange_rate_date: Option<String>,
    #[serde(rename = "invoiceId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_id: Option<String>,
    #[serde(rename = "previousInvoiceId", default, skip_serializing_if = "Option::is_none")]
    pub previous_invoice_id: Option<String>,
    #[serde(rename = "pricingCurrencyCode", default, skip_serializing_if = "Option::is_none")]
    pub pricing_currency_code: Option<String>,
    #[serde(rename = "productIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub product_identifier: Option<String>,
    #[serde(rename = "resourceLocationNormalized", default, skip_serializing_if = "Option::is_none")]
    pub resource_location_normalized: Option<String>,
    #[serde(rename = "servicePeriodStartDate", default, skip_serializing_if = "Option::is_none")]
    pub service_period_start_date: Option<String>,
    #[serde(rename = "servicePeriodEndDate", default, skip_serializing_if = "Option::is_none")]
    pub service_period_end_date: Option<String>,
    #[serde(rename = "customerTenantId", default, skip_serializing_if = "Option::is_none")]
    pub customer_tenant_id: Option<String>,
    #[serde(rename = "customerName", default, skip_serializing_if = "Option::is_none")]
    pub customer_name: Option<String>,
    #[serde(rename = "partnerTenantId", default, skip_serializing_if = "Option::is_none")]
    pub partner_tenant_id: Option<String>,
    #[serde(rename = "partnerName", default, skip_serializing_if = "Option::is_none")]
    pub partner_name: Option<String>,
    #[serde(rename = "resellerMpnId", default, skip_serializing_if = "Option::is_none")]
    pub reseller_mpn_id: Option<String>,
    #[serde(rename = "resellerName", default, skip_serializing_if = "Option::is_none")]
    pub reseller_name: Option<String>,
    #[serde(rename = "publisherId", default, skip_serializing_if = "Option::is_none")]
    pub publisher_id: Option<String>,
    #[serde(rename = "marketPrice", default, skip_serializing_if = "Option::is_none")]
    pub market_price: Option<f64>,
    #[serde(rename = "exchangeRatePricingToBilling", default, skip_serializing_if = "Option::is_none")]
    pub exchange_rate_pricing_to_billing: Option<f64>,
    #[serde(rename = "paygCostInBillingCurrency", default, skip_serializing_if = "Option::is_none")]
    pub payg_cost_in_billing_currency: Option<f64>,
    #[serde(rename = "paygCostInUSD", default, skip_serializing_if = "Option::is_none")]
    pub payg_cost_in_usd: Option<f64>,
    #[serde(rename = "partnerEarnedCreditRate", default, skip_serializing_if = "Option::is_none")]
    pub partner_earned_credit_rate: Option<f64>,
    #[serde(rename = "partnerEarnedCreditApplied", default, skip_serializing_if = "Option::is_none")]
    pub partner_earned_credit_applied: Option<String>,
    #[serde(rename = "payGPrice", default, skip_serializing_if = "Option::is_none")]
    pub pay_g_price: Option<f64>,
    #[serde(rename = "benefitId", default, skip_serializing_if = "Option::is_none")]
    pub benefit_id: Option<String>,
    #[serde(rename = "benefitName", default, skip_serializing_if = "Option::is_none")]
    pub benefit_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(rename = "costAllocationRuleName", default, skip_serializing_if = "Option::is_none")]
    pub cost_allocation_rule_name: Option<String>,
}
impl ModernUsageDetailProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod modern_usage_detail_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PricingModel {
        #[serde(rename = "On Demand")]
        OnDemand,
        Reservation,
        Spot,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Notification {
    pub enabled: bool,
    pub operator: notification::Operator,
    pub threshold: f64,
    #[serde(rename = "contactEmails")]
    pub contact_emails: Vec<String>,
    #[serde(rename = "contactRoles", default, skip_serializing_if = "Vec::is_empty")]
    pub contact_roles: Vec<String>,
    #[serde(rename = "contactGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub contact_groups: Vec<String>,
    #[serde(rename = "thresholdType", default, skip_serializing_if = "Option::is_none")]
    pub threshold_type: Option<notification::ThresholdType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub locale: Option<notification::Locale>,
}
impl Notification {
    pub fn new(enabled: bool, operator: notification::Operator, threshold: f64, contact_emails: Vec<String>) -> Self {
        Self {
            enabled,
            operator,
            threshold,
            contact_emails,
            contact_roles: Vec::new(),
            contact_groups: Vec::new(),
            threshold_type: None,
            locale: None,
        }
    }
}
pub mod notification {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        EqualTo,
        GreaterThan,
        GreaterThanOrEqualTo,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ThresholdType {
        Actual,
        Forecasted,
    }
    impl Default for ThresholdType {
        fn default() -> Self {
            Self::Actual
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Locale {
        #[serde(rename = "en-us")]
        EnUs,
        #[serde(rename = "ja-jp")]
        JaJp,
        #[serde(rename = "zh-cn")]
        ZhCn,
        #[serde(rename = "de-de")]
        DeDe,
        #[serde(rename = "es-es")]
        EsEs,
        #[serde(rename = "fr-fr")]
        FrFr,
        #[serde(rename = "it-it")]
        ItIt,
        #[serde(rename = "ko-kr")]
        KoKr,
        #[serde(rename = "pt-br")]
        PtBr,
        #[serde(rename = "ru-ru")]
        RuRu,
        #[serde(rename = "zh-tw")]
        ZhTw,
        #[serde(rename = "cs-cz")]
        CsCz,
        #[serde(rename = "pl-pl")]
        PlPl,
        #[serde(rename = "tr-tr")]
        TrTr,
        #[serde(rename = "da-dk")]
        DaDk,
        #[serde(rename = "en-gb")]
        EnGb,
        #[serde(rename = "hu-hu")]
        HuHu,
        #[serde(rename = "nb-no")]
        NbNo,
        #[serde(rename = "nl-nl")]
        NlNl,
        #[serde(rename = "pt-pt")]
        PtPt,
        #[serde(rename = "sv-se")]
        SvSe,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PriceSheetModel {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub pricesheets: Vec<PriceSheetProperties>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub download: Option<MeterDetails>,
}
impl PriceSheetModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PriceSheetProperties {
    #[serde(rename = "billingPeriodId", default, skip_serializing_if = "Option::is_none")]
    pub billing_period_id: Option<String>,
    #[serde(rename = "meterId", default, skip_serializing_if = "Option::is_none")]
    pub meter_id: Option<String>,
    #[serde(rename = "meterDetails", default, skip_serializing_if = "Option::is_none")]
    pub meter_details: Option<MeterDetails>,
    #[serde(rename = "unitOfMeasure", default, skip_serializing_if = "Option::is_none")]
    pub unit_of_measure: Option<String>,
    #[serde(rename = "includedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub included_quantity: Option<f64>,
    #[serde(rename = "partNumber", default, skip_serializing_if = "Option::is_none")]
    pub part_number: Option<String>,
    #[serde(rename = "unitPrice", default, skip_serializing_if = "Option::is_none")]
    pub unit_price: Option<f64>,
    #[serde(rename = "currencyCode", default, skip_serializing_if = "Option::is_none")]
    pub currency_code: Option<String>,
    #[serde(rename = "offerId", default, skip_serializing_if = "Option::is_none")]
    pub offer_id: Option<String>,
}
impl PriceSheetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PriceSheetResult {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PriceSheetModel>,
}
impl PriceSheetResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Reseller {
    #[serde(rename = "resellerId", default, skip_serializing_if = "Option::is_none")]
    pub reseller_id: Option<String>,
    #[serde(rename = "resellerDescription", default, skip_serializing_if = "Option::is_none")]
    pub reseller_description: Option<String>,
}
impl Reseller {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationDetail {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReservationDetailProperties>,
}
impl ReservationDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationDetailProperties {
    #[serde(rename = "reservationOrderId", default, skip_serializing_if = "Option::is_none")]
    pub reservation_order_id: Option<String>,
    #[serde(rename = "instanceFlexibilityRatio", default, skip_serializing_if = "Option::is_none")]
    pub instance_flexibility_ratio: Option<String>,
    #[serde(rename = "instanceFlexibilityGroup", default, skip_serializing_if = "Option::is_none")]
    pub instance_flexibility_group: Option<String>,
    #[serde(rename = "reservationId", default, skip_serializing_if = "Option::is_none")]
    pub reservation_id: Option<String>,
    #[serde(rename = "skuName", default, skip_serializing_if = "Option::is_none")]
    pub sku_name: Option<String>,
    #[serde(rename = "reservedHours", default, skip_serializing_if = "Option::is_none")]
    pub reserved_hours: Option<f64>,
    #[serde(rename = "usageDate", default, skip_serializing_if = "Option::is_none")]
    pub usage_date: Option<String>,
    #[serde(rename = "usedHours", default, skip_serializing_if = "Option::is_none")]
    pub used_hours: Option<f64>,
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[serde(rename = "totalReservedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub total_reserved_quantity: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl ReservationDetailProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationDetailsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReservationDetail>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ReservationDetailsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReservationRecommendation {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub resource_attributes: ResourceAttributes,
    pub kind: reservation_recommendation::Kind,
}
impl ReservationRecommendation {
    pub fn new(kind: reservation_recommendation::Kind) -> Self {
        Self {
            resource: Resource::default(),
            resource_attributes: ResourceAttributes::default(),
            kind,
        }
    }
}
pub mod reservation_recommendation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "legacy")]
        Legacy,
        #[serde(rename = "modern")]
        Modern,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationRecommendationDetailsCalculatedSavingsProperties {
    #[serde(rename = "onDemandCost", default, skip_serializing_if = "Option::is_none")]
    pub on_demand_cost: Option<f64>,
    #[serde(rename = "overageCost", default, skip_serializing_if = "Option::is_none")]
    pub overage_cost: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<f64>,
    #[serde(rename = "reservationCost", default, skip_serializing_if = "Option::is_none")]
    pub reservation_cost: Option<f64>,
    #[serde(rename = "totalReservationCost", default, skip_serializing_if = "Option::is_none")]
    pub total_reservation_cost: Option<f64>,
    #[serde(rename = "reservedUnitCount", default, skip_serializing_if = "Option::is_none")]
    pub reserved_unit_count: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub savings: Option<f64>,
}
impl ReservationRecommendationDetailsCalculatedSavingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationRecommendationDetailsModel {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReservationRecommendationDetailsProperties>,
}
impl ReservationRecommendationDetailsModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationRecommendationDetailsProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<ReservationRecommendationDetailsResourceProperties>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub savings: Option<ReservationRecommendationDetailsSavingsProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub usage: Option<ReservationRecommendationDetailsUsageProperties>,
}
impl ReservationRecommendationDetailsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationRecommendationDetailsResourceProperties {
    #[serde(rename = "appliedScopes", default, skip_serializing_if = "Vec::is_empty")]
    pub applied_scopes: Vec<String>,
    #[serde(rename = "onDemandRate", default, skip_serializing_if = "Option::is_none")]
    pub on_demand_rate: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub product: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "reservationRate", default, skip_serializing_if = "Option::is_none")]
    pub reservation_rate: Option<f64>,
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
}
impl ReservationRecommendationDetailsResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationRecommendationDetailsSavingsProperties {
    #[serde(rename = "calculatedSavings", default, skip_serializing_if = "Vec::is_empty")]
    pub calculated_savings: Vec<ReservationRecommendationDetailsCalculatedSavingsProperties>,
    #[serde(rename = "lookBackPeriod", default, skip_serializing_if = "Option::is_none")]
    pub look_back_period: Option<i32>,
    #[serde(rename = "recommendedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub recommended_quantity: Option<f64>,
    #[serde(rename = "reservationOrderTerm", default, skip_serializing_if = "Option::is_none")]
    pub reservation_order_term: Option<String>,
    #[serde(rename = "savingsType", default, skip_serializing_if = "Option::is_none")]
    pub savings_type: Option<String>,
    #[serde(rename = "unitOfMeasure", default, skip_serializing_if = "Option::is_none")]
    pub unit_of_measure: Option<String>,
}
impl ReservationRecommendationDetailsSavingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationRecommendationDetailsUsageProperties {
    #[serde(rename = "firstConsumptionDate", default, skip_serializing_if = "Option::is_none")]
    pub first_consumption_date: Option<String>,
    #[serde(rename = "lastConsumptionDate", default, skip_serializing_if = "Option::is_none")]
    pub last_consumption_date: Option<String>,
    #[serde(rename = "lookBackUnitType", default, skip_serializing_if = "Option::is_none")]
    pub look_back_unit_type: Option<String>,
    #[serde(rename = "usageData", default, skip_serializing_if = "Vec::is_empty")]
    pub usage_data: Vec<f64>,
    #[serde(rename = "usageGrain", default, skip_serializing_if = "Option::is_none")]
    pub usage_grain: Option<String>,
}
impl ReservationRecommendationDetailsUsageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationRecommendationsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReservationRecommendation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(rename = "previousLink", default, skip_serializing_if = "Option::is_none")]
    pub previous_link: Option<String>,
}
impl ReservationRecommendationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationSummariesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReservationSummary>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ReservationSummariesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationSummary {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReservationSummaryProperties>,
}
impl ReservationSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationSummaryProperties {
    #[serde(rename = "reservationOrderId", default, skip_serializing_if = "Option::is_none")]
    pub reservation_order_id: Option<String>,
    #[serde(rename = "reservationId", default, skip_serializing_if = "Option::is_none")]
    pub reservation_id: Option<String>,
    #[serde(rename = "skuName", default, skip_serializing_if = "Option::is_none")]
    pub sku_name: Option<String>,
    #[serde(rename = "reservedHours", default, skip_serializing_if = "Option::is_none")]
    pub reserved_hours: Option<f64>,
    #[serde(rename = "usageDate", default, skip_serializing_if = "Option::is_none")]
    pub usage_date: Option<String>,
    #[serde(rename = "usedHours", default, skip_serializing_if = "Option::is_none")]
    pub used_hours: Option<f64>,
    #[serde(rename = "minUtilizationPercentage", default, skip_serializing_if = "Option::is_none")]
    pub min_utilization_percentage: Option<f64>,
    #[serde(rename = "avgUtilizationPercentage", default, skip_serializing_if = "Option::is_none")]
    pub avg_utilization_percentage: Option<f64>,
    #[serde(rename = "maxUtilizationPercentage", default, skip_serializing_if = "Option::is_none")]
    pub max_utilization_percentage: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[serde(rename = "purchasedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub purchased_quantity: Option<f64>,
    #[serde(rename = "remainingQuantity", default, skip_serializing_if = "Option::is_none")]
    pub remaining_quantity: Option<f64>,
    #[serde(rename = "totalReservedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub total_reserved_quantity: Option<f64>,
    #[serde(rename = "usedQuantity", default, skip_serializing_if = "Option::is_none")]
    pub used_quantity: Option<f64>,
    #[serde(rename = "utilizedPercentage", default, skip_serializing_if = "Option::is_none")]
    pub utilized_percentage: Option<f64>,
}
impl ReservationSummaryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationTransaction {
    #[serde(flatten)]
    pub reservation_transaction_resource: ReservationTransactionResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LegacyReservationTransactionProperties>,
}
impl ReservationTransaction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationTransactionResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tags: Vec<String>,
}
impl ReservationTransactionResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReservationTransactionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReservationTransaction>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ReservationTransactionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceAttributes {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
}
impl ResourceAttributes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuProperty {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl SkuProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Tag {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<String>,
}
impl Tag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tags: Vec<Tag>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(rename = "previousLink", default, skip_serializing_if = "Option::is_none")]
    pub previous_link: Option<String>,
}
impl TagProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsResult {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TagProperties>,
}
impl TagsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UsageDetail {
    #[serde(flatten)]
    pub resource: Resource,
    pub kind: usage_detail::Kind,
}
impl UsageDetail {
    pub fn new(kind: usage_detail::Kind) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
pub mod usage_detail {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "legacy")]
        Legacy,
        #[serde(rename = "modern")]
        Modern,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageDetailsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<UsageDetail>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UsageDetailsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Amount {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
}
impl Amount {
    pub fn new() -> Self {
        Self::default()
    }
}
