#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Container service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerService {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the container service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContainerServiceProperties>,
}
impl ContainerService {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "Profile for the container service agent pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceAgentPoolProfile {
    #[doc = "Unique name of the agent pool profile in the context of the subscription and resource group."]
    pub name: String,
    #[doc = "Number of agents (VMs) to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1. "]
    pub count: i32,
    #[doc = "Size of agent VMs."]
    #[serde(rename = "vmSize")]
    pub vm_size: container_service_agent_pool_profile::VmSize,
    #[doc = "DNS prefix to be used to create the FQDN for the agent pool."]
    #[serde(rename = "dnsPrefix")]
    pub dns_prefix: String,
    #[doc = "FQDN for the agent pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
}
impl ContainerServiceAgentPoolProfile {
    pub fn new(name: String, count: i32, vm_size: container_service_agent_pool_profile::VmSize, dns_prefix: String) -> Self {
        Self {
            name,
            count,
            vm_size,
            dns_prefix,
            fqdn: None,
        }
    }
}
pub mod container_service_agent_pool_profile {
    use super::*;
    #[doc = "Size of agent VMs."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VmSize {
        #[serde(rename = "Standard_A0")]
        StandardA0,
        #[serde(rename = "Standard_A1")]
        StandardA1,
        #[serde(rename = "Standard_A2")]
        StandardA2,
        #[serde(rename = "Standard_A3")]
        StandardA3,
        #[serde(rename = "Standard_A4")]
        StandardA4,
        #[serde(rename = "Standard_A5")]
        StandardA5,
        #[serde(rename = "Standard_A6")]
        StandardA6,
        #[serde(rename = "Standard_A7")]
        StandardA7,
        #[serde(rename = "Standard_A8")]
        StandardA8,
        #[serde(rename = "Standard_A9")]
        StandardA9,
        #[serde(rename = "Standard_A10")]
        StandardA10,
        #[serde(rename = "Standard_A11")]
        StandardA11,
        #[serde(rename = "Standard_D1")]
        StandardD1,
        #[serde(rename = "Standard_D2")]
        StandardD2,
        #[serde(rename = "Standard_D3")]
        StandardD3,
        #[serde(rename = "Standard_D4")]
        StandardD4,
        #[serde(rename = "Standard_D11")]
        StandardD11,
        #[serde(rename = "Standard_D12")]
        StandardD12,
        #[serde(rename = "Standard_D13")]
        StandardD13,
        #[serde(rename = "Standard_D14")]
        StandardD14,
        #[serde(rename = "Standard_D1_v2")]
        StandardD1V2,
        #[serde(rename = "Standard_D2_v2")]
        StandardD2V2,
        #[serde(rename = "Standard_D3_v2")]
        StandardD3V2,
        #[serde(rename = "Standard_D4_v2")]
        StandardD4V2,
        #[serde(rename = "Standard_D5_v2")]
        StandardD5V2,
        #[serde(rename = "Standard_D11_v2")]
        StandardD11V2,
        #[serde(rename = "Standard_D12_v2")]
        StandardD12V2,
        #[serde(rename = "Standard_D13_v2")]
        StandardD13V2,
        #[serde(rename = "Standard_D14_v2")]
        StandardD14V2,
        #[serde(rename = "Standard_G1")]
        StandardG1,
        #[serde(rename = "Standard_G2")]
        StandardG2,
        #[serde(rename = "Standard_G3")]
        StandardG3,
        #[serde(rename = "Standard_G4")]
        StandardG4,
        #[serde(rename = "Standard_G5")]
        StandardG5,
        #[serde(rename = "Standard_DS1")]
        StandardDs1,
        #[serde(rename = "Standard_DS2")]
        StandardDs2,
        #[serde(rename = "Standard_DS3")]
        StandardDs3,
        #[serde(rename = "Standard_DS4")]
        StandardDs4,
        #[serde(rename = "Standard_DS11")]
        StandardDs11,
        #[serde(rename = "Standard_DS12")]
        StandardDs12,
        #[serde(rename = "Standard_DS13")]
        StandardDs13,
        #[serde(rename = "Standard_DS14")]
        StandardDs14,
        #[serde(rename = "Standard_GS1")]
        StandardGs1,
        #[serde(rename = "Standard_GS2")]
        StandardGs2,
        #[serde(rename = "Standard_GS3")]
        StandardGs3,
        #[serde(rename = "Standard_GS4")]
        StandardGs4,
        #[serde(rename = "Standard_GS5")]
        StandardGs5,
    }
}
#[doc = "Properties to configure a custom container service cluster."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceCustomProfile {
    #[doc = "The name of the custom orchestrator to use."]
    pub orchestrator: String,
}
impl ContainerServiceCustomProfile {
    pub fn new(orchestrator: String) -> Self {
        Self { orchestrator }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceDiagnosticsProfile {
    #[doc = "Profile for diagnostics on the container service VMs."]
    #[serde(rename = "vmDiagnostics")]
    pub vm_diagnostics: ContainerServiceVmDiagnostics,
}
impl ContainerServiceDiagnosticsProfile {
    pub fn new(vm_diagnostics: ContainerServiceVmDiagnostics) -> Self {
        Self { vm_diagnostics }
    }
}
#[doc = "Profile for Linux VMs in the container service cluster."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceLinuxProfile {
    #[doc = "The administrator username to use for Linux VMs."]
    #[serde(rename = "adminUsername")]
    pub admin_username: String,
    #[doc = "SSH configuration for Linux-based VMs running on Azure."]
    pub ssh: ContainerServiceSshConfiguration,
}
impl ContainerServiceLinuxProfile {
    pub fn new(admin_username: String, ssh: ContainerServiceSshConfiguration) -> Self {
        Self { admin_username, ssh }
    }
}
#[doc = "The response from the List Container Services operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerServiceListResult {
    #[doc = "the list of container services."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ContainerService>,
    #[doc = "The URL to get the next set of container service results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ContainerServiceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Profile for the container service master."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceMasterProfile {
    #[doc = "Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<container_service_master_profile::Count>,
    #[doc = "DNS prefix to be used to create the FQDN for master."]
    #[serde(rename = "dnsPrefix")]
    pub dns_prefix: String,
    #[doc = "FQDN for the master."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
}
impl ContainerServiceMasterProfile {
    pub fn new(dns_prefix: String) -> Self {
        Self {
            count: None,
            dns_prefix,
            fqdn: None,
        }
    }
}
pub mod container_service_master_profile {
    use super::*;
    #[doc = "Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Count {}
}
#[doc = "Profile for the container service orchestrator."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceOrchestratorProfile {
    #[doc = "The orchestrator to use to manage container service cluster resources. Valid values are Swarm, DCOS, and Custom."]
    #[serde(rename = "orchestratorType")]
    pub orchestrator_type: container_service_orchestrator_profile::OrchestratorType,
}
impl ContainerServiceOrchestratorProfile {
    pub fn new(orchestrator_type: container_service_orchestrator_profile::OrchestratorType) -> Self {
        Self { orchestrator_type }
    }
}
pub mod container_service_orchestrator_profile {
    use super::*;
    #[doc = "The orchestrator to use to manage container service cluster resources. Valid values are Swarm, DCOS, and Custom."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OrchestratorType {
        Swarm,
        #[serde(rename = "DCOS")]
        Dcos,
        Custom,
        Kubernetes,
    }
}
#[doc = "Properties of the container service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceProperties {
    #[doc = "the current deployment or provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Profile for the container service orchestrator."]
    #[serde(rename = "orchestratorProfile", default, skip_serializing_if = "Option::is_none")]
    pub orchestrator_profile: Option<ContainerServiceOrchestratorProfile>,
    #[doc = "Properties to configure a custom container service cluster."]
    #[serde(rename = "customProfile", default, skip_serializing_if = "Option::is_none")]
    pub custom_profile: Option<ContainerServiceCustomProfile>,
    #[doc = "Information about a service principal identity for the cluster to use for manipulating Azure APIs."]
    #[serde(rename = "servicePrincipalProfile", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_profile: Option<ContainerServiceServicePrincipalProfile>,
    #[doc = "Profile for the container service master."]
    #[serde(rename = "masterProfile")]
    pub master_profile: ContainerServiceMasterProfile,
    #[doc = "Properties of the agent pool."]
    #[serde(rename = "agentPoolProfiles")]
    pub agent_pool_profiles: Vec<ContainerServiceAgentPoolProfile>,
    #[doc = "Profile for Windows VMs in the container service cluster."]
    #[serde(rename = "windowsProfile", default, skip_serializing_if = "Option::is_none")]
    pub windows_profile: Option<ContainerServiceWindowsProfile>,
    #[doc = "Profile for Linux VMs in the container service cluster."]
    #[serde(rename = "linuxProfile")]
    pub linux_profile: ContainerServiceLinuxProfile,
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<ContainerServiceDiagnosticsProfile>,
}
impl ContainerServiceProperties {
    pub fn new(
        master_profile: ContainerServiceMasterProfile,
        agent_pool_profiles: Vec<ContainerServiceAgentPoolProfile>,
        linux_profile: ContainerServiceLinuxProfile,
    ) -> Self {
        Self {
            provisioning_state: None,
            orchestrator_profile: None,
            custom_profile: None,
            service_principal_profile: None,
            master_profile,
            agent_pool_profiles,
            windows_profile: None,
            linux_profile,
            diagnostics_profile: None,
        }
    }
}
#[doc = "Information about a service principal identity for the cluster to use for manipulating Azure APIs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceServicePrincipalProfile {
    #[doc = "The ID for the service principal."]
    #[serde(rename = "clientId")]
    pub client_id: String,
    #[doc = "The secret password associated with the service principal."]
    pub secret: String,
}
impl ContainerServiceServicePrincipalProfile {
    pub fn new(client_id: String, secret: String) -> Self {
        Self { client_id, secret }
    }
}
#[doc = "SSH configuration for Linux-based VMs running on Azure."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceSshConfiguration {
    #[doc = "the list of SSH public keys used to authenticate with Linux-based VMs."]
    #[serde(rename = "publicKeys")]
    pub public_keys: Vec<ContainerServiceSshPublicKey>,
}
impl ContainerServiceSshConfiguration {
    pub fn new(public_keys: Vec<ContainerServiceSshPublicKey>) -> Self {
        Self { public_keys }
    }
}
#[doc = "Contains information about SSH certificate public key data."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceSshPublicKey {
    #[doc = "Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers."]
    #[serde(rename = "keyData")]
    pub key_data: String,
}
impl ContainerServiceSshPublicKey {
    pub fn new(key_data: String) -> Self {
        Self { key_data }
    }
}
#[doc = "Profile for diagnostics on the container service VMs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceVmDiagnostics {
    #[doc = "Whether the VM diagnostic agent is provisioned on the VM."]
    pub enabled: bool,
    #[doc = "The URI of the storage account where diagnostics are stored."]
    #[serde(rename = "storageUri", default, skip_serializing_if = "Option::is_none")]
    pub storage_uri: Option<String>,
}
impl ContainerServiceVmDiagnostics {
    pub fn new(enabled: bool) -> Self {
        Self {
            enabled,
            storage_uri: None,
        }
    }
}
#[doc = "Profile for Windows VMs in the container service cluster."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceWindowsProfile {
    #[doc = "The administrator username to use for Windows VMs."]
    #[serde(rename = "adminUsername")]
    pub admin_username: String,
    #[doc = "The administrator password to use for Windows VMs."]
    #[serde(rename = "adminPassword")]
    pub admin_password: String,
}
impl ContainerServiceWindowsProfile {
    pub fn new(admin_username: String, admin_password: String) -> Self {
        Self {
            admin_username,
            admin_password,
        }
    }
}
#[doc = "The Resource model definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
