#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdditionalUnattendContent {
    #[doc = "The pass name. Currently, the only allowable value is OobeSystem."]
    #[serde(rename = "passName", default, skip_serializing_if = "Option::is_none")]
    pub pass_name: Option<additional_unattend_content::PassName>,
    #[doc = "The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup."]
    #[serde(rename = "componentName", default, skip_serializing_if = "Option::is_none")]
    pub component_name: Option<additional_unattend_content::ComponentName>,
    #[doc = "Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon."]
    #[serde(rename = "settingName", default, skip_serializing_if = "Option::is_none")]
    pub setting_name: Option<additional_unattend_content::SettingName>,
    #[doc = "Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
}
impl AdditionalUnattendContent {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod additional_unattend_content {
    use super::*;
    #[doc = "The pass name. Currently, the only allowable value is OobeSystem."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PassName {
        OobeSystem,
    }
    #[doc = "The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComponentName {
        #[serde(rename = "Microsoft-Windows-Shell-Setup")]
        MicrosoftWindowsShellSetup,
    }
    #[doc = "Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SettingName {
        AutoLogon,
        FirstLogonCommands,
    }
}
#[doc = "The API entity reference."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiEntityReference {
    #[doc = "The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/..."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ApiEntityReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Api error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiError {
    #[doc = "The Api error details"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ApiErrorBase>,
    #[doc = "Inner error details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub innererror: Option<InnerError>,
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The target of the particular error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ApiError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Api error base."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiErrorBase {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The target of the particular error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ApiErrorBase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Manage the availability of virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json). <br><br> For more information on Azure planned maintenance, see [Planned maintenance for virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailabilitySet {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The instance view of a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AvailabilitySetProperties>,
}
impl AvailabilitySet {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The List Availability Set operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailabilitySetListResult {
    #[doc = "The list of availability sets"]
    pub value: Vec<AvailabilitySet>,
    #[doc = "The URI to fetch the next page of AvailabilitySets. Call ListNext() with this URI to fetch the next page of AvailabilitySets."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailabilitySetListResult {
    pub fn new(value: Vec<AvailabilitySet>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "The instance view of a resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailabilitySetProperties {
    #[doc = "Update Domain count."]
    #[serde(rename = "platformUpdateDomainCount", default, skip_serializing_if = "Option::is_none")]
    pub platform_update_domain_count: Option<i32>,
    #[doc = "Fault Domain count."]
    #[serde(rename = "platformFaultDomainCount", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain_count: Option<i32>,
    #[doc = "A list of references to all virtual machines in the availability set."]
    #[serde(rename = "virtualMachines", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_machines: Vec<SubResource>,
    #[doc = "The resource status information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl AvailabilitySetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BootDiagnostics {
    #[doc = "Whether boot diagnostics should be enabled on the Virtual Machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[doc = "Uri of the storage account to use for placing the console output and screenshot."]
    #[serde(rename = "storageUri", default, skip_serializing_if = "Option::is_none")]
    pub storage_uri: Option<String>,
}
impl BootDiagnostics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The instance view of a virtual machine boot diagnostics."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BootDiagnosticsInstanceView {
    #[doc = "The console screenshot blob URI."]
    #[serde(rename = "consoleScreenshotBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub console_screenshot_blob_uri: Option<String>,
    #[doc = "The Linux serial console log blob Uri."]
    #[serde(rename = "serialConsoleLogBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub serial_console_log_blob_uri: Option<String>,
}
impl BootDiagnosticsInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Caching {
    None,
    ReadOnly,
    ReadWrite,
}
#[doc = "Compute-specific operation properties, including output"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeLongRunningOperationProperties {
    #[doc = "Operation output data (raw JSON)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<serde_json::Value>,
}
impl ComputeLongRunningOperationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CreateOption {
    FromImage,
    Empty,
    Attach,
}
#[doc = "Describes a data disk."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataDisk {
    #[doc = "Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM."]
    pub lun: i32,
    #[doc = "The disk name."]
    pub name: String,
    #[doc = "Describes the uri of a disk."]
    pub vhd: VirtualHardDisk,
    #[doc = "Describes the uri of a disk."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[doc = "Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[doc = "Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described."]
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[doc = "Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB"]
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
}
impl DataDisk {
    pub fn new(lun: i32, name: String, vhd: VirtualHardDisk, create_option: CreateOption) -> Self {
        Self {
            lun,
            name,
            vhd,
            image: None,
            caching: None,
            create_option,
            disk_size_gb: None,
        }
    }
}
#[doc = "Contains the data disk images information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataDiskImage {
    #[doc = "Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub lun: Option<i32>,
}
impl DataDiskImage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticsProfile {
    #[doc = "Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor."]
    #[serde(rename = "bootDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub boot_diagnostics: Option<BootDiagnostics>,
}
impl DiagnosticsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a Encryption Settings for a Disk"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskEncryptionSettings {
    #[doc = "Describes a reference to Key Vault Secret"]
    #[serde(rename = "diskEncryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_key: Option<KeyVaultSecretReference>,
    #[doc = "Describes a reference to Key Vault Key"]
    #[serde(rename = "keyEncryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub key_encryption_key: Option<KeyVaultKeyReference>,
    #[doc = "Specifies whether disk encryption should be enabled on the virtual machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl DiskEncryptionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The instance view of the disk."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskInstanceView {
    #[doc = "The disk name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The resource status information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl DiskInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies the hardware settings for the virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HardwareProfile {
    #[doc = "Specifies the size of the virtual machine. For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json). <br><br> The available VM sizes depend on region and availability set. For a list of available sizes use these APIs:  <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region](https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes)"]
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<hardware_profile::VmSize>,
}
impl HardwareProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hardware_profile {
    use super::*;
    #[doc = "Specifies the size of the virtual machine. For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json). <br><br> The available VM sizes depend on region and availability set. For a list of available sizes use these APIs:  <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region](https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VmSize {
        #[serde(rename = "Basic_A0")]
        BasicA0,
        #[serde(rename = "Basic_A1")]
        BasicA1,
        #[serde(rename = "Basic_A2")]
        BasicA2,
        #[serde(rename = "Basic_A3")]
        BasicA3,
        #[serde(rename = "Basic_A4")]
        BasicA4,
        #[serde(rename = "Standard_A0")]
        StandardA0,
        #[serde(rename = "Standard_A1")]
        StandardA1,
        #[serde(rename = "Standard_A2")]
        StandardA2,
        #[serde(rename = "Standard_A3")]
        StandardA3,
        #[serde(rename = "Standard_A4")]
        StandardA4,
        #[serde(rename = "Standard_A5")]
        StandardA5,
        #[serde(rename = "Standard_A6")]
        StandardA6,
        #[serde(rename = "Standard_A7")]
        StandardA7,
        #[serde(rename = "Standard_A8")]
        StandardA8,
        #[serde(rename = "Standard_A9")]
        StandardA9,
        #[serde(rename = "Standard_A10")]
        StandardA10,
        #[serde(rename = "Standard_A11")]
        StandardA11,
        #[serde(rename = "Standard_D1")]
        StandardD1,
        #[serde(rename = "Standard_D2")]
        StandardD2,
        #[serde(rename = "Standard_D3")]
        StandardD3,
        #[serde(rename = "Standard_D4")]
        StandardD4,
        #[serde(rename = "Standard_D11")]
        StandardD11,
        #[serde(rename = "Standard_D12")]
        StandardD12,
        #[serde(rename = "Standard_D13")]
        StandardD13,
        #[serde(rename = "Standard_D14")]
        StandardD14,
        #[serde(rename = "Standard_D1_v2")]
        StandardD1V2,
        #[serde(rename = "Standard_D2_v2")]
        StandardD2V2,
        #[serde(rename = "Standard_D3_v2")]
        StandardD3V2,
        #[serde(rename = "Standard_D4_v2")]
        StandardD4V2,
        #[serde(rename = "Standard_D5_v2")]
        StandardD5V2,
        #[serde(rename = "Standard_D11_v2")]
        StandardD11V2,
        #[serde(rename = "Standard_D12_v2")]
        StandardD12V2,
        #[serde(rename = "Standard_D13_v2")]
        StandardD13V2,
        #[serde(rename = "Standard_D14_v2")]
        StandardD14V2,
        #[serde(rename = "Standard_D15_v2")]
        StandardD15V2,
        #[serde(rename = "Standard_DS1")]
        StandardDs1,
        #[serde(rename = "Standard_DS2")]
        StandardDs2,
        #[serde(rename = "Standard_DS3")]
        StandardDs3,
        #[serde(rename = "Standard_DS4")]
        StandardDs4,
        #[serde(rename = "Standard_DS11")]
        StandardDs11,
        #[serde(rename = "Standard_DS12")]
        StandardDs12,
        #[serde(rename = "Standard_DS13")]
        StandardDs13,
        #[serde(rename = "Standard_DS14")]
        StandardDs14,
        #[serde(rename = "Standard_DS1_v2")]
        StandardDs1V2,
        #[serde(rename = "Standard_DS2_v2")]
        StandardDs2V2,
        #[serde(rename = "Standard_DS3_v2")]
        StandardDs3V2,
        #[serde(rename = "Standard_DS4_v2")]
        StandardDs4V2,
        #[serde(rename = "Standard_DS5_v2")]
        StandardDs5V2,
        #[serde(rename = "Standard_DS11_v2")]
        StandardDs11V2,
        #[serde(rename = "Standard_DS12_v2")]
        StandardDs12V2,
        #[serde(rename = "Standard_DS13_v2")]
        StandardDs13V2,
        #[serde(rename = "Standard_DS14_v2")]
        StandardDs14V2,
        #[serde(rename = "Standard_DS15_v2")]
        StandardDs15V2,
        #[serde(rename = "Standard_G1")]
        StandardG1,
        #[serde(rename = "Standard_G2")]
        StandardG2,
        #[serde(rename = "Standard_G3")]
        StandardG3,
        #[serde(rename = "Standard_G4")]
        StandardG4,
        #[serde(rename = "Standard_G5")]
        StandardG5,
        #[serde(rename = "Standard_GS1")]
        StandardGs1,
        #[serde(rename = "Standard_GS2")]
        StandardGs2,
        #[serde(rename = "Standard_GS3")]
        StandardGs3,
        #[serde(rename = "Standard_GS4")]
        StandardGs4,
        #[serde(rename = "Standard_GS5")]
        StandardGs5,
    }
}
#[doc = "Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageReference {
    #[doc = "The image publisher."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[doc = "Specifies the offer of the platform image or marketplace image used to create the virtual machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
    #[doc = "The image SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[doc = "Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl ImageReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Inner error details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InnerError {
    #[doc = "The exception type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exceptiontype: Option<String>,
    #[doc = "The internal error message or exception dump."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub errordetail: Option<String>,
}
impl InnerError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Instance view status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstanceViewStatus {
    #[doc = "The status code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The level code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<instance_view_status::Level>,
    #[doc = "The short localizable label for the status."]
    #[serde(rename = "displayStatus", default, skip_serializing_if = "Option::is_none")]
    pub display_status: Option<String>,
    #[doc = "The detailed status message, including for alerts and error messages."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The time of the status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
}
impl InstanceViewStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod instance_view_status {
    use super::*;
    #[doc = "The level code."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Info,
        Warning,
        Error,
    }
}
#[doc = "Describes a reference to Key Vault Key"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultKeyReference {
    #[doc = "The URL referencing a key encryption key in Key Vault."]
    #[serde(rename = "keyUrl")]
    pub key_url: String,
    #[serde(rename = "sourceVault")]
    pub source_vault: SubResource,
}
impl KeyVaultKeyReference {
    pub fn new(key_url: String, source_vault: SubResource) -> Self {
        Self { key_url, source_vault }
    }
}
#[doc = "Describes a reference to Key Vault Secret"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultSecretReference {
    #[doc = "The URL referencing a secret in a Key Vault."]
    #[serde(rename = "secretUrl")]
    pub secret_url: String,
    #[serde(rename = "sourceVault")]
    pub source_vault: SubResource,
}
impl KeyVaultSecretReference {
    pub fn new(secret_url: String, source_vault: SubResource) -> Self {
        Self { secret_url, source_vault }
    }
}
#[doc = "Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinuxConfiguration {
    #[doc = "Specifies whether password authentication should be disabled."]
    #[serde(rename = "disablePasswordAuthentication", default, skip_serializing_if = "Option::is_none")]
    pub disable_password_authentication: Option<bool>,
    #[doc = "SSH configuration for Linux based VMs running on Azure"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub ssh: Option<SshConfiguration>,
}
impl LinuxConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Usages operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListUsagesResult {
    #[doc = "The list of compute resource usages."]
    pub value: Vec<Usage>,
    #[doc = "The URI to fetch the next page of compute resource usage information. Call ListNext() with this to fetch the next page of compute resource usage information."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListUsagesResult {
    pub fn new(value: Vec<Usage>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Describes a network interface reference."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceReference {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Describes a network interface reference properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceReferenceProperties>,
}
impl NetworkInterfaceReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a network interface reference properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceReferenceProperties {
    #[doc = "Specifies the primary network interface in case the virtual machine has more than 1 network interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
}
impl NetworkInterfaceReferenceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies the network interfaces of the virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProfile {
    #[doc = "Specifies the list of resource Ids for the network interfaces associated with the virtual machine."]
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterfaceReference>,
}
impl NetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OsDisk {
    #[doc = "This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**"]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<os_disk::OsType>,
    #[doc = "Describes a Encryption Settings for a Disk"]
    #[serde(rename = "encryptionSettings", default, skip_serializing_if = "Option::is_none")]
    pub encryption_settings: Option<DiskEncryptionSettings>,
    #[doc = "The disk name."]
    pub name: String,
    #[doc = "Describes the uri of a disk."]
    pub vhd: VirtualHardDisk,
    #[doc = "Describes the uri of a disk."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[doc = "Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[doc = "Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described."]
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[doc = "Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB"]
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
}
impl OsDisk {
    pub fn new(name: String, vhd: VirtualHardDisk, create_option: CreateOption) -> Self {
        Self {
            os_type: None,
            encryption_settings: None,
            name,
            vhd,
            image: None,
            caching: None,
            create_option,
            disk_size_gb: None,
        }
    }
}
pub mod os_disk {
    use super::*;
    #[doc = "This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[doc = "Contains the os disk image information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OsDiskImage {
    #[doc = "The operating system of the osDiskImage."]
    #[serde(rename = "operatingSystem")]
    pub operating_system: os_disk_image::OperatingSystem,
}
impl OsDiskImage {
    pub fn new(operating_system: os_disk_image::OperatingSystem) -> Self {
        Self { operating_system }
    }
}
pub mod os_disk_image {
    use super::*;
    #[doc = "The operating system of the osDiskImage."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperatingSystem {
        Windows,
        Linux,
    }
}
#[doc = "Specifies the operating system settings for the virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsProfile {
    #[doc = "Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions)."]
    #[serde(rename = "computerName", default, skip_serializing_if = "Option::is_none")]
    pub computer_name: Option<String>,
    #[doc = "Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in \".\" <br><br> **Disallowed values:** \"administrator\", \"admin\", \"user\", \"user1\", \"test\", \"user2\", \"test1\", \"user3\", \"admin1\", \"1\", \"123\", \"a\", \"actuser\", \"adm\", \"admin2\", \"aspnet\", \"backup\", \"console\", \"david\", \"guest\", \"john\", \"owner\", \"root\", \"server\", \"sql\", \"support\", \"support_388945a0\", \"sys\", \"test2\", \"test3\", \"user4\", \"user5\". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)"]
    #[serde(rename = "adminUsername", default, skip_serializing_if = "Option::is_none")]
    pub admin_username: Option<String>,
    #[doc = "Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** \"abc@123\", \"P@$$w0rd\", \"P@ssw0rd\", \"P@ssword123\", \"Pa$$word\", \"pass@word1\", \"Password!\", \"Password1\", \"Password22\", \"iloveyou!\" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)"]
    #[serde(rename = "adminPassword", default, skip_serializing_if = "Option::is_none")]
    pub admin_password: Option<String>,
    #[doc = "Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)"]
    #[serde(rename = "customData", default, skip_serializing_if = "Option::is_none")]
    pub custom_data: Option<String>,
    #[doc = "Specifies Windows operating system settings on the virtual machine."]
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[doc = "Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)."]
    #[serde(rename = "linuxConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_configuration: Option<LinuxConfiguration>,
    #[doc = "Specifies set of certificates that should be installed onto the virtual machine."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub secrets: Vec<VaultSecretGroup>,
}
impl OsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Operation status response"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatusResponse {
    #[doc = "Operation ID"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Operation status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Start time of the operation"]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "End time of the operation"]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "Api error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
}
impl OperationStatusResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Plan {
    #[doc = "The plan ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The publisher ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[doc = "Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub product: Option<String>,
    #[doc = "The promotion code."]
    #[serde(rename = "promotionCode", default, skip_serializing_if = "Option::is_none")]
    pub promotion_code: Option<String>,
}
impl Plan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Used for establishing the purchase context of any 3rd Party artifact through MarketPlace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PurchasePlan {
    #[doc = "The publisher ID."]
    pub publisher: String,
    #[doc = "The plan ID."]
    pub name: String,
    #[doc = "Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element."]
    pub product: String,
}
impl PurchasePlan {
    pub fn new(publisher: String, name: String, product: String) -> Self {
        Self { publisher, name, product }
    }
}
#[doc = "The Resource model definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location: None,
            tags: None,
        }
    }
}
#[doc = "Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[doc = "The sku name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[doc = "Specifies the number of virtual machines in the scale set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i64>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SSH configuration for Linux based VMs running on Azure"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SshConfiguration {
    #[doc = "The list of SSH public keys used to authenticate with linux based VMs."]
    #[serde(rename = "publicKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub public_keys: Vec<SshPublicKey>,
}
impl SshConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SshPublicKey {
    #[doc = "Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)."]
    #[serde(rename = "keyData", default, skip_serializing_if = "Option::is_none")]
    pub key_data: Option<String>,
}
impl SshPublicKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies the storage settings for the virtual machine disks."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageProfile {
    #[doc = "Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set."]
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<ImageReference>,
    #[doc = "Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)."]
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<OsDisk>,
    #[doc = "Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)."]
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<DataDisk>,
}
impl StorageProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Update Resource model definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateResource {
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl UpdateResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes an upgrade policy - automatic or manual."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpgradePolicy {
    #[doc = "Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<upgrade_policy::Mode>,
}
impl UpgradePolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod upgrade_policy {
    use super::*;
    #[doc = "Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        Automatic,
        Manual,
    }
}
#[doc = "Describes Compute Resource Usage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    #[doc = "An enum describing the unit of usage measurement."]
    pub unit: usage::Unit,
    #[doc = "The current usage of the resource."]
    #[serde(rename = "currentValue")]
    pub current_value: i32,
    #[doc = "The maximum permitted usage of the resource."]
    pub limit: i64,
    #[doc = "The Usage Names."]
    pub name: UsageName,
}
impl Usage {
    pub fn new(unit: usage::Unit, current_value: i32, limit: i64, name: UsageName) -> Self {
        Self {
            unit,
            current_value,
            limit,
            name,
        }
    }
}
pub mod usage {
    use super::*;
    #[doc = "An enum describing the unit of usage measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[doc = "The Usage Names."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "The localized name of the resource."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultCertificate {
    #[doc = "This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  \"data\":\"<Base64-encoded-certificate>\",<br>  \"dataType\":\"pfx\",<br>  \"password\":\"<pfx-file-password>\"<br>}"]
    #[serde(rename = "certificateUrl", default, skip_serializing_if = "Option::is_none")]
    pub certificate_url: Option<String>,
    #[doc = "For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted."]
    #[serde(rename = "certificateStore", default, skip_serializing_if = "Option::is_none")]
    pub certificate_store: Option<String>,
}
impl VaultCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a set of certificates which are all in the same Key Vault."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultSecretGroup {
    #[serde(rename = "sourceVault", default, skip_serializing_if = "Option::is_none")]
    pub source_vault: Option<SubResource>,
    #[doc = "The list of key vault references in SourceVault which contain certificates."]
    #[serde(rename = "vaultCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vault_certificates: Vec<VaultCertificate>,
}
impl VaultSecretGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the uri of a disk."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHardDisk {
    #[doc = "Specifies the virtual hard disk's uri."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
}
impl VirtualHardDisk {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a Virtual Machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachine {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[doc = "Describes the properties of a Virtual Machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineProperties>,
    #[doc = "The virtual machine child extension resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<VirtualMachineExtension>,
    #[doc = "Identity for the virtual machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<VirtualMachineIdentity>,
}
impl VirtualMachine {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            plan: None,
            properties: None,
            resources: Vec::new(),
            identity: None,
        }
    }
}
#[doc = "The instance view of the VM Agent running on the virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineAgentInstanceView {
    #[doc = "The VM Agent full version."]
    #[serde(rename = "vmAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub vm_agent_version: Option<String>,
    #[doc = "The virtual machine extension handler instance view."]
    #[serde(rename = "extensionHandlers", default, skip_serializing_if = "Vec::is_empty")]
    pub extension_handlers: Vec<VirtualMachineExtensionHandlerInstanceView>,
    #[doc = "The resource status information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineAgentInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Capture Virtual Machine parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineCaptureParameters {
    #[doc = "The captured virtual hard disk's name prefix."]
    #[serde(rename = "vhdPrefix")]
    pub vhd_prefix: String,
    #[doc = "The destination container name."]
    #[serde(rename = "destinationContainerName")]
    pub destination_container_name: String,
    #[doc = "Specifies whether to overwrite the destination virtual hard disk, in case of conflict."]
    #[serde(rename = "overwriteVhds")]
    pub overwrite_vhds: bool,
}
impl VirtualMachineCaptureParameters {
    pub fn new(vhd_prefix: String, destination_container_name: String, overwrite_vhds: bool) -> Self {
        Self {
            vhd_prefix,
            destination_container_name,
            overwrite_vhds,
        }
    }
}
#[doc = "Resource Id."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineCaptureResult {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Compute-specific operation properties, including output"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineCaptureResultProperties>,
}
impl VirtualMachineCaptureResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Compute-specific operation properties, including output"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineCaptureResultProperties {
    #[doc = "Operation output data (raw JSON)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<serde_json::Value>,
}
impl VirtualMachineCaptureResultProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a Virtual Machine Extension."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineExtension {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes the properties of a Virtual Machine Extension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionProperties>,
}
impl VirtualMachineExtension {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The instance view of a virtual machine extension handler."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionHandlerInstanceView {
    #[doc = "Specifies the type of the extension; an example is \"CustomScriptExtension\"."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Specifies the version of the script handler."]
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[doc = "Instance view status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<InstanceViewStatus>,
}
impl VirtualMachineExtensionHandlerInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a Virtual Machine Extension Image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineExtensionImage {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes the properties of a Virtual Machine Extension Image."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionImageProperties>,
}
impl VirtualMachineExtensionImage {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "Describes the properties of a Virtual Machine Extension Image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineExtensionImageProperties {
    #[doc = "The operating system this extension supports."]
    #[serde(rename = "operatingSystem")]
    pub operating_system: String,
    #[doc = "The type of role (IaaS or PaaS) this extension supports."]
    #[serde(rename = "computeRole")]
    pub compute_role: String,
    #[doc = "The schema defined by publisher, where extension consumers should provide settings in a matching schema."]
    #[serde(rename = "handlerSchema")]
    pub handler_schema: String,
    #[doc = "Whether the extension can be used on xRP VMScaleSets. By default existing extensions are usable on scalesets, but there might be cases where a publisher wants to explicitly indicate the extension is only enabled for CRP VMs but not VMSS."]
    #[serde(rename = "vmScaleSetEnabled", default, skip_serializing_if = "Option::is_none")]
    pub vm_scale_set_enabled: Option<bool>,
    #[doc = "Whether the handler can support multiple extensions."]
    #[serde(rename = "supportsMultipleExtensions", default, skip_serializing_if = "Option::is_none")]
    pub supports_multiple_extensions: Option<bool>,
}
impl VirtualMachineExtensionImageProperties {
    pub fn new(operating_system: String, compute_role: String, handler_schema: String) -> Self {
        Self {
            operating_system,
            compute_role,
            handler_schema,
            vm_scale_set_enabled: None,
            supports_multiple_extensions: None,
        }
    }
}
#[doc = "The instance view of a virtual machine extension."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionInstanceView {
    #[doc = "The virtual machine extension name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Specifies the type of the extension; an example is \"CustomScriptExtension\"."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Specifies the version of the script handler."]
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[doc = "The resource status information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub substatuses: Vec<InstanceViewStatus>,
    #[doc = "The resource status information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineExtensionInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a Virtual Machine Extension."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionProperties {
    #[doc = "How the extension handler should be forced to update even if the extension configuration has not changed."]
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
    #[doc = "The name of the extension handler publisher."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[doc = "Specifies the type of the extension; an example is \"CustomScriptExtension\"."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Specifies the version of the script handler."]
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[doc = "Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true."]
    #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_minor_version: Option<bool>,
    #[doc = "Json formatted public settings for the extension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<serde_json::Value>,
    #[doc = "The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all."]
    #[serde(rename = "protectedSettings", default, skip_serializing_if = "Option::is_none")]
    pub protected_settings: Option<serde_json::Value>,
    #[doc = "The provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "The instance view of a virtual machine extension."]
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineExtensionInstanceView>,
}
impl VirtualMachineExtensionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a Virtual Machine Extension."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[doc = "Describes the properties of a Virtual Machine Extension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionUpdateProperties>,
}
impl VirtualMachineExtensionUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a Virtual Machine Extension."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionUpdateProperties {
    #[doc = "How the extension handler should be forced to update even if the extension configuration has not changed."]
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
    #[doc = "The name of the extension handler publisher."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[doc = "Specifies the type of the extension; an example is \"CustomScriptExtension\"."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Specifies the version of the script handler."]
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[doc = "Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true."]
    #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_minor_version: Option<bool>,
    #[doc = "Json formatted public settings for the extension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<serde_json::Value>,
    #[doc = "The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all."]
    #[serde(rename = "protectedSettings", default, skip_serializing_if = "Option::is_none")]
    pub protected_settings: Option<serde_json::Value>,
}
impl VirtualMachineExtensionUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Extension operation response"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionsListResult {
    #[doc = "The list of extensions"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualMachineExtension>,
}
impl VirtualMachineExtensionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Identity for the virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineIdentity {
    #[doc = "The principal id of virtual machine identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The tenant id associated with the virtual machine."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The type of identity used for the virtual machine. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<virtual_machine_identity::Type>,
}
impl VirtualMachineIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_identity {
    use super::*;
    #[doc = "The type of identity used for the virtual machine. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[doc = "Describes a Virtual Machine Image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineImage {
    #[serde(flatten)]
    pub virtual_machine_image_resource: VirtualMachineImageResource,
    #[doc = "Describes the properties of a Virtual Machine Image."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineImageProperties>,
}
impl VirtualMachineImage {
    pub fn new(virtual_machine_image_resource: VirtualMachineImageResource) -> Self {
        Self {
            virtual_machine_image_resource,
            properties: None,
        }
    }
}
#[doc = "Describes the properties of a Virtual Machine Image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineImageProperties {
    #[doc = "Used for establishing the purchase context of any 3rd Party artifact through MarketPlace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<PurchasePlan>,
    #[doc = "Contains the os disk image information."]
    #[serde(rename = "osDiskImage", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_image: Option<OsDiskImage>,
    #[serde(rename = "dataDiskImages", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disk_images: Vec<DataDiskImage>,
}
impl VirtualMachineImageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual machine image resource information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineImageResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "The name of the resource."]
    pub name: String,
    #[doc = "The supported Azure location of the resource."]
    pub location: String,
    #[doc = "Specifies the tags that are assigned to the virtual machine. For more information about using tags, see [Using tags to organize your Azure resources](https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl VirtualMachineImageResource {
    pub fn new(name: String, location: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            name,
            location,
            tags: None,
        }
    }
}
#[doc = "The instance view of a virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineInstanceView {
    #[doc = "Specifies the update domain of the virtual machine."]
    #[serde(rename = "platformUpdateDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_update_domain: Option<i32>,
    #[doc = "Specifies the fault domain of the virtual machine."]
    #[serde(rename = "platformFaultDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain: Option<i32>,
    #[doc = "The Remote desktop certificate thumbprint."]
    #[serde(rename = "rdpThumbPrint", default, skip_serializing_if = "Option::is_none")]
    pub rdp_thumb_print: Option<String>,
    #[doc = "The instance view of the VM Agent running on the virtual machine."]
    #[serde(rename = "vmAgent", default, skip_serializing_if = "Option::is_none")]
    pub vm_agent: Option<VirtualMachineAgentInstanceView>,
    #[doc = "The virtual machine disk information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<DiskInstanceView>,
    #[doc = "The extensions information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineExtensionInstanceView>,
    #[doc = "The instance view of a virtual machine boot diagnostics."]
    #[serde(rename = "bootDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub boot_diagnostics: Option<BootDiagnosticsInstanceView>,
    #[doc = "The resource status information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Virtual Machine operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineListResult {
    #[doc = "The list of virtual machines."]
    pub value: Vec<VirtualMachine>,
    #[doc = "The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch the next page of Virtual Machines."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineListResult {
    pub fn new(value: Vec<VirtualMachine>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Describes the properties of a Virtual Machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineProperties {
    #[doc = "Specifies the hardware settings for the virtual machine."]
    #[serde(rename = "hardwareProfile", default, skip_serializing_if = "Option::is_none")]
    pub hardware_profile: Option<HardwareProfile>,
    #[doc = "Specifies the storage settings for the virtual machine disks."]
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<StorageProfile>,
    #[doc = "Specifies the operating system settings for the virtual machine."]
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<OsProfile>,
    #[doc = "Specifies the network interfaces of the virtual machine."]
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<NetworkProfile>,
    #[doc = "Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15."]
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<DiagnosticsProfile>,
    #[serde(rename = "availabilitySet", default, skip_serializing_if = "Option::is_none")]
    pub availability_set: Option<SubResource>,
    #[doc = "The provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "The instance view of a virtual machine."]
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineInstanceView>,
    #[doc = "Specifies that the image or disk that is being used was licensed on-premises. This element is only used for images that contain the Windows Server operating system. <br><br> Possible values are: <br><br> Windows_Client <br><br> Windows_Server <br><br> If this element is included in a request for an update, the value must match the initial value. This value cannot be updated. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> Minimum api-version: 2015-06-15"]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[doc = "Specifies the VM unique ID which is a 128-bits identifier that is encoded and stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands."]
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
}
impl VirtualMachineProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a Virtual Machine Scale Set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSet {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Describes the properties of a Virtual Machine Scale Set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetProperties>,
    #[doc = "Identity for the virtual machine scale set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<VirtualMachineScaleSetIdentity>,
}
impl VirtualMachineScaleSet {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            sku: None,
            properties: None,
            identity: None,
        }
    }
}
#[doc = "Describes a Virtual Machine Scale Set Extension."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtension {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "The name of the extension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Describes the properties of a Virtual Machine Scale Set Extension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetExtensionProperties>,
}
impl VirtualMachineScaleSetExtension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a virtual machine scale set extension profile."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtensionProfile {
    #[doc = "The virtual machine scale set child extension resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineScaleSetExtension>,
}
impl VirtualMachineScaleSetExtensionProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a Virtual Machine Scale Set Extension."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtensionProperties {
    #[doc = "The name of the extension handler publisher."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[doc = "The type of the extension handler."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The type version of the extension handler."]
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[doc = "Whether the extension handler should be automatically upgraded across minor versions."]
    #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_minor_version: Option<bool>,
    #[doc = "Json formatted public settings for the extension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<serde_json::Value>,
    #[doc = "Json formatted protected settings for the extension."]
    #[serde(rename = "protectedSettings", default, skip_serializing_if = "Option::is_none")]
    pub protected_settings: Option<serde_json::Value>,
    #[doc = "The provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualMachineScaleSetExtensionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a virtual machine scale set network profile's IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "The IP configuration name."]
    pub name: String,
    #[doc = "Describes a virtual machine scale set network profile's IP configuration properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetIpConfigurationProperties>,
}
impl VirtualMachineScaleSetIpConfiguration {
    pub fn new(name: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            name,
            properties: None,
        }
    }
}
#[doc = "Describes a virtual machine scale set network profile's IP configuration properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetIpConfigurationProperties {
    #[doc = "The API entity reference."]
    pub subnet: ApiEntityReference,
    #[doc = "The application gateway backend address pools."]
    #[serde(rename = "applicationGatewayBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_backend_address_pools: Vec<SubResource>,
    #[doc = "The load balancer backend address pools."]
    #[serde(rename = "loadBalancerBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_address_pools: Vec<SubResource>,
    #[doc = "The load balancer inbound nat pools."]
    #[serde(rename = "loadBalancerInboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_inbound_nat_pools: Vec<SubResource>,
}
impl VirtualMachineScaleSetIpConfigurationProperties {
    pub fn new(subnet: ApiEntityReference) -> Self {
        Self {
            subnet,
            application_gateway_backend_address_pools: Vec::new(),
            load_balancer_backend_address_pools: Vec::new(),
            load_balancer_inbound_nat_pools: Vec::new(),
        }
    }
}
#[doc = "Identity for the virtual machine scale set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetIdentity {
    #[doc = "The principal id of virtual machine scale set identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The tenant id associated with the virtual machine scale set."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The type of identity used for the virtual machine scale set. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<virtual_machine_scale_set_identity::Type>,
}
impl VirtualMachineScaleSetIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_scale_set_identity {
    use super::*;
    #[doc = "The type of identity used for the virtual machine scale set. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[doc = "The instance view of a virtual machine scale set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetInstanceView {
    #[doc = "Instance view statuses summary for virtual machines of a virtual machine scale set."]
    #[serde(rename = "virtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine: Option<VirtualMachineScaleSetInstanceViewStatusesSummary>,
    #[doc = "The extensions information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineScaleSetVmExtensionsSummary>,
    #[doc = "The resource status information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineScaleSetInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Instance view statuses summary for virtual machines of a virtual machine scale set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetInstanceViewStatusesSummary {
    #[doc = "The extensions information."]
    #[serde(rename = "statusesSummary", default, skip_serializing_if = "Vec::is_empty")]
    pub statuses_summary: Vec<VirtualMachineStatusCodeCount>,
}
impl VirtualMachineScaleSetInstanceViewStatusesSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Virtual Machine operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListResult {
    #[doc = "The list of virtual machine scale sets."]
    pub value: Vec<VirtualMachineScaleSet>,
    #[doc = "The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext() with this to fetch the next page of VMSS."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListResult {
    pub fn new(value: Vec<VirtualMachineScaleSet>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "The Virtual Machine Scale Set List Skus operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListSkusResult {
    #[doc = "The list of skus available for the virtual machine scale set."]
    pub value: Vec<VirtualMachineScaleSetSku>,
    #[doc = "The uri to fetch the next page of Virtual Machine Scale Set Skus. Call ListNext() with this to fetch the next page of VMSS Skus."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListSkusResult {
    pub fn new(value: Vec<VirtualMachineScaleSetSku>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "The List Virtual Machine operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListWithLinkResult {
    #[doc = "The list of virtual machine scale sets."]
    pub value: Vec<VirtualMachineScaleSet>,
    #[doc = "The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext() with this to fetch the next page of Virtual Machine Scale Sets."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListWithLinkResult {
    pub fn new(value: Vec<VirtualMachineScaleSet>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Describes a virtual machine scale set network profile's network configurations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetNetworkConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "The network configuration name."]
    pub name: String,
    #[doc = "Describes a virtual machine scale set network profile's IP configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetNetworkConfigurationProperties>,
}
impl VirtualMachineScaleSetNetworkConfiguration {
    pub fn new(name: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            name,
            properties: None,
        }
    }
}
#[doc = "Describes a virtual machine scale set network profile's IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetNetworkConfigurationProperties {
    #[doc = "Whether this is a primary NIC on a virtual machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[doc = "The virtual machine scale set IP Configuration."]
    #[serde(rename = "ipConfigurations")]
    pub ip_configurations: Vec<VirtualMachineScaleSetIpConfiguration>,
}
impl VirtualMachineScaleSetNetworkConfigurationProperties {
    pub fn new(ip_configurations: Vec<VirtualMachineScaleSetIpConfiguration>) -> Self {
        Self {
            primary: None,
            ip_configurations,
        }
    }
}
#[doc = "Describes a virtual machine scale set network profile."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetNetworkProfile {
    #[doc = "The list of network configurations."]
    #[serde(rename = "networkInterfaceConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interface_configurations: Vec<VirtualMachineScaleSetNetworkConfiguration>,
}
impl VirtualMachineScaleSetNetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a virtual machine scale set operating system disk."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetOsDisk {
    #[doc = "The disk name."]
    pub name: String,
    #[doc = "Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[doc = "Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described."]
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[doc = "This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**"]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<virtual_machine_scale_set_os_disk::OsType>,
    #[doc = "Describes the uri of a disk."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[doc = "The list of virtual hard disk container uris."]
    #[serde(rename = "vhdContainers", default, skip_serializing_if = "Vec::is_empty")]
    pub vhd_containers: Vec<String>,
}
impl VirtualMachineScaleSetOsDisk {
    pub fn new(name: String, create_option: CreateOption) -> Self {
        Self {
            name,
            caching: None,
            create_option,
            os_type: None,
            image: None,
            vhd_containers: Vec::new(),
        }
    }
}
pub mod virtual_machine_scale_set_os_disk {
    use super::*;
    #[doc = "This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[doc = "Describes a virtual machine scale set OS profile."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetOsProfile {
    #[doc = "Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long."]
    #[serde(rename = "computerNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub computer_name_prefix: Option<String>,
    #[doc = "Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in \".\" <br><br> **Disallowed values:** \"administrator\", \"admin\", \"user\", \"user1\", \"test\", \"user2\", \"test1\", \"user3\", \"admin1\", \"1\", \"123\", \"a\", \"actuser\", \"adm\", \"admin2\", \"aspnet\", \"backup\", \"console\", \"david\", \"guest\", \"john\", \"owner\", \"root\", \"server\", \"sql\", \"support\", \"support_388945a0\", \"sys\", \"test2\", \"test3\", \"user4\", \"user5\". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)"]
    #[serde(rename = "adminUsername", default, skip_serializing_if = "Option::is_none")]
    pub admin_username: Option<String>,
    #[doc = "Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** \"abc@123\", \"P@$$w0rd\", \"P@ssw0rd\", \"P@ssword123\", \"Pa$$word\", \"pass@word1\", \"Password!\", \"Password1\", \"Password22\", \"iloveyou!\" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)"]
    #[serde(rename = "adminPassword", default, skip_serializing_if = "Option::is_none")]
    pub admin_password: Option<String>,
    #[doc = "A base-64 encoded string of custom data."]
    #[serde(rename = "customData", default, skip_serializing_if = "Option::is_none")]
    pub custom_data: Option<String>,
    #[doc = "Specifies Windows operating system settings on the virtual machine."]
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[doc = "Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)."]
    #[serde(rename = "linuxConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_configuration: Option<LinuxConfiguration>,
    #[doc = "The List of certificates for addition to the VM."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub secrets: Vec<VaultSecretGroup>,
}
impl VirtualMachineScaleSetOsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a Virtual Machine Scale Set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetProperties {
    #[doc = "Describes an upgrade policy - automatic or manual."]
    #[serde(rename = "upgradePolicy", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_policy: Option<UpgradePolicy>,
    #[doc = "Describes a virtual machine scale set virtual machine profile."]
    #[serde(rename = "virtualMachineProfile", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_profile: Option<VirtualMachineScaleSetVmProfile>,
    #[doc = "The provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Specifies whether the Virtual Machine Scale Set should be overprovisioned."]
    #[serde(rename = "overProvision", default, skip_serializing_if = "Option::is_none")]
    pub over_provision: Option<bool>,
}
impl VirtualMachineScaleSetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes an available virtual machine scale set sku."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetSku {
    #[doc = "The type of resource the sku applies to."]
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[doc = "Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Describes scaling information of a sku."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<VirtualMachineScaleSetSkuCapacity>,
}
impl VirtualMachineScaleSetSku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes scaling information of a sku."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetSkuCapacity {
    #[doc = "The minimum capacity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<i64>,
    #[doc = "The maximum capacity that can be set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i64>,
    #[doc = "The default capacity."]
    #[serde(rename = "defaultCapacity", default, skip_serializing_if = "Option::is_none")]
    pub default_capacity: Option<i64>,
    #[doc = "The scale type applicable to the sku."]
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<virtual_machine_scale_set_sku_capacity::ScaleType>,
}
impl VirtualMachineScaleSetSkuCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_scale_set_sku_capacity {
    use super::*;
    #[doc = "The scale type applicable to the sku."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScaleType {
        Automatic,
        None,
    }
}
#[doc = "Describes a virtual machine scale set storage profile."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetStorageProfile {
    #[doc = "Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set."]
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<ImageReference>,
    #[doc = "Describes a virtual machine scale set operating system disk."]
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<VirtualMachineScaleSetOsDisk>,
}
impl VirtualMachineScaleSetStorageProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a virtual machine scale set virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetVm {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The virtual machine instance ID."]
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[doc = "Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Describes the properties of a virtual machine scale set virtual machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetVmProperties>,
    #[doc = "Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[doc = "The virtual machine child extension resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<VirtualMachineExtension>,
}
impl VirtualMachineScaleSetVm {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            instance_id: None,
            sku: None,
            properties: None,
            plan: None,
            resources: Vec::new(),
        }
    }
}
#[doc = "Extensions summary for virtual machines of a virtual machine scale set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmExtensionsSummary {
    #[doc = "The extension name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The extensions information."]
    #[serde(rename = "statusesSummary", default, skip_serializing_if = "Vec::is_empty")]
    pub statuses_summary: Vec<VirtualMachineStatusCodeCount>,
}
impl VirtualMachineScaleSetVmExtensionsSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies a list of virtual machine instance IDs from the VM scale set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmInstanceIDs {
    #[doc = "The virtual machine scale set instance ids. Omitting the virtual machine scale set instance ids will result in the operation being performed on all virtual machines in the virtual machine scale set."]
    #[serde(rename = "instanceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub instance_ids: Vec<String>,
}
impl VirtualMachineScaleSetVmInstanceIDs {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies a list of virtual machine instance IDs from the VM scale set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetVmInstanceRequiredIDs {
    #[doc = "The virtual machine scale set instance ids."]
    #[serde(rename = "instanceIds")]
    pub instance_ids: Vec<String>,
}
impl VirtualMachineScaleSetVmInstanceRequiredIDs {
    pub fn new(instance_ids: Vec<String>) -> Self {
        Self { instance_ids }
    }
}
#[doc = "The instance view of a virtual machine scale set VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmInstanceView {
    #[doc = "The Update Domain count."]
    #[serde(rename = "platformUpdateDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_update_domain: Option<i32>,
    #[doc = "The Fault Domain count."]
    #[serde(rename = "platformFaultDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain: Option<i32>,
    #[doc = "The Remote desktop certificate thumbprint."]
    #[serde(rename = "rdpThumbPrint", default, skip_serializing_if = "Option::is_none")]
    pub rdp_thumb_print: Option<String>,
    #[doc = "The instance view of the VM Agent running on the virtual machine."]
    #[serde(rename = "vmAgent", default, skip_serializing_if = "Option::is_none")]
    pub vm_agent: Option<VirtualMachineAgentInstanceView>,
    #[doc = "The disks information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<DiskInstanceView>,
    #[doc = "The extensions information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineExtensionInstanceView>,
    #[doc = "The instance view of a virtual machine boot diagnostics."]
    #[serde(rename = "bootDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub boot_diagnostics: Option<BootDiagnosticsInstanceView>,
    #[doc = "The resource status information."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineScaleSetVmInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Virtual Machine Scale Set VMs operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetVmListResult {
    #[doc = "The list of virtual machine scale sets VMs."]
    pub value: Vec<VirtualMachineScaleSetVm>,
    #[doc = "The uri to fetch the next page of Virtual Machine Scale Set VMs. Call ListNext() with this to fetch the next page of VMSS VMs"]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetVmListResult {
    pub fn new(value: Vec<VirtualMachineScaleSetVm>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Describes a virtual machine scale set virtual machine profile."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmProfile {
    #[doc = "Describes a virtual machine scale set OS profile."]
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<VirtualMachineScaleSetOsProfile>,
    #[doc = "Describes a virtual machine scale set storage profile."]
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<VirtualMachineScaleSetStorageProfile>,
    #[doc = "Describes a virtual machine scale set network profile."]
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<VirtualMachineScaleSetNetworkProfile>,
    #[doc = "Describes a virtual machine scale set extension profile."]
    #[serde(rename = "extensionProfile", default, skip_serializing_if = "Option::is_none")]
    pub extension_profile: Option<VirtualMachineScaleSetExtensionProfile>,
}
impl VirtualMachineScaleSetVmProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a virtual machine scale set virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmProperties {
    #[doc = "Specifies whether the latest model has been applied to the virtual machine."]
    #[serde(rename = "latestModelApplied", default, skip_serializing_if = "Option::is_none")]
    pub latest_model_applied: Option<bool>,
    #[doc = "Azure VM unique ID."]
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[doc = "The instance view of a virtual machine scale set VM."]
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineScaleSetVmInstanceView>,
    #[doc = "Specifies the hardware settings for the virtual machine."]
    #[serde(rename = "hardwareProfile", default, skip_serializing_if = "Option::is_none")]
    pub hardware_profile: Option<HardwareProfile>,
    #[doc = "Specifies the storage settings for the virtual machine disks."]
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<StorageProfile>,
    #[doc = "Specifies the operating system settings for the virtual machine."]
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<OsProfile>,
    #[doc = "Specifies the network interfaces of the virtual machine."]
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<NetworkProfile>,
    #[doc = "Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15."]
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<DiagnosticsProfile>,
    #[serde(rename = "availabilitySet", default, skip_serializing_if = "Option::is_none")]
    pub availability_set: Option<SubResource>,
    #[doc = "The provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Specifies that the image or disk that is being used was licensed on-premises. This element is only used for images that contain the Windows Server operating system. <br><br> Possible values are: <br><br> Windows_Client <br><br> Windows_Server <br><br> If this element is included in a request for an update, the value must match the initial value. This value cannot be updated. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> Minimum api-version: 2015-06-15"]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
}
impl VirtualMachineScaleSetVmProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a VM size."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSize {
    #[doc = "The name of the virtual machine size."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The number of cores supported by the virtual machine size."]
    #[serde(rename = "numberOfCores", default, skip_serializing_if = "Option::is_none")]
    pub number_of_cores: Option<i32>,
    #[doc = "The OS disk size, in MB, allowed by the virtual machine size."]
    #[serde(rename = "osDiskSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_size_in_mb: Option<i32>,
    #[doc = "The resource disk size, in MB, allowed by the virtual machine size."]
    #[serde(rename = "resourceDiskSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub resource_disk_size_in_mb: Option<i32>,
    #[doc = "The amount of memory, in MB, supported by the virtual machine size."]
    #[serde(rename = "memoryInMB", default, skip_serializing_if = "Option::is_none")]
    pub memory_in_mb: Option<i32>,
    #[doc = "The maximum number of data disks that can be attached to the virtual machine size."]
    #[serde(rename = "maxDataDiskCount", default, skip_serializing_if = "Option::is_none")]
    pub max_data_disk_count: Option<i32>,
}
impl VirtualMachineSize {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Virtual Machine operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSizeListResult {
    #[doc = "The list of virtual machine sizes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualMachineSize>,
}
impl VirtualMachineSizeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The status code and count of the virtual machine scale set instance view status summary."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineStatusCodeCount {
    #[doc = "The instance view status code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The number of instances having a particular status code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
}
impl VirtualMachineStatusCodeCount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes Windows Remote Management configuration of the VM"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WinRmConfiguration {
    #[doc = "The list of Windows Remote Management listeners"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub listeners: Vec<WinRmListener>,
}
impl WinRmConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes Protocol and thumbprint of Windows Remote Management listener"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WinRmListener {
    #[doc = "Specifies the protocol of listener. <br><br> Possible values are: <br>**http** <br><br> **https**"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<win_rm_listener::Protocol>,
    #[doc = "This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  \"data\":\"<Base64-encoded-certificate>\",<br>  \"dataType\":\"pfx\",<br>  \"password\":\"<pfx-file-password>\"<br>}"]
    #[serde(rename = "certificateUrl", default, skip_serializing_if = "Option::is_none")]
    pub certificate_url: Option<String>,
}
impl WinRmListener {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod win_rm_listener {
    use super::*;
    #[doc = "Specifies the protocol of listener. <br><br> Possible values are: <br>**http** <br><br> **https**"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Https,
    }
}
#[doc = "Specifies Windows operating system settings on the virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WindowsConfiguration {
    #[doc = "Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later."]
    #[serde(rename = "provisionVMAgent", default, skip_serializing_if = "Option::is_none")]
    pub provision_vm_agent: Option<bool>,
    #[doc = "Indicates whether virtual machine is enabled for automatic updates."]
    #[serde(rename = "enableAutomaticUpdates", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_updates: Option<bool>,
    #[doc = "Specifies the time zone of the virtual machine. e.g. \"Pacific Standard Time\""]
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[doc = "Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup."]
    #[serde(rename = "additionalUnattendContent", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_unattend_content: Vec<AdditionalUnattendContent>,
    #[doc = "Describes Windows Remote Management configuration of the VM"]
    #[serde(rename = "winRM", default, skip_serializing_if = "Option::is_none")]
    pub win_rm: Option<WinRmConfiguration>,
}
impl WindowsConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
