#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Api error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiError {
    #[doc = "The Api error details"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ApiErrorBase>,
    #[doc = "Inner error details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub innererror: Option<InnerError>,
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The target of the particular error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ApiError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Api error base."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiErrorBase {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The target of the particular error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ApiErrorBase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response from the Compute service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "Api error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information of community gallery if current gallery is shared to community"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CommunityGalleryInfo {
    #[doc = "Community gallery publisher uri"]
    #[serde(rename = "publisherUri", default, skip_serializing_if = "Option::is_none")]
    pub publisher_uri: Option<String>,
    #[doc = "Community gallery publisher contact email"]
    #[serde(rename = "publisherContact", default, skip_serializing_if = "Option::is_none")]
    pub publisher_contact: Option<String>,
    #[doc = "Community gallery publisher eula"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub eula: Option<String>,
    #[doc = "Community gallery public name prefix"]
    #[serde(rename = "publicNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub public_name_prefix: Option<String>,
    #[doc = "Contains info about whether community gallery sharing is enabled."]
    #[serde(rename = "communityGalleryEnabled", default, skip_serializing_if = "Option::is_none")]
    pub community_gallery_enabled: Option<bool>,
    #[doc = "Community gallery public name list."]
    #[serde(rename = "publicNames", default, skip_serializing_if = "Vec::is_empty")]
    pub public_names: Vec<String>,
}
impl CommunityGalleryInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains encryption settings for a data disk image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataDiskImageEncryption {
    #[serde(flatten)]
    pub disk_image_encryption: DiskImageEncryption,
    #[doc = "This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine."]
    pub lun: i32,
}
impl DataDiskImageEncryption {
    pub fn new(lun: i32) -> Self {
        Self {
            disk_image_encryption: DiskImageEncryption::default(),
            lun,
        }
    }
}
#[doc = "Describes the disallowed disk types."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Disallowed {
    #[doc = "A list of disk types."]
    #[serde(rename = "diskTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_types: Vec<String>,
}
impl Disallowed {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This is the disk image encryption base class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskImageEncryption {
    #[doc = "A relative URI containing the resource ID of the disk encryption set."]
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
}
impl DiskImageEncryption {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionImages {
    #[doc = "Contains encryption settings for an OS disk image."]
    #[serde(rename = "osDiskImage", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_image: Option<OsDiskImageEncryption>,
    #[doc = "A list of encryption specifications for data disk images."]
    #[serde(rename = "dataDiskImages", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disk_images: Vec<DataDiskImageEncryption>,
}
impl EncryptionImages {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies information about the Shared Image Gallery that you want to create or update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gallery {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes the properties of a Shared Image Gallery."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryProperties>,
}
impl Gallery {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "Specifies information about the gallery Application Definition that you want to create or update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryApplication {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes the properties of a gallery Application Definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryApplicationProperties>,
}
impl GalleryApplication {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The List Gallery Applications operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryApplicationList {
    #[doc = "A list of Gallery Applications."]
    pub value: Vec<GalleryApplication>,
    #[doc = "The uri to fetch the next page of Application Definitions in the Application Gallery. Call ListNext() with this to fetch the next page of gallery Application Definitions."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GalleryApplicationList {
    pub fn new(value: Vec<GalleryApplication>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Describes the properties of a gallery Application Definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryApplicationProperties {
    #[doc = "The description of this gallery Application Definition resource. This property is updatable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The Eula agreement for the gallery Application Definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub eula: Option<String>,
    #[doc = "The privacy statement uri."]
    #[serde(rename = "privacyStatementUri", default, skip_serializing_if = "Option::is_none")]
    pub privacy_statement_uri: Option<String>,
    #[doc = "The release note uri."]
    #[serde(rename = "releaseNoteUri", default, skip_serializing_if = "Option::is_none")]
    pub release_note_uri: Option<String>,
    #[doc = "The end of life date of the gallery Application Definition. This property can be used for decommissioning purposes. This property is updatable."]
    #[serde(rename = "endOfLifeDate", default, skip_serializing_if = "Option::is_none")]
    pub end_of_life_date: Option<String>,
    #[doc = "This property allows you to specify the supported type of the OS that application is built for. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**"]
    #[serde(rename = "supportedOSType")]
    pub supported_os_type: gallery_application_properties::SupportedOsType,
}
impl GalleryApplicationProperties {
    pub fn new(supported_os_type: gallery_application_properties::SupportedOsType) -> Self {
        Self {
            description: None,
            eula: None,
            privacy_statement_uri: None,
            release_note_uri: None,
            end_of_life_date: None,
            supported_os_type,
        }
    }
}
pub mod gallery_application_properties {
    use super::*;
    #[doc = "This property allows you to specify the supported type of the OS that application is built for. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SupportedOsType {
        Windows,
        Linux,
    }
}
#[doc = "Specifies information about the gallery Application Definition that you want to update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryApplicationUpdate {
    #[serde(flatten)]
    pub update_resource_definition: UpdateResourceDefinition,
    #[doc = "Describes the properties of a gallery Application Definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryApplicationProperties>,
}
impl GalleryApplicationUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies information about the gallery Application Version that you want to create or update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryApplicationVersion {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes the properties of a gallery image version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryApplicationVersionProperties>,
}
impl GalleryApplicationVersion {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The List Gallery Application version operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryApplicationVersionList {
    #[doc = "A list of gallery Application Versions."]
    pub value: Vec<GalleryApplicationVersion>,
    #[doc = "The uri to fetch the next page of gallery Application Versions. Call ListNext() with this to fetch the next page of gallery Application Versions."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GalleryApplicationVersionList {
    pub fn new(value: Vec<GalleryApplicationVersion>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Describes the properties of a gallery image version."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryApplicationVersionProperties {
    #[doc = "The publishing profile of a gallery image version."]
    #[serde(rename = "publishingProfile")]
    pub publishing_profile: GalleryApplicationVersionPublishingProfile,
    #[doc = "The provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<gallery_application_version_properties::ProvisioningState>,
    #[doc = "This is the replication status of the gallery image version."]
    #[serde(rename = "replicationStatus", default, skip_serializing_if = "Option::is_none")]
    pub replication_status: Option<ReplicationStatus>,
}
impl GalleryApplicationVersionProperties {
    pub fn new(publishing_profile: GalleryApplicationVersionPublishingProfile) -> Self {
        Self {
            publishing_profile,
            provisioning_state: None,
            replication_status: None,
        }
    }
}
pub mod gallery_application_version_properties {
    use super::*;
    #[doc = "The provisioning state, which only appears in the response."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Failed,
        Succeeded,
        Deleting,
        Migrating,
    }
}
#[doc = "The publishing profile of a gallery image version."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryApplicationVersionPublishingProfile {
    #[serde(flatten)]
    pub gallery_artifact_publishing_profile_base: GalleryArtifactPublishingProfileBase,
    #[doc = "The source image from which the Image Version is going to be created."]
    pub source: UserArtifactSource,
    #[serde(rename = "manageActions", default, skip_serializing_if = "Option::is_none")]
    pub manage_actions: Option<UserArtifactManage>,
    #[doc = "Optional. Whether or not this application reports health."]
    #[serde(rename = "enableHealthCheck", default, skip_serializing_if = "Option::is_none")]
    pub enable_health_check: Option<bool>,
}
impl GalleryApplicationVersionPublishingProfile {
    pub fn new(source: UserArtifactSource) -> Self {
        Self {
            gallery_artifact_publishing_profile_base: GalleryArtifactPublishingProfileBase::default(),
            source,
            manage_actions: None,
            enable_health_check: None,
        }
    }
}
#[doc = "Specifies information about the gallery Application Version that you want to update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryApplicationVersionUpdate {
    #[serde(flatten)]
    pub update_resource_definition: UpdateResourceDefinition,
    #[doc = "Describes the properties of a gallery image version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryApplicationVersionProperties>,
}
impl GalleryApplicationVersionUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the basic gallery artifact publishing profile."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryArtifactPublishingProfileBase {
    #[doc = "The target regions where the Image Version is going to be replicated to. This property is updatable."]
    #[serde(rename = "targetRegions", default, skip_serializing_if = "Vec::is_empty")]
    pub target_regions: Vec<TargetRegion>,
    #[doc = "The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable."]
    #[serde(rename = "replicaCount", default, skip_serializing_if = "Option::is_none")]
    pub replica_count: Option<i32>,
    #[doc = "If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version."]
    #[serde(rename = "excludeFromLatest", default, skip_serializing_if = "Option::is_none")]
    pub exclude_from_latest: Option<bool>,
    #[doc = "The timestamp for when the gallery image version is published."]
    #[serde(rename = "publishedDate", default, skip_serializing_if = "Option::is_none")]
    pub published_date: Option<String>,
    #[doc = "The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable."]
    #[serde(rename = "endOfLifeDate", default, skip_serializing_if = "Option::is_none")]
    pub end_of_life_date: Option<String>,
    #[doc = "Specifies the storage account type to be used to store the image. This property is not updatable."]
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<gallery_artifact_publishing_profile_base::StorageAccountType>,
    #[doc = "Optional parameter which specifies the mode to be used for replication. This property is not updatable."]
    #[serde(rename = "replicationMode", default, skip_serializing_if = "Option::is_none")]
    pub replication_mode: Option<gallery_artifact_publishing_profile_base::ReplicationMode>,
    #[doc = "The target extended locations where the Image Version is going to be replicated to. This property is updatable."]
    #[serde(rename = "targetExtendedLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub target_extended_locations: Vec<GalleryTargetExtendedLocation>,
}
impl GalleryArtifactPublishingProfileBase {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod gallery_artifact_publishing_profile_base {
    use super::*;
    #[doc = "Specifies the storage account type to be used to store the image. This property is not updatable."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageAccountType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Standard_ZRS")]
        StandardZrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
    }
    #[doc = "Optional parameter which specifies the mode to be used for replication. This property is not updatable."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReplicationMode {
        Full,
        Shallow,
    }
}
#[doc = "The source image from which the Image Version is going to be created."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryArtifactSource {
    #[doc = "The managed artifact."]
    #[serde(rename = "managedImage")]
    pub managed_image: ManagedArtifact,
}
impl GalleryArtifactSource {
    pub fn new(managed_image: ManagedArtifact) -> Self {
        Self { managed_image }
    }
}
#[doc = "The gallery artifact version source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryArtifactVersionSource {
    #[doc = "The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The uri of the gallery artifact version source. Currently used to specify vhd/blob source."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
}
impl GalleryArtifactVersionSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This is the data disk image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryDataDiskImage {
    #[serde(flatten)]
    pub gallery_disk_image: GalleryDiskImage,
    #[doc = "This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine."]
    pub lun: i32,
}
impl GalleryDataDiskImage {
    pub fn new(lun: i32) -> Self {
        Self {
            gallery_disk_image: GalleryDiskImage::default(),
            lun,
        }
    }
}
#[doc = "This is the disk image base class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryDiskImage {
    #[doc = "This property indicates the size of the VHD to be created."]
    #[serde(rename = "sizeInGB", default, skip_serializing_if = "Option::is_none")]
    pub size_in_gb: Option<i32>,
    #[doc = "The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'"]
    #[serde(rename = "hostCaching", default, skip_serializing_if = "Option::is_none")]
    pub host_caching: Option<gallery_disk_image::HostCaching>,
    #[doc = "The gallery artifact version source."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<GalleryArtifactVersionSource>,
}
impl GalleryDiskImage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod gallery_disk_image {
    use super::*;
    #[doc = "The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HostCaching {
        None,
        ReadOnly,
        ReadWrite,
    }
}
#[doc = "The name of the extended location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryExtendedLocation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "It is type of the extended location."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<GalleryExtendedLocationType>,
}
impl GalleryExtendedLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "It is type of the extended location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum GalleryExtendedLocationType {
    EdgeZone,
    Unknown,
}
#[doc = "Describes the gallery unique name."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryIdentifier {
    #[doc = "The unique name of the Shared Image Gallery. This name is generated automatically by Azure."]
    #[serde(rename = "uniqueName", default, skip_serializing_if = "Option::is_none")]
    pub unique_name: Option<String>,
}
impl GalleryIdentifier {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies information about the gallery image definition that you want to create or update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryImage {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes the properties of a gallery image definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryImageProperties>,
}
impl GalleryImage {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "A feature for gallery image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageFeature {
    #[doc = "The name of the gallery image feature."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The value of the gallery image feature."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl GalleryImageFeature {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This is the gallery image definition identifier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryImageIdentifier {
    #[doc = "The name of the gallery image definition publisher."]
    pub publisher: String,
    #[doc = "The name of the gallery image definition offer."]
    pub offer: String,
    #[doc = "The name of the gallery image definition SKU."]
    pub sku: String,
}
impl GalleryImageIdentifier {
    pub fn new(publisher: String, offer: String, sku: String) -> Self {
        Self { publisher, offer, sku }
    }
}
#[doc = "The List Gallery Images operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryImageList {
    #[doc = "A list of Shared Image Gallery images."]
    pub value: Vec<GalleryImage>,
    #[doc = "The uri to fetch the next page of Image Definitions in the Shared Image Gallery. Call ListNext() with this to fetch the next page of gallery image definitions."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GalleryImageList {
    pub fn new(value: Vec<GalleryImage>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Describes the properties of a gallery image definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryImageProperties {
    #[doc = "The description of this gallery image definition resource. This property is updatable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The Eula agreement for the gallery image definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub eula: Option<String>,
    #[doc = "The privacy statement uri."]
    #[serde(rename = "privacyStatementUri", default, skip_serializing_if = "Option::is_none")]
    pub privacy_statement_uri: Option<String>,
    #[doc = "The release note uri."]
    #[serde(rename = "releaseNoteUri", default, skip_serializing_if = "Option::is_none")]
    pub release_note_uri: Option<String>,
    #[doc = "This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**"]
    #[serde(rename = "osType")]
    pub os_type: gallery_image_properties::OsType,
    #[doc = "This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'."]
    #[serde(rename = "osState")]
    pub os_state: gallery_image_properties::OsState,
    #[doc = "The hypervisor generation of the Virtual Machine. Applicable to OS disks only."]
    #[serde(rename = "hyperVGeneration", default, skip_serializing_if = "Option::is_none")]
    pub hyper_v_generation: Option<gallery_image_properties::HyperVGeneration>,
    #[doc = "The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property is updatable."]
    #[serde(rename = "endOfLifeDate", default, skip_serializing_if = "Option::is_none")]
    pub end_of_life_date: Option<String>,
    #[doc = "This is the gallery image definition identifier."]
    pub identifier: GalleryImageIdentifier,
    #[doc = "The properties describe the recommended machine configuration for this Image Definition. These properties are updatable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recommended: Option<RecommendedMachineConfiguration>,
    #[doc = "Describes the disallowed disk types."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disallowed: Option<Disallowed>,
    #[doc = "Describes the gallery image definition purchase plan. This is used by marketplace images."]
    #[serde(rename = "purchasePlan", default, skip_serializing_if = "Option::is_none")]
    pub purchase_plan: Option<ImagePurchasePlan>,
    #[doc = "The provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<gallery_image_properties::ProvisioningState>,
    #[doc = "A list of gallery image features."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub features: Vec<GalleryImageFeature>,
    #[doc = "The architecture of the image. Applicable to OS disks only."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub architecture: Option<gallery_image_properties::Architecture>,
}
impl GalleryImageProperties {
    pub fn new(
        os_type: gallery_image_properties::OsType,
        os_state: gallery_image_properties::OsState,
        identifier: GalleryImageIdentifier,
    ) -> Self {
        Self {
            description: None,
            eula: None,
            privacy_statement_uri: None,
            release_note_uri: None,
            os_type,
            os_state,
            hyper_v_generation: None,
            end_of_life_date: None,
            identifier,
            recommended: None,
            disallowed: None,
            purchase_plan: None,
            provisioning_state: None,
            features: Vec::new(),
            architecture: None,
        }
    }
}
pub mod gallery_image_properties {
    use super::*;
    #[doc = "This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
    #[doc = "This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsState {
        Generalized,
        Specialized,
    }
    #[doc = "The hypervisor generation of the Virtual Machine. Applicable to OS disks only."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HyperVGeneration {
        V1,
        V2,
    }
    #[doc = "The provisioning state, which only appears in the response."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Failed,
        Succeeded,
        Deleting,
        Migrating,
    }
    #[doc = "The architecture of the image. Applicable to OS disks only."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Architecture {
        #[serde(rename = "x64")]
        X64,
        Arm64,
    }
}
#[doc = "Specifies information about the gallery image definition that you want to update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageUpdate {
    #[serde(flatten)]
    pub update_resource_definition: UpdateResourceDefinition,
    #[doc = "Describes the properties of a gallery image definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryImageProperties>,
}
impl GalleryImageUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies information about the gallery image version that you want to create or update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryImageVersion {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes the properties of a gallery image version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryImageVersionProperties>,
}
impl GalleryImageVersion {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "The List Gallery Image version operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryImageVersionList {
    #[doc = "A list of gallery image versions."]
    pub value: Vec<GalleryImageVersion>,
    #[doc = "The uri to fetch the next page of gallery image versions. Call ListNext() with this to fetch the next page of gallery image versions."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GalleryImageVersionList {
    pub fn new(value: Vec<GalleryImageVersion>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Describes the properties of a gallery image version."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryImageVersionProperties {
    #[doc = "The publishing profile of a gallery image Version."]
    #[serde(rename = "publishingProfile", default, skip_serializing_if = "Option::is_none")]
    pub publishing_profile: Option<GalleryImageVersionPublishingProfile>,
    #[doc = "The provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<gallery_image_version_properties::ProvisioningState>,
    #[doc = "This is the storage profile of a Gallery Image Version."]
    #[serde(rename = "storageProfile")]
    pub storage_profile: GalleryImageVersionStorageProfile,
    #[doc = "This is the replication status of the gallery image version."]
    #[serde(rename = "replicationStatus", default, skip_serializing_if = "Option::is_none")]
    pub replication_status: Option<ReplicationStatus>,
}
impl GalleryImageVersionProperties {
    pub fn new(storage_profile: GalleryImageVersionStorageProfile) -> Self {
        Self {
            publishing_profile: None,
            provisioning_state: None,
            storage_profile,
            replication_status: None,
        }
    }
}
pub mod gallery_image_version_properties {
    use super::*;
    #[doc = "The provisioning state, which only appears in the response."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Failed,
        Succeeded,
        Deleting,
        Migrating,
    }
}
#[doc = "The publishing profile of a gallery image Version."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageVersionPublishingProfile {
    #[serde(flatten)]
    pub gallery_artifact_publishing_profile_base: GalleryArtifactPublishingProfileBase,
}
impl GalleryImageVersionPublishingProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This is the storage profile of a Gallery Image Version."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageVersionStorageProfile {
    #[doc = "The gallery artifact version source."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<GalleryArtifactVersionSource>,
    #[doc = "This is the OS disk image."]
    #[serde(rename = "osDiskImage", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_image: Option<GalleryOsDiskImage>,
    #[doc = "A list of data disk images."]
    #[serde(rename = "dataDiskImages", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disk_images: Vec<GalleryDataDiskImage>,
}
impl GalleryImageVersionStorageProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies information about the gallery image version that you want to update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryImageVersionUpdate {
    #[serde(flatten)]
    pub update_resource_definition: UpdateResourceDefinition,
    #[doc = "Describes the properties of a gallery image version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryImageVersionProperties>,
}
impl GalleryImageVersionUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Galleries operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GalleryList {
    #[doc = "A list of galleries."]
    pub value: Vec<Gallery>,
    #[doc = "The uri to fetch the next page of galleries. Call ListNext() with this to fetch the next page of galleries."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GalleryList {
    pub fn new(value: Vec<Gallery>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "This is the OS disk image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryOsDiskImage {
    #[serde(flatten)]
    pub gallery_disk_image: GalleryDiskImage,
}
impl GalleryOsDiskImage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a Shared Image Gallery."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryProperties {
    #[doc = "The description of this Shared Image Gallery resource. This property is updatable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Describes the gallery unique name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identifier: Option<GalleryIdentifier>,
    #[doc = "The provisioning state, which only appears in the response."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<gallery_properties::ProvisioningState>,
    #[doc = "Profile for gallery sharing to subscription or tenant"]
    #[serde(rename = "sharingProfile", default, skip_serializing_if = "Option::is_none")]
    pub sharing_profile: Option<SharingProfile>,
    #[doc = "Contains information about the soft deletion policy of the gallery."]
    #[serde(rename = "softDeletePolicy", default, skip_serializing_if = "Option::is_none")]
    pub soft_delete_policy: Option<SoftDeletePolicy>,
    #[doc = "Sharing status of current gallery."]
    #[serde(rename = "sharingStatus", default, skip_serializing_if = "Option::is_none")]
    pub sharing_status: Option<SharingStatus>,
}
impl GalleryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod gallery_properties {
    use super::*;
    #[doc = "The provisioning state, which only appears in the response."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Updating,
        Failed,
        Succeeded,
        Deleting,
        Migrating,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryTargetExtendedLocation {
    #[doc = "The name of the region."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The name of the extended location."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<GalleryExtendedLocation>,
    #[doc = "The number of replicas of the Image Version to be created per extended location. This property is updatable."]
    #[serde(rename = "extendedLocationReplicaCount", default, skip_serializing_if = "Option::is_none")]
    pub extended_location_replica_count: Option<i32>,
    #[doc = "Specifies the storage account type to be used to store the image. This property is not updatable."]
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<gallery_target_extended_location::StorageAccountType>,
    #[doc = "Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionImages>,
}
impl GalleryTargetExtendedLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod gallery_target_extended_location {
    use super::*;
    #[doc = "Specifies the storage account type to be used to store the image. This property is not updatable."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageAccountType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Standard_ZRS")]
        StandardZrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
    }
}
#[doc = "Specifies information about the Shared Image Gallery that you want to update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GalleryUpdate {
    #[serde(flatten)]
    pub update_resource_definition: UpdateResourceDefinition,
    #[doc = "Describes the properties of a Shared Image Gallery."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GalleryProperties>,
}
impl GalleryUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the gallery image definition purchase plan. This is used by marketplace images."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImagePurchasePlan {
    #[doc = "The plan ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The publisher ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[doc = "The product ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub product: Option<String>,
}
impl ImagePurchasePlan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Inner error details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InnerError {
    #[doc = "The exception type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exceptiontype: Option<String>,
    #[doc = "The internal error message or exception dump."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub errordetail: Option<String>,
}
impl InnerError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The managed artifact."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedArtifact {
    #[doc = "The managed artifact id."]
    pub id: String,
}
impl ManagedArtifact {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "Contains encryption settings for an OS disk image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsDiskImageEncryption {
    #[serde(flatten)]
    pub disk_image_encryption: DiskImageEncryption,
    #[doc = "Contains security profile for an OS disk image."]
    #[serde(rename = "securityProfile", default, skip_serializing_if = "Option::is_none")]
    pub security_profile: Option<OsDiskImageSecurityProfile>,
}
impl OsDiskImageEncryption {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains security profile for an OS disk image."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsDiskImageSecurityProfile {
    #[doc = "confidential VM encryption types"]
    #[serde(rename = "confidentialVMEncryptionType", default, skip_serializing_if = "Option::is_none")]
    pub confidential_vm_encryption_type: Option<os_disk_image_security_profile::ConfidentialVmEncryptionType>,
    #[doc = "secure VM disk encryption set id"]
    #[serde(rename = "secureVMDiskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub secure_vm_disk_encryption_set_id: Option<String>,
}
impl OsDiskImageSecurityProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod os_disk_image_security_profile {
    use super::*;
    #[doc = "confidential VM encryption types"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConfidentialVmEncryptionType {
        #[serde(rename = "EncryptedVMGuestStateOnlyWithPmk")]
        EncryptedVmGuestStateOnlyWithPmk,
        EncryptedWithPmk,
        EncryptedWithCmk,
    }
}
#[doc = "The properties describe the recommended machine configuration for this Image Definition. These properties are updatable."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendedMachineConfiguration {
    #[doc = "Describes the resource range."]
    #[serde(rename = "vCPUs", default, skip_serializing_if = "Option::is_none")]
    pub v_cp_us: Option<ResourceRange>,
    #[doc = "Describes the resource range."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub memory: Option<ResourceRange>,
}
impl RecommendedMachineConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This is the regional replication status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegionalReplicationStatus {
    #[doc = "The region to which the gallery image version is being replicated to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "This is the regional replication state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<regional_replication_status::State>,
    #[doc = "The details of the replication status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
    #[doc = "It indicates progress of the replication job."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub progress: Option<i32>,
}
impl RegionalReplicationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod regional_replication_status {
    use super::*;
    #[doc = "This is the regional replication state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Unknown,
        Replicating,
        Completed,
        Failed,
    }
}
#[doc = "Gallery regional sharing status"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegionalSharingStatus {
    #[doc = "Region name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "The sharing state of the gallery, which only appears in the response."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<SharingState>,
    #[doc = "Details of gallery regional sharing failure."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
}
impl RegionalSharingStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This is the replication status of the gallery image version."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationStatus {
    #[doc = "This is the aggregated replication status based on all the regional replication status flags."]
    #[serde(rename = "aggregatedState", default, skip_serializing_if = "Option::is_none")]
    pub aggregated_state: Option<replication_status::AggregatedState>,
    #[doc = "This is a summary of replication status for each region."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub summary: Vec<RegionalReplicationStatus>,
}
impl ReplicationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod replication_status {
    use super::*;
    #[doc = "This is the aggregated replication status based on all the regional replication status flags."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AggregatedState {
        Unknown,
        InProgress,
        Completed,
        Failed,
    }
}
#[doc = "The Resource model definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[doc = "Describes the resource range."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceRange {
    #[doc = "The minimum number of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub min: Option<i32>,
    #[doc = "The maximum number of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub max: Option<i32>,
}
impl ResourceRange {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Profile for gallery sharing to subscription or tenant"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharingProfile {
    #[doc = "This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub permissions: Option<sharing_profile::Permissions>,
    #[doc = "A list of sharing profile groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groups: Vec<SharingProfileGroup>,
    #[doc = "Information of community gallery if current gallery is shared to community."]
    #[serde(rename = "communityGalleryInfo", default, skip_serializing_if = "Option::is_none")]
    pub community_gallery_info: Option<serde_json::Value>,
}
impl SharingProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sharing_profile {
    use super::*;
    #[doc = "This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Permissions {
        Private,
        Groups,
    }
}
#[doc = "Group of the gallery sharing profile"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharingProfileGroup {
    #[doc = "This property allows you to specify the type of sharing group. <br><br> Possible values are: <br><br> **Subscriptions** <br><br> **AADTenants** <br><br> **Community**"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<sharing_profile_group::Type>,
    #[doc = "A list of subscription/tenant ids the gallery is aimed to be shared to."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub ids: Vec<String>,
}
impl SharingProfileGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sharing_profile_group {
    use super::*;
    #[doc = "This property allows you to specify the type of sharing group. <br><br> Possible values are: <br><br> **Subscriptions** <br><br> **AADTenants** <br><br> **Community**"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Subscriptions,
        #[serde(rename = "AADTenants")]
        AadTenants,
        Community,
    }
}
#[doc = "The sharing state of the gallery, which only appears in the response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SharingState {
    Succeeded,
    InProgress,
    Failed,
    Unknown,
}
#[doc = "Sharing status of current gallery."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharingStatus {
    #[doc = "The sharing state of the gallery, which only appears in the response."]
    #[serde(rename = "aggregatedState", default, skip_serializing_if = "Option::is_none")]
    pub aggregated_state: Option<SharingState>,
    #[doc = "Summary of all regional sharing status."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub summary: Vec<RegionalSharingStatus>,
}
impl SharingStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies information about the gallery sharing profile update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharingUpdate {
    #[doc = "This property allows you to specify the operation type of gallery sharing update. <br><br> Possible values are: <br><br> **Add** <br><br> **Remove** <br><br> **Reset**"]
    #[serde(rename = "operationType")]
    pub operation_type: sharing_update::OperationType,
    #[doc = "A list of sharing profile groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groups: Vec<SharingProfileGroup>,
}
impl SharingUpdate {
    pub fn new(operation_type: sharing_update::OperationType) -> Self {
        Self {
            operation_type,
            groups: Vec::new(),
        }
    }
}
pub mod sharing_update {
    use super::*;
    #[doc = "This property allows you to specify the operation type of gallery sharing update. <br><br> Possible values are: <br><br> **Add** <br><br> **Remove** <br><br> **Reset**"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationType {
        Add,
        Remove,
        Reset,
        EnableCommunity,
    }
}
#[doc = "Contains information about the soft deletion policy of the gallery."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SoftDeletePolicy {
    #[doc = "Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time."]
    #[serde(rename = "isSoftDeleteEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_soft_delete_enabled: Option<bool>,
}
impl SoftDeletePolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the target region information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TargetRegion {
    #[doc = "The name of the region."]
    pub name: String,
    #[doc = "The number of replicas of the Image Version to be created per region. This property is updatable."]
    #[serde(rename = "regionalReplicaCount", default, skip_serializing_if = "Option::is_none")]
    pub regional_replica_count: Option<i32>,
    #[doc = "Specifies the storage account type to be used to store the image. This property is not updatable."]
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<target_region::StorageAccountType>,
    #[doc = "Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionImages>,
}
impl TargetRegion {
    pub fn new(name: String) -> Self {
        Self {
            name,
            regional_replica_count: None,
            storage_account_type: None,
            encryption: None,
        }
    }
}
pub mod target_region {
    use super::*;
    #[doc = "Specifies the storage account type to be used to store the image. This property is not updatable."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageAccountType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Standard_ZRS")]
        StandardZrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
    }
}
#[doc = "The Update Resource model definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateResourceDefinition {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl UpdateResourceDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserArtifactManage {
    #[doc = "Required. The path and arguments to install the gallery application. This is limited to 4096 characters."]
    pub install: String,
    #[doc = "Required. The path and arguments to remove the gallery application. This is limited to 4096 characters."]
    pub remove: String,
    #[doc = "Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub update: Option<String>,
}
impl UserArtifactManage {
    pub fn new(install: String, remove: String) -> Self {
        Self {
            install,
            remove,
            update: None,
        }
    }
}
#[doc = "The source image from which the Image Version is going to be created."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserArtifactSource {
    #[doc = "Required. The mediaLink of the artifact, must be a readable storage page blob."]
    #[serde(rename = "mediaLink")]
    pub media_link: String,
    #[doc = "Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob."]
    #[serde(rename = "defaultConfigurationLink", default, skip_serializing_if = "Option::is_none")]
    pub default_configuration_link: Option<String>,
}
impl UserArtifactSource {
    pub fn new(media_link: String) -> Self {
        Self {
            media_link,
            default_configuration_link: None,
        }
    }
}
