#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerService {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContainerServiceProperties>,
}
impl ContainerService {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceAgentPoolProfile {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "vmSize")]
    pub vm_size: container_service_agent_pool_profile::VmSize,
    #[serde(rename = "dnsPrefix")]
    pub dns_prefix: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
}
impl ContainerServiceAgentPoolProfile {
    pub fn new(name: String, vm_size: container_service_agent_pool_profile::VmSize, dns_prefix: String) -> Self {
        Self {
            name,
            count: None,
            vm_size,
            dns_prefix,
            fqdn: None,
        }
    }
}
pub mod container_service_agent_pool_profile {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VmSize {
        #[serde(rename = "Standard_A0")]
        StandardA0,
        #[serde(rename = "Standard_A1")]
        StandardA1,
        #[serde(rename = "Standard_A2")]
        StandardA2,
        #[serde(rename = "Standard_A3")]
        StandardA3,
        #[serde(rename = "Standard_A4")]
        StandardA4,
        #[serde(rename = "Standard_A5")]
        StandardA5,
        #[serde(rename = "Standard_A6")]
        StandardA6,
        #[serde(rename = "Standard_A7")]
        StandardA7,
        #[serde(rename = "Standard_A8")]
        StandardA8,
        #[serde(rename = "Standard_A9")]
        StandardA9,
        #[serde(rename = "Standard_A10")]
        StandardA10,
        #[serde(rename = "Standard_A11")]
        StandardA11,
        #[serde(rename = "Standard_D1")]
        StandardD1,
        #[serde(rename = "Standard_D2")]
        StandardD2,
        #[serde(rename = "Standard_D3")]
        StandardD3,
        #[serde(rename = "Standard_D4")]
        StandardD4,
        #[serde(rename = "Standard_D11")]
        StandardD11,
        #[serde(rename = "Standard_D12")]
        StandardD12,
        #[serde(rename = "Standard_D13")]
        StandardD13,
        #[serde(rename = "Standard_D14")]
        StandardD14,
        #[serde(rename = "Standard_D1_v2")]
        StandardD1V2,
        #[serde(rename = "Standard_D2_v2")]
        StandardD2V2,
        #[serde(rename = "Standard_D3_v2")]
        StandardD3V2,
        #[serde(rename = "Standard_D4_v2")]
        StandardD4V2,
        #[serde(rename = "Standard_D5_v2")]
        StandardD5V2,
        #[serde(rename = "Standard_D11_v2")]
        StandardD11V2,
        #[serde(rename = "Standard_D12_v2")]
        StandardD12V2,
        #[serde(rename = "Standard_D13_v2")]
        StandardD13V2,
        #[serde(rename = "Standard_D14_v2")]
        StandardD14V2,
        #[serde(rename = "Standard_G1")]
        StandardG1,
        #[serde(rename = "Standard_G2")]
        StandardG2,
        #[serde(rename = "Standard_G3")]
        StandardG3,
        #[serde(rename = "Standard_G4")]
        StandardG4,
        #[serde(rename = "Standard_G5")]
        StandardG5,
        #[serde(rename = "Standard_DS1")]
        StandardDs1,
        #[serde(rename = "Standard_DS2")]
        StandardDs2,
        #[serde(rename = "Standard_DS3")]
        StandardDs3,
        #[serde(rename = "Standard_DS4")]
        StandardDs4,
        #[serde(rename = "Standard_DS11")]
        StandardDs11,
        #[serde(rename = "Standard_DS12")]
        StandardDs12,
        #[serde(rename = "Standard_DS13")]
        StandardDs13,
        #[serde(rename = "Standard_DS14")]
        StandardDs14,
        #[serde(rename = "Standard_GS1")]
        StandardGs1,
        #[serde(rename = "Standard_GS2")]
        StandardGs2,
        #[serde(rename = "Standard_GS3")]
        StandardGs3,
        #[serde(rename = "Standard_GS4")]
        StandardGs4,
        #[serde(rename = "Standard_GS5")]
        StandardGs5,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceDiagnosticsProfile {
    #[serde(rename = "vmDiagnostics")]
    pub vm_diagnostics: ContainerServiceVmDiagnostics,
}
impl ContainerServiceDiagnosticsProfile {
    pub fn new(vm_diagnostics: ContainerServiceVmDiagnostics) -> Self {
        Self { vm_diagnostics }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceLinuxProfile {
    #[serde(rename = "adminUsername")]
    pub admin_username: String,
    pub ssh: ContainerServiceSshConfiguration,
}
impl ContainerServiceLinuxProfile {
    pub fn new(admin_username: String, ssh: ContainerServiceSshConfiguration) -> Self {
        Self { admin_username, ssh }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerServiceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ContainerService>,
}
impl ContainerServiceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceMasterProfile {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<container_service_master_profile::Count>,
    #[serde(rename = "dnsPrefix")]
    pub dns_prefix: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
}
impl ContainerServiceMasterProfile {
    pub fn new(dns_prefix: String) -> Self {
        Self {
            count: None,
            dns_prefix,
            fqdn: None,
        }
    }
}
pub mod container_service_master_profile {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Count {}
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceOrchestratorProfile {
    #[serde(rename = "orchestratorType")]
    pub orchestrator_type: container_service_orchestrator_profile::OrchestratorType,
}
impl ContainerServiceOrchestratorProfile {
    pub fn new(orchestrator_type: container_service_orchestrator_profile::OrchestratorType) -> Self {
        Self { orchestrator_type }
    }
}
pub mod container_service_orchestrator_profile {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OrchestratorType {
        Swarm,
        #[serde(rename = "DCOS")]
        Dcos,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "orchestratorProfile", default, skip_serializing_if = "Option::is_none")]
    pub orchestrator_profile: Option<ContainerServiceOrchestratorProfile>,
    #[serde(rename = "masterProfile")]
    pub master_profile: ContainerServiceMasterProfile,
    #[serde(rename = "agentPoolProfiles")]
    pub agent_pool_profiles: Vec<ContainerServiceAgentPoolProfile>,
    #[serde(rename = "windowsProfile", default, skip_serializing_if = "Option::is_none")]
    pub windows_profile: Option<ContainerServiceWindowsProfile>,
    #[serde(rename = "linuxProfile")]
    pub linux_profile: ContainerServiceLinuxProfile,
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<ContainerServiceDiagnosticsProfile>,
}
impl ContainerServiceProperties {
    pub fn new(
        master_profile: ContainerServiceMasterProfile,
        agent_pool_profiles: Vec<ContainerServiceAgentPoolProfile>,
        linux_profile: ContainerServiceLinuxProfile,
    ) -> Self {
        Self {
            provisioning_state: None,
            orchestrator_profile: None,
            master_profile,
            agent_pool_profiles,
            windows_profile: None,
            linux_profile,
            diagnostics_profile: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceSshConfiguration {
    #[serde(rename = "publicKeys")]
    pub public_keys: Vec<ContainerServiceSshPublicKey>,
}
impl ContainerServiceSshConfiguration {
    pub fn new(public_keys: Vec<ContainerServiceSshPublicKey>) -> Self {
        Self { public_keys }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceSshPublicKey {
    #[serde(rename = "keyData")]
    pub key_data: String,
}
impl ContainerServiceSshPublicKey {
    pub fn new(key_data: String) -> Self {
        Self { key_data }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceVmDiagnostics {
    pub enabled: bool,
    #[serde(rename = "storageUri", default, skip_serializing_if = "Option::is_none")]
    pub storage_uri: Option<String>,
}
impl ContainerServiceVmDiagnostics {
    pub fn new(enabled: bool) -> Self {
        Self {
            enabled,
            storage_uri: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerServiceWindowsProfile {
    #[serde(rename = "adminUsername")]
    pub admin_username: String,
    #[serde(rename = "adminPassword")]
    pub admin_password: String,
}
impl ContainerServiceWindowsProfile {
    pub fn new(admin_username: String, admin_password: String) -> Self {
        Self {
            admin_username,
            admin_password,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
