#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessUri {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AccessUriOutput>,
}
impl AccessUri {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessUriOutput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<AccessUriRaw>,
}
impl AccessUriOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessUriRaw {
    #[serde(rename = "accessSAS", default, skip_serializing_if = "Option::is_none")]
    pub access_sas: Option<String>,
}
impl AccessUriRaw {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdditionalUnattendContent {
    #[serde(rename = "passName", default, skip_serializing_if = "Option::is_none")]
    pub pass_name: Option<additional_unattend_content::PassName>,
    #[serde(rename = "componentName", default, skip_serializing_if = "Option::is_none")]
    pub component_name: Option<additional_unattend_content::ComponentName>,
    #[serde(rename = "settingName", default, skip_serializing_if = "Option::is_none")]
    pub setting_name: Option<additional_unattend_content::SettingName>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
}
impl AdditionalUnattendContent {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod additional_unattend_content {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PassName {
        OobeSystem,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComponentName {
        #[serde(rename = "Microsoft-Windows-Shell-Setup")]
        MicrosoftWindowsShellSetup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SettingName {
        AutoLogon,
        FirstLogonCommands,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiEntityReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ApiEntityReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiError {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ApiErrorBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub innererror: Option<InnerError>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ApiError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiErrorBase {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ApiErrorBase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailabilitySet {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AvailabilitySetProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
}
impl AvailabilitySet {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            sku: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailabilitySetListResult {
    pub value: Vec<AvailabilitySet>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailabilitySetListResult {
    pub fn new(value: Vec<AvailabilitySet>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailabilitySetProperties {
    #[serde(rename = "platformUpdateDomainCount", default, skip_serializing_if = "Option::is_none")]
    pub platform_update_domain_count: Option<i32>,
    #[serde(rename = "platformFaultDomainCount", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain_count: Option<i32>,
    #[serde(rename = "virtualMachines", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_machines: Vec<SubResource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub managed: Option<bool>,
}
impl AvailabilitySetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BootDiagnostics {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "storageUri", default, skip_serializing_if = "Option::is_none")]
    pub storage_uri: Option<String>,
}
impl BootDiagnostics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BootDiagnosticsInstanceView {
    #[serde(rename = "consoleScreenshotBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub console_screenshot_blob_uri: Option<String>,
    #[serde(rename = "serialConsoleLogBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub serial_console_log_blob_uri: Option<String>,
}
impl BootDiagnosticsInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Caching {
    None,
    ReadOnly,
    ReadWrite,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeLongRunningOperationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<serde_json::Value>,
}
impl ComputeLongRunningOperationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CreateOption {
    FromImage,
    Empty,
    Attach,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreationData {
    #[serde(rename = "createOption")]
    pub create_option: creation_data::CreateOption,
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<ImageDiskReference>,
    #[serde(rename = "sourceUri", default, skip_serializing_if = "Option::is_none")]
    pub source_uri: Option<String>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
}
impl CreationData {
    pub fn new(create_option: creation_data::CreateOption) -> Self {
        Self {
            create_option,
            storage_account_id: None,
            image_reference: None,
            source_uri: None,
            source_resource_id: None,
        }
    }
}
pub mod creation_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreateOption {
        Empty,
        Attach,
        FromImage,
        Import,
        Copy,
        Restore,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataDisk {
    pub lun: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vhd: Option<VirtualHardDisk>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<ManagedDiskParameters>,
}
impl DataDisk {
    pub fn new(lun: i32, create_option: CreateOption) -> Self {
        Self {
            lun,
            name: None,
            vhd: None,
            image: None,
            caching: None,
            create_option,
            disk_size_gb: None,
            managed_disk: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataDiskImage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub lun: Option<i32>,
}
impl DataDiskImage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticsProfile {
    #[serde(rename = "bootDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub boot_diagnostics: Option<BootDiagnostics>,
}
impl DiagnosticsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Disk {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DiskProperties>,
}
impl Disk {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskEncryptionSettings {
    #[serde(rename = "diskEncryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_key: Option<KeyVaultSecretReference>,
    #[serde(rename = "keyEncryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub key_encryption_key: Option<KeyVaultKeyReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl DiskEncryptionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskInstanceView {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl DiskInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiskList {
    pub value: Vec<Disk>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiskList {
    pub fn new(value: Vec<Disk>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiskProperties {
    #[serde(rename = "accountType", default, skip_serializing_if = "Option::is_none")]
    pub account_type: Option<disk_properties::AccountType>,
    #[serde(rename = "timeCreated", default, skip_serializing_if = "Option::is_none")]
    pub time_created: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<disk_properties::OsType>,
    #[serde(rename = "creationData")]
    pub creation_data: CreationData,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "encryptionSettings", default, skip_serializing_if = "Option::is_none")]
    pub encryption_settings: Option<EncryptionSettings>,
    #[serde(rename = "ownerId", default, skip_serializing_if = "Option::is_none")]
    pub owner_id: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl DiskProperties {
    pub fn new(creation_data: CreationData) -> Self {
        Self {
            account_type: None,
            time_created: None,
            os_type: None,
            creation_data,
            disk_size_gb: None,
            encryption_settings: None,
            owner_id: None,
            provisioning_state: None,
        }
    }
}
pub mod disk_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AccountType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskUpdate {
    #[serde(flatten)]
    pub resource_update: ResourceUpdate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DiskUpdateProperties>,
}
impl DiskUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskUpdateProperties {
    #[serde(rename = "accountType", default, skip_serializing_if = "Option::is_none")]
    pub account_type: Option<disk_update_properties::AccountType>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<disk_update_properties::OsType>,
    #[serde(rename = "creationData", default, skip_serializing_if = "Option::is_none")]
    pub creation_data: Option<CreationData>,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "encryptionSettings", default, skip_serializing_if = "Option::is_none")]
    pub encryption_settings: Option<EncryptionSettings>,
}
impl DiskUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod disk_update_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AccountType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "diskEncryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_key: Option<KeyVaultAndSecretReference>,
    #[serde(rename = "keyEncryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub key_encryption_key: Option<KeyVaultAndKeyReference>,
}
impl EncryptionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GrantAccessData {
    pub access: grant_access_data::Access,
    #[serde(rename = "durationInSeconds")]
    pub duration_in_seconds: i32,
}
impl GrantAccessData {
    pub fn new(access: grant_access_data::Access, duration_in_seconds: i32) -> Self {
        Self {
            access,
            duration_in_seconds,
        }
    }
}
pub mod grant_access_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        None,
        Read,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HardwareProfile {
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<hardware_profile::VmSize>,
}
impl HardwareProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hardware_profile {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VmSize {
        #[serde(rename = "Basic_A0")]
        BasicA0,
        #[serde(rename = "Basic_A1")]
        BasicA1,
        #[serde(rename = "Basic_A2")]
        BasicA2,
        #[serde(rename = "Basic_A3")]
        BasicA3,
        #[serde(rename = "Basic_A4")]
        BasicA4,
        #[serde(rename = "Standard_A0")]
        StandardA0,
        #[serde(rename = "Standard_A1")]
        StandardA1,
        #[serde(rename = "Standard_A2")]
        StandardA2,
        #[serde(rename = "Standard_A3")]
        StandardA3,
        #[serde(rename = "Standard_A4")]
        StandardA4,
        #[serde(rename = "Standard_A5")]
        StandardA5,
        #[serde(rename = "Standard_A6")]
        StandardA6,
        #[serde(rename = "Standard_A7")]
        StandardA7,
        #[serde(rename = "Standard_A8")]
        StandardA8,
        #[serde(rename = "Standard_A9")]
        StandardA9,
        #[serde(rename = "Standard_A10")]
        StandardA10,
        #[serde(rename = "Standard_A11")]
        StandardA11,
        #[serde(rename = "Standard_D1")]
        StandardD1,
        #[serde(rename = "Standard_D2")]
        StandardD2,
        #[serde(rename = "Standard_D3")]
        StandardD3,
        #[serde(rename = "Standard_D4")]
        StandardD4,
        #[serde(rename = "Standard_D11")]
        StandardD11,
        #[serde(rename = "Standard_D12")]
        StandardD12,
        #[serde(rename = "Standard_D13")]
        StandardD13,
        #[serde(rename = "Standard_D14")]
        StandardD14,
        #[serde(rename = "Standard_D1_v2")]
        StandardD1V2,
        #[serde(rename = "Standard_D2_v2")]
        StandardD2V2,
        #[serde(rename = "Standard_D3_v2")]
        StandardD3V2,
        #[serde(rename = "Standard_D4_v2")]
        StandardD4V2,
        #[serde(rename = "Standard_D5_v2")]
        StandardD5V2,
        #[serde(rename = "Standard_D11_v2")]
        StandardD11V2,
        #[serde(rename = "Standard_D12_v2")]
        StandardD12V2,
        #[serde(rename = "Standard_D13_v2")]
        StandardD13V2,
        #[serde(rename = "Standard_D14_v2")]
        StandardD14V2,
        #[serde(rename = "Standard_D15_v2")]
        StandardD15V2,
        #[serde(rename = "Standard_DS1")]
        StandardDs1,
        #[serde(rename = "Standard_DS2")]
        StandardDs2,
        #[serde(rename = "Standard_DS3")]
        StandardDs3,
        #[serde(rename = "Standard_DS4")]
        StandardDs4,
        #[serde(rename = "Standard_DS11")]
        StandardDs11,
        #[serde(rename = "Standard_DS12")]
        StandardDs12,
        #[serde(rename = "Standard_DS13")]
        StandardDs13,
        #[serde(rename = "Standard_DS14")]
        StandardDs14,
        #[serde(rename = "Standard_DS1_v2")]
        StandardDs1V2,
        #[serde(rename = "Standard_DS2_v2")]
        StandardDs2V2,
        #[serde(rename = "Standard_DS3_v2")]
        StandardDs3V2,
        #[serde(rename = "Standard_DS4_v2")]
        StandardDs4V2,
        #[serde(rename = "Standard_DS5_v2")]
        StandardDs5V2,
        #[serde(rename = "Standard_DS11_v2")]
        StandardDs11V2,
        #[serde(rename = "Standard_DS12_v2")]
        StandardDs12V2,
        #[serde(rename = "Standard_DS13_v2")]
        StandardDs13V2,
        #[serde(rename = "Standard_DS14_v2")]
        StandardDs14V2,
        #[serde(rename = "Standard_DS15_v2")]
        StandardDs15V2,
        #[serde(rename = "Standard_G1")]
        StandardG1,
        #[serde(rename = "Standard_G2")]
        StandardG2,
        #[serde(rename = "Standard_G3")]
        StandardG3,
        #[serde(rename = "Standard_G4")]
        StandardG4,
        #[serde(rename = "Standard_G5")]
        StandardG5,
        #[serde(rename = "Standard_GS1")]
        StandardGs1,
        #[serde(rename = "Standard_GS2")]
        StandardGs2,
        #[serde(rename = "Standard_GS3")]
        StandardGs3,
        #[serde(rename = "Standard_GS4")]
        StandardGs4,
        #[serde(rename = "Standard_GS5")]
        StandardGs5,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Image {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ImageProperties>,
}
impl Image {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImageDataDisk {
    pub lun: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub snapshot: Option<SubResource>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<SubResource>,
    #[serde(rename = "blobUri", default, skip_serializing_if = "Option::is_none")]
    pub blob_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<image_data_disk::Caching>,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
}
impl ImageDataDisk {
    pub fn new(lun: i32) -> Self {
        Self {
            lun,
            snapshot: None,
            managed_disk: None,
            blob_uri: None,
            caching: None,
            disk_size_gb: None,
        }
    }
}
pub mod image_data_disk {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Caching {
        None,
        ReadOnly,
        ReadWrite,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImageDiskReference {
    pub id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub lun: Option<i32>,
}
impl ImageDiskReference {
    pub fn new(id: String) -> Self {
        Self { id, lun: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImageListResult {
    pub value: Vec<Image>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ImageListResult {
    pub fn new(value: Vec<Image>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImageOsDisk {
    #[serde(rename = "osType")]
    pub os_type: image_os_disk::OsType,
    #[serde(rename = "osState")]
    pub os_state: image_os_disk::OsState,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub snapshot: Option<SubResource>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<SubResource>,
    #[serde(rename = "blobUri", default, skip_serializing_if = "Option::is_none")]
    pub blob_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<image_os_disk::Caching>,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
}
impl ImageOsDisk {
    pub fn new(os_type: image_os_disk::OsType, os_state: image_os_disk::OsState) -> Self {
        Self {
            os_type,
            os_state,
            snapshot: None,
            managed_disk: None,
            blob_uri: None,
            caching: None,
            disk_size_gb: None,
        }
    }
}
pub mod image_os_disk {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsState {
        Generalized,
        Specialized,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Caching {
        None,
        ReadOnly,
        ReadWrite,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageProperties {
    #[serde(rename = "sourceVirtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub source_virtual_machine: Option<SubResource>,
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<ImageStorageProfile>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ImageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageReference {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl ImageReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImageStorageProfile {
    #[serde(rename = "osDisk")]
    pub os_disk: ImageOsDisk,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<ImageDataDisk>,
}
impl ImageStorageProfile {
    pub fn new(os_disk: ImageOsDisk) -> Self {
        Self {
            os_disk,
            data_disks: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InnerError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exceptiontype: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub errordetail: Option<String>,
}
impl InnerError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstanceViewStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<instance_view_status::Level>,
    #[serde(rename = "displayStatus", default, skip_serializing_if = "Option::is_none")]
    pub display_status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
}
impl InstanceViewStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod instance_view_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Info,
        Warning,
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultAndKeyReference {
    #[serde(rename = "sourceVault")]
    pub source_vault: SourceVault,
    #[serde(rename = "keyUrl")]
    pub key_url: String,
}
impl KeyVaultAndKeyReference {
    pub fn new(source_vault: SourceVault, key_url: String) -> Self {
        Self { source_vault, key_url }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultAndSecretReference {
    #[serde(rename = "sourceVault")]
    pub source_vault: SourceVault,
    #[serde(rename = "secretUrl")]
    pub secret_url: String,
}
impl KeyVaultAndSecretReference {
    pub fn new(source_vault: SourceVault, secret_url: String) -> Self {
        Self { source_vault, secret_url }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultKeyReference {
    #[serde(rename = "keyUrl")]
    pub key_url: String,
    #[serde(rename = "sourceVault")]
    pub source_vault: SubResource,
}
impl KeyVaultKeyReference {
    pub fn new(key_url: String, source_vault: SubResource) -> Self {
        Self { key_url, source_vault }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultSecretReference {
    #[serde(rename = "secretUrl")]
    pub secret_url: String,
    #[serde(rename = "sourceVault")]
    pub source_vault: SubResource,
}
impl KeyVaultSecretReference {
    pub fn new(secret_url: String, source_vault: SubResource) -> Self {
        Self { secret_url, source_vault }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinuxConfiguration {
    #[serde(rename = "disablePasswordAuthentication", default, skip_serializing_if = "Option::is_none")]
    pub disable_password_authentication: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub ssh: Option<SshConfiguration>,
}
impl LinuxConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListUsagesResult {
    pub value: Vec<Usage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListUsagesResult {
    pub fn new(value: Vec<Usage>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedDiskParameters {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<StorageAccountType>,
}
impl ManagedDiskParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceReference {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceReferenceProperties>,
}
impl NetworkInterfaceReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceReferenceProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
}
impl NetworkInterfaceReferenceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProfile {
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterfaceReference>,
}
impl NetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OsDisk {
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<os_disk::OsType>,
    #[serde(rename = "encryptionSettings", default, skip_serializing_if = "Option::is_none")]
    pub encryption_settings: Option<DiskEncryptionSettings>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vhd: Option<VirtualHardDisk>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<ManagedDiskParameters>,
}
impl OsDisk {
    pub fn new(create_option: CreateOption) -> Self {
        Self {
            os_type: None,
            encryption_settings: None,
            name: None,
            vhd: None,
            image: None,
            caching: None,
            create_option,
            disk_size_gb: None,
            managed_disk: None,
        }
    }
}
pub mod os_disk {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OsDiskImage {
    #[serde(rename = "operatingSystem")]
    pub operating_system: os_disk_image::OperatingSystem,
}
impl OsDiskImage {
    pub fn new(operating_system: os_disk_image::OperatingSystem) -> Self {
        Self { operating_system }
    }
}
pub mod os_disk_image {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperatingSystem {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsProfile {
    #[serde(rename = "computerName", default, skip_serializing_if = "Option::is_none")]
    pub computer_name: Option<String>,
    #[serde(rename = "adminUsername", default, skip_serializing_if = "Option::is_none")]
    pub admin_username: Option<String>,
    #[serde(rename = "adminPassword", default, skip_serializing_if = "Option::is_none")]
    pub admin_password: Option<String>,
    #[serde(rename = "customData", default, skip_serializing_if = "Option::is_none")]
    pub custom_data: Option<String>,
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[serde(rename = "linuxConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_configuration: Option<LinuxConfiguration>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub secrets: Vec<VaultSecretGroup>,
}
impl OsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatusResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
}
impl OperationStatusResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Plan {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub product: Option<String>,
    #[serde(rename = "promotionCode", default, skip_serializing_if = "Option::is_none")]
    pub promotion_code: Option<String>,
}
impl Plan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PurchasePlan {
    pub publisher: String,
    pub name: String,
    pub product: String,
}
impl PurchasePlan {
    pub fn new(publisher: String, name: String, product: String) -> Self {
        Self { publisher, name, product }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location: None,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceUpdate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ResourceUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i64>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Snapshot {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DiskProperties>,
}
impl Snapshot {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnapshotList {
    pub value: Vec<Snapshot>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SnapshotList {
    pub fn new(value: Vec<Snapshot>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotUpdate {
    #[serde(flatten)]
    pub resource_update: ResourceUpdate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DiskUpdateProperties>,
}
impl SnapshotUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceVault {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SourceVault {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SshConfiguration {
    #[serde(rename = "publicKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub public_keys: Vec<SshPublicKey>,
}
impl SshConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SshPublicKey {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "keyData", default, skip_serializing_if = "Option::is_none")]
    pub key_data: Option<String>,
}
impl SshPublicKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum StorageAccountType {
    #[serde(rename = "Standard_LRS")]
    StandardLrs,
    #[serde(rename = "Premium_LRS")]
    PremiumLrs,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageProfile {
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<ImageReference>,
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<OsDisk>,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<DataDisk>,
}
impl StorageProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResourceReadOnly {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResourceReadOnly {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl UpdateResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpgradePolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<upgrade_policy::Mode>,
}
impl UpgradePolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod upgrade_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        Automatic,
        Manual,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    pub unit: usage::Unit,
    #[serde(rename = "currentValue")]
    pub current_value: i32,
    pub limit: i64,
    pub name: UsageName,
}
impl Usage {
    pub fn new(unit: usage::Unit, current_value: i32, limit: i64, name: UsageName) -> Self {
        Self {
            unit,
            current_value,
            limit,
            name,
        }
    }
}
pub mod usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultCertificate {
    #[serde(rename = "certificateUrl", default, skip_serializing_if = "Option::is_none")]
    pub certificate_url: Option<String>,
    #[serde(rename = "certificateStore", default, skip_serializing_if = "Option::is_none")]
    pub certificate_store: Option<String>,
}
impl VaultCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultSecretGroup {
    #[serde(rename = "sourceVault", default, skip_serializing_if = "Option::is_none")]
    pub source_vault: Option<SubResource>,
    #[serde(rename = "vaultCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vault_certificates: Vec<VaultCertificate>,
}
impl VaultSecretGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHardDisk {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
}
impl VirtualHardDisk {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachine {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineProperties>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<VirtualMachineExtension>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<VirtualMachineIdentity>,
}
impl VirtualMachine {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            plan: None,
            properties: None,
            resources: Vec::new(),
            identity: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineAgentInstanceView {
    #[serde(rename = "vmAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub vm_agent_version: Option<String>,
    #[serde(rename = "extensionHandlers", default, skip_serializing_if = "Vec::is_empty")]
    pub extension_handlers: Vec<VirtualMachineExtensionHandlerInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineAgentInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineCaptureParameters {
    #[serde(rename = "vhdPrefix")]
    pub vhd_prefix: String,
    #[serde(rename = "destinationContainerName")]
    pub destination_container_name: String,
    #[serde(rename = "overwriteVhds")]
    pub overwrite_vhds: bool,
}
impl VirtualMachineCaptureParameters {
    pub fn new(vhd_prefix: String, destination_container_name: String, overwrite_vhds: bool) -> Self {
        Self {
            vhd_prefix,
            destination_container_name,
            overwrite_vhds,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineCaptureResult {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineCaptureResultProperties>,
}
impl VirtualMachineCaptureResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineCaptureResultProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<serde_json::Value>,
}
impl VirtualMachineCaptureResultProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineExtension {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionProperties>,
}
impl VirtualMachineExtension {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionHandlerInstanceView {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<InstanceViewStatus>,
}
impl VirtualMachineExtensionHandlerInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineExtensionImage {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionImageProperties>,
}
impl VirtualMachineExtensionImage {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineExtensionImageProperties {
    #[serde(rename = "operatingSystem")]
    pub operating_system: String,
    #[serde(rename = "computeRole")]
    pub compute_role: String,
    #[serde(rename = "handlerSchema")]
    pub handler_schema: String,
    #[serde(rename = "vmScaleSetEnabled", default, skip_serializing_if = "Option::is_none")]
    pub vm_scale_set_enabled: Option<bool>,
    #[serde(rename = "supportsMultipleExtensions", default, skip_serializing_if = "Option::is_none")]
    pub supports_multiple_extensions: Option<bool>,
}
impl VirtualMachineExtensionImageProperties {
    pub fn new(operating_system: String, compute_role: String, handler_schema: String) -> Self {
        Self {
            operating_system,
            compute_role,
            handler_schema,
            vm_scale_set_enabled: None,
            supports_multiple_extensions: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionInstanceView {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub substatuses: Vec<InstanceViewStatus>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineExtensionInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionProperties {
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_minor_version: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<serde_json::Value>,
    #[serde(rename = "protectedSettings", default, skip_serializing_if = "Option::is_none")]
    pub protected_settings: Option<serde_json::Value>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineExtensionInstanceView>,
}
impl VirtualMachineExtensionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionUpdateProperties>,
}
impl VirtualMachineExtensionUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionUpdateProperties {
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_minor_version: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<serde_json::Value>,
    #[serde(rename = "protectedSettings", default, skip_serializing_if = "Option::is_none")]
    pub protected_settings: Option<serde_json::Value>,
}
impl VirtualMachineExtensionUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualMachineExtension>,
}
impl VirtualMachineExtensionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<virtual_machine_identity::Type>,
}
impl VirtualMachineIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineImage {
    #[serde(flatten)]
    pub virtual_machine_image_resource: VirtualMachineImageResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineImageProperties>,
}
impl VirtualMachineImage {
    pub fn new(virtual_machine_image_resource: VirtualMachineImageResource) -> Self {
        Self {
            virtual_machine_image_resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineImageProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<PurchasePlan>,
    #[serde(rename = "osDiskImage", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_image: Option<OsDiskImage>,
    #[serde(rename = "dataDiskImages", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disk_images: Vec<DataDiskImage>,
}
impl VirtualMachineImageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineImageResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub name: String,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl VirtualMachineImageResource {
    pub fn new(name: String, location: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            name,
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineInstanceView {
    #[serde(rename = "platformUpdateDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_update_domain: Option<i32>,
    #[serde(rename = "platformFaultDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain: Option<i32>,
    #[serde(rename = "rdpThumbPrint", default, skip_serializing_if = "Option::is_none")]
    pub rdp_thumb_print: Option<String>,
    #[serde(rename = "vmAgent", default, skip_serializing_if = "Option::is_none")]
    pub vm_agent: Option<VirtualMachineAgentInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<DiskInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineExtensionInstanceView>,
    #[serde(rename = "bootDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub boot_diagnostics: Option<BootDiagnosticsInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineListResult {
    pub value: Vec<VirtualMachine>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineListResult {
    pub fn new(value: Vec<VirtualMachine>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineProperties {
    #[serde(rename = "hardwareProfile", default, skip_serializing_if = "Option::is_none")]
    pub hardware_profile: Option<HardwareProfile>,
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<StorageProfile>,
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<OsProfile>,
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<NetworkProfile>,
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<DiagnosticsProfile>,
    #[serde(rename = "availabilitySet", default, skip_serializing_if = "Option::is_none")]
    pub availability_set: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineInstanceView>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
}
impl VirtualMachineProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSet {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<VirtualMachineScaleSetIdentity>,
}
impl VirtualMachineScaleSet {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            sku: None,
            plan: None,
            properties: None,
            identity: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetDataDisk {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    pub lun: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<VirtualMachineScaleSetManagedDiskParameters>,
}
impl VirtualMachineScaleSetDataDisk {
    pub fn new(lun: i32, create_option: CreateOption) -> Self {
        Self {
            name: None,
            lun,
            caching: None,
            create_option,
            disk_size_gb: None,
            managed_disk: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtension {
    #[serde(flatten)]
    pub sub_resource_read_only: SubResourceReadOnly,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetExtensionProperties>,
}
impl VirtualMachineScaleSetExtension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtensionProfile {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineScaleSetExtension>,
}
impl VirtualMachineScaleSetExtensionProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtensionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_minor_version: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<serde_json::Value>,
    #[serde(rename = "protectedSettings", default, skip_serializing_if = "Option::is_none")]
    pub protected_settings: Option<serde_json::Value>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualMachineScaleSetExtensionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetIpConfigurationProperties>,
}
impl VirtualMachineScaleSetIpConfiguration {
    pub fn new(name: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            name,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetIpConfigurationProperties {
    pub subnet: ApiEntityReference,
    #[serde(rename = "applicationGatewayBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_backend_address_pools: Vec<SubResource>,
    #[serde(rename = "loadBalancerBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_address_pools: Vec<SubResource>,
    #[serde(rename = "loadBalancerInboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_inbound_nat_pools: Vec<SubResource>,
}
impl VirtualMachineScaleSetIpConfigurationProperties {
    pub fn new(subnet: ApiEntityReference) -> Self {
        Self {
            subnet,
            application_gateway_backend_address_pools: Vec::new(),
            load_balancer_backend_address_pools: Vec::new(),
            load_balancer_inbound_nat_pools: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<virtual_machine_scale_set_identity::Type>,
}
impl VirtualMachineScaleSetIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_scale_set_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetInstanceView {
    #[serde(rename = "virtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine: Option<VirtualMachineScaleSetInstanceViewStatusesSummary>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineScaleSetVmExtensionsSummary>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineScaleSetInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetInstanceViewStatusesSummary {
    #[serde(rename = "statusesSummary", default, skip_serializing_if = "Vec::is_empty")]
    pub statuses_summary: Vec<VirtualMachineStatusCodeCount>,
}
impl VirtualMachineScaleSetInstanceViewStatusesSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListResult {
    pub value: Vec<VirtualMachineScaleSet>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListResult {
    pub fn new(value: Vec<VirtualMachineScaleSet>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListSkusResult {
    pub value: Vec<VirtualMachineScaleSetSku>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListSkusResult {
    pub fn new(value: Vec<VirtualMachineScaleSetSku>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListWithLinkResult {
    pub value: Vec<VirtualMachineScaleSet>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListWithLinkResult {
    pub fn new(value: Vec<VirtualMachineScaleSet>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetManagedDiskParameters {
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<StorageAccountType>,
}
impl VirtualMachineScaleSetManagedDiskParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetNetworkConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetNetworkConfigurationProperties>,
}
impl VirtualMachineScaleSetNetworkConfiguration {
    pub fn new(name: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            name,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetNetworkConfigurationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "ipConfigurations")]
    pub ip_configurations: Vec<VirtualMachineScaleSetIpConfiguration>,
}
impl VirtualMachineScaleSetNetworkConfigurationProperties {
    pub fn new(ip_configurations: Vec<VirtualMachineScaleSetIpConfiguration>) -> Self {
        Self {
            primary: None,
            ip_configurations,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetNetworkProfile {
    #[serde(rename = "networkInterfaceConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interface_configurations: Vec<VirtualMachineScaleSetNetworkConfiguration>,
}
impl VirtualMachineScaleSetNetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetOsDisk {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<virtual_machine_scale_set_os_disk::OsType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[serde(rename = "vhdContainers", default, skip_serializing_if = "Vec::is_empty")]
    pub vhd_containers: Vec<String>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<VirtualMachineScaleSetManagedDiskParameters>,
}
impl VirtualMachineScaleSetOsDisk {
    pub fn new(create_option: CreateOption) -> Self {
        Self {
            name: None,
            caching: None,
            create_option,
            os_type: None,
            image: None,
            vhd_containers: Vec::new(),
            managed_disk: None,
        }
    }
}
pub mod virtual_machine_scale_set_os_disk {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetOsProfile {
    #[serde(rename = "computerNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub computer_name_prefix: Option<String>,
    #[serde(rename = "adminUsername", default, skip_serializing_if = "Option::is_none")]
    pub admin_username: Option<String>,
    #[serde(rename = "adminPassword", default, skip_serializing_if = "Option::is_none")]
    pub admin_password: Option<String>,
    #[serde(rename = "customData", default, skip_serializing_if = "Option::is_none")]
    pub custom_data: Option<String>,
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[serde(rename = "linuxConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_configuration: Option<LinuxConfiguration>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub secrets: Vec<VaultSecretGroup>,
}
impl VirtualMachineScaleSetOsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetProperties {
    #[serde(rename = "upgradePolicy", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_policy: Option<UpgradePolicy>,
    #[serde(rename = "virtualMachineProfile", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_profile: Option<VirtualMachineScaleSetVmProfile>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "overProvision", default, skip_serializing_if = "Option::is_none")]
    pub over_provision: Option<bool>,
    #[serde(rename = "singlePlacementGroup", default, skip_serializing_if = "Option::is_none")]
    pub single_placement_group: Option<bool>,
}
impl VirtualMachineScaleSetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetSku {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<VirtualMachineScaleSetSkuCapacity>,
}
impl VirtualMachineScaleSetSku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetSkuCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i64>,
    #[serde(rename = "defaultCapacity", default, skip_serializing_if = "Option::is_none")]
    pub default_capacity: Option<i64>,
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<virtual_machine_scale_set_sku_capacity::ScaleType>,
}
impl VirtualMachineScaleSetSkuCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_scale_set_sku_capacity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScaleType {
        Automatic,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetStorageProfile {
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<ImageReference>,
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<VirtualMachineScaleSetOsDisk>,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<VirtualMachineScaleSetDataDisk>,
}
impl VirtualMachineScaleSetStorageProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetVm {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetVmProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<VirtualMachineExtension>,
}
impl VirtualMachineScaleSetVm {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            instance_id: None,
            sku: None,
            properties: None,
            plan: None,
            resources: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmExtensionsSummary {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "statusesSummary", default, skip_serializing_if = "Vec::is_empty")]
    pub statuses_summary: Vec<VirtualMachineStatusCodeCount>,
}
impl VirtualMachineScaleSetVmExtensionsSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmInstanceIDs {
    #[serde(rename = "instanceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub instance_ids: Vec<String>,
}
impl VirtualMachineScaleSetVmInstanceIDs {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetVmInstanceRequiredIDs {
    #[serde(rename = "instanceIds")]
    pub instance_ids: Vec<String>,
}
impl VirtualMachineScaleSetVmInstanceRequiredIDs {
    pub fn new(instance_ids: Vec<String>) -> Self {
        Self { instance_ids }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmInstanceView {
    #[serde(rename = "platformUpdateDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_update_domain: Option<i32>,
    #[serde(rename = "platformFaultDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain: Option<i32>,
    #[serde(rename = "rdpThumbPrint", default, skip_serializing_if = "Option::is_none")]
    pub rdp_thumb_print: Option<String>,
    #[serde(rename = "vmAgent", default, skip_serializing_if = "Option::is_none")]
    pub vm_agent: Option<VirtualMachineAgentInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<DiskInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineExtensionInstanceView>,
    #[serde(rename = "bootDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub boot_diagnostics: Option<BootDiagnosticsInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
    #[serde(rename = "placementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub placement_group_id: Option<String>,
}
impl VirtualMachineScaleSetVmInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetVmListResult {
    pub value: Vec<VirtualMachineScaleSetVm>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetVmListResult {
    pub fn new(value: Vec<VirtualMachineScaleSetVm>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmProfile {
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<VirtualMachineScaleSetOsProfile>,
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<VirtualMachineScaleSetStorageProfile>,
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<VirtualMachineScaleSetNetworkProfile>,
    #[serde(rename = "extensionProfile", default, skip_serializing_if = "Option::is_none")]
    pub extension_profile: Option<VirtualMachineScaleSetExtensionProfile>,
}
impl VirtualMachineScaleSetVmProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmProperties {
    #[serde(rename = "latestModelApplied", default, skip_serializing_if = "Option::is_none")]
    pub latest_model_applied: Option<bool>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineScaleSetVmInstanceView>,
    #[serde(rename = "hardwareProfile", default, skip_serializing_if = "Option::is_none")]
    pub hardware_profile: Option<HardwareProfile>,
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<StorageProfile>,
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<OsProfile>,
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<NetworkProfile>,
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<DiagnosticsProfile>,
    #[serde(rename = "availabilitySet", default, skip_serializing_if = "Option::is_none")]
    pub availability_set: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
}
impl VirtualMachineScaleSetVmProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSize {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "numberOfCores", default, skip_serializing_if = "Option::is_none")]
    pub number_of_cores: Option<i32>,
    #[serde(rename = "osDiskSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_size_in_mb: Option<i32>,
    #[serde(rename = "resourceDiskSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub resource_disk_size_in_mb: Option<i32>,
    #[serde(rename = "memoryInMB", default, skip_serializing_if = "Option::is_none")]
    pub memory_in_mb: Option<i32>,
    #[serde(rename = "maxDataDiskCount", default, skip_serializing_if = "Option::is_none")]
    pub max_data_disk_count: Option<i32>,
}
impl VirtualMachineSize {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSizeListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualMachineSize>,
}
impl VirtualMachineSizeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineStatusCodeCount {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
}
impl VirtualMachineStatusCodeCount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WinRmConfiguration {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub listeners: Vec<WinRmListener>,
}
impl WinRmConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WinRmListener {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<win_rm_listener::Protocol>,
    #[serde(rename = "certificateUrl", default, skip_serializing_if = "Option::is_none")]
    pub certificate_url: Option<String>,
}
impl WinRmListener {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod win_rm_listener {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Https,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WindowsConfiguration {
    #[serde(rename = "provisionVMAgent", default, skip_serializing_if = "Option::is_none")]
    pub provision_vm_agent: Option<bool>,
    #[serde(rename = "enableAutomaticUpdates", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_updates: Option<bool>,
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[serde(rename = "additionalUnattendContent", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_unattend_content: Vec<AdditionalUnattendContent>,
    #[serde(rename = "winRM", default, skip_serializing_if = "Option::is_none")]
    pub win_rm: Option<WinRmConfiguration>,
}
impl WindowsConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
