#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdditionalCapabilities {
    #[serde(rename = "ultraSSDEnabled", default, skip_serializing_if = "Option::is_none")]
    pub ultra_ssd_enabled: Option<bool>,
}
impl AdditionalCapabilities {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdditionalUnattendContent {
    #[serde(rename = "passName", default, skip_serializing_if = "Option::is_none")]
    pub pass_name: Option<additional_unattend_content::PassName>,
    #[serde(rename = "componentName", default, skip_serializing_if = "Option::is_none")]
    pub component_name: Option<additional_unattend_content::ComponentName>,
    #[serde(rename = "settingName", default, skip_serializing_if = "Option::is_none")]
    pub setting_name: Option<additional_unattend_content::SettingName>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
}
impl AdditionalUnattendContent {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod additional_unattend_content {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PassName {
        OobeSystem,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComponentName {
        #[serde(rename = "Microsoft-Windows-Shell-Setup")]
        MicrosoftWindowsShellSetup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SettingName {
        AutoLogon,
        FirstLogonCommands,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiEntityReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ApiEntityReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiError {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ApiErrorBase>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub innererror: Option<InnerError>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ApiError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiErrorBase {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ApiErrorBase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutomaticOsUpgradePolicy {
    #[serde(rename = "enableAutomaticOSUpgrade", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_os_upgrade: Option<bool>,
    #[serde(rename = "disableAutomaticRollback", default, skip_serializing_if = "Option::is_none")]
    pub disable_automatic_rollback: Option<bool>,
}
impl AutomaticOsUpgradePolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomaticOsUpgradeProperties {
    #[serde(rename = "automaticOSUpgradeSupported")]
    pub automatic_os_upgrade_supported: bool,
}
impl AutomaticOsUpgradeProperties {
    pub fn new(automatic_os_upgrade_supported: bool) -> Self {
        Self {
            automatic_os_upgrade_supported,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutomaticRepairsPolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "gracePeriod", default, skip_serializing_if = "Option::is_none")]
    pub grace_period: Option<String>,
}
impl AutomaticRepairsPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailabilitySet {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AvailabilitySetProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
}
impl AvailabilitySet {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            sku: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailabilitySetListResult {
    pub value: Vec<AvailabilitySet>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailabilitySetListResult {
    pub fn new(value: Vec<AvailabilitySet>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailabilitySetProperties {
    #[serde(rename = "platformUpdateDomainCount", default, skip_serializing_if = "Option::is_none")]
    pub platform_update_domain_count: Option<i32>,
    #[serde(rename = "platformFaultDomainCount", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain_count: Option<i32>,
    #[serde(rename = "virtualMachines", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_machines: Vec<SubResource>,
    #[serde(rename = "proximityPlacementGroup", default, skip_serializing_if = "Option::is_none")]
    pub proximity_placement_group: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl AvailabilitySetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AvailabilitySetSkuType {
    Classic,
    Aligned,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailabilitySetUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AvailabilitySetProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
}
impl AvailabilitySetUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailablePatchSummary {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<available_patch_summary::Status>,
    #[serde(rename = "assessmentActivityId", default, skip_serializing_if = "Option::is_none")]
    pub assessment_activity_id: Option<String>,
    #[serde(rename = "rebootPending", default, skip_serializing_if = "Option::is_none")]
    pub reboot_pending: Option<bool>,
    #[serde(rename = "criticalAndSecurityPatchCount", default, skip_serializing_if = "Option::is_none")]
    pub critical_and_security_patch_count: Option<i32>,
    #[serde(rename = "otherPatchCount", default, skip_serializing_if = "Option::is_none")]
    pub other_patch_count: Option<i32>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "lastModifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
}
impl AvailablePatchSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod available_patch_summary {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Failed,
        Succeeded,
        CompletedWithWarnings,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingProfile {
    #[serde(rename = "maxPrice", default, skip_serializing_if = "Option::is_none")]
    pub max_price: Option<f64>,
}
impl BillingProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BootDiagnostics {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "storageUri", default, skip_serializing_if = "Option::is_none")]
    pub storage_uri: Option<String>,
}
impl BootDiagnostics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BootDiagnosticsInstanceView {
    #[serde(rename = "consoleScreenshotBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub console_screenshot_blob_uri: Option<String>,
    #[serde(rename = "serialConsoleLogBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub serial_console_log_blob_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<InstanceViewStatus>,
}
impl BootDiagnosticsInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Caching {
    None,
    ReadOnly,
    ReadWrite,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeOperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ComputeOperationValue>,
}
impl ComputeOperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeOperationValue {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<ComputeOperationValueDisplay>,
}
impl ComputeOperationValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeOperationValueDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
}
impl ComputeOperationValueDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CreateOption {
    FromImage,
    Empty,
    Attach,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataDisk {
    pub lun: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vhd: Option<VirtualHardDisk>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[serde(rename = "writeAcceleratorEnabled", default, skip_serializing_if = "Option::is_none")]
    pub write_accelerator_enabled: Option<bool>,
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<ManagedDiskParameters>,
    #[serde(rename = "toBeDetached", default, skip_serializing_if = "Option::is_none")]
    pub to_be_detached: Option<bool>,
    #[serde(rename = "diskIOPSReadWrite", default, skip_serializing_if = "Option::is_none")]
    pub disk_iops_read_write: Option<i64>,
    #[serde(rename = "diskMBpsReadWrite", default, skip_serializing_if = "Option::is_none")]
    pub disk_m_bps_read_write: Option<i64>,
}
impl DataDisk {
    pub fn new(lun: i32, create_option: CreateOption) -> Self {
        Self {
            lun,
            name: None,
            vhd: None,
            image: None,
            caching: None,
            write_accelerator_enabled: None,
            create_option,
            disk_size_gb: None,
            managed_disk: None,
            to_be_detached: None,
            disk_iops_read_write: None,
            disk_m_bps_read_write: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataDiskImage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub lun: Option<i32>,
}
impl DataDiskImage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DedicatedHost {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DedicatedHostProperties>,
    pub sku: Sku,
}
impl DedicatedHost {
    pub fn new(resource: Resource, sku: Sku) -> Self {
        Self {
            resource,
            properties: None,
            sku,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DedicatedHostAllocatableVm {
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<f64>,
}
impl DedicatedHostAllocatableVm {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DedicatedHostAvailableCapacity {
    #[serde(rename = "allocatableVMs", default, skip_serializing_if = "Vec::is_empty")]
    pub allocatable_v_ms: Vec<DedicatedHostAllocatableVm>,
}
impl DedicatedHostAvailableCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DedicatedHostGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DedicatedHostGroupProperties>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl DedicatedHostGroup {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            zones: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DedicatedHostGroupInstanceView {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hosts: Vec<DedicatedHostInstanceViewWithName>,
}
impl DedicatedHostGroupInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DedicatedHostGroupListResult {
    pub value: Vec<DedicatedHostGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DedicatedHostGroupListResult {
    pub fn new(value: Vec<DedicatedHostGroup>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DedicatedHostGroupProperties {
    #[serde(rename = "platformFaultDomainCount")]
    pub platform_fault_domain_count: i32,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hosts: Vec<SubResourceReadOnly>,
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<DedicatedHostGroupInstanceView>,
    #[serde(rename = "supportAutomaticPlacement", default, skip_serializing_if = "Option::is_none")]
    pub support_automatic_placement: Option<bool>,
}
impl DedicatedHostGroupProperties {
    pub fn new(platform_fault_domain_count: i32) -> Self {
        Self {
            platform_fault_domain_count,
            hosts: Vec::new(),
            instance_view: None,
            support_automatic_placement: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DedicatedHostGroupUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DedicatedHostGroupProperties>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl DedicatedHostGroupUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DedicatedHostInstanceView {
    #[serde(rename = "assetId", default, skip_serializing_if = "Option::is_none")]
    pub asset_id: Option<String>,
    #[serde(rename = "availableCapacity", default, skip_serializing_if = "Option::is_none")]
    pub available_capacity: Option<DedicatedHostAvailableCapacity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl DedicatedHostInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DedicatedHostInstanceViewWithName {
    #[serde(flatten)]
    pub dedicated_host_instance_view: DedicatedHostInstanceView,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl DedicatedHostInstanceViewWithName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DedicatedHostLicenseType {
    None,
    #[serde(rename = "Windows_Server_Hybrid")]
    WindowsServerHybrid,
    #[serde(rename = "Windows_Server_Perpetual")]
    WindowsServerPerpetual,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DedicatedHostListResult {
    pub value: Vec<DedicatedHost>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DedicatedHostListResult {
    pub fn new(value: Vec<DedicatedHost>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DedicatedHostProperties {
    #[serde(rename = "platformFaultDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain: Option<i32>,
    #[serde(rename = "autoReplaceOnFailure", default, skip_serializing_if = "Option::is_none")]
    pub auto_replace_on_failure: Option<bool>,
    #[serde(rename = "hostId", default, skip_serializing_if = "Option::is_none")]
    pub host_id: Option<String>,
    #[serde(rename = "virtualMachines", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_machines: Vec<SubResourceReadOnly>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<DedicatedHostLicenseType>,
    #[serde(rename = "provisioningTime", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_time: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<DedicatedHostInstanceView>,
}
impl DedicatedHostProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DedicatedHostUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DedicatedHostProperties>,
}
impl DedicatedHostUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticsProfile {
    #[serde(rename = "bootDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub boot_diagnostics: Option<BootDiagnostics>,
}
impl DiagnosticsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DiffDiskOption {
    Local,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DiffDiskPlacement {
    CacheDisk,
    ResourceDisk,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiffDiskSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub option: Option<DiffDiskOption>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub placement: Option<DiffDiskPlacement>,
}
impl DiffDiskSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DisallowedConfiguration {
    #[serde(rename = "vmDiskType", default, skip_serializing_if = "Option::is_none")]
    pub vm_disk_type: Option<disallowed_configuration::VmDiskType>,
}
impl DisallowedConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod disallowed_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VmDiskType {
        None,
        Unmanaged,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskEncryptionSetParameters {
    #[serde(flatten)]
    pub sub_resource: SubResource,
}
impl DiskEncryptionSetParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskEncryptionSettings {
    #[serde(rename = "diskEncryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_key: Option<KeyVaultSecretReference>,
    #[serde(rename = "keyEncryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub key_encryption_key: Option<KeyVaultKeyReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl DiskEncryptionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskInstanceView {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "encryptionSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub encryption_settings: Vec<DiskEncryptionSettings>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl DiskInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HardwareProfile {
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<hardware_profile::VmSize>,
}
impl HardwareProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hardware_profile {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VmSize {
        #[serde(rename = "Basic_A0")]
        BasicA0,
        #[serde(rename = "Basic_A1")]
        BasicA1,
        #[serde(rename = "Basic_A2")]
        BasicA2,
        #[serde(rename = "Basic_A3")]
        BasicA3,
        #[serde(rename = "Basic_A4")]
        BasicA4,
        #[serde(rename = "Standard_A0")]
        StandardA0,
        #[serde(rename = "Standard_A1")]
        StandardA1,
        #[serde(rename = "Standard_A2")]
        StandardA2,
        #[serde(rename = "Standard_A3")]
        StandardA3,
        #[serde(rename = "Standard_A4")]
        StandardA4,
        #[serde(rename = "Standard_A5")]
        StandardA5,
        #[serde(rename = "Standard_A6")]
        StandardA6,
        #[serde(rename = "Standard_A7")]
        StandardA7,
        #[serde(rename = "Standard_A8")]
        StandardA8,
        #[serde(rename = "Standard_A9")]
        StandardA9,
        #[serde(rename = "Standard_A10")]
        StandardA10,
        #[serde(rename = "Standard_A11")]
        StandardA11,
        #[serde(rename = "Standard_A1_v2")]
        StandardA1V2,
        #[serde(rename = "Standard_A2_v2")]
        StandardA2V2,
        #[serde(rename = "Standard_A4_v2")]
        StandardA4V2,
        #[serde(rename = "Standard_A8_v2")]
        StandardA8V2,
        #[serde(rename = "Standard_A2m_v2")]
        StandardA2mV2,
        #[serde(rename = "Standard_A4m_v2")]
        StandardA4mV2,
        #[serde(rename = "Standard_A8m_v2")]
        StandardA8mV2,
        #[serde(rename = "Standard_B1s")]
        StandardB1s,
        #[serde(rename = "Standard_B1ms")]
        StandardB1ms,
        #[serde(rename = "Standard_B2s")]
        StandardB2s,
        #[serde(rename = "Standard_B2ms")]
        StandardB2ms,
        #[serde(rename = "Standard_B4ms")]
        StandardB4ms,
        #[serde(rename = "Standard_B8ms")]
        StandardB8ms,
        #[serde(rename = "Standard_D1")]
        StandardD1,
        #[serde(rename = "Standard_D2")]
        StandardD2,
        #[serde(rename = "Standard_D3")]
        StandardD3,
        #[serde(rename = "Standard_D4")]
        StandardD4,
        #[serde(rename = "Standard_D11")]
        StandardD11,
        #[serde(rename = "Standard_D12")]
        StandardD12,
        #[serde(rename = "Standard_D13")]
        StandardD13,
        #[serde(rename = "Standard_D14")]
        StandardD14,
        #[serde(rename = "Standard_D1_v2")]
        StandardD1V2,
        #[serde(rename = "Standard_D2_v2")]
        StandardD2V2,
        #[serde(rename = "Standard_D3_v2")]
        StandardD3V2,
        #[serde(rename = "Standard_D4_v2")]
        StandardD4V2,
        #[serde(rename = "Standard_D5_v2")]
        StandardD5V2,
        #[serde(rename = "Standard_D2_v3")]
        StandardD2V3,
        #[serde(rename = "Standard_D4_v3")]
        StandardD4V3,
        #[serde(rename = "Standard_D8_v3")]
        StandardD8V3,
        #[serde(rename = "Standard_D16_v3")]
        StandardD16V3,
        #[serde(rename = "Standard_D32_v3")]
        StandardD32V3,
        #[serde(rename = "Standard_D64_v3")]
        StandardD64V3,
        #[serde(rename = "Standard_D2s_v3")]
        StandardD2sV3,
        #[serde(rename = "Standard_D4s_v3")]
        StandardD4sV3,
        #[serde(rename = "Standard_D8s_v3")]
        StandardD8sV3,
        #[serde(rename = "Standard_D16s_v3")]
        StandardD16sV3,
        #[serde(rename = "Standard_D32s_v3")]
        StandardD32sV3,
        #[serde(rename = "Standard_D64s_v3")]
        StandardD64sV3,
        #[serde(rename = "Standard_D11_v2")]
        StandardD11V2,
        #[serde(rename = "Standard_D12_v2")]
        StandardD12V2,
        #[serde(rename = "Standard_D13_v2")]
        StandardD13V2,
        #[serde(rename = "Standard_D14_v2")]
        StandardD14V2,
        #[serde(rename = "Standard_D15_v2")]
        StandardD15V2,
        #[serde(rename = "Standard_DS1")]
        StandardDs1,
        #[serde(rename = "Standard_DS2")]
        StandardDs2,
        #[serde(rename = "Standard_DS3")]
        StandardDs3,
        #[serde(rename = "Standard_DS4")]
        StandardDs4,
        #[serde(rename = "Standard_DS11")]
        StandardDs11,
        #[serde(rename = "Standard_DS12")]
        StandardDs12,
        #[serde(rename = "Standard_DS13")]
        StandardDs13,
        #[serde(rename = "Standard_DS14")]
        StandardDs14,
        #[serde(rename = "Standard_DS1_v2")]
        StandardDs1V2,
        #[serde(rename = "Standard_DS2_v2")]
        StandardDs2V2,
        #[serde(rename = "Standard_DS3_v2")]
        StandardDs3V2,
        #[serde(rename = "Standard_DS4_v2")]
        StandardDs4V2,
        #[serde(rename = "Standard_DS5_v2")]
        StandardDs5V2,
        #[serde(rename = "Standard_DS11_v2")]
        StandardDs11V2,
        #[serde(rename = "Standard_DS12_v2")]
        StandardDs12V2,
        #[serde(rename = "Standard_DS13_v2")]
        StandardDs13V2,
        #[serde(rename = "Standard_DS14_v2")]
        StandardDs14V2,
        #[serde(rename = "Standard_DS15_v2")]
        StandardDs15V2,
        #[serde(rename = "Standard_DS13-4_v2")]
        StandardDs134V2,
        #[serde(rename = "Standard_DS13-2_v2")]
        StandardDs132V2,
        #[serde(rename = "Standard_DS14-8_v2")]
        StandardDs148V2,
        #[serde(rename = "Standard_DS14-4_v2")]
        StandardDs144V2,
        #[serde(rename = "Standard_E2_v3")]
        StandardE2V3,
        #[serde(rename = "Standard_E4_v3")]
        StandardE4V3,
        #[serde(rename = "Standard_E8_v3")]
        StandardE8V3,
        #[serde(rename = "Standard_E16_v3")]
        StandardE16V3,
        #[serde(rename = "Standard_E32_v3")]
        StandardE32V3,
        #[serde(rename = "Standard_E64_v3")]
        StandardE64V3,
        #[serde(rename = "Standard_E2s_v3")]
        StandardE2sV3,
        #[serde(rename = "Standard_E4s_v3")]
        StandardE4sV3,
        #[serde(rename = "Standard_E8s_v3")]
        StandardE8sV3,
        #[serde(rename = "Standard_E16s_v3")]
        StandardE16sV3,
        #[serde(rename = "Standard_E32s_v3")]
        StandardE32sV3,
        #[serde(rename = "Standard_E64s_v3")]
        StandardE64sV3,
        #[serde(rename = "Standard_E32-16_v3")]
        StandardE3216V3,
        #[serde(rename = "Standard_E32-8s_v3")]
        StandardE328sV3,
        #[serde(rename = "Standard_E64-32s_v3")]
        StandardE6432sV3,
        #[serde(rename = "Standard_E64-16s_v3")]
        StandardE6416sV3,
        #[serde(rename = "Standard_F1")]
        StandardF1,
        #[serde(rename = "Standard_F2")]
        StandardF2,
        #[serde(rename = "Standard_F4")]
        StandardF4,
        #[serde(rename = "Standard_F8")]
        StandardF8,
        #[serde(rename = "Standard_F16")]
        StandardF16,
        #[serde(rename = "Standard_F1s")]
        StandardF1s,
        #[serde(rename = "Standard_F2s")]
        StandardF2s,
        #[serde(rename = "Standard_F4s")]
        StandardF4s,
        #[serde(rename = "Standard_F8s")]
        StandardF8s,
        #[serde(rename = "Standard_F16s")]
        StandardF16s,
        #[serde(rename = "Standard_F2s_v2")]
        StandardF2sV2,
        #[serde(rename = "Standard_F4s_v2")]
        StandardF4sV2,
        #[serde(rename = "Standard_F8s_v2")]
        StandardF8sV2,
        #[serde(rename = "Standard_F16s_v2")]
        StandardF16sV2,
        #[serde(rename = "Standard_F32s_v2")]
        StandardF32sV2,
        #[serde(rename = "Standard_F64s_v2")]
        StandardF64sV2,
        #[serde(rename = "Standard_F72s_v2")]
        StandardF72sV2,
        #[serde(rename = "Standard_G1")]
        StandardG1,
        #[serde(rename = "Standard_G2")]
        StandardG2,
        #[serde(rename = "Standard_G3")]
        StandardG3,
        #[serde(rename = "Standard_G4")]
        StandardG4,
        #[serde(rename = "Standard_G5")]
        StandardG5,
        #[serde(rename = "Standard_GS1")]
        StandardGs1,
        #[serde(rename = "Standard_GS2")]
        StandardGs2,
        #[serde(rename = "Standard_GS3")]
        StandardGs3,
        #[serde(rename = "Standard_GS4")]
        StandardGs4,
        #[serde(rename = "Standard_GS5")]
        StandardGs5,
        #[serde(rename = "Standard_GS4-8")]
        StandardGs48,
        #[serde(rename = "Standard_GS4-4")]
        StandardGs44,
        #[serde(rename = "Standard_GS5-16")]
        StandardGs516,
        #[serde(rename = "Standard_GS5-8")]
        StandardGs58,
        #[serde(rename = "Standard_H8")]
        StandardH8,
        #[serde(rename = "Standard_H16")]
        StandardH16,
        #[serde(rename = "Standard_H8m")]
        StandardH8m,
        #[serde(rename = "Standard_H16m")]
        StandardH16m,
        #[serde(rename = "Standard_H16r")]
        StandardH16r,
        #[serde(rename = "Standard_H16mr")]
        StandardH16mr,
        #[serde(rename = "Standard_L4s")]
        StandardL4s,
        #[serde(rename = "Standard_L8s")]
        StandardL8s,
        #[serde(rename = "Standard_L16s")]
        StandardL16s,
        #[serde(rename = "Standard_L32s")]
        StandardL32s,
        #[serde(rename = "Standard_M64s")]
        StandardM64s,
        #[serde(rename = "Standard_M64ms")]
        StandardM64ms,
        #[serde(rename = "Standard_M128s")]
        StandardM128s,
        #[serde(rename = "Standard_M128ms")]
        StandardM128ms,
        #[serde(rename = "Standard_M64-32ms")]
        StandardM6432ms,
        #[serde(rename = "Standard_M64-16ms")]
        StandardM6416ms,
        #[serde(rename = "Standard_M128-64ms")]
        StandardM12864ms,
        #[serde(rename = "Standard_M128-32ms")]
        StandardM12832ms,
        #[serde(rename = "Standard_NC6")]
        StandardNc6,
        #[serde(rename = "Standard_NC12")]
        StandardNc12,
        #[serde(rename = "Standard_NC24")]
        StandardNc24,
        #[serde(rename = "Standard_NC24r")]
        StandardNc24r,
        #[serde(rename = "Standard_NC6s_v2")]
        StandardNc6sV2,
        #[serde(rename = "Standard_NC12s_v2")]
        StandardNc12sV2,
        #[serde(rename = "Standard_NC24s_v2")]
        StandardNc24sV2,
        #[serde(rename = "Standard_NC24rs_v2")]
        StandardNc24rsV2,
        #[serde(rename = "Standard_NC6s_v3")]
        StandardNc6sV3,
        #[serde(rename = "Standard_NC12s_v3")]
        StandardNc12sV3,
        #[serde(rename = "Standard_NC24s_v3")]
        StandardNc24sV3,
        #[serde(rename = "Standard_NC24rs_v3")]
        StandardNc24rsV3,
        #[serde(rename = "Standard_ND6s")]
        StandardNd6s,
        #[serde(rename = "Standard_ND12s")]
        StandardNd12s,
        #[serde(rename = "Standard_ND24s")]
        StandardNd24s,
        #[serde(rename = "Standard_ND24rs")]
        StandardNd24rs,
        #[serde(rename = "Standard_NV6")]
        StandardNv6,
        #[serde(rename = "Standard_NV12")]
        StandardNv12,
        #[serde(rename = "Standard_NV24")]
        StandardNv24,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum HyperVGenerationType {
    V1,
    V2,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Image {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ImageProperties>,
}
impl Image {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImageDataDisk {
    #[serde(flatten)]
    pub image_disk: ImageDisk,
    pub lun: i32,
}
impl ImageDataDisk {
    pub fn new(lun: i32) -> Self {
        Self {
            image_disk: ImageDisk::default(),
            lun,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageDisk {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub snapshot: Option<SubResource>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<SubResource>,
    #[serde(rename = "blobUri", default, skip_serializing_if = "Option::is_none")]
    pub blob_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<image_disk::Caching>,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<StorageAccountType>,
    #[serde(rename = "diskEncryptionSet", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set: Option<DiskEncryptionSetParameters>,
}
impl ImageDisk {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod image_disk {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Caching {
        None,
        ReadOnly,
        ReadWrite,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImageListResult {
    pub value: Vec<Image>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ImageListResult {
    pub fn new(value: Vec<Image>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImageOsDisk {
    #[serde(flatten)]
    pub image_disk: ImageDisk,
    #[serde(rename = "osType")]
    pub os_type: image_os_disk::OsType,
    #[serde(rename = "osState")]
    pub os_state: image_os_disk::OsState,
}
impl ImageOsDisk {
    pub fn new(os_type: image_os_disk::OsType, os_state: image_os_disk::OsState) -> Self {
        Self {
            image_disk: ImageDisk::default(),
            os_type,
            os_state,
        }
    }
}
pub mod image_os_disk {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsState {
        Generalized,
        Specialized,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageProperties {
    #[serde(rename = "sourceVirtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub source_virtual_machine: Option<SubResource>,
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<ImageStorageProfile>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "hyperVGeneration", default, skip_serializing_if = "Option::is_none")]
    pub hyper_v_generation: Option<HyperVGenerationType>,
}
impl ImageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageReference {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "exactVersion", default, skip_serializing_if = "Option::is_none")]
    pub exact_version: Option<String>,
}
impl ImageReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageStorageProfile {
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<ImageOsDisk>,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<ImageDataDisk>,
    #[serde(rename = "zoneResilient", default, skip_serializing_if = "Option::is_none")]
    pub zone_resilient: Option<bool>,
}
impl ImageStorageProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ImageProperties>,
}
impl ImageUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InnerError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exceptiontype: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub errordetail: Option<String>,
}
impl InnerError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstanceViewStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<instance_view_status::Level>,
    #[serde(rename = "displayStatus", default, skip_serializing_if = "Option::is_none")]
    pub display_status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
}
impl InstanceViewStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod instance_view_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Info,
        Warning,
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultKeyReference {
    #[serde(rename = "keyUrl")]
    pub key_url: String,
    #[serde(rename = "sourceVault")]
    pub source_vault: SubResource,
}
impl KeyVaultKeyReference {
    pub fn new(key_url: String, source_vault: SubResource) -> Self {
        Self { key_url, source_vault }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultSecretReference {
    #[serde(rename = "secretUrl")]
    pub secret_url: String,
    #[serde(rename = "sourceVault")]
    pub source_vault: SubResource,
}
impl KeyVaultSecretReference {
    pub fn new(secret_url: String, source_vault: SubResource) -> Self {
        Self { secret_url, source_vault }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LastPatchInstallationSummary {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<last_patch_installation_summary::Status>,
    #[serde(rename = "installationActivityId", default, skip_serializing_if = "Option::is_none")]
    pub installation_activity_id: Option<String>,
    #[serde(rename = "maintenanceWindowExceeded", default, skip_serializing_if = "Option::is_none")]
    pub maintenance_window_exceeded: Option<bool>,
    #[serde(rename = "rebootStatus", default, skip_serializing_if = "Option::is_none")]
    pub reboot_status: Option<last_patch_installation_summary::RebootStatus>,
    #[serde(rename = "notSelectedPatchCount", default, skip_serializing_if = "Option::is_none")]
    pub not_selected_patch_count: Option<i32>,
    #[serde(rename = "excludedPatchCount", default, skip_serializing_if = "Option::is_none")]
    pub excluded_patch_count: Option<i32>,
    #[serde(rename = "pendingPatchCount", default, skip_serializing_if = "Option::is_none")]
    pub pending_patch_count: Option<i32>,
    #[serde(rename = "installedPatchCount", default, skip_serializing_if = "Option::is_none")]
    pub installed_patch_count: Option<i32>,
    #[serde(rename = "failedPatchCount", default, skip_serializing_if = "Option::is_none")]
    pub failed_patch_count: Option<i32>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "lastModifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<String>,
    #[serde(rename = "startedBy", default, skip_serializing_if = "Option::is_none")]
    pub started_by: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
}
impl LastPatchInstallationSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod last_patch_installation_summary {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Failed,
        Succeeded,
        CompletedWithWarnings,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RebootStatus {
        NotNeeded,
        Required,
        Started,
        Failed,
        Completed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinuxConfiguration {
    #[serde(rename = "disablePasswordAuthentication", default, skip_serializing_if = "Option::is_none")]
    pub disable_password_authentication: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub ssh: Option<SshConfiguration>,
    #[serde(rename = "provisionVMAgent", default, skip_serializing_if = "Option::is_none")]
    pub provision_vm_agent: Option<bool>,
}
impl LinuxConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListUsagesResult {
    pub value: Vec<Usage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListUsagesResult {
    pub fn new(value: Vec<Usage>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogAnalyticsInputBase {
    #[serde(rename = "blobContainerSasUri")]
    pub blob_container_sas_uri: String,
    #[serde(rename = "fromTime")]
    pub from_time: String,
    #[serde(rename = "toTime")]
    pub to_time: String,
    #[serde(rename = "groupByThrottlePolicy", default, skip_serializing_if = "Option::is_none")]
    pub group_by_throttle_policy: Option<bool>,
    #[serde(rename = "groupByOperationName", default, skip_serializing_if = "Option::is_none")]
    pub group_by_operation_name: Option<bool>,
    #[serde(rename = "groupByResourceName", default, skip_serializing_if = "Option::is_none")]
    pub group_by_resource_name: Option<bool>,
    #[serde(rename = "groupByClientApplicationId", default, skip_serializing_if = "Option::is_none")]
    pub group_by_client_application_id: Option<bool>,
    #[serde(rename = "groupByUserAgent", default, skip_serializing_if = "Option::is_none")]
    pub group_by_user_agent: Option<bool>,
}
impl LogAnalyticsInputBase {
    pub fn new(blob_container_sas_uri: String, from_time: String, to_time: String) -> Self {
        Self {
            blob_container_sas_uri,
            from_time,
            to_time,
            group_by_throttle_policy: None,
            group_by_operation_name: None,
            group_by_resource_name: None,
            group_by_client_application_id: None,
            group_by_user_agent: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogAnalyticsOperationResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LogAnalyticsOutput>,
}
impl LogAnalyticsOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogAnalyticsOutput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<String>,
}
impl LogAnalyticsOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MaintenanceRedeployStatus {
    #[serde(rename = "isCustomerInitiatedMaintenanceAllowed", default, skip_serializing_if = "Option::is_none")]
    pub is_customer_initiated_maintenance_allowed: Option<bool>,
    #[serde(rename = "preMaintenanceWindowStartTime", default, skip_serializing_if = "Option::is_none")]
    pub pre_maintenance_window_start_time: Option<String>,
    #[serde(rename = "preMaintenanceWindowEndTime", default, skip_serializing_if = "Option::is_none")]
    pub pre_maintenance_window_end_time: Option<String>,
    #[serde(rename = "maintenanceWindowStartTime", default, skip_serializing_if = "Option::is_none")]
    pub maintenance_window_start_time: Option<String>,
    #[serde(rename = "maintenanceWindowEndTime", default, skip_serializing_if = "Option::is_none")]
    pub maintenance_window_end_time: Option<String>,
    #[serde(rename = "lastOperationResultCode", default, skip_serializing_if = "Option::is_none")]
    pub last_operation_result_code: Option<maintenance_redeploy_status::LastOperationResultCode>,
    #[serde(rename = "lastOperationMessage", default, skip_serializing_if = "Option::is_none")]
    pub last_operation_message: Option<String>,
}
impl MaintenanceRedeployStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod maintenance_redeploy_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastOperationResultCode {
        None,
        RetryLater,
        MaintenanceAborted,
        MaintenanceCompleted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedDiskParameters {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<StorageAccountType>,
    #[serde(rename = "diskEncryptionSet", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set: Option<DiskEncryptionSetParameters>,
}
impl ManagedDiskParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceReference {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceReferenceProperties>,
}
impl NetworkInterfaceReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceReferenceProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
}
impl NetworkInterfaceReferenceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProfile {
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterfaceReference>,
}
impl NetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OsDisk {
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<os_disk::OsType>,
    #[serde(rename = "encryptionSettings", default, skip_serializing_if = "Option::is_none")]
    pub encryption_settings: Option<DiskEncryptionSettings>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vhd: Option<VirtualHardDisk>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[serde(rename = "writeAcceleratorEnabled", default, skip_serializing_if = "Option::is_none")]
    pub write_accelerator_enabled: Option<bool>,
    #[serde(rename = "diffDiskSettings", default, skip_serializing_if = "Option::is_none")]
    pub diff_disk_settings: Option<DiffDiskSettings>,
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<ManagedDiskParameters>,
}
impl OsDisk {
    pub fn new(create_option: CreateOption) -> Self {
        Self {
            os_type: None,
            encryption_settings: None,
            name: None,
            vhd: None,
            image: None,
            caching: None,
            write_accelerator_enabled: None,
            diff_disk_settings: None,
            create_option,
            disk_size_gb: None,
            managed_disk: None,
        }
    }
}
pub mod os_disk {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OsDiskImage {
    #[serde(rename = "operatingSystem")]
    pub operating_system: os_disk_image::OperatingSystem,
}
impl OsDiskImage {
    pub fn new(operating_system: os_disk_image::OperatingSystem) -> Self {
        Self { operating_system }
    }
}
pub mod os_disk_image {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperatingSystem {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsProfile {
    #[serde(rename = "computerName", default, skip_serializing_if = "Option::is_none")]
    pub computer_name: Option<String>,
    #[serde(rename = "adminUsername", default, skip_serializing_if = "Option::is_none")]
    pub admin_username: Option<String>,
    #[serde(rename = "adminPassword", default, skip_serializing_if = "Option::is_none")]
    pub admin_password: Option<String>,
    #[serde(rename = "customData", default, skip_serializing_if = "Option::is_none")]
    pub custom_data: Option<String>,
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[serde(rename = "linuxConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_configuration: Option<LinuxConfiguration>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub secrets: Vec<VaultSecretGroup>,
    #[serde(rename = "allowExtensionOperations", default, skip_serializing_if = "Option::is_none")]
    pub allow_extension_operations: Option<bool>,
    #[serde(rename = "requireGuestProvisionSignal", default, skip_serializing_if = "Option::is_none")]
    pub require_guest_provision_signal: Option<bool>,
}
impl OsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrchestrationServiceStateInput {
    #[serde(rename = "serviceName")]
    pub service_name: orchestration_service_state_input::ServiceName,
    pub action: orchestration_service_state_input::Action,
}
impl OrchestrationServiceStateInput {
    pub fn new(service_name: orchestration_service_state_input::ServiceName, action: orchestration_service_state_input::Action) -> Self {
        Self { service_name, action }
    }
}
pub mod orchestration_service_state_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceName {
        AutomaticRepairs,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Resume,
        Suspend,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OrchestrationServiceSummary {
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<orchestration_service_summary::ServiceName>,
    #[serde(rename = "serviceState", default, skip_serializing_if = "Option::is_none")]
    pub service_state: Option<orchestration_service_summary::ServiceState>,
}
impl OrchestrationServiceSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod orchestration_service_summary {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceName {
        AutomaticRepairs,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceState {
        NotRunning,
        Running,
        Suspended,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PatchSettings {
    #[serde(rename = "patchMode", default, skip_serializing_if = "Option::is_none")]
    pub patch_mode: Option<patch_settings::PatchMode>,
}
impl PatchSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod patch_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PatchMode {
        Manual,
        #[serde(rename = "AutomaticByOS")]
        AutomaticByOs,
        AutomaticByPlatform,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Plan {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub product: Option<String>,
    #[serde(rename = "promotionCode", default, skip_serializing_if = "Option::is_none")]
    pub promotion_code: Option<String>,
}
impl Plan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProximityPlacementGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProximityPlacementGroupProperties>,
}
impl ProximityPlacementGroup {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProximityPlacementGroupListResult {
    pub value: Vec<ProximityPlacementGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProximityPlacementGroupListResult {
    pub fn new(value: Vec<ProximityPlacementGroup>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProximityPlacementGroupProperties {
    #[serde(rename = "proximityPlacementGroupType", default, skip_serializing_if = "Option::is_none")]
    pub proximity_placement_group_type: Option<proximity_placement_group_properties::ProximityPlacementGroupType>,
    #[serde(rename = "virtualMachines", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_machines: Vec<SubResourceWithColocationStatus>,
    #[serde(rename = "virtualMachineScaleSets", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_machine_scale_sets: Vec<SubResourceWithColocationStatus>,
    #[serde(rename = "availabilitySets", default, skip_serializing_if = "Vec::is_empty")]
    pub availability_sets: Vec<SubResourceWithColocationStatus>,
    #[serde(rename = "colocationStatus", default, skip_serializing_if = "Option::is_none")]
    pub colocation_status: Option<InstanceViewStatus>,
}
impl ProximityPlacementGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod proximity_placement_group_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProximityPlacementGroupType {
        Standard,
        Ultra,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProximityPlacementGroupUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
}
impl ProximityPlacementGroupUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PurchasePlan {
    pub publisher: String,
    pub name: String,
    pub product: String,
}
impl PurchasePlan {
    pub fn new(publisher: String, name: String, product: String) -> Self {
        Self { publisher, name, product }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryWalkResponse {
    #[serde(rename = "walkPerformed", default, skip_serializing_if = "Option::is_none")]
    pub walk_performed: Option<bool>,
    #[serde(rename = "nextPlatformUpdateDomain", default, skip_serializing_if = "Option::is_none")]
    pub next_platform_update_domain: Option<i64>,
}
impl RecoveryWalkResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RequestRateByIntervalInput {
    #[serde(flatten)]
    pub log_analytics_input_base: LogAnalyticsInputBase,
    #[serde(rename = "intervalLength")]
    pub interval_length: request_rate_by_interval_input::IntervalLength,
}
impl RequestRateByIntervalInput {
    pub fn new(log_analytics_input_base: LogAnalyticsInputBase, interval_length: request_rate_by_interval_input::IntervalLength) -> Self {
        Self {
            log_analytics_input_base,
            interval_length,
        }
    }
}
pub mod request_rate_by_interval_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IntervalLength {
        ThreeMins,
        FiveMins,
        ThirtyMins,
        SixtyMins,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location: None,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetrieveBootDiagnosticsDataResult {
    #[serde(rename = "consoleScreenshotBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub console_screenshot_blob_uri: Option<String>,
    #[serde(rename = "serialConsoleLogBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub serial_console_log_blob_uri: Option<String>,
}
impl RetrieveBootDiagnosticsDataResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RollbackStatusInfo {
    #[serde(rename = "successfullyRolledbackInstanceCount", default, skip_serializing_if = "Option::is_none")]
    pub successfully_rolledback_instance_count: Option<i32>,
    #[serde(rename = "failedRolledbackInstanceCount", default, skip_serializing_if = "Option::is_none")]
    pub failed_rolledback_instance_count: Option<i32>,
    #[serde(rename = "rollbackError", default, skip_serializing_if = "Option::is_none")]
    pub rollback_error: Option<ApiError>,
}
impl RollbackStatusInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RollingUpgradePolicy {
    #[serde(rename = "maxBatchInstancePercent", default, skip_serializing_if = "Option::is_none")]
    pub max_batch_instance_percent: Option<i32>,
    #[serde(rename = "maxUnhealthyInstancePercent", default, skip_serializing_if = "Option::is_none")]
    pub max_unhealthy_instance_percent: Option<i32>,
    #[serde(rename = "maxUnhealthyUpgradedInstancePercent", default, skip_serializing_if = "Option::is_none")]
    pub max_unhealthy_upgraded_instance_percent: Option<i32>,
    #[serde(rename = "pauseTimeBetweenBatches", default, skip_serializing_if = "Option::is_none")]
    pub pause_time_between_batches: Option<String>,
}
impl RollingUpgradePolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RollingUpgradeProgressInfo {
    #[serde(rename = "successfulInstanceCount", default, skip_serializing_if = "Option::is_none")]
    pub successful_instance_count: Option<i32>,
    #[serde(rename = "failedInstanceCount", default, skip_serializing_if = "Option::is_none")]
    pub failed_instance_count: Option<i32>,
    #[serde(rename = "inProgressInstanceCount", default, skip_serializing_if = "Option::is_none")]
    pub in_progress_instance_count: Option<i32>,
    #[serde(rename = "pendingInstanceCount", default, skip_serializing_if = "Option::is_none")]
    pub pending_instance_count: Option<i32>,
}
impl RollingUpgradeProgressInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RollingUpgradeRunningStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<rolling_upgrade_running_status::Code>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "lastAction", default, skip_serializing_if = "Option::is_none")]
    pub last_action: Option<rolling_upgrade_running_status::LastAction>,
    #[serde(rename = "lastActionTime", default, skip_serializing_if = "Option::is_none")]
    pub last_action_time: Option<String>,
}
impl RollingUpgradeRunningStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod rolling_upgrade_running_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Code {
        RollingForward,
        Cancelled,
        Completed,
        Faulted,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastAction {
        Start,
        Cancel,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RollingUpgradeStatusInfo {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RollingUpgradeStatusInfoProperties>,
}
impl RollingUpgradeStatusInfo {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RollingUpgradeStatusInfoProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub policy: Option<RollingUpgradePolicy>,
    #[serde(rename = "runningStatus", default, skip_serializing_if = "Option::is_none")]
    pub running_status: Option<RollingUpgradeRunningStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub progress: Option<RollingUpgradeProgressInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
}
impl RollingUpgradeStatusInfoProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunCommandDocument {
    #[serde(flatten)]
    pub run_command_document_base: RunCommandDocumentBase,
    pub script: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<RunCommandParameterDefinition>,
}
impl RunCommandDocument {
    pub fn new(run_command_document_base: RunCommandDocumentBase, script: Vec<String>) -> Self {
        Self {
            run_command_document_base,
            script,
            parameters: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunCommandDocumentBase {
    #[serde(rename = "$schema")]
    pub schema: String,
    pub id: String,
    #[serde(rename = "osType")]
    pub os_type: run_command_document_base::OsType,
    pub label: String,
    pub description: String,
}
impl RunCommandDocumentBase {
    pub fn new(schema: String, id: String, os_type: run_command_document_base::OsType, label: String, description: String) -> Self {
        Self {
            schema,
            id,
            os_type,
            label,
            description,
        }
    }
}
pub mod run_command_document_base {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunCommandInput {
    #[serde(rename = "commandId")]
    pub command_id: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub script: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<RunCommandInputParameter>,
}
impl RunCommandInput {
    pub fn new(command_id: String) -> Self {
        Self {
            command_id,
            script: Vec::new(),
            parameters: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunCommandInputParameter {
    pub name: String,
    pub value: String,
}
impl RunCommandInputParameter {
    pub fn new(name: String, value: String) -> Self {
        Self { name, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunCommandListResult {
    pub value: Vec<RunCommandDocumentBase>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RunCommandListResult {
    pub fn new(value: Vec<RunCommandDocumentBase>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunCommandParameterDefinition {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub required: Option<bool>,
}
impl RunCommandParameterDefinition {
    pub fn new(name: String, type_: String) -> Self {
        Self {
            name,
            type_,
            default_value: None,
            required: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunCommandResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<InstanceViewStatus>,
}
impl RunCommandResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScaleInPolicy {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<String>,
}
impl ScaleInPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduledEventsProfile {
    #[serde(rename = "terminateNotificationProfile", default, skip_serializing_if = "Option::is_none")]
    pub terminate_notification_profile: Option<TerminateNotificationProfile>,
}
impl ScheduledEventsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityProfile {
    #[serde(rename = "encryptionAtHost", default, skip_serializing_if = "Option::is_none")]
    pub encryption_at_host: Option<bool>,
}
impl SecurityProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i64>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SshConfiguration {
    #[serde(rename = "publicKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub public_keys: Vec<SshPublicKey>,
}
impl SshConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SshPublicKey {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "keyData", default, skip_serializing_if = "Option::is_none")]
    pub key_data: Option<String>,
}
impl SshPublicKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SshPublicKeyGenerateKeyPairResult {
    #[serde(rename = "privateKey")]
    pub private_key: String,
    #[serde(rename = "publicKey")]
    pub public_key: String,
    pub id: String,
}
impl SshPublicKeyGenerateKeyPairResult {
    pub fn new(private_key: String, public_key: String, id: String) -> Self {
        Self {
            private_key,
            public_key,
            id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SshPublicKeyResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SshPublicKeyResourceProperties>,
}
impl SshPublicKeyResource {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SshPublicKeyResourceProperties {
    #[serde(rename = "publicKey", default, skip_serializing_if = "Option::is_none")]
    pub public_key: Option<String>,
}
impl SshPublicKeyResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SshPublicKeyUpdateResource {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SshPublicKeyResourceProperties>,
}
impl SshPublicKeyUpdateResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SshPublicKeysGroupListResult {
    pub value: Vec<SshPublicKeyResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SshPublicKeysGroupListResult {
    pub fn new(value: Vec<SshPublicKeyResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum StorageAccountType {
    #[serde(rename = "Standard_LRS")]
    StandardLrs,
    #[serde(rename = "Premium_LRS")]
    PremiumLrs,
    #[serde(rename = "StandardSSD_LRS")]
    StandardSsdLrs,
    #[serde(rename = "UltraSSD_LRS")]
    UltraSsdLrs,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageProfile {
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<ImageReference>,
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<OsDisk>,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<DataDisk>,
}
impl StorageProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResourceReadOnly {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResourceReadOnly {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResourceWithColocationStatus {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(rename = "colocationStatus", default, skip_serializing_if = "Option::is_none")]
    pub colocation_status: Option<InstanceViewStatus>,
}
impl SubResourceWithColocationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TerminateNotificationProfile {
    #[serde(rename = "notBeforeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub not_before_timeout: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enable: Option<bool>,
}
impl TerminateNotificationProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThrottledRequestsInput {
    #[serde(flatten)]
    pub log_analytics_input_base: LogAnalyticsInputBase,
}
impl ThrottledRequestsInput {
    pub fn new(log_analytics_input_base: LogAnalyticsInputBase) -> Self {
        Self { log_analytics_input_base }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl UpdateResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpgradeOperationHistoricalStatusInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpgradeOperationHistoricalStatusInfoProperties>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl UpgradeOperationHistoricalStatusInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpgradeOperationHistoricalStatusInfoProperties {
    #[serde(rename = "runningStatus", default, skip_serializing_if = "Option::is_none")]
    pub running_status: Option<UpgradeOperationHistoryStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub progress: Option<RollingUpgradeProgressInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
    #[serde(rename = "startedBy", default, skip_serializing_if = "Option::is_none")]
    pub started_by: Option<upgrade_operation_historical_status_info_properties::StartedBy>,
    #[serde(rename = "targetImageReference", default, skip_serializing_if = "Option::is_none")]
    pub target_image_reference: Option<ImageReference>,
    #[serde(rename = "rollbackInfo", default, skip_serializing_if = "Option::is_none")]
    pub rollback_info: Option<RollbackStatusInfo>,
}
impl UpgradeOperationHistoricalStatusInfoProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod upgrade_operation_historical_status_info_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StartedBy {
        Unknown,
        User,
        Platform,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpgradeOperationHistoryStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<upgrade_operation_history_status::Code>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl UpgradeOperationHistoryStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod upgrade_operation_history_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Code {
        RollingForward,
        Cancelled,
        Completed,
        Faulted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpgradePolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<upgrade_policy::Mode>,
    #[serde(rename = "rollingUpgradePolicy", default, skip_serializing_if = "Option::is_none")]
    pub rolling_upgrade_policy: Option<RollingUpgradePolicy>,
    #[serde(rename = "automaticOSUpgradePolicy", default, skip_serializing_if = "Option::is_none")]
    pub automatic_os_upgrade_policy: Option<AutomaticOsUpgradePolicy>,
}
impl UpgradePolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod upgrade_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        Automatic,
        Manual,
        Rolling,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    pub unit: usage::Unit,
    #[serde(rename = "currentValue")]
    pub current_value: i32,
    pub limit: i64,
    pub name: UsageName,
}
impl Usage {
    pub fn new(unit: usage::Unit, current_value: i32, limit: i64, name: UsageName) -> Self {
        Self {
            unit,
            current_value,
            limit,
            name,
        }
    }
}
pub mod usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmScaleSetConvertToSinglePlacementGroupInput {
    #[serde(rename = "activePlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub active_placement_group_id: Option<String>,
}
impl VmScaleSetConvertToSinglePlacementGroupInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultCertificate {
    #[serde(rename = "certificateUrl", default, skip_serializing_if = "Option::is_none")]
    pub certificate_url: Option<String>,
    #[serde(rename = "certificateStore", default, skip_serializing_if = "Option::is_none")]
    pub certificate_store: Option<String>,
}
impl VaultCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultSecretGroup {
    #[serde(rename = "sourceVault", default, skip_serializing_if = "Option::is_none")]
    pub source_vault: Option<SubResource>,
    #[serde(rename = "vaultCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vault_certificates: Vec<VaultCertificate>,
}
impl VaultSecretGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHardDisk {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
}
impl VirtualHardDisk {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachine {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineProperties>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<VirtualMachineExtension>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<VirtualMachineIdentity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl VirtualMachine {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            plan: None,
            properties: None,
            resources: Vec::new(),
            identity: None,
            zones: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineAgentInstanceView {
    #[serde(rename = "vmAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub vm_agent_version: Option<String>,
    #[serde(rename = "extensionHandlers", default, skip_serializing_if = "Vec::is_empty")]
    pub extension_handlers: Vec<VirtualMachineExtensionHandlerInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineAgentInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineAssessPatchesResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<virtual_machine_assess_patches_result::Status>,
    #[serde(rename = "assessmentActivityId", default, skip_serializing_if = "Option::is_none")]
    pub assessment_activity_id: Option<String>,
    #[serde(rename = "rebootPending", default, skip_serializing_if = "Option::is_none")]
    pub reboot_pending: Option<bool>,
    #[serde(rename = "criticalAndSecurityPatchCount", default, skip_serializing_if = "Option::is_none")]
    pub critical_and_security_patch_count: Option<i32>,
    #[serde(rename = "otherPatchCount", default, skip_serializing_if = "Option::is_none")]
    pub other_patch_count: Option<i32>,
    #[serde(rename = "startDateTime", default, skip_serializing_if = "Option::is_none")]
    pub start_date_time: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub patches: Vec<VirtualMachineSoftwarePatchProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
}
impl VirtualMachineAssessPatchesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_assess_patches_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Failed,
        Succeeded,
        CompletedWithWarnings,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineCaptureParameters {
    #[serde(rename = "vhdPrefix")]
    pub vhd_prefix: String,
    #[serde(rename = "destinationContainerName")]
    pub destination_container_name: String,
    #[serde(rename = "overwriteVhds")]
    pub overwrite_vhds: bool,
}
impl VirtualMachineCaptureParameters {
    pub fn new(vhd_prefix: String, destination_container_name: String, overwrite_vhds: bool) -> Self {
        Self {
            vhd_prefix,
            destination_container_name,
            overwrite_vhds,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineCaptureResult {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(rename = "$schema", default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    #[serde(rename = "contentVersion", default, skip_serializing_if = "Option::is_none")]
    pub content_version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<serde_json::Value>,
}
impl VirtualMachineCaptureResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineExtension {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionProperties>,
}
impl VirtualMachineExtension {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionHandlerInstanceView {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<InstanceViewStatus>,
}
impl VirtualMachineExtensionHandlerInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineExtensionImage {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionImageProperties>,
}
impl VirtualMachineExtensionImage {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineExtensionImageProperties {
    #[serde(rename = "operatingSystem")]
    pub operating_system: String,
    #[serde(rename = "computeRole")]
    pub compute_role: String,
    #[serde(rename = "handlerSchema")]
    pub handler_schema: String,
    #[serde(rename = "vmScaleSetEnabled", default, skip_serializing_if = "Option::is_none")]
    pub vm_scale_set_enabled: Option<bool>,
    #[serde(rename = "supportsMultipleExtensions", default, skip_serializing_if = "Option::is_none")]
    pub supports_multiple_extensions: Option<bool>,
}
impl VirtualMachineExtensionImageProperties {
    pub fn new(operating_system: String, compute_role: String, handler_schema: String) -> Self {
        Self {
            operating_system,
            compute_role,
            handler_schema,
            vm_scale_set_enabled: None,
            supports_multiple_extensions: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionInstanceView {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub substatuses: Vec<InstanceViewStatus>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineExtensionInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionProperties {
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_minor_version: Option<bool>,
    #[serde(rename = "enableAutomaticUpgrade", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_upgrade: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<serde_json::Value>,
    #[serde(rename = "protectedSettings", default, skip_serializing_if = "Option::is_none")]
    pub protected_settings: Option<serde_json::Value>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineExtensionInstanceView>,
}
impl VirtualMachineExtensionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionUpdateProperties>,
}
impl VirtualMachineExtensionUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionUpdateProperties {
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_minor_version: Option<bool>,
    #[serde(rename = "enableAutomaticUpgrade", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_upgrade: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<serde_json::Value>,
    #[serde(rename = "protectedSettings", default, skip_serializing_if = "Option::is_none")]
    pub protected_settings: Option<serde_json::Value>,
}
impl VirtualMachineExtensionUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineExtensionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualMachineExtension>,
}
impl VirtualMachineExtensionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineHealthStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<InstanceViewStatus>,
}
impl VirtualMachineHealthStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<virtual_machine_identity::Type>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl VirtualMachineIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineImage {
    #[serde(flatten)]
    pub virtual_machine_image_resource: VirtualMachineImageResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineImageProperties>,
}
impl VirtualMachineImage {
    pub fn new(virtual_machine_image_resource: VirtualMachineImageResource) -> Self {
        Self {
            virtual_machine_image_resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineImageProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<PurchasePlan>,
    #[serde(rename = "osDiskImage", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_image: Option<OsDiskImage>,
    #[serde(rename = "dataDiskImages", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disk_images: Vec<DataDiskImage>,
    #[serde(rename = "automaticOSUpgradeProperties", default, skip_serializing_if = "Option::is_none")]
    pub automatic_os_upgrade_properties: Option<AutomaticOsUpgradeProperties>,
    #[serde(rename = "hyperVGeneration", default, skip_serializing_if = "Option::is_none")]
    pub hyper_v_generation: Option<HyperVGenerationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disallowed: Option<DisallowedConfiguration>,
}
impl VirtualMachineImageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineImageResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub name: String,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl VirtualMachineImageResource {
    pub fn new(name: String, location: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            name,
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineInstanceView {
    #[serde(rename = "platformUpdateDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_update_domain: Option<i32>,
    #[serde(rename = "platformFaultDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain: Option<i32>,
    #[serde(rename = "computerName", default, skip_serializing_if = "Option::is_none")]
    pub computer_name: Option<String>,
    #[serde(rename = "osName", default, skip_serializing_if = "Option::is_none")]
    pub os_name: Option<String>,
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[serde(rename = "hyperVGeneration", default, skip_serializing_if = "Option::is_none")]
    pub hyper_v_generation: Option<virtual_machine_instance_view::HyperVGeneration>,
    #[serde(rename = "rdpThumbPrint", default, skip_serializing_if = "Option::is_none")]
    pub rdp_thumb_print: Option<String>,
    #[serde(rename = "vmAgent", default, skip_serializing_if = "Option::is_none")]
    pub vm_agent: Option<VirtualMachineAgentInstanceView>,
    #[serde(rename = "maintenanceRedeployStatus", default, skip_serializing_if = "Option::is_none")]
    pub maintenance_redeploy_status: Option<MaintenanceRedeployStatus>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<DiskInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineExtensionInstanceView>,
    #[serde(rename = "vmHealth", default, skip_serializing_if = "Option::is_none")]
    pub vm_health: Option<VirtualMachineHealthStatus>,
    #[serde(rename = "bootDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub boot_diagnostics: Option<BootDiagnosticsInstanceView>,
    #[serde(rename = "assignedHost", default, skip_serializing_if = "Option::is_none")]
    pub assigned_host: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
    #[serde(rename = "patchStatus", default, skip_serializing_if = "Option::is_none")]
    pub patch_status: Option<VirtualMachinePatchStatus>,
}
impl VirtualMachineInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_instance_view {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HyperVGeneration {
        V1,
        V2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineListResult {
    pub value: Vec<VirtualMachine>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineListResult {
    pub fn new(value: Vec<VirtualMachine>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachinePatchStatus {
    #[serde(rename = "availablePatchSummary", default, skip_serializing_if = "Option::is_none")]
    pub available_patch_summary: Option<AvailablePatchSummary>,
    #[serde(rename = "lastPatchInstallationSummary", default, skip_serializing_if = "Option::is_none")]
    pub last_patch_installation_summary: Option<LastPatchInstallationSummary>,
}
impl VirtualMachinePatchStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineProperties {
    #[serde(rename = "hardwareProfile", default, skip_serializing_if = "Option::is_none")]
    pub hardware_profile: Option<HardwareProfile>,
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<StorageProfile>,
    #[serde(rename = "additionalCapabilities", default, skip_serializing_if = "Option::is_none")]
    pub additional_capabilities: Option<AdditionalCapabilities>,
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<OsProfile>,
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<NetworkProfile>,
    #[serde(rename = "securityProfile", default, skip_serializing_if = "Option::is_none")]
    pub security_profile: Option<SecurityProfile>,
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<DiagnosticsProfile>,
    #[serde(rename = "availabilitySet", default, skip_serializing_if = "Option::is_none")]
    pub availability_set: Option<SubResource>,
    #[serde(rename = "virtualMachineScaleSet", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_scale_set: Option<SubResource>,
    #[serde(rename = "proximityPlacementGroup", default, skip_serializing_if = "Option::is_none")]
    pub proximity_placement_group: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<Priority>,
    #[serde(rename = "evictionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub eviction_policy: Option<EvictionPolicy>,
    #[serde(rename = "billingProfile", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile: Option<BillingProfile>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<SubResource>,
    #[serde(rename = "hostGroup", default, skip_serializing_if = "Option::is_none")]
    pub host_group: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineInstanceView>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "extensionsTimeBudget", default, skip_serializing_if = "Option::is_none")]
    pub extensions_time_budget: Option<String>,
}
impl VirtualMachineProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineReimageParameters {
    #[serde(rename = "tempDisk", default, skip_serializing_if = "Option::is_none")]
    pub temp_disk: Option<bool>,
}
impl VirtualMachineReimageParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineRunCommand {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineRunCommandProperties>,
}
impl VirtualMachineRunCommand {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineRunCommandInstanceView {
    #[serde(rename = "executionState", default, skip_serializing_if = "Option::is_none")]
    pub execution_state: Option<virtual_machine_run_command_instance_view::ExecutionState>,
    #[serde(rename = "executionMessage", default, skip_serializing_if = "Option::is_none")]
    pub execution_message: Option<String>,
    #[serde(rename = "exitCode", default, skip_serializing_if = "Option::is_none")]
    pub exit_code: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
}
impl VirtualMachineRunCommandInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_run_command_instance_view {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ExecutionState {
        Unknown,
        Pending,
        Running,
        Failed,
        Succeeded,
        TimedOut,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineRunCommandProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<VirtualMachineRunCommandScriptSource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<RunCommandInputParameter>,
    #[serde(rename = "protectedParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_parameters: Vec<RunCommandInputParameter>,
    #[serde(rename = "asyncExecution", default, skip_serializing_if = "Option::is_none")]
    pub async_execution: Option<bool>,
    #[serde(rename = "runAsUser", default, skip_serializing_if = "Option::is_none")]
    pub run_as_user: Option<String>,
    #[serde(rename = "runAsPassword", default, skip_serializing_if = "Option::is_none")]
    pub run_as_password: Option<String>,
    #[serde(rename = "timeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_in_seconds: Option<i32>,
    #[serde(rename = "outputBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub output_blob_uri: Option<String>,
    #[serde(rename = "errorBlobUri", default, skip_serializing_if = "Option::is_none")]
    pub error_blob_uri: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineRunCommandInstanceView>,
}
impl VirtualMachineRunCommandProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineRunCommandScriptSource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<String>,
    #[serde(rename = "scriptUri", default, skip_serializing_if = "Option::is_none")]
    pub script_uri: Option<String>,
    #[serde(rename = "commandId", default, skip_serializing_if = "Option::is_none")]
    pub command_id: Option<String>,
}
impl VirtualMachineRunCommandScriptSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineRunCommandUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineRunCommandProperties>,
}
impl VirtualMachineRunCommandUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineRunCommandsListResult {
    pub value: Vec<VirtualMachineRunCommand>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineRunCommandsListResult {
    pub fn new(value: Vec<VirtualMachineRunCommand>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSet {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<VirtualMachineScaleSetIdentity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl VirtualMachineScaleSet {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            sku: None,
            plan: None,
            properties: None,
            identity: None,
            zones: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetDataDisk {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    pub lun: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[serde(rename = "writeAcceleratorEnabled", default, skip_serializing_if = "Option::is_none")]
    pub write_accelerator_enabled: Option<bool>,
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<VirtualMachineScaleSetManagedDiskParameters>,
    #[serde(rename = "diskIOPSReadWrite", default, skip_serializing_if = "Option::is_none")]
    pub disk_iops_read_write: Option<i64>,
    #[serde(rename = "diskMBpsReadWrite", default, skip_serializing_if = "Option::is_none")]
    pub disk_m_bps_read_write: Option<i64>,
}
impl VirtualMachineScaleSetDataDisk {
    pub fn new(lun: i32, create_option: CreateOption) -> Self {
        Self {
            name: None,
            lun,
            caching: None,
            write_accelerator_enabled: None,
            create_option,
            disk_size_gb: None,
            managed_disk: None,
            disk_iops_read_write: None,
            disk_m_bps_read_write: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtension {
    #[serde(flatten)]
    pub sub_resource_read_only: SubResourceReadOnly,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetExtensionProperties>,
}
impl VirtualMachineScaleSetExtension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetExtensionListResult {
    pub value: Vec<VirtualMachineScaleSetExtension>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetExtensionListResult {
    pub fn new(value: Vec<VirtualMachineScaleSetExtension>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtensionProfile {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineScaleSetExtension>,
    #[serde(rename = "extensionsTimeBudget", default, skip_serializing_if = "Option::is_none")]
    pub extensions_time_budget: Option<String>,
}
impl VirtualMachineScaleSetExtensionProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtensionProperties {
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "typeHandlerVersion", default, skip_serializing_if = "Option::is_none")]
    pub type_handler_version: Option<String>,
    #[serde(rename = "autoUpgradeMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub auto_upgrade_minor_version: Option<bool>,
    #[serde(rename = "enableAutomaticUpgrade", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_upgrade: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<serde_json::Value>,
    #[serde(rename = "protectedSettings", default, skip_serializing_if = "Option::is_none")]
    pub protected_settings: Option<serde_json::Value>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "provisionAfterExtensions", default, skip_serializing_if = "Vec::is_empty")]
    pub provision_after_extensions: Vec<String>,
}
impl VirtualMachineScaleSetExtensionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetExtensionUpdate {
    #[serde(flatten)]
    pub sub_resource_read_only: SubResourceReadOnly,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetExtensionProperties>,
}
impl VirtualMachineScaleSetExtensionUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetIpConfigurationProperties>,
}
impl VirtualMachineScaleSetIpConfiguration {
    pub fn new(name: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            name,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetIpConfigurationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<ApiEntityReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "publicIPAddressConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_configuration: Option<VirtualMachineScaleSetPublicIpAddressConfiguration>,
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<virtual_machine_scale_set_ip_configuration_properties::PrivateIpAddressVersion>,
    #[serde(rename = "applicationGatewayBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_backend_address_pools: Vec<SubResource>,
    #[serde(rename = "applicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub application_security_groups: Vec<SubResource>,
    #[serde(rename = "loadBalancerBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_address_pools: Vec<SubResource>,
    #[serde(rename = "loadBalancerInboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_inbound_nat_pools: Vec<SubResource>,
}
impl VirtualMachineScaleSetIpConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_scale_set_ip_configuration_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAddressVersion {
        IPv4,
        IPv6,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<virtual_machine_scale_set_identity::Type>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl VirtualMachineScaleSetIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_scale_set_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetInstanceView {
    #[serde(rename = "virtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine: Option<VirtualMachineScaleSetInstanceViewStatusesSummary>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineScaleSetVmExtensionsSummary>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
    #[serde(rename = "orchestrationServices", default, skip_serializing_if = "Vec::is_empty")]
    pub orchestration_services: Vec<OrchestrationServiceSummary>,
}
impl VirtualMachineScaleSetInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetInstanceViewStatusesSummary {
    #[serde(rename = "statusesSummary", default, skip_serializing_if = "Vec::is_empty")]
    pub statuses_summary: Vec<VirtualMachineStatusCodeCount>,
}
impl VirtualMachineScaleSetInstanceViewStatusesSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetIpTag {
    #[serde(rename = "ipTagType", default, skip_serializing_if = "Option::is_none")]
    pub ip_tag_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
}
impl VirtualMachineScaleSetIpTag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListOsUpgradeHistory {
    pub value: Vec<UpgradeOperationHistoricalStatusInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListOsUpgradeHistory {
    pub fn new(value: Vec<UpgradeOperationHistoricalStatusInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListResult {
    pub value: Vec<VirtualMachineScaleSet>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListResult {
    pub fn new(value: Vec<VirtualMachineScaleSet>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListSkusResult {
    pub value: Vec<VirtualMachineScaleSetSku>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListSkusResult {
    pub fn new(value: Vec<VirtualMachineScaleSetSku>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetListWithLinkResult {
    pub value: Vec<VirtualMachineScaleSet>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetListWithLinkResult {
    pub fn new(value: Vec<VirtualMachineScaleSet>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetManagedDiskParameters {
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<StorageAccountType>,
    #[serde(rename = "diskEncryptionSet", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set: Option<DiskEncryptionSetParameters>,
}
impl VirtualMachineScaleSetManagedDiskParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetNetworkConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetNetworkConfigurationProperties>,
}
impl VirtualMachineScaleSetNetworkConfiguration {
    pub fn new(name: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            name,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetNetworkConfigurationDnsSettings {
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
}
impl VirtualMachineScaleSetNetworkConfigurationDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetNetworkConfigurationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "enableAcceleratedNetworking", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking: Option<bool>,
    #[serde(rename = "enableFpga", default, skip_serializing_if = "Option::is_none")]
    pub enable_fpga: Option<bool>,
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<SubResource>,
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<VirtualMachineScaleSetNetworkConfigurationDnsSettings>,
    #[serde(rename = "ipConfigurations")]
    pub ip_configurations: Vec<VirtualMachineScaleSetIpConfiguration>,
    #[serde(rename = "enableIPForwarding", default, skip_serializing_if = "Option::is_none")]
    pub enable_ip_forwarding: Option<bool>,
}
impl VirtualMachineScaleSetNetworkConfigurationProperties {
    pub fn new(ip_configurations: Vec<VirtualMachineScaleSetIpConfiguration>) -> Self {
        Self {
            primary: None,
            enable_accelerated_networking: None,
            enable_fpga: None,
            network_security_group: None,
            dns_settings: None,
            ip_configurations,
            enable_ip_forwarding: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetNetworkProfile {
    #[serde(rename = "healthProbe", default, skip_serializing_if = "Option::is_none")]
    pub health_probe: Option<ApiEntityReference>,
    #[serde(rename = "networkInterfaceConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interface_configurations: Vec<VirtualMachineScaleSetNetworkConfiguration>,
}
impl VirtualMachineScaleSetNetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetOsDisk {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[serde(rename = "writeAcceleratorEnabled", default, skip_serializing_if = "Option::is_none")]
    pub write_accelerator_enabled: Option<bool>,
    #[serde(rename = "createOption")]
    pub create_option: CreateOption,
    #[serde(rename = "diffDiskSettings", default, skip_serializing_if = "Option::is_none")]
    pub diff_disk_settings: Option<DiffDiskSettings>,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<virtual_machine_scale_set_os_disk::OsType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[serde(rename = "vhdContainers", default, skip_serializing_if = "Vec::is_empty")]
    pub vhd_containers: Vec<String>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<VirtualMachineScaleSetManagedDiskParameters>,
}
impl VirtualMachineScaleSetOsDisk {
    pub fn new(create_option: CreateOption) -> Self {
        Self {
            name: None,
            caching: None,
            write_accelerator_enabled: None,
            create_option,
            diff_disk_settings: None,
            disk_size_gb: None,
            os_type: None,
            image: None,
            vhd_containers: Vec::new(),
            managed_disk: None,
        }
    }
}
pub mod virtual_machine_scale_set_os_disk {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetOsProfile {
    #[serde(rename = "computerNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub computer_name_prefix: Option<String>,
    #[serde(rename = "adminUsername", default, skip_serializing_if = "Option::is_none")]
    pub admin_username: Option<String>,
    #[serde(rename = "adminPassword", default, skip_serializing_if = "Option::is_none")]
    pub admin_password: Option<String>,
    #[serde(rename = "customData", default, skip_serializing_if = "Option::is_none")]
    pub custom_data: Option<String>,
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[serde(rename = "linuxConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_configuration: Option<LinuxConfiguration>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub secrets: Vec<VaultSecretGroup>,
}
impl VirtualMachineScaleSetOsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetProperties {
    #[serde(rename = "upgradePolicy", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_policy: Option<UpgradePolicy>,
    #[serde(rename = "automaticRepairsPolicy", default, skip_serializing_if = "Option::is_none")]
    pub automatic_repairs_policy: Option<AutomaticRepairsPolicy>,
    #[serde(rename = "virtualMachineProfile", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_profile: Option<VirtualMachineScaleSetVmProfile>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub overprovision: Option<bool>,
    #[serde(
        rename = "doNotRunExtensionsOnOverprovisionedVMs",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub do_not_run_extensions_on_overprovisioned_v_ms: Option<bool>,
    #[serde(rename = "uniqueId", default, skip_serializing_if = "Option::is_none")]
    pub unique_id: Option<String>,
    #[serde(rename = "singlePlacementGroup", default, skip_serializing_if = "Option::is_none")]
    pub single_placement_group: Option<bool>,
    #[serde(rename = "zoneBalance", default, skip_serializing_if = "Option::is_none")]
    pub zone_balance: Option<bool>,
    #[serde(rename = "platformFaultDomainCount", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain_count: Option<i32>,
    #[serde(rename = "proximityPlacementGroup", default, skip_serializing_if = "Option::is_none")]
    pub proximity_placement_group: Option<SubResource>,
    #[serde(rename = "hostGroup", default, skip_serializing_if = "Option::is_none")]
    pub host_group: Option<SubResource>,
    #[serde(rename = "additionalCapabilities", default, skip_serializing_if = "Option::is_none")]
    pub additional_capabilities: Option<AdditionalCapabilities>,
    #[serde(rename = "scaleInPolicy", default, skip_serializing_if = "Option::is_none")]
    pub scale_in_policy: Option<ScaleInPolicy>,
}
impl VirtualMachineScaleSetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetPublicIpAddressConfiguration {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetPublicIpAddressConfigurationProperties>,
}
impl VirtualMachineScaleSetPublicIpAddressConfiguration {
    pub fn new(name: String) -> Self {
        Self { name, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings {
    #[serde(rename = "domainNameLabel")]
    pub domain_name_label: String,
}
impl VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings {
    pub fn new(domain_name_label: String) -> Self {
        Self { domain_name_label }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetPublicIpAddressConfigurationProperties {
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings>,
    #[serde(rename = "ipTags", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_tags: Vec<VirtualMachineScaleSetIpTag>,
    #[serde(rename = "publicIPPrefix", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_prefix: Option<SubResource>,
    #[serde(rename = "publicIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_version: Option<virtual_machine_scale_set_public_ip_address_configuration_properties::PublicIpAddressVersion>,
}
impl VirtualMachineScaleSetPublicIpAddressConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_scale_set_public_ip_address_configuration_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicIpAddressVersion {
        IPv4,
        IPv6,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetReimageParameters {
    #[serde(flatten)]
    pub virtual_machine_scale_set_vm_reimage_parameters: VirtualMachineScaleSetVmReimageParameters,
    #[serde(rename = "instanceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub instance_ids: Vec<String>,
}
impl VirtualMachineScaleSetReimageParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetSku {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<VirtualMachineScaleSetSkuCapacity>,
}
impl VirtualMachineScaleSetSku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetSkuCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i64>,
    #[serde(rename = "defaultCapacity", default, skip_serializing_if = "Option::is_none")]
    pub default_capacity: Option<i64>,
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<virtual_machine_scale_set_sku_capacity::ScaleType>,
}
impl VirtualMachineScaleSetSkuCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_scale_set_sku_capacity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScaleType {
        Automatic,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetStorageProfile {
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<ImageReference>,
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<VirtualMachineScaleSetOsDisk>,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<VirtualMachineScaleSetDataDisk>,
}
impl VirtualMachineScaleSetStorageProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetUpdateProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<VirtualMachineScaleSetIdentity>,
}
impl VirtualMachineScaleSetUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetUpdateIpConfigurationProperties>,
}
impl VirtualMachineScaleSetUpdateIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateIpConfigurationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<ApiEntityReference>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "publicIPAddressConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_configuration: Option<VirtualMachineScaleSetUpdatePublicIpAddressConfiguration>,
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<virtual_machine_scale_set_update_ip_configuration_properties::PrivateIpAddressVersion>,
    #[serde(rename = "applicationGatewayBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_backend_address_pools: Vec<SubResource>,
    #[serde(rename = "applicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub application_security_groups: Vec<SubResource>,
    #[serde(rename = "loadBalancerBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_address_pools: Vec<SubResource>,
    #[serde(rename = "loadBalancerInboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_inbound_nat_pools: Vec<SubResource>,
}
impl VirtualMachineScaleSetUpdateIpConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_scale_set_update_ip_configuration_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAddressVersion {
        IPv4,
        IPv6,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateNetworkConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetUpdateNetworkConfigurationProperties>,
}
impl VirtualMachineScaleSetUpdateNetworkConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateNetworkConfigurationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "enableAcceleratedNetworking", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking: Option<bool>,
    #[serde(rename = "enableFpga", default, skip_serializing_if = "Option::is_none")]
    pub enable_fpga: Option<bool>,
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<SubResource>,
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<VirtualMachineScaleSetNetworkConfigurationDnsSettings>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<VirtualMachineScaleSetUpdateIpConfiguration>,
    #[serde(rename = "enableIPForwarding", default, skip_serializing_if = "Option::is_none")]
    pub enable_ip_forwarding: Option<bool>,
}
impl VirtualMachineScaleSetUpdateNetworkConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateNetworkProfile {
    #[serde(rename = "healthProbe", default, skip_serializing_if = "Option::is_none")]
    pub health_probe: Option<ApiEntityReference>,
    #[serde(rename = "networkInterfaceConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interface_configurations: Vec<VirtualMachineScaleSetUpdateNetworkConfiguration>,
}
impl VirtualMachineScaleSetUpdateNetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateOsDisk {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<Caching>,
    #[serde(rename = "writeAcceleratorEnabled", default, skip_serializing_if = "Option::is_none")]
    pub write_accelerator_enabled: Option<bool>,
    #[serde(rename = "diskSizeGB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_gb: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub image: Option<VirtualHardDisk>,
    #[serde(rename = "vhdContainers", default, skip_serializing_if = "Vec::is_empty")]
    pub vhd_containers: Vec<String>,
    #[serde(rename = "managedDisk", default, skip_serializing_if = "Option::is_none")]
    pub managed_disk: Option<VirtualMachineScaleSetManagedDiskParameters>,
}
impl VirtualMachineScaleSetUpdateOsDisk {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateOsProfile {
    #[serde(rename = "customData", default, skip_serializing_if = "Option::is_none")]
    pub custom_data: Option<String>,
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[serde(rename = "linuxConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_configuration: Option<LinuxConfiguration>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub secrets: Vec<VaultSecretGroup>,
}
impl VirtualMachineScaleSetUpdateOsProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateProperties {
    #[serde(rename = "upgradePolicy", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_policy: Option<UpgradePolicy>,
    #[serde(rename = "automaticRepairsPolicy", default, skip_serializing_if = "Option::is_none")]
    pub automatic_repairs_policy: Option<AutomaticRepairsPolicy>,
    #[serde(rename = "virtualMachineProfile", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_profile: Option<VirtualMachineScaleSetUpdateVmProfile>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub overprovision: Option<bool>,
    #[serde(
        rename = "doNotRunExtensionsOnOverprovisionedVMs",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub do_not_run_extensions_on_overprovisioned_v_ms: Option<bool>,
    #[serde(rename = "singlePlacementGroup", default, skip_serializing_if = "Option::is_none")]
    pub single_placement_group: Option<bool>,
    #[serde(rename = "additionalCapabilities", default, skip_serializing_if = "Option::is_none")]
    pub additional_capabilities: Option<AdditionalCapabilities>,
    #[serde(rename = "scaleInPolicy", default, skip_serializing_if = "Option::is_none")]
    pub scale_in_policy: Option<ScaleInPolicy>,
    #[serde(rename = "proximityPlacementGroup", default, skip_serializing_if = "Option::is_none")]
    pub proximity_placement_group: Option<SubResource>,
}
impl VirtualMachineScaleSetUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdatePublicIpAddressConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties>,
}
impl VirtualMachineScaleSetUpdatePublicIpAddressConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties {
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings>,
}
impl VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateStorageProfile {
    #[serde(rename = "imageReference", default, skip_serializing_if = "Option::is_none")]
    pub image_reference: Option<ImageReference>,
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<VirtualMachineScaleSetUpdateOsDisk>,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<VirtualMachineScaleSetDataDisk>,
}
impl VirtualMachineScaleSetUpdateStorageProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetUpdateVmProfile {
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<VirtualMachineScaleSetUpdateOsProfile>,
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<VirtualMachineScaleSetUpdateStorageProfile>,
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<VirtualMachineScaleSetUpdateNetworkProfile>,
    #[serde(rename = "securityProfile", default, skip_serializing_if = "Option::is_none")]
    pub security_profile: Option<SecurityProfile>,
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<DiagnosticsProfile>,
    #[serde(rename = "extensionProfile", default, skip_serializing_if = "Option::is_none")]
    pub extension_profile: Option<VirtualMachineScaleSetExtensionProfile>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "billingProfile", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile: Option<BillingProfile>,
    #[serde(rename = "scheduledEventsProfile", default, skip_serializing_if = "Option::is_none")]
    pub scheduled_events_profile: Option<ScheduledEventsProfile>,
}
impl VirtualMachineScaleSetUpdateVmProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetVm {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineScaleSetVmProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<VirtualMachineExtension>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl VirtualMachineScaleSetVm {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            instance_id: None,
            sku: None,
            properties: None,
            plan: None,
            resources: Vec::new(),
            zones: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmExtension {
    #[serde(flatten)]
    pub sub_resource_read_only: SubResourceReadOnly,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionProperties>,
}
impl VirtualMachineScaleSetVmExtension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmExtensionUpdate {
    #[serde(flatten)]
    pub sub_resource_read_only: SubResourceReadOnly,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineExtensionUpdateProperties>,
}
impl VirtualMachineScaleSetVmExtensionUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmExtensionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualMachineScaleSetVmExtension>,
}
impl VirtualMachineScaleSetVmExtensionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmExtensionsSummary {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "statusesSummary", default, skip_serializing_if = "Vec::is_empty")]
    pub statuses_summary: Vec<VirtualMachineStatusCodeCount>,
}
impl VirtualMachineScaleSetVmExtensionsSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmInstanceIDs {
    #[serde(rename = "instanceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub instance_ids: Vec<String>,
}
impl VirtualMachineScaleSetVmInstanceIDs {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetVmInstanceRequiredIDs {
    #[serde(rename = "instanceIds")]
    pub instance_ids: Vec<String>,
}
impl VirtualMachineScaleSetVmInstanceRequiredIDs {
    pub fn new(instance_ids: Vec<String>) -> Self {
        Self { instance_ids }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmInstanceView {
    #[serde(rename = "platformUpdateDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_update_domain: Option<i32>,
    #[serde(rename = "platformFaultDomain", default, skip_serializing_if = "Option::is_none")]
    pub platform_fault_domain: Option<i32>,
    #[serde(rename = "rdpThumbPrint", default, skip_serializing_if = "Option::is_none")]
    pub rdp_thumb_print: Option<String>,
    #[serde(rename = "vmAgent", default, skip_serializing_if = "Option::is_none")]
    pub vm_agent: Option<VirtualMachineAgentInstanceView>,
    #[serde(rename = "maintenanceRedeployStatus", default, skip_serializing_if = "Option::is_none")]
    pub maintenance_redeploy_status: Option<MaintenanceRedeployStatus>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<DiskInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<VirtualMachineExtensionInstanceView>,
    #[serde(rename = "vmHealth", default, skip_serializing_if = "Option::is_none")]
    pub vm_health: Option<VirtualMachineHealthStatus>,
    #[serde(rename = "bootDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub boot_diagnostics: Option<BootDiagnosticsInstanceView>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<InstanceViewStatus>,
    #[serde(rename = "assignedHost", default, skip_serializing_if = "Option::is_none")]
    pub assigned_host: Option<String>,
    #[serde(rename = "placementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub placement_group_id: Option<String>,
}
impl VirtualMachineScaleSetVmInstanceView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineScaleSetVmListResult {
    pub value: Vec<VirtualMachineScaleSetVm>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualMachineScaleSetVmListResult {
    pub fn new(value: Vec<VirtualMachineScaleSetVm>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmNetworkProfileConfiguration {
    #[serde(rename = "networkInterfaceConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interface_configurations: Vec<VirtualMachineScaleSetNetworkConfiguration>,
}
impl VirtualMachineScaleSetVmNetworkProfileConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmProfile {
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<VirtualMachineScaleSetOsProfile>,
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<VirtualMachineScaleSetStorageProfile>,
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<VirtualMachineScaleSetNetworkProfile>,
    #[serde(rename = "securityProfile", default, skip_serializing_if = "Option::is_none")]
    pub security_profile: Option<SecurityProfile>,
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<DiagnosticsProfile>,
    #[serde(rename = "extensionProfile", default, skip_serializing_if = "Option::is_none")]
    pub extension_profile: Option<VirtualMachineScaleSetExtensionProfile>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<Priority>,
    #[serde(rename = "evictionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub eviction_policy: Option<EvictionPolicy>,
    #[serde(rename = "billingProfile", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile: Option<BillingProfile>,
    #[serde(rename = "scheduledEventsProfile", default, skip_serializing_if = "Option::is_none")]
    pub scheduled_events_profile: Option<ScheduledEventsProfile>,
}
impl VirtualMachineScaleSetVmProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmProperties {
    #[serde(rename = "latestModelApplied", default, skip_serializing_if = "Option::is_none")]
    pub latest_model_applied: Option<bool>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "instanceView", default, skip_serializing_if = "Option::is_none")]
    pub instance_view: Option<VirtualMachineScaleSetVmInstanceView>,
    #[serde(rename = "hardwareProfile", default, skip_serializing_if = "Option::is_none")]
    pub hardware_profile: Option<HardwareProfile>,
    #[serde(rename = "storageProfile", default, skip_serializing_if = "Option::is_none")]
    pub storage_profile: Option<StorageProfile>,
    #[serde(rename = "additionalCapabilities", default, skip_serializing_if = "Option::is_none")]
    pub additional_capabilities: Option<AdditionalCapabilities>,
    #[serde(rename = "osProfile", default, skip_serializing_if = "Option::is_none")]
    pub os_profile: Option<OsProfile>,
    #[serde(rename = "securityProfile", default, skip_serializing_if = "Option::is_none")]
    pub security_profile: Option<SecurityProfile>,
    #[serde(rename = "networkProfile", default, skip_serializing_if = "Option::is_none")]
    pub network_profile: Option<NetworkProfile>,
    #[serde(rename = "networkProfileConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub network_profile_configuration: Option<VirtualMachineScaleSetVmNetworkProfileConfiguration>,
    #[serde(rename = "diagnosticsProfile", default, skip_serializing_if = "Option::is_none")]
    pub diagnostics_profile: Option<DiagnosticsProfile>,
    #[serde(rename = "availabilitySet", default, skip_serializing_if = "Option::is_none")]
    pub availability_set: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "modelDefinitionApplied", default, skip_serializing_if = "Option::is_none")]
    pub model_definition_applied: Option<String>,
    #[serde(rename = "protectionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub protection_policy: Option<VirtualMachineScaleSetVmProtectionPolicy>,
}
impl VirtualMachineScaleSetVmProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmProtectionPolicy {
    #[serde(rename = "protectFromScaleIn", default, skip_serializing_if = "Option::is_none")]
    pub protect_from_scale_in: Option<bool>,
    #[serde(rename = "protectFromScaleSetActions", default, skip_serializing_if = "Option::is_none")]
    pub protect_from_scale_set_actions: Option<bool>,
}
impl VirtualMachineScaleSetVmProtectionPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineScaleSetVmReimageParameters {
    #[serde(flatten)]
    pub virtual_machine_reimage_parameters: VirtualMachineReimageParameters,
}
impl VirtualMachineScaleSetVmReimageParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSize {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "numberOfCores", default, skip_serializing_if = "Option::is_none")]
    pub number_of_cores: Option<i32>,
    #[serde(rename = "osDiskSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_size_in_mb: Option<i32>,
    #[serde(rename = "resourceDiskSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub resource_disk_size_in_mb: Option<i32>,
    #[serde(rename = "memoryInMB", default, skip_serializing_if = "Option::is_none")]
    pub memory_in_mb: Option<i32>,
    #[serde(rename = "maxDataDiskCount", default, skip_serializing_if = "Option::is_none")]
    pub max_data_disk_count: Option<i32>,
}
impl VirtualMachineSize {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSizeListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualMachineSize>,
}
impl VirtualMachineSizeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineSoftwarePatchProperties {
    #[serde(rename = "patchId", default, skip_serializing_if = "Option::is_none")]
    pub patch_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kbid: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub classifications: Vec<String>,
    #[serde(rename = "rebootBehavior", default, skip_serializing_if = "Option::is_none")]
    pub reboot_behavior: Option<virtual_machine_software_patch_properties::RebootBehavior>,
    #[serde(rename = "activityId", default, skip_serializing_if = "Option::is_none")]
    pub activity_id: Option<String>,
    #[serde(rename = "publishedDate", default, skip_serializing_if = "Option::is_none")]
    pub published_date: Option<String>,
    #[serde(rename = "lastModifiedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_date_time: Option<String>,
    #[serde(rename = "assessmentState", default, skip_serializing_if = "Option::is_none")]
    pub assessment_state: Option<virtual_machine_software_patch_properties::AssessmentState>,
}
impl VirtualMachineSoftwarePatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_machine_software_patch_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RebootBehavior {
        NeverReboots,
        AlwaysRequiresReboot,
        CanRequestReboot,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AssessmentState {
        Installed,
        Failed,
        Excluded,
        NotSelected,
        Pending,
        Available,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineStatusCodeCount {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
}
impl VirtualMachineStatusCodeCount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineUpdate {
    #[serde(flatten)]
    pub update_resource: UpdateResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<Plan>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualMachineProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<VirtualMachineIdentity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl VirtualMachineUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WinRmConfiguration {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub listeners: Vec<WinRmListener>,
}
impl WinRmConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WinRmListener {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<win_rm_listener::Protocol>,
    #[serde(rename = "certificateUrl", default, skip_serializing_if = "Option::is_none")]
    pub certificate_url: Option<String>,
}
impl WinRmListener {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod win_rm_listener {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Https,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WindowsConfiguration {
    #[serde(rename = "provisionVMAgent", default, skip_serializing_if = "Option::is_none")]
    pub provision_vm_agent: Option<bool>,
    #[serde(rename = "enableAutomaticUpdates", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_updates: Option<bool>,
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[serde(rename = "additionalUnattendContent", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_unattend_content: Vec<AdditionalUnattendContent>,
    #[serde(rename = "patchSettings", default, skip_serializing_if = "Option::is_none")]
    pub patch_settings: Option<PatchSettings>,
    #[serde(rename = "winRM", default, skip_serializing_if = "Option::is_none")]
    pub win_rm: Option<WinRmConfiguration>,
}
impl WindowsConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EvictionPolicy {
    Deallocate,
    Delete,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Priority {
    Regular,
    Low,
    Spot,
}
