#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdDomain {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AfdDomainProperties>,
}
impl AfdDomain {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AfdDomainHttpsParameters {
    #[serde(rename = "certificateType")]
    pub certificate_type: afd_domain_https_parameters::CertificateType,
    #[serde(rename = "minimumTlsVersion", default, skip_serializing_if = "Option::is_none")]
    pub minimum_tls_version: Option<afd_domain_https_parameters::MinimumTlsVersion>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secret: Option<ResourceReference>,
}
impl AfdDomainHttpsParameters {
    pub fn new(certificate_type: afd_domain_https_parameters::CertificateType) -> Self {
        Self {
            certificate_type,
            minimum_tls_version: None,
            secret: None,
        }
    }
}
pub mod afd_domain_https_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CertificateType {
        CustomerCertificate,
        ManagedCertificate,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MinimumTlsVersion {
        #[serde(rename = "TLS10")]
        Tls10,
        #[serde(rename = "TLS12")]
        Tls12,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdDomainListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AfdDomain>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AfdDomainListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AfdDomainProperties {
    #[serde(flatten)]
    pub afd_domain_update_properties_parameters: AfdDomainUpdatePropertiesParameters,
    #[serde(flatten)]
    pub afd_state_properties: AfdStateProperties,
    #[serde(rename = "domainValidationState", default, skip_serializing_if = "Option::is_none")]
    pub domain_validation_state: Option<afd_domain_properties::DomainValidationState>,
    #[serde(rename = "hostName")]
    pub host_name: String,
    #[serde(rename = "validationProperties", default, skip_serializing_if = "Option::is_none")]
    pub validation_properties: Option<DomainValidationProperties>,
}
impl AfdDomainProperties {
    pub fn new(host_name: String) -> Self {
        Self {
            afd_domain_update_properties_parameters: AfdDomainUpdatePropertiesParameters::default(),
            afd_state_properties: AfdStateProperties::default(),
            domain_validation_state: None,
            host_name,
            validation_properties: None,
        }
    }
}
pub mod afd_domain_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DomainValidationState {
        Unknown,
        Submitting,
        Pending,
        TimedOut,
        PendingRevalidation,
        Approved,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdDomainUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AfdDomainUpdatePropertiesParameters>,
}
impl AfdDomainUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdDomainUpdatePropertiesParameters {
    #[serde(rename = "tlsSettings", default, skip_serializing_if = "Option::is_none")]
    pub tls_settings: Option<AfdDomainHttpsParameters>,
    #[serde(rename = "azureDnsZone", default, skip_serializing_if = "Option::is_none")]
    pub azure_dns_zone: Option<ResourceReference>,
}
impl AfdDomainUpdatePropertiesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AfdEndpoint {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AfdEndpointProperties>,
}
impl AfdEndpoint {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdEndpointListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AfdEndpoint>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AfdEndpointListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdEndpointProperties {
    #[serde(flatten)]
    pub afd_endpoint_properties_update_parameters: AfdEndpointPropertiesUpdateParameters,
    #[serde(flatten)]
    pub afd_state_properties: AfdStateProperties,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
}
impl AfdEndpointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdEndpointPropertiesUpdateParameters {
    #[serde(rename = "originResponseTimeoutSeconds", default, skip_serializing_if = "Option::is_none")]
    pub origin_response_timeout_seconds: Option<i32>,
    #[serde(rename = "enabledState", default, skip_serializing_if = "Option::is_none")]
    pub enabled_state: Option<afd_endpoint_properties_update_parameters::EnabledState>,
}
impl AfdEndpointPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod afd_endpoint_properties_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EnabledState {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AfdEndpointProtocols {
    Http,
    Https,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdEndpointUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AfdEndpointPropertiesUpdateParameters>,
}
impl AfdEndpointUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdOrigin {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AfdOriginProperties>,
}
impl AfdOrigin {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdOriginGroup {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AfdOriginGroupProperties>,
}
impl AfdOriginGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdOriginGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AfdOriginGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AfdOriginGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdOriginGroupProperties {
    #[serde(flatten)]
    pub afd_origin_group_update_properties_parameters: AfdOriginGroupUpdatePropertiesParameters,
    #[serde(flatten)]
    pub afd_state_properties: AfdStateProperties,
}
impl AfdOriginGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdOriginGroupUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AfdOriginGroupUpdatePropertiesParameters>,
}
impl AfdOriginGroupUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdOriginGroupUpdatePropertiesParameters {
    #[serde(rename = "loadBalancingSettings", default, skip_serializing_if = "Option::is_none")]
    pub load_balancing_settings: Option<LoadBalancingSettingsParameters>,
    #[serde(rename = "healthProbeSettings", default, skip_serializing_if = "Option::is_none")]
    pub health_probe_settings: Option<HealthProbeParameters>,
    #[serde(
        rename = "trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Option<i32>,
    #[serde(
        rename = "responseBasedAfdOriginErrorDetectionSettings",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub response_based_afd_origin_error_detection_settings: Option<ResponseBasedOriginErrorDetectionParameters>,
    #[serde(rename = "sessionAffinityState", default, skip_serializing_if = "Option::is_none")]
    pub session_affinity_state: Option<afd_origin_group_update_properties_parameters::SessionAffinityState>,
}
impl AfdOriginGroupUpdatePropertiesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod afd_origin_group_update_properties_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SessionAffinityState {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdOriginListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AfdOrigin>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AfdOriginListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AfdOriginProperties {
    #[serde(flatten)]
    pub afd_origin_update_properties_parameters: AfdOriginUpdatePropertiesParameters,
    #[serde(flatten)]
    pub afd_state_properties: AfdStateProperties,
}
impl AfdOriginProperties {
    pub fn new() -> Self {
        Self {
            afd_origin_update_properties_parameters: AfdOriginUpdatePropertiesParameters::default(),
            afd_state_properties: AfdStateProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdOriginUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AfdOriginUpdatePropertiesParameters>,
}
impl AfdOriginUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdOriginUpdatePropertiesParameters {
    #[serde(rename = "azureOrigin", default, skip_serializing_if = "Option::is_none")]
    pub azure_origin: Option<ResourceReference>,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "httpPort", default, skip_serializing_if = "Option::is_none")]
    pub http_port: Option<i32>,
    #[serde(rename = "httpsPort", default, skip_serializing_if = "Option::is_none")]
    pub https_port: Option<i32>,
    #[serde(rename = "originHostHeader", default, skip_serializing_if = "Option::is_none")]
    pub origin_host_header: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
    #[serde(rename = "sharedPrivateLinkResource", default, skip_serializing_if = "Option::is_none")]
    pub shared_private_link_resource: Option<serde_json::Value>,
    #[serde(rename = "enabledState", default, skip_serializing_if = "Option::is_none")]
    pub enabled_state: Option<afd_origin_update_properties_parameters::EnabledState>,
}
impl AfdOriginUpdatePropertiesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod afd_origin_update_properties_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EnabledState {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdStateProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<afd_state_properties::ProvisioningState>,
    #[serde(rename = "deploymentStatus", default, skip_serializing_if = "Option::is_none")]
    pub deployment_status: Option<afd_state_properties::DeploymentStatus>,
}
impl AfdStateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod afd_state_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Failed,
        Updating,
        Deleting,
        Creating,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeploymentStatus {
        NotStarted,
        InProgress,
        Succeeded,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ActionType {
    Allow,
    Block,
    Log,
    Redirect,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AfdErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl AfdErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AfdPurgeParameters {
    #[serde(rename = "contentPaths")]
    pub content_paths: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub domains: Vec<String>,
}
impl AfdPurgeParameters {
    pub fn new(content_paths: Vec<String>) -> Self {
        Self {
            content_paths,
            domains: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CacheExpirationActionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: cache_expiration_action_parameters::OdataType,
    #[serde(rename = "cacheBehavior")]
    pub cache_behavior: cache_expiration_action_parameters::CacheBehavior,
    #[serde(rename = "cacheType")]
    pub cache_type: cache_expiration_action_parameters::CacheType,
    #[serde(rename = "cacheDuration", default, skip_serializing_if = "Option::is_none")]
    pub cache_duration: Option<String>,
}
impl CacheExpirationActionParameters {
    pub fn new(
        odata_type: cache_expiration_action_parameters::OdataType,
        cache_behavior: cache_expiration_action_parameters::CacheBehavior,
        cache_type: cache_expiration_action_parameters::CacheType,
    ) -> Self {
        Self {
            odata_type,
            cache_behavior,
            cache_type,
            cache_duration: None,
        }
    }
}
pub mod cache_expiration_action_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheExpirationActionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleCacheExpirationActionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CacheBehavior {
        BypassCache,
        Override,
        SetIfMissing,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CacheType {
        All,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CacheKeyQueryStringActionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: cache_key_query_string_action_parameters::OdataType,
    #[serde(rename = "queryStringBehavior")]
    pub query_string_behavior: cache_key_query_string_action_parameters::QueryStringBehavior,
    #[serde(rename = "queryParameters", default, skip_serializing_if = "Option::is_none")]
    pub query_parameters: Option<String>,
}
impl CacheKeyQueryStringActionParameters {
    pub fn new(
        odata_type: cache_key_query_string_action_parameters::OdataType,
        query_string_behavior: cache_key_query_string_action_parameters::QueryStringBehavior,
    ) -> Self {
        Self {
            odata_type,
            query_string_behavior,
            query_parameters: None,
        }
    }
}
pub mod cache_key_query_string_action_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheKeyQueryStringBehaviorActionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleCacheKeyQueryStringBehaviorActionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum QueryStringBehavior {
        Include,
        IncludeAll,
        Exclude,
        ExcludeAll,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CdnCertificateSourceParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: cdn_certificate_source_parameters::OdataType,
    #[serde(rename = "certificateType")]
    pub certificate_type: cdn_certificate_source_parameters::CertificateType,
}
impl CdnCertificateSourceParameters {
    pub fn new(
        odata_type: cdn_certificate_source_parameters::OdataType,
        certificate_type: cdn_certificate_source_parameters::CertificateType,
    ) -> Self {
        Self {
            odata_type,
            certificate_type,
        }
    }
}
pub mod cdn_certificate_source_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters")]
        MicrosoftAzureCdnModelsCdnCertificateSourceParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CertificateType {
        Shared,
        Dedicated,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CdnEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl CdnEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CdnManagedHttpsParameters {
    #[serde(flatten)]
    pub custom_domain_https_parameters: CustomDomainHttpsParameters,
    #[serde(rename = "certificateSourceParameters")]
    pub certificate_source_parameters: CdnCertificateSourceParameters,
}
impl CdnManagedHttpsParameters {
    pub fn new(
        custom_domain_https_parameters: CustomDomainHttpsParameters,
        certificate_source_parameters: CdnCertificateSourceParameters,
    ) -> Self {
        Self {
            custom_domain_https_parameters,
            certificate_source_parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CdnWebApplicationFirewallPolicy {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CdnWebApplicationFirewallPolicyProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    pub sku: Sku,
}
impl CdnWebApplicationFirewallPolicy {
    pub fn new(tracked_resource: TrackedResource, sku: Sku) -> Self {
        Self {
            tracked_resource,
            properties: None,
            etag: None,
            sku,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CdnWebApplicationFirewallPolicyList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CdnWebApplicationFirewallPolicy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CdnWebApplicationFirewallPolicyList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CdnWebApplicationFirewallPolicyPatchParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl CdnWebApplicationFirewallPolicyPatchParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CdnWebApplicationFirewallPolicyProperties {
    #[serde(rename = "policySettings", default, skip_serializing_if = "Option::is_none")]
    pub policy_settings: Option<PolicySettings>,
    #[serde(rename = "rateLimitRules", default, skip_serializing_if = "Option::is_none")]
    pub rate_limit_rules: Option<RateLimitRuleList>,
    #[serde(rename = "customRules", default, skip_serializing_if = "Option::is_none")]
    pub custom_rules: Option<CustomRuleList>,
    #[serde(rename = "managedRules", default, skip_serializing_if = "Option::is_none")]
    pub managed_rules: Option<ManagedRuleSetList>,
    #[serde(rename = "endpointLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub endpoint_links: Vec<CdnEndpoint>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<cdn_web_application_firewall_policy_properties::ProvisioningState>,
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<cdn_web_application_firewall_policy_properties::ResourceState>,
}
impl CdnWebApplicationFirewallPolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod cdn_web_application_firewall_policy_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        Succeeded,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceState {
        Creating,
        Enabling,
        Enabled,
        Disabling,
        Disabled,
        Deleting,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Certificate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
}
impl Certificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckNameAvailabilityInput {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: ResourceType,
}
impl CheckNameAvailabilityInput {
    pub fn new(name: String, type_: ResourceType) -> Self {
        Self { name, type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckNameAvailabilityOutput {
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl CheckNameAvailabilityOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CompressionSettings {
    #[serde(rename = "contentTypesToCompress", default, skip_serializing_if = "Vec::is_empty")]
    pub content_types_to_compress: Vec<String>,
    #[serde(rename = "isCompressionEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_compression_enabled: Option<bool>,
}
impl CompressionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContinentsResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub continents: Vec<serde_json::Value>,
    #[serde(rename = "countryOrRegions", default, skip_serializing_if = "Vec::is_empty")]
    pub country_or_regions: Vec<serde_json::Value>,
}
impl ContinentsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CookiesMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: cookies_match_condition_parameters::OdataType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub selector: Option<String>,
    pub operator: cookies_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl CookiesMatchConditionParameters {
    pub fn new(odata_type: cookies_match_condition_parameters::OdataType, operator: cookies_match_condition_parameters::Operator) -> Self {
        Self {
            odata_type,
            selector: None,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod cookies_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCookiesConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleCookiesConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        Equal,
        Contains,
        BeginsWith,
        EndsWith,
        LessThan,
        LessThanOrEqual,
        GreaterThan,
        GreaterThanOrEqual,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomDomain {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CustomDomainProperties>,
}
impl CustomDomain {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomDomainHttpsParameters {
    #[serde(rename = "certificateSource")]
    pub certificate_source: custom_domain_https_parameters::CertificateSource,
    #[serde(rename = "protocolType")]
    pub protocol_type: custom_domain_https_parameters::ProtocolType,
    #[serde(rename = "minimumTlsVersion", default, skip_serializing_if = "Option::is_none")]
    pub minimum_tls_version: Option<custom_domain_https_parameters::MinimumTlsVersion>,
}
impl CustomDomainHttpsParameters {
    pub fn new(
        certificate_source: custom_domain_https_parameters::CertificateSource,
        protocol_type: custom_domain_https_parameters::ProtocolType,
    ) -> Self {
        Self {
            certificate_source,
            protocol_type,
            minimum_tls_version: None,
        }
    }
}
pub mod custom_domain_https_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CertificateSource {
        AzureKeyVault,
        Cdn,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtocolType {
        ServerNameIndication,
        #[serde(rename = "IPBased")]
        IpBased,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MinimumTlsVersion {
        None,
        #[serde(rename = "TLS10")]
        Tls10,
        #[serde(rename = "TLS12")]
        Tls12,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomDomainListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CustomDomain>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CustomDomainListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomDomainParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CustomDomainPropertiesParameters>,
}
impl CustomDomainParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomDomainProperties {
    #[serde(rename = "hostName")]
    pub host_name: String,
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<custom_domain_properties::ResourceState>,
    #[serde(rename = "customHttpsProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub custom_https_provisioning_state: Option<custom_domain_properties::CustomHttpsProvisioningState>,
    #[serde(rename = "customHttpsProvisioningSubstate", default, skip_serializing_if = "Option::is_none")]
    pub custom_https_provisioning_substate: Option<custom_domain_properties::CustomHttpsProvisioningSubstate>,
    #[serde(rename = "customHttpsParameters", default, skip_serializing_if = "Option::is_none")]
    pub custom_https_parameters: Option<CustomDomainHttpsParameters>,
    #[serde(rename = "validationData", default, skip_serializing_if = "Option::is_none")]
    pub validation_data: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl CustomDomainProperties {
    pub fn new(host_name: String) -> Self {
        Self {
            host_name,
            resource_state: None,
            custom_https_provisioning_state: None,
            custom_https_provisioning_substate: None,
            custom_https_parameters: None,
            validation_data: None,
            provisioning_state: None,
        }
    }
}
pub mod custom_domain_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceState {
        Creating,
        Active,
        Deleting,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CustomHttpsProvisioningState {
        Enabling,
        Enabled,
        Disabling,
        Disabled,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CustomHttpsProvisioningSubstate {
        SubmittingDomainControlValidationRequest,
        PendingDomainControlValidationREquestApproval,
        DomainControlValidationRequestApproved,
        DomainControlValidationRequestRejected,
        DomainControlValidationRequestTimedOut,
        IssuingCertificate,
        DeployingCertificate,
        CertificateDeployed,
        DeletingCertificate,
        CertificateDeleted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomDomainPropertiesParameters {
    #[serde(rename = "hostName")]
    pub host_name: String,
}
impl CustomDomainPropertiesParameters {
    pub fn new(host_name: String) -> Self {
        Self { host_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomRule {
    pub name: String,
    #[serde(rename = "enabledState", default, skip_serializing_if = "Option::is_none")]
    pub enabled_state: Option<custom_rule::EnabledState>,
    pub priority: i32,
    #[serde(rename = "matchConditions")]
    pub match_conditions: Vec<MatchCondition>,
    pub action: ActionType,
}
impl CustomRule {
    pub fn new(name: String, priority: i32, match_conditions: Vec<MatchCondition>, action: ActionType) -> Self {
        Self {
            name,
            enabled_state: None,
            priority,
            match_conditions,
            action,
        }
    }
}
pub mod custom_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EnabledState {
        Disabled,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomRuleList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<CustomRule>,
}
impl CustomRuleList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomerCertificate {
    #[serde(flatten)]
    pub certificate: Certificate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "certificateAuthority", default, skip_serializing_if = "Option::is_none")]
    pub certificate_authority: Option<String>,
    #[serde(rename = "certificateUrl")]
    pub certificate_url: String,
    #[serde(rename = "useLatestVersion", default, skip_serializing_if = "Option::is_none")]
    pub use_latest_version: Option<bool>,
    #[serde(rename = "subjectAlternativeNames", default, skip_serializing_if = "Vec::is_empty")]
    pub subject_alternative_names: Vec<String>,
}
impl CustomerCertificate {
    pub fn new(certificate_url: String) -> Self {
        Self {
            certificate: Certificate::default(),
            version: None,
            certificate_authority: None,
            certificate_url,
            use_latest_version: None,
            subject_alternative_names: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomerCertificateParameters {
    #[serde(flatten)]
    pub secret_parameters: SecretParameters,
    #[serde(rename = "secretSource")]
    pub secret_source: ResourceReference,
    #[serde(rename = "secretVersion", default, skip_serializing_if = "Option::is_none")]
    pub secret_version: Option<String>,
    #[serde(rename = "certificateAuthority", default, skip_serializing_if = "Option::is_none")]
    pub certificate_authority: Option<String>,
    #[serde(rename = "useLatestVersion", default, skip_serializing_if = "Option::is_none")]
    pub use_latest_version: Option<bool>,
    #[serde(rename = "subjectAlternativeNames", default, skip_serializing_if = "Vec::is_empty")]
    pub subject_alternative_names: Vec<String>,
}
impl CustomerCertificateParameters {
    pub fn new(secret_parameters: SecretParameters, secret_source: ResourceReference) -> Self {
        Self {
            secret_parameters,
            secret_source,
            secret_version: None,
            certificate_authority: None,
            use_latest_version: None,
            subject_alternative_names: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeepCreatedOrigin {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DeepCreatedOriginProperties>,
}
impl DeepCreatedOrigin {
    pub fn new(name: String) -> Self {
        Self { name, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeepCreatedOriginGroup {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DeepCreatedOriginGroupProperties>,
}
impl DeepCreatedOriginGroup {
    pub fn new(name: String) -> Self {
        Self { name, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeepCreatedOriginGroupProperties {
    #[serde(rename = "healthProbeSettings", default, skip_serializing_if = "Option::is_none")]
    pub health_probe_settings: Option<HealthProbeParameters>,
    pub origins: Vec<ResourceReference>,
    #[serde(
        rename = "trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Option<i64>,
    #[serde(
        rename = "responseBasedOriginErrorDetectionSettings",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub response_based_origin_error_detection_settings: Option<ResponseBasedOriginErrorDetectionParameters>,
}
impl DeepCreatedOriginGroupProperties {
    pub fn new(origins: Vec<ResourceReference>) -> Self {
        Self {
            health_probe_settings: None,
            origins,
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: None,
            response_based_origin_error_detection_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeepCreatedOriginProperties {
    #[serde(rename = "hostName")]
    pub host_name: String,
    #[serde(rename = "httpPort", default, skip_serializing_if = "Option::is_none")]
    pub http_port: Option<i64>,
    #[serde(rename = "httpsPort", default, skip_serializing_if = "Option::is_none")]
    pub https_port: Option<i64>,
    #[serde(rename = "originHostHeader", default, skip_serializing_if = "Option::is_none")]
    pub origin_host_header: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "privateLinkAlias", default, skip_serializing_if = "Option::is_none")]
    pub private_link_alias: Option<String>,
    #[serde(rename = "privateLinkResourceId", default, skip_serializing_if = "Option::is_none")]
    pub private_link_resource_id: Option<String>,
    #[serde(rename = "privateLinkLocation", default, skip_serializing_if = "Option::is_none")]
    pub private_link_location: Option<String>,
    #[serde(rename = "privateLinkApprovalMessage", default, skip_serializing_if = "Option::is_none")]
    pub private_link_approval_message: Option<String>,
}
impl DeepCreatedOriginProperties {
    pub fn new(host_name: String) -> Self {
        Self {
            host_name,
            http_port: None,
            https_port: None,
            origin_host_header: None,
            priority: None,
            weight: None,
            enabled: None,
            private_link_alias: None,
            private_link_resource_id: None,
            private_link_location: None,
            private_link_approval_message: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    pub order: i64,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub conditions: Vec<DeliveryRuleCondition>,
    pub actions: Vec<DeliveryRuleAction>,
}
impl DeliveryRule {
    pub fn new(order: i64, actions: Vec<DeliveryRuleAction>) -> Self {
        Self {
            name: None,
            order,
            conditions: Vec::new(),
            actions,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleAction {
    pub name: delivery_rule_action::Name,
}
impl DeliveryRuleAction {
    pub fn new(name: delivery_rule_action::Name) -> Self {
        Self { name }
    }
}
pub mod delivery_rule_action {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        CacheExpiration,
        CacheKeyQueryString,
        ModifyRequestHeader,
        ModifyResponseHeader,
        UrlRedirect,
        UrlRewrite,
        UrlSigning,
        OriginGroupOverride,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleCacheExpirationAction {
    #[serde(flatten)]
    pub delivery_rule_action: DeliveryRuleAction,
    pub parameters: CacheExpirationActionParameters,
}
impl DeliveryRuleCacheExpirationAction {
    pub fn new(delivery_rule_action: DeliveryRuleAction, parameters: CacheExpirationActionParameters) -> Self {
        Self {
            delivery_rule_action,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleCacheKeyQueryStringAction {
    #[serde(flatten)]
    pub delivery_rule_action: DeliveryRuleAction,
    pub parameters: CacheKeyQueryStringActionParameters,
}
impl DeliveryRuleCacheKeyQueryStringAction {
    pub fn new(delivery_rule_action: DeliveryRuleAction, parameters: CacheKeyQueryStringActionParameters) -> Self {
        Self {
            delivery_rule_action,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleCondition {
    pub name: delivery_rule_condition::Name,
}
impl DeliveryRuleCondition {
    pub fn new(name: delivery_rule_condition::Name) -> Self {
        Self { name }
    }
}
pub mod delivery_rule_condition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        RemoteAddress,
        RequestMethod,
        QueryString,
        PostArgs,
        RequestUri,
        RequestHeader,
        RequestBody,
        RequestScheme,
        UrlPath,
        UrlFileExtension,
        UrlFileName,
        HttpVersion,
        Cookies,
        IsDevice,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleCookiesCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: CookiesMatchConditionParameters,
}
impl DeliveryRuleCookiesCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: CookiesMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleHttpVersionCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: HttpVersionMatchConditionParameters,
}
impl DeliveryRuleHttpVersionCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: HttpVersionMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleIsDeviceCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: IsDeviceMatchConditionParameters,
}
impl DeliveryRuleIsDeviceCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: IsDeviceMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRulePostArgsCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: PostArgsMatchConditionParameters,
}
impl DeliveryRulePostArgsCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: PostArgsMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleQueryStringCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: QueryStringMatchConditionParameters,
}
impl DeliveryRuleQueryStringCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: QueryStringMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleRemoteAddressCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: RemoteAddressMatchConditionParameters,
}
impl DeliveryRuleRemoteAddressCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: RemoteAddressMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleRequestBodyCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: RequestBodyMatchConditionParameters,
}
impl DeliveryRuleRequestBodyCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: RequestBodyMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleRequestHeaderAction {
    #[serde(flatten)]
    pub delivery_rule_action: DeliveryRuleAction,
    pub parameters: HeaderActionParameters,
}
impl DeliveryRuleRequestHeaderAction {
    pub fn new(delivery_rule_action: DeliveryRuleAction, parameters: HeaderActionParameters) -> Self {
        Self {
            delivery_rule_action,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleRequestHeaderCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: RequestHeaderMatchConditionParameters,
}
impl DeliveryRuleRequestHeaderCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: RequestHeaderMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleRequestMethodCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: RequestMethodMatchConditionParameters,
}
impl DeliveryRuleRequestMethodCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: RequestMethodMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleRequestSchemeCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: RequestSchemeMatchConditionParameters,
}
impl DeliveryRuleRequestSchemeCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: RequestSchemeMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleRequestUriCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: RequestUriMatchConditionParameters,
}
impl DeliveryRuleRequestUriCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: RequestUriMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleResponseHeaderAction {
    #[serde(flatten)]
    pub delivery_rule_action: DeliveryRuleAction,
    pub parameters: HeaderActionParameters,
}
impl DeliveryRuleResponseHeaderAction {
    pub fn new(delivery_rule_action: DeliveryRuleAction, parameters: HeaderActionParameters) -> Self {
        Self {
            delivery_rule_action,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleUrlFileExtensionCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: UrlFileExtensionMatchConditionParameters,
}
impl DeliveryRuleUrlFileExtensionCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: UrlFileExtensionMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleUrlFileNameCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: UrlFileNameMatchConditionParameters,
}
impl DeliveryRuleUrlFileNameCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: UrlFileNameMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeliveryRuleUrlPathCondition {
    #[serde(flatten)]
    pub delivery_rule_condition: DeliveryRuleCondition,
    pub parameters: UrlPathMatchConditionParameters,
}
impl DeliveryRuleUrlPathCondition {
    pub fn new(delivery_rule_condition: DeliveryRuleCondition, parameters: UrlPathMatchConditionParameters) -> Self {
        Self {
            delivery_rule_condition,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainValidationProperties {
    #[serde(rename = "validationToken", default, skip_serializing_if = "Option::is_none")]
    pub validation_token: Option<String>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
}
impl DomainValidationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EdgeNode {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EdgeNodeProperties>,
}
impl EdgeNode {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EdgeNodeProperties {
    #[serde(rename = "ipAddressGroups")]
    pub ip_address_groups: Vec<IpAddressGroup>,
}
impl EdgeNodeProperties {
    pub fn new(ip_address_groups: Vec<IpAddressGroup>) -> Self {
        Self { ip_address_groups }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EdgenodeResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EdgeNode>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EdgenodeResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Endpoint {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EndpointProperties>,
}
impl Endpoint {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Endpoint>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EndpointListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EndpointProperties {
    #[serde(flatten)]
    pub endpoint_properties_update_parameters: EndpointPropertiesUpdateParameters,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    pub origins: Vec<DeepCreatedOrigin>,
    #[serde(rename = "originGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub origin_groups: Vec<DeepCreatedOriginGroup>,
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<endpoint_properties::ResourceState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl EndpointProperties {
    pub fn new(origins: Vec<DeepCreatedOrigin>) -> Self {
        Self {
            endpoint_properties_update_parameters: EndpointPropertiesUpdateParameters::default(),
            host_name: None,
            origins,
            origin_groups: Vec::new(),
            resource_state: None,
            provisioning_state: None,
        }
    }
}
pub mod endpoint_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceState {
        Creating,
        Deleting,
        Running,
        Starting,
        Stopped,
        Stopping,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointPropertiesUpdateParameters {
    #[serde(rename = "originPath", default, skip_serializing_if = "Option::is_none")]
    pub origin_path: Option<String>,
    #[serde(rename = "contentTypesToCompress", default, skip_serializing_if = "Vec::is_empty")]
    pub content_types_to_compress: Vec<String>,
    #[serde(rename = "originHostHeader", default, skip_serializing_if = "Option::is_none")]
    pub origin_host_header: Option<String>,
    #[serde(rename = "isCompressionEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_compression_enabled: Option<bool>,
    #[serde(rename = "isHttpAllowed", default, skip_serializing_if = "Option::is_none")]
    pub is_http_allowed: Option<bool>,
    #[serde(rename = "isHttpsAllowed", default, skip_serializing_if = "Option::is_none")]
    pub is_https_allowed: Option<bool>,
    #[serde(rename = "queryStringCachingBehavior", default, skip_serializing_if = "Option::is_none")]
    pub query_string_caching_behavior: Option<QueryStringCachingBehavior>,
    #[serde(rename = "optimizationType", default, skip_serializing_if = "Option::is_none")]
    pub optimization_type: Option<OptimizationType>,
    #[serde(rename = "probePath", default, skip_serializing_if = "Option::is_none")]
    pub probe_path: Option<String>,
    #[serde(rename = "geoFilters", default, skip_serializing_if = "Vec::is_empty")]
    pub geo_filters: Vec<GeoFilter>,
    #[serde(rename = "defaultOriginGroup", default, skip_serializing_if = "Option::is_none")]
    pub default_origin_group: Option<ResourceReference>,
    #[serde(rename = "urlSigningKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub url_signing_keys: Vec<UrlSigningKey>,
    #[serde(rename = "deliveryPolicy", default, skip_serializing_if = "Option::is_none")]
    pub delivery_policy: Option<endpoint_properties_update_parameters::DeliveryPolicy>,
    #[serde(rename = "webApplicationFirewallPolicyLink", default, skip_serializing_if = "Option::is_none")]
    pub web_application_firewall_policy_link: Option<endpoint_properties_update_parameters::WebApplicationFirewallPolicyLink>,
}
impl EndpointPropertiesUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod endpoint_properties_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct DeliveryPolicy {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        pub rules: Vec<DeliveryRule>,
    }
    impl DeliveryPolicy {
        pub fn new(rules: Vec<DeliveryRule>) -> Self {
            Self { description: None, rules }
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct WebApplicationFirewallPolicyLink {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
    }
    impl WebApplicationFirewallPolicyLink {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EndpointPropertiesUpdateParameters>,
}
impl EndpointUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GeoFilter {
    #[serde(rename = "relativePath")]
    pub relative_path: String,
    pub action: geo_filter::Action,
    #[serde(rename = "countryCodes")]
    pub country_codes: Vec<String>,
}
impl GeoFilter {
    pub fn new(relative_path: String, action: geo_filter::Action, country_codes: Vec<String>) -> Self {
        Self {
            relative_path,
            action,
            country_codes,
        }
    }
}
pub mod geo_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Block,
        Allow,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HeaderActionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: header_action_parameters::OdataType,
    #[serde(rename = "headerAction")]
    pub header_action: header_action_parameters::HeaderAction,
    #[serde(rename = "headerName")]
    pub header_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl HeaderActionParameters {
    pub fn new(
        odata_type: header_action_parameters::OdataType,
        header_action: header_action_parameters::HeaderAction,
        header_name: String,
    ) -> Self {
        Self {
            odata_type,
            header_action,
            header_name,
            value: None,
        }
    }
}
pub mod header_action_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHeaderActionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleHeaderActionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HeaderAction {
        Append,
        Overwrite,
        Delete,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HealthProbeParameters {
    #[serde(rename = "probePath", default, skip_serializing_if = "Option::is_none")]
    pub probe_path: Option<String>,
    #[serde(rename = "probeRequestType", default, skip_serializing_if = "Option::is_none")]
    pub probe_request_type: Option<health_probe_parameters::ProbeRequestType>,
    #[serde(rename = "probeProtocol", default, skip_serializing_if = "Option::is_none")]
    pub probe_protocol: Option<health_probe_parameters::ProbeProtocol>,
    #[serde(rename = "probeIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub probe_interval_in_seconds: Option<i64>,
}
impl HealthProbeParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod health_probe_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProbeRequestType {
        NotSet,
        #[serde(rename = "GET")]
        Get,
        #[serde(rename = "HEAD")]
        Head,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProbeProtocol {
        NotSet,
        Http,
        Https,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpErrorRangeParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub begin: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub end: Option<i64>,
}
impl HttpErrorRangeParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpVersionMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: http_version_match_condition_parameters::OdataType,
    pub operator: http_version_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
}
impl HttpVersionMatchConditionParameters {
    pub fn new(
        odata_type: http_version_match_condition_parameters::OdataType,
        operator: http_version_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
        }
    }
}
pub mod http_version_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHttpVersionConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleHttpVersionConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Equal,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IdentityType {
    #[serde(rename = "user")]
    User,
    #[serde(rename = "application")]
    Application,
    #[serde(rename = "managedIdentity")]
    ManagedIdentity,
    #[serde(rename = "key")]
    Key,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressGroup {
    #[serde(rename = "deliveryRegion", default, skip_serializing_if = "Option::is_none")]
    pub delivery_region: Option<String>,
    #[serde(rename = "ipv4Addresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ipv4_addresses: Vec<CidrIpAddress>,
    #[serde(rename = "ipv6Addresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ipv6_addresses: Vec<CidrIpAddress>,
}
impl IpAddressGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IsDeviceMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: is_device_match_condition_parameters::OdataType,
    pub operator: is_device_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl IsDeviceMatchConditionParameters {
    pub fn new(
        odata_type: is_device_match_condition_parameters::OdataType,
        operator: is_device_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod is_device_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleIsDeviceConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleIsDeviceConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Equal,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultCertificateSourceParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: key_vault_certificate_source_parameters::OdataType,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
    #[serde(rename = "resourceGroupName")]
    pub resource_group_name: String,
    #[serde(rename = "vaultName")]
    pub vault_name: String,
    #[serde(rename = "secretName")]
    pub secret_name: String,
    #[serde(rename = "secretVersion", default, skip_serializing_if = "Option::is_none")]
    pub secret_version: Option<String>,
    #[serde(rename = "updateRule")]
    pub update_rule: key_vault_certificate_source_parameters::UpdateRule,
    #[serde(rename = "deleteRule")]
    pub delete_rule: key_vault_certificate_source_parameters::DeleteRule,
}
impl KeyVaultCertificateSourceParameters {
    pub fn new(
        odata_type: key_vault_certificate_source_parameters::OdataType,
        subscription_id: String,
        resource_group_name: String,
        vault_name: String,
        secret_name: String,
        update_rule: key_vault_certificate_source_parameters::UpdateRule,
        delete_rule: key_vault_certificate_source_parameters::DeleteRule,
    ) -> Self {
        Self {
            odata_type,
            subscription_id,
            resource_group_name,
            vault_name,
            secret_name,
            secret_version: None,
            update_rule,
            delete_rule,
        }
    }
}
pub mod key_vault_certificate_source_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.KeyVaultCertificateSourceParameters")]
        MicrosoftAzureCdnModelsKeyVaultCertificateSourceParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UpdateRule {
        NoAction,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeleteRule {
        NoAction,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultSigningKeyParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: key_vault_signing_key_parameters::OdataType,
    #[serde(rename = "subscriptionId")]
    pub subscription_id: String,
    #[serde(rename = "resourceGroupName")]
    pub resource_group_name: String,
    #[serde(rename = "vaultName")]
    pub vault_name: String,
    #[serde(rename = "secretName")]
    pub secret_name: String,
    #[serde(rename = "secretVersion")]
    pub secret_version: String,
}
impl KeyVaultSigningKeyParameters {
    pub fn new(
        odata_type: key_vault_signing_key_parameters::OdataType,
        subscription_id: String,
        resource_group_name: String,
        vault_name: String,
        secret_name: String,
        secret_version: String,
    ) -> Self {
        Self {
            odata_type,
            subscription_id,
            resource_group_name,
            vault_name,
            secret_name,
            secret_version,
        }
    }
}
pub mod key_vault_signing_key_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.KeyVaultSigningKeyParameters")]
        MicrosoftAzureCdnModelsKeyVaultSigningKeyParameters,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancingSettingsParameters {
    #[serde(rename = "sampleSize", default, skip_serializing_if = "Option::is_none")]
    pub sample_size: Option<i32>,
    #[serde(rename = "successfulSamplesRequired", default, skip_serializing_if = "Option::is_none")]
    pub successful_samples_required: Option<i32>,
    #[serde(rename = "additionalLatencyInMilliseconds", default, skip_serializing_if = "Option::is_none")]
    pub additional_latency_in_milliseconds: Option<i32>,
}
impl LoadBalancingSettingsParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LoadParameters {
    #[serde(rename = "contentPaths")]
    pub content_paths: Vec<String>,
}
impl LoadParameters {
    pub fn new(content_paths: Vec<String>) -> Self {
        Self { content_paths }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedCertificate {
    #[serde(flatten)]
    pub certificate: Certificate,
}
impl ManagedCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedCertificateParameters {
    #[serde(flatten)]
    pub secret_parameters: SecretParameters,
}
impl ManagedCertificateParameters {
    pub fn new(secret_parameters: SecretParameters) -> Self {
        Self { secret_parameters }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedRuleDefinition {
    #[serde(rename = "ruleId", default, skip_serializing_if = "Option::is_none")]
    pub rule_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ManagedRuleDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedRuleGroupDefinition {
    #[serde(rename = "ruleGroupName", default, skip_serializing_if = "Option::is_none")]
    pub rule_group_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<ManagedRuleDefinition>,
}
impl ManagedRuleGroupDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRuleGroupOverride {
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<ManagedRuleOverride>,
}
impl ManagedRuleGroupOverride {
    pub fn new(rule_group_name: String) -> Self {
        Self {
            rule_group_name,
            rules: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRuleOverride {
    #[serde(rename = "ruleId")]
    pub rule_id: String,
    #[serde(rename = "enabledState", default, skip_serializing_if = "Option::is_none")]
    pub enabled_state: Option<managed_rule_override::EnabledState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<ActionType>,
}
impl ManagedRuleOverride {
    pub fn new(rule_id: String) -> Self {
        Self {
            rule_id,
            enabled_state: None,
            action: None,
        }
    }
}
pub mod managed_rule_override {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EnabledState {
        Disabled,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRuleSet {
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[serde(rename = "anomalyScore", default, skip_serializing_if = "Option::is_none")]
    pub anomaly_score: Option<i64>,
    #[serde(rename = "ruleGroupOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_group_overrides: Vec<ManagedRuleGroupOverride>,
}
impl ManagedRuleSet {
    pub fn new(rule_set_type: String, rule_set_version: String) -> Self {
        Self {
            rule_set_type,
            rule_set_version,
            anomaly_score: None,
            rule_group_overrides: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedRuleSetDefinition {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagedRuleSetDefinitionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
}
impl ManagedRuleSetDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedRuleSetDefinitionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ManagedRuleSetDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagedRuleSetDefinitionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedRuleSetDefinitionProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "ruleSetType", default, skip_serializing_if = "Option::is_none")]
    pub rule_set_type: Option<String>,
    #[serde(rename = "ruleSetVersion", default, skip_serializing_if = "Option::is_none")]
    pub rule_set_version: Option<String>,
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ManagedRuleGroupDefinition>,
}
impl ManagedRuleSetDefinitionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedRuleSetList {
    #[serde(rename = "managedRuleSets", default, skip_serializing_if = "Vec::is_empty")]
    pub managed_rule_sets: Vec<ManagedRuleSet>,
}
impl ManagedRuleSetList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MatchCondition {
    #[serde(rename = "matchVariable")]
    pub match_variable: match_condition::MatchVariable,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub selector: Option<String>,
    pub operator: match_condition::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValue")]
    pub match_value: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<TransformType>,
}
impl MatchCondition {
    pub fn new(match_variable: match_condition::MatchVariable, operator: match_condition::Operator, match_value: Vec<String>) -> Self {
        Self {
            match_variable,
            selector: None,
            operator,
            negate_condition: None,
            match_value,
            transforms: Vec::new(),
        }
    }
}
pub mod match_condition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MatchVariable {
        RemoteAddr,
        SocketAddr,
        RequestMethod,
        RequestHeader,
        RequestUri,
        QueryString,
        RequestBody,
        Cookies,
        PostArgs,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        #[serde(rename = "IPMatch")]
        IpMatch,
        GeoMatch,
        Equal,
        Contains,
        LessThan,
        GreaterThan,
        LessThanOrEqual,
        GreaterThanOrEqual,
        BeginsWith,
        EndsWith,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricsResponse {
    #[serde(rename = "dateTimeBegin", default, skip_serializing_if = "Option::is_none")]
    pub date_time_begin: Option<String>,
    #[serde(rename = "dateTimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub date_time_end: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub granularity: Option<metrics_response::Granularity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub series: Vec<serde_json::Value>,
}
impl MetricsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod metrics_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Granularity {
        #[serde(rename = "PT5M")]
        Pt5m,
        #[serde(rename = "PT1H")]
        Pt1h,
        #[serde(rename = "P1D")]
        P1d,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OptimizationType {
    GeneralWebDelivery,
    GeneralMediaStreaming,
    VideoOnDemandMediaStreaming,
    LargeFileDownload,
    DynamicSiteAcceleration,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Origin {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OriginProperties>,
}
impl Origin {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OriginGroup {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OriginGroupProperties>,
}
impl OriginGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OriginGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OriginGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OriginGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OriginGroupOverrideAction {
    #[serde(flatten)]
    pub delivery_rule_action: DeliveryRuleAction,
    pub parameters: OriginGroupOverrideActionParameters,
}
impl OriginGroupOverrideAction {
    pub fn new(delivery_rule_action: DeliveryRuleAction, parameters: OriginGroupOverrideActionParameters) -> Self {
        Self {
            delivery_rule_action,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OriginGroupOverrideActionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: origin_group_override_action_parameters::OdataType,
    #[serde(rename = "originGroup")]
    pub origin_group: ResourceReference,
}
impl OriginGroupOverrideActionParameters {
    pub fn new(odata_type: origin_group_override_action_parameters::OdataType, origin_group: ResourceReference) -> Self {
        Self { odata_type, origin_group }
    }
}
pub mod origin_group_override_action_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleOriginGroupOverrideActionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleOriginGroupOverrideActionParameters,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OriginGroupProperties {
    #[serde(flatten)]
    pub origin_group_update_properties_parameters: OriginGroupUpdatePropertiesParameters,
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<origin_group_properties::ResourceState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl OriginGroupProperties {
    pub fn new() -> Self {
        Self {
            origin_group_update_properties_parameters: OriginGroupUpdatePropertiesParameters::default(),
            resource_state: None,
            provisioning_state: None,
        }
    }
}
pub mod origin_group_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceState {
        Creating,
        Active,
        Deleting,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OriginGroupUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OriginGroupUpdatePropertiesParameters>,
}
impl OriginGroupUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OriginGroupUpdatePropertiesParameters {
    #[serde(rename = "healthProbeSettings", default, skip_serializing_if = "Option::is_none")]
    pub health_probe_settings: Option<HealthProbeParameters>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub origins: Vec<ResourceReference>,
    #[serde(
        rename = "trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Option<i64>,
    #[serde(
        rename = "responseBasedOriginErrorDetectionSettings",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub response_based_origin_error_detection_settings: Option<ResponseBasedOriginErrorDetectionParameters>,
}
impl OriginGroupUpdatePropertiesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OriginListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Origin>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OriginListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OriginProperties {
    #[serde(flatten)]
    pub origin_update_properties_parameters: OriginUpdatePropertiesParameters,
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<origin_properties::ResourceState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "privateEndpointStatus", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint_status: Option<origin_properties::PrivateEndpointStatus>,
}
impl OriginProperties {
    pub fn new() -> Self {
        Self {
            origin_update_properties_parameters: OriginUpdatePropertiesParameters::default(),
            resource_state: None,
            provisioning_state: None,
            private_endpoint_status: None,
        }
    }
}
pub mod origin_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceState {
        Creating,
        Active,
        Deleting,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateEndpointStatus {
        Pending,
        Approved,
        Rejected,
        Disconnected,
        Timeout,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OriginUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OriginUpdatePropertiesParameters>,
}
impl OriginUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OriginUpdatePropertiesParameters {
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "httpPort", default, skip_serializing_if = "Option::is_none")]
    pub http_port: Option<i64>,
    #[serde(rename = "httpsPort", default, skip_serializing_if = "Option::is_none")]
    pub https_port: Option<i64>,
    #[serde(rename = "originHostHeader", default, skip_serializing_if = "Option::is_none")]
    pub origin_host_header: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "privateLinkAlias", default, skip_serializing_if = "Option::is_none")]
    pub private_link_alias: Option<String>,
    #[serde(rename = "privateLinkResourceId", default, skip_serializing_if = "Option::is_none")]
    pub private_link_resource_id: Option<String>,
    #[serde(rename = "privateLinkLocation", default, skip_serializing_if = "Option::is_none")]
    pub private_link_location: Option<String>,
    #[serde(rename = "privateLinkApprovalMessage", default, skip_serializing_if = "Option::is_none")]
    pub private_link_approval_message: Option<String>,
}
impl OriginUpdatePropertiesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PostArgsMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: post_args_match_condition_parameters::OdataType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub selector: Option<String>,
    pub operator: post_args_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl PostArgsMatchConditionParameters {
    pub fn new(
        odata_type: post_args_match_condition_parameters::OdataType,
        operator: post_args_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            selector: None,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod post_args_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRulePostArgsConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRulePostArgsConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        Equal,
        Contains,
        BeginsWith,
        EndsWith,
        LessThan,
        LessThanOrEqual,
        GreaterThan,
        GreaterThanOrEqual,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Profile {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    pub sku: Sku,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProfileProperties>,
}
impl Profile {
    pub fn new(tracked_resource: TrackedResource, sku: Sku) -> Self {
        Self {
            tracked_resource,
            sku,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProfileListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Profile>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProfileListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProfileProperties {
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<profile_properties::ResourceState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "frontdoorId", default, skip_serializing_if = "Option::is_none")]
    pub frontdoor_id: Option<String>,
}
impl ProfileProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod profile_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceState {
        Creating,
        Active,
        Deleting,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProfileUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ProfileUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PurgeParameters {
    #[serde(rename = "contentPaths")]
    pub content_paths: Vec<String>,
}
impl PurgeParameters {
    pub fn new(content_paths: Vec<String>) -> Self {
        Self { content_paths }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum QueryStringCachingBehavior {
    IgnoreQueryString,
    BypassCaching,
    UseQueryString,
    NotSet,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryStringMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: query_string_match_condition_parameters::OdataType,
    pub operator: query_string_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl QueryStringMatchConditionParameters {
    pub fn new(
        odata_type: query_string_match_condition_parameters::OdataType,
        operator: query_string_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod query_string_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleQueryStringConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleQueryStringConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        Equal,
        Contains,
        BeginsWith,
        EndsWith,
        LessThan,
        LessThanOrEqual,
        GreaterThan,
        GreaterThanOrEqual,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RankingsResponse {
    #[serde(rename = "dateTimeBegin", default, skip_serializing_if = "Option::is_none")]
    pub date_time_begin: Option<String>,
    #[serde(rename = "dateTimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub date_time_end: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tables: Vec<serde_json::Value>,
}
impl RankingsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RateLimitRule {
    #[serde(flatten)]
    pub custom_rule: CustomRule,
    #[serde(rename = "rateLimitThreshold")]
    pub rate_limit_threshold: i32,
    #[serde(rename = "rateLimitDurationInMinutes")]
    pub rate_limit_duration_in_minutes: i32,
}
impl RateLimitRule {
    pub fn new(custom_rule: CustomRule, rate_limit_threshold: i32, rate_limit_duration_in_minutes: i32) -> Self {
        Self {
            custom_rule,
            rate_limit_threshold,
            rate_limit_duration_in_minutes,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RateLimitRuleList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<RateLimitRule>,
}
impl RateLimitRuleList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RemoteAddressMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: remote_address_match_condition_parameters::OdataType,
    pub operator: remote_address_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl RemoteAddressMatchConditionParameters {
    pub fn new(
        odata_type: remote_address_match_condition_parameters::OdataType,
        operator: remote_address_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod remote_address_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRemoteAddressConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleRemoteAddressConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        #[serde(rename = "IPMatch")]
        IpMatch,
        GeoMatch,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RequestBodyMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: request_body_match_condition_parameters::OdataType,
    pub operator: request_body_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl RequestBodyMatchConditionParameters {
    pub fn new(
        odata_type: request_body_match_condition_parameters::OdataType,
        operator: request_body_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod request_body_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestBodyConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleRequestBodyConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        Equal,
        Contains,
        BeginsWith,
        EndsWith,
        LessThan,
        LessThanOrEqual,
        GreaterThan,
        GreaterThanOrEqual,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RequestHeaderMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: request_header_match_condition_parameters::OdataType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub selector: Option<String>,
    pub operator: request_header_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl RequestHeaderMatchConditionParameters {
    pub fn new(
        odata_type: request_header_match_condition_parameters::OdataType,
        operator: request_header_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            selector: None,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod request_header_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestHeaderConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleRequestHeaderConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        Equal,
        Contains,
        BeginsWith,
        EndsWith,
        LessThan,
        LessThanOrEqual,
        GreaterThan,
        GreaterThanOrEqual,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RequestMethodMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: request_method_match_condition_parameters::OdataType,
    pub operator: request_method_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
}
impl RequestMethodMatchConditionParameters {
    pub fn new(
        odata_type: request_method_match_condition_parameters::OdataType,
        operator: request_method_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
        }
    }
}
pub mod request_method_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestMethodConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleRequestMethodConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Equal,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RequestSchemeMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: request_scheme_match_condition_parameters::OdataType,
    pub operator: request_scheme_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
}
impl RequestSchemeMatchConditionParameters {
    pub fn new(
        odata_type: request_scheme_match_condition_parameters::OdataType,
        operator: request_scheme_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
        }
    }
}
pub mod request_scheme_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestSchemeConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleRequestSchemeConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Equal,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RequestUriMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: request_uri_match_condition_parameters::OdataType,
    pub operator: request_uri_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl RequestUriMatchConditionParameters {
    pub fn new(
        odata_type: request_uri_match_condition_parameters::OdataType,
        operator: request_uri_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod request_uri_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestUriConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleRequestUriConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        Equal,
        Contains,
        BeginsWith,
        EndsWith,
        LessThan,
        LessThanOrEqual,
        GreaterThan,
        GreaterThanOrEqual,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ResourceReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ResourceType {
    #[serde(rename = "Microsoft.Cdn/Profiles/Endpoints")]
    MicrosoftCdnProfilesEndpoints,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceUsage {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
}
impl ResourceUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceUsageListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceUsage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceUsageListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourcesResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<serde_json::Value>,
    #[serde(rename = "customDomains", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_domains: Vec<serde_json::Value>,
}
impl ResourcesResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseBasedOriginErrorDetectionParameters {
    #[serde(rename = "responseBasedDetectedErrorTypes", default, skip_serializing_if = "Option::is_none")]
    pub response_based_detected_error_types: Option<response_based_origin_error_detection_parameters::ResponseBasedDetectedErrorTypes>,
    #[serde(
        rename = "responseBasedFailoverThresholdPercentage",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub response_based_failover_threshold_percentage: Option<i64>,
    #[serde(rename = "httpErrorRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub http_error_ranges: Vec<HttpErrorRangeParameters>,
}
impl ResponseBasedOriginErrorDetectionParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod response_based_origin_error_detection_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResponseBasedDetectedErrorTypes {
        None,
        TcpErrorsOnly,
        TcpAndHttpErrors,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Route {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteProperties>,
}
impl Route {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Route>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RouteProperties {
    #[serde(flatten)]
    pub route_update_properties_parameters: RouteUpdatePropertiesParameters,
    #[serde(flatten)]
    pub afd_state_properties: AfdStateProperties,
}
impl RouteProperties {
    pub fn new() -> Self {
        Self {
            route_update_properties_parameters: RouteUpdatePropertiesParameters::default(),
            afd_state_properties: AfdStateProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteUpdatePropertiesParameters>,
}
impl RouteUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteUpdatePropertiesParameters {
    #[serde(rename = "customDomains", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_domains: Vec<ResourceReference>,
    #[serde(rename = "originGroup", default, skip_serializing_if = "Option::is_none")]
    pub origin_group: Option<ResourceReference>,
    #[serde(rename = "originPath", default, skip_serializing_if = "Option::is_none")]
    pub origin_path: Option<String>,
    #[serde(rename = "ruleSets", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_sets: Vec<ResourceReference>,
    #[serde(rename = "supportedProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_protocols: Vec<AfdEndpointProtocols>,
    #[serde(rename = "patternsToMatch", default, skip_serializing_if = "Vec::is_empty")]
    pub patterns_to_match: Vec<String>,
    #[serde(rename = "compressionSettings", default, skip_serializing_if = "Option::is_none")]
    pub compression_settings: Option<serde_json::Value>,
    #[serde(rename = "queryStringCachingBehavior", default, skip_serializing_if = "Option::is_none")]
    pub query_string_caching_behavior: Option<route_update_properties_parameters::QueryStringCachingBehavior>,
    #[serde(rename = "forwardingProtocol", default, skip_serializing_if = "Option::is_none")]
    pub forwarding_protocol: Option<route_update_properties_parameters::ForwardingProtocol>,
    #[serde(rename = "linkToDefaultDomain", default, skip_serializing_if = "Option::is_none")]
    pub link_to_default_domain: Option<route_update_properties_parameters::LinkToDefaultDomain>,
    #[serde(rename = "httpsRedirect", default, skip_serializing_if = "Option::is_none")]
    pub https_redirect: Option<route_update_properties_parameters::HttpsRedirect>,
    #[serde(rename = "enabledState", default, skip_serializing_if = "Option::is_none")]
    pub enabled_state: Option<route_update_properties_parameters::EnabledState>,
}
impl RouteUpdatePropertiesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod route_update_properties_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum QueryStringCachingBehavior {
        IgnoreQueryString,
        UseQueryString,
        NotSet,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ForwardingProtocol {
        HttpOnly,
        HttpsOnly,
        MatchRequest,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LinkToDefaultDomain {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HttpsRedirect {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EnabledState {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Rule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RuleProperties>,
}
impl Rule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Rule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RuleProperties {
    #[serde(flatten)]
    pub rule_update_properties_parameters: RuleUpdatePropertiesParameters,
    #[serde(flatten)]
    pub afd_state_properties: AfdStateProperties,
}
impl RuleProperties {
    pub fn new() -> Self {
        Self {
            rule_update_properties_parameters: RuleUpdatePropertiesParameters::default(),
            afd_state_properties: AfdStateProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleSet {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RuleSetProperties>,
}
impl RuleSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleSetListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RuleSet>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RuleSetListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleSetProperties {
    #[serde(flatten)]
    pub afd_state_properties: AfdStateProperties,
}
impl RuleSetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RuleUpdatePropertiesParameters>,
}
impl RuleUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleUpdatePropertiesParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub order: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub conditions: Vec<DeliveryRuleCondition>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub actions: Vec<DeliveryRuleAction>,
    #[serde(rename = "matchProcessingBehavior", default, skip_serializing_if = "Option::is_none")]
    pub match_processing_behavior: Option<rule_update_properties_parameters::MatchProcessingBehavior>,
}
impl RuleUpdatePropertiesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod rule_update_properties_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MatchProcessingBehavior {
        Continue,
        Stop,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Secret {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecretProperties>,
}
impl Secret {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecretListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Secret>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecretListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecretParameters {
    #[serde(rename = "type")]
    pub type_: secret_parameters::Type,
}
impl SecretParameters {
    pub fn new(type_: secret_parameters::Type) -> Self {
        Self { type_ }
    }
}
pub mod secret_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        UrlSigningKey,
        CustomerCertificate,
        ManagedCertificate,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecretProperties {
    #[serde(flatten)]
    pub afd_state_properties: AfdStateProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<SecretParameters>,
}
impl SecretProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityPolicyProperties>,
}
impl SecurityPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPolicyListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityPolicy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityPolicyParameters {
    #[serde(rename = "type")]
    pub type_: security_policy_parameters::Type,
}
impl SecurityPolicyParameters {
    pub fn new(type_: security_policy_parameters::Type) -> Self {
        Self { type_ }
    }
}
pub mod security_policy_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        WebApplicationFirewall,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPolicyProperties {
    #[serde(flatten)]
    pub afd_state_properties: AfdStateProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<SecurityPolicyParameters>,
}
impl SecurityPolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPolicyWebApplicationFirewallAssociation {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub domains: Vec<ResourceReference>,
    #[serde(rename = "patternsToMatch", default, skip_serializing_if = "Vec::is_empty")]
    pub patterns_to_match: Vec<String>,
}
impl SecurityPolicyWebApplicationFirewallAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityPolicyWebApplicationFirewallParameters {
    #[serde(flatten)]
    pub security_policy_parameters: SecurityPolicyParameters,
    #[serde(rename = "wafPolicy", default, skip_serializing_if = "Option::is_none")]
    pub waf_policy: Option<ResourceReference>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub associations: Vec<SecurityPolicyWebApplicationFirewallAssociation>,
}
impl SecurityPolicyWebApplicationFirewallParameters {
    pub fn new(security_policy_parameters: SecurityPolicyParameters) -> Self {
        Self {
            security_policy_parameters,
            waf_policy: None,
            associations: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharedPrivateLinkResourceProperties {
    #[serde(rename = "privateLink", default, skip_serializing_if = "Option::is_none")]
    pub private_link: Option<ResourceReference>,
    #[serde(rename = "privateLinkLocation", default, skip_serializing_if = "Option::is_none")]
    pub private_link_location: Option<String>,
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "requestMessage", default, skip_serializing_if = "Option::is_none")]
    pub request_message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<shared_private_link_resource_properties::Status>,
}
impl SharedPrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod shared_private_link_resource_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Pending,
        Approved,
        Rejected,
        Disconnected,
        Timeout,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<sku::Name>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "Standard_Verizon")]
        StandardVerizon,
        #[serde(rename = "Premium_Verizon")]
        PremiumVerizon,
        #[serde(rename = "Custom_Verizon")]
        CustomVerizon,
        #[serde(rename = "Standard_Akamai")]
        StandardAkamai,
        #[serde(rename = "Standard_ChinaCdn")]
        StandardChinaCdn,
        #[serde(rename = "Standard_Microsoft")]
        StandardMicrosoft,
        #[serde(rename = "Premium_ChinaCdn")]
        PremiumChinaCdn,
        #[serde(rename = "Standard_AzureFrontDoor")]
        StandardAzureFrontDoor,
        #[serde(rename = "Premium_AzureFrontDoor")]
        PremiumAzureFrontDoor,
        #[serde(rename = "Standard_955BandWidth_ChinaCdn")]
        Standard955bandWidthChinaCdn,
        #[serde(rename = "Standard_AvgBandWidth_ChinaCdn")]
        StandardAvgBandWidthChinaCdn,
        #[serde(rename = "StandardPlus_ChinaCdn")]
        StandardPlusChinaCdn,
        #[serde(rename = "StandardPlus_955BandWidth_ChinaCdn")]
        StandardPlus955bandWidthChinaCdn,
        #[serde(rename = "StandardPlus_AvgBandWidth_ChinaCdn")]
        StandardPlusAvgBandWidthChinaCdn,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsoUri {
    #[serde(rename = "ssoUriValue", default, skip_serializing_if = "Option::is_none")]
    pub sso_uri_value: Option<String>,
}
impl SsoUri {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SupportedOptimizationTypesListResult {
    #[serde(rename = "supportedOptimizationTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_optimization_types: Vec<OptimizationType>,
}
impl SupportedOptimizationTypesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<IdentityType>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<IdentityType>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TransformType {
    Lowercase,
    Uppercase,
    Trim,
    UrlDecode,
    UrlEncode,
    RemoveNulls,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlFileExtensionMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: url_file_extension_match_condition_parameters::OdataType,
    pub operator: url_file_extension_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl UrlFileExtensionMatchConditionParameters {
    pub fn new(
        odata_type: url_file_extension_match_condition_parameters::OdataType,
        operator: url_file_extension_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod url_file_extension_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFileExtensionMatchConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleUrlFileExtensionMatchConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        Equal,
        Contains,
        BeginsWith,
        EndsWith,
        LessThan,
        LessThanOrEqual,
        GreaterThan,
        GreaterThanOrEqual,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlFileNameMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: url_file_name_match_condition_parameters::OdataType,
    pub operator: url_file_name_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl UrlFileNameMatchConditionParameters {
    pub fn new(
        odata_type: url_file_name_match_condition_parameters::OdataType,
        operator: url_file_name_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod url_file_name_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFilenameConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleUrlFilenameConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        Equal,
        Contains,
        BeginsWith,
        EndsWith,
        LessThan,
        LessThanOrEqual,
        GreaterThan,
        GreaterThanOrEqual,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlPathMatchConditionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: url_path_match_condition_parameters::OdataType,
    pub operator: url_path_match_condition_parameters::Operator,
    #[serde(rename = "negateCondition", default, skip_serializing_if = "Option::is_none")]
    pub negate_condition: Option<bool>,
    #[serde(rename = "matchValues", default, skip_serializing_if = "Vec::is_empty")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl UrlPathMatchConditionParameters {
    pub fn new(
        odata_type: url_path_match_condition_parameters::OdataType,
        operator: url_path_match_condition_parameters::Operator,
    ) -> Self {
        Self {
            odata_type,
            operator,
            negate_condition: None,
            match_values: Vec::new(),
            transforms: Vec::new(),
        }
    }
}
pub mod url_path_match_condition_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlPathMatchConditionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleUrlPathMatchConditionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Any,
        Equal,
        Contains,
        BeginsWith,
        EndsWith,
        LessThan,
        LessThanOrEqual,
        GreaterThan,
        GreaterThanOrEqual,
        Wildcard,
        RegEx,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlRedirectAction {
    #[serde(flatten)]
    pub delivery_rule_action: DeliveryRuleAction,
    pub parameters: UrlRedirectActionParameters,
}
impl UrlRedirectAction {
    pub fn new(delivery_rule_action: DeliveryRuleAction, parameters: UrlRedirectActionParameters) -> Self {
        Self {
            delivery_rule_action,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlRedirectActionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: url_redirect_action_parameters::OdataType,
    #[serde(rename = "redirectType")]
    pub redirect_type: url_redirect_action_parameters::RedirectType,
    #[serde(rename = "destinationProtocol", default, skip_serializing_if = "Option::is_none")]
    pub destination_protocol: Option<url_redirect_action_parameters::DestinationProtocol>,
    #[serde(rename = "customPath", default, skip_serializing_if = "Option::is_none")]
    pub custom_path: Option<String>,
    #[serde(rename = "customHostname", default, skip_serializing_if = "Option::is_none")]
    pub custom_hostname: Option<String>,
    #[serde(rename = "customQueryString", default, skip_serializing_if = "Option::is_none")]
    pub custom_query_string: Option<String>,
    #[serde(rename = "customFragment", default, skip_serializing_if = "Option::is_none")]
    pub custom_fragment: Option<String>,
}
impl UrlRedirectActionParameters {
    pub fn new(odata_type: url_redirect_action_parameters::OdataType, redirect_type: url_redirect_action_parameters::RedirectType) -> Self {
        Self {
            odata_type,
            redirect_type,
            destination_protocol: None,
            custom_path: None,
            custom_hostname: None,
            custom_query_string: None,
            custom_fragment: None,
        }
    }
}
pub mod url_redirect_action_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRedirectActionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleUrlRedirectActionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RedirectType {
        Moved,
        Found,
        TemporaryRedirect,
        PermanentRedirect,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DestinationProtocol {
        MatchRequest,
        Http,
        Https,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlRewriteAction {
    #[serde(flatten)]
    pub delivery_rule_action: DeliveryRuleAction,
    pub parameters: UrlRewriteActionParameters,
}
impl UrlRewriteAction {
    pub fn new(delivery_rule_action: DeliveryRuleAction, parameters: UrlRewriteActionParameters) -> Self {
        Self {
            delivery_rule_action,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlRewriteActionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: url_rewrite_action_parameters::OdataType,
    #[serde(rename = "sourcePattern")]
    pub source_pattern: String,
    pub destination: String,
    #[serde(rename = "preserveUnmatchedPath", default, skip_serializing_if = "Option::is_none")]
    pub preserve_unmatched_path: Option<bool>,
}
impl UrlRewriteActionParameters {
    pub fn new(odata_type: url_rewrite_action_parameters::OdataType, source_pattern: String, destination: String) -> Self {
        Self {
            odata_type,
            source_pattern,
            destination,
            preserve_unmatched_path: None,
        }
    }
}
pub mod url_rewrite_action_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRewriteActionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleUrlRewriteActionParameters,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlSigningAction {
    #[serde(flatten)]
    pub delivery_rule_action: DeliveryRuleAction,
    pub parameters: UrlSigningActionParameters,
}
impl UrlSigningAction {
    pub fn new(delivery_rule_action: DeliveryRuleAction, parameters: UrlSigningActionParameters) -> Self {
        Self {
            delivery_rule_action,
            parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlSigningActionParameters {
    #[serde(rename = "@odata.type")]
    pub odata_type: url_signing_action_parameters::OdataType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub algorithm: Option<url_signing_action_parameters::Algorithm>,
    #[serde(rename = "parameterNameOverride", default, skip_serializing_if = "Vec::is_empty")]
    pub parameter_name_override: Vec<UrlSigningParamIdentifier>,
}
impl UrlSigningActionParameters {
    pub fn new(odata_type: url_signing_action_parameters::OdataType) -> Self {
        Self {
            odata_type,
            algorithm: None,
            parameter_name_override: Vec::new(),
        }
    }
}
pub mod url_signing_action_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OdataType {
        #[serde(rename = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters")]
        MicrosoftAzureCdnModelsDeliveryRuleUrlSigningActionParameters,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Algorithm {
        #[serde(rename = "SHA256")]
        Sha256,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlSigningKey {
    #[serde(rename = "keyId")]
    pub key_id: String,
    #[serde(rename = "keySourceParameters")]
    pub key_source_parameters: KeyVaultSigningKeyParameters,
}
impl UrlSigningKey {
    pub fn new(key_id: String, key_source_parameters: KeyVaultSigningKeyParameters) -> Self {
        Self {
            key_id,
            key_source_parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlSigningKeyParameters {
    #[serde(flatten)]
    pub secret_parameters: SecretParameters,
    #[serde(rename = "keyId")]
    pub key_id: String,
    #[serde(rename = "secretSource")]
    pub secret_source: ResourceReference,
    #[serde(rename = "secretVersion", default, skip_serializing_if = "Option::is_none")]
    pub secret_version: Option<String>,
}
impl UrlSigningKeyParameters {
    pub fn new(secret_parameters: SecretParameters, key_id: String, secret_source: ResourceReference) -> Self {
        Self {
            secret_parameters,
            key_id,
            secret_source,
            secret_version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlSigningParamIdentifier {
    #[serde(rename = "paramIndicator")]
    pub param_indicator: url_signing_param_identifier::ParamIndicator,
    #[serde(rename = "paramName")]
    pub param_name: String,
}
impl UrlSigningParamIdentifier {
    pub fn new(param_indicator: url_signing_param_identifier::ParamIndicator, param_name: String) -> Self {
        Self {
            param_indicator,
            param_name,
        }
    }
}
pub mod url_signing_param_identifier {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ParamIndicator {
        Expires,
        KeyId,
        Signature,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    pub unit: usage::Unit,
    #[serde(rename = "currentValue")]
    pub current_value: i64,
    pub limit: i64,
    pub name: UsageName,
}
impl Usage {
    pub fn new(unit: usage::Unit, current_value: i64, limit: i64, name: UsageName) -> Self {
        Self {
            id: None,
            unit,
            current_value,
            limit,
            name,
        }
    }
}
pub mod usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsagesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UsagesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserManagedHttpsParameters {
    #[serde(flatten)]
    pub custom_domain_https_parameters: CustomDomainHttpsParameters,
    #[serde(rename = "certificateSourceParameters")]
    pub certificate_source_parameters: KeyVaultCertificateSourceParameters,
}
impl UserManagedHttpsParameters {
    pub fn new(
        custom_domain_https_parameters: CustomDomainHttpsParameters,
        certificate_source_parameters: KeyVaultCertificateSourceParameters,
    ) -> Self {
        Self {
            custom_domain_https_parameters,
            certificate_source_parameters,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidateCustomDomainInput {
    #[serde(rename = "hostName")]
    pub host_name: String,
}
impl ValidateCustomDomainInput {
    pub fn new(host_name: String) -> Self {
        Self { host_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateCustomDomainOutput {
    #[serde(rename = "customDomainValidated", default, skip_serializing_if = "Option::is_none")]
    pub custom_domain_validated: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ValidateCustomDomainOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidateProbeInput {
    #[serde(rename = "probeURL")]
    pub probe_url: String,
}
impl ValidateProbeInput {
    pub fn new(probe_url: String) -> Self {
        Self { probe_url }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateProbeOutput {
    #[serde(rename = "isValid", default, skip_serializing_if = "Option::is_none")]
    pub is_valid: Option<bool>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ValidateProbeOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidateSecretInput {
    #[serde(rename = "secretSource")]
    pub secret_source: ResourceReference,
    #[serde(rename = "secretType")]
    pub secret_type: validate_secret_input::SecretType,
}
impl ValidateSecretInput {
    pub fn new(secret_source: ResourceReference, secret_type: validate_secret_input::SecretType) -> Self {
        Self {
            secret_source,
            secret_type,
        }
    }
}
pub mod validate_secret_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SecretType {
        UrlSigningKey,
        ManagedCertificate,
        CustomerCertificate,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateSecretOutput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<validate_secret_output::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ValidateSecretOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod validate_secret_output {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Valid,
        Invalid,
        AccessDenied,
        CertificateExpired,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidationToken {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub token: Option<String>,
}
impl ValidationToken {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WafMetricsResponse {
    #[serde(rename = "dateTimeBegin", default, skip_serializing_if = "Option::is_none")]
    pub date_time_begin: Option<String>,
    #[serde(rename = "dateTimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub date_time_end: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub granularity: Option<waf_metrics_response::Granularity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub series: Vec<serde_json::Value>,
}
impl WafMetricsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod waf_metrics_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Granularity {
        #[serde(rename = "PT5M")]
        Pt5m,
        #[serde(rename = "PT1H")]
        Pt1h,
        #[serde(rename = "P1D")]
        P1d,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WafRankingsResponse {
    #[serde(rename = "dateTimeBegin", default, skip_serializing_if = "Option::is_none")]
    pub date_time_begin: Option<String>,
    #[serde(rename = "dateTimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub date_time_end: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groups: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub data: Vec<serde_json::Value>,
}
impl WafRankingsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CidrIpAddress {
    #[serde(rename = "baseIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub base_ip_address: Option<String>,
    #[serde(rename = "prefixLength", default, skip_serializing_if = "Option::is_none")]
    pub prefix_length: Option<i64>,
}
impl CidrIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicySettings {
    #[serde(rename = "enabledState", default, skip_serializing_if = "Option::is_none")]
    pub enabled_state: Option<policy_settings::EnabledState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<policy_settings::Mode>,
    #[serde(rename = "defaultRedirectUrl", default, skip_serializing_if = "Option::is_none")]
    pub default_redirect_url: Option<String>,
    #[serde(rename = "defaultCustomBlockResponseStatusCode", default, skip_serializing_if = "Option::is_none")]
    pub default_custom_block_response_status_code: Option<policy_settings::DefaultCustomBlockResponseStatusCode>,
    #[serde(rename = "defaultCustomBlockResponseBody", default, skip_serializing_if = "Option::is_none")]
    pub default_custom_block_response_body: Option<String>,
}
impl PolicySettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod policy_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EnabledState {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        Prevention,
        Detection,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DefaultCustomBlockResponseStatusCode {}
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Transform {
    Lowercase,
    Uppercase,
    Trim,
    UrlDecode,
    UrlEncode,
    RemoveNulls,
}
