#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Amount {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
}
impl Amount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscription {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BillingSubscriptionProperties>,
}
impl BillingSubscription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionAlias {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BillingSubscriptionAliasProperties>,
}
impl BillingSubscriptionAlias {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionAliasListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BillingSubscriptionAlias>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BillingSubscriptionAliasListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionAliasProperties {
    #[serde(flatten)]
    pub billing_subscription_properties: BillingSubscriptionProperties,
    #[serde(rename = "billingSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub billing_subscription_id: Option<String>,
}
impl BillingSubscriptionAliasProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionMergeRequest {
    #[serde(rename = "targetBillingSubscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub target_billing_subscription_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<i32>,
}
impl BillingSubscriptionMergeRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionProperties {
    #[serde(rename = "autoRenew", default, skip_serializing_if = "Option::is_none")]
    pub auto_renew: Option<billing_subscription_properties::AutoRenew>,
    #[serde(rename = "beneficiaryTenantId", default, skip_serializing_if = "Option::is_none")]
    pub beneficiary_tenant_id: Option<String>,
    #[serde(rename = "billingFrequency", default, skip_serializing_if = "Option::is_none")]
    pub billing_frequency: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingPolicies", default, skip_serializing_if = "Option::is_none")]
    pub billing_policies: Option<serde_json::Value>,
    #[serde(rename = "billingProfileDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_display_name: Option<String>,
    #[serde(rename = "billingProfileName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_name: Option<String>,
    #[serde(rename = "consumptionCostCenter", default, skip_serializing_if = "Option::is_none")]
    pub consumption_cost_center: Option<String>,
    #[serde(rename = "customerId", default, skip_serializing_if = "Option::is_none")]
    pub customer_id: Option<String>,
    #[serde(rename = "customerDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub customer_display_name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "enrollmentAccountId", default, skip_serializing_if = "Option::is_none")]
    pub enrollment_account_id: Option<String>,
    #[serde(rename = "enrollmentAccountDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub enrollment_account_display_name: Option<String>,
    #[serde(rename = "enrollmentAccountSubscriptionDetails", default, skip_serializing_if = "Option::is_none")]
    pub enrollment_account_subscription_details: Option<EnrollmentAccountSubscriptionDetails>,
    #[serde(rename = "invoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_id: Option<String>,
    #[serde(rename = "invoiceSectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_display_name: Option<String>,
    #[serde(rename = "invoiceSectionName", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_name: Option<String>,
    #[serde(rename = "lastMonthCharges", default, skip_serializing_if = "Option::is_none")]
    pub last_month_charges: Option<Amount>,
    #[serde(rename = "monthToDateCharges", default, skip_serializing_if = "Option::is_none")]
    pub month_to_date_charges: Option<Amount>,
    #[serde(rename = "nextBillingCycleDetails", default, skip_serializing_if = "Option::is_none")]
    pub next_billing_cycle_details: Option<NextBillingCycleDetails>,
    #[serde(rename = "offerId", default, skip_serializing_if = "Option::is_none")]
    pub offer_id: Option<String>,
    #[serde(rename = "productCategory", default, skip_serializing_if = "Option::is_none")]
    pub product_category: Option<String>,
    #[serde(rename = "productType", default, skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
    #[serde(rename = "productTypeId", default, skip_serializing_if = "Option::is_none")]
    pub product_type_id: Option<String>,
    #[serde(rename = "purchaseDate", default, skip_serializing_if = "Option::is_none")]
    pub purchase_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reseller: Option<Reseller>,
    #[serde(rename = "renewalTermDetails", default, skip_serializing_if = "Option::is_none")]
    pub renewal_term_details: Option<RenewalTermDetails>,
    #[serde(rename = "skuDescription", default, skip_serializing_if = "Option::is_none")]
    pub sku_description: Option<String>,
    #[serde(rename = "skuId", default, skip_serializing_if = "Option::is_none")]
    pub sku_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<billing_subscription_properties::Status>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "suspensionReasons", default, skip_serializing_if = "Vec::is_empty")]
    pub suspension_reasons: Vec<String>,
    #[serde(rename = "termDuration", default, skip_serializing_if = "Option::is_none")]
    pub term_duration: Option<String>,
    #[serde(rename = "termStartDate", default, skip_serializing_if = "Option::is_none")]
    pub term_start_date: Option<String>,
    #[serde(rename = "termEndDate", default, skip_serializing_if = "Option::is_none")]
    pub term_end_date: Option<String>,
}
impl BillingSubscriptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod billing_subscription_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutoRenew {
        Off,
        On,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Unknown,
        Active,
        Disabled,
        Deleted,
        Warned,
        Expiring,
        Expired,
        AutoRenew,
        Cancelled,
        Suspended,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionSplitRequest {
    #[serde(rename = "billingFrequency", default, skip_serializing_if = "Option::is_none")]
    pub billing_frequency: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<i32>,
    #[serde(rename = "targetProductTypeId", default, skip_serializing_if = "Option::is_none")]
    pub target_product_type_id: Option<String>,
    #[serde(rename = "targetSkuId", default, skip_serializing_if = "Option::is_none")]
    pub target_sku_id: Option<String>,
    #[serde(rename = "termDuration", default, skip_serializing_if = "Option::is_none")]
    pub term_duration: Option<String>,
}
impl BillingSubscriptionSplitRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BillingSubscription>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BillingSubscriptionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetachPaymentMethodEligibilityError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<DetachPaymentMethodErrorDetails>,
}
impl DetachPaymentMethodEligibilityError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DetachPaymentMethodEligibilityErrorCode {
    AzureSubscriptions,
    RecurringCharges,
    ReservedInstances,
    OutstandingCharges,
    PendingCharges,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetachPaymentMethodEligibilityResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<DetachPaymentMethodEligibilityError>,
}
impl DetachPaymentMethodEligibilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetachPaymentMethodErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<DetachPaymentMethodEligibilityErrorCode>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl DetachPaymentMethodErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrollmentAccountSubscriptionDetails {
    #[serde(rename = "subscriptionEnrollmentAccountStatus", default, skip_serializing_if = "Option::is_none")]
    pub subscription_enrollment_account_status: Option<enrollment_account_subscription_details::SubscriptionEnrollmentAccountStatus>,
    #[serde(rename = "enrollmentAccountStartDate", default, skip_serializing_if = "Option::is_none")]
    pub enrollment_account_start_date: Option<String>,
}
impl EnrollmentAccountSubscriptionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod enrollment_account_subscription_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SubscriptionEnrollmentAccountStatus {
        Active,
        Cancelled,
        Expired,
        Deleted,
        TransferredOut,
        Transferring,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<ErrorSubDetails>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetails>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type ErrorSubDetails = Vec<serde_json::Value>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum MoveBillingSubscriptionEligibilityErrorCode {
    AccountIsLocked,
    AssetNotActive,
    AssetHasCap,
    BillingAccountInactive,
    BillingProfilePastDue,
    CrossBillingAccountNotAllowed,
    DestinationBillingProfileNotFound,
    DestinationBillingProfileInactive,
    DestinationBillingProfilePastDue,
    DestinationInvoiceSectionNotFound,
    DestinationInvoiceSectionInactive,
    InvalidDestination,
    InvalidSource,
    InvoiceSectionIsRestricted,
    InsufficientPermissionOnDestination,
    InsufficientPermissionOnSource,
    MarketplaceNotEnabledOnDestination,
    ProductNotFound,
    ProductInactive,
    ProductTypeNotSupported,
    SourceBillingProfilePastDue,
    SourceInvoiceSectionInactive,
    SubscriptionNotActive,
    SubscriptionTypeNotSupported,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MoveBillingSubscriptionRequest {
    #[serde(rename = "destinationEnrollmentAccountId", default, skip_serializing_if = "Option::is_none")]
    pub destination_enrollment_account_id: Option<String>,
    #[serde(rename = "destinationInvoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub destination_invoice_section_id: Option<String>,
}
impl MoveBillingSubscriptionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NextBillingCycleDetails {
    #[serde(rename = "billingFrequency", default, skip_serializing_if = "Option::is_none")]
    pub billing_frequency: Option<String>,
}
impl NextBillingCycleDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "isDataAction", default, skip_serializing_if = "Option::is_none")]
    pub is_data_action: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethod {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PaymentMethodProperties>,
}
impl PaymentMethod {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodLink {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PaymentMethodLinkProperties>,
}
impl PaymentMethodLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodLinkProperties {
    #[serde(rename = "paymentMethod", default, skip_serializing_if = "Option::is_none")]
    pub payment_method: Option<PaymentMethodProjectionProperties>,
}
impl PaymentMethodLinkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodLinksListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PaymentMethodLink>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PaymentMethodLinksListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodLogo {
    #[serde(rename = "mimeType", default, skip_serializing_if = "Option::is_none")]
    pub mime_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl PaymentMethodLogo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodProjectionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<payment_method_projection_properties::Family>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "accountHolderName", default, skip_serializing_if = "Option::is_none")]
    pub account_holder_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiration: Option<String>,
    #[serde(rename = "lastFourDigits", default, skip_serializing_if = "Option::is_none")]
    pub last_four_digits: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub logos: Vec<PaymentMethodLogo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<payment_method_projection_properties::Status>,
}
impl PaymentMethodProjectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod payment_method_projection_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Family {
        CreditCard,
        CheckWire,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "active")]
        Active,
        #[serde(rename = "inactive")]
        Inactive,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<payment_method_properties::Family>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "accountHolderName", default, skip_serializing_if = "Option::is_none")]
    pub account_holder_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiration: Option<String>,
    #[serde(rename = "lastFourDigits", default, skip_serializing_if = "Option::is_none")]
    pub last_four_digits: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub logos: Vec<PaymentMethodLogo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<payment_method_properties::Status>,
}
impl PaymentMethodProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod payment_method_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Family {
        CreditCard,
        CheckWire,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "active")]
        Active,
        #[serde(rename = "inactive")]
        Inactive,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodResource {
    #[serde(rename = "paymentMethodId", default, skip_serializing_if = "Option::is_none")]
    pub payment_method_id: Option<String>,
}
impl PaymentMethodResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PaymentMethod>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PaymentMethodsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RenewalTermDetails {
    #[serde(rename = "billingFrequency", default, skip_serializing_if = "Option::is_none")]
    pub billing_frequency: Option<String>,
    #[serde(rename = "productTypeId", default, skip_serializing_if = "Option::is_none")]
    pub product_type_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<i64>,
    #[serde(rename = "skuId", default, skip_serializing_if = "Option::is_none")]
    pub sku_id: Option<String>,
    #[serde(rename = "termDuration", default, skip_serializing_if = "Option::is_none")]
    pub term_duration: Option<String>,
}
impl RenewalTermDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Reseller {
    #[serde(rename = "resellerId", default, skip_serializing_if = "Option::is_none")]
    pub reseller_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl Reseller {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateMoveBillingSubscriptionEligibilityError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<MoveBillingSubscriptionEligibilityErrorCode>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
}
impl ValidateMoveBillingSubscriptionEligibilityError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateMoveBillingSubscriptionEligibilityResult {
    #[serde(rename = "isMoveEligible", default, skip_serializing_if = "Option::is_none")]
    pub is_move_eligible: Option<bool>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Option::is_none")]
    pub error_details: Option<ValidateMoveBillingSubscriptionEligibilityError>,
}
impl ValidateMoveBillingSubscriptionEligibilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
