#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcceptTransferProperties {
    #[serde(rename = "productDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub product_details: Vec<ProductDetails>,
}
impl AcceptTransferProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcceptTransferRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AcceptTransferProperties>,
}
impl AcceptTransferRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type Action = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Address {
    #[serde(rename = "firstName", default, skip_serializing_if = "Option::is_none")]
    pub first_name: Option<String>,
    #[serde(rename = "lastName", default, skip_serializing_if = "Option::is_none")]
    pub last_name: Option<String>,
    #[serde(rename = "companyName", default, skip_serializing_if = "Option::is_none")]
    pub company_name: Option<String>,
    #[serde(rename = "addressLine1", default, skip_serializing_if = "Option::is_none")]
    pub address_line1: Option<String>,
    #[serde(rename = "addressLine2", default, skip_serializing_if = "Option::is_none")]
    pub address_line2: Option<String>,
    #[serde(rename = "addressLine3", default, skip_serializing_if = "Option::is_none")]
    pub address_line3: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[serde(rename = "postalCode", default, skip_serializing_if = "Option::is_none")]
    pub postal_code: Option<String>,
}
impl Address {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AddressValidationStatus {
    Valid,
    Invalid,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Agreement {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AgreementProperties>,
}
impl Agreement {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgreementListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Agreement>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AgreementListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgreementProperties {
    #[serde(rename = "agreementLink", default, skip_serializing_if = "Option::is_none")]
    pub agreement_link: Option<String>,
    #[serde(rename = "effectiveDate", default, skip_serializing_if = "Option::is_none")]
    pub effective_date: Option<String>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub participants: Vec<Participants>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl AgreementProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Amount {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
}
impl Amount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableBalance {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AvailableBalanceProperties>,
}
impl AvailableBalance {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableBalanceProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub amount: Option<Amount>,
}
impl AvailableBalanceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingAccount {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BillingAccountProperties>,
}
impl BillingAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingAccountListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BillingAccount>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BillingAccountListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingAccountProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "accountType", default, skip_serializing_if = "Option::is_none")]
    pub account_type: Option<billing_account_properties::AccountType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<Address>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub company: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[serde(rename = "invoiceSections", default, skip_serializing_if = "Vec::is_empty")]
    pub invoice_sections: Vec<InvoiceSection>,
    #[serde(rename = "billingProfiles", default, skip_serializing_if = "Vec::is_empty")]
    pub billing_profiles: Vec<BillingProfile>,
    #[serde(rename = "enrollmentDetails", default, skip_serializing_if = "Option::is_none")]
    pub enrollment_details: Option<Enrollment>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub departments: Vec<Department>,
    #[serde(rename = "enrollmentAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub enrollment_accounts: Vec<EnrollmentAccount>,
    #[serde(rename = "hasReadAccess", default, skip_serializing_if = "Option::is_none")]
    pub has_read_access: Option<bool>,
}
impl BillingAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod billing_account_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AccountType {
        Organization,
        Enrollment,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingAccountUpdateProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BillingAccountProperties>,
}
impl BillingAccountUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingPermissionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BillingPermissionsProperties>,
}
impl BillingPermissionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingPermissionsProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub actions: Vec<Action>,
    #[serde(rename = "notActions", default, skip_serializing_if = "Vec::is_empty")]
    pub not_actions: Vec<NotAction>,
}
impl BillingPermissionsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingProfile {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BillingProfileProperties>,
}
impl BillingProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingProfileCreationParameters {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "poNumber", default, skip_serializing_if = "Option::is_none")]
    pub po_number: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<Address>,
    #[serde(rename = "invoiceEmailOptIn", default, skip_serializing_if = "Option::is_none")]
    pub invoice_email_opt_in: Option<bool>,
    #[serde(rename = "enableAzureSKUs", default, skip_serializing_if = "Vec::is_empty")]
    pub enable_azure_sk_us: Vec<EnabledAzureSkUs>,
}
impl BillingProfileCreationParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingProfileListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BillingProfile>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BillingProfileListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingProfileProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "poNumber", default, skip_serializing_if = "Option::is_none")]
    pub po_number: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<Address>,
    #[serde(rename = "invoiceEmailOptIn", default, skip_serializing_if = "Option::is_none")]
    pub invoice_email_opt_in: Option<bool>,
    #[serde(rename = "isClassic", default, skip_serializing_if = "Option::is_none")]
    pub is_classic: Option<bool>,
    #[serde(rename = "invoiceDay", default, skip_serializing_if = "Option::is_none")]
    pub invoice_day: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(rename = "enabledAzureSKUs", default, skip_serializing_if = "Vec::is_empty")]
    pub enabled_azure_sk_us: Vec<EnabledAzureSkUs>,
    #[serde(rename = "invoiceSections", default, skip_serializing_if = "Vec::is_empty")]
    pub invoice_sections: Vec<InvoiceSection>,
}
impl BillingProfileProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingProperty {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BillingPropertySummary>,
}
impl BillingProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingPropertySummary {
    #[serde(rename = "billingTenantId", default, skip_serializing_if = "Option::is_none")]
    pub billing_tenant_id: Option<String>,
    #[serde(rename = "billingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub billing_account_id: Option<String>,
    #[serde(rename = "billingAccountName", default, skip_serializing_if = "Option::is_none")]
    pub billing_account_name: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingProfileName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_name: Option<String>,
    #[serde(rename = "costCenter", default, skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    #[serde(rename = "invoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_id: Option<String>,
    #[serde(rename = "invoiceSectionName", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_name: Option<String>,
    #[serde(rename = "productId", default, skip_serializing_if = "Option::is_none")]
    pub product_id: Option<String>,
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[serde(rename = "skuId", default, skip_serializing_if = "Option::is_none")]
    pub sku_id: Option<String>,
    #[serde(rename = "skuDescription", default, skip_serializing_if = "Option::is_none")]
    pub sku_description: Option<String>,
}
impl BillingPropertySummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingRoleAssignment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BillingRoleAssignmentProperties>,
}
impl BillingRoleAssignment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingRoleAssignmentListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BillingRoleAssignment>,
}
impl BillingRoleAssignmentListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingRoleAssignmentPayload {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "billingRoleDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub billing_role_definition_id: Option<String>,
}
impl BillingRoleAssignmentPayload {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingRoleAssignmentProperties {
    #[serde(rename = "createdOn", default, skip_serializing_if = "Option::is_none")]
    pub created_on: Option<String>,
    #[serde(rename = "createdByPrincipalTenantId", default, skip_serializing_if = "Option::is_none")]
    pub created_by_principal_tenant_id: Option<String>,
    #[serde(rename = "createdByPrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub created_by_principal_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "roleDefinitionName", default, skip_serializing_if = "Option::is_none")]
    pub role_definition_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
}
impl BillingRoleAssignmentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingRoleDefinition {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BillingRoleDefinitionProperties>,
}
impl BillingRoleDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingRoleDefinitionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BillingRoleDefinition>,
}
impl BillingRoleDefinitionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingRoleDefinitionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub permissions: Option<BillingPermissionsListResult>,
    #[serde(rename = "roleName", default, skip_serializing_if = "Option::is_none")]
    pub role_name: Option<String>,
}
impl BillingRoleDefinitionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "subscriptionBillingStatus", default, skip_serializing_if = "Option::is_none")]
    pub subscription_billing_status: Option<billing_subscription_properties::SubscriptionBillingStatus>,
    #[serde(rename = "lastMonthCharges", default, skip_serializing_if = "Option::is_none")]
    pub last_month_charges: Option<Amount>,
    #[serde(rename = "monthToDateCharges", default, skip_serializing_if = "Option::is_none")]
    pub month_to_date_charges: Option<Amount>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingProfileName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_name: Option<String>,
    #[serde(rename = "customerId", default, skip_serializing_if = "Option::is_none")]
    pub customer_id: Option<String>,
    #[serde(rename = "customerDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub customer_display_name: Option<String>,
    #[serde(rename = "invoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_id: Option<String>,
    #[serde(rename = "invoiceSectionName", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_name: Option<String>,
    #[serde(rename = "skuId", default, skip_serializing_if = "Option::is_none")]
    pub sku_id: Option<String>,
    #[serde(rename = "skuDescription", default, skip_serializing_if = "Option::is_none")]
    pub sku_description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reseller: Option<Reseller>,
}
impl BillingSubscriptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod billing_subscription_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SubscriptionBillingStatus {
        Active,
        Inactive,
        Abandoned,
        Deleted,
        Warning,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionSummary {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BillingSubscriptionProperties>,
}
impl BillingSubscriptionSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingSubscriptionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BillingSubscriptionSummary>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BillingSubscriptionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Customer {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CustomerProperties>,
}
impl Customer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Customer>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CustomerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomerProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "enabledAzureSKUs", default, skip_serializing_if = "Vec::is_empty")]
    pub enabled_azure_sk_us: Vec<EnabledAzureSkUs>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resellers: Vec<Reseller>,
}
impl CustomerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Department {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DepartmentProperties>,
}
impl Department {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DepartmentListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Department>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DepartmentListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DepartmentProperties {
    #[serde(rename = "departmentName", default, skip_serializing_if = "Option::is_none")]
    pub department_name: Option<String>,
    #[serde(rename = "costCenter", default, skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "enrollmentAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub enrollment_accounts: Vec<EnrollmentAccount>,
}
impl DepartmentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetailedTransferStatus {
    #[serde(rename = "productType", default, skip_serializing_if = "Option::is_none")]
    pub product_type: Option<ProductType>,
    #[serde(rename = "productId", default, skip_serializing_if = "Option::is_none")]
    pub product_id: Option<String>,
    #[serde(rename = "transferStatus", default, skip_serializing_if = "Option::is_none")]
    pub transfer_status: Option<ProductTransferStatus>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Option::is_none")]
    pub error_details: Option<Error>,
}
impl DetailedTransferStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DownloadProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<download_properties::Kind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl DownloadProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod download_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Invoice,
        VoidNote,
        Receipt,
        CreditNote,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DownloadUrl {
    #[serde(rename = "expiryTime", default, skip_serializing_if = "Option::is_none")]
    pub expiry_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl DownloadUrl {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EligibleProductType {
    DevTestAzureSubscription,
    StandardAzureSubscription,
    AzureReservation,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnabledAzureSkUs {
    #[serde(rename = "skuId", default, skip_serializing_if = "Option::is_none")]
    pub sku_id: Option<String>,
    #[serde(rename = "skuDescription", default, skip_serializing_if = "Option::is_none")]
    pub sku_description: Option<String>,
}
impl EnabledAzureSkUs {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Enrollment {
    #[serde(rename = "startDate", default, skip_serializing_if = "Option::is_none")]
    pub start_date: Option<String>,
    #[serde(rename = "endDate", default, skip_serializing_if = "Option::is_none")]
    pub end_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub channel: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub policies: Option<EnrollmentPolicies>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<String>,
    #[serde(rename = "countryCode", default, skip_serializing_if = "Option::is_none")]
    pub country_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "billingCycle", default, skip_serializing_if = "Option::is_none")]
    pub billing_cycle: Option<String>,
}
impl Enrollment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrollmentAccount {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EnrollmentAccountProperties>,
}
impl EnrollmentAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrollmentAccountContext {
    #[serde(rename = "costCenter", default, skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    #[serde(rename = "startDate", default, skip_serializing_if = "Option::is_none")]
    pub start_date: Option<String>,
    #[serde(rename = "endDate", default, skip_serializing_if = "Option::is_none")]
    pub end_date: Option<String>,
    #[serde(rename = "enrollmentAccountName", default, skip_serializing_if = "Option::is_none")]
    pub enrollment_account_name: Option<String>,
}
impl EnrollmentAccountContext {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrollmentAccountListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EnrollmentAccount>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EnrollmentAccountListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrollmentAccountProperties {
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[serde(rename = "costCenter", default, skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    #[serde(rename = "accountOwner", default, skip_serializing_if = "Option::is_none")]
    pub account_owner: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "startDate", default, skip_serializing_if = "Option::is_none")]
    pub start_date: Option<String>,
    #[serde(rename = "endDate", default, skip_serializing_if = "Option::is_none")]
    pub end_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub department: Option<Department>,
}
impl EnrollmentAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrollmentPolicies {
    #[serde(rename = "accountOwnerViewCharges", default, skip_serializing_if = "Option::is_none")]
    pub account_owner_view_charges: Option<bool>,
    #[serde(rename = "departmentAdminViewCharges", default, skip_serializing_if = "Option::is_none")]
    pub department_admin_view_charges: Option<bool>,
    #[serde(rename = "marketplacesEnabled", default, skip_serializing_if = "Option::is_none")]
    pub marketplaces_enabled: Option<bool>,
    #[serde(rename = "reservedInstancesEnabled", default, skip_serializing_if = "Option::is_none")]
    pub reserved_instances_enabled: Option<bool>,
}
impl EnrollmentPolicies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Error {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}
impl Error {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetails>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InitiateTransferProperties {
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "recipientEmailId", default, skip_serializing_if = "Option::is_none")]
    pub recipient_email_id: Option<String>,
}
impl InitiateTransferProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InitiateTransferRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InitiateTransferProperties>,
}
impl InitiateTransferRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InvoiceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<InvoiceSummary>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl InvoiceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InvoiceSection {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InvoiceSectionProperties>,
}
impl InvoiceSection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InvoiceSectionCreationRequest {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
}
impl InvoiceSectionCreationRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InvoiceSectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<InvoiceSection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl InvoiceSectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InvoiceSectionProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "billingProfiles", default, skip_serializing_if = "Vec::is_empty")]
    pub billing_profiles: Vec<BillingProfile>,
}
impl InvoiceSectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InvoiceSummary {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InvoiceSummaryProperties>,
}
impl InvoiceSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InvoiceSummaryProperties {
    #[serde(rename = "dueDate", default, skip_serializing_if = "Option::is_none")]
    pub due_date: Option<String>,
    #[serde(rename = "invoiceDate", default, skip_serializing_if = "Option::is_none")]
    pub invoice_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<invoice_summary_properties::Status>,
    #[serde(rename = "amountDue", default, skip_serializing_if = "Option::is_none")]
    pub amount_due: Option<Amount>,
    #[serde(rename = "billedAmount", default, skip_serializing_if = "Option::is_none")]
    pub billed_amount: Option<Amount>,
    #[serde(rename = "invoicePeriodStartDate", default, skip_serializing_if = "Option::is_none")]
    pub invoice_period_start_date: Option<String>,
    #[serde(rename = "invoicePeriodEndDate", default, skip_serializing_if = "Option::is_none")]
    pub invoice_period_end_date: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingProfileName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_name: Option<String>,
    #[serde(rename = "purchaseOrderNumber", default, skip_serializing_if = "Option::is_none")]
    pub purchase_order_number: Option<String>,
    #[serde(rename = "documentUrls", default, skip_serializing_if = "Vec::is_empty")]
    pub document_urls: Vec<DownloadProperties>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub payments: Vec<PaymentProperties>,
}
impl InvoiceSummaryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod invoice_summary_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        PastDue,
        Due,
        Paid,
        Void,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LineOfCredit {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LineOfCreditProperties>,
}
impl LineOfCredit {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LineOfCreditProperties {
    #[serde(rename = "creditLimit", default, skip_serializing_if = "Option::is_none")]
    pub credit_limit: Option<Amount>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[serde(rename = "remainingBalance", default, skip_serializing_if = "Option::is_none")]
    pub remaining_balance: Option<Amount>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<line_of_credit_properties::Status>,
}
impl LineOfCreditProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod line_of_credit_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Approved,
        Rejected,
    }
}
pub type NotAction = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "statusDetail", default, skip_serializing_if = "Option::is_none")]
    pub status_detail: Option<String>,
}
impl OperationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Participants {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "statusDate", default, skip_serializing_if = "Option::is_none")]
    pub status_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
}
impl Participants {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethod {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PaymentMethodProperties>,
}
impl PaymentMethod {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodProperties {
    #[serde(rename = "paymentMethodType", default, skip_serializing_if = "Option::is_none")]
    pub payment_method_type: Option<payment_method_properties::PaymentMethodType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expiration: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub currency: Option<String>,
}
impl PaymentMethodProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod payment_method_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PaymentMethodType {
        Credits,
        ChequeWire,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentMethodsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PaymentMethod>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PaymentMethodsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PaymentProperties {
    #[serde(rename = "paymentType", default, skip_serializing_if = "Option::is_none")]
    pub payment_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub amount: Option<Amount>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub date: Option<String>,
}
impl PaymentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Policy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PolicyProperties>,
}
impl Policy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyProperties {
    #[serde(rename = "marketplacePurchasesAllowed", default, skip_serializing_if = "Option::is_none")]
    pub marketplace_purchases_allowed: Option<bool>,
    #[serde(rename = "reservationPurchasesAllowed", default, skip_serializing_if = "Option::is_none")]
    pub reservation_purchases_allowed: Option<bool>,
    #[serde(rename = "subscriptionOwnerCanViewCharges", default, skip_serializing_if = "Option::is_none")]
    pub subscription_owner_can_view_charges: Option<bool>,
}
impl PolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProductDetails {
    #[serde(rename = "productType", default, skip_serializing_if = "Option::is_none")]
    pub product_type: Option<ProductType>,
    #[serde(rename = "productId", default, skip_serializing_if = "Option::is_none")]
    pub product_id: Option<String>,
}
impl ProductDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProductSummary {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProductSummaryProperties>,
}
impl ProductSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProductSummaryProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "purchaseDate", default, skip_serializing_if = "Option::is_none")]
    pub purchase_date: Option<String>,
    #[serde(rename = "productTypeId", default, skip_serializing_if = "Option::is_none")]
    pub product_type_id: Option<String>,
    #[serde(rename = "productType", default, skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<product_summary_properties::Status>,
    #[serde(rename = "endDate", default, skip_serializing_if = "Option::is_none")]
    pub end_date: Option<String>,
    #[serde(rename = "billingFrequency", default, skip_serializing_if = "Option::is_none")]
    pub billing_frequency: Option<product_summary_properties::BillingFrequency>,
    #[serde(rename = "lastCharge", default, skip_serializing_if = "Option::is_none")]
    pub last_charge: Option<Amount>,
    #[serde(rename = "lastChargeDate", default, skip_serializing_if = "Option::is_none")]
    pub last_charge_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<f64>,
    #[serde(rename = "skuId", default, skip_serializing_if = "Option::is_none")]
    pub sku_id: Option<String>,
    #[serde(rename = "skuDescription", default, skip_serializing_if = "Option::is_none")]
    pub sku_description: Option<String>,
    #[serde(rename = "availabilityId", default, skip_serializing_if = "Option::is_none")]
    pub availability_id: Option<String>,
    #[serde(rename = "parentProductId", default, skip_serializing_if = "Option::is_none")]
    pub parent_product_id: Option<String>,
    #[serde(rename = "invoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_id: Option<String>,
    #[serde(rename = "invoiceSectionName", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_name: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingProfileName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_name: Option<String>,
}
impl ProductSummaryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod product_summary_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Active,
        Inactive,
        PastDue,
        Expiring,
        Expired,
        Disabled,
        Cancelled,
        AutoRenew,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BillingFrequency {
        OneTime,
        Monthly,
        UsageBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProductTransferStatus {
    NotStarted,
    InProgress,
    Completed,
    Failed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProductTransferValidationErrorCode {
    InvalidSource,
    ProductNotActive,
    InsufficientPermissionOnSource,
    InsufficientPermissionOnDestination,
    DestinationBillingProfilePastDue,
    ProductTypeNotSupported,
    CrossBillingAccountNotAllowed,
    NotAvailableForDestinationMarket,
    OneTimePurchaseProductTransferNotAllowed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProductType {
    AzureSubscription,
    AzureReservation,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProductsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProductSummary>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProductsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientTransferDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecipientTransferProperties>,
}
impl RecipientTransferDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientTransferDetailsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecipientTransferDetails>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecipientTransferDetailsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientTransferProperties {
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[serde(rename = "allowedProductType", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_product_type: Vec<EligibleProductType>,
    #[serde(rename = "transferStatus", default, skip_serializing_if = "Option::is_none")]
    pub transfer_status: Option<TransferStatus>,
    #[serde(rename = "recipientEmailId", default, skip_serializing_if = "Option::is_none")]
    pub recipient_email_id: Option<String>,
    #[serde(rename = "initiatorEmailId", default, skip_serializing_if = "Option::is_none")]
    pub initiator_email_id: Option<String>,
    #[serde(rename = "canceledBy", default, skip_serializing_if = "Option::is_none")]
    pub canceled_by: Option<String>,
    #[serde(rename = "lastModifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<String>,
    #[serde(rename = "detailedTransferStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub detailed_transfer_status: Vec<DetailedTransferStatus>,
}
impl RecipientTransferProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Reseller {
    #[serde(rename = "resellerId", default, skip_serializing_if = "Option::is_none")]
    pub reseller_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl Reseller {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SubscriptionTransferValidationErrorCode {
    InvalidSource,
    SubscriptionNotActive,
    InsufficientPermissionOnSource,
    InsufficientPermissionOnDestination,
    DestinationBillingProfilePastDue,
    SubscriptionTypeNotSupported,
    CrossBillingAccountNotAllowed,
    NotAvailableForDestinationMarket,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransactionsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TransactionsSummary>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TransactionsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransactionsSummary {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TransactionsSummaryProperties>,
}
impl TransactionsSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransactionsSummaryProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<transactions_summary_properties::Kind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub invoice: Option<String>,
    #[serde(rename = "orderId", default, skip_serializing_if = "Option::is_none")]
    pub order_id: Option<String>,
    #[serde(rename = "orderName", default, skip_serializing_if = "Option::is_none")]
    pub order_name: Option<String>,
    #[serde(rename = "productFamily", default, skip_serializing_if = "Option::is_none")]
    pub product_family: Option<String>,
    #[serde(rename = "productTypeId", default, skip_serializing_if = "Option::is_none")]
    pub product_type_id: Option<String>,
    #[serde(rename = "productType", default, skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
    #[serde(rename = "productDescription", default, skip_serializing_if = "Option::is_none")]
    pub product_description: Option<String>,
    #[serde(rename = "transactionType", default, skip_serializing_if = "Option::is_none")]
    pub transaction_type: Option<transactions_summary_properties::TransactionType>,
    #[serde(rename = "transactionAmount", default, skip_serializing_if = "Option::is_none")]
    pub transaction_amount: Option<Amount>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<i32>,
    #[serde(rename = "customerId", default, skip_serializing_if = "Option::is_none")]
    pub customer_id: Option<String>,
    #[serde(rename = "customerDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub customer_display_name: Option<String>,
    #[serde(rename = "invoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_id: Option<String>,
    #[serde(rename = "invoiceSectionName", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_name: Option<String>,
    #[serde(rename = "billingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_id: Option<String>,
    #[serde(rename = "billingProfileName", default, skip_serializing_if = "Option::is_none")]
    pub billing_profile_name: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "subscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub subscription_name: Option<String>,
}
impl TransactionsSummaryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod transactions_summary_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "all")]
        All,
        #[serde(rename = "reservation")]
        Reservation,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TransactionType {
        Purchase,
        #[serde(rename = "Usage Charge")]
        UsageCharge,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransferBillingSubscriptionRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TransferBillingSubscriptionRequestProperties>,
}
impl TransferBillingSubscriptionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransferBillingSubscriptionRequestProperties {
    #[serde(rename = "destinationInvoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub destination_invoice_section_id: Option<String>,
    #[serde(rename = "destinationBillingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub destination_billing_profile_id: Option<String>,
}
impl TransferBillingSubscriptionRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransferBillingSubscriptionResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TransferBillingSubscriptionResultProperties>,
}
impl TransferBillingSubscriptionResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransferBillingSubscriptionResultProperties {
    #[serde(rename = "billingSubscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub billing_subscription_name: Option<String>,
}
impl TransferBillingSubscriptionResultProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransferDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TransferProperties>,
}
impl TransferDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransferDetailsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TransferDetails>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TransferDetailsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransferProductRequestProperties {
    #[serde(rename = "destinationInvoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub destination_invoice_section_id: Option<String>,
    #[serde(rename = "destinationBillingProfileId", default, skip_serializing_if = "Option::is_none")]
    pub destination_billing_profile_id: Option<String>,
}
impl TransferProductRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransferProperties {
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[serde(rename = "invoiceSectionId", default, skip_serializing_if = "Option::is_none")]
    pub invoice_section_id: Option<String>,
    #[serde(rename = "billingAccountId", default, skip_serializing_if = "Option::is_none")]
    pub billing_account_id: Option<String>,
    #[serde(rename = "transferStatus", default, skip_serializing_if = "Option::is_none")]
    pub transfer_status: Option<TransferStatus>,
    #[serde(rename = "recipientEmailId", default, skip_serializing_if = "Option::is_none")]
    pub recipient_email_id: Option<String>,
    #[serde(rename = "initiatorEmailId", default, skip_serializing_if = "Option::is_none")]
    pub initiator_email_id: Option<String>,
    #[serde(rename = "canceledBy", default, skip_serializing_if = "Option::is_none")]
    pub canceled_by: Option<String>,
    #[serde(rename = "lastModifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<String>,
    #[serde(rename = "detailedTransferStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub detailed_transfer_status: Vec<DetailedTransferStatus>,
}
impl TransferProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TransferStatus {
    Pending,
    InProgress,
    Completed,
    CompletedWithErrors,
    Failed,
    Canceled,
    Declined,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateAutoRenewOperationSummary {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateAutoRenewOperationSummaryProperties>,
}
impl UpdateAutoRenewOperationSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateAutoRenewOperationSummaryProperties {
    #[serde(rename = "endDate", default, skip_serializing_if = "Option::is_none")]
    pub end_date: Option<String>,
}
impl UpdateAutoRenewOperationSummaryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateAutoRenewRequest {
    #[serde(rename = "autoRenew", default, skip_serializing_if = "Option::is_none")]
    pub auto_renew: Option<update_auto_renew_request::AutoRenew>,
}
impl UpdateAutoRenewRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod update_auto_renew_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutoRenew {
        #[serde(rename = "true")]
        True,
        #[serde(rename = "false")]
        False,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateAddressResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<AddressValidationStatus>,
    #[serde(rename = "suggestedAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub suggested_addresses: Vec<Address>,
    #[serde(rename = "validationMessage", default, skip_serializing_if = "Option::is_none")]
    pub validation_message: Option<String>,
}
impl ValidateAddressResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateProductTransferEligibilityError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<ProductTransferValidationErrorCode>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
}
impl ValidateProductTransferEligibilityError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateProductTransferEligibilityResult {
    #[serde(rename = "isTransferEligible", default, skip_serializing_if = "Option::is_none")]
    pub is_transfer_eligible: Option<bool>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Option::is_none")]
    pub error_details: Option<ValidateProductTransferEligibilityError>,
}
impl ValidateProductTransferEligibilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateSubscriptionTransferEligibilityError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<SubscriptionTransferValidationErrorCode>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
}
impl ValidateSubscriptionTransferEligibilityError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateSubscriptionTransferEligibilityResult {
    #[serde(rename = "isTransferEligible", default, skip_serializing_if = "Option::is_none")]
    pub is_transfer_eligible: Option<bool>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Option::is_none")]
    pub error_details: Option<ValidateSubscriptionTransferEligibilityError>,
}
impl ValidateSubscriptionTransferEligibilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
