#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Parameters for an activating an application package."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivateApplicationPackageParameters {
    #[doc = "The format of the application package binary file."]
    pub format: String,
}
impl ActivateApplicationPackageParameters {
    pub fn new(format: String) -> Self {
        Self { format }
    }
}
#[doc = "Contains information about an application in a Batch account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Application {
    #[doc = "A string that uniquely identifies the application within the account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The display name for the application."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The list of packages under this application."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub packages: Vec<ApplicationPackage>,
    #[doc = "A value indicating whether packages within the application may be overwritten using the same version string."]
    #[serde(rename = "allowUpdates", default, skip_serializing_if = "Option::is_none")]
    pub allow_updates: Option<bool>,
    #[doc = "The package to use if a client requests the application but does not specify a version."]
    #[serde(rename = "defaultVersion", default, skip_serializing_if = "Option::is_none")]
    pub default_version: Option<String>,
}
impl Application {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for adding an Application."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationCreateParameters {
    #[doc = "A value indicating whether packages within the application may be overwritten using the same version string."]
    #[serde(rename = "allowUpdates", default, skip_serializing_if = "Option::is_none")]
    pub allow_updates: Option<bool>,
    #[doc = "The display name for the application."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl ApplicationCreateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An application package which represents a particular version of an application."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationPackage {
    #[doc = "The ID of the application."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The version of the application package."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[doc = "The current state of the application package."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<application_package::State>,
    #[doc = "The format of the application package, if the package is active."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<String>,
    #[doc = "The URL for the application package in Azure Storage."]
    #[serde(rename = "storageUrl", default, skip_serializing_if = "Option::is_none")]
    pub storage_url: Option<String>,
    #[doc = "The UTC time at which the Azure Storage URL will expire."]
    #[serde(rename = "storageUrlExpiry", default, skip_serializing_if = "Option::is_none")]
    pub storage_url_expiry: Option<String>,
    #[doc = "The time at which the package was last activated, if the package is active."]
    #[serde(rename = "lastActivationTime", default, skip_serializing_if = "Option::is_none")]
    pub last_activation_time: Option<String>,
}
impl ApplicationPackage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_package {
    use super::*;
    #[doc = "The current state of the application package."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Pending,
        Active,
        Unmapped,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationPackageReference {
    pub id: String,
    #[doc = "If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl ApplicationPackageReference {
    pub fn new(id: String) -> Self {
        Self { id, version: None }
    }
}
#[doc = "Parameters for an update application request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationUpdateParameters {
    #[doc = "A value indicating whether packages within the application may be overwritten using the same version string."]
    #[serde(rename = "allowUpdates", default, skip_serializing_if = "Option::is_none")]
    pub allow_updates: Option<bool>,
    #[doc = "The package to use if a client requests the application but does not specify a version."]
    #[serde(rename = "defaultVersion", default, skip_serializing_if = "Option::is_none")]
    pub default_version: Option<String>,
    #[doc = "The display name for the application."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl ApplicationUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoScaleRun {
    #[serde(rename = "evaluationTime")]
    pub evaluation_time: String,
    #[doc = "Each variable value is returned in the form $variable=value, and variables are separated by semicolons."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub results: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<AutoScaleRunError>,
}
impl AutoScaleRun {
    pub fn new(evaluation_time: String) -> Self {
        Self {
            evaluation_time,
            results: None,
            error: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoScaleRunError {
    #[doc = "An identifier for the error. Codes are invariant and are intended to be consumed programmatically."]
    pub code: String,
    #[doc = "A message describing the error, intended to be suitable for display in a user interface."]
    pub message: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<AutoScaleRunError>,
}
impl AutoScaleRunError {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoScaleSettings {
    pub formula: String,
    #[doc = "If omitted, the default value is 15 minutes (PT15M)."]
    #[serde(rename = "evaluationInterval", default, skip_serializing_if = "Option::is_none")]
    pub evaluation_interval: Option<String>,
}
impl AutoScaleSettings {
    pub fn new(formula: String) -> Self {
        Self {
            formula,
            evaluation_interval: None,
        }
    }
}
#[doc = "The properties related to the auto-storage account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoStorageBaseProperties {
    #[doc = "The resource ID of the storage account to be used for auto-storage account."]
    #[serde(rename = "storageAccountId")]
    pub storage_account_id: String,
}
impl AutoStorageBaseProperties {
    pub fn new(storage_account_id: String) -> Self {
        Self { storage_account_id }
    }
}
#[doc = "Contains information about the auto-storage account associated with a Batch account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoStorageProperties {
    #[serde(flatten)]
    pub auto_storage_base_properties: AutoStorageBaseProperties,
    #[doc = "The UTC time at which storage keys were last synchronized with the Batch account."]
    #[serde(rename = "lastKeySync")]
    pub last_key_sync: String,
}
impl AutoStorageProperties {
    pub fn new(auto_storage_base_properties: AutoStorageBaseProperties, last_key_sync: String) -> Self {
        Self {
            auto_storage_base_properties,
            last_key_sync,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoUserSpecification {
    #[doc = "pool - specifies that the task runs as the common auto user account which is created on every node in a pool. task - specifies that the service should create a new user for the task. The default value is task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<auto_user_specification::Scope>,
    #[doc = "Values are:\n\n NonAdmin - The user is a standard user without elevated access.\n Admin - The user is a user with elevated access and operates with full Administrator permissions."]
    #[serde(rename = "elevationLevel", default, skip_serializing_if = "Option::is_none")]
    pub elevation_level: Option<ElevationLevel>,
}
impl AutoUserSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod auto_user_specification {
    use super::*;
    #[doc = "pool - specifies that the task runs as the common auto user account which is created on every node in a pool. task - specifies that the service should create a new user for the task. The default value is task."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Scope {
        Task,
        Pool,
    }
}
#[doc = "Contains information about an Azure Batch account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccount {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Account specific properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BatchAccountProperties>,
}
impl BatchAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters supplied to the Create operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BatchAccountCreateParameters {
    #[doc = "The region in which to create the account."]
    pub location: String,
    #[doc = "The user-specified tags associated with the account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The properties of a Batch account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BatchAccountCreateProperties>,
}
impl BatchAccountCreateParameters {
    pub fn new(location: String) -> Self {
        Self {
            location,
            tags: None,
            properties: None,
        }
    }
}
#[doc = "The properties of a Batch account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountCreateProperties {
    #[doc = "The properties related to the auto-storage account."]
    #[serde(rename = "autoStorage", default, skip_serializing_if = "Option::is_none")]
    pub auto_storage: Option<AutoStorageBaseProperties>,
    #[doc = "The allocation mode for creating pools in the Batch account."]
    #[serde(rename = "poolAllocationMode", default, skip_serializing_if = "Option::is_none")]
    pub pool_allocation_mode: Option<PoolAllocationMode>,
    #[doc = "Identifies the Azure key vault associated with a Batch account."]
    #[serde(rename = "keyVaultReference", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_reference: Option<KeyVaultReference>,
}
impl BatchAccountCreateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A set of Azure Batch account keys."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountKeys {
    #[doc = "The Batch account name."]
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[doc = "The primary key associated with the account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<String>,
    #[doc = "The secondary key associated with the account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secondary: Option<String>,
}
impl BatchAccountKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Values returned by the List operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountListResult {
    #[doc = "The collection of Batch accounts returned by the listing operation."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BatchAccount>,
    #[doc = "The continuation token."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BatchAccountListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Account specific properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountProperties {
    #[doc = "The account endpoint used to interact with the Batch service."]
    #[serde(rename = "accountEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub account_endpoint: Option<String>,
    #[doc = "The provisioned state of the resource"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<batch_account_properties::ProvisioningState>,
    #[doc = "The allocation mode for creating pools in the Batch account."]
    #[serde(rename = "poolAllocationMode", default, skip_serializing_if = "Option::is_none")]
    pub pool_allocation_mode: Option<PoolAllocationMode>,
    #[doc = "Identifies the Azure key vault associated with a Batch account."]
    #[serde(rename = "keyVaultReference", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_reference: Option<KeyVaultReference>,
    #[doc = "Contains information about the auto-storage account associated with a Batch account."]
    #[serde(rename = "autoStorage", default, skip_serializing_if = "Option::is_none")]
    pub auto_storage: Option<AutoStorageProperties>,
    #[serde(rename = "dedicatedCoreQuota", default, skip_serializing_if = "Option::is_none")]
    pub dedicated_core_quota: Option<i32>,
    #[serde(rename = "lowPriorityCoreQuota", default, skip_serializing_if = "Option::is_none")]
    pub low_priority_core_quota: Option<i32>,
    #[serde(rename = "poolQuota", default, skip_serializing_if = "Option::is_none")]
    pub pool_quota: Option<i32>,
    #[serde(rename = "activeJobAndJobScheduleQuota", default, skip_serializing_if = "Option::is_none")]
    pub active_job_and_job_schedule_quota: Option<i32>,
}
impl BatchAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod batch_account_properties {
    use super::*;
    #[doc = "The provisioned state of the resource"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Invalid,
        Creating,
        Deleting,
        Succeeded,
        Failed,
        Cancelled,
    }
}
#[doc = "Parameters supplied to the RegenerateKey operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BatchAccountRegenerateKeyParameters {
    #[doc = "The type of account key to regenerate."]
    #[serde(rename = "keyName")]
    pub key_name: batch_account_regenerate_key_parameters::KeyName,
}
impl BatchAccountRegenerateKeyParameters {
    pub fn new(key_name: batch_account_regenerate_key_parameters::KeyName) -> Self {
        Self { key_name }
    }
}
pub mod batch_account_regenerate_key_parameters {
    use super::*;
    #[doc = "The type of account key to regenerate."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyName {
        Primary,
        Secondary,
    }
}
#[doc = "Parameters for updating an Azure Batch account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountUpdateParameters {
    #[doc = "The user-specified tags associated with the account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The properties of a Batch account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BatchAccountUpdateProperties>,
}
impl BatchAccountUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a Batch account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountUpdateProperties {
    #[doc = "The properties related to the auto-storage account."]
    #[serde(rename = "autoStorage", default, skip_serializing_if = "Option::is_none")]
    pub auto_storage: Option<AutoStorageBaseProperties>,
}
impl BatchAccountUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Quotas associated with a Batch region for a particular subscription."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchLocationQuota {
    #[doc = "The number of Batch accounts that may be created under the subscription in the specified region."]
    #[serde(rename = "accountQuota", default, skip_serializing_if = "Option::is_none")]
    pub account_quota: Option<i32>,
}
impl BatchLocationQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Values are:\n\n None - The caching mode for the disk is not enabled.\n ReadOnly - The caching mode for the disk is read only.\n ReadWrite - The caching mode for the disk is read and write. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CachingType {
    None,
    ReadOnly,
    ReadWrite,
}
#[doc = "Contains information about a certificate."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Certificate {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Certificate properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificateProperties>,
}
impl Certificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateBaseProperties {
    #[doc = "This must match the first portion of the certificate name. Currently required to be 'SHA1'."]
    #[serde(rename = "thumbprintAlgorithm", default, skip_serializing_if = "Option::is_none")]
    pub thumbprint_algorithm: Option<String>,
    #[doc = "This must match the thumbprint from the name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<certificate_base_properties::Format>,
}
impl CertificateBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod certificate_base_properties {
    use super::*;
    #[doc = "The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Format {
        Pfx,
        Cer,
    }
}
#[doc = "Contains information about a certificate."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateCreateOrUpdateParameters {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Certificate properties for create operations"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificateCreateOrUpdateProperties>,
}
impl CertificateCreateOrUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Certificate properties for create operations"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateCreateOrUpdateProperties {
    #[serde(flatten)]
    pub certificate_base_properties: CertificateBaseProperties,
    #[doc = "The maximum size is 10KB."]
    pub data: String,
    #[doc = "This is required if the certificate format is pfx and must be omitted if the certificate format is cer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl CertificateCreateOrUpdateProperties {
    pub fn new(data: String) -> Self {
        Self {
            certificate_base_properties: CertificateBaseProperties::default(),
            data,
            password: None,
        }
    }
}
#[doc = "Certificate properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateProperties {
    #[serde(flatten)]
    pub certificate_base_properties: CertificateBaseProperties,
    #[doc = "Values are:\n\n Succeeded - The certificate is available for use in pools.\n Deleting - The user has requested that the certificate be deleted, but the delete operation has not yet completed. You may not reference the certificate when creating or updating pools.\n Failed - The user requested that the certificate be deleted, but there are pools that still have references to the certificate, or it is still installed on one or more compute nodes. (The latter can occur if the certificate has been removed from the pool, but the node has not yet restarted. Nodes refresh their certificates only when they restart.) You may use the cancel certificate delete operation to cancel the delete, or the delete certificate operation to retry the delete."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<certificate_properties::ProvisioningState>,
    #[serde(rename = "provisioningStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state_transition_time: Option<String>,
    #[doc = "The previous provisioned state of the resource"]
    #[serde(rename = "previousProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub previous_provisioning_state: Option<certificate_properties::PreviousProvisioningState>,
    #[serde(
        rename = "previousProvisioningStateTransitionTime",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub previous_provisioning_state_transition_time: Option<String>,
    #[doc = "The public key of the certificate."]
    #[serde(rename = "publicData", default, skip_serializing_if = "Option::is_none")]
    pub public_data: Option<String>,
    #[doc = "An error response from the Batch service."]
    #[serde(rename = "deleteCertificateError", default, skip_serializing_if = "Option::is_none")]
    pub delete_certificate_error: Option<DeleteCertificateError>,
}
impl CertificateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod certificate_properties {
    use super::*;
    #[doc = "Values are:\n\n Succeeded - The certificate is available for use in pools.\n Deleting - The user has requested that the certificate be deleted, but the delete operation has not yet completed. You may not reference the certificate when creating or updating pools.\n Failed - The user requested that the certificate be deleted, but there are pools that still have references to the certificate, or it is still installed on one or more compute nodes. (The latter can occur if the certificate has been removed from the pool, but the node has not yet restarted. Nodes refresh their certificates only when they restart.) You may use the cancel certificate delete operation to cancel the delete, or the delete certificate operation to retry the delete."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Deleting,
        Failed,
    }
    #[doc = "The previous provisioned state of the resource"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreviousProvisioningState {
        Succeeded,
        Deleting,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateReference {
    pub id: String,
    #[doc = "The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory."]
    #[serde(rename = "storeLocation", default, skip_serializing_if = "Option::is_none")]
    pub store_location: Option<certificate_reference::StoreLocation>,
    #[doc = "This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My."]
    #[serde(rename = "storeName", default, skip_serializing_if = "Option::is_none")]
    pub store_name: Option<String>,
    #[doc = "Values are:\n\n starttask - The user account under which the start task is run.\n task - The accounts under which job tasks are run.\n remoteuser - The accounts under which users remotely access the node.\n\n You can specify more than one visibility in this collection. The default is all accounts."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub visibility: Vec<String>,
}
impl CertificateReference {
    pub fn new(id: String) -> Self {
        Self {
            id,
            store_location: None,
            store_name: None,
            visibility: Vec::new(),
        }
    }
}
pub mod certificate_reference {
    use super::*;
    #[doc = "The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StoreLocation {
        CurrentUser,
        LocalMachine,
    }
}
#[doc = "Parameters for a check name availability request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckNameAvailabilityParameters {
    #[doc = "The name to check for availability"]
    pub name: String,
    #[doc = "The resource type. Must be set to Microsoft.Batch/batchAccounts"]
    #[serde(rename = "type")]
    pub type_: check_name_availability_parameters::Type,
}
impl CheckNameAvailabilityParameters {
    pub fn new(name: String, type_: check_name_availability_parameters::Type) -> Self {
        Self { name, type_ }
    }
}
pub mod check_name_availability_parameters {
    use super::*;
    #[doc = "The resource type. Must be set to Microsoft.Batch/batchAccounts"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.Batch/batchAccounts")]
        MicrosoftBatchBatchAccounts,
    }
}
#[doc = "The CheckNameAvailability operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckNameAvailabilityResult {
    #[doc = "Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or invalid and cannot be used."]
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[doc = "Gets the reason that a Batch account name could not be used. The Reason element is only returned if NameAvailable is false."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<check_name_availability_result::Reason>,
    #[doc = "Gets an error message explaining the Reason value in more detail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl CheckNameAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod check_name_availability_result {
    use super::*;
    #[doc = "Gets the reason that a Batch account name could not be used. The Reason element is only returned if NameAvailable is false."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[doc = "An error response from the Batch service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "An error response from the Batch service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response from the Batch service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "An identifier for the error. Codes are invariant and are intended to be consumed programmatically."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "A message describing the error, intended to be suitable for display in a user interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The target of the particular error. For example, the name of the property in error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "A list of additional details about the error."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudServiceConfiguration {
    #[doc = "Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases)."]
    #[serde(rename = "osFamily")]
    pub os_family: String,
    #[doc = "The default value is * which specifies the latest operating system version for the specified OS family."]
    #[serde(rename = "targetOSVersion", default, skip_serializing_if = "Option::is_none")]
    pub target_os_version: Option<String>,
    #[doc = "This may differ from targetOSVersion if the pool state is Upgrading. In this case some virtual machines may be on the targetOSVersion and some may be on the currentOSVersion during the upgrade process. Once all virtual machines have upgraded, currentOSVersion is updated to be the same as targetOSVersion."]
    #[serde(rename = "currentOSVersion", default, skip_serializing_if = "Option::is_none")]
    pub current_os_version: Option<String>,
}
impl CloudServiceConfiguration {
    pub fn new(os_family: String) -> Self {
        Self {
            os_family,
            target_os_version: None,
            current_os_version: None,
        }
    }
}
#[doc = "Values are:\n\n Requeue - Terminate running tasks and requeue them. The tasks will run again when the job is enabled. Remove nodes as soon as tasks have been terminated.\n Terminate - Terminate running tasks. The tasks will not run again. Remove nodes as soon as tasks have been terminated.\n TaskCompletion - Allow currently running tasks to complete. Schedule no new tasks while waiting. Remove nodes when all tasks have completed.\n RetainedData - Allow currently running tasks to complete, then wait for all task data retention periods to expire. Schedule no new tasks while waiting. Remove nodes when all task retention periods have expired."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ComputeNodeDeallocationOption {
    Requeue,
    Terminate,
    TaskCompletion,
    RetainedData,
}
#[doc = "Data Disk settings which will be used by the data disks associated to Compute Nodes in the pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataDisk {
    #[doc = "The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun."]
    pub lun: i32,
    #[doc = "Values are:\n\n None - The caching mode for the disk is not enabled.\n ReadOnly - The caching mode for the disk is read only.\n ReadWrite - The caching mode for the disk is read and write. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<CachingType>,
    #[serde(rename = "diskSizeGB")]
    pub disk_size_gb: i32,
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<StorageAccountType>,
}
impl DataDisk {
    pub fn new(lun: i32, disk_size_gb: i32) -> Self {
        Self {
            lun,
            caching: None,
            disk_size_gb,
            storage_account_type: None,
        }
    }
}
#[doc = "An error response from the Batch service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeleteCertificateError {
    #[doc = "An identifier for the error. Codes are invariant and are intended to be consumed programmatically."]
    pub code: String,
    #[doc = "A message describing the error, intended to be suitable for display in a user interface."]
    pub message: String,
    #[doc = "The target of the particular error. For example, the name of the property in error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "A list of additional details about the error."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<DeleteCertificateError>,
}
impl DeleteCertificateError {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentConfiguration {
    #[serde(rename = "cloudServiceConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_configuration: Option<CloudServiceConfiguration>,
    #[serde(rename = "virtualMachineConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_configuration: Option<VirtualMachineConfiguration>,
}
impl DeploymentConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Values are:\n\n NonAdmin - The user is a standard user without elevated access.\n Admin - The user is a user with elevated access and operates with full Administrator permissions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ElevationLevel {
    NonAdmin,
    Admin,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentSetting {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl EnvironmentSetting {
    pub fn new(name: String) -> Self {
        Self { name, value: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FixedScaleSettings {
    #[doc = "The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request)."]
    #[serde(rename = "resizeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub resize_timeout: Option<String>,
    #[doc = "At least one of targetDedicatedNodes, targetLowPriority nodes must be set."]
    #[serde(rename = "targetDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_dedicated_nodes: Option<i32>,
    #[doc = "At least one of targetDedicatedNodes, targetLowPriority nodes must be set."]
    #[serde(rename = "targetLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_low_priority_nodes: Option<i32>,
    #[doc = "Values are:\n\n Requeue - Terminate running tasks and requeue them. The tasks will run again when the job is enabled. Remove nodes as soon as tasks have been terminated.\n Terminate - Terminate running tasks. The tasks will not run again. Remove nodes as soon as tasks have been terminated.\n TaskCompletion - Allow currently running tasks to complete. Schedule no new tasks while waiting. Remove nodes when all tasks have completed.\n RetainedData - Allow currently running tasks to complete, then wait for all task data retention periods to expire. Schedule no new tasks while waiting. Remove nodes when all task retention periods have expired."]
    #[serde(rename = "nodeDeallocationOption", default, skip_serializing_if = "Option::is_none")]
    pub node_deallocation_option: Option<ComputeNodeDeallocationOption>,
}
impl FixedScaleSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageReference {
    #[doc = "For example, Canonical or MicrosoftWindowsServer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[doc = "For example, UbuntuServer or WindowsServer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
    #[doc = "For example, 14.04.0-LTS or 2012-R2-Datacenter."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[doc = "A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[doc = "This property is mutually exclusive with other properties. The virtual machine image must be in the same region and subscription as the Azure Batch account. For information about the firewall settings for Batch node agent to communicate with Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration ."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ImageReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundNatPool {
    #[doc = "The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400."]
    pub name: String,
    pub protocol: inbound_nat_pool::Protocol,
    #[doc = "This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400."]
    #[serde(rename = "backendPort")]
    pub backend_port: i32,
    #[doc = "Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400."]
    #[serde(rename = "frontendPortRangeStart")]
    pub frontend_port_range_start: i32,
    #[doc = "Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400."]
    #[serde(rename = "frontendPortRangeEnd")]
    pub frontend_port_range_end: i32,
    #[doc = "The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400."]
    #[serde(rename = "networkSecurityGroupRules", default, skip_serializing_if = "Vec::is_empty")]
    pub network_security_group_rules: Vec<NetworkSecurityGroupRule>,
}
impl InboundNatPool {
    pub fn new(
        name: String,
        protocol: inbound_nat_pool::Protocol,
        backend_port: i32,
        frontend_port_range_start: i32,
        frontend_port_range_end: i32,
    ) -> Self {
        Self {
            name,
            protocol,
            backend_port,
            frontend_port_range_start,
            frontend_port_range_end,
            network_security_group_rules: Vec::new(),
        }
    }
}
pub mod inbound_nat_pool {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
    }
}
#[doc = "Identifies the Azure key vault associated with a Batch account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultReference {
    #[doc = "The resource ID of the Azure key vault associated with the Batch account."]
    pub id: String,
    #[doc = "The URL of the Azure key vault associated with the Batch account."]
    pub url: String,
}
impl KeyVaultReference {
    pub fn new(id: String, url: String) -> Self {
        Self { id, url }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinuxUserConfiguration {
    #[doc = "The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uid: Option<i32>,
    #[doc = "The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub gid: Option<i32>,
    #[doc = "The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done)."]
    #[serde(rename = "sshPrivateKey", default, skip_serializing_if = "Option::is_none")]
    pub ssh_private_key: Option<String>,
}
impl LinuxUserConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of performing list applications."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListApplicationsResult {
    #[doc = "The list of applications."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Application>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListApplicationsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Values returned by the List operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListCertificatesResult {
    #[doc = "The collection of returned certificates."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Certificate>,
    #[doc = "The continuation token."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListCertificatesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Values returned by the List operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListPoolsResult {
    #[doc = "The collection of returned pools."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Pool>,
    #[doc = "The continuation token."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListPoolsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Batch service does not assign any meaning to this metadata; it is solely for the use of user code."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataItem {
    pub name: String,
    pub value: String,
}
impl MetadataItem {
    pub fn new(name: String, value: String) -> Self {
        Self { name, value }
    }
}
#[doc = "The network configuration for a pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkConfiguration {
    #[doc = "The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes, and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. For pools created via virtualMachineConfiguration the Batch account must have poolAllocationMode userSubscription in order to use a VNet. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration"]
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[serde(rename = "endpointConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_configuration: Option<PoolEndpointConfiguration>,
}
impl NetworkConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkSecurityGroupRule {
    #[doc = "Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 3500. If any reserved or duplicate values are provided the request fails with HTTP status code 400."]
    pub priority: i32,
    pub access: network_security_group_rule::Access,
    #[doc = "Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400."]
    #[serde(rename = "sourceAddressPrefix")]
    pub source_address_prefix: String,
}
impl NetworkSecurityGroupRule {
    pub fn new(priority: i32, access: network_security_group_rule::Access, source_address_prefix: String) -> Self {
        Self {
            priority,
            access,
            source_address_prefix,
        }
    }
}
pub mod network_security_group_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsDisk {
    #[doc = "Values are:\n\n None - The caching mode for the disk is not enabled.\n ReadOnly - The caching mode for the disk is read only.\n ReadWrite - The caching mode for the disk is read and write. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<CachingType>,
}
impl OsDisk {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "This is of the format {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "For example: read, write, delete, or listKeys/action"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains information about a pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Pool {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Pool properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PoolProperties>,
}
impl Pool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The allocation mode for creating pools in the Batch account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PoolAllocationMode {
    BatchService,
    UserSubscription,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolEndpointConfiguration {
    #[doc = "The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400."]
    #[serde(rename = "inboundNatPools")]
    pub inbound_nat_pools: Vec<InboundNatPool>,
}
impl PoolEndpointConfiguration {
    pub fn new(inbound_nat_pools: Vec<InboundNatPool>) -> Self {
        Self { inbound_nat_pools }
    }
}
#[doc = "Pool properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PoolProperties {
    #[doc = "The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "This is the last time at which the pool level data, such as the targetDedicatedNodes or autoScaleSettings, changed. It does not factor in node-level changes such as a compute node changing state."]
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[doc = "Values are:\n\n Succeeded - The pool is available to run tasks subject to the availability of compute nodes.\n Deleting - The user has requested that the pool be deleted, but the delete operation has not yet completed."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<pool_properties::ProvisioningState>,
    #[serde(rename = "provisioningStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state_transition_time: Option<String>,
    #[doc = "Values are:\n\n Steady - The pool is not resizing. There are no changes to the number of nodes in the pool in progress. A pool enters this state when it is created and when no operations are being performed on the pool to change the number of dedicated nodes.\n Resizing - The pool is resizing; that is, compute nodes are being added to or removed from the pool.\n Stopping - The pool was resizing, but the user has requested that the resize be stopped, but the stop request has not yet been completed."]
    #[serde(rename = "allocationState", default, skip_serializing_if = "Option::is_none")]
    pub allocation_state: Option<pool_properties::AllocationState>,
    #[serde(rename = "allocationStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub allocation_state_transition_time: Option<String>,
    #[doc = "For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series)."]
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<String>,
    #[serde(rename = "deploymentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub deployment_configuration: Option<DeploymentConfiguration>,
    #[serde(rename = "currentDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub current_dedicated_nodes: Option<i32>,
    #[serde(rename = "currentLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub current_low_priority_nodes: Option<i32>,
    #[doc = "Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes."]
    #[serde(rename = "scaleSettings", default, skip_serializing_if = "Option::is_none")]
    pub scale_settings: Option<ScaleSettings>,
    #[serde(rename = "autoScaleRun", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_run: Option<AutoScaleRun>,
    #[doc = "This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to 'Disabled'."]
    #[serde(rename = "interNodeCommunication", default, skip_serializing_if = "Option::is_none")]
    pub inter_node_communication: Option<pool_properties::InterNodeCommunication>,
    #[doc = "The network configuration for a pool."]
    #[serde(rename = "networkConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub network_configuration: Option<NetworkConfiguration>,
    #[serde(rename = "maxTasksPerNode", default, skip_serializing_if = "Option::is_none")]
    pub max_tasks_per_node: Option<i32>,
    #[serde(rename = "taskSchedulingPolicy", default, skip_serializing_if = "Option::is_none")]
    pub task_scheduling_policy: Option<TaskSchedulingPolicy>,
    #[serde(rename = "userAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub user_accounts: Vec<UserAccount>,
    #[doc = "The Batch service does not assign any meaning to metadata; it is solely for the use of user code."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
    #[serde(rename = "startTask", default, skip_serializing_if = "Option::is_none")]
    pub start_task: Option<StartTask>,
    #[doc = "For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub certificates: Vec<CertificateReference>,
    #[doc = "Changes to application packages affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged."]
    #[serde(rename = "applicationPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub application_packages: Vec<ApplicationPackageReference>,
    #[doc = "The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail."]
    #[serde(rename = "applicationLicenses", default, skip_serializing_if = "Vec::is_empty")]
    pub application_licenses: Vec<String>,
    #[doc = "Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady)."]
    #[serde(rename = "resizeOperationStatus", default, skip_serializing_if = "Option::is_none")]
    pub resize_operation_status: Option<ResizeOperationStatus>,
}
impl PoolProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pool_properties {
    use super::*;
    #[doc = "Values are:\n\n Succeeded - The pool is available to run tasks subject to the availability of compute nodes.\n Deleting - The user has requested that the pool be deleted, but the delete operation has not yet completed."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Deleting,
    }
    #[doc = "Values are:\n\n Steady - The pool is not resizing. There are no changes to the number of nodes in the pool in progress. A pool enters this state when it is created and when no operations are being performed on the pool to change the number of dedicated nodes.\n Resizing - The pool is resizing; that is, compute nodes are being added to or removed from the pool.\n Stopping - The pool was resizing, but the user has requested that the resize be stopped, but the stop request has not yet been completed."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AllocationState {
        Steady,
        Resizing,
        Stopping,
    }
    #[doc = "This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to 'Disabled'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InterNodeCommunication {
        Enabled,
        Disabled,
    }
}
#[doc = "A definition of an Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[doc = "The ID of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The ETag of the resource, used for concurrency statements."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResizeError {
    #[doc = "An identifier for the error. Codes are invariant and are intended to be consumed programmatically."]
    pub code: String,
    #[doc = "A message describing the error, intended to be suitable for display in a user interface."]
    pub message: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ResizeError>,
}
impl ResizeError {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            details: Vec::new(),
        }
    }
}
#[doc = "Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResizeOperationStatus {
    #[serde(rename = "targetDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_dedicated_nodes: Option<i32>,
    #[serde(rename = "targetLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_low_priority_nodes: Option<i32>,
    #[doc = "The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request)."]
    #[serde(rename = "resizeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub resize_timeout: Option<String>,
    #[doc = "Values are:\n\n Requeue - Terminate running tasks and requeue them. The tasks will run again when the job is enabled. Remove nodes as soon as tasks have been terminated.\n Terminate - Terminate running tasks. The tasks will not run again. Remove nodes as soon as tasks have been terminated.\n TaskCompletion - Allow currently running tasks to complete. Schedule no new tasks while waiting. Remove nodes when all tasks have completed.\n RetainedData - Allow currently running tasks to complete, then wait for all task data retention periods to expire. Schedule no new tasks while waiting. Remove nodes when all task retention periods have expired."]
    #[serde(rename = "nodeDeallocationOption", default, skip_serializing_if = "Option::is_none")]
    pub node_deallocation_option: Option<ComputeNodeDeallocationOption>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "This property is set only if an error occurred during the last pool resize, and only when the pool allocationState is Steady."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ResizeError>,
}
impl ResizeOperationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A definition of an Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "The ID of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The location of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "The tags of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceFile {
    #[doc = "This URL must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access."]
    #[serde(rename = "blobSource")]
    pub blob_source: String,
    #[serde(rename = "filePath")]
    pub file_path: String,
    #[doc = "This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file."]
    #[serde(rename = "fileMode", default, skip_serializing_if = "Option::is_none")]
    pub file_mode: Option<String>,
}
impl ResourceFile {
    pub fn new(blob_source: String, file_path: String) -> Self {
        Self {
            blob_source,
            file_path,
            file_mode: None,
        }
    }
}
#[doc = "Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScaleSettings {
    #[serde(rename = "fixedScale", default, skip_serializing_if = "Option::is_none")]
    pub fixed_scale: Option<FixedScaleSettings>,
    #[serde(rename = "autoScale", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale: Option<AutoScaleSettings>,
}
impl ScaleSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StartTask {
    #[doc = "The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using \"cmd /c MyCommand\" in Windows or \"/bin/sh -c MyCommand\" in Linux. Required if any other properties of the startTask are specified."]
    #[serde(rename = "commandLine", default, skip_serializing_if = "Option::is_none")]
    pub command_line: Option<String>,
    #[serde(rename = "resourceFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_files: Vec<ResourceFile>,
    #[serde(rename = "environmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_settings: Vec<EnvironmentSetting>,
    #[doc = "Specify either the userName or autoUser property, but not both."]
    #[serde(rename = "userIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_identity: Option<UserIdentity>,
    #[doc = "The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit."]
    #[serde(rename = "maxTaskRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_task_retry_count: Option<i32>,
    #[doc = "If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is false."]
    #[serde(rename = "waitForSuccess", default, skip_serializing_if = "Option::is_none")]
    pub wait_for_success: Option<bool>,
}
impl StartTask {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum StorageAccountType {
    #[serde(rename = "Standard_LRS")]
    StandardLrs,
    #[serde(rename = "Premium_LRS")]
    PremiumLrs,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskSchedulingPolicy {
    #[serde(rename = "nodeFillType")]
    pub node_fill_type: task_scheduling_policy::NodeFillType,
}
impl TaskSchedulingPolicy {
    pub fn new(node_fill_type: task_scheduling_policy::NodeFillType) -> Self {
        Self { node_fill_type }
    }
}
pub mod task_scheduling_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeFillType {
        Spread,
        Pack,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserAccount {
    pub name: String,
    pub password: String,
    #[doc = "Values are:\n\n NonAdmin - The user is a standard user without elevated access.\n Admin - The user is a user with elevated access and operates with full Administrator permissions."]
    #[serde(rename = "elevationLevel", default, skip_serializing_if = "Option::is_none")]
    pub elevation_level: Option<ElevationLevel>,
    #[serde(rename = "linuxUserConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_user_configuration: Option<LinuxUserConfiguration>,
}
impl UserAccount {
    pub fn new(name: String, password: String) -> Self {
        Self {
            name,
            password,
            elevation_level: None,
            linux_user_configuration: None,
        }
    }
}
#[doc = "Specify either the userName or autoUser property, but not both."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentity {
    #[doc = "The userName and autoUser properties are mutually exclusive; you must specify one but not both."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(rename = "autoUser", default, skip_serializing_if = "Option::is_none")]
    pub auto_user: Option<AutoUserSpecification>,
}
impl UserIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineConfiguration {
    #[serde(rename = "imageReference")]
    pub image_reference: ImageReference,
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<OsDisk>,
    #[doc = "The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation."]
    #[serde(rename = "nodeAgentSkuId")]
    pub node_agent_sku_id: String,
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[doc = "This property must be specified if the compute nodes in the pool need to have empty data disks attached to them."]
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<DataDisk>,
    #[doc = "This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:\n\n Windows_Server - The on-premises license is for Windows Server.\n Windows_Client - The on-premises license is for Windows Client.\n"]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
}
impl VirtualMachineConfiguration {
    pub fn new(image_reference: ImageReference, node_agent_sku_id: String) -> Self {
        Self {
            image_reference,
            os_disk: None,
            node_agent_sku_id,
            windows_configuration: None,
            data_disks: Vec::new(),
            license_type: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WindowsConfiguration {
    #[doc = "If omitted, the default value is true."]
    #[serde(rename = "enableAutomaticUpdates", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_updates: Option<bool>,
}
impl WindowsConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
