#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivateApplicationPackageParameters {
    pub format: String,
}
impl ActivateApplicationPackageParameters {
    pub fn new(format: String) -> Self {
        Self { format }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Application {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationProperties>,
}
impl Application {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationPackage {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationPackageProperties>,
}
impl ApplicationPackage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationPackageProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<application_package_properties::State>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<String>,
    #[serde(rename = "storageUrl", default, skip_serializing_if = "Option::is_none")]
    pub storage_url: Option<String>,
    #[serde(rename = "storageUrlExpiry", default, skip_serializing_if = "Option::is_none")]
    pub storage_url_expiry: Option<String>,
    #[serde(rename = "lastActivationTime", default, skip_serializing_if = "Option::is_none")]
    pub last_activation_time: Option<String>,
}
impl ApplicationPackageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_package_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Pending,
        Active,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationPackageReference {
    pub id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl ApplicationPackageReference {
    pub fn new(id: String) -> Self {
        Self { id, version: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "allowUpdates", default, skip_serializing_if = "Option::is_none")]
    pub allow_updates: Option<bool>,
    #[serde(rename = "defaultVersion", default, skip_serializing_if = "Option::is_none")]
    pub default_version: Option<String>,
}
impl ApplicationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoScaleRun {
    #[serde(rename = "evaluationTime")]
    pub evaluation_time: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub results: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<AutoScaleRunError>,
}
impl AutoScaleRun {
    pub fn new(evaluation_time: String) -> Self {
        Self {
            evaluation_time,
            results: None,
            error: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoScaleRunError {
    pub code: String,
    pub message: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<AutoScaleRunError>,
}
impl AutoScaleRunError {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoScaleSettings {
    pub formula: String,
    #[serde(rename = "evaluationInterval", default, skip_serializing_if = "Option::is_none")]
    pub evaluation_interval: Option<String>,
}
impl AutoScaleSettings {
    pub fn new(formula: String) -> Self {
        Self {
            formula,
            evaluation_interval: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoStorageBaseProperties {
    #[serde(rename = "storageAccountId")]
    pub storage_account_id: String,
}
impl AutoStorageBaseProperties {
    pub fn new(storage_account_id: String) -> Self {
        Self { storage_account_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoStorageProperties {
    #[serde(flatten)]
    pub auto_storage_base_properties: AutoStorageBaseProperties,
    #[serde(rename = "lastKeySync")]
    pub last_key_sync: String,
}
impl AutoStorageProperties {
    pub fn new(auto_storage_base_properties: AutoStorageBaseProperties, last_key_sync: String) -> Self {
        Self {
            auto_storage_base_properties,
            last_key_sync,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoUserSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<auto_user_specification::Scope>,
    #[serde(rename = "elevationLevel", default, skip_serializing_if = "Option::is_none")]
    pub elevation_level: Option<ElevationLevel>,
}
impl AutoUserSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod auto_user_specification {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Scope {
        Task,
        Pool,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFileSystemConfiguration {
    #[serde(rename = "accountName")]
    pub account_name: String,
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<String>,
    #[serde(rename = "sasKey", default, skip_serializing_if = "Option::is_none")]
    pub sas_key: Option<String>,
    #[serde(rename = "blobfuseOptions", default, skip_serializing_if = "Option::is_none")]
    pub blobfuse_options: Option<String>,
    #[serde(rename = "relativeMountPath")]
    pub relative_mount_path: String,
}
impl AzureBlobFileSystemConfiguration {
    pub fn new(account_name: String, container_name: String, relative_mount_path: String) -> Self {
        Self {
            account_name,
            container_name,
            account_key: None,
            sas_key: None,
            blobfuse_options: None,
            relative_mount_path,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareConfiguration {
    #[serde(rename = "accountName")]
    pub account_name: String,
    #[serde(rename = "azureFileUrl")]
    pub azure_file_url: String,
    #[serde(rename = "accountKey")]
    pub account_key: String,
    #[serde(rename = "relativeMountPath")]
    pub relative_mount_path: String,
    #[serde(rename = "mountOptions", default, skip_serializing_if = "Option::is_none")]
    pub mount_options: Option<String>,
}
impl AzureFileShareConfiguration {
    pub fn new(account_name: String, azure_file_url: String, account_key: String, relative_mount_path: String) -> Self {
        Self {
            account_name,
            azure_file_url,
            account_key,
            relative_mount_path,
            mount_options: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccount {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BatchAccountProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<BatchAccountIdentity>,
}
impl BatchAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BatchAccountCreateParameters {
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BatchAccountCreateProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<BatchAccountIdentity>,
}
impl BatchAccountCreateParameters {
    pub fn new(location: String) -> Self {
        Self {
            location,
            tags: None,
            properties: None,
            identity: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountCreateProperties {
    #[serde(rename = "autoStorage", default, skip_serializing_if = "Option::is_none")]
    pub auto_storage: Option<AutoStorageBaseProperties>,
    #[serde(rename = "poolAllocationMode", default, skip_serializing_if = "Option::is_none")]
    pub pool_allocation_mode: Option<PoolAllocationMode>,
    #[serde(rename = "keyVaultReference", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_reference: Option<KeyVaultReference>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<PublicNetworkAccessType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionProperties>,
}
impl BatchAccountCreateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BatchAccountIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type")]
    pub type_: batch_account_identity::Type,
}
impl BatchAccountIdentity {
    pub fn new(type_: batch_account_identity::Type) -> Self {
        Self {
            principal_id: None,
            tenant_id: None,
            type_,
        }
    }
}
pub mod batch_account_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountKeys {
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secondary: Option<String>,
}
impl BatchAccountKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BatchAccount>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BatchAccountListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountProperties {
    #[serde(rename = "accountEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub account_endpoint: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<batch_account_properties::ProvisioningState>,
    #[serde(rename = "poolAllocationMode", default, skip_serializing_if = "Option::is_none")]
    pub pool_allocation_mode: Option<PoolAllocationMode>,
    #[serde(rename = "keyVaultReference", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_reference: Option<KeyVaultReference>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<PublicNetworkAccessType>,
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[serde(rename = "autoStorage", default, skip_serializing_if = "Option::is_none")]
    pub auto_storage: Option<AutoStorageProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionProperties>,
    #[serde(rename = "dedicatedCoreQuota", default, skip_serializing_if = "Option::is_none")]
    pub dedicated_core_quota: Option<i32>,
    #[serde(rename = "lowPriorityCoreQuota", default, skip_serializing_if = "Option::is_none")]
    pub low_priority_core_quota: Option<i32>,
    #[serde(rename = "dedicatedCoreQuotaPerVMFamily", default, skip_serializing_if = "Vec::is_empty")]
    pub dedicated_core_quota_per_vm_family: Vec<VirtualMachineFamilyCoreQuota>,
    #[serde(rename = "dedicatedCoreQuotaPerVMFamilyEnforced", default, skip_serializing_if = "Option::is_none")]
    pub dedicated_core_quota_per_vm_family_enforced: Option<bool>,
    #[serde(rename = "poolQuota", default, skip_serializing_if = "Option::is_none")]
    pub pool_quota: Option<i32>,
    #[serde(rename = "activeJobAndJobScheduleQuota", default, skip_serializing_if = "Option::is_none")]
    pub active_job_and_job_schedule_quota: Option<i32>,
}
impl BatchAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod batch_account_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Invalid,
        Creating,
        Deleting,
        Succeeded,
        Failed,
        Cancelled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BatchAccountRegenerateKeyParameters {
    #[serde(rename = "keyName")]
    pub key_name: batch_account_regenerate_key_parameters::KeyName,
}
impl BatchAccountRegenerateKeyParameters {
    pub fn new(key_name: batch_account_regenerate_key_parameters::KeyName) -> Self {
        Self { key_name }
    }
}
pub mod batch_account_regenerate_key_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyName {
        Primary,
        Secondary,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BatchAccountUpdateProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<BatchAccountIdentity>,
}
impl BatchAccountUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchAccountUpdateProperties {
    #[serde(rename = "autoStorage", default, skip_serializing_if = "Option::is_none")]
    pub auto_storage: Option<AutoStorageBaseProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionProperties>,
}
impl BatchAccountUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchLocationQuota {
    #[serde(rename = "accountQuota", default, skip_serializing_if = "Option::is_none")]
    pub account_quota: Option<i32>,
}
impl BatchLocationQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CifsMountConfiguration {
    pub username: String,
    pub source: String,
    #[serde(rename = "relativeMountPath")]
    pub relative_mount_path: String,
    #[serde(rename = "mountOptions", default, skip_serializing_if = "Option::is_none")]
    pub mount_options: Option<String>,
    pub password: String,
}
impl CifsMountConfiguration {
    pub fn new(username: String, source: String, relative_mount_path: String, password: String) -> Self {
        Self {
            username,
            source,
            relative_mount_path,
            mount_options: None,
            password,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CachingType {
    None,
    ReadOnly,
    ReadWrite,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Certificate {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificateProperties>,
}
impl Certificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateBaseProperties {
    #[serde(rename = "thumbprintAlgorithm", default, skip_serializing_if = "Option::is_none")]
    pub thumbprint_algorithm: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<certificate_base_properties::Format>,
}
impl CertificateBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod certificate_base_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Format {
        Pfx,
        Cer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateCreateOrUpdateParameters {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificateCreateOrUpdateProperties>,
}
impl CertificateCreateOrUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateCreateOrUpdateProperties {
    #[serde(flatten)]
    pub certificate_base_properties: CertificateBaseProperties,
    pub data: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl CertificateCreateOrUpdateProperties {
    pub fn new(data: String) -> Self {
        Self {
            certificate_base_properties: CertificateBaseProperties::default(),
            data,
            password: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateProperties {
    #[serde(flatten)]
    pub certificate_base_properties: CertificateBaseProperties,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<certificate_properties::ProvisioningState>,
    #[serde(rename = "provisioningStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state_transition_time: Option<String>,
    #[serde(rename = "previousProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub previous_provisioning_state: Option<certificate_properties::PreviousProvisioningState>,
    #[serde(
        rename = "previousProvisioningStateTransitionTime",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub previous_provisioning_state_transition_time: Option<String>,
    #[serde(rename = "publicData", default, skip_serializing_if = "Option::is_none")]
    pub public_data: Option<String>,
    #[serde(rename = "deleteCertificateError", default, skip_serializing_if = "Option::is_none")]
    pub delete_certificate_error: Option<DeleteCertificateError>,
}
impl CertificateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod certificate_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Deleting,
        Failed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreviousProvisioningState {
        Succeeded,
        Deleting,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateReference {
    pub id: String,
    #[serde(rename = "storeLocation", default, skip_serializing_if = "Option::is_none")]
    pub store_location: Option<certificate_reference::StoreLocation>,
    #[serde(rename = "storeName", default, skip_serializing_if = "Option::is_none")]
    pub store_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub visibility: Vec<String>,
}
impl CertificateReference {
    pub fn new(id: String) -> Self {
        Self {
            id,
            store_location: None,
            store_name: None,
            visibility: Vec::new(),
        }
    }
}
pub mod certificate_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StoreLocation {
        CurrentUser,
        LocalMachine,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckNameAvailabilityParameters {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: check_name_availability_parameters::Type,
}
impl CheckNameAvailabilityParameters {
    pub fn new(name: String, type_: check_name_availability_parameters::Type) -> Self {
        Self { name, type_ }
    }
}
pub mod check_name_availability_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.Batch/batchAccounts")]
        MicrosoftBatchBatchAccounts,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckNameAvailabilityResult {
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<check_name_availability_result::Reason>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl CheckNameAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod check_name_availability_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudServiceConfiguration {
    #[serde(rename = "osFamily")]
    pub os_family: String,
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
}
impl CloudServiceConfiguration {
    pub fn new(os_family: String) -> Self {
        Self {
            os_family,
            os_version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ComputeNodeDeallocationOption {
    Requeue,
    Terminate,
    TaskCompletion,
    RetainedData,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerConfiguration {
    #[serde(rename = "type")]
    pub type_: container_configuration::Type,
    #[serde(rename = "containerImageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub container_image_names: Vec<String>,
    #[serde(rename = "containerRegistries", default, skip_serializing_if = "Vec::is_empty")]
    pub container_registries: Vec<ContainerRegistry>,
}
impl ContainerConfiguration {
    pub fn new(type_: container_configuration::Type) -> Self {
        Self {
            type_,
            container_image_names: Vec::new(),
            container_registries: Vec::new(),
        }
    }
}
pub mod container_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        DockerCompatible,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerRegistry {
    #[serde(rename = "registryServer", default, skip_serializing_if = "Option::is_none")]
    pub registry_server: Option<String>,
    pub username: String,
    pub password: String,
}
impl ContainerRegistry {
    pub fn new(username: String, password: String) -> Self {
        Self {
            registry_server: None,
            username,
            password,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataDisk {
    pub lun: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub caching: Option<CachingType>,
    #[serde(rename = "diskSizeGB")]
    pub disk_size_gb: i32,
    #[serde(rename = "storageAccountType", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_type: Option<StorageAccountType>,
}
impl DataDisk {
    pub fn new(lun: i32, disk_size_gb: i32) -> Self {
        Self {
            lun,
            caching: None,
            disk_size_gb,
            storage_account_type: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeleteCertificateError {
    pub code: String,
    pub message: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<DeleteCertificateError>,
}
impl DeleteCertificateError {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentConfiguration {
    #[serde(rename = "cloudServiceConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_configuration: Option<CloudServiceConfiguration>,
    #[serde(rename = "virtualMachineConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_configuration: Option<VirtualMachineConfiguration>,
}
impl DeploymentConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskEncryptionConfiguration {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub targets: Vec<String>,
}
impl DiskEncryptionConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ElevationLevel {
    NonAdmin,
    Admin,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionProperties {
    #[serde(rename = "keySource", default, skip_serializing_if = "Option::is_none")]
    pub key_source: Option<encryption_properties::KeySource>,
    #[serde(rename = "keyVaultProperties", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_properties: Option<KeyVaultProperties>,
}
impl EncryptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod encryption_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeySource {
        #[serde(rename = "Microsoft.Batch")]
        MicrosoftBatch,
        #[serde(rename = "Microsoft.KeyVault")]
        MicrosoftKeyVault,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentSetting {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl EnvironmentSetting {
    pub fn new(name: String) -> Self {
        Self { name, value: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FixedScaleSettings {
    #[serde(rename = "resizeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub resize_timeout: Option<String>,
    #[serde(rename = "targetDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_dedicated_nodes: Option<i32>,
    #[serde(rename = "targetLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_low_priority_nodes: Option<i32>,
    #[serde(rename = "nodeDeallocationOption", default, skip_serializing_if = "Option::is_none")]
    pub node_deallocation_option: Option<ComputeNodeDeallocationOption>,
}
impl FixedScaleSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpAddressProvisioningType {
    BatchManaged,
    UserManaged,
    #[serde(rename = "NoPublicIPAddresses")]
    NoPublicIpAddresses,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ImageReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundNatPool {
    pub name: String,
    pub protocol: inbound_nat_pool::Protocol,
    #[serde(rename = "backendPort")]
    pub backend_port: i32,
    #[serde(rename = "frontendPortRangeStart")]
    pub frontend_port_range_start: i32,
    #[serde(rename = "frontendPortRangeEnd")]
    pub frontend_port_range_end: i32,
    #[serde(rename = "networkSecurityGroupRules", default, skip_serializing_if = "Vec::is_empty")]
    pub network_security_group_rules: Vec<NetworkSecurityGroupRule>,
}
impl InboundNatPool {
    pub fn new(
        name: String,
        protocol: inbound_nat_pool::Protocol,
        backend_port: i32,
        frontend_port_range_start: i32,
        frontend_port_range_end: i32,
    ) -> Self {
        Self {
            name,
            protocol,
            backend_port,
            frontend_port_range_start,
            frontend_port_range_end,
            network_security_group_rules: Vec::new(),
        }
    }
}
pub mod inbound_nat_pool {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultProperties {
    #[serde(rename = "keyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub key_identifier: Option<String>,
}
impl KeyVaultProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct KeyVaultReference {
    pub id: String,
    pub url: String,
}
impl KeyVaultReference {
    pub fn new(id: String, url: String) -> Self {
        Self { id, url }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinuxUserConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uid: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub gid: Option<i32>,
    #[serde(rename = "sshPrivateKey", default, skip_serializing_if = "Option::is_none")]
    pub ssh_private_key: Option<String>,
}
impl LinuxUserConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListApplicationPackagesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationPackage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListApplicationPackagesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListApplicationsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Application>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListApplicationsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListCertificatesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Certificate>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListCertificatesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListPoolsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Pool>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListPoolsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListPrivateEndpointConnectionsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpointConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListPrivateEndpointConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListPrivateLinkResourcesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateLinkResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListPrivateLinkResourcesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataItem {
    pub name: String,
    pub value: String,
}
impl MetadataItem {
    pub fn new(name: String, value: String) -> Self {
        Self { name, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MountConfiguration {
    #[serde(rename = "azureBlobFileSystemConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub azure_blob_file_system_configuration: Option<AzureBlobFileSystemConfiguration>,
    #[serde(rename = "nfsMountConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub nfs_mount_configuration: Option<NfsMountConfiguration>,
    #[serde(rename = "cifsMountConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub cifs_mount_configuration: Option<CifsMountConfiguration>,
    #[serde(rename = "azureFileShareConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub azure_file_share_configuration: Option<AzureFileShareConfiguration>,
}
impl MountConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NfsMountConfiguration {
    pub source: String,
    #[serde(rename = "relativeMountPath")]
    pub relative_mount_path: String,
    #[serde(rename = "mountOptions", default, skip_serializing_if = "Option::is_none")]
    pub mount_options: Option<String>,
}
impl NfsMountConfiguration {
    pub fn new(source: String, relative_mount_path: String) -> Self {
        Self {
            source,
            relative_mount_path,
            mount_options: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkConfiguration {
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[serde(rename = "endpointConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_configuration: Option<PoolEndpointConfiguration>,
    #[serde(rename = "publicIPAddressConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_configuration: Option<PublicIpAddressConfiguration>,
}
impl NetworkConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkSecurityGroupRule {
    pub priority: i32,
    pub access: network_security_group_rule::Access,
    #[serde(rename = "sourceAddressPrefix")]
    pub source_address_prefix: String,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
}
impl NetworkSecurityGroupRule {
    pub fn new(priority: i32, access: network_security_group_rule::Access, source_address_prefix: String) -> Self {
        Self {
            priority,
            access,
            source_address_prefix,
            source_port_ranges: Vec::new(),
        }
    }
}
pub mod network_security_group_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Pool {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PoolProperties>,
}
impl Pool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PoolAllocationMode {
    BatchService,
    UserSubscription,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolEndpointConfiguration {
    #[serde(rename = "inboundNatPools")]
    pub inbound_nat_pools: Vec<InboundNatPool>,
}
impl PoolEndpointConfiguration {
    pub fn new(inbound_nat_pools: Vec<InboundNatPool>) -> Self {
        Self { inbound_nat_pools }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PoolProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<pool_properties::ProvisioningState>,
    #[serde(rename = "provisioningStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state_transition_time: Option<String>,
    #[serde(rename = "allocationState", default, skip_serializing_if = "Option::is_none")]
    pub allocation_state: Option<pool_properties::AllocationState>,
    #[serde(rename = "allocationStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub allocation_state_transition_time: Option<String>,
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<String>,
    #[serde(rename = "deploymentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub deployment_configuration: Option<DeploymentConfiguration>,
    #[serde(rename = "currentDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub current_dedicated_nodes: Option<i32>,
    #[serde(rename = "currentLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub current_low_priority_nodes: Option<i32>,
    #[serde(rename = "scaleSettings", default, skip_serializing_if = "Option::is_none")]
    pub scale_settings: Option<ScaleSettings>,
    #[serde(rename = "autoScaleRun", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_run: Option<AutoScaleRun>,
    #[serde(rename = "interNodeCommunication", default, skip_serializing_if = "Option::is_none")]
    pub inter_node_communication: Option<pool_properties::InterNodeCommunication>,
    #[serde(rename = "networkConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub network_configuration: Option<NetworkConfiguration>,
    #[serde(rename = "taskSlotsPerNode", default, skip_serializing_if = "Option::is_none")]
    pub task_slots_per_node: Option<i32>,
    #[serde(rename = "taskSchedulingPolicy", default, skip_serializing_if = "Option::is_none")]
    pub task_scheduling_policy: Option<TaskSchedulingPolicy>,
    #[serde(rename = "userAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub user_accounts: Vec<UserAccount>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
    #[serde(rename = "startTask", default, skip_serializing_if = "Option::is_none")]
    pub start_task: Option<StartTask>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub certificates: Vec<CertificateReference>,
    #[serde(rename = "applicationPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub application_packages: Vec<ApplicationPackageReference>,
    #[serde(rename = "applicationLicenses", default, skip_serializing_if = "Vec::is_empty")]
    pub application_licenses: Vec<String>,
    #[serde(rename = "resizeOperationStatus", default, skip_serializing_if = "Option::is_none")]
    pub resize_operation_status: Option<ResizeOperationStatus>,
    #[serde(rename = "mountConfiguration", default, skip_serializing_if = "Vec::is_empty")]
    pub mount_configuration: Vec<MountConfiguration>,
}
impl PoolProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pool_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Deleting,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AllocationState {
        Steady,
        Resizing,
        Stopping,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InterNodeCommunication {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnectionProperties>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<private_endpoint_connection_properties::ProvisioningState>,
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
}
impl PrivateEndpointConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod private_endpoint_connection_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Updating,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResource {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkResourceProperties>,
}
impl PrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceProperties {
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl PrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateLinkServiceConnectionState {
    pub status: PrivateLinkServiceConnectionStatus,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "actionRequired", default, skip_serializing_if = "Option::is_none")]
    pub action_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new(status: PrivateLinkServiceConnectionStatus) -> Self {
        Self {
            status,
            description: None,
            action_required: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PrivateLinkServiceConnectionStatus {
    Approved,
    Pending,
    Rejected,
    Disconnected,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provision: Option<IpAddressProvisioningType>,
    #[serde(rename = "ipAddressIds", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_address_ids: Vec<String>,
}
impl PublicIpAddressConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PublicNetworkAccessType {
    Enabled,
    Disabled,
}
impl Default for PublicNetworkAccessType {
    fn default() -> Self {
        Self::Enabled
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResizeError {
    pub code: String,
    pub message: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ResizeError>,
}
impl ResizeError {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResizeOperationStatus {
    #[serde(rename = "targetDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_dedicated_nodes: Option<i32>,
    #[serde(rename = "targetLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_low_priority_nodes: Option<i32>,
    #[serde(rename = "resizeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub resize_timeout: Option<String>,
    #[serde(rename = "nodeDeallocationOption", default, skip_serializing_if = "Option::is_none")]
    pub node_deallocation_option: Option<ComputeNodeDeallocationOption>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ResizeError>,
}
impl ResizeOperationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceFile {
    #[serde(rename = "autoStorageContainerName", default, skip_serializing_if = "Option::is_none")]
    pub auto_storage_container_name: Option<String>,
    #[serde(rename = "storageContainerUrl", default, skip_serializing_if = "Option::is_none")]
    pub storage_container_url: Option<String>,
    #[serde(rename = "httpUrl", default, skip_serializing_if = "Option::is_none")]
    pub http_url: Option<String>,
    #[serde(rename = "blobPrefix", default, skip_serializing_if = "Option::is_none")]
    pub blob_prefix: Option<String>,
    #[serde(rename = "filePath", default, skip_serializing_if = "Option::is_none")]
    pub file_path: Option<String>,
    #[serde(rename = "fileMode", default, skip_serializing_if = "Option::is_none")]
    pub file_mode: Option<String>,
}
impl ResourceFile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScaleSettings {
    #[serde(rename = "fixedScale", default, skip_serializing_if = "Option::is_none")]
    pub fixed_scale: Option<FixedScaleSettings>,
    #[serde(rename = "autoScale", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale: Option<AutoScaleSettings>,
}
impl ScaleSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StartTask {
    #[serde(rename = "commandLine", default, skip_serializing_if = "Option::is_none")]
    pub command_line: Option<String>,
    #[serde(rename = "resourceFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_files: Vec<ResourceFile>,
    #[serde(rename = "environmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_settings: Vec<EnvironmentSetting>,
    #[serde(rename = "userIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_identity: Option<UserIdentity>,
    #[serde(rename = "maxTaskRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_task_retry_count: Option<i32>,
    #[serde(rename = "waitForSuccess", default, skip_serializing_if = "Option::is_none")]
    pub wait_for_success: Option<bool>,
    #[serde(rename = "containerSettings", default, skip_serializing_if = "Option::is_none")]
    pub container_settings: Option<TaskContainerSettings>,
}
impl StartTask {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum StorageAccountType {
    #[serde(rename = "Standard_LRS")]
    StandardLrs,
    #[serde(rename = "Premium_LRS")]
    PremiumLrs,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskContainerSettings {
    #[serde(rename = "containerRunOptions", default, skip_serializing_if = "Option::is_none")]
    pub container_run_options: Option<String>,
    #[serde(rename = "imageName")]
    pub image_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registry: Option<ContainerRegistry>,
    #[serde(rename = "workingDirectory", default, skip_serializing_if = "Option::is_none")]
    pub working_directory: Option<task_container_settings::WorkingDirectory>,
}
impl TaskContainerSettings {
    pub fn new(image_name: String) -> Self {
        Self {
            container_run_options: None,
            image_name,
            registry: None,
            working_directory: None,
        }
    }
}
pub mod task_container_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkingDirectory {
        TaskWorkingDirectory,
        ContainerImageDefault,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskSchedulingPolicy {
    #[serde(rename = "nodeFillType")]
    pub node_fill_type: task_scheduling_policy::NodeFillType,
}
impl TaskSchedulingPolicy {
    pub fn new(node_fill_type: task_scheduling_policy::NodeFillType) -> Self {
        Self { node_fill_type }
    }
}
pub mod task_scheduling_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeFillType {
        Spread,
        Pack,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserAccount {
    pub name: String,
    pub password: String,
    #[serde(rename = "elevationLevel", default, skip_serializing_if = "Option::is_none")]
    pub elevation_level: Option<ElevationLevel>,
    #[serde(rename = "linuxUserConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_user_configuration: Option<LinuxUserConfiguration>,
    #[serde(rename = "windowsUserConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_user_configuration: Option<WindowsUserConfiguration>,
}
impl UserAccount {
    pub fn new(name: String, password: String) -> Self {
        Self {
            name,
            password,
            elevation_level: None,
            linux_user_configuration: None,
            windows_user_configuration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentity {
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(rename = "autoUser", default, skip_serializing_if = "Option::is_none")]
    pub auto_user: Option<AutoUserSpecification>,
}
impl UserIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineConfiguration {
    #[serde(rename = "imageReference")]
    pub image_reference: ImageReference,
    #[serde(rename = "nodeAgentSkuId")]
    pub node_agent_sku_id: String,
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<DataDisk>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "containerConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub container_configuration: Option<ContainerConfiguration>,
    #[serde(rename = "diskEncryptionConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_configuration: Option<DiskEncryptionConfiguration>,
}
impl VirtualMachineConfiguration {
    pub fn new(image_reference: ImageReference, node_agent_sku_id: String) -> Self {
        Self {
            image_reference,
            node_agent_sku_id,
            windows_configuration: None,
            data_disks: Vec::new(),
            license_type: None,
            container_configuration: None,
            disk_encryption_configuration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineFamilyCoreQuota {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "coreQuota", default, skip_serializing_if = "Option::is_none")]
    pub core_quota: Option<i32>,
}
impl VirtualMachineFamilyCoreQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WindowsConfiguration {
    #[serde(rename = "enableAutomaticUpdates", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_updates: Option<bool>,
}
impl WindowsConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WindowsUserConfiguration {
    #[serde(rename = "loginMode", default, skip_serializing_if = "Option::is_none")]
    pub login_mode: Option<windows_user_configuration::LoginMode>,
}
impl WindowsUserConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod windows_user_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoginMode {
        Batch,
        Interactive,
    }
}
