#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessInformationContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl AccessInformationContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessInformationUpdateParameterProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl AccessInformationUpdateParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessInformationUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AccessInformationUpdateParameterProperties>,
}
impl AccessInformationUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdditionalLocation {
    pub location: String,
    pub sku: ApiManagementServiceSkuProperties,
    #[serde(rename = "publicIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_addresses: Vec<String>,
    #[serde(rename = "privateIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub private_ip_addresses: Vec<String>,
    #[serde(rename = "virtualNetworkConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_configuration: Option<VirtualNetworkConfiguration>,
    #[serde(rename = "gatewayRegionalUrl", default, skip_serializing_if = "Option::is_none")]
    pub gateway_regional_url: Option<String>,
    #[serde(rename = "disableGateway", default, skip_serializing_if = "Option::is_none")]
    pub disable_gateway: Option<bool>,
}
impl AdditionalLocation {
    pub fn new(location: String, sku: ApiManagementServiceSkuProperties) -> Self {
        Self {
            location,
            sku,
            public_ip_addresses: Vec::new(),
            private_ip_addresses: Vec::new(),
            virtual_network_configuration: None,
            gateway_regional_url: None,
            disable_gateway: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApiContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApiCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApiContractProperties>,
}
impl ApiContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiContractProperties {
    #[serde(flatten)]
    pub api_entity_base_contract: ApiEntityBaseContract,
    #[serde(rename = "sourceApiId", default, skip_serializing_if = "Option::is_none")]
    pub source_api_id: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<String>,
    pub path: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<String>,
    #[serde(rename = "apiVersionSet", default, skip_serializing_if = "Option::is_none")]
    pub api_version_set: Option<ApiVersionSetContractDetails>,
}
impl ApiContractProperties {
    pub fn new(path: String) -> Self {
        Self {
            api_entity_base_contract: ApiEntityBaseContract::default(),
            source_api_id: None,
            display_name: None,
            service_url: None,
            path,
            protocols: Vec::new(),
            api_version_set: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiContractUpdateProperties {
    #[serde(flatten)]
    pub api_entity_base_contract: ApiEntityBaseContract,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<String>,
}
impl ApiContractUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiCreateOrUpdateParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApiCreateOrUpdateProperties>,
}
impl ApiCreateOrUpdateParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiCreateOrUpdateProperties {
    #[serde(flatten)]
    pub api_contract_properties: ApiContractProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<api_create_or_update_properties::Format>,
    #[serde(rename = "wsdlSelector", default, skip_serializing_if = "Option::is_none")]
    pub wsdl_selector: Option<api_create_or_update_properties::WsdlSelector>,
    #[serde(rename = "apiType", default, skip_serializing_if = "Option::is_none")]
    pub api_type: Option<api_create_or_update_properties::ApiType>,
}
impl ApiCreateOrUpdateProperties {
    pub fn new(api_contract_properties: ApiContractProperties) -> Self {
        Self {
            api_contract_properties,
            value: None,
            format: None,
            wsdl_selector: None,
            api_type: None,
        }
    }
}
pub mod api_create_or_update_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Format {
        #[serde(rename = "wadl-xml")]
        WadlXml,
        #[serde(rename = "wadl-link-json")]
        WadlLinkJson,
        #[serde(rename = "swagger-json")]
        SwaggerJson,
        #[serde(rename = "swagger-link-json")]
        SwaggerLinkJson,
        #[serde(rename = "wsdl")]
        Wsdl,
        #[serde(rename = "wsdl-link")]
        WsdlLink,
        #[serde(rename = "openapi")]
        Openapi,
        #[serde(rename = "openapi+json")]
        OpenapiJson,
        #[serde(rename = "openapi-link")]
        OpenapiLink,
        #[serde(rename = "openapi+json-link")]
        OpenapiJsonLink,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct WsdlSelector {
        #[serde(rename = "wsdlServiceName", default, skip_serializing_if = "Option::is_none")]
        pub wsdl_service_name: Option<String>,
        #[serde(rename = "wsdlEndpointName", default, skip_serializing_if = "Option::is_none")]
        pub wsdl_endpoint_name: Option<String>,
    }
    impl WsdlSelector {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ApiType {
        #[serde(rename = "http")]
        Http,
        #[serde(rename = "soap")]
        Soap,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiEntityBaseContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "authenticationSettings", default, skip_serializing_if = "Option::is_none")]
    pub authentication_settings: Option<AuthenticationSettingsContract>,
    #[serde(rename = "subscriptionKeyParameterNames", default, skip_serializing_if = "Option::is_none")]
    pub subscription_key_parameter_names: Option<SubscriptionKeyParameterNamesContract>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<api_entity_base_contract::Type>,
    #[serde(rename = "apiRevision", default, skip_serializing_if = "Option::is_none")]
    pub api_revision: Option<String>,
    #[serde(rename = "apiVersion", default, skip_serializing_if = "Option::is_none")]
    pub api_version: Option<String>,
    #[serde(rename = "isCurrent", default, skip_serializing_if = "Option::is_none")]
    pub is_current: Option<bool>,
    #[serde(rename = "isOnline", default, skip_serializing_if = "Option::is_none")]
    pub is_online: Option<bool>,
    #[serde(rename = "apiRevisionDescription", default, skip_serializing_if = "Option::is_none")]
    pub api_revision_description: Option<String>,
    #[serde(rename = "apiVersionDescription", default, skip_serializing_if = "Option::is_none")]
    pub api_version_description: Option<String>,
    #[serde(rename = "apiVersionSetId", default, skip_serializing_if = "Option::is_none")]
    pub api_version_set_id: Option<String>,
    #[serde(rename = "subscriptionRequired", default, skip_serializing_if = "Option::is_none")]
    pub subscription_required: Option<bool>,
}
impl ApiEntityBaseContract {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod api_entity_base_contract {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "http")]
        Http,
        #[serde(rename = "soap")]
        Soap,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiExportResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<api_export_result::Format>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<api_export_result::Value>,
}
impl ApiExportResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod api_export_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Format {
        #[serde(rename = "swagger-link-json")]
        SwaggerLinkJson,
        #[serde(rename = "wadl-link-json")]
        WadlLinkJson,
        #[serde(rename = "wsdl-link+xml")]
        WsdlLinkXml,
        #[serde(rename = "openapi-link")]
        OpenapiLink,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Value {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub link: Option<String>,
    }
    impl Value {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementServiceApplyNetworkConfigurationParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl ApiManagementServiceApplyNetworkConfigurationParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiManagementServiceBackupRestoreParameters {
    #[serde(rename = "storageAccount")]
    pub storage_account: String,
    #[serde(rename = "accessKey")]
    pub access_key: String,
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "backupName")]
    pub backup_name: String,
}
impl ApiManagementServiceBackupRestoreParameters {
    pub fn new(storage_account: String, access_key: String, container_name: String, backup_name: String) -> Self {
        Self {
            storage_account,
            access_key,
            container_name,
            backup_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementServiceBaseProperties {
    #[serde(rename = "notificationSenderEmail", default, skip_serializing_if = "Option::is_none")]
    pub notification_sender_email: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "targetProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub target_provisioning_state: Option<String>,
    #[serde(rename = "createdAtUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_at_utc: Option<String>,
    #[serde(rename = "gatewayUrl", default, skip_serializing_if = "Option::is_none")]
    pub gateway_url: Option<String>,
    #[serde(rename = "gatewayRegionalUrl", default, skip_serializing_if = "Option::is_none")]
    pub gateway_regional_url: Option<String>,
    #[serde(rename = "portalUrl", default, skip_serializing_if = "Option::is_none")]
    pub portal_url: Option<String>,
    #[serde(rename = "managementApiUrl", default, skip_serializing_if = "Option::is_none")]
    pub management_api_url: Option<String>,
    #[serde(rename = "scmUrl", default, skip_serializing_if = "Option::is_none")]
    pub scm_url: Option<String>,
    #[serde(rename = "developerPortalUrl", default, skip_serializing_if = "Option::is_none")]
    pub developer_portal_url: Option<String>,
    #[serde(rename = "hostnameConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub hostname_configurations: Vec<HostnameConfiguration>,
    #[serde(rename = "publicIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_addresses: Vec<String>,
    #[serde(rename = "privateIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub private_ip_addresses: Vec<String>,
    #[serde(rename = "virtualNetworkConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_configuration: Option<VirtualNetworkConfiguration>,
    #[serde(rename = "additionalLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_locations: Vec<AdditionalLocation>,
    #[serde(rename = "customProperties", default, skip_serializing_if = "Option::is_none")]
    pub custom_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub certificates: Vec<CertificateConfiguration>,
    #[serde(rename = "enableClientCertificate", default, skip_serializing_if = "Option::is_none")]
    pub enable_client_certificate: Option<bool>,
    #[serde(rename = "disableGateway", default, skip_serializing_if = "Option::is_none")]
    pub disable_gateway: Option<bool>,
    #[serde(rename = "virtualNetworkType", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_type: Option<api_management_service_base_properties::VirtualNetworkType>,
    #[serde(rename = "apiVersionConstraint", default, skip_serializing_if = "Option::is_none")]
    pub api_version_constraint: Option<ApiVersionConstraint>,
}
impl ApiManagementServiceBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod api_management_service_base_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VirtualNetworkType {
        None,
        External,
        Internal,
    }
    impl Default for VirtualNetworkType {
        fn default() -> Self {
            Self::None
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiManagementServiceCheckNameAvailabilityParameters {
    pub name: String,
}
impl ApiManagementServiceCheckNameAvailabilityParameters {
    pub fn new(name: String) -> Self {
        Self { name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementServiceGetSsoTokenResult {
    #[serde(rename = "redirectUri", default, skip_serializing_if = "Option::is_none")]
    pub redirect_uri: Option<String>,
}
impl ApiManagementServiceGetSsoTokenResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiManagementServiceIdentity {
    #[serde(rename = "type")]
    pub type_: api_management_service_identity::Type,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl ApiManagementServiceIdentity {
    pub fn new(type_: api_management_service_identity::Type) -> Self {
        Self {
            type_,
            principal_id: None,
            tenant_id: None,
            user_assigned_identities: None,
        }
    }
}
pub mod api_management_service_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiManagementServiceListResult {
    pub value: Vec<ApiManagementServiceResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApiManagementServiceListResult {
    pub fn new(value: Vec<ApiManagementServiceResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementServiceNameAvailabilityResult {
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<api_management_service_name_availability_result::Reason>,
}
impl ApiManagementServiceNameAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod api_management_service_name_availability_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Valid,
        Invalid,
        AlreadyExists,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiManagementServiceProperties {
    #[serde(flatten)]
    pub api_management_service_base_properties: ApiManagementServiceBaseProperties,
    #[serde(rename = "publisherEmail")]
    pub publisher_email: String,
    #[serde(rename = "publisherName")]
    pub publisher_name: String,
}
impl ApiManagementServiceProperties {
    pub fn new(publisher_email: String, publisher_name: String) -> Self {
        Self {
            api_management_service_base_properties: ApiManagementServiceBaseProperties::default(),
            publisher_email,
            publisher_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiManagementServiceResource {
    #[serde(flatten)]
    pub apim_resource: ApimResource,
    pub properties: ApiManagementServiceProperties,
    pub sku: ApiManagementServiceSkuProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ApiManagementServiceIdentity>,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApiManagementServiceResource {
    pub fn new(properties: ApiManagementServiceProperties, sku: ApiManagementServiceSkuProperties, location: String) -> Self {
        Self {
            apim_resource: ApimResource::default(),
            properties,
            sku,
            identity: None,
            location,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiManagementServiceSkuProperties {
    pub name: api_management_service_sku_properties::Name,
    pub capacity: i32,
}
impl ApiManagementServiceSkuProperties {
    pub fn new(name: api_management_service_sku_properties::Name, capacity: i32) -> Self {
        Self { name, capacity }
    }
}
pub mod api_management_service_sku_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Developer,
        Standard,
        Premium,
        Basic,
        Consumption,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementServiceUpdateParameters {
    #[serde(flatten)]
    pub apim_resource: ApimResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApiManagementServiceUpdateProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ApiManagementServiceSkuProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ApiManagementServiceIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApiManagementServiceUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementServiceUpdateProperties {
    #[serde(flatten)]
    pub api_management_service_base_properties: ApiManagementServiceBaseProperties,
    #[serde(rename = "publisherEmail", default, skip_serializing_if = "Option::is_none")]
    pub publisher_email: Option<String>,
    #[serde(rename = "publisherName", default, skip_serializing_if = "Option::is_none")]
    pub publisher_name: Option<String>,
}
impl ApiManagementServiceUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiReleaseCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApiReleaseContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApiReleaseCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiReleaseContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApiReleaseContractProperties>,
}
impl ApiReleaseContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiReleaseContractProperties {
    #[serde(rename = "apiId", default, skip_serializing_if = "Option::is_none")]
    pub api_id: Option<String>,
    #[serde(rename = "createdDateTime", default, skip_serializing_if = "Option::is_none")]
    pub created_date_time: Option<String>,
    #[serde(rename = "updatedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub updated_date_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
}
impl ApiReleaseContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiRevisionCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApiRevisionContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApiRevisionCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiRevisionContract {
    #[serde(rename = "apiId", default, skip_serializing_if = "Option::is_none")]
    pub api_id: Option<String>,
    #[serde(rename = "apiRevision", default, skip_serializing_if = "Option::is_none")]
    pub api_revision: Option<String>,
    #[serde(rename = "createdDateTime", default, skip_serializing_if = "Option::is_none")]
    pub created_date_time: Option<String>,
    #[serde(rename = "updatedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub updated_date_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "privateUrl", default, skip_serializing_if = "Option::is_none")]
    pub private_url: Option<String>,
    #[serde(rename = "isOnline", default, skip_serializing_if = "Option::is_none")]
    pub is_online: Option<bool>,
    #[serde(rename = "isCurrent", default, skip_serializing_if = "Option::is_none")]
    pub is_current: Option<bool>,
}
impl ApiRevisionContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiRevisionInfoContract {
    #[serde(rename = "sourceApiId", default, skip_serializing_if = "Option::is_none")]
    pub source_api_id: Option<String>,
    #[serde(rename = "apiVersionName", default, skip_serializing_if = "Option::is_none")]
    pub api_version_name: Option<String>,
    #[serde(rename = "apiRevisionDescription", default, skip_serializing_if = "Option::is_none")]
    pub api_revision_description: Option<String>,
    #[serde(rename = "apiVersionSet", default, skip_serializing_if = "Option::is_none")]
    pub api_version_set: Option<ApiVersionSetContractDetails>,
}
impl ApiRevisionInfoContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiTagResourceContractProperties {
    #[serde(flatten)]
    pub api_entity_base_contract: ApiEntityBaseContract,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<String>,
}
impl ApiTagResourceContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiUpdateContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApiContractUpdateProperties>,
}
impl ApiUpdateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiVersionConstraint {
    #[serde(rename = "minApiVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_api_version: Option<String>,
}
impl ApiVersionConstraint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiVersionSetCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApiVersionSetContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApiVersionSetCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiVersionSetContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApiVersionSetContractProperties>,
}
impl ApiVersionSetContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiVersionSetContractDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "versioningScheme", default, skip_serializing_if = "Option::is_none")]
    pub versioning_scheme: Option<api_version_set_contract_details::VersioningScheme>,
    #[serde(rename = "versionQueryName", default, skip_serializing_if = "Option::is_none")]
    pub version_query_name: Option<String>,
    #[serde(rename = "versionHeaderName", default, skip_serializing_if = "Option::is_none")]
    pub version_header_name: Option<String>,
}
impl ApiVersionSetContractDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod api_version_set_contract_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VersioningScheme {
        Segment,
        Query,
        Header,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiVersionSetContractProperties {
    #[serde(flatten)]
    pub api_version_set_entity_base: ApiVersionSetEntityBase,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(rename = "versioningScheme")]
    pub versioning_scheme: api_version_set_contract_properties::VersioningScheme,
}
impl ApiVersionSetContractProperties {
    pub fn new(display_name: String, versioning_scheme: api_version_set_contract_properties::VersioningScheme) -> Self {
        Self {
            api_version_set_entity_base: ApiVersionSetEntityBase::default(),
            display_name,
            versioning_scheme,
        }
    }
}
pub mod api_version_set_contract_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VersioningScheme {
        Segment,
        Query,
        Header,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiVersionSetEntityBase {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "versionQueryName", default, skip_serializing_if = "Option::is_none")]
    pub version_query_name: Option<String>,
    #[serde(rename = "versionHeaderName", default, skip_serializing_if = "Option::is_none")]
    pub version_header_name: Option<String>,
}
impl ApiVersionSetEntityBase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiVersionSetUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApiVersionSetUpdateParametersProperties>,
}
impl ApiVersionSetUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiVersionSetUpdateParametersProperties {
    #[serde(flatten)]
    pub api_version_set_entity_base: ApiVersionSetEntityBase,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "versioningScheme", default, skip_serializing_if = "Option::is_none")]
    pub versioning_scheme: Option<api_version_set_update_parameters_properties::VersioningScheme>,
}
impl ApiVersionSetUpdateParametersProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod api_version_set_update_parameters_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VersioningScheme {
        Segment,
        Query,
        Header,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApimResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ApimResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssociationContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<association_contract::Properties>,
}
impl AssociationContract {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod association_contract {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            #[serde(rename = "created")]
            Created,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthenticationSettingsContract {
    #[serde(rename = "oAuth2", default, skip_serializing_if = "Option::is_none")]
    pub o_auth2: Option<OAuth2AuthenticationSettingsContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub openid: Option<OpenIdAuthenticationSettingsContract>,
}
impl AuthenticationSettingsContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationServerCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AuthorizationServerContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AuthorizationServerCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationServerContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AuthorizationServerContractProperties>,
}
impl AuthorizationServerContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationServerContractBaseProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "authorizationMethods", default, skip_serializing_if = "Vec::is_empty")]
    pub authorization_methods: Vec<String>,
    #[serde(rename = "clientAuthenticationMethod", default, skip_serializing_if = "Vec::is_empty")]
    pub client_authentication_method: Vec<String>,
    #[serde(rename = "tokenBodyParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub token_body_parameters: Vec<TokenBodyParameterContract>,
    #[serde(rename = "tokenEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub token_endpoint: Option<String>,
    #[serde(rename = "supportState", default, skip_serializing_if = "Option::is_none")]
    pub support_state: Option<bool>,
    #[serde(rename = "defaultScope", default, skip_serializing_if = "Option::is_none")]
    pub default_scope: Option<String>,
    #[serde(rename = "bearerTokenSendingMethods", default, skip_serializing_if = "Vec::is_empty")]
    pub bearer_token_sending_methods: Vec<String>,
    #[serde(rename = "resourceOwnerUsername", default, skip_serializing_if = "Option::is_none")]
    pub resource_owner_username: Option<String>,
    #[serde(rename = "resourceOwnerPassword", default, skip_serializing_if = "Option::is_none")]
    pub resource_owner_password: Option<String>,
}
impl AuthorizationServerContractBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AuthorizationServerContractProperties {
    #[serde(flatten)]
    pub authorization_server_contract_base_properties: AuthorizationServerContractBaseProperties,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(rename = "clientRegistrationEndpoint")]
    pub client_registration_endpoint: String,
    #[serde(rename = "authorizationEndpoint")]
    pub authorization_endpoint: String,
    #[serde(rename = "grantTypes")]
    pub grant_types: Vec<String>,
    #[serde(rename = "clientId")]
    pub client_id: String,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
}
impl AuthorizationServerContractProperties {
    pub fn new(
        display_name: String,
        client_registration_endpoint: String,
        authorization_endpoint: String,
        grant_types: Vec<String>,
        client_id: String,
    ) -> Self {
        Self {
            authorization_server_contract_base_properties: AuthorizationServerContractBaseProperties::default(),
            display_name,
            client_registration_endpoint,
            authorization_endpoint,
            grant_types,
            client_id,
            client_secret: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationServerUpdateContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AuthorizationServerUpdateContractProperties>,
}
impl AuthorizationServerUpdateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationServerUpdateContractProperties {
    #[serde(flatten)]
    pub authorization_server_contract_base_properties: AuthorizationServerContractBaseProperties,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "clientRegistrationEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub client_registration_endpoint: Option<String>,
    #[serde(rename = "authorizationEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub authorization_endpoint: Option<String>,
    #[serde(rename = "grantTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub grant_types: Vec<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
}
impl AuthorizationServerUpdateContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackendAuthorizationHeaderCredentials {
    pub scheme: String,
    pub parameter: String,
}
impl BackendAuthorizationHeaderCredentials {
    pub fn new(scheme: String, parameter: String) -> Self {
        Self { scheme, parameter }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendBaseParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackendProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<BackendCredentialsContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub proxy: Option<BackendProxyContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tls: Option<BackendTlsProperties>,
}
impl BackendBaseParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackendContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BackendCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackendContractProperties>,
}
impl BackendContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackendContractProperties {
    #[serde(flatten)]
    pub backend_base_parameters: BackendBaseParameters,
    pub url: String,
    pub protocol: backend_contract_properties::Protocol,
}
impl BackendContractProperties {
    pub fn new(url: String, protocol: backend_contract_properties::Protocol) -> Self {
        Self {
            backend_base_parameters: BackendBaseParameters::default(),
            url,
            protocol,
        }
    }
}
pub mod backend_contract_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "http")]
        Http,
        #[serde(rename = "soap")]
        Soap,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendCredentialsContract {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub certificate: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub header: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<BackendAuthorizationHeaderCredentials>,
}
impl BackendCredentialsContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendProperties {
    #[serde(rename = "serviceFabricCluster", default, skip_serializing_if = "Option::is_none")]
    pub service_fabric_cluster: Option<BackendServiceFabricClusterProperties>,
}
impl BackendProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackendProxyContract {
    pub url: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl BackendProxyContract {
    pub fn new(url: String) -> Self {
        Self {
            url,
            username: None,
            password: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendReconnectContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackendReconnectProperties>,
}
impl BackendReconnectContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendReconnectProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub after: Option<String>,
}
impl BackendReconnectProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackendServiceFabricClusterProperties {
    #[serde(rename = "clientCertificatethumbprint")]
    pub client_certificatethumbprint: String,
    #[serde(rename = "maxPartitionResolutionRetries", default, skip_serializing_if = "Option::is_none")]
    pub max_partition_resolution_retries: Option<i32>,
    #[serde(rename = "managementEndpoints")]
    pub management_endpoints: Vec<String>,
    #[serde(rename = "serverCertificateThumbprints", default, skip_serializing_if = "Vec::is_empty")]
    pub server_certificate_thumbprints: Vec<String>,
    #[serde(rename = "serverX509Names", default, skip_serializing_if = "Vec::is_empty")]
    pub server_x509_names: Vec<X509CertificateName>,
}
impl BackendServiceFabricClusterProperties {
    pub fn new(client_certificatethumbprint: String, management_endpoints: Vec<String>) -> Self {
        Self {
            client_certificatethumbprint,
            max_partition_resolution_retries: None,
            management_endpoints,
            server_certificate_thumbprints: Vec::new(),
            server_x509_names: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendTlsProperties {
    #[serde(rename = "validateCertificateChain", default, skip_serializing_if = "Option::is_none")]
    pub validate_certificate_chain: Option<bool>,
    #[serde(rename = "validateCertificateName", default, skip_serializing_if = "Option::is_none")]
    pub validate_certificate_name: Option<bool>,
}
impl BackendTlsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendUpdateParameterProperties {
    #[serde(flatten)]
    pub backend_base_parameters: BackendBaseParameters,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<backend_update_parameter_properties::Protocol>,
}
impl BackendUpdateParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backend_update_parameter_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "http")]
        Http,
        #[serde(rename = "soap")]
        Soap,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackendUpdateParameterProperties>,
}
impl BackendUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum BearerTokenSendingMethodsContract {
    #[serde(rename = "authorizationHeader")]
    AuthorizationHeader,
    #[serde(rename = "query")]
    Query,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BodyDiagnosticSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub bytes: Option<i32>,
}
impl BodyDiagnosticSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CacheCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CacheContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CacheCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CacheContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CacheContractProperties>,
}
impl CacheContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CacheContractProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "connectionString")]
    pub connection_string: String,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl CacheContractProperties {
    pub fn new(connection_string: String) -> Self {
        Self {
            description: None,
            connection_string,
            resource_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CacheUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CacheUpdateProperties>,
}
impl CacheUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CacheUpdateProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl CacheUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CertificateContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CertificateCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateConfiguration {
    #[serde(rename = "encodedCertificate", default, skip_serializing_if = "Option::is_none")]
    pub encoded_certificate: Option<String>,
    #[serde(rename = "certificatePassword", default, skip_serializing_if = "Option::is_none")]
    pub certificate_password: Option<String>,
    #[serde(rename = "storeName")]
    pub store_name: certificate_configuration::StoreName,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<CertificateInformation>,
}
impl CertificateConfiguration {
    pub fn new(store_name: certificate_configuration::StoreName) -> Self {
        Self {
            encoded_certificate: None,
            certificate_password: None,
            store_name,
            certificate: None,
        }
    }
}
pub mod certificate_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StoreName {
        CertificateAuthority,
        Root,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificateContractProperties>,
}
impl CertificateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateContractProperties {
    pub subject: String,
    pub thumbprint: String,
    #[serde(rename = "expirationDate")]
    pub expiration_date: String,
}
impl CertificateContractProperties {
    pub fn new(subject: String, thumbprint: String, expiration_date: String) -> Self {
        Self {
            subject,
            thumbprint,
            expiration_date,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateCreateOrUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CertificateCreateOrUpdateProperties>,
}
impl CertificateCreateOrUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateCreateOrUpdateProperties {
    pub data: String,
    pub password: String,
}
impl CertificateCreateOrUpdateProperties {
    pub fn new(data: String, password: String) -> Self {
        Self { data, password }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateInformation {
    pub expiry: String,
    pub thumbprint: String,
    pub subject: String,
}
impl CertificateInformation {
    pub fn new(expiry: String, thumbprint: String, subject: String) -> Self {
        Self {
            expiry,
            thumbprint,
            subject,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientSecretContract {
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
}
impl ClientSecretContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivityStatusContract {
    pub name: String,
    pub status: connectivity_status_contract::Status,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
    #[serde(rename = "lastUpdated")]
    pub last_updated: String,
    #[serde(rename = "lastStatusChange")]
    pub last_status_change: String,
}
impl ConnectivityStatusContract {
    pub fn new(name: String, status: connectivity_status_contract::Status, last_updated: String, last_status_change: String) -> Self {
        Self {
            name,
            status,
            error: None,
            last_updated,
            last_status_change,
        }
    }
}
pub mod connectivity_status_contract {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "initializing")]
        Initializing,
        #[serde(rename = "success")]
        Success,
        #[serde(rename = "failure")]
        Failure,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentItemCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ContentItemContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ContentItemCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentItemContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContentItemContractProperties>,
}
impl ContentItemContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentItemContractProperties {}
impl ContentItemContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentTypeCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ContentTypeContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ContentTypeCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentTypeContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContentTypeContractProperties>,
}
impl ContentTypeContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentTypeContractProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl ContentTypeContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeployConfigurationParameterProperties {
    pub branch: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub force: Option<bool>,
}
impl DeployConfigurationParameterProperties {
    pub fn new(branch: String) -> Self {
        Self { branch, force: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeployConfigurationParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DeployConfigurationParameterProperties>,
}
impl DeployConfigurationParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DiagnosticContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiagnosticCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DiagnosticContractProperties>,
}
impl DiagnosticContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiagnosticContractProperties {
    #[serde(rename = "alwaysLog", default, skip_serializing_if = "Option::is_none")]
    pub always_log: Option<diagnostic_contract_properties::AlwaysLog>,
    #[serde(rename = "loggerId")]
    pub logger_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sampling: Option<SamplingSettings>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frontend: Option<PipelineDiagnosticSettings>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub backend: Option<PipelineDiagnosticSettings>,
    #[serde(rename = "logClientIp", default, skip_serializing_if = "Option::is_none")]
    pub log_client_ip: Option<bool>,
    #[serde(rename = "httpCorrelationProtocol", default, skip_serializing_if = "Option::is_none")]
    pub http_correlation_protocol: Option<diagnostic_contract_properties::HttpCorrelationProtocol>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verbosity: Option<diagnostic_contract_properties::Verbosity>,
}
impl DiagnosticContractProperties {
    pub fn new(logger_id: String) -> Self {
        Self {
            always_log: None,
            logger_id,
            sampling: None,
            frontend: None,
            backend: None,
            log_client_ip: None,
            http_correlation_protocol: None,
            verbosity: None,
        }
    }
}
pub mod diagnostic_contract_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AlwaysLog {
        #[serde(rename = "allErrors")]
        AllErrors,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HttpCorrelationProtocol {
        None,
        Legacy,
        #[serde(rename = "W3C")]
        W3c,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Verbosity {
        #[serde(rename = "verbose")]
        Verbose,
        #[serde(rename = "information")]
        Information,
        #[serde(rename = "error")]
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EmailTemplateCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EmailTemplateContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EmailTemplateCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EmailTemplateContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EmailTemplateContractProperties>,
}
impl EmailTemplateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EmailTemplateContractProperties {
    pub subject: String,
    pub body: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<EmailTemplateParametersContractProperties>,
}
impl EmailTemplateContractProperties {
    pub fn new(subject: String, body: String) -> Self {
        Self {
            subject,
            body,
            title: None,
            description: None,
            is_default: None,
            parameters: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EmailTemplateParametersContractProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl EmailTemplateParametersContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EmailTemplateUpdateParameterProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<EmailTemplateParametersContractProperties>,
}
impl EmailTemplateUpdateParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EmailTemplateUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EmailTemplateUpdateParameterProperties>,
}
impl EmailTemplateUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorFieldContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl ErrorFieldContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponseBody>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponseBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorFieldContract>,
}
impl ErrorResponseBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GatewayContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GatewayCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GatewayContractProperties>,
}
impl GatewayContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayContractProperties {
    #[serde(rename = "locationData", default, skip_serializing_if = "Option::is_none")]
    pub location_data: Option<ResourceLocationDataContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl GatewayContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayHostnameConfigurationCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GatewayHostnameConfigurationContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GatewayHostnameConfigurationCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayHostnameConfigurationContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GatewayHostnameConfigurationContractProperties>,
}
impl GatewayHostnameConfigurationContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayHostnameConfigurationContractProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
    #[serde(rename = "certificateId", default, skip_serializing_if = "Option::is_none")]
    pub certificate_id: Option<String>,
    #[serde(rename = "negotiateClientCertificate", default, skip_serializing_if = "Option::is_none")]
    pub negotiate_client_certificate: Option<bool>,
}
impl GatewayHostnameConfigurationContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GatewayKeyRegenerationRequestContract {
    #[serde(rename = "keyType")]
    pub key_type: gateway_key_regeneration_request_contract::KeyType,
}
impl GatewayKeyRegenerationRequestContract {
    pub fn new(key_type: gateway_key_regeneration_request_contract::KeyType) -> Self {
        Self { key_type }
    }
}
pub mod gateway_key_regeneration_request_contract {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyType {
        #[serde(rename = "primary")]
        Primary,
        #[serde(rename = "secondary")]
        Secondary,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayKeysContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secondary: Option<String>,
}
impl GatewayKeysContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayTokenContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl GatewayTokenContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GatewayTokenRequestContract {
    #[serde(rename = "keyType")]
    pub key_type: gateway_token_request_contract::KeyType,
    pub expiry: String,
}
impl GatewayTokenRequestContract {
    pub fn new(key_type: gateway_token_request_contract::KeyType, expiry: String) -> Self {
        Self { key_type, expiry }
    }
}
pub mod gateway_token_request_contract {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyType {
        #[serde(rename = "primary")]
        Primary,
        #[serde(rename = "secondary")]
        Secondary,
    }
    impl Default for KeyType {
        fn default() -> Self {
            Self::Primary
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenerateSsoUrlResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl GenerateSsoUrlResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GroupContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GroupCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GroupContractProperties>,
}
impl GroupContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GroupContractProperties {
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "builtIn", default, skip_serializing_if = "Option::is_none")]
    pub built_in: Option<bool>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<group_contract_properties::Type>,
    #[serde(rename = "externalId", default, skip_serializing_if = "Option::is_none")]
    pub external_id: Option<String>,
}
impl GroupContractProperties {
    pub fn new(display_name: String) -> Self {
        Self {
            display_name,
            description: None,
            built_in: None,
            type_: None,
            external_id: None,
        }
    }
}
pub mod group_contract_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "custom")]
        Custom,
        #[serde(rename = "system")]
        System,
        #[serde(rename = "external")]
        External,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupCreateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GroupCreateParametersProperties>,
}
impl GroupCreateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GroupCreateParametersProperties {
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<group_create_parameters_properties::Type>,
    #[serde(rename = "externalId", default, skip_serializing_if = "Option::is_none")]
    pub external_id: Option<String>,
}
impl GroupCreateParametersProperties {
    pub fn new(display_name: String) -> Self {
        Self {
            display_name,
            description: None,
            type_: None,
            external_id: None,
        }
    }
}
pub mod group_create_parameters_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "custom")]
        Custom,
        #[serde(rename = "system")]
        System,
        #[serde(rename = "external")]
        External,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GroupUpdateParametersProperties>,
}
impl GroupUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupUpdateParametersProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<group_update_parameters_properties::Type>,
    #[serde(rename = "externalId", default, skip_serializing_if = "Option::is_none")]
    pub external_id: Option<String>,
}
impl GroupUpdateParametersProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod group_update_parameters_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "custom")]
        Custom,
        #[serde(rename = "system")]
        System,
        #[serde(rename = "external")]
        External,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HostnameConfiguration {
    #[serde(rename = "type")]
    pub type_: hostname_configuration::Type,
    #[serde(rename = "hostName")]
    pub host_name: String,
    #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_id: Option<String>,
    #[serde(rename = "encodedCertificate", default, skip_serializing_if = "Option::is_none")]
    pub encoded_certificate: Option<String>,
    #[serde(rename = "certificatePassword", default, skip_serializing_if = "Option::is_none")]
    pub certificate_password: Option<String>,
    #[serde(rename = "defaultSslBinding", default, skip_serializing_if = "Option::is_none")]
    pub default_ssl_binding: Option<bool>,
    #[serde(rename = "negotiateClientCertificate", default, skip_serializing_if = "Option::is_none")]
    pub negotiate_client_certificate: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<CertificateInformation>,
}
impl HostnameConfiguration {
    pub fn new(type_: hostname_configuration::Type, host_name: String) -> Self {
        Self {
            type_,
            host_name,
            key_vault_id: None,
            encoded_certificate: None,
            certificate_password: None,
            default_ssl_binding: None,
            negotiate_client_certificate: None,
            certificate: None,
        }
    }
}
pub mod hostname_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Proxy,
        Portal,
        Management,
        Scm,
        DeveloperPortal,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpMessageDiagnostic {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub headers: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<BodyDiagnosticSettings>,
}
impl HttpMessageDiagnostic {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProviderBaseParameters {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity_provider_base_parameters::Type>,
    #[serde(rename = "signinTenant", default, skip_serializing_if = "Option::is_none")]
    pub signin_tenant: Option<String>,
    #[serde(rename = "allowedTenants", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_tenants: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authority: Option<String>,
    #[serde(rename = "signupPolicyName", default, skip_serializing_if = "Option::is_none")]
    pub signup_policy_name: Option<String>,
    #[serde(rename = "signinPolicyName", default, skip_serializing_if = "Option::is_none")]
    pub signin_policy_name: Option<String>,
    #[serde(rename = "profileEditingPolicyName", default, skip_serializing_if = "Option::is_none")]
    pub profile_editing_policy_name: Option<String>,
    #[serde(rename = "passwordResetPolicyName", default, skip_serializing_if = "Option::is_none")]
    pub password_reset_policy_name: Option<String>,
}
impl IdentityProviderBaseParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity_provider_base_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "facebook")]
        Facebook,
        #[serde(rename = "google")]
        Google,
        #[serde(rename = "microsoft")]
        Microsoft,
        #[serde(rename = "twitter")]
        Twitter,
        #[serde(rename = "aad")]
        Aad,
        #[serde(rename = "aadB2C")]
        AadB2c,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProviderContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IdentityProviderContractProperties>,
}
impl IdentityProviderContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IdentityProviderContractProperties {
    #[serde(flatten)]
    pub identity_provider_base_parameters: IdentityProviderBaseParameters,
    #[serde(rename = "clientId")]
    pub client_id: String,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
}
impl IdentityProviderContractProperties {
    pub fn new(client_id: String) -> Self {
        Self {
            identity_provider_base_parameters: IdentityProviderBaseParameters::default(),
            client_id,
            client_secret: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProviderCreateContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IdentityProviderCreateContractProperties>,
}
impl IdentityProviderCreateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IdentityProviderCreateContractProperties {
    #[serde(flatten)]
    pub identity_provider_base_parameters: IdentityProviderBaseParameters,
    #[serde(rename = "clientId")]
    pub client_id: String,
    #[serde(rename = "clientSecret")]
    pub client_secret: String,
}
impl IdentityProviderCreateContractProperties {
    pub fn new(client_id: String, client_secret: String) -> Self {
        Self {
            identity_provider_base_parameters: IdentityProviderBaseParameters::default(),
            client_id,
            client_secret,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProviderList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IdentityProviderContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IdentityProviderList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProviderUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IdentityProviderUpdateProperties>,
}
impl IdentityProviderUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProviderUpdateProperties {
    #[serde(flatten)]
    pub identity_provider_base_parameters: IdentityProviderBaseParameters,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
}
impl IdentityProviderUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueAttachmentCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IssueAttachmentContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IssueAttachmentCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueAttachmentContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IssueAttachmentContractProperties>,
}
impl IssueAttachmentContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IssueAttachmentContractProperties {
    pub title: String,
    #[serde(rename = "contentFormat")]
    pub content_format: String,
    pub content: String,
}
impl IssueAttachmentContractProperties {
    pub fn new(title: String, content_format: String, content: String) -> Self {
        Self {
            title,
            content_format,
            content,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IssueContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IssueCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueCommentCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IssueCommentContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IssueCommentCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueCommentContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IssueCommentContractProperties>,
}
impl IssueCommentContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IssueCommentContractProperties {
    pub text: String,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "userId")]
    pub user_id: String,
}
impl IssueCommentContractProperties {
    pub fn new(text: String, user_id: String) -> Self {
        Self {
            text,
            created_date: None,
            user_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IssueContractProperties>,
}
impl IssueContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueContractBaseProperties {
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<issue_contract_base_properties::State>,
    #[serde(rename = "apiId", default, skip_serializing_if = "Option::is_none")]
    pub api_id: Option<String>,
}
impl IssueContractBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod issue_contract_base_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "proposed")]
        Proposed,
        #[serde(rename = "open")]
        Open,
        #[serde(rename = "removed")]
        Removed,
        #[serde(rename = "resolved")]
        Resolved,
        #[serde(rename = "closed")]
        Closed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IssueContractProperties {
    #[serde(flatten)]
    pub issue_contract_base_properties: IssueContractBaseProperties,
    pub title: String,
    pub description: String,
    #[serde(rename = "userId")]
    pub user_id: String,
}
impl IssueContractProperties {
    pub fn new(title: String, description: String, user_id: String) -> Self {
        Self {
            issue_contract_base_properties: IssueContractBaseProperties::default(),
            title,
            description,
            user_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueUpdateContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IssueUpdateContractProperties>,
}
impl IssueUpdateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueUpdateContractProperties {
    #[serde(flatten)]
    pub issue_contract_base_properties: IssueContractBaseProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
}
impl IssueUpdateContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoggerCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoggerContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoggerCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoggerContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoggerContractProperties>,
}
impl LoggerContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LoggerContractProperties {
    #[serde(rename = "loggerType")]
    pub logger_type: logger_contract_properties::LoggerType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    pub credentials: serde_json::Value,
    #[serde(rename = "isBuffered", default, skip_serializing_if = "Option::is_none")]
    pub is_buffered: Option<bool>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl LoggerContractProperties {
    pub fn new(logger_type: logger_contract_properties::LoggerType, credentials: serde_json::Value) -> Self {
        Self {
            logger_type,
            description: None,
            credentials,
            is_buffered: None,
            resource_id: None,
        }
    }
}
pub mod logger_contract_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoggerType {
        #[serde(rename = "azureEventHub")]
        AzureEventHub,
        #[serde(rename = "applicationInsights")]
        ApplicationInsights,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoggerUpdateContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoggerUpdateParameters>,
}
impl LoggerUpdateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoggerUpdateParameters {
    #[serde(rename = "loggerType", default, skip_serializing_if = "Option::is_none")]
    pub logger_type: Option<logger_update_parameters::LoggerType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<serde_json::Value>,
    #[serde(rename = "isBuffered", default, skip_serializing_if = "Option::is_none")]
    pub is_buffered: Option<bool>,
}
impl LoggerUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod logger_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoggerType {
        #[serde(rename = "azureEventHub")]
        AzureEventHub,
        #[serde(rename = "applicationInsights")]
        ApplicationInsights,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NamedValueCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NamedValueContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NamedValueCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NamedValueContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NamedValueContractProperties>,
}
impl NamedValueContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NamedValueContractProperties {
    #[serde(flatten)]
    pub named_value_entity_base_parameters: NamedValueEntityBaseParameters,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl NamedValueContractProperties {
    pub fn new(display_name: String) -> Self {
        Self {
            named_value_entity_base_parameters: NamedValueEntityBaseParameters::default(),
            display_name,
            value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NamedValueCreateContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NamedValueCreateContractProperties>,
}
impl NamedValueCreateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NamedValueCreateContractProperties {
    #[serde(flatten)]
    pub named_value_entity_base_parameters: NamedValueEntityBaseParameters,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub value: String,
}
impl NamedValueCreateContractProperties {
    pub fn new(display_name: String, value: String) -> Self {
        Self {
            named_value_entity_base_parameters: NamedValueEntityBaseParameters::default(),
            display_name,
            value,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NamedValueEntityBaseParameters {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tags: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secret: Option<bool>,
}
impl NamedValueEntityBaseParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NamedValueUpdateParameterProperties {
    #[serde(flatten)]
    pub named_value_entity_base_parameters: NamedValueEntityBaseParameters,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl NamedValueUpdateParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NamedValueUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NamedValueUpdateParameterProperties>,
}
impl NamedValueUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkStatusContract {
    #[serde(rename = "dnsServers")]
    pub dns_servers: Vec<String>,
    #[serde(rename = "connectivityStatus")]
    pub connectivity_status: Vec<ConnectivityStatusContract>,
}
impl NetworkStatusContract {
    pub fn new(dns_servers: Vec<String>, connectivity_status: Vec<ConnectivityStatusContract>) -> Self {
        Self {
            dns_servers,
            connectivity_status,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkStatusContractByLocation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "networkStatus", default, skip_serializing_if = "Option::is_none")]
    pub network_status: Option<NetworkStatusContract>,
}
impl NetworkStatusContractByLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NotificationContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NotificationCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NotificationContractProperties>,
}
impl NotificationContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotificationContractProperties {
    pub title: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recipients: Option<RecipientsContractProperties>,
}
impl NotificationContractProperties {
    pub fn new(title: String) -> Self {
        Self {
            title,
            description: None,
            recipients: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OAuth2AuthenticationSettingsContract {
    #[serde(rename = "authorizationServerId", default, skip_serializing_if = "Option::is_none")]
    pub authorization_server_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
}
impl OAuth2AuthenticationSettingsContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OpenIdAuthenticationSettingsContract {
    #[serde(rename = "openidProviderId", default, skip_serializing_if = "Option::is_none")]
    pub openid_provider_id: Option<String>,
    #[serde(rename = "bearerTokenSendingMethods", default, skip_serializing_if = "Vec::is_empty")]
    pub bearer_token_sending_methods: Vec<BearerTokenSendingMethodsContract>,
}
impl OpenIdAuthenticationSettingsContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OpenIdConnectProviderCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OpenidConnectProviderContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OpenIdConnectProviderCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OpenidConnectProviderContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OpenidConnectProviderContractProperties>,
}
impl OpenidConnectProviderContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OpenidConnectProviderContractProperties {
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "metadataEndpoint")]
    pub metadata_endpoint: String,
    #[serde(rename = "clientId")]
    pub client_id: String,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
}
impl OpenidConnectProviderContractProperties {
    pub fn new(display_name: String, metadata_endpoint: String, client_id: String) -> Self {
        Self {
            display_name,
            description: None,
            metadata_endpoint,
            client_id,
            client_secret: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OpenidConnectProviderUpdateContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OpenidConnectProviderUpdateContractProperties>,
}
impl OpenidConnectProviderUpdateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OpenidConnectProviderUpdateContractProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "metadataEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub metadata_endpoint: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
}
impl OpenidConnectProviderUpdateContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OperationContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationContractProperties>,
}
impl OperationContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationContractProperties {
    #[serde(flatten)]
    pub operation_entity_base_contract: OperationEntityBaseContract,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub method: String,
    #[serde(rename = "urlTemplate")]
    pub url_template: String,
}
impl OperationContractProperties {
    pub fn new(display_name: String, method: String, url_template: String) -> Self {
        Self {
            operation_entity_base_contract: OperationEntityBaseContract::default(),
            display_name,
            method,
            url_template,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationEntityBaseContract {
    #[serde(rename = "templateParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub template_parameters: Vec<ParameterContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub request: Option<RequestContract>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub responses: Vec<ResponseContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub policies: Option<String>,
}
impl OperationEntityBaseContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResultContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<operation_result_contract::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub started: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "resultInfo", default, skip_serializing_if = "Option::is_none")]
    pub result_info: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponseBody>,
    #[serde(rename = "actionLog", default, skip_serializing_if = "Vec::is_empty")]
    pub action_log: Vec<OperationResultLogItemContract>,
}
impl OperationResultContract {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_result_contract {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Started,
        InProgress,
        Succeeded,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResultLogItemContract {
    #[serde(rename = "objectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
    #[serde(rename = "objectKey", default, skip_serializing_if = "Option::is_none")]
    pub object_key: Option<String>,
}
impl OperationResultLogItemContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationTagResourceContractProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "apiName", default, skip_serializing_if = "Option::is_none")]
    pub api_name: Option<String>,
    #[serde(rename = "apiRevision", default, skip_serializing_if = "Option::is_none")]
    pub api_revision: Option<String>,
    #[serde(rename = "apiVersion", default, skip_serializing_if = "Option::is_none")]
    pub api_version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[serde(rename = "urlTemplate", default, skip_serializing_if = "Option::is_none")]
    pub url_template: Option<String>,
}
impl OperationTagResourceContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationUpdateContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationUpdateContractProperties>,
}
impl OperationUpdateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationUpdateContractProperties {
    #[serde(flatten)]
    pub operation_entity_base_contract: OperationEntityBaseContract,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[serde(rename = "urlTemplate", default, skip_serializing_if = "Option::is_none")]
    pub url_template: Option<String>,
}
impl OperationUpdateContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParameterContract {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub required: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl ParameterContract {
    pub fn new(name: String, type_: String) -> Self {
        Self {
            name,
            description: None,
            type_,
            default_value: None,
            required: None,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PipelineDiagnosticSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub request: Option<HttpMessageDiagnostic>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub response: Option<HttpMessageDiagnostic>,
}
impl PipelineDiagnosticSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PolicyContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PolicyCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PolicyContractProperties>,
}
impl PolicyContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PolicyContractProperties {
    pub value: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<policy_contract_properties::Format>,
}
impl PolicyContractProperties {
    pub fn new(value: String) -> Self {
        Self { value, format: None }
    }
}
pub mod policy_contract_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Format {
        #[serde(rename = "xml")]
        Xml,
        #[serde(rename = "xml-link")]
        XmlLink,
        #[serde(rename = "rawxml")]
        Rawxml,
        #[serde(rename = "rawxml-link")]
        RawxmlLink,
    }
    impl Default for Format {
        fn default() -> Self {
            Self::Xml
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyDescriptionCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PolicyDescriptionContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl PolicyDescriptionCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyDescriptionContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PolicyDescriptionContractProperties>,
}
impl PolicyDescriptionContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyDescriptionContractProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<i64>,
}
impl PolicyDescriptionContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PortalDelegationSettings {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PortalDelegationSettingsProperties>,
}
impl PortalDelegationSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PortalDelegationSettingsProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "validationKey", default, skip_serializing_if = "Option::is_none")]
    pub validation_key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subscriptions: Option<SubscriptionsDelegationSettingsProperties>,
    #[serde(rename = "userRegistration", default, skip_serializing_if = "Option::is_none")]
    pub user_registration: Option<RegistrationDelegationSettingsProperties>,
}
impl PortalDelegationSettingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PortalSettingValidationKeyContract {
    #[serde(rename = "validationKey", default, skip_serializing_if = "Option::is_none")]
    pub validation_key: Option<String>,
}
impl PortalSettingValidationKeyContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PortalSigninSettingProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl PortalSigninSettingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PortalSigninSettings {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PortalSigninSettingProperties>,
}
impl PortalSigninSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PortalSignupSettings {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PortalSignupSettingsProperties>,
}
impl PortalSignupSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PortalSignupSettingsProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "termsOfService", default, skip_serializing_if = "Option::is_none")]
    pub terms_of_service: Option<TermsOfServiceProperties>,
}
impl PortalSignupSettingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProductCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProductContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProductCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProductContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProductContractProperties>,
}
impl ProductContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProductContractProperties {
    #[serde(flatten)]
    pub product_entity_base_parameters: ProductEntityBaseParameters,
    #[serde(rename = "displayName")]
    pub display_name: String,
}
impl ProductContractProperties {
    pub fn new(display_name: String) -> Self {
        Self {
            product_entity_base_parameters: ProductEntityBaseParameters::default(),
            display_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProductEntityBaseParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub terms: Option<String>,
    #[serde(rename = "subscriptionRequired", default, skip_serializing_if = "Option::is_none")]
    pub subscription_required: Option<bool>,
    #[serde(rename = "approvalRequired", default, skip_serializing_if = "Option::is_none")]
    pub approval_required: Option<bool>,
    #[serde(rename = "subscriptionsLimit", default, skip_serializing_if = "Option::is_none")]
    pub subscriptions_limit: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<product_entity_base_parameters::State>,
}
impl ProductEntityBaseParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod product_entity_base_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "notPublished")]
        NotPublished,
        #[serde(rename = "published")]
        Published,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProductTagResourceContractProperties {
    #[serde(flatten)]
    pub product_entity_base_parameters: ProductEntityBaseParameters,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    pub name: String,
}
impl ProductTagResourceContractProperties {
    pub fn new(name: String) -> Self {
        Self {
            product_entity_base_parameters: ProductEntityBaseParameters::default(),
            id: None,
            name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProductUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProductUpdateProperties>,
}
impl ProductUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProductUpdateProperties {
    #[serde(flatten)]
    pub product_entity_base_parameters: ProductEntityBaseParameters,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl ProductUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PropertyValueContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl PropertyValueContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaCounterCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<QuotaCounterContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl QuotaCounterCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuotaCounterContract {
    #[serde(rename = "counterKey")]
    pub counter_key: String,
    #[serde(rename = "periodKey")]
    pub period_key: String,
    #[serde(rename = "periodStartTime")]
    pub period_start_time: String,
    #[serde(rename = "periodEndTime")]
    pub period_end_time: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<QuotaCounterValueContractProperties>,
}
impl QuotaCounterContract {
    pub fn new(counter_key: String, period_key: String, period_start_time: String, period_end_time: String) -> Self {
        Self {
            counter_key,
            period_key,
            period_start_time,
            period_end_time,
            value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaCounterValueContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<QuotaCounterValueContractProperties>,
}
impl QuotaCounterValueContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaCounterValueContractProperties {
    #[serde(rename = "callsCount", default, skip_serializing_if = "Option::is_none")]
    pub calls_count: Option<i32>,
    #[serde(rename = "kbTransferred", default, skip_serializing_if = "Option::is_none")]
    pub kb_transferred: Option<f64>,
}
impl QuotaCounterValueContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaCounterValueUpdateContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<QuotaCounterValueContractProperties>,
}
impl QuotaCounterValueUpdateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientEmailCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecipientEmailContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecipientEmailCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientEmailContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecipientEmailContractProperties>,
}
impl RecipientEmailContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientEmailContractProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
}
impl RecipientEmailContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientUserCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecipientUserContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecipientUserCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientUserContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecipientUsersContractProperties>,
}
impl RecipientUserContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientUsersContractProperties {
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
}
impl RecipientUsersContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecipientsContractProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub emails: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub users: Vec<String>,
}
impl RecipientsContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegionContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "isMasterRegion", default, skip_serializing_if = "Option::is_none")]
    pub is_master_region: Option<bool>,
    #[serde(rename = "isDeleted", default, skip_serializing_if = "Option::is_none")]
    pub is_deleted: Option<bool>,
}
impl RegionContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RegionContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RegionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistrationDelegationSettingsProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl RegistrationDelegationSettingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReportCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReportRecordContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ReportCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReportRecordContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub zip: Option<String>,
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
    #[serde(rename = "productId", default, skip_serializing_if = "Option::is_none")]
    pub product_id: Option<String>,
    #[serde(rename = "apiId", default, skip_serializing_if = "Option::is_none")]
    pub api_id: Option<String>,
    #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
    pub operation_id: Option<String>,
    #[serde(rename = "apiRegion", default, skip_serializing_if = "Option::is_none")]
    pub api_region: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "callCountSuccess", default, skip_serializing_if = "Option::is_none")]
    pub call_count_success: Option<i32>,
    #[serde(rename = "callCountBlocked", default, skip_serializing_if = "Option::is_none")]
    pub call_count_blocked: Option<i32>,
    #[serde(rename = "callCountFailed", default, skip_serializing_if = "Option::is_none")]
    pub call_count_failed: Option<i32>,
    #[serde(rename = "callCountOther", default, skip_serializing_if = "Option::is_none")]
    pub call_count_other: Option<i32>,
    #[serde(rename = "callCountTotal", default, skip_serializing_if = "Option::is_none")]
    pub call_count_total: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub bandwidth: Option<i64>,
    #[serde(rename = "cacheHitCount", default, skip_serializing_if = "Option::is_none")]
    pub cache_hit_count: Option<i32>,
    #[serde(rename = "cacheMissCount", default, skip_serializing_if = "Option::is_none")]
    pub cache_miss_count: Option<i32>,
    #[serde(rename = "apiTimeAvg", default, skip_serializing_if = "Option::is_none")]
    pub api_time_avg: Option<f64>,
    #[serde(rename = "apiTimeMin", default, skip_serializing_if = "Option::is_none")]
    pub api_time_min: Option<f64>,
    #[serde(rename = "apiTimeMax", default, skip_serializing_if = "Option::is_none")]
    pub api_time_max: Option<f64>,
    #[serde(rename = "serviceTimeAvg", default, skip_serializing_if = "Option::is_none")]
    pub service_time_avg: Option<f64>,
    #[serde(rename = "serviceTimeMin", default, skip_serializing_if = "Option::is_none")]
    pub service_time_min: Option<f64>,
    #[serde(rename = "serviceTimeMax", default, skip_serializing_if = "Option::is_none")]
    pub service_time_max: Option<f64>,
}
impl ReportRecordContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RepresentationContract {
    #[serde(rename = "contentType")]
    pub content_type: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sample: Option<String>,
    #[serde(rename = "schemaId", default, skip_serializing_if = "Option::is_none")]
    pub schema_id: Option<String>,
    #[serde(rename = "typeName", default, skip_serializing_if = "Option::is_none")]
    pub type_name: Option<String>,
    #[serde(rename = "formParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub form_parameters: Vec<ParameterContract>,
}
impl RepresentationContract {
    pub fn new(content_type: String) -> Self {
        Self {
            content_type,
            sample: None,
            schema_id: None,
            type_name: None,
            form_parameters: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "queryParameters", default, skip_serializing_if = "Vec::is_empty")]
    pub query_parameters: Vec<ParameterContract>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub headers: Vec<ParameterContract>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub representations: Vec<RepresentationContract>,
}
impl RequestContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestReportCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RequestReportRecordContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl RequestReportCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestReportRecordContract {
    #[serde(rename = "apiId", default, skip_serializing_if = "Option::is_none")]
    pub api_id: Option<String>,
    #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
    pub operation_id: Option<String>,
    #[serde(rename = "productId", default, skip_serializing_if = "Option::is_none")]
    pub product_id: Option<String>,
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "backendResponseCode", default, skip_serializing_if = "Option::is_none")]
    pub backend_response_code: Option<String>,
    #[serde(rename = "responseCode", default, skip_serializing_if = "Option::is_none")]
    pub response_code: Option<i32>,
    #[serde(rename = "responseSize", default, skip_serializing_if = "Option::is_none")]
    pub response_size: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cache: Option<String>,
    #[serde(rename = "apiTime", default, skip_serializing_if = "Option::is_none")]
    pub api_time: Option<f64>,
    #[serde(rename = "serviceTime", default, skip_serializing_if = "Option::is_none")]
    pub service_time: Option<f64>,
    #[serde(rename = "apiRegion", default, skip_serializing_if = "Option::is_none")]
    pub api_region: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(rename = "requestSize", default, skip_serializing_if = "Option::is_none")]
    pub request_size: Option<i32>,
}
impl RequestReportRecordContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceLocationDataContract {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub district: Option<String>,
    #[serde(rename = "countryOrRegion", default, skip_serializing_if = "Option::is_none")]
    pub country_or_region: Option<String>,
}
impl ResourceLocationDataContract {
    pub fn new(name: String) -> Self {
        Self {
            name,
            city: None,
            district: None,
            country_or_region: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<resource_sku::Name>,
}
impl ResourceSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Developer,
        Standard,
        Premium,
        Basic,
        Consumption,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSkuCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<i32>,
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<resource_sku_capacity::ScaleType>,
}
impl ResourceSkuCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_sku_capacity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScaleType {
        #[serde(rename = "automatic")]
        Automatic,
        #[serde(rename = "manual")]
        Manual,
        #[serde(rename = "none")]
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSkuResult {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ResourceSku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<ResourceSkuCapacity>,
}
impl ResourceSkuResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceSkuResults {
    pub value: Vec<ResourceSkuResult>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceSkuResults {
    pub fn new(value: Vec<ResourceSkuResult>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponseContract {
    #[serde(rename = "statusCode")]
    pub status_code: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub representations: Vec<RepresentationContract>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub headers: Vec<ParameterContract>,
}
impl ResponseContract {
    pub fn new(status_code: i32) -> Self {
        Self {
            status_code,
            description: None,
            representations: Vec::new(),
            headers: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SamplingSettings {
    #[serde(rename = "samplingType", default, skip_serializing_if = "Option::is_none")]
    pub sampling_type: Option<sampling_settings::SamplingType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub percentage: Option<f64>,
}
impl SamplingSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sampling_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SamplingType {
        #[serde(rename = "fixed")]
        Fixed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SaveConfigurationParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SaveConfigurationParameterProperties>,
}
impl SaveConfigurationParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SaveConfigurationParameterProperties {
    pub branch: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub force: Option<bool>,
}
impl SaveConfigurationParameterProperties {
    pub fn new(branch: String) -> Self {
        Self { branch, force: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SchemaCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SchemaContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SchemaCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SchemaContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SchemaContractProperties>,
}
impl SchemaContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SchemaContractProperties {
    #[serde(rename = "contentType")]
    pub content_type: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub document: Option<SchemaDocumentProperties>,
}
impl SchemaContractProperties {
    pub fn new(content_type: String) -> Self {
        Self {
            content_type,
            document: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SchemaDocumentProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definitions: Option<serde_json::Value>,
}
impl SchemaDocumentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SubscriptionContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SubscriptionCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubscriptionContractProperties>,
}
impl SubscriptionContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SubscriptionContractProperties {
    #[serde(rename = "ownerId", default, skip_serializing_if = "Option::is_none")]
    pub owner_id: Option<String>,
    pub scope: String,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub state: subscription_contract_properties::State,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "startDate", default, skip_serializing_if = "Option::is_none")]
    pub start_date: Option<String>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(rename = "endDate", default, skip_serializing_if = "Option::is_none")]
    pub end_date: Option<String>,
    #[serde(rename = "notificationDate", default, skip_serializing_if = "Option::is_none")]
    pub notification_date: Option<String>,
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
    #[serde(rename = "stateComment", default, skip_serializing_if = "Option::is_none")]
    pub state_comment: Option<String>,
    #[serde(rename = "allowTracing", default, skip_serializing_if = "Option::is_none")]
    pub allow_tracing: Option<bool>,
}
impl SubscriptionContractProperties {
    pub fn new(scope: String, state: subscription_contract_properties::State) -> Self {
        Self {
            owner_id: None,
            scope,
            display_name: None,
            state,
            created_date: None,
            start_date: None,
            expiration_date: None,
            end_date: None,
            notification_date: None,
            primary_key: None,
            secondary_key: None,
            state_comment: None,
            allow_tracing: None,
        }
    }
}
pub mod subscription_contract_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "suspended")]
        Suspended,
        #[serde(rename = "active")]
        Active,
        #[serde(rename = "expired")]
        Expired,
        #[serde(rename = "submitted")]
        Submitted,
        #[serde(rename = "rejected")]
        Rejected,
        #[serde(rename = "cancelled")]
        Cancelled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SubscriptionCreateParameterProperties {
    #[serde(rename = "ownerId", default, skip_serializing_if = "Option::is_none")]
    pub owner_id: Option<String>,
    pub scope: String,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<subscription_create_parameter_properties::State>,
    #[serde(rename = "allowTracing", default, skip_serializing_if = "Option::is_none")]
    pub allow_tracing: Option<bool>,
}
impl SubscriptionCreateParameterProperties {
    pub fn new(scope: String, display_name: String) -> Self {
        Self {
            owner_id: None,
            scope,
            display_name,
            primary_key: None,
            secondary_key: None,
            state: None,
            allow_tracing: None,
        }
    }
}
pub mod subscription_create_parameter_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "suspended")]
        Suspended,
        #[serde(rename = "active")]
        Active,
        #[serde(rename = "expired")]
        Expired,
        #[serde(rename = "submitted")]
        Submitted,
        #[serde(rename = "rejected")]
        Rejected,
        #[serde(rename = "cancelled")]
        Cancelled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionCreateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubscriptionCreateParameterProperties>,
}
impl SubscriptionCreateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionKeyParameterNamesContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub header: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
}
impl SubscriptionKeyParameterNamesContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionKeysContract {
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
}
impl SubscriptionKeysContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionUpdateParameterProperties {
    #[serde(rename = "ownerId", default, skip_serializing_if = "Option::is_none")]
    pub owner_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<subscription_update_parameter_properties::State>,
    #[serde(rename = "stateComment", default, skip_serializing_if = "Option::is_none")]
    pub state_comment: Option<String>,
    #[serde(rename = "allowTracing", default, skip_serializing_if = "Option::is_none")]
    pub allow_tracing: Option<bool>,
}
impl SubscriptionUpdateParameterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod subscription_update_parameter_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "suspended")]
        Suspended,
        #[serde(rename = "active")]
        Active,
        #[serde(rename = "expired")]
        Expired,
        #[serde(rename = "submitted")]
        Submitted,
        #[serde(rename = "rejected")]
        Rejected,
        #[serde(rename = "cancelled")]
        Cancelled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubscriptionUpdateParameterProperties>,
}
impl SubscriptionUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionsDelegationSettingsProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl SubscriptionsDelegationSettingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TagContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TagCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TagContractProperties>,
}
impl TagContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TagContractProperties {
    #[serde(rename = "displayName")]
    pub display_name: String,
}
impl TagContractProperties {
    pub fn new(display_name: String) -> Self {
        Self { display_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagCreateUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TagContractProperties>,
}
impl TagCreateUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagDescriptionBaseProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "externalDocsUrl", default, skip_serializing_if = "Option::is_none")]
    pub external_docs_url: Option<String>,
    #[serde(rename = "externalDocsDescription", default, skip_serializing_if = "Option::is_none")]
    pub external_docs_description: Option<String>,
}
impl TagDescriptionBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagDescriptionCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TagDescriptionContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TagDescriptionCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagDescriptionContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TagDescriptionContractProperties>,
}
impl TagDescriptionContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagDescriptionContractProperties {
    #[serde(flatten)]
    pub tag_description_base_properties: TagDescriptionBaseProperties,
    #[serde(rename = "tagId", default, skip_serializing_if = "Option::is_none")]
    pub tag_id: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl TagDescriptionContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagDescriptionCreateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TagDescriptionBaseProperties>,
}
impl TagDescriptionCreateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagResourceCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TagResourceContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TagResourceCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TagResourceContract {
    pub tag: TagTagResourceContractProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub api: Option<ApiTagResourceContractProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<OperationTagResourceContractProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub product: Option<ProductTagResourceContractProperties>,
}
impl TagResourceContract {
    pub fn new(tag: TagTagResourceContractProperties) -> Self {
        Self {
            tag,
            api: None,
            operation: None,
            product: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagTagResourceContractProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl TagTagResourceContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TenantConfigurationSyncStateContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[serde(rename = "commitId", default, skip_serializing_if = "Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(rename = "isExport", default, skip_serializing_if = "Option::is_none")]
    pub is_export: Option<bool>,
    #[serde(rename = "isSynced", default, skip_serializing_if = "Option::is_none")]
    pub is_synced: Option<bool>,
    #[serde(rename = "isGitEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_git_enabled: Option<bool>,
    #[serde(rename = "syncDate", default, skip_serializing_if = "Option::is_none")]
    pub sync_date: Option<String>,
    #[serde(rename = "configurationChangeDate", default, skip_serializing_if = "Option::is_none")]
    pub configuration_change_date: Option<String>,
}
impl TenantConfigurationSyncStateContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TermsOfServiceProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub text: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "consentRequired", default, skip_serializing_if = "Option::is_none")]
    pub consent_required: Option<bool>,
}
impl TermsOfServiceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TokenBodyParameterContract {
    pub name: String,
    pub value: String,
}
impl TokenBodyParameterContract {
    pub fn new(name: String, value: String) -> Self {
        Self { name, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<UserContract>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UserCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserContract {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserContractProperties>,
}
impl UserContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserContractProperties {
    #[serde(flatten)]
    pub user_entity_base_parameters: UserEntityBaseParameters,
    #[serde(rename = "firstName", default, skip_serializing_if = "Option::is_none")]
    pub first_name: Option<String>,
    #[serde(rename = "lastName", default, skip_serializing_if = "Option::is_none")]
    pub last_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(rename = "registrationDate", default, skip_serializing_if = "Option::is_none")]
    pub registration_date: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groups: Vec<GroupContractProperties>,
}
impl UserContractProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserCreateParameterProperties {
    #[serde(flatten)]
    pub user_entity_base_parameters: UserEntityBaseParameters,
    pub email: String,
    #[serde(rename = "firstName")]
    pub first_name: String,
    #[serde(rename = "lastName")]
    pub last_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "appType", default, skip_serializing_if = "Option::is_none")]
    pub app_type: Option<user_create_parameter_properties::AppType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub confirmation: Option<user_create_parameter_properties::Confirmation>,
}
impl UserCreateParameterProperties {
    pub fn new(email: String, first_name: String, last_name: String) -> Self {
        Self {
            user_entity_base_parameters: UserEntityBaseParameters::default(),
            email,
            first_name,
            last_name,
            password: None,
            app_type: None,
            confirmation: None,
        }
    }
}
pub mod user_create_parameter_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AppType {
        #[serde(rename = "portal")]
        Portal,
        #[serde(rename = "developerPortal")]
        DeveloperPortal,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Confirmation {
        #[serde(rename = "signup")]
        Signup,
        #[serde(rename = "invite")]
        Invite,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserCreateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserCreateParameterProperties>,
}
impl UserCreateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserEntityBaseParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<user_entity_base_parameters::State>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub note: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub identities: Vec<UserIdentityContract>,
}
impl UserEntityBaseParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod user_entity_base_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "active")]
        Active,
        #[serde(rename = "blocked")]
        Blocked,
        #[serde(rename = "pending")]
        Pending,
        #[serde(rename = "deleted")]
        Deleted,
    }
    impl Default for State {
        fn default() -> Self {
            Self::Active
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentityCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<UserIdentityContract>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UserIdentityCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentityContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl UserIdentityContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentityProperties {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
}
impl UserIdentityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserTokenParameterProperties {
    #[serde(rename = "keyType")]
    pub key_type: user_token_parameter_properties::KeyType,
    pub expiry: String,
}
impl UserTokenParameterProperties {
    pub fn new(key_type: user_token_parameter_properties::KeyType, expiry: String) -> Self {
        Self { key_type, expiry }
    }
}
pub mod user_token_parameter_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyType {
        #[serde(rename = "primary")]
        Primary,
        #[serde(rename = "secondary")]
        Secondary,
    }
    impl Default for KeyType {
        fn default() -> Self {
            Self::Primary
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserTokenParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserTokenParameterProperties>,
}
impl UserTokenParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserTokenResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl UserTokenResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserUpdateParametersProperties>,
}
impl UserUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserUpdateParametersProperties {
    #[serde(flatten)]
    pub user_entity_base_parameters: UserEntityBaseParameters,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "firstName", default, skip_serializing_if = "Option::is_none")]
    pub first_name: Option<String>,
    #[serde(rename = "lastName", default, skip_serializing_if = "Option::is_none")]
    pub last_name: Option<String>,
}
impl UserUpdateParametersProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vnetid: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnetname: Option<String>,
    #[serde(rename = "subnetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_resource_id: Option<String>,
}
impl VirtualNetworkConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct X509CertificateName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "issuerCertificateThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub issuer_certificate_thumbprint: Option<String>,
}
impl X509CertificateName {
    pub fn new() -> Self {
        Self::default()
    }
}
