#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The Action Groups information, used by the alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionGroupsInformation {
    #[doc = "An optional custom email subject to use in email notifications."]
    #[serde(rename = "customEmailSubject", default, skip_serializing_if = "Option::is_none")]
    pub custom_email_subject: Option<String>,
    #[doc = "An optional custom web-hook payload to use in web-hook notifications."]
    #[serde(rename = "customWebhookPayload", default, skip_serializing_if = "Option::is_none")]
    pub custom_webhook_payload: Option<String>,
    #[doc = "The Action Group resource IDs."]
    #[serde(rename = "groupIds")]
    pub group_ids: Vec<String>,
}
impl ActionGroupsInformation {
    pub fn new(group_ids: Vec<String>) -> Self {
        Self {
            custom_email_subject: None,
            custom_webhook_payload: None,
            group_ids,
        }
    }
}
#[doc = "The alert rule information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRule {
    #[serde(flatten)]
    pub azure_resource: AzureResource,
    #[doc = "The alert rule properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertRuleProperties>,
}
impl AlertRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The alert rule patch information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRulePatchObject {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The alert rule properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertRulePatchProperties>,
}
impl AlertRulePatchObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The alert rule properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRulePatchProperties {
    #[doc = "The alert rule description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The alert rule state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<alert_rule_patch_properties::State>,
    #[doc = "The alert rule severity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<alert_rule_patch_properties::Severity>,
    #[doc = "The alert rule frequency in ISO8601 format. The time granularity must be in minutes and minimum value is 5 minutes."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<String>,
    #[doc = "The Action Groups information, used by the alert rule."]
    #[serde(rename = "actionGroups", default, skip_serializing_if = "Option::is_none")]
    pub action_groups: Option<ActionGroupsInformation>,
    #[doc = "Optional throttling information for the alert rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub throttling: Option<ThrottlingInformation>,
}
impl AlertRulePatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_rule_patch_properties {
    use super::*;
    #[doc = "The alert rule state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
    #[doc = "The alert rule severity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Sev0,
        Sev1,
        Sev2,
        Sev3,
        Sev4,
    }
}
#[doc = "The alert rule properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleProperties {
    #[doc = "The alert rule description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The alert rule state."]
    pub state: alert_rule_properties::State,
    #[doc = "The alert rule severity."]
    pub severity: alert_rule_properties::Severity,
    #[doc = "The alert rule frequency in ISO8601 format. The time granularity must be in minutes and minimum value is 5 minutes."]
    pub frequency: String,
    #[doc = "The detector information. By default this is not populated, unless it's specified in expandDetector"]
    pub detector: Detector,
    #[doc = "The alert rule resources scope."]
    pub scope: Vec<String>,
    #[doc = "The Action Groups information, used by the alert rule."]
    #[serde(rename = "actionGroups")]
    pub action_groups: ActionGroupsInformation,
    #[doc = "Optional throttling information for the alert rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub throttling: Option<ThrottlingInformation>,
}
impl AlertRuleProperties {
    pub fn new(
        state: alert_rule_properties::State,
        severity: alert_rule_properties::Severity,
        frequency: String,
        detector: Detector,
        scope: Vec<String>,
        action_groups: ActionGroupsInformation,
    ) -> Self {
        Self {
            description: None,
            state,
            severity,
            frequency,
            detector,
            scope,
            action_groups,
            throttling: None,
        }
    }
}
pub mod alert_rule_properties {
    use super::*;
    #[doc = "The alert rule state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
    #[doc = "The alert rule severity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Sev0,
        Sev1,
        Sev2,
        Sev3,
        Sev4,
    }
}
#[doc = "List of Smart Detector alert rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRulesList {
    #[doc = "List of Smart Detector alert rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AlertRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertRulesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResource {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "The resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl AzureResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The detector information. By default this is not populated, unless it's specified in expandDetector"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Detector {
    #[doc = "The detector id."]
    pub id: String,
    #[doc = "The detector's parameters.'"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[doc = "The Smart Detector name. By default this is not populated, unless it's specified in expandDetector"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The Smart Detector description. By default this is not populated, unless it's specified in expandDetector"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The Smart Detector supported resource types. By default this is not populated, unless it's specified in expandDetector"]
    #[serde(rename = "supportedResourceTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_resource_types: Vec<String>,
    #[doc = "The Smart Detector image path. By default this is not populated, unless it's specified in expandDetector"]
    #[serde(rename = "imagePaths", default, skip_serializing_if = "Vec::is_empty")]
    pub image_paths: Vec<String>,
}
impl Detector {
    pub fn new(id: String) -> Self {
        Self {
            id,
            parameters: None,
            name: None,
            description: None,
            supported_resource_types: Vec::new(),
            image_paths: Vec::new(),
        }
    }
}
#[doc = "Describe the format of an Error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmartDetectorErrorResponse {
    #[doc = "Error code"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message indicating why the operation failed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl SmartDetectorErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Optional throttling information for the alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThrottlingInformation {
    #[doc = "The required duration (in ISO8601 format) to wait before notifying on the alert rule again. The time granularity must be in minutes and minimum value is 0 minutes"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
}
impl ThrottlingInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
