#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The Action Groups information, used by the alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionGroupsInformation {
    #[doc = "An optional custom email subject to use in email notifications."]
    #[serde(rename = "customEmailSubject", default, skip_serializing_if = "Option::is_none")]
    pub custom_email_subject: Option<String>,
    #[doc = "An optional custom web-hook payload to use in web-hook notifications."]
    #[serde(rename = "customWebhookPayload", default, skip_serializing_if = "Option::is_none")]
    pub custom_webhook_payload: Option<String>,
    #[doc = "The Action Group resource IDs."]
    #[serde(rename = "groupIds")]
    pub group_ids: Vec<String>,
}
impl ActionGroupsInformation {
    pub fn new(group_ids: Vec<String>) -> Self {
        Self {
            custom_email_subject: None,
            custom_webhook_payload: None,
            group_ids,
        }
    }
}
#[doc = "The alert rule information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRule {
    #[serde(flatten)]
    pub azure_resource: AzureResource,
    #[doc = "The alert rule properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertRuleProperties>,
}
impl AlertRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The alert rule patch information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRulePatchObject {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The alert rule properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertRulePatchProperties>,
}
impl AlertRulePatchObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The alert rule properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRulePatchProperties {
    #[doc = "The alert rule description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The alert rule state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<alert_rule_patch_properties::State>,
    #[doc = "The alert rule severity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<alert_rule_patch_properties::Severity>,
    #[doc = "The alert rule frequency in ISO8601 format. The time granularity must be in minutes and minimum value is 5 minutes."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<String>,
    #[doc = "The Action Groups information, used by the alert rule."]
    #[serde(rename = "actionGroups", default, skip_serializing_if = "Option::is_none")]
    pub action_groups: Option<ActionGroupsInformation>,
    #[doc = "Optional throttling information for the alert rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub throttling: Option<ThrottlingInformation>,
}
impl AlertRulePatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_rule_patch_properties {
    use super::*;
    #[doc = "The alert rule state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
    #[doc = "The alert rule severity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Sev0,
        Sev1,
        Sev2,
        Sev3,
        Sev4,
    }
}
#[doc = "The alert rule properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleProperties {
    #[doc = "The alert rule description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The alert rule state."]
    pub state: alert_rule_properties::State,
    #[doc = "The alert rule severity."]
    pub severity: alert_rule_properties::Severity,
    #[doc = "The alert rule frequency in ISO8601 format. The time granularity must be in minutes and minimum value is 5 minutes."]
    pub frequency: String,
    #[doc = "The detector information. By default this is not populated, unless it's specified in expandDetector"]
    pub detector: Detector,
    #[doc = "The alert rule resources scope."]
    pub scope: Vec<String>,
    #[doc = "The Action Groups information, used by the alert rule."]
    #[serde(rename = "actionGroups")]
    pub action_groups: ActionGroupsInformation,
    #[doc = "Optional throttling information for the alert rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub throttling: Option<ThrottlingInformation>,
}
impl AlertRuleProperties {
    pub fn new(
        state: alert_rule_properties::State,
        severity: alert_rule_properties::Severity,
        frequency: String,
        detector: Detector,
        scope: Vec<String>,
        action_groups: ActionGroupsInformation,
    ) -> Self {
        Self {
            description: None,
            state,
            severity,
            frequency,
            detector,
            scope,
            action_groups,
            throttling: None,
        }
    }
}
pub mod alert_rule_properties {
    use super::*;
    #[doc = "The alert rule state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
    #[doc = "The alert rule severity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Sev0,
        Sev1,
        Sev2,
        Sev3,
        Sev4,
    }
}
#[doc = "List of Smart Detector alert rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRulesList {
    #[doc = "List of Smart Detector alert rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AlertRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertRulesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response from the service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertsManagementErrorResponse {
    #[doc = "Details of error response."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponseBody>,
}
impl AlertsManagementErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResource {
    #[doc = "The resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl AzureResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The detector information. By default this is not populated, unless it's specified in expandDetector"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Detector {
    #[doc = "The detector id."]
    pub id: String,
    #[doc = "The detector's parameters.'"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[doc = "The Smart Detector name. By default this is not populated, unless it's specified in expandDetector"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The Smart Detector description. By default this is not populated, unless it's specified in expandDetector"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The Smart Detector supported resource types. By default this is not populated, unless it's specified in expandDetector"]
    #[serde(rename = "supportedResourceTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_resource_types: Vec<String>,
    #[doc = "The Smart Detector image path. By default this is not populated, unless it's specified in expandDetector"]
    #[serde(rename = "imagePaths", default, skip_serializing_if = "Vec::is_empty")]
    pub image_paths: Vec<String>,
}
impl Detector {
    pub fn new(id: String) -> Self {
        Self {
            id,
            parameters: None,
            name: None,
            description: None,
            supported_resource_types: Vec::new(),
            image_paths: Vec::new(),
        }
    }
}
#[doc = "Details of a monitor service"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MonitorServiceDetails {
    #[doc = "Monitor service name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Monitor service display name"]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl MonitorServiceDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Monitor service details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MonitorServiceList {
    #[serde(flatten)]
    pub alerts_meta_data_properties: AlertsMetaDataProperties,
    #[doc = "Array of operations"]
    pub data: Vec<MonitorServiceDetails>,
}
impl MonitorServiceList {
    pub fn new(alerts_meta_data_properties: AlertsMetaDataProperties, data: Vec<MonitorServiceDetails>) -> Self {
        Self {
            alerts_meta_data_properties,
            data,
        }
    }
}
#[doc = "An azure resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[doc = "Azure resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Azure resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Azure resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describe the format of an Error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmartDetectorErrorResponse {
    #[doc = "Error code"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message indicating why the operation failed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl SmartDetectorErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Optional throttling information for the alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThrottlingInformation {
    #[doc = "The required duration (in ISO8601 format) to wait before notifying on the alert rule again. The time granularity must be in minutes and minimum value is 0 minutes"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
}
impl ThrottlingInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Action status"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActionStatus {
    #[doc = "Value indicating whether alert is suppressed."]
    #[serde(rename = "isSuppressed", default, skip_serializing_if = "Option::is_none")]
    pub is_suppressed: Option<bool>,
}
impl ActionStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An alert created in alert management service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alert {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Alert property bag"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertProperties>,
}
impl Alert {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information specific to the monitor service that gives more contextual details about the alert."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertContext {}
impl AlertContext {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Alert Modification details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertModification {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of the alert modification item."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertModificationProperties>,
}
impl AlertModification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Alert modification item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertModificationItem {
    #[doc = "Reason for the modification"]
    #[serde(rename = "modificationEvent", default, skip_serializing_if = "Option::is_none")]
    pub modification_event: Option<alert_modification_item::ModificationEvent>,
    #[doc = "Old value"]
    #[serde(rename = "oldValue", default, skip_serializing_if = "Option::is_none")]
    pub old_value: Option<String>,
    #[doc = "New value"]
    #[serde(rename = "newValue", default, skip_serializing_if = "Option::is_none")]
    pub new_value: Option<String>,
    #[doc = "Modified date and time"]
    #[serde(rename = "modifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub modified_at: Option<String>,
    #[doc = "Modified user details (Principal client name)"]
    #[serde(rename = "modifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub modified_by: Option<String>,
    #[doc = "Modification comments"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
    #[doc = "Description of the modification"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl AlertModificationItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_modification_item {
    use super::*;
    #[doc = "Reason for the modification"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ModificationEvent {
        AlertCreated,
        StateChange,
        MonitorConditionChange,
    }
}
#[doc = "Properties of the alert modification item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertModificationProperties {
    #[doc = "Unique Id of the alert for which the history is being retrieved"]
    #[serde(rename = "alertId", default, skip_serializing_if = "Option::is_none")]
    pub alert_id: Option<String>,
    #[doc = "Modification details"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub modifications: Vec<AlertModificationItem>,
}
impl AlertModificationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Alert property bag"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertProperties {
    #[doc = "This object contains consistent fields across different monitor services."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub essentials: Option<Essentials>,
    #[doc = "Information specific to the monitor service that gives more contextual details about the alert."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub context: Option<AlertContext>,
    #[doc = "Config which would be used for displaying the data in portal."]
    #[serde(rename = "egressConfig", default, skip_serializing_if = "Option::is_none")]
    pub egress_config: Option<EgressConfig>,
}
impl AlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List the alerts."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertsList {
    #[doc = "URL to fetch the next set of alerts."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "List of alerts"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Alert>,
}
impl AlertsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "alert meta data information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertsMetaData {
    #[doc = "alert meta data property bag"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertsMetaDataProperties>,
}
impl AlertsMetaData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "alert meta data property bag"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertsMetaDataProperties {
    #[doc = "Identification of the information to be retrieved by API call"]
    #[serde(rename = "metadataIdentifier")]
    pub metadata_identifier: alerts_meta_data_properties::MetadataIdentifier,
}
impl AlertsMetaDataProperties {
    pub fn new(metadata_identifier: alerts_meta_data_properties::MetadataIdentifier) -> Self {
        Self { metadata_identifier }
    }
}
pub mod alerts_meta_data_properties {
    use super::*;
    #[doc = "Identification of the information to be retrieved by API call"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MetadataIdentifier {
        MonitorServiceList,
    }
}
#[doc = "Summary of alerts based on the input filters and 'groupby' parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertsSummary {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Group the result set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertsSummaryGroup>,
}
impl AlertsSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Group the result set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertsSummaryGroup {
    #[doc = "Total count of the result set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<i64>,
    #[doc = "Total count of the smart groups."]
    #[serde(rename = "smartGroupsCount", default, skip_serializing_if = "Option::is_none")]
    pub smart_groups_count: Option<i64>,
    #[doc = "Name of the field aggregated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub groupedby: Option<String>,
    #[doc = "List of the items"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<AlertsSummaryGroupItem>,
}
impl AlertsSummaryGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Alerts summary group item"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertsSummaryGroupItem {
    #[doc = "Value of the aggregated field"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Count of the aggregated field"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[doc = "Name of the field aggregated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub groupedby: Option<String>,
    #[doc = "List of the items"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<AlertsSummaryGroupItem>,
}
impl AlertsSummaryGroupItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Config which would be used for displaying the data in portal."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EgressConfig {}
impl EgressConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details of error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponseBody {
    #[doc = "Error code, intended to be consumed programmatically."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Description of the error, intended for display in user interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "Target of the particular error, for example name of the property."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "A list of additional details about the error."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorResponseBody>,
}
impl ErrorResponseBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This object contains consistent fields across different monitor services."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Essentials {
    #[doc = "Severity of alert Sev0 being highest and Sev4 being lowest."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<essentials::Severity>,
    #[doc = "The type of signal the alert is based on, which could be metrics, logs or activity logs."]
    #[serde(rename = "signalType", default, skip_serializing_if = "Option::is_none")]
    pub signal_type: Option<essentials::SignalType>,
    #[doc = "Alert object state, which can be modified by the user."]
    #[serde(rename = "alertState", default, skip_serializing_if = "Option::is_none")]
    pub alert_state: Option<essentials::AlertState>,
    #[doc = "Can be 'Fired' or 'Resolved', which represents whether the underlying conditions have crossed the defined alert rule thresholds."]
    #[serde(rename = "monitorCondition", default, skip_serializing_if = "Option::is_none")]
    pub monitor_condition: Option<essentials::MonitorCondition>,
    #[doc = "Target ARM resource, on which alert got created."]
    #[serde(rename = "targetResource", default, skip_serializing_if = "Option::is_none")]
    pub target_resource: Option<String>,
    #[doc = "Name of the target ARM resource name, on which alert got created."]
    #[serde(rename = "targetResourceName", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_name: Option<String>,
    #[doc = "Resource group of target ARM resource, on which alert got created."]
    #[serde(rename = "targetResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group: Option<String>,
    #[doc = "Resource type of target ARM resource, on which alert got created."]
    #[serde(rename = "targetResourceType", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_type: Option<String>,
    #[doc = "Monitor service on which the rule(monitor) is set."]
    #[serde(rename = "monitorService", default, skip_serializing_if = "Option::is_none")]
    pub monitor_service: Option<essentials::MonitorService>,
    #[doc = "Rule(monitor) which fired alert instance. Depending on the monitor service,  this would be ARM id or name of the rule."]
    #[serde(rename = "alertRule", default, skip_serializing_if = "Option::is_none")]
    pub alert_rule: Option<String>,
    #[doc = "Unique Id created by monitor service for each alert instance. This could be used to track the issue at the monitor service, in case of Nagios, Zabbix, SCOM etc."]
    #[serde(rename = "sourceCreatedId", default, skip_serializing_if = "Option::is_none")]
    pub source_created_id: Option<String>,
    #[doc = "Unique Id of the smart group"]
    #[serde(rename = "smartGroupId", default, skip_serializing_if = "Option::is_none")]
    pub smart_group_id: Option<String>,
    #[doc = "Verbose reason describing the reason why this alert instance is added to a smart group"]
    #[serde(rename = "smartGroupingReason", default, skip_serializing_if = "Option::is_none")]
    pub smart_grouping_reason: Option<String>,
    #[doc = "Creation time(ISO-8601 format) of alert instance."]
    #[serde(rename = "startDateTime", default, skip_serializing_if = "Option::is_none")]
    pub start_date_time: Option<String>,
    #[doc = "Last modification time(ISO-8601 format) of alert instance."]
    #[serde(rename = "lastModifiedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_date_time: Option<String>,
    #[doc = "Resolved time(ISO-8601 format) of alert instance. This will be updated when monitor service resolves the alert instance because the rule condition is no longer met."]
    #[serde(rename = "monitorConditionResolvedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub monitor_condition_resolved_date_time: Option<String>,
    #[doc = "User who last modified the alert, in case of monitor service updates user would be 'system', otherwise name of the user."]
    #[serde(rename = "lastModifiedUserName", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_user_name: Option<String>,
    #[doc = "Action status"]
    #[serde(rename = "actionStatus", default, skip_serializing_if = "Option::is_none")]
    pub action_status: Option<ActionStatus>,
    #[doc = "Alert description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl Essentials {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod essentials {
    use super::*;
    #[doc = "Severity of alert Sev0 being highest and Sev4 being lowest."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Sev0,
        Sev1,
        Sev2,
        Sev3,
        Sev4,
    }
    #[doc = "The type of signal the alert is based on, which could be metrics, logs or activity logs."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SignalType {
        Metric,
        Log,
        Unknown,
    }
    #[doc = "Alert object state, which can be modified by the user."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AlertState {
        New,
        Acknowledged,
        Closed,
    }
    #[doc = "Can be 'Fired' or 'Resolved', which represents whether the underlying conditions have crossed the defined alert rule thresholds."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MonitorCondition {
        Fired,
        Resolved,
    }
    #[doc = "Monitor service on which the rule(monitor) is set."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MonitorService {
        #[serde(rename = "Application Insights")]
        ApplicationInsights,
        #[serde(rename = "ActivityLog Administrative")]
        ActivityLogAdministrative,
        #[serde(rename = "ActivityLog Security")]
        ActivityLogSecurity,
        #[serde(rename = "ActivityLog Recommendation")]
        ActivityLogRecommendation,
        #[serde(rename = "ActivityLog Policy")]
        ActivityLogPolicy,
        #[serde(rename = "ActivityLog Autoscale")]
        ActivityLogAutoscale,
        #[serde(rename = "Log Analytics")]
        LogAnalytics,
        Nagios,
        Platform,
        #[serde(rename = "SCOM")]
        Scom,
        ServiceHealth,
        SmartDetector,
        #[serde(rename = "VM Insights")]
        VmInsights,
        Zabbix,
        #[serde(rename = "Resource Health")]
        ResourceHealth,
    }
}
#[doc = "Operation provided by provider"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Name of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Properties of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "Properties of the operation"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Provider name"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource name"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Operation name"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "Description of the operation"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Lists the operations available in the AlertsManagement RP."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationsList {
    #[doc = "URL to fetch the next set of alerts."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of operations"]
    pub value: Vec<Operation>,
}
impl OperationsList {
    pub fn new(value: Vec<Operation>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "Set of related alerts grouped together smartly by AMS."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmartGroup {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of smart group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SmartGroupProperties>,
}
impl SmartGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Aggregated property of each type"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmartGroupAggregatedProperty {
    #[doc = "Name of the type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Total number of items of type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl SmartGroupAggregatedProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Alert Modification details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmartGroupModification {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of the smartGroup modification item."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SmartGroupModificationProperties>,
}
impl SmartGroupModification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "smartGroup modification item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmartGroupModificationItem {
    #[doc = "Reason for the modification"]
    #[serde(rename = "modificationEvent", default, skip_serializing_if = "Option::is_none")]
    pub modification_event: Option<smart_group_modification_item::ModificationEvent>,
    #[doc = "Old value"]
    #[serde(rename = "oldValue", default, skip_serializing_if = "Option::is_none")]
    pub old_value: Option<String>,
    #[doc = "New value"]
    #[serde(rename = "newValue", default, skip_serializing_if = "Option::is_none")]
    pub new_value: Option<String>,
    #[doc = "Modified date and time"]
    #[serde(rename = "modifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub modified_at: Option<String>,
    #[doc = "Modified user details (Principal client name)"]
    #[serde(rename = "modifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub modified_by: Option<String>,
    #[doc = "Modification comments"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
    #[doc = "Description of the modification"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl SmartGroupModificationItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod smart_group_modification_item {
    use super::*;
    #[doc = "Reason for the modification"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ModificationEvent {
        SmartGroupCreated,
        StateChange,
        AlertAdded,
        AlertRemoved,
    }
}
#[doc = "Properties of the smartGroup modification item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmartGroupModificationProperties {
    #[doc = "Unique Id of the smartGroup for which the history is being retrieved"]
    #[serde(rename = "smartGroupId", default, skip_serializing_if = "Option::is_none")]
    pub smart_group_id: Option<String>,
    #[doc = "Modification details"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub modifications: Vec<SmartGroupModificationItem>,
    #[doc = "URL to fetch the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SmartGroupModificationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of smart group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmartGroupProperties {
    #[doc = "Total number of alerts in smart group"]
    #[serde(rename = "alertsCount", default, skip_serializing_if = "Option::is_none")]
    pub alerts_count: Option<i64>,
    #[doc = "Smart group state"]
    #[serde(rename = "smartGroupState", default, skip_serializing_if = "Option::is_none")]
    pub smart_group_state: Option<smart_group_properties::SmartGroupState>,
    #[doc = "Severity of smart group is the highest(Sev0 >... > Sev4) severity of all the alerts in the group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<smart_group_properties::Severity>,
    #[doc = "Creation time of smart group. Date-Time in ISO-8601 format."]
    #[serde(rename = "startDateTime", default, skip_serializing_if = "Option::is_none")]
    pub start_date_time: Option<String>,
    #[doc = "Last updated time of smart group. Date-Time in ISO-8601 format."]
    #[serde(rename = "lastModifiedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_date_time: Option<String>,
    #[doc = "Last modified by user name."]
    #[serde(rename = "lastModifiedUserName", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_user_name: Option<String>,
    #[doc = "Summary of target resources in the smart group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<SmartGroupAggregatedProperty>,
    #[doc = "Summary of target resource types in the smart group"]
    #[serde(rename = "resourceTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_types: Vec<SmartGroupAggregatedProperty>,
    #[doc = "Summary of target resource groups in the smart group"]
    #[serde(rename = "resourceGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_groups: Vec<SmartGroupAggregatedProperty>,
    #[doc = "Summary of monitorServices in the smart group"]
    #[serde(rename = "monitorServices", default, skip_serializing_if = "Vec::is_empty")]
    pub monitor_services: Vec<SmartGroupAggregatedProperty>,
    #[doc = "Summary of monitorConditions in the smart group"]
    #[serde(rename = "monitorConditions", default, skip_serializing_if = "Vec::is_empty")]
    pub monitor_conditions: Vec<SmartGroupAggregatedProperty>,
    #[doc = "Summary of alertStates in the smart group"]
    #[serde(rename = "alertStates", default, skip_serializing_if = "Vec::is_empty")]
    pub alert_states: Vec<SmartGroupAggregatedProperty>,
    #[doc = "Summary of alertSeverities in the smart group"]
    #[serde(rename = "alertSeverities", default, skip_serializing_if = "Vec::is_empty")]
    pub alert_severities: Vec<SmartGroupAggregatedProperty>,
    #[doc = "The URI to fetch the next page of alerts. Call ListNext() with this URI to fetch the next page alerts."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SmartGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod smart_group_properties {
    use super::*;
    #[doc = "Smart group state"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SmartGroupState {
        New,
        Acknowledged,
        Closed,
    }
    #[doc = "Severity of smart group is the highest(Sev0 >... > Sev4) severity of all the alerts in the group."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Sev0,
        Sev1,
        Sev2,
        Sev3,
        Sev4,
    }
}
#[doc = "List the alerts."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmartGroupsList {
    #[doc = "URL to fetch the next set of alerts."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "List of alerts"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SmartGroup>,
}
impl SmartGroupsList {
    pub fn new() -> Self {
        Self::default()
    }
}
