#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdditionalInformation {
    #[serde(rename = "titleName", default, skip_serializing_if = "Option::is_none")]
    pub title_name: Option<String>,
    #[serde(rename = "titleValue", default, skip_serializing_if = "Option::is_none")]
    pub title_value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(rename = "hasProperties", default, skip_serializing_if = "Option::is_none")]
    pub has_properties: Option<bool>,
}
impl AdditionalInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddsConfiguration {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Item>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl AddsConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddsServiceMember {
    #[serde(rename = "domainName", default, skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
    pub site_name: Option<String>,
    #[serde(rename = "addsRoles", default, skip_serializing_if = "Vec::is_empty")]
    pub adds_roles: Vec<String>,
    #[serde(rename = "gcReachable", default, skip_serializing_if = "Option::is_none")]
    pub gc_reachable: Option<bool>,
    #[serde(rename = "isAdvertising", default, skip_serializing_if = "Option::is_none")]
    pub is_advertising: Option<bool>,
    #[serde(rename = "pdcReachable", default, skip_serializing_if = "Option::is_none")]
    pub pdc_reachable: Option<bool>,
    #[serde(rename = "sysvolState", default, skip_serializing_if = "Option::is_none")]
    pub sysvol_state: Option<bool>,
    #[serde(rename = "dcTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub dc_types: Vec<String>,
    #[serde(rename = "serviceMemberId", default, skip_serializing_if = "Option::is_none")]
    pub service_member_id: Option<String>,
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "activeAlerts", default, skip_serializing_if = "Option::is_none")]
    pub active_alerts: Option<i64>,
    #[serde(rename = "additionalInformation", default, skip_serializing_if = "Option::is_none")]
    pub additional_information: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Item>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    #[serde(rename = "disabledReason", default, skip_serializing_if = "Option::is_none")]
    pub disabled_reason: Option<i64>,
    #[serde(rename = "installedQfes", default, skip_serializing_if = "Vec::is_empty")]
    pub installed_qfes: Vec<Hotfix>,
    #[serde(rename = "lastDisabled", default, skip_serializing_if = "Option::is_none")]
    pub last_disabled: Option<String>,
    #[serde(rename = "lastReboot", default, skip_serializing_if = "Option::is_none")]
    pub last_reboot: Option<String>,
    #[serde(
        rename = "lastServerReportedMonitoringLevelChange",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub last_server_reported_monitoring_level_change: Option<String>,
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[serde(rename = "machineId", default, skip_serializing_if = "Option::is_none")]
    pub machine_id: Option<String>,
    #[serde(rename = "machineName", default, skip_serializing_if = "Option::is_none")]
    pub machine_name: Option<String>,
    #[serde(rename = "monitoringConfigurationsComputed", default, skip_serializing_if = "Vec::is_empty")]
    pub monitoring_configurations_computed: Vec<Item>,
    #[serde(rename = "monitoringConfigurationsCustomized", default, skip_serializing_if = "Vec::is_empty")]
    pub monitoring_configurations_customized: Vec<Item>,
    #[serde(rename = "osName", default, skip_serializing_if = "Option::is_none")]
    pub os_name: Option<String>,
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<Item>,
    #[serde(rename = "recommendedQfes", default, skip_serializing_if = "Vec::is_empty")]
    pub recommended_qfes: Vec<Hotfix>,
    #[serde(rename = "resolvedAlerts", default, skip_serializing_if = "Option::is_none")]
    pub resolved_alerts: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub role: Option<String>,
    #[serde(rename = "serverReportedMonitoringLevel", default, skip_serializing_if = "Option::is_none")]
    pub server_reported_monitoring_level: Option<adds_service_member::ServerReportedMonitoringLevel>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl AddsServiceMember {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod adds_service_member {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServerReportedMonitoringLevel {
        Partial,
        Full,
        Off,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddsServiceMembers {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AddsServiceMember>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl AddsServiceMembers {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Agent {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "machineId", default, skip_serializing_if = "Option::is_none")]
    pub machine_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "machineName", default, skip_serializing_if = "Option::is_none")]
    pub machine_name: Option<String>,
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
}
impl Agent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alert {
    #[serde(rename = "alertId", default, skip_serializing_if = "Option::is_none")]
    pub alert_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<alert::Level>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<alert::State>,
    #[serde(rename = "shortName", default, skip_serializing_if = "Option::is_none")]
    pub short_name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub remediation: Option<String>,
    #[serde(rename = "relatedLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub related_links: Vec<HelpLink>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[serde(rename = "additionalInformation", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_information: Vec<AdditionalInformation>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "resolvedDate", default, skip_serializing_if = "Option::is_none")]
    pub resolved_date: Option<String>,
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[serde(rename = "monitorRoleType", default, skip_serializing_if = "Option::is_none")]
    pub monitor_role_type: Option<String>,
    #[serde(rename = "activeAlertProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub active_alert_properties: Vec<Item>,
    #[serde(rename = "resolvedAlertProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub resolved_alert_properties: Vec<Item>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "serviceMemberId", default, skip_serializing_if = "Option::is_none")]
    pub service_member_id: Option<String>,
}
impl Alert {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Warning,
        Error,
        PreWarning,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Active,
        ResolvedByPositiveResult,
        ResolvedManually,
        ResolvedByTimer,
        ResolvedByStateChange,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertFeedback {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "shortName", default, skip_serializing_if = "Option::is_none")]
    pub short_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub feedback: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    #[serde(rename = "consentedToShare", default, skip_serializing_if = "Option::is_none")]
    pub consented_to_share: Option<bool>,
    #[serde(rename = "serviceMemberId", default, skip_serializing_if = "Option::is_none")]
    pub service_member_id: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
}
impl AlertFeedback {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertFeedbacks {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AlertFeedback>,
}
impl AlertFeedbacks {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alerts {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Alert>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl Alerts {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssociatedObject {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "distinguishedName", default, skip_serializing_if = "Option::is_none")]
    pub distinguished_name: Option<String>,
    #[serde(rename = "lastDirSyncTime", default, skip_serializing_if = "Option::is_none")]
    pub last_dir_sync_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mail: Option<String>,
    #[serde(rename = "objectGuid", default, skip_serializing_if = "Option::is_none")]
    pub object_guid: Option<String>,
    #[serde(rename = "objectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "onpremisesUserPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub onpremises_user_principal_name: Option<String>,
    #[serde(rename = "proxyAddresses", default, skip_serializing_if = "Option::is_none")]
    pub proxy_addresses: Option<String>,
    #[serde(rename = "sourceAnchor", default, skip_serializing_if = "Option::is_none")]
    pub source_anchor: Option<String>,
    #[serde(rename = "sourceOfAuthority", default, skip_serializing_if = "Option::is_none")]
    pub source_of_authority: Option<String>,
    #[serde(rename = "timeOccurred", default, skip_serializing_if = "Option::is_none")]
    pub time_occurred: Option<String>,
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
}
impl AssociatedObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AttributeDelta {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<ValueDelta>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
    pub operation_type: Option<attribute_delta::OperationType>,
    #[serde(rename = "valueType", default, skip_serializing_if = "Option::is_none")]
    pub value_type: Option<attribute_delta::ValueType>,
    #[serde(rename = "multiValued", default, skip_serializing_if = "Option::is_none")]
    pub multi_valued: Option<bool>,
}
impl AttributeDelta {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod attribute_delta {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationType {
        Undefined,
        Add,
        Replace,
        Update,
        Delete,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ValueType {
        Undefined,
        Dn,
        Binary,
        String,
        Integer,
        Boolean,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AttributeMapping {
    #[serde(rename = "mappingSource", default, skip_serializing_if = "Option::is_none")]
    pub mapping_source: Option<AttributeMppingSource>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<attribute_mapping::Type>,
    #[serde(rename = "destinationAttribute", default, skip_serializing_if = "Option::is_none")]
    pub destination_attribute: Option<String>,
    #[serde(rename = "contextId", default, skip_serializing_if = "Option::is_none")]
    pub context_id: Option<String>,
}
impl AttributeMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod attribute_mapping {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Constant,
        Direct,
        DnPart,
        Script,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AttributeMppingSource {
    #[serde(rename = "sourceAttribute", default, skip_serializing_if = "Vec::is_empty")]
    pub source_attribute: Vec<String>,
    #[serde(rename = "dnPart", default, skip_serializing_if = "Option::is_none")]
    pub dn_part: Option<i64>,
    #[serde(rename = "scriptContext", default, skip_serializing_if = "Option::is_none")]
    pub script_context: Option<String>,
    #[serde(rename = "constantValue", default, skip_serializing_if = "Option::is_none")]
    pub constant_value: Option<String>,
}
impl AttributeMppingSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ChangeNotReimported {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub delta: Option<ChangeNotReimportedDelta>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub entry: Option<ChangeNotReimportedEntry>,
}
impl ChangeNotReimported {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ChangeNotReimportedDelta {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub anchor: Option<String>,
    #[serde(rename = "dnAttributes", default, skip_serializing_if = "Vec::is_empty")]
    pub dn_attributes: Vec<AttributeDelta>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub attributes: Vec<AttributeDelta>,
    #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
    pub operation_type: Option<change_not_reimported_delta::OperationType>,
}
impl ChangeNotReimportedDelta {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod change_not_reimported_delta {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationType {
        Undefined,
        None,
        Add,
        Replace,
        Update,
        Delete,
        Obsolete,
        DeleteAdd,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ChangeNotReimportedEntry {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub anchor: Option<String>,
    #[serde(rename = "parentAnchor", default, skip_serializing_if = "Option::is_none")]
    pub parent_anchor: Option<String>,
    #[serde(rename = "primaryObjectClass", default, skip_serializing_if = "Option::is_none")]
    pub primary_object_class: Option<String>,
    #[serde(rename = "objectClasses", default, skip_serializing_if = "Vec::is_empty")]
    pub object_classes: Vec<String>,
    #[serde(rename = "dnAttributes", default, skip_serializing_if = "Vec::is_empty")]
    pub dn_attributes: Vec<AttributeDelta>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub attributes: Vec<AttributeDelta>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dn: Option<String>,
}
impl ChangeNotReimportedEntry {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Connector {
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "schemaXml", default, skip_serializing_if = "Option::is_none")]
    pub schema_xml: Option<String>,
    #[serde(rename = "passwordManagementSettings", default, skip_serializing_if = "Option::is_none")]
    pub password_management_settings: Option<serde_json::Value>,
    #[serde(rename = "passwordHashSyncConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub password_hash_sync_configuration: Option<serde_json::Value>,
    #[serde(rename = "timeCreated", default, skip_serializing_if = "Option::is_none")]
    pub time_created: Option<String>,
    #[serde(rename = "timeLastModified", default, skip_serializing_if = "Option::is_none")]
    pub time_last_modified: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub partitions: Vec<Partition>,
    #[serde(rename = "runProfiles", default, skip_serializing_if = "Vec::is_empty")]
    pub run_profiles: Vec<RunProfile>,
    #[serde(rename = "classesIncluded", default, skip_serializing_if = "Vec::is_empty")]
    pub classes_included: Vec<String>,
    #[serde(rename = "attributesIncluded", default, skip_serializing_if = "Vec::is_empty")]
    pub attributes_included: Vec<String>,
}
impl Connector {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorConnectionError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "runStepResultId", default, skip_serializing_if = "Option::is_none")]
    pub run_step_result_id: Option<String>,
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "timeOccured", default, skip_serializing_if = "Option::is_none")]
    pub time_occured: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<String>,
}
impl ConnectorConnectionError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorConnectionErrors {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConnectorConnectionError>,
}
impl ConnectorConnectionErrors {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorMetadata {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub connectors: Vec<ConnectorMetadataDetails>,
    #[serde(rename = "runProfileNames", default, skip_serializing_if = "Vec::is_empty")]
    pub run_profile_names: Vec<String>,
}
impl ConnectorMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorMetadataDetails {
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(rename = "connectorDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub connector_display_name: Option<String>,
}
impl ConnectorMetadataDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorObjectError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "runStepResultId", default, skip_serializing_if = "Option::is_none")]
    pub run_step_result_id: Option<String>,
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "entryNumber", default, skip_serializing_if = "Option::is_none")]
    pub entry_number: Option<i64>,
    #[serde(rename = "lineNumber", default, skip_serializing_if = "Option::is_none")]
    pub line_number: Option<i64>,
    #[serde(rename = "columnNumber", default, skip_serializing_if = "Option::is_none")]
    pub column_number: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dn: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub anchor: Option<String>,
    #[serde(rename = "attributeName", default, skip_serializing_if = "Option::is_none")]
    pub attribute_name: Option<String>,
    #[serde(rename = "serverErrorDetail", default, skip_serializing_if = "Option::is_none")]
    pub server_error_detail: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl ConnectorObjectError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectorObjectErrors {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConnectorObjectError>,
}
impl ConnectorObjectErrors {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Connectors {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Connector>,
}
impl Connectors {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Credential {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identifier: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "credentialData", default, skip_serializing_if = "Vec::is_empty")]
    pub credential_data: Vec<String>,
}
impl Credential {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Credentials {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Credential>,
}
impl Credentials {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFreshnessDetails {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Item>,
}
impl DataFreshnessDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<dimension::Health>,
    #[serde(rename = "simpleProperties", default, skip_serializing_if = "Option::is_none")]
    pub simple_properties: Option<serde_json::Value>,
    #[serde(rename = "activeAlerts", default, skip_serializing_if = "Option::is_none")]
    pub active_alerts: Option<i64>,
    #[serde(rename = "additionalInformation", default, skip_serializing_if = "Option::is_none")]
    pub additional_information: Option<String>,
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "resolvedAlerts", default, skip_serializing_if = "Option::is_none")]
    pub resolved_alerts: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub signature: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod dimension {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        Healthy,
        Warning,
        Error,
        NotMonitored,
        Missing,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimensions {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Dimension>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl Dimensions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Display {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
}
impl Display {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorCount {
    #[serde(rename = "errorBucket", default, skip_serializing_if = "Option::is_none")]
    pub error_bucket: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub truncated: Option<bool>,
}
impl ErrorCount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorCounts {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ErrorCount>,
}
impl ErrorCounts {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "kbUrl", default, skip_serializing_if = "Option::is_none")]
    pub kb_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub detail: Option<String>,
    #[serde(rename = "objectsWithSyncError", default, skip_serializing_if = "Option::is_none")]
    pub objects_with_sync_error: Option<ObjectWithSyncError>,
    #[serde(rename = "objectWithSyncError", default, skip_serializing_if = "Option::is_none")]
    pub object_with_sync_error: Option<MergedExportError>,
}
impl ErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorReportUsersEntries {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ErrorReportUsersEntry>,
}
impl ErrorReportUsersEntries {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorReportUsersEntry {
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[serde(rename = "uniqueIpAddresses", default, skip_serializing_if = "Option::is_none")]
    pub unique_ip_addresses: Option<String>,
    #[serde(rename = "totalErrorAttempts", default, skip_serializing_if = "Option::is_none")]
    pub total_error_attempts: Option<i64>,
}
impl ErrorReportUsersEntry {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "runStepResultId", default, skip_serializing_if = "Option::is_none")]
    pub run_step_result_id: Option<String>,
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "serverErrorDetail", default, skip_serializing_if = "Option::is_none")]
    pub server_error_detail: Option<String>,
    #[serde(rename = "timeFirstOccured", default, skip_serializing_if = "Option::is_none")]
    pub time_first_occured: Option<String>,
    #[serde(rename = "retryCount", default, skip_serializing_if = "Option::is_none")]
    pub retry_count: Option<i64>,
    #[serde(rename = "csObjectId", default, skip_serializing_if = "Option::is_none")]
    pub cs_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dn: Option<String>,
    #[serde(rename = "minLimit", default, skip_serializing_if = "Option::is_none")]
    pub min_limit: Option<String>,
    #[serde(rename = "maxLimit", default, skip_serializing_if = "Option::is_none")]
    pub max_limit: Option<String>,
    #[serde(rename = "cloudAnchor", default, skip_serializing_if = "Option::is_none")]
    pub cloud_anchor: Option<String>,
    #[serde(rename = "attributeName", default, skip_serializing_if = "Option::is_none")]
    pub attribute_name: Option<String>,
    #[serde(rename = "attributeValue", default, skip_serializing_if = "Option::is_none")]
    pub attribute_value: Option<String>,
    #[serde(rename = "attributeMultiValue", default, skip_serializing_if = "Option::is_none")]
    pub attribute_multi_value: Option<bool>,
    #[serde(rename = "objectIdConflict", default, skip_serializing_if = "Option::is_none")]
    pub object_id_conflict: Option<String>,
    #[serde(rename = "samAccountName", default, skip_serializing_if = "Option::is_none")]
    pub sam_account_name: Option<String>,
    #[serde(rename = "adObjectType", default, skip_serializing_if = "Option::is_none")]
    pub ad_object_type: Option<String>,
    #[serde(rename = "adObjectGuid", default, skip_serializing_if = "Option::is_none")]
    pub ad_object_guid: Option<String>,
    #[serde(rename = "adDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub ad_display_name: Option<String>,
    #[serde(rename = "adSourceOfAuthority", default, skip_serializing_if = "Option::is_none")]
    pub ad_source_of_authority: Option<String>,
    #[serde(rename = "adSourceAnchor", default, skip_serializing_if = "Option::is_none")]
    pub ad_source_anchor: Option<String>,
    #[serde(rename = "adUserPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub ad_user_principal_name: Option<String>,
    #[serde(rename = "adDistinguishedName", default, skip_serializing_if = "Option::is_none")]
    pub ad_distinguished_name: Option<String>,
    #[serde(rename = "adMail", default, skip_serializing_if = "Option::is_none")]
    pub ad_mail: Option<String>,
    #[serde(rename = "timeOccured", default, skip_serializing_if = "Option::is_none")]
    pub time_occured: Option<String>,
    #[serde(rename = "aadObjectType", default, skip_serializing_if = "Option::is_none")]
    pub aad_object_type: Option<String>,
    #[serde(rename = "aadObjectGuid", default, skip_serializing_if = "Option::is_none")]
    pub aad_object_guid: Option<String>,
    #[serde(rename = "aadDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub aad_display_name: Option<String>,
    #[serde(rename = "aadSourceOfAuthority", default, skip_serializing_if = "Option::is_none")]
    pub aad_source_of_authority: Option<String>,
    #[serde(rename = "aadUserPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub aad_user_principal_name: Option<String>,
    #[serde(rename = "aadDistinguishedName", default, skip_serializing_if = "Option::is_none")]
    pub aad_distinguished_name: Option<String>,
    #[serde(rename = "aadMail", default, skip_serializing_if = "Option::is_none")]
    pub aad_mail: Option<String>,
    #[serde(rename = "lastDirSyncTime", default, skip_serializing_if = "Option::is_none")]
    pub last_dir_sync_time: Option<String>,
    #[serde(rename = "modifiedAttributeValue", default, skip_serializing_if = "Option::is_none")]
    pub modified_attribute_value: Option<String>,
}
impl ExportError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportErrors {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExportError>,
}
impl ExportErrors {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportStatus {
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "serviceMemberId", default, skip_serializing_if = "Option::is_none")]
    pub service_member_id: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "runStepResultId", default, skip_serializing_if = "Option::is_none")]
    pub run_step_result_id: Option<String>,
}
impl ExportStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportStatuses {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExportStatus>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl ExportStatuses {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtensionErrorInfo {
    #[serde(rename = "extensionName", default, skip_serializing_if = "Option::is_none")]
    pub extension_name: Option<String>,
    #[serde(rename = "extensionContext", default, skip_serializing_if = "Option::is_none")]
    pub extension_context: Option<String>,
    #[serde(rename = "callStack", default, skip_serializing_if = "Option::is_none")]
    pub call_stack: Option<String>,
}
impl ExtensionErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ForestSummary {
    #[serde(rename = "forestName", default, skip_serializing_if = "Option::is_none")]
    pub forest_name: Option<String>,
    #[serde(rename = "domainCount", default, skip_serializing_if = "Option::is_none")]
    pub domain_count: Option<i64>,
    #[serde(rename = "siteCount", default, skip_serializing_if = "Option::is_none")]
    pub site_count: Option<i64>,
    #[serde(rename = "monitoredDcCount", default, skip_serializing_if = "Option::is_none")]
    pub monitored_dc_count: Option<i64>,
    #[serde(rename = "totalDcCount", default, skip_serializing_if = "Option::is_none")]
    pub total_dc_count: Option<i64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub domains: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sites: Vec<String>,
}
impl ForestSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GlobalConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
    #[serde(rename = "schemaXml", default, skip_serializing_if = "Option::is_none")]
    pub schema_xml: Option<String>,
    #[serde(rename = "passwordSyncEnabled", default, skip_serializing_if = "Option::is_none")]
    pub password_sync_enabled: Option<bool>,
    #[serde(rename = "numSavedPwdEvent", default, skip_serializing_if = "Option::is_none")]
    pub num_saved_pwd_event: Option<i64>,
    #[serde(rename = "featureSet", default, skip_serializing_if = "Vec::is_empty")]
    pub feature_set: Vec<Item>,
}
impl GlobalConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GlobalConfigurations {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GlobalConfiguration>,
}
impl GlobalConfigurations {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HelpLink {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl HelpLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Hotfix {
    #[serde(rename = "kbName", default, skip_serializing_if = "Option::is_none")]
    pub kb_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[serde(rename = "installedDate", default, skip_serializing_if = "Option::is_none")]
    pub installed_date: Option<String>,
}
impl Hotfix {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Hotfixes {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Hotfix>,
}
impl Hotfixes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressAggregate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "firstAuditTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub first_audit_timestamp: Option<String>,
    #[serde(rename = "lastAuditTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub last_audit_timestamp: Option<String>,
    #[serde(rename = "extranetLockoutErrorCount", default, skip_serializing_if = "Option::is_none")]
    pub extranet_lockout_error_count: Option<i64>,
    #[serde(rename = "badPasswordErrorCount", default, skip_serializing_if = "Option::is_none")]
    pub bad_password_error_count: Option<i64>,
    #[serde(rename = "uniqueUsernamesAttemptedCount", default, skip_serializing_if = "Option::is_none")]
    pub unique_usernames_attempted_count: Option<i64>,
    #[serde(rename = "attemptCountThresholdIsExceeded", default, skip_serializing_if = "Option::is_none")]
    pub attempt_count_threshold_is_exceeded: Option<bool>,
    #[serde(rename = "timeSpan", default, skip_serializing_if = "Option::is_none")]
    pub time_span: Option<String>,
    #[serde(rename = "isWhitelistedIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub is_whitelisted_ip_address: Option<bool>,
    #[serde(rename = "networkLocation", default, skip_serializing_if = "Option::is_none")]
    pub network_location: Option<String>,
    #[serde(rename = "attemptCountThresholdOnTrigger", default, skip_serializing_if = "Option::is_none")]
    pub attempt_count_threshold_on_trigger: Option<i64>,
    #[serde(rename = "attemptThresholdTypeOnTrigger", default, skip_serializing_if = "Option::is_none")]
    pub attempt_threshold_type_on_trigger: Option<String>,
    #[serde(rename = "geographicLocation", default, skip_serializing_if = "Option::is_none")]
    pub geographic_location: Option<String>,
}
impl IpAddressAggregate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressAggregateSetting {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(
        rename = "badPasswordAndExtranetLockoutCombinedDailyThreshold",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub bad_password_and_extranet_lockout_combined_daily_threshold: Option<i64>,
    #[serde(
        rename = "badPasswordAndExtranetLockoutCombinedHourlyThreshold",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub bad_password_and_extranet_lockout_combined_hourly_threshold: Option<i64>,
    #[serde(rename = "extranetLockoutDailyThreshold", default, skip_serializing_if = "Option::is_none")]
    pub extranet_lockout_daily_threshold: Option<i64>,
    #[serde(rename = "extranetLockoutHourlyThreshold", default, skip_serializing_if = "Option::is_none")]
    pub extranet_lockout_hourly_threshold: Option<i64>,
    #[serde(rename = "emailNotificationEnabled", default, skip_serializing_if = "Option::is_none")]
    pub email_notification_enabled: Option<bool>,
}
impl IpAddressAggregateSetting {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressAggregates {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IpAddressAggregate>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl IpAddressAggregates {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "runStepResultId", default, skip_serializing_if = "Option::is_none")]
    pub run_step_result_id: Option<String>,
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "timeOccurred", default, skip_serializing_if = "Option::is_none")]
    pub time_occurred: Option<String>,
    #[serde(rename = "timeFirstOccurred", default, skip_serializing_if = "Option::is_none")]
    pub time_first_occurred: Option<String>,
    #[serde(rename = "retryCount", default, skip_serializing_if = "Option::is_none")]
    pub retry_count: Option<i64>,
    #[serde(rename = "algorithmStepType", default, skip_serializing_if = "Option::is_none")]
    pub algorithm_step_type: Option<import_error::AlgorithmStepType>,
    #[serde(rename = "changeNotReimported", default, skip_serializing_if = "Option::is_none")]
    pub change_not_reimported: Option<ChangeNotReimported>,
    #[serde(rename = "extensionErrorInfo", default, skip_serializing_if = "Option::is_none")]
    pub extension_error_info: Option<ExtensionErrorInfo>,
    #[serde(rename = "ruleErrorInfo", default, skip_serializing_if = "Option::is_none")]
    pub rule_error_info: Option<RuleErrorInfo>,
    #[serde(rename = "csObjectId", default, skip_serializing_if = "Option::is_none")]
    pub cs_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dn: Option<String>,
}
impl ImportError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod import_error {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AlgorithmStepType {
        Undefined,
        Staging,
        ConnectorFilter,
        Join,
        Projection,
        ImportFlow,
        Provisioning,
        ValidateConnectorFilter,
        Deprovisioning,
        ExportFlow,
        MvDeletion,
        Recall,
        MvObjectTypeChange,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportErrors {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ImportError>,
}
impl ImportErrors {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundReplicationNeighbor {
    #[serde(rename = "sourceDomainController", default, skip_serializing_if = "Option::is_none")]
    pub source_domain_controller: Option<String>,
    #[serde(rename = "consecutiveFailureCount", default, skip_serializing_if = "Option::is_none")]
    pub consecutive_failure_count: Option<i64>,
    #[serde(rename = "namingContext", default, skip_serializing_if = "Option::is_none")]
    pub naming_context: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<i64>,
    #[serde(rename = "lastAttemptedSync", default, skip_serializing_if = "Option::is_none")]
    pub last_attempted_sync: Option<String>,
    #[serde(rename = "lastSuccessfulSync", default, skip_serializing_if = "Option::is_none")]
    pub last_successful_sync: Option<String>,
    #[serde(rename = "lastErrorCode", default, skip_serializing_if = "Option::is_none")]
    pub last_error_code: Option<i64>,
    #[serde(rename = "lastErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub last_error_message: Option<String>,
    #[serde(rename = "errorTitle", default, skip_serializing_if = "Option::is_none")]
    pub error_title: Option<String>,
    #[serde(rename = "errorDescription", default, skip_serializing_if = "Option::is_none")]
    pub error_description: Option<String>,
    #[serde(rename = "fixLink", default, skip_serializing_if = "Option::is_none")]
    pub fix_link: Option<String>,
    #[serde(rename = "fixDetails", default, skip_serializing_if = "Option::is_none")]
    pub fix_details: Option<String>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub additional_info: Option<String>,
}
impl InboundReplicationNeighbor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundReplicationNeighbors {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<InboundReplicationNeighbor>,
}
impl InboundReplicationNeighbors {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Item {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl Item {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Items {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Item>,
}
impl Items {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MergedExportError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "incomingObjectDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub incoming_object_display_name: Option<String>,
    #[serde(rename = "incomingObjectType", default, skip_serializing_if = "Option::is_none")]
    pub incoming_object_type: Option<String>,
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "attributeName", default, skip_serializing_if = "Option::is_none")]
    pub attribute_name: Option<String>,
    #[serde(rename = "attributeValue", default, skip_serializing_if = "Option::is_none")]
    pub attribute_value: Option<String>,
    #[serde(rename = "timeOccurred", default, skip_serializing_if = "Option::is_none")]
    pub time_occurred: Option<String>,
    #[serde(rename = "timeFirstOccurred", default, skip_serializing_if = "Option::is_none")]
    pub time_first_occurred: Option<String>,
    #[serde(rename = "csObjectId", default, skip_serializing_if = "Option::is_none")]
    pub cs_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dn: Option<String>,
    #[serde(rename = "incomingObject", default, skip_serializing_if = "Option::is_none")]
    pub incoming_object: Option<AssociatedObject>,
    #[serde(rename = "existingObject", default, skip_serializing_if = "Option::is_none")]
    pub existing_object: Option<AssociatedObject>,
    #[serde(rename = "modifiedOrRemovedAttributeValue", default, skip_serializing_if = "Option::is_none")]
    pub modified_or_removed_attribute_value: Option<String>,
    #[serde(rename = "runStepResultId", default, skip_serializing_if = "Option::is_none")]
    pub run_step_result_id: Option<String>,
    #[serde(rename = "samAccountName", default, skip_serializing_if = "Option::is_none")]
    pub sam_account_name: Option<String>,
    #[serde(rename = "serverErrorDetail", default, skip_serializing_if = "Option::is_none")]
    pub server_error_detail: Option<String>,
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "serviceMemberId", default, skip_serializing_if = "Option::is_none")]
    pub service_member_id: Option<String>,
    #[serde(rename = "mergedEntityId", default, skip_serializing_if = "Option::is_none")]
    pub merged_entity_id: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "exportErrorStatus", default, skip_serializing_if = "Option::is_none")]
    pub export_error_status: Option<i64>,
}
impl MergedExportError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MergedExportErrors {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MergedExportError>,
}
impl MergedExportErrors {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricGroup {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "invisibleForUi", default, skip_serializing_if = "Option::is_none")]
    pub invisible_for_ui: Option<bool>,
}
impl MetricGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricMetadata {
    #[serde(rename = "metricsProcessorClassName", default, skip_serializing_if = "Option::is_none")]
    pub metrics_processor_class_name: Option<String>,
    #[serde(rename = "metricName", default, skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groupings: Vec<MetricGroup>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "valueKind", default, skip_serializing_if = "Option::is_none")]
    pub value_kind: Option<String>,
    #[serde(rename = "minValue", default, skip_serializing_if = "Option::is_none")]
    pub min_value: Option<i64>,
    #[serde(rename = "maxValue", default, skip_serializing_if = "Option::is_none")]
    pub max_value: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[serde(rename = "isPerfCounter", default, skip_serializing_if = "Option::is_none")]
    pub is_perf_counter: Option<bool>,
    #[serde(rename = "isDevOps", default, skip_serializing_if = "Option::is_none")]
    pub is_dev_ops: Option<bool>,
}
impl MetricMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricMetadataList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MetricMetadata>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl MetricMetadataList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSet {
    #[serde(rename = "setName", default, skip_serializing_if = "Option::is_none")]
    pub set_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<i64>,
}
impl MetricSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSets {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sets: Vec<MetricSet>,
    #[serde(rename = "timeStamps", default, skip_serializing_if = "Vec::is_empty")]
    pub time_stamps: Vec<String>,
}
impl MetricSets {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Metrics {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Item>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl Metrics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModuleConfiguration {
    #[serde(rename = "agentService", default, skip_serializing_if = "Option::is_none")]
    pub agent_service: Option<String>,
    #[serde(rename = "moduleName", default, skip_serializing_if = "Option::is_none")]
    pub module_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl ModuleConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModuleConfigurations {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ModuleConfiguration>,
}
impl ModuleConfigurations {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ObjectWithSyncError {
    #[serde(rename = "sourceOfAuthority", default, skip_serializing_if = "Option::is_none")]
    pub source_of_authority: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "objectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "attributeName", default, skip_serializing_if = "Option::is_none")]
    pub attribute_name: Option<String>,
    #[serde(rename = "attributeValue", default, skip_serializing_if = "Option::is_none")]
    pub attribute_value: Option<String>,
    #[serde(rename = "modififedValue", default, skip_serializing_if = "Option::is_none")]
    pub modififed_value: Option<String>,
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
    #[serde(rename = "objectGuid", default, skip_serializing_if = "Option::is_none")]
    pub object_guid: Option<String>,
    #[serde(rename = "attributeMultiValues", default, skip_serializing_if = "Option::is_none")]
    pub attribute_multi_values: Option<bool>,
    #[serde(rename = "minLimit", default, skip_serializing_if = "Option::is_none")]
    pub min_limit: Option<String>,
    #[serde(rename = "maxLimit", default, skip_serializing_if = "Option::is_none")]
    pub max_limit: Option<String>,
    #[serde(rename = "distinguishedName", default, skip_serializing_if = "Option::is_none")]
    pub distinguished_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mail: Option<String>,
    #[serde(rename = "timeOccured", default, skip_serializing_if = "Option::is_none")]
    pub time_occured: Option<String>,
    #[serde(rename = "errorType", default, skip_serializing_if = "Option::is_none")]
    pub error_type: Option<String>,
    #[serde(rename = "sourceAnchor", default, skip_serializing_if = "Option::is_none")]
    pub source_anchor: Option<String>,
}
impl ObjectWithSyncError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<serde_json::Value>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResponse {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl OperationListResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Partition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dn: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "timeCreated", default, skip_serializing_if = "Option::is_none")]
    pub time_created: Option<String>,
    #[serde(rename = "timeLastModified", default, skip_serializing_if = "Option::is_none")]
    pub time_last_modified: Option<String>,
    #[serde(rename = "partitionScope", default, skip_serializing_if = "Option::is_none")]
    pub partition_scope: Option<PartitionScope>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "isDomain", default, skip_serializing_if = "Option::is_none")]
    pub is_domain: Option<bool>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Partition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PartitionScope {
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[serde(rename = "objectClasses", default, skip_serializing_if = "Vec::is_empty")]
    pub object_classes: Vec<String>,
    #[serde(rename = "containersIncluded", default, skip_serializing_if = "Vec::is_empty")]
    pub containers_included: Vec<String>,
    #[serde(rename = "containersExcluded", default, skip_serializing_if = "Vec::is_empty")]
    pub containers_excluded: Vec<String>,
}
impl PartitionScope {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PasswordHashSyncConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl PasswordHashSyncConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PasswordManagementSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "extensionFilePath", default, skip_serializing_if = "Option::is_none")]
    pub extension_file_path: Option<String>,
    #[serde(rename = "connectTo", default, skip_serializing_if = "Option::is_none")]
    pub connect_to: Option<String>,
    #[serde(rename = "connectionTimeout", default, skip_serializing_if = "Option::is_none")]
    pub connection_timeout: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub user: Option<String>,
    #[serde(rename = "supportedPasswordOperations", default, skip_serializing_if = "Option::is_none")]
    pub supported_password_operations: Option<password_management_settings::SupportedPasswordOperations>,
    #[serde(rename = "maximumRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub maximum_retry_count: Option<i64>,
    #[serde(rename = "retryIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub retry_interval_in_seconds: Option<i64>,
    #[serde(rename = "requiresSecureConnection", default, skip_serializing_if = "Option::is_none")]
    pub requires_secure_connection: Option<bool>,
    #[serde(rename = "unlockAccount", default, skip_serializing_if = "Option::is_none")]
    pub unlock_account: Option<bool>,
}
impl PasswordManagementSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod password_management_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SupportedPasswordOperations {
        Undefined,
        Set,
        Change,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationDetailsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReplicationSummary>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ReplicationDetailsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationStatus {
    #[serde(rename = "forestName", default, skip_serializing_if = "Option::is_none")]
    pub forest_name: Option<String>,
    #[serde(rename = "totalDcCount", default, skip_serializing_if = "Option::is_none")]
    pub total_dc_count: Option<i64>,
    #[serde(rename = "errorDcCount", default, skip_serializing_if = "Option::is_none")]
    pub error_dc_count: Option<i64>,
}
impl ReplicationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationSummary {
    #[serde(rename = "targetServer", default, skip_serializing_if = "Option::is_none")]
    pub target_server: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub site: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub domain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<i64>,
    #[serde(rename = "lastAttemptedSync", default, skip_serializing_if = "Option::is_none")]
    pub last_attempted_sync: Option<String>,
    #[serde(rename = "lastSuccessfulSync", default, skip_serializing_if = "Option::is_none")]
    pub last_successful_sync: Option<String>,
    #[serde(rename = "inboundNeighborCollection", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_neighbor_collection: Vec<InboundReplicationNeighbor>,
}
impl ReplicationSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationSummaryList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReplicationSummary>,
}
impl ReplicationSummaryList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Result {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<bool>,
}
impl Result {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RiskyIpBlobUri {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "resultSasUri", default, skip_serializing_if = "Option::is_none")]
    pub result_sas_uri: Option<String>,
    #[serde(rename = "blobCreateDateTime", default, skip_serializing_if = "Option::is_none")]
    pub blob_create_date_time: Option<String>,
    #[serde(rename = "jobCompletionTime", default, skip_serializing_if = "Option::is_none")]
    pub job_completion_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl RiskyIpBlobUri {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RiskyIpBlobUris {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RiskyIpBlobUri>,
}
impl RiskyIpBlobUris {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleErrorInfo {
    #[serde(rename = "attributeMapping", default, skip_serializing_if = "Option::is_none")]
    pub attribute_mapping: Option<AttributeMapping>,
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(rename = "connectorName", default, skip_serializing_if = "Option::is_none")]
    pub connector_name: Option<String>,
    #[serde(rename = "csObjectId", default, skip_serializing_if = "Option::is_none")]
    pub cs_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dn: Option<String>,
}
impl RuleErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunProfile {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "runSteps", default, skip_serializing_if = "Vec::is_empty")]
    pub run_steps: Vec<RunStep>,
}
impl RunProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunProfiles {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RunProfile>,
}
impl RunProfiles {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunStep {
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<i64>,
    #[serde(rename = "objectProcessLimit", default, skip_serializing_if = "Option::is_none")]
    pub object_process_limit: Option<i64>,
    #[serde(rename = "objectDeleteLimit", default, skip_serializing_if = "Option::is_none")]
    pub object_delete_limit: Option<i64>,
    #[serde(rename = "pageSize", default, skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i64>,
    #[serde(rename = "partitionId", default, skip_serializing_if = "Option::is_none")]
    pub partition_id: Option<String>,
    #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
    pub operation_type: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i64>,
}
impl RunStep {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "serviceType", default, skip_serializing_if = "Option::is_none")]
    pub service_type: Option<i64>,
    #[serde(rename = "serviceAccount", default, skip_serializing_if = "Option::is_none")]
    pub service_account: Option<String>,
    #[serde(rename = "sqlServer", default, skip_serializing_if = "Option::is_none")]
    pub sql_server: Option<String>,
    #[serde(rename = "sqlVersion", default, skip_serializing_if = "Option::is_none")]
    pub sql_version: Option<String>,
    #[serde(rename = "sqlEdition", default, skip_serializing_if = "Option::is_none")]
    pub sql_edition: Option<String>,
    #[serde(rename = "sqlInstance", default, skip_serializing_if = "Option::is_none")]
    pub sql_instance: Option<String>,
    #[serde(rename = "sqlDatabaseName", default, skip_serializing_if = "Option::is_none")]
    pub sql_database_name: Option<String>,
    #[serde(rename = "sqlDatabaseSize", default, skip_serializing_if = "Option::is_none")]
    pub sql_database_size: Option<i64>,
}
impl ServiceConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceMember {
    #[serde(rename = "serviceMemberId", default, skip_serializing_if = "Option::is_none")]
    pub service_member_id: Option<String>,
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "activeAlerts", default, skip_serializing_if = "Option::is_none")]
    pub active_alerts: Option<i64>,
    #[serde(rename = "additionalInformation", default, skip_serializing_if = "Option::is_none")]
    pub additional_information: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dimensions: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    #[serde(rename = "disabledReason", default, skip_serializing_if = "Option::is_none")]
    pub disabled_reason: Option<i64>,
    #[serde(rename = "installedQfes", default, skip_serializing_if = "Option::is_none")]
    pub installed_qfes: Option<serde_json::Value>,
    #[serde(rename = "lastDisabled", default, skip_serializing_if = "Option::is_none")]
    pub last_disabled: Option<String>,
    #[serde(rename = "lastReboot", default, skip_serializing_if = "Option::is_none")]
    pub last_reboot: Option<String>,
    #[serde(
        rename = "lastServerReportedMonitoringLevelChange",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub last_server_reported_monitoring_level_change: Option<String>,
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[serde(rename = "machineId", default, skip_serializing_if = "Option::is_none")]
    pub machine_id: Option<String>,
    #[serde(rename = "machineName", default, skip_serializing_if = "Option::is_none")]
    pub machine_name: Option<String>,
    #[serde(rename = "monitoringConfigurationsComputed", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_configurations_computed: Option<serde_json::Value>,
    #[serde(rename = "monitoringConfigurationsCustomized", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_configurations_customized: Option<serde_json::Value>,
    #[serde(rename = "osName", default, skip_serializing_if = "Option::is_none")]
    pub os_name: Option<String>,
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(rename = "recommendedQfes", default, skip_serializing_if = "Option::is_none")]
    pub recommended_qfes: Option<serde_json::Value>,
    #[serde(rename = "resolvedAlerts", default, skip_serializing_if = "Option::is_none")]
    pub resolved_alerts: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub role: Option<String>,
    #[serde(rename = "serverReportedMonitoringLevel", default, skip_serializing_if = "Option::is_none")]
    pub server_reported_monitoring_level: Option<service_member::ServerReportedMonitoringLevel>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl ServiceMember {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod service_member {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServerReportedMonitoringLevel {
        Partial,
        Full,
        Off,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceMembers {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceMember>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl ServiceMembers {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "activeAlerts", default, skip_serializing_if = "Option::is_none")]
    pub active_alerts: Option<i64>,
    #[serde(rename = "additionalInformation", default, skip_serializing_if = "Option::is_none")]
    pub additional_information: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "customNotificationEmails", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_notification_emails: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<String>,
    #[serde(rename = "lastDisabled", default, skip_serializing_if = "Option::is_none")]
    pub last_disabled: Option<String>,
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[serde(rename = "monitoringConfigurationsComputed", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_configurations_computed: Option<serde_json::Value>,
    #[serde(rename = "monitoringConfigurationsCustomized", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_configurations_customized: Option<serde_json::Value>,
    #[serde(rename = "notificationEmailEnabled", default, skip_serializing_if = "Option::is_none")]
    pub notification_email_enabled: Option<bool>,
    #[serde(
        rename = "notificationEmailEnabledForGlobalAdmins",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub notification_email_enabled_for_global_admins: Option<bool>,
    #[serde(
        rename = "notificationEmailsEnabledForGlobalAdmins",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub notification_emails_enabled_for_global_admins: Option<bool>,
    #[serde(rename = "notificationEmails", default, skip_serializing_if = "Vec::is_empty")]
    pub notification_emails: Vec<String>,
    #[serde(rename = "originalDisabledState", default, skip_serializing_if = "Option::is_none")]
    pub original_disabled_state: Option<bool>,
    #[serde(rename = "resolvedAlerts", default, skip_serializing_if = "Option::is_none")]
    pub resolved_alerts: Option<i64>,
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub signature: Option<String>,
    #[serde(rename = "simpleProperties", default, skip_serializing_if = "Option::is_none")]
    pub simple_properties: Option<serde_json::Value>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ServiceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Services {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceProperties>,
    #[serde(rename = "totalCount", default, skip_serializing_if = "Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl Services {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TabularExportError {
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "serviceMemberId", default, skip_serializing_if = "Option::is_none")]
    pub service_member_id: Option<String>,
    #[serde(rename = "mergedEntityId", default, skip_serializing_if = "Option::is_none")]
    pub merged_entity_id: Option<String>,
    #[serde(rename = "tabularExportErrorData", default, skip_serializing_if = "Option::is_none")]
    pub tabular_export_error_data: Option<String>,
}
impl TabularExportError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Tenant {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "aadLicense", default, skip_serializing_if = "Option::is_none")]
    pub aad_license: Option<String>,
    #[serde(rename = "aadPremium", default, skip_serializing_if = "Option::is_none")]
    pub aad_premium: Option<bool>,
    #[serde(rename = "agentAutoUpdate", default, skip_serializing_if = "Option::is_none")]
    pub agent_auto_update: Option<bool>,
    #[serde(rename = "alertSuppressionTimeInMins", default, skip_serializing_if = "Option::is_none")]
    pub alert_suppression_time_in_mins: Option<i64>,
    #[serde(rename = "consentedToMicrosoftDevOps", default, skip_serializing_if = "Option::is_none")]
    pub consented_to_microsoft_dev_ops: Option<bool>,
    #[serde(rename = "countryLetterCode", default, skip_serializing_if = "Option::is_none")]
    pub country_letter_code: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "devOpsTtl", default, skip_serializing_if = "Option::is_none")]
    pub dev_ops_ttl: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
    #[serde(rename = "disabledReason", default, skip_serializing_if = "Option::is_none")]
    pub disabled_reason: Option<i64>,
    #[serde(rename = "globalAdminsEmail", default, skip_serializing_if = "Vec::is_empty")]
    pub global_admins_email: Vec<String>,
    #[serde(rename = "initialDomain", default, skip_serializing_if = "Option::is_none")]
    pub initial_domain: Option<String>,
    #[serde(rename = "lastDisabled", default, skip_serializing_if = "Option::is_none")]
    pub last_disabled: Option<String>,
    #[serde(rename = "lastVerified", default, skip_serializing_if = "Option::is_none")]
    pub last_verified: Option<String>,
    #[serde(rename = "onboardingAllowed", default, skip_serializing_if = "Option::is_none")]
    pub onboarding_allowed: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub onboarded: Option<bool>,
    #[serde(rename = "pksCertificate", default, skip_serializing_if = "Option::is_none")]
    pub pks_certificate: Option<serde_json::Value>,
    #[serde(rename = "privatePreviewTenant", default, skip_serializing_if = "Option::is_none")]
    pub private_preview_tenant: Option<bool>,
    #[serde(rename = "tenantInQuarantine", default, skip_serializing_if = "Option::is_none")]
    pub tenant_in_quarantine: Option<bool>,
    #[serde(rename = "tenantName", default, skip_serializing_if = "Option::is_none")]
    pub tenant_name: Option<String>,
}
impl Tenant {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TenantOnboardingDetails {
    #[serde(rename = "tenantOnboarded", default, skip_serializing_if = "Option::is_none")]
    pub tenant_onboarded: Option<bool>,
    #[serde(rename = "onboardingDisplayUrl", default, skip_serializing_if = "Option::is_none")]
    pub onboarding_display_url: Option<String>,
}
impl TenantOnboardingDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserPreference {
    #[serde(rename = "metricNames", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_names: Vec<String>,
}
impl UserPreference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValueDelta {
    #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
    pub operation_type: Option<value_delta::OperationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ValueDelta {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod value_delta {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationType {
        Undefined,
        Add,
        Update,
        Delete,
    }
}
