#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
pub type CanonicalSupportPlanInfo = Vec<CanonicalSupportPlanInfoDefinition>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CanonicalSupportPlanInfoDefinition {
    #[serde(rename = "supportPlanType", default, skip_serializing_if = "Option::is_none")]
    pub support_plan_type: Option<canonical_support_plan_info_definition::SupportPlanType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "oneTimeCharge", default, skip_serializing_if = "Option::is_none")]
    pub one_time_charge: Option<canonical_support_plan_info_definition::OneTimeCharge>,
}
impl CanonicalSupportPlanInfoDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod canonical_support_plan_info_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SupportPlanType {
        #[serde(rename = "essential")]
        Essential,
        #[serde(rename = "standard")]
        Standard,
        #[serde(rename = "advanced")]
        Advanced,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OneTimeCharge {
        #[serde(rename = "no")]
        No,
        #[serde(rename = "onEnabled")]
        OnEnabled,
        #[serde(rename = "onReenabled")]
        OnReenabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CanonicalSupportPlanProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<canonical_support_plan_properties::ProvisioningState>,
}
impl CanonicalSupportPlanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod canonical_support_plan_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Failed,
        Cancelled,
        Purchasing,
        Downgrading,
        Cancelling,
        Upgrading,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CanonicalSupportPlanResponseEnvelope {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub properties: CanonicalSupportPlanProperties,
}
impl CanonicalSupportPlanResponseEnvelope {
    pub fn new(properties: CanonicalSupportPlanProperties) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorDefinition {
    pub message: String,
    pub code: String,
}
impl ErrorDefinition {
    pub fn new(message: String, code: String) -> Self {
        Self { message, code }
    }
}
pub type OperationList = Vec<OperationsDefinition>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListValue {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<OperationList>,
}
impl OperationListValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationsDisplayDefinition>,
}
impl OperationsDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsDisplayDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationsDisplayDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
