/// AUTO GENERATED BY build.rs

use std::collections::HashMap;

use webrender_build::shader::ShaderVersion;

pub struct SourceWithDigest {
    pub source: &'static str,
    pub digest: &'static str,
}

pub struct OptimizedSourceWithDigest {
    pub vert_source: &'static str,
    pub frag_source: &'static str,
    pub digest: &'static str,
}

lazy_static! {
  pub static ref UNOPTIMIZED_SHADERS: HashMap<&'static str, SourceWithDigest> = {
    let mut shaders = HashMap::new();
    shaders.insert("base", SourceWithDigest { source: include_str!("./res/base.glsl"), digest: "d5ae695bab268b7d"});
    shaders.insert("blend", SourceWithDigest { source: include_str!("./res/blend.glsl"), digest: "1c6f6f2578877c93"});
    shaders.insert("brush", SourceWithDigest { source: include_str!("./res/brush.glsl"), digest: "fda195c2df7fbecd"});
    shaders.insert("brush_blend", SourceWithDigest { source: include_str!("./res/brush_blend.glsl"), digest: "3592aea82964e454"});
    shaders.insert("brush_image", SourceWithDigest { source: include_str!("./res/brush_image.glsl"), digest: "16b6de2284d6239d"});
    shaders.insert("brush_linear_gradient", SourceWithDigest { source: include_str!("./res/brush_linear_gradient.glsl"), digest: "370892f4559a82f0"});
    shaders.insert("brush_mix_blend", SourceWithDigest { source: include_str!("./res/brush_mix_blend.glsl"), digest: "dbe849fb27ba1db8"});
    shaders.insert("brush_opacity", SourceWithDigest { source: include_str!("./res/brush_opacity.glsl"), digest: "e4e711e57ee2ac3b"});
    shaders.insert("brush_solid", SourceWithDigest { source: include_str!("./res/brush_solid.glsl"), digest: "7d970a2ce0129d96"});
    shaders.insert("brush_yuv_image", SourceWithDigest { source: include_str!("./res/brush_yuv_image.glsl"), digest: "46deb9c6c8b54ecd"});
    shaders.insert("clip_shared", SourceWithDigest { source: include_str!("./res/clip_shared.glsl"), digest: "34b82ef3ac08b8a2"});
    shaders.insert("composite", SourceWithDigest { source: include_str!("./res/composite.glsl"), digest: "4b265dbbc9a52330"});
    shaders.insert("cs_blur", SourceWithDigest { source: include_str!("./res/cs_blur.glsl"), digest: "93d704aed94a9f5b"});
    shaders.insert("cs_border_segment", SourceWithDigest { source: include_str!("./res/cs_border_segment.glsl"), digest: "bd7b3c75683fe343"});
    shaders.insert("cs_border_solid", SourceWithDigest { source: include_str!("./res/cs_border_solid.glsl"), digest: "5961eb63cbaacec9"});
    shaders.insert("cs_clip_box_shadow", SourceWithDigest { source: include_str!("./res/cs_clip_box_shadow.glsl"), digest: "96bd5eb5871cee29"});
    shaders.insert("cs_clip_image", SourceWithDigest { source: include_str!("./res/cs_clip_image.glsl"), digest: "504659a9c88b9d62"});
    shaders.insert("cs_clip_rectangle", SourceWithDigest { source: include_str!("./res/cs_clip_rectangle.glsl"), digest: "31b40813e39a8834"});
    shaders.insert("cs_conic_gradient", SourceWithDigest { source: include_str!("./res/cs_conic_gradient.glsl"), digest: "36d37cf33b997e50"});
    shaders.insert("cs_fast_linear_gradient", SourceWithDigest { source: include_str!("./res/cs_fast_linear_gradient.glsl"), digest: "d9a1e5db0fd6c5d2"});
    shaders.insert("cs_line_decoration", SourceWithDigest { source: include_str!("./res/cs_line_decoration.glsl"), digest: "1fb346eddb175ef0"});
    shaders.insert("cs_linear_gradient", SourceWithDigest { source: include_str!("./res/cs_linear_gradient.glsl"), digest: "3863c2c3f4ed0b91"});
    shaders.insert("cs_radial_gradient", SourceWithDigest { source: include_str!("./res/cs_radial_gradient.glsl"), digest: "fe21c35ecdacb093"});
    shaders.insert("cs_scale", SourceWithDigest { source: include_str!("./res/cs_scale.glsl"), digest: "fc6709e353349d1e"});
    shaders.insert("cs_svg_filter", SourceWithDigest { source: include_str!("./res/cs_svg_filter.glsl"), digest: "9a3ecac2dc865431"});
    shaders.insert("debug_color", SourceWithDigest { source: include_str!("./res/debug_color.glsl"), digest: "2f9261e057bd8448"});
    shaders.insert("debug_font", SourceWithDigest { source: include_str!("./res/debug_font.glsl"), digest: "738d28322b4c39c6"});
    shaders.insert("ellipse", SourceWithDigest { source: include_str!("./res/ellipse.glsl"), digest: "1883f224293b6515"});
    shaders.insert("gpu_cache", SourceWithDigest { source: include_str!("./res/gpu_cache.glsl"), digest: "e99b57d9cc26406a"});
    shaders.insert("gpu_cache_update", SourceWithDigest { source: include_str!("./res/gpu_cache_update.glsl"), digest: "208078c3cbd97aa7"});
    shaders.insert("gradient", SourceWithDigest { source: include_str!("./res/gradient.glsl"), digest: "c53f998c85cc0414"});
    shaders.insert("gradient_shared", SourceWithDigest { source: include_str!("./res/gradient_shared.glsl"), digest: "4a24fb3e35fdbe06"});
    shaders.insert("prim_shared", SourceWithDigest { source: include_str!("./res/prim_shared.glsl"), digest: "871a865d0292f40c"});
    shaders.insert("ps_clear", SourceWithDigest { source: include_str!("./res/ps_clear.glsl"), digest: "81dbbdcf6f3326c5"});
    shaders.insert("ps_split_composite", SourceWithDigest { source: include_str!("./res/ps_split_composite.glsl"), digest: "e24e70dc915930a9"});
    shaders.insert("ps_text_run", SourceWithDigest { source: include_str!("./res/ps_text_run.glsl"), digest: "ef8508d13282da15"});
    shaders.insert("rect", SourceWithDigest { source: include_str!("./res/rect.glsl"), digest: "4f129d4925591d33"});
    shaders.insert("render_task", SourceWithDigest { source: include_str!("./res/render_task.glsl"), digest: "c4574b7a23485833"});
    shaders.insert("shared", SourceWithDigest { source: include_str!("./res/shared.glsl"), digest: "4c69e477c1a90ece"});
    shaders.insert("shared_other", SourceWithDigest { source: include_str!("./res/shared_other.glsl"), digest: "9f6298a27dfe79c6"});
    shaders.insert("transform", SourceWithDigest { source: include_str!("./res/transform.glsl"), digest: "c783752dc8c02e55"});
    shaders.insert("yuv", SourceWithDigest { source: include_str!("./res/yuv.glsl"), digest: "131e800777417171"});
    shaders
  };

  pub static ref OPTIMIZED_SHADERS: HashMap<(ShaderVersion, &'static str), OptimizedSourceWithDigest> = {
    let mut shaders = HashMap::new();
    shaders.insert((ShaderVersion::Gles, "brush_blend"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_blend_Gles.vert"),
        frag_source: include_str!("./brush_blend_Gles.frag"),
        digest: "9b816aef9fa301d6",
    });
    shaders.insert((ShaderVersion::Gles, "brush_blend_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_blend_ALPHA_PASS_Gles.vert"),
        frag_source: include_str!("./brush_blend_ALPHA_PASS_Gles.frag"),
        digest: "ffacb1d7da557c0e",
    });
    shaders.insert((ShaderVersion::Gles, "brush_blend_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_blend_DEBUG_OVERDRAW_Gles.vert"),
        frag_source: include_str!("./brush_blend_DEBUG_OVERDRAW_Gles.frag"),
        digest: "bcceef94f24b1422",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gles.frag"),
        digest: "95a23d2cb2faded0",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "d674db11ee7239b8",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D_Gles.frag"),
        digest: "55c109c7d026e92b",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "d08bf638d627711d",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D_Gles.frag"),
        digest: "5db406d0898631d8",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "b84b73874f0191de",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gles.frag"),
        digest: "30705a2ee259b762",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "5351c789b3635925",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gles.frag"),
        digest: "be798ea359c0b277",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "b2abbf674ed11cba",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ALPHA_PASS_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_ALPHA_PASS_TEXTURE_2D_Gles.frag"),
        digest: "1ec5d4f9d367478a",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ALPHA_PASS_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ALPHA_PASS_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_ALPHA_PASS_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "4f81fa6e74d306f0",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D_Gles.frag"),
        digest: "f975bcb7142947c",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "6c1bfe2561ad8c63",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ANTIALIASING_REPETITION_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_ANTIALIASING_REPETITION_TEXTURE_2D_Gles.frag"),
        digest: "a6bde72e612083a3",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_ANTIALIASING_REPETITION_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_ANTIALIASING_REPETITION_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_ANTIALIASING_REPETITION_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "eef8908d0c3bab90",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_DEBUG_OVERDRAW_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_DEBUG_OVERDRAW_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_DEBUG_OVERDRAW_TEXTURE_2D_Gles.frag"),
        digest: "1d8deabd7bbce79",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_DEBUG_OVERDRAW_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_DEBUG_OVERDRAW_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_DEBUG_OVERDRAW_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "3552853c6a997190",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./brush_image_TEXTURE_2D_Gles.frag"),
        digest: "407aab6c5d002582",
    });
    shaders.insert((ShaderVersion::Gles, "brush_image_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_image_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./brush_image_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "2adda57ec3142382",
    });
    shaders.insert((ShaderVersion::Gles, "brush_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_linear_gradient_Gles.vert"),
        frag_source: include_str!("./brush_linear_gradient_Gles.frag"),
        digest: "78b95ec3e0d79b16",
    });
    shaders.insert((ShaderVersion::Gles, "brush_linear_gradient_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_linear_gradient_ALPHA_PASS_Gles.vert"),
        frag_source: include_str!("./brush_linear_gradient_ALPHA_PASS_Gles.frag"),
        digest: "717249967efd63d9",
    });
    shaders.insert((ShaderVersion::Gles, "brush_linear_gradient_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_linear_gradient_DEBUG_OVERDRAW_Gles.vert"),
        frag_source: include_str!("./brush_linear_gradient_DEBUG_OVERDRAW_Gles.frag"),
        digest: "fd308afe8c364afb",
    });
    shaders.insert((ShaderVersion::Gles, "brush_mix_blend"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_mix_blend_Gles.vert"),
        frag_source: include_str!("./brush_mix_blend_Gles.frag"),
        digest: "3edf697d4eba6c3e",
    });
    shaders.insert((ShaderVersion::Gles, "brush_mix_blend_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_mix_blend_ALPHA_PASS_Gles.vert"),
        frag_source: include_str!("./brush_mix_blend_ALPHA_PASS_Gles.frag"),
        digest: "166161d7b4f5166e",
    });
    shaders.insert((ShaderVersion::Gles, "brush_mix_blend_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_mix_blend_DEBUG_OVERDRAW_Gles.vert"),
        frag_source: include_str!("./brush_mix_blend_DEBUG_OVERDRAW_Gles.frag"),
        digest: "91fbc62545d6227b",
    });
    shaders.insert((ShaderVersion::Gles, "brush_opacity"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_opacity_Gles.vert"),
        frag_source: include_str!("./brush_opacity_Gles.frag"),
        digest: "ade5ca9e800b86e5",
    });
    shaders.insert((ShaderVersion::Gles, "brush_opacity_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_opacity_ALPHA_PASS_Gles.vert"),
        frag_source: include_str!("./brush_opacity_ALPHA_PASS_Gles.frag"),
        digest: "1f96aed840a0a8e6",
    });
    shaders.insert((ShaderVersion::Gles, "brush_opacity_ALPHA_PASS_ANTIALIASING"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_opacity_ALPHA_PASS_ANTIALIASING_Gles.vert"),
        frag_source: include_str!("./brush_opacity_ALPHA_PASS_ANTIALIASING_Gles.frag"),
        digest: "7ae9a5c37d0025ff",
    });
    shaders.insert((ShaderVersion::Gles, "brush_opacity_ANTIALIASING"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_opacity_ANTIALIASING_Gles.vert"),
        frag_source: include_str!("./brush_opacity_ANTIALIASING_Gles.frag"),
        digest: "334102bc421b222f",
    });
    shaders.insert((ShaderVersion::Gles, "brush_opacity_ANTIALIASING_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_opacity_ANTIALIASING_DEBUG_OVERDRAW_Gles.vert"),
        frag_source: include_str!("./brush_opacity_ANTIALIASING_DEBUG_OVERDRAW_Gles.frag"),
        digest: "7d56ae21f02c278d",
    });
    shaders.insert((ShaderVersion::Gles, "brush_opacity_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_opacity_DEBUG_OVERDRAW_Gles.vert"),
        frag_source: include_str!("./brush_opacity_DEBUG_OVERDRAW_Gles.frag"),
        digest: "b4b8c330e9a6c529",
    });
    shaders.insert((ShaderVersion::Gles, "brush_solid"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_solid_Gles.vert"),
        frag_source: include_str!("./brush_solid_Gles.frag"),
        digest: "119a28fd7c550981",
    });
    shaders.insert((ShaderVersion::Gles, "brush_solid_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_solid_ALPHA_PASS_Gles.vert"),
        frag_source: include_str!("./brush_solid_ALPHA_PASS_Gles.frag"),
        digest: "431d5ec2756477d9",
    });
    shaders.insert((ShaderVersion::Gles, "brush_solid_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_solid_DEBUG_OVERDRAW_Gles.vert"),
        frag_source: include_str!("./brush_solid_DEBUG_OVERDRAW_Gles.frag"),
        digest: "3745d7d52f75d298",
    });
    shaders.insert((ShaderVersion::Gles, "brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV_Gles.vert"),
        frag_source: include_str!("./brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV_Gles.frag"),
        digest: "9ab9d6af5179fad2",
    });
    shaders.insert((ShaderVersion::Gles, "brush_yuv_image_ALPHA_PASS_TEXTURE_EXTERNAL_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_yuv_image_ALPHA_PASS_TEXTURE_EXTERNAL_YUV_Gles.vert"),
        frag_source: include_str!("./brush_yuv_image_ALPHA_PASS_TEXTURE_EXTERNAL_YUV_Gles.frag"),
        digest: "14fda927a78fb34",
    });
    shaders.insert((ShaderVersion::Gles, "brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV_Gles.vert"),
        frag_source: include_str!("./brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV_Gles.frag"),
        digest: "d6c1d14981cb52b5",
    });
    shaders.insert((ShaderVersion::Gles, "brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_EXTERNAL_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_EXTERNAL_YUV_Gles.vert"),
        frag_source: include_str!("./brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_EXTERNAL_YUV_Gles.frag"),
        digest: "6a19c96d254e3854",
    });
    shaders.insert((ShaderVersion::Gles, "brush_yuv_image_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_yuv_image_TEXTURE_2D_YUV_Gles.vert"),
        frag_source: include_str!("./brush_yuv_image_TEXTURE_2D_YUV_Gles.frag"),
        digest: "398dad811a82a2b7",
    });
    shaders.insert((ShaderVersion::Gles, "brush_yuv_image_TEXTURE_EXTERNAL_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("./brush_yuv_image_TEXTURE_EXTERNAL_YUV_Gles.vert"),
        frag_source: include_str!("./brush_yuv_image_TEXTURE_EXTERNAL_YUV_Gles.frag"),
        digest: "7f463e27ae34b91",
    });
    shaders.insert((ShaderVersion::Gles, "composite_FAST_PATH_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./composite_FAST_PATH_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./composite_FAST_PATH_TEXTURE_2D_Gles.frag"),
        digest: "727437f6c0c6e2b0",
    });
    shaders.insert((ShaderVersion::Gles, "composite_FAST_PATH_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./composite_FAST_PATH_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./composite_FAST_PATH_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "9a00336e03267149",
    });
    shaders.insert((ShaderVersion::Gles, "composite_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./composite_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./composite_TEXTURE_2D_Gles.frag"),
        digest: "6e5ed055451e2b98",
    });
    shaders.insert((ShaderVersion::Gles, "composite_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("./composite_TEXTURE_2D_YUV_Gles.vert"),
        frag_source: include_str!("./composite_TEXTURE_2D_YUV_Gles.frag"),
        digest: "17a1d596c6516d12",
    });
    shaders.insert((ShaderVersion::Gles, "composite_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./composite_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./composite_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "24bfe48aade0321e",
    });
    shaders.insert((ShaderVersion::Gles, "composite_TEXTURE_EXTERNAL_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("./composite_TEXTURE_EXTERNAL_YUV_Gles.vert"),
        frag_source: include_str!("./composite_TEXTURE_EXTERNAL_YUV_Gles.frag"),
        digest: "e0342db39e199010",
    });
    shaders.insert((ShaderVersion::Gles, "cs_blur_ALPHA_TARGET"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_blur_ALPHA_TARGET_Gles.vert"),
        frag_source: include_str!("./cs_blur_ALPHA_TARGET_Gles.frag"),
        digest: "c14b8a34ae00efef",
    });
    shaders.insert((ShaderVersion::Gles, "cs_blur_COLOR_TARGET"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_blur_COLOR_TARGET_Gles.vert"),
        frag_source: include_str!("./cs_blur_COLOR_TARGET_Gles.frag"),
        digest: "3575641c9005134f",
    });
    shaders.insert((ShaderVersion::Gles, "cs_border_segment"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_border_segment_Gles.vert"),
        frag_source: include_str!("./cs_border_segment_Gles.frag"),
        digest: "3de8cc9e0f7eb1ef",
    });
    shaders.insert((ShaderVersion::Gles, "cs_border_solid"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_border_solid_Gles.vert"),
        frag_source: include_str!("./cs_border_solid_Gles.frag"),
        digest: "e6c743ac4d92dc8b",
    });
    shaders.insert((ShaderVersion::Gles, "cs_clip_box_shadow_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_clip_box_shadow_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./cs_clip_box_shadow_TEXTURE_2D_Gles.frag"),
        digest: "5a515f3f65c820e7",
    });
    shaders.insert((ShaderVersion::Gles, "cs_clip_image_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_clip_image_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./cs_clip_image_TEXTURE_2D_Gles.frag"),
        digest: "b4a1ddb88ceed4c2",
    });
    shaders.insert((ShaderVersion::Gles, "cs_clip_rectangle"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_clip_rectangle_Gles.vert"),
        frag_source: include_str!("./cs_clip_rectangle_Gles.frag"),
        digest: "2594b559c0d008da",
    });
    shaders.insert((ShaderVersion::Gles, "cs_clip_rectangle_FAST_PATH"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_clip_rectangle_FAST_PATH_Gles.vert"),
        frag_source: include_str!("./cs_clip_rectangle_FAST_PATH_Gles.frag"),
        digest: "83bd086548d12f94",
    });
    shaders.insert((ShaderVersion::Gles, "cs_conic_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_conic_gradient_Gles.vert"),
        frag_source: include_str!("./cs_conic_gradient_Gles.frag"),
        digest: "e21cb71986fb648c",
    });
    shaders.insert((ShaderVersion::Gles, "cs_fast_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_fast_linear_gradient_Gles.vert"),
        frag_source: include_str!("./cs_fast_linear_gradient_Gles.frag"),
        digest: "1bcd60263c4c9c05",
    });
    shaders.insert((ShaderVersion::Gles, "cs_line_decoration"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_line_decoration_Gles.vert"),
        frag_source: include_str!("./cs_line_decoration_Gles.frag"),
        digest: "b5f40b8e1e6c84e5",
    });
    shaders.insert((ShaderVersion::Gles, "cs_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_linear_gradient_Gles.vert"),
        frag_source: include_str!("./cs_linear_gradient_Gles.frag"),
        digest: "410309e97aa545dd",
    });
    shaders.insert((ShaderVersion::Gles, "cs_radial_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_radial_gradient_Gles.vert"),
        frag_source: include_str!("./cs_radial_gradient_Gles.frag"),
        digest: "8bd159dbc9e73230",
    });
    shaders.insert((ShaderVersion::Gles, "cs_scale_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_scale_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./cs_scale_TEXTURE_2D_Gles.frag"),
        digest: "d666b55b953a9bd7",
    });
    shaders.insert((ShaderVersion::Gles, "cs_scale_TEXTURE_EXTERNAL"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_scale_TEXTURE_EXTERNAL_Gles.vert"),
        frag_source: include_str!("./cs_scale_TEXTURE_EXTERNAL_Gles.frag"),
        digest: "f871344040a1ba28",
    });
    shaders.insert((ShaderVersion::Gles, "cs_svg_filter"), OptimizedSourceWithDigest {
        vert_source: include_str!("./cs_svg_filter_Gles.vert"),
        frag_source: include_str!("./cs_svg_filter_Gles.frag"),
        digest: "8382e8ed1b5b2eb2",
    });
    shaders.insert((ShaderVersion::Gles, "debug_color"), OptimizedSourceWithDigest {
        vert_source: include_str!("./debug_color_Gles.vert"),
        frag_source: include_str!("./debug_color_Gles.frag"),
        digest: "499fdb269cb09c0e",
    });
    shaders.insert((ShaderVersion::Gles, "debug_font"), OptimizedSourceWithDigest {
        vert_source: include_str!("./debug_font_Gles.vert"),
        frag_source: include_str!("./debug_font_Gles.frag"),
        digest: "f4e15ef4f54819ed",
    });
    shaders.insert((ShaderVersion::Gles, "ps_clear"), OptimizedSourceWithDigest {
        vert_source: include_str!("./ps_clear_Gles.vert"),
        frag_source: include_str!("./ps_clear_Gles.frag"),
        digest: "d7adbc16e515795",
    });
    shaders.insert((ShaderVersion::Gles, "ps_split_composite"), OptimizedSourceWithDigest {
        vert_source: include_str!("./ps_split_composite_Gles.vert"),
        frag_source: include_str!("./ps_split_composite_Gles.frag"),
        digest: "ed2745758e2946b9",
    });
    shaders.insert((ShaderVersion::Gles, "ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D_Gles.frag"),
        digest: "2b8132d9d1c2e0d3",
    });
    shaders.insert((ShaderVersion::Gles, "ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gles.frag"),
        digest: "f9101e03a32ecb92",
    });
    shaders.insert((ShaderVersion::Gles, "ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D_Gles.frag"),
        digest: "5a8dae4219a621c2",
    });
    shaders.insert((ShaderVersion::Gles, "ps_text_run_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./ps_text_run_ALPHA_PASS_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./ps_text_run_ALPHA_PASS_TEXTURE_2D_Gles.frag"),
        digest: "c8ae838194e4c703",
    });
    shaders.insert((ShaderVersion::Gles, "ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gles.frag"),
        digest: "8cec35728b700bfa",
    });
    shaders.insert((ShaderVersion::Gles, "ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("./ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D_Gles.vert"),
        frag_source: include_str!("./ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D_Gles.frag"),
        digest: "d27dcd9670e917f7",
    });
    shaders
  };
}
