#version 300 es
// cs_clip_image
// features: ["TEXTURE_2D"]

uniform highp mat4 uTransform;
in highp vec2 aPosition;
uniform lowp sampler2D sColor0;
uniform highp sampler2D sGpuCache;
flat out highp vec4 vTransformBounds;
uniform highp sampler2D sTransformPalette;
in highp vec4 aClipOrigins;
in highp float aDevicePixelScale;
in highp ivec2 aTransformIds;
out highp vec2 vLocalPos;
out highp vec2 vClipMaskImageUv;
flat out highp vec4 vClipMaskUvInnerRect;
in highp vec4 aClipTileRect;
in highp ivec2 aClipDataResourceAddress;
in highp vec4 aClipLocalRect;
void main ()
{
  vec2 tmpvar_1;
  vec2 tmpvar_2;
  tmpvar_1 = aClipLocalRect.xy;
  tmpvar_2 = aClipLocalRect.zw;
  mat4 transform_m_3;
  int tmpvar_4;
  tmpvar_4 = (aTransformIds.y & 16777215);
  ivec2 tmpvar_5;
  tmpvar_5.x = int((8u * (
    uint(tmpvar_4)
   % 128u)));
  tmpvar_5.y = int((uint(tmpvar_4) / 128u));
  transform_m_3[0] = texelFetch (sTransformPalette, tmpvar_5, 0);
  transform_m_3[1] = texelFetch (sTransformPalette, (tmpvar_5 + ivec2(1, 0)), 0);
  transform_m_3[2] = texelFetch (sTransformPalette, (tmpvar_5 + ivec2(2, 0)), 0);
  transform_m_3[3] = texelFetch (sTransformPalette, (tmpvar_5 + ivec2(3, 0)), 0);
  vec2 uv_rect_p0_6;
  vec2 uv_rect_p1_7;
  vec4 tmpvar_8;
  tmpvar_8 = texelFetch (sGpuCache, aClipDataResourceAddress, 0);
  uv_rect_p0_6 = tmpvar_8.xy;
  uv_rect_p1_7 = tmpvar_8.zw;
  vec2 tmpvar_9;
  tmpvar_9 = min (max (mix (aClipTileRect.xy, aClipTileRect.zw, aPosition), aClipLocalRect.xy), aClipLocalRect.zw);
  vec4 tmpvar_10;
  tmpvar_10.zw = vec2(0.0, 1.0);
  tmpvar_10.xy = tmpvar_9;
  vec4 tmpvar_11;
  tmpvar_11 = (transform_m_3 * tmpvar_10);
  vec4 tmpvar_12;
  tmpvar_12.z = 0.0;
  tmpvar_12.xy = ((tmpvar_11.xy * aDevicePixelScale) + ((aClipOrigins.xy - aClipOrigins.zw) * tmpvar_11.w));
  tmpvar_12.w = tmpvar_11.w;
  gl_Position = (uTransform * tmpvar_12);
  vec4 tmpvar_13;
  if (((aTransformIds.x >> 24) == 0)) {
    tmpvar_13 = vec4(-1e+16, -1e+16, 1e+16, 1e+16);
  } else {
    vec4 tmpvar_14;
    tmpvar_14.xy = tmpvar_1;
    tmpvar_14.zw = tmpvar_2;
    tmpvar_13 = tmpvar_14;
  };
  vTransformBounds = tmpvar_13;
  vLocalPos = tmpvar_9;
  vec2 tmpvar_15;
  tmpvar_15 = vec2(textureSize (sColor0, 0));
  vec4 tmpvar_16;
  tmpvar_16.xy = uv_rect_p0_6;
  tmpvar_16.zw = uv_rect_p1_7;
  vClipMaskImageUv = (mix (tmpvar_8.xy, tmpvar_8.zw, (
    (tmpvar_9 - aClipTileRect.xy)
   / 
    (aClipTileRect.zw - aClipTileRect.xy)
  )) / tmpvar_15);
  vClipMaskUvInnerRect = ((tmpvar_16 + vec4(0.5, 0.5, -0.5, -0.5)) / tmpvar_15.xyxy);
}

