#version 300 es
// brush_yuv_image
// features: ["DEBUG_OVERDRAW", "TEXTURE_EXTERNAL", "YUV"]

#extension GL_OES_EGL_image_external_essl3 : enable
uniform highp mat4 uTransform;
in highp vec2 aPosition;
uniform lowp samplerExternalOES sColor0;
uniform lowp samplerExternalOES sColor1;
uniform lowp samplerExternalOES sColor2;
uniform highp sampler2D sRenderTasks;
uniform highp sampler2D sGpuCache;
flat out highp vec4 vTransformBounds;
uniform highp sampler2D sTransformPalette;
uniform highp sampler2D sPrimitiveHeadersF;
uniform highp isampler2D sPrimitiveHeadersI;
in highp ivec4 aData;
out highp vec2 vUv_Y;
flat out highp vec4 vUvBounds_Y;
out highp vec2 vUv_U;
flat out highp vec4 vUvBounds_U;
out highp vec2 vUv_V;
flat out highp vec4 vUvBounds_V;
flat out highp vec3 vYcbcrBias;
flat out highp mat3 vRgbFromDebiasedYcbcr;
flat out highp int vFormat;
void main ()
{
  int instance_picture_task_address_1;
  int instance_segment_index_2;
  instance_picture_task_address_1 = (aData.y >> 16);
  instance_segment_index_2 = (aData.z & 65535);
  float ph_z_3;
  ivec2 tmpvar_4;
  tmpvar_4.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_4.y = int((uint(aData.x) / 512u));
  vec4 tmpvar_5;
  tmpvar_5 = texelFetch (sPrimitiveHeadersF, tmpvar_4, 0);
  vec4 tmpvar_6;
  tmpvar_6 = texelFetch (sPrimitiveHeadersF, (tmpvar_4 + ivec2(1, 0)), 0);
  vec2 tmpvar_7;
  vec2 tmpvar_8;
  tmpvar_7 = tmpvar_5.xy;
  tmpvar_8 = tmpvar_5.zw;
  ivec2 tmpvar_9;
  tmpvar_9.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_9.y = int((uint(aData.x) / 512u));
  ivec4 tmpvar_10;
  tmpvar_10 = texelFetch (sPrimitiveHeadersI, tmpvar_9, 0);
  ivec4 tmpvar_11;
  tmpvar_11 = texelFetch (sPrimitiveHeadersI, (tmpvar_9 + ivec2(1, 0)), 0);
  ph_z_3 = float(tmpvar_10.x);
  mat4 transform_m_12;
  bool transform_is_axis_aligned_13;
  transform_is_axis_aligned_13 = ((tmpvar_10.z >> 24) == 0);
  int tmpvar_14;
  tmpvar_14 = (tmpvar_10.z & 16777215);
  ivec2 tmpvar_15;
  tmpvar_15.x = int((8u * (
    uint(tmpvar_14)
   % 128u)));
  tmpvar_15.y = int((uint(tmpvar_14) / 128u));
  transform_m_12[0] = texelFetch (sTransformPalette, tmpvar_15, 0);
  transform_m_12[1] = texelFetch (sTransformPalette, (tmpvar_15 + ivec2(1, 0)), 0);
  transform_m_12[2] = texelFetch (sTransformPalette, (tmpvar_15 + ivec2(2, 0)), 0);
  transform_m_12[3] = texelFetch (sTransformPalette, (tmpvar_15 + ivec2(3, 0)), 0);
  ivec2 tmpvar_16;
  tmpvar_16.x = int((2u * (
    uint(instance_picture_task_address_1)
   % 512u)));
  tmpvar_16.y = int((uint(instance_picture_task_address_1) / 512u));
  vec4 tmpvar_17;
  tmpvar_17 = texelFetch (sRenderTasks, tmpvar_16, 0);
  vec4 tmpvar_18;
  tmpvar_18 = texelFetch (sRenderTasks, (tmpvar_16 + ivec2(1, 0)), 0);
  vec2 vi_local_pos_19;
  vec2 segment_rect_p0_20;
  vec2 segment_rect_p1_21;
  int tmpvar_22;
  tmpvar_22 = ((aData.z >> 16) & 255);
  if ((instance_segment_index_2 == 65535)) {
    segment_rect_p0_20 = tmpvar_7;
    segment_rect_p1_21 = tmpvar_8;
  } else {
    int tmpvar_23;
    tmpvar_23 = ((tmpvar_10.y + 1) + (instance_segment_index_2 * 2));
    ivec2 tmpvar_24;
    tmpvar_24.x = int((uint(tmpvar_23) % 1024u));
    tmpvar_24.y = int((uint(tmpvar_23) / 1024u));
    vec4 tmpvar_25;
    tmpvar_25 = texelFetch (sGpuCache, tmpvar_24, 0);
    segment_rect_p0_20 = (tmpvar_25.xy + tmpvar_5.xy);
    segment_rect_p1_21 = (tmpvar_25.zw + tmpvar_5.xy);
  };
  if (transform_is_axis_aligned_13) {
    vec2 tmpvar_26;
    tmpvar_26 = min (max (mix (segment_rect_p0_20, segment_rect_p1_21, aPosition), tmpvar_6.xy), tmpvar_6.zw);
    vec4 tmpvar_27;
    tmpvar_27.zw = vec2(0.0, 1.0);
    tmpvar_27.xy = tmpvar_26;
    vec4 tmpvar_28;
    tmpvar_28 = (transform_m_12 * tmpvar_27);
    vec4 tmpvar_29;
    tmpvar_29.xy = ((tmpvar_28.xy * tmpvar_18.x) + ((
      -(tmpvar_18.yz)
     + tmpvar_17.xy) * tmpvar_28.w));
    tmpvar_29.z = (ph_z_3 * tmpvar_28.w);
    tmpvar_29.w = tmpvar_28.w;
    gl_Position = (uTransform * tmpvar_29);
    vi_local_pos_19 = tmpvar_26;
  } else {
    bvec4 tmpvar_30;
    tmpvar_30.x = bool((tmpvar_22 & 1));
    tmpvar_30.y = bool((tmpvar_22 & 2));
    tmpvar_30.z = bool((tmpvar_22 & 4));
    tmpvar_30.w = bool((tmpvar_22 & 8));
    vec4 tmpvar_31;
    tmpvar_31.xy = min (max (tmpvar_5.xy, tmpvar_6.xy), tmpvar_6.zw);
    tmpvar_31.zw = min (max (tmpvar_5.zw, tmpvar_6.xy), tmpvar_6.zw);
    vec4 tmpvar_32;
    tmpvar_32.xy = min (max (segment_rect_p0_20, tmpvar_6.xy), tmpvar_6.zw);
    tmpvar_32.zw = min (max (segment_rect_p1_21, tmpvar_6.xy), tmpvar_6.zw);
    vTransformBounds = mix(tmpvar_31, tmpvar_32, bvec4(tmpvar_30));
    vec4 tmpvar_33;
    tmpvar_33 = mix(vec4(0.0, 0.0, 0.0, 0.0), vec4(2.0, 2.0, 2.0, 2.0), bvec4(tmpvar_30));
    vec2 tmpvar_34;
    tmpvar_34 = mix ((segment_rect_p0_20 - tmpvar_33.xy), (segment_rect_p1_21 + tmpvar_33.zw), aPosition);
    vec4 tmpvar_35;
    tmpvar_35.zw = vec2(0.0, 1.0);
    tmpvar_35.xy = tmpvar_34;
    vec4 tmpvar_36;
    tmpvar_36 = (transform_m_12 * tmpvar_35);
    vec4 tmpvar_37;
    tmpvar_37.xy = ((tmpvar_36.xy * tmpvar_18.x) + ((tmpvar_17.xy - tmpvar_18.yz) * tmpvar_36.w));
    tmpvar_37.z = (ph_z_3 * tmpvar_36.w);
    tmpvar_37.w = tmpvar_36.w;
    gl_Position = (uTransform * tmpvar_37);
    vi_local_pos_19 = tmpvar_34;
  };
  highp vec2 f_38;
  f_38 = ((vi_local_pos_19 - tmpvar_5.xy) / (tmpvar_5.zw - tmpvar_5.xy));
  ivec2 tmpvar_39;
  tmpvar_39.x = int((uint(tmpvar_10.y) % 1024u));
  tmpvar_39.y = int((uint(tmpvar_10.y) / 1024u));
  vec4 tmpvar_40;
  tmpvar_40 = texelFetch (sGpuCache, tmpvar_39, 0);
  int tmpvar_41;
  tmpvar_41 = int(tmpvar_40.z);
  int tmpvar_42;
  int tmpvar_43;
  tmpvar_42 = int(tmpvar_40.x);
  tmpvar_43 = int(tmpvar_40.y);
  mat3 tmpvar_44;
  vec4 tmpvar_45;
  if ((tmpvar_43 == 0)) {
    highp int channel_depth_46;
    ivec4 tmpvar_47;
    tmpvar_47 = (ivec4(16, 128, 235, 240) << (tmpvar_42 - 8));
    channel_depth_46 = 8;
    if ((8 < tmpvar_42)) {
      channel_depth_46 = 16;
    };
    tmpvar_44 = mat3(1.0, 1.0, 1.0, 0.0, -0.17207, 0.886, 0.701, -0.35707, 0.0);
    tmpvar_45 = (vec4(tmpvar_47) / float((
      (1 << channel_depth_46)
     - 1)));
  } else {
    if ((tmpvar_43 == 1)) {
      vec4 tmpvar_48;
      highp int channel_depth_49;
      ivec4 tmpvar_50;
      tmpvar_50 = (ivec4(16, 128, 235, 240) << (tmpvar_42 - 8));
      channel_depth_49 = 8;
      if ((8 < tmpvar_42)) {
        channel_depth_49 = 16;
      };
      tmpvar_48 = (vec4(tmpvar_50) / float((
        (1 << channel_depth_49)
       - 1)));
      highp int channel_depth_51;
      channel_depth_51 = 8;
      if ((8 < tmpvar_42)) {
        channel_depth_51 = 16;
      };
      float tmpvar_52;
      tmpvar_52 = (float((
        (1 << tmpvar_42)
       - 1)) / float((
        (1 << channel_depth_51)
       - 1)));
      vec4 tmpvar_53;
      tmpvar_53.xy = vec2(0.0, 0.0);
      tmpvar_53.z = tmpvar_52;
      tmpvar_53.w = tmpvar_52;
      vec4 tmpvar_54;
      tmpvar_54.x = 0.0;
      tmpvar_54.y = tmpvar_48.y;
      tmpvar_54.zw = tmpvar_53.zw;
      tmpvar_44 = mat3(1.0, 1.0, 1.0, 0.0, -0.17207, 0.886, 0.701, -0.35707, 0.0);
      tmpvar_45 = tmpvar_54;
    } else {
      if ((tmpvar_43 == 2)) {
        highp int channel_depth_55;
        ivec4 tmpvar_56;
        tmpvar_56 = (ivec4(16, 128, 235, 240) << (tmpvar_42 - 8));
        channel_depth_55 = 8;
        if ((8 < tmpvar_42)) {
          channel_depth_55 = 16;
        };
        tmpvar_44 = mat3(1.0, 1.0, 1.0, 0.0, -0.09366, 0.9278, 0.7874, -0.23406, 0.0);
        tmpvar_45 = (vec4(tmpvar_56) / float((
          (1 << channel_depth_55)
         - 1)));
      } else {
        if ((tmpvar_43 == 3)) {
          vec4 tmpvar_57;
          highp int channel_depth_58;
          ivec4 tmpvar_59;
          tmpvar_59 = (ivec4(16, 128, 235, 240) << (tmpvar_42 - 8));
          channel_depth_58 = 8;
          if ((8 < tmpvar_42)) {
            channel_depth_58 = 16;
          };
          tmpvar_57 = (vec4(tmpvar_59) / float((
            (1 << channel_depth_58)
           - 1)));
          highp int channel_depth_60;
          channel_depth_60 = 8;
          if ((8 < tmpvar_42)) {
            channel_depth_60 = 16;
          };
          float tmpvar_61;
          tmpvar_61 = (float((
            (1 << tmpvar_42)
           - 1)) / float((
            (1 << channel_depth_60)
           - 1)));
          vec4 tmpvar_62;
          tmpvar_62.xy = vec2(0.0, 0.0);
          tmpvar_62.z = tmpvar_61;
          tmpvar_62.w = tmpvar_61;
          vec4 tmpvar_63;
          tmpvar_63.x = 0.0;
          tmpvar_63.y = tmpvar_57.y;
          tmpvar_63.zw = tmpvar_62.zw;
          tmpvar_44 = mat3(1.0, 1.0, 1.0, 0.0, -0.09366, 0.9278, 0.7874, -0.23406, 0.0);
          tmpvar_45 = tmpvar_63;
        } else {
          if ((tmpvar_43 == 4)) {
            highp int channel_depth_64;
            ivec4 tmpvar_65;
            tmpvar_65 = (ivec4(16, 128, 235, 240) << (tmpvar_42 - 8));
            channel_depth_64 = 8;
            if ((8 < tmpvar_42)) {
              channel_depth_64 = 16;
            };
            tmpvar_44 = mat3(1.0, 1.0, 1.0, 0.0, -0.08228, 0.9407, 0.7373, -0.28568, 0.0);
            tmpvar_45 = (vec4(tmpvar_65) / float((
              (1 << channel_depth_64)
             - 1)));
          } else {
            if ((tmpvar_43 == 5)) {
              vec4 tmpvar_66;
              highp int channel_depth_67;
              ivec4 tmpvar_68;
              tmpvar_68 = (ivec4(16, 128, 235, 240) << (tmpvar_42 - 8));
              channel_depth_67 = 8;
              if ((8 < tmpvar_42)) {
                channel_depth_67 = 16;
              };
              tmpvar_66 = (vec4(tmpvar_68) / float((
                (1 << channel_depth_67)
               - 1)));
              highp int channel_depth_69;
              channel_depth_69 = 8;
              if ((8 < tmpvar_42)) {
                channel_depth_69 = 16;
              };
              float tmpvar_70;
              tmpvar_70 = (float((
                (1 << tmpvar_42)
               - 1)) / float((
                (1 << channel_depth_69)
               - 1)));
              vec4 tmpvar_71;
              tmpvar_71.xy = vec2(0.0, 0.0);
              tmpvar_71.z = tmpvar_70;
              tmpvar_71.w = tmpvar_70;
              vec4 tmpvar_72;
              tmpvar_72.x = 0.0;
              tmpvar_72.y = tmpvar_66.y;
              tmpvar_72.zw = tmpvar_71.zw;
              tmpvar_44 = mat3(1.0, 1.0, 1.0, 0.0, -0.08228, 0.9407, 0.7373, -0.28568, 0.0);
              tmpvar_45 = tmpvar_72;
            } else {
              highp int channel_depth_73;
              channel_depth_73 = 8;
              if ((8 < tmpvar_42)) {
                channel_depth_73 = 16;
              };
              float tmpvar_74;
              tmpvar_74 = (float((
                (1 << tmpvar_42)
               - 1)) / float((
                (1 << channel_depth_73)
               - 1)));
              vec4 tmpvar_75;
              tmpvar_75.xy = vec2(0.0, 0.0);
              tmpvar_75.z = tmpvar_74;
              tmpvar_75.w = tmpvar_74;
              tmpvar_44 = mat3(0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0);
              tmpvar_45 = tmpvar_75;
            };
          };
        };
      };
    };
  };
  vec2 tmpvar_76;
  tmpvar_76 = (1.0/((tmpvar_45.zw - tmpvar_45.xy)));
  mat3 tmpvar_77;
  tmpvar_77[uint(0)].x = tmpvar_76.x;
  tmpvar_77[uint(0)].y = 0.0;
  tmpvar_77[uint(0)].z = 0.0;
  tmpvar_77[1u].x = 0.0;
  tmpvar_77[1u].y = tmpvar_76.y;
  tmpvar_77[1u].z = 0.0;
  tmpvar_77[2u].x = 0.0;
  tmpvar_77[2u].y = 0.0;
  tmpvar_77[2u].z = tmpvar_76.y;
  vYcbcrBias = tmpvar_45.xyy;
  vRgbFromDebiasedYcbcr = (tmpvar_44 * tmpvar_77);
  vFormat = tmpvar_41;
  if (((tmpvar_41 == 1) || (tmpvar_41 == 99))) {
    ivec2 tmpvar_78;
    tmpvar_78.x = int((uint(tmpvar_11.x) % 1024u));
    tmpvar_78.y = int((uint(tmpvar_11.x) / 1024u));
    vec4 tmpvar_79;
    tmpvar_79 = texelFetch (sGpuCache, tmpvar_78, 0);
    ivec2 tmpvar_80;
    tmpvar_80.x = int((uint(tmpvar_11.y) % 1024u));
    tmpvar_80.y = int((uint(tmpvar_11.y) / 1024u));
    vec4 tmpvar_81;
    tmpvar_81 = texelFetch (sGpuCache, tmpvar_80, 0);
    ivec2 tmpvar_82;
    tmpvar_82.x = int((uint(tmpvar_11.z) % 1024u));
    tmpvar_82.y = int((uint(tmpvar_11.z) / 1024u));
    vec4 tmpvar_83;
    tmpvar_83 = texelFetch (sGpuCache, tmpvar_82, 0);
    vec2 tmpvar_84;
    tmpvar_84 = vec2(textureSize (sColor0, 0));
    vec4 tmpvar_85;
    tmpvar_85.xy = (tmpvar_79.xy + vec2(0.5, 0.5));
    tmpvar_85.zw = (tmpvar_79.zw - vec2(0.5, 0.5));
    vUv_Y = (mix (tmpvar_79.xy, tmpvar_79.zw, f_38) / tmpvar_84);
    vUvBounds_Y = (tmpvar_85 / tmpvar_84.xyxy);
    vec2 tmpvar_86;
    tmpvar_86 = vec2(textureSize (sColor1, 0));
    vec4 tmpvar_87;
    tmpvar_87.xy = (tmpvar_81.xy + vec2(0.5, 0.5));
    tmpvar_87.zw = (tmpvar_81.zw - vec2(0.5, 0.5));
    vUv_U = (mix (tmpvar_81.xy, tmpvar_81.zw, f_38) / tmpvar_86);
    vUvBounds_U = (tmpvar_87 / tmpvar_86.xyxy);
    vec2 tmpvar_88;
    tmpvar_88 = vec2(textureSize (sColor2, 0));
    vec4 tmpvar_89;
    tmpvar_89.xy = (tmpvar_83.xy + vec2(0.5, 0.5));
    tmpvar_89.zw = (tmpvar_83.zw - vec2(0.5, 0.5));
    vUv_V = (mix (tmpvar_83.xy, tmpvar_83.zw, f_38) / tmpvar_88);
    vUvBounds_V = (tmpvar_89 / tmpvar_88.xyxy);
  } else {
    if ((tmpvar_41 == 0)) {
      ivec2 tmpvar_90;
      tmpvar_90.x = int((uint(tmpvar_11.x) % 1024u));
      tmpvar_90.y = int((uint(tmpvar_11.x) / 1024u));
      vec4 tmpvar_91;
      tmpvar_91 = texelFetch (sGpuCache, tmpvar_90, 0);
      ivec2 tmpvar_92;
      tmpvar_92.x = int((uint(tmpvar_11.y) % 1024u));
      tmpvar_92.y = int((uint(tmpvar_11.y) / 1024u));
      vec4 tmpvar_93;
      tmpvar_93 = texelFetch (sGpuCache, tmpvar_92, 0);
      vec2 tmpvar_94;
      tmpvar_94 = vec2(textureSize (sColor0, 0));
      vec4 tmpvar_95;
      tmpvar_95.xy = (tmpvar_91.xy + vec2(0.5, 0.5));
      tmpvar_95.zw = (tmpvar_91.zw - vec2(0.5, 0.5));
      vUv_Y = (mix (tmpvar_91.xy, tmpvar_91.zw, f_38) / tmpvar_94);
      vUvBounds_Y = (tmpvar_95 / tmpvar_94.xyxy);
      vec2 tmpvar_96;
      tmpvar_96 = vec2(textureSize (sColor1, 0));
      vec4 tmpvar_97;
      tmpvar_97.xy = (tmpvar_93.xy + vec2(0.5, 0.5));
      tmpvar_97.zw = (tmpvar_93.zw - vec2(0.5, 0.5));
      vUv_U = (mix (tmpvar_93.xy, tmpvar_93.zw, f_38) / tmpvar_96);
      vUvBounds_U = (tmpvar_97 / tmpvar_96.xyxy);
    } else {
      if ((tmpvar_41 == 2)) {
        ivec2 tmpvar_98;
        tmpvar_98.x = int((uint(tmpvar_11.x) % 1024u));
        tmpvar_98.y = int((uint(tmpvar_11.x) / 1024u));
        vec4 tmpvar_99;
        tmpvar_99 = texelFetch (sGpuCache, tmpvar_98, 0);
        vec2 tmpvar_100;
        tmpvar_100 = vec2(textureSize (sColor0, 0));
        vec4 tmpvar_101;
        tmpvar_101.xy = (tmpvar_99.xy + vec2(0.5, 0.5));
        tmpvar_101.zw = (tmpvar_99.zw - vec2(0.5, 0.5));
        vUv_Y = (mix (tmpvar_99.xy, tmpvar_99.zw, f_38) / tmpvar_100);
        vUvBounds_Y = (tmpvar_101 / tmpvar_100.xyxy);
      };
    };
  };
}

