#version 300 es
// brush_yuv_image
// features: ["ALPHA_PASS", "TEXTURE_2D", "YUV"]

struct RectWithEndpoint {
  vec2 p0;
  vec2 p1;
};
uniform highp mat4 uTransform;
in highp vec2 aPosition;
uniform lowp sampler2D sColor0;
uniform lowp sampler2D sColor1;
uniform lowp sampler2D sColor2;
uniform highp sampler2D sRenderTasks;
uniform highp sampler2D sGpuCache;
flat out highp vec4 vTransformBounds;
uniform highp sampler2D sTransformPalette;
flat out highp vec4 vClipMaskUvBounds;
out highp vec2 vClipMaskUv;
uniform highp sampler2D sPrimitiveHeadersF;
uniform highp isampler2D sPrimitiveHeadersI;
in highp ivec4 aData;
out highp vec2 v_local_pos;
out highp vec2 vUv_Y;
flat out highp vec4 vUvBounds_Y;
out highp vec2 vUv_U;
flat out highp vec4 vUvBounds_U;
out highp vec2 vUv_V;
flat out highp vec4 vUvBounds_V;
flat out highp vec3 vYcbcrBias;
flat out highp mat3 vRgbFromDebiasedYcbcr;
flat out highp int vFormat;
void main ()
{
  int instance_picture_task_address_1;
  int instance_clip_address_2;
  int instance_segment_index_3;
  int instance_flags_4;
  instance_picture_task_address_1 = (aData.y >> 16);
  instance_clip_address_2 = (aData.y & 65535);
  instance_segment_index_3 = (aData.z & 65535);
  instance_flags_4 = (aData.z >> 16);
  float ph_z_5;
  ivec2 tmpvar_6;
  tmpvar_6.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_6.y = int((uint(aData.x) / 512u));
  vec4 tmpvar_7;
  tmpvar_7 = texelFetch (sPrimitiveHeadersF, tmpvar_6, 0);
  vec4 tmpvar_8;
  tmpvar_8 = texelFetch (sPrimitiveHeadersF, (tmpvar_6 + ivec2(1, 0)), 0);
  vec2 tmpvar_9;
  vec2 tmpvar_10;
  tmpvar_9 = tmpvar_7.xy;
  tmpvar_10 = tmpvar_7.zw;
  ivec2 tmpvar_11;
  tmpvar_11.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_11.y = int((uint(aData.x) / 512u));
  ivec4 tmpvar_12;
  tmpvar_12 = texelFetch (sPrimitiveHeadersI, tmpvar_11, 0);
  ivec4 tmpvar_13;
  tmpvar_13 = texelFetch (sPrimitiveHeadersI, (tmpvar_11 + ivec2(1, 0)), 0);
  ph_z_5 = float(tmpvar_12.x);
  mat4 transform_m_14;
  bool transform_is_axis_aligned_15;
  transform_is_axis_aligned_15 = ((tmpvar_12.z >> 24) == 0);
  int tmpvar_16;
  tmpvar_16 = (tmpvar_12.z & 16777215);
  ivec2 tmpvar_17;
  tmpvar_17.x = int((8u * (
    uint(tmpvar_16)
   % 128u)));
  tmpvar_17.y = int((uint(tmpvar_16) / 128u));
  transform_m_14[0] = texelFetch (sTransformPalette, tmpvar_17, 0);
  transform_m_14[1] = texelFetch (sTransformPalette, (tmpvar_17 + ivec2(1, 0)), 0);
  transform_m_14[2] = texelFetch (sTransformPalette, (tmpvar_17 + ivec2(2, 0)), 0);
  transform_m_14[3] = texelFetch (sTransformPalette, (tmpvar_17 + ivec2(3, 0)), 0);
  ivec2 tmpvar_18;
  tmpvar_18.x = int((2u * (
    uint(instance_picture_task_address_1)
   % 512u)));
  tmpvar_18.y = int((uint(instance_picture_task_address_1) / 512u));
  vec4 tmpvar_19;
  tmpvar_19 = texelFetch (sRenderTasks, tmpvar_18, 0);
  vec4 tmpvar_20;
  tmpvar_20 = texelFetch (sRenderTasks, (tmpvar_18 + ivec2(1, 0)), 0);
  RectWithEndpoint area_task_rect_21;
  float area_device_pixel_scale_22;
  vec2 area_screen_origin_23;
  if ((instance_clip_address_2 >= 32767)) {
    area_task_rect_21 = RectWithEndpoint(vec2(0.0, 0.0), vec2(0.0, 0.0));
    area_device_pixel_scale_22 = 0.0;
    area_screen_origin_23 = vec2(0.0, 0.0);
  } else {
    ivec2 tmpvar_24;
    tmpvar_24.x = int((2u * (
      uint(instance_clip_address_2)
     % 512u)));
    tmpvar_24.y = int((uint(instance_clip_address_2) / 512u));
    vec4 tmpvar_25;
    tmpvar_25 = texelFetch (sRenderTasks, tmpvar_24, 0);
    vec4 tmpvar_26;
    tmpvar_26 = texelFetch (sRenderTasks, (tmpvar_24 + ivec2(1, 0)), 0);
    area_task_rect_21.p0 = tmpvar_25.xy;
    area_task_rect_21.p1 = tmpvar_25.zw;
    area_device_pixel_scale_22 = tmpvar_26.x;
    area_screen_origin_23 = tmpvar_26.yz;
  };
  vec2 vi_local_pos_27;
  vec4 vi_world_pos_28;
  vec2 segment_rect_p0_29;
  vec2 segment_rect_p1_30;
  int tmpvar_31;
  tmpvar_31 = (instance_flags_4 & 255);
  if ((instance_segment_index_3 == 65535)) {
    segment_rect_p0_29 = tmpvar_9;
    segment_rect_p1_30 = tmpvar_10;
  } else {
    int tmpvar_32;
    tmpvar_32 = ((tmpvar_12.y + 1) + (instance_segment_index_3 * 2));
    ivec2 tmpvar_33;
    tmpvar_33.x = int((uint(tmpvar_32) % 1024u));
    tmpvar_33.y = int((uint(tmpvar_32) / 1024u));
    vec4 tmpvar_34;
    tmpvar_34 = texelFetch (sGpuCache, tmpvar_33, 0);
    segment_rect_p0_29 = (tmpvar_34.xy + tmpvar_7.xy);
    segment_rect_p1_30 = (tmpvar_34.zw + tmpvar_7.xy);
  };
  if (transform_is_axis_aligned_15) {
    vec2 tmpvar_35;
    tmpvar_35 = min (max (mix (segment_rect_p0_29, segment_rect_p1_30, aPosition), tmpvar_8.xy), tmpvar_8.zw);
    vec4 tmpvar_36;
    tmpvar_36.zw = vec2(0.0, 1.0);
    tmpvar_36.xy = tmpvar_35;
    vec4 tmpvar_37;
    tmpvar_37 = (transform_m_14 * tmpvar_36);
    vec4 tmpvar_38;
    tmpvar_38.xy = ((tmpvar_37.xy * tmpvar_20.x) + ((
      -(tmpvar_20.yz)
     + tmpvar_19.xy) * tmpvar_37.w));
    tmpvar_38.z = (ph_z_5 * tmpvar_37.w);
    tmpvar_38.w = tmpvar_37.w;
    gl_Position = (uTransform * tmpvar_38);
    vi_local_pos_27 = tmpvar_35;
    vi_world_pos_28 = tmpvar_37;
    vTransformBounds = vec4(-1e+16, -1e+16, 1e+16, 1e+16);
  } else {
    bvec4 tmpvar_39;
    tmpvar_39.x = bool((tmpvar_31 & 1));
    tmpvar_39.y = bool((tmpvar_31 & 2));
    tmpvar_39.z = bool((tmpvar_31 & 4));
    tmpvar_39.w = bool((tmpvar_31 & 8));
    vec4 tmpvar_40;
    tmpvar_40.xy = min (max (tmpvar_7.xy, tmpvar_8.xy), tmpvar_8.zw);
    tmpvar_40.zw = min (max (tmpvar_7.zw, tmpvar_8.xy), tmpvar_8.zw);
    vec4 tmpvar_41;
    tmpvar_41.xy = min (max (segment_rect_p0_29, tmpvar_8.xy), tmpvar_8.zw);
    tmpvar_41.zw = min (max (segment_rect_p1_30, tmpvar_8.xy), tmpvar_8.zw);
    vTransformBounds = mix(tmpvar_40, tmpvar_41, bvec4(tmpvar_39));
    vec4 tmpvar_42;
    tmpvar_42 = mix(vec4(0.0, 0.0, 0.0, 0.0), vec4(2.0, 2.0, 2.0, 2.0), bvec4(tmpvar_39));
    vec2 tmpvar_43;
    tmpvar_43 = mix ((segment_rect_p0_29 - tmpvar_42.xy), (segment_rect_p1_30 + tmpvar_42.zw), aPosition);
    vec4 tmpvar_44;
    tmpvar_44.zw = vec2(0.0, 1.0);
    tmpvar_44.xy = tmpvar_43;
    vec4 tmpvar_45;
    tmpvar_45 = (transform_m_14 * tmpvar_44);
    vec4 tmpvar_46;
    tmpvar_46.xy = ((tmpvar_45.xy * tmpvar_20.x) + ((tmpvar_19.xy - tmpvar_20.yz) * tmpvar_45.w));
    tmpvar_46.z = (ph_z_5 * tmpvar_45.w);
    tmpvar_46.w = tmpvar_45.w;
    gl_Position = (uTransform * tmpvar_46);
    vi_local_pos_27 = tmpvar_43;
    vi_world_pos_28 = tmpvar_45;
  };
  vec4 tmpvar_47;
  tmpvar_47.xy = area_task_rect_21.p0;
  tmpvar_47.zw = area_task_rect_21.p1;
  vClipMaskUvBounds = tmpvar_47;
  vClipMaskUv = ((vi_world_pos_28.xy * area_device_pixel_scale_22) + (vi_world_pos_28.w * (area_task_rect_21.p0 - area_screen_origin_23)));
  highp vec2 f_48;
  f_48 = ((vi_local_pos_27 - tmpvar_7.xy) / (tmpvar_7.zw - tmpvar_7.xy));
  ivec2 tmpvar_49;
  tmpvar_49.x = int((uint(tmpvar_12.y) % 1024u));
  tmpvar_49.y = int((uint(tmpvar_12.y) / 1024u));
  vec4 tmpvar_50;
  tmpvar_50 = texelFetch (sGpuCache, tmpvar_49, 0);
  int tmpvar_51;
  tmpvar_51 = int(tmpvar_50.z);
  int tmpvar_52;
  int tmpvar_53;
  tmpvar_52 = int(tmpvar_50.x);
  tmpvar_53 = int(tmpvar_50.y);
  mat3 tmpvar_54;
  vec4 tmpvar_55;
  if ((tmpvar_53 == 0)) {
    highp int channel_depth_56;
    ivec4 tmpvar_57;
    tmpvar_57 = (ivec4(16, 128, 235, 240) << (tmpvar_52 - 8));
    channel_depth_56 = 8;
    if ((8 < tmpvar_52)) {
      channel_depth_56 = 16;
    };
    tmpvar_54 = mat3(1.0, 1.0, 1.0, 0.0, -0.17207, 0.886, 0.701, -0.35707, 0.0);
    tmpvar_55 = (vec4(tmpvar_57) / float((
      (1 << channel_depth_56)
     - 1)));
  } else {
    if ((tmpvar_53 == 1)) {
      vec4 tmpvar_58;
      highp int channel_depth_59;
      ivec4 tmpvar_60;
      tmpvar_60 = (ivec4(16, 128, 235, 240) << (tmpvar_52 - 8));
      channel_depth_59 = 8;
      if ((8 < tmpvar_52)) {
        channel_depth_59 = 16;
      };
      tmpvar_58 = (vec4(tmpvar_60) / float((
        (1 << channel_depth_59)
       - 1)));
      highp int channel_depth_61;
      channel_depth_61 = 8;
      if ((8 < tmpvar_52)) {
        channel_depth_61 = 16;
      };
      float tmpvar_62;
      tmpvar_62 = (float((
        (1 << tmpvar_52)
       - 1)) / float((
        (1 << channel_depth_61)
       - 1)));
      vec4 tmpvar_63;
      tmpvar_63.xy = vec2(0.0, 0.0);
      tmpvar_63.z = tmpvar_62;
      tmpvar_63.w = tmpvar_62;
      vec4 tmpvar_64;
      tmpvar_64.x = 0.0;
      tmpvar_64.y = tmpvar_58.y;
      tmpvar_64.zw = tmpvar_63.zw;
      tmpvar_54 = mat3(1.0, 1.0, 1.0, 0.0, -0.17207, 0.886, 0.701, -0.35707, 0.0);
      tmpvar_55 = tmpvar_64;
    } else {
      if ((tmpvar_53 == 2)) {
        highp int channel_depth_65;
        ivec4 tmpvar_66;
        tmpvar_66 = (ivec4(16, 128, 235, 240) << (tmpvar_52 - 8));
        channel_depth_65 = 8;
        if ((8 < tmpvar_52)) {
          channel_depth_65 = 16;
        };
        tmpvar_54 = mat3(1.0, 1.0, 1.0, 0.0, -0.09366, 0.9278, 0.7874, -0.23406, 0.0);
        tmpvar_55 = (vec4(tmpvar_66) / float((
          (1 << channel_depth_65)
         - 1)));
      } else {
        if ((tmpvar_53 == 3)) {
          vec4 tmpvar_67;
          highp int channel_depth_68;
          ivec4 tmpvar_69;
          tmpvar_69 = (ivec4(16, 128, 235, 240) << (tmpvar_52 - 8));
          channel_depth_68 = 8;
          if ((8 < tmpvar_52)) {
            channel_depth_68 = 16;
          };
          tmpvar_67 = (vec4(tmpvar_69) / float((
            (1 << channel_depth_68)
           - 1)));
          highp int channel_depth_70;
          channel_depth_70 = 8;
          if ((8 < tmpvar_52)) {
            channel_depth_70 = 16;
          };
          float tmpvar_71;
          tmpvar_71 = (float((
            (1 << tmpvar_52)
           - 1)) / float((
            (1 << channel_depth_70)
           - 1)));
          vec4 tmpvar_72;
          tmpvar_72.xy = vec2(0.0, 0.0);
          tmpvar_72.z = tmpvar_71;
          tmpvar_72.w = tmpvar_71;
          vec4 tmpvar_73;
          tmpvar_73.x = 0.0;
          tmpvar_73.y = tmpvar_67.y;
          tmpvar_73.zw = tmpvar_72.zw;
          tmpvar_54 = mat3(1.0, 1.0, 1.0, 0.0, -0.09366, 0.9278, 0.7874, -0.23406, 0.0);
          tmpvar_55 = tmpvar_73;
        } else {
          if ((tmpvar_53 == 4)) {
            highp int channel_depth_74;
            ivec4 tmpvar_75;
            tmpvar_75 = (ivec4(16, 128, 235, 240) << (tmpvar_52 - 8));
            channel_depth_74 = 8;
            if ((8 < tmpvar_52)) {
              channel_depth_74 = 16;
            };
            tmpvar_54 = mat3(1.0, 1.0, 1.0, 0.0, -0.08228, 0.9407, 0.7373, -0.28568, 0.0);
            tmpvar_55 = (vec4(tmpvar_75) / float((
              (1 << channel_depth_74)
             - 1)));
          } else {
            if ((tmpvar_53 == 5)) {
              vec4 tmpvar_76;
              highp int channel_depth_77;
              ivec4 tmpvar_78;
              tmpvar_78 = (ivec4(16, 128, 235, 240) << (tmpvar_52 - 8));
              channel_depth_77 = 8;
              if ((8 < tmpvar_52)) {
                channel_depth_77 = 16;
              };
              tmpvar_76 = (vec4(tmpvar_78) / float((
                (1 << channel_depth_77)
               - 1)));
              highp int channel_depth_79;
              channel_depth_79 = 8;
              if ((8 < tmpvar_52)) {
                channel_depth_79 = 16;
              };
              float tmpvar_80;
              tmpvar_80 = (float((
                (1 << tmpvar_52)
               - 1)) / float((
                (1 << channel_depth_79)
               - 1)));
              vec4 tmpvar_81;
              tmpvar_81.xy = vec2(0.0, 0.0);
              tmpvar_81.z = tmpvar_80;
              tmpvar_81.w = tmpvar_80;
              vec4 tmpvar_82;
              tmpvar_82.x = 0.0;
              tmpvar_82.y = tmpvar_76.y;
              tmpvar_82.zw = tmpvar_81.zw;
              tmpvar_54 = mat3(1.0, 1.0, 1.0, 0.0, -0.08228, 0.9407, 0.7373, -0.28568, 0.0);
              tmpvar_55 = tmpvar_82;
            } else {
              highp int channel_depth_83;
              channel_depth_83 = 8;
              if ((8 < tmpvar_52)) {
                channel_depth_83 = 16;
              };
              float tmpvar_84;
              tmpvar_84 = (float((
                (1 << tmpvar_52)
               - 1)) / float((
                (1 << channel_depth_83)
               - 1)));
              vec4 tmpvar_85;
              tmpvar_85.xy = vec2(0.0, 0.0);
              tmpvar_85.z = tmpvar_84;
              tmpvar_85.w = tmpvar_84;
              tmpvar_54 = mat3(0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0);
              tmpvar_55 = tmpvar_85;
            };
          };
        };
      };
    };
  };
  vec2 tmpvar_86;
  tmpvar_86 = (1.0/((tmpvar_55.zw - tmpvar_55.xy)));
  mat3 tmpvar_87;
  tmpvar_87[uint(0)].x = tmpvar_86.x;
  tmpvar_87[uint(0)].y = 0.0;
  tmpvar_87[uint(0)].z = 0.0;
  tmpvar_87[1u].x = 0.0;
  tmpvar_87[1u].y = tmpvar_86.y;
  tmpvar_87[1u].z = 0.0;
  tmpvar_87[2u].x = 0.0;
  tmpvar_87[2u].y = 0.0;
  tmpvar_87[2u].z = tmpvar_86.y;
  vYcbcrBias = tmpvar_55.xyy;
  vRgbFromDebiasedYcbcr = (tmpvar_54 * tmpvar_87);
  vFormat = tmpvar_51;
  if (((tmpvar_51 == 1) || (tmpvar_51 == 99))) {
    ivec2 tmpvar_88;
    tmpvar_88.x = int((uint(tmpvar_13.x) % 1024u));
    tmpvar_88.y = int((uint(tmpvar_13.x) / 1024u));
    vec4 tmpvar_89;
    tmpvar_89 = texelFetch (sGpuCache, tmpvar_88, 0);
    ivec2 tmpvar_90;
    tmpvar_90.x = int((uint(tmpvar_13.y) % 1024u));
    tmpvar_90.y = int((uint(tmpvar_13.y) / 1024u));
    vec4 tmpvar_91;
    tmpvar_91 = texelFetch (sGpuCache, tmpvar_90, 0);
    ivec2 tmpvar_92;
    tmpvar_92.x = int((uint(tmpvar_13.z) % 1024u));
    tmpvar_92.y = int((uint(tmpvar_13.z) / 1024u));
    vec4 tmpvar_93;
    tmpvar_93 = texelFetch (sGpuCache, tmpvar_92, 0);
    vec2 tmpvar_94;
    tmpvar_94 = vec2(textureSize (sColor0, 0));
    vec4 tmpvar_95;
    tmpvar_95.xy = (tmpvar_89.xy + vec2(0.5, 0.5));
    tmpvar_95.zw = (tmpvar_89.zw - vec2(0.5, 0.5));
    vUv_Y = (mix (tmpvar_89.xy, tmpvar_89.zw, f_48) / tmpvar_94);
    vUvBounds_Y = (tmpvar_95 / tmpvar_94.xyxy);
    vec2 tmpvar_96;
    tmpvar_96 = vec2(textureSize (sColor1, 0));
    vec4 tmpvar_97;
    tmpvar_97.xy = (tmpvar_91.xy + vec2(0.5, 0.5));
    tmpvar_97.zw = (tmpvar_91.zw - vec2(0.5, 0.5));
    vUv_U = (mix (tmpvar_91.xy, tmpvar_91.zw, f_48) / tmpvar_96);
    vUvBounds_U = (tmpvar_97 / tmpvar_96.xyxy);
    vec2 tmpvar_98;
    tmpvar_98 = vec2(textureSize (sColor2, 0));
    vec4 tmpvar_99;
    tmpvar_99.xy = (tmpvar_93.xy + vec2(0.5, 0.5));
    tmpvar_99.zw = (tmpvar_93.zw - vec2(0.5, 0.5));
    vUv_V = (mix (tmpvar_93.xy, tmpvar_93.zw, f_48) / tmpvar_98);
    vUvBounds_V = (tmpvar_99 / tmpvar_98.xyxy);
  } else {
    if ((tmpvar_51 == 0)) {
      ivec2 tmpvar_100;
      tmpvar_100.x = int((uint(tmpvar_13.x) % 1024u));
      tmpvar_100.y = int((uint(tmpvar_13.x) / 1024u));
      vec4 tmpvar_101;
      tmpvar_101 = texelFetch (sGpuCache, tmpvar_100, 0);
      ivec2 tmpvar_102;
      tmpvar_102.x = int((uint(tmpvar_13.y) % 1024u));
      tmpvar_102.y = int((uint(tmpvar_13.y) / 1024u));
      vec4 tmpvar_103;
      tmpvar_103 = texelFetch (sGpuCache, tmpvar_102, 0);
      vec2 tmpvar_104;
      tmpvar_104 = vec2(textureSize (sColor0, 0));
      vec4 tmpvar_105;
      tmpvar_105.xy = (tmpvar_101.xy + vec2(0.5, 0.5));
      tmpvar_105.zw = (tmpvar_101.zw - vec2(0.5, 0.5));
      vUv_Y = (mix (tmpvar_101.xy, tmpvar_101.zw, f_48) / tmpvar_104);
      vUvBounds_Y = (tmpvar_105 / tmpvar_104.xyxy);
      vec2 tmpvar_106;
      tmpvar_106 = vec2(textureSize (sColor1, 0));
      vec4 tmpvar_107;
      tmpvar_107.xy = (tmpvar_103.xy + vec2(0.5, 0.5));
      tmpvar_107.zw = (tmpvar_103.zw - vec2(0.5, 0.5));
      vUv_U = (mix (tmpvar_103.xy, tmpvar_103.zw, f_48) / tmpvar_106);
      vUvBounds_U = (tmpvar_107 / tmpvar_106.xyxy);
    } else {
      if ((tmpvar_51 == 2)) {
        ivec2 tmpvar_108;
        tmpvar_108.x = int((uint(tmpvar_13.x) % 1024u));
        tmpvar_108.y = int((uint(tmpvar_13.x) / 1024u));
        vec4 tmpvar_109;
        tmpvar_109 = texelFetch (sGpuCache, tmpvar_108, 0);
        vec2 tmpvar_110;
        tmpvar_110 = vec2(textureSize (sColor0, 0));
        vec4 tmpvar_111;
        tmpvar_111.xy = (tmpvar_109.xy + vec2(0.5, 0.5));
        tmpvar_111.zw = (tmpvar_109.zw - vec2(0.5, 0.5));
        vUv_Y = (mix (tmpvar_109.xy, tmpvar_109.zw, f_48) / tmpvar_110);
        vUvBounds_Y = (tmpvar_111 / tmpvar_110.xyxy);
      };
    };
  };
  v_local_pos = vi_local_pos_27;
}

